/*
 * This file is part of libsh4lt.
 *
 * libsh4lt is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General
 * Public License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef SH4LT_BOOL_LOG_H_
#define SH4LT_BOOL_LOG_H_

#include <string>

namespace sh4lt {
class BoolLog {
 public:
  BoolLog();
  BoolLog(bool is_valid);
  BoolLog(bool is_valid, std::string msg);
  operator bool() const;
  [[nodiscard]] auto msg() const -> std::string;

 private:
  bool is_valid_;
  std::string msg_;
};

}  // namespace sh4lt

#endif
