<!-- SPDX-License-Identifier: CC-BY-4.0 -->
<!-- Copyright Contributors to the OpenColorIO Project. -->

December 15, 2020

Host: Michael Dolan

Attendees:
  * [X] Mark Boorer (_TSC_) - Industrial Light & Magic
  * [X] Michael Dolan (_TSC Chair_) - Epic Games
  * [X] Carol Payne (_TSC_) - Netflix
  * [X] Doug Walker (_TSC Chief Architect_) - Autodesk
  * [X] Matthias Scharfenberg - Industrial Light & Magic
  * [X] Dennis Adams - Sony
  * [X] Thomas Mansencal - Weta Digital
  * [X] Christophe Brejon
  * [X] Zach Lewis - Method
  * [X] J Schulte - Industrial Light & Magic
  * [X] Scott Dyer - A.M.P.A.S.

# **OCIO Configs Working Group Meeting Notes**

* Continue spreadsheet discussion. Update from ACES:
    - Michael: Would like to shift this meeting one week forward in the new 
      year as it currently conflicts with a SMPTE meeting Scott attends. 
      Any objections?
    - No objections.
    - Michael: Scott shared his opinion via email that he thinks we could omit 
      ACESproxy and DCDM ODTs from the reference config. Can discuss with him 
      further in new year to make a formal decision.
    - Carol: No problem with that.
    - Doug: No objection. Think it's better to track what Academy is doing and 
      remove if it matches what they are doing. Some we may need to preempt for 
      practical reasons.
    - Zach: Is there a way to deprecate?
    - Michael: Deprecation is supported with inactive color spaces and the 
      upcoming alias feature (for deprecated names).
    - Mark: Since they are not currently there, would be better to not 
      implement.
    - Doug: Agree.
    - Mark: Depends what mean by deprecating. Doesn't work any more? Think we 
      would follow typical OCIO patch notes saying this doesn't exist anymore 
      and add ociocheck warnings.
    - Thomas: Deprecate is not removal. Warn in prior release. We're talking 
      about removal without warning.
    - Mark: If we were to deprecate a BuiltinTransform, would likely be over 
      multiple versions.

* Conclude discussion about whether to generate config from graph code 
  currently in repo, or to have a separate library which explicitly builds 
  config, using the graph lib to validate:
    - Michael: Discussing whether we should stay on course with current config 
      generation code, or use that for validation and have separate more 
      concise script just for config generation.
    - Mark: Nothing wrong with usefulness of this code, but as someone involved 
      with setting up configs, found it hard to approach current setup and to 
      make changes. It does so many other things than generate the config. Can 
      get stats, build graph, etc. I previously showed simpler version I 
      created that just builds config. Discussed mapping needed between CTL and 
      what we wanted color spaces to be called, and the intermediate color space 
      that doesn't exist. Sounds like there are more exceptions to the rule 
      than just following CTL. Think we would be better hand rolling config 
      code.
    - Carol: With the display spaces, we're getting to place with mapping where 
      we have to do it ourselves anyway. Once fixed on ACES side, would manual 
      intervention lessen?
    - Mark: Two PRs for URNs that mismatch. Each of our code has chunk to 
      handle the misnaming. Don't think those are dominant parts of the problem. 
      Different problem with needing to tease apart ODTs.
    - Zach: Not going to avoid mapping one way or other.
    - Mark: Nice aspects to tracking CTL. Comment strings make good docstrings, 
      but one of the big UX decisions is in regard to how those are formatted 
      since some are long and can't be displayed easily in apps. Should we lead 
      the way and lessen those? Feel our intent would be clearer expressed, 
      even with risk of drifting. Should present ACES workflow in OCIO way.
    - Michael: Think we could use the current lib to support generating 
      config in smaller script. Find a middle ground between both approaches.
    - Thomas: That's what it currently is essentially. CTL discovery code 
      builds list of transforms, can be used directly, which is similar to what 
      Mark did. Graph built on top of that, used to fit config generation code. 
      Config code is agnostic. Just gets input from graph. Nothing says graph 
      needs to be used. I think there is value in getting that info from CTL. 
      Can highlight issues which wouldn't be discovered otherwise. What is 
      being used to maintain current config. As current maintainer, it 
      is useful. When switched from 1.0 to 1.1, was easy to see what was 
      missing. Is complex, but can also look at complexity and reduce where 
      needed and make it easier. Don't have strong opinion. Can go in another 
      way. Just need to know to not waste time maintaining code that won't be 
      used.
    - Carol: Think there's an overarching thing with OCIO way of doing stuff. 
      A partnership aspect of this between OCIO and ACES that should be 
      improved. Mark's points are valid. Hard to translate between projects. 
      Think if this is going to be ACES reference config, have responsibility 
      to link to CTL, to keep us accountable.
    - Thomas: Agree. When started to work on automated generation, idea was to 
      have something Scott and Alex could run automatically. Could be useful 
      for them to check stuff on their end.
    - Carol: Thinking too with comments, this is ACES reference config so can 
      be more verbose. Can make descriptions for a more well rounded studio 
      config.
    - Thomas: To that, could be something in CTL itself, front facing (one 
      liner) user comments. Maybe some roads to be made here, and CTL can help 
      us do that work.
    - Mark: I'll push my simplified version in a PR so you can see what I was 
      looking for. At this point it's doing same thing. Just less code. There's 
      a disconnect between CTL and OCIO. We aren't using the CTL in OCIO, but 
      re-implementing transforms ourselves. Get the desire to strengthen link 
      between projects, but feel the relationship goes opposite direction too, 
      with many using ACES through OCIO.
    - Doug: Because of Thomas experience maintaining existing configs, has 
      learned how challenging it is to maintain. At each update may not be 
      obvious what has changed. What has been produced is complex, but it does 
      try to solve this problem with how to keep in sync with something with 
      many moving parts. Certainly not a unique problem for OCIO. All ACES 
      product partners face same problem. Every time there's a new ACES release 
      takes days to go through and make sure the transforms are implemented 
      correctly. Everyone is re-implementing it vs. using CTL directly. It 
      would be nice to give feedback to Academy to make it easier to do what 
      we're trying to do since we're not the only ones.
    - Michael: Since we will also need to use this to generate the studio 
      config, which will include much more than just ACES, more argument to 
      leverage this code as library supporting config generation. Then both 
      scripts can use it as needed and for validation.
    - Thomas: Agree to find middle ground. We can raise exception when we don't 
      have things mapped. Want library because I'm planning to use it, and hope 
      others too. Can become tools to not only generate ACES config, but other 
      configs too.
    - Mark: For ACES config, all the guts are builtin transforms being chained 
      together. Just need to write YAML file in correct order.
    - Carol: If we are thinking future extensible, good to start out well.
    - Thomas: Needs to be something we can test. Advantage on a show is if 
      something is broken you change it, but here we're talking about 
      something being shipped in software. It needs to work. When I did 
      transition between 1.0 and 1.1, took ages because a mistake will effect 
      everybody. When Nuke ships with this, it's a big difference. Internal and 
      public software different jobs.
    - Mark: Discussions around entry points for building ACES config vs config 
      library different. Would have had other discussions around creating the 
      lib. That's my concern. Not putting down current work. There is massive 
      ramifications for doing it wrong, so that's important and I appreciate 
      what's there.
    - Thomas: Understand. Maybe I can do a write up on current state and idea.
    - Zach: Raise interesting question. Do we want to have mechanism for 
      testing against ctlrender, etc?
    - Thomas: Yes, planning to do that.
    - Michael: Thomas set up GHA CI so we can test against images, etc.
    - Thomas: Not implemented yet, but where I want to go. Don't think we can 
      do less than current config. Need to confirm implementation is matching.
    - Doug: Think this will be very helpful to ACES project. Already flagged 
      issues with Transform IDs. As we get it, we'll likely find differences 
      with CTL and reference images.

* Talk about dev workflow, it is a bit painful atm: 
    - https://github.com/AcademySoftwareFoundation/OpenColorIO-Config-ACES/pull/9#issuecomment-735352837
    - Thomas: Annoyance currently is we're not using gitflow. Currently one 
      main branch. When merging and squashing, get diverging history 
      because of other in-progress work. If you have two feature branches, if 
      you squash one, need to rebase.
    - Michael: Same setup we have for core OCIO. Messy if people have many 
      commits, which is why we enforce squashing.
    - Thomas: Can ask people to be cleaner. We tend to rebase on develop before 
      merging. Can ask people to squash on their own. Makes it easier to revert 
      changes.
    - Mark: Think we expect most dev work to happen on forks, and for changes 
      to come in as PRs, vs. feature branches pushed to repo.
    - Thomas: Yeah, that's what is happening. Look at PR #9. Can talk on Slack.
    - Michael: Gitflow can get complex. OpenEXR is doing something in the 
      middle, with a develop and main branch. We could do something like that.
    - Thomas: Mostly talking about main/develop. Not full gitflow. Two branches. 
      Suggested same to Academy.

* Talk about what we can do with the incorrectly named ACEStransformID as I 
  have the feeling we won’t get a resolution from the AMPAS soon:
    - Scott: Working to get issues resolved with our repo. Fixes in dev branch 
      not integrated yet.

* Fully fledged display spaces, it was agreed here on Slack, but maybe we can 
  make it official:
    - Thomas: Doug agreed in slides that the way the transforms were broken up 
      could be simplified to have single transform instead of group transform.
    - Doug: Agree. Adding BuiltinTransforms in current PR.

* Items for next TSC meeting agenda:
    - Further discuss spreadsheet questions with Scott.
