// Copyright Joyent, Inc. and other Node contributors.
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to permit
// persons to whom the Software is furnished to do so, subject to the
// following conditions:
//
// The above copyright notice and this permission notice shall be included
// in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
// USE OR OTHER DEALINGS IN THE SOFTWARE.

'use strict';
const common = require('../common');
const fixtures = require('../common/fixtures');
const assert = require('assert');
const execFile = require('child_process').execFile;
const depmod = fixtures.path('deprecated.js');
const node = process.execPath;

const depUserlandFunction =
  fixtures.path('deprecated-userland-function.js');

const depUserlandClass =
  fixtures.path('deprecated-userland-class.js');

const depUserlandSubClass =
  fixtures.path('deprecated-userland-subclass.js');

const normal = [depmod];
const noDep = ['--no-deprecation', depmod];
const traceDep = ['--trace-deprecation', depmod];

execFile(node, normal, common.mustSucceed((stdout, stderr) => {
  console.error('normal: show deprecation warning');
  assert.strictEqual(stdout, '');
  assert.match(stderr, /this function is deprecated/);
  console.log('normal ok');
}));

execFile(node, noDep, common.mustSucceed((stdout, stderr) => {
  console.error('--no-deprecation: silence deprecations');
  assert.strictEqual(stdout, '');
  assert.strictEqual(stderr.trim(), 'This is deprecated');
  console.log('silent ok');
}));

execFile(node, traceDep, common.mustSucceed((stdout, stderr) => {
  console.error('--trace-deprecation: show stack');
  assert.strictEqual(stdout, '');
  const stack = stderr.trim().split('\n');
  // Just check the top and bottom.
  assert.match(stack[1], /this function is deprecated/);
  assert.match(stack[0], /This is deprecated/);
  console.log('trace ok');
}));

execFile(node, [depUserlandFunction], common.mustSucceed((stdout, stderr) => {
  console.error('normal: testing deprecated userland function');
  assert.strictEqual(stdout, '');
  assert.match(stderr, /deprecatedFunction is deprecated/);
  console.error('normal: ok');
}));

execFile(node, [depUserlandClass], common.mustSucceed((stdout, stderr) => {
  assert.strictEqual(stdout, '');
  assert.match(stderr, /deprecatedClass is deprecated/);
}));

execFile(node, [depUserlandSubClass], common.mustSucceed((stdout, stderr) => {
  assert.strictEqual(stdout, '');
  assert.match(stderr, /deprecatedClass is deprecated/);
}));
