
# NOTE: Assertions have been autogenerated by utils/update_mca_test_checks.py
# RUN: llvm-mca -mtriple=riscv64 -mcpu=sifive-p470 -iterations=1 < %s | FileCheck %s

vsetvli zero, zero, e32, m1, tu, mu
vrgather.vv  v5, v7, v8
vcompress.vm v4, v9, v0

vsetvli zero, zero, e32, m2, tu, mu
vrgather.vv  v5, v7, v8
vcompress.vm v4, v9, v0

vsetvli zero, zero, e32, m4, tu, mu
vrgather.vv  v5, v7, v8
vcompress.vm v4, v9, v0

vsetvli zero, zero, e32, m8, tu, mu
vrgather.vv  v5, v7, v8
vcompress.vm v4, v9, v0

# CHECK:      Iterations:        1
# CHECK-NEXT: Instructions:      12
# CHECK-NEXT: Total Cycles:      92
# CHECK-NEXT: Total uOps:        12

# CHECK:      Dispatch Width:    3
# CHECK-NEXT: uOps Per Cycle:    0.13
# CHECK-NEXT: IPC:               0.13
# CHECK-NEXT: Block RThroughput: 106.0

# CHECK:      Instruction Info:
# CHECK-NEXT: [1]: #uOps
# CHECK-NEXT: [2]: Latency
# CHECK-NEXT: [3]: RThroughput
# CHECK-NEXT: [4]: MayLoad
# CHECK-NEXT: [5]: MayStore
# CHECK-NEXT: [6]: HasSideEffects (U)

# CHECK:      [1]    [2]    [3]    [4]    [5]    [6]    Instructions:
# CHECK-NEXT:  1      1     1.00                  U     vsetvli zero, zero, e32, m1, tu, mu
# CHECK-NEXT:  1      3     1.00                        vrgather.vv v5, v7, v8
# CHECK-NEXT:  1      3     1.00                        vcompress.vm  v4, v9, v0
# CHECK-NEXT:  1      1     1.00                  U     vsetvli zero, zero, e32, m2, tu, mu
# CHECK-NEXT:  1      6     12.00                       vrgather.vv v5, v7, v8
# CHECK-NEXT:  1      6     12.00                       vcompress.vm  v4, v9, v0
# CHECK-NEXT:  1      1     1.00                  U     vsetvli zero, zero, e32, m4, tu, mu
# CHECK-NEXT:  1      6     16.00                       vrgather.vv v5, v7, v8
# CHECK-NEXT:  1      6     16.00                       vcompress.vm  v4, v9, v0
# CHECK-NEXT:  1      1     1.00                  U     vsetvli zero, zero, e32, m8, tu, mu
# CHECK-NEXT:  1      6     24.00                       vrgather.vv v5, v7, v8
# CHECK-NEXT:  1      6     24.00                       vcompress.vm  v4, v9, v0

# CHECK:      Resources:
# CHECK-NEXT: [0]   - SiFiveP400Div
# CHECK-NEXT: [1]   - SiFiveP400FEXQ0
# CHECK-NEXT: [2]   - SiFiveP400FloatDiv
# CHECK-NEXT: [3]   - SiFiveP400IEXQ0
# CHECK-NEXT: [4]   - SiFiveP400IEXQ1
# CHECK-NEXT: [5]   - SiFiveP400IEXQ2
# CHECK-NEXT: [6]   - SiFiveP400Load
# CHECK-NEXT: [7]   - SiFiveP400Store
# CHECK-NEXT: [8]   - SiFiveP400VDiv
# CHECK-NEXT: [9]   - SiFiveP400VEXQ0
# CHECK-NEXT: [10]  - SiFiveP400VFloatDiv
# CHECK-NEXT: [11]  - SiFiveP400VLD
# CHECK-NEXT: [12]  - SiFiveP400VST

# CHECK:      Resource pressure per iteration:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]    [9]    [10]   [11]   [12]
# CHECK-NEXT:  -      -      -      -     4.00    -      -      -      -     106.00  -      -      -

# CHECK:      Resource pressure by instruction:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]    [9]    [10]   [11]   [12]   Instructions:
# CHECK-NEXT:  -      -      -      -     1.00    -      -      -      -      -      -      -      -     vsetvli  zero, zero, e32, m1, tu, mu
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -      -     vrgather.vv  v5, v7, v8
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -      -     vcompress.vm v4, v9, v0
# CHECK-NEXT:  -      -      -      -     1.00    -      -      -      -      -      -      -      -     vsetvli  zero, zero, e32, m2, tu, mu
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     12.00   -      -      -     vrgather.vv  v5, v7, v8
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     12.00   -      -      -     vcompress.vm v4, v9, v0
# CHECK-NEXT:  -      -      -      -     1.00    -      -      -      -      -      -      -      -     vsetvli  zero, zero, e32, m4, tu, mu
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     16.00   -      -      -     vrgather.vv  v5, v7, v8
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     16.00   -      -      -     vcompress.vm v4, v9, v0
# CHECK-NEXT:  -      -      -      -     1.00    -      -      -      -      -      -      -      -     vsetvli  zero, zero, e32, m8, tu, mu
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     24.00   -      -      -     vrgather.vv  v5, v7, v8
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     24.00   -      -      -     vcompress.vm v4, v9, v0

