; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 2
; RUN: llc -mtriple=aarch64 %s -o - | FileCheck %s
define i32 @test_cchi(i64 %a) {
; CHECK-LABEL: test_cchi:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    //APP
; CHECK-NEXT:    subs x0, x0, #3
; CHECK-NEXT:    //NO_APP
; CHECK-NEXT:    cset w0, hi
; CHECK-NEXT:    ret
entry:
  %0 = tail call { i64, i32 } asm "subs $0, $0, #3", "=r,={@cchi},0,~{dirflag},~{fpsr},~{flags}"(i64 %a)
  %asmresult1 = extractvalue { i64, i32 } %0, 1
  %1 = icmp ult i32 %asmresult1, 2
  tail call void @llvm.assume(i1 %1)
  ret i32 %asmresult1
}

define i32 @test_cccs(i64 %a) {
; CHECK-LABEL: test_cccs:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    //APP
; CHECK-NEXT:    subs x0, x0, #3
; CHECK-NEXT:    //NO_APP
; CHECK-NEXT:    cset w0, hs
; CHECK-NEXT:    ret
entry:
  %0 = tail call { i64, i32 } asm "subs $0, $0, #3", "=r,={@cccs},0,~{dirflag},~{fpsr},~{flags}"(i64 %a)
  %asmresult1 = extractvalue { i64, i32 } %0, 1
  %1 = icmp ult i32 %asmresult1, 2
  tail call void @llvm.assume(i1 %1)
  ret i32 %asmresult1
}

define i32 @test_cclo(i64 %a) {
; CHECK-LABEL: test_cclo:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    //APP
; CHECK-NEXT:    subs x0, x0, #3
; CHECK-NEXT:    //NO_APP
; CHECK-NEXT:    cset w0, lo
; CHECK-NEXT:    ret
entry:
  %0 = tail call { i64, i32 } asm "subs $0, $0, #3", "=r,={@cclo},0,~{dirflag},~{fpsr},~{flags}"(i64 %a)
  %asmresult1 = extractvalue { i64, i32 } %0, 1
  %1 = icmp ult i32 %asmresult1, 2
  tail call void @llvm.assume(i1 %1)
  ret i32 %asmresult1
}

define i32 @test_ccls(i64 %a) {
; CHECK-LABEL: test_ccls:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    //APP
; CHECK-NEXT:    subs x0, x0, #3
; CHECK-NEXT:    //NO_APP
; CHECK-NEXT:    cset w0, ls
; CHECK-NEXT:    ret
entry:
  %0 = tail call { i64, i32 } asm "subs $0, $0, #3", "=r,={@ccls},0,~{dirflag},~{fpsr},~{flags}"(i64 %a)
  %asmresult1 = extractvalue { i64, i32 } %0, 1
  %1 = icmp ult i32 %asmresult1, 2
  tail call void @llvm.assume(i1 %1)
  ret i32 %asmresult1
}

define i32 @test_cccc(i64 %a) {
; CHECK-LABEL: test_cccc:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    //APP
; CHECK-NEXT:    subs x0, x0, #3
; CHECK-NEXT:    //NO_APP
; CHECK-NEXT:    cset w0, lo
; CHECK-NEXT:    ret
entry:
  %0 = tail call { i64, i32 } asm "subs $0, $0, #3", "=r,={@cccc},0,~{dirflag},~{fpsr},~{flags}"(i64 %a)
  %asmresult1 = extractvalue { i64, i32 } %0, 1
  %1 = icmp ult i32 %asmresult1, 2
  tail call void @llvm.assume(i1 %1)
  ret i32 %asmresult1
}

define i32 @test_cceq(i64 %a) {
; CHECK-LABEL: test_cceq:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    //APP
; CHECK-NEXT:    subs x0, x0, #3
; CHECK-NEXT:    //NO_APP
; CHECK-NEXT:    cset w0, eq
; CHECK-NEXT:    ret
entry:
  %0 = tail call { i64, i32 } asm "subs $0, $0, #3", "=r,={@cceq},0,~{dirflag},~{fpsr},~{flags}"(i64 %a)
  %asmresult1 = extractvalue { i64, i32 } %0, 1
  %1 = icmp ult i32 %asmresult1, 2
  tail call void @llvm.assume(i1 %1)
  ret i32 %asmresult1
}

define i32 @test_ccgt(i64 %a) {
; CHECK-LABEL: test_ccgt:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    //APP
; CHECK-NEXT:    subs x0, x0, #3
; CHECK-NEXT:    //NO_APP
; CHECK-NEXT:    cset w0, gt
; CHECK-NEXT:    ret
entry:
  %0 = tail call { i64, i32 } asm "subs $0, $0, #3", "=r,={@ccgt},0,~{dirflag},~{fpsr},~{flags}"(i64 %a)
  %asmresult1 = extractvalue { i64, i32 } %0, 1
  %1 = icmp ult i32 %asmresult1, 2
  tail call void @llvm.assume(i1 %1)
  ret i32 %asmresult1
}

define i32 @test_ccge(i64 %a) {
; CHECK-LABEL: test_ccge:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    //APP
; CHECK-NEXT:    subs x0, x0, #3
; CHECK-NEXT:    //NO_APP
; CHECK-NEXT:    cset w0, ge
; CHECK-NEXT:    ret
entry:
  %0 = tail call { i64, i32 } asm "subs $0, $0, #3", "=r,={@ccge},0,~{dirflag},~{fpsr},~{flags}"(i64 %a)
  %asmresult1 = extractvalue { i64, i32 } %0, 1
  %1 = icmp ult i32 %asmresult1, 2
  tail call void @llvm.assume(i1 %1)
  ret i32 %asmresult1
}

define i32 @test_cclt(i64 %a) {
; CHECK-LABEL: test_cclt:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    //APP
; CHECK-NEXT:    subs x0, x0, #3
; CHECK-NEXT:    //NO_APP
; CHECK-NEXT:    cset w0, lt
; CHECK-NEXT:    ret
entry:
  %0 = tail call { i64, i32 } asm "subs $0, $0, #3", "=r,={@cclt},0,~{dirflag},~{fpsr},~{flags}"(i64 %a)
  %asmresult1 = extractvalue { i64, i32 } %0, 1
  %1 = icmp ult i32 %asmresult1, 2
  tail call void @llvm.assume(i1 %1)
  ret i32 %asmresult1
}

define i32 @test_ccle(i64 %a) {
; CHECK-LABEL: test_ccle:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    //APP
; CHECK-NEXT:    subs x0, x0, #3
; CHECK-NEXT:    //NO_APP
; CHECK-NEXT:    cset w0, le
; CHECK-NEXT:    ret
entry:
  %0 = tail call { i64, i32 } asm "subs $0, $0, #3", "=r,={@ccle},0,~{dirflag},~{fpsr},~{flags}"(i64 %a)
  %asmresult1 = extractvalue { i64, i32 } %0, 1
  %1 = icmp ult i32 %asmresult1, 2
  tail call void @llvm.assume(i1 %1)
  ret i32 %asmresult1
}

define i32 @test_cchs(i64 %a) {
; CHECK-LABEL: test_cchs:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    //APP
; CHECK-NEXT:    subs x0, x0, #3
; CHECK-NEXT:    //NO_APP
; CHECK-NEXT:    cset w0, hs
; CHECK-NEXT:    ret
entry:
  %0 = tail call { i64, i32 } asm "subs $0, $0, #3", "=r,={@cchs},0,~{dirflag},~{fpsr},~{flags}"(i64 %a)
  %asmresult1 = extractvalue { i64, i32 } %0, 1
  %1 = icmp ult i32 %asmresult1, 2
  tail call void @llvm.assume(i1 %1)
  ret i32 %asmresult1
}

define i32 @test_ccne(i64 %a) {
; CHECK-LABEL: test_ccne:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    //APP
; CHECK-NEXT:    subs x0, x0, #3
; CHECK-NEXT:    //NO_APP
; CHECK-NEXT:    cset w0, ne
; CHECK-NEXT:    ret
entry:
  %0 = tail call { i64, i32 } asm "subs $0, $0, #3", "=r,={@ccne},0,~{dirflag},~{fpsr},~{flags}"(i64 %a)
  %asmresult1 = extractvalue { i64, i32 } %0, 1
  %1 = icmp ult i32 %asmresult1, 2
  tail call void @llvm.assume(i1 %1)
  ret i32 %asmresult1
}

define i32 @test_ccvc(i64 %a) {
; CHECK-LABEL: test_ccvc:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    //APP
; CHECK-NEXT:    subs x0, x0, #3
; CHECK-NEXT:    //NO_APP
; CHECK-NEXT:    cset w0, vc
; CHECK-NEXT:    ret
entry:
  %0 = tail call { i64, i32 } asm "subs $0, $0, #3", "=r,={@ccvc},0,~{dirflag},~{fpsr},~{flags}"(i64 %a)
  %asmresult1 = extractvalue { i64, i32 } %0, 1
  %1 = icmp ult i32 %asmresult1, 2
  tail call void @llvm.assume(i1 %1)
  ret i32 %asmresult1
}

define i32 @test_ccpl(i64 %a) {
; CHECK-LABEL: test_ccpl:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    //APP
; CHECK-NEXT:    subs x0, x0, #3
; CHECK-NEXT:    //NO_APP
; CHECK-NEXT:    cset w0, pl
; CHECK-NEXT:    ret
entry:
  %0 = tail call { i64, i32 } asm "subs $0, $0, #3", "=r,={@ccpl},0,~{dirflag},~{fpsr},~{flags}"(i64 %a)
  %asmresult1 = extractvalue { i64, i32 } %0, 1
  %1 = icmp ult i32 %asmresult1, 2
  tail call void @llvm.assume(i1 %1)
  ret i32 %asmresult1
}

define i32 @test_ccvs(i64 %a) {
; CHECK-LABEL: test_ccvs:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    //APP
; CHECK-NEXT:    subs x0, x0, #3
; CHECK-NEXT:    //NO_APP
; CHECK-NEXT:    cset w0, vs
; CHECK-NEXT:    ret
entry:
  %0 = tail call { i64, i32 } asm "subs $0, $0, #3", "=r,={@ccvs},0,~{dirflag},~{fpsr},~{flags}"(i64 %a)
  %asmresult1 = extractvalue { i64, i32 } %0, 1
  %1 = icmp ult i32 %asmresult1, 2
  tail call void @llvm.assume(i1 %1)
  ret i32 %asmresult1
}

define i32 @test_ccmi(i64 %a) {
; CHECK-LABEL: test_ccmi:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    //APP
; CHECK-NEXT:    subs x0, x0, #3
; CHECK-NEXT:    //NO_APP
; CHECK-NEXT:    cset w0, mi
; CHECK-NEXT:    ret
entry:
  %0 = tail call { i64, i32 } asm "subs $0, $0, #3", "=r,={@ccmi},0,~{dirflag},~{fpsr},~{flags}"(i64 %a)
  %asmresult1 = extractvalue { i64, i32 } %0, 1
  %1 = icmp ult i32 %asmresult1, 2
  tail call void @llvm.assume(i1 %1)
  ret i32 %asmresult1
}

declare void @llvm.assume(i1)
