; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -passes=correlated-propagation -S %s | FileCheck %s

; Check that shift is not removed by CVP because of incorrect range returned by LVI::getConstantRangeAtUse.
; https://github.com/llvm/llvm-project/issues/60629

define i32 @test(i32 %arg) {
; CHECK-LABEL: @test(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[IV:%.*]] = phi i32 [ 127, [[ENTRY:%.*]] ], [ [[IV_NEXT:%.*]], [[DO_SHIFT:%.*]] ]
; CHECK-NEXT:    [[SHIFTED_IV:%.*]] = phi i32 [ 0, [[ENTRY]] ], [ [[SHIFT:%.*]], [[DO_SHIFT]] ]
; CHECK-NEXT:    [[IV_NEXT]] = add i32 [[IV]], 1
; CHECK-NEXT:    [[LOOP_COND:%.*]] = icmp sgt i32 [[IV]], 127
; CHECK-NEXT:    br i1 [[LOOP_COND]], label [[EXIT:%.*]], label [[DO_SHIFT]]
; CHECK:       do.shift:
; CHECK-NEXT:    [[SHIFT]] = ashr i32 [[IV]], [[ARG:%.*]]
; CHECK-NEXT:    br label [[LOOP]]
; CHECK:       bb1:
; CHECK-NEXT:    br label [[EXIT]]
; CHECK:       exit:
; CHECK-NEXT:    [[RETVAL:%.*]] = phi i32 [ 0, [[BB1:%.*]] ], [ [[SHIFTED_IV]], [[LOOP]] ]
; CHECK-NEXT:    ret i32 [[RETVAL]]
;
entry:
  br label %loop

loop:                                              ; preds = %do.shift, %entry
  %iv = phi i32 [ 127, %entry ], [ %iv.next, %do.shift ]
  %shifted.iv = phi i32 [ 0, %entry ], [ %shift, %do.shift ]
  %iv.next = add i32 %iv, 1
  %loop_cond = icmp sgt i32 %iv, 127
  br i1 %loop_cond, label %exit, label %do.shift

do.shift:                                          ; preds = %loop
  %shift = ashr i32 %iv, %arg
  br label %loop

bb1:                                               ; No predecessors!
  br label %exit

exit:                                              ; preds = %loop, %bb1
  %retval = phi i32 [ 0, %bb1 ], [ %shifted.iv, %loop ]
  ret i32 %retval
}
