; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 4
; RUN: llc -mtriple=riscv32 -mattr=+v -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK
; RUN: llc -mtriple=riscv64 -mattr=+v -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK

define <vscale x 8 x i64> @vwadd_wv_mask_v8i32(<vscale x 8 x i32> %x, <vscale x 8 x i64> %y) {
; CHECK-LABEL: vwadd_wv_mask_v8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmv4r.v v24, v8
; CHECK-NEXT:    li a0, 42
; CHECK-NEXT:    vmslt.vx v0, v8, a0
; CHECK-NEXT:    vmv8r.v v8, v16
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, tu, mu
; CHECK-NEXT:    vwadd.wv v8, v8, v24, v0.t
; CHECK-NEXT:    ret
    %mask = icmp slt <vscale x 8 x i32> %x, splat (i32 42)
    %a = select <vscale x 8 x i1> %mask, <vscale x 8 x i32> %x, <vscale x 8 x i32> zeroinitializer
    %sa = sext <vscale x 8 x i32> %a to <vscale x 8 x i64>
    %ret = add <vscale x 8 x i64> %sa, %y
    ret <vscale x 8 x i64> %ret
}

define <vscale x 8 x i64> @vwaddu_wv_mask_v8i32(<vscale x 8 x i32> %x, <vscale x 8 x i64> %y) {
; CHECK-LABEL: vwaddu_wv_mask_v8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmv4r.v v24, v8
; CHECK-NEXT:    li a0, 42
; CHECK-NEXT:    vmslt.vx v0, v8, a0
; CHECK-NEXT:    vmv8r.v v8, v16
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, tu, mu
; CHECK-NEXT:    vwaddu.wv v8, v8, v24, v0.t
; CHECK-NEXT:    ret
    %mask = icmp slt <vscale x 8 x i32> %x, splat (i32 42)
    %a = select <vscale x 8 x i1> %mask, <vscale x 8 x i32> %x, <vscale x 8 x i32> zeroinitializer
    %sa = zext <vscale x 8 x i32> %a to <vscale x 8 x i64>
    %ret = add <vscale x 8 x i64> %sa, %y
    ret <vscale x 8 x i64> %ret
}

define <vscale x 8 x i64> @vwaddu_vv_mask_v8i32(<vscale x 8 x i32> %x, <vscale x 8 x i32> %y) {
; CHECK-LABEL: vwaddu_vv_mask_v8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmv4r.v v16, v12
; CHECK-NEXT:    li a0, 42
; CHECK-NEXT:    vmslt.vx v0, v8, a0
; CHECK-NEXT:    vmv.v.i v12, 0
; CHECK-NEXT:    vmerge.vvm v20, v12, v8, v0
; CHECK-NEXT:    vwaddu.vv v8, v20, v16
; CHECK-NEXT:    ret
    %mask = icmp slt <vscale x 8 x i32> %x, splat (i32 42)
    %a = select <vscale x 8 x i1> %mask, <vscale x 8 x i32> %x, <vscale x 8 x i32> zeroinitializer
    %sa = zext <vscale x 8 x i32> %a to <vscale x 8 x i64>
    %sy = zext <vscale x 8 x i32> %y to <vscale x 8 x i64>
    %ret = add <vscale x 8 x i64> %sa, %sy
    ret <vscale x 8 x i64> %ret
}

define <vscale x 8 x i64> @vwadd_wv_mask_v8i32_commutative(<vscale x 8 x i32> %x, <vscale x 8 x i64> %y) {
; CHECK-LABEL: vwadd_wv_mask_v8i32_commutative:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmv4r.v v24, v8
; CHECK-NEXT:    li a0, 42
; CHECK-NEXT:    vmslt.vx v0, v8, a0
; CHECK-NEXT:    vmv8r.v v8, v16
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, tu, mu
; CHECK-NEXT:    vwadd.wv v8, v8, v24, v0.t
; CHECK-NEXT:    ret
    %mask = icmp slt <vscale x 8 x i32> %x, splat (i32 42)
    %a = select <vscale x 8 x i1> %mask, <vscale x 8 x i32> %x, <vscale x 8 x i32> zeroinitializer
    %sa = sext <vscale x 8 x i32> %a to <vscale x 8 x i64>
    %ret = add <vscale x 8 x i64> %y, %sa
    ret <vscale x 8 x i64> %ret
}

define <vscale x 8 x i64> @vwadd_wv_mask_v8i32_nonzero(<vscale x 8 x i32> %x, <vscale x 8 x i64> %y) {
; CHECK-LABEL: vwadd_wv_mask_v8i32_nonzero:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a0, 42
; CHECK-NEXT:    vsetvli a1, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmslt.vx v0, v8, a0
; CHECK-NEXT:    vmv.v.i v12, 1
; CHECK-NEXT:    vmerge.vvm v24, v12, v8, v0
; CHECK-NEXT:    vwadd.wv v8, v16, v24
; CHECK-NEXT:    ret
    %mask = icmp slt <vscale x 8 x i32> %x, splat (i32 42)
    %a = select <vscale x 8 x i1> %mask, <vscale x 8 x i32> %x, <vscale x 8 x i32> splat (i32 1)
    %sa = sext <vscale x 8 x i32> %a to <vscale x 8 x i64>
    %ret = add <vscale x 8 x i64> %sa, %y
    ret <vscale x 8 x i64> %ret
}
