
with Ada.Containers.Vectors;
with Ada.Exceptions;
with Ada.Unchecked_Conversion;
with Ada.Unchecked_Deallocation;

with System;

with Liblktlang_Support.Bump_Ptr;    use Liblktlang_Support.Bump_Ptr;
with Liblktlang_Support.Diagnostics; use Liblktlang_Support.Diagnostics;
with Liblktlang_Support.Packrat;
with Liblktlang_Support.Slocs;       use Liblktlang_Support.Slocs;

pragma Warnings (Off, "referenced");
with Liblktlang_Support.Symbols; use Liblktlang_Support.Symbols;
pragma Warnings (On, "referenced");

with Liblktlang_Support.Text;        use Liblktlang_Support.Text;

with Liblktlang.Common;         use Liblktlang.Common;
with Liblktlang.Implementation; use Liblktlang.Implementation;
use Liblktlang.Implementation.Precomputed_Symbols;
with Liblktlang.Lexer_Implementation;
use Liblktlang.Lexer_Implementation;

pragma Warnings (Off, "referenced");
with Liblktlang.Private_Converters; use Liblktlang.Private_Converters;
pragma Warnings (On, "referenced");

with Liblktlang.Implementation.Extensions;



package body Liblktlang.Parsers_Impl is
   pragma Warnings (Off, "use clause");
   use all type Liblktlang_Support.Symbols.Symbol_Type;
   pragma Warnings (On, "use clause");

   --  Prepare packrat instantiations: one per enum type and onefor each kind
   --  of node (including lists). Likewise for bump ptr. allocators, except
   --  we need them only for non-abstract AST nodes.

   pragma Warnings (Off, "is not referenced");
      package Bare_Lkt_Node_Memos is new Liblktlang_Support.Packrat
        (Bare_Lkt_Node, Token_Index);

      package Bare_Argument_Memos is new Liblktlang_Support.Packrat
        (Bare_Argument, Token_Index);

         
         subtype Subtype_For_Argument is
            Root_Node_Record (Lkt_Argument);
         type Access_To_Subtype_For_Argument is access all Subtype_For_Argument;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Argument);
         package Bare_Argument_Alloc is new Alloc
           (Subtype_For_Argument, Access_To_Subtype_For_Argument);

         function Allocate_Argument
           (Pool : Bump_Ptr_Pool) return Bare_Argument;

         function Allocate_Argument
           (Pool : Bump_Ptr_Pool) return Bare_Argument
         is
            Result      : constant Access_To_Subtype_For_Argument := Bare_Argument_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Argument;
            return Bare_Argument (Result);
         end Allocate_Argument;

      package Bare_Base_Lexer_Case_Rule_Alt_Memos is new Liblktlang_Support.Packrat
        (Bare_Base_Lexer_Case_Rule_Alt, Token_Index);

      package Bare_Lexer_Case_Rule_Cond_Alt_Memos is new Liblktlang_Support.Packrat
        (Bare_Lexer_Case_Rule_Cond_Alt, Token_Index);

         
         subtype Subtype_For_Lexer_Case_Rule_Cond_Alt is
            Root_Node_Record (Lkt_Lexer_Case_Rule_Cond_Alt);
         type Access_To_Subtype_For_Lexer_Case_Rule_Cond_Alt is access all Subtype_For_Lexer_Case_Rule_Cond_Alt;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Lexer_Case_Rule_Cond_Alt);
         package Bare_Lexer_Case_Rule_Cond_Alt_Alloc is new Alloc
           (Subtype_For_Lexer_Case_Rule_Cond_Alt, Access_To_Subtype_For_Lexer_Case_Rule_Cond_Alt);

         function Allocate_Lexer_Case_Rule_Cond_Alt
           (Pool : Bump_Ptr_Pool) return Bare_Lexer_Case_Rule_Cond_Alt;

         function Allocate_Lexer_Case_Rule_Cond_Alt
           (Pool : Bump_Ptr_Pool) return Bare_Lexer_Case_Rule_Cond_Alt
         is
            Result      : constant Access_To_Subtype_For_Lexer_Case_Rule_Cond_Alt := Bare_Lexer_Case_Rule_Cond_Alt_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Lexer_Case_Rule_Cond_Alt;
            return Bare_Lexer_Case_Rule_Cond_Alt (Result);
         end Allocate_Lexer_Case_Rule_Cond_Alt;

      package Bare_Lexer_Case_Rule_Default_Alt_Memos is new Liblktlang_Support.Packrat
        (Bare_Lexer_Case_Rule_Default_Alt, Token_Index);

         
         subtype Subtype_For_Lexer_Case_Rule_Default_Alt is
            Root_Node_Record (Lkt_Lexer_Case_Rule_Default_Alt);
         type Access_To_Subtype_For_Lexer_Case_Rule_Default_Alt is access all Subtype_For_Lexer_Case_Rule_Default_Alt;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Lexer_Case_Rule_Default_Alt);
         package Bare_Lexer_Case_Rule_Default_Alt_Alloc is new Alloc
           (Subtype_For_Lexer_Case_Rule_Default_Alt, Access_To_Subtype_For_Lexer_Case_Rule_Default_Alt);

         function Allocate_Lexer_Case_Rule_Default_Alt
           (Pool : Bump_Ptr_Pool) return Bare_Lexer_Case_Rule_Default_Alt;

         function Allocate_Lexer_Case_Rule_Default_Alt
           (Pool : Bump_Ptr_Pool) return Bare_Lexer_Case_Rule_Default_Alt
         is
            Result      : constant Access_To_Subtype_For_Lexer_Case_Rule_Default_Alt := Bare_Lexer_Case_Rule_Default_Alt_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Lexer_Case_Rule_Default_Alt;
            return Bare_Lexer_Case_Rule_Default_Alt (Result);
         end Allocate_Lexer_Case_Rule_Default_Alt;

      package Bare_Base_Match_Branch_Memos is new Liblktlang_Support.Packrat
        (Bare_Base_Match_Branch, Token_Index);

      package Bare_Match_Branch_Memos is new Liblktlang_Support.Packrat
        (Bare_Match_Branch, Token_Index);

         
         subtype Subtype_For_Match_Branch is
            Root_Node_Record (Lkt_Match_Branch);
         type Access_To_Subtype_For_Match_Branch is access all Subtype_For_Match_Branch;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Match_Branch);
         package Bare_Match_Branch_Alloc is new Alloc
           (Subtype_For_Match_Branch, Access_To_Subtype_For_Match_Branch);

         function Allocate_Match_Branch
           (Pool : Bump_Ptr_Pool) return Bare_Match_Branch;

         function Allocate_Match_Branch
           (Pool : Bump_Ptr_Pool) return Bare_Match_Branch
         is
            Result      : constant Access_To_Subtype_For_Match_Branch := Bare_Match_Branch_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Match_Branch;
            return Bare_Match_Branch (Result);
         end Allocate_Match_Branch;

      package Bare_Pattern_Match_Branch_Memos is new Liblktlang_Support.Packrat
        (Bare_Pattern_Match_Branch, Token_Index);

         
         subtype Subtype_For_Pattern_Match_Branch is
            Root_Node_Record (Lkt_Pattern_Match_Branch);
         type Access_To_Subtype_For_Pattern_Match_Branch is access all Subtype_For_Pattern_Match_Branch;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Pattern_Match_Branch);
         package Bare_Pattern_Match_Branch_Alloc is new Alloc
           (Subtype_For_Pattern_Match_Branch, Access_To_Subtype_For_Pattern_Match_Branch);

         function Allocate_Pattern_Match_Branch
           (Pool : Bump_Ptr_Pool) return Bare_Pattern_Match_Branch;

         function Allocate_Pattern_Match_Branch
           (Pool : Bump_Ptr_Pool) return Bare_Pattern_Match_Branch
         is
            Result      : constant Access_To_Subtype_For_Pattern_Match_Branch := Bare_Pattern_Match_Branch_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Pattern_Match_Branch;
            return Bare_Pattern_Match_Branch (Result);
         end Allocate_Pattern_Match_Branch;

      package Bare_Block_Expr_Clause_Memos is new Liblktlang_Support.Packrat
        (Bare_Block_Expr_Clause, Token_Index);

         
         subtype Subtype_For_Block_Expr_Clause is
            Root_Node_Record (Lkt_Block_Expr_Clause);
         type Access_To_Subtype_For_Block_Expr_Clause is access all Subtype_For_Block_Expr_Clause;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Block_Expr_Clause);
         package Bare_Block_Expr_Clause_Alloc is new Alloc
           (Subtype_For_Block_Expr_Clause, Access_To_Subtype_For_Block_Expr_Clause);

         function Allocate_Block_Expr_Clause
           (Pool : Bump_Ptr_Pool) return Bare_Block_Expr_Clause;

         function Allocate_Block_Expr_Clause
           (Pool : Bump_Ptr_Pool) return Bare_Block_Expr_Clause
         is
            Result      : constant Access_To_Subtype_For_Block_Expr_Clause := Bare_Block_Expr_Clause_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Block_Expr_Clause;
            return Bare_Block_Expr_Clause (Result);
         end Allocate_Block_Expr_Clause;

      package Bare_Block_String_Line_Memos is new Liblktlang_Support.Packrat
        (Bare_Block_String_Line, Token_Index);

         
         subtype Subtype_For_Block_String_Line is
            Root_Node_Record (Lkt_Block_String_Line);
         type Access_To_Subtype_For_Block_String_Line is access all Subtype_For_Block_String_Line;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Block_String_Line);
         package Bare_Block_String_Line_Alloc is new Alloc
           (Subtype_For_Block_String_Line, Access_To_Subtype_For_Block_String_Line);

         function Allocate_Block_String_Line
           (Pool : Bump_Ptr_Pool) return Bare_Block_String_Line;

         function Allocate_Block_String_Line
           (Pool : Bump_Ptr_Pool) return Bare_Block_String_Line
         is
            Result      : constant Access_To_Subtype_For_Block_String_Line := Bare_Block_String_Line_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Block_String_Line;
            return Bare_Block_String_Line (Result);
         end Allocate_Block_String_Line;

      package Bare_Class_Qualifier_Memos is new Liblktlang_Support.Packrat
        (Bare_Class_Qualifier, Token_Index);

      package Bare_Class_Qualifier_Absent_Memos is new Liblktlang_Support.Packrat
        (Bare_Class_Qualifier_Absent, Token_Index);

         
         subtype Subtype_For_Class_Qualifier_Absent is
            Root_Node_Record (Lkt_Class_Qualifier_Absent);
         type Access_To_Subtype_For_Class_Qualifier_Absent is access all Subtype_For_Class_Qualifier_Absent;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Class_Qualifier_Absent);
         package Bare_Class_Qualifier_Absent_Alloc is new Alloc
           (Subtype_For_Class_Qualifier_Absent, Access_To_Subtype_For_Class_Qualifier_Absent);

         function Allocate_Class_Qualifier_Absent
           (Pool : Bump_Ptr_Pool) return Bare_Class_Qualifier_Absent;

         function Allocate_Class_Qualifier_Absent
           (Pool : Bump_Ptr_Pool) return Bare_Class_Qualifier_Absent
         is
            Result      : constant Access_To_Subtype_For_Class_Qualifier_Absent := Bare_Class_Qualifier_Absent_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Class_Qualifier_Absent;
            return Bare_Class_Qualifier_Absent (Result);
         end Allocate_Class_Qualifier_Absent;

      package Bare_Class_Qualifier_Present_Memos is new Liblktlang_Support.Packrat
        (Bare_Class_Qualifier_Present, Token_Index);

         
         subtype Subtype_For_Class_Qualifier_Present is
            Root_Node_Record (Lkt_Class_Qualifier_Present);
         type Access_To_Subtype_For_Class_Qualifier_Present is access all Subtype_For_Class_Qualifier_Present;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Class_Qualifier_Present);
         package Bare_Class_Qualifier_Present_Alloc is new Alloc
           (Subtype_For_Class_Qualifier_Present, Access_To_Subtype_For_Class_Qualifier_Present);

         function Allocate_Class_Qualifier_Present
           (Pool : Bump_Ptr_Pool) return Bare_Class_Qualifier_Present;

         function Allocate_Class_Qualifier_Present
           (Pool : Bump_Ptr_Pool) return Bare_Class_Qualifier_Present
         is
            Result      : constant Access_To_Subtype_For_Class_Qualifier_Present := Bare_Class_Qualifier_Present_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Class_Qualifier_Present;
            return Bare_Class_Qualifier_Present (Result);
         end Allocate_Class_Qualifier_Present;

      package Bare_Decl_Memos is new Liblktlang_Support.Packrat
        (Bare_Decl, Token_Index);

      package Bare_Base_Grammar_Rule_Decl_Memos is new Liblktlang_Support.Packrat
        (Bare_Base_Grammar_Rule_Decl, Token_Index);

      package Bare_Grammar_Rule_Decl_Memos is new Liblktlang_Support.Packrat
        (Bare_Grammar_Rule_Decl, Token_Index);

         
         subtype Subtype_For_Grammar_Rule_Decl is
            Root_Node_Record (Lkt_Grammar_Rule_Decl);
         type Access_To_Subtype_For_Grammar_Rule_Decl is access all Subtype_For_Grammar_Rule_Decl;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Grammar_Rule_Decl);
         package Bare_Grammar_Rule_Decl_Alloc is new Alloc
           (Subtype_For_Grammar_Rule_Decl, Access_To_Subtype_For_Grammar_Rule_Decl);

         function Allocate_Grammar_Rule_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Grammar_Rule_Decl;

         function Allocate_Grammar_Rule_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Grammar_Rule_Decl
         is
            Result      : constant Access_To_Subtype_For_Grammar_Rule_Decl := Bare_Grammar_Rule_Decl_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Grammar_Rule_Decl;
            return Bare_Grammar_Rule_Decl (Result);
         end Allocate_Grammar_Rule_Decl;

      package Bare_Synthetic_Lexer_Decl_Memos is new Liblktlang_Support.Packrat
        (Bare_Synthetic_Lexer_Decl, Token_Index);

         
         subtype Subtype_For_Synthetic_Lexer_Decl is
            Root_Node_Record (Lkt_Synthetic_Lexer_Decl);
         type Access_To_Subtype_For_Synthetic_Lexer_Decl is access all Subtype_For_Synthetic_Lexer_Decl;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Synthetic_Lexer_Decl);
         package Bare_Synthetic_Lexer_Decl_Alloc is new Alloc
           (Subtype_For_Synthetic_Lexer_Decl, Access_To_Subtype_For_Synthetic_Lexer_Decl);

         function Allocate_Synthetic_Lexer_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Synthetic_Lexer_Decl;

         function Allocate_Synthetic_Lexer_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Synthetic_Lexer_Decl
         is
            Result      : constant Access_To_Subtype_For_Synthetic_Lexer_Decl := Bare_Synthetic_Lexer_Decl_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Synthetic_Lexer_Decl;
            return Bare_Synthetic_Lexer_Decl (Result);
         end Allocate_Synthetic_Lexer_Decl;

      package Bare_Base_Val_Decl_Memos is new Liblktlang_Support.Packrat
        (Bare_Base_Val_Decl, Token_Index);

      package Bare_Node_Decl_Memos is new Liblktlang_Support.Packrat
        (Bare_Node_Decl, Token_Index);

         
         subtype Subtype_For_Node_Decl is
            Root_Node_Record (Lkt_Node_Decl);
         type Access_To_Subtype_For_Node_Decl is access all Subtype_For_Node_Decl;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Node_Decl);
         package Bare_Node_Decl_Alloc is new Alloc
           (Subtype_For_Node_Decl, Access_To_Subtype_For_Node_Decl);

         function Allocate_Node_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Node_Decl;

         function Allocate_Node_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Node_Decl
         is
            Result      : constant Access_To_Subtype_For_Node_Decl := Bare_Node_Decl_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Node_Decl;
            return Bare_Node_Decl (Result);
         end Allocate_Node_Decl;

      package Bare_Self_Decl_Memos is new Liblktlang_Support.Packrat
        (Bare_Self_Decl, Token_Index);

         
         subtype Subtype_For_Self_Decl is
            Root_Node_Record (Lkt_Self_Decl);
         type Access_To_Subtype_For_Self_Decl is access all Subtype_For_Self_Decl;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Self_Decl);
         package Bare_Self_Decl_Alloc is new Alloc
           (Subtype_For_Self_Decl, Access_To_Subtype_For_Self_Decl);

         function Allocate_Self_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Self_Decl;

         function Allocate_Self_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Self_Decl
         is
            Result      : constant Access_To_Subtype_For_Self_Decl := Bare_Self_Decl_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Self_Decl;
            return Bare_Self_Decl (Result);
         end Allocate_Self_Decl;

      package Bare_User_Val_Decl_Memos is new Liblktlang_Support.Packrat
        (Bare_User_Val_Decl, Token_Index);

      package Bare_Binding_Val_Decl_Memos is new Liblktlang_Support.Packrat
        (Bare_Binding_Val_Decl, Token_Index);

         
         subtype Subtype_For_Binding_Val_Decl is
            Root_Node_Record (Lkt_Binding_Val_Decl);
         type Access_To_Subtype_For_Binding_Val_Decl is access all Subtype_For_Binding_Val_Decl;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Binding_Val_Decl);
         package Bare_Binding_Val_Decl_Alloc is new Alloc
           (Subtype_For_Binding_Val_Decl, Access_To_Subtype_For_Binding_Val_Decl);

         function Allocate_Binding_Val_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Binding_Val_Decl;

         function Allocate_Binding_Val_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Binding_Val_Decl
         is
            Result      : constant Access_To_Subtype_For_Binding_Val_Decl := Bare_Binding_Val_Decl_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Binding_Val_Decl;
            return Bare_Binding_Val_Decl (Result);
         end Allocate_Binding_Val_Decl;

      package Bare_Enum_Lit_Decl_Memos is new Liblktlang_Support.Packrat
        (Bare_Enum_Lit_Decl, Token_Index);

         
         subtype Subtype_For_Enum_Lit_Decl is
            Root_Node_Record (Lkt_Enum_Lit_Decl);
         type Access_To_Subtype_For_Enum_Lit_Decl is access all Subtype_For_Enum_Lit_Decl;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Enum_Lit_Decl);
         package Bare_Enum_Lit_Decl_Alloc is new Alloc
           (Subtype_For_Enum_Lit_Decl, Access_To_Subtype_For_Enum_Lit_Decl);

         function Allocate_Enum_Lit_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Enum_Lit_Decl;

         function Allocate_Enum_Lit_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Enum_Lit_Decl
         is
            Result      : constant Access_To_Subtype_For_Enum_Lit_Decl := Bare_Enum_Lit_Decl_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Enum_Lit_Decl;
            return Bare_Enum_Lit_Decl (Result);
         end Allocate_Enum_Lit_Decl;

      package Bare_Explicitly_Typed_Decl_Memos is new Liblktlang_Support.Packrat
        (Bare_Explicitly_Typed_Decl, Token_Index);

      package Bare_Component_Decl_Memos is new Liblktlang_Support.Packrat
        (Bare_Component_Decl, Token_Index);

      package Bare_Field_Decl_Memos is new Liblktlang_Support.Packrat
        (Bare_Field_Decl, Token_Index);

         
         subtype Subtype_For_Field_Decl is
            Root_Node_Record (Lkt_Field_Decl);
         type Access_To_Subtype_For_Field_Decl is access all Subtype_For_Field_Decl;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Field_Decl);
         package Bare_Field_Decl_Alloc is new Alloc
           (Subtype_For_Field_Decl, Access_To_Subtype_For_Field_Decl);

         function Allocate_Field_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Field_Decl;

         function Allocate_Field_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Field_Decl
         is
            Result      : constant Access_To_Subtype_For_Field_Decl := Bare_Field_Decl_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Field_Decl;
            return Bare_Field_Decl (Result);
         end Allocate_Field_Decl;

      package Bare_Fun_Param_Decl_Memos is new Liblktlang_Support.Packrat
        (Bare_Fun_Param_Decl, Token_Index);

         
         subtype Subtype_For_Fun_Param_Decl is
            Root_Node_Record (Lkt_Fun_Param_Decl);
         type Access_To_Subtype_For_Fun_Param_Decl is access all Subtype_For_Fun_Param_Decl;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Fun_Param_Decl);
         package Bare_Fun_Param_Decl_Alloc is new Alloc
           (Subtype_For_Fun_Param_Decl, Access_To_Subtype_For_Fun_Param_Decl);

         function Allocate_Fun_Param_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Fun_Param_Decl;

         function Allocate_Fun_Param_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Fun_Param_Decl
         is
            Result      : constant Access_To_Subtype_For_Fun_Param_Decl := Bare_Fun_Param_Decl_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Fun_Param_Decl;
            return Bare_Fun_Param_Decl (Result);
         end Allocate_Fun_Param_Decl;

      package Bare_Lambda_Param_Decl_Memos is new Liblktlang_Support.Packrat
        (Bare_Lambda_Param_Decl, Token_Index);

         
         subtype Subtype_For_Lambda_Param_Decl is
            Root_Node_Record (Lkt_Lambda_Param_Decl);
         type Access_To_Subtype_For_Lambda_Param_Decl is access all Subtype_For_Lambda_Param_Decl;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Lambda_Param_Decl);
         package Bare_Lambda_Param_Decl_Alloc is new Alloc
           (Subtype_For_Lambda_Param_Decl, Access_To_Subtype_For_Lambda_Param_Decl);

         function Allocate_Lambda_Param_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Lambda_Param_Decl;

         function Allocate_Lambda_Param_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Lambda_Param_Decl
         is
            Result      : constant Access_To_Subtype_For_Lambda_Param_Decl := Bare_Lambda_Param_Decl_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Lambda_Param_Decl;
            return Bare_Lambda_Param_Decl (Result);
         end Allocate_Lambda_Param_Decl;

      package Bare_Dyn_Var_Decl_Memos is new Liblktlang_Support.Packrat
        (Bare_Dyn_Var_Decl, Token_Index);

         
         subtype Subtype_For_Dyn_Var_Decl is
            Root_Node_Record (Lkt_Dyn_Var_Decl);
         type Access_To_Subtype_For_Dyn_Var_Decl is access all Subtype_For_Dyn_Var_Decl;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Dyn_Var_Decl);
         package Bare_Dyn_Var_Decl_Alloc is new Alloc
           (Subtype_For_Dyn_Var_Decl, Access_To_Subtype_For_Dyn_Var_Decl);

         function Allocate_Dyn_Var_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Dyn_Var_Decl;

         function Allocate_Dyn_Var_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Dyn_Var_Decl
         is
            Result      : constant Access_To_Subtype_For_Dyn_Var_Decl := Bare_Dyn_Var_Decl_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Dyn_Var_Decl;
            return Bare_Dyn_Var_Decl (Result);
         end Allocate_Dyn_Var_Decl;

      package Bare_Match_Val_Decl_Memos is new Liblktlang_Support.Packrat
        (Bare_Match_Val_Decl, Token_Index);

         
         subtype Subtype_For_Match_Val_Decl is
            Root_Node_Record (Lkt_Match_Val_Decl);
         type Access_To_Subtype_For_Match_Val_Decl is access all Subtype_For_Match_Val_Decl;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Match_Val_Decl);
         package Bare_Match_Val_Decl_Alloc is new Alloc
           (Subtype_For_Match_Val_Decl, Access_To_Subtype_For_Match_Val_Decl);

         function Allocate_Match_Val_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Match_Val_Decl;

         function Allocate_Match_Val_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Match_Val_Decl
         is
            Result      : constant Access_To_Subtype_For_Match_Val_Decl := Bare_Match_Val_Decl_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Match_Val_Decl;
            return Bare_Match_Val_Decl (Result);
         end Allocate_Match_Val_Decl;

      package Bare_Val_Decl_Memos is new Liblktlang_Support.Packrat
        (Bare_Val_Decl, Token_Index);

         
         subtype Subtype_For_Val_Decl is
            Root_Node_Record (Lkt_Val_Decl);
         type Access_To_Subtype_For_Val_Decl is access all Subtype_For_Val_Decl;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Val_Decl);
         package Bare_Val_Decl_Alloc is new Alloc
           (Subtype_For_Val_Decl, Access_To_Subtype_For_Val_Decl);

         function Allocate_Val_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Val_Decl;

         function Allocate_Val_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Val_Decl
         is
            Result      : constant Access_To_Subtype_For_Val_Decl := Bare_Val_Decl_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Val_Decl;
            return Bare_Val_Decl (Result);
         end Allocate_Val_Decl;

      package Bare_Fun_Decl_Memos is new Liblktlang_Support.Packrat
        (Bare_Fun_Decl, Token_Index);

         
         subtype Subtype_For_Fun_Decl is
            Root_Node_Record (Lkt_Fun_Decl);
         type Access_To_Subtype_For_Fun_Decl is access all Subtype_For_Fun_Decl;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Fun_Decl);
         package Bare_Fun_Decl_Alloc is new Alloc
           (Subtype_For_Fun_Decl, Access_To_Subtype_For_Fun_Decl);

         function Allocate_Fun_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Fun_Decl;

         function Allocate_Fun_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Fun_Decl
         is
            Result      : constant Access_To_Subtype_For_Fun_Decl := Bare_Fun_Decl_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Fun_Decl;
            return Bare_Fun_Decl (Result);
         end Allocate_Fun_Decl;

      package Bare_Env_Spec_Decl_Memos is new Liblktlang_Support.Packrat
        (Bare_Env_Spec_Decl, Token_Index);

         
         subtype Subtype_For_Env_Spec_Decl is
            Root_Node_Record (Lkt_Env_Spec_Decl);
         type Access_To_Subtype_For_Env_Spec_Decl is access all Subtype_For_Env_Spec_Decl;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Env_Spec_Decl);
         package Bare_Env_Spec_Decl_Alloc is new Alloc
           (Subtype_For_Env_Spec_Decl, Access_To_Subtype_For_Env_Spec_Decl);

         function Allocate_Env_Spec_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Env_Spec_Decl;

         function Allocate_Env_Spec_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Env_Spec_Decl
         is
            Result      : constant Access_To_Subtype_For_Env_Spec_Decl := Bare_Env_Spec_Decl_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Env_Spec_Decl;
            return Bare_Env_Spec_Decl (Result);
         end Allocate_Env_Spec_Decl;

      package Bare_Error_Decl_Memos is new Liblktlang_Support.Packrat
        (Bare_Error_Decl, Token_Index);

         
         subtype Subtype_For_Error_Decl is
            Root_Node_Record (Lkt_Error_Decl);
         type Access_To_Subtype_For_Error_Decl is access all Subtype_For_Error_Decl;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Error_Decl);
         package Bare_Error_Decl_Alloc is new Alloc
           (Subtype_For_Error_Decl, Access_To_Subtype_For_Error_Decl);

         function Allocate_Error_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Error_Decl;

         function Allocate_Error_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Error_Decl
         is
            Result      : constant Access_To_Subtype_For_Error_Decl := Bare_Error_Decl_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Error_Decl;
            return Bare_Error_Decl (Result);
         end Allocate_Error_Decl;

      package Bare_Generic_Decl_Memos is new Liblktlang_Support.Packrat
        (Bare_Generic_Decl, Token_Index);

         
         subtype Subtype_For_Generic_Decl is
            Root_Node_Record (Lkt_Generic_Decl);
         type Access_To_Subtype_For_Generic_Decl is access all Subtype_For_Generic_Decl;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Generic_Decl);
         package Bare_Generic_Decl_Alloc is new Alloc
           (Subtype_For_Generic_Decl, Access_To_Subtype_For_Generic_Decl);

         function Allocate_Generic_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Generic_Decl;

         function Allocate_Generic_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Generic_Decl
         is
            Result      : constant Access_To_Subtype_For_Generic_Decl := Bare_Generic_Decl_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Generic_Decl;
            return Bare_Generic_Decl (Result);
         end Allocate_Generic_Decl;

      package Bare_Grammar_Decl_Memos is new Liblktlang_Support.Packrat
        (Bare_Grammar_Decl, Token_Index);

         
         subtype Subtype_For_Grammar_Decl is
            Root_Node_Record (Lkt_Grammar_Decl);
         type Access_To_Subtype_For_Grammar_Decl is access all Subtype_For_Grammar_Decl;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Grammar_Decl);
         package Bare_Grammar_Decl_Alloc is new Alloc
           (Subtype_For_Grammar_Decl, Access_To_Subtype_For_Grammar_Decl);

         function Allocate_Grammar_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Grammar_Decl;

         function Allocate_Grammar_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Grammar_Decl
         is
            Result      : constant Access_To_Subtype_For_Grammar_Decl := Bare_Grammar_Decl_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Grammar_Decl;
            return Bare_Grammar_Decl (Result);
         end Allocate_Grammar_Decl;

      package Bare_Lexer_Decl_Memos is new Liblktlang_Support.Packrat
        (Bare_Lexer_Decl, Token_Index);

         
         subtype Subtype_For_Lexer_Decl is
            Root_Node_Record (Lkt_Lexer_Decl);
         type Access_To_Subtype_For_Lexer_Decl is access all Subtype_For_Lexer_Decl;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Lexer_Decl);
         package Bare_Lexer_Decl_Alloc is new Alloc
           (Subtype_For_Lexer_Decl, Access_To_Subtype_For_Lexer_Decl);

         function Allocate_Lexer_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Lexer_Decl;

         function Allocate_Lexer_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Lexer_Decl
         is
            Result      : constant Access_To_Subtype_For_Lexer_Decl := Bare_Lexer_Decl_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Lexer_Decl;
            return Bare_Lexer_Decl (Result);
         end Allocate_Lexer_Decl;

      package Bare_Lexer_Family_Decl_Memos is new Liblktlang_Support.Packrat
        (Bare_Lexer_Family_Decl, Token_Index);

         
         subtype Subtype_For_Lexer_Family_Decl is
            Root_Node_Record (Lkt_Lexer_Family_Decl);
         type Access_To_Subtype_For_Lexer_Family_Decl is access all Subtype_For_Lexer_Family_Decl;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Lexer_Family_Decl);
         package Bare_Lexer_Family_Decl_Alloc is new Alloc
           (Subtype_For_Lexer_Family_Decl, Access_To_Subtype_For_Lexer_Family_Decl);

         function Allocate_Lexer_Family_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Lexer_Family_Decl;

         function Allocate_Lexer_Family_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Lexer_Family_Decl
         is
            Result      : constant Access_To_Subtype_For_Lexer_Family_Decl := Bare_Lexer_Family_Decl_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Lexer_Family_Decl;
            return Bare_Lexer_Family_Decl (Result);
         end Allocate_Lexer_Family_Decl;

      package Bare_Synth_Fun_Decl_Memos is new Liblktlang_Support.Packrat
        (Bare_Synth_Fun_Decl, Token_Index);

         
         subtype Subtype_For_Synth_Fun_Decl is
            Root_Node_Record (Lkt_Synth_Fun_Decl);
         type Access_To_Subtype_For_Synth_Fun_Decl is access all Subtype_For_Synth_Fun_Decl;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Synth_Fun_Decl);
         package Bare_Synth_Fun_Decl_Alloc is new Alloc
           (Subtype_For_Synth_Fun_Decl, Access_To_Subtype_For_Synth_Fun_Decl);

         function Allocate_Synth_Fun_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Synth_Fun_Decl;

         function Allocate_Synth_Fun_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Synth_Fun_Decl
         is
            Result      : constant Access_To_Subtype_For_Synth_Fun_Decl := Bare_Synth_Fun_Decl_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Synth_Fun_Decl;
            return Bare_Synth_Fun_Decl (Result);
         end Allocate_Synth_Fun_Decl;

      package Bare_Synth_Param_Decl_Memos is new Liblktlang_Support.Packrat
        (Bare_Synth_Param_Decl, Token_Index);

         
         subtype Subtype_For_Synth_Param_Decl is
            Root_Node_Record (Lkt_Synth_Param_Decl);
         type Access_To_Subtype_For_Synth_Param_Decl is access all Subtype_For_Synth_Param_Decl;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Synth_Param_Decl);
         package Bare_Synth_Param_Decl_Alloc is new Alloc
           (Subtype_For_Synth_Param_Decl, Access_To_Subtype_For_Synth_Param_Decl);

         function Allocate_Synth_Param_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Synth_Param_Decl;

         function Allocate_Synth_Param_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Synth_Param_Decl
         is
            Result      : constant Access_To_Subtype_For_Synth_Param_Decl := Bare_Synth_Param_Decl_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Synth_Param_Decl;
            return Bare_Synth_Param_Decl (Result);
         end Allocate_Synth_Param_Decl;

      package Bare_Type_Decl_Memos is new Liblktlang_Support.Packrat
        (Bare_Type_Decl, Token_Index);

      package Bare_Any_Type_Decl_Memos is new Liblktlang_Support.Packrat
        (Bare_Any_Type_Decl, Token_Index);

         
         subtype Subtype_For_Any_Type_Decl is
            Root_Node_Record (Lkt_Any_Type_Decl);
         type Access_To_Subtype_For_Any_Type_Decl is access all Subtype_For_Any_Type_Decl;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Any_Type_Decl);
         package Bare_Any_Type_Decl_Alloc is new Alloc
           (Subtype_For_Any_Type_Decl, Access_To_Subtype_For_Any_Type_Decl);

         function Allocate_Any_Type_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Any_Type_Decl;

         function Allocate_Any_Type_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Any_Type_Decl
         is
            Result      : constant Access_To_Subtype_For_Any_Type_Decl := Bare_Any_Type_Decl_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Any_Type_Decl;
            return Bare_Any_Type_Decl (Result);
         end Allocate_Any_Type_Decl;

      package Bare_Enum_Class_Alt_Decl_Memos is new Liblktlang_Support.Packrat
        (Bare_Enum_Class_Alt_Decl, Token_Index);

         
         subtype Subtype_For_Enum_Class_Alt_Decl is
            Root_Node_Record (Lkt_Enum_Class_Alt_Decl);
         type Access_To_Subtype_For_Enum_Class_Alt_Decl is access all Subtype_For_Enum_Class_Alt_Decl;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Enum_Class_Alt_Decl);
         package Bare_Enum_Class_Alt_Decl_Alloc is new Alloc
           (Subtype_For_Enum_Class_Alt_Decl, Access_To_Subtype_For_Enum_Class_Alt_Decl);

         function Allocate_Enum_Class_Alt_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Enum_Class_Alt_Decl;

         function Allocate_Enum_Class_Alt_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Enum_Class_Alt_Decl
         is
            Result      : constant Access_To_Subtype_For_Enum_Class_Alt_Decl := Bare_Enum_Class_Alt_Decl_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Enum_Class_Alt_Decl;
            return Bare_Enum_Class_Alt_Decl (Result);
         end Allocate_Enum_Class_Alt_Decl;

      package Bare_Function_Type_Memos is new Liblktlang_Support.Packrat
        (Bare_Function_Type, Token_Index);

         
         subtype Subtype_For_Function_Type is
            Root_Node_Record (Lkt_Function_Type);
         type Access_To_Subtype_For_Function_Type is access all Subtype_For_Function_Type;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Function_Type);
         package Bare_Function_Type_Alloc is new Alloc
           (Subtype_For_Function_Type, Access_To_Subtype_For_Function_Type);

         function Allocate_Function_Type
           (Pool : Bump_Ptr_Pool) return Bare_Function_Type;

         function Allocate_Function_Type
           (Pool : Bump_Ptr_Pool) return Bare_Function_Type
         is
            Result      : constant Access_To_Subtype_For_Function_Type := Bare_Function_Type_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Function_Type;
            return Bare_Function_Type (Result);
         end Allocate_Function_Type;

      package Bare_Generic_Param_Type_Decl_Memos is new Liblktlang_Support.Packrat
        (Bare_Generic_Param_Type_Decl, Token_Index);

         
         subtype Subtype_For_Generic_Param_Type_Decl is
            Root_Node_Record (Lkt_Generic_Param_Type_Decl);
         type Access_To_Subtype_For_Generic_Param_Type_Decl is access all Subtype_For_Generic_Param_Type_Decl;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Generic_Param_Type_Decl);
         package Bare_Generic_Param_Type_Decl_Alloc is new Alloc
           (Subtype_For_Generic_Param_Type_Decl, Access_To_Subtype_For_Generic_Param_Type_Decl);

         function Allocate_Generic_Param_Type_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Generic_Param_Type_Decl;

         function Allocate_Generic_Param_Type_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Generic_Param_Type_Decl
         is
            Result      : constant Access_To_Subtype_For_Generic_Param_Type_Decl := Bare_Generic_Param_Type_Decl_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Generic_Param_Type_Decl;
            return Bare_Generic_Param_Type_Decl (Result);
         end Allocate_Generic_Param_Type_Decl;

      package Bare_Named_Type_Decl_Memos is new Liblktlang_Support.Packrat
        (Bare_Named_Type_Decl, Token_Index);

      package Bare_Basic_Class_Decl_Memos is new Liblktlang_Support.Packrat
        (Bare_Basic_Class_Decl, Token_Index);

      package Bare_Class_Decl_Memos is new Liblktlang_Support.Packrat
        (Bare_Class_Decl, Token_Index);

         
         subtype Subtype_For_Class_Decl is
            Root_Node_Record (Lkt_Class_Decl);
         type Access_To_Subtype_For_Class_Decl is access all Subtype_For_Class_Decl;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Class_Decl);
         package Bare_Class_Decl_Alloc is new Alloc
           (Subtype_For_Class_Decl, Access_To_Subtype_For_Class_Decl);

         function Allocate_Class_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Class_Decl;

         function Allocate_Class_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Class_Decl
         is
            Result      : constant Access_To_Subtype_For_Class_Decl := Bare_Class_Decl_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Class_Decl;
            return Bare_Class_Decl (Result);
         end Allocate_Class_Decl;

      package Bare_Enum_Class_Decl_Memos is new Liblktlang_Support.Packrat
        (Bare_Enum_Class_Decl, Token_Index);

         
         subtype Subtype_For_Enum_Class_Decl is
            Root_Node_Record (Lkt_Enum_Class_Decl);
         type Access_To_Subtype_For_Enum_Class_Decl is access all Subtype_For_Enum_Class_Decl;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Enum_Class_Decl);
         package Bare_Enum_Class_Decl_Alloc is new Alloc
           (Subtype_For_Enum_Class_Decl, Access_To_Subtype_For_Enum_Class_Decl);

         function Allocate_Enum_Class_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Enum_Class_Decl;

         function Allocate_Enum_Class_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Enum_Class_Decl
         is
            Result      : constant Access_To_Subtype_For_Enum_Class_Decl := Bare_Enum_Class_Decl_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Enum_Class_Decl;
            return Bare_Enum_Class_Decl (Result);
         end Allocate_Enum_Class_Decl;

      package Bare_Enum_Type_Decl_Memos is new Liblktlang_Support.Packrat
        (Bare_Enum_Type_Decl, Token_Index);

         
         subtype Subtype_For_Enum_Type_Decl is
            Root_Node_Record (Lkt_Enum_Type_Decl);
         type Access_To_Subtype_For_Enum_Type_Decl is access all Subtype_For_Enum_Type_Decl;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Enum_Type_Decl);
         package Bare_Enum_Type_Decl_Alloc is new Alloc
           (Subtype_For_Enum_Type_Decl, Access_To_Subtype_For_Enum_Type_Decl);

         function Allocate_Enum_Type_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Enum_Type_Decl;

         function Allocate_Enum_Type_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Enum_Type_Decl
         is
            Result      : constant Access_To_Subtype_For_Enum_Type_Decl := Bare_Enum_Type_Decl_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Enum_Type_Decl;
            return Bare_Enum_Type_Decl (Result);
         end Allocate_Enum_Type_Decl;

      package Bare_Struct_Decl_Memos is new Liblktlang_Support.Packrat
        (Bare_Struct_Decl, Token_Index);

         
         subtype Subtype_For_Struct_Decl is
            Root_Node_Record (Lkt_Struct_Decl);
         type Access_To_Subtype_For_Struct_Decl is access all Subtype_For_Struct_Decl;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Struct_Decl);
         package Bare_Struct_Decl_Alloc is new Alloc
           (Subtype_For_Struct_Decl, Access_To_Subtype_For_Struct_Decl);

         function Allocate_Struct_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Struct_Decl;

         function Allocate_Struct_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Struct_Decl
         is
            Result      : constant Access_To_Subtype_For_Struct_Decl := Bare_Struct_Decl_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Struct_Decl;
            return Bare_Struct_Decl (Result);
         end Allocate_Struct_Decl;

      package Bare_Trait_Decl_Memos is new Liblktlang_Support.Packrat
        (Bare_Trait_Decl, Token_Index);

         
         subtype Subtype_For_Trait_Decl is
            Root_Node_Record (Lkt_Trait_Decl);
         type Access_To_Subtype_For_Trait_Decl is access all Subtype_For_Trait_Decl;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Trait_Decl);
         package Bare_Trait_Decl_Alloc is new Alloc
           (Subtype_For_Trait_Decl, Access_To_Subtype_For_Trait_Decl);

         function Allocate_Trait_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Trait_Decl;

         function Allocate_Trait_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Trait_Decl
         is
            Result      : constant Access_To_Subtype_For_Trait_Decl := Bare_Trait_Decl_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Trait_Decl;
            return Bare_Trait_Decl (Result);
         end Allocate_Trait_Decl;

      package Bare_Decl_Annotation_Memos is new Liblktlang_Support.Packrat
        (Bare_Decl_Annotation, Token_Index);

         
         subtype Subtype_For_Decl_Annotation is
            Root_Node_Record (Lkt_Decl_Annotation);
         type Access_To_Subtype_For_Decl_Annotation is access all Subtype_For_Decl_Annotation;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Decl_Annotation);
         package Bare_Decl_Annotation_Alloc is new Alloc
           (Subtype_For_Decl_Annotation, Access_To_Subtype_For_Decl_Annotation);

         function Allocate_Decl_Annotation
           (Pool : Bump_Ptr_Pool) return Bare_Decl_Annotation;

         function Allocate_Decl_Annotation
           (Pool : Bump_Ptr_Pool) return Bare_Decl_Annotation
         is
            Result      : constant Access_To_Subtype_For_Decl_Annotation := Bare_Decl_Annotation_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Decl_Annotation;
            return Bare_Decl_Annotation (Result);
         end Allocate_Decl_Annotation;

      package Bare_Decl_Annotation_Args_Memos is new Liblktlang_Support.Packrat
        (Bare_Decl_Annotation_Args, Token_Index);

         
         subtype Subtype_For_Decl_Annotation_Args is
            Root_Node_Record (Lkt_Decl_Annotation_Args);
         type Access_To_Subtype_For_Decl_Annotation_Args is access all Subtype_For_Decl_Annotation_Args;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Decl_Annotation_Args);
         package Bare_Decl_Annotation_Args_Alloc is new Alloc
           (Subtype_For_Decl_Annotation_Args, Access_To_Subtype_For_Decl_Annotation_Args);

         function Allocate_Decl_Annotation_Args
           (Pool : Bump_Ptr_Pool) return Bare_Decl_Annotation_Args;

         function Allocate_Decl_Annotation_Args
           (Pool : Bump_Ptr_Pool) return Bare_Decl_Annotation_Args
         is
            Result      : constant Access_To_Subtype_For_Decl_Annotation_Args := Bare_Decl_Annotation_Args_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Decl_Annotation_Args;
            return Bare_Decl_Annotation_Args (Result);
         end Allocate_Decl_Annotation_Args;

      package Bare_Dyn_Env_Wrapper_Memos is new Liblktlang_Support.Packrat
        (Bare_Dyn_Env_Wrapper, Token_Index);

         
         subtype Subtype_For_Dyn_Env_Wrapper is
            Root_Node_Record (Lkt_Dyn_Env_Wrapper);
         type Access_To_Subtype_For_Dyn_Env_Wrapper is access all Subtype_For_Dyn_Env_Wrapper;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Dyn_Env_Wrapper);
         package Bare_Dyn_Env_Wrapper_Alloc is new Alloc
           (Subtype_For_Dyn_Env_Wrapper, Access_To_Subtype_For_Dyn_Env_Wrapper);

         function Allocate_Dyn_Env_Wrapper
           (Pool : Bump_Ptr_Pool) return Bare_Dyn_Env_Wrapper;

         function Allocate_Dyn_Env_Wrapper
           (Pool : Bump_Ptr_Pool) return Bare_Dyn_Env_Wrapper
         is
            Result      : constant Access_To_Subtype_For_Dyn_Env_Wrapper := Bare_Dyn_Env_Wrapper_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Dyn_Env_Wrapper;
            return Bare_Dyn_Env_Wrapper (Result);
         end Allocate_Dyn_Env_Wrapper;

      package Bare_Elsif_Branch_Memos is new Liblktlang_Support.Packrat
        (Bare_Elsif_Branch, Token_Index);

         
         subtype Subtype_For_Elsif_Branch is
            Root_Node_Record (Lkt_Elsif_Branch);
         type Access_To_Subtype_For_Elsif_Branch is access all Subtype_For_Elsif_Branch;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Elsif_Branch);
         package Bare_Elsif_Branch_Alloc is new Alloc
           (Subtype_For_Elsif_Branch, Access_To_Subtype_For_Elsif_Branch);

         function Allocate_Elsif_Branch
           (Pool : Bump_Ptr_Pool) return Bare_Elsif_Branch;

         function Allocate_Elsif_Branch
           (Pool : Bump_Ptr_Pool) return Bare_Elsif_Branch
         is
            Result      : constant Access_To_Subtype_For_Elsif_Branch := Bare_Elsif_Branch_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Elsif_Branch;
            return Bare_Elsif_Branch (Result);
         end Allocate_Elsif_Branch;

      package Bare_Enum_Class_Case_Memos is new Liblktlang_Support.Packrat
        (Bare_Enum_Class_Case, Token_Index);

         
         subtype Subtype_For_Enum_Class_Case is
            Root_Node_Record (Lkt_Enum_Class_Case);
         type Access_To_Subtype_For_Enum_Class_Case is access all Subtype_For_Enum_Class_Case;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Enum_Class_Case);
         package Bare_Enum_Class_Case_Alloc is new Alloc
           (Subtype_For_Enum_Class_Case, Access_To_Subtype_For_Enum_Class_Case);

         function Allocate_Enum_Class_Case
           (Pool : Bump_Ptr_Pool) return Bare_Enum_Class_Case;

         function Allocate_Enum_Class_Case
           (Pool : Bump_Ptr_Pool) return Bare_Enum_Class_Case
         is
            Result      : constant Access_To_Subtype_For_Enum_Class_Case := Bare_Enum_Class_Case_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Enum_Class_Case;
            return Bare_Enum_Class_Case (Result);
         end Allocate_Enum_Class_Case;

      package Bare_Excludes_Null_Memos is new Liblktlang_Support.Packrat
        (Bare_Excludes_Null, Token_Index);

      package Bare_Excludes_Null_Absent_Memos is new Liblktlang_Support.Packrat
        (Bare_Excludes_Null_Absent, Token_Index);

         
         subtype Subtype_For_Excludes_Null_Absent is
            Root_Node_Record (Lkt_Excludes_Null_Absent);
         type Access_To_Subtype_For_Excludes_Null_Absent is access all Subtype_For_Excludes_Null_Absent;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Excludes_Null_Absent);
         package Bare_Excludes_Null_Absent_Alloc is new Alloc
           (Subtype_For_Excludes_Null_Absent, Access_To_Subtype_For_Excludes_Null_Absent);

         function Allocate_Excludes_Null_Absent
           (Pool : Bump_Ptr_Pool) return Bare_Excludes_Null_Absent;

         function Allocate_Excludes_Null_Absent
           (Pool : Bump_Ptr_Pool) return Bare_Excludes_Null_Absent
         is
            Result      : constant Access_To_Subtype_For_Excludes_Null_Absent := Bare_Excludes_Null_Absent_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Excludes_Null_Absent;
            return Bare_Excludes_Null_Absent (Result);
         end Allocate_Excludes_Null_Absent;

      package Bare_Excludes_Null_Present_Memos is new Liblktlang_Support.Packrat
        (Bare_Excludes_Null_Present, Token_Index);

         
         subtype Subtype_For_Excludes_Null_Present is
            Root_Node_Record (Lkt_Excludes_Null_Present);
         type Access_To_Subtype_For_Excludes_Null_Present is access all Subtype_For_Excludes_Null_Present;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Excludes_Null_Present);
         package Bare_Excludes_Null_Present_Alloc is new Alloc
           (Subtype_For_Excludes_Null_Present, Access_To_Subtype_For_Excludes_Null_Present);

         function Allocate_Excludes_Null_Present
           (Pool : Bump_Ptr_Pool) return Bare_Excludes_Null_Present;

         function Allocate_Excludes_Null_Present
           (Pool : Bump_Ptr_Pool) return Bare_Excludes_Null_Present
         is
            Result      : constant Access_To_Subtype_For_Excludes_Null_Present := Bare_Excludes_Null_Present_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Excludes_Null_Present;
            return Bare_Excludes_Null_Present (Result);
         end Allocate_Excludes_Null_Present;

      package Bare_Expr_Memos is new Liblktlang_Support.Packrat
        (Bare_Expr, Token_Index);

      package Bare_Any_Of_Memos is new Liblktlang_Support.Packrat
        (Bare_Any_Of, Token_Index);

         
         subtype Subtype_For_Any_Of is
            Root_Node_Record (Lkt_Any_Of);
         type Access_To_Subtype_For_Any_Of is access all Subtype_For_Any_Of;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Any_Of);
         package Bare_Any_Of_Alloc is new Alloc
           (Subtype_For_Any_Of, Access_To_Subtype_For_Any_Of);

         function Allocate_Any_Of
           (Pool : Bump_Ptr_Pool) return Bare_Any_Of;

         function Allocate_Any_Of
           (Pool : Bump_Ptr_Pool) return Bare_Any_Of
         is
            Result      : constant Access_To_Subtype_For_Any_Of := Bare_Any_Of_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Any_Of;
            return Bare_Any_Of (Result);
         end Allocate_Any_Of;

      package Bare_Array_Literal_Memos is new Liblktlang_Support.Packrat
        (Bare_Array_Literal, Token_Index);

         
         subtype Subtype_For_Array_Literal is
            Root_Node_Record (Lkt_Array_Literal);
         type Access_To_Subtype_For_Array_Literal is access all Subtype_For_Array_Literal;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Array_Literal);
         package Bare_Array_Literal_Alloc is new Alloc
           (Subtype_For_Array_Literal, Access_To_Subtype_For_Array_Literal);

         function Allocate_Array_Literal
           (Pool : Bump_Ptr_Pool) return Bare_Array_Literal;

         function Allocate_Array_Literal
           (Pool : Bump_Ptr_Pool) return Bare_Array_Literal
         is
            Result      : constant Access_To_Subtype_For_Array_Literal := Bare_Array_Literal_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Array_Literal;
            return Bare_Array_Literal (Result);
         end Allocate_Array_Literal;

      package Bare_Base_Call_Expr_Memos is new Liblktlang_Support.Packrat
        (Bare_Base_Call_Expr, Token_Index);

      package Bare_Call_Expr_Memos is new Liblktlang_Support.Packrat
        (Bare_Call_Expr, Token_Index);

         
         subtype Subtype_For_Call_Expr is
            Root_Node_Record (Lkt_Call_Expr);
         type Access_To_Subtype_For_Call_Expr is access all Subtype_For_Call_Expr;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Call_Expr);
         package Bare_Call_Expr_Alloc is new Alloc
           (Subtype_For_Call_Expr, Access_To_Subtype_For_Call_Expr);

         function Allocate_Call_Expr
           (Pool : Bump_Ptr_Pool) return Bare_Call_Expr;

         function Allocate_Call_Expr
           (Pool : Bump_Ptr_Pool) return Bare_Call_Expr
         is
            Result      : constant Access_To_Subtype_For_Call_Expr := Bare_Call_Expr_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Call_Expr;
            return Bare_Call_Expr (Result);
         end Allocate_Call_Expr;

      package Bare_Logic_Call_Expr_Memos is new Liblktlang_Support.Packrat
        (Bare_Logic_Call_Expr, Token_Index);

      package Bare_Logic_Predicate_Memos is new Liblktlang_Support.Packrat
        (Bare_Logic_Predicate, Token_Index);

         
         subtype Subtype_For_Logic_Predicate is
            Root_Node_Record (Lkt_Logic_Predicate);
         type Access_To_Subtype_For_Logic_Predicate is access all Subtype_For_Logic_Predicate;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Logic_Predicate);
         package Bare_Logic_Predicate_Alloc is new Alloc
           (Subtype_For_Logic_Predicate, Access_To_Subtype_For_Logic_Predicate);

         function Allocate_Logic_Predicate
           (Pool : Bump_Ptr_Pool) return Bare_Logic_Predicate;

         function Allocate_Logic_Predicate
           (Pool : Bump_Ptr_Pool) return Bare_Logic_Predicate
         is
            Result      : constant Access_To_Subtype_For_Logic_Predicate := Bare_Logic_Predicate_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Logic_Predicate;
            return Bare_Logic_Predicate (Result);
         end Allocate_Logic_Predicate;

      package Bare_Logic_Propagate_Call_Memos is new Liblktlang_Support.Packrat
        (Bare_Logic_Propagate_Call, Token_Index);

         
         subtype Subtype_For_Logic_Propagate_Call is
            Root_Node_Record (Lkt_Logic_Propagate_Call);
         type Access_To_Subtype_For_Logic_Propagate_Call is access all Subtype_For_Logic_Propagate_Call;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Logic_Propagate_Call);
         package Bare_Logic_Propagate_Call_Alloc is new Alloc
           (Subtype_For_Logic_Propagate_Call, Access_To_Subtype_For_Logic_Propagate_Call);

         function Allocate_Logic_Propagate_Call
           (Pool : Bump_Ptr_Pool) return Bare_Logic_Propagate_Call;

         function Allocate_Logic_Propagate_Call
           (Pool : Bump_Ptr_Pool) return Bare_Logic_Propagate_Call
         is
            Result      : constant Access_To_Subtype_For_Logic_Propagate_Call := Bare_Logic_Propagate_Call_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Logic_Propagate_Call;
            return Bare_Logic_Propagate_Call (Result);
         end Allocate_Logic_Propagate_Call;

      package Bare_Bin_Op_Memos is new Liblktlang_Support.Packrat
        (Bare_Bin_Op, Token_Index);

         
         subtype Subtype_For_Bin_Op is
            Root_Node_Record (Lkt_Bin_Op);
         type Access_To_Subtype_For_Bin_Op is access all Subtype_For_Bin_Op;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Bin_Op);
         package Bare_Bin_Op_Alloc is new Alloc
           (Subtype_For_Bin_Op, Access_To_Subtype_For_Bin_Op);

         function Allocate_Bin_Op
           (Pool : Bump_Ptr_Pool) return Bare_Bin_Op;

         function Allocate_Bin_Op
           (Pool : Bump_Ptr_Pool) return Bare_Bin_Op
         is
            Result      : constant Access_To_Subtype_For_Bin_Op := Bare_Bin_Op_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Bin_Op;
            return Bare_Bin_Op (Result);
         end Allocate_Bin_Op;

      package Bare_Block_Expr_Memos is new Liblktlang_Support.Packrat
        (Bare_Block_Expr, Token_Index);

         
         subtype Subtype_For_Block_Expr is
            Root_Node_Record (Lkt_Block_Expr);
         type Access_To_Subtype_For_Block_Expr is access all Subtype_For_Block_Expr;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Block_Expr);
         package Bare_Block_Expr_Alloc is new Alloc
           (Subtype_For_Block_Expr, Access_To_Subtype_For_Block_Expr);

         function Allocate_Block_Expr
           (Pool : Bump_Ptr_Pool) return Bare_Block_Expr;

         function Allocate_Block_Expr
           (Pool : Bump_Ptr_Pool) return Bare_Block_Expr
         is
            Result      : constant Access_To_Subtype_For_Block_Expr := Bare_Block_Expr_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Block_Expr;
            return Bare_Block_Expr (Result);
         end Allocate_Block_Expr;

      package Bare_Cast_Expr_Memos is new Liblktlang_Support.Packrat
        (Bare_Cast_Expr, Token_Index);

         
         subtype Subtype_For_Cast_Expr is
            Root_Node_Record (Lkt_Cast_Expr);
         type Access_To_Subtype_For_Cast_Expr is access all Subtype_For_Cast_Expr;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Cast_Expr);
         package Bare_Cast_Expr_Alloc is new Alloc
           (Subtype_For_Cast_Expr, Access_To_Subtype_For_Cast_Expr);

         function Allocate_Cast_Expr
           (Pool : Bump_Ptr_Pool) return Bare_Cast_Expr;

         function Allocate_Cast_Expr
           (Pool : Bump_Ptr_Pool) return Bare_Cast_Expr
         is
            Result      : constant Access_To_Subtype_For_Cast_Expr := Bare_Cast_Expr_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Cast_Expr;
            return Bare_Cast_Expr (Result);
         end Allocate_Cast_Expr;

      package Bare_Dot_Expr_Memos is new Liblktlang_Support.Packrat
        (Bare_Dot_Expr, Token_Index);

         
         subtype Subtype_For_Dot_Expr is
            Root_Node_Record (Lkt_Dot_Expr);
         type Access_To_Subtype_For_Dot_Expr is access all Subtype_For_Dot_Expr;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Dot_Expr);
         package Bare_Dot_Expr_Alloc is new Alloc
           (Subtype_For_Dot_Expr, Access_To_Subtype_For_Dot_Expr);

         function Allocate_Dot_Expr
           (Pool : Bump_Ptr_Pool) return Bare_Dot_Expr;

         function Allocate_Dot_Expr
           (Pool : Bump_Ptr_Pool) return Bare_Dot_Expr
         is
            Result      : constant Access_To_Subtype_For_Dot_Expr := Bare_Dot_Expr_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Dot_Expr;
            return Bare_Dot_Expr (Result);
         end Allocate_Dot_Expr;

      package Bare_Error_On_Null_Memos is new Liblktlang_Support.Packrat
        (Bare_Error_On_Null, Token_Index);

         
         subtype Subtype_For_Error_On_Null is
            Root_Node_Record (Lkt_Error_On_Null);
         type Access_To_Subtype_For_Error_On_Null is access all Subtype_For_Error_On_Null;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Error_On_Null);
         package Bare_Error_On_Null_Alloc is new Alloc
           (Subtype_For_Error_On_Null, Access_To_Subtype_For_Error_On_Null);

         function Allocate_Error_On_Null
           (Pool : Bump_Ptr_Pool) return Bare_Error_On_Null;

         function Allocate_Error_On_Null
           (Pool : Bump_Ptr_Pool) return Bare_Error_On_Null
         is
            Result      : constant Access_To_Subtype_For_Error_On_Null := Bare_Error_On_Null_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Error_On_Null;
            return Bare_Error_On_Null (Result);
         end Allocate_Error_On_Null;

      package Bare_Generic_Instantiation_Memos is new Liblktlang_Support.Packrat
        (Bare_Generic_Instantiation, Token_Index);

         
         subtype Subtype_For_Generic_Instantiation is
            Root_Node_Record (Lkt_Generic_Instantiation);
         type Access_To_Subtype_For_Generic_Instantiation is access all Subtype_For_Generic_Instantiation;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Generic_Instantiation);
         package Bare_Generic_Instantiation_Alloc is new Alloc
           (Subtype_For_Generic_Instantiation, Access_To_Subtype_For_Generic_Instantiation);

         function Allocate_Generic_Instantiation
           (Pool : Bump_Ptr_Pool) return Bare_Generic_Instantiation;

         function Allocate_Generic_Instantiation
           (Pool : Bump_Ptr_Pool) return Bare_Generic_Instantiation
         is
            Result      : constant Access_To_Subtype_For_Generic_Instantiation := Bare_Generic_Instantiation_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Generic_Instantiation;
            return Bare_Generic_Instantiation (Result);
         end Allocate_Generic_Instantiation;

      package Bare_Grammar_Expr_Memos is new Liblktlang_Support.Packrat
        (Bare_Grammar_Expr, Token_Index);

      package Bare_Grammar_Cut_Memos is new Liblktlang_Support.Packrat
        (Bare_Grammar_Cut, Token_Index);

         
         subtype Subtype_For_Grammar_Cut is
            Root_Node_Record (Lkt_Grammar_Cut);
         type Access_To_Subtype_For_Grammar_Cut is access all Subtype_For_Grammar_Cut;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Grammar_Cut);
         package Bare_Grammar_Cut_Alloc is new Alloc
           (Subtype_For_Grammar_Cut, Access_To_Subtype_For_Grammar_Cut);

         function Allocate_Grammar_Cut
           (Pool : Bump_Ptr_Pool) return Bare_Grammar_Cut;

         function Allocate_Grammar_Cut
           (Pool : Bump_Ptr_Pool) return Bare_Grammar_Cut
         is
            Result      : constant Access_To_Subtype_For_Grammar_Cut := Bare_Grammar_Cut_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Grammar_Cut;
            return Bare_Grammar_Cut (Result);
         end Allocate_Grammar_Cut;

      package Bare_Grammar_Discard_Memos is new Liblktlang_Support.Packrat
        (Bare_Grammar_Discard, Token_Index);

         
         subtype Subtype_For_Grammar_Discard is
            Root_Node_Record (Lkt_Grammar_Discard);
         type Access_To_Subtype_For_Grammar_Discard is access all Subtype_For_Grammar_Discard;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Grammar_Discard);
         package Bare_Grammar_Discard_Alloc is new Alloc
           (Subtype_For_Grammar_Discard, Access_To_Subtype_For_Grammar_Discard);

         function Allocate_Grammar_Discard
           (Pool : Bump_Ptr_Pool) return Bare_Grammar_Discard;

         function Allocate_Grammar_Discard
           (Pool : Bump_Ptr_Pool) return Bare_Grammar_Discard
         is
            Result      : constant Access_To_Subtype_For_Grammar_Discard := Bare_Grammar_Discard_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Grammar_Discard;
            return Bare_Grammar_Discard (Result);
         end Allocate_Grammar_Discard;

      package Bare_Grammar_Dont_Skip_Memos is new Liblktlang_Support.Packrat
        (Bare_Grammar_Dont_Skip, Token_Index);

         
         subtype Subtype_For_Grammar_Dont_Skip is
            Root_Node_Record (Lkt_Grammar_Dont_Skip);
         type Access_To_Subtype_For_Grammar_Dont_Skip is access all Subtype_For_Grammar_Dont_Skip;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Grammar_Dont_Skip);
         package Bare_Grammar_Dont_Skip_Alloc is new Alloc
           (Subtype_For_Grammar_Dont_Skip, Access_To_Subtype_For_Grammar_Dont_Skip);

         function Allocate_Grammar_Dont_Skip
           (Pool : Bump_Ptr_Pool) return Bare_Grammar_Dont_Skip;

         function Allocate_Grammar_Dont_Skip
           (Pool : Bump_Ptr_Pool) return Bare_Grammar_Dont_Skip
         is
            Result      : constant Access_To_Subtype_For_Grammar_Dont_Skip := Bare_Grammar_Dont_Skip_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Grammar_Dont_Skip;
            return Bare_Grammar_Dont_Skip (Result);
         end Allocate_Grammar_Dont_Skip;

      package Bare_Grammar_List_Memos is new Liblktlang_Support.Packrat
        (Bare_Grammar_List, Token_Index);

         
         subtype Subtype_For_Grammar_List is
            Root_Node_Record (Lkt_Grammar_List);
         type Access_To_Subtype_For_Grammar_List is access all Subtype_For_Grammar_List;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Grammar_List);
         package Bare_Grammar_List_Alloc is new Alloc
           (Subtype_For_Grammar_List, Access_To_Subtype_For_Grammar_List);

         function Allocate_Grammar_List
           (Pool : Bump_Ptr_Pool) return Bare_Grammar_List;

         function Allocate_Grammar_List
           (Pool : Bump_Ptr_Pool) return Bare_Grammar_List
         is
            Result      : constant Access_To_Subtype_For_Grammar_List := Bare_Grammar_List_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Grammar_List;
            return Bare_Grammar_List (Result);
         end Allocate_Grammar_List;

      package Bare_Grammar_Null_Memos is new Liblktlang_Support.Packrat
        (Bare_Grammar_Null, Token_Index);

         
         subtype Subtype_For_Grammar_Null is
            Root_Node_Record (Lkt_Grammar_Null);
         type Access_To_Subtype_For_Grammar_Null is access all Subtype_For_Grammar_Null;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Grammar_Null);
         package Bare_Grammar_Null_Alloc is new Alloc
           (Subtype_For_Grammar_Null, Access_To_Subtype_For_Grammar_Null);

         function Allocate_Grammar_Null
           (Pool : Bump_Ptr_Pool) return Bare_Grammar_Null;

         function Allocate_Grammar_Null
           (Pool : Bump_Ptr_Pool) return Bare_Grammar_Null
         is
            Result      : constant Access_To_Subtype_For_Grammar_Null := Bare_Grammar_Null_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Grammar_Null;
            return Bare_Grammar_Null (Result);
         end Allocate_Grammar_Null;

      package Bare_Grammar_Opt_Memos is new Liblktlang_Support.Packrat
        (Bare_Grammar_Opt, Token_Index);

         
         subtype Subtype_For_Grammar_Opt is
            Root_Node_Record (Lkt_Grammar_Opt);
         type Access_To_Subtype_For_Grammar_Opt is access all Subtype_For_Grammar_Opt;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Grammar_Opt);
         package Bare_Grammar_Opt_Alloc is new Alloc
           (Subtype_For_Grammar_Opt, Access_To_Subtype_For_Grammar_Opt);

         function Allocate_Grammar_Opt
           (Pool : Bump_Ptr_Pool) return Bare_Grammar_Opt;

         function Allocate_Grammar_Opt
           (Pool : Bump_Ptr_Pool) return Bare_Grammar_Opt
         is
            Result      : constant Access_To_Subtype_For_Grammar_Opt := Bare_Grammar_Opt_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Grammar_Opt;
            return Bare_Grammar_Opt (Result);
         end Allocate_Grammar_Opt;

      package Bare_Grammar_Opt_Error_Memos is new Liblktlang_Support.Packrat
        (Bare_Grammar_Opt_Error, Token_Index);

         
         subtype Subtype_For_Grammar_Opt_Error is
            Root_Node_Record (Lkt_Grammar_Opt_Error);
         type Access_To_Subtype_For_Grammar_Opt_Error is access all Subtype_For_Grammar_Opt_Error;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Grammar_Opt_Error);
         package Bare_Grammar_Opt_Error_Alloc is new Alloc
           (Subtype_For_Grammar_Opt_Error, Access_To_Subtype_For_Grammar_Opt_Error);

         function Allocate_Grammar_Opt_Error
           (Pool : Bump_Ptr_Pool) return Bare_Grammar_Opt_Error;

         function Allocate_Grammar_Opt_Error
           (Pool : Bump_Ptr_Pool) return Bare_Grammar_Opt_Error
         is
            Result      : constant Access_To_Subtype_For_Grammar_Opt_Error := Bare_Grammar_Opt_Error_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Grammar_Opt_Error;
            return Bare_Grammar_Opt_Error (Result);
         end Allocate_Grammar_Opt_Error;

      package Bare_Grammar_Opt_Error_Group_Memos is new Liblktlang_Support.Packrat
        (Bare_Grammar_Opt_Error_Group, Token_Index);

         
         subtype Subtype_For_Grammar_Opt_Error_Group is
            Root_Node_Record (Lkt_Grammar_Opt_Error_Group);
         type Access_To_Subtype_For_Grammar_Opt_Error_Group is access all Subtype_For_Grammar_Opt_Error_Group;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Grammar_Opt_Error_Group);
         package Bare_Grammar_Opt_Error_Group_Alloc is new Alloc
           (Subtype_For_Grammar_Opt_Error_Group, Access_To_Subtype_For_Grammar_Opt_Error_Group);

         function Allocate_Grammar_Opt_Error_Group
           (Pool : Bump_Ptr_Pool) return Bare_Grammar_Opt_Error_Group;

         function Allocate_Grammar_Opt_Error_Group
           (Pool : Bump_Ptr_Pool) return Bare_Grammar_Opt_Error_Group
         is
            Result      : constant Access_To_Subtype_For_Grammar_Opt_Error_Group := Bare_Grammar_Opt_Error_Group_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Grammar_Opt_Error_Group;
            return Bare_Grammar_Opt_Error_Group (Result);
         end Allocate_Grammar_Opt_Error_Group;

      package Bare_Grammar_Opt_Group_Memos is new Liblktlang_Support.Packrat
        (Bare_Grammar_Opt_Group, Token_Index);

         
         subtype Subtype_For_Grammar_Opt_Group is
            Root_Node_Record (Lkt_Grammar_Opt_Group);
         type Access_To_Subtype_For_Grammar_Opt_Group is access all Subtype_For_Grammar_Opt_Group;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Grammar_Opt_Group);
         package Bare_Grammar_Opt_Group_Alloc is new Alloc
           (Subtype_For_Grammar_Opt_Group, Access_To_Subtype_For_Grammar_Opt_Group);

         function Allocate_Grammar_Opt_Group
           (Pool : Bump_Ptr_Pool) return Bare_Grammar_Opt_Group;

         function Allocate_Grammar_Opt_Group
           (Pool : Bump_Ptr_Pool) return Bare_Grammar_Opt_Group
         is
            Result      : constant Access_To_Subtype_For_Grammar_Opt_Group := Bare_Grammar_Opt_Group_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Grammar_Opt_Group;
            return Bare_Grammar_Opt_Group (Result);
         end Allocate_Grammar_Opt_Group;

      package Bare_Grammar_Or_Expr_Memos is new Liblktlang_Support.Packrat
        (Bare_Grammar_Or_Expr, Token_Index);

         
         subtype Subtype_For_Grammar_Or_Expr is
            Root_Node_Record (Lkt_Grammar_Or_Expr);
         type Access_To_Subtype_For_Grammar_Or_Expr is access all Subtype_For_Grammar_Or_Expr;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Grammar_Or_Expr);
         package Bare_Grammar_Or_Expr_Alloc is new Alloc
           (Subtype_For_Grammar_Or_Expr, Access_To_Subtype_For_Grammar_Or_Expr);

         function Allocate_Grammar_Or_Expr
           (Pool : Bump_Ptr_Pool) return Bare_Grammar_Or_Expr;

         function Allocate_Grammar_Or_Expr
           (Pool : Bump_Ptr_Pool) return Bare_Grammar_Or_Expr
         is
            Result      : constant Access_To_Subtype_For_Grammar_Or_Expr := Bare_Grammar_Or_Expr_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Grammar_Or_Expr;
            return Bare_Grammar_Or_Expr (Result);
         end Allocate_Grammar_Or_Expr;

      package Bare_Grammar_Pick_Memos is new Liblktlang_Support.Packrat
        (Bare_Grammar_Pick, Token_Index);

         
         subtype Subtype_For_Grammar_Pick is
            Root_Node_Record (Lkt_Grammar_Pick);
         type Access_To_Subtype_For_Grammar_Pick is access all Subtype_For_Grammar_Pick;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Grammar_Pick);
         package Bare_Grammar_Pick_Alloc is new Alloc
           (Subtype_For_Grammar_Pick, Access_To_Subtype_For_Grammar_Pick);

         function Allocate_Grammar_Pick
           (Pool : Bump_Ptr_Pool) return Bare_Grammar_Pick;

         function Allocate_Grammar_Pick
           (Pool : Bump_Ptr_Pool) return Bare_Grammar_Pick
         is
            Result      : constant Access_To_Subtype_For_Grammar_Pick := Bare_Grammar_Pick_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Grammar_Pick;
            return Bare_Grammar_Pick (Result);
         end Allocate_Grammar_Pick;

      package Bare_Grammar_Implicit_Pick_Memos is new Liblktlang_Support.Packrat
        (Bare_Grammar_Implicit_Pick, Token_Index);

         
         subtype Subtype_For_Grammar_Implicit_Pick is
            Root_Node_Record (Lkt_Grammar_Implicit_Pick);
         type Access_To_Subtype_For_Grammar_Implicit_Pick is access all Subtype_For_Grammar_Implicit_Pick;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Grammar_Implicit_Pick);
         package Bare_Grammar_Implicit_Pick_Alloc is new Alloc
           (Subtype_For_Grammar_Implicit_Pick, Access_To_Subtype_For_Grammar_Implicit_Pick);

         function Allocate_Grammar_Implicit_Pick
           (Pool : Bump_Ptr_Pool) return Bare_Grammar_Implicit_Pick;

         function Allocate_Grammar_Implicit_Pick
           (Pool : Bump_Ptr_Pool) return Bare_Grammar_Implicit_Pick
         is
            Result      : constant Access_To_Subtype_For_Grammar_Implicit_Pick := Bare_Grammar_Implicit_Pick_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Grammar_Implicit_Pick;
            return Bare_Grammar_Implicit_Pick (Result);
         end Allocate_Grammar_Implicit_Pick;

      package Bare_Grammar_Predicate_Memos is new Liblktlang_Support.Packrat
        (Bare_Grammar_Predicate, Token_Index);

         
         subtype Subtype_For_Grammar_Predicate is
            Root_Node_Record (Lkt_Grammar_Predicate);
         type Access_To_Subtype_For_Grammar_Predicate is access all Subtype_For_Grammar_Predicate;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Grammar_Predicate);
         package Bare_Grammar_Predicate_Alloc is new Alloc
           (Subtype_For_Grammar_Predicate, Access_To_Subtype_For_Grammar_Predicate);

         function Allocate_Grammar_Predicate
           (Pool : Bump_Ptr_Pool) return Bare_Grammar_Predicate;

         function Allocate_Grammar_Predicate
           (Pool : Bump_Ptr_Pool) return Bare_Grammar_Predicate
         is
            Result      : constant Access_To_Subtype_For_Grammar_Predicate := Bare_Grammar_Predicate_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Grammar_Predicate;
            return Bare_Grammar_Predicate (Result);
         end Allocate_Grammar_Predicate;

      package Bare_Grammar_Rule_Ref_Memos is new Liblktlang_Support.Packrat
        (Bare_Grammar_Rule_Ref, Token_Index);

         
         subtype Subtype_For_Grammar_Rule_Ref is
            Root_Node_Record (Lkt_Grammar_Rule_Ref);
         type Access_To_Subtype_For_Grammar_Rule_Ref is access all Subtype_For_Grammar_Rule_Ref;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Grammar_Rule_Ref);
         package Bare_Grammar_Rule_Ref_Alloc is new Alloc
           (Subtype_For_Grammar_Rule_Ref, Access_To_Subtype_For_Grammar_Rule_Ref);

         function Allocate_Grammar_Rule_Ref
           (Pool : Bump_Ptr_Pool) return Bare_Grammar_Rule_Ref;

         function Allocate_Grammar_Rule_Ref
           (Pool : Bump_Ptr_Pool) return Bare_Grammar_Rule_Ref
         is
            Result      : constant Access_To_Subtype_For_Grammar_Rule_Ref := Bare_Grammar_Rule_Ref_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Grammar_Rule_Ref;
            return Bare_Grammar_Rule_Ref (Result);
         end Allocate_Grammar_Rule_Ref;

      package Bare_Grammar_Skip_Memos is new Liblktlang_Support.Packrat
        (Bare_Grammar_Skip, Token_Index);

         
         subtype Subtype_For_Grammar_Skip is
            Root_Node_Record (Lkt_Grammar_Skip);
         type Access_To_Subtype_For_Grammar_Skip is access all Subtype_For_Grammar_Skip;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Grammar_Skip);
         package Bare_Grammar_Skip_Alloc is new Alloc
           (Subtype_For_Grammar_Skip, Access_To_Subtype_For_Grammar_Skip);

         function Allocate_Grammar_Skip
           (Pool : Bump_Ptr_Pool) return Bare_Grammar_Skip;

         function Allocate_Grammar_Skip
           (Pool : Bump_Ptr_Pool) return Bare_Grammar_Skip
         is
            Result      : constant Access_To_Subtype_For_Grammar_Skip := Bare_Grammar_Skip_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Grammar_Skip;
            return Bare_Grammar_Skip (Result);
         end Allocate_Grammar_Skip;

      package Bare_Grammar_Stop_Cut_Memos is new Liblktlang_Support.Packrat
        (Bare_Grammar_Stop_Cut, Token_Index);

         
         subtype Subtype_For_Grammar_Stop_Cut is
            Root_Node_Record (Lkt_Grammar_Stop_Cut);
         type Access_To_Subtype_For_Grammar_Stop_Cut is access all Subtype_For_Grammar_Stop_Cut;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Grammar_Stop_Cut);
         package Bare_Grammar_Stop_Cut_Alloc is new Alloc
           (Subtype_For_Grammar_Stop_Cut, Access_To_Subtype_For_Grammar_Stop_Cut);

         function Allocate_Grammar_Stop_Cut
           (Pool : Bump_Ptr_Pool) return Bare_Grammar_Stop_Cut;

         function Allocate_Grammar_Stop_Cut
           (Pool : Bump_Ptr_Pool) return Bare_Grammar_Stop_Cut
         is
            Result      : constant Access_To_Subtype_For_Grammar_Stop_Cut := Bare_Grammar_Stop_Cut_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Grammar_Stop_Cut;
            return Bare_Grammar_Stop_Cut (Result);
         end Allocate_Grammar_Stop_Cut;

      package Bare_Parse_Node_Expr_Memos is new Liblktlang_Support.Packrat
        (Bare_Parse_Node_Expr, Token_Index);

         
         subtype Subtype_For_Parse_Node_Expr is
            Root_Node_Record (Lkt_Parse_Node_Expr);
         type Access_To_Subtype_For_Parse_Node_Expr is access all Subtype_For_Parse_Node_Expr;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Parse_Node_Expr);
         package Bare_Parse_Node_Expr_Alloc is new Alloc
           (Subtype_For_Parse_Node_Expr, Access_To_Subtype_For_Parse_Node_Expr);

         function Allocate_Parse_Node_Expr
           (Pool : Bump_Ptr_Pool) return Bare_Parse_Node_Expr;

         function Allocate_Parse_Node_Expr
           (Pool : Bump_Ptr_Pool) return Bare_Parse_Node_Expr
         is
            Result      : constant Access_To_Subtype_For_Parse_Node_Expr := Bare_Parse_Node_Expr_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Parse_Node_Expr;
            return Bare_Parse_Node_Expr (Result);
         end Allocate_Parse_Node_Expr;

      package Bare_Token_Lit_Memos is new Liblktlang_Support.Packrat
        (Bare_Token_Lit, Token_Index);

         
         subtype Subtype_For_Token_Lit is
            Root_Node_Record (Lkt_Token_Lit);
         type Access_To_Subtype_For_Token_Lit is access all Subtype_For_Token_Lit;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Token_Lit);
         package Bare_Token_Lit_Alloc is new Alloc
           (Subtype_For_Token_Lit, Access_To_Subtype_For_Token_Lit);

         function Allocate_Token_Lit
           (Pool : Bump_Ptr_Pool) return Bare_Token_Lit;

         function Allocate_Token_Lit
           (Pool : Bump_Ptr_Pool) return Bare_Token_Lit
         is
            Result      : constant Access_To_Subtype_For_Token_Lit := Bare_Token_Lit_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Token_Lit;
            return Bare_Token_Lit (Result);
         end Allocate_Token_Lit;

      package Bare_Token_No_Case_Lit_Memos is new Liblktlang_Support.Packrat
        (Bare_Token_No_Case_Lit, Token_Index);

         
         subtype Subtype_For_Token_No_Case_Lit is
            Root_Node_Record (Lkt_Token_No_Case_Lit);
         type Access_To_Subtype_For_Token_No_Case_Lit is access all Subtype_For_Token_No_Case_Lit;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Token_No_Case_Lit);
         package Bare_Token_No_Case_Lit_Alloc is new Alloc
           (Subtype_For_Token_No_Case_Lit, Access_To_Subtype_For_Token_No_Case_Lit);

         function Allocate_Token_No_Case_Lit
           (Pool : Bump_Ptr_Pool) return Bare_Token_No_Case_Lit;

         function Allocate_Token_No_Case_Lit
           (Pool : Bump_Ptr_Pool) return Bare_Token_No_Case_Lit
         is
            Result      : constant Access_To_Subtype_For_Token_No_Case_Lit := Bare_Token_No_Case_Lit_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Token_No_Case_Lit;
            return Bare_Token_No_Case_Lit (Result);
         end Allocate_Token_No_Case_Lit;

      package Bare_Token_Pattern_Concat_Memos is new Liblktlang_Support.Packrat
        (Bare_Token_Pattern_Concat, Token_Index);

         
         subtype Subtype_For_Token_Pattern_Concat is
            Root_Node_Record (Lkt_Token_Pattern_Concat);
         type Access_To_Subtype_For_Token_Pattern_Concat is access all Subtype_For_Token_Pattern_Concat;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Token_Pattern_Concat);
         package Bare_Token_Pattern_Concat_Alloc is new Alloc
           (Subtype_For_Token_Pattern_Concat, Access_To_Subtype_For_Token_Pattern_Concat);

         function Allocate_Token_Pattern_Concat
           (Pool : Bump_Ptr_Pool) return Bare_Token_Pattern_Concat;

         function Allocate_Token_Pattern_Concat
           (Pool : Bump_Ptr_Pool) return Bare_Token_Pattern_Concat
         is
            Result      : constant Access_To_Subtype_For_Token_Pattern_Concat := Bare_Token_Pattern_Concat_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Token_Pattern_Concat;
            return Bare_Token_Pattern_Concat (Result);
         end Allocate_Token_Pattern_Concat;

      package Bare_Token_Pattern_Lit_Memos is new Liblktlang_Support.Packrat
        (Bare_Token_Pattern_Lit, Token_Index);

         
         subtype Subtype_For_Token_Pattern_Lit is
            Root_Node_Record (Lkt_Token_Pattern_Lit);
         type Access_To_Subtype_For_Token_Pattern_Lit is access all Subtype_For_Token_Pattern_Lit;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Token_Pattern_Lit);
         package Bare_Token_Pattern_Lit_Alloc is new Alloc
           (Subtype_For_Token_Pattern_Lit, Access_To_Subtype_For_Token_Pattern_Lit);

         function Allocate_Token_Pattern_Lit
           (Pool : Bump_Ptr_Pool) return Bare_Token_Pattern_Lit;

         function Allocate_Token_Pattern_Lit
           (Pool : Bump_Ptr_Pool) return Bare_Token_Pattern_Lit
         is
            Result      : constant Access_To_Subtype_For_Token_Pattern_Lit := Bare_Token_Pattern_Lit_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Token_Pattern_Lit;
            return Bare_Token_Pattern_Lit (Result);
         end Allocate_Token_Pattern_Lit;

      package Bare_Token_Ref_Memos is new Liblktlang_Support.Packrat
        (Bare_Token_Ref, Token_Index);

         
         subtype Subtype_For_Token_Ref is
            Root_Node_Record (Lkt_Token_Ref);
         type Access_To_Subtype_For_Token_Ref is access all Subtype_For_Token_Ref;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Token_Ref);
         package Bare_Token_Ref_Alloc is new Alloc
           (Subtype_For_Token_Ref, Access_To_Subtype_For_Token_Ref);

         function Allocate_Token_Ref
           (Pool : Bump_Ptr_Pool) return Bare_Token_Ref;

         function Allocate_Token_Ref
           (Pool : Bump_Ptr_Pool) return Bare_Token_Ref
         is
            Result      : constant Access_To_Subtype_For_Token_Ref := Bare_Token_Ref_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Token_Ref;
            return Bare_Token_Ref (Result);
         end Allocate_Token_Ref;

      package Bare_Id_Memos is new Liblktlang_Support.Packrat
        (Bare_Id, Token_Index);

         
         subtype Subtype_For_Id is
            Root_Node_Record (Lkt_Id);
         type Access_To_Subtype_For_Id is access all Subtype_For_Id;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Id);
         package Bare_Id_Alloc is new Alloc
           (Subtype_For_Id, Access_To_Subtype_For_Id);

         function Allocate_Id
           (Pool : Bump_Ptr_Pool) return Bare_Id;

         function Allocate_Id
           (Pool : Bump_Ptr_Pool) return Bare_Id
         is
            Result      : constant Access_To_Subtype_For_Id := Bare_Id_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Id;
            return Bare_Id (Result);
         end Allocate_Id;

      package Bare_Def_Id_Memos is new Liblktlang_Support.Packrat
        (Bare_Def_Id, Token_Index);

         
         subtype Subtype_For_Def_Id is
            Root_Node_Record (Lkt_Def_Id);
         type Access_To_Subtype_For_Def_Id is access all Subtype_For_Def_Id;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Def_Id);
         package Bare_Def_Id_Alloc is new Alloc
           (Subtype_For_Def_Id, Access_To_Subtype_For_Def_Id);

         function Allocate_Def_Id
           (Pool : Bump_Ptr_Pool) return Bare_Def_Id;

         function Allocate_Def_Id
           (Pool : Bump_Ptr_Pool) return Bare_Def_Id
         is
            Result      : constant Access_To_Subtype_For_Def_Id := Bare_Def_Id_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Def_Id;
            return Bare_Def_Id (Result);
         end Allocate_Def_Id;

      package Bare_Module_Ref_Id_Memos is new Liblktlang_Support.Packrat
        (Bare_Module_Ref_Id, Token_Index);

         
         subtype Subtype_For_Module_Ref_Id is
            Root_Node_Record (Lkt_Module_Ref_Id);
         type Access_To_Subtype_For_Module_Ref_Id is access all Subtype_For_Module_Ref_Id;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Module_Ref_Id);
         package Bare_Module_Ref_Id_Alloc is new Alloc
           (Subtype_For_Module_Ref_Id, Access_To_Subtype_For_Module_Ref_Id);

         function Allocate_Module_Ref_Id
           (Pool : Bump_Ptr_Pool) return Bare_Module_Ref_Id;

         function Allocate_Module_Ref_Id
           (Pool : Bump_Ptr_Pool) return Bare_Module_Ref_Id
         is
            Result      : constant Access_To_Subtype_For_Module_Ref_Id := Bare_Module_Ref_Id_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Module_Ref_Id;
            return Bare_Module_Ref_Id (Result);
         end Allocate_Module_Ref_Id;

      package Bare_Ref_Id_Memos is new Liblktlang_Support.Packrat
        (Bare_Ref_Id, Token_Index);

         
         subtype Subtype_For_Ref_Id is
            Root_Node_Record (Lkt_Ref_Id);
         type Access_To_Subtype_For_Ref_Id is access all Subtype_For_Ref_Id;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Ref_Id);
         package Bare_Ref_Id_Alloc is new Alloc
           (Subtype_For_Ref_Id, Access_To_Subtype_For_Ref_Id);

         function Allocate_Ref_Id
           (Pool : Bump_Ptr_Pool) return Bare_Ref_Id;

         function Allocate_Ref_Id
           (Pool : Bump_Ptr_Pool) return Bare_Ref_Id
         is
            Result      : constant Access_To_Subtype_For_Ref_Id := Bare_Ref_Id_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Ref_Id;
            return Bare_Ref_Id (Result);
         end Allocate_Ref_Id;

      package Bare_If_Expr_Memos is new Liblktlang_Support.Packrat
        (Bare_If_Expr, Token_Index);

         
         subtype Subtype_For_If_Expr is
            Root_Node_Record (Lkt_If_Expr);
         type Access_To_Subtype_For_If_Expr is access all Subtype_For_If_Expr;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_If_Expr);
         package Bare_If_Expr_Alloc is new Alloc
           (Subtype_For_If_Expr, Access_To_Subtype_For_If_Expr);

         function Allocate_If_Expr
           (Pool : Bump_Ptr_Pool) return Bare_If_Expr;

         function Allocate_If_Expr
           (Pool : Bump_Ptr_Pool) return Bare_If_Expr
         is
            Result      : constant Access_To_Subtype_For_If_Expr := Bare_If_Expr_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_If_Expr;
            return Bare_If_Expr (Result);
         end Allocate_If_Expr;

      package Bare_Isa_Memos is new Liblktlang_Support.Packrat
        (Bare_Isa, Token_Index);

         
         subtype Subtype_For_Isa is
            Root_Node_Record (Lkt_Isa);
         type Access_To_Subtype_For_Isa is access all Subtype_For_Isa;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Isa);
         package Bare_Isa_Alloc is new Alloc
           (Subtype_For_Isa, Access_To_Subtype_For_Isa);

         function Allocate_Isa
           (Pool : Bump_Ptr_Pool) return Bare_Isa;

         function Allocate_Isa
           (Pool : Bump_Ptr_Pool) return Bare_Isa
         is
            Result      : constant Access_To_Subtype_For_Isa := Bare_Isa_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Isa;
            return Bare_Isa (Result);
         end Allocate_Isa;

      package Bare_Keep_Expr_Memos is new Liblktlang_Support.Packrat
        (Bare_Keep_Expr, Token_Index);

         
         subtype Subtype_For_Keep_Expr is
            Root_Node_Record (Lkt_Keep_Expr);
         type Access_To_Subtype_For_Keep_Expr is access all Subtype_For_Keep_Expr;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Keep_Expr);
         package Bare_Keep_Expr_Alloc is new Alloc
           (Subtype_For_Keep_Expr, Access_To_Subtype_For_Keep_Expr);

         function Allocate_Keep_Expr
           (Pool : Bump_Ptr_Pool) return Bare_Keep_Expr;

         function Allocate_Keep_Expr
           (Pool : Bump_Ptr_Pool) return Bare_Keep_Expr
         is
            Result      : constant Access_To_Subtype_For_Keep_Expr := Bare_Keep_Expr_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Keep_Expr;
            return Bare_Keep_Expr (Result);
         end Allocate_Keep_Expr;

      package Bare_Lambda_Expr_Memos is new Liblktlang_Support.Packrat
        (Bare_Lambda_Expr, Token_Index);

         
         subtype Subtype_For_Lambda_Expr is
            Root_Node_Record (Lkt_Lambda_Expr);
         type Access_To_Subtype_For_Lambda_Expr is access all Subtype_For_Lambda_Expr;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Lambda_Expr);
         package Bare_Lambda_Expr_Alloc is new Alloc
           (Subtype_For_Lambda_Expr, Access_To_Subtype_For_Lambda_Expr);

         function Allocate_Lambda_Expr
           (Pool : Bump_Ptr_Pool) return Bare_Lambda_Expr;

         function Allocate_Lambda_Expr
           (Pool : Bump_Ptr_Pool) return Bare_Lambda_Expr
         is
            Result      : constant Access_To_Subtype_For_Lambda_Expr := Bare_Lambda_Expr_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Lambda_Expr;
            return Bare_Lambda_Expr (Result);
         end Allocate_Lambda_Expr;

      package Bare_Lit_Memos is new Liblktlang_Support.Packrat
        (Bare_Lit, Token_Index);

      package Bare_Big_Num_Lit_Memos is new Liblktlang_Support.Packrat
        (Bare_Big_Num_Lit, Token_Index);

         
         subtype Subtype_For_Big_Num_Lit is
            Root_Node_Record (Lkt_Big_Num_Lit);
         type Access_To_Subtype_For_Big_Num_Lit is access all Subtype_For_Big_Num_Lit;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Big_Num_Lit);
         package Bare_Big_Num_Lit_Alloc is new Alloc
           (Subtype_For_Big_Num_Lit, Access_To_Subtype_For_Big_Num_Lit);

         function Allocate_Big_Num_Lit
           (Pool : Bump_Ptr_Pool) return Bare_Big_Num_Lit;

         function Allocate_Big_Num_Lit
           (Pool : Bump_Ptr_Pool) return Bare_Big_Num_Lit
         is
            Result      : constant Access_To_Subtype_For_Big_Num_Lit := Bare_Big_Num_Lit_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Big_Num_Lit;
            return Bare_Big_Num_Lit (Result);
         end Allocate_Big_Num_Lit;

      package Bare_Char_Lit_Memos is new Liblktlang_Support.Packrat
        (Bare_Char_Lit, Token_Index);

         
         subtype Subtype_For_Char_Lit is
            Root_Node_Record (Lkt_Char_Lit);
         type Access_To_Subtype_For_Char_Lit is access all Subtype_For_Char_Lit;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Char_Lit);
         package Bare_Char_Lit_Alloc is new Alloc
           (Subtype_For_Char_Lit, Access_To_Subtype_For_Char_Lit);

         function Allocate_Char_Lit
           (Pool : Bump_Ptr_Pool) return Bare_Char_Lit;

         function Allocate_Char_Lit
           (Pool : Bump_Ptr_Pool) return Bare_Char_Lit
         is
            Result      : constant Access_To_Subtype_For_Char_Lit := Bare_Char_Lit_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Char_Lit;
            return Bare_Char_Lit (Result);
         end Allocate_Char_Lit;

      package Bare_Null_Lit_Memos is new Liblktlang_Support.Packrat
        (Bare_Null_Lit, Token_Index);

         
         subtype Subtype_For_Null_Lit is
            Root_Node_Record (Lkt_Null_Lit);
         type Access_To_Subtype_For_Null_Lit is access all Subtype_For_Null_Lit;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Null_Lit);
         package Bare_Null_Lit_Alloc is new Alloc
           (Subtype_For_Null_Lit, Access_To_Subtype_For_Null_Lit);

         function Allocate_Null_Lit
           (Pool : Bump_Ptr_Pool) return Bare_Null_Lit;

         function Allocate_Null_Lit
           (Pool : Bump_Ptr_Pool) return Bare_Null_Lit
         is
            Result      : constant Access_To_Subtype_For_Null_Lit := Bare_Null_Lit_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Null_Lit;
            return Bare_Null_Lit (Result);
         end Allocate_Null_Lit;

      package Bare_Num_Lit_Memos is new Liblktlang_Support.Packrat
        (Bare_Num_Lit, Token_Index);

         
         subtype Subtype_For_Num_Lit is
            Root_Node_Record (Lkt_Num_Lit);
         type Access_To_Subtype_For_Num_Lit is access all Subtype_For_Num_Lit;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Num_Lit);
         package Bare_Num_Lit_Alloc is new Alloc
           (Subtype_For_Num_Lit, Access_To_Subtype_For_Num_Lit);

         function Allocate_Num_Lit
           (Pool : Bump_Ptr_Pool) return Bare_Num_Lit;

         function Allocate_Num_Lit
           (Pool : Bump_Ptr_Pool) return Bare_Num_Lit
         is
            Result      : constant Access_To_Subtype_For_Num_Lit := Bare_Num_Lit_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Num_Lit;
            return Bare_Num_Lit (Result);
         end Allocate_Num_Lit;

      package Bare_String_Lit_Memos is new Liblktlang_Support.Packrat
        (Bare_String_Lit, Token_Index);

      package Bare_Block_String_Lit_Memos is new Liblktlang_Support.Packrat
        (Bare_Block_String_Lit, Token_Index);

         
         subtype Subtype_For_Block_String_Lit is
            Root_Node_Record (Lkt_Block_String_Lit);
         type Access_To_Subtype_For_Block_String_Lit is access all Subtype_For_Block_String_Lit;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Block_String_Lit);
         package Bare_Block_String_Lit_Alloc is new Alloc
           (Subtype_For_Block_String_Lit, Access_To_Subtype_For_Block_String_Lit);

         function Allocate_Block_String_Lit
           (Pool : Bump_Ptr_Pool) return Bare_Block_String_Lit;

         function Allocate_Block_String_Lit
           (Pool : Bump_Ptr_Pool) return Bare_Block_String_Lit
         is
            Result      : constant Access_To_Subtype_For_Block_String_Lit := Bare_Block_String_Lit_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Block_String_Lit;
            return Bare_Block_String_Lit (Result);
         end Allocate_Block_String_Lit;

      package Bare_Single_Line_String_Lit_Memos is new Liblktlang_Support.Packrat
        (Bare_Single_Line_String_Lit, Token_Index);

         
         subtype Subtype_For_Single_Line_String_Lit is
            Root_Node_Record (Lkt_Single_Line_String_Lit);
         type Access_To_Subtype_For_Single_Line_String_Lit is access all Subtype_For_Single_Line_String_Lit;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Single_Line_String_Lit);
         package Bare_Single_Line_String_Lit_Alloc is new Alloc
           (Subtype_For_Single_Line_String_Lit, Access_To_Subtype_For_Single_Line_String_Lit);

         function Allocate_Single_Line_String_Lit
           (Pool : Bump_Ptr_Pool) return Bare_Single_Line_String_Lit;

         function Allocate_Single_Line_String_Lit
           (Pool : Bump_Ptr_Pool) return Bare_Single_Line_String_Lit
         is
            Result      : constant Access_To_Subtype_For_Single_Line_String_Lit := Bare_Single_Line_String_Lit_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Single_Line_String_Lit;
            return Bare_Single_Line_String_Lit (Result);
         end Allocate_Single_Line_String_Lit;

      package Bare_Pattern_Single_Line_String_Lit_Memos is new Liblktlang_Support.Packrat
        (Bare_Pattern_Single_Line_String_Lit, Token_Index);

         
         subtype Subtype_For_Pattern_Single_Line_String_Lit is
            Root_Node_Record (Lkt_Pattern_Single_Line_String_Lit);
         type Access_To_Subtype_For_Pattern_Single_Line_String_Lit is access all Subtype_For_Pattern_Single_Line_String_Lit;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Pattern_Single_Line_String_Lit);
         package Bare_Pattern_Single_Line_String_Lit_Alloc is new Alloc
           (Subtype_For_Pattern_Single_Line_String_Lit, Access_To_Subtype_For_Pattern_Single_Line_String_Lit);

         function Allocate_Pattern_Single_Line_String_Lit
           (Pool : Bump_Ptr_Pool) return Bare_Pattern_Single_Line_String_Lit;

         function Allocate_Pattern_Single_Line_String_Lit
           (Pool : Bump_Ptr_Pool) return Bare_Pattern_Single_Line_String_Lit
         is
            Result      : constant Access_To_Subtype_For_Pattern_Single_Line_String_Lit := Bare_Pattern_Single_Line_String_Lit_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Pattern_Single_Line_String_Lit;
            return Bare_Pattern_Single_Line_String_Lit (Result);
         end Allocate_Pattern_Single_Line_String_Lit;

      package Bare_Logic_Assign_Memos is new Liblktlang_Support.Packrat
        (Bare_Logic_Assign, Token_Index);

         
         subtype Subtype_For_Logic_Assign is
            Root_Node_Record (Lkt_Logic_Assign);
         type Access_To_Subtype_For_Logic_Assign is access all Subtype_For_Logic_Assign;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Logic_Assign);
         package Bare_Logic_Assign_Alloc is new Alloc
           (Subtype_For_Logic_Assign, Access_To_Subtype_For_Logic_Assign);

         function Allocate_Logic_Assign
           (Pool : Bump_Ptr_Pool) return Bare_Logic_Assign;

         function Allocate_Logic_Assign
           (Pool : Bump_Ptr_Pool) return Bare_Logic_Assign
         is
            Result      : constant Access_To_Subtype_For_Logic_Assign := Bare_Logic_Assign_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Logic_Assign;
            return Bare_Logic_Assign (Result);
         end Allocate_Logic_Assign;

      package Bare_Logic_Expr_Memos is new Liblktlang_Support.Packrat
        (Bare_Logic_Expr, Token_Index);

         
         subtype Subtype_For_Logic_Expr is
            Root_Node_Record (Lkt_Logic_Expr);
         type Access_To_Subtype_For_Logic_Expr is access all Subtype_For_Logic_Expr;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Logic_Expr);
         package Bare_Logic_Expr_Alloc is new Alloc
           (Subtype_For_Logic_Expr, Access_To_Subtype_For_Logic_Expr);

         function Allocate_Logic_Expr
           (Pool : Bump_Ptr_Pool) return Bare_Logic_Expr;

         function Allocate_Logic_Expr
           (Pool : Bump_Ptr_Pool) return Bare_Logic_Expr
         is
            Result      : constant Access_To_Subtype_For_Logic_Expr := Bare_Logic_Expr_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Logic_Expr;
            return Bare_Logic_Expr (Result);
         end Allocate_Logic_Expr;

      package Bare_Logic_Propagate_Memos is new Liblktlang_Support.Packrat
        (Bare_Logic_Propagate, Token_Index);

         
         subtype Subtype_For_Logic_Propagate is
            Root_Node_Record (Lkt_Logic_Propagate);
         type Access_To_Subtype_For_Logic_Propagate is access all Subtype_For_Logic_Propagate;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Logic_Propagate);
         package Bare_Logic_Propagate_Alloc is new Alloc
           (Subtype_For_Logic_Propagate, Access_To_Subtype_For_Logic_Propagate);

         function Allocate_Logic_Propagate
           (Pool : Bump_Ptr_Pool) return Bare_Logic_Propagate;

         function Allocate_Logic_Propagate
           (Pool : Bump_Ptr_Pool) return Bare_Logic_Propagate
         is
            Result      : constant Access_To_Subtype_For_Logic_Propagate := Bare_Logic_Propagate_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Logic_Propagate;
            return Bare_Logic_Propagate (Result);
         end Allocate_Logic_Propagate;

      package Bare_Logic_Unify_Memos is new Liblktlang_Support.Packrat
        (Bare_Logic_Unify, Token_Index);

         
         subtype Subtype_For_Logic_Unify is
            Root_Node_Record (Lkt_Logic_Unify);
         type Access_To_Subtype_For_Logic_Unify is access all Subtype_For_Logic_Unify;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Logic_Unify);
         package Bare_Logic_Unify_Alloc is new Alloc
           (Subtype_For_Logic_Unify, Access_To_Subtype_For_Logic_Unify);

         function Allocate_Logic_Unify
           (Pool : Bump_Ptr_Pool) return Bare_Logic_Unify;

         function Allocate_Logic_Unify
           (Pool : Bump_Ptr_Pool) return Bare_Logic_Unify
         is
            Result      : constant Access_To_Subtype_For_Logic_Unify := Bare_Logic_Unify_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Logic_Unify;
            return Bare_Logic_Unify (Result);
         end Allocate_Logic_Unify;

      package Bare_Match_Expr_Memos is new Liblktlang_Support.Packrat
        (Bare_Match_Expr, Token_Index);

         
         subtype Subtype_For_Match_Expr is
            Root_Node_Record (Lkt_Match_Expr);
         type Access_To_Subtype_For_Match_Expr is access all Subtype_For_Match_Expr;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Match_Expr);
         package Bare_Match_Expr_Alloc is new Alloc
           (Subtype_For_Match_Expr, Access_To_Subtype_For_Match_Expr);

         function Allocate_Match_Expr
           (Pool : Bump_Ptr_Pool) return Bare_Match_Expr;

         function Allocate_Match_Expr
           (Pool : Bump_Ptr_Pool) return Bare_Match_Expr
         is
            Result      : constant Access_To_Subtype_For_Match_Expr := Bare_Match_Expr_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Match_Expr;
            return Bare_Match_Expr (Result);
         end Allocate_Match_Expr;

      package Bare_Not_Expr_Memos is new Liblktlang_Support.Packrat
        (Bare_Not_Expr, Token_Index);

         
         subtype Subtype_For_Not_Expr is
            Root_Node_Record (Lkt_Not_Expr);
         type Access_To_Subtype_For_Not_Expr is access all Subtype_For_Not_Expr;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Not_Expr);
         package Bare_Not_Expr_Alloc is new Alloc
           (Subtype_For_Not_Expr, Access_To_Subtype_For_Not_Expr);

         function Allocate_Not_Expr
           (Pool : Bump_Ptr_Pool) return Bare_Not_Expr;

         function Allocate_Not_Expr
           (Pool : Bump_Ptr_Pool) return Bare_Not_Expr
         is
            Result      : constant Access_To_Subtype_For_Not_Expr := Bare_Not_Expr_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Not_Expr;
            return Bare_Not_Expr (Result);
         end Allocate_Not_Expr;

      package Bare_Paren_Expr_Memos is new Liblktlang_Support.Packrat
        (Bare_Paren_Expr, Token_Index);

         
         subtype Subtype_For_Paren_Expr is
            Root_Node_Record (Lkt_Paren_Expr);
         type Access_To_Subtype_For_Paren_Expr is access all Subtype_For_Paren_Expr;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Paren_Expr);
         package Bare_Paren_Expr_Alloc is new Alloc
           (Subtype_For_Paren_Expr, Access_To_Subtype_For_Paren_Expr);

         function Allocate_Paren_Expr
           (Pool : Bump_Ptr_Pool) return Bare_Paren_Expr;

         function Allocate_Paren_Expr
           (Pool : Bump_Ptr_Pool) return Bare_Paren_Expr
         is
            Result      : constant Access_To_Subtype_For_Paren_Expr := Bare_Paren_Expr_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Paren_Expr;
            return Bare_Paren_Expr (Result);
         end Allocate_Paren_Expr;

      package Bare_Raise_Expr_Memos is new Liblktlang_Support.Packrat
        (Bare_Raise_Expr, Token_Index);

         
         subtype Subtype_For_Raise_Expr is
            Root_Node_Record (Lkt_Raise_Expr);
         type Access_To_Subtype_For_Raise_Expr is access all Subtype_For_Raise_Expr;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Raise_Expr);
         package Bare_Raise_Expr_Alloc is new Alloc
           (Subtype_For_Raise_Expr, Access_To_Subtype_For_Raise_Expr);

         function Allocate_Raise_Expr
           (Pool : Bump_Ptr_Pool) return Bare_Raise_Expr;

         function Allocate_Raise_Expr
           (Pool : Bump_Ptr_Pool) return Bare_Raise_Expr
         is
            Result      : constant Access_To_Subtype_For_Raise_Expr := Bare_Raise_Expr_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Raise_Expr;
            return Bare_Raise_Expr (Result);
         end Allocate_Raise_Expr;

      package Bare_Subscript_Expr_Memos is new Liblktlang_Support.Packrat
        (Bare_Subscript_Expr, Token_Index);

         
         subtype Subtype_For_Subscript_Expr is
            Root_Node_Record (Lkt_Subscript_Expr);
         type Access_To_Subtype_For_Subscript_Expr is access all Subtype_For_Subscript_Expr;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Subscript_Expr);
         package Bare_Subscript_Expr_Alloc is new Alloc
           (Subtype_For_Subscript_Expr, Access_To_Subtype_For_Subscript_Expr);

         function Allocate_Subscript_Expr
           (Pool : Bump_Ptr_Pool) return Bare_Subscript_Expr;

         function Allocate_Subscript_Expr
           (Pool : Bump_Ptr_Pool) return Bare_Subscript_Expr
         is
            Result      : constant Access_To_Subtype_For_Subscript_Expr := Bare_Subscript_Expr_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Subscript_Expr;
            return Bare_Subscript_Expr (Result);
         end Allocate_Subscript_Expr;

      package Bare_Try_Expr_Memos is new Liblktlang_Support.Packrat
        (Bare_Try_Expr, Token_Index);

         
         subtype Subtype_For_Try_Expr is
            Root_Node_Record (Lkt_Try_Expr);
         type Access_To_Subtype_For_Try_Expr is access all Subtype_For_Try_Expr;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Try_Expr);
         package Bare_Try_Expr_Alloc is new Alloc
           (Subtype_For_Try_Expr, Access_To_Subtype_For_Try_Expr);

         function Allocate_Try_Expr
           (Pool : Bump_Ptr_Pool) return Bare_Try_Expr;

         function Allocate_Try_Expr
           (Pool : Bump_Ptr_Pool) return Bare_Try_Expr
         is
            Result      : constant Access_To_Subtype_For_Try_Expr := Bare_Try_Expr_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Try_Expr;
            return Bare_Try_Expr (Result);
         end Allocate_Try_Expr;

      package Bare_Un_Op_Memos is new Liblktlang_Support.Packrat
        (Bare_Un_Op, Token_Index);

         
         subtype Subtype_For_Un_Op is
            Root_Node_Record (Lkt_Un_Op);
         type Access_To_Subtype_For_Un_Op is access all Subtype_For_Un_Op;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Un_Op);
         package Bare_Un_Op_Alloc is new Alloc
           (Subtype_For_Un_Op, Access_To_Subtype_For_Un_Op);

         function Allocate_Un_Op
           (Pool : Bump_Ptr_Pool) return Bare_Un_Op;

         function Allocate_Un_Op
           (Pool : Bump_Ptr_Pool) return Bare_Un_Op
         is
            Result      : constant Access_To_Subtype_For_Un_Op := Bare_Un_Op_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Un_Op;
            return Bare_Un_Op (Result);
         end Allocate_Un_Op;

      package Bare_Full_Decl_Memos is new Liblktlang_Support.Packrat
        (Bare_Full_Decl, Token_Index);

         
         subtype Subtype_For_Full_Decl is
            Root_Node_Record (Lkt_Full_Decl);
         type Access_To_Subtype_For_Full_Decl is access all Subtype_For_Full_Decl;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Full_Decl);
         package Bare_Full_Decl_Alloc is new Alloc
           (Subtype_For_Full_Decl, Access_To_Subtype_For_Full_Decl);

         function Allocate_Full_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Full_Decl;

         function Allocate_Full_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Full_Decl
         is
            Result      : constant Access_To_Subtype_For_Full_Decl := Bare_Full_Decl_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Full_Decl;
            return Bare_Full_Decl (Result);
         end Allocate_Full_Decl;

      package Bare_Grammar_List_Sep_Memos is new Liblktlang_Support.Packrat
        (Bare_Grammar_List_Sep, Token_Index);

         
         subtype Subtype_For_Grammar_List_Sep is
            Root_Node_Record (Lkt_Grammar_List_Sep);
         type Access_To_Subtype_For_Grammar_List_Sep is access all Subtype_For_Grammar_List_Sep;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Grammar_List_Sep);
         package Bare_Grammar_List_Sep_Alloc is new Alloc
           (Subtype_For_Grammar_List_Sep, Access_To_Subtype_For_Grammar_List_Sep);

         function Allocate_Grammar_List_Sep
           (Pool : Bump_Ptr_Pool) return Bare_Grammar_List_Sep;

         function Allocate_Grammar_List_Sep
           (Pool : Bump_Ptr_Pool) return Bare_Grammar_List_Sep
         is
            Result      : constant Access_To_Subtype_For_Grammar_List_Sep := Bare_Grammar_List_Sep_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Grammar_List_Sep;
            return Bare_Grammar_List_Sep (Result);
         end Allocate_Grammar_List_Sep;

      package Bare_Import_Memos is new Liblktlang_Support.Packrat
        (Bare_Import, Token_Index);

         
         subtype Subtype_For_Import is
            Root_Node_Record (Lkt_Import);
         type Access_To_Subtype_For_Import is access all Subtype_For_Import;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Import);
         package Bare_Import_Alloc is new Alloc
           (Subtype_For_Import, Access_To_Subtype_For_Import);

         function Allocate_Import
           (Pool : Bump_Ptr_Pool) return Bare_Import;

         function Allocate_Import
           (Pool : Bump_Ptr_Pool) return Bare_Import
         is
            Result      : constant Access_To_Subtype_For_Import := Bare_Import_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Import;
            return Bare_Import (Result);
         end Allocate_Import;

      package Bare_Langkit_Root_Memos is new Liblktlang_Support.Packrat
        (Bare_Langkit_Root, Token_Index);

         
         subtype Subtype_For_Langkit_Root is
            Root_Node_Record (Lkt_Langkit_Root);
         type Access_To_Subtype_For_Langkit_Root is access all Subtype_For_Langkit_Root;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Langkit_Root);
         package Bare_Langkit_Root_Alloc is new Alloc
           (Subtype_For_Langkit_Root, Access_To_Subtype_For_Langkit_Root);

         function Allocate_Langkit_Root
           (Pool : Bump_Ptr_Pool) return Bare_Langkit_Root;

         function Allocate_Langkit_Root
           (Pool : Bump_Ptr_Pool) return Bare_Langkit_Root
         is
            Result      : constant Access_To_Subtype_For_Langkit_Root := Bare_Langkit_Root_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Langkit_Root;
            return Bare_Langkit_Root (Result);
         end Allocate_Langkit_Root;

      package Bare_Lexer_Case_Rule_Memos is new Liblktlang_Support.Packrat
        (Bare_Lexer_Case_Rule, Token_Index);

         
         subtype Subtype_For_Lexer_Case_Rule is
            Root_Node_Record (Lkt_Lexer_Case_Rule);
         type Access_To_Subtype_For_Lexer_Case_Rule is access all Subtype_For_Lexer_Case_Rule;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Lexer_Case_Rule);
         package Bare_Lexer_Case_Rule_Alloc is new Alloc
           (Subtype_For_Lexer_Case_Rule, Access_To_Subtype_For_Lexer_Case_Rule);

         function Allocate_Lexer_Case_Rule
           (Pool : Bump_Ptr_Pool) return Bare_Lexer_Case_Rule;

         function Allocate_Lexer_Case_Rule
           (Pool : Bump_Ptr_Pool) return Bare_Lexer_Case_Rule
         is
            Result      : constant Access_To_Subtype_For_Lexer_Case_Rule := Bare_Lexer_Case_Rule_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Lexer_Case_Rule;
            return Bare_Lexer_Case_Rule (Result);
         end Allocate_Lexer_Case_Rule;

      package Bare_Lexer_Case_Rule_Send_Memos is new Liblktlang_Support.Packrat
        (Bare_Lexer_Case_Rule_Send, Token_Index);

         
         subtype Subtype_For_Lexer_Case_Rule_Send is
            Root_Node_Record (Lkt_Lexer_Case_Rule_Send);
         type Access_To_Subtype_For_Lexer_Case_Rule_Send is access all Subtype_For_Lexer_Case_Rule_Send;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Lexer_Case_Rule_Send);
         package Bare_Lexer_Case_Rule_Send_Alloc is new Alloc
           (Subtype_For_Lexer_Case_Rule_Send, Access_To_Subtype_For_Lexer_Case_Rule_Send);

         function Allocate_Lexer_Case_Rule_Send
           (Pool : Bump_Ptr_Pool) return Bare_Lexer_Case_Rule_Send;

         function Allocate_Lexer_Case_Rule_Send
           (Pool : Bump_Ptr_Pool) return Bare_Lexer_Case_Rule_Send
         is
            Result      : constant Access_To_Subtype_For_Lexer_Case_Rule_Send := Bare_Lexer_Case_Rule_Send_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Lexer_Case_Rule_Send;
            return Bare_Lexer_Case_Rule_Send (Result);
         end Allocate_Lexer_Case_Rule_Send;

      package Bare_List_Kind_Memos is new Liblktlang_Support.Packrat
        (Bare_List_Kind, Token_Index);

      package Bare_List_Kind_One_Memos is new Liblktlang_Support.Packrat
        (Bare_List_Kind_One, Token_Index);

         
         subtype Subtype_For_List_Kind_One is
            Root_Node_Record (Lkt_List_Kind_One);
         type Access_To_Subtype_For_List_Kind_One is access all Subtype_For_List_Kind_One;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_List_Kind_One);
         package Bare_List_Kind_One_Alloc is new Alloc
           (Subtype_For_List_Kind_One, Access_To_Subtype_For_List_Kind_One);

         function Allocate_List_Kind_One
           (Pool : Bump_Ptr_Pool) return Bare_List_Kind_One;

         function Allocate_List_Kind_One
           (Pool : Bump_Ptr_Pool) return Bare_List_Kind_One
         is
            Result      : constant Access_To_Subtype_For_List_Kind_One := Bare_List_Kind_One_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_List_Kind_One;
            return Bare_List_Kind_One (Result);
         end Allocate_List_Kind_One;

      package Bare_List_Kind_Zero_Memos is new Liblktlang_Support.Packrat
        (Bare_List_Kind_Zero, Token_Index);

         
         subtype Subtype_For_List_Kind_Zero is
            Root_Node_Record (Lkt_List_Kind_Zero);
         type Access_To_Subtype_For_List_Kind_Zero is access all Subtype_For_List_Kind_Zero;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_List_Kind_Zero);
         package Bare_List_Kind_Zero_Alloc is new Alloc
           (Subtype_For_List_Kind_Zero, Access_To_Subtype_For_List_Kind_Zero);

         function Allocate_List_Kind_Zero
           (Pool : Bump_Ptr_Pool) return Bare_List_Kind_Zero;

         function Allocate_List_Kind_Zero
           (Pool : Bump_Ptr_Pool) return Bare_List_Kind_Zero
         is
            Result      : constant Access_To_Subtype_For_List_Kind_Zero := Bare_List_Kind_Zero_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_List_Kind_Zero;
            return Bare_List_Kind_Zero (Result);
         end Allocate_List_Kind_Zero;

      package Bare_Lkt_Node_Base_List_Memos is new Liblktlang_Support.Packrat
        (Bare_Lkt_Node_Base_List, Token_Index);

      package Bare_Argument_List_Memos is new Liblktlang_Support.Packrat
        (Bare_Argument_List, Token_Index);

         
         subtype Subtype_For_Argument_List is
            Root_Node_Record (Lkt_Argument_List);
         type Access_To_Subtype_For_Argument_List is access all Subtype_For_Argument_List;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Argument_List);
         package Bare_Argument_List_Alloc is new Alloc
           (Subtype_For_Argument_List, Access_To_Subtype_For_Argument_List);

         function Allocate_Argument_List
           (Pool : Bump_Ptr_Pool) return Bare_Argument_List;

         function Allocate_Argument_List
           (Pool : Bump_Ptr_Pool) return Bare_Argument_List
         is
            Result      : constant Access_To_Subtype_For_Argument_List := Bare_Argument_List_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Argument_List;
            return Bare_Argument_List (Result);
         end Allocate_Argument_List;

      package Bare_Base_Lexer_Case_Rule_Alt_List_Memos is new Liblktlang_Support.Packrat
        (Bare_Base_Lexer_Case_Rule_Alt_List, Token_Index);

         
         subtype Subtype_For_Base_Lexer_Case_Rule_Alt_List is
            Root_Node_Record (Lkt_Base_Lexer_Case_Rule_Alt_List);
         type Access_To_Subtype_For_Base_Lexer_Case_Rule_Alt_List is access all Subtype_For_Base_Lexer_Case_Rule_Alt_List;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Base_Lexer_Case_Rule_Alt_List);
         package Bare_Base_Lexer_Case_Rule_Alt_List_Alloc is new Alloc
           (Subtype_For_Base_Lexer_Case_Rule_Alt_List, Access_To_Subtype_For_Base_Lexer_Case_Rule_Alt_List);

         function Allocate_Base_Lexer_Case_Rule_Alt_List
           (Pool : Bump_Ptr_Pool) return Bare_Base_Lexer_Case_Rule_Alt_List;

         function Allocate_Base_Lexer_Case_Rule_Alt_List
           (Pool : Bump_Ptr_Pool) return Bare_Base_Lexer_Case_Rule_Alt_List
         is
            Result      : constant Access_To_Subtype_For_Base_Lexer_Case_Rule_Alt_List := Bare_Base_Lexer_Case_Rule_Alt_List_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Base_Lexer_Case_Rule_Alt_List;
            return Bare_Base_Lexer_Case_Rule_Alt_List (Result);
         end Allocate_Base_Lexer_Case_Rule_Alt_List;

      package Bare_Base_Match_Branch_List_Memos is new Liblktlang_Support.Packrat
        (Bare_Base_Match_Branch_List, Token_Index);

         
         subtype Subtype_For_Base_Match_Branch_List is
            Root_Node_Record (Lkt_Base_Match_Branch_List);
         type Access_To_Subtype_For_Base_Match_Branch_List is access all Subtype_For_Base_Match_Branch_List;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Base_Match_Branch_List);
         package Bare_Base_Match_Branch_List_Alloc is new Alloc
           (Subtype_For_Base_Match_Branch_List, Access_To_Subtype_For_Base_Match_Branch_List);

         function Allocate_Base_Match_Branch_List
           (Pool : Bump_Ptr_Pool) return Bare_Base_Match_Branch_List;

         function Allocate_Base_Match_Branch_List
           (Pool : Bump_Ptr_Pool) return Bare_Base_Match_Branch_List
         is
            Result      : constant Access_To_Subtype_For_Base_Match_Branch_List := Bare_Base_Match_Branch_List_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Base_Match_Branch_List;
            return Bare_Base_Match_Branch_List (Result);
         end Allocate_Base_Match_Branch_List;

      package Bare_Block_String_Line_List_Memos is new Liblktlang_Support.Packrat
        (Bare_Block_String_Line_List, Token_Index);

         
         subtype Subtype_For_Block_String_Line_List is
            Root_Node_Record (Lkt_Block_String_Line_List);
         type Access_To_Subtype_For_Block_String_Line_List is access all Subtype_For_Block_String_Line_List;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Block_String_Line_List);
         package Bare_Block_String_Line_List_Alloc is new Alloc
           (Subtype_For_Block_String_Line_List, Access_To_Subtype_For_Block_String_Line_List);

         function Allocate_Block_String_Line_List
           (Pool : Bump_Ptr_Pool) return Bare_Block_String_Line_List;

         function Allocate_Block_String_Line_List
           (Pool : Bump_Ptr_Pool) return Bare_Block_String_Line_List
         is
            Result      : constant Access_To_Subtype_For_Block_String_Line_List := Bare_Block_String_Line_List_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Block_String_Line_List;
            return Bare_Block_String_Line_List (Result);
         end Allocate_Block_String_Line_List;

      package Bare_Call_Expr_List_Memos is new Liblktlang_Support.Packrat
        (Bare_Call_Expr_List, Token_Index);

         
         subtype Subtype_For_Call_Expr_List is
            Root_Node_Record (Lkt_Call_Expr_List);
         type Access_To_Subtype_For_Call_Expr_List is access all Subtype_For_Call_Expr_List;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Call_Expr_List);
         package Bare_Call_Expr_List_Alloc is new Alloc
           (Subtype_For_Call_Expr_List, Access_To_Subtype_For_Call_Expr_List);

         function Allocate_Call_Expr_List
           (Pool : Bump_Ptr_Pool) return Bare_Call_Expr_List;

         function Allocate_Call_Expr_List
           (Pool : Bump_Ptr_Pool) return Bare_Call_Expr_List
         is
            Result      : constant Access_To_Subtype_For_Call_Expr_List := Bare_Call_Expr_List_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Call_Expr_List;
            return Bare_Call_Expr_List (Result);
         end Allocate_Call_Expr_List;

      package Bare_Decl_Annotation_List_Memos is new Liblktlang_Support.Packrat
        (Bare_Decl_Annotation_List, Token_Index);

         
         subtype Subtype_For_Decl_Annotation_List is
            Root_Node_Record (Lkt_Decl_Annotation_List);
         type Access_To_Subtype_For_Decl_Annotation_List is access all Subtype_For_Decl_Annotation_List;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Decl_Annotation_List);
         package Bare_Decl_Annotation_List_Alloc is new Alloc
           (Subtype_For_Decl_Annotation_List, Access_To_Subtype_For_Decl_Annotation_List);

         function Allocate_Decl_Annotation_List
           (Pool : Bump_Ptr_Pool) return Bare_Decl_Annotation_List;

         function Allocate_Decl_Annotation_List
           (Pool : Bump_Ptr_Pool) return Bare_Decl_Annotation_List
         is
            Result      : constant Access_To_Subtype_For_Decl_Annotation_List := Bare_Decl_Annotation_List_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Decl_Annotation_List;
            return Bare_Decl_Annotation_List (Result);
         end Allocate_Decl_Annotation_List;

      package Bare_Elsif_Branch_List_Memos is new Liblktlang_Support.Packrat
        (Bare_Elsif_Branch_List, Token_Index);

         
         subtype Subtype_For_Elsif_Branch_List is
            Root_Node_Record (Lkt_Elsif_Branch_List);
         type Access_To_Subtype_For_Elsif_Branch_List is access all Subtype_For_Elsif_Branch_List;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Elsif_Branch_List);
         package Bare_Elsif_Branch_List_Alloc is new Alloc
           (Subtype_For_Elsif_Branch_List, Access_To_Subtype_For_Elsif_Branch_List);

         function Allocate_Elsif_Branch_List
           (Pool : Bump_Ptr_Pool) return Bare_Elsif_Branch_List;

         function Allocate_Elsif_Branch_List
           (Pool : Bump_Ptr_Pool) return Bare_Elsif_Branch_List
         is
            Result      : constant Access_To_Subtype_For_Elsif_Branch_List := Bare_Elsif_Branch_List_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Elsif_Branch_List;
            return Bare_Elsif_Branch_List (Result);
         end Allocate_Elsif_Branch_List;

      package Bare_Enum_Class_Alt_Decl_List_Memos is new Liblktlang_Support.Packrat
        (Bare_Enum_Class_Alt_Decl_List, Token_Index);

         
         subtype Subtype_For_Enum_Class_Alt_Decl_List is
            Root_Node_Record (Lkt_Enum_Class_Alt_Decl_List);
         type Access_To_Subtype_For_Enum_Class_Alt_Decl_List is access all Subtype_For_Enum_Class_Alt_Decl_List;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Enum_Class_Alt_Decl_List);
         package Bare_Enum_Class_Alt_Decl_List_Alloc is new Alloc
           (Subtype_For_Enum_Class_Alt_Decl_List, Access_To_Subtype_For_Enum_Class_Alt_Decl_List);

         function Allocate_Enum_Class_Alt_Decl_List
           (Pool : Bump_Ptr_Pool) return Bare_Enum_Class_Alt_Decl_List;

         function Allocate_Enum_Class_Alt_Decl_List
           (Pool : Bump_Ptr_Pool) return Bare_Enum_Class_Alt_Decl_List
         is
            Result      : constant Access_To_Subtype_For_Enum_Class_Alt_Decl_List := Bare_Enum_Class_Alt_Decl_List_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Enum_Class_Alt_Decl_List;
            return Bare_Enum_Class_Alt_Decl_List (Result);
         end Allocate_Enum_Class_Alt_Decl_List;

      package Bare_Enum_Class_Case_List_Memos is new Liblktlang_Support.Packrat
        (Bare_Enum_Class_Case_List, Token_Index);

         
         subtype Subtype_For_Enum_Class_Case_List is
            Root_Node_Record (Lkt_Enum_Class_Case_List);
         type Access_To_Subtype_For_Enum_Class_Case_List is access all Subtype_For_Enum_Class_Case_List;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Enum_Class_Case_List);
         package Bare_Enum_Class_Case_List_Alloc is new Alloc
           (Subtype_For_Enum_Class_Case_List, Access_To_Subtype_For_Enum_Class_Case_List);

         function Allocate_Enum_Class_Case_List
           (Pool : Bump_Ptr_Pool) return Bare_Enum_Class_Case_List;

         function Allocate_Enum_Class_Case_List
           (Pool : Bump_Ptr_Pool) return Bare_Enum_Class_Case_List
         is
            Result      : constant Access_To_Subtype_For_Enum_Class_Case_List := Bare_Enum_Class_Case_List_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Enum_Class_Case_List;
            return Bare_Enum_Class_Case_List (Result);
         end Allocate_Enum_Class_Case_List;

      package Bare_Enum_Lit_Decl_List_Memos is new Liblktlang_Support.Packrat
        (Bare_Enum_Lit_Decl_List, Token_Index);

         
         subtype Subtype_For_Enum_Lit_Decl_List is
            Root_Node_Record (Lkt_Enum_Lit_Decl_List);
         type Access_To_Subtype_For_Enum_Lit_Decl_List is access all Subtype_For_Enum_Lit_Decl_List;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Enum_Lit_Decl_List);
         package Bare_Enum_Lit_Decl_List_Alloc is new Alloc
           (Subtype_For_Enum_Lit_Decl_List, Access_To_Subtype_For_Enum_Lit_Decl_List);

         function Allocate_Enum_Lit_Decl_List
           (Pool : Bump_Ptr_Pool) return Bare_Enum_Lit_Decl_List;

         function Allocate_Enum_Lit_Decl_List
           (Pool : Bump_Ptr_Pool) return Bare_Enum_Lit_Decl_List
         is
            Result      : constant Access_To_Subtype_For_Enum_Lit_Decl_List := Bare_Enum_Lit_Decl_List_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Enum_Lit_Decl_List;
            return Bare_Enum_Lit_Decl_List (Result);
         end Allocate_Enum_Lit_Decl_List;

      package Bare_Expr_List_Memos is new Liblktlang_Support.Packrat
        (Bare_Expr_List, Token_Index);

         
         subtype Subtype_For_Expr_List is
            Root_Node_Record (Lkt_Expr_List);
         type Access_To_Subtype_For_Expr_List is access all Subtype_For_Expr_List;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Expr_List);
         package Bare_Expr_List_Alloc is new Alloc
           (Subtype_For_Expr_List, Access_To_Subtype_For_Expr_List);

         function Allocate_Expr_List
           (Pool : Bump_Ptr_Pool) return Bare_Expr_List;

         function Allocate_Expr_List
           (Pool : Bump_Ptr_Pool) return Bare_Expr_List
         is
            Result      : constant Access_To_Subtype_For_Expr_List := Bare_Expr_List_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Expr_List;
            return Bare_Expr_List (Result);
         end Allocate_Expr_List;

      package Bare_Any_Of_List_Memos is new Liblktlang_Support.Packrat
        (Bare_Any_Of_List, Token_Index);

         
         subtype Subtype_For_Any_Of_List is
            Root_Node_Record (Lkt_Any_Of_List);
         type Access_To_Subtype_For_Any_Of_List is access all Subtype_For_Any_Of_List;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Any_Of_List);
         package Bare_Any_Of_List_Alloc is new Alloc
           (Subtype_For_Any_Of_List, Access_To_Subtype_For_Any_Of_List);

         function Allocate_Any_Of_List
           (Pool : Bump_Ptr_Pool) return Bare_Any_Of_List;

         function Allocate_Any_Of_List
           (Pool : Bump_Ptr_Pool) return Bare_Any_Of_List
         is
            Result      : constant Access_To_Subtype_For_Any_Of_List := Bare_Any_Of_List_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Any_Of_List;
            return Bare_Any_Of_List (Result);
         end Allocate_Any_Of_List;

      package Bare_Full_Decl_List_Memos is new Liblktlang_Support.Packrat
        (Bare_Full_Decl_List, Token_Index);

         
         subtype Subtype_For_Full_Decl_List is
            Root_Node_Record (Lkt_Full_Decl_List);
         type Access_To_Subtype_For_Full_Decl_List is access all Subtype_For_Full_Decl_List;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Full_Decl_List);
         package Bare_Full_Decl_List_Alloc is new Alloc
           (Subtype_For_Full_Decl_List, Access_To_Subtype_For_Full_Decl_List);

         function Allocate_Full_Decl_List
           (Pool : Bump_Ptr_Pool) return Bare_Full_Decl_List;

         function Allocate_Full_Decl_List
           (Pool : Bump_Ptr_Pool) return Bare_Full_Decl_List
         is
            Result      : constant Access_To_Subtype_For_Full_Decl_List := Bare_Full_Decl_List_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Full_Decl_List;
            return Bare_Full_Decl_List (Result);
         end Allocate_Full_Decl_List;

      package Bare_Decl_Block_Memos is new Liblktlang_Support.Packrat
        (Bare_Decl_Block, Token_Index);

         
         subtype Subtype_For_Decl_Block is
            Root_Node_Record (Lkt_Decl_Block);
         type Access_To_Subtype_For_Decl_Block is access all Subtype_For_Decl_Block;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Decl_Block);
         package Bare_Decl_Block_Alloc is new Alloc
           (Subtype_For_Decl_Block, Access_To_Subtype_For_Decl_Block);

         function Allocate_Decl_Block
           (Pool : Bump_Ptr_Pool) return Bare_Decl_Block;

         function Allocate_Decl_Block
           (Pool : Bump_Ptr_Pool) return Bare_Decl_Block
         is
            Result      : constant Access_To_Subtype_For_Decl_Block := Bare_Decl_Block_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Decl_Block;
            return Bare_Decl_Block (Result);
         end Allocate_Decl_Block;

      package Bare_Generic_Param_Decl_List_Memos is new Liblktlang_Support.Packrat
        (Bare_Generic_Param_Decl_List, Token_Index);

         
         subtype Subtype_For_Generic_Param_Decl_List is
            Root_Node_Record (Lkt_Generic_Param_Decl_List);
         type Access_To_Subtype_For_Generic_Param_Decl_List is access all Subtype_For_Generic_Param_Decl_List;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Generic_Param_Decl_List);
         package Bare_Generic_Param_Decl_List_Alloc is new Alloc
           (Subtype_For_Generic_Param_Decl_List, Access_To_Subtype_For_Generic_Param_Decl_List);

         function Allocate_Generic_Param_Decl_List
           (Pool : Bump_Ptr_Pool) return Bare_Generic_Param_Decl_List;

         function Allocate_Generic_Param_Decl_List
           (Pool : Bump_Ptr_Pool) return Bare_Generic_Param_Decl_List
         is
            Result      : constant Access_To_Subtype_For_Generic_Param_Decl_List := Bare_Generic_Param_Decl_List_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Generic_Param_Decl_List;
            return Bare_Generic_Param_Decl_List (Result);
         end Allocate_Generic_Param_Decl_List;

      package Bare_Fun_Param_Decl_List_Memos is new Liblktlang_Support.Packrat
        (Bare_Fun_Param_Decl_List, Token_Index);

         
         subtype Subtype_For_Fun_Param_Decl_List is
            Root_Node_Record (Lkt_Fun_Param_Decl_List);
         type Access_To_Subtype_For_Fun_Param_Decl_List is access all Subtype_For_Fun_Param_Decl_List;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Fun_Param_Decl_List);
         package Bare_Fun_Param_Decl_List_Alloc is new Alloc
           (Subtype_For_Fun_Param_Decl_List, Access_To_Subtype_For_Fun_Param_Decl_List);

         function Allocate_Fun_Param_Decl_List
           (Pool : Bump_Ptr_Pool) return Bare_Fun_Param_Decl_List;

         function Allocate_Fun_Param_Decl_List
           (Pool : Bump_Ptr_Pool) return Bare_Fun_Param_Decl_List
         is
            Result      : constant Access_To_Subtype_For_Fun_Param_Decl_List := Bare_Fun_Param_Decl_List_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Fun_Param_Decl_List;
            return Bare_Fun_Param_Decl_List (Result);
         end Allocate_Fun_Param_Decl_List;

      package Bare_Grammar_Expr_List_Memos is new Liblktlang_Support.Packrat
        (Bare_Grammar_Expr_List, Token_Index);

         
         subtype Subtype_For_Grammar_Expr_List is
            Root_Node_Record (Lkt_Grammar_Expr_List);
         type Access_To_Subtype_For_Grammar_Expr_List is access all Subtype_For_Grammar_Expr_List;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Grammar_Expr_List);
         package Bare_Grammar_Expr_List_Alloc is new Alloc
           (Subtype_For_Grammar_Expr_List, Access_To_Subtype_For_Grammar_Expr_List);

         function Allocate_Grammar_Expr_List
           (Pool : Bump_Ptr_Pool) return Bare_Grammar_Expr_List;

         function Allocate_Grammar_Expr_List
           (Pool : Bump_Ptr_Pool) return Bare_Grammar_Expr_List
         is
            Result      : constant Access_To_Subtype_For_Grammar_Expr_List := Bare_Grammar_Expr_List_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Grammar_Expr_List;
            return Bare_Grammar_Expr_List (Result);
         end Allocate_Grammar_Expr_List;

      package Bare_Grammar_Expr_List_List_Memos is new Liblktlang_Support.Packrat
        (Bare_Grammar_Expr_List_List, Token_Index);

         
         subtype Subtype_For_Grammar_Expr_List_List is
            Root_Node_Record (Lkt_Grammar_Expr_List_List);
         type Access_To_Subtype_For_Grammar_Expr_List_List is access all Subtype_For_Grammar_Expr_List_List;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Grammar_Expr_List_List);
         package Bare_Grammar_Expr_List_List_Alloc is new Alloc
           (Subtype_For_Grammar_Expr_List_List, Access_To_Subtype_For_Grammar_Expr_List_List);

         function Allocate_Grammar_Expr_List_List
           (Pool : Bump_Ptr_Pool) return Bare_Grammar_Expr_List_List;

         function Allocate_Grammar_Expr_List_List
           (Pool : Bump_Ptr_Pool) return Bare_Grammar_Expr_List_List
         is
            Result      : constant Access_To_Subtype_For_Grammar_Expr_List_List := Bare_Grammar_Expr_List_List_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Grammar_Expr_List_List;
            return Bare_Grammar_Expr_List_List (Result);
         end Allocate_Grammar_Expr_List_List;

      package Bare_Import_List_Memos is new Liblktlang_Support.Packrat
        (Bare_Import_List, Token_Index);

         
         subtype Subtype_For_Import_List is
            Root_Node_Record (Lkt_Import_List);
         type Access_To_Subtype_For_Import_List is access all Subtype_For_Import_List;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Import_List);
         package Bare_Import_List_Alloc is new Alloc
           (Subtype_For_Import_List, Access_To_Subtype_For_Import_List);

         function Allocate_Import_List
           (Pool : Bump_Ptr_Pool) return Bare_Import_List;

         function Allocate_Import_List
           (Pool : Bump_Ptr_Pool) return Bare_Import_List
         is
            Result      : constant Access_To_Subtype_For_Import_List := Bare_Import_List_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Import_List;
            return Bare_Import_List (Result);
         end Allocate_Import_List;

      package Bare_Lambda_Param_Decl_List_Memos is new Liblktlang_Support.Packrat
        (Bare_Lambda_Param_Decl_List, Token_Index);

         
         subtype Subtype_For_Lambda_Param_Decl_List is
            Root_Node_Record (Lkt_Lambda_Param_Decl_List);
         type Access_To_Subtype_For_Lambda_Param_Decl_List is access all Subtype_For_Lambda_Param_Decl_List;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Lambda_Param_Decl_List);
         package Bare_Lambda_Param_Decl_List_Alloc is new Alloc
           (Subtype_For_Lambda_Param_Decl_List, Access_To_Subtype_For_Lambda_Param_Decl_List);

         function Allocate_Lambda_Param_Decl_List
           (Pool : Bump_Ptr_Pool) return Bare_Lambda_Param_Decl_List;

         function Allocate_Lambda_Param_Decl_List
           (Pool : Bump_Ptr_Pool) return Bare_Lambda_Param_Decl_List
         is
            Result      : constant Access_To_Subtype_For_Lambda_Param_Decl_List := Bare_Lambda_Param_Decl_List_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Lambda_Param_Decl_List;
            return Bare_Lambda_Param_Decl_List (Result);
         end Allocate_Lambda_Param_Decl_List;

      package Bare_Lkt_Node_List_Memos is new Liblktlang_Support.Packrat
        (Bare_Lkt_Node_List, Token_Index);

         
         subtype Subtype_For_Lkt_Node_List is
            Root_Node_Record (Lkt_Lkt_Node_List);
         type Access_To_Subtype_For_Lkt_Node_List is access all Subtype_For_Lkt_Node_List;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Lkt_Node_List);
         package Bare_Lkt_Node_List_Alloc is new Alloc
           (Subtype_For_Lkt_Node_List, Access_To_Subtype_For_Lkt_Node_List);

         function Allocate_Lkt_Node_List
           (Pool : Bump_Ptr_Pool) return Bare_Lkt_Node_List;

         function Allocate_Lkt_Node_List
           (Pool : Bump_Ptr_Pool) return Bare_Lkt_Node_List
         is
            Result      : constant Access_To_Subtype_For_Lkt_Node_List := Bare_Lkt_Node_List_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Lkt_Node_List;
            return Bare_Lkt_Node_List (Result);
         end Allocate_Lkt_Node_List;

      package Bare_Pattern_Detail_List_Memos is new Liblktlang_Support.Packrat
        (Bare_Pattern_Detail_List, Token_Index);

         
         subtype Subtype_For_Pattern_Detail_List is
            Root_Node_Record (Lkt_Pattern_Detail_List);
         type Access_To_Subtype_For_Pattern_Detail_List is access all Subtype_For_Pattern_Detail_List;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Pattern_Detail_List);
         package Bare_Pattern_Detail_List_Alloc is new Alloc
           (Subtype_For_Pattern_Detail_List, Access_To_Subtype_For_Pattern_Detail_List);

         function Allocate_Pattern_Detail_List
           (Pool : Bump_Ptr_Pool) return Bare_Pattern_Detail_List;

         function Allocate_Pattern_Detail_List
           (Pool : Bump_Ptr_Pool) return Bare_Pattern_Detail_List
         is
            Result      : constant Access_To_Subtype_For_Pattern_Detail_List := Bare_Pattern_Detail_List_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Pattern_Detail_List;
            return Bare_Pattern_Detail_List (Result);
         end Allocate_Pattern_Detail_List;

      package Bare_Pattern_List_Memos is new Liblktlang_Support.Packrat
        (Bare_Pattern_List, Token_Index);

         
         subtype Subtype_For_Pattern_List is
            Root_Node_Record (Lkt_Pattern_List);
         type Access_To_Subtype_For_Pattern_List is access all Subtype_For_Pattern_List;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Pattern_List);
         package Bare_Pattern_List_Alloc is new Alloc
           (Subtype_For_Pattern_List, Access_To_Subtype_For_Pattern_List);

         function Allocate_Pattern_List
           (Pool : Bump_Ptr_Pool) return Bare_Pattern_List;

         function Allocate_Pattern_List
           (Pool : Bump_Ptr_Pool) return Bare_Pattern_List
         is
            Result      : constant Access_To_Subtype_For_Pattern_List := Bare_Pattern_List_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Pattern_List;
            return Bare_Pattern_List (Result);
         end Allocate_Pattern_List;

      package Bare_Ref_Id_List_Memos is new Liblktlang_Support.Packrat
        (Bare_Ref_Id_List, Token_Index);

         
         subtype Subtype_For_Ref_Id_List is
            Root_Node_Record (Lkt_Ref_Id_List);
         type Access_To_Subtype_For_Ref_Id_List is access all Subtype_For_Ref_Id_List;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Ref_Id_List);
         package Bare_Ref_Id_List_Alloc is new Alloc
           (Subtype_For_Ref_Id_List, Access_To_Subtype_For_Ref_Id_List);

         function Allocate_Ref_Id_List
           (Pool : Bump_Ptr_Pool) return Bare_Ref_Id_List;

         function Allocate_Ref_Id_List
           (Pool : Bump_Ptr_Pool) return Bare_Ref_Id_List
         is
            Result      : constant Access_To_Subtype_For_Ref_Id_List := Bare_Ref_Id_List_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Ref_Id_List;
            return Bare_Ref_Id_List (Result);
         end Allocate_Ref_Id_List;

      package Bare_Type_Ref_List_Memos is new Liblktlang_Support.Packrat
        (Bare_Type_Ref_List, Token_Index);

         
         subtype Subtype_For_Type_Ref_List is
            Root_Node_Record (Lkt_Type_Ref_List);
         type Access_To_Subtype_For_Type_Ref_List is access all Subtype_For_Type_Ref_List;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Type_Ref_List);
         package Bare_Type_Ref_List_Alloc is new Alloc
           (Subtype_For_Type_Ref_List, Access_To_Subtype_For_Type_Ref_List);

         function Allocate_Type_Ref_List
           (Pool : Bump_Ptr_Pool) return Bare_Type_Ref_List;

         function Allocate_Type_Ref_List
           (Pool : Bump_Ptr_Pool) return Bare_Type_Ref_List
         is
            Result      : constant Access_To_Subtype_For_Type_Ref_List := Bare_Type_Ref_List_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Type_Ref_List;
            return Bare_Type_Ref_List (Result);
         end Allocate_Type_Ref_List;

      package Bare_Synthetic_Type_Ref_List_Memos is new Liblktlang_Support.Packrat
        (Bare_Synthetic_Type_Ref_List, Token_Index);

         
         subtype Subtype_For_Synthetic_Type_Ref_List is
            Root_Node_Record (Lkt_Synthetic_Type_Ref_List);
         type Access_To_Subtype_For_Synthetic_Type_Ref_List is access all Subtype_For_Synthetic_Type_Ref_List;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Synthetic_Type_Ref_List);
         package Bare_Synthetic_Type_Ref_List_Alloc is new Alloc
           (Subtype_For_Synthetic_Type_Ref_List, Access_To_Subtype_For_Synthetic_Type_Ref_List);

         function Allocate_Synthetic_Type_Ref_List
           (Pool : Bump_Ptr_Pool) return Bare_Synthetic_Type_Ref_List;

         function Allocate_Synthetic_Type_Ref_List
           (Pool : Bump_Ptr_Pool) return Bare_Synthetic_Type_Ref_List
         is
            Result      : constant Access_To_Subtype_For_Synthetic_Type_Ref_List := Bare_Synthetic_Type_Ref_List_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Synthetic_Type_Ref_List;
            return Bare_Synthetic_Type_Ref_List (Result);
         end Allocate_Synthetic_Type_Ref_List;

      package Bare_Null_Cond_Qualifier_Memos is new Liblktlang_Support.Packrat
        (Bare_Null_Cond_Qualifier, Token_Index);

      package Bare_Null_Cond_Qualifier_Absent_Memos is new Liblktlang_Support.Packrat
        (Bare_Null_Cond_Qualifier_Absent, Token_Index);

         
         subtype Subtype_For_Null_Cond_Qualifier_Absent is
            Root_Node_Record (Lkt_Null_Cond_Qualifier_Absent);
         type Access_To_Subtype_For_Null_Cond_Qualifier_Absent is access all Subtype_For_Null_Cond_Qualifier_Absent;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Null_Cond_Qualifier_Absent);
         package Bare_Null_Cond_Qualifier_Absent_Alloc is new Alloc
           (Subtype_For_Null_Cond_Qualifier_Absent, Access_To_Subtype_For_Null_Cond_Qualifier_Absent);

         function Allocate_Null_Cond_Qualifier_Absent
           (Pool : Bump_Ptr_Pool) return Bare_Null_Cond_Qualifier_Absent;

         function Allocate_Null_Cond_Qualifier_Absent
           (Pool : Bump_Ptr_Pool) return Bare_Null_Cond_Qualifier_Absent
         is
            Result      : constant Access_To_Subtype_For_Null_Cond_Qualifier_Absent := Bare_Null_Cond_Qualifier_Absent_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Null_Cond_Qualifier_Absent;
            return Bare_Null_Cond_Qualifier_Absent (Result);
         end Allocate_Null_Cond_Qualifier_Absent;

      package Bare_Null_Cond_Qualifier_Present_Memos is new Liblktlang_Support.Packrat
        (Bare_Null_Cond_Qualifier_Present, Token_Index);

         
         subtype Subtype_For_Null_Cond_Qualifier_Present is
            Root_Node_Record (Lkt_Null_Cond_Qualifier_Present);
         type Access_To_Subtype_For_Null_Cond_Qualifier_Present is access all Subtype_For_Null_Cond_Qualifier_Present;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Null_Cond_Qualifier_Present);
         package Bare_Null_Cond_Qualifier_Present_Alloc is new Alloc
           (Subtype_For_Null_Cond_Qualifier_Present, Access_To_Subtype_For_Null_Cond_Qualifier_Present);

         function Allocate_Null_Cond_Qualifier_Present
           (Pool : Bump_Ptr_Pool) return Bare_Null_Cond_Qualifier_Present;

         function Allocate_Null_Cond_Qualifier_Present
           (Pool : Bump_Ptr_Pool) return Bare_Null_Cond_Qualifier_Present
         is
            Result      : constant Access_To_Subtype_For_Null_Cond_Qualifier_Present := Bare_Null_Cond_Qualifier_Present_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Null_Cond_Qualifier_Present;
            return Bare_Null_Cond_Qualifier_Present (Result);
         end Allocate_Null_Cond_Qualifier_Present;

      package Bare_Op_Memos is new Liblktlang_Support.Packrat
        (Bare_Op, Token_Index);

      package Bare_Op_Amp_Memos is new Liblktlang_Support.Packrat
        (Bare_Op_Amp, Token_Index);

         
         subtype Subtype_For_Op_Amp is
            Root_Node_Record (Lkt_Op_Amp);
         type Access_To_Subtype_For_Op_Amp is access all Subtype_For_Op_Amp;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Op_Amp);
         package Bare_Op_Amp_Alloc is new Alloc
           (Subtype_For_Op_Amp, Access_To_Subtype_For_Op_Amp);

         function Allocate_Op_Amp
           (Pool : Bump_Ptr_Pool) return Bare_Op_Amp;

         function Allocate_Op_Amp
           (Pool : Bump_Ptr_Pool) return Bare_Op_Amp
         is
            Result      : constant Access_To_Subtype_For_Op_Amp := Bare_Op_Amp_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Op_Amp;
            return Bare_Op_Amp (Result);
         end Allocate_Op_Amp;

      package Bare_Op_And_Memos is new Liblktlang_Support.Packrat
        (Bare_Op_And, Token_Index);

         
         subtype Subtype_For_Op_And is
            Root_Node_Record (Lkt_Op_And);
         type Access_To_Subtype_For_Op_And is access all Subtype_For_Op_And;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Op_And);
         package Bare_Op_And_Alloc is new Alloc
           (Subtype_For_Op_And, Access_To_Subtype_For_Op_And);

         function Allocate_Op_And
           (Pool : Bump_Ptr_Pool) return Bare_Op_And;

         function Allocate_Op_And
           (Pool : Bump_Ptr_Pool) return Bare_Op_And
         is
            Result      : constant Access_To_Subtype_For_Op_And := Bare_Op_And_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Op_And;
            return Bare_Op_And (Result);
         end Allocate_Op_And;

      package Bare_Op_Div_Memos is new Liblktlang_Support.Packrat
        (Bare_Op_Div, Token_Index);

         
         subtype Subtype_For_Op_Div is
            Root_Node_Record (Lkt_Op_Div);
         type Access_To_Subtype_For_Op_Div is access all Subtype_For_Op_Div;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Op_Div);
         package Bare_Op_Div_Alloc is new Alloc
           (Subtype_For_Op_Div, Access_To_Subtype_For_Op_Div);

         function Allocate_Op_Div
           (Pool : Bump_Ptr_Pool) return Bare_Op_Div;

         function Allocate_Op_Div
           (Pool : Bump_Ptr_Pool) return Bare_Op_Div
         is
            Result      : constant Access_To_Subtype_For_Op_Div := Bare_Op_Div_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Op_Div;
            return Bare_Op_Div (Result);
         end Allocate_Op_Div;

      package Bare_Op_Eq_Memos is new Liblktlang_Support.Packrat
        (Bare_Op_Eq, Token_Index);

         
         subtype Subtype_For_Op_Eq is
            Root_Node_Record (Lkt_Op_Eq);
         type Access_To_Subtype_For_Op_Eq is access all Subtype_For_Op_Eq;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Op_Eq);
         package Bare_Op_Eq_Alloc is new Alloc
           (Subtype_For_Op_Eq, Access_To_Subtype_For_Op_Eq);

         function Allocate_Op_Eq
           (Pool : Bump_Ptr_Pool) return Bare_Op_Eq;

         function Allocate_Op_Eq
           (Pool : Bump_Ptr_Pool) return Bare_Op_Eq
         is
            Result      : constant Access_To_Subtype_For_Op_Eq := Bare_Op_Eq_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Op_Eq;
            return Bare_Op_Eq (Result);
         end Allocate_Op_Eq;

      package Bare_Op_Gt_Memos is new Liblktlang_Support.Packrat
        (Bare_Op_Gt, Token_Index);

         
         subtype Subtype_For_Op_Gt is
            Root_Node_Record (Lkt_Op_Gt);
         type Access_To_Subtype_For_Op_Gt is access all Subtype_For_Op_Gt;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Op_Gt);
         package Bare_Op_Gt_Alloc is new Alloc
           (Subtype_For_Op_Gt, Access_To_Subtype_For_Op_Gt);

         function Allocate_Op_Gt
           (Pool : Bump_Ptr_Pool) return Bare_Op_Gt;

         function Allocate_Op_Gt
           (Pool : Bump_Ptr_Pool) return Bare_Op_Gt
         is
            Result      : constant Access_To_Subtype_For_Op_Gt := Bare_Op_Gt_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Op_Gt;
            return Bare_Op_Gt (Result);
         end Allocate_Op_Gt;

      package Bare_Op_Gte_Memos is new Liblktlang_Support.Packrat
        (Bare_Op_Gte, Token_Index);

         
         subtype Subtype_For_Op_Gte is
            Root_Node_Record (Lkt_Op_Gte);
         type Access_To_Subtype_For_Op_Gte is access all Subtype_For_Op_Gte;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Op_Gte);
         package Bare_Op_Gte_Alloc is new Alloc
           (Subtype_For_Op_Gte, Access_To_Subtype_For_Op_Gte);

         function Allocate_Op_Gte
           (Pool : Bump_Ptr_Pool) return Bare_Op_Gte;

         function Allocate_Op_Gte
           (Pool : Bump_Ptr_Pool) return Bare_Op_Gte
         is
            Result      : constant Access_To_Subtype_For_Op_Gte := Bare_Op_Gte_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Op_Gte;
            return Bare_Op_Gte (Result);
         end Allocate_Op_Gte;

      package Bare_Op_Logic_And_Memos is new Liblktlang_Support.Packrat
        (Bare_Op_Logic_And, Token_Index);

         
         subtype Subtype_For_Op_Logic_And is
            Root_Node_Record (Lkt_Op_Logic_And);
         type Access_To_Subtype_For_Op_Logic_And is access all Subtype_For_Op_Logic_And;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Op_Logic_And);
         package Bare_Op_Logic_And_Alloc is new Alloc
           (Subtype_For_Op_Logic_And, Access_To_Subtype_For_Op_Logic_And);

         function Allocate_Op_Logic_And
           (Pool : Bump_Ptr_Pool) return Bare_Op_Logic_And;

         function Allocate_Op_Logic_And
           (Pool : Bump_Ptr_Pool) return Bare_Op_Logic_And
         is
            Result      : constant Access_To_Subtype_For_Op_Logic_And := Bare_Op_Logic_And_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Op_Logic_And;
            return Bare_Op_Logic_And (Result);
         end Allocate_Op_Logic_And;

      package Bare_Op_Logic_Or_Memos is new Liblktlang_Support.Packrat
        (Bare_Op_Logic_Or, Token_Index);

         
         subtype Subtype_For_Op_Logic_Or is
            Root_Node_Record (Lkt_Op_Logic_Or);
         type Access_To_Subtype_For_Op_Logic_Or is access all Subtype_For_Op_Logic_Or;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Op_Logic_Or);
         package Bare_Op_Logic_Or_Alloc is new Alloc
           (Subtype_For_Op_Logic_Or, Access_To_Subtype_For_Op_Logic_Or);

         function Allocate_Op_Logic_Or
           (Pool : Bump_Ptr_Pool) return Bare_Op_Logic_Or;

         function Allocate_Op_Logic_Or
           (Pool : Bump_Ptr_Pool) return Bare_Op_Logic_Or
         is
            Result      : constant Access_To_Subtype_For_Op_Logic_Or := Bare_Op_Logic_Or_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Op_Logic_Or;
            return Bare_Op_Logic_Or (Result);
         end Allocate_Op_Logic_Or;

      package Bare_Op_Lt_Memos is new Liblktlang_Support.Packrat
        (Bare_Op_Lt, Token_Index);

         
         subtype Subtype_For_Op_Lt is
            Root_Node_Record (Lkt_Op_Lt);
         type Access_To_Subtype_For_Op_Lt is access all Subtype_For_Op_Lt;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Op_Lt);
         package Bare_Op_Lt_Alloc is new Alloc
           (Subtype_For_Op_Lt, Access_To_Subtype_For_Op_Lt);

         function Allocate_Op_Lt
           (Pool : Bump_Ptr_Pool) return Bare_Op_Lt;

         function Allocate_Op_Lt
           (Pool : Bump_Ptr_Pool) return Bare_Op_Lt
         is
            Result      : constant Access_To_Subtype_For_Op_Lt := Bare_Op_Lt_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Op_Lt;
            return Bare_Op_Lt (Result);
         end Allocate_Op_Lt;

      package Bare_Op_Lte_Memos is new Liblktlang_Support.Packrat
        (Bare_Op_Lte, Token_Index);

         
         subtype Subtype_For_Op_Lte is
            Root_Node_Record (Lkt_Op_Lte);
         type Access_To_Subtype_For_Op_Lte is access all Subtype_For_Op_Lte;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Op_Lte);
         package Bare_Op_Lte_Alloc is new Alloc
           (Subtype_For_Op_Lte, Access_To_Subtype_For_Op_Lte);

         function Allocate_Op_Lte
           (Pool : Bump_Ptr_Pool) return Bare_Op_Lte;

         function Allocate_Op_Lte
           (Pool : Bump_Ptr_Pool) return Bare_Op_Lte
         is
            Result      : constant Access_To_Subtype_For_Op_Lte := Bare_Op_Lte_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Op_Lte;
            return Bare_Op_Lte (Result);
         end Allocate_Op_Lte;

      package Bare_Op_Minus_Memos is new Liblktlang_Support.Packrat
        (Bare_Op_Minus, Token_Index);

         
         subtype Subtype_For_Op_Minus is
            Root_Node_Record (Lkt_Op_Minus);
         type Access_To_Subtype_For_Op_Minus is access all Subtype_For_Op_Minus;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Op_Minus);
         package Bare_Op_Minus_Alloc is new Alloc
           (Subtype_For_Op_Minus, Access_To_Subtype_For_Op_Minus);

         function Allocate_Op_Minus
           (Pool : Bump_Ptr_Pool) return Bare_Op_Minus;

         function Allocate_Op_Minus
           (Pool : Bump_Ptr_Pool) return Bare_Op_Minus
         is
            Result      : constant Access_To_Subtype_For_Op_Minus := Bare_Op_Minus_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Op_Minus;
            return Bare_Op_Minus (Result);
         end Allocate_Op_Minus;

      package Bare_Op_Mult_Memos is new Liblktlang_Support.Packrat
        (Bare_Op_Mult, Token_Index);

         
         subtype Subtype_For_Op_Mult is
            Root_Node_Record (Lkt_Op_Mult);
         type Access_To_Subtype_For_Op_Mult is access all Subtype_For_Op_Mult;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Op_Mult);
         package Bare_Op_Mult_Alloc is new Alloc
           (Subtype_For_Op_Mult, Access_To_Subtype_For_Op_Mult);

         function Allocate_Op_Mult
           (Pool : Bump_Ptr_Pool) return Bare_Op_Mult;

         function Allocate_Op_Mult
           (Pool : Bump_Ptr_Pool) return Bare_Op_Mult
         is
            Result      : constant Access_To_Subtype_For_Op_Mult := Bare_Op_Mult_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Op_Mult;
            return Bare_Op_Mult (Result);
         end Allocate_Op_Mult;

      package Bare_Op_Ne_Memos is new Liblktlang_Support.Packrat
        (Bare_Op_Ne, Token_Index);

         
         subtype Subtype_For_Op_Ne is
            Root_Node_Record (Lkt_Op_Ne);
         type Access_To_Subtype_For_Op_Ne is access all Subtype_For_Op_Ne;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Op_Ne);
         package Bare_Op_Ne_Alloc is new Alloc
           (Subtype_For_Op_Ne, Access_To_Subtype_For_Op_Ne);

         function Allocate_Op_Ne
           (Pool : Bump_Ptr_Pool) return Bare_Op_Ne;

         function Allocate_Op_Ne
           (Pool : Bump_Ptr_Pool) return Bare_Op_Ne
         is
            Result      : constant Access_To_Subtype_For_Op_Ne := Bare_Op_Ne_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Op_Ne;
            return Bare_Op_Ne (Result);
         end Allocate_Op_Ne;

      package Bare_Op_Or_Memos is new Liblktlang_Support.Packrat
        (Bare_Op_Or, Token_Index);

         
         subtype Subtype_For_Op_Or is
            Root_Node_Record (Lkt_Op_Or);
         type Access_To_Subtype_For_Op_Or is access all Subtype_For_Op_Or;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Op_Or);
         package Bare_Op_Or_Alloc is new Alloc
           (Subtype_For_Op_Or, Access_To_Subtype_For_Op_Or);

         function Allocate_Op_Or
           (Pool : Bump_Ptr_Pool) return Bare_Op_Or;

         function Allocate_Op_Or
           (Pool : Bump_Ptr_Pool) return Bare_Op_Or
         is
            Result      : constant Access_To_Subtype_For_Op_Or := Bare_Op_Or_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Op_Or;
            return Bare_Op_Or (Result);
         end Allocate_Op_Or;

      package Bare_Op_Or_Int_Memos is new Liblktlang_Support.Packrat
        (Bare_Op_Or_Int, Token_Index);

         
         subtype Subtype_For_Op_Or_Int is
            Root_Node_Record (Lkt_Op_Or_Int);
         type Access_To_Subtype_For_Op_Or_Int is access all Subtype_For_Op_Or_Int;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Op_Or_Int);
         package Bare_Op_Or_Int_Alloc is new Alloc
           (Subtype_For_Op_Or_Int, Access_To_Subtype_For_Op_Or_Int);

         function Allocate_Op_Or_Int
           (Pool : Bump_Ptr_Pool) return Bare_Op_Or_Int;

         function Allocate_Op_Or_Int
           (Pool : Bump_Ptr_Pool) return Bare_Op_Or_Int
         is
            Result      : constant Access_To_Subtype_For_Op_Or_Int := Bare_Op_Or_Int_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Op_Or_Int;
            return Bare_Op_Or_Int (Result);
         end Allocate_Op_Or_Int;

      package Bare_Op_Plus_Memos is new Liblktlang_Support.Packrat
        (Bare_Op_Plus, Token_Index);

         
         subtype Subtype_For_Op_Plus is
            Root_Node_Record (Lkt_Op_Plus);
         type Access_To_Subtype_For_Op_Plus is access all Subtype_For_Op_Plus;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Op_Plus);
         package Bare_Op_Plus_Alloc is new Alloc
           (Subtype_For_Op_Plus, Access_To_Subtype_For_Op_Plus);

         function Allocate_Op_Plus
           (Pool : Bump_Ptr_Pool) return Bare_Op_Plus;

         function Allocate_Op_Plus
           (Pool : Bump_Ptr_Pool) return Bare_Op_Plus
         is
            Result      : constant Access_To_Subtype_For_Op_Plus := Bare_Op_Plus_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Op_Plus;
            return Bare_Op_Plus (Result);
         end Allocate_Op_Plus;

      package Bare_Pattern_Memos is new Liblktlang_Support.Packrat
        (Bare_Pattern, Token_Index);

      package Bare_Any_Type_Pattern_Memos is new Liblktlang_Support.Packrat
        (Bare_Any_Type_Pattern, Token_Index);

         
         subtype Subtype_For_Any_Type_Pattern is
            Root_Node_Record (Lkt_Any_Type_Pattern);
         type Access_To_Subtype_For_Any_Type_Pattern is access all Subtype_For_Any_Type_Pattern;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Any_Type_Pattern);
         package Bare_Any_Type_Pattern_Alloc is new Alloc
           (Subtype_For_Any_Type_Pattern, Access_To_Subtype_For_Any_Type_Pattern);

         function Allocate_Any_Type_Pattern
           (Pool : Bump_Ptr_Pool) return Bare_Any_Type_Pattern;

         function Allocate_Any_Type_Pattern
           (Pool : Bump_Ptr_Pool) return Bare_Any_Type_Pattern
         is
            Result      : constant Access_To_Subtype_For_Any_Type_Pattern := Bare_Any_Type_Pattern_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Any_Type_Pattern;
            return Bare_Any_Type_Pattern (Result);
         end Allocate_Any_Type_Pattern;

      package Bare_Binding_Pattern_Memos is new Liblktlang_Support.Packrat
        (Bare_Binding_Pattern, Token_Index);

         
         subtype Subtype_For_Binding_Pattern is
            Root_Node_Record (Lkt_Binding_Pattern);
         type Access_To_Subtype_For_Binding_Pattern is access all Subtype_For_Binding_Pattern;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Binding_Pattern);
         package Bare_Binding_Pattern_Alloc is new Alloc
           (Subtype_For_Binding_Pattern, Access_To_Subtype_For_Binding_Pattern);

         function Allocate_Binding_Pattern
           (Pool : Bump_Ptr_Pool) return Bare_Binding_Pattern;

         function Allocate_Binding_Pattern
           (Pool : Bump_Ptr_Pool) return Bare_Binding_Pattern
         is
            Result      : constant Access_To_Subtype_For_Binding_Pattern := Bare_Binding_Pattern_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Binding_Pattern;
            return Bare_Binding_Pattern (Result);
         end Allocate_Binding_Pattern;

      package Bare_Bool_Pattern_Memos is new Liblktlang_Support.Packrat
        (Bare_Bool_Pattern, Token_Index);

      package Bare_Bool_Pattern_False_Memos is new Liblktlang_Support.Packrat
        (Bare_Bool_Pattern_False, Token_Index);

         
         subtype Subtype_For_Bool_Pattern_False is
            Root_Node_Record (Lkt_Bool_Pattern_False);
         type Access_To_Subtype_For_Bool_Pattern_False is access all Subtype_For_Bool_Pattern_False;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Bool_Pattern_False);
         package Bare_Bool_Pattern_False_Alloc is new Alloc
           (Subtype_For_Bool_Pattern_False, Access_To_Subtype_For_Bool_Pattern_False);

         function Allocate_Bool_Pattern_False
           (Pool : Bump_Ptr_Pool) return Bare_Bool_Pattern_False;

         function Allocate_Bool_Pattern_False
           (Pool : Bump_Ptr_Pool) return Bare_Bool_Pattern_False
         is
            Result      : constant Access_To_Subtype_For_Bool_Pattern_False := Bare_Bool_Pattern_False_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Bool_Pattern_False;
            return Bare_Bool_Pattern_False (Result);
         end Allocate_Bool_Pattern_False;

      package Bare_Bool_Pattern_True_Memos is new Liblktlang_Support.Packrat
        (Bare_Bool_Pattern_True, Token_Index);

         
         subtype Subtype_For_Bool_Pattern_True is
            Root_Node_Record (Lkt_Bool_Pattern_True);
         type Access_To_Subtype_For_Bool_Pattern_True is access all Subtype_For_Bool_Pattern_True;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Bool_Pattern_True);
         package Bare_Bool_Pattern_True_Alloc is new Alloc
           (Subtype_For_Bool_Pattern_True, Access_To_Subtype_For_Bool_Pattern_True);

         function Allocate_Bool_Pattern_True
           (Pool : Bump_Ptr_Pool) return Bare_Bool_Pattern_True;

         function Allocate_Bool_Pattern_True
           (Pool : Bump_Ptr_Pool) return Bare_Bool_Pattern_True
         is
            Result      : constant Access_To_Subtype_For_Bool_Pattern_True := Bare_Bool_Pattern_True_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Bool_Pattern_True;
            return Bare_Bool_Pattern_True (Result);
         end Allocate_Bool_Pattern_True;

      package Bare_Ellipsis_Pattern_Memos is new Liblktlang_Support.Packrat
        (Bare_Ellipsis_Pattern, Token_Index);

         
         subtype Subtype_For_Ellipsis_Pattern is
            Root_Node_Record (Lkt_Ellipsis_Pattern);
         type Access_To_Subtype_For_Ellipsis_Pattern is access all Subtype_For_Ellipsis_Pattern;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Ellipsis_Pattern);
         package Bare_Ellipsis_Pattern_Alloc is new Alloc
           (Subtype_For_Ellipsis_Pattern, Access_To_Subtype_For_Ellipsis_Pattern);

         function Allocate_Ellipsis_Pattern
           (Pool : Bump_Ptr_Pool) return Bare_Ellipsis_Pattern;

         function Allocate_Ellipsis_Pattern
           (Pool : Bump_Ptr_Pool) return Bare_Ellipsis_Pattern
         is
            Result      : constant Access_To_Subtype_For_Ellipsis_Pattern := Bare_Ellipsis_Pattern_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Ellipsis_Pattern;
            return Bare_Ellipsis_Pattern (Result);
         end Allocate_Ellipsis_Pattern;

      package Bare_Extended_Pattern_Memos is new Liblktlang_Support.Packrat
        (Bare_Extended_Pattern, Token_Index);

         
         subtype Subtype_For_Extended_Pattern is
            Root_Node_Record (Lkt_Extended_Pattern);
         type Access_To_Subtype_For_Extended_Pattern is access all Subtype_For_Extended_Pattern;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Extended_Pattern);
         package Bare_Extended_Pattern_Alloc is new Alloc
           (Subtype_For_Extended_Pattern, Access_To_Subtype_For_Extended_Pattern);

         function Allocate_Extended_Pattern
           (Pool : Bump_Ptr_Pool) return Bare_Extended_Pattern;

         function Allocate_Extended_Pattern
           (Pool : Bump_Ptr_Pool) return Bare_Extended_Pattern
         is
            Result      : constant Access_To_Subtype_For_Extended_Pattern := Bare_Extended_Pattern_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Extended_Pattern;
            return Bare_Extended_Pattern (Result);
         end Allocate_Extended_Pattern;

      package Bare_Filtered_Pattern_Memos is new Liblktlang_Support.Packrat
        (Bare_Filtered_Pattern, Token_Index);

         
         subtype Subtype_For_Filtered_Pattern is
            Root_Node_Record (Lkt_Filtered_Pattern);
         type Access_To_Subtype_For_Filtered_Pattern is access all Subtype_For_Filtered_Pattern;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Filtered_Pattern);
         package Bare_Filtered_Pattern_Alloc is new Alloc
           (Subtype_For_Filtered_Pattern, Access_To_Subtype_For_Filtered_Pattern);

         function Allocate_Filtered_Pattern
           (Pool : Bump_Ptr_Pool) return Bare_Filtered_Pattern;

         function Allocate_Filtered_Pattern
           (Pool : Bump_Ptr_Pool) return Bare_Filtered_Pattern
         is
            Result      : constant Access_To_Subtype_For_Filtered_Pattern := Bare_Filtered_Pattern_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Filtered_Pattern;
            return Bare_Filtered_Pattern (Result);
         end Allocate_Filtered_Pattern;

      package Bare_Integer_Pattern_Memos is new Liblktlang_Support.Packrat
        (Bare_Integer_Pattern, Token_Index);

         
         subtype Subtype_For_Integer_Pattern is
            Root_Node_Record (Lkt_Integer_Pattern);
         type Access_To_Subtype_For_Integer_Pattern is access all Subtype_For_Integer_Pattern;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Integer_Pattern);
         package Bare_Integer_Pattern_Alloc is new Alloc
           (Subtype_For_Integer_Pattern, Access_To_Subtype_For_Integer_Pattern);

         function Allocate_Integer_Pattern
           (Pool : Bump_Ptr_Pool) return Bare_Integer_Pattern;

         function Allocate_Integer_Pattern
           (Pool : Bump_Ptr_Pool) return Bare_Integer_Pattern
         is
            Result      : constant Access_To_Subtype_For_Integer_Pattern := Bare_Integer_Pattern_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Integer_Pattern;
            return Bare_Integer_Pattern (Result);
         end Allocate_Integer_Pattern;

      package Bare_List_Pattern_Memos is new Liblktlang_Support.Packrat
        (Bare_List_Pattern, Token_Index);

         
         subtype Subtype_For_List_Pattern is
            Root_Node_Record (Lkt_List_Pattern);
         type Access_To_Subtype_For_List_Pattern is access all Subtype_For_List_Pattern;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_List_Pattern);
         package Bare_List_Pattern_Alloc is new Alloc
           (Subtype_For_List_Pattern, Access_To_Subtype_For_List_Pattern);

         function Allocate_List_Pattern
           (Pool : Bump_Ptr_Pool) return Bare_List_Pattern;

         function Allocate_List_Pattern
           (Pool : Bump_Ptr_Pool) return Bare_List_Pattern
         is
            Result      : constant Access_To_Subtype_For_List_Pattern := Bare_List_Pattern_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_List_Pattern;
            return Bare_List_Pattern (Result);
         end Allocate_List_Pattern;

      package Bare_Not_Pattern_Memos is new Liblktlang_Support.Packrat
        (Bare_Not_Pattern, Token_Index);

         
         subtype Subtype_For_Not_Pattern is
            Root_Node_Record (Lkt_Not_Pattern);
         type Access_To_Subtype_For_Not_Pattern is access all Subtype_For_Not_Pattern;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Not_Pattern);
         package Bare_Not_Pattern_Alloc is new Alloc
           (Subtype_For_Not_Pattern, Access_To_Subtype_For_Not_Pattern);

         function Allocate_Not_Pattern
           (Pool : Bump_Ptr_Pool) return Bare_Not_Pattern;

         function Allocate_Not_Pattern
           (Pool : Bump_Ptr_Pool) return Bare_Not_Pattern
         is
            Result      : constant Access_To_Subtype_For_Not_Pattern := Bare_Not_Pattern_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Not_Pattern;
            return Bare_Not_Pattern (Result);
         end Allocate_Not_Pattern;

      package Bare_Null_Pattern_Memos is new Liblktlang_Support.Packrat
        (Bare_Null_Pattern, Token_Index);

         
         subtype Subtype_For_Null_Pattern is
            Root_Node_Record (Lkt_Null_Pattern);
         type Access_To_Subtype_For_Null_Pattern is access all Subtype_For_Null_Pattern;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Null_Pattern);
         package Bare_Null_Pattern_Alloc is new Alloc
           (Subtype_For_Null_Pattern, Access_To_Subtype_For_Null_Pattern);

         function Allocate_Null_Pattern
           (Pool : Bump_Ptr_Pool) return Bare_Null_Pattern;

         function Allocate_Null_Pattern
           (Pool : Bump_Ptr_Pool) return Bare_Null_Pattern
         is
            Result      : constant Access_To_Subtype_For_Null_Pattern := Bare_Null_Pattern_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Null_Pattern;
            return Bare_Null_Pattern (Result);
         end Allocate_Null_Pattern;

      package Bare_Or_Pattern_Memos is new Liblktlang_Support.Packrat
        (Bare_Or_Pattern, Token_Index);

         
         subtype Subtype_For_Or_Pattern is
            Root_Node_Record (Lkt_Or_Pattern);
         type Access_To_Subtype_For_Or_Pattern is access all Subtype_For_Or_Pattern;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Or_Pattern);
         package Bare_Or_Pattern_Alloc is new Alloc
           (Subtype_For_Or_Pattern, Access_To_Subtype_For_Or_Pattern);

         function Allocate_Or_Pattern
           (Pool : Bump_Ptr_Pool) return Bare_Or_Pattern;

         function Allocate_Or_Pattern
           (Pool : Bump_Ptr_Pool) return Bare_Or_Pattern
         is
            Result      : constant Access_To_Subtype_For_Or_Pattern := Bare_Or_Pattern_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Or_Pattern;
            return Bare_Or_Pattern (Result);
         end Allocate_Or_Pattern;

      package Bare_Paren_Pattern_Memos is new Liblktlang_Support.Packrat
        (Bare_Paren_Pattern, Token_Index);

         
         subtype Subtype_For_Paren_Pattern is
            Root_Node_Record (Lkt_Paren_Pattern);
         type Access_To_Subtype_For_Paren_Pattern is access all Subtype_For_Paren_Pattern;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Paren_Pattern);
         package Bare_Paren_Pattern_Alloc is new Alloc
           (Subtype_For_Paren_Pattern, Access_To_Subtype_For_Paren_Pattern);

         function Allocate_Paren_Pattern
           (Pool : Bump_Ptr_Pool) return Bare_Paren_Pattern;

         function Allocate_Paren_Pattern
           (Pool : Bump_Ptr_Pool) return Bare_Paren_Pattern
         is
            Result      : constant Access_To_Subtype_For_Paren_Pattern := Bare_Paren_Pattern_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Paren_Pattern;
            return Bare_Paren_Pattern (Result);
         end Allocate_Paren_Pattern;

      package Bare_Regex_Pattern_Memos is new Liblktlang_Support.Packrat
        (Bare_Regex_Pattern, Token_Index);

         
         subtype Subtype_For_Regex_Pattern is
            Root_Node_Record (Lkt_Regex_Pattern);
         type Access_To_Subtype_For_Regex_Pattern is access all Subtype_For_Regex_Pattern;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Regex_Pattern);
         package Bare_Regex_Pattern_Alloc is new Alloc
           (Subtype_For_Regex_Pattern, Access_To_Subtype_For_Regex_Pattern);

         function Allocate_Regex_Pattern
           (Pool : Bump_Ptr_Pool) return Bare_Regex_Pattern;

         function Allocate_Regex_Pattern
           (Pool : Bump_Ptr_Pool) return Bare_Regex_Pattern
         is
            Result      : constant Access_To_Subtype_For_Regex_Pattern := Bare_Regex_Pattern_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Regex_Pattern;
            return Bare_Regex_Pattern (Result);
         end Allocate_Regex_Pattern;

      package Bare_Tuple_Pattern_Memos is new Liblktlang_Support.Packrat
        (Bare_Tuple_Pattern, Token_Index);

         
         subtype Subtype_For_Tuple_Pattern is
            Root_Node_Record (Lkt_Tuple_Pattern);
         type Access_To_Subtype_For_Tuple_Pattern is access all Subtype_For_Tuple_Pattern;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Tuple_Pattern);
         package Bare_Tuple_Pattern_Alloc is new Alloc
           (Subtype_For_Tuple_Pattern, Access_To_Subtype_For_Tuple_Pattern);

         function Allocate_Tuple_Pattern
           (Pool : Bump_Ptr_Pool) return Bare_Tuple_Pattern;

         function Allocate_Tuple_Pattern
           (Pool : Bump_Ptr_Pool) return Bare_Tuple_Pattern
         is
            Result      : constant Access_To_Subtype_For_Tuple_Pattern := Bare_Tuple_Pattern_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Tuple_Pattern;
            return Bare_Tuple_Pattern (Result);
         end Allocate_Tuple_Pattern;

      package Bare_Type_Pattern_Memos is new Liblktlang_Support.Packrat
        (Bare_Type_Pattern, Token_Index);

         
         subtype Subtype_For_Type_Pattern is
            Root_Node_Record (Lkt_Type_Pattern);
         type Access_To_Subtype_For_Type_Pattern is access all Subtype_For_Type_Pattern;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Type_Pattern);
         package Bare_Type_Pattern_Alloc is new Alloc
           (Subtype_For_Type_Pattern, Access_To_Subtype_For_Type_Pattern);

         function Allocate_Type_Pattern
           (Pool : Bump_Ptr_Pool) return Bare_Type_Pattern;

         function Allocate_Type_Pattern
           (Pool : Bump_Ptr_Pool) return Bare_Type_Pattern
         is
            Result      : constant Access_To_Subtype_For_Type_Pattern := Bare_Type_Pattern_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Type_Pattern;
            return Bare_Type_Pattern (Result);
         end Allocate_Type_Pattern;

      package Bare_Pattern_Detail_Memos is new Liblktlang_Support.Packrat
        (Bare_Pattern_Detail, Token_Index);

      package Bare_Field_Pattern_Detail_Memos is new Liblktlang_Support.Packrat
        (Bare_Field_Pattern_Detail, Token_Index);

         
         subtype Subtype_For_Field_Pattern_Detail is
            Root_Node_Record (Lkt_Field_Pattern_Detail);
         type Access_To_Subtype_For_Field_Pattern_Detail is access all Subtype_For_Field_Pattern_Detail;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Field_Pattern_Detail);
         package Bare_Field_Pattern_Detail_Alloc is new Alloc
           (Subtype_For_Field_Pattern_Detail, Access_To_Subtype_For_Field_Pattern_Detail);

         function Allocate_Field_Pattern_Detail
           (Pool : Bump_Ptr_Pool) return Bare_Field_Pattern_Detail;

         function Allocate_Field_Pattern_Detail
           (Pool : Bump_Ptr_Pool) return Bare_Field_Pattern_Detail
         is
            Result      : constant Access_To_Subtype_For_Field_Pattern_Detail := Bare_Field_Pattern_Detail_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Field_Pattern_Detail;
            return Bare_Field_Pattern_Detail (Result);
         end Allocate_Field_Pattern_Detail;

      package Bare_Property_Pattern_Detail_Memos is new Liblktlang_Support.Packrat
        (Bare_Property_Pattern_Detail, Token_Index);

         
         subtype Subtype_For_Property_Pattern_Detail is
            Root_Node_Record (Lkt_Property_Pattern_Detail);
         type Access_To_Subtype_For_Property_Pattern_Detail is access all Subtype_For_Property_Pattern_Detail;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Property_Pattern_Detail);
         package Bare_Property_Pattern_Detail_Alloc is new Alloc
           (Subtype_For_Property_Pattern_Detail, Access_To_Subtype_For_Property_Pattern_Detail);

         function Allocate_Property_Pattern_Detail
           (Pool : Bump_Ptr_Pool) return Bare_Property_Pattern_Detail;

         function Allocate_Property_Pattern_Detail
           (Pool : Bump_Ptr_Pool) return Bare_Property_Pattern_Detail
         is
            Result      : constant Access_To_Subtype_For_Property_Pattern_Detail := Bare_Property_Pattern_Detail_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Property_Pattern_Detail;
            return Bare_Property_Pattern_Detail (Result);
         end Allocate_Property_Pattern_Detail;

      package Bare_Selector_Pattern_Detail_Memos is new Liblktlang_Support.Packrat
        (Bare_Selector_Pattern_Detail, Token_Index);

         
         subtype Subtype_For_Selector_Pattern_Detail is
            Root_Node_Record (Lkt_Selector_Pattern_Detail);
         type Access_To_Subtype_For_Selector_Pattern_Detail is access all Subtype_For_Selector_Pattern_Detail;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Selector_Pattern_Detail);
         package Bare_Selector_Pattern_Detail_Alloc is new Alloc
           (Subtype_For_Selector_Pattern_Detail, Access_To_Subtype_For_Selector_Pattern_Detail);

         function Allocate_Selector_Pattern_Detail
           (Pool : Bump_Ptr_Pool) return Bare_Selector_Pattern_Detail;

         function Allocate_Selector_Pattern_Detail
           (Pool : Bump_Ptr_Pool) return Bare_Selector_Pattern_Detail
         is
            Result      : constant Access_To_Subtype_For_Selector_Pattern_Detail := Bare_Selector_Pattern_Detail_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Selector_Pattern_Detail;
            return Bare_Selector_Pattern_Detail (Result);
         end Allocate_Selector_Pattern_Detail;

      package Bare_Selector_Call_Memos is new Liblktlang_Support.Packrat
        (Bare_Selector_Call, Token_Index);

         
         subtype Subtype_For_Selector_Call is
            Root_Node_Record (Lkt_Selector_Call);
         type Access_To_Subtype_For_Selector_Call is access all Subtype_For_Selector_Call;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Selector_Call);
         package Bare_Selector_Call_Alloc is new Alloc
           (Subtype_For_Selector_Call, Access_To_Subtype_For_Selector_Call);

         function Allocate_Selector_Call
           (Pool : Bump_Ptr_Pool) return Bare_Selector_Call;

         function Allocate_Selector_Call
           (Pool : Bump_Ptr_Pool) return Bare_Selector_Call
         is
            Result      : constant Access_To_Subtype_For_Selector_Call := Bare_Selector_Call_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Selector_Call;
            return Bare_Selector_Call (Result);
         end Allocate_Selector_Call;

      package Bare_Type_Ref_Memos is new Liblktlang_Support.Packrat
        (Bare_Type_Ref, Token_Index);

      package Bare_Default_List_Type_Ref_Memos is new Liblktlang_Support.Packrat
        (Bare_Default_List_Type_Ref, Token_Index);

         
         subtype Subtype_For_Default_List_Type_Ref is
            Root_Node_Record (Lkt_Default_List_Type_Ref);
         type Access_To_Subtype_For_Default_List_Type_Ref is access all Subtype_For_Default_List_Type_Ref;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Default_List_Type_Ref);
         package Bare_Default_List_Type_Ref_Alloc is new Alloc
           (Subtype_For_Default_List_Type_Ref, Access_To_Subtype_For_Default_List_Type_Ref);

         function Allocate_Default_List_Type_Ref
           (Pool : Bump_Ptr_Pool) return Bare_Default_List_Type_Ref;

         function Allocate_Default_List_Type_Ref
           (Pool : Bump_Ptr_Pool) return Bare_Default_List_Type_Ref
         is
            Result      : constant Access_To_Subtype_For_Default_List_Type_Ref := Bare_Default_List_Type_Ref_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Default_List_Type_Ref;
            return Bare_Default_List_Type_Ref (Result);
         end Allocate_Default_List_Type_Ref;

      package Bare_Function_Type_Ref_Memos is new Liblktlang_Support.Packrat
        (Bare_Function_Type_Ref, Token_Index);

         
         subtype Subtype_For_Function_Type_Ref is
            Root_Node_Record (Lkt_Function_Type_Ref);
         type Access_To_Subtype_For_Function_Type_Ref is access all Subtype_For_Function_Type_Ref;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Function_Type_Ref);
         package Bare_Function_Type_Ref_Alloc is new Alloc
           (Subtype_For_Function_Type_Ref, Access_To_Subtype_For_Function_Type_Ref);

         function Allocate_Function_Type_Ref
           (Pool : Bump_Ptr_Pool) return Bare_Function_Type_Ref;

         function Allocate_Function_Type_Ref
           (Pool : Bump_Ptr_Pool) return Bare_Function_Type_Ref
         is
            Result      : constant Access_To_Subtype_For_Function_Type_Ref := Bare_Function_Type_Ref_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Function_Type_Ref;
            return Bare_Function_Type_Ref (Result);
         end Allocate_Function_Type_Ref;

      package Bare_Generic_Type_Ref_Memos is new Liblktlang_Support.Packrat
        (Bare_Generic_Type_Ref, Token_Index);

         
         subtype Subtype_For_Generic_Type_Ref is
            Root_Node_Record (Lkt_Generic_Type_Ref);
         type Access_To_Subtype_For_Generic_Type_Ref is access all Subtype_For_Generic_Type_Ref;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Generic_Type_Ref);
         package Bare_Generic_Type_Ref_Alloc is new Alloc
           (Subtype_For_Generic_Type_Ref, Access_To_Subtype_For_Generic_Type_Ref);

         function Allocate_Generic_Type_Ref
           (Pool : Bump_Ptr_Pool) return Bare_Generic_Type_Ref;

         function Allocate_Generic_Type_Ref
           (Pool : Bump_Ptr_Pool) return Bare_Generic_Type_Ref
         is
            Result      : constant Access_To_Subtype_For_Generic_Type_Ref := Bare_Generic_Type_Ref_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Generic_Type_Ref;
            return Bare_Generic_Type_Ref (Result);
         end Allocate_Generic_Type_Ref;

      package Bare_Simple_Type_Ref_Memos is new Liblktlang_Support.Packrat
        (Bare_Simple_Type_Ref, Token_Index);

         
         subtype Subtype_For_Simple_Type_Ref is
            Root_Node_Record (Lkt_Simple_Type_Ref);
         type Access_To_Subtype_For_Simple_Type_Ref is access all Subtype_For_Simple_Type_Ref;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Simple_Type_Ref);
         package Bare_Simple_Type_Ref_Alloc is new Alloc
           (Subtype_For_Simple_Type_Ref, Access_To_Subtype_For_Simple_Type_Ref);

         function Allocate_Simple_Type_Ref
           (Pool : Bump_Ptr_Pool) return Bare_Simple_Type_Ref;

         function Allocate_Simple_Type_Ref
           (Pool : Bump_Ptr_Pool) return Bare_Simple_Type_Ref
         is
            Result      : constant Access_To_Subtype_For_Simple_Type_Ref := Bare_Simple_Type_Ref_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Simple_Type_Ref;
            return Bare_Simple_Type_Ref (Result);
         end Allocate_Simple_Type_Ref;

      package Bare_Var_Bind_Memos is new Liblktlang_Support.Packrat
        (Bare_Var_Bind, Token_Index);

         
         subtype Subtype_For_Var_Bind is
            Root_Node_Record (Lkt_Var_Bind);
         type Access_To_Subtype_For_Var_Bind is access all Subtype_For_Var_Bind;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Var_Bind);
         package Bare_Var_Bind_Alloc is new Alloc
           (Subtype_For_Var_Bind, Access_To_Subtype_For_Var_Bind);

         function Allocate_Var_Bind
           (Pool : Bump_Ptr_Pool) return Bare_Var_Bind;

         function Allocate_Var_Bind
           (Pool : Bump_Ptr_Pool) return Bare_Var_Bind
         is
            Result      : constant Access_To_Subtype_For_Var_Bind := Bare_Var_Bind_Alloc.Alloc (Pool);
            Result_Kind : Lkt_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Lkt_Var_Bind;
            return Bare_Var_Bind (Result);
         end Allocate_Var_Bind;

   pragma Warnings (On, "is not referenced");

   type Dontskip_Parser_Function is access function
     (Parser : in out Parser_Type;
      Pos    : Token_Index) return Bare_Lkt_Node;

   package Dont_Skip_Fn_Vectors
   is new Ada.Containers.Vectors (Natural, Dontskip_Parser_Function);

   type Free_Parse_List_Record;
   type Free_Parse_List is access all Free_Parse_List_Record;
   --  Cache of temporary lists of AST nodes used in List parsers

   type Free_Parse_List_Record is record
      Nodes : Bare_Lkt_Node_Vectors.Vector;
      Next  : Free_Parse_List;
   end record;

   type Parser_Private_Part_Type is record
      Parse_Lists : Free_Parse_List;

      
      Args_List_Parse0_Memo : Bare_Argument_List_Memos.Memo_Type;
      
      Argument_Transform_Parse0_Memo : Bare_Argument_Memos.Memo_Type;
      
      Arith_1_Or_Parse1_Memo : Bare_Expr_Memos.Memo_Type;
      
      Arith_2_Or_Parse1_Memo : Bare_Expr_Memos.Memo_Type;
      
      Arith_3_Or_Parse1_Memo : Bare_Expr_Memos.Memo_Type;
      
      Array_Literal_Transform_Parse0_Memo : Bare_Array_Literal_Memos.Memo_Type;
      
      Bare_Decl_Or_Parse0_Memo : Bare_Decl_Memos.Memo_Type;
      
      Basic_Expr_Or_Parse0_Memo : Bare_Expr_Memos.Memo_Type;
      
      Basic_Name_Or_Parse0_Memo : Bare_Expr_Memos.Memo_Type;
      
      Big_Num_Lit_Transform_Parse0_Memo : Bare_Big_Num_Lit_Memos.Memo_Type;
      
      Block_String_Lit_Transform_Parse1_Memo : Bare_Block_String_Lit_Memos.Memo_Type;
      
      Block_Transform_Parse2_Memo : Bare_Block_Expr_Memos.Memo_Type;
      
      Bool_Pattern_Or_Parse0_Memo : Bare_Bool_Pattern_Memos.Memo_Type;
      
      Callable_Ref_Or_Parse0_Memo : Bare_Expr_Memos.Memo_Type;
      
      Char_Lit_Transform_Parse0_Memo : Bare_Char_Lit_Memos.Memo_Type;
      
      Decl_Annotation_Args_Opt_Parse0_Memo : Bare_Decl_Annotation_Args_Memos.Memo_Type;
      
      Decl_Annotation_Transform_Parse0_Memo : Bare_Decl_Annotation_Memos.Memo_Type;
      
      Decl_Block_List_Parse0_Memo : Bare_Decl_Block_Memos.Memo_Type;
      
      Decl_Transform_Parse0_Memo : Bare_Full_Decl_Memos.Memo_Type;
      
      Decls_List_Parse0_Memo : Bare_Full_Decl_List_Memos.Memo_Type;
      
      Def_Id_Transform_Parse0_Memo : Bare_Def_Id_Memos.Memo_Type;
      
      Doc_Opt_Parse0_Memo : Bare_String_Lit_Memos.Memo_Type;
      
      Dontskip_Block0_Extract_Parse0_Memo : Bare_Lkt_Node_Memos.Memo_Type;
      
      Dynvar_Decl_Transform_Parse0_Memo : Bare_Dyn_Var_Decl_Memos.Memo_Type;
      
      Ellipsis_Pattern_Transform_Parse0_Memo : Bare_Ellipsis_Pattern_Memos.Memo_Type;
      
      Enum_Lit_Decl_Transform_Parse0_Memo : Bare_Enum_Lit_Decl_Memos.Memo_Type;
      
      Env_Spec_Action_Transform_Parse1_Memo : Bare_Call_Expr_Memos.Memo_Type;
      
      Env_Spec_Decl_Transform_Parse1_Memo : Bare_Env_Spec_Decl_Memos.Memo_Type;
      
      Eq_Or_Parse1_Memo : Bare_Expr_Memos.Memo_Type;
      
      Expr_Or_Parse1_Memo : Bare_Expr_Memos.Memo_Type;
      
      Field_Decl_Transform_Parse0_Memo : Bare_Field_Decl_Memos.Memo_Type;
      
      Fil_Pattern_Or_Parse0_Memo : Bare_Pattern_Memos.Memo_Type;
      
      Fun_Decl_Transform_Parse0_Memo : Bare_Fun_Decl_Memos.Memo_Type;
      
      Fun_Param_Decl_Transform_Parse0_Memo : Bare_Fun_Param_Decl_Memos.Memo_Type;
      
      Fun_Param_List_List_Parse0_Memo : Bare_Fun_Param_Decl_List_Memos.Memo_Type;
      
      Generic_Decl_Transform_Parse0_Memo : Bare_Generic_Decl_Memos.Memo_Type;
      
      Generic_Param_Type_Transform_Parse1_Memo : Bare_Full_Decl_Memos.Memo_Type;
      
      Grammar_Cut_Transform_Parse0_Memo : Bare_Grammar_Cut_Memos.Memo_Type;
      
      Grammar_Decl_Transform_Parse0_Memo : Bare_Grammar_Decl_Memos.Memo_Type;
      
      Grammar_Discard_Expr_Transform_Parse0_Memo : Bare_Grammar_Discard_Memos.Memo_Type;
      
      Grammar_Expr_Or_Parse0_Memo : Bare_Grammar_Expr_Memos.Memo_Type;
      
      Grammar_Implicit_Pick_Transform_Parse0_Memo : Bare_Grammar_Implicit_Pick_Memos.Memo_Type;
      
      Grammar_List_Expr_Transform_Parse3_Memo : Bare_Grammar_List_Memos.Memo_Type;
      
      Grammar_List_Sep_Transform_Parse0_Memo : Bare_Grammar_List_Sep_Memos.Memo_Type;
      
      Grammar_Null_Transform_Parse0_Memo : Bare_Grammar_Null_Memos.Memo_Type;
      
      Grammar_Opt_Error_Or_Parse0_Memo : Bare_Grammar_Expr_Memos.Memo_Type;
      
      Grammar_Opt_Or_Parse0_Memo : Bare_Grammar_Expr_Memos.Memo_Type;
      
      Grammar_Or_Expr_Transform_Parse0_Memo : Bare_Grammar_Or_Expr_Memos.Memo_Type;
      
      Grammar_Pick_Transform_Parse0_Memo : Bare_Grammar_Pick_Memos.Memo_Type;
      
      Grammar_Primary_Or_Parse0_Memo : Bare_Grammar_Expr_Memos.Memo_Type;
      
      Grammar_Rule_Ref_Transform_Parse0_Memo : Bare_Grammar_Rule_Ref_Memos.Memo_Type;
      
      Grammar_Rule_Transform_Parse0_Memo : Bare_Grammar_Rule_Decl_Memos.Memo_Type;
      
      Grammar_Skip_Transform_Parse0_Memo : Bare_Grammar_Skip_Memos.Memo_Type;
      
      Grammar_Stopcut_Transform_Parse0_Memo : Bare_Grammar_Stop_Cut_Memos.Memo_Type;
      
      Grammar_Token_Transform_Parse0_Memo : Bare_Token_Ref_Memos.Memo_Type;
      
      Id_Transform_Parse0_Memo : Bare_Id_Memos.Memo_Type;
      
      If_Expr_Transform_Parse1_Memo : Bare_If_Expr_Memos.Memo_Type;
      
      Import_Stmt_Transform_Parse1_Memo : Bare_Import_Memos.Memo_Type;
      
      Imports_List_Parse0_Memo : Bare_Import_List_Memos.Memo_Type;
      
      Integer_Pattern_Transform_Parse0_Memo : Bare_Integer_Pattern_Memos.Memo_Type;
      
      Isa_Or_Primary_Or_Parse0_Memo : Bare_Expr_Memos.Memo_Type;
      
      Lambda_Expr_Transform_Parse0_Memo : Bare_Lambda_Expr_Memos.Memo_Type;
      
      Lambda_Param_Decl_Transform_Parse0_Memo : Bare_Lambda_Param_Decl_Memos.Memo_Type;
      
      Lambda_Param_List_List_Parse0_Memo : Bare_Lambda_Param_Decl_List_Memos.Memo_Type;
      
      Lexer_Case_Alt_Or_Parse0_Memo : Bare_Base_Lexer_Case_Rule_Alt_Memos.Memo_Type;
      
      Lexer_Case_Rule_Transform_Parse0_Memo : Bare_Lexer_Case_Rule_Memos.Memo_Type;
      
      Lexer_Case_Send_Transform_Parse0_Memo : Bare_Lexer_Case_Rule_Send_Memos.Memo_Type;
      
      Lexer_Decl_Transform_Parse0_Memo : Bare_Lexer_Decl_Memos.Memo_Type;
      
      Lexer_Family_Decl_Transform_Parse1_Memo : Bare_Full_Decl_Memos.Memo_Type;
      
      Lexer_Rule_Or_Parse0_Memo : Bare_Lkt_Node_Memos.Memo_Type;
      
      List_Pattern_Transform_Parse0_Memo : Bare_List_Pattern_Memos.Memo_Type;
      
      Logic_Propagate_Call_Transform_Parse0_Memo : Bare_Logic_Propagate_Call_Memos.Memo_Type;
      
      Main_Rule_Transform_Parse0_Memo : Bare_Langkit_Root_Memos.Memo_Type;
      
      Match_Expr_Transform_Parse3_Memo : Bare_Match_Expr_Memos.Memo_Type;
      
      Null_Cond_Qual_Opt_Parse0_Memo : Bare_Null_Cond_Qualifier_Memos.Memo_Type;
      
      Null_Lit_Transform_Parse0_Memo : Bare_Null_Lit_Memos.Memo_Type;
      
      Num_Lit_Transform_Parse0_Memo : Bare_Num_Lit_Memos.Memo_Type;
      
      Parse_Node_Expr_Transform_Parse0_Memo : Bare_Parse_Node_Expr_Memos.Memo_Type;
      
      Pattern_Arg_Or_Parse0_Memo : Bare_Pattern_Detail_Memos.Memo_Type;
      
      Pattern_Or_Parse0_Memo : Bare_Pattern_Memos.Memo_Type;
      
      Primary_Or_Parse0_Memo : Bare_Expr_Memos.Memo_Type;
      
      Raise_Expr_Transform_Parse0_Memo : Bare_Raise_Expr_Memos.Memo_Type;
      
      Ref_Id_Transform_Parse0_Memo : Bare_Ref_Id_Memos.Memo_Type;
      
      Regex_Pattern_Transform_Parse0_Memo : Bare_Regex_Pattern_Memos.Memo_Type;
      
      Rel_Or_Parse0_Memo : Bare_Expr_Memos.Memo_Type;
      
      Selector_Call_Transform_Parse0_Memo : Bare_Selector_Call_Memos.Memo_Type;
      
      String_Lit_Or_Parse0_Memo : Bare_String_Lit_Memos.Memo_Type;
      
      Term_Or_Parse0_Memo : Bare_Expr_Memos.Memo_Type;
      
      Token_Literal_Transform_Parse0_Memo : Bare_Token_Lit_Memos.Memo_Type;
      
      Token_No_Case_Literal_Transform_Parse0_Memo : Bare_Token_No_Case_Lit_Memos.Memo_Type;
      
      Token_Pattern_Literal_Transform_Parse0_Memo : Bare_Token_Pattern_Lit_Memos.Memo_Type;
      
      Token_Pattern_Or_Parse0_Memo : Bare_Grammar_Expr_Memos.Memo_Type;
      
      Try_Expr_Transform_Parse0_Memo : Bare_Try_Expr_Memos.Memo_Type;
      
      Tuple_Pattern_Transform_Parse0_Memo : Bare_Tuple_Pattern_Memos.Memo_Type;
      
      Type_Decl_Or_Parse0_Memo : Bare_Named_Type_Decl_Memos.Memo_Type;
      
      Type_Expr_Or_Parse0_Memo : Bare_Expr_Memos.Memo_Type;
      
      Type_List_List_Parse0_Memo : Bare_Type_Ref_List_Memos.Memo_Type;
      
      Type_Member_Ref_Transform_Parse0_Memo : Bare_Dot_Expr_Memos.Memo_Type;
      
      Type_Ref_Id_Predicate_Parse0_Memo : Bare_Ref_Id_Memos.Memo_Type;
      
      Type_Ref_Or_Parse0_Memo : Bare_Type_Ref_Memos.Memo_Type;
      
      Val_Decl_Transform_Parse0_Memo : Bare_Val_Decl_Memos.Memo_Type;
      
      Value_Pattern_Or_Parse1_Memo : Bare_Pattern_Memos.Memo_Type;
      
      Var_Bind_Transform_Parse0_Memo : Bare_Var_Bind_Memos.Memo_Type;

      Dont_Skip : Dont_Skip_Fn_Vectors.Vector;
   end record;
   type Parser_Private_Part is access all Parser_Private_Part_Type;
   pragma No_Strict_Aliasing (Parser_Private_Part);
   function "+" is new Ada.Unchecked_Conversion
     (System.Address, Parser_Private_Part);
   function "+" is new Ada.Unchecked_Conversion
     (Parser_Private_Part, System.Address);

   
function Args_List_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Argument_List;

   
function Argument_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Argument;

   
function Arith_1_Or_Parse1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr;

   
function Arith_2_Or_Parse1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr;

   
function Arith_3_Or_Parse1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr;

   
function Array_Literal_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Array_Literal;

   
function Bare_Decl_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Decl;

   
function Basic_Expr_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr;

   
function Basic_Name_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr;

   
function Big_Num_Lit_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Big_Num_Lit;

   
function Block_Transform_Parse2
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Block_Expr;

   
function Block_String_Lit_Transform_Parse1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Block_String_Lit;

   
function Bool_Pattern_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Bool_Pattern;

   
function Callable_Ref_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr;

   
function Char_Lit_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Char_Lit;

   
function Decl_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Full_Decl;

   
function Decl_Annotation_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Decl_Annotation;

   
function Decl_Annotation_Args_Opt_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Decl_Annotation_Args;

   
function Decl_Block_List_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Decl_Block;

   
function Decls_List_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Full_Decl_List;

   
function Def_Id_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Def_Id;

   
function Doc_Opt_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_String_Lit;

   
function Dontskip_Block0_Extract_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Lkt_Node;

   
function Dynvar_Decl_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Dyn_Var_Decl;

   
function Ellipsis_Pattern_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Ellipsis_Pattern;

   
function Enum_Lit_Decl_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Enum_Lit_Decl;

   
function Env_Spec_Action_Transform_Parse1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Call_Expr;

   
function Env_Spec_Decl_Transform_Parse1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Env_Spec_Decl;

   
function Eq_Or_Parse1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr;

   
function Expr_Or_Parse1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr;

   
function Field_Decl_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Field_Decl;

   
function Fil_Pattern_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Pattern;

   
function Fun_Decl_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Fun_Decl;

   
function Fun_Param_Decl_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Fun_Param_Decl;

   
function Fun_Param_List_List_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Fun_Param_Decl_List;

   
function Generic_Decl_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Generic_Decl;

   
function Generic_Param_Type_Transform_Parse1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Full_Decl;

   
function Grammar_Cut_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Grammar_Cut;

   
function Grammar_Decl_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Grammar_Decl;

   
function Grammar_Discard_Expr_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Grammar_Discard;

   
function Grammar_Expr_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Grammar_Expr;

   
function Grammar_Implicit_Pick_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Grammar_Implicit_Pick;

   
function Grammar_List_Expr_Transform_Parse3
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Grammar_List;

   
function Grammar_List_Sep_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Grammar_List_Sep;

   
function Grammar_Null_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Grammar_Null;

   
function Grammar_Opt_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Grammar_Expr;

   
function Grammar_Opt_Error_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Grammar_Expr;

   
function Grammar_Or_Expr_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Grammar_Or_Expr;

   
function Grammar_Pick_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Grammar_Pick;

   
function Grammar_Primary_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Grammar_Expr;

   
function Grammar_Rule_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Grammar_Rule_Decl;

   
function Grammar_Rule_Ref_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Grammar_Rule_Ref;

   
function Grammar_Skip_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Grammar_Skip;

   
function Grammar_Stopcut_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Grammar_Stop_Cut;

   
function Grammar_Token_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Token_Ref;

   
function Id_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Id;

   
function If_Expr_Transform_Parse1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_If_Expr;

   
function Import_Stmt_Transform_Parse1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Import;

   
function Imports_List_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Import_List;

   
function Integer_Pattern_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Integer_Pattern;

   
function Isa_Or_Primary_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr;

   
function Lambda_Expr_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Lambda_Expr;

   
function Lambda_Param_Decl_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Lambda_Param_Decl;

   
function Lambda_Param_List_List_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Lambda_Param_Decl_List;

   
function Lexer_Case_Alt_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Base_Lexer_Case_Rule_Alt;

   
function Lexer_Case_Rule_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Lexer_Case_Rule;

   
function Lexer_Case_Send_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Lexer_Case_Rule_Send;

   
function Lexer_Decl_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Lexer_Decl;

   
function Lexer_Family_Decl_Transform_Parse1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Full_Decl;

   
function Lexer_Rule_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Lkt_Node;

   
function List_Pattern_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_List_Pattern;

   
function Logic_Propagate_Call_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Logic_Propagate_Call;

   
function Main_Rule_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Langkit_Root;

   
function Match_Expr_Transform_Parse3
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Match_Expr;

   
function Null_Cond_Qual_Opt_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Null_Cond_Qualifier;

   
function Null_Lit_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Null_Lit;

   
function Num_Lit_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Num_Lit;

   
function Parse_Node_Expr_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Parse_Node_Expr;

   
function Pattern_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Pattern;

   
function Pattern_Arg_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Pattern_Detail;

   
function Primary_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr;

   
function Raise_Expr_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Raise_Expr;

   
function Ref_Id_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Ref_Id;

   
function Regex_Pattern_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Regex_Pattern;

   
function Rel_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr;

   
function Selector_Call_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Selector_Call;

   
function String_Lit_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_String_Lit;

   
function Term_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr;

   
function Token_Literal_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Token_Lit;

   
function Token_No_Case_Literal_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Token_No_Case_Lit;

   
function Token_Pattern_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Grammar_Expr;

   
function Token_Pattern_Literal_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Token_Pattern_Lit;

   
function Try_Expr_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Try_Expr;

   
function Tuple_Pattern_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Tuple_Pattern;

   
function Type_Decl_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Named_Type_Decl;

   
function Type_Expr_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr;

   
function Type_List_List_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Type_Ref_List;

   
function Type_Member_Ref_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Dot_Expr;

   
function Type_Ref_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Type_Ref;

   
function Type_Ref_Id_Predicate_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Ref_Id;

   
function Val_Decl_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Val_Decl;

   
function Value_Pattern_Or_Parse1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Pattern;

   
function Var_Bind_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Var_Bind;


   procedure Process_Parsing_Error
     (Parser         : in out Parser_Type;
      Check_Complete : Boolean := True);
   --  Helper for the user parsing function, to be called after a low-level
   --  parsing function. Check_Complete has the same semantics as in Parse. If
   --  the parsing failed (Parser.Current_Pos = No_Token_Index), append
   --  corresponding diagnostics to Parser.Diagnostics, do nothing instead.

   procedure Add_Last_Fail_Diagnostic (Parser : in out Parser_Type);
   --  Add a diagnostic for the last fail position of the parser

   pragma Warnings (Off, "is not referenced");

   function Get_Parse_List (Parser : Parser_Type) return Free_Parse_List;
   --  Get a free parse list, or allocate one if there is no free parse list in
   --  Parser. When done with the result, the caller must invoke
   --  Release_Parse_List.

   procedure Release_Parse_List
     (Parser : Parser_Type; List : in out Free_Parse_List);
   --  Release a parse list, putting it in Parsers' free list. Set List to
   --  null.

   procedure Initialize_List
     (Self   : Bare_Lkt_Node_Base_List;
      Parser : Parser_Type;
      Count  : Natural);
   --  Helper for parsers, to initialize the list of children in a freshly
   --  allocated list node.

   pragma Warnings (On, "is not referenced");

   ---------------------
   -- Initialize_List --
   ---------------------

   procedure Initialize_List
     (Self   : Bare_Lkt_Node_Base_List;
      Parser : Parser_Type;
      Count  : Natural) is
   begin
      Self.Count := Count;
      Self.Nodes := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, 0);
   end Initialize_List;

   -----------------
   -- Init_Parser --
   -----------------

   procedure Init_Parser
     (Input         : Lexer_Input;
      With_Trivia   : Boolean;
      Unit          : access Implementation.Analysis_Unit_Type;
      TDH           : Token_Data_Handler_Access;
      Parser        : in out Parser_Type;
      Old_TDH       : access constant Token_Data_Handler;
      Same_Contents : out Boolean)
   is
      --  Never try to use file readers for internal units: these are generally
      --  not actual source files, and file readers, which are external users
      --  of the generated library, have no reason to be aware of them.

      FR : constant Internal_File_Reader_Access :=
        (if Unit.Is_Internal
         then null
         else Unit.Context.File_Reader);
   begin
      Reset (Parser);
      Extract_Tokens
        (Input,
         With_Trivia,
         FR,
         TDH.all,
         Parser.Diagnostics,
         Old_TDH,
         Same_Contents);
      if Same_Contents then
         return;
      end if;
      Parser.Unit := Unit;
      Parser.TDH := TDH;
   end Init_Parser;

   ------------------------------
   -- Add_Last_Fail_Diagnostic --
   ------------------------------

   procedure Add_Last_Fail_Diagnostic (Parser : in out Parser_Type)
   is
      Last_Token : Stored_Token_Data renames
         Get_Token (Parser.TDH.all, Parser.Last_Fail.Pos);
      D : constant Diagnostic :=
        (if Parser.Last_Fail.Kind = Token_Fail then
          Create (Sloc_Range (Parser.TDH.all, Last_Token), To_Text
            ("Expected "
             & Token_Error_Image (Parser.Last_Fail.Expected_Token_Id)
             & ", got "
             & Token_Error_Image (Parser.Last_Fail.Found_Token_Id)))
         else
           Create (Sloc_Range (Parser.TDH.all, Last_Token),
                   To_Text (Parser.Last_Fail.Custom_Message.all)));
   begin
      Parser.Diagnostics.Append (D);
   end Add_Last_Fail_Diagnostic;

   ---------------------------
   -- Process_Parsing_Error --
   ---------------------------

   procedure Process_Parsing_Error
     (Parser         : in out Parser_Type;
      Check_Complete : Boolean := True) is
   begin

      if Parser.Current_Pos = No_Token_Index then
         Add_Last_Fail_Diagnostic (Parser);
      elsif Check_Complete
        and then Parser.Current_Pos /= Last_Token (Parser.TDH.all)
      then
         --  If the fail pos is the current position of the parser or after,
         --  it means that the longest parse is the correct result, and that we
         --  have some garbage afterwards.
         if Parser.Current_Pos >= Parser.Last_Fail.Pos then
            declare
               First_Garbage_Token : Stored_Token_Data renames
                  Get_Token (Parser.TDH.all, Parser.Current_Pos);
            begin
               Append
                 (Parser.Diagnostics,
                  Sloc_Range (Parser.TDH.all, First_Garbage_Token),
                  To_Text
                    ("End of input expected, got """
                     & Token_Kind_Name
                         (To_Token_Kind (First_Garbage_Token.Kind))
                     & """"));
            end;

         --  Else, the last fail pos is further down the line, and we want to
         --  have the diagnostic of what exactly failed.
         else
            Add_Last_Fail_Diagnostic (Parser);
         end if;
      end if;

   end Process_Parsing_Error;

   -----------
   -- Parse --
   -----------

   function Parse
     (Parser         : in out Parser_Type;
      Check_Complete : Boolean := True;
      Rule           : Grammar_Rule) return Parsed_Node
   is
      Result : Bare_Lkt_Node;
   begin
      case Rule is
         when Main_Rule_Rule =>
            Result := Main_Rule_Transform_Parse0
              (Parser, First_Token_Index);
         when Id_Rule =>
            Result := Id_Transform_Parse0
              (Parser, First_Token_Index);
         when Ref_Id_Rule =>
            Result := Ref_Id_Transform_Parse0
              (Parser, First_Token_Index);
         when Type_Ref_Id_Rule =>
            Result := Type_Ref_Id_Predicate_Parse0
              (Parser, First_Token_Index);
         when Def_Id_Rule =>
            Result := Def_Id_Transform_Parse0
              (Parser, First_Token_Index);
         when Doc_Rule =>
            Result := Doc_Opt_Parse0
              (Parser, First_Token_Index);
         when Import_Stmt_Rule =>
            Result := Import_Stmt_Transform_Parse1
              (Parser, First_Token_Index);
         when Imports_Rule =>
            Result := Imports_List_Parse0
              (Parser, First_Token_Index);
         when Lexer_Decl_Rule =>
            Result := Lexer_Decl_Transform_Parse0
              (Parser, First_Token_Index);
         when Grammar_Decl_Rule =>
            Result := Grammar_Decl_Transform_Parse0
              (Parser, First_Token_Index);
         when Grammar_Rule_Rule =>
            Result := Grammar_Rule_Transform_Parse0
              (Parser, First_Token_Index);
         when Lexer_Rule_Rule =>
            Result := Lexer_Rule_Or_Parse0
              (Parser, First_Token_Index);
         when Lexer_Family_Decl_Rule =>
            Result := Lexer_Family_Decl_Transform_Parse1
              (Parser, First_Token_Index);
         when Lexer_Case_Rule_Rule =>
            Result := Lexer_Case_Rule_Transform_Parse0
              (Parser, First_Token_Index);
         when Lexer_Case_Alt_Rule =>
            Result := Lexer_Case_Alt_Or_Parse0
              (Parser, First_Token_Index);
         when Lexer_Case_Send_Rule =>
            Result := Lexer_Case_Send_Transform_Parse0
              (Parser, First_Token_Index);
         when Grammar_Primary_Rule =>
            Result := Grammar_Primary_Or_Parse0
              (Parser, First_Token_Index);
         when Grammar_Expr_Rule =>
            Result := Grammar_Expr_Or_Parse0
              (Parser, First_Token_Index);
         when Grammar_Pick_Rule =>
            Result := Grammar_Pick_Transform_Parse0
              (Parser, First_Token_Index);
         when Grammar_Implicit_Pick_Rule =>
            Result := Grammar_Implicit_Pick_Transform_Parse0
              (Parser, First_Token_Index);
         when Grammar_Opt_Rule =>
            Result := Grammar_Opt_Or_Parse0
              (Parser, First_Token_Index);
         when Grammar_Opt_Error_Rule =>
            Result := Grammar_Opt_Error_Or_Parse0
              (Parser, First_Token_Index);
         when Grammar_Cut_Rule =>
            Result := Grammar_Cut_Transform_Parse0
              (Parser, First_Token_Index);
         when Grammar_Stopcut_Rule =>
            Result := Grammar_Stopcut_Transform_Parse0
              (Parser, First_Token_Index);
         when Grammar_Or_Expr_Rule =>
            Result := Grammar_Or_Expr_Transform_Parse0
              (Parser, First_Token_Index);
         when Grammar_Discard_Expr_Rule =>
            Result := Grammar_Discard_Expr_Transform_Parse0
              (Parser, First_Token_Index);
         when Token_Literal_Rule =>
            Result := Token_Literal_Transform_Parse0
              (Parser, First_Token_Index);
         when Token_No_Case_Literal_Rule =>
            Result := Token_No_Case_Literal_Transform_Parse0
              (Parser, First_Token_Index);
         when Token_Pattern_Rule =>
            Result := Token_Pattern_Or_Parse0
              (Parser, First_Token_Index);
         when Token_Pattern_Literal_Rule =>
            Result := Token_Pattern_Literal_Transform_Parse0
              (Parser, First_Token_Index);
         when Parse_Node_Expr_Rule =>
            Result := Parse_Node_Expr_Transform_Parse0
              (Parser, First_Token_Index);
         when Grammar_Rule_Ref_Rule =>
            Result := Grammar_Rule_Ref_Transform_Parse0
              (Parser, First_Token_Index);
         when Grammar_List_Expr_Rule =>
            Result := Grammar_List_Expr_Transform_Parse3
              (Parser, First_Token_Index);
         when Grammar_List_Sep_Rule =>
            Result := Grammar_List_Sep_Transform_Parse0
              (Parser, First_Token_Index);
         when Grammar_Skip_Rule =>
            Result := Grammar_Skip_Transform_Parse0
              (Parser, First_Token_Index);
         when Grammar_Null_Rule =>
            Result := Grammar_Null_Transform_Parse0
              (Parser, First_Token_Index);
         when Grammar_Token_Rule =>
            Result := Grammar_Token_Transform_Parse0
              (Parser, First_Token_Index);
         when Type_Decl_Rule =>
            Result := Type_Decl_Or_Parse0
              (Parser, First_Token_Index);
         when Generic_Decl_Rule =>
            Result := Generic_Decl_Transform_Parse0
              (Parser, First_Token_Index);
         when Generic_Param_Type_Rule =>
            Result := Generic_Param_Type_Transform_Parse1
              (Parser, First_Token_Index);
         when Enum_Lit_Decl_Rule =>
            Result := Enum_Lit_Decl_Transform_Parse0
              (Parser, First_Token_Index);
         when Fun_Decl_Rule =>
            Result := Fun_Decl_Transform_Parse0
              (Parser, First_Token_Index);
         when Lambda_Param_Decl_Rule =>
            Result := Lambda_Param_Decl_Transform_Parse0
              (Parser, First_Token_Index);
         when Fun_Param_Decl_Rule =>
            Result := Fun_Param_Decl_Transform_Parse0
              (Parser, First_Token_Index);
         when Fun_Param_List_Rule =>
            Result := Fun_Param_List_List_Parse0
              (Parser, First_Token_Index);
         when Lambda_Param_List_Rule =>
            Result := Lambda_Param_List_List_Parse0
              (Parser, First_Token_Index);
         when Field_Decl_Rule =>
            Result := Field_Decl_Transform_Parse0
              (Parser, First_Token_Index);
         when Bare_Decl_Rule =>
            Result := Bare_Decl_Or_Parse0
              (Parser, First_Token_Index);
         when Decl_Rule =>
            Result := Decl_Transform_Parse0
              (Parser, First_Token_Index);
         when Type_Member_Ref_Rule =>
            Result := Type_Member_Ref_Transform_Parse0
              (Parser, First_Token_Index);
         when Type_Expr_Rule =>
            Result := Type_Expr_Or_Parse0
              (Parser, First_Token_Index);
         when Type_Ref_Rule =>
            Result := Type_Ref_Or_Parse0
              (Parser, First_Token_Index);
         when Type_List_Rule =>
            Result := Type_List_List_Parse0
              (Parser, First_Token_Index);
         when Decls_Rule =>
            Result := Decls_List_Parse0
              (Parser, First_Token_Index);
         when Decl_Block_Rule =>
            Result := Decl_Block_List_Parse0
              (Parser, First_Token_Index);
         when Val_Decl_Rule =>
            Result := Val_Decl_Transform_Parse0
              (Parser, First_Token_Index);
         when Dynvar_Decl_Rule =>
            Result := Dynvar_Decl_Transform_Parse0
              (Parser, First_Token_Index);
         when Var_Bind_Rule =>
            Result := Var_Bind_Transform_Parse0
              (Parser, First_Token_Index);
         when Env_Spec_Action_Rule =>
            Result := Env_Spec_Action_Transform_Parse1
              (Parser, First_Token_Index);
         when Env_Spec_Decl_Rule =>
            Result := Env_Spec_Decl_Transform_Parse1
              (Parser, First_Token_Index);
         when Block_Rule =>
            Result := Block_Transform_Parse2
              (Parser, First_Token_Index);
         when Pattern_Rule =>
            Result := Pattern_Or_Parse0
              (Parser, First_Token_Index);
         when Fil_Pattern_Rule =>
            Result := Fil_Pattern_Or_Parse0
              (Parser, First_Token_Index);
         when Value_Pattern_Rule =>
            Result := Value_Pattern_Or_Parse1
              (Parser, First_Token_Index);
         when Regex_Pattern_Rule =>
            Result := Regex_Pattern_Transform_Parse0
              (Parser, First_Token_Index);
         when Bool_Pattern_Rule =>
            Result := Bool_Pattern_Or_Parse0
              (Parser, First_Token_Index);
         when Ellipsis_Pattern_Rule =>
            Result := Ellipsis_Pattern_Transform_Parse0
              (Parser, First_Token_Index);
         when Integer_Pattern_Rule =>
            Result := Integer_Pattern_Transform_Parse0
              (Parser, First_Token_Index);
         when List_Pattern_Rule =>
            Result := List_Pattern_Transform_Parse0
              (Parser, First_Token_Index);
         when Tuple_Pattern_Rule =>
            Result := Tuple_Pattern_Transform_Parse0
              (Parser, First_Token_Index);
         when Pattern_Arg_Rule =>
            Result := Pattern_Arg_Or_Parse0
              (Parser, First_Token_Index);
         when Selector_Call_Rule =>
            Result := Selector_Call_Transform_Parse0
              (Parser, First_Token_Index);
         when Expr_Rule =>
            Result := Expr_Or_Parse1
              (Parser, First_Token_Index);
         when Rel_Rule =>
            Result := Rel_Or_Parse0
              (Parser, First_Token_Index);
         when Eq_Rule =>
            Result := Eq_Or_Parse1
              (Parser, First_Token_Index);
         when Arith_1_Rule =>
            Result := Arith_1_Or_Parse1
              (Parser, First_Token_Index);
         when Arith_2_Rule =>
            Result := Arith_2_Or_Parse1
              (Parser, First_Token_Index);
         when Arith_3_Rule =>
            Result := Arith_3_Or_Parse1
              (Parser, First_Token_Index);
         when Isa_Or_Primary_Rule =>
            Result := Isa_Or_Primary_Or_Parse0
              (Parser, First_Token_Index);
         when Logic_Propagate_Call_Rule =>
            Result := Logic_Propagate_Call_Transform_Parse0
              (Parser, First_Token_Index);
         when Primary_Rule =>
            Result := Primary_Or_Parse0
              (Parser, First_Token_Index);
         when Match_Expr_Rule =>
            Result := Match_Expr_Transform_Parse3
              (Parser, First_Token_Index);
         when Num_Lit_Rule =>
            Result := Num_Lit_Transform_Parse0
              (Parser, First_Token_Index);
         when Big_Num_Lit_Rule =>
            Result := Big_Num_Lit_Transform_Parse0
              (Parser, First_Token_Index);
         when String_Lit_Rule =>
            Result := String_Lit_Or_Parse0
              (Parser, First_Token_Index);
         when Block_String_Lit_Rule =>
            Result := Block_String_Lit_Transform_Parse1
              (Parser, First_Token_Index);
         when Char_Lit_Rule =>
            Result := Char_Lit_Transform_Parse0
              (Parser, First_Token_Index);
         when If_Expr_Rule =>
            Result := If_Expr_Transform_Parse1
              (Parser, First_Token_Index);
         when Raise_Expr_Rule =>
            Result := Raise_Expr_Transform_Parse0
              (Parser, First_Token_Index);
         when Try_Expr_Rule =>
            Result := Try_Expr_Transform_Parse0
              (Parser, First_Token_Index);
         when Array_Literal_Rule =>
            Result := Array_Literal_Transform_Parse0
              (Parser, First_Token_Index);
         when Callable_Ref_Rule =>
            Result := Callable_Ref_Or_Parse0
              (Parser, First_Token_Index);
         when Null_Cond_Qual_Rule =>
            Result := Null_Cond_Qual_Opt_Parse0
              (Parser, First_Token_Index);
         when Basic_Expr_Rule =>
            Result := Basic_Expr_Or_Parse0
              (Parser, First_Token_Index);
         when Term_Rule =>
            Result := Term_Or_Parse0
              (Parser, First_Token_Index);
         when Basic_Name_Rule =>
            Result := Basic_Name_Or_Parse0
              (Parser, First_Token_Index);
         when Lambda_Expr_Rule =>
            Result := Lambda_Expr_Transform_Parse0
              (Parser, First_Token_Index);
         when Null_Lit_Rule =>
            Result := Null_Lit_Transform_Parse0
              (Parser, First_Token_Index);
         when Argument_Rule =>
            Result := Argument_Transform_Parse0
              (Parser, First_Token_Index);
         when Args_Rule =>
            Result := Args_List_Parse0
              (Parser, First_Token_Index);
         when Decl_Annotation_Args_Rule =>
            Result := Decl_Annotation_Args_Opt_Parse0
              (Parser, First_Token_Index);
         when Decl_Annotation_Rule =>
            Result := Decl_Annotation_Transform_Parse0
              (Parser, First_Token_Index);
      end case;
      Process_Parsing_Error (Parser, Check_Complete);
      Set_Parents (Result, null);
      return Parsed_Node (Result);
   exception
      when Exc : Property_Error =>
         Append
           (Parser.Diagnostics,
            No_Source_Location_Range,
            To_Text ("Error during parsing: "
                     & Ada.Exceptions.Exception_Message (Exc)));
         return Parsed_Node (No_Bare_Lkt_Node);
   end Parse;

   


function Args_List_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Argument_List
is
   use Bare_Argument_List_Memos;

      Lst_Cpos0 :
            Token_Index
               := No_Token_Index;
      Tmp_List0 :
            Free_Parse_List;
      Defer_Pos0 :
            Token_Index
               := No_Token_Index;
      Defer_Res0 :
            Bare_Argument
               := No_Bare_Lkt_Node;
      Token_Pos0 :
            Token_Index
               := No_Token_Index;
      Token_Res0 :
            Token_Index
               := No_Token_Index;
      List_Pos0 :
            Token_Index
               := No_Token_Index;
      List_Res0 :
            Bare_Argument_List
               := No_Bare_Lkt_Node;


   PP : constant Parser_Private_Part := +Parser.Private_Part;
   M  : Memo_Entry := Get (PP.Args_List_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      List_Res0 := M.Instance;
      return List_Res0;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return List_Res0;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  BEGIN <List (root of 'args') at parser.lkt:428:13>

    List_Pos0 := Pos;



Lst_Cpos0 := Pos;
Tmp_List0 := Get_Parse_List (Parser);


loop
   
--  BEGIN <Defer (for 'argument') at parser.lkt:428:19>

Defer_Res0 :=
   Argument_Transform_Parse0 (Parser, Lst_Cpos0);
Defer_Pos0 := Parser.Current_Pos;

--  END <Defer (for 'argument') at parser.lkt:428:19>


   exit when Defer_Pos0 = No_Token_Index;

   List_Pos0 := Defer_Pos0;
   Lst_Cpos0 := List_Pos0;

   Tmp_List0.Nodes.Append (Defer_Res0);

      
--  BEGIN <Token(<WithText Comma>, ) (root of 'args') at parser.lkt:428:29>

Token_Res0 := Lst_Cpos0;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res0));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_Comma)
   then
       Token_Pos0 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Lst_Cpos0 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Lst_Cpos0,
             Expected_Token_Id => Lkt_Comma,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos0 := Lst_Cpos0 + 1;
   end if;
end;

--  END <Token(<WithText Comma>, ) (root of 'args') at parser.lkt:428:29>


      exit when Token_Pos0 = No_Token_Index;

      Lst_Cpos0 := Token_Pos0;

end loop;


declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List0.Nodes.Length;
begin
   List_Res0 := Allocate_Argument_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Pos;
      Token_End := (if Lst_Cpos0 = Pos
                    then Pos
                    else List_Pos0 - 1);

   else
      Token_Start := Token_Index'Max (Pos, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res0,
      Kind              => Lkt_Argument_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res0,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_Lkt_Node_Vectors.Vector renames
         Tmp_List0.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res0.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List0);

--  END <List (root of 'args') at parser.lkt:428:13>


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (PP.Args_List_Parse0_Memo,
      List_Pos0 /= No_Token_Index,
      List_Res0,
      Pos,
      List_Pos0);


   Parser.Current_Pos := List_Pos0;

   return List_Res0;
end Args_List_Parse0;

   


function Argument_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Argument
is
   use Bare_Argument_Memos;

      Row_Pos0 :
            Token_Index
               := No_Token_Index;
      Row_Pos1 :
            Token_Index
               := No_Token_Index;
      Defer_Pos1 :
            Token_Index
               := No_Token_Index;
      Defer_Res1 :
            Bare_Ref_Id
               := No_Bare_Lkt_Node;
      Token_Pos1 :
            Token_Index
               := No_Token_Index;
      Token_Res1 :
            Token_Index
               := No_Token_Index;
      Defer_Pos2 :
            Token_Index
               := No_Token_Index;
      Defer_Res2 :
            Bare_Expr
               := No_Bare_Lkt_Node;
      Transform_Res0 :
            Bare_Argument
               := No_Bare_Lkt_Node;
      Transform_Diags0 :
            Ada.Containers.Count_Type;


   PP : constant Parser_Private_Part := +Parser.Private_Part;
   M  : Memo_Entry := Get (PP.Argument_Transform_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res0 := M.Instance;
      return Transform_Res0;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res0;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  BEGIN <Transform(<ASTNodeType Argument>) (root of 'argument') at parser.lkt:427:17>

Transform_Diags0 := Parser.Diagnostics.Length;


--  BEGIN <_Row (root of 'argument') at parser.lkt:427:17>

Row_Pos0 := Pos;



--  BEGIN <Opt (root of 'argument') at parser.lkt:427:26>












--  BEGIN <_Extract (root of 'argument') at parser.lkt:427:27>

--  BEGIN <_Row (root of 'argument') at parser.lkt:427:27>

Row_Pos1 := Row_Pos0;



--  BEGIN <Defer (for 'ref_id') at parser.lkt:427:32>

Defer_Res1 :=
   Ref_Id_Transform_Parse0 (Parser, Row_Pos1);
Defer_Pos1 := Parser.Current_Pos;

--  END <Defer (for 'ref_id') at parser.lkt:427:32>




if Defer_Pos1 /= No_Token_Index then

   Row_Pos1 := Defer_Pos1;

else
   Row_Pos1 := No_Token_Index;
   goto Exit_Row1_0;

end if;


--  BEGIN <Token(<WithText Equal>, ) (root of 'argument') at parser.lkt:427:39>

Token_Res1 := Row_Pos1;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res1));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_Equal)
   then
       Token_Pos1 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos1 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos1,
             Expected_Token_Id => Lkt_Equal,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos1 := Row_Pos1 + 1;
   end if;
end;

--  END <Token(<WithText Equal>, ) (root of 'argument') at parser.lkt:427:39>




if Token_Pos1 /= No_Token_Index then

   Row_Pos1 := Token_Pos1;

else
   Row_Pos1 := No_Token_Index;
   goto Exit_Row1_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row1_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'argument') at parser.lkt:427:27>

--  END <_Extract (root of 'argument') at parser.lkt:427:27>


if Row_Pos1 = No_Token_Index then

         
   Defer_Res1 := No_Bare_Lkt_Node;



       
   Row_Pos1 := Row_Pos0;



end if;

--  END <Opt (root of 'argument') at parser.lkt:427:26>




if Row_Pos1 /= No_Token_Index then

   Row_Pos0 := Row_Pos1;

else
   Row_Pos0 := No_Token_Index;
   goto Exit_Row0_0;

end if;


--  BEGIN <Defer (for 'expr') at parser.lkt:427:44>

Defer_Res2 :=
   Expr_Or_Parse1 (Parser, Row_Pos0);
Defer_Pos2 := Parser.Current_Pos;

--  END <Defer (for 'expr') at parser.lkt:427:44>




if Defer_Pos2 /= No_Token_Index then

   Row_Pos0 := Defer_Pos2;

else
   Row_Pos0 := No_Token_Index;
   goto Exit_Row0_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row0_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'argument') at parser.lkt:427:17>



if Row_Pos0 /= No_Token_Index then

   Transform_Res0 := Allocate_Argument (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res0,
      Kind => Lkt_Argument,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos0 = Pos
                            then No_Token_Index
                            else Row_Pos0 - 1));

      
      Initialize_Fields_For_Argument
        (Self => Transform_Res0,
         Argument_F_Name => Defer_Res1,
         Argument_F_Value => Defer_Res2);

         if Defer_Res1 /= null and then Is_Incomplete (Defer_Res1) then
            Transform_Res0.Last_Attempted_Child := 0;
         elsif Defer_Res1 /= null and then not Is_Ghost (Defer_Res1) then
            Transform_Res0.Last_Attempted_Child := -1;
         end if;
         if Defer_Res2 /= null and then Is_Incomplete (Defer_Res2) then
            Transform_Res0.Last_Attempted_Child := 0;
         elsif Defer_Res2 /= null and then not Is_Ghost (Defer_Res2) then
            Transform_Res0.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos0 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags0);
end if;

--  END <Transform(<ASTNodeType Argument>) (root of 'argument') at parser.lkt:427:17>


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (PP.Argument_Transform_Parse0_Memo,
      Row_Pos0 /= No_Token_Index,
      Transform_Res0,
      Pos,
      Row_Pos0);


   Parser.Current_Pos := Row_Pos0;

   return Transform_Res0;
end Argument_Transform_Parse0;

   


function Arith_1_Or_Parse1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr
is
   use Bare_Expr_Memos;

      Row_Pos2 :
            Token_Index
               := No_Token_Index;
      Defer_Pos3 :
            Token_Index
               := No_Token_Index;
      Defer_Res3 :
            Bare_Expr
               := No_Bare_Lkt_Node;
      Row_Pos3 :
            Token_Index
               := No_Token_Index;
      Token_Pos2 :
            Token_Index
               := No_Token_Index;
      Token_Res2 :
            Token_Index
               := No_Token_Index;
      Transform_Res1 :
            Bare_Op_Plus
               := No_Bare_Lkt_Node;
      Transform_Diags1 :
            Ada.Containers.Count_Type;
      Row_Pos4 :
            Token_Index
               := No_Token_Index;
      Token_Pos3 :
            Token_Index
               := No_Token_Index;
      Token_Res3 :
            Token_Index
               := No_Token_Index;
      Transform_Res2 :
            Bare_Op_Minus
               := No_Bare_Lkt_Node;
      Transform_Diags2 :
            Ada.Containers.Count_Type;
      Row_Pos5 :
            Token_Index
               := No_Token_Index;
      Token_Pos4 :
            Token_Index
               := No_Token_Index;
      Token_Res4 :
            Token_Index
               := No_Token_Index;
      Transform_Res3 :
            Bare_Op_Amp
               := No_Bare_Lkt_Node;
      Transform_Diags3 :
            Ada.Containers.Count_Type;
      Or_Pos0 :
            Token_Index
               := No_Token_Index;
      Or_Res0 :
            Bare_Op
               := No_Bare_Lkt_Node;
      Defer_Pos4 :
            Token_Index
               := No_Token_Index;
      Defer_Res4 :
            Bare_Expr
               := No_Bare_Lkt_Node;
      Transform_Res4 :
            Bare_Bin_Op
               := No_Bare_Lkt_Node;
      Transform_Diags4 :
            Ada.Containers.Count_Type;
      Defer_Pos5 :
            Token_Index
               := No_Token_Index;
      Defer_Res5 :
            Bare_Expr
               := No_Bare_Lkt_Node;
      Or_Pos1 :
            Token_Index
               := No_Token_Index;
      Or_Res1 :
            Bare_Expr
               := No_Bare_Lkt_Node;

      Mem_Pos : Token_Index := Pos;
      Mem_Res : Bare_Expr := No_Bare_Lkt_Node;

   PP : constant Parser_Private_Part := +Parser.Private_Part;
   M  : Memo_Entry := Get (PP.Arith_1_Or_Parse1_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Or_Res1 := M.Instance;
      return Or_Res1;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Or_Res1;
   end if;

       Set (PP.Arith_1_Or_Parse1_Memo, False, Or_Res1, Pos, Mem_Pos);

       <<Try_Again>>



   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  BEGIN <Or (root of 'arith_1') at parser.lkt:323:16>

Or_Pos1 := No_Token_Index;
Or_Res1 := No_Bare_Lkt_Node;
    
--  BEGIN <Transform(<ASTNodeType BinOp>) (root of 'arith_1') at parser.lkt:324:11>

Transform_Diags4 := Parser.Diagnostics.Length;


--  BEGIN <_Row (root of 'arith_1') at parser.lkt:324:11>

Row_Pos2 := Pos;



--  BEGIN <Defer (for 'arith_1') at parser.lkt:324:17>

Defer_Res3 :=
   Arith_1_Or_Parse1 (Parser, Row_Pos2);
Defer_Pos3 := Parser.Current_Pos;

--  END <Defer (for 'arith_1') at parser.lkt:324:17>




if Defer_Pos3 /= No_Token_Index then

   Row_Pos2 := Defer_Pos3;

else
   Row_Pos2 := No_Token_Index;
   goto Exit_Row2_0;

end if;


--  BEGIN <Or (root of 'arith_1') at parser.lkt:324:25>

Or_Pos0 := No_Token_Index;
Or_Res0 := No_Bare_Lkt_Node;
    
--  BEGIN <Transform(<ASTNodeType Op.Plus>) (root of 'arith_1') at parser.lkt:324:28>

Transform_Diags1 := Parser.Diagnostics.Length;


--  BEGIN <_Row (root of 'arith_1') at parser.lkt:324:28>

Row_Pos3 := Row_Pos2;



--  BEGIN <Token(<WithText Plus>, ) (root of 'arith_1') at parser.lkt:324:36>

Token_Res2 := Row_Pos3;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res2));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_Plus)
   then
       Token_Pos2 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos3 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos3,
             Expected_Token_Id => Lkt_Plus,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos2 := Row_Pos3 + 1;
   end if;
end;

--  END <Token(<WithText Plus>, ) (root of 'arith_1') at parser.lkt:324:36>




if Token_Pos2 /= No_Token_Index then

   Row_Pos3 := Token_Pos2;

else
   Row_Pos3 := No_Token_Index;
   goto Exit_Row3_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row3_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'arith_1') at parser.lkt:324:28>



if Row_Pos3 /= No_Token_Index then

   Transform_Res1 := Allocate_Op_Plus (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res1,
      Kind => Lkt_Op_Plus,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos2,
      Token_End_Index   => (if Row_Pos3 = Row_Pos2
                            then No_Token_Index
                            else Row_Pos3 - 1));




elsif Row_Pos3 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags1);
end if;

--  END <Transform(<ASTNodeType Op.Plus>) (root of 'arith_1') at parser.lkt:324:28>

    if Row_Pos3 /= No_Token_Index then
        Or_Pos0 := Row_Pos3;
        Or_Res0 := Transform_Res1;
        goto Exit_Or1;
    end if;
    
--  BEGIN <Transform(<ASTNodeType Op.Minus>) (root of 'arith_1') at parser.lkt:324:43>

Transform_Diags2 := Parser.Diagnostics.Length;


--  BEGIN <_Row (root of 'arith_1') at parser.lkt:324:43>

Row_Pos4 := Row_Pos2;



--  BEGIN <Token(<WithText Minus>, ) (root of 'arith_1') at parser.lkt:324:52>

Token_Res3 := Row_Pos4;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res3));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_Minus)
   then
       Token_Pos3 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos4 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos4,
             Expected_Token_Id => Lkt_Minus,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos3 := Row_Pos4 + 1;
   end if;
end;

--  END <Token(<WithText Minus>, ) (root of 'arith_1') at parser.lkt:324:52>




if Token_Pos3 /= No_Token_Index then

   Row_Pos4 := Token_Pos3;

else
   Row_Pos4 := No_Token_Index;
   goto Exit_Row4_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row4_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'arith_1') at parser.lkt:324:43>



if Row_Pos4 /= No_Token_Index then

   Transform_Res2 := Allocate_Op_Minus (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res2,
      Kind => Lkt_Op_Minus,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos2,
      Token_End_Index   => (if Row_Pos4 = Row_Pos2
                            then No_Token_Index
                            else Row_Pos4 - 1));




elsif Row_Pos4 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags2);
end if;

--  END <Transform(<ASTNodeType Op.Minus>) (root of 'arith_1') at parser.lkt:324:43>

    if Row_Pos4 /= No_Token_Index then
        Or_Pos0 := Row_Pos4;
        Or_Res0 := Transform_Res2;
        goto Exit_Or1;
    end if;
    
--  BEGIN <Transform(<ASTNodeType Op.Amp>) (root of 'arith_1') at parser.lkt:324:59>

Transform_Diags3 := Parser.Diagnostics.Length;


--  BEGIN <_Row (root of 'arith_1') at parser.lkt:324:59>

Row_Pos5 := Row_Pos2;



--  BEGIN <Token(<WithText Amp>, ) (root of 'arith_1') at parser.lkt:324:66>

Token_Res4 := Row_Pos5;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res4));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_Amp)
   then
       Token_Pos4 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos5 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos5,
             Expected_Token_Id => Lkt_Amp,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos4 := Row_Pos5 + 1;
   end if;
end;

--  END <Token(<WithText Amp>, ) (root of 'arith_1') at parser.lkt:324:66>




if Token_Pos4 /= No_Token_Index then

   Row_Pos5 := Token_Pos4;

else
   Row_Pos5 := No_Token_Index;
   goto Exit_Row5_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row5_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'arith_1') at parser.lkt:324:59>



if Row_Pos5 /= No_Token_Index then

   Transform_Res3 := Allocate_Op_Amp (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res3,
      Kind => Lkt_Op_Amp,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos2,
      Token_End_Index   => (if Row_Pos5 = Row_Pos2
                            then No_Token_Index
                            else Row_Pos5 - 1));




elsif Row_Pos5 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags3);
end if;

--  END <Transform(<ASTNodeType Op.Amp>) (root of 'arith_1') at parser.lkt:324:59>

    if Row_Pos5 /= No_Token_Index then
        Or_Pos0 := Row_Pos5;
        Or_Res0 := Transform_Res3;
        goto Exit_Or1;
    end if;
<<Exit_Or1>>

--  END <Or (root of 'arith_1') at parser.lkt:324:25>




if Or_Pos0 /= No_Token_Index then

   Row_Pos2 := Or_Pos0;

else
   Row_Pos2 := No_Token_Index;
   goto Exit_Row2_0;

end if;


--  BEGIN <Defer (for 'arith_2') at parser.lkt:324:72>

Defer_Res4 :=
   Arith_2_Or_Parse1 (Parser, Row_Pos2);
Defer_Pos4 := Parser.Current_Pos;

--  END <Defer (for 'arith_2') at parser.lkt:324:72>




if Defer_Pos4 /= No_Token_Index then

   Row_Pos2 := Defer_Pos4;

else
   Row_Pos2 := No_Token_Index;
   goto Exit_Row2_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row2_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'arith_1') at parser.lkt:324:11>



if Row_Pos2 /= No_Token_Index then

   Transform_Res4 := Allocate_Bin_Op (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res4,
      Kind => Lkt_Bin_Op,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos2 = Pos
                            then No_Token_Index
                            else Row_Pos2 - 1));

      
      Initialize_Fields_For_Bin_Op
        (Self => Transform_Res4,
         Bin_Op_F_Left => Defer_Res3,
         Bin_Op_F_Op => Or_Res0,
         Bin_Op_F_Right => Defer_Res4);

         if Defer_Res3 /= null and then Is_Incomplete (Defer_Res3) then
            Transform_Res4.Last_Attempted_Child := 0;
         elsif Defer_Res3 /= null and then not Is_Ghost (Defer_Res3) then
            Transform_Res4.Last_Attempted_Child := -1;
         end if;
         if Or_Res0 /= null and then Is_Incomplete (Or_Res0) then
            Transform_Res4.Last_Attempted_Child := 0;
         elsif Or_Res0 /= null and then not Is_Ghost (Or_Res0) then
            Transform_Res4.Last_Attempted_Child := -1;
         end if;
         if Defer_Res4 /= null and then Is_Incomplete (Defer_Res4) then
            Transform_Res4.Last_Attempted_Child := 0;
         elsif Defer_Res4 /= null and then not Is_Ghost (Defer_Res4) then
            Transform_Res4.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos2 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags4);
end if;

--  END <Transform(<ASTNodeType BinOp>) (root of 'arith_1') at parser.lkt:324:11>

    if Row_Pos2 /= No_Token_Index then
        Or_Pos1 := Row_Pos2;
        Or_Res1 := Transform_Res4;
        goto Exit_Or0;
    end if;
    
--  BEGIN <Defer (for 'arith_2') at parser.lkt:325:11>

Defer_Res5 :=
   Arith_2_Or_Parse1 (Parser, Pos);
Defer_Pos5 := Parser.Current_Pos;

--  END <Defer (for 'arith_2') at parser.lkt:325:11>

    if Defer_Pos5 /= No_Token_Index then
        Or_Pos1 := Defer_Pos5;
        Or_Res1 := Defer_Res5;
        goto Exit_Or0;
    end if;
<<Exit_Or0>>

--  END <Or (root of 'arith_1') at parser.lkt:323:16>


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------

      if Or_Pos1 > Mem_Pos then
         Mem_Pos := Or_Pos1;
         Mem_Res := Or_Res1;
         Set
           (PP.Arith_1_Or_Parse1_Memo,
            Or_Pos1 /= No_Token_Index,
            Or_Res1,
            Pos,
            Or_Pos1);
         goto Try_Again;

      elsif Mem_Pos > Pos then
         Or_Res1 := Mem_Res;
         Or_Pos1 := Mem_Pos;
         goto No_Memo;
      end if;

   Set
     (PP.Arith_1_Or_Parse1_Memo,
      Or_Pos1 /= No_Token_Index,
      Or_Res1,
      Pos,
      Or_Pos1);

       <<No_Memo>>

   Parser.Current_Pos := Or_Pos1;

   return Or_Res1;
end Arith_1_Or_Parse1;

   


function Arith_2_Or_Parse1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr
is
   use Bare_Expr_Memos;

      Row_Pos6 :
            Token_Index
               := No_Token_Index;
      Defer_Pos6 :
            Token_Index
               := No_Token_Index;
      Defer_Res6 :
            Bare_Expr
               := No_Bare_Lkt_Node;
      Row_Pos7 :
            Token_Index
               := No_Token_Index;
      Token_Pos5 :
            Token_Index
               := No_Token_Index;
      Token_Res5 :
            Token_Index
               := No_Token_Index;
      Transform_Res5 :
            Bare_Op_Mult
               := No_Bare_Lkt_Node;
      Transform_Diags5 :
            Ada.Containers.Count_Type;
      Row_Pos8 :
            Token_Index
               := No_Token_Index;
      Token_Pos6 :
            Token_Index
               := No_Token_Index;
      Token_Res6 :
            Token_Index
               := No_Token_Index;
      Transform_Res6 :
            Bare_Op_Div
               := No_Bare_Lkt_Node;
      Transform_Diags6 :
            Ada.Containers.Count_Type;
      Or_Pos2 :
            Token_Index
               := No_Token_Index;
      Or_Res2 :
            Bare_Op
               := No_Bare_Lkt_Node;
      Defer_Pos7 :
            Token_Index
               := No_Token_Index;
      Defer_Res7 :
            Bare_Expr
               := No_Bare_Lkt_Node;
      Transform_Res7 :
            Bare_Bin_Op
               := No_Bare_Lkt_Node;
      Transform_Diags7 :
            Ada.Containers.Count_Type;
      Defer_Pos8 :
            Token_Index
               := No_Token_Index;
      Defer_Res8 :
            Bare_Expr
               := No_Bare_Lkt_Node;
      Or_Pos3 :
            Token_Index
               := No_Token_Index;
      Or_Res3 :
            Bare_Expr
               := No_Bare_Lkt_Node;

      Mem_Pos : Token_Index := Pos;
      Mem_Res : Bare_Expr := No_Bare_Lkt_Node;

   PP : constant Parser_Private_Part := +Parser.Private_Part;
   M  : Memo_Entry := Get (PP.Arith_2_Or_Parse1_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Or_Res3 := M.Instance;
      return Or_Res3;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Or_Res3;
   end if;

       Set (PP.Arith_2_Or_Parse1_Memo, False, Or_Res3, Pos, Mem_Pos);

       <<Try_Again>>



   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  BEGIN <Or (root of 'arith_2') at parser.lkt:327:16>

Or_Pos3 := No_Token_Index;
Or_Res3 := No_Bare_Lkt_Node;
    
--  BEGIN <Transform(<ASTNodeType BinOp>) (root of 'arith_2') at parser.lkt:328:11>

Transform_Diags7 := Parser.Diagnostics.Length;


--  BEGIN <_Row (root of 'arith_2') at parser.lkt:328:11>

Row_Pos6 := Pos;



--  BEGIN <Defer (for 'arith_2') at parser.lkt:328:17>

Defer_Res6 :=
   Arith_2_Or_Parse1 (Parser, Row_Pos6);
Defer_Pos6 := Parser.Current_Pos;

--  END <Defer (for 'arith_2') at parser.lkt:328:17>




if Defer_Pos6 /= No_Token_Index then

   Row_Pos6 := Defer_Pos6;

else
   Row_Pos6 := No_Token_Index;
   goto Exit_Row6_0;

end if;


--  BEGIN <Or (root of 'arith_2') at parser.lkt:328:25>

Or_Pos2 := No_Token_Index;
Or_Res2 := No_Bare_Lkt_Node;
    
--  BEGIN <Transform(<ASTNodeType Op.Mult>) (root of 'arith_2') at parser.lkt:328:28>

Transform_Diags5 := Parser.Diagnostics.Length;


--  BEGIN <_Row (root of 'arith_2') at parser.lkt:328:28>

Row_Pos7 := Row_Pos6;



--  BEGIN <Token(<WithText Times>, ) (root of 'arith_2') at parser.lkt:328:36>

Token_Res5 := Row_Pos7;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res5));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_Times)
   then
       Token_Pos5 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos7 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos7,
             Expected_Token_Id => Lkt_Times,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos5 := Row_Pos7 + 1;
   end if;
end;

--  END <Token(<WithText Times>, ) (root of 'arith_2') at parser.lkt:328:36>




if Token_Pos5 /= No_Token_Index then

   Row_Pos7 := Token_Pos5;

else
   Row_Pos7 := No_Token_Index;
   goto Exit_Row7_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row7_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'arith_2') at parser.lkt:328:28>



if Row_Pos7 /= No_Token_Index then

   Transform_Res5 := Allocate_Op_Mult (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res5,
      Kind => Lkt_Op_Mult,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos6,
      Token_End_Index   => (if Row_Pos7 = Row_Pos6
                            then No_Token_Index
                            else Row_Pos7 - 1));




elsif Row_Pos7 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags5);
end if;

--  END <Transform(<ASTNodeType Op.Mult>) (root of 'arith_2') at parser.lkt:328:28>

    if Row_Pos7 /= No_Token_Index then
        Or_Pos2 := Row_Pos7;
        Or_Res2 := Transform_Res5;
        goto Exit_Or3;
    end if;
    
--  BEGIN <Transform(<ASTNodeType Op.Div>) (root of 'arith_2') at parser.lkt:328:43>

Transform_Diags6 := Parser.Diagnostics.Length;


--  BEGIN <_Row (root of 'arith_2') at parser.lkt:328:43>

Row_Pos8 := Row_Pos6;



--  BEGIN <Token(<WithText Div>, ) (root of 'arith_2') at parser.lkt:328:50>

Token_Res6 := Row_Pos8;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res6));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_Div)
   then
       Token_Pos6 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos8 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos8,
             Expected_Token_Id => Lkt_Div,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos6 := Row_Pos8 + 1;
   end if;
end;

--  END <Token(<WithText Div>, ) (root of 'arith_2') at parser.lkt:328:50>




if Token_Pos6 /= No_Token_Index then

   Row_Pos8 := Token_Pos6;

else
   Row_Pos8 := No_Token_Index;
   goto Exit_Row8_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row8_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'arith_2') at parser.lkt:328:43>



if Row_Pos8 /= No_Token_Index then

   Transform_Res6 := Allocate_Op_Div (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res6,
      Kind => Lkt_Op_Div,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos6,
      Token_End_Index   => (if Row_Pos8 = Row_Pos6
                            then No_Token_Index
                            else Row_Pos8 - 1));




elsif Row_Pos8 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags6);
end if;

--  END <Transform(<ASTNodeType Op.Div>) (root of 'arith_2') at parser.lkt:328:43>

    if Row_Pos8 /= No_Token_Index then
        Or_Pos2 := Row_Pos8;
        Or_Res2 := Transform_Res6;
        goto Exit_Or3;
    end if;
<<Exit_Or3>>

--  END <Or (root of 'arith_2') at parser.lkt:328:25>




if Or_Pos2 /= No_Token_Index then

   Row_Pos6 := Or_Pos2;

else
   Row_Pos6 := No_Token_Index;
   goto Exit_Row6_0;

end if;


--  BEGIN <Defer (for 'arith_3') at parser.lkt:328:56>

Defer_Res7 :=
   Arith_3_Or_Parse1 (Parser, Row_Pos6);
Defer_Pos7 := Parser.Current_Pos;

--  END <Defer (for 'arith_3') at parser.lkt:328:56>




if Defer_Pos7 /= No_Token_Index then

   Row_Pos6 := Defer_Pos7;

else
   Row_Pos6 := No_Token_Index;
   goto Exit_Row6_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row6_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'arith_2') at parser.lkt:328:11>



if Row_Pos6 /= No_Token_Index then

   Transform_Res7 := Allocate_Bin_Op (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res7,
      Kind => Lkt_Bin_Op,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos6 = Pos
                            then No_Token_Index
                            else Row_Pos6 - 1));

      
      Initialize_Fields_For_Bin_Op
        (Self => Transform_Res7,
         Bin_Op_F_Left => Defer_Res6,
         Bin_Op_F_Op => Or_Res2,
         Bin_Op_F_Right => Defer_Res7);

         if Defer_Res6 /= null and then Is_Incomplete (Defer_Res6) then
            Transform_Res7.Last_Attempted_Child := 0;
         elsif Defer_Res6 /= null and then not Is_Ghost (Defer_Res6) then
            Transform_Res7.Last_Attempted_Child := -1;
         end if;
         if Or_Res2 /= null and then Is_Incomplete (Or_Res2) then
            Transform_Res7.Last_Attempted_Child := 0;
         elsif Or_Res2 /= null and then not Is_Ghost (Or_Res2) then
            Transform_Res7.Last_Attempted_Child := -1;
         end if;
         if Defer_Res7 /= null and then Is_Incomplete (Defer_Res7) then
            Transform_Res7.Last_Attempted_Child := 0;
         elsif Defer_Res7 /= null and then not Is_Ghost (Defer_Res7) then
            Transform_Res7.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos6 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags7);
end if;

--  END <Transform(<ASTNodeType BinOp>) (root of 'arith_2') at parser.lkt:328:11>

    if Row_Pos6 /= No_Token_Index then
        Or_Pos3 := Row_Pos6;
        Or_Res3 := Transform_Res7;
        goto Exit_Or2;
    end if;
    
--  BEGIN <Defer (for 'arith_3') at parser.lkt:329:11>

Defer_Res8 :=
   Arith_3_Or_Parse1 (Parser, Pos);
Defer_Pos8 := Parser.Current_Pos;

--  END <Defer (for 'arith_3') at parser.lkt:329:11>

    if Defer_Pos8 /= No_Token_Index then
        Or_Pos3 := Defer_Pos8;
        Or_Res3 := Defer_Res8;
        goto Exit_Or2;
    end if;
<<Exit_Or2>>

--  END <Or (root of 'arith_2') at parser.lkt:327:16>


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------

      if Or_Pos3 > Mem_Pos then
         Mem_Pos := Or_Pos3;
         Mem_Res := Or_Res3;
         Set
           (PP.Arith_2_Or_Parse1_Memo,
            Or_Pos3 /= No_Token_Index,
            Or_Res3,
            Pos,
            Or_Pos3);
         goto Try_Again;

      elsif Mem_Pos > Pos then
         Or_Res3 := Mem_Res;
         Or_Pos3 := Mem_Pos;
         goto No_Memo;
      end if;

   Set
     (PP.Arith_2_Or_Parse1_Memo,
      Or_Pos3 /= No_Token_Index,
      Or_Res3,
      Pos,
      Or_Pos3);

       <<No_Memo>>

   Parser.Current_Pos := Or_Pos3;

   return Or_Res3;
end Arith_2_Or_Parse1;

   


function Arith_3_Or_Parse1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr
is
   use Bare_Expr_Memos;

      Row_Pos9 :
            Token_Index
               := No_Token_Index;
      Row_Pos10 :
            Token_Index
               := No_Token_Index;
      Token_Pos7 :
            Token_Index
               := No_Token_Index;
      Token_Res7 :
            Token_Index
               := No_Token_Index;
      Transform_Res8 :
            Bare_Op_Plus
               := No_Bare_Lkt_Node;
      Transform_Diags8 :
            Ada.Containers.Count_Type;
      Row_Pos11 :
            Token_Index
               := No_Token_Index;
      Token_Pos8 :
            Token_Index
               := No_Token_Index;
      Token_Res8 :
            Token_Index
               := No_Token_Index;
      Transform_Res9 :
            Bare_Op_Minus
               := No_Bare_Lkt_Node;
      Transform_Diags9 :
            Ada.Containers.Count_Type;
      Or_Pos4 :
            Token_Index
               := No_Token_Index;
      Or_Res4 :
            Bare_Op
               := No_Bare_Lkt_Node;
      Defer_Pos9 :
            Token_Index
               := No_Token_Index;
      Defer_Res9 :
            Bare_Expr
               := No_Bare_Lkt_Node;
      Transform_Res10 :
            Bare_Un_Op
               := No_Bare_Lkt_Node;
      Transform_Diags10 :
            Ada.Containers.Count_Type;
      Defer_Pos10 :
            Token_Index
               := No_Token_Index;
      Defer_Res10 :
            Bare_Expr
               := No_Bare_Lkt_Node;
      Or_Pos5 :
            Token_Index
               := No_Token_Index;
      Or_Res5 :
            Bare_Expr
               := No_Bare_Lkt_Node;


   PP : constant Parser_Private_Part := +Parser.Private_Part;
   M  : Memo_Entry := Get (PP.Arith_3_Or_Parse1_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Or_Res5 := M.Instance;
      return Or_Res5;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Or_Res5;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  BEGIN <Or (root of 'arith_3') at parser.lkt:331:16>

Or_Pos5 := No_Token_Index;
Or_Res5 := No_Bare_Lkt_Node;
    
--  BEGIN <Transform(<ASTNodeType UnOp>) (root of 'arith_3') at parser.lkt:332:11>

Transform_Diags10 := Parser.Diagnostics.Length;


--  BEGIN <_Row (root of 'arith_3') at parser.lkt:332:11>

Row_Pos9 := Pos;



--  BEGIN <Or (root of 'arith_3') at parser.lkt:332:16>

Or_Pos4 := No_Token_Index;
Or_Res4 := No_Bare_Lkt_Node;
    
--  BEGIN <Transform(<ASTNodeType Op.Plus>) (root of 'arith_3') at parser.lkt:332:19>

Transform_Diags8 := Parser.Diagnostics.Length;


--  BEGIN <_Row (root of 'arith_3') at parser.lkt:332:19>

Row_Pos10 := Row_Pos9;



--  BEGIN <Token(<WithText Plus>, ) (root of 'arith_3') at parser.lkt:332:27>

Token_Res7 := Row_Pos10;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res7));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_Plus)
   then
       Token_Pos7 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos10 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos10,
             Expected_Token_Id => Lkt_Plus,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos7 := Row_Pos10 + 1;
   end if;
end;

--  END <Token(<WithText Plus>, ) (root of 'arith_3') at parser.lkt:332:27>




if Token_Pos7 /= No_Token_Index then

   Row_Pos10 := Token_Pos7;

else
   Row_Pos10 := No_Token_Index;
   goto Exit_Row10_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row10_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'arith_3') at parser.lkt:332:19>



if Row_Pos10 /= No_Token_Index then

   Transform_Res8 := Allocate_Op_Plus (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res8,
      Kind => Lkt_Op_Plus,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos9,
      Token_End_Index   => (if Row_Pos10 = Row_Pos9
                            then No_Token_Index
                            else Row_Pos10 - 1));




elsif Row_Pos10 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags8);
end if;

--  END <Transform(<ASTNodeType Op.Plus>) (root of 'arith_3') at parser.lkt:332:19>

    if Row_Pos10 /= No_Token_Index then
        Or_Pos4 := Row_Pos10;
        Or_Res4 := Transform_Res8;
        goto Exit_Or5;
    end if;
    
--  BEGIN <Transform(<ASTNodeType Op.Minus>) (root of 'arith_3') at parser.lkt:332:34>

Transform_Diags9 := Parser.Diagnostics.Length;


--  BEGIN <_Row (root of 'arith_3') at parser.lkt:332:34>

Row_Pos11 := Row_Pos9;



--  BEGIN <Token(<WithText Minus>, ) (root of 'arith_3') at parser.lkt:332:43>

Token_Res8 := Row_Pos11;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res8));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_Minus)
   then
       Token_Pos8 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos11 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos11,
             Expected_Token_Id => Lkt_Minus,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos8 := Row_Pos11 + 1;
   end if;
end;

--  END <Token(<WithText Minus>, ) (root of 'arith_3') at parser.lkt:332:43>




if Token_Pos8 /= No_Token_Index then

   Row_Pos11 := Token_Pos8;

else
   Row_Pos11 := No_Token_Index;
   goto Exit_Row11_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row11_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'arith_3') at parser.lkt:332:34>



if Row_Pos11 /= No_Token_Index then

   Transform_Res9 := Allocate_Op_Minus (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res9,
      Kind => Lkt_Op_Minus,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos9,
      Token_End_Index   => (if Row_Pos11 = Row_Pos9
                            then No_Token_Index
                            else Row_Pos11 - 1));




elsif Row_Pos11 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags9);
end if;

--  END <Transform(<ASTNodeType Op.Minus>) (root of 'arith_3') at parser.lkt:332:34>

    if Row_Pos11 /= No_Token_Index then
        Or_Pos4 := Row_Pos11;
        Or_Res4 := Transform_Res9;
        goto Exit_Or5;
    end if;
<<Exit_Or5>>

--  END <Or (root of 'arith_3') at parser.lkt:332:16>




if Or_Pos4 /= No_Token_Index then

   Row_Pos9 := Or_Pos4;

else
   Row_Pos9 := No_Token_Index;
   goto Exit_Row9_0;

end if;


--  BEGIN <Defer (for 'isa_or_primary') at parser.lkt:332:49>

Defer_Res9 :=
   Isa_Or_Primary_Or_Parse0 (Parser, Row_Pos9);
Defer_Pos9 := Parser.Current_Pos;

--  END <Defer (for 'isa_or_primary') at parser.lkt:332:49>




if Defer_Pos9 /= No_Token_Index then

   Row_Pos9 := Defer_Pos9;

else
   Row_Pos9 := No_Token_Index;
   goto Exit_Row9_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row9_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'arith_3') at parser.lkt:332:11>



if Row_Pos9 /= No_Token_Index then

   Transform_Res10 := Allocate_Un_Op (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res10,
      Kind => Lkt_Un_Op,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos9 = Pos
                            then No_Token_Index
                            else Row_Pos9 - 1));

      
      Initialize_Fields_For_Un_Op
        (Self => Transform_Res10,
         Un_Op_F_Op => Or_Res4,
         Un_Op_F_Expr => Defer_Res9);

         if Or_Res4 /= null and then Is_Incomplete (Or_Res4) then
            Transform_Res10.Last_Attempted_Child := 0;
         elsif Or_Res4 /= null and then not Is_Ghost (Or_Res4) then
            Transform_Res10.Last_Attempted_Child := -1;
         end if;
         if Defer_Res9 /= null and then Is_Incomplete (Defer_Res9) then
            Transform_Res10.Last_Attempted_Child := 0;
         elsif Defer_Res9 /= null and then not Is_Ghost (Defer_Res9) then
            Transform_Res10.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos9 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags10);
end if;

--  END <Transform(<ASTNodeType UnOp>) (root of 'arith_3') at parser.lkt:332:11>

    if Row_Pos9 /= No_Token_Index then
        Or_Pos5 := Row_Pos9;
        Or_Res5 := Transform_Res10;
        goto Exit_Or4;
    end if;
    
--  BEGIN <Defer (for 'isa_or_primary') at parser.lkt:333:11>

Defer_Res10 :=
   Isa_Or_Primary_Or_Parse0 (Parser, Pos);
Defer_Pos10 := Parser.Current_Pos;

--  END <Defer (for 'isa_or_primary') at parser.lkt:333:11>

    if Defer_Pos10 /= No_Token_Index then
        Or_Pos5 := Defer_Pos10;
        Or_Res5 := Defer_Res10;
        goto Exit_Or4;
    end if;
<<Exit_Or4>>

--  END <Or (root of 'arith_3') at parser.lkt:331:16>


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (PP.Arith_3_Or_Parse1_Memo,
      Or_Pos5 /= No_Token_Index,
      Or_Res5,
      Pos,
      Or_Pos5);


   Parser.Current_Pos := Or_Pos5;

   return Or_Res5;
end Arith_3_Or_Parse1;

   


function Array_Literal_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Array_Literal
is
   use Bare_Array_Literal_Memos;

      Row_Pos12 :
            Token_Index
               := No_Token_Index;
      Token_Pos9 :
            Token_Index
               := No_Token_Index;
      Token_Res9 :
            Token_Index
               := No_Token_Index;
      Lst_Cpos1 :
            Token_Index
               := No_Token_Index;
      Tmp_List1 :
            Free_Parse_List;
      Defer_Pos11 :
            Token_Index
               := No_Token_Index;
      Defer_Res11 :
            Bare_Expr
               := No_Bare_Lkt_Node;
      Token_Pos10 :
            Token_Index
               := No_Token_Index;
      Token_Res10 :
            Token_Index
               := No_Token_Index;
      List_Pos1 :
            Token_Index
               := No_Token_Index;
      List_Res1 :
            Bare_Expr_List
               := No_Bare_Lkt_Node;
      Token_Pos11 :
            Token_Index
               := No_Token_Index;
      Token_Res11 :
            Token_Index
               := No_Token_Index;
      Row_Pos13 :
            Token_Index
               := No_Token_Index;
      Token_Pos12 :
            Token_Index
               := No_Token_Index;
      Token_Res12 :
            Token_Index
               := No_Token_Index;
      Defer_Pos12 :
            Token_Index
               := No_Token_Index;
      Defer_Res12 :
            Bare_Type_Ref
               := No_Bare_Lkt_Node;
      Transform_Res11 :
            Bare_Array_Literal
               := No_Bare_Lkt_Node;
      Transform_Diags11 :
            Ada.Containers.Count_Type;


   PP : constant Parser_Private_Part := +Parser.Private_Part;
   M  : Memo_Entry := Get (PP.Array_Literal_Transform_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res11 := M.Instance;
      return Transform_Res11;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res11;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  BEGIN <Transform(<ASTNodeType ArrayLiteral>) (root of 'array_literal') at parser.lkt:379:22>

Transform_Diags11 := Parser.Diagnostics.Length;


--  BEGIN <_Row (root of 'array_literal') at parser.lkt:379:22>

Row_Pos12 := Pos;



--  BEGIN <Token(<WithText LBrack>, ) (root of 'array_literal') at parser.lkt:379:35>

Token_Res9 := Row_Pos12;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res9));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_L_Brack)
   then
       Token_Pos9 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos12 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos12,
             Expected_Token_Id => Lkt_L_Brack,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos9 := Row_Pos12 + 1;
   end if;
end;

--  END <Token(<WithText LBrack>, ) (root of 'array_literal') at parser.lkt:379:35>




if Token_Pos9 /= No_Token_Index then

   Row_Pos12 := Token_Pos9;

else
   Row_Pos12 := No_Token_Index;
   goto Exit_Row12_0;

end if;


--  BEGIN <List (root of 'array_literal') at parser.lkt:379:39>

    List_Pos1 := Row_Pos12;



Lst_Cpos1 := Row_Pos12;
Tmp_List1 := Get_Parse_List (Parser);


loop
   
--  BEGIN <Defer (for 'expr') at parser.lkt:379:45>

Defer_Res11 :=
   Expr_Or_Parse1 (Parser, Lst_Cpos1);
Defer_Pos11 := Parser.Current_Pos;

--  END <Defer (for 'expr') at parser.lkt:379:45>


   exit when Defer_Pos11 = No_Token_Index;

   List_Pos1 := Defer_Pos11;
   Lst_Cpos1 := List_Pos1;

   Tmp_List1.Nodes.Append (Defer_Res11);

      
--  BEGIN <Token(<WithText Comma>, ) (root of 'array_literal') at parser.lkt:379:51>

Token_Res10 := Lst_Cpos1;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res10));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_Comma)
   then
       Token_Pos10 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Lst_Cpos1 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Lst_Cpos1,
             Expected_Token_Id => Lkt_Comma,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos10 := Lst_Cpos1 + 1;
   end if;
end;

--  END <Token(<WithText Comma>, ) (root of 'array_literal') at parser.lkt:379:51>


      exit when Token_Pos10 = No_Token_Index;

      Lst_Cpos1 := Token_Pos10;

end loop;


declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List1.Nodes.Length;
begin
   List_Res1 := Allocate_Expr_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Row_Pos12;
      Token_End := (if Lst_Cpos1 = Row_Pos12
                    then Row_Pos12
                    else List_Pos1 - 1);

   else
      Token_Start := Token_Index'Max (Row_Pos12, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res1,
      Kind              => Lkt_Expr_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res1,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_Lkt_Node_Vectors.Vector renames
         Tmp_List1.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res1.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List1);

--  END <List (root of 'array_literal') at parser.lkt:379:39>




if List_Pos1 /= No_Token_Index then

   Row_Pos12 := List_Pos1;

else
   Row_Pos12 := No_Token_Index;
   goto Exit_Row12_0;

end if;


--  BEGIN <Token(<WithText RBrack>, ) (root of 'array_literal') at parser.lkt:379:56>

Token_Res11 := Row_Pos12;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res11));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_R_Brack)
   then
       Token_Pos11 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos12 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos12,
             Expected_Token_Id => Lkt_R_Brack,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos11 := Row_Pos12 + 1;
   end if;
end;

--  END <Token(<WithText RBrack>, ) (root of 'array_literal') at parser.lkt:379:56>




if Token_Pos11 /= No_Token_Index then

   Row_Pos12 := Token_Pos11;

else
   Row_Pos12 := No_Token_Index;
   goto Exit_Row12_0;

end if;


--  BEGIN <Opt (root of 'array_literal') at parser.lkt:379:60>












--  BEGIN <_Extract (root of 'array_literal') at parser.lkt:379:61>

--  BEGIN <_Row (root of 'array_literal') at parser.lkt:379:61>

Row_Pos13 := Row_Pos12;



--  BEGIN <Token(<WithText Colon>, ) (root of 'array_literal') at parser.lkt:379:66>

Token_Res12 := Row_Pos13;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res12));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_Colon)
   then
       Token_Pos12 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos13 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos13,
             Expected_Token_Id => Lkt_Colon,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos12 := Row_Pos13 + 1;
   end if;
end;

--  END <Token(<WithText Colon>, ) (root of 'array_literal') at parser.lkt:379:66>




if Token_Pos12 /= No_Token_Index then

   Row_Pos13 := Token_Pos12;

else
   Row_Pos13 := No_Token_Index;
   goto Exit_Row13_0;

end if;


--  BEGIN <Defer (for 'type_ref') at parser.lkt:379:70>

Defer_Res12 :=
   Type_Ref_Or_Parse0 (Parser, Row_Pos13);
Defer_Pos12 := Parser.Current_Pos;

--  END <Defer (for 'type_ref') at parser.lkt:379:70>




if Defer_Pos12 /= No_Token_Index then

   Row_Pos13 := Defer_Pos12;

else
   Row_Pos13 := No_Token_Index;
   goto Exit_Row13_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row13_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'array_literal') at parser.lkt:379:61>

--  END <_Extract (root of 'array_literal') at parser.lkt:379:61>


if Row_Pos13 = No_Token_Index then

         
   Defer_Res12 := No_Bare_Lkt_Node;



       
   Row_Pos13 := Row_Pos12;



end if;

--  END <Opt (root of 'array_literal') at parser.lkt:379:60>




if Row_Pos13 /= No_Token_Index then

   Row_Pos12 := Row_Pos13;

else
   Row_Pos12 := No_Token_Index;
   goto Exit_Row12_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row12_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'array_literal') at parser.lkt:379:22>



if Row_Pos12 /= No_Token_Index then

   Transform_Res11 := Allocate_Array_Literal (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res11,
      Kind => Lkt_Array_Literal,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos12 = Pos
                            then No_Token_Index
                            else Row_Pos12 - 1));

      
      Initialize_Fields_For_Array_Literal
        (Self => Transform_Res11,
         Array_Literal_F_Exprs => List_Res1,
         Array_Literal_F_Element_Type => Defer_Res12);

         if List_Res1 /= null and then Is_Incomplete (List_Res1) then
            Transform_Res11.Last_Attempted_Child := 0;
         elsif List_Res1 /= null and then not Is_Ghost (List_Res1) then
            Transform_Res11.Last_Attempted_Child := -1;
         end if;
         if Defer_Res12 /= null and then Is_Incomplete (Defer_Res12) then
            Transform_Res11.Last_Attempted_Child := 0;
         elsif Defer_Res12 /= null and then not Is_Ghost (Defer_Res12) then
            Transform_Res11.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos12 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags11);
end if;

--  END <Transform(<ASTNodeType ArrayLiteral>) (root of 'array_literal') at parser.lkt:379:22>


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (PP.Array_Literal_Transform_Parse0_Memo,
      Row_Pos12 /= No_Token_Index,
      Transform_Res11,
      Pos,
      Row_Pos12);


   Parser.Current_Pos := Row_Pos12;

   return Transform_Res11;
end Array_Literal_Transform_Parse0;

   


function Bare_Decl_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Decl
is
   use Bare_Decl_Memos;

      Defer_Pos13 :
            Token_Index
               := No_Token_Index;
      Defer_Res13 :
            Bare_Generic_Decl
               := No_Bare_Lkt_Node;
      Defer_Pos14 :
            Token_Index
               := No_Token_Index;
      Defer_Res14 :
            Bare_Named_Type_Decl
               := No_Bare_Lkt_Node;
      Defer_Pos15 :
            Token_Index
               := No_Token_Index;
      Defer_Res15 :
            Bare_Fun_Decl
               := No_Bare_Lkt_Node;
      Defer_Pos16 :
            Token_Index
               := No_Token_Index;
      Defer_Res16 :
            Bare_Lexer_Decl
               := No_Bare_Lkt_Node;
      Defer_Pos17 :
            Token_Index
               := No_Token_Index;
      Defer_Res17 :
            Bare_Grammar_Decl
               := No_Bare_Lkt_Node;
      Defer_Pos18 :
            Token_Index
               := No_Token_Index;
      Defer_Res18 :
            Bare_Field_Decl
               := No_Bare_Lkt_Node;
      Defer_Pos19 :
            Token_Index
               := No_Token_Index;
      Defer_Res19 :
            Bare_Val_Decl
               := No_Bare_Lkt_Node;
      Defer_Pos20 :
            Token_Index
               := No_Token_Index;
      Defer_Res20 :
            Bare_Env_Spec_Decl
               := No_Bare_Lkt_Node;
      Defer_Pos21 :
            Token_Index
               := No_Token_Index;
      Defer_Res21 :
            Bare_Grammar_Rule_Decl
               := No_Bare_Lkt_Node;
      Defer_Pos22 :
            Token_Index
               := No_Token_Index;
      Defer_Res22 :
            Bare_Dyn_Var_Decl
               := No_Bare_Lkt_Node;
      Or_Pos6 :
            Token_Index
               := No_Token_Index;
      Or_Res6 :
            Bare_Decl
               := No_Bare_Lkt_Node;


   PP : constant Parser_Private_Part := +Parser.Private_Part;
   M  : Memo_Entry := Get (PP.Bare_Decl_Or_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Or_Res6 := M.Instance;
      return Or_Res6;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Or_Res6;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  BEGIN <Or (root of 'bare_decl') at parser.lkt:200:18>

Or_Pos6 := No_Token_Index;
Or_Res6 := No_Bare_Lkt_Node;
    
--  BEGIN <Defer (for 'generic_decl') at parser.lkt:201:11>

Defer_Res13 :=
   Generic_Decl_Transform_Parse0 (Parser, Pos);
Defer_Pos13 := Parser.Current_Pos;

--  END <Defer (for 'generic_decl') at parser.lkt:201:11>

    if Defer_Pos13 /= No_Token_Index then
        Or_Pos6 := Defer_Pos13;
        Or_Res6 := Defer_Res13;
        goto Exit_Or6;
    end if;
    
--  BEGIN <Defer (for 'type_decl') at parser.lkt:202:11>

Defer_Res14 :=
   Type_Decl_Or_Parse0 (Parser, Pos);
Defer_Pos14 := Parser.Current_Pos;

--  END <Defer (for 'type_decl') at parser.lkt:202:11>

    if Defer_Pos14 /= No_Token_Index then
        Or_Pos6 := Defer_Pos14;
        Or_Res6 := Defer_Res14;
        goto Exit_Or6;
    end if;
    
--  BEGIN <Defer (for 'fun_decl') at parser.lkt:203:11>

Defer_Res15 :=
   Fun_Decl_Transform_Parse0 (Parser, Pos);
Defer_Pos15 := Parser.Current_Pos;

--  END <Defer (for 'fun_decl') at parser.lkt:203:11>

    if Defer_Pos15 /= No_Token_Index then
        Or_Pos6 := Defer_Pos15;
        Or_Res6 := Defer_Res15;
        goto Exit_Or6;
    end if;
    
--  BEGIN <Defer (for 'lexer_decl') at parser.lkt:204:11>

Defer_Res16 :=
   Lexer_Decl_Transform_Parse0 (Parser, Pos);
Defer_Pos16 := Parser.Current_Pos;

--  END <Defer (for 'lexer_decl') at parser.lkt:204:11>

    if Defer_Pos16 /= No_Token_Index then
        Or_Pos6 := Defer_Pos16;
        Or_Res6 := Defer_Res16;
        goto Exit_Or6;
    end if;
    
--  BEGIN <Defer (for 'grammar_decl') at parser.lkt:205:11>

Defer_Res17 :=
   Grammar_Decl_Transform_Parse0 (Parser, Pos);
Defer_Pos17 := Parser.Current_Pos;

--  END <Defer (for 'grammar_decl') at parser.lkt:205:11>

    if Defer_Pos17 /= No_Token_Index then
        Or_Pos6 := Defer_Pos17;
        Or_Res6 := Defer_Res17;
        goto Exit_Or6;
    end if;
    
--  BEGIN <Defer (for 'field_decl') at parser.lkt:206:11>

Defer_Res18 :=
   Field_Decl_Transform_Parse0 (Parser, Pos);
Defer_Pos18 := Parser.Current_Pos;

--  END <Defer (for 'field_decl') at parser.lkt:206:11>

    if Defer_Pos18 /= No_Token_Index then
        Or_Pos6 := Defer_Pos18;
        Or_Res6 := Defer_Res18;
        goto Exit_Or6;
    end if;
    
--  BEGIN <Defer (for 'val_decl') at parser.lkt:207:11>

Defer_Res19 :=
   Val_Decl_Transform_Parse0 (Parser, Pos);
Defer_Pos19 := Parser.Current_Pos;

--  END <Defer (for 'val_decl') at parser.lkt:207:11>

    if Defer_Pos19 /= No_Token_Index then
        Or_Pos6 := Defer_Pos19;
        Or_Res6 := Defer_Res19;
        goto Exit_Or6;
    end if;
    
--  BEGIN <Defer (for 'env_spec_decl') at parser.lkt:208:11>

Defer_Res20 :=
   Env_Spec_Decl_Transform_Parse1 (Parser, Pos);
Defer_Pos20 := Parser.Current_Pos;

--  END <Defer (for 'env_spec_decl') at parser.lkt:208:11>

    if Defer_Pos20 /= No_Token_Index then
        Or_Pos6 := Defer_Pos20;
        Or_Res6 := Defer_Res20;
        goto Exit_Or6;
    end if;
    
--  BEGIN <Defer (for 'grammar_rule') at parser.lkt:209:11>

Defer_Res21 :=
   Grammar_Rule_Transform_Parse0 (Parser, Pos);
Defer_Pos21 := Parser.Current_Pos;

--  END <Defer (for 'grammar_rule') at parser.lkt:209:11>

    if Defer_Pos21 /= No_Token_Index then
        Or_Pos6 := Defer_Pos21;
        Or_Res6 := Defer_Res21;
        goto Exit_Or6;
    end if;
    
--  BEGIN <Defer (for 'dynvar_decl') at parser.lkt:210:11>

Defer_Res22 :=
   Dynvar_Decl_Transform_Parse0 (Parser, Pos);
Defer_Pos22 := Parser.Current_Pos;

--  END <Defer (for 'dynvar_decl') at parser.lkt:210:11>

    if Defer_Pos22 /= No_Token_Index then
        Or_Pos6 := Defer_Pos22;
        Or_Res6 := Defer_Res22;
        goto Exit_Or6;
    end if;
<<Exit_Or6>>

--  END <Or (root of 'bare_decl') at parser.lkt:200:18>


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (PP.Bare_Decl_Or_Parse0_Memo,
      Or_Pos6 /= No_Token_Index,
      Or_Res6,
      Pos,
      Or_Pos6);


   Parser.Current_Pos := Or_Pos6;

   return Or_Res6;
end Bare_Decl_Or_Parse0;

   


function Basic_Expr_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr
is
   use Bare_Expr_Memos;

      Nobt0 :
            Boolean
               := False;
      Row_Pos14 :
            Token_Index
               := No_Token_Index;
      Defer_Pos23 :
            Token_Index
               := No_Token_Index;
      Defer_Res23 :
            Bare_Expr
               := No_Bare_Lkt_Node;
      Token_Pos13 :
            Token_Index
               := No_Token_Index;
      Token_Res13 :
            Token_Index
               := No_Token_Index;
      Defer_Pos24 :
            Token_Index
               := No_Token_Index;
      Defer_Res24 :
            Bare_Argument_List
               := No_Bare_Lkt_Node;
      Token_Pos14 :
            Token_Index
               := No_Token_Index;
      Token_Res14 :
            Token_Index
               := No_Token_Index;
      Transform_Res12 :
            Bare_Call_Expr
               := No_Bare_Lkt_Node;
      Transform_Diags12 :
            Ada.Containers.Count_Type;
      Row_Pos15 :
            Token_Index
               := No_Token_Index;
      Defer_Pos25 :
            Token_Index
               := No_Token_Index;
      Defer_Res25 :
            Bare_Expr
               := No_Bare_Lkt_Node;
      Token_Pos15 :
            Token_Index
               := No_Token_Index;
      Token_Res15 :
            Token_Index
               := No_Token_Index;
      Defer_Pos26 :
            Token_Index
               := No_Token_Index;
      Defer_Res26 :
            Bare_Type_Ref_List
               := No_Bare_Lkt_Node;
      Token_Pos16 :
            Token_Index
               := No_Token_Index;
      Token_Res16 :
            Token_Index
               := No_Token_Index;
      Transform_Res13 :
            Bare_Generic_Instantiation
               := No_Bare_Lkt_Node;
      Transform_Diags13 :
            Ada.Containers.Count_Type;
      Row_Pos16 :
            Token_Index
               := No_Token_Index;
      Defer_Pos27 :
            Token_Index
               := No_Token_Index;
      Defer_Res27 :
            Bare_Expr
               := No_Bare_Lkt_Node;
      Defer_Pos28 :
            Token_Index
               := No_Token_Index;
      Defer_Res28 :
            Bare_Null_Cond_Qualifier
               := No_Bare_Lkt_Node;
      Token_Pos17 :
            Token_Index
               := No_Token_Index;
      Token_Res17 :
            Token_Index
               := No_Token_Index;
      Defer_Pos29 :
            Token_Index
               := No_Token_Index;
      Defer_Res29 :
            Bare_Expr
               := No_Bare_Lkt_Node;
      Token_Pos18 :
            Token_Index
               := No_Token_Index;
      Token_Res18 :
            Token_Index
               := No_Token_Index;
      Transform_Res14 :
            Bare_Subscript_Expr
               := No_Bare_Lkt_Node;
      Transform_Diags14 :
            Ada.Containers.Count_Type;
      Row_Pos17 :
            Token_Index
               := No_Token_Index;
      Defer_Pos30 :
            Token_Index
               := No_Token_Index;
      Defer_Res30 :
            Bare_Expr
               := No_Bare_Lkt_Node;
      Token_Pos19 :
            Token_Index
               := No_Token_Index;
      Token_Res19 :
            Token_Index
               := No_Token_Index;
      Transform_Res15 :
            Bare_Error_On_Null
               := No_Bare_Lkt_Node;
      Transform_Diags15 :
            Ada.Containers.Count_Type;
      Row_Pos18 :
            Token_Index
               := No_Token_Index;
      Defer_Pos31 :
            Token_Index
               := No_Token_Index;
      Defer_Res31 :
            Bare_Expr
               := No_Bare_Lkt_Node;
      Defer_Pos32 :
            Token_Index
               := No_Token_Index;
      Defer_Res32 :
            Bare_Null_Cond_Qualifier
               := No_Bare_Lkt_Node;
      Token_Pos20 :
            Token_Index
               := No_Token_Index;
      Token_Res20 :
            Token_Index
               := No_Token_Index;
      Token_Pos21 :
            Token_Index
               := No_Token_Index;
      Token_Res21 :
            Token_Index
               := No_Token_Index;
      Token_Pos22 :
            Token_Index
               := No_Token_Index;
      Token_Res22 :
            Token_Index
               := No_Token_Index;
      Defer_Pos33 :
            Token_Index
               := No_Token_Index;
      Defer_Res33 :
            Bare_Type_Ref
               := No_Bare_Lkt_Node;
      Token_Pos23 :
            Token_Index
               := No_Token_Index;
      Token_Res23 :
            Token_Index
               := No_Token_Index;
      Transform_Res16 :
            Bare_Keep_Expr
               := No_Bare_Lkt_Node;
      Transform_Diags16 :
            Ada.Containers.Count_Type;
      Row_Pos19 :
            Token_Index
               := No_Token_Index;
      Defer_Pos34 :
            Token_Index
               := No_Token_Index;
      Defer_Res34 :
            Bare_Expr
               := No_Bare_Lkt_Node;
      Defer_Pos35 :
            Token_Index
               := No_Token_Index;
      Defer_Res35 :
            Bare_Null_Cond_Qualifier
               := No_Bare_Lkt_Node;
      Token_Pos24 :
            Token_Index
               := No_Token_Index;
      Token_Res24 :
            Token_Index
               := No_Token_Index;
      Token_Pos25 :
            Token_Index
               := No_Token_Index;
      Token_Res25 :
            Token_Index
               := No_Token_Index;
      Token_Pos26 :
            Token_Index
               := No_Token_Index;
      Token_Res26 :
            Token_Index
               := No_Token_Index;
      Opt_Res0 :
            Bare_Excludes_Null
               := No_Bare_Lkt_Node;
      Token_Pos27 :
            Token_Index
               := No_Token_Index;
      Token_Res27 :
            Token_Index
               := No_Token_Index;
      Defer_Pos36 :
            Token_Index
               := No_Token_Index;
      Defer_Res36 :
            Bare_Type_Ref
               := No_Bare_Lkt_Node;
      Token_Pos28 :
            Token_Index
               := No_Token_Index;
      Token_Res28 :
            Token_Index
               := No_Token_Index;
      Transform_Res17 :
            Bare_Cast_Expr
               := No_Bare_Lkt_Node;
      Transform_Diags17 :
            Ada.Containers.Count_Type;
      Row_Pos20 :
            Token_Index
               := No_Token_Index;
      Defer_Pos37 :
            Token_Index
               := No_Token_Index;
      Defer_Res37 :
            Bare_Expr
               := No_Bare_Lkt_Node;
      Token_Pos29 :
            Token_Index
               := No_Token_Index;
      Token_Res29 :
            Token_Index
               := No_Token_Index;
      Token_Pos30 :
            Token_Index
               := No_Token_Index;
      Token_Res30 :
            Token_Index
               := No_Token_Index;
      Defer_Pos38 :
            Token_Index
               := No_Token_Index;
      Defer_Res38 :
            Bare_Argument_List
               := No_Bare_Lkt_Node;
      Token_Pos31 :
            Token_Index
               := No_Token_Index;
      Token_Res31 :
            Token_Index
               := No_Token_Index;
      Transform_Res18 :
            Bare_Logic_Predicate
               := No_Bare_Lkt_Node;
      Transform_Diags18 :
            Ada.Containers.Count_Type;
      Row_Pos21 :
            Token_Index
               := No_Token_Index;
      Defer_Pos39 :
            Token_Index
               := No_Token_Index;
      Defer_Res39 :
            Bare_Expr
               := No_Bare_Lkt_Node;
      Defer_Pos40 :
            Token_Index
               := No_Token_Index;
      Defer_Res40 :
            Bare_Null_Cond_Qualifier
               := No_Bare_Lkt_Node;
      Token_Pos32 :
            Token_Index
               := No_Token_Index;
      Token_Res32 :
            Token_Index
               := No_Token_Index;
      Defer_Pos41 :
            Token_Index
               := No_Token_Index;
      Defer_Res41 :
            Bare_Ref_Id
               := No_Bare_Lkt_Node;
      Row_Progress0 :
            Integer
               := 0;
      Transform_Res19 :
            Bare_Dot_Expr
               := No_Bare_Lkt_Node;
      Transform_Has_Failed0 :
            Boolean
               := False;
      Transform_Diags19 :
            Ada.Containers.Count_Type;
      Row_Pos22 :
            Token_Index
               := No_Token_Index;
      Token_Pos33 :
            Token_Index
               := No_Token_Index;
      Token_Res33 :
            Token_Index
               := No_Token_Index;
      Row_Pos23 :
            Token_Index
               := No_Token_Index;
      Defer_Pos42 :
            Token_Index
               := No_Token_Index;
      Defer_Res42 :
            Bare_Ref_Id
               := No_Bare_Lkt_Node;
      Token_Pos34 :
            Token_Index
               := No_Token_Index;
      Token_Res34 :
            Token_Index
               := No_Token_Index;
      Defer_Pos43 :
            Token_Index
               := No_Token_Index;
      Defer_Res43 :
            Bare_Argument_List
               := No_Bare_Lkt_Node;
      Token_Pos35 :
            Token_Index
               := No_Token_Index;
      Token_Res35 :
            Token_Index
               := No_Token_Index;
      Transform_Res20 :
            Bare_Call_Expr
               := No_Bare_Lkt_Node;
      Transform_Diags20 :
            Ada.Containers.Count_Type;
      Transform_Res21 :
            Bare_Logic_Expr
               := No_Bare_Lkt_Node;
      Transform_Diags21 :
            Ada.Containers.Count_Type;
      Row_Pos24 :
            Token_Index
               := No_Token_Index;
      Token_Pos36 :
            Token_Index
               := No_Token_Index;
      Token_Res36 :
            Token_Index
               := No_Token_Index;
      Defer_Pos44 :
            Token_Index
               := No_Token_Index;
      Defer_Res44 :
            Bare_Ref_Id
               := No_Bare_Lkt_Node;
      Transform_Res22 :
            Bare_Logic_Expr
               := No_Bare_Lkt_Node;
      Transform_Diags22 :
            Ada.Containers.Count_Type;
      Defer_Pos45 :
            Token_Index
               := No_Token_Index;
      Defer_Res45 :
            Bare_Expr
               := No_Bare_Lkt_Node;
      Or_Pos7 :
            Token_Index
               := No_Token_Index;
      Or_Res7 :
            Bare_Expr
               := No_Bare_Lkt_Node;

      Mem_Pos : Token_Index := Pos;
      Mem_Res : Bare_Expr := No_Bare_Lkt_Node;

   PP : constant Parser_Private_Part := +Parser.Private_Part;
   M  : Memo_Entry := Get (PP.Basic_Expr_Or_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Or_Res7 := M.Instance;
      return Or_Res7;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Or_Res7;
   end if;

       Set (PP.Basic_Expr_Or_Parse0_Memo, False, Or_Res7, Pos, Mem_Pos);

       <<Try_Again>>

      Nobt0 := False;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  BEGIN <Or (root of 'basic_expr') at parser.lkt:384:19>

Or_Pos7 := No_Token_Index;
Or_Res7 := No_Bare_Lkt_Node;
    
--  BEGIN <Transform(<ASTNodeType CallExpr>) (root of 'basic_expr') at parser.lkt:385:11>

Transform_Diags12 := Parser.Diagnostics.Length;


--  BEGIN <_Row (root of 'basic_expr') at parser.lkt:385:11>

Row_Pos14 := Pos;



--  BEGIN <Defer (for 'basic_expr') at parser.lkt:385:20>

Defer_Res23 :=
   Basic_Expr_Or_Parse0 (Parser, Row_Pos14);
Defer_Pos23 := Parser.Current_Pos;

--  END <Defer (for 'basic_expr') at parser.lkt:385:20>




if Defer_Pos23 /= No_Token_Index then

   Row_Pos14 := Defer_Pos23;

else
   Row_Pos14 := No_Token_Index;
   goto Exit_Row14_0;

end if;


--  BEGIN <Token(<WithText LPar>, ) (root of 'basic_expr') at parser.lkt:385:31>

Token_Res13 := Row_Pos14;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res13));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_L_Par)
   then
       Token_Pos13 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos14 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos14,
             Expected_Token_Id => Lkt_L_Par,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos13 := Row_Pos14 + 1;
   end if;
end;

--  END <Token(<WithText LPar>, ) (root of 'basic_expr') at parser.lkt:385:31>




if Token_Pos13 /= No_Token_Index then

   Row_Pos14 := Token_Pos13;

else
   Row_Pos14 := No_Token_Index;
   goto Exit_Row14_0;

end if;


--  BEGIN <Defer (for 'args') at parser.lkt:385:35>

Defer_Res24 :=
   Args_List_Parse0 (Parser, Row_Pos14);
Defer_Pos24 := Parser.Current_Pos;

--  END <Defer (for 'args') at parser.lkt:385:35>




if Defer_Pos24 /= No_Token_Index then

   Row_Pos14 := Defer_Pos24;

else
   Row_Pos14 := No_Token_Index;
   goto Exit_Row14_0;

end if;


--  BEGIN <Token(<WithText RPar>, ) (root of 'basic_expr') at parser.lkt:385:40>

Token_Res14 := Row_Pos14;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res14));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_R_Par)
   then
       Token_Pos14 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos14 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos14,
             Expected_Token_Id => Lkt_R_Par,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos14 := Row_Pos14 + 1;
   end if;
end;

--  END <Token(<WithText RPar>, ) (root of 'basic_expr') at parser.lkt:385:40>




if Token_Pos14 /= No_Token_Index then

   Row_Pos14 := Token_Pos14;

else
   Row_Pos14 := No_Token_Index;
   goto Exit_Row14_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row14_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'basic_expr') at parser.lkt:385:11>



if Row_Pos14 /= No_Token_Index then

   Transform_Res12 := Allocate_Call_Expr (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res12,
      Kind => Lkt_Call_Expr,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos14 = Pos
                            then No_Token_Index
                            else Row_Pos14 - 1));

      
      Initialize_Fields_For_Call_Expr
        (Self => Transform_Res12,
         Base_Call_Expr_F_Name => Defer_Res23,
         Base_Call_Expr_F_Args => Defer_Res24);

         if Defer_Res23 /= null and then Is_Incomplete (Defer_Res23) then
            Transform_Res12.Last_Attempted_Child := 0;
         elsif Defer_Res23 /= null and then not Is_Ghost (Defer_Res23) then
            Transform_Res12.Last_Attempted_Child := -1;
         end if;
         if Defer_Res24 /= null and then Is_Incomplete (Defer_Res24) then
            Transform_Res12.Last_Attempted_Child := 0;
         elsif Defer_Res24 /= null and then not Is_Ghost (Defer_Res24) then
            Transform_Res12.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos14 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags12);
end if;

--  END <Transform(<ASTNodeType CallExpr>) (root of 'basic_expr') at parser.lkt:385:11>

    if Row_Pos14 /= No_Token_Index then
        Or_Pos7 := Row_Pos14;
        Or_Res7 := Transform_Res12;
        goto Exit_Or7;
    end if;
    
--  BEGIN <Transform(<ASTNodeType GenericInstantiation>) (root of 'basic_expr') at parser.lkt:386:11>

Transform_Diags13 := Parser.Diagnostics.Length;


--  BEGIN <_Row (root of 'basic_expr') at parser.lkt:386:11>

Row_Pos15 := Pos;



--  BEGIN <Defer (for 'basic_expr') at parser.lkt:386:32>

Defer_Res25 :=
   Basic_Expr_Or_Parse0 (Parser, Row_Pos15);
Defer_Pos25 := Parser.Current_Pos;

--  END <Defer (for 'basic_expr') at parser.lkt:386:32>




if Defer_Pos25 /= No_Token_Index then

   Row_Pos15 := Defer_Pos25;

else
   Row_Pos15 := No_Token_Index;
   goto Exit_Row15_0;

end if;


--  BEGIN <Token(<WithText LBrack>, ) (root of 'basic_expr') at parser.lkt:386:43>

Token_Res15 := Row_Pos15;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res15));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_L_Brack)
   then
       Token_Pos15 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos15 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos15,
             Expected_Token_Id => Lkt_L_Brack,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos15 := Row_Pos15 + 1;
   end if;
end;

--  END <Token(<WithText LBrack>, ) (root of 'basic_expr') at parser.lkt:386:43>




if Token_Pos15 /= No_Token_Index then

   Row_Pos15 := Token_Pos15;

else
   Row_Pos15 := No_Token_Index;
   goto Exit_Row15_0;

end if;


--  BEGIN <Defer (for 'type_list') at parser.lkt:386:47>

Defer_Res26 :=
   Type_List_List_Parse0 (Parser, Row_Pos15);
Defer_Pos26 := Parser.Current_Pos;

--  END <Defer (for 'type_list') at parser.lkt:386:47>




if Defer_Pos26 /= No_Token_Index then

   Row_Pos15 := Defer_Pos26;

else
   Row_Pos15 := No_Token_Index;
   goto Exit_Row15_0;

end if;


--  BEGIN <Token(<WithText RBrack>, ) (root of 'basic_expr') at parser.lkt:386:57>

Token_Res16 := Row_Pos15;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res16));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_R_Brack)
   then
       Token_Pos16 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos15 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos15,
             Expected_Token_Id => Lkt_R_Brack,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos16 := Row_Pos15 + 1;
   end if;
end;

--  END <Token(<WithText RBrack>, ) (root of 'basic_expr') at parser.lkt:386:57>




if Token_Pos16 /= No_Token_Index then

   Row_Pos15 := Token_Pos16;

else
   Row_Pos15 := No_Token_Index;
   goto Exit_Row15_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row15_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'basic_expr') at parser.lkt:386:11>



if Row_Pos15 /= No_Token_Index then

   Transform_Res13 := Allocate_Generic_Instantiation (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res13,
      Kind => Lkt_Generic_Instantiation,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos15 = Pos
                            then No_Token_Index
                            else Row_Pos15 - 1));

      
      Initialize_Fields_For_Generic_Instantiation
        (Self => Transform_Res13,
         Generic_Instantiation_F_Name => Defer_Res25,
         Generic_Instantiation_F_Args => Defer_Res26);

         if Defer_Res25 /= null and then Is_Incomplete (Defer_Res25) then
            Transform_Res13.Last_Attempted_Child := 0;
         elsif Defer_Res25 /= null and then not Is_Ghost (Defer_Res25) then
            Transform_Res13.Last_Attempted_Child := -1;
         end if;
         if Defer_Res26 /= null and then Is_Incomplete (Defer_Res26) then
            Transform_Res13.Last_Attempted_Child := 0;
         elsif Defer_Res26 /= null and then not Is_Ghost (Defer_Res26) then
            Transform_Res13.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos15 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags13);
end if;

--  END <Transform(<ASTNodeType GenericInstantiation>) (root of 'basic_expr') at parser.lkt:386:11>

    if Row_Pos15 /= No_Token_Index then
        Or_Pos7 := Row_Pos15;
        Or_Res7 := Transform_Res13;
        goto Exit_Or7;
    end if;
    
--  BEGIN <Transform(<ASTNodeType SubscriptExpr>) (root of 'basic_expr') at parser.lkt:387:11>

Transform_Diags14 := Parser.Diagnostics.Length;


--  BEGIN <_Row (root of 'basic_expr') at parser.lkt:387:11>

Row_Pos16 := Pos;



--  BEGIN <Defer (for 'basic_expr') at parser.lkt:387:25>

Defer_Res27 :=
   Basic_Expr_Or_Parse0 (Parser, Row_Pos16);
Defer_Pos27 := Parser.Current_Pos;

--  END <Defer (for 'basic_expr') at parser.lkt:387:25>




if Defer_Pos27 /= No_Token_Index then

   Row_Pos16 := Defer_Pos27;

else
   Row_Pos16 := No_Token_Index;
   goto Exit_Row16_0;

end if;


--  BEGIN <Defer (for 'null_cond_qual') at parser.lkt:387:36>

Defer_Res28 :=
   Null_Cond_Qual_Opt_Parse0 (Parser, Row_Pos16);
Defer_Pos28 := Parser.Current_Pos;

--  END <Defer (for 'null_cond_qual') at parser.lkt:387:36>




if Defer_Pos28 /= No_Token_Index then

   Row_Pos16 := Defer_Pos28;

else
   Row_Pos16 := No_Token_Index;
   goto Exit_Row16_0;

end if;


--  BEGIN <Token(<WithText LBrack>, ) (root of 'basic_expr') at parser.lkt:387:51>

Token_Res17 := Row_Pos16;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res17));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_L_Brack)
   then
       Token_Pos17 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos16 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos16,
             Expected_Token_Id => Lkt_L_Brack,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos17 := Row_Pos16 + 1;
   end if;
end;

--  END <Token(<WithText LBrack>, ) (root of 'basic_expr') at parser.lkt:387:51>




if Token_Pos17 /= No_Token_Index then

   Row_Pos16 := Token_Pos17;

else
   Row_Pos16 := No_Token_Index;
   goto Exit_Row16_0;

end if;


--  BEGIN <Defer (for 'expr') at parser.lkt:387:55>

Defer_Res29 :=
   Expr_Or_Parse1 (Parser, Row_Pos16);
Defer_Pos29 := Parser.Current_Pos;

--  END <Defer (for 'expr') at parser.lkt:387:55>




if Defer_Pos29 /= No_Token_Index then

   Row_Pos16 := Defer_Pos29;

else
   Row_Pos16 := No_Token_Index;
   goto Exit_Row16_0;

end if;


--  BEGIN <Token(<WithText RBrack>, ) (root of 'basic_expr') at parser.lkt:387:60>

Token_Res18 := Row_Pos16;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res18));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_R_Brack)
   then
       Token_Pos18 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos16 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos16,
             Expected_Token_Id => Lkt_R_Brack,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos18 := Row_Pos16 + 1;
   end if;
end;

--  END <Token(<WithText RBrack>, ) (root of 'basic_expr') at parser.lkt:387:60>




if Token_Pos18 /= No_Token_Index then

   Row_Pos16 := Token_Pos18;

else
   Row_Pos16 := No_Token_Index;
   goto Exit_Row16_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row16_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'basic_expr') at parser.lkt:387:11>



if Row_Pos16 /= No_Token_Index then

   Transform_Res14 := Allocate_Subscript_Expr (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res14,
      Kind => Lkt_Subscript_Expr,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos16 = Pos
                            then No_Token_Index
                            else Row_Pos16 - 1));

      
      Initialize_Fields_For_Subscript_Expr
        (Self => Transform_Res14,
         Subscript_Expr_F_Prefix => Defer_Res27,
         Subscript_Expr_F_Null_Cond => Defer_Res28,
         Subscript_Expr_F_Index => Defer_Res29);

         if Defer_Res27 /= null and then Is_Incomplete (Defer_Res27) then
            Transform_Res14.Last_Attempted_Child := 0;
         elsif Defer_Res27 /= null and then not Is_Ghost (Defer_Res27) then
            Transform_Res14.Last_Attempted_Child := -1;
         end if;
         if Defer_Res28 /= null and then Is_Incomplete (Defer_Res28) then
            Transform_Res14.Last_Attempted_Child := 0;
         elsif Defer_Res28 /= null and then not Is_Ghost (Defer_Res28) then
            Transform_Res14.Last_Attempted_Child := -1;
         end if;
         if Defer_Res29 /= null and then Is_Incomplete (Defer_Res29) then
            Transform_Res14.Last_Attempted_Child := 0;
         elsif Defer_Res29 /= null and then not Is_Ghost (Defer_Res29) then
            Transform_Res14.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos16 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags14);
end if;

--  END <Transform(<ASTNodeType SubscriptExpr>) (root of 'basic_expr') at parser.lkt:387:11>

    if Row_Pos16 /= No_Token_Index then
        Or_Pos7 := Row_Pos16;
        Or_Res7 := Transform_Res14;
        goto Exit_Or7;
    end if;
    
--  BEGIN <Transform(<ASTNodeType ErrorOnNull>) (root of 'basic_expr') at parser.lkt:388:11>

Transform_Diags15 := Parser.Diagnostics.Length;


--  BEGIN <_Row (root of 'basic_expr') at parser.lkt:388:11>

Row_Pos17 := Pos;



--  BEGIN <Defer (for 'basic_expr') at parser.lkt:388:23>

Defer_Res30 :=
   Basic_Expr_Or_Parse0 (Parser, Row_Pos17);
Defer_Pos30 := Parser.Current_Pos;

--  END <Defer (for 'basic_expr') at parser.lkt:388:23>




if Defer_Pos30 /= No_Token_Index then

   Row_Pos17 := Defer_Pos30;

else
   Row_Pos17 := No_Token_Index;
   goto Exit_Row17_0;

end if;


--  BEGIN <Token(<WithText ExclMark>, ) (root of 'basic_expr') at parser.lkt:388:34>

Token_Res19 := Row_Pos17;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res19));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_Excl_Mark)
   then
       Token_Pos19 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos17 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos17,
             Expected_Token_Id => Lkt_Excl_Mark,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos19 := Row_Pos17 + 1;
   end if;
end;

--  END <Token(<WithText ExclMark>, ) (root of 'basic_expr') at parser.lkt:388:34>




if Token_Pos19 /= No_Token_Index then

   Row_Pos17 := Token_Pos19;

else
   Row_Pos17 := No_Token_Index;
   goto Exit_Row17_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row17_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'basic_expr') at parser.lkt:388:11>



if Row_Pos17 /= No_Token_Index then

   Transform_Res15 := Allocate_Error_On_Null (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res15,
      Kind => Lkt_Error_On_Null,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos17 = Pos
                            then No_Token_Index
                            else Row_Pos17 - 1));

      
      Initialize_Fields_For_Error_On_Null
        (Self => Transform_Res15,
         Error_On_Null_F_Expr => Defer_Res30);

         if Defer_Res30 /= null and then Is_Incomplete (Defer_Res30) then
            Transform_Res15.Last_Attempted_Child := 0;
         elsif Defer_Res30 /= null and then not Is_Ghost (Defer_Res30) then
            Transform_Res15.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos17 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags15);
end if;

--  END <Transform(<ASTNodeType ErrorOnNull>) (root of 'basic_expr') at parser.lkt:388:11>

    if Row_Pos17 /= No_Token_Index then
        Or_Pos7 := Row_Pos17;
        Or_Res7 := Transform_Res15;
        goto Exit_Or7;
    end if;
    
--  BEGIN <Transform(<ASTNodeType KeepExpr>) (root of 'basic_expr') at parser.lkt:389:11>

Transform_Diags16 := Parser.Diagnostics.Length;


--  BEGIN <_Row (root of 'basic_expr') at parser.lkt:389:11>

Row_Pos18 := Pos;



--  BEGIN <Defer (for 'basic_expr') at parser.lkt:390:13>

Defer_Res31 :=
   Basic_Expr_Or_Parse0 (Parser, Row_Pos18);
Defer_Pos31 := Parser.Current_Pos;

--  END <Defer (for 'basic_expr') at parser.lkt:390:13>




if Defer_Pos31 /= No_Token_Index then

   Row_Pos18 := Defer_Pos31;

else
   Row_Pos18 := No_Token_Index;
   goto Exit_Row18_0;

end if;


--  BEGIN <Defer (for 'null_cond_qual') at parser.lkt:390:24>

Defer_Res32 :=
   Null_Cond_Qual_Opt_Parse0 (Parser, Row_Pos18);
Defer_Pos32 := Parser.Current_Pos;

--  END <Defer (for 'null_cond_qual') at parser.lkt:390:24>




if Defer_Pos32 /= No_Token_Index then

   Row_Pos18 := Defer_Pos32;

else
   Row_Pos18 := No_Token_Index;
   goto Exit_Row18_0;

end if;


--  BEGIN <Token(<WithText Dot>, ) (root of 'basic_expr') at parser.lkt:390:39>

Token_Res20 := Row_Pos18;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res20));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_Dot)
   then
       Token_Pos20 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos18 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos18,
             Expected_Token_Id => Lkt_Dot,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos20 := Row_Pos18 + 1;
   end if;
end;

--  END <Token(<WithText Dot>, ) (root of 'basic_expr') at parser.lkt:390:39>




if Token_Pos20 /= No_Token_Index then

   Row_Pos18 := Token_Pos20;

else
   Row_Pos18 := No_Token_Index;
   goto Exit_Row18_0;

end if;


--  BEGIN <Token(<WithSymbol Identifier>, keep) (root of 'basic_expr') at parser.lkt:390:43>

Token_Res21 := Row_Pos18;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res21));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_Identifier)
      or else T.Symbol /= Precomputed_Symbol
        (Precomputed_Symbol_Table (Parser.TDH.Symbols),
         Precomputed_Sym_Keep)
   then
       Token_Pos21 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos18 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos18,
             Expected_Token_Id => Lkt_Identifier,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos21 := Row_Pos18 + 1;
   end if;
end;

--  END <Token(<WithSymbol Identifier>, keep) (root of 'basic_expr') at parser.lkt:390:43>




if Token_Pos21 /= No_Token_Index then

   Row_Pos18 := Token_Pos21;

else
   Row_Pos18 := No_Token_Index;
   goto Exit_Row18_0;

end if;


--  BEGIN <Token(<WithText LBrack>, ) (root of 'basic_expr') at parser.lkt:390:63>

Token_Res22 := Row_Pos18;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res22));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_L_Brack)
   then
       Token_Pos22 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos18 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos18,
             Expected_Token_Id => Lkt_L_Brack,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos22 := Row_Pos18 + 1;
   end if;
end;

--  END <Token(<WithText LBrack>, ) (root of 'basic_expr') at parser.lkt:390:63>




if Token_Pos22 /= No_Token_Index then

   Row_Pos18 := Token_Pos22;

else
   Row_Pos18 := No_Token_Index;
   goto Exit_Row18_0;

end if;


--  BEGIN <Defer (for 'type_ref') at parser.lkt:390:67>

Defer_Res33 :=
   Type_Ref_Or_Parse0 (Parser, Row_Pos18);
Defer_Pos33 := Parser.Current_Pos;

--  END <Defer (for 'type_ref') at parser.lkt:390:67>




if Defer_Pos33 /= No_Token_Index then

   Row_Pos18 := Defer_Pos33;

else
   Row_Pos18 := No_Token_Index;
   goto Exit_Row18_0;

end if;


--  BEGIN <Token(<WithText RBrack>, ) (root of 'basic_expr') at parser.lkt:390:76>

Token_Res23 := Row_Pos18;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res23));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_R_Brack)
   then
       Token_Pos23 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos18 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos18,
             Expected_Token_Id => Lkt_R_Brack,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos23 := Row_Pos18 + 1;
   end if;
end;

--  END <Token(<WithText RBrack>, ) (root of 'basic_expr') at parser.lkt:390:76>




if Token_Pos23 /= No_Token_Index then

   Row_Pos18 := Token_Pos23;

else
   Row_Pos18 := No_Token_Index;
   goto Exit_Row18_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row18_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'basic_expr') at parser.lkt:389:11>



if Row_Pos18 /= No_Token_Index then

   Transform_Res16 := Allocate_Keep_Expr (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res16,
      Kind => Lkt_Keep_Expr,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos18 = Pos
                            then No_Token_Index
                            else Row_Pos18 - 1));

      
      Initialize_Fields_For_Keep_Expr
        (Self => Transform_Res16,
         Keep_Expr_F_Expr => Defer_Res31,
         Keep_Expr_F_Null_Cond => Defer_Res32,
         Keep_Expr_F_Keep_Type => Defer_Res33);

         if Defer_Res31 /= null and then Is_Incomplete (Defer_Res31) then
            Transform_Res16.Last_Attempted_Child := 0;
         elsif Defer_Res31 /= null and then not Is_Ghost (Defer_Res31) then
            Transform_Res16.Last_Attempted_Child := -1;
         end if;
         if Defer_Res32 /= null and then Is_Incomplete (Defer_Res32) then
            Transform_Res16.Last_Attempted_Child := 0;
         elsif Defer_Res32 /= null and then not Is_Ghost (Defer_Res32) then
            Transform_Res16.Last_Attempted_Child := -1;
         end if;
         if Defer_Res33 /= null and then Is_Incomplete (Defer_Res33) then
            Transform_Res16.Last_Attempted_Child := 0;
         elsif Defer_Res33 /= null and then not Is_Ghost (Defer_Res33) then
            Transform_Res16.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos18 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags16);
end if;

--  END <Transform(<ASTNodeType KeepExpr>) (root of 'basic_expr') at parser.lkt:389:11>

    if Row_Pos18 /= No_Token_Index then
        Or_Pos7 := Row_Pos18;
        Or_Res7 := Transform_Res16;
        goto Exit_Or7;
    end if;
    
--  BEGIN <Transform(<ASTNodeType CastExpr>) (root of 'basic_expr') at parser.lkt:392:11>

Transform_Diags17 := Parser.Diagnostics.Length;


--  BEGIN <_Row (root of 'basic_expr') at parser.lkt:392:11>

Row_Pos19 := Pos;



--  BEGIN <Defer (for 'basic_expr') at parser.lkt:393:13>

Defer_Res34 :=
   Basic_Expr_Or_Parse0 (Parser, Row_Pos19);
Defer_Pos34 := Parser.Current_Pos;

--  END <Defer (for 'basic_expr') at parser.lkt:393:13>




if Defer_Pos34 /= No_Token_Index then

   Row_Pos19 := Defer_Pos34;

else
   Row_Pos19 := No_Token_Index;
   goto Exit_Row19_0;

end if;


--  BEGIN <Defer (for 'null_cond_qual') at parser.lkt:394:13>

Defer_Res35 :=
   Null_Cond_Qual_Opt_Parse0 (Parser, Row_Pos19);
Defer_Pos35 := Parser.Current_Pos;

--  END <Defer (for 'null_cond_qual') at parser.lkt:394:13>




if Defer_Pos35 /= No_Token_Index then

   Row_Pos19 := Defer_Pos35;

else
   Row_Pos19 := No_Token_Index;
   goto Exit_Row19_0;

end if;


--  BEGIN <Token(<WithText Dot>, ) (root of 'basic_expr') at parser.lkt:395:13>

Token_Res24 := Row_Pos19;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res24));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_Dot)
   then
       Token_Pos24 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos19 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos19,
             Expected_Token_Id => Lkt_Dot,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos24 := Row_Pos19 + 1;
   end if;
end;

--  END <Token(<WithText Dot>, ) (root of 'basic_expr') at parser.lkt:395:13>




if Token_Pos24 /= No_Token_Index then

   Row_Pos19 := Token_Pos24;

else
   Row_Pos19 := No_Token_Index;
   goto Exit_Row19_0;

end if;


--  BEGIN <Token(<WithSymbol Identifier>, as) (root of 'basic_expr') at parser.lkt:396:13>

Token_Res25 := Row_Pos19;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res25));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_Identifier)
      or else T.Symbol /= Precomputed_Symbol
        (Precomputed_Symbol_Table (Parser.TDH.Symbols),
         Precomputed_Sym_As)
   then
       Token_Pos25 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos19 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos19,
             Expected_Token_Id => Lkt_Identifier,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos25 := Row_Pos19 + 1;
   end if;
end;

--  END <Token(<WithSymbol Identifier>, as) (root of 'basic_expr') at parser.lkt:396:13>




if Token_Pos25 /= No_Token_Index then

   Row_Pos19 := Token_Pos25;

else
   Row_Pos19 := No_Token_Index;
   goto Exit_Row19_0;

end if;


--  BEGIN <Opt (root of 'basic_expr') at parser.lkt:397:13>












--  BEGIN <Token(<WithText ExclMark>, ) (root of 'basic_expr') at parser.lkt:397:26>

Token_Res26 := Row_Pos19;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res26));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_Excl_Mark)
   then
       Token_Pos26 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos19 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos19,
             Expected_Token_Id => Lkt_Excl_Mark,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos26 := Row_Pos19 + 1;
   end if;
end;

--  END <Token(<WithText ExclMark>, ) (root of 'basic_expr') at parser.lkt:397:26>


if Token_Pos26 = No_Token_Index then

         Opt_Res0 := Allocate_Excludes_Null_Absent (Parser.Mem_Pool);
         Initialize
           (Self              => Opt_Res0,
            Kind              => Lkt_Excludes_Null_Absent,
            Unit              => Parser.Unit,
            Token_Start_Index => Row_Pos19,
            Token_End_Index   => No_Token_Index);


       
   Token_Pos26 := Row_Pos19;


else

      Opt_Res0 := Allocate_Excludes_Null_Present (Parser.Mem_Pool);
      Initialize
        (Self              => Opt_Res0,
         Kind              => Lkt_Excludes_Null_Present,
         Unit              => Parser.Unit,
         Token_Start_Index => Row_Pos19,
         Token_End_Index   => Token_Pos26 - 1);

end if;

--  END <Opt (root of 'basic_expr') at parser.lkt:397:13>




if Token_Pos26 /= No_Token_Index then

   Row_Pos19 := Token_Pos26;

else
   Row_Pos19 := No_Token_Index;
   goto Exit_Row19_0;

end if;


--  BEGIN <Token(<WithText LBrack>, ) (root of 'basic_expr') at parser.lkt:398:13>

Token_Res27 := Row_Pos19;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res27));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_L_Brack)
   then
       Token_Pos27 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos19 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos19,
             Expected_Token_Id => Lkt_L_Brack,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos27 := Row_Pos19 + 1;
   end if;
end;

--  END <Token(<WithText LBrack>, ) (root of 'basic_expr') at parser.lkt:398:13>




if Token_Pos27 /= No_Token_Index then

   Row_Pos19 := Token_Pos27;

else
   Row_Pos19 := No_Token_Index;
   goto Exit_Row19_0;

end if;


--  BEGIN <Defer (for 'type_ref') at parser.lkt:399:13>

Defer_Res36 :=
   Type_Ref_Or_Parse0 (Parser, Row_Pos19);
Defer_Pos36 := Parser.Current_Pos;

--  END <Defer (for 'type_ref') at parser.lkt:399:13>




if Defer_Pos36 /= No_Token_Index then

   Row_Pos19 := Defer_Pos36;

else
   Row_Pos19 := No_Token_Index;
   goto Exit_Row19_0;

end if;


--  BEGIN <Token(<WithText RBrack>, ) (root of 'basic_expr') at parser.lkt:400:13>

Token_Res28 := Row_Pos19;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res28));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_R_Brack)
   then
       Token_Pos28 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos19 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos19,
             Expected_Token_Id => Lkt_R_Brack,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos28 := Row_Pos19 + 1;
   end if;
end;

--  END <Token(<WithText RBrack>, ) (root of 'basic_expr') at parser.lkt:400:13>




if Token_Pos28 /= No_Token_Index then

   Row_Pos19 := Token_Pos28;

else
   Row_Pos19 := No_Token_Index;
   goto Exit_Row19_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row19_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'basic_expr') at parser.lkt:392:11>



if Row_Pos19 /= No_Token_Index then

   Transform_Res17 := Allocate_Cast_Expr (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res17,
      Kind => Lkt_Cast_Expr,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos19 = Pos
                            then No_Token_Index
                            else Row_Pos19 - 1));

      
      Initialize_Fields_For_Cast_Expr
        (Self => Transform_Res17,
         Cast_Expr_F_Expr => Defer_Res34,
         Cast_Expr_F_Null_Cond => Defer_Res35,
         Cast_Expr_F_Excludes_Null => Opt_Res0,
         Cast_Expr_F_Dest_Type => Defer_Res36);

         if Defer_Res34 /= null and then Is_Incomplete (Defer_Res34) then
            Transform_Res17.Last_Attempted_Child := 0;
         elsif Defer_Res34 /= null and then not Is_Ghost (Defer_Res34) then
            Transform_Res17.Last_Attempted_Child := -1;
         end if;
         if Defer_Res35 /= null and then Is_Incomplete (Defer_Res35) then
            Transform_Res17.Last_Attempted_Child := 0;
         elsif Defer_Res35 /= null and then not Is_Ghost (Defer_Res35) then
            Transform_Res17.Last_Attempted_Child := -1;
         end if;
         if Opt_Res0 /= null and then Is_Incomplete (Opt_Res0) then
            Transform_Res17.Last_Attempted_Child := 0;
         elsif Opt_Res0 /= null and then not Is_Ghost (Opt_Res0) then
            Transform_Res17.Last_Attempted_Child := -1;
         end if;
         if Defer_Res36 /= null and then Is_Incomplete (Defer_Res36) then
            Transform_Res17.Last_Attempted_Child := 0;
         elsif Defer_Res36 /= null and then not Is_Ghost (Defer_Res36) then
            Transform_Res17.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos19 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags17);
end if;

--  END <Transform(<ASTNodeType CastExpr>) (root of 'basic_expr') at parser.lkt:392:11>

    if Row_Pos19 /= No_Token_Index then
        Or_Pos7 := Row_Pos19;
        Or_Res7 := Transform_Res17;
        goto Exit_Or7;
    end if;
    
--  BEGIN <Transform(<ASTNodeType LogicPredicate>) (root of 'basic_expr') at parser.lkt:402:11>

Transform_Diags18 := Parser.Diagnostics.Length;


--  BEGIN <_Row (root of 'basic_expr') at parser.lkt:402:11>

Row_Pos20 := Pos;



--  BEGIN <Defer (for 'basic_expr') at parser.lkt:402:26>

Defer_Res37 :=
   Basic_Expr_Or_Parse0 (Parser, Row_Pos20);
Defer_Pos37 := Parser.Current_Pos;

--  END <Defer (for 'basic_expr') at parser.lkt:402:26>




if Defer_Pos37 /= No_Token_Index then

   Row_Pos20 := Defer_Pos37;

else
   Row_Pos20 := No_Token_Index;
   goto Exit_Row20_0;

end if;


--  BEGIN <Token(<WithText Percent>, ) (root of 'basic_expr') at parser.lkt:402:37>

Token_Res29 := Row_Pos20;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res29));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_Percent)
   then
       Token_Pos29 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos20 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos20,
             Expected_Token_Id => Lkt_Percent,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos29 := Row_Pos20 + 1;
   end if;
end;

--  END <Token(<WithText Percent>, ) (root of 'basic_expr') at parser.lkt:402:37>




if Token_Pos29 /= No_Token_Index then

   Row_Pos20 := Token_Pos29;

else
   Row_Pos20 := No_Token_Index;
   goto Exit_Row20_0;

end if;


--  BEGIN <Token(<WithText LPar>, ) (root of 'basic_expr') at parser.lkt:402:41>

Token_Res30 := Row_Pos20;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res30));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_L_Par)
   then
       Token_Pos30 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos20 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos20,
             Expected_Token_Id => Lkt_L_Par,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos30 := Row_Pos20 + 1;
   end if;
end;

--  END <Token(<WithText LPar>, ) (root of 'basic_expr') at parser.lkt:402:41>




if Token_Pos30 /= No_Token_Index then

   Row_Pos20 := Token_Pos30;

else
   Row_Pos20 := No_Token_Index;
   goto Exit_Row20_0;

end if;


--  BEGIN <Defer (for 'args') at parser.lkt:402:45>

Defer_Res38 :=
   Args_List_Parse0 (Parser, Row_Pos20);
Defer_Pos38 := Parser.Current_Pos;

--  END <Defer (for 'args') at parser.lkt:402:45>




if Defer_Pos38 /= No_Token_Index then

   Row_Pos20 := Defer_Pos38;

else
   Row_Pos20 := No_Token_Index;
   goto Exit_Row20_0;

end if;


--  BEGIN <Token(<WithText RPar>, ) (root of 'basic_expr') at parser.lkt:402:50>

Token_Res31 := Row_Pos20;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res31));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_R_Par)
   then
       Token_Pos31 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos20 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos20,
             Expected_Token_Id => Lkt_R_Par,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos31 := Row_Pos20 + 1;
   end if;
end;

--  END <Token(<WithText RPar>, ) (root of 'basic_expr') at parser.lkt:402:50>




if Token_Pos31 /= No_Token_Index then

   Row_Pos20 := Token_Pos31;

else
   Row_Pos20 := No_Token_Index;
   goto Exit_Row20_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row20_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'basic_expr') at parser.lkt:402:11>



if Row_Pos20 /= No_Token_Index then

   Transform_Res18 := Allocate_Logic_Predicate (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res18,
      Kind => Lkt_Logic_Predicate,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos20 = Pos
                            then No_Token_Index
                            else Row_Pos20 - 1));

      
      Initialize_Fields_For_Logic_Predicate
        (Self => Transform_Res18,
         Base_Call_Expr_F_Name => Defer_Res37,
         Base_Call_Expr_F_Args => Defer_Res38);

         if Defer_Res37 /= null and then Is_Incomplete (Defer_Res37) then
            Transform_Res18.Last_Attempted_Child := 0;
         elsif Defer_Res37 /= null and then not Is_Ghost (Defer_Res37) then
            Transform_Res18.Last_Attempted_Child := -1;
         end if;
         if Defer_Res38 /= null and then Is_Incomplete (Defer_Res38) then
            Transform_Res18.Last_Attempted_Child := 0;
         elsif Defer_Res38 /= null and then not Is_Ghost (Defer_Res38) then
            Transform_Res18.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos20 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags18);
end if;

--  END <Transform(<ASTNodeType LogicPredicate>) (root of 'basic_expr') at parser.lkt:402:11>

    if Row_Pos20 /= No_Token_Index then
        Or_Pos7 := Row_Pos20;
        Or_Res7 := Transform_Res18;
        goto Exit_Or7;
    end if;
    
--  BEGIN <Transform(<ASTNodeType DotExpr>) (root of 'basic_expr') at parser.lkt:403:11>

Transform_Diags19 := Parser.Diagnostics.Length;


--  BEGIN <_Row (root of 'basic_expr') at parser.lkt:403:11>

Row_Pos21 := Pos;



--  BEGIN <Defer (for 'basic_expr') at parser.lkt:403:19>

Defer_Res39 :=
   Basic_Expr_Or_Parse0 (Parser, Row_Pos21);
Defer_Pos39 := Parser.Current_Pos;

--  END <Defer (for 'basic_expr') at parser.lkt:403:19>



Row_Progress0 := 1;

if Defer_Pos39 /= No_Token_Index then

   Row_Pos21 := Defer_Pos39;

else
   Row_Pos21 := No_Token_Index;
   goto Exit_Row21_0;

end if;


--  BEGIN <Defer (for 'null_cond_qual') at parser.lkt:403:30>

Defer_Res40 :=
   Null_Cond_Qual_Opt_Parse0 (Parser, Row_Pos21);
Defer_Pos40 := Parser.Current_Pos;

--  END <Defer (for 'null_cond_qual') at parser.lkt:403:30>



Row_Progress0 := 2;

if Defer_Pos40 /= No_Token_Index then

   Row_Pos21 := Defer_Pos40;

else
   Row_Pos21 := No_Token_Index;
   goto Exit_Row21_0;

end if;


--  BEGIN <Token(<WithText Dot>, ) (root of 'basic_expr') at parser.lkt:403:45>

Token_Res32 := Row_Pos21;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res32));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_Dot)
   then
       Token_Pos32 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos21 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos21,
             Expected_Token_Id => Lkt_Dot,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos32 := Row_Pos21 + 1;
   end if;
end;

--  END <Token(<WithText Dot>, ) (root of 'basic_expr') at parser.lkt:403:45>



Row_Progress0 := 3;

if Token_Pos32 /= No_Token_Index then

   Row_Pos21 := Token_Pos32;

else
   Row_Pos21 := No_Token_Index;
   goto Exit_Row21_0;

end if;


--  BEGIN <Cut (root of 'basic_expr') at parser.lkt:403:49>
Nobt0 := True;
--  END <Cut (root of 'basic_expr') at parser.lkt:403:49>


   Nobt0 := Nobt0;

Row_Progress0 := 4;

if Row_Pos21 /= No_Token_Index then

   Row_Pos21 := Row_Pos21;

else
   Row_Pos21 := No_Token_Index;
   goto Exit_Row21_0;

end if;


--  BEGIN <Defer (for 'ref_id') at parser.lkt:403:51>

Defer_Res41 :=
   Ref_Id_Transform_Parse0 (Parser, Row_Pos21);
Defer_Pos41 := Parser.Current_Pos;

--  END <Defer (for 'ref_id') at parser.lkt:403:51>



Row_Progress0 := 5;

if Defer_Pos41 /= No_Token_Index then

   Row_Pos21 := Defer_Pos41;

else
   Row_Pos21 := No_Token_Index;
   goto Exit_Row21_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row21_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'basic_expr') at parser.lkt:403:11>


if Row_Pos21 = No_Token_Index and then Nobt0 then

   Row_Pos21 := Parser.Last_Fail.Pos;

   Transform_Has_Failed0 := True;
end if;

if Row_Pos21 /= No_Token_Index then

   Transform_Res19 := Allocate_Dot_Expr (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res19,
      Kind => Lkt_Dot_Expr,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos21 = Pos
                            then No_Token_Index
                            else Row_Pos21 - 1));

      
      Initialize_Fields_For_Dot_Expr
        (Self => Transform_Res19,
         Dot_Expr_F_Prefix => Defer_Res39,
         Dot_Expr_F_Null_Cond => Defer_Res40,
         Dot_Expr_F_Suffix => Defer_Res41);

         if Defer_Res39 /= null and then Is_Incomplete (Defer_Res39) then
            Transform_Res19.Last_Attempted_Child := 0;
         elsif Defer_Res39 /= null and then not Is_Ghost (Defer_Res39) then
            Transform_Res19.Last_Attempted_Child := -1;
         end if;
         if Defer_Res40 /= null and then Is_Incomplete (Defer_Res40) then
            Transform_Res19.Last_Attempted_Child := 0;
         elsif Defer_Res40 /= null and then not Is_Ghost (Defer_Res40) then
            Transform_Res19.Last_Attempted_Child := -1;
         end if;
         if Defer_Res41 /= null and then Is_Incomplete (Defer_Res41) then
            Transform_Res19.Last_Attempted_Child := 0;
         elsif Defer_Res41 /= null and then not Is_Ghost (Defer_Res41) then
            Transform_Res19.Last_Attempted_Child := -1;
         end if;

   if Transform_Has_Failed0 then
      Transform_Res19.Last_Attempted_Child :=
         Row_Progress0;

      Append (Parser.Diagnostics,
              Sloc_Range (Parser.TDH.all,
                          Get_Token (Parser.TDH.all, Pos)),
              To_Text ("Cannot parse <basic_expr>"));

      Add_Last_Fail_Diagnostic (Parser);
   end if;

elsif Row_Pos21 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags19);
end if;

--  END <Transform(<ASTNodeType DotExpr>) (root of 'basic_expr') at parser.lkt:403:11>

    if Row_Pos21 /= No_Token_Index then
        Or_Pos7 := Row_Pos21;
        Or_Res7 := Transform_Res19;
        goto Exit_Or7;
    end if;
    
--  BEGIN <Transform(<ASTNodeType LogicExpr>) (root of 'basic_expr') at parser.lkt:404:11>

Transform_Diags21 := Parser.Diagnostics.Length;


--  BEGIN <_Row (root of 'basic_expr') at parser.lkt:404:11>

Row_Pos22 := Pos;



--  BEGIN <Token(<WithText Percent>, ) (root of 'basic_expr') at parser.lkt:404:21>

Token_Res33 := Row_Pos22;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res33));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_Percent)
   then
       Token_Pos33 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos22 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos22,
             Expected_Token_Id => Lkt_Percent,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos33 := Row_Pos22 + 1;
   end if;
end;

--  END <Token(<WithText Percent>, ) (root of 'basic_expr') at parser.lkt:404:21>




if Token_Pos33 /= No_Token_Index then

   Row_Pos22 := Token_Pos33;

else
   Row_Pos22 := No_Token_Index;
   goto Exit_Row22_0;

end if;


--  BEGIN <Transform(<ASTNodeType CallExpr>) (root of 'basic_expr') at parser.lkt:404:25>

Transform_Diags20 := Parser.Diagnostics.Length;


--  BEGIN <_Row (root of 'basic_expr') at parser.lkt:404:25>

Row_Pos23 := Row_Pos22;



--  BEGIN <Defer (for 'ref_id') at parser.lkt:404:34>

Defer_Res42 :=
   Ref_Id_Transform_Parse0 (Parser, Row_Pos23);
Defer_Pos42 := Parser.Current_Pos;

--  END <Defer (for 'ref_id') at parser.lkt:404:34>




if Defer_Pos42 /= No_Token_Index then

   Row_Pos23 := Defer_Pos42;

else
   Row_Pos23 := No_Token_Index;
   goto Exit_Row23_0;

end if;


--  BEGIN <Token(<WithText LPar>, ) (root of 'basic_expr') at parser.lkt:404:41>

Token_Res34 := Row_Pos23;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res34));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_L_Par)
   then
       Token_Pos34 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos23 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos23,
             Expected_Token_Id => Lkt_L_Par,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos34 := Row_Pos23 + 1;
   end if;
end;

--  END <Token(<WithText LPar>, ) (root of 'basic_expr') at parser.lkt:404:41>




if Token_Pos34 /= No_Token_Index then

   Row_Pos23 := Token_Pos34;

else
   Row_Pos23 := No_Token_Index;
   goto Exit_Row23_0;

end if;


--  BEGIN <Defer (for 'args') at parser.lkt:404:45>

Defer_Res43 :=
   Args_List_Parse0 (Parser, Row_Pos23);
Defer_Pos43 := Parser.Current_Pos;

--  END <Defer (for 'args') at parser.lkt:404:45>




if Defer_Pos43 /= No_Token_Index then

   Row_Pos23 := Defer_Pos43;

else
   Row_Pos23 := No_Token_Index;
   goto Exit_Row23_0;

end if;


--  BEGIN <Token(<WithText RPar>, ) (root of 'basic_expr') at parser.lkt:404:50>

Token_Res35 := Row_Pos23;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res35));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_R_Par)
   then
       Token_Pos35 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos23 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos23,
             Expected_Token_Id => Lkt_R_Par,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos35 := Row_Pos23 + 1;
   end if;
end;

--  END <Token(<WithText RPar>, ) (root of 'basic_expr') at parser.lkt:404:50>




if Token_Pos35 /= No_Token_Index then

   Row_Pos23 := Token_Pos35;

else
   Row_Pos23 := No_Token_Index;
   goto Exit_Row23_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row23_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'basic_expr') at parser.lkt:404:25>



if Row_Pos23 /= No_Token_Index then

   Transform_Res20 := Allocate_Call_Expr (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res20,
      Kind => Lkt_Call_Expr,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos22,
      Token_End_Index   => (if Row_Pos23 = Row_Pos22
                            then No_Token_Index
                            else Row_Pos23 - 1));

      
      Initialize_Fields_For_Call_Expr
        (Self => Transform_Res20,
         Base_Call_Expr_F_Name => Defer_Res42,
         Base_Call_Expr_F_Args => Defer_Res43);

         if Defer_Res42 /= null and then Is_Incomplete (Defer_Res42) then
            Transform_Res20.Last_Attempted_Child := 0;
         elsif Defer_Res42 /= null and then not Is_Ghost (Defer_Res42) then
            Transform_Res20.Last_Attempted_Child := -1;
         end if;
         if Defer_Res43 /= null and then Is_Incomplete (Defer_Res43) then
            Transform_Res20.Last_Attempted_Child := 0;
         elsif Defer_Res43 /= null and then not Is_Ghost (Defer_Res43) then
            Transform_Res20.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos23 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags20);
end if;

--  END <Transform(<ASTNodeType CallExpr>) (root of 'basic_expr') at parser.lkt:404:25>




if Row_Pos23 /= No_Token_Index then

   Row_Pos22 := Row_Pos23;

else
   Row_Pos22 := No_Token_Index;
   goto Exit_Row22_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row22_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'basic_expr') at parser.lkt:404:11>



if Row_Pos22 /= No_Token_Index then

   Transform_Res21 := Allocate_Logic_Expr (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res21,
      Kind => Lkt_Logic_Expr,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos22 = Pos
                            then No_Token_Index
                            else Row_Pos22 - 1));

      
      Initialize_Fields_For_Logic_Expr
        (Self => Transform_Res21,
         Logic_Expr_F_Expr => Transform_Res20);

         if Transform_Res20 /= null and then Is_Incomplete (Transform_Res20) then
            Transform_Res21.Last_Attempted_Child := 0;
         elsif Transform_Res20 /= null and then not Is_Ghost (Transform_Res20) then
            Transform_Res21.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos22 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags21);
end if;

--  END <Transform(<ASTNodeType LogicExpr>) (root of 'basic_expr') at parser.lkt:404:11>

    if Row_Pos22 /= No_Token_Index then
        Or_Pos7 := Row_Pos22;
        Or_Res7 := Transform_Res21;
        goto Exit_Or7;
    end if;
    
--  BEGIN <Transform(<ASTNodeType LogicExpr>) (root of 'basic_expr') at parser.lkt:405:11>

Transform_Diags22 := Parser.Diagnostics.Length;


--  BEGIN <_Row (root of 'basic_expr') at parser.lkt:405:11>

Row_Pos24 := Pos;



--  BEGIN <Token(<WithText Percent>, ) (root of 'basic_expr') at parser.lkt:405:21>

Token_Res36 := Row_Pos24;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res36));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_Percent)
   then
       Token_Pos36 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos24 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos24,
             Expected_Token_Id => Lkt_Percent,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos36 := Row_Pos24 + 1;
   end if;
end;

--  END <Token(<WithText Percent>, ) (root of 'basic_expr') at parser.lkt:405:21>




if Token_Pos36 /= No_Token_Index then

   Row_Pos24 := Token_Pos36;

else
   Row_Pos24 := No_Token_Index;
   goto Exit_Row24_0;

end if;


--  BEGIN <Defer (for 'ref_id') at parser.lkt:405:25>

Defer_Res44 :=
   Ref_Id_Transform_Parse0 (Parser, Row_Pos24);
Defer_Pos44 := Parser.Current_Pos;

--  END <Defer (for 'ref_id') at parser.lkt:405:25>




if Defer_Pos44 /= No_Token_Index then

   Row_Pos24 := Defer_Pos44;

else
   Row_Pos24 := No_Token_Index;
   goto Exit_Row24_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row24_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'basic_expr') at parser.lkt:405:11>



if Row_Pos24 /= No_Token_Index then

   Transform_Res22 := Allocate_Logic_Expr (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res22,
      Kind => Lkt_Logic_Expr,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos24 = Pos
                            then No_Token_Index
                            else Row_Pos24 - 1));

      
      Initialize_Fields_For_Logic_Expr
        (Self => Transform_Res22,
         Logic_Expr_F_Expr => Defer_Res44);

         if Defer_Res44 /= null and then Is_Incomplete (Defer_Res44) then
            Transform_Res22.Last_Attempted_Child := 0;
         elsif Defer_Res44 /= null and then not Is_Ghost (Defer_Res44) then
            Transform_Res22.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos24 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags22);
end if;

--  END <Transform(<ASTNodeType LogicExpr>) (root of 'basic_expr') at parser.lkt:405:11>

    if Row_Pos24 /= No_Token_Index then
        Or_Pos7 := Row_Pos24;
        Or_Res7 := Transform_Res22;
        goto Exit_Or7;
    end if;
    
--  BEGIN <Defer (for 'term') at parser.lkt:406:11>

Defer_Res45 :=
   Term_Or_Parse0 (Parser, Pos);
Defer_Pos45 := Parser.Current_Pos;

--  END <Defer (for 'term') at parser.lkt:406:11>

    if Defer_Pos45 /= No_Token_Index then
        Or_Pos7 := Defer_Pos45;
        Or_Res7 := Defer_Res45;
        goto Exit_Or7;
    end if;
<<Exit_Or7>>

--  END <Or (root of 'basic_expr') at parser.lkt:384:19>


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------

      if Or_Pos7 > Mem_Pos then
         Mem_Pos := Or_Pos7;
         Mem_Res := Or_Res7;
         Set
           (PP.Basic_Expr_Or_Parse0_Memo,
            Or_Pos7 /= No_Token_Index,
            Or_Res7,
            Pos,
            Or_Pos7);
         goto Try_Again;

      elsif Mem_Pos > Pos then
         Or_Res7 := Mem_Res;
         Or_Pos7 := Mem_Pos;
         goto No_Memo;
      end if;

   Set
     (PP.Basic_Expr_Or_Parse0_Memo,
      Or_Pos7 /= No_Token_Index,
      Or_Res7,
      Pos,
      Or_Pos7);

       <<No_Memo>>

   Parser.Current_Pos := Or_Pos7;

   return Or_Res7;
end Basic_Expr_Or_Parse0;

   


function Basic_Name_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr
is
   use Bare_Expr_Memos;

      Nobt1 :
            Boolean
               := False;
      Row_Pos25 :
            Token_Index
               := No_Token_Index;
      Defer_Pos46 :
            Token_Index
               := No_Token_Index;
      Defer_Res46 :
            Bare_Expr
               := No_Bare_Lkt_Node;
      Null_Res0 :
            Bare_Null_Cond_Qualifier
               := No_Bare_Lkt_Node;
      Token_Pos37 :
            Token_Index
               := No_Token_Index;
      Token_Res37 :
            Token_Index
               := No_Token_Index;
      Defer_Pos47 :
            Token_Index
               := No_Token_Index;
      Defer_Res47 :
            Bare_Ref_Id
               := No_Bare_Lkt_Node;
      Row_Progress1 :
            Integer
               := 0;
      Transform_Res23 :
            Bare_Dot_Expr
               := No_Bare_Lkt_Node;
      Transform_Has_Failed1 :
            Boolean
               := False;
      Transform_Diags23 :
            Ada.Containers.Count_Type;
      Defer_Pos48 :
            Token_Index
               := No_Token_Index;
      Defer_Res48 :
            Bare_Ref_Id
               := No_Bare_Lkt_Node;
      Or_Pos8 :
            Token_Index
               := No_Token_Index;
      Or_Res8 :
            Bare_Expr
               := No_Bare_Lkt_Node;

      Mem_Pos : Token_Index := Pos;
      Mem_Res : Bare_Expr := No_Bare_Lkt_Node;

   PP : constant Parser_Private_Part := +Parser.Private_Part;
   M  : Memo_Entry := Get (PP.Basic_Name_Or_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Or_Res8 := M.Instance;
      return Or_Res8;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Or_Res8;
   end if;

       Set (PP.Basic_Name_Or_Parse0_Memo, False, Or_Res8, Pos, Mem_Pos);

       <<Try_Again>>

      Nobt1 := False;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  BEGIN <Or (root of 'basic_name') at parser.lkt:420:19>

Or_Pos8 := No_Token_Index;
Or_Res8 := No_Bare_Lkt_Node;
    
--  BEGIN <Transform(<ASTNodeType DotExpr>) (root of 'basic_name') at parser.lkt:421:9>

Transform_Diags23 := Parser.Diagnostics.Length;


--  BEGIN <_Row (root of 'basic_name') at parser.lkt:421:9>

Row_Pos25 := Pos;



--  BEGIN <Defer (for 'basic_name') at parser.lkt:421:17>

Defer_Res46 :=
   Basic_Name_Or_Parse0 (Parser, Row_Pos25);
Defer_Pos46 := Parser.Current_Pos;

--  END <Defer (for 'basic_name') at parser.lkt:421:17>



Row_Progress1 := 1;

if Defer_Pos46 /= No_Token_Index then

   Row_Pos25 := Defer_Pos46;

else
   Row_Pos25 := No_Token_Index;
   goto Exit_Row25_0;

end if;


--  BEGIN <Null (root of 'basic_name') at parser.lkt:421:28>

   
   Null_Res0 := Allocate_Null_Cond_Qualifier_Absent (Parser.Mem_Pool);
   Initialize
     (Self              => Null_Res0,
      Kind              => Lkt_Null_Cond_Qualifier_Absent,
      Unit              => Parser.Unit,
      Token_Start_Index => Row_Pos25,
      Token_End_Index   => No_Token_Index);


--  END <Null (root of 'basic_name') at parser.lkt:421:28>



Row_Progress1 := 2;

if Row_Pos25 /= No_Token_Index then

   Row_Pos25 := Row_Pos25;

else
   Row_Pos25 := No_Token_Index;
   goto Exit_Row25_0;

end if;


--  BEGIN <Token(<WithText Dot>, ) (root of 'basic_name') at parser.lkt:421:52>

Token_Res37 := Row_Pos25;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res37));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_Dot)
   then
       Token_Pos37 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos25 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos25,
             Expected_Token_Id => Lkt_Dot,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos37 := Row_Pos25 + 1;
   end if;
end;

--  END <Token(<WithText Dot>, ) (root of 'basic_name') at parser.lkt:421:52>



Row_Progress1 := 3;

if Token_Pos37 /= No_Token_Index then

   Row_Pos25 := Token_Pos37;

else
   Row_Pos25 := No_Token_Index;
   goto Exit_Row25_0;

end if;


--  BEGIN <Cut (root of 'basic_name') at parser.lkt:421:56>
Nobt1 := True;
--  END <Cut (root of 'basic_name') at parser.lkt:421:56>


   Nobt1 := Nobt1;

Row_Progress1 := 4;

if Row_Pos25 /= No_Token_Index then

   Row_Pos25 := Row_Pos25;

else
   Row_Pos25 := No_Token_Index;
   goto Exit_Row25_0;

end if;


--  BEGIN <Defer (for 'ref_id') at parser.lkt:421:58>

Defer_Res47 :=
   Ref_Id_Transform_Parse0 (Parser, Row_Pos25);
Defer_Pos47 := Parser.Current_Pos;

--  END <Defer (for 'ref_id') at parser.lkt:421:58>



Row_Progress1 := 5;

if Defer_Pos47 /= No_Token_Index then

   Row_Pos25 := Defer_Pos47;

else
   Row_Pos25 := No_Token_Index;
   goto Exit_Row25_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row25_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'basic_name') at parser.lkt:421:9>


if Row_Pos25 = No_Token_Index and then Nobt1 then

   Row_Pos25 := Parser.Last_Fail.Pos;

   Transform_Has_Failed1 := True;
end if;

if Row_Pos25 /= No_Token_Index then

   Transform_Res23 := Allocate_Dot_Expr (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res23,
      Kind => Lkt_Dot_Expr,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos25 = Pos
                            then No_Token_Index
                            else Row_Pos25 - 1));

      
      Initialize_Fields_For_Dot_Expr
        (Self => Transform_Res23,
         Dot_Expr_F_Prefix => Defer_Res46,
         Dot_Expr_F_Null_Cond => Null_Res0,
         Dot_Expr_F_Suffix => Defer_Res47);

         if Defer_Res46 /= null and then Is_Incomplete (Defer_Res46) then
            Transform_Res23.Last_Attempted_Child := 0;
         elsif Defer_Res46 /= null and then not Is_Ghost (Defer_Res46) then
            Transform_Res23.Last_Attempted_Child := -1;
         end if;
         if Null_Res0 /= null and then Is_Incomplete (Null_Res0) then
            Transform_Res23.Last_Attempted_Child := 0;
         elsif Null_Res0 /= null and then not Is_Ghost (Null_Res0) then
            Transform_Res23.Last_Attempted_Child := -1;
         end if;
         if Defer_Res47 /= null and then Is_Incomplete (Defer_Res47) then
            Transform_Res23.Last_Attempted_Child := 0;
         elsif Defer_Res47 /= null and then not Is_Ghost (Defer_Res47) then
            Transform_Res23.Last_Attempted_Child := -1;
         end if;

   if Transform_Has_Failed1 then
      Transform_Res23.Last_Attempted_Child :=
         Row_Progress1;

      Append (Parser.Diagnostics,
              Sloc_Range (Parser.TDH.all,
                          Get_Token (Parser.TDH.all, Pos)),
              To_Text ("Cannot parse <basic_name>"));

      Add_Last_Fail_Diagnostic (Parser);
   end if;

elsif Row_Pos25 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags23);
end if;

--  END <Transform(<ASTNodeType DotExpr>) (root of 'basic_name') at parser.lkt:421:9>

    if Row_Pos25 /= No_Token_Index then
        Or_Pos8 := Row_Pos25;
        Or_Res8 := Transform_Res23;
        goto Exit_Or8;
    end if;
    
--  BEGIN <Defer (for 'ref_id') at parser.lkt:421:68>

Defer_Res48 :=
   Ref_Id_Transform_Parse0 (Parser, Pos);
Defer_Pos48 := Parser.Current_Pos;

--  END <Defer (for 'ref_id') at parser.lkt:421:68>

    if Defer_Pos48 /= No_Token_Index then
        Or_Pos8 := Defer_Pos48;
        Or_Res8 := Defer_Res48;
        goto Exit_Or8;
    end if;
<<Exit_Or8>>

--  END <Or (root of 'basic_name') at parser.lkt:420:19>


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------

      if Or_Pos8 > Mem_Pos then
         Mem_Pos := Or_Pos8;
         Mem_Res := Or_Res8;
         Set
           (PP.Basic_Name_Or_Parse0_Memo,
            Or_Pos8 /= No_Token_Index,
            Or_Res8,
            Pos,
            Or_Pos8);
         goto Try_Again;

      elsif Mem_Pos > Pos then
         Or_Res8 := Mem_Res;
         Or_Pos8 := Mem_Pos;
         goto No_Memo;
      end if;

   Set
     (PP.Basic_Name_Or_Parse0_Memo,
      Or_Pos8 /= No_Token_Index,
      Or_Res8,
      Pos,
      Or_Pos8);

       <<No_Memo>>

   Parser.Current_Pos := Or_Pos8;

   return Or_Res8;
end Basic_Name_Or_Parse0;

   


function Big_Num_Lit_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Big_Num_Lit
is
   use Bare_Big_Num_Lit_Memos;

      Row_Pos26 :
            Token_Index
               := No_Token_Index;
      Token_Pos38 :
            Token_Index
               := No_Token_Index;
      Token_Res38 :
            Token_Index
               := No_Token_Index;
      Transform_Res24 :
            Bare_Big_Num_Lit
               := No_Bare_Lkt_Node;
      Transform_Diags24 :
            Ada.Containers.Count_Type;


   PP : constant Parser_Private_Part := +Parser.Private_Part;
   M  : Memo_Entry := Get (PP.Big_Num_Lit_Transform_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res24 := M.Instance;
      return Transform_Res24;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res24;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  BEGIN <Transform(<ASTNodeType BigNumLit>) (root of 'big_num_lit') at parser.lkt:358:20>

Transform_Diags24 := Parser.Diagnostics.Length;


--  BEGIN <_Row (root of 'big_num_lit') at parser.lkt:358:20>

Row_Pos26 := Pos;



--  BEGIN <Token(<WithText BigNumber>, ) (root of 'big_num_lit') at parser.lkt:358:30>

Token_Res38 := Row_Pos26;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res38));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_Big_Number)
   then
       Token_Pos38 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos26 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos26,
             Expected_Token_Id => Lkt_Big_Number,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos38 := Row_Pos26 + 1;
   end if;
end;

--  END <Token(<WithText BigNumber>, ) (root of 'big_num_lit') at parser.lkt:358:30>




if Token_Pos38 /= No_Token_Index then

   Row_Pos26 := Token_Pos38;

else
   Row_Pos26 := No_Token_Index;
   goto Exit_Row26_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row26_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'big_num_lit') at parser.lkt:358:20>



if Row_Pos26 /= No_Token_Index then

   Transform_Res24 := Allocate_Big_Num_Lit (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res24,
      Kind => Lkt_Big_Num_Lit,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos26 = Pos
                            then No_Token_Index
                            else Row_Pos26 - 1));

      
      Initialize_Fields_For_Big_Num_Lit
        (Self => Transform_Res24);



elsif Row_Pos26 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags24);
end if;

--  END <Transform(<ASTNodeType BigNumLit>) (root of 'big_num_lit') at parser.lkt:358:20>


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (PP.Big_Num_Lit_Transform_Parse0_Memo,
      Row_Pos26 /= No_Token_Index,
      Transform_Res24,
      Pos,
      Row_Pos26);


   Parser.Current_Pos := Row_Pos26;

   return Transform_Res24;
end Big_Num_Lit_Transform_Parse0;

   


function Block_Transform_Parse2
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Block_Expr
is
   use Bare_Block_Expr_Memos;

      Nobt2 :
            Boolean
               := False;
      Row_Pos27 :
            Token_Index
               := No_Token_Index;
      Token_Pos39 :
            Token_Index
               := No_Token_Index;
      Token_Res39 :
            Token_Index
               := No_Token_Index;
      Lst_Cpos2 :
            Token_Index
               := No_Token_Index;
      Tmp_List2 :
            Free_Parse_List;
      Row_Pos28 :
            Token_Index
               := No_Token_Index;
      Defer_Pos49 :
            Token_Index
               := No_Token_Index;
      Defer_Res49 :
            Bare_Val_Decl
               := No_Bare_Lkt_Node;
      Defer_Pos50 :
            Token_Index
               := No_Token_Index;
      Defer_Res50 :
            Bare_Var_Bind
               := No_Bare_Lkt_Node;
      Or_Pos9 :
            Token_Index
               := No_Token_Index;
      Or_Res9 :
            Bare_Lkt_Node
               := No_Bare_Lkt_Node;
      Token_Pos40 :
            Token_Index
               := No_Token_Index;
      Token_Res40 :
            Token_Index
               := No_Token_Index;
      Transform_Res25 :
            Bare_Block_Expr_Clause
               := No_Bare_Lkt_Node;
      Transform_Diags25 :
            Ada.Containers.Count_Type;
      Defer_Pos51 :
            Token_Index
               := No_Token_Index;
      Defer_Res51 :
            Bare_Expr
               := No_Bare_Lkt_Node;
      Row_Pos29 :
            Token_Index
               := No_Token_Index;
      Transform_Res26 :
            Bare_Error_Decl
               := No_Bare_Lkt_Node;
      Transform_Diags26 :
            Ada.Containers.Count_Type;
      Skip_Pos0 :
            Token_Index
               := No_Token_Index;
      Skip_Dummy0 :
            Bare_Lkt_Node
               := No_Bare_Lkt_Node;
      Or_Pos10 :
            Token_Index
               := No_Token_Index;
      Or_Res10 :
            Bare_Lkt_Node
               := No_Bare_Lkt_Node;
      List_Pos2 :
            Token_Index
               := No_Token_Index;
      List_Res2 :
            Bare_Lkt_Node_List
               := No_Bare_Lkt_Node;
      Token_Pos41 :
            Token_Index
               := No_Token_Index;
      Token_Res41 :
            Token_Index
               := No_Token_Index;
      Row_Progress2 :
            Integer
               := 0;
      Transform_Res27 :
            Bare_Block_Expr
               := No_Bare_Lkt_Node;
      Transform_Has_Failed2 :
            Boolean
               := False;
      Transform_Diags27 :
            Ada.Containers.Count_Type;


   PP : constant Parser_Private_Part := +Parser.Private_Part;
   M  : Memo_Entry := Get (PP.Block_Transform_Parse2_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res27 := M.Instance;
      return Transform_Res27;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res27;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  BEGIN <Transform(<ASTNodeType BlockExpr>) (root of 'block') at parser.lkt:233:14>

Transform_Diags27 := Parser.Diagnostics.Length;


--  BEGIN <_Row (root of 'block') at parser.lkt:233:14>

Row_Pos27 := Pos;



--  BEGIN <Token(<WithText LBrace>, ) (root of 'block') at parser.lkt:234:9>

Token_Res39 := Row_Pos27;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res39));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_L_Brace)
   then
       Token_Pos39 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos27 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos27,
             Expected_Token_Id => Lkt_L_Brace,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos39 := Row_Pos27 + 1;
   end if;
end;

--  END <Token(<WithText LBrace>, ) (root of 'block') at parser.lkt:234:9>



Row_Progress2 := 1;

if Token_Pos39 /= No_Token_Index then

   Row_Pos27 := Token_Pos39;

else
   Row_Pos27 := No_Token_Index;
   goto Exit_Row27_0;

end if;


--  BEGIN <Cut (root of 'block') at parser.lkt:235:9>
Nobt2 := True;
--  END <Cut (root of 'block') at parser.lkt:235:9>


   Nobt2 := Nobt2;

Row_Progress2 := 2;

if Row_Pos27 /= No_Token_Index then

   Row_Pos27 := Row_Pos27;

else
   Row_Pos27 := No_Token_Index;
   goto Exit_Row27_0;

end if;


        
--  BEGIN <DontSkip (root of 'block') at parser.lkt:236:9>

        PP.Dont_Skip.Append (Dontskip_Block0_Extract_Parse0'Access);
        
--  BEGIN <List (root of 'block') at parser.lkt:236:9>

    List_Pos2 := No_Token_Index;



Lst_Cpos2 := Row_Pos27;
Tmp_List2 := Get_Parse_List (Parser);


loop
   
--  BEGIN <Or (root of 'block') at parser.lkt:237:13>

Or_Pos10 := No_Token_Index;
Or_Res10 := No_Bare_Lkt_Node;
    
--  BEGIN <Transform(<ASTNodeType BlockExprClause>) (root of 'block') at parser.lkt:238:19>

Transform_Diags25 := Parser.Diagnostics.Length;


--  BEGIN <_Row (root of 'block') at parser.lkt:238:19>

Row_Pos28 := Lst_Cpos2;



--  BEGIN <Or (root of 'block') at parser.lkt:238:35>

Or_Pos9 := No_Token_Index;
Or_Res9 := No_Bare_Lkt_Node;
    
--  BEGIN <Defer (for 'val_decl') at parser.lkt:238:38>

Defer_Res49 :=
   Val_Decl_Transform_Parse0 (Parser, Row_Pos28);
Defer_Pos49 := Parser.Current_Pos;

--  END <Defer (for 'val_decl') at parser.lkt:238:38>

    if Defer_Pos49 /= No_Token_Index then
        Or_Pos9 := Defer_Pos49;
        Or_Res9 := Defer_Res49;
        goto Exit_Or10;
    end if;
    
--  BEGIN <Defer (for 'var_bind') at parser.lkt:238:49>

Defer_Res50 :=
   Var_Bind_Transform_Parse0 (Parser, Row_Pos28);
Defer_Pos50 := Parser.Current_Pos;

--  END <Defer (for 'var_bind') at parser.lkt:238:49>

    if Defer_Pos50 /= No_Token_Index then
        Or_Pos9 := Defer_Pos50;
        Or_Res9 := Defer_Res50;
        goto Exit_Or10;
    end if;
<<Exit_Or10>>

--  END <Or (root of 'block') at parser.lkt:238:35>




if Or_Pos9 /= No_Token_Index then

   Row_Pos28 := Or_Pos9;

else
   Row_Pos28 := No_Token_Index;
   goto Exit_Row28_0;

end if;


--  BEGIN <Token(<WithText Semicolon>, ) (root of 'block') at parser.lkt:238:59>

Token_Res40 := Row_Pos28;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res40));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_Semicolon)
   then
       Token_Pos40 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos28 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos28,
             Expected_Token_Id => Lkt_Semicolon,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos40 := Row_Pos28 + 1;
   end if;
end;

--  END <Token(<WithText Semicolon>, ) (root of 'block') at parser.lkt:238:59>




if Token_Pos40 /= No_Token_Index then

   Row_Pos28 := Token_Pos40;

else
   Row_Pos28 := No_Token_Index;
   goto Exit_Row28_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row28_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'block') at parser.lkt:238:19>



if Row_Pos28 /= No_Token_Index then

   Transform_Res25 := Allocate_Block_Expr_Clause (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res25,
      Kind => Lkt_Block_Expr_Clause,
      Unit => Parser.Unit,

      Token_Start_Index => Lst_Cpos2,
      Token_End_Index   => (if Row_Pos28 = Lst_Cpos2
                            then No_Token_Index
                            else Row_Pos28 - 1));

      
      Initialize_Fields_For_Block_Expr_Clause
        (Self => Transform_Res25,
         Block_Expr_Clause_F_Clause => Or_Res9);

         if Or_Res9 /= null and then Is_Incomplete (Or_Res9) then
            Transform_Res25.Last_Attempted_Child := 0;
         elsif Or_Res9 /= null and then not Is_Ghost (Or_Res9) then
            Transform_Res25.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos28 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags25);
end if;

--  END <Transform(<ASTNodeType BlockExprClause>) (root of 'block') at parser.lkt:238:19>

    if Row_Pos28 /= No_Token_Index then
        Or_Pos10 := Row_Pos28;
        Or_Res10 := Transform_Res25;
        goto Exit_Or9;
    end if;
    
--  BEGIN <Defer (for 'expr') at parser.lkt:239:19>

Defer_Res51 :=
   Expr_Or_Parse1 (Parser, Lst_Cpos2);
Defer_Pos51 := Parser.Current_Pos;

--  END <Defer (for 'expr') at parser.lkt:239:19>

    if Defer_Pos51 /= No_Token_Index then
        Or_Pos10 := Defer_Pos51;
        Or_Res10 := Defer_Res51;
        goto Exit_Or9;
    end if;
    
--  BEGIN <Skip (root of 'block') at parser.lkt:240:19>

if Get_Token (Parser.TDH.all, Lst_Cpos2).Kind
   = From_Token_Kind (Lkt_Termination)
then
   Skip_Pos0 := No_Token_Index;
   goto Exit_Or11;
end if;

for Fn of PP.Dont_Skip loop
   Skip_Dummy0 := Fn (Parser, Lst_Cpos2);

   if Parser.Current_Pos /= No_Token_Index  then
      Skip_Pos0 := No_Token_Index;
      goto Exit_Or11;
   end if;
end loop;

Skip_Pos0 := Lst_Cpos2 + 1;

--  BEGIN <Transform(<ASTNodeType ErrorDecl>) (root of 'block') at parser.lkt:240:19>

Transform_Diags26 := Parser.Diagnostics.Length;


--  BEGIN <_Row (root of 'block') at parser.lkt:240:19>

Row_Pos29 := Lst_Cpos2;


pragma Warnings (Off, "referenced");
<<Exit_Row29_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'block') at parser.lkt:240:19>



if Row_Pos29 /= No_Token_Index then

   Transform_Res26 := Allocate_Error_Decl (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res26,
      Kind => Lkt_Error_Decl,
      Unit => Parser.Unit,

      Token_Start_Index => Lst_Cpos2,
      Token_End_Index   => (if Row_Pos29 = Lst_Cpos2
                            then No_Token_Index
                            else Row_Pos29 - 1));




elsif Row_Pos29 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags26);
end if;

--  END <Transform(<ASTNodeType ErrorDecl>) (root of 'block') at parser.lkt:240:19>

Transform_Res26.Token_End_Index := Lst_Cpos2;

Append (Parser.Diagnostics,
        Sloc_Range (Parser.TDH.all,
                    Get_Token (Parser.TDH.all, Lst_Cpos2)),
        To_Text ("Skipped token ")
        & Common.Text
            (Wrap_Token_Reference
               (Parser.Unit.Context,
                Parser.TDH,
                (Lst_Cpos2, No_Token_Index))));

<<Exit_Or11>>

--  END <Skip (root of 'block') at parser.lkt:240:19>

    if Skip_Pos0 /= No_Token_Index then
        Or_Pos10 := Skip_Pos0;
        Or_Res10 := Transform_Res26;
        goto Exit_Or9;
    end if;
<<Exit_Or9>>

--  END <Or (root of 'block') at parser.lkt:237:13>


   exit when Or_Pos10 = No_Token_Index;

   List_Pos2 := Or_Pos10;
   Lst_Cpos2 := List_Pos2;

   Tmp_List2.Nodes.Append (Or_Res10);

end loop;


declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List2.Nodes.Length;
begin
   List_Res2 := Allocate_Lkt_Node_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Row_Pos27;
      Token_End := (if Lst_Cpos2 = Row_Pos27
                    then Row_Pos27
                    else List_Pos2 - 1);

   else
      Token_Start := Token_Index'Max (Row_Pos27, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res2,
      Kind              => Lkt_Lkt_Node_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res2,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_Lkt_Node_Vectors.Vector renames
         Tmp_List2.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res2.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List2);

--  END <List (root of 'block') at parser.lkt:236:9>

        PP.Dont_Skip.Delete_Last;
        
--  END <DontSkip (root of 'block') at parser.lkt:236:9>

        


Row_Progress2 := 3;

if List_Pos2 /= No_Token_Index then

   Row_Pos27 := List_Pos2;

else
   Row_Pos27 := No_Token_Index;
   goto Exit_Row27_0;

end if;


--  BEGIN <Token(<WithText RBrace>, ) (root of 'block') at parser.lkt:243:9>

Token_Res41 := Row_Pos27;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res41));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_R_Brace)
   then
       Token_Pos41 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos27 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos27,
             Expected_Token_Id => Lkt_R_Brace,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos41 := Row_Pos27 + 1;
   end if;
end;

--  END <Token(<WithText RBrace>, ) (root of 'block') at parser.lkt:243:9>



Row_Progress2 := 4;

if Token_Pos41 /= No_Token_Index then

   Row_Pos27 := Token_Pos41;

else
   Row_Pos27 := No_Token_Index;
   goto Exit_Row27_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row27_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'block') at parser.lkt:233:14>


if Row_Pos27 = No_Token_Index and then Nobt2 then

   Row_Pos27 := Parser.Last_Fail.Pos;

   Transform_Has_Failed2 := True;
end if;

if Row_Pos27 /= No_Token_Index then

   Transform_Res27 := Allocate_Block_Expr (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res27,
      Kind => Lkt_Block_Expr,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos27 = Pos
                            then No_Token_Index
                            else Row_Pos27 - 1));

      
      Initialize_Fields_For_Block_Expr
        (Self => Transform_Res27,
         Block_Expr_F_Clauses => List_Res2);

         if List_Res2 /= null and then Is_Incomplete (List_Res2) then
            Transform_Res27.Last_Attempted_Child := 0;
         elsif List_Res2 /= null and then not Is_Ghost (List_Res2) then
            Transform_Res27.Last_Attempted_Child := -1;
         end if;

   if Transform_Has_Failed2 then
      Transform_Res27.Last_Attempted_Child :=
         Row_Progress2;

      Append (Parser.Diagnostics,
              Sloc_Range (Parser.TDH.all,
                          Get_Token (Parser.TDH.all, Pos)),
              To_Text ("Cannot parse <block>"));

      Add_Last_Fail_Diagnostic (Parser);
   end if;

elsif Row_Pos27 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags27);
end if;

--  END <Transform(<ASTNodeType BlockExpr>) (root of 'block') at parser.lkt:233:14>


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (PP.Block_Transform_Parse2_Memo,
      Row_Pos27 /= No_Token_Index,
      Transform_Res27,
      Pos,
      Row_Pos27);


   Parser.Current_Pos := Row_Pos27;

   return Transform_Res27;
end Block_Transform_Parse2;

   


function Block_String_Lit_Transform_Parse1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Block_String_Lit
is
   use Bare_Block_String_Lit_Memos;

      Row_Pos30 :
            Token_Index
               := No_Token_Index;
      Lst_Cpos3 :
            Token_Index
               := No_Token_Index;
      Tmp_List3 :
            Free_Parse_List;
      Row_Pos31 :
            Token_Index
               := No_Token_Index;
      Token_Pos42 :
            Token_Index
               := No_Token_Index;
      Token_Res42 :
            Token_Index
               := No_Token_Index;
      Transform_Res28 :
            Bare_Block_String_Line
               := No_Bare_Lkt_Node;
      Transform_Diags28 :
            Ada.Containers.Count_Type;
      List_Pos3 :
            Token_Index
               := No_Token_Index;
      List_Res3 :
            Bare_Block_String_Line_List
               := No_Bare_Lkt_Node;
      Transform_Res29 :
            Bare_Block_String_Lit
               := No_Bare_Lkt_Node;
      Transform_Diags29 :
            Ada.Containers.Count_Type;


   PP : constant Parser_Private_Part := +Parser.Private_Part;
   M  : Memo_Entry := Get (PP.Block_String_Lit_Transform_Parse1_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res29 := M.Instance;
      return Transform_Res29;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res29;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  BEGIN <Transform(<ASTNodeType BlockStringLit>) (root of 'block_string_lit') at parser.lkt:364:25>

Transform_Diags29 := Parser.Diagnostics.Length;


--  BEGIN <_Row (root of 'block_string_lit') at parser.lkt:364:25>

Row_Pos30 := Pos;



--  BEGIN <List (root of 'block_string_lit') at parser.lkt:365:9>

    List_Pos3 := No_Token_Index;



Lst_Cpos3 := Row_Pos30;
Tmp_List3 := Get_Parse_List (Parser);


loop
   
--  BEGIN <Transform(<ASTNodeType BlockStringLine>) (root of 'block_string_lit') at parser.lkt:365:15>

Transform_Diags28 := Parser.Diagnostics.Length;


--  BEGIN <_Row (root of 'block_string_lit') at parser.lkt:365:15>

Row_Pos31 := Lst_Cpos3;



--  BEGIN <Token(<WithText BlockStringLine>, ) (root of 'block_string_lit') at parser.lkt:365:31>

Token_Res42 := Row_Pos31;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res42));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_Block_String_Line)
   then
       Token_Pos42 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos31 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos31,
             Expected_Token_Id => Lkt_Block_String_Line,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos42 := Row_Pos31 + 1;
   end if;
end;

--  END <Token(<WithText BlockStringLine>, ) (root of 'block_string_lit') at parser.lkt:365:31>




if Token_Pos42 /= No_Token_Index then

   Row_Pos31 := Token_Pos42;

else
   Row_Pos31 := No_Token_Index;
   goto Exit_Row31_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row31_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'block_string_lit') at parser.lkt:365:15>



if Row_Pos31 /= No_Token_Index then

   Transform_Res28 := Allocate_Block_String_Line (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res28,
      Kind => Lkt_Block_String_Line,
      Unit => Parser.Unit,

      Token_Start_Index => Lst_Cpos3,
      Token_End_Index   => (if Row_Pos31 = Lst_Cpos3
                            then No_Token_Index
                            else Row_Pos31 - 1));




elsif Row_Pos31 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags28);
end if;

--  END <Transform(<ASTNodeType BlockStringLine>) (root of 'block_string_lit') at parser.lkt:365:15>


   exit when Row_Pos31 = No_Token_Index;

   List_Pos3 := Row_Pos31;
   Lst_Cpos3 := List_Pos3;

   Tmp_List3.Nodes.Append (Transform_Res28);

end loop;


declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List3.Nodes.Length;
begin
   List_Res3 := Allocate_Block_String_Line_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Row_Pos30;
      Token_End := (if Lst_Cpos3 = Row_Pos30
                    then Row_Pos30
                    else List_Pos3 - 1);

   else
      Token_Start := Token_Index'Max (Row_Pos30, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res3,
      Kind              => Lkt_Block_String_Line_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res3,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_Lkt_Node_Vectors.Vector renames
         Tmp_List3.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res3.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List3);

--  END <List (root of 'block_string_lit') at parser.lkt:365:9>




if List_Pos3 /= No_Token_Index then

   Row_Pos30 := List_Pos3;

else
   Row_Pos30 := No_Token_Index;
   goto Exit_Row30_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row30_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'block_string_lit') at parser.lkt:364:25>



if Row_Pos30 /= No_Token_Index then

   Transform_Res29 := Allocate_Block_String_Lit (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res29,
      Kind => Lkt_Block_String_Lit,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos30 = Pos
                            then No_Token_Index
                            else Row_Pos30 - 1));

      
      Initialize_Fields_For_Block_String_Lit
        (Self => Transform_Res29,
         Block_String_Lit_F_Lines => List_Res3);

         if List_Res3 /= null and then Is_Incomplete (List_Res3) then
            Transform_Res29.Last_Attempted_Child := 0;
         elsif List_Res3 /= null and then not Is_Ghost (List_Res3) then
            Transform_Res29.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos30 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags29);
end if;

--  END <Transform(<ASTNodeType BlockStringLit>) (root of 'block_string_lit') at parser.lkt:364:25>


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (PP.Block_String_Lit_Transform_Parse1_Memo,
      Row_Pos30 /= No_Token_Index,
      Transform_Res29,
      Pos,
      Row_Pos30);


   Parser.Current_Pos := Row_Pos30;

   return Transform_Res29;
end Block_String_Lit_Transform_Parse1;

   


function Bool_Pattern_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Bool_Pattern
is
   use Bare_Bool_Pattern_Memos;

      Row_Pos32 :
            Token_Index
               := No_Token_Index;
      Token_Pos43 :
            Token_Index
               := No_Token_Index;
      Token_Res43 :
            Token_Index
               := No_Token_Index;
      Transform_Res30 :
            Bare_Bool_Pattern_True
               := No_Bare_Lkt_Node;
      Transform_Diags30 :
            Ada.Containers.Count_Type;
      Row_Pos33 :
            Token_Index
               := No_Token_Index;
      Token_Pos44 :
            Token_Index
               := No_Token_Index;
      Token_Res44 :
            Token_Index
               := No_Token_Index;
      Transform_Res31 :
            Bare_Bool_Pattern_False
               := No_Bare_Lkt_Node;
      Transform_Diags31 :
            Ada.Containers.Count_Type;
      Or_Pos11 :
            Token_Index
               := No_Token_Index;
      Or_Res11 :
            Bare_Bool_Pattern
               := No_Bare_Lkt_Node;


   PP : constant Parser_Private_Part := +Parser.Private_Part;
   M  : Memo_Entry := Get (PP.Bool_Pattern_Or_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Or_Res11 := M.Instance;
      return Or_Res11;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Or_Res11;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  BEGIN <Or (root of 'bool_pattern') at parser.lkt:274:21>

Or_Pos11 := No_Token_Index;
Or_Res11 := No_Bare_Lkt_Node;
    
--  BEGIN <Transform(<ASTNodeType BoolPattern.True>) (root of 'bool_pattern') at parser.lkt:275:11>

Transform_Diags30 := Parser.Diagnostics.Length;


--  BEGIN <_Row (root of 'bool_pattern') at parser.lkt:275:11>

Row_Pos32 := Pos;



--  BEGIN <Token(<WithSymbol Identifier>, true) (root of 'bool_pattern') at parser.lkt:275:28>

Token_Res43 := Row_Pos32;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res43));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_Identifier)
      or else T.Symbol /= Precomputed_Symbol
        (Precomputed_Symbol_Table (Parser.TDH.Symbols),
         Precomputed_Sym_True)
   then
       Token_Pos43 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos32 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos32,
             Expected_Token_Id => Lkt_Identifier,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos43 := Row_Pos32 + 1;
   end if;
end;

--  END <Token(<WithSymbol Identifier>, true) (root of 'bool_pattern') at parser.lkt:275:28>




if Token_Pos43 /= No_Token_Index then

   Row_Pos32 := Token_Pos43;

else
   Row_Pos32 := No_Token_Index;
   goto Exit_Row32_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row32_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'bool_pattern') at parser.lkt:275:11>



if Row_Pos32 /= No_Token_Index then

   Transform_Res30 := Allocate_Bool_Pattern_True (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res30,
      Kind => Lkt_Bool_Pattern_True,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos32 = Pos
                            then No_Token_Index
                            else Row_Pos32 - 1));




elsif Row_Pos32 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags30);
end if;

--  END <Transform(<ASTNodeType BoolPattern.True>) (root of 'bool_pattern') at parser.lkt:275:11>

    if Row_Pos32 /= No_Token_Index then
        Or_Pos11 := Row_Pos32;
        Or_Res11 := Transform_Res30;
        goto Exit_Or12;
    end if;
    
--  BEGIN <Transform(<ASTNodeType BoolPattern.False>) (root of 'bool_pattern') at parser.lkt:276:11>

Transform_Diags31 := Parser.Diagnostics.Length;


--  BEGIN <_Row (root of 'bool_pattern') at parser.lkt:276:11>

Row_Pos33 := Pos;



--  BEGIN <Token(<WithSymbol Identifier>, false) (root of 'bool_pattern') at parser.lkt:276:29>

Token_Res44 := Row_Pos33;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res44));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_Identifier)
      or else T.Symbol /= Precomputed_Symbol
        (Precomputed_Symbol_Table (Parser.TDH.Symbols),
         Precomputed_Sym_False)
   then
       Token_Pos44 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos33 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos33,
             Expected_Token_Id => Lkt_Identifier,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos44 := Row_Pos33 + 1;
   end if;
end;

--  END <Token(<WithSymbol Identifier>, false) (root of 'bool_pattern') at parser.lkt:276:29>




if Token_Pos44 /= No_Token_Index then

   Row_Pos33 := Token_Pos44;

else
   Row_Pos33 := No_Token_Index;
   goto Exit_Row33_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row33_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'bool_pattern') at parser.lkt:276:11>



if Row_Pos33 /= No_Token_Index then

   Transform_Res31 := Allocate_Bool_Pattern_False (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res31,
      Kind => Lkt_Bool_Pattern_False,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos33 = Pos
                            then No_Token_Index
                            else Row_Pos33 - 1));




elsif Row_Pos33 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags31);
end if;

--  END <Transform(<ASTNodeType BoolPattern.False>) (root of 'bool_pattern') at parser.lkt:276:11>

    if Row_Pos33 /= No_Token_Index then
        Or_Pos11 := Row_Pos33;
        Or_Res11 := Transform_Res31;
        goto Exit_Or12;
    end if;
<<Exit_Or12>>

--  END <Or (root of 'bool_pattern') at parser.lkt:274:21>


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (PP.Bool_Pattern_Or_Parse0_Memo,
      Or_Pos11 /= No_Token_Index,
      Or_Res11,
      Pos,
      Or_Pos11);


   Parser.Current_Pos := Or_Pos11;

   return Or_Res11;
end Bool_Pattern_Or_Parse0;

   


function Callable_Ref_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr
is
   use Bare_Expr_Memos;

      Row_Pos34 :
            Token_Index
               := No_Token_Index;
      Defer_Pos52 :
            Token_Index
               := No_Token_Index;
      Defer_Res52 :
            Bare_Expr
               := No_Bare_Lkt_Node;
      Null_Res1 :
            Bare_Null_Cond_Qualifier
               := No_Bare_Lkt_Node;
      Token_Pos45 :
            Token_Index
               := No_Token_Index;
      Token_Res45 :
            Token_Index
               := No_Token_Index;
      Defer_Pos53 :
            Token_Index
               := No_Token_Index;
      Defer_Res53 :
            Bare_Ref_Id
               := No_Bare_Lkt_Node;
      Transform_Res32 :
            Bare_Dot_Expr
               := No_Bare_Lkt_Node;
      Transform_Diags32 :
            Ada.Containers.Count_Type;
      Defer_Pos54 :
            Token_Index
               := No_Token_Index;
      Defer_Res54 :
            Bare_Ref_Id
               := No_Bare_Lkt_Node;
      Or_Pos12 :
            Token_Index
               := No_Token_Index;
      Or_Res12 :
            Bare_Expr
               := No_Bare_Lkt_Node;

      Mem_Pos : Token_Index := Pos;
      Mem_Res : Bare_Expr := No_Bare_Lkt_Node;

   PP : constant Parser_Private_Part := +Parser.Private_Part;
   M  : Memo_Entry := Get (PP.Callable_Ref_Or_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Or_Res12 := M.Instance;
      return Or_Res12;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Or_Res12;
   end if;

       Set (PP.Callable_Ref_Or_Parse0_Memo, False, Or_Res12, Pos, Mem_Pos);

       <<Try_Again>>



   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  BEGIN <Or (root of 'callable_ref') at parser.lkt:380:21>

Or_Pos12 := No_Token_Index;
Or_Res12 := No_Bare_Lkt_Node;
    
--  BEGIN <Transform(<ASTNodeType DotExpr>) (root of 'callable_ref') at parser.lkt:381:9>

Transform_Diags32 := Parser.Diagnostics.Length;


--  BEGIN <_Row (root of 'callable_ref') at parser.lkt:381:9>

Row_Pos34 := Pos;



--  BEGIN <Defer (for 'callable_ref') at parser.lkt:381:17>

Defer_Res52 :=
   Callable_Ref_Or_Parse0 (Parser, Row_Pos34);
Defer_Pos52 := Parser.Current_Pos;

--  END <Defer (for 'callable_ref') at parser.lkt:381:17>




if Defer_Pos52 /= No_Token_Index then

   Row_Pos34 := Defer_Pos52;

else
   Row_Pos34 := No_Token_Index;
   goto Exit_Row34_0;

end if;


--  BEGIN <Null (root of 'callable_ref') at parser.lkt:381:30>

   
   Null_Res1 := Allocate_Null_Cond_Qualifier_Absent (Parser.Mem_Pool);
   Initialize
     (Self              => Null_Res1,
      Kind              => Lkt_Null_Cond_Qualifier_Absent,
      Unit              => Parser.Unit,
      Token_Start_Index => Row_Pos34,
      Token_End_Index   => No_Token_Index);


--  END <Null (root of 'callable_ref') at parser.lkt:381:30>




if Row_Pos34 /= No_Token_Index then

   Row_Pos34 := Row_Pos34;

else
   Row_Pos34 := No_Token_Index;
   goto Exit_Row34_0;

end if;


--  BEGIN <Token(<WithText Dot>, ) (root of 'callable_ref') at parser.lkt:381:54>

Token_Res45 := Row_Pos34;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res45));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_Dot)
   then
       Token_Pos45 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos34 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos34,
             Expected_Token_Id => Lkt_Dot,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos45 := Row_Pos34 + 1;
   end if;
end;

--  END <Token(<WithText Dot>, ) (root of 'callable_ref') at parser.lkt:381:54>




if Token_Pos45 /= No_Token_Index then

   Row_Pos34 := Token_Pos45;

else
   Row_Pos34 := No_Token_Index;
   goto Exit_Row34_0;

end if;


--  BEGIN <Defer (for 'ref_id') at parser.lkt:381:58>

Defer_Res53 :=
   Ref_Id_Transform_Parse0 (Parser, Row_Pos34);
Defer_Pos53 := Parser.Current_Pos;

--  END <Defer (for 'ref_id') at parser.lkt:381:58>




if Defer_Pos53 /= No_Token_Index then

   Row_Pos34 := Defer_Pos53;

else
   Row_Pos34 := No_Token_Index;
   goto Exit_Row34_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row34_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'callable_ref') at parser.lkt:381:9>



if Row_Pos34 /= No_Token_Index then

   Transform_Res32 := Allocate_Dot_Expr (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res32,
      Kind => Lkt_Dot_Expr,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos34 = Pos
                            then No_Token_Index
                            else Row_Pos34 - 1));

      
      Initialize_Fields_For_Dot_Expr
        (Self => Transform_Res32,
         Dot_Expr_F_Prefix => Defer_Res52,
         Dot_Expr_F_Null_Cond => Null_Res1,
         Dot_Expr_F_Suffix => Defer_Res53);

         if Defer_Res52 /= null and then Is_Incomplete (Defer_Res52) then
            Transform_Res32.Last_Attempted_Child := 0;
         elsif Defer_Res52 /= null and then not Is_Ghost (Defer_Res52) then
            Transform_Res32.Last_Attempted_Child := -1;
         end if;
         if Null_Res1 /= null and then Is_Incomplete (Null_Res1) then
            Transform_Res32.Last_Attempted_Child := 0;
         elsif Null_Res1 /= null and then not Is_Ghost (Null_Res1) then
            Transform_Res32.Last_Attempted_Child := -1;
         end if;
         if Defer_Res53 /= null and then Is_Incomplete (Defer_Res53) then
            Transform_Res32.Last_Attempted_Child := 0;
         elsif Defer_Res53 /= null and then not Is_Ghost (Defer_Res53) then
            Transform_Res32.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos34 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags32);
end if;

--  END <Transform(<ASTNodeType DotExpr>) (root of 'callable_ref') at parser.lkt:381:9>

    if Row_Pos34 /= No_Token_Index then
        Or_Pos12 := Row_Pos34;
        Or_Res12 := Transform_Res32;
        goto Exit_Or13;
    end if;
    
--  BEGIN <Defer (for 'ref_id') at parser.lkt:381:68>

Defer_Res54 :=
   Ref_Id_Transform_Parse0 (Parser, Pos);
Defer_Pos54 := Parser.Current_Pos;

--  END <Defer (for 'ref_id') at parser.lkt:381:68>

    if Defer_Pos54 /= No_Token_Index then
        Or_Pos12 := Defer_Pos54;
        Or_Res12 := Defer_Res54;
        goto Exit_Or13;
    end if;
<<Exit_Or13>>

--  END <Or (root of 'callable_ref') at parser.lkt:380:21>


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------

      if Or_Pos12 > Mem_Pos then
         Mem_Pos := Or_Pos12;
         Mem_Res := Or_Res12;
         Set
           (PP.Callable_Ref_Or_Parse0_Memo,
            Or_Pos12 /= No_Token_Index,
            Or_Res12,
            Pos,
            Or_Pos12);
         goto Try_Again;

      elsif Mem_Pos > Pos then
         Or_Res12 := Mem_Res;
         Or_Pos12 := Mem_Pos;
         goto No_Memo;
      end if;

   Set
     (PP.Callable_Ref_Or_Parse0_Memo,
      Or_Pos12 /= No_Token_Index,
      Or_Res12,
      Pos,
      Or_Pos12);

       <<No_Memo>>

   Parser.Current_Pos := Or_Pos12;

   return Or_Res12;
end Callable_Ref_Or_Parse0;

   


function Char_Lit_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Char_Lit
is
   use Bare_Char_Lit_Memos;

      Row_Pos35 :
            Token_Index
               := No_Token_Index;
      Token_Pos46 :
            Token_Index
               := No_Token_Index;
      Token_Res46 :
            Token_Index
               := No_Token_Index;
      Transform_Res33 :
            Bare_Char_Lit
               := No_Bare_Lkt_Node;
      Transform_Diags33 :
            Ada.Containers.Count_Type;


   PP : constant Parser_Private_Part := +Parser.Private_Part;
   M  : Memo_Entry := Get (PP.Char_Lit_Transform_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res33 := M.Instance;
      return Transform_Res33;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res33;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  BEGIN <Transform(<ASTNodeType CharLit>) (root of 'char_lit') at parser.lkt:367:17>

Transform_Diags33 := Parser.Diagnostics.Length;


--  BEGIN <_Row (root of 'char_lit') at parser.lkt:367:17>

Row_Pos35 := Pos;



--  BEGIN <Token(<WithText Char>, ) (root of 'char_lit') at parser.lkt:367:25>

Token_Res46 := Row_Pos35;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res46));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_Char)
   then
       Token_Pos46 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos35 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos35,
             Expected_Token_Id => Lkt_Char,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos46 := Row_Pos35 + 1;
   end if;
end;

--  END <Token(<WithText Char>, ) (root of 'char_lit') at parser.lkt:367:25>




if Token_Pos46 /= No_Token_Index then

   Row_Pos35 := Token_Pos46;

else
   Row_Pos35 := No_Token_Index;
   goto Exit_Row35_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row35_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'char_lit') at parser.lkt:367:17>



if Row_Pos35 /= No_Token_Index then

   Transform_Res33 := Allocate_Char_Lit (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res33,
      Kind => Lkt_Char_Lit,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos35 = Pos
                            then No_Token_Index
                            else Row_Pos35 - 1));

      
      Initialize_Fields_For_Char_Lit
        (Self => Transform_Res33);



elsif Row_Pos35 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags33);
end if;

--  END <Transform(<ASTNodeType CharLit>) (root of 'char_lit') at parser.lkt:367:17>


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (PP.Char_Lit_Transform_Parse0_Memo,
      Row_Pos35 /= No_Token_Index,
      Transform_Res33,
      Pos,
      Row_Pos35);


   Parser.Current_Pos := Row_Pos35;

   return Transform_Res33;
end Char_Lit_Transform_Parse0;

   


function Decl_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Full_Decl
is
   use Bare_Full_Decl_Memos;

      Row_Pos36 :
            Token_Index
               := No_Token_Index;
      Defer_Pos55 :
            Token_Index
               := No_Token_Index;
      Defer_Res55 :
            Bare_String_Lit
               := No_Bare_Lkt_Node;
      Lst_Cpos4 :
            Token_Index
               := No_Token_Index;
      Tmp_List4 :
            Free_Parse_List;
      Defer_Pos56 :
            Token_Index
               := No_Token_Index;
      Defer_Res56 :
            Bare_Decl_Annotation
               := No_Bare_Lkt_Node;
      List_Pos4 :
            Token_Index
               := No_Token_Index;
      List_Res4 :
            Bare_Decl_Annotation_List
               := No_Bare_Lkt_Node;
      Defer_Pos57 :
            Token_Index
               := No_Token_Index;
      Defer_Res57 :
            Bare_Decl
               := No_Bare_Lkt_Node;
      Transform_Res34 :
            Bare_Full_Decl
               := No_Bare_Lkt_Node;
      Transform_Diags34 :
            Ada.Containers.Count_Type;


   PP : constant Parser_Private_Part := +Parser.Private_Part;
   M  : Memo_Entry := Get (PP.Decl_Transform_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res34 := M.Instance;
      return Transform_Res34;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res34;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  BEGIN <Transform(<ASTNodeType FullDecl>) (root of 'decl') at parser.lkt:212:13>

Transform_Diags34 := Parser.Diagnostics.Length;


--  BEGIN <_Row (root of 'decl') at parser.lkt:212:13>

Row_Pos36 := Pos;



--  BEGIN <Defer (for 'doc') at parser.lkt:212:22>

Defer_Res55 :=
   Doc_Opt_Parse0 (Parser, Row_Pos36);
Defer_Pos55 := Parser.Current_Pos;

--  END <Defer (for 'doc') at parser.lkt:212:22>




if Defer_Pos55 /= No_Token_Index then

   Row_Pos36 := Defer_Pos55;

else
   Row_Pos36 := No_Token_Index;
   goto Exit_Row36_0;

end if;


--  BEGIN <List (root of 'decl') at parser.lkt:212:26>

    List_Pos4 := Row_Pos36;



Lst_Cpos4 := Row_Pos36;
Tmp_List4 := Get_Parse_List (Parser);


loop
   
--  BEGIN <Defer (for 'decl_annotation') at parser.lkt:212:32>

Defer_Res56 :=
   Decl_Annotation_Transform_Parse0 (Parser, Lst_Cpos4);
Defer_Pos56 := Parser.Current_Pos;

--  END <Defer (for 'decl_annotation') at parser.lkt:212:32>


   exit when Defer_Pos56 = No_Token_Index;

   List_Pos4 := Defer_Pos56;
   Lst_Cpos4 := List_Pos4;

   Tmp_List4.Nodes.Append (Defer_Res56);

end loop;


declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List4.Nodes.Length;
begin
   List_Res4 := Allocate_Decl_Annotation_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Row_Pos36;
      Token_End := (if Lst_Cpos4 = Row_Pos36
                    then Row_Pos36
                    else List_Pos4 - 1);

   else
      Token_Start := Token_Index'Max (Row_Pos36, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res4,
      Kind              => Lkt_Decl_Annotation_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res4,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_Lkt_Node_Vectors.Vector renames
         Tmp_List4.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res4.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List4);

--  END <List (root of 'decl') at parser.lkt:212:26>




if List_Pos4 /= No_Token_Index then

   Row_Pos36 := List_Pos4;

else
   Row_Pos36 := No_Token_Index;
   goto Exit_Row36_0;

end if;


--  BEGIN <Defer (for 'bare_decl') at parser.lkt:212:49>

Defer_Res57 :=
   Bare_Decl_Or_Parse0 (Parser, Row_Pos36);
Defer_Pos57 := Parser.Current_Pos;

--  END <Defer (for 'bare_decl') at parser.lkt:212:49>




if Defer_Pos57 /= No_Token_Index then

   Row_Pos36 := Defer_Pos57;

else
   Row_Pos36 := No_Token_Index;
   goto Exit_Row36_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row36_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'decl') at parser.lkt:212:13>



if Row_Pos36 /= No_Token_Index then

   Transform_Res34 := Allocate_Full_Decl (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res34,
      Kind => Lkt_Full_Decl,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos36 = Pos
                            then No_Token_Index
                            else Row_Pos36 - 1));

      
      Initialize_Fields_For_Full_Decl
        (Self => Transform_Res34,
         Full_Decl_F_Doc => Defer_Res55,
         Full_Decl_F_Decl_Annotations => List_Res4,
         Full_Decl_F_Decl => Defer_Res57);

         if Defer_Res55 /= null and then Is_Incomplete (Defer_Res55) then
            Transform_Res34.Last_Attempted_Child := 0;
         elsif Defer_Res55 /= null and then not Is_Ghost (Defer_Res55) then
            Transform_Res34.Last_Attempted_Child := -1;
         end if;
         if List_Res4 /= null and then Is_Incomplete (List_Res4) then
            Transform_Res34.Last_Attempted_Child := 0;
         elsif List_Res4 /= null and then not Is_Ghost (List_Res4) then
            Transform_Res34.Last_Attempted_Child := -1;
         end if;
         if Defer_Res57 /= null and then Is_Incomplete (Defer_Res57) then
            Transform_Res34.Last_Attempted_Child := 0;
         elsif Defer_Res57 /= null and then not Is_Ghost (Defer_Res57) then
            Transform_Res34.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos36 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags34);
end if;

--  END <Transform(<ASTNodeType FullDecl>) (root of 'decl') at parser.lkt:212:13>


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (PP.Decl_Transform_Parse0_Memo,
      Row_Pos36 /= No_Token_Index,
      Transform_Res34,
      Pos,
      Row_Pos36);


   Parser.Current_Pos := Row_Pos36;

   return Transform_Res34;
end Decl_Transform_Parse0;

   


function Decl_Annotation_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Decl_Annotation
is
   use Bare_Decl_Annotation_Memos;

      Row_Pos37 :
            Token_Index
               := No_Token_Index;
      Token_Pos47 :
            Token_Index
               := No_Token_Index;
      Token_Res47 :
            Token_Index
               := No_Token_Index;
      Defer_Pos58 :
            Token_Index
               := No_Token_Index;
      Defer_Res58 :
            Bare_Id
               := No_Bare_Lkt_Node;
      Defer_Pos59 :
            Token_Index
               := No_Token_Index;
      Defer_Res59 :
            Bare_Decl_Annotation_Args
               := No_Bare_Lkt_Node;
      Transform_Res35 :
            Bare_Decl_Annotation
               := No_Bare_Lkt_Node;
      Transform_Diags35 :
            Ada.Containers.Count_Type;


   PP : constant Parser_Private_Part := +Parser.Private_Part;
   M  : Memo_Entry := Get (PP.Decl_Annotation_Transform_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res35 := M.Instance;
      return Transform_Res35;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res35;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  BEGIN <Transform(<ASTNodeType DeclAnnotation>) (root of 'decl_annotation') at parser.lkt:430:24>

Transform_Diags35 := Parser.Diagnostics.Length;


--  BEGIN <_Row (root of 'decl_annotation') at parser.lkt:430:24>

Row_Pos37 := Pos;



--  BEGIN <Token(<WithText At>, ) (root of 'decl_annotation') at parser.lkt:430:39>

Token_Res47 := Row_Pos37;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res47));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_At)
   then
       Token_Pos47 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos37 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos37,
             Expected_Token_Id => Lkt_At,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos47 := Row_Pos37 + 1;
   end if;
end;

--  END <Token(<WithText At>, ) (root of 'decl_annotation') at parser.lkt:430:39>




if Token_Pos47 /= No_Token_Index then

   Row_Pos37 := Token_Pos47;

else
   Row_Pos37 := No_Token_Index;
   goto Exit_Row37_0;

end if;


--  BEGIN <Defer (for 'id') at parser.lkt:430:43>

Defer_Res58 :=
   Id_Transform_Parse0 (Parser, Row_Pos37);
Defer_Pos58 := Parser.Current_Pos;

--  END <Defer (for 'id') at parser.lkt:430:43>




if Defer_Pos58 /= No_Token_Index then

   Row_Pos37 := Defer_Pos58;

else
   Row_Pos37 := No_Token_Index;
   goto Exit_Row37_0;

end if;


--  BEGIN <Defer (for 'decl_annotation_args') at parser.lkt:430:46>

Defer_Res59 :=
   Decl_Annotation_Args_Opt_Parse0 (Parser, Row_Pos37);
Defer_Pos59 := Parser.Current_Pos;

--  END <Defer (for 'decl_annotation_args') at parser.lkt:430:46>




if Defer_Pos59 /= No_Token_Index then

   Row_Pos37 := Defer_Pos59;

else
   Row_Pos37 := No_Token_Index;
   goto Exit_Row37_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row37_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'decl_annotation') at parser.lkt:430:24>



if Row_Pos37 /= No_Token_Index then

   Transform_Res35 := Allocate_Decl_Annotation (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res35,
      Kind => Lkt_Decl_Annotation,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos37 = Pos
                            then No_Token_Index
                            else Row_Pos37 - 1));

      
      Initialize_Fields_For_Decl_Annotation
        (Self => Transform_Res35,
         Decl_Annotation_F_Name => Defer_Res58,
         Decl_Annotation_F_Args => Defer_Res59);

         if Defer_Res58 /= null and then Is_Incomplete (Defer_Res58) then
            Transform_Res35.Last_Attempted_Child := 0;
         elsif Defer_Res58 /= null and then not Is_Ghost (Defer_Res58) then
            Transform_Res35.Last_Attempted_Child := -1;
         end if;
         if Defer_Res59 /= null and then Is_Incomplete (Defer_Res59) then
            Transform_Res35.Last_Attempted_Child := 0;
         elsif Defer_Res59 /= null and then not Is_Ghost (Defer_Res59) then
            Transform_Res35.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos37 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags35);
end if;

--  END <Transform(<ASTNodeType DeclAnnotation>) (root of 'decl_annotation') at parser.lkt:430:24>


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (PP.Decl_Annotation_Transform_Parse0_Memo,
      Row_Pos37 /= No_Token_Index,
      Transform_Res35,
      Pos,
      Row_Pos37);


   Parser.Current_Pos := Row_Pos37;

   return Transform_Res35;
end Decl_Annotation_Transform_Parse0;

   


function Decl_Annotation_Args_Opt_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Decl_Annotation_Args
is
   use Bare_Decl_Annotation_Args_Memos;

      Row_Pos38 :
            Token_Index
               := No_Token_Index;
      Token_Pos48 :
            Token_Index
               := No_Token_Index;
      Token_Res48 :
            Token_Index
               := No_Token_Index;
      Defer_Pos60 :
            Token_Index
               := No_Token_Index;
      Defer_Res60 :
            Bare_Argument_List
               := No_Bare_Lkt_Node;
      Token_Pos49 :
            Token_Index
               := No_Token_Index;
      Token_Res49 :
            Token_Index
               := No_Token_Index;
      Transform_Res36 :
            Bare_Decl_Annotation_Args
               := No_Bare_Lkt_Node;
      Transform_Diags36 :
            Ada.Containers.Count_Type;


   PP : constant Parser_Private_Part := +Parser.Private_Part;
   M  : Memo_Entry := Get (PP.Decl_Annotation_Args_Opt_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res36 := M.Instance;
      return Transform_Res36;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res36;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  BEGIN <Opt (root of 'decl_annotation_args') at parser.lkt:429:29>












--  BEGIN <Transform(<ASTNodeType DeclAnnotationArgs>) (root of 'decl_annotation_args') at parser.lkt:429:30>

Transform_Diags36 := Parser.Diagnostics.Length;


--  BEGIN <_Row (root of 'decl_annotation_args') at parser.lkt:429:30>

Row_Pos38 := Pos;



--  BEGIN <Token(<WithText LPar>, ) (root of 'decl_annotation_args') at parser.lkt:429:49>

Token_Res48 := Row_Pos38;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res48));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_L_Par)
   then
       Token_Pos48 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos38 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos38,
             Expected_Token_Id => Lkt_L_Par,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos48 := Row_Pos38 + 1;
   end if;
end;

--  END <Token(<WithText LPar>, ) (root of 'decl_annotation_args') at parser.lkt:429:49>




if Token_Pos48 /= No_Token_Index then

   Row_Pos38 := Token_Pos48;

else
   Row_Pos38 := No_Token_Index;
   goto Exit_Row38_0;

end if;


--  BEGIN <Defer (for 'args') at parser.lkt:429:53>

Defer_Res60 :=
   Args_List_Parse0 (Parser, Row_Pos38);
Defer_Pos60 := Parser.Current_Pos;

--  END <Defer (for 'args') at parser.lkt:429:53>




if Defer_Pos60 /= No_Token_Index then

   Row_Pos38 := Defer_Pos60;

else
   Row_Pos38 := No_Token_Index;
   goto Exit_Row38_0;

end if;


--  BEGIN <Token(<WithText RPar>, ) (root of 'decl_annotation_args') at parser.lkt:429:58>

Token_Res49 := Row_Pos38;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res49));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_R_Par)
   then
       Token_Pos49 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos38 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos38,
             Expected_Token_Id => Lkt_R_Par,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos49 := Row_Pos38 + 1;
   end if;
end;

--  END <Token(<WithText RPar>, ) (root of 'decl_annotation_args') at parser.lkt:429:58>




if Token_Pos49 /= No_Token_Index then

   Row_Pos38 := Token_Pos49;

else
   Row_Pos38 := No_Token_Index;
   goto Exit_Row38_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row38_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'decl_annotation_args') at parser.lkt:429:30>



if Row_Pos38 /= No_Token_Index then

   Transform_Res36 := Allocate_Decl_Annotation_Args (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res36,
      Kind => Lkt_Decl_Annotation_Args,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos38 = Pos
                            then No_Token_Index
                            else Row_Pos38 - 1));

      
      Initialize_Fields_For_Decl_Annotation_Args
        (Self => Transform_Res36,
         Decl_Annotation_Args_F_Args => Defer_Res60);

         if Defer_Res60 /= null and then Is_Incomplete (Defer_Res60) then
            Transform_Res36.Last_Attempted_Child := 0;
         elsif Defer_Res60 /= null and then not Is_Ghost (Defer_Res60) then
            Transform_Res36.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos38 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags36);
end if;

--  END <Transform(<ASTNodeType DeclAnnotationArgs>) (root of 'decl_annotation_args') at parser.lkt:429:30>


if Row_Pos38 = No_Token_Index then

         
   Transform_Res36 := No_Bare_Lkt_Node;



       
   Row_Pos38 := Pos;



end if;

--  END <Opt (root of 'decl_annotation_args') at parser.lkt:429:29>


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (PP.Decl_Annotation_Args_Opt_Parse0_Memo,
      Row_Pos38 /= No_Token_Index,
      Transform_Res36,
      Pos,
      Row_Pos38);


   Parser.Current_Pos := Row_Pos38;

   return Transform_Res36;
end Decl_Annotation_Args_Opt_Parse0;

   


function Decl_Block_List_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Decl_Block
is
   use Bare_Decl_Block_Memos;

      Lst_Cpos5 :
            Token_Index
               := No_Token_Index;
      Tmp_List5 :
            Free_Parse_List;
      Defer_Pos61 :
            Token_Index
               := No_Token_Index;
      Defer_Res61 :
            Bare_Full_Decl
               := No_Bare_Lkt_Node;
      List_Pos5 :
            Token_Index
               := No_Token_Index;
      List_Res5 :
            Bare_Decl_Block
               := No_Bare_Lkt_Node;


   PP : constant Parser_Private_Part := +Parser.Private_Part;
   M  : Memo_Entry := Get (PP.Decl_Block_List_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      List_Res5 := M.Instance;
      return List_Res5;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return List_Res5;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  BEGIN <List (root of 'decl_block') at parser.lkt:225:19>

    List_Pos5 := Pos;



Lst_Cpos5 := Pos;
Tmp_List5 := Get_Parse_List (Parser);


loop
   
--  BEGIN <Defer (for 'decl') at parser.lkt:225:30>

Defer_Res61 :=
   Decl_Transform_Parse0 (Parser, Lst_Cpos5);
Defer_Pos61 := Parser.Current_Pos;

--  END <Defer (for 'decl') at parser.lkt:225:30>


   exit when Defer_Pos61 = No_Token_Index;

   List_Pos5 := Defer_Pos61;
   Lst_Cpos5 := List_Pos5;

   Tmp_List5.Nodes.Append (Defer_Res61);

end loop;


declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List5.Nodes.Length;
begin
   List_Res5 := Allocate_Decl_Block (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Pos;
      Token_End := (if Lst_Cpos5 = Pos
                    then Pos
                    else List_Pos5 - 1);

   else
      Token_Start := Token_Index'Max (Pos, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res5,
      Kind              => Lkt_Decl_Block,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res5,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_Lkt_Node_Vectors.Vector renames
         Tmp_List5.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res5.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List5);

--  END <List (root of 'decl_block') at parser.lkt:225:19>


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (PP.Decl_Block_List_Parse0_Memo,
      List_Pos5 /= No_Token_Index,
      List_Res5,
      Pos,
      List_Pos5);


   Parser.Current_Pos := List_Pos5;

   return List_Res5;
end Decl_Block_List_Parse0;

   


function Decls_List_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Full_Decl_List
is
   use Bare_Full_Decl_List_Memos;

      Lst_Cpos6 :
            Token_Index
               := No_Token_Index;
      Tmp_List6 :
            Free_Parse_List;
      Defer_Pos62 :
            Token_Index
               := No_Token_Index;
      Defer_Res62 :
            Bare_Full_Decl
               := No_Bare_Lkt_Node;
      List_Pos6 :
            Token_Index
               := No_Token_Index;
      List_Res6 :
            Bare_Full_Decl_List
               := No_Bare_Lkt_Node;


   PP : constant Parser_Private_Part := +Parser.Private_Part;
   M  : Memo_Entry := Get (PP.Decls_List_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      List_Res6 := M.Instance;
      return List_Res6;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return List_Res6;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  BEGIN <List (root of 'decls') at parser.lkt:224:14>

    List_Pos6 := Pos;



Lst_Cpos6 := Pos;
Tmp_List6 := Get_Parse_List (Parser);


loop
   
--  BEGIN <Defer (for 'decl') at parser.lkt:224:20>

Defer_Res62 :=
   Decl_Transform_Parse0 (Parser, Lst_Cpos6);
Defer_Pos62 := Parser.Current_Pos;

--  END <Defer (for 'decl') at parser.lkt:224:20>


   exit when Defer_Pos62 = No_Token_Index;

   List_Pos6 := Defer_Pos62;
   Lst_Cpos6 := List_Pos6;

   Tmp_List6.Nodes.Append (Defer_Res62);

end loop;


declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List6.Nodes.Length;
begin
   List_Res6 := Allocate_Full_Decl_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Pos;
      Token_End := (if Lst_Cpos6 = Pos
                    then Pos
                    else List_Pos6 - 1);

   else
      Token_Start := Token_Index'Max (Pos, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res6,
      Kind              => Lkt_Full_Decl_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res6,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_Lkt_Node_Vectors.Vector renames
         Tmp_List6.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res6.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List6);

--  END <List (root of 'decls') at parser.lkt:224:14>


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (PP.Decls_List_Parse0_Memo,
      List_Pos6 /= No_Token_Index,
      List_Res6,
      Pos,
      List_Pos6);


   Parser.Current_Pos := List_Pos6;

   return List_Res6;
end Decls_List_Parse0;

   


function Def_Id_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Def_Id
is
   use Bare_Def_Id_Memos;

      Row_Pos39 :
            Token_Index
               := No_Token_Index;
      Token_Pos50 :
            Token_Index
               := No_Token_Index;
      Token_Res50 :
            Token_Index
               := No_Token_Index;
      Transform_Res37 :
            Bare_Def_Id
               := No_Bare_Lkt_Node;
      Transform_Diags37 :
            Ada.Containers.Count_Type;


   PP : constant Parser_Private_Part := +Parser.Private_Part;
   M  : Memo_Entry := Get (PP.Def_Id_Transform_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res37 := M.Instance;
      return Transform_Res37;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res37;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  BEGIN <Transform(<ASTNodeType DefId>) (root of 'def_id') at parser.lkt:9:15>

Transform_Diags37 := Parser.Diagnostics.Length;


--  BEGIN <_Row (root of 'def_id') at parser.lkt:9:15>

Row_Pos39 := Pos;



--  BEGIN <Token(<WithSymbol Identifier>, ) (root of 'def_id') at parser.lkt:9:21>

Token_Res50 := Row_Pos39;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res50));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_Identifier)
   then
       Token_Pos50 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos39 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos39,
             Expected_Token_Id => Lkt_Identifier,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos50 := Row_Pos39 + 1;
   end if;
end;

--  END <Token(<WithSymbol Identifier>, ) (root of 'def_id') at parser.lkt:9:21>




if Token_Pos50 /= No_Token_Index then

   Row_Pos39 := Token_Pos50;

else
   Row_Pos39 := No_Token_Index;
   goto Exit_Row39_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row39_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'def_id') at parser.lkt:9:15>



if Row_Pos39 /= No_Token_Index then

   Transform_Res37 := Allocate_Def_Id (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res37,
      Kind => Lkt_Def_Id,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos39 = Pos
                            then No_Token_Index
                            else Row_Pos39 - 1));

      
      Initialize_Fields_For_Def_Id
        (Self => Transform_Res37);



elsif Row_Pos39 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags37);
end if;

--  END <Transform(<ASTNodeType DefId>) (root of 'def_id') at parser.lkt:9:15>


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (PP.Def_Id_Transform_Parse0_Memo,
      Row_Pos39 /= No_Token_Index,
      Transform_Res37,
      Pos,
      Row_Pos39);


   Parser.Current_Pos := Row_Pos39;

   return Transform_Res37;
end Def_Id_Transform_Parse0;

   


function Doc_Opt_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_String_Lit
is
   use Bare_String_Lit_Memos;

      Defer_Pos63 :
            Token_Index
               := No_Token_Index;
      Defer_Res63 :
            Bare_String_Lit
               := No_Bare_Lkt_Node;


   PP : constant Parser_Private_Part := +Parser.Private_Part;
   M  : Memo_Entry := Get (PP.Doc_Opt_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Defer_Res63 := M.Instance;
      return Defer_Res63;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Defer_Res63;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  BEGIN <Opt (root of 'doc') at parser.lkt:10:12>












--  BEGIN <Defer (for 'string_lit') at parser.lkt:10:13>

Defer_Res63 :=
   String_Lit_Or_Parse0 (Parser, Pos);
Defer_Pos63 := Parser.Current_Pos;

--  END <Defer (for 'string_lit') at parser.lkt:10:13>


if Defer_Pos63 = No_Token_Index then

         
   Defer_Res63 := No_Bare_Lkt_Node;



       
   Defer_Pos63 := Pos;



end if;

--  END <Opt (root of 'doc') at parser.lkt:10:12>


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (PP.Doc_Opt_Parse0_Memo,
      Defer_Pos63 /= No_Token_Index,
      Defer_Res63,
      Pos,
      Defer_Pos63);


   Parser.Current_Pos := Defer_Pos63;

   return Defer_Res63;
end Doc_Opt_Parse0;

   


function Dontskip_Block0_Extract_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Lkt_Node
is
   use Bare_Lkt_Node_Memos;

      Row_Pos40 :
            Token_Index
               := No_Token_Index;
      Null_Res2 :
            Bare_Lkt_Node
               := No_Bare_Lkt_Node;
      Token_Pos51 :
            Token_Index
               := No_Token_Index;
      Token_Res51 :
            Token_Index
               := No_Token_Index;


   PP : constant Parser_Private_Part := +Parser.Private_Part;
   M  : Memo_Entry := Get (PP.Dontskip_Block0_Extract_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Null_Res2 := M.Instance;
      return Null_Res2;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Null_Res2;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  BEGIN <_Extract (root of 'dontskip_block0') at parser.lkt:236:9>

--  BEGIN <_Row (root of 'dontskip_block0') at parser.lkt:236:9>

Row_Pos40 := Pos;



--  BEGIN <Null (root of 'dontskip_block0') at <builtin>>

   Null_Res2 := No_Bare_Lkt_Node;

--  END <Null (root of 'dontskip_block0') at <builtin>>




if Row_Pos40 /= No_Token_Index then

   Row_Pos40 := Row_Pos40;

else
   Row_Pos40 := No_Token_Index;
   goto Exit_Row40_0;

end if;


--  BEGIN <Token(<WithText RBrace>, ) (root of 'dontskip_block0') at parser.lkt:242:21>

Token_Res51 := Row_Pos40;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res51));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_R_Brace)
   then
       Token_Pos51 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos40 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos40,
             Expected_Token_Id => Lkt_R_Brace,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos51 := Row_Pos40 + 1;
   end if;
end;

--  END <Token(<WithText RBrace>, ) (root of 'dontskip_block0') at parser.lkt:242:21>




if Token_Pos51 /= No_Token_Index then

   Row_Pos40 := Token_Pos51;

else
   Row_Pos40 := No_Token_Index;
   goto Exit_Row40_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row40_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'dontskip_block0') at parser.lkt:236:9>

--  END <_Extract (root of 'dontskip_block0') at parser.lkt:236:9>


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (PP.Dontskip_Block0_Extract_Parse0_Memo,
      Row_Pos40 /= No_Token_Index,
      Null_Res2,
      Pos,
      Row_Pos40);


   Parser.Current_Pos := Row_Pos40;

   return Null_Res2;
end Dontskip_Block0_Extract_Parse0;

   


function Dynvar_Decl_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Dyn_Var_Decl
is
   use Bare_Dyn_Var_Decl_Memos;

      Row_Pos41 :
            Token_Index
               := No_Token_Index;
      Token_Pos52 :
            Token_Index
               := No_Token_Index;
      Token_Res52 :
            Token_Index
               := No_Token_Index;
      Defer_Pos64 :
            Token_Index
               := No_Token_Index;
      Defer_Res64 :
            Bare_Def_Id
               := No_Bare_Lkt_Node;
      Token_Pos53 :
            Token_Index
               := No_Token_Index;
      Token_Res53 :
            Token_Index
               := No_Token_Index;
      Defer_Pos65 :
            Token_Index
               := No_Token_Index;
      Defer_Res65 :
            Bare_Type_Ref
               := No_Bare_Lkt_Node;
      Transform_Res38 :
            Bare_Dyn_Var_Decl
               := No_Bare_Lkt_Node;
      Transform_Diags38 :
            Ada.Containers.Count_Type;


   PP : constant Parser_Private_Part := +Parser.Private_Part;
   M  : Memo_Entry := Get (PP.Dynvar_Decl_Transform_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res38 := M.Instance;
      return Transform_Res38;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res38;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  BEGIN <Transform(<ASTNodeType DynVarDecl>) (root of 'dynvar_decl') at parser.lkt:227:20>

Transform_Diags38 := Parser.Diagnostics.Length;


--  BEGIN <_Row (root of 'dynvar_decl') at parser.lkt:227:20>

Row_Pos41 := Pos;



--  BEGIN <Token(<WithText DynVarKw>, ) (root of 'dynvar_decl') at parser.lkt:227:31>

Token_Res52 := Row_Pos41;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res52));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_Dyn_Var_Kw)
   then
       Token_Pos52 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos41 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos41,
             Expected_Token_Id => Lkt_Dyn_Var_Kw,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos52 := Row_Pos41 + 1;
   end if;
end;

--  END <Token(<WithText DynVarKw>, ) (root of 'dynvar_decl') at parser.lkt:227:31>




if Token_Pos52 /= No_Token_Index then

   Row_Pos41 := Token_Pos52;

else
   Row_Pos41 := No_Token_Index;
   goto Exit_Row41_0;

end if;


--  BEGIN <Defer (for 'def_id') at parser.lkt:227:40>

Defer_Res64 :=
   Def_Id_Transform_Parse0 (Parser, Row_Pos41);
Defer_Pos64 := Parser.Current_Pos;

--  END <Defer (for 'def_id') at parser.lkt:227:40>




if Defer_Pos64 /= No_Token_Index then

   Row_Pos41 := Defer_Pos64;

else
   Row_Pos41 := No_Token_Index;
   goto Exit_Row41_0;

end if;


--  BEGIN <Token(<WithText Colon>, ) (root of 'dynvar_decl') at parser.lkt:227:47>

Token_Res53 := Row_Pos41;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res53));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_Colon)
   then
       Token_Pos53 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos41 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos41,
             Expected_Token_Id => Lkt_Colon,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos53 := Row_Pos41 + 1;
   end if;
end;

--  END <Token(<WithText Colon>, ) (root of 'dynvar_decl') at parser.lkt:227:47>




if Token_Pos53 /= No_Token_Index then

   Row_Pos41 := Token_Pos53;

else
   Row_Pos41 := No_Token_Index;
   goto Exit_Row41_0;

end if;


--  BEGIN <Defer (for 'type_ref') at parser.lkt:227:51>

Defer_Res65 :=
   Type_Ref_Or_Parse0 (Parser, Row_Pos41);
Defer_Pos65 := Parser.Current_Pos;

--  END <Defer (for 'type_ref') at parser.lkt:227:51>




if Defer_Pos65 /= No_Token_Index then

   Row_Pos41 := Defer_Pos65;

else
   Row_Pos41 := No_Token_Index;
   goto Exit_Row41_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row41_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'dynvar_decl') at parser.lkt:227:20>



if Row_Pos41 /= No_Token_Index then

   Transform_Res38 := Allocate_Dyn_Var_Decl (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res38,
      Kind => Lkt_Dyn_Var_Decl,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos41 = Pos
                            then No_Token_Index
                            else Row_Pos41 - 1));

      
      Initialize_Fields_For_Dyn_Var_Decl
        (Self => Transform_Res38,
         Dyn_Var_Decl_F_Syn_Name => Defer_Res64,
         Dyn_Var_Decl_F_Decl_Type => Defer_Res65);

         if Defer_Res64 /= null and then Is_Incomplete (Defer_Res64) then
            Transform_Res38.Last_Attempted_Child := 0;
         elsif Defer_Res64 /= null and then not Is_Ghost (Defer_Res64) then
            Transform_Res38.Last_Attempted_Child := -1;
         end if;
         if Defer_Res65 /= null and then Is_Incomplete (Defer_Res65) then
            Transform_Res38.Last_Attempted_Child := 0;
         elsif Defer_Res65 /= null and then not Is_Ghost (Defer_Res65) then
            Transform_Res38.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos41 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags38);
end if;

--  END <Transform(<ASTNodeType DynVarDecl>) (root of 'dynvar_decl') at parser.lkt:227:20>


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (PP.Dynvar_Decl_Transform_Parse0_Memo,
      Row_Pos41 /= No_Token_Index,
      Transform_Res38,
      Pos,
      Row_Pos41);


   Parser.Current_Pos := Row_Pos41;

   return Transform_Res38;
end Dynvar_Decl_Transform_Parse0;

   


function Ellipsis_Pattern_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Ellipsis_Pattern
is
   use Bare_Ellipsis_Pattern_Memos;

      Row_Pos42 :
            Token_Index
               := No_Token_Index;
      Row_Pos43 :
            Token_Index
               := No_Token_Index;
      Defer_Pos66 :
            Token_Index
               := No_Token_Index;
      Defer_Res66 :
            Bare_Id
               := No_Bare_Lkt_Node;
      Token_Pos54 :
            Token_Index
               := No_Token_Index;
      Token_Res54 :
            Token_Index
               := No_Token_Index;
      Token_Pos55 :
            Token_Index
               := No_Token_Index;
      Token_Res55 :
            Token_Index
               := No_Token_Index;
      Transform_Res39 :
            Bare_Ellipsis_Pattern
               := No_Bare_Lkt_Node;
      Transform_Diags39 :
            Ada.Containers.Count_Type;


   PP : constant Parser_Private_Part := +Parser.Private_Part;
   M  : Memo_Entry := Get (PP.Ellipsis_Pattern_Transform_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res39 := M.Instance;
      return Transform_Res39;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res39;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  BEGIN <Transform(<ASTNodeType EllipsisPattern>) (root of 'ellipsis_pattern') at parser.lkt:279:25>

Transform_Diags39 := Parser.Diagnostics.Length;


--  BEGIN <_Row (root of 'ellipsis_pattern') at parser.lkt:279:25>

Row_Pos42 := Pos;



--  BEGIN <Opt (root of 'ellipsis_pattern') at parser.lkt:279:41>












--  BEGIN <_Extract (root of 'ellipsis_pattern') at parser.lkt:279:42>

--  BEGIN <_Row (root of 'ellipsis_pattern') at parser.lkt:279:42>

Row_Pos43 := Row_Pos42;



--  BEGIN <Defer (for 'id') at parser.lkt:279:47>

Defer_Res66 :=
   Id_Transform_Parse0 (Parser, Row_Pos43);
Defer_Pos66 := Parser.Current_Pos;

--  END <Defer (for 'id') at parser.lkt:279:47>




if Defer_Pos66 /= No_Token_Index then

   Row_Pos43 := Defer_Pos66;

else
   Row_Pos43 := No_Token_Index;
   goto Exit_Row43_0;

end if;


--  BEGIN <Token(<WithText At>, ) (root of 'ellipsis_pattern') at parser.lkt:279:50>

Token_Res54 := Row_Pos43;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res54));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_At)
   then
       Token_Pos54 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos43 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos43,
             Expected_Token_Id => Lkt_At,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos54 := Row_Pos43 + 1;
   end if;
end;

--  END <Token(<WithText At>, ) (root of 'ellipsis_pattern') at parser.lkt:279:50>




if Token_Pos54 /= No_Token_Index then

   Row_Pos43 := Token_Pos54;

else
   Row_Pos43 := No_Token_Index;
   goto Exit_Row43_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row43_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'ellipsis_pattern') at parser.lkt:279:42>

--  END <_Extract (root of 'ellipsis_pattern') at parser.lkt:279:42>


if Row_Pos43 = No_Token_Index then

         
   Defer_Res66 := No_Bare_Lkt_Node;



       
   Row_Pos43 := Row_Pos42;



end if;

--  END <Opt (root of 'ellipsis_pattern') at parser.lkt:279:41>




if Row_Pos43 /= No_Token_Index then

   Row_Pos42 := Row_Pos43;

else
   Row_Pos42 := No_Token_Index;
   goto Exit_Row42_0;

end if;


--  BEGIN <Token(<WithText Ellipsis>, ) (root of 'ellipsis_pattern') at parser.lkt:279:55>

Token_Res55 := Row_Pos42;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res55));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_Ellipsis)
   then
       Token_Pos55 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos42 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos42,
             Expected_Token_Id => Lkt_Ellipsis,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos55 := Row_Pos42 + 1;
   end if;
end;

--  END <Token(<WithText Ellipsis>, ) (root of 'ellipsis_pattern') at parser.lkt:279:55>




if Token_Pos55 /= No_Token_Index then

   Row_Pos42 := Token_Pos55;

else
   Row_Pos42 := No_Token_Index;
   goto Exit_Row42_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row42_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'ellipsis_pattern') at parser.lkt:279:25>



if Row_Pos42 /= No_Token_Index then

   Transform_Res39 := Allocate_Ellipsis_Pattern (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res39,
      Kind => Lkt_Ellipsis_Pattern,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos42 = Pos
                            then No_Token_Index
                            else Row_Pos42 - 1));

      
      Initialize_Fields_For_Ellipsis_Pattern
        (Self => Transform_Res39,
         Ellipsis_Pattern_F_Binding => Defer_Res66);

         if Defer_Res66 /= null and then Is_Incomplete (Defer_Res66) then
            Transform_Res39.Last_Attempted_Child := 0;
         elsif Defer_Res66 /= null and then not Is_Ghost (Defer_Res66) then
            Transform_Res39.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos42 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags39);
end if;

--  END <Transform(<ASTNodeType EllipsisPattern>) (root of 'ellipsis_pattern') at parser.lkt:279:25>


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (PP.Ellipsis_Pattern_Transform_Parse0_Memo,
      Row_Pos42 /= No_Token_Index,
      Transform_Res39,
      Pos,
      Row_Pos42);


   Parser.Current_Pos := Row_Pos42;

   return Transform_Res39;
end Ellipsis_Pattern_Transform_Parse0;

   


function Enum_Lit_Decl_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Enum_Lit_Decl
is
   use Bare_Enum_Lit_Decl_Memos;

      Row_Pos44 :
            Token_Index
               := No_Token_Index;
      Defer_Pos67 :
            Token_Index
               := No_Token_Index;
      Defer_Res67 :
            Bare_Def_Id
               := No_Bare_Lkt_Node;
      Transform_Res40 :
            Bare_Enum_Lit_Decl
               := No_Bare_Lkt_Node;
      Transform_Diags40 :
            Ada.Containers.Count_Type;


   PP : constant Parser_Private_Part := +Parser.Private_Part;
   M  : Memo_Entry := Get (PP.Enum_Lit_Decl_Transform_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res40 := M.Instance;
      return Transform_Res40;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res40;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  BEGIN <Transform(<ASTNodeType EnumLitDecl>) (root of 'enum_lit_decl') at parser.lkt:173:22>

Transform_Diags40 := Parser.Diagnostics.Length;


--  BEGIN <_Row (root of 'enum_lit_decl') at parser.lkt:173:22>

Row_Pos44 := Pos;



--  BEGIN <Defer (for 'def_id') at parser.lkt:173:34>

Defer_Res67 :=
   Def_Id_Transform_Parse0 (Parser, Row_Pos44);
Defer_Pos67 := Parser.Current_Pos;

--  END <Defer (for 'def_id') at parser.lkt:173:34>




if Defer_Pos67 /= No_Token_Index then

   Row_Pos44 := Defer_Pos67;

else
   Row_Pos44 := No_Token_Index;
   goto Exit_Row44_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row44_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'enum_lit_decl') at parser.lkt:173:22>



if Row_Pos44 /= No_Token_Index then

   Transform_Res40 := Allocate_Enum_Lit_Decl (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res40,
      Kind => Lkt_Enum_Lit_Decl,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos44 = Pos
                            then No_Token_Index
                            else Row_Pos44 - 1));

      
      Initialize_Fields_For_Enum_Lit_Decl
        (Self => Transform_Res40,
         Enum_Lit_Decl_F_Syn_Name => Defer_Res67);

         if Defer_Res67 /= null and then Is_Incomplete (Defer_Res67) then
            Transform_Res40.Last_Attempted_Child := 0;
         elsif Defer_Res67 /= null and then not Is_Ghost (Defer_Res67) then
            Transform_Res40.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos44 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags40);
end if;

--  END <Transform(<ASTNodeType EnumLitDecl>) (root of 'enum_lit_decl') at parser.lkt:173:22>


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (PP.Enum_Lit_Decl_Transform_Parse0_Memo,
      Row_Pos44 /= No_Token_Index,
      Transform_Res40,
      Pos,
      Row_Pos44);


   Parser.Current_Pos := Row_Pos44;

   return Transform_Res40;
end Enum_Lit_Decl_Transform_Parse0;

   


function Env_Spec_Action_Transform_Parse1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Call_Expr
is
   use Bare_Call_Expr_Memos;

      Row_Pos45 :
            Token_Index
               := No_Token_Index;
      Row_Pos46 :
            Token_Index
               := No_Token_Index;
      Token_Pos56 :
            Token_Index
               := No_Token_Index;
      Token_Res56 :
            Token_Index
               := No_Token_Index;
      Transform_Res41 :
            Bare_Ref_Id
               := No_Bare_Lkt_Node;
      Transform_Diags41 :
            Ada.Containers.Count_Type;
      Token_Pos57 :
            Token_Index
               := No_Token_Index;
      Token_Res57 :
            Token_Index
               := No_Token_Index;
      Defer_Pos68 :
            Token_Index
               := No_Token_Index;
      Defer_Res68 :
            Bare_Argument_List
               := No_Bare_Lkt_Node;
      Token_Pos58 :
            Token_Index
               := No_Token_Index;
      Token_Res58 :
            Token_Index
               := No_Token_Index;
      Transform_Res42 :
            Bare_Call_Expr
               := No_Bare_Lkt_Node;
      Transform_Diags42 :
            Ada.Containers.Count_Type;


   PP : constant Parser_Private_Part := +Parser.Private_Part;
   M  : Memo_Entry := Get (PP.Env_Spec_Action_Transform_Parse1_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res42 := M.Instance;
      return Transform_Res42;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res42;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  BEGIN <Transform(<ASTNodeType CallExpr>) (root of 'env_spec_action') at parser.lkt:229:24>

Transform_Diags42 := Parser.Diagnostics.Length;


--  BEGIN <_Row (root of 'env_spec_action') at parser.lkt:229:24>

Row_Pos45 := Pos;



--  BEGIN <Transform(<ASTNodeType RefId>) (root of 'env_spec_action') at parser.lkt:229:33>

Transform_Diags41 := Parser.Diagnostics.Length;


--  BEGIN <_Row (root of 'env_spec_action') at parser.lkt:229:33>

Row_Pos46 := Row_Pos45;



--  BEGIN <Token(<WithSymbol Identifier>, ) (root of 'env_spec_action') at parser.lkt:229:39>

Token_Res56 := Row_Pos46;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res56));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_Identifier)
   then
       Token_Pos56 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos46 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos46,
             Expected_Token_Id => Lkt_Identifier,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos56 := Row_Pos46 + 1;
   end if;
end;

--  END <Token(<WithSymbol Identifier>, ) (root of 'env_spec_action') at parser.lkt:229:39>




if Token_Pos56 /= No_Token_Index then

   Row_Pos46 := Token_Pos56;

else
   Row_Pos46 := No_Token_Index;
   goto Exit_Row46_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row46_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'env_spec_action') at parser.lkt:229:33>



if Row_Pos46 /= No_Token_Index then

   Transform_Res41 := Allocate_Ref_Id (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res41,
      Kind => Lkt_Ref_Id,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos45,
      Token_End_Index   => (if Row_Pos46 = Row_Pos45
                            then No_Token_Index
                            else Row_Pos46 - 1));

      
      Initialize_Fields_For_Ref_Id
        (Self => Transform_Res41);



elsif Row_Pos46 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags41);
end if;

--  END <Transform(<ASTNodeType RefId>) (root of 'env_spec_action') at parser.lkt:229:33>




if Row_Pos46 /= No_Token_Index then

   Row_Pos45 := Row_Pos46;

else
   Row_Pos45 := No_Token_Index;
   goto Exit_Row45_0;

end if;


--  BEGIN <Token(<WithText LPar>, ) (root of 'env_spec_action') at parser.lkt:229:52>

Token_Res57 := Row_Pos45;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res57));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_L_Par)
   then
       Token_Pos57 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos45 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos45,
             Expected_Token_Id => Lkt_L_Par,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos57 := Row_Pos45 + 1;
   end if;
end;

--  END <Token(<WithText LPar>, ) (root of 'env_spec_action') at parser.lkt:229:52>




if Token_Pos57 /= No_Token_Index then

   Row_Pos45 := Token_Pos57;

else
   Row_Pos45 := No_Token_Index;
   goto Exit_Row45_0;

end if;


--  BEGIN <Defer (for 'args') at parser.lkt:229:56>

Defer_Res68 :=
   Args_List_Parse0 (Parser, Row_Pos45);
Defer_Pos68 := Parser.Current_Pos;

--  END <Defer (for 'args') at parser.lkt:229:56>




if Defer_Pos68 /= No_Token_Index then

   Row_Pos45 := Defer_Pos68;

else
   Row_Pos45 := No_Token_Index;
   goto Exit_Row45_0;

end if;


--  BEGIN <Token(<WithText RPar>, ) (root of 'env_spec_action') at parser.lkt:229:61>

Token_Res58 := Row_Pos45;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res58));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_R_Par)
   then
       Token_Pos58 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos45 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos45,
             Expected_Token_Id => Lkt_R_Par,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos58 := Row_Pos45 + 1;
   end if;
end;

--  END <Token(<WithText RPar>, ) (root of 'env_spec_action') at parser.lkt:229:61>




if Token_Pos58 /= No_Token_Index then

   Row_Pos45 := Token_Pos58;

else
   Row_Pos45 := No_Token_Index;
   goto Exit_Row45_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row45_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'env_spec_action') at parser.lkt:229:24>



if Row_Pos45 /= No_Token_Index then

   Transform_Res42 := Allocate_Call_Expr (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res42,
      Kind => Lkt_Call_Expr,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos45 = Pos
                            then No_Token_Index
                            else Row_Pos45 - 1));

      
      Initialize_Fields_For_Call_Expr
        (Self => Transform_Res42,
         Base_Call_Expr_F_Name => Transform_Res41,
         Base_Call_Expr_F_Args => Defer_Res68);

         if Transform_Res41 /= null and then Is_Incomplete (Transform_Res41) then
            Transform_Res42.Last_Attempted_Child := 0;
         elsif Transform_Res41 /= null and then not Is_Ghost (Transform_Res41) then
            Transform_Res42.Last_Attempted_Child := -1;
         end if;
         if Defer_Res68 /= null and then Is_Incomplete (Defer_Res68) then
            Transform_Res42.Last_Attempted_Child := 0;
         elsif Defer_Res68 /= null and then not Is_Ghost (Defer_Res68) then
            Transform_Res42.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos45 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags42);
end if;

--  END <Transform(<ASTNodeType CallExpr>) (root of 'env_spec_action') at parser.lkt:229:24>


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (PP.Env_Spec_Action_Transform_Parse1_Memo,
      Row_Pos45 /= No_Token_Index,
      Transform_Res42,
      Pos,
      Row_Pos45);


   Parser.Current_Pos := Row_Pos45;

   return Transform_Res42;
end Env_Spec_Action_Transform_Parse1;

   


function Env_Spec_Decl_Transform_Parse1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Env_Spec_Decl
is
   use Bare_Env_Spec_Decl_Memos;

      Row_Pos47 :
            Token_Index
               := No_Token_Index;
      Row_Pos48 :
            Token_Index
               := No_Token_Index;
      Token_Pos59 :
            Token_Index
               := No_Token_Index;
      Token_Res59 :
            Token_Index
               := No_Token_Index;
      Transform_Res43 :
            Bare_Def_Id
               := No_Bare_Lkt_Node;
      Transform_Diags43 :
            Ada.Containers.Count_Type;
      Token_Pos60 :
            Token_Index
               := No_Token_Index;
      Token_Res60 :
            Token_Index
               := No_Token_Index;
      Lst_Cpos7 :
            Token_Index
               := No_Token_Index;
      Tmp_List7 :
            Free_Parse_List;
      Defer_Pos69 :
            Token_Index
               := No_Token_Index;
      Defer_Res69 :
            Bare_Call_Expr
               := No_Bare_Lkt_Node;
      List_Pos7 :
            Token_Index
               := No_Token_Index;
      List_Res7 :
            Bare_Call_Expr_List
               := No_Bare_Lkt_Node;
      Token_Pos61 :
            Token_Index
               := No_Token_Index;
      Token_Res61 :
            Token_Index
               := No_Token_Index;
      Transform_Res44 :
            Bare_Env_Spec_Decl
               := No_Bare_Lkt_Node;
      Transform_Diags44 :
            Ada.Containers.Count_Type;


   PP : constant Parser_Private_Part := +Parser.Private_Part;
   M  : Memo_Entry := Get (PP.Env_Spec_Decl_Transform_Parse1_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res44 := M.Instance;
      return Transform_Res44;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res44;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  BEGIN <Transform(<ASTNodeType EnvSpecDecl>) (root of 'env_spec_decl') at parser.lkt:230:22>

Transform_Diags44 := Parser.Diagnostics.Length;


--  BEGIN <_Row (root of 'env_spec_decl') at parser.lkt:230:22>

Row_Pos47 := Pos;



--  BEGIN <Transform(<ASTNodeType DefId>) (root of 'env_spec_decl') at parser.lkt:231:9>

Transform_Diags43 := Parser.Diagnostics.Length;


--  BEGIN <_Row (root of 'env_spec_decl') at parser.lkt:231:9>

Row_Pos48 := Row_Pos47;



--  BEGIN <Token(<WithSymbol Identifier>, env_spec) (root of 'env_spec_decl') at parser.lkt:231:15>

Token_Res59 := Row_Pos48;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res59));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_Identifier)
      or else T.Symbol /= Precomputed_Symbol
        (Precomputed_Symbol_Table (Parser.TDH.Symbols),
         Precomputed_Sym_Env_Spec)
   then
       Token_Pos59 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos48 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos48,
             Expected_Token_Id => Lkt_Identifier,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos59 := Row_Pos48 + 1;
   end if;
end;

--  END <Token(<WithSymbol Identifier>, env_spec) (root of 'env_spec_decl') at parser.lkt:231:15>




if Token_Pos59 /= No_Token_Index then

   Row_Pos48 := Token_Pos59;

else
   Row_Pos48 := No_Token_Index;
   goto Exit_Row48_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row48_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'env_spec_decl') at parser.lkt:231:9>



if Row_Pos48 /= No_Token_Index then

   Transform_Res43 := Allocate_Def_Id (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res43,
      Kind => Lkt_Def_Id,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos47,
      Token_End_Index   => (if Row_Pos48 = Row_Pos47
                            then No_Token_Index
                            else Row_Pos48 - 1));

      
      Initialize_Fields_For_Def_Id
        (Self => Transform_Res43);



elsif Row_Pos48 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags43);
end if;

--  END <Transform(<ASTNodeType DefId>) (root of 'env_spec_decl') at parser.lkt:231:9>




if Row_Pos48 /= No_Token_Index then

   Row_Pos47 := Row_Pos48;

else
   Row_Pos47 := No_Token_Index;
   goto Exit_Row47_0;

end if;


--  BEGIN <Token(<WithText LBrace>, ) (root of 'env_spec_decl') at parser.lkt:231:40>

Token_Res60 := Row_Pos47;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res60));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_L_Brace)
   then
       Token_Pos60 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos47 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos47,
             Expected_Token_Id => Lkt_L_Brace,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos60 := Row_Pos47 + 1;
   end if;
end;

--  END <Token(<WithText LBrace>, ) (root of 'env_spec_decl') at parser.lkt:231:40>




if Token_Pos60 /= No_Token_Index then

   Row_Pos47 := Token_Pos60;

else
   Row_Pos47 := No_Token_Index;
   goto Exit_Row47_0;

end if;


--  BEGIN <List (root of 'env_spec_decl') at parser.lkt:231:44>

    List_Pos7 := Row_Pos47;



Lst_Cpos7 := Row_Pos47;
Tmp_List7 := Get_Parse_List (Parser);


loop
   
--  BEGIN <Defer (for 'env_spec_action') at parser.lkt:231:50>

Defer_Res69 :=
   Env_Spec_Action_Transform_Parse1 (Parser, Lst_Cpos7);
Defer_Pos69 := Parser.Current_Pos;

--  END <Defer (for 'env_spec_action') at parser.lkt:231:50>


   exit when Defer_Pos69 = No_Token_Index;

   List_Pos7 := Defer_Pos69;
   Lst_Cpos7 := List_Pos7;

   Tmp_List7.Nodes.Append (Defer_Res69);

end loop;


declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List7.Nodes.Length;
begin
   List_Res7 := Allocate_Call_Expr_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Row_Pos47;
      Token_End := (if Lst_Cpos7 = Row_Pos47
                    then Row_Pos47
                    else List_Pos7 - 1);

   else
      Token_Start := Token_Index'Max (Row_Pos47, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res7,
      Kind              => Lkt_Call_Expr_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res7,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_Lkt_Node_Vectors.Vector renames
         Tmp_List7.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res7.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List7);

--  END <List (root of 'env_spec_decl') at parser.lkt:231:44>




if List_Pos7 /= No_Token_Index then

   Row_Pos47 := List_Pos7;

else
   Row_Pos47 := No_Token_Index;
   goto Exit_Row47_0;

end if;


--  BEGIN <Token(<WithText RBrace>, ) (root of 'env_spec_decl') at parser.lkt:231:67>

Token_Res61 := Row_Pos47;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res61));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_R_Brace)
   then
       Token_Pos61 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos47 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos47,
             Expected_Token_Id => Lkt_R_Brace,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos61 := Row_Pos47 + 1;
   end if;
end;

--  END <Token(<WithText RBrace>, ) (root of 'env_spec_decl') at parser.lkt:231:67>




if Token_Pos61 /= No_Token_Index then

   Row_Pos47 := Token_Pos61;

else
   Row_Pos47 := No_Token_Index;
   goto Exit_Row47_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row47_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'env_spec_decl') at parser.lkt:230:22>



if Row_Pos47 /= No_Token_Index then

   Transform_Res44 := Allocate_Env_Spec_Decl (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res44,
      Kind => Lkt_Env_Spec_Decl,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos47 = Pos
                            then No_Token_Index
                            else Row_Pos47 - 1));

      
      Initialize_Fields_For_Env_Spec_Decl
        (Self => Transform_Res44,
         Env_Spec_Decl_F_Syn_Name => Transform_Res43,
         Env_Spec_Decl_F_Actions => List_Res7);

         if Transform_Res43 /= null and then Is_Incomplete (Transform_Res43) then
            Transform_Res44.Last_Attempted_Child := 0;
         elsif Transform_Res43 /= null and then not Is_Ghost (Transform_Res43) then
            Transform_Res44.Last_Attempted_Child := -1;
         end if;
         if List_Res7 /= null and then Is_Incomplete (List_Res7) then
            Transform_Res44.Last_Attempted_Child := 0;
         elsif List_Res7 /= null and then not Is_Ghost (List_Res7) then
            Transform_Res44.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos47 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags44);
end if;

--  END <Transform(<ASTNodeType EnvSpecDecl>) (root of 'env_spec_decl') at parser.lkt:230:22>


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (PP.Env_Spec_Decl_Transform_Parse1_Memo,
      Row_Pos47 /= No_Token_Index,
      Transform_Res44,
      Pos,
      Row_Pos47);


   Parser.Current_Pos := Row_Pos47;

   return Transform_Res44;
end Env_Spec_Decl_Transform_Parse1;

   


function Eq_Or_Parse1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr
is
   use Bare_Expr_Memos;

      Row_Pos49 :
            Token_Index
               := No_Token_Index;
      Defer_Pos70 :
            Token_Index
               := No_Token_Index;
      Defer_Res70 :
            Bare_Expr
               := No_Bare_Lkt_Node;
      Row_Pos50 :
            Token_Index
               := No_Token_Index;
      Token_Pos62 :
            Token_Index
               := No_Token_Index;
      Token_Res62 :
            Token_Index
               := No_Token_Index;
      Transform_Res45 :
            Bare_Op_Lte
               := No_Bare_Lkt_Node;
      Transform_Diags45 :
            Ada.Containers.Count_Type;
      Row_Pos51 :
            Token_Index
               := No_Token_Index;
      Token_Pos63 :
            Token_Index
               := No_Token_Index;
      Token_Res63 :
            Token_Index
               := No_Token_Index;
      Transform_Res46 :
            Bare_Op_Lt
               := No_Bare_Lkt_Node;
      Transform_Diags46 :
            Ada.Containers.Count_Type;
      Row_Pos52 :
            Token_Index
               := No_Token_Index;
      Token_Pos64 :
            Token_Index
               := No_Token_Index;
      Token_Res64 :
            Token_Index
               := No_Token_Index;
      Transform_Res47 :
            Bare_Op_Gte
               := No_Bare_Lkt_Node;
      Transform_Diags47 :
            Ada.Containers.Count_Type;
      Row_Pos53 :
            Token_Index
               := No_Token_Index;
      Token_Pos65 :
            Token_Index
               := No_Token_Index;
      Token_Res65 :
            Token_Index
               := No_Token_Index;
      Transform_Res48 :
            Bare_Op_Gt
               := No_Bare_Lkt_Node;
      Transform_Diags48 :
            Ada.Containers.Count_Type;
      Row_Pos54 :
            Token_Index
               := No_Token_Index;
      Token_Pos66 :
            Token_Index
               := No_Token_Index;
      Token_Res66 :
            Token_Index
               := No_Token_Index;
      Transform_Res49 :
            Bare_Op_Eq
               := No_Bare_Lkt_Node;
      Transform_Diags49 :
            Ada.Containers.Count_Type;
      Row_Pos55 :
            Token_Index
               := No_Token_Index;
      Token_Pos67 :
            Token_Index
               := No_Token_Index;
      Token_Res67 :
            Token_Index
               := No_Token_Index;
      Transform_Res50 :
            Bare_Op_Ne
               := No_Bare_Lkt_Node;
      Transform_Diags50 :
            Ada.Containers.Count_Type;
      Or_Pos13 :
            Token_Index
               := No_Token_Index;
      Or_Res13 :
            Bare_Op
               := No_Bare_Lkt_Node;
      Defer_Pos71 :
            Token_Index
               := No_Token_Index;
      Defer_Res71 :
            Bare_Expr
               := No_Bare_Lkt_Node;
      Transform_Res51 :
            Bare_Bin_Op
               := No_Bare_Lkt_Node;
      Transform_Diags51 :
            Ada.Containers.Count_Type;
      Defer_Pos72 :
            Token_Index
               := No_Token_Index;
      Defer_Res72 :
            Bare_Expr
               := No_Bare_Lkt_Node;
      Or_Pos14 :
            Token_Index
               := No_Token_Index;
      Or_Res14 :
            Bare_Expr
               := No_Bare_Lkt_Node;

      Mem_Pos : Token_Index := Pos;
      Mem_Res : Bare_Expr := No_Bare_Lkt_Node;

   PP : constant Parser_Private_Part := +Parser.Private_Part;
   M  : Memo_Entry := Get (PP.Eq_Or_Parse1_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Or_Res14 := M.Instance;
      return Or_Res14;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Or_Res14;
   end if;

       Set (PP.Eq_Or_Parse1_Memo, False, Or_Res14, Pos, Mem_Pos);

       <<Try_Again>>



   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  BEGIN <Or (root of 'eq') at parser.lkt:308:11>

Or_Pos14 := No_Token_Index;
Or_Res14 := No_Bare_Lkt_Node;
    
--  BEGIN <Transform(<ASTNodeType BinOp>) (root of 'eq') at parser.lkt:309:11>

Transform_Diags51 := Parser.Diagnostics.Length;


--  BEGIN <_Row (root of 'eq') at parser.lkt:309:11>

Row_Pos49 := Pos;



--  BEGIN <Defer (for 'eq') at parser.lkt:310:13>

Defer_Res70 :=
   Eq_Or_Parse1 (Parser, Row_Pos49);
Defer_Pos70 := Parser.Current_Pos;

--  END <Defer (for 'eq') at parser.lkt:310:13>




if Defer_Pos70 /= No_Token_Index then

   Row_Pos49 := Defer_Pos70;

else
   Row_Pos49 := No_Token_Index;
   goto Exit_Row49_0;

end if;


--  BEGIN <Or (root of 'eq') at parser.lkt:311:13>

Or_Pos13 := No_Token_Index;
Or_Res13 := No_Bare_Lkt_Node;
    
--  BEGIN <Transform(<ASTNodeType Op.Lte>) (root of 'eq') at parser.lkt:312:19>

Transform_Diags45 := Parser.Diagnostics.Length;


--  BEGIN <_Row (root of 'eq') at parser.lkt:312:19>

Row_Pos50 := Row_Pos49;



--  BEGIN <Token(<WithText LTE>, ) (root of 'eq') at parser.lkt:312:26>

Token_Res62 := Row_Pos50;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res62));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_L_T_E)
   then
       Token_Pos62 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos50 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos50,
             Expected_Token_Id => Lkt_L_T_E,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos62 := Row_Pos50 + 1;
   end if;
end;

--  END <Token(<WithText LTE>, ) (root of 'eq') at parser.lkt:312:26>




if Token_Pos62 /= No_Token_Index then

   Row_Pos50 := Token_Pos62;

else
   Row_Pos50 := No_Token_Index;
   goto Exit_Row50_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row50_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'eq') at parser.lkt:312:19>



if Row_Pos50 /= No_Token_Index then

   Transform_Res45 := Allocate_Op_Lte (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res45,
      Kind => Lkt_Op_Lte,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos49,
      Token_End_Index   => (if Row_Pos50 = Row_Pos49
                            then No_Token_Index
                            else Row_Pos50 - 1));




elsif Row_Pos50 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags45);
end if;

--  END <Transform(<ASTNodeType Op.Lte>) (root of 'eq') at parser.lkt:312:19>

    if Row_Pos50 /= No_Token_Index then
        Or_Pos13 := Row_Pos50;
        Or_Res13 := Transform_Res45;
        goto Exit_Or15;
    end if;
    
--  BEGIN <Transform(<ASTNodeType Op.Lt>) (root of 'eq') at parser.lkt:313:19>

Transform_Diags46 := Parser.Diagnostics.Length;


--  BEGIN <_Row (root of 'eq') at parser.lkt:313:19>

Row_Pos51 := Row_Pos49;



--  BEGIN <Token(<WithText LT>, ) (root of 'eq') at parser.lkt:313:25>

Token_Res63 := Row_Pos51;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res63));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_L_T)
   then
       Token_Pos63 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos51 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos51,
             Expected_Token_Id => Lkt_L_T,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos63 := Row_Pos51 + 1;
   end if;
end;

--  END <Token(<WithText LT>, ) (root of 'eq') at parser.lkt:313:25>




if Token_Pos63 /= No_Token_Index then

   Row_Pos51 := Token_Pos63;

else
   Row_Pos51 := No_Token_Index;
   goto Exit_Row51_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row51_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'eq') at parser.lkt:313:19>



if Row_Pos51 /= No_Token_Index then

   Transform_Res46 := Allocate_Op_Lt (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res46,
      Kind => Lkt_Op_Lt,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos49,
      Token_End_Index   => (if Row_Pos51 = Row_Pos49
                            then No_Token_Index
                            else Row_Pos51 - 1));




elsif Row_Pos51 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags46);
end if;

--  END <Transform(<ASTNodeType Op.Lt>) (root of 'eq') at parser.lkt:313:19>

    if Row_Pos51 /= No_Token_Index then
        Or_Pos13 := Row_Pos51;
        Or_Res13 := Transform_Res46;
        goto Exit_Or15;
    end if;
    
--  BEGIN <Transform(<ASTNodeType Op.Gte>) (root of 'eq') at parser.lkt:314:19>

Transform_Diags47 := Parser.Diagnostics.Length;


--  BEGIN <_Row (root of 'eq') at parser.lkt:314:19>

Row_Pos52 := Row_Pos49;



--  BEGIN <Token(<WithText GTE>, ) (root of 'eq') at parser.lkt:314:26>

Token_Res64 := Row_Pos52;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res64));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_G_T_E)
   then
       Token_Pos64 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos52 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos52,
             Expected_Token_Id => Lkt_G_T_E,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos64 := Row_Pos52 + 1;
   end if;
end;

--  END <Token(<WithText GTE>, ) (root of 'eq') at parser.lkt:314:26>




if Token_Pos64 /= No_Token_Index then

   Row_Pos52 := Token_Pos64;

else
   Row_Pos52 := No_Token_Index;
   goto Exit_Row52_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row52_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'eq') at parser.lkt:314:19>



if Row_Pos52 /= No_Token_Index then

   Transform_Res47 := Allocate_Op_Gte (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res47,
      Kind => Lkt_Op_Gte,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos49,
      Token_End_Index   => (if Row_Pos52 = Row_Pos49
                            then No_Token_Index
                            else Row_Pos52 - 1));




elsif Row_Pos52 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags47);
end if;

--  END <Transform(<ASTNodeType Op.Gte>) (root of 'eq') at parser.lkt:314:19>

    if Row_Pos52 /= No_Token_Index then
        Or_Pos13 := Row_Pos52;
        Or_Res13 := Transform_Res47;
        goto Exit_Or15;
    end if;
    
--  BEGIN <Transform(<ASTNodeType Op.Gt>) (root of 'eq') at parser.lkt:315:19>

Transform_Diags48 := Parser.Diagnostics.Length;


--  BEGIN <_Row (root of 'eq') at parser.lkt:315:19>

Row_Pos53 := Row_Pos49;



--  BEGIN <Token(<WithText GT>, ) (root of 'eq') at parser.lkt:315:25>

Token_Res65 := Row_Pos53;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res65));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_G_T)
   then
       Token_Pos65 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos53 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos53,
             Expected_Token_Id => Lkt_G_T,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos65 := Row_Pos53 + 1;
   end if;
end;

--  END <Token(<WithText GT>, ) (root of 'eq') at parser.lkt:315:25>




if Token_Pos65 /= No_Token_Index then

   Row_Pos53 := Token_Pos65;

else
   Row_Pos53 := No_Token_Index;
   goto Exit_Row53_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row53_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'eq') at parser.lkt:315:19>



if Row_Pos53 /= No_Token_Index then

   Transform_Res48 := Allocate_Op_Gt (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res48,
      Kind => Lkt_Op_Gt,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos49,
      Token_End_Index   => (if Row_Pos53 = Row_Pos49
                            then No_Token_Index
                            else Row_Pos53 - 1));




elsif Row_Pos53 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags48);
end if;

--  END <Transform(<ASTNodeType Op.Gt>) (root of 'eq') at parser.lkt:315:19>

    if Row_Pos53 /= No_Token_Index then
        Or_Pos13 := Row_Pos53;
        Or_Res13 := Transform_Res48;
        goto Exit_Or15;
    end if;
    
--  BEGIN <Transform(<ASTNodeType Op.Eq>) (root of 'eq') at parser.lkt:316:19>

Transform_Diags49 := Parser.Diagnostics.Length;


--  BEGIN <_Row (root of 'eq') at parser.lkt:316:19>

Row_Pos54 := Row_Pos49;



--  BEGIN <Token(<WithText EQ>, ) (root of 'eq') at parser.lkt:316:25>

Token_Res66 := Row_Pos54;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res66));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_E_Q)
   then
       Token_Pos66 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos54 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos54,
             Expected_Token_Id => Lkt_E_Q,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos66 := Row_Pos54 + 1;
   end if;
end;

--  END <Token(<WithText EQ>, ) (root of 'eq') at parser.lkt:316:25>




if Token_Pos66 /= No_Token_Index then

   Row_Pos54 := Token_Pos66;

else
   Row_Pos54 := No_Token_Index;
   goto Exit_Row54_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row54_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'eq') at parser.lkt:316:19>



if Row_Pos54 /= No_Token_Index then

   Transform_Res49 := Allocate_Op_Eq (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res49,
      Kind => Lkt_Op_Eq,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos49,
      Token_End_Index   => (if Row_Pos54 = Row_Pos49
                            then No_Token_Index
                            else Row_Pos54 - 1));




elsif Row_Pos54 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags49);
end if;

--  END <Transform(<ASTNodeType Op.Eq>) (root of 'eq') at parser.lkt:316:19>

    if Row_Pos54 /= No_Token_Index then
        Or_Pos13 := Row_Pos54;
        Or_Res13 := Transform_Res49;
        goto Exit_Or15;
    end if;
    
--  BEGIN <Transform(<ASTNodeType Op.Ne>) (root of 'eq') at parser.lkt:317:19>

Transform_Diags50 := Parser.Diagnostics.Length;


--  BEGIN <_Row (root of 'eq') at parser.lkt:317:19>

Row_Pos55 := Row_Pos49;



--  BEGIN <Token(<WithText NE>, ) (root of 'eq') at parser.lkt:317:25>

Token_Res67 := Row_Pos55;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res67));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_N_E)
   then
       Token_Pos67 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos55 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos55,
             Expected_Token_Id => Lkt_N_E,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos67 := Row_Pos55 + 1;
   end if;
end;

--  END <Token(<WithText NE>, ) (root of 'eq') at parser.lkt:317:25>




if Token_Pos67 /= No_Token_Index then

   Row_Pos55 := Token_Pos67;

else
   Row_Pos55 := No_Token_Index;
   goto Exit_Row55_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row55_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'eq') at parser.lkt:317:19>



if Row_Pos55 /= No_Token_Index then

   Transform_Res50 := Allocate_Op_Ne (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res50,
      Kind => Lkt_Op_Ne,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos49,
      Token_End_Index   => (if Row_Pos55 = Row_Pos49
                            then No_Token_Index
                            else Row_Pos55 - 1));




elsif Row_Pos55 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags50);
end if;

--  END <Transform(<ASTNodeType Op.Ne>) (root of 'eq') at parser.lkt:317:19>

    if Row_Pos55 /= No_Token_Index then
        Or_Pos13 := Row_Pos55;
        Or_Res13 := Transform_Res50;
        goto Exit_Or15;
    end if;
<<Exit_Or15>>

--  END <Or (root of 'eq') at parser.lkt:311:13>




if Or_Pos13 /= No_Token_Index then

   Row_Pos49 := Or_Pos13;

else
   Row_Pos49 := No_Token_Index;
   goto Exit_Row49_0;

end if;


--  BEGIN <Defer (for 'arith_1') at parser.lkt:319:13>

Defer_Res71 :=
   Arith_1_Or_Parse1 (Parser, Row_Pos49);
Defer_Pos71 := Parser.Current_Pos;

--  END <Defer (for 'arith_1') at parser.lkt:319:13>




if Defer_Pos71 /= No_Token_Index then

   Row_Pos49 := Defer_Pos71;

else
   Row_Pos49 := No_Token_Index;
   goto Exit_Row49_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row49_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'eq') at parser.lkt:309:11>



if Row_Pos49 /= No_Token_Index then

   Transform_Res51 := Allocate_Bin_Op (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res51,
      Kind => Lkt_Bin_Op,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos49 = Pos
                            then No_Token_Index
                            else Row_Pos49 - 1));

      
      Initialize_Fields_For_Bin_Op
        (Self => Transform_Res51,
         Bin_Op_F_Left => Defer_Res70,
         Bin_Op_F_Op => Or_Res13,
         Bin_Op_F_Right => Defer_Res71);

         if Defer_Res70 /= null and then Is_Incomplete (Defer_Res70) then
            Transform_Res51.Last_Attempted_Child := 0;
         elsif Defer_Res70 /= null and then not Is_Ghost (Defer_Res70) then
            Transform_Res51.Last_Attempted_Child := -1;
         end if;
         if Or_Res13 /= null and then Is_Incomplete (Or_Res13) then
            Transform_Res51.Last_Attempted_Child := 0;
         elsif Or_Res13 /= null and then not Is_Ghost (Or_Res13) then
            Transform_Res51.Last_Attempted_Child := -1;
         end if;
         if Defer_Res71 /= null and then Is_Incomplete (Defer_Res71) then
            Transform_Res51.Last_Attempted_Child := 0;
         elsif Defer_Res71 /= null and then not Is_Ghost (Defer_Res71) then
            Transform_Res51.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos49 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags51);
end if;

--  END <Transform(<ASTNodeType BinOp>) (root of 'eq') at parser.lkt:309:11>

    if Row_Pos49 /= No_Token_Index then
        Or_Pos14 := Row_Pos49;
        Or_Res14 := Transform_Res51;
        goto Exit_Or14;
    end if;
    
--  BEGIN <Defer (for 'arith_1') at parser.lkt:321:11>

Defer_Res72 :=
   Arith_1_Or_Parse1 (Parser, Pos);
Defer_Pos72 := Parser.Current_Pos;

--  END <Defer (for 'arith_1') at parser.lkt:321:11>

    if Defer_Pos72 /= No_Token_Index then
        Or_Pos14 := Defer_Pos72;
        Or_Res14 := Defer_Res72;
        goto Exit_Or14;
    end if;
<<Exit_Or14>>

--  END <Or (root of 'eq') at parser.lkt:308:11>


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------

      if Or_Pos14 > Mem_Pos then
         Mem_Pos := Or_Pos14;
         Mem_Res := Or_Res14;
         Set
           (PP.Eq_Or_Parse1_Memo,
            Or_Pos14 /= No_Token_Index,
            Or_Res14,
            Pos,
            Or_Pos14);
         goto Try_Again;

      elsif Mem_Pos > Pos then
         Or_Res14 := Mem_Res;
         Or_Pos14 := Mem_Pos;
         goto No_Memo;
      end if;

   Set
     (PP.Eq_Or_Parse1_Memo,
      Or_Pos14 /= No_Token_Index,
      Or_Res14,
      Pos,
      Or_Pos14);

       <<No_Memo>>

   Parser.Current_Pos := Or_Pos14;

   return Or_Res14;
end Eq_Or_Parse1;

   


function Expr_Or_Parse1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr
is
   use Bare_Expr_Memos;

      Row_Pos56 :
            Token_Index
               := No_Token_Index;
      Defer_Pos73 :
            Token_Index
               := No_Token_Index;
      Defer_Res73 :
            Bare_Expr
               := No_Bare_Lkt_Node;
      Row_Pos57 :
            Token_Index
               := No_Token_Index;
      Token_Pos68 :
            Token_Index
               := No_Token_Index;
      Token_Res68 :
            Token_Index
               := No_Token_Index;
      Token_Pos69 :
            Token_Index
               := No_Token_Index;
      Token_Res69 :
            Token_Index
               := No_Token_Index;
      Transform_Res52 :
            Bare_Op_Or_Int
               := No_Bare_Lkt_Node;
      Transform_Diags52 :
            Ada.Containers.Count_Type;
      Row_Pos58 :
            Token_Index
               := No_Token_Index;
      Token_Pos70 :
            Token_Index
               := No_Token_Index;
      Token_Res70 :
            Token_Index
               := No_Token_Index;
      Transform_Res53 :
            Bare_Op_Or
               := No_Bare_Lkt_Node;
      Transform_Diags53 :
            Ada.Containers.Count_Type;
      Row_Pos59 :
            Token_Index
               := No_Token_Index;
      Token_Pos71 :
            Token_Index
               := No_Token_Index;
      Token_Res71 :
            Token_Index
               := No_Token_Index;
      Transform_Res54 :
            Bare_Op_And
               := No_Bare_Lkt_Node;
      Transform_Diags54 :
            Ada.Containers.Count_Type;
      Row_Pos60 :
            Token_Index
               := No_Token_Index;
      Token_Pos72 :
            Token_Index
               := No_Token_Index;
      Token_Res72 :
            Token_Index
               := No_Token_Index;
      Token_Pos73 :
            Token_Index
               := No_Token_Index;
      Token_Res73 :
            Token_Index
               := No_Token_Index;
      Transform_Res55 :
            Bare_Op_Logic_And
               := No_Bare_Lkt_Node;
      Transform_Diags55 :
            Ada.Containers.Count_Type;
      Row_Pos61 :
            Token_Index
               := No_Token_Index;
      Token_Pos74 :
            Token_Index
               := No_Token_Index;
      Token_Res74 :
            Token_Index
               := No_Token_Index;
      Token_Pos75 :
            Token_Index
               := No_Token_Index;
      Token_Res75 :
            Token_Index
               := No_Token_Index;
      Transform_Res56 :
            Bare_Op_Logic_Or
               := No_Bare_Lkt_Node;
      Transform_Diags56 :
            Ada.Containers.Count_Type;
      Or_Pos15 :
            Token_Index
               := No_Token_Index;
      Or_Res15 :
            Bare_Op
               := No_Bare_Lkt_Node;
      Defer_Pos74 :
            Token_Index
               := No_Token_Index;
      Defer_Res74 :
            Bare_Expr
               := No_Bare_Lkt_Node;
      Transform_Res57 :
            Bare_Bin_Op
               := No_Bare_Lkt_Node;
      Transform_Diags57 :
            Ada.Containers.Count_Type;
      Defer_Pos75 :
            Token_Index
               := No_Token_Index;
      Defer_Res75 :
            Bare_Expr
               := No_Bare_Lkt_Node;
      Or_Pos16 :
            Token_Index
               := No_Token_Index;
      Or_Res16 :
            Bare_Expr
               := No_Bare_Lkt_Node;

      Mem_Pos : Token_Index := Pos;
      Mem_Res : Bare_Expr := No_Bare_Lkt_Node;

   PP : constant Parser_Private_Part := +Parser.Private_Part;
   M  : Memo_Entry := Get (PP.Expr_Or_Parse1_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Or_Res16 := M.Instance;
      return Or_Res16;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Or_Res16;
   end if;

       Set (PP.Expr_Or_Parse1_Memo, False, Or_Res16, Pos, Mem_Pos);

       <<Try_Again>>



   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  BEGIN <Or (root of 'expr') at parser.lkt:293:13>

Or_Pos16 := No_Token_Index;
Or_Res16 := No_Bare_Lkt_Node;
    
--  BEGIN <Transform(<ASTNodeType BinOp>) (root of 'expr') at parser.lkt:294:11>

Transform_Diags57 := Parser.Diagnostics.Length;


--  BEGIN <_Row (root of 'expr') at parser.lkt:294:11>

Row_Pos56 := Pos;



--  BEGIN <Defer (for 'expr') at parser.lkt:295:13>

Defer_Res73 :=
   Expr_Or_Parse1 (Parser, Row_Pos56);
Defer_Pos73 := Parser.Current_Pos;

--  END <Defer (for 'expr') at parser.lkt:295:13>




if Defer_Pos73 /= No_Token_Index then

   Row_Pos56 := Defer_Pos73;

else
   Row_Pos56 := No_Token_Index;
   goto Exit_Row56_0;

end if;


--  BEGIN <Or (root of 'expr') at parser.lkt:296:13>

Or_Pos15 := No_Token_Index;
Or_Res15 := No_Bare_Lkt_Node;
    
--  BEGIN <Transform(<ASTNodeType Op.OrInt>) (root of 'expr') at parser.lkt:297:19>

Transform_Diags52 := Parser.Diagnostics.Length;


--  BEGIN <_Row (root of 'expr') at parser.lkt:297:19>

Row_Pos57 := Row_Pos56;



--  BEGIN <Token(<WithText OrKw>, ) (root of 'expr') at parser.lkt:297:28>

Token_Res68 := Row_Pos57;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res68));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_Or_Kw)
   then
       Token_Pos68 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos57 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos57,
             Expected_Token_Id => Lkt_Or_Kw,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos68 := Row_Pos57 + 1;
   end if;
end;

--  END <Token(<WithText OrKw>, ) (root of 'expr') at parser.lkt:297:28>




if Token_Pos68 /= No_Token_Index then

   Row_Pos57 := Token_Pos68;

else
   Row_Pos57 := No_Token_Index;
   goto Exit_Row57_0;

end if;


--  BEGIN <Token(<WithText IntMark>, ) (root of 'expr') at parser.lkt:297:33>

Token_Res69 := Row_Pos57;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res69));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_Int_Mark)
   then
       Token_Pos69 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos57 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos57,
             Expected_Token_Id => Lkt_Int_Mark,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos69 := Row_Pos57 + 1;
   end if;
end;

--  END <Token(<WithText IntMark>, ) (root of 'expr') at parser.lkt:297:33>




if Token_Pos69 /= No_Token_Index then

   Row_Pos57 := Token_Pos69;

else
   Row_Pos57 := No_Token_Index;
   goto Exit_Row57_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row57_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'expr') at parser.lkt:297:19>



if Row_Pos57 /= No_Token_Index then

   Transform_Res52 := Allocate_Op_Or_Int (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res52,
      Kind => Lkt_Op_Or_Int,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos56,
      Token_End_Index   => (if Row_Pos57 = Row_Pos56
                            then No_Token_Index
                            else Row_Pos57 - 1));




elsif Row_Pos57 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags52);
end if;

--  END <Transform(<ASTNodeType Op.OrInt>) (root of 'expr') at parser.lkt:297:19>

    if Row_Pos57 /= No_Token_Index then
        Or_Pos15 := Row_Pos57;
        Or_Res15 := Transform_Res52;
        goto Exit_Or17;
    end if;
    
--  BEGIN <Transform(<ASTNodeType Op.Or>) (root of 'expr') at parser.lkt:298:19>

Transform_Diags53 := Parser.Diagnostics.Length;


--  BEGIN <_Row (root of 'expr') at parser.lkt:298:19>

Row_Pos58 := Row_Pos56;



--  BEGIN <Token(<WithText OrKw>, ) (root of 'expr') at parser.lkt:298:25>

Token_Res70 := Row_Pos58;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res70));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_Or_Kw)
   then
       Token_Pos70 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos58 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos58,
             Expected_Token_Id => Lkt_Or_Kw,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos70 := Row_Pos58 + 1;
   end if;
end;

--  END <Token(<WithText OrKw>, ) (root of 'expr') at parser.lkt:298:25>




if Token_Pos70 /= No_Token_Index then

   Row_Pos58 := Token_Pos70;

else
   Row_Pos58 := No_Token_Index;
   goto Exit_Row58_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row58_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'expr') at parser.lkt:298:19>



if Row_Pos58 /= No_Token_Index then

   Transform_Res53 := Allocate_Op_Or (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res53,
      Kind => Lkt_Op_Or,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos56,
      Token_End_Index   => (if Row_Pos58 = Row_Pos56
                            then No_Token_Index
                            else Row_Pos58 - 1));




elsif Row_Pos58 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags53);
end if;

--  END <Transform(<ASTNodeType Op.Or>) (root of 'expr') at parser.lkt:298:19>

    if Row_Pos58 /= No_Token_Index then
        Or_Pos15 := Row_Pos58;
        Or_Res15 := Transform_Res53;
        goto Exit_Or17;
    end if;
    
--  BEGIN <Transform(<ASTNodeType Op.And>) (root of 'expr') at parser.lkt:299:19>

Transform_Diags54 := Parser.Diagnostics.Length;


--  BEGIN <_Row (root of 'expr') at parser.lkt:299:19>

Row_Pos59 := Row_Pos56;



--  BEGIN <Token(<WithText AndKw>, ) (root of 'expr') at parser.lkt:299:26>

Token_Res71 := Row_Pos59;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res71));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_And_Kw)
   then
       Token_Pos71 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos59 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos59,
             Expected_Token_Id => Lkt_And_Kw,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos71 := Row_Pos59 + 1;
   end if;
end;

--  END <Token(<WithText AndKw>, ) (root of 'expr') at parser.lkt:299:26>




if Token_Pos71 /= No_Token_Index then

   Row_Pos59 := Token_Pos71;

else
   Row_Pos59 := No_Token_Index;
   goto Exit_Row59_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row59_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'expr') at parser.lkt:299:19>



if Row_Pos59 /= No_Token_Index then

   Transform_Res54 := Allocate_Op_And (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res54,
      Kind => Lkt_Op_And,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos56,
      Token_End_Index   => (if Row_Pos59 = Row_Pos56
                            then No_Token_Index
                            else Row_Pos59 - 1));




elsif Row_Pos59 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags54);
end if;

--  END <Transform(<ASTNodeType Op.And>) (root of 'expr') at parser.lkt:299:19>

    if Row_Pos59 /= No_Token_Index then
        Or_Pos15 := Row_Pos59;
        Or_Res15 := Transform_Res54;
        goto Exit_Or17;
    end if;
    
--  BEGIN <Transform(<ASTNodeType Op.LogicAnd>) (root of 'expr') at parser.lkt:300:19>

Transform_Diags55 := Parser.Diagnostics.Length;


--  BEGIN <_Row (root of 'expr') at parser.lkt:300:19>

Row_Pos60 := Row_Pos56;



--  BEGIN <Token(<WithText Percent>, ) (root of 'expr') at parser.lkt:300:31>

Token_Res72 := Row_Pos60;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res72));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_Percent)
   then
       Token_Pos72 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos60 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos60,
             Expected_Token_Id => Lkt_Percent,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos72 := Row_Pos60 + 1;
   end if;
end;

--  END <Token(<WithText Percent>, ) (root of 'expr') at parser.lkt:300:31>




if Token_Pos72 /= No_Token_Index then

   Row_Pos60 := Token_Pos72;

else
   Row_Pos60 := No_Token_Index;
   goto Exit_Row60_0;

end if;


--  BEGIN <Token(<WithText AndKw>, ) (root of 'expr') at parser.lkt:300:35>

Token_Res73 := Row_Pos60;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res73));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_And_Kw)
   then
       Token_Pos73 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos60 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos60,
             Expected_Token_Id => Lkt_And_Kw,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos73 := Row_Pos60 + 1;
   end if;
end;

--  END <Token(<WithText AndKw>, ) (root of 'expr') at parser.lkt:300:35>




if Token_Pos73 /= No_Token_Index then

   Row_Pos60 := Token_Pos73;

else
   Row_Pos60 := No_Token_Index;
   goto Exit_Row60_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row60_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'expr') at parser.lkt:300:19>



if Row_Pos60 /= No_Token_Index then

   Transform_Res55 := Allocate_Op_Logic_And (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res55,
      Kind => Lkt_Op_Logic_And,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos56,
      Token_End_Index   => (if Row_Pos60 = Row_Pos56
                            then No_Token_Index
                            else Row_Pos60 - 1));




elsif Row_Pos60 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags55);
end if;

--  END <Transform(<ASTNodeType Op.LogicAnd>) (root of 'expr') at parser.lkt:300:19>

    if Row_Pos60 /= No_Token_Index then
        Or_Pos15 := Row_Pos60;
        Or_Res15 := Transform_Res55;
        goto Exit_Or17;
    end if;
    
--  BEGIN <Transform(<ASTNodeType Op.LogicOr>) (root of 'expr') at parser.lkt:301:19>

Transform_Diags56 := Parser.Diagnostics.Length;


--  BEGIN <_Row (root of 'expr') at parser.lkt:301:19>

Row_Pos61 := Row_Pos56;



--  BEGIN <Token(<WithText Percent>, ) (root of 'expr') at parser.lkt:301:30>

Token_Res74 := Row_Pos61;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res74));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_Percent)
   then
       Token_Pos74 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos61 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos61,
             Expected_Token_Id => Lkt_Percent,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos74 := Row_Pos61 + 1;
   end if;
end;

--  END <Token(<WithText Percent>, ) (root of 'expr') at parser.lkt:301:30>




if Token_Pos74 /= No_Token_Index then

   Row_Pos61 := Token_Pos74;

else
   Row_Pos61 := No_Token_Index;
   goto Exit_Row61_0;

end if;


--  BEGIN <Token(<WithText OrKw>, ) (root of 'expr') at parser.lkt:301:34>

Token_Res75 := Row_Pos61;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res75));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_Or_Kw)
   then
       Token_Pos75 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos61 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos61,
             Expected_Token_Id => Lkt_Or_Kw,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos75 := Row_Pos61 + 1;
   end if;
end;

--  END <Token(<WithText OrKw>, ) (root of 'expr') at parser.lkt:301:34>




if Token_Pos75 /= No_Token_Index then

   Row_Pos61 := Token_Pos75;

else
   Row_Pos61 := No_Token_Index;
   goto Exit_Row61_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row61_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'expr') at parser.lkt:301:19>



if Row_Pos61 /= No_Token_Index then

   Transform_Res56 := Allocate_Op_Logic_Or (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res56,
      Kind => Lkt_Op_Logic_Or,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos56,
      Token_End_Index   => (if Row_Pos61 = Row_Pos56
                            then No_Token_Index
                            else Row_Pos61 - 1));




elsif Row_Pos61 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags56);
end if;

--  END <Transform(<ASTNodeType Op.LogicOr>) (root of 'expr') at parser.lkt:301:19>

    if Row_Pos61 /= No_Token_Index then
        Or_Pos15 := Row_Pos61;
        Or_Res15 := Transform_Res56;
        goto Exit_Or17;
    end if;
<<Exit_Or17>>

--  END <Or (root of 'expr') at parser.lkt:296:13>




if Or_Pos15 /= No_Token_Index then

   Row_Pos56 := Or_Pos15;

else
   Row_Pos56 := No_Token_Index;
   goto Exit_Row56_0;

end if;


--  BEGIN <Defer (for 'rel') at parser.lkt:303:13>

Defer_Res74 :=
   Rel_Or_Parse0 (Parser, Row_Pos56);
Defer_Pos74 := Parser.Current_Pos;

--  END <Defer (for 'rel') at parser.lkt:303:13>




if Defer_Pos74 /= No_Token_Index then

   Row_Pos56 := Defer_Pos74;

else
   Row_Pos56 := No_Token_Index;
   goto Exit_Row56_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row56_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'expr') at parser.lkt:294:11>



if Row_Pos56 /= No_Token_Index then

   Transform_Res57 := Allocate_Bin_Op (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res57,
      Kind => Lkt_Bin_Op,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos56 = Pos
                            then No_Token_Index
                            else Row_Pos56 - 1));

      
      Initialize_Fields_For_Bin_Op
        (Self => Transform_Res57,
         Bin_Op_F_Left => Defer_Res73,
         Bin_Op_F_Op => Or_Res15,
         Bin_Op_F_Right => Defer_Res74);

         if Defer_Res73 /= null and then Is_Incomplete (Defer_Res73) then
            Transform_Res57.Last_Attempted_Child := 0;
         elsif Defer_Res73 /= null and then not Is_Ghost (Defer_Res73) then
            Transform_Res57.Last_Attempted_Child := -1;
         end if;
         if Or_Res15 /= null and then Is_Incomplete (Or_Res15) then
            Transform_Res57.Last_Attempted_Child := 0;
         elsif Or_Res15 /= null and then not Is_Ghost (Or_Res15) then
            Transform_Res57.Last_Attempted_Child := -1;
         end if;
         if Defer_Res74 /= null and then Is_Incomplete (Defer_Res74) then
            Transform_Res57.Last_Attempted_Child := 0;
         elsif Defer_Res74 /= null and then not Is_Ghost (Defer_Res74) then
            Transform_Res57.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos56 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags57);
end if;

--  END <Transform(<ASTNodeType BinOp>) (root of 'expr') at parser.lkt:294:11>

    if Row_Pos56 /= No_Token_Index then
        Or_Pos16 := Row_Pos56;
        Or_Res16 := Transform_Res57;
        goto Exit_Or16;
    end if;
    
--  BEGIN <Defer (for 'rel') at parser.lkt:305:11>

Defer_Res75 :=
   Rel_Or_Parse0 (Parser, Pos);
Defer_Pos75 := Parser.Current_Pos;

--  END <Defer (for 'rel') at parser.lkt:305:11>

    if Defer_Pos75 /= No_Token_Index then
        Or_Pos16 := Defer_Pos75;
        Or_Res16 := Defer_Res75;
        goto Exit_Or16;
    end if;
<<Exit_Or16>>

--  END <Or (root of 'expr') at parser.lkt:293:13>


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------

      if Or_Pos16 > Mem_Pos then
         Mem_Pos := Or_Pos16;
         Mem_Res := Or_Res16;
         Set
           (PP.Expr_Or_Parse1_Memo,
            Or_Pos16 /= No_Token_Index,
            Or_Res16,
            Pos,
            Or_Pos16);
         goto Try_Again;

      elsif Mem_Pos > Pos then
         Or_Res16 := Mem_Res;
         Or_Pos16 := Mem_Pos;
         goto No_Memo;
      end if;

   Set
     (PP.Expr_Or_Parse1_Memo,
      Or_Pos16 /= No_Token_Index,
      Or_Res16,
      Pos,
      Or_Pos16);

       <<No_Memo>>

   Parser.Current_Pos := Or_Pos16;

   return Or_Res16;
end Expr_Or_Parse1;

   


function Field_Decl_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Field_Decl
is
   use Bare_Field_Decl_Memos;

      Row_Pos62 :
            Token_Index
               := No_Token_Index;
      Defer_Pos76 :
            Token_Index
               := No_Token_Index;
      Defer_Res76 :
            Bare_Def_Id
               := No_Bare_Lkt_Node;
      Token_Pos76 :
            Token_Index
               := No_Token_Index;
      Token_Res76 :
            Token_Index
               := No_Token_Index;
      Defer_Pos77 :
            Token_Index
               := No_Token_Index;
      Defer_Res77 :
            Bare_Type_Ref
               := No_Bare_Lkt_Node;
      Row_Pos63 :
            Token_Index
               := No_Token_Index;
      Token_Pos77 :
            Token_Index
               := No_Token_Index;
      Token_Res77 :
            Token_Index
               := No_Token_Index;
      Defer_Pos78 :
            Token_Index
               := No_Token_Index;
      Defer_Res78 :
            Bare_Dot_Expr
               := No_Bare_Lkt_Node;
      Row_Pos64 :
            Token_Index
               := No_Token_Index;
      Token_Pos78 :
            Token_Index
               := No_Token_Index;
      Token_Res78 :
            Token_Index
               := No_Token_Index;
      Defer_Pos79 :
            Token_Index
               := No_Token_Index;
      Defer_Res79 :
            Bare_Expr
               := No_Bare_Lkt_Node;
      Transform_Res58 :
            Bare_Field_Decl
               := No_Bare_Lkt_Node;
      Transform_Diags58 :
            Ada.Containers.Count_Type;


   PP : constant Parser_Private_Part := +Parser.Private_Part;
   M  : Memo_Entry := Get (PP.Field_Decl_Transform_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res58 := M.Instance;
      return Transform_Res58;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res58;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  BEGIN <Transform(<ASTNodeType FieldDecl>) (root of 'field_decl') at parser.lkt:193:19>

Transform_Diags58 := Parser.Diagnostics.Length;


--  BEGIN <_Row (root of 'field_decl') at parser.lkt:193:19>

Row_Pos62 := Pos;



--  BEGIN <Defer (for 'def_id') at parser.lkt:194:9>

Defer_Res76 :=
   Def_Id_Transform_Parse0 (Parser, Row_Pos62);
Defer_Pos76 := Parser.Current_Pos;

--  END <Defer (for 'def_id') at parser.lkt:194:9>




if Defer_Pos76 /= No_Token_Index then

   Row_Pos62 := Defer_Pos76;

else
   Row_Pos62 := No_Token_Index;
   goto Exit_Row62_0;

end if;


--  BEGIN <Token(<WithText Colon>, ) (root of 'field_decl') at parser.lkt:195:9>

Token_Res76 := Row_Pos62;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res76));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_Colon)
   then
       Token_Pos76 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos62 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos62,
             Expected_Token_Id => Lkt_Colon,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos76 := Row_Pos62 + 1;
   end if;
end;

--  END <Token(<WithText Colon>, ) (root of 'field_decl') at parser.lkt:195:9>




if Token_Pos76 /= No_Token_Index then

   Row_Pos62 := Token_Pos76;

else
   Row_Pos62 := No_Token_Index;
   goto Exit_Row62_0;

end if;


--  BEGIN <Defer (for 'type_ref') at parser.lkt:196:9>

Defer_Res77 :=
   Type_Ref_Or_Parse0 (Parser, Row_Pos62);
Defer_Pos77 := Parser.Current_Pos;

--  END <Defer (for 'type_ref') at parser.lkt:196:9>




if Defer_Pos77 /= No_Token_Index then

   Row_Pos62 := Defer_Pos77;

else
   Row_Pos62 := No_Token_Index;
   goto Exit_Row62_0;

end if;


--  BEGIN <Opt (root of 'field_decl') at parser.lkt:197:9>












--  BEGIN <_Extract (root of 'field_decl') at parser.lkt:197:10>

--  BEGIN <_Row (root of 'field_decl') at parser.lkt:197:10>

Row_Pos63 := Row_Pos62;



--  BEGIN <Token(<WithText ImplementsKw>, ) (root of 'field_decl') at parser.lkt:197:15>

Token_Res77 := Row_Pos63;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res77));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_Implements_Kw)
   then
       Token_Pos77 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos63 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos63,
             Expected_Token_Id => Lkt_Implements_Kw,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos77 := Row_Pos63 + 1;
   end if;
end;

--  END <Token(<WithText ImplementsKw>, ) (root of 'field_decl') at parser.lkt:197:15>




if Token_Pos77 /= No_Token_Index then

   Row_Pos63 := Token_Pos77;

else
   Row_Pos63 := No_Token_Index;
   goto Exit_Row63_0;

end if;


--  BEGIN <Defer (for 'type_member_ref') at parser.lkt:197:28>

Defer_Res78 :=
   Type_Member_Ref_Transform_Parse0 (Parser, Row_Pos63);
Defer_Pos78 := Parser.Current_Pos;

--  END <Defer (for 'type_member_ref') at parser.lkt:197:28>




if Defer_Pos78 /= No_Token_Index then

   Row_Pos63 := Defer_Pos78;

else
   Row_Pos63 := No_Token_Index;
   goto Exit_Row63_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row63_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'field_decl') at parser.lkt:197:10>

--  END <_Extract (root of 'field_decl') at parser.lkt:197:10>


if Row_Pos63 = No_Token_Index then

         
   Defer_Res78 := No_Bare_Lkt_Node;



       
   Row_Pos63 := Row_Pos62;



end if;

--  END <Opt (root of 'field_decl') at parser.lkt:197:9>




if Row_Pos63 /= No_Token_Index then

   Row_Pos62 := Row_Pos63;

else
   Row_Pos62 := No_Token_Index;
   goto Exit_Row62_0;

end if;


--  BEGIN <Opt (root of 'field_decl') at parser.lkt:198:9>












--  BEGIN <_Extract (root of 'field_decl') at parser.lkt:198:10>

--  BEGIN <_Row (root of 'field_decl') at parser.lkt:198:10>

Row_Pos64 := Row_Pos62;



--  BEGIN <Token(<WithText Equal>, ) (root of 'field_decl') at parser.lkt:198:15>

Token_Res78 := Row_Pos64;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res78));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_Equal)
   then
       Token_Pos78 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos64 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos64,
             Expected_Token_Id => Lkt_Equal,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos78 := Row_Pos64 + 1;
   end if;
end;

--  END <Token(<WithText Equal>, ) (root of 'field_decl') at parser.lkt:198:15>




if Token_Pos78 /= No_Token_Index then

   Row_Pos64 := Token_Pos78;

else
   Row_Pos64 := No_Token_Index;
   goto Exit_Row64_0;

end if;


--  BEGIN <Defer (for 'expr') at parser.lkt:198:19>

Defer_Res79 :=
   Expr_Or_Parse1 (Parser, Row_Pos64);
Defer_Pos79 := Parser.Current_Pos;

--  END <Defer (for 'expr') at parser.lkt:198:19>




if Defer_Pos79 /= No_Token_Index then

   Row_Pos64 := Defer_Pos79;

else
   Row_Pos64 := No_Token_Index;
   goto Exit_Row64_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row64_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'field_decl') at parser.lkt:198:10>

--  END <_Extract (root of 'field_decl') at parser.lkt:198:10>


if Row_Pos64 = No_Token_Index then

         
   Defer_Res79 := No_Bare_Lkt_Node;



       
   Row_Pos64 := Row_Pos62;



end if;

--  END <Opt (root of 'field_decl') at parser.lkt:198:9>




if Row_Pos64 /= No_Token_Index then

   Row_Pos62 := Row_Pos64;

else
   Row_Pos62 := No_Token_Index;
   goto Exit_Row62_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row62_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'field_decl') at parser.lkt:193:19>



if Row_Pos62 /= No_Token_Index then

   Transform_Res58 := Allocate_Field_Decl (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res58,
      Kind => Lkt_Field_Decl,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos62 = Pos
                            then No_Token_Index
                            else Row_Pos62 - 1));

      
      Initialize_Fields_For_Field_Decl
        (Self => Transform_Res58,
         Field_Decl_F_Syn_Name => Defer_Res76,
         Field_Decl_F_Decl_Type => Defer_Res77,
         Field_Decl_F_Trait_Ref => Defer_Res78,
         Field_Decl_F_Default_Val => Defer_Res79);

         if Defer_Res76 /= null and then Is_Incomplete (Defer_Res76) then
            Transform_Res58.Last_Attempted_Child := 0;
         elsif Defer_Res76 /= null and then not Is_Ghost (Defer_Res76) then
            Transform_Res58.Last_Attempted_Child := -1;
         end if;
         if Defer_Res77 /= null and then Is_Incomplete (Defer_Res77) then
            Transform_Res58.Last_Attempted_Child := 0;
         elsif Defer_Res77 /= null and then not Is_Ghost (Defer_Res77) then
            Transform_Res58.Last_Attempted_Child := -1;
         end if;
         if Defer_Res78 /= null and then Is_Incomplete (Defer_Res78) then
            Transform_Res58.Last_Attempted_Child := 0;
         elsif Defer_Res78 /= null and then not Is_Ghost (Defer_Res78) then
            Transform_Res58.Last_Attempted_Child := -1;
         end if;
         if Defer_Res79 /= null and then Is_Incomplete (Defer_Res79) then
            Transform_Res58.Last_Attempted_Child := 0;
         elsif Defer_Res79 /= null and then not Is_Ghost (Defer_Res79) then
            Transform_Res58.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos62 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags58);
end if;

--  END <Transform(<ASTNodeType FieldDecl>) (root of 'field_decl') at parser.lkt:193:19>


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (PP.Field_Decl_Transform_Parse0_Memo,
      Row_Pos62 /= No_Token_Index,
      Transform_Res58,
      Pos,
      Row_Pos62);


   Parser.Current_Pos := Row_Pos62;

   return Transform_Res58;
end Field_Decl_Transform_Parse0;

   


function Fil_Pattern_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Pattern
is
   use Bare_Pattern_Memos;

      Row_Pos65 :
            Token_Index
               := No_Token_Index;
      Defer_Pos80 :
            Token_Index
               := No_Token_Index;
      Defer_Res80 :
            Bare_Pattern
               := No_Bare_Lkt_Node;
      Token_Pos79 :
            Token_Index
               := No_Token_Index;
      Token_Res79 :
            Token_Index
               := No_Token_Index;
      Defer_Pos81 :
            Token_Index
               := No_Token_Index;
      Defer_Res81 :
            Bare_Expr
               := No_Bare_Lkt_Node;
      Transform_Res59 :
            Bare_Filtered_Pattern
               := No_Bare_Lkt_Node;
      Transform_Diags59 :
            Ada.Containers.Count_Type;
      Defer_Pos82 :
            Token_Index
               := No_Token_Index;
      Defer_Res82 :
            Bare_Pattern
               := No_Bare_Lkt_Node;
      Or_Pos17 :
            Token_Index
               := No_Token_Index;
      Or_Res17 :
            Bare_Pattern
               := No_Bare_Lkt_Node;


   PP : constant Parser_Private_Part := +Parser.Private_Part;
   M  : Memo_Entry := Get (PP.Fil_Pattern_Or_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Or_Res17 := M.Instance;
      return Or_Res17;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Or_Res17;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  BEGIN <Or (root of 'fil_pattern') at parser.lkt:246:20>

Or_Pos17 := No_Token_Index;
Or_Res17 := No_Bare_Lkt_Node;
    
--  BEGIN <Transform(<ASTNodeType FilteredPattern>) (root of 'fil_pattern') at parser.lkt:247:11>

Transform_Diags59 := Parser.Diagnostics.Length;


--  BEGIN <_Row (root of 'fil_pattern') at parser.lkt:247:11>

Row_Pos65 := Pos;



--  BEGIN <Defer (for 'value_pattern') at parser.lkt:247:27>

Defer_Res80 :=
   Value_Pattern_Or_Parse1 (Parser, Row_Pos65);
Defer_Pos80 := Parser.Current_Pos;

--  END <Defer (for 'value_pattern') at parser.lkt:247:27>




if Defer_Pos80 /= No_Token_Index then

   Row_Pos65 := Defer_Pos80;

else
   Row_Pos65 := No_Token_Index;
   goto Exit_Row65_0;

end if;


--  BEGIN <Token(<WithText WhenKw>, ) (root of 'fil_pattern') at parser.lkt:247:41>

Token_Res79 := Row_Pos65;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res79));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_When_Kw)
   then
       Token_Pos79 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos65 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos65,
             Expected_Token_Id => Lkt_When_Kw,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos79 := Row_Pos65 + 1;
   end if;
end;

--  END <Token(<WithText WhenKw>, ) (root of 'fil_pattern') at parser.lkt:247:41>




if Token_Pos79 /= No_Token_Index then

   Row_Pos65 := Token_Pos79;

else
   Row_Pos65 := No_Token_Index;
   goto Exit_Row65_0;

end if;


--  BEGIN <Defer (for 'expr') at parser.lkt:247:48>

Defer_Res81 :=
   Expr_Or_Parse1 (Parser, Row_Pos65);
Defer_Pos81 := Parser.Current_Pos;

--  END <Defer (for 'expr') at parser.lkt:247:48>




if Defer_Pos81 /= No_Token_Index then

   Row_Pos65 := Defer_Pos81;

else
   Row_Pos65 := No_Token_Index;
   goto Exit_Row65_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row65_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'fil_pattern') at parser.lkt:247:11>



if Row_Pos65 /= No_Token_Index then

   Transform_Res59 := Allocate_Filtered_Pattern (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res59,
      Kind => Lkt_Filtered_Pattern,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos65 = Pos
                            then No_Token_Index
                            else Row_Pos65 - 1));

      
      Initialize_Fields_For_Filtered_Pattern
        (Self => Transform_Res59,
         Filtered_Pattern_F_Sub_Pattern => Defer_Res80,
         Filtered_Pattern_F_Predicate => Defer_Res81);

         if Defer_Res80 /= null and then Is_Incomplete (Defer_Res80) then
            Transform_Res59.Last_Attempted_Child := 0;
         elsif Defer_Res80 /= null and then not Is_Ghost (Defer_Res80) then
            Transform_Res59.Last_Attempted_Child := -1;
         end if;
         if Defer_Res81 /= null and then Is_Incomplete (Defer_Res81) then
            Transform_Res59.Last_Attempted_Child := 0;
         elsif Defer_Res81 /= null and then not Is_Ghost (Defer_Res81) then
            Transform_Res59.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos65 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags59);
end if;

--  END <Transform(<ASTNodeType FilteredPattern>) (root of 'fil_pattern') at parser.lkt:247:11>

    if Row_Pos65 /= No_Token_Index then
        Or_Pos17 := Row_Pos65;
        Or_Res17 := Transform_Res59;
        goto Exit_Or18;
    end if;
    
--  BEGIN <Defer (for 'value_pattern') at parser.lkt:248:11>

Defer_Res82 :=
   Value_Pattern_Or_Parse1 (Parser, Pos);
Defer_Pos82 := Parser.Current_Pos;

--  END <Defer (for 'value_pattern') at parser.lkt:248:11>

    if Defer_Pos82 /= No_Token_Index then
        Or_Pos17 := Defer_Pos82;
        Or_Res17 := Defer_Res82;
        goto Exit_Or18;
    end if;
<<Exit_Or18>>

--  END <Or (root of 'fil_pattern') at parser.lkt:246:20>


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (PP.Fil_Pattern_Or_Parse0_Memo,
      Or_Pos17 /= No_Token_Index,
      Or_Res17,
      Pos,
      Or_Pos17);


   Parser.Current_Pos := Or_Pos17;

   return Or_Res17;
end Fil_Pattern_Or_Parse0;

   


function Fun_Decl_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Fun_Decl
is
   use Bare_Fun_Decl_Memos;

      Row_Pos66 :
            Token_Index
               := No_Token_Index;
      Token_Pos80 :
            Token_Index
               := No_Token_Index;
      Token_Res80 :
            Token_Index
               := No_Token_Index;
      Defer_Pos83 :
            Token_Index
               := No_Token_Index;
      Defer_Res83 :
            Bare_Def_Id
               := No_Bare_Lkt_Node;
      Token_Pos81 :
            Token_Index
               := No_Token_Index;
      Token_Res81 :
            Token_Index
               := No_Token_Index;
      Defer_Pos84 :
            Token_Index
               := No_Token_Index;
      Defer_Res84 :
            Bare_Fun_Param_Decl_List
               := No_Bare_Lkt_Node;
      Token_Pos82 :
            Token_Index
               := No_Token_Index;
      Token_Res82 :
            Token_Index
               := No_Token_Index;
      Token_Pos83 :
            Token_Index
               := No_Token_Index;
      Token_Res83 :
            Token_Index
               := No_Token_Index;
      Defer_Pos85 :
            Token_Index
               := No_Token_Index;
      Defer_Res85 :
            Bare_Type_Ref
               := No_Bare_Lkt_Node;
      Row_Pos67 :
            Token_Index
               := No_Token_Index;
      Token_Pos84 :
            Token_Index
               := No_Token_Index;
      Token_Res84 :
            Token_Index
               := No_Token_Index;
      Defer_Pos86 :
            Token_Index
               := No_Token_Index;
      Defer_Res86 :
            Bare_Dot_Expr
               := No_Bare_Lkt_Node;
      Row_Pos68 :
            Token_Index
               := No_Token_Index;
      Token_Pos85 :
            Token_Index
               := No_Token_Index;
      Token_Res85 :
            Token_Index
               := No_Token_Index;
      Defer_Pos87 :
            Token_Index
               := No_Token_Index;
      Defer_Res87 :
            Bare_Expr
               := No_Bare_Lkt_Node;
      Transform_Res60 :
            Bare_Fun_Decl
               := No_Bare_Lkt_Node;
      Transform_Diags60 :
            Ada.Containers.Count_Type;


   PP : constant Parser_Private_Part := +Parser.Private_Part;
   M  : Memo_Entry := Get (PP.Fun_Decl_Transform_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res60 := M.Instance;
      return Transform_Res60;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res60;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  BEGIN <Transform(<ASTNodeType FunDecl>) (root of 'fun_decl') at parser.lkt:174:17>

Transform_Diags60 := Parser.Diagnostics.Length;


--  BEGIN <_Row (root of 'fun_decl') at parser.lkt:174:17>

Row_Pos66 := Pos;



--  BEGIN <Token(<WithText FunKw>, ) (root of 'fun_decl') at parser.lkt:175:9>

Token_Res80 := Row_Pos66;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res80));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_Fun_Kw)
   then
       Token_Pos80 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos66 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos66,
             Expected_Token_Id => Lkt_Fun_Kw,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos80 := Row_Pos66 + 1;
   end if;
end;

--  END <Token(<WithText FunKw>, ) (root of 'fun_decl') at parser.lkt:175:9>




if Token_Pos80 /= No_Token_Index then

   Row_Pos66 := Token_Pos80;

else
   Row_Pos66 := No_Token_Index;
   goto Exit_Row66_0;

end if;


--  BEGIN <Defer (for 'def_id') at parser.lkt:176:9>

Defer_Res83 :=
   Def_Id_Transform_Parse0 (Parser, Row_Pos66);
Defer_Pos83 := Parser.Current_Pos;

--  END <Defer (for 'def_id') at parser.lkt:176:9>




if Defer_Pos83 /= No_Token_Index then

   Row_Pos66 := Defer_Pos83;

else
   Row_Pos66 := No_Token_Index;
   goto Exit_Row66_0;

end if;


--  BEGIN <Token(<WithText LPar>, ) (root of 'fun_decl') at parser.lkt:177:9>

Token_Res81 := Row_Pos66;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res81));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_L_Par)
   then
       Token_Pos81 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos66 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos66,
             Expected_Token_Id => Lkt_L_Par,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos81 := Row_Pos66 + 1;
   end if;
end;

--  END <Token(<WithText LPar>, ) (root of 'fun_decl') at parser.lkt:177:9>




if Token_Pos81 /= No_Token_Index then

   Row_Pos66 := Token_Pos81;

else
   Row_Pos66 := No_Token_Index;
   goto Exit_Row66_0;

end if;


--  BEGIN <Defer (for 'fun_param_list') at parser.lkt:178:9>

Defer_Res84 :=
   Fun_Param_List_List_Parse0 (Parser, Row_Pos66);
Defer_Pos84 := Parser.Current_Pos;

--  END <Defer (for 'fun_param_list') at parser.lkt:178:9>




if Defer_Pos84 /= No_Token_Index then

   Row_Pos66 := Defer_Pos84;

else
   Row_Pos66 := No_Token_Index;
   goto Exit_Row66_0;

end if;


--  BEGIN <Token(<WithText RPar>, ) (root of 'fun_decl') at parser.lkt:179:9>

Token_Res82 := Row_Pos66;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res82));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_R_Par)
   then
       Token_Pos82 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos66 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos66,
             Expected_Token_Id => Lkt_R_Par,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos82 := Row_Pos66 + 1;
   end if;
end;

--  END <Token(<WithText RPar>, ) (root of 'fun_decl') at parser.lkt:179:9>




if Token_Pos82 /= No_Token_Index then

   Row_Pos66 := Token_Pos82;

else
   Row_Pos66 := No_Token_Index;
   goto Exit_Row66_0;

end if;


--  BEGIN <Token(<WithText Colon>, ) (root of 'fun_decl') at parser.lkt:180:9>

Token_Res83 := Row_Pos66;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res83));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_Colon)
   then
       Token_Pos83 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos66 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos66,
             Expected_Token_Id => Lkt_Colon,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos83 := Row_Pos66 + 1;
   end if;
end;

--  END <Token(<WithText Colon>, ) (root of 'fun_decl') at parser.lkt:180:9>




if Token_Pos83 /= No_Token_Index then

   Row_Pos66 := Token_Pos83;

else
   Row_Pos66 := No_Token_Index;
   goto Exit_Row66_0;

end if;


--  BEGIN <Defer (for 'type_ref') at parser.lkt:181:9>

Defer_Res85 :=
   Type_Ref_Or_Parse0 (Parser, Row_Pos66);
Defer_Pos85 := Parser.Current_Pos;

--  END <Defer (for 'type_ref') at parser.lkt:181:9>




if Defer_Pos85 /= No_Token_Index then

   Row_Pos66 := Defer_Pos85;

else
   Row_Pos66 := No_Token_Index;
   goto Exit_Row66_0;

end if;


--  BEGIN <Opt (root of 'fun_decl') at parser.lkt:182:9>












--  BEGIN <_Extract (root of 'fun_decl') at parser.lkt:182:10>

--  BEGIN <_Row (root of 'fun_decl') at parser.lkt:182:10>

Row_Pos67 := Row_Pos66;



--  BEGIN <Token(<WithText ImplementsKw>, ) (root of 'fun_decl') at parser.lkt:182:15>

Token_Res84 := Row_Pos67;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res84));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_Implements_Kw)
   then
       Token_Pos84 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos67 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos67,
             Expected_Token_Id => Lkt_Implements_Kw,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos84 := Row_Pos67 + 1;
   end if;
end;

--  END <Token(<WithText ImplementsKw>, ) (root of 'fun_decl') at parser.lkt:182:15>




if Token_Pos84 /= No_Token_Index then

   Row_Pos67 := Token_Pos84;

else
   Row_Pos67 := No_Token_Index;
   goto Exit_Row67_0;

end if;


--  BEGIN <Defer (for 'type_member_ref') at parser.lkt:182:28>

Defer_Res86 :=
   Type_Member_Ref_Transform_Parse0 (Parser, Row_Pos67);
Defer_Pos86 := Parser.Current_Pos;

--  END <Defer (for 'type_member_ref') at parser.lkt:182:28>




if Defer_Pos86 /= No_Token_Index then

   Row_Pos67 := Defer_Pos86;

else
   Row_Pos67 := No_Token_Index;
   goto Exit_Row67_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row67_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'fun_decl') at parser.lkt:182:10>

--  END <_Extract (root of 'fun_decl') at parser.lkt:182:10>


if Row_Pos67 = No_Token_Index then

         
   Defer_Res86 := No_Bare_Lkt_Node;



       
   Row_Pos67 := Row_Pos66;



end if;

--  END <Opt (root of 'fun_decl') at parser.lkt:182:9>




if Row_Pos67 /= No_Token_Index then

   Row_Pos66 := Row_Pos67;

else
   Row_Pos66 := No_Token_Index;
   goto Exit_Row66_0;

end if;


--  BEGIN <Opt (root of 'fun_decl') at parser.lkt:183:9>












--  BEGIN <_Extract (root of 'fun_decl') at parser.lkt:183:10>

--  BEGIN <_Row (root of 'fun_decl') at parser.lkt:183:10>

Row_Pos68 := Row_Pos66;



--  BEGIN <Token(<WithText Equal>, ) (root of 'fun_decl') at parser.lkt:183:15>

Token_Res85 := Row_Pos68;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res85));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_Equal)
   then
       Token_Pos85 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos68 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos68,
             Expected_Token_Id => Lkt_Equal,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos85 := Row_Pos68 + 1;
   end if;
end;

--  END <Token(<WithText Equal>, ) (root of 'fun_decl') at parser.lkt:183:15>




if Token_Pos85 /= No_Token_Index then

   Row_Pos68 := Token_Pos85;

else
   Row_Pos68 := No_Token_Index;
   goto Exit_Row68_0;

end if;


--  BEGIN <Defer (for 'expr') at parser.lkt:183:19>

Defer_Res87 :=
   Expr_Or_Parse1 (Parser, Row_Pos68);
Defer_Pos87 := Parser.Current_Pos;

--  END <Defer (for 'expr') at parser.lkt:183:19>




if Defer_Pos87 /= No_Token_Index then

   Row_Pos68 := Defer_Pos87;

else
   Row_Pos68 := No_Token_Index;
   goto Exit_Row68_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row68_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'fun_decl') at parser.lkt:183:10>

--  END <_Extract (root of 'fun_decl') at parser.lkt:183:10>


if Row_Pos68 = No_Token_Index then

         
   Defer_Res87 := No_Bare_Lkt_Node;



       
   Row_Pos68 := Row_Pos66;



end if;

--  END <Opt (root of 'fun_decl') at parser.lkt:183:9>




if Row_Pos68 /= No_Token_Index then

   Row_Pos66 := Row_Pos68;

else
   Row_Pos66 := No_Token_Index;
   goto Exit_Row66_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row66_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'fun_decl') at parser.lkt:174:17>



if Row_Pos66 /= No_Token_Index then

   Transform_Res60 := Allocate_Fun_Decl (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res60,
      Kind => Lkt_Fun_Decl,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos66 = Pos
                            then No_Token_Index
                            else Row_Pos66 - 1));

      
      Initialize_Fields_For_Fun_Decl
        (Self => Transform_Res60,
         Fun_Decl_F_Syn_Name => Defer_Res83,
         Fun_Decl_F_Params => Defer_Res84,
         Fun_Decl_F_Return_Type => Defer_Res85,
         Fun_Decl_F_Trait_Ref => Defer_Res86,
         Fun_Decl_F_Body => Defer_Res87);

         if Defer_Res83 /= null and then Is_Incomplete (Defer_Res83) then
            Transform_Res60.Last_Attempted_Child := 0;
         elsif Defer_Res83 /= null and then not Is_Ghost (Defer_Res83) then
            Transform_Res60.Last_Attempted_Child := -1;
         end if;
         if Defer_Res84 /= null and then Is_Incomplete (Defer_Res84) then
            Transform_Res60.Last_Attempted_Child := 0;
         elsif Defer_Res84 /= null and then not Is_Ghost (Defer_Res84) then
            Transform_Res60.Last_Attempted_Child := -1;
         end if;
         if Defer_Res85 /= null and then Is_Incomplete (Defer_Res85) then
            Transform_Res60.Last_Attempted_Child := 0;
         elsif Defer_Res85 /= null and then not Is_Ghost (Defer_Res85) then
            Transform_Res60.Last_Attempted_Child := -1;
         end if;
         if Defer_Res86 /= null and then Is_Incomplete (Defer_Res86) then
            Transform_Res60.Last_Attempted_Child := 0;
         elsif Defer_Res86 /= null and then not Is_Ghost (Defer_Res86) then
            Transform_Res60.Last_Attempted_Child := -1;
         end if;
         if Defer_Res87 /= null and then Is_Incomplete (Defer_Res87) then
            Transform_Res60.Last_Attempted_Child := 0;
         elsif Defer_Res87 /= null and then not Is_Ghost (Defer_Res87) then
            Transform_Res60.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos66 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags60);
end if;

--  END <Transform(<ASTNodeType FunDecl>) (root of 'fun_decl') at parser.lkt:174:17>


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (PP.Fun_Decl_Transform_Parse0_Memo,
      Row_Pos66 /= No_Token_Index,
      Transform_Res60,
      Pos,
      Row_Pos66);


   Parser.Current_Pos := Row_Pos66;

   return Transform_Res60;
end Fun_Decl_Transform_Parse0;

   


function Fun_Param_Decl_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Fun_Param_Decl
is
   use Bare_Fun_Param_Decl_Memos;

      Row_Pos69 :
            Token_Index
               := No_Token_Index;
      Lst_Cpos8 :
            Token_Index
               := No_Token_Index;
      Tmp_List8 :
            Free_Parse_List;
      Defer_Pos88 :
            Token_Index
               := No_Token_Index;
      Defer_Res88 :
            Bare_Decl_Annotation
               := No_Bare_Lkt_Node;
      List_Pos8 :
            Token_Index
               := No_Token_Index;
      List_Res8 :
            Bare_Decl_Annotation_List
               := No_Bare_Lkt_Node;
      Defer_Pos89 :
            Token_Index
               := No_Token_Index;
      Defer_Res89 :
            Bare_Def_Id
               := No_Bare_Lkt_Node;
      Token_Pos86 :
            Token_Index
               := No_Token_Index;
      Token_Res86 :
            Token_Index
               := No_Token_Index;
      Defer_Pos90 :
            Token_Index
               := No_Token_Index;
      Defer_Res90 :
            Bare_Type_Ref
               := No_Bare_Lkt_Node;
      Row_Pos70 :
            Token_Index
               := No_Token_Index;
      Token_Pos87 :
            Token_Index
               := No_Token_Index;
      Token_Res87 :
            Token_Index
               := No_Token_Index;
      Defer_Pos91 :
            Token_Index
               := No_Token_Index;
      Defer_Res91 :
            Bare_Expr
               := No_Bare_Lkt_Node;
      Transform_Res61 :
            Bare_Fun_Param_Decl
               := No_Bare_Lkt_Node;
      Transform_Diags61 :
            Ada.Containers.Count_Type;


   PP : constant Parser_Private_Part := +Parser.Private_Part;
   M  : Memo_Entry := Get (PP.Fun_Param_Decl_Transform_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res61 := M.Instance;
      return Transform_Res61;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res61;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  BEGIN <Transform(<ASTNodeType FunParamDecl>) (root of 'fun_param_decl') at parser.lkt:188:23>

Transform_Diags61 := Parser.Diagnostics.Length;


--  BEGIN <_Row (root of 'fun_param_decl') at parser.lkt:188:23>

Row_Pos69 := Pos;



--  BEGIN <List (root of 'fun_param_decl') at parser.lkt:189:9>

    List_Pos8 := Row_Pos69;



Lst_Cpos8 := Row_Pos69;
Tmp_List8 := Get_Parse_List (Parser);


loop
   
--  BEGIN <Defer (for 'decl_annotation') at parser.lkt:189:15>

Defer_Res88 :=
   Decl_Annotation_Transform_Parse0 (Parser, Lst_Cpos8);
Defer_Pos88 := Parser.Current_Pos;

--  END <Defer (for 'decl_annotation') at parser.lkt:189:15>


   exit when Defer_Pos88 = No_Token_Index;

   List_Pos8 := Defer_Pos88;
   Lst_Cpos8 := List_Pos8;

   Tmp_List8.Nodes.Append (Defer_Res88);

end loop;


declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List8.Nodes.Length;
begin
   List_Res8 := Allocate_Decl_Annotation_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Row_Pos69;
      Token_End := (if Lst_Cpos8 = Row_Pos69
                    then Row_Pos69
                    else List_Pos8 - 1);

   else
      Token_Start := Token_Index'Max (Row_Pos69, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res8,
      Kind              => Lkt_Decl_Annotation_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res8,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_Lkt_Node_Vectors.Vector renames
         Tmp_List8.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res8.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List8);

--  END <List (root of 'fun_param_decl') at parser.lkt:189:9>




if List_Pos8 /= No_Token_Index then

   Row_Pos69 := List_Pos8;

else
   Row_Pos69 := No_Token_Index;
   goto Exit_Row69_0;

end if;


--  BEGIN <Defer (for 'def_id') at parser.lkt:189:32>

Defer_Res89 :=
   Def_Id_Transform_Parse0 (Parser, Row_Pos69);
Defer_Pos89 := Parser.Current_Pos;

--  END <Defer (for 'def_id') at parser.lkt:189:32>




if Defer_Pos89 /= No_Token_Index then

   Row_Pos69 := Defer_Pos89;

else
   Row_Pos69 := No_Token_Index;
   goto Exit_Row69_0;

end if;


--  BEGIN <Token(<WithText Colon>, ) (root of 'fun_param_decl') at parser.lkt:189:39>

Token_Res86 := Row_Pos69;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res86));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_Colon)
   then
       Token_Pos86 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos69 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos69,
             Expected_Token_Id => Lkt_Colon,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos86 := Row_Pos69 + 1;
   end if;
end;

--  END <Token(<WithText Colon>, ) (root of 'fun_param_decl') at parser.lkt:189:39>




if Token_Pos86 /= No_Token_Index then

   Row_Pos69 := Token_Pos86;

else
   Row_Pos69 := No_Token_Index;
   goto Exit_Row69_0;

end if;


--  BEGIN <Defer (for 'type_ref') at parser.lkt:189:43>

Defer_Res90 :=
   Type_Ref_Or_Parse0 (Parser, Row_Pos69);
Defer_Pos90 := Parser.Current_Pos;

--  END <Defer (for 'type_ref') at parser.lkt:189:43>




if Defer_Pos90 /= No_Token_Index then

   Row_Pos69 := Defer_Pos90;

else
   Row_Pos69 := No_Token_Index;
   goto Exit_Row69_0;

end if;


--  BEGIN <Opt (root of 'fun_param_decl') at parser.lkt:189:52>












--  BEGIN <_Extract (root of 'fun_param_decl') at parser.lkt:189:53>

--  BEGIN <_Row (root of 'fun_param_decl') at parser.lkt:189:53>

Row_Pos70 := Row_Pos69;



--  BEGIN <Token(<WithText Equal>, ) (root of 'fun_param_decl') at parser.lkt:189:58>

Token_Res87 := Row_Pos70;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res87));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_Equal)
   then
       Token_Pos87 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos70 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos70,
             Expected_Token_Id => Lkt_Equal,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos87 := Row_Pos70 + 1;
   end if;
end;

--  END <Token(<WithText Equal>, ) (root of 'fun_param_decl') at parser.lkt:189:58>




if Token_Pos87 /= No_Token_Index then

   Row_Pos70 := Token_Pos87;

else
   Row_Pos70 := No_Token_Index;
   goto Exit_Row70_0;

end if;


--  BEGIN <Defer (for 'expr') at parser.lkt:189:62>

Defer_Res91 :=
   Expr_Or_Parse1 (Parser, Row_Pos70);
Defer_Pos91 := Parser.Current_Pos;

--  END <Defer (for 'expr') at parser.lkt:189:62>




if Defer_Pos91 /= No_Token_Index then

   Row_Pos70 := Defer_Pos91;

else
   Row_Pos70 := No_Token_Index;
   goto Exit_Row70_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row70_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'fun_param_decl') at parser.lkt:189:53>

--  END <_Extract (root of 'fun_param_decl') at parser.lkt:189:53>


if Row_Pos70 = No_Token_Index then

         
   Defer_Res91 := No_Bare_Lkt_Node;



       
   Row_Pos70 := Row_Pos69;



end if;

--  END <Opt (root of 'fun_param_decl') at parser.lkt:189:52>




if Row_Pos70 /= No_Token_Index then

   Row_Pos69 := Row_Pos70;

else
   Row_Pos69 := No_Token_Index;
   goto Exit_Row69_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row69_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'fun_param_decl') at parser.lkt:188:23>



if Row_Pos69 /= No_Token_Index then

   Transform_Res61 := Allocate_Fun_Param_Decl (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res61,
      Kind => Lkt_Fun_Param_Decl,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos69 = Pos
                            then No_Token_Index
                            else Row_Pos69 - 1));

      
      Initialize_Fields_For_Fun_Param_Decl
        (Self => Transform_Res61,
         Fun_Param_Decl_F_Decl_Annotations => List_Res8,
         Fun_Param_Decl_F_Syn_Name => Defer_Res89,
         Fun_Param_Decl_F_Decl_Type => Defer_Res90,
         Fun_Param_Decl_F_Default_Val => Defer_Res91);

         if List_Res8 /= null and then Is_Incomplete (List_Res8) then
            Transform_Res61.Last_Attempted_Child := 0;
         elsif List_Res8 /= null and then not Is_Ghost (List_Res8) then
            Transform_Res61.Last_Attempted_Child := -1;
         end if;
         if Defer_Res89 /= null and then Is_Incomplete (Defer_Res89) then
            Transform_Res61.Last_Attempted_Child := 0;
         elsif Defer_Res89 /= null and then not Is_Ghost (Defer_Res89) then
            Transform_Res61.Last_Attempted_Child := -1;
         end if;
         if Defer_Res90 /= null and then Is_Incomplete (Defer_Res90) then
            Transform_Res61.Last_Attempted_Child := 0;
         elsif Defer_Res90 /= null and then not Is_Ghost (Defer_Res90) then
            Transform_Res61.Last_Attempted_Child := -1;
         end if;
         if Defer_Res91 /= null and then Is_Incomplete (Defer_Res91) then
            Transform_Res61.Last_Attempted_Child := 0;
         elsif Defer_Res91 /= null and then not Is_Ghost (Defer_Res91) then
            Transform_Res61.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos69 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags61);
end if;

--  END <Transform(<ASTNodeType FunParamDecl>) (root of 'fun_param_decl') at parser.lkt:188:23>


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (PP.Fun_Param_Decl_Transform_Parse0_Memo,
      Row_Pos69 /= No_Token_Index,
      Transform_Res61,
      Pos,
      Row_Pos69);


   Parser.Current_Pos := Row_Pos69;

   return Transform_Res61;
end Fun_Param_Decl_Transform_Parse0;

   


function Fun_Param_List_List_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Fun_Param_Decl_List
is
   use Bare_Fun_Param_Decl_List_Memos;

      Lst_Cpos9 :
            Token_Index
               := No_Token_Index;
      Tmp_List9 :
            Free_Parse_List;
      Defer_Pos92 :
            Token_Index
               := No_Token_Index;
      Defer_Res92 :
            Bare_Fun_Param_Decl
               := No_Bare_Lkt_Node;
      Token_Pos88 :
            Token_Index
               := No_Token_Index;
      Token_Res88 :
            Token_Index
               := No_Token_Index;
      List_Pos9 :
            Token_Index
               := No_Token_Index;
      List_Res9 :
            Bare_Fun_Param_Decl_List
               := No_Bare_Lkt_Node;


   PP : constant Parser_Private_Part := +Parser.Private_Part;
   M  : Memo_Entry := Get (PP.Fun_Param_List_List_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      List_Res9 := M.Instance;
      return List_Res9;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return List_Res9;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  BEGIN <List (root of 'fun_param_list') at parser.lkt:191:23>

    List_Pos9 := Pos;



Lst_Cpos9 := Pos;
Tmp_List9 := Get_Parse_List (Parser);


loop
   
--  BEGIN <Defer (for 'fun_param_decl') at parser.lkt:191:29>

Defer_Res92 :=
   Fun_Param_Decl_Transform_Parse0 (Parser, Lst_Cpos9);
Defer_Pos92 := Parser.Current_Pos;

--  END <Defer (for 'fun_param_decl') at parser.lkt:191:29>


   exit when Defer_Pos92 = No_Token_Index;

   List_Pos9 := Defer_Pos92;
   Lst_Cpos9 := List_Pos9;

   Tmp_List9.Nodes.Append (Defer_Res92);

      
--  BEGIN <Token(<WithText Comma>, ) (root of 'fun_param_list') at parser.lkt:191:45>

Token_Res88 := Lst_Cpos9;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res88));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_Comma)
   then
       Token_Pos88 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Lst_Cpos9 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Lst_Cpos9,
             Expected_Token_Id => Lkt_Comma,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos88 := Lst_Cpos9 + 1;
   end if;
end;

--  END <Token(<WithText Comma>, ) (root of 'fun_param_list') at parser.lkt:191:45>


      exit when Token_Pos88 = No_Token_Index;

      Lst_Cpos9 := Token_Pos88;

end loop;


declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List9.Nodes.Length;
begin
   List_Res9 := Allocate_Fun_Param_Decl_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Pos;
      Token_End := (if Lst_Cpos9 = Pos
                    then Pos
                    else List_Pos9 - 1);

   else
      Token_Start := Token_Index'Max (Pos, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res9,
      Kind              => Lkt_Fun_Param_Decl_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res9,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_Lkt_Node_Vectors.Vector renames
         Tmp_List9.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res9.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List9);

--  END <List (root of 'fun_param_list') at parser.lkt:191:23>


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (PP.Fun_Param_List_List_Parse0_Memo,
      List_Pos9 /= No_Token_Index,
      List_Res9,
      Pos,
      List_Pos9);


   Parser.Current_Pos := List_Pos9;

   return List_Res9;
end Fun_Param_List_List_Parse0;

   


function Generic_Decl_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Generic_Decl
is
   use Bare_Generic_Decl_Memos;

      Row_Pos71 :
            Token_Index
               := No_Token_Index;
      Token_Pos89 :
            Token_Index
               := No_Token_Index;
      Token_Res89 :
            Token_Index
               := No_Token_Index;
      Token_Pos90 :
            Token_Index
               := No_Token_Index;
      Token_Res90 :
            Token_Index
               := No_Token_Index;
      Lst_Cpos10 :
            Token_Index
               := No_Token_Index;
      Tmp_List10 :
            Free_Parse_List;
      Defer_Pos93 :
            Token_Index
               := No_Token_Index;
      Defer_Res93 :
            Bare_Full_Decl
               := No_Bare_Lkt_Node;
      Token_Pos91 :
            Token_Index
               := No_Token_Index;
      Token_Res91 :
            Token_Index
               := No_Token_Index;
      List_Pos10 :
            Token_Index
               := No_Token_Index;
      List_Res10 :
            Bare_Generic_Param_Decl_List
               := No_Bare_Lkt_Node;
      Token_Pos92 :
            Token_Index
               := No_Token_Index;
      Token_Res92 :
            Token_Index
               := No_Token_Index;
      Defer_Pos94 :
            Token_Index
               := No_Token_Index;
      Defer_Res94 :
            Bare_Decl
               := No_Bare_Lkt_Node;
      Transform_Res62 :
            Bare_Generic_Decl
               := No_Bare_Lkt_Node;
      Transform_Diags62 :
            Ada.Containers.Count_Type;


   PP : constant Parser_Private_Part := +Parser.Private_Part;
   M  : Memo_Entry := Get (PP.Generic_Decl_Transform_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res62 := M.Instance;
      return Transform_Res62;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res62;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  BEGIN <Transform(<ASTNodeType GenericDecl>) (root of 'generic_decl') at parser.lkt:159:21>

Transform_Diags62 := Parser.Diagnostics.Length;


--  BEGIN <_Row (root of 'generic_decl') at parser.lkt:159:21>

Row_Pos71 := Pos;



--  BEGIN <Token(<WithText GenericKw>, ) (root of 'generic_decl') at parser.lkt:160:9>

Token_Res89 := Row_Pos71;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res89));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_Generic_Kw)
   then
       Token_Pos89 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos71 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos71,
             Expected_Token_Id => Lkt_Generic_Kw,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos89 := Row_Pos71 + 1;
   end if;
end;

--  END <Token(<WithText GenericKw>, ) (root of 'generic_decl') at parser.lkt:160:9>




if Token_Pos89 /= No_Token_Index then

   Row_Pos71 := Token_Pos89;

else
   Row_Pos71 := No_Token_Index;
   goto Exit_Row71_0;

end if;


--  BEGIN <Token(<WithText LBrack>, ) (root of 'generic_decl') at parser.lkt:161:9>

Token_Res90 := Row_Pos71;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res90));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_L_Brack)
   then
       Token_Pos90 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos71 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos71,
             Expected_Token_Id => Lkt_L_Brack,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos90 := Row_Pos71 + 1;
   end if;
end;

--  END <Token(<WithText LBrack>, ) (root of 'generic_decl') at parser.lkt:161:9>




if Token_Pos90 /= No_Token_Index then

   Row_Pos71 := Token_Pos90;

else
   Row_Pos71 := No_Token_Index;
   goto Exit_Row71_0;

end if;


--  BEGIN <List (root of 'generic_decl') at parser.lkt:162:9>

    List_Pos10 := No_Token_Index;



Lst_Cpos10 := Row_Pos71;
Tmp_List10 := Get_Parse_List (Parser);


loop
   
--  BEGIN <Defer (for 'generic_param_type') at parser.lkt:162:31>

Defer_Res93 :=
   Generic_Param_Type_Transform_Parse1 (Parser, Lst_Cpos10);
Defer_Pos93 := Parser.Current_Pos;

--  END <Defer (for 'generic_param_type') at parser.lkt:162:31>


   exit when Defer_Pos93 = No_Token_Index;

   List_Pos10 := Defer_Pos93;
   Lst_Cpos10 := List_Pos10;

   Tmp_List10.Nodes.Append (Defer_Res93);

      
--  BEGIN <Token(<WithText Comma>, ) (root of 'generic_decl') at parser.lkt:162:51>

Token_Res91 := Lst_Cpos10;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res91));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_Comma)
   then
       Token_Pos91 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Lst_Cpos10 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Lst_Cpos10,
             Expected_Token_Id => Lkt_Comma,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos91 := Lst_Cpos10 + 1;
   end if;
end;

--  END <Token(<WithText Comma>, ) (root of 'generic_decl') at parser.lkt:162:51>


      exit when Token_Pos91 = No_Token_Index;

      Lst_Cpos10 := Token_Pos91;

end loop;


declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List10.Nodes.Length;
begin
   List_Res10 := Allocate_Generic_Param_Decl_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Row_Pos71;
      Token_End := (if Lst_Cpos10 = Row_Pos71
                    then Row_Pos71
                    else List_Pos10 - 1);

   else
      Token_Start := Token_Index'Max (Row_Pos71, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res10,
      Kind              => Lkt_Generic_Param_Decl_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res10,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_Lkt_Node_Vectors.Vector renames
         Tmp_List10.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res10.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List10);

--  END <List (root of 'generic_decl') at parser.lkt:162:9>




if List_Pos10 /= No_Token_Index then

   Row_Pos71 := List_Pos10;

else
   Row_Pos71 := No_Token_Index;
   goto Exit_Row71_0;

end if;


--  BEGIN <Token(<WithText RBrack>, ) (root of 'generic_decl') at parser.lkt:163:9>

Token_Res92 := Row_Pos71;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res92));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_R_Brack)
   then
       Token_Pos92 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos71 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos71,
             Expected_Token_Id => Lkt_R_Brack,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos92 := Row_Pos71 + 1;
   end if;
end;

--  END <Token(<WithText RBrack>, ) (root of 'generic_decl') at parser.lkt:163:9>




if Token_Pos92 /= No_Token_Index then

   Row_Pos71 := Token_Pos92;

else
   Row_Pos71 := No_Token_Index;
   goto Exit_Row71_0;

end if;


--  BEGIN <Defer (for 'bare_decl') at parser.lkt:164:9>

Defer_Res94 :=
   Bare_Decl_Or_Parse0 (Parser, Row_Pos71);
Defer_Pos94 := Parser.Current_Pos;

--  END <Defer (for 'bare_decl') at parser.lkt:164:9>




if Defer_Pos94 /= No_Token_Index then

   Row_Pos71 := Defer_Pos94;

else
   Row_Pos71 := No_Token_Index;
   goto Exit_Row71_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row71_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'generic_decl') at parser.lkt:159:21>



if Row_Pos71 /= No_Token_Index then

   Transform_Res62 := Allocate_Generic_Decl (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res62,
      Kind => Lkt_Generic_Decl,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos71 = Pos
                            then No_Token_Index
                            else Row_Pos71 - 1));

      
      Initialize_Fields_For_Generic_Decl
        (Self => Transform_Res62,
         Generic_Decl_F_Generic_Param_Decls => List_Res10,
         Generic_Decl_F_Decl => Defer_Res94);

         if List_Res10 /= null and then Is_Incomplete (List_Res10) then
            Transform_Res62.Last_Attempted_Child := 0;
         elsif List_Res10 /= null and then not Is_Ghost (List_Res10) then
            Transform_Res62.Last_Attempted_Child := -1;
         end if;
         if Defer_Res94 /= null and then Is_Incomplete (Defer_Res94) then
            Transform_Res62.Last_Attempted_Child := 0;
         elsif Defer_Res94 /= null and then not Is_Ghost (Defer_Res94) then
            Transform_Res62.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos71 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags62);
end if;

--  END <Transform(<ASTNodeType GenericDecl>) (root of 'generic_decl') at parser.lkt:159:21>


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (PP.Generic_Decl_Transform_Parse0_Memo,
      Row_Pos71 /= No_Token_Index,
      Transform_Res62,
      Pos,
      Row_Pos71);


   Parser.Current_Pos := Row_Pos71;

   return Transform_Res62;
end Generic_Decl_Transform_Parse0;

   


function Generic_Param_Type_Transform_Parse1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Full_Decl
is
   use Bare_Full_Decl_Memos;

      Row_Pos72 :
            Token_Index
               := No_Token_Index;
      Defer_Pos95 :
            Token_Index
               := No_Token_Index;
      Defer_Res95 :
            Bare_String_Lit
               := No_Bare_Lkt_Node;
      Lst_Cpos11 :
            Token_Index
               := No_Token_Index;
      Tmp_List11 :
            Free_Parse_List;
      Defer_Pos96 :
            Token_Index
               := No_Token_Index;
      Defer_Res96 :
            Bare_Decl_Annotation
               := No_Bare_Lkt_Node;
      List_Pos11 :
            Token_Index
               := No_Token_Index;
      List_Res11 :
            Bare_Decl_Annotation_List
               := No_Bare_Lkt_Node;
      Row_Pos73 :
            Token_Index
               := No_Token_Index;
      Token_Pos93 :
            Token_Index
               := No_Token_Index;
      Token_Res93 :
            Token_Index
               := No_Token_Index;
      Opt_Res1 :
            Bare_Class_Qualifier
               := No_Bare_Lkt_Node;
      Defer_Pos97 :
            Token_Index
               := No_Token_Index;
      Defer_Res97 :
            Bare_Def_Id
               := No_Bare_Lkt_Node;
      Null_Res3 :
            Bare_Type_Ref_List
               := No_Bare_Lkt_Node;
      Transform_Res63 :
            Bare_Generic_Param_Type_Decl
               := No_Bare_Lkt_Node;
      Transform_Diags63 :
            Ada.Containers.Count_Type;
      Transform_Res64 :
            Bare_Full_Decl
               := No_Bare_Lkt_Node;
      Transform_Diags64 :
            Ada.Containers.Count_Type;


   PP : constant Parser_Private_Part := +Parser.Private_Part;
   M  : Memo_Entry := Get (PP.Generic_Param_Type_Transform_Parse1_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res64 := M.Instance;
      return Transform_Res64;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res64;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  BEGIN <Transform(<ASTNodeType FullDecl>) (root of 'generic_param_type') at parser.lkt:166:27>

Transform_Diags64 := Parser.Diagnostics.Length;


--  BEGIN <_Row (root of 'generic_param_type') at parser.lkt:166:27>

Row_Pos72 := Pos;



--  BEGIN <Defer (for 'doc') at parser.lkt:167:9>

Defer_Res95 :=
   Doc_Opt_Parse0 (Parser, Row_Pos72);
Defer_Pos95 := Parser.Current_Pos;

--  END <Defer (for 'doc') at parser.lkt:167:9>




if Defer_Pos95 /= No_Token_Index then

   Row_Pos72 := Defer_Pos95;

else
   Row_Pos72 := No_Token_Index;
   goto Exit_Row72_0;

end if;


--  BEGIN <List (root of 'generic_param_type') at parser.lkt:168:9>

    List_Pos11 := Row_Pos72;



Lst_Cpos11 := Row_Pos72;
Tmp_List11 := Get_Parse_List (Parser);


loop
   
--  BEGIN <Defer (for 'decl_annotation') at parser.lkt:168:15>

Defer_Res96 :=
   Decl_Annotation_Transform_Parse0 (Parser, Lst_Cpos11);
Defer_Pos96 := Parser.Current_Pos;

--  END <Defer (for 'decl_annotation') at parser.lkt:168:15>


   exit when Defer_Pos96 = No_Token_Index;

   List_Pos11 := Defer_Pos96;
   Lst_Cpos11 := List_Pos11;

   Tmp_List11.Nodes.Append (Defer_Res96);

end loop;


declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List11.Nodes.Length;
begin
   List_Res11 := Allocate_Decl_Annotation_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Row_Pos72;
      Token_End := (if Lst_Cpos11 = Row_Pos72
                    then Row_Pos72
                    else List_Pos11 - 1);

   else
      Token_Start := Token_Index'Max (Row_Pos72, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res11,
      Kind              => Lkt_Decl_Annotation_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res11,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_Lkt_Node_Vectors.Vector renames
         Tmp_List11.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res11.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List11);

--  END <List (root of 'generic_param_type') at parser.lkt:168:9>




if List_Pos11 /= No_Token_Index then

   Row_Pos72 := List_Pos11;

else
   Row_Pos72 := No_Token_Index;
   goto Exit_Row72_0;

end if;


--  BEGIN <Transform(<ASTNodeType GenericParamTypeDecl>) (root of 'generic_param_type') at parser.lkt:169:9>

Transform_Diags63 := Parser.Diagnostics.Length;


--  BEGIN <_Row (root of 'generic_param_type') at parser.lkt:169:9>

Row_Pos73 := Row_Pos72;



--  BEGIN <Opt (root of 'generic_param_type') at parser.lkt:170:13>












--  BEGIN <Token(<WithText ClassKw>, ) (root of 'generic_param_type') at parser.lkt:170:28>

Token_Res93 := Row_Pos73;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res93));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_Class_Kw)
   then
       Token_Pos93 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos73 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos73,
             Expected_Token_Id => Lkt_Class_Kw,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos93 := Row_Pos73 + 1;
   end if;
end;

--  END <Token(<WithText ClassKw>, ) (root of 'generic_param_type') at parser.lkt:170:28>


if Token_Pos93 = No_Token_Index then

         Opt_Res1 := Allocate_Class_Qualifier_Absent (Parser.Mem_Pool);
         Initialize
           (Self              => Opt_Res1,
            Kind              => Lkt_Class_Qualifier_Absent,
            Unit              => Parser.Unit,
            Token_Start_Index => Row_Pos73,
            Token_End_Index   => No_Token_Index);


       
   Token_Pos93 := Row_Pos73;


else

      Opt_Res1 := Allocate_Class_Qualifier_Present (Parser.Mem_Pool);
      Initialize
        (Self              => Opt_Res1,
         Kind              => Lkt_Class_Qualifier_Present,
         Unit              => Parser.Unit,
         Token_Start_Index => Row_Pos73,
         Token_End_Index   => Token_Pos93 - 1);

end if;

--  END <Opt (root of 'generic_param_type') at parser.lkt:170:13>




if Token_Pos93 /= No_Token_Index then

   Row_Pos73 := Token_Pos93;

else
   Row_Pos73 := No_Token_Index;
   goto Exit_Row73_0;

end if;


--  BEGIN <Defer (for 'def_id') at parser.lkt:170:37>

Defer_Res97 :=
   Def_Id_Transform_Parse0 (Parser, Row_Pos73);
Defer_Pos97 := Parser.Current_Pos;

--  END <Defer (for 'def_id') at parser.lkt:170:37>




if Defer_Pos97 /= No_Token_Index then

   Row_Pos73 := Defer_Pos97;

else
   Row_Pos73 := No_Token_Index;
   goto Exit_Row73_0;

end if;


--  BEGIN <Null (root of 'generic_param_type') at parser.lkt:170:44>

   Null_Res3 := Allocate_Type_Ref_List (Parser.Mem_Pool);
   Initialize
     (Self              => Null_Res3,
      Kind              => Lkt_Type_Ref_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Index'Max (Row_Pos73, 1),
      Token_End_Index   => No_Token_Index);
   Initialize_List
     (Self   => Null_Res3,
      Parser => Parser,
      Count  => 0);


--  END <Null (root of 'generic_param_type') at parser.lkt:170:44>




if Row_Pos73 /= No_Token_Index then

   Row_Pos73 := Row_Pos73;

else
   Row_Pos73 := No_Token_Index;
   goto Exit_Row73_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row73_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'generic_param_type') at parser.lkt:169:9>



if Row_Pos73 /= No_Token_Index then

   Transform_Res63 := Allocate_Generic_Param_Type_Decl (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res63,
      Kind => Lkt_Generic_Param_Type_Decl,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos72,
      Token_End_Index   => (if Row_Pos73 = Row_Pos72
                            then No_Token_Index
                            else Row_Pos73 - 1));

      
      Initialize_Fields_For_Generic_Param_Type_Decl
        (Self => Transform_Res63,
         Generic_Param_Type_Decl_F_Has_Class => Opt_Res1,
         Generic_Param_Type_Decl_F_Syn_Name => Defer_Res97,
         Generic_Param_Type_Decl_F_Traits => Null_Res3);

         if Opt_Res1 /= null and then Is_Incomplete (Opt_Res1) then
            Transform_Res63.Last_Attempted_Child := 0;
         elsif Opt_Res1 /= null and then not Is_Ghost (Opt_Res1) then
            Transform_Res63.Last_Attempted_Child := -1;
         end if;
         if Defer_Res97 /= null and then Is_Incomplete (Defer_Res97) then
            Transform_Res63.Last_Attempted_Child := 0;
         elsif Defer_Res97 /= null and then not Is_Ghost (Defer_Res97) then
            Transform_Res63.Last_Attempted_Child := -1;
         end if;
         if Null_Res3 /= null and then Is_Incomplete (Null_Res3) then
            Transform_Res63.Last_Attempted_Child := 0;
         elsif Null_Res3 /= null and then not Is_Ghost (Null_Res3) then
            Transform_Res63.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos73 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags63);
end if;

--  END <Transform(<ASTNodeType GenericParamTypeDecl>) (root of 'generic_param_type') at parser.lkt:169:9>




if Row_Pos73 /= No_Token_Index then

   Row_Pos72 := Row_Pos73;

else
   Row_Pos72 := No_Token_Index;
   goto Exit_Row72_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row72_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'generic_param_type') at parser.lkt:166:27>



if Row_Pos72 /= No_Token_Index then

   Transform_Res64 := Allocate_Full_Decl (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res64,
      Kind => Lkt_Full_Decl,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos72 = Pos
                            then No_Token_Index
                            else Row_Pos72 - 1));

      
      Initialize_Fields_For_Full_Decl
        (Self => Transform_Res64,
         Full_Decl_F_Doc => Defer_Res95,
         Full_Decl_F_Decl_Annotations => List_Res11,
         Full_Decl_F_Decl => Transform_Res63);

         if Defer_Res95 /= null and then Is_Incomplete (Defer_Res95) then
            Transform_Res64.Last_Attempted_Child := 0;
         elsif Defer_Res95 /= null and then not Is_Ghost (Defer_Res95) then
            Transform_Res64.Last_Attempted_Child := -1;
         end if;
         if List_Res11 /= null and then Is_Incomplete (List_Res11) then
            Transform_Res64.Last_Attempted_Child := 0;
         elsif List_Res11 /= null and then not Is_Ghost (List_Res11) then
            Transform_Res64.Last_Attempted_Child := -1;
         end if;
         if Transform_Res63 /= null and then Is_Incomplete (Transform_Res63) then
            Transform_Res64.Last_Attempted_Child := 0;
         elsif Transform_Res63 /= null and then not Is_Ghost (Transform_Res63) then
            Transform_Res64.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos72 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags64);
end if;

--  END <Transform(<ASTNodeType FullDecl>) (root of 'generic_param_type') at parser.lkt:166:27>


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (PP.Generic_Param_Type_Transform_Parse1_Memo,
      Row_Pos72 /= No_Token_Index,
      Transform_Res64,
      Pos,
      Row_Pos72);


   Parser.Current_Pos := Row_Pos72;

   return Transform_Res64;
end Generic_Param_Type_Transform_Parse1;

   


function Grammar_Cut_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Grammar_Cut
is
   use Bare_Grammar_Cut_Memos;

      Row_Pos74 :
            Token_Index
               := No_Token_Index;
      Token_Pos94 :
            Token_Index
               := No_Token_Index;
      Token_Res94 :
            Token_Index
               := No_Token_Index;
      Transform_Res65 :
            Bare_Grammar_Cut
               := No_Bare_Lkt_Node;
      Transform_Diags65 :
            Ada.Containers.Count_Type;


   PP : constant Parser_Private_Part := +Parser.Private_Part;
   M  : Memo_Entry := Get (PP.Grammar_Cut_Transform_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res65 := M.Instance;
      return Transform_Res65;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res65;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  BEGIN <Transform(<ASTNodeType GrammarCut>) (root of 'grammar_cut') at parser.lkt:80:20>

Transform_Diags65 := Parser.Diagnostics.Length;


--  BEGIN <_Row (root of 'grammar_cut') at parser.lkt:80:20>

Row_Pos74 := Pos;



--  BEGIN <Token(<WithText Div>, ) (root of 'grammar_cut') at parser.lkt:80:31>

Token_Res94 := Row_Pos74;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res94));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_Div)
   then
       Token_Pos94 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos74 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos74,
             Expected_Token_Id => Lkt_Div,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos94 := Row_Pos74 + 1;
   end if;
end;

--  END <Token(<WithText Div>, ) (root of 'grammar_cut') at parser.lkt:80:31>




if Token_Pos94 /= No_Token_Index then

   Row_Pos74 := Token_Pos94;

else
   Row_Pos74 := No_Token_Index;
   goto Exit_Row74_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row74_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'grammar_cut') at parser.lkt:80:20>



if Row_Pos74 /= No_Token_Index then

   Transform_Res65 := Allocate_Grammar_Cut (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res65,
      Kind => Lkt_Grammar_Cut,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos74 = Pos
                            then No_Token_Index
                            else Row_Pos74 - 1));

      
      Initialize_Fields_For_Grammar_Cut
        (Self => Transform_Res65);



elsif Row_Pos74 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags65);
end if;

--  END <Transform(<ASTNodeType GrammarCut>) (root of 'grammar_cut') at parser.lkt:80:20>


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (PP.Grammar_Cut_Transform_Parse0_Memo,
      Row_Pos74 /= No_Token_Index,
      Transform_Res65,
      Pos,
      Row_Pos74);


   Parser.Current_Pos := Row_Pos74;

   return Transform_Res65;
end Grammar_Cut_Transform_Parse0;

   


function Grammar_Decl_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Grammar_Decl
is
   use Bare_Grammar_Decl_Memos;

      Row_Pos75 :
            Token_Index
               := No_Token_Index;
      Token_Pos95 :
            Token_Index
               := No_Token_Index;
      Token_Res95 :
            Token_Index
               := No_Token_Index;
      Defer_Pos98 :
            Token_Index
               := No_Token_Index;
      Defer_Res98 :
            Bare_Def_Id
               := No_Bare_Lkt_Node;
      Token_Pos96 :
            Token_Index
               := No_Token_Index;
      Token_Res96 :
            Token_Index
               := No_Token_Index;
      Lst_Cpos12 :
            Token_Index
               := No_Token_Index;
      Tmp_List12 :
            Free_Parse_List;
      Defer_Pos99 :
            Token_Index
               := No_Token_Index;
      Defer_Res99 :
            Bare_Full_Decl
               := No_Bare_Lkt_Node;
      List_Pos12 :
            Token_Index
               := No_Token_Index;
      List_Res12 :
            Bare_Full_Decl_List
               := No_Bare_Lkt_Node;
      Token_Pos97 :
            Token_Index
               := No_Token_Index;
      Token_Res97 :
            Token_Index
               := No_Token_Index;
      Transform_Res66 :
            Bare_Grammar_Decl
               := No_Bare_Lkt_Node;
      Transform_Diags66 :
            Ada.Containers.Count_Type;


   PP : constant Parser_Private_Part := +Parser.Private_Part;
   M  : Memo_Entry := Get (PP.Grammar_Decl_Transform_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res66 := M.Instance;
      return Transform_Res66;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res66;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  BEGIN <Transform(<ASTNodeType GrammarDecl>) (root of 'grammar_decl') at parser.lkt:16:21>

Transform_Diags66 := Parser.Diagnostics.Length;


--  BEGIN <_Row (root of 'grammar_decl') at parser.lkt:16:21>

Row_Pos75 := Pos;



--  BEGIN <Token(<WithText GrammarKw>, ) (root of 'grammar_decl') at parser.lkt:16:33>

Token_Res95 := Row_Pos75;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res95));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_Grammar_Kw)
   then
       Token_Pos95 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos75 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos75,
             Expected_Token_Id => Lkt_Grammar_Kw,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos95 := Row_Pos75 + 1;
   end if;
end;

--  END <Token(<WithText GrammarKw>, ) (root of 'grammar_decl') at parser.lkt:16:33>




if Token_Pos95 /= No_Token_Index then

   Row_Pos75 := Token_Pos95;

else
   Row_Pos75 := No_Token_Index;
   goto Exit_Row75_0;

end if;


--  BEGIN <Defer (for 'def_id') at parser.lkt:16:43>

Defer_Res98 :=
   Def_Id_Transform_Parse0 (Parser, Row_Pos75);
Defer_Pos98 := Parser.Current_Pos;

--  END <Defer (for 'def_id') at parser.lkt:16:43>




if Defer_Pos98 /= No_Token_Index then

   Row_Pos75 := Defer_Pos98;

else
   Row_Pos75 := No_Token_Index;
   goto Exit_Row75_0;

end if;


--  BEGIN <Token(<WithText LBrace>, ) (root of 'grammar_decl') at parser.lkt:16:50>

Token_Res96 := Row_Pos75;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res96));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_L_Brace)
   then
       Token_Pos96 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos75 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos75,
             Expected_Token_Id => Lkt_L_Brace,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos96 := Row_Pos75 + 1;
   end if;
end;

--  END <Token(<WithText LBrace>, ) (root of 'grammar_decl') at parser.lkt:16:50>




if Token_Pos96 /= No_Token_Index then

   Row_Pos75 := Token_Pos96;

else
   Row_Pos75 := No_Token_Index;
   goto Exit_Row75_0;

end if;


--  BEGIN <List (root of 'grammar_decl') at parser.lkt:16:54>

    List_Pos12 := Row_Pos75;



Lst_Cpos12 := Row_Pos75;
Tmp_List12 := Get_Parse_List (Parser);


loop
   
--  BEGIN <Defer (for 'decl') at parser.lkt:16:60>

Defer_Res99 :=
   Decl_Transform_Parse0 (Parser, Lst_Cpos12);
Defer_Pos99 := Parser.Current_Pos;

--  END <Defer (for 'decl') at parser.lkt:16:60>


   exit when Defer_Pos99 = No_Token_Index;

   List_Pos12 := Defer_Pos99;
   Lst_Cpos12 := List_Pos12;

   Tmp_List12.Nodes.Append (Defer_Res99);

end loop;


declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List12.Nodes.Length;
begin
   List_Res12 := Allocate_Full_Decl_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Row_Pos75;
      Token_End := (if Lst_Cpos12 = Row_Pos75
                    then Row_Pos75
                    else List_Pos12 - 1);

   else
      Token_Start := Token_Index'Max (Row_Pos75, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res12,
      Kind              => Lkt_Full_Decl_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res12,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_Lkt_Node_Vectors.Vector renames
         Tmp_List12.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res12.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List12);

--  END <List (root of 'grammar_decl') at parser.lkt:16:54>




if List_Pos12 /= No_Token_Index then

   Row_Pos75 := List_Pos12;

else
   Row_Pos75 := No_Token_Index;
   goto Exit_Row75_0;

end if;


--  BEGIN <Token(<WithText RBrace>, ) (root of 'grammar_decl') at parser.lkt:16:66>

Token_Res97 := Row_Pos75;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res97));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_R_Brace)
   then
       Token_Pos97 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos75 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos75,
             Expected_Token_Id => Lkt_R_Brace,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos97 := Row_Pos75 + 1;
   end if;
end;

--  END <Token(<WithText RBrace>, ) (root of 'grammar_decl') at parser.lkt:16:66>




if Token_Pos97 /= No_Token_Index then

   Row_Pos75 := Token_Pos97;

else
   Row_Pos75 := No_Token_Index;
   goto Exit_Row75_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row75_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'grammar_decl') at parser.lkt:16:21>



if Row_Pos75 /= No_Token_Index then

   Transform_Res66 := Allocate_Grammar_Decl (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res66,
      Kind => Lkt_Grammar_Decl,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos75 = Pos
                            then No_Token_Index
                            else Row_Pos75 - 1));

      
      Initialize_Fields_For_Grammar_Decl
        (Self => Transform_Res66,
         Grammar_Decl_F_Syn_Name => Defer_Res98,
         Grammar_Decl_F_Rules => List_Res12);

         if Defer_Res98 /= null and then Is_Incomplete (Defer_Res98) then
            Transform_Res66.Last_Attempted_Child := 0;
         elsif Defer_Res98 /= null and then not Is_Ghost (Defer_Res98) then
            Transform_Res66.Last_Attempted_Child := -1;
         end if;
         if List_Res12 /= null and then Is_Incomplete (List_Res12) then
            Transform_Res66.Last_Attempted_Child := 0;
         elsif List_Res12 /= null and then not Is_Ghost (List_Res12) then
            Transform_Res66.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos75 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags66);
end if;

--  END <Transform(<ASTNodeType GrammarDecl>) (root of 'grammar_decl') at parser.lkt:16:21>


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (PP.Grammar_Decl_Transform_Parse0_Memo,
      Row_Pos75 /= No_Token_Index,
      Transform_Res66,
      Pos,
      Row_Pos75);


   Parser.Current_Pos := Row_Pos75;

   return Transform_Res66;
end Grammar_Decl_Transform_Parse0;

   


function Grammar_Discard_Expr_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Grammar_Discard
is
   use Bare_Grammar_Discard_Memos;

      Row_Pos76 :
            Token_Index
               := No_Token_Index;
      Token_Pos98 :
            Token_Index
               := No_Token_Index;
      Token_Res98 :
            Token_Index
               := No_Token_Index;
      Token_Pos99 :
            Token_Index
               := No_Token_Index;
      Token_Res99 :
            Token_Index
               := No_Token_Index;
      Defer_Pos100 :
            Token_Index
               := No_Token_Index;
      Defer_Res100 :
            Bare_Grammar_Expr
               := No_Bare_Lkt_Node;
      Token_Pos100 :
            Token_Index
               := No_Token_Index;
      Token_Res100 :
            Token_Index
               := No_Token_Index;
      Transform_Res67 :
            Bare_Grammar_Discard
               := No_Bare_Lkt_Node;
      Transform_Diags67 :
            Ada.Containers.Count_Type;


   PP : constant Parser_Private_Part := +Parser.Private_Part;
   M  : Memo_Entry := Get (PP.Grammar_Discard_Expr_Transform_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res67 := M.Instance;
      return Transform_Res67;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res67;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  BEGIN <Transform(<ASTNodeType GrammarDiscard>) (root of 'grammar_discard_expr') at parser.lkt:87:29>

Transform_Diags67 := Parser.Diagnostics.Length;


--  BEGIN <_Row (root of 'grammar_discard_expr') at parser.lkt:87:29>

Row_Pos76 := Pos;



--  BEGIN <Token(<WithText DiscardKw>, ) (root of 'grammar_discard_expr') at parser.lkt:87:44>

Token_Res98 := Row_Pos76;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res98));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_Discard_Kw)
   then
       Token_Pos98 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos76 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos76,
             Expected_Token_Id => Lkt_Discard_Kw,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos98 := Row_Pos76 + 1;
   end if;
end;

--  END <Token(<WithText DiscardKw>, ) (root of 'grammar_discard_expr') at parser.lkt:87:44>




if Token_Pos98 /= No_Token_Index then

   Row_Pos76 := Token_Pos98;

else
   Row_Pos76 := No_Token_Index;
   goto Exit_Row76_0;

end if;


--  BEGIN <Token(<WithText LPar>, ) (root of 'grammar_discard_expr') at parser.lkt:87:54>

Token_Res99 := Row_Pos76;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res99));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_L_Par)
   then
       Token_Pos99 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos76 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos76,
             Expected_Token_Id => Lkt_L_Par,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos99 := Row_Pos76 + 1;
   end if;
end;

--  END <Token(<WithText LPar>, ) (root of 'grammar_discard_expr') at parser.lkt:87:54>




if Token_Pos99 /= No_Token_Index then

   Row_Pos76 := Token_Pos99;

else
   Row_Pos76 := No_Token_Index;
   goto Exit_Row76_0;

end if;


--  BEGIN <Defer (for 'grammar_expr') at parser.lkt:87:58>

Defer_Res100 :=
   Grammar_Expr_Or_Parse0 (Parser, Row_Pos76);
Defer_Pos100 := Parser.Current_Pos;

--  END <Defer (for 'grammar_expr') at parser.lkt:87:58>




if Defer_Pos100 /= No_Token_Index then

   Row_Pos76 := Defer_Pos100;

else
   Row_Pos76 := No_Token_Index;
   goto Exit_Row76_0;

end if;


--  BEGIN <Token(<WithText RPar>, ) (root of 'grammar_discard_expr') at parser.lkt:87:71>

Token_Res100 := Row_Pos76;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res100));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_R_Par)
   then
       Token_Pos100 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos76 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos76,
             Expected_Token_Id => Lkt_R_Par,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos100 := Row_Pos76 + 1;
   end if;
end;

--  END <Token(<WithText RPar>, ) (root of 'grammar_discard_expr') at parser.lkt:87:71>




if Token_Pos100 /= No_Token_Index then

   Row_Pos76 := Token_Pos100;

else
   Row_Pos76 := No_Token_Index;
   goto Exit_Row76_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row76_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'grammar_discard_expr') at parser.lkt:87:29>



if Row_Pos76 /= No_Token_Index then

   Transform_Res67 := Allocate_Grammar_Discard (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res67,
      Kind => Lkt_Grammar_Discard,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos76 = Pos
                            then No_Token_Index
                            else Row_Pos76 - 1));

      
      Initialize_Fields_For_Grammar_Discard
        (Self => Transform_Res67,
         Grammar_Discard_F_Expr => Defer_Res100);

         if Defer_Res100 /= null and then Is_Incomplete (Defer_Res100) then
            Transform_Res67.Last_Attempted_Child := 0;
         elsif Defer_Res100 /= null and then not Is_Ghost (Defer_Res100) then
            Transform_Res67.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos76 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags67);
end if;

--  END <Transform(<ASTNodeType GrammarDiscard>) (root of 'grammar_discard_expr') at parser.lkt:87:29>


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (PP.Grammar_Discard_Expr_Transform_Parse0_Memo,
      Row_Pos76 /= No_Token_Index,
      Transform_Res67,
      Pos,
      Row_Pos76);


   Parser.Current_Pos := Row_Pos76;

   return Transform_Res67;
end Grammar_Discard_Expr_Transform_Parse0;

   


function Grammar_Expr_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Grammar_Expr
is
   use Bare_Grammar_Expr_Memos;

      Row_Pos77 :
            Token_Index
               := No_Token_Index;
      Defer_Pos101 :
            Token_Index
               := No_Token_Index;
      Defer_Res101 :
            Bare_Grammar_Expr
               := No_Bare_Lkt_Node;
      Token_Pos101 :
            Token_Index
               := No_Token_Index;
      Token_Res101 :
            Token_Index
               := No_Token_Index;
      Token_Pos102 :
            Token_Index
               := No_Token_Index;
      Token_Res102 :
            Token_Index
               := No_Token_Index;
      Token_Pos103 :
            Token_Index
               := No_Token_Index;
      Token_Res103 :
            Token_Index
               := No_Token_Index;
      Defer_Pos102 :
            Token_Index
               := No_Token_Index;
      Defer_Res102 :
            Bare_Grammar_Expr
               := No_Bare_Lkt_Node;
      Token_Pos104 :
            Token_Index
               := No_Token_Index;
      Token_Res104 :
            Token_Index
               := No_Token_Index;
      Transform_Res68 :
            Bare_Grammar_Dont_Skip
               := No_Bare_Lkt_Node;
      Transform_Diags68 :
            Ada.Containers.Count_Type;
      Row_Pos78 :
            Token_Index
               := No_Token_Index;
      Defer_Pos103 :
            Token_Index
               := No_Token_Index;
      Defer_Res103 :
            Bare_Grammar_Expr
               := No_Bare_Lkt_Node;
      Token_Pos105 :
            Token_Index
               := No_Token_Index;
      Token_Res105 :
            Token_Index
               := No_Token_Index;
      Token_Pos106 :
            Token_Index
               := No_Token_Index;
      Token_Res106 :
            Token_Index
               := No_Token_Index;
      Token_Pos107 :
            Token_Index
               := No_Token_Index;
      Token_Res107 :
            Token_Index
               := No_Token_Index;
      Defer_Pos104 :
            Token_Index
               := No_Token_Index;
      Defer_Res104 :
            Bare_Expr
               := No_Bare_Lkt_Node;
      Token_Pos108 :
            Token_Index
               := No_Token_Index;
      Token_Res108 :
            Token_Index
               := No_Token_Index;
      Transform_Res69 :
            Bare_Grammar_Predicate
               := No_Bare_Lkt_Node;
      Transform_Diags69 :
            Ada.Containers.Count_Type;
      Defer_Pos105 :
            Token_Index
               := No_Token_Index;
      Defer_Res105 :
            Bare_Grammar_Expr
               := No_Bare_Lkt_Node;
      Or_Pos18 :
            Token_Index
               := No_Token_Index;
      Or_Res18 :
            Bare_Grammar_Expr
               := No_Bare_Lkt_Node;

      Mem_Pos : Token_Index := Pos;
      Mem_Res : Bare_Grammar_Expr := No_Bare_Lkt_Node;

   PP : constant Parser_Private_Part := +Parser.Private_Part;
   M  : Memo_Entry := Get (PP.Grammar_Expr_Or_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Or_Res18 := M.Instance;
      return Or_Res18;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Or_Res18;
   end if;

       Set (PP.Grammar_Expr_Or_Parse0_Memo, False, Or_Res18, Pos, Mem_Pos);

       <<Try_Again>>



   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  BEGIN <Or (root of 'grammar_expr') at parser.lkt:59:21>

Or_Pos18 := No_Token_Index;
Or_Res18 := No_Bare_Lkt_Node;
    
--  BEGIN <Transform(<ASTNodeType GrammarDontSkip>) (root of 'grammar_expr') at parser.lkt:60:11>

Transform_Diags68 := Parser.Diagnostics.Length;


--  BEGIN <_Row (root of 'grammar_expr') at parser.lkt:60:11>

Row_Pos77 := Pos;



--  BEGIN <Defer (for 'grammar_expr') at parser.lkt:61:13>

Defer_Res101 :=
   Grammar_Expr_Or_Parse0 (Parser, Row_Pos77);
Defer_Pos101 := Parser.Current_Pos;

--  END <Defer (for 'grammar_expr') at parser.lkt:61:13>




if Defer_Pos101 /= No_Token_Index then

   Row_Pos77 := Defer_Pos101;

else
   Row_Pos77 := No_Token_Index;
   goto Exit_Row77_0;

end if;


--  BEGIN <Token(<WithText Dot>, ) (root of 'grammar_expr') at parser.lkt:61:26>

Token_Res101 := Row_Pos77;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res101));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_Dot)
   then
       Token_Pos101 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos77 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos77,
             Expected_Token_Id => Lkt_Dot,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos101 := Row_Pos77 + 1;
   end if;
end;

--  END <Token(<WithText Dot>, ) (root of 'grammar_expr') at parser.lkt:61:26>




if Token_Pos101 /= No_Token_Index then

   Row_Pos77 := Token_Pos101;

else
   Row_Pos77 := No_Token_Index;
   goto Exit_Row77_0;

end if;


--  BEGIN <Token(<WithSymbol Identifier>, dont_skip) (root of 'grammar_expr') at parser.lkt:61:30>

Token_Res102 := Row_Pos77;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res102));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_Identifier)
      or else T.Symbol /= Precomputed_Symbol
        (Precomputed_Symbol_Table (Parser.TDH.Symbols),
         Precomputed_Sym_Dont_Skip)
   then
       Token_Pos102 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos77 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos77,
             Expected_Token_Id => Lkt_Identifier,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos102 := Row_Pos77 + 1;
   end if;
end;

--  END <Token(<WithSymbol Identifier>, dont_skip) (root of 'grammar_expr') at parser.lkt:61:30>




if Token_Pos102 /= No_Token_Index then

   Row_Pos77 := Token_Pos102;

else
   Row_Pos77 := No_Token_Index;
   goto Exit_Row77_0;

end if;


--  BEGIN <Token(<WithText LPar>, ) (root of 'grammar_expr') at parser.lkt:61:55>

Token_Res103 := Row_Pos77;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res103));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_L_Par)
   then
       Token_Pos103 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos77 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos77,
             Expected_Token_Id => Lkt_L_Par,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos103 := Row_Pos77 + 1;
   end if;
end;

--  END <Token(<WithText LPar>, ) (root of 'grammar_expr') at parser.lkt:61:55>




if Token_Pos103 /= No_Token_Index then

   Row_Pos77 := Token_Pos103;

else
   Row_Pos77 := No_Token_Index;
   goto Exit_Row77_0;

end if;


--  BEGIN <Defer (for 'grammar_expr') at parser.lkt:61:59>

Defer_Res102 :=
   Grammar_Expr_Or_Parse0 (Parser, Row_Pos77);
Defer_Pos102 := Parser.Current_Pos;

--  END <Defer (for 'grammar_expr') at parser.lkt:61:59>




if Defer_Pos102 /= No_Token_Index then

   Row_Pos77 := Defer_Pos102;

else
   Row_Pos77 := No_Token_Index;
   goto Exit_Row77_0;

end if;


--  BEGIN <Token(<WithText RPar>, ) (root of 'grammar_expr') at parser.lkt:61:72>

Token_Res104 := Row_Pos77;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res104));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_R_Par)
   then
       Token_Pos104 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos77 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos77,
             Expected_Token_Id => Lkt_R_Par,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos104 := Row_Pos77 + 1;
   end if;
end;

--  END <Token(<WithText RPar>, ) (root of 'grammar_expr') at parser.lkt:61:72>




if Token_Pos104 /= No_Token_Index then

   Row_Pos77 := Token_Pos104;

else
   Row_Pos77 := No_Token_Index;
   goto Exit_Row77_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row77_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'grammar_expr') at parser.lkt:60:11>



if Row_Pos77 /= No_Token_Index then

   Transform_Res68 := Allocate_Grammar_Dont_Skip (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res68,
      Kind => Lkt_Grammar_Dont_Skip,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos77 = Pos
                            then No_Token_Index
                            else Row_Pos77 - 1));

      
      Initialize_Fields_For_Grammar_Dont_Skip
        (Self => Transform_Res68,
         Grammar_Dont_Skip_F_Expr => Defer_Res101,
         Grammar_Dont_Skip_F_Dont_Skip => Defer_Res102);

         if Defer_Res101 /= null and then Is_Incomplete (Defer_Res101) then
            Transform_Res68.Last_Attempted_Child := 0;
         elsif Defer_Res101 /= null and then not Is_Ghost (Defer_Res101) then
            Transform_Res68.Last_Attempted_Child := -1;
         end if;
         if Defer_Res102 /= null and then Is_Incomplete (Defer_Res102) then
            Transform_Res68.Last_Attempted_Child := 0;
         elsif Defer_Res102 /= null and then not Is_Ghost (Defer_Res102) then
            Transform_Res68.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos77 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags68);
end if;

--  END <Transform(<ASTNodeType GrammarDontSkip>) (root of 'grammar_expr') at parser.lkt:60:11>

    if Row_Pos77 /= No_Token_Index then
        Or_Pos18 := Row_Pos77;
        Or_Res18 := Transform_Res68;
        goto Exit_Or19;
    end if;
    
--  BEGIN <Transform(<ASTNodeType GrammarPredicate>) (root of 'grammar_expr') at parser.lkt:63:11>

Transform_Diags69 := Parser.Diagnostics.Length;


--  BEGIN <_Row (root of 'grammar_expr') at parser.lkt:63:11>

Row_Pos78 := Pos;



--  BEGIN <Defer (for 'grammar_expr') at parser.lkt:64:13>

Defer_Res103 :=
   Grammar_Expr_Or_Parse0 (Parser, Row_Pos78);
Defer_Pos103 := Parser.Current_Pos;

--  END <Defer (for 'grammar_expr') at parser.lkt:64:13>




if Defer_Pos103 /= No_Token_Index then

   Row_Pos78 := Defer_Pos103;

else
   Row_Pos78 := No_Token_Index;
   goto Exit_Row78_0;

end if;


--  BEGIN <Token(<WithText Comb>, ) (root of 'grammar_expr') at parser.lkt:64:26>

Token_Res105 := Row_Pos78;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res105));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_Comb)
   then
       Token_Pos105 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos78 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos78,
             Expected_Token_Id => Lkt_Comb,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos105 := Row_Pos78 + 1;
   end if;
end;

--  END <Token(<WithText Comb>, ) (root of 'grammar_expr') at parser.lkt:64:26>




if Token_Pos105 /= No_Token_Index then

   Row_Pos78 := Token_Pos105;

else
   Row_Pos78 := No_Token_Index;
   goto Exit_Row78_0;

end if;


--  BEGIN <Token(<WithText WhenKw>, ) (root of 'grammar_expr') at parser.lkt:64:31>

Token_Res106 := Row_Pos78;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res106));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_When_Kw)
   then
       Token_Pos106 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos78 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos78,
             Expected_Token_Id => Lkt_When_Kw,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos106 := Row_Pos78 + 1;
   end if;
end;

--  END <Token(<WithText WhenKw>, ) (root of 'grammar_expr') at parser.lkt:64:31>




if Token_Pos106 /= No_Token_Index then

   Row_Pos78 := Token_Pos106;

else
   Row_Pos78 := No_Token_Index;
   goto Exit_Row78_0;

end if;


--  BEGIN <Token(<WithText LPar>, ) (root of 'grammar_expr') at parser.lkt:64:38>

Token_Res107 := Row_Pos78;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res107));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_L_Par)
   then
       Token_Pos107 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos78 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos78,
             Expected_Token_Id => Lkt_L_Par,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos107 := Row_Pos78 + 1;
   end if;
end;

--  END <Token(<WithText LPar>, ) (root of 'grammar_expr') at parser.lkt:64:38>




if Token_Pos107 /= No_Token_Index then

   Row_Pos78 := Token_Pos107;

else
   Row_Pos78 := No_Token_Index;
   goto Exit_Row78_0;

end if;


--  BEGIN <Defer (for 'basic_name') at parser.lkt:64:42>

Defer_Res104 :=
   Basic_Name_Or_Parse0 (Parser, Row_Pos78);
Defer_Pos104 := Parser.Current_Pos;

--  END <Defer (for 'basic_name') at parser.lkt:64:42>




if Defer_Pos104 /= No_Token_Index then

   Row_Pos78 := Defer_Pos104;

else
   Row_Pos78 := No_Token_Index;
   goto Exit_Row78_0;

end if;


--  BEGIN <Token(<WithText RPar>, ) (root of 'grammar_expr') at parser.lkt:64:53>

Token_Res108 := Row_Pos78;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res108));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_R_Par)
   then
       Token_Pos108 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos78 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos78,
             Expected_Token_Id => Lkt_R_Par,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos108 := Row_Pos78 + 1;
   end if;
end;

--  END <Token(<WithText RPar>, ) (root of 'grammar_expr') at parser.lkt:64:53>




if Token_Pos108 /= No_Token_Index then

   Row_Pos78 := Token_Pos108;

else
   Row_Pos78 := No_Token_Index;
   goto Exit_Row78_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row78_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'grammar_expr') at parser.lkt:63:11>



if Row_Pos78 /= No_Token_Index then

   Transform_Res69 := Allocate_Grammar_Predicate (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res69,
      Kind => Lkt_Grammar_Predicate,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos78 = Pos
                            then No_Token_Index
                            else Row_Pos78 - 1));

      
      Initialize_Fields_For_Grammar_Predicate
        (Self => Transform_Res69,
         Grammar_Predicate_F_Expr => Defer_Res103,
         Grammar_Predicate_F_Prop_Ref => Defer_Res104);

         if Defer_Res103 /= null and then Is_Incomplete (Defer_Res103) then
            Transform_Res69.Last_Attempted_Child := 0;
         elsif Defer_Res103 /= null and then not Is_Ghost (Defer_Res103) then
            Transform_Res69.Last_Attempted_Child := -1;
         end if;
         if Defer_Res104 /= null and then Is_Incomplete (Defer_Res104) then
            Transform_Res69.Last_Attempted_Child := 0;
         elsif Defer_Res104 /= null and then not Is_Ghost (Defer_Res104) then
            Transform_Res69.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos78 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags69);
end if;

--  END <Transform(<ASTNodeType GrammarPredicate>) (root of 'grammar_expr') at parser.lkt:63:11>

    if Row_Pos78 /= No_Token_Index then
        Or_Pos18 := Row_Pos78;
        Or_Res18 := Transform_Res69;
        goto Exit_Or19;
    end if;
    
--  BEGIN <Defer (for 'grammar_primary') at parser.lkt:66:11>

Defer_Res105 :=
   Grammar_Primary_Or_Parse0 (Parser, Pos);
Defer_Pos105 := Parser.Current_Pos;

--  END <Defer (for 'grammar_primary') at parser.lkt:66:11>

    if Defer_Pos105 /= No_Token_Index then
        Or_Pos18 := Defer_Pos105;
        Or_Res18 := Defer_Res105;
        goto Exit_Or19;
    end if;
<<Exit_Or19>>

--  END <Or (root of 'grammar_expr') at parser.lkt:59:21>


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------

      if Or_Pos18 > Mem_Pos then
         Mem_Pos := Or_Pos18;
         Mem_Res := Or_Res18;
         Set
           (PP.Grammar_Expr_Or_Parse0_Memo,
            Or_Pos18 /= No_Token_Index,
            Or_Res18,
            Pos,
            Or_Pos18);
         goto Try_Again;

      elsif Mem_Pos > Pos then
         Or_Res18 := Mem_Res;
         Or_Pos18 := Mem_Pos;
         goto No_Memo;
      end if;

   Set
     (PP.Grammar_Expr_Or_Parse0_Memo,
      Or_Pos18 /= No_Token_Index,
      Or_Res18,
      Pos,
      Or_Pos18);

       <<No_Memo>>

   Parser.Current_Pos := Or_Pos18;

   return Or_Res18;
end Grammar_Expr_Or_Parse0;

   


function Grammar_Implicit_Pick_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Grammar_Implicit_Pick
is
   use Bare_Grammar_Implicit_Pick_Memos;

      Row_Pos79 :
            Token_Index
               := No_Token_Index;
      Lst_Cpos13 :
            Token_Index
               := No_Token_Index;
      Tmp_List13 :
            Free_Parse_List;
      Defer_Pos106 :
            Token_Index
               := No_Token_Index;
      Defer_Res106 :
            Bare_Grammar_Expr
               := No_Bare_Lkt_Node;
      List_Pos13 :
            Token_Index
               := No_Token_Index;
      List_Res13 :
            Bare_Grammar_Expr_List
               := No_Bare_Lkt_Node;
      Transform_Res70 :
            Bare_Grammar_Implicit_Pick
               := No_Bare_Lkt_Node;
      Transform_Diags70 :
            Ada.Containers.Count_Type;


   PP : constant Parser_Private_Part := +Parser.Private_Part;
   M  : Memo_Entry := Get (PP.Grammar_Implicit_Pick_Transform_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res70 := M.Instance;
      return Transform_Res70;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res70;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  BEGIN <Transform(<ASTNodeType GrammarImplicitPick>) (root of 'grammar_implicit_pick') at parser.lkt:71:30>

Transform_Diags70 := Parser.Diagnostics.Length;


--  BEGIN <_Row (root of 'grammar_implicit_pick') at parser.lkt:71:30>

Row_Pos79 := Pos;



--  BEGIN <List (root of 'grammar_implicit_pick') at parser.lkt:71:50>

    List_Pos13 := No_Token_Index;



Lst_Cpos13 := Row_Pos79;
Tmp_List13 := Get_Parse_List (Parser);


loop
   
--  BEGIN <Defer (for 'grammar_expr') at parser.lkt:71:56>

Defer_Res106 :=
   Grammar_Expr_Or_Parse0 (Parser, Lst_Cpos13);
Defer_Pos106 := Parser.Current_Pos;

--  END <Defer (for 'grammar_expr') at parser.lkt:71:56>


   exit when Defer_Pos106 = No_Token_Index;

   List_Pos13 := Defer_Pos106;
   Lst_Cpos13 := List_Pos13;

   Tmp_List13.Nodes.Append (Defer_Res106);

end loop;


declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List13.Nodes.Length;
begin
   List_Res13 := Allocate_Grammar_Expr_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Row_Pos79;
      Token_End := (if Lst_Cpos13 = Row_Pos79
                    then Row_Pos79
                    else List_Pos13 - 1);

   else
      Token_Start := Token_Index'Max (Row_Pos79, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res13,
      Kind              => Lkt_Grammar_Expr_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res13,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_Lkt_Node_Vectors.Vector renames
         Tmp_List13.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res13.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List13);

--  END <List (root of 'grammar_implicit_pick') at parser.lkt:71:50>




if List_Pos13 /= No_Token_Index then

   Row_Pos79 := List_Pos13;

else
   Row_Pos79 := No_Token_Index;
   goto Exit_Row79_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row79_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'grammar_implicit_pick') at parser.lkt:71:30>



if Row_Pos79 /= No_Token_Index then

   Transform_Res70 := Allocate_Grammar_Implicit_Pick (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res70,
      Kind => Lkt_Grammar_Implicit_Pick,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos79 = Pos
                            then No_Token_Index
                            else Row_Pos79 - 1));

      
      Initialize_Fields_For_Grammar_Implicit_Pick
        (Self => Transform_Res70,
         Grammar_Pick_F_Exprs => List_Res13);

         if List_Res13 /= null and then Is_Incomplete (List_Res13) then
            Transform_Res70.Last_Attempted_Child := 0;
         elsif List_Res13 /= null and then not Is_Ghost (List_Res13) then
            Transform_Res70.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos79 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags70);
end if;

--  END <Transform(<ASTNodeType GrammarImplicitPick>) (root of 'grammar_implicit_pick') at parser.lkt:71:30>


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (PP.Grammar_Implicit_Pick_Transform_Parse0_Memo,
      Row_Pos79 /= No_Token_Index,
      Transform_Res70,
      Pos,
      Row_Pos79);


   Parser.Current_Pos := Row_Pos79;

   return Transform_Res70;
end Grammar_Implicit_Pick_Transform_Parse0;

   


function Grammar_List_Expr_Transform_Parse3
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Grammar_List
is
   use Bare_Grammar_List_Memos;

      Row_Pos80 :
            Token_Index
               := No_Token_Index;
      Row_Pos81 :
            Token_Index
               := No_Token_Index;
      Token_Pos109 :
            Token_Index
               := No_Token_Index;
      Token_Res109 :
            Token_Index
               := No_Token_Index;
      Transform_Res71 :
            Bare_Default_List_Type_Ref
               := No_Bare_Lkt_Node;
      Transform_Diags71 :
            Ada.Containers.Count_Type;
      Defer_Pos107 :
            Token_Index
               := No_Token_Index;
      Defer_Res107 :
            Bare_Type_Ref
               := No_Bare_Lkt_Node;
      Or_Pos19 :
            Token_Index
               := No_Token_Index;
      Or_Res19 :
            Bare_Type_Ref
               := No_Bare_Lkt_Node;
      Row_Pos82 :
            Token_Index
               := No_Token_Index;
      Token_Pos110 :
            Token_Index
               := No_Token_Index;
      Token_Res110 :
            Token_Index
               := No_Token_Index;
      Transform_Res72 :
            Bare_List_Kind_One
               := No_Bare_Lkt_Node;
      Transform_Diags72 :
            Ada.Containers.Count_Type;
      Row_Pos83 :
            Token_Index
               := No_Token_Index;
      Token_Pos111 :
            Token_Index
               := No_Token_Index;
      Token_Res111 :
            Token_Index
               := No_Token_Index;
      Transform_Res73 :
            Bare_List_Kind_Zero
               := No_Bare_Lkt_Node;
      Transform_Diags73 :
            Ada.Containers.Count_Type;
      Or_Pos20 :
            Token_Index
               := No_Token_Index;
      Or_Res20 :
            Bare_List_Kind
               := No_Bare_Lkt_Node;
      Token_Pos112 :
            Token_Index
               := No_Token_Index;
      Token_Res112 :
            Token_Index
               := No_Token_Index;
      Defer_Pos108 :
            Token_Index
               := No_Token_Index;
      Defer_Res108 :
            Bare_Grammar_Implicit_Pick
               := No_Bare_Lkt_Node;
      Defer_Pos109 :
            Token_Index
               := No_Token_Index;
      Defer_Res109 :
            Bare_Grammar_Expr
               := No_Bare_Lkt_Node;
      Or_Pos21 :
            Token_Index
               := No_Token_Index;
      Or_Res21 :
            Bare_Grammar_Expr
               := No_Bare_Lkt_Node;
      Row_Pos84 :
            Token_Index
               := No_Token_Index;
      Token_Pos113 :
            Token_Index
               := No_Token_Index;
      Token_Res113 :
            Token_Index
               := No_Token_Index;
      Defer_Pos110 :
            Token_Index
               := No_Token_Index;
      Defer_Res110 :
            Bare_Grammar_List_Sep
               := No_Bare_Lkt_Node;
      Token_Pos114 :
            Token_Index
               := No_Token_Index;
      Token_Res114 :
            Token_Index
               := No_Token_Index;
      Transform_Res74 :
            Bare_Grammar_List
               := No_Bare_Lkt_Node;
      Transform_Diags74 :
            Ada.Containers.Count_Type;


   PP : constant Parser_Private_Part := +Parser.Private_Part;
   M  : Memo_Entry := Get (PP.Grammar_List_Expr_Transform_Parse3_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res74 := M.Instance;
      return Transform_Res74;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res74;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  BEGIN <Transform(<ASTNodeType GrammarList>) (root of 'grammar_list_expr') at parser.lkt:99:26>

Transform_Diags74 := Parser.Diagnostics.Length;


--  BEGIN <_Row (root of 'grammar_list_expr') at parser.lkt:99:26>

Row_Pos80 := Pos;



--  BEGIN <Or (root of 'grammar_list_expr') at parser.lkt:102:9>

Or_Pos19 := No_Token_Index;
Or_Res19 := No_Bare_Lkt_Node;
    
--  BEGIN <Transform(<ASTNodeType DefaultListTypeRef>) (root of 'grammar_list_expr') at parser.lkt:102:12>

Transform_Diags71 := Parser.Diagnostics.Length;


--  BEGIN <_Row (root of 'grammar_list_expr') at parser.lkt:102:12>

Row_Pos81 := Row_Pos80;



--  BEGIN <Token(<WithSymbol Identifier>, list) (root of 'grammar_list_expr') at parser.lkt:102:31>

Token_Res109 := Row_Pos81;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res109));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_Identifier)
      or else T.Symbol /= Precomputed_Symbol
        (Precomputed_Symbol_Table (Parser.TDH.Symbols),
         Precomputed_Sym_List)
   then
       Token_Pos109 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos81 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos81,
             Expected_Token_Id => Lkt_Identifier,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos109 := Row_Pos81 + 1;
   end if;
end;

--  END <Token(<WithSymbol Identifier>, list) (root of 'grammar_list_expr') at parser.lkt:102:31>




if Token_Pos109 /= No_Token_Index then

   Row_Pos81 := Token_Pos109;

else
   Row_Pos81 := No_Token_Index;
   goto Exit_Row81_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row81_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'grammar_list_expr') at parser.lkt:102:12>



if Row_Pos81 /= No_Token_Index then

   Transform_Res71 := Allocate_Default_List_Type_Ref (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res71,
      Kind => Lkt_Default_List_Type_Ref,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos80,
      Token_End_Index   => (if Row_Pos81 = Row_Pos80
                            then No_Token_Index
                            else Row_Pos81 - 1));

      
      Initialize_Fields_For_Default_List_Type_Ref
        (Self => Transform_Res71);



elsif Row_Pos81 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags71);
end if;

--  END <Transform(<ASTNodeType DefaultListTypeRef>) (root of 'grammar_list_expr') at parser.lkt:102:12>

    if Row_Pos81 /= No_Token_Index then
        Or_Pos19 := Row_Pos81;
        Or_Res19 := Transform_Res71;
        goto Exit_Or20;
    end if;
    
--  BEGIN <Defer (for 'type_ref') at parser.lkt:102:54>

Defer_Res107 :=
   Type_Ref_Or_Parse0 (Parser, Row_Pos80);
Defer_Pos107 := Parser.Current_Pos;

--  END <Defer (for 'type_ref') at parser.lkt:102:54>

    if Defer_Pos107 /= No_Token_Index then
        Or_Pos19 := Defer_Pos107;
        Or_Res19 := Defer_Res107;
        goto Exit_Or20;
    end if;
<<Exit_Or20>>

--  END <Or (root of 'grammar_list_expr') at parser.lkt:102:9>




if Or_Pos19 /= No_Token_Index then

   Row_Pos80 := Or_Pos19;

else
   Row_Pos80 := No_Token_Index;
   goto Exit_Row80_0;

end if;


--  BEGIN <Or (root of 'grammar_list_expr') at parser.lkt:104:9>

Or_Pos20 := No_Token_Index;
Or_Res20 := No_Bare_Lkt_Node;
    
--  BEGIN <Transform(<ASTNodeType ListKind.One>) (root of 'grammar_list_expr') at parser.lkt:104:12>

Transform_Diags72 := Parser.Diagnostics.Length;


--  BEGIN <_Row (root of 'grammar_list_expr') at parser.lkt:104:12>

Row_Pos82 := Row_Pos80;



--  BEGIN <Token(<WithText Plus>, ) (root of 'grammar_list_expr') at parser.lkt:104:25>

Token_Res110 := Row_Pos82;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res110));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_Plus)
   then
       Token_Pos110 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos82 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos82,
             Expected_Token_Id => Lkt_Plus,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos110 := Row_Pos82 + 1;
   end if;
end;

--  END <Token(<WithText Plus>, ) (root of 'grammar_list_expr') at parser.lkt:104:25>




if Token_Pos110 /= No_Token_Index then

   Row_Pos82 := Token_Pos110;

else
   Row_Pos82 := No_Token_Index;
   goto Exit_Row82_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row82_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'grammar_list_expr') at parser.lkt:104:12>



if Row_Pos82 /= No_Token_Index then

   Transform_Res72 := Allocate_List_Kind_One (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res72,
      Kind => Lkt_List_Kind_One,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos80,
      Token_End_Index   => (if Row_Pos82 = Row_Pos80
                            then No_Token_Index
                            else Row_Pos82 - 1));




elsif Row_Pos82 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags72);
end if;

--  END <Transform(<ASTNodeType ListKind.One>) (root of 'grammar_list_expr') at parser.lkt:104:12>

    if Row_Pos82 /= No_Token_Index then
        Or_Pos20 := Row_Pos82;
        Or_Res20 := Transform_Res72;
        goto Exit_Or21;
    end if;
    
--  BEGIN <Transform(<ASTNodeType ListKind.Zero>) (root of 'grammar_list_expr') at parser.lkt:104:32>

Transform_Diags73 := Parser.Diagnostics.Length;


--  BEGIN <_Row (root of 'grammar_list_expr') at parser.lkt:104:32>

Row_Pos83 := Row_Pos80;



--  BEGIN <Token(<WithText Times>, ) (root of 'grammar_list_expr') at parser.lkt:104:46>

Token_Res111 := Row_Pos83;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res111));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_Times)
   then
       Token_Pos111 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos83 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos83,
             Expected_Token_Id => Lkt_Times,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos111 := Row_Pos83 + 1;
   end if;
end;

--  END <Token(<WithText Times>, ) (root of 'grammar_list_expr') at parser.lkt:104:46>




if Token_Pos111 /= No_Token_Index then

   Row_Pos83 := Token_Pos111;

else
   Row_Pos83 := No_Token_Index;
   goto Exit_Row83_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row83_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'grammar_list_expr') at parser.lkt:104:32>



if Row_Pos83 /= No_Token_Index then

   Transform_Res73 := Allocate_List_Kind_Zero (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res73,
      Kind => Lkt_List_Kind_Zero,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos80,
      Token_End_Index   => (if Row_Pos83 = Row_Pos80
                            then No_Token_Index
                            else Row_Pos83 - 1));




elsif Row_Pos83 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags73);
end if;

--  END <Transform(<ASTNodeType ListKind.Zero>) (root of 'grammar_list_expr') at parser.lkt:104:32>

    if Row_Pos83 /= No_Token_Index then
        Or_Pos20 := Row_Pos83;
        Or_Res20 := Transform_Res73;
        goto Exit_Or21;
    end if;
<<Exit_Or21>>

--  END <Or (root of 'grammar_list_expr') at parser.lkt:104:9>




if Or_Pos20 /= No_Token_Index then

   Row_Pos80 := Or_Pos20;

else
   Row_Pos80 := No_Token_Index;
   goto Exit_Row80_0;

end if;


--  BEGIN <Token(<WithText LPar>, ) (root of 'grammar_list_expr') at parser.lkt:105:9>

Token_Res112 := Row_Pos80;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res112));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_L_Par)
   then
       Token_Pos112 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos80 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos80,
             Expected_Token_Id => Lkt_L_Par,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos112 := Row_Pos80 + 1;
   end if;
end;

--  END <Token(<WithText LPar>, ) (root of 'grammar_list_expr') at parser.lkt:105:9>




if Token_Pos112 /= No_Token_Index then

   Row_Pos80 := Token_Pos112;

else
   Row_Pos80 := No_Token_Index;
   goto Exit_Row80_0;

end if;


--  BEGIN <Or (root of 'grammar_list_expr') at parser.lkt:108:9>

Or_Pos21 := No_Token_Index;
Or_Res21 := No_Bare_Lkt_Node;
    
--  BEGIN <Defer (for 'grammar_implicit_pick') at parser.lkt:108:12>

Defer_Res108 :=
   Grammar_Implicit_Pick_Transform_Parse0 (Parser, Row_Pos80);
Defer_Pos108 := Parser.Current_Pos;

--  END <Defer (for 'grammar_implicit_pick') at parser.lkt:108:12>

    if Defer_Pos108 /= No_Token_Index then
        Or_Pos21 := Defer_Pos108;
        Or_Res21 := Defer_Res108;
        goto Exit_Or22;
    end if;
    
--  BEGIN <Defer (for 'grammar_expr') at parser.lkt:108:36>

Defer_Res109 :=
   Grammar_Expr_Or_Parse0 (Parser, Row_Pos80);
Defer_Pos109 := Parser.Current_Pos;

--  END <Defer (for 'grammar_expr') at parser.lkt:108:36>

    if Defer_Pos109 /= No_Token_Index then
        Or_Pos21 := Defer_Pos109;
        Or_Res21 := Defer_Res109;
        goto Exit_Or22;
    end if;
<<Exit_Or22>>

--  END <Or (root of 'grammar_list_expr') at parser.lkt:108:9>




if Or_Pos21 /= No_Token_Index then

   Row_Pos80 := Or_Pos21;

else
   Row_Pos80 := No_Token_Index;
   goto Exit_Row80_0;

end if;


--  BEGIN <Opt (root of 'grammar_list_expr') at parser.lkt:111:9>












--  BEGIN <_Extract (root of 'grammar_list_expr') at parser.lkt:111:10>

--  BEGIN <_Row (root of 'grammar_list_expr') at parser.lkt:111:10>

Row_Pos84 := Row_Pos80;



--  BEGIN <Token(<WithText Comma>, ) (root of 'grammar_list_expr') at parser.lkt:111:15>

Token_Res113 := Row_Pos84;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res113));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_Comma)
   then
       Token_Pos113 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos84 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos84,
             Expected_Token_Id => Lkt_Comma,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos113 := Row_Pos84 + 1;
   end if;
end;

--  END <Token(<WithText Comma>, ) (root of 'grammar_list_expr') at parser.lkt:111:15>




if Token_Pos113 /= No_Token_Index then

   Row_Pos84 := Token_Pos113;

else
   Row_Pos84 := No_Token_Index;
   goto Exit_Row84_0;

end if;


--  BEGIN <Defer (for 'grammar_list_sep') at parser.lkt:111:19>

Defer_Res110 :=
   Grammar_List_Sep_Transform_Parse0 (Parser, Row_Pos84);
Defer_Pos110 := Parser.Current_Pos;

--  END <Defer (for 'grammar_list_sep') at parser.lkt:111:19>




if Defer_Pos110 /= No_Token_Index then

   Row_Pos84 := Defer_Pos110;

else
   Row_Pos84 := No_Token_Index;
   goto Exit_Row84_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row84_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'grammar_list_expr') at parser.lkt:111:10>

--  END <_Extract (root of 'grammar_list_expr') at parser.lkt:111:10>


if Row_Pos84 = No_Token_Index then

         
   Defer_Res110 := No_Bare_Lkt_Node;



       
   Row_Pos84 := Row_Pos80;



end if;

--  END <Opt (root of 'grammar_list_expr') at parser.lkt:111:9>




if Row_Pos84 /= No_Token_Index then

   Row_Pos80 := Row_Pos84;

else
   Row_Pos80 := No_Token_Index;
   goto Exit_Row80_0;

end if;


--  BEGIN <Token(<WithText RPar>, ) (root of 'grammar_list_expr') at parser.lkt:112:9>

Token_Res114 := Row_Pos80;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res114));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_R_Par)
   then
       Token_Pos114 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos80 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos80,
             Expected_Token_Id => Lkt_R_Par,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos114 := Row_Pos80 + 1;
   end if;
end;

--  END <Token(<WithText RPar>, ) (root of 'grammar_list_expr') at parser.lkt:112:9>




if Token_Pos114 /= No_Token_Index then

   Row_Pos80 := Token_Pos114;

else
   Row_Pos80 := No_Token_Index;
   goto Exit_Row80_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row80_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'grammar_list_expr') at parser.lkt:99:26>



if Row_Pos80 /= No_Token_Index then

   Transform_Res74 := Allocate_Grammar_List (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res74,
      Kind => Lkt_Grammar_List,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos80 = Pos
                            then No_Token_Index
                            else Row_Pos80 - 1));

      
      Initialize_Fields_For_Grammar_List
        (Self => Transform_Res74,
         Grammar_List_F_List_Type => Or_Res19,
         Grammar_List_F_Kind => Or_Res20,
         Grammar_List_F_Expr => Or_Res21,
         Grammar_List_F_Sep => Defer_Res110);

         if Or_Res19 /= null and then Is_Incomplete (Or_Res19) then
            Transform_Res74.Last_Attempted_Child := 0;
         elsif Or_Res19 /= null and then not Is_Ghost (Or_Res19) then
            Transform_Res74.Last_Attempted_Child := -1;
         end if;
         if Or_Res20 /= null and then Is_Incomplete (Or_Res20) then
            Transform_Res74.Last_Attempted_Child := 0;
         elsif Or_Res20 /= null and then not Is_Ghost (Or_Res20) then
            Transform_Res74.Last_Attempted_Child := -1;
         end if;
         if Or_Res21 /= null and then Is_Incomplete (Or_Res21) then
            Transform_Res74.Last_Attempted_Child := 0;
         elsif Or_Res21 /= null and then not Is_Ghost (Or_Res21) then
            Transform_Res74.Last_Attempted_Child := -1;
         end if;
         if Defer_Res110 /= null and then Is_Incomplete (Defer_Res110) then
            Transform_Res74.Last_Attempted_Child := 0;
         elsif Defer_Res110 /= null and then not Is_Ghost (Defer_Res110) then
            Transform_Res74.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos80 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags74);
end if;

--  END <Transform(<ASTNodeType GrammarList>) (root of 'grammar_list_expr') at parser.lkt:99:26>


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (PP.Grammar_List_Expr_Transform_Parse3_Memo,
      Row_Pos80 /= No_Token_Index,
      Transform_Res74,
      Pos,
      Row_Pos80);


   Parser.Current_Pos := Row_Pos80;

   return Transform_Res74;
end Grammar_List_Expr_Transform_Parse3;

   


function Grammar_List_Sep_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Grammar_List_Sep
is
   use Bare_Grammar_List_Sep_Memos;

      Row_Pos85 :
            Token_Index
               := No_Token_Index;
      Defer_Pos111 :
            Token_Index
               := No_Token_Index;
      Defer_Res111 :
            Bare_Grammar_Expr
               := No_Bare_Lkt_Node;
      Row_Pos86 :
            Token_Index
               := No_Token_Index;
      Token_Pos115 :
            Token_Index
               := No_Token_Index;
      Token_Res115 :
            Token_Index
               := No_Token_Index;
      Defer_Pos112 :
            Token_Index
               := No_Token_Index;
      Defer_Res112 :
            Bare_Id
               := No_Bare_Lkt_Node;
      Transform_Res75 :
            Bare_Grammar_List_Sep
               := No_Bare_Lkt_Node;
      Transform_Diags75 :
            Ada.Containers.Count_Type;


   PP : constant Parser_Private_Part := +Parser.Private_Part;
   M  : Memo_Entry := Get (PP.Grammar_List_Sep_Transform_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res75 := M.Instance;
      return Transform_Res75;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res75;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  BEGIN <Transform(<ASTNodeType GrammarListSep>) (root of 'grammar_list_sep') at parser.lkt:114:25>

Transform_Diags75 := Parser.Diagnostics.Length;


--  BEGIN <_Row (root of 'grammar_list_sep') at parser.lkt:114:25>

Row_Pos85 := Pos;



--  BEGIN <Defer (for 'grammar_expr') at parser.lkt:114:40>

Defer_Res111 :=
   Grammar_Expr_Or_Parse0 (Parser, Row_Pos85);
Defer_Pos111 := Parser.Current_Pos;

--  END <Defer (for 'grammar_expr') at parser.lkt:114:40>




if Defer_Pos111 /= No_Token_Index then

   Row_Pos85 := Defer_Pos111;

else
   Row_Pos85 := No_Token_Index;
   goto Exit_Row85_0;

end if;


--  BEGIN <Opt (root of 'grammar_list_sep') at parser.lkt:114:53>












--  BEGIN <_Extract (root of 'grammar_list_sep') at parser.lkt:114:54>

--  BEGIN <_Row (root of 'grammar_list_sep') at parser.lkt:114:54>

Row_Pos86 := Row_Pos85;



--  BEGIN <Token(<WithText Comma>, ) (root of 'grammar_list_sep') at parser.lkt:114:59>

Token_Res115 := Row_Pos86;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res115));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_Comma)
   then
       Token_Pos115 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos86 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos86,
             Expected_Token_Id => Lkt_Comma,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos115 := Row_Pos86 + 1;
   end if;
end;

--  END <Token(<WithText Comma>, ) (root of 'grammar_list_sep') at parser.lkt:114:59>




if Token_Pos115 /= No_Token_Index then

   Row_Pos86 := Token_Pos115;

else
   Row_Pos86 := No_Token_Index;
   goto Exit_Row86_0;

end if;


--  BEGIN <Defer (for 'id') at parser.lkt:114:63>

Defer_Res112 :=
   Id_Transform_Parse0 (Parser, Row_Pos86);
Defer_Pos112 := Parser.Current_Pos;

--  END <Defer (for 'id') at parser.lkt:114:63>




if Defer_Pos112 /= No_Token_Index then

   Row_Pos86 := Defer_Pos112;

else
   Row_Pos86 := No_Token_Index;
   goto Exit_Row86_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row86_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'grammar_list_sep') at parser.lkt:114:54>

--  END <_Extract (root of 'grammar_list_sep') at parser.lkt:114:54>


if Row_Pos86 = No_Token_Index then

         
   Defer_Res112 := No_Bare_Lkt_Node;



       
   Row_Pos86 := Row_Pos85;



end if;

--  END <Opt (root of 'grammar_list_sep') at parser.lkt:114:53>




if Row_Pos86 /= No_Token_Index then

   Row_Pos85 := Row_Pos86;

else
   Row_Pos85 := No_Token_Index;
   goto Exit_Row85_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row85_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'grammar_list_sep') at parser.lkt:114:25>



if Row_Pos85 /= No_Token_Index then

   Transform_Res75 := Allocate_Grammar_List_Sep (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res75,
      Kind => Lkt_Grammar_List_Sep,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos85 = Pos
                            then No_Token_Index
                            else Row_Pos85 - 1));

      
      Initialize_Fields_For_Grammar_List_Sep
        (Self => Transform_Res75,
         Grammar_List_Sep_F_Token => Defer_Res111,
         Grammar_List_Sep_F_Extra => Defer_Res112);

         if Defer_Res111 /= null and then Is_Incomplete (Defer_Res111) then
            Transform_Res75.Last_Attempted_Child := 0;
         elsif Defer_Res111 /= null and then not Is_Ghost (Defer_Res111) then
            Transform_Res75.Last_Attempted_Child := -1;
         end if;
         if Defer_Res112 /= null and then Is_Incomplete (Defer_Res112) then
            Transform_Res75.Last_Attempted_Child := 0;
         elsif Defer_Res112 /= null and then not Is_Ghost (Defer_Res112) then
            Transform_Res75.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos85 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags75);
end if;

--  END <Transform(<ASTNodeType GrammarListSep>) (root of 'grammar_list_sep') at parser.lkt:114:25>


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (PP.Grammar_List_Sep_Transform_Parse0_Memo,
      Row_Pos85 /= No_Token_Index,
      Transform_Res75,
      Pos,
      Row_Pos85);


   Parser.Current_Pos := Row_Pos85;

   return Transform_Res75;
end Grammar_List_Sep_Transform_Parse0;

   


function Grammar_Null_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Grammar_Null
is
   use Bare_Grammar_Null_Memos;

      Row_Pos87 :
            Token_Index
               := No_Token_Index;
      Token_Pos116 :
            Token_Index
               := No_Token_Index;
      Token_Res116 :
            Token_Index
               := No_Token_Index;
      Token_Pos117 :
            Token_Index
               := No_Token_Index;
      Token_Res117 :
            Token_Index
               := No_Token_Index;
      Defer_Pos113 :
            Token_Index
               := No_Token_Index;
      Defer_Res113 :
            Bare_Type_Ref
               := No_Bare_Lkt_Node;
      Token_Pos118 :
            Token_Index
               := No_Token_Index;
      Token_Res118 :
            Token_Index
               := No_Token_Index;
      Transform_Res76 :
            Bare_Grammar_Null
               := No_Bare_Lkt_Node;
      Transform_Diags76 :
            Ada.Containers.Count_Type;


   PP : constant Parser_Private_Part := +Parser.Private_Part;
   M  : Memo_Entry := Get (PP.Grammar_Null_Transform_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res76 := M.Instance;
      return Transform_Res76;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res76;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  BEGIN <Transform(<ASTNodeType GrammarNull>) (root of 'grammar_null') at parser.lkt:116:21>

Transform_Diags76 := Parser.Diagnostics.Length;


--  BEGIN <_Row (root of 'grammar_null') at parser.lkt:116:21>

Row_Pos87 := Pos;



--  BEGIN <Token(<WithText NullKw>, ) (root of 'grammar_null') at parser.lkt:116:33>

Token_Res116 := Row_Pos87;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res116));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_Null_Kw)
   then
       Token_Pos116 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos87 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos87,
             Expected_Token_Id => Lkt_Null_Kw,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos116 := Row_Pos87 + 1;
   end if;
end;

--  END <Token(<WithText NullKw>, ) (root of 'grammar_null') at parser.lkt:116:33>




if Token_Pos116 /= No_Token_Index then

   Row_Pos87 := Token_Pos116;

else
   Row_Pos87 := No_Token_Index;
   goto Exit_Row87_0;

end if;


--  BEGIN <Token(<WithText LPar>, ) (root of 'grammar_null') at parser.lkt:116:40>

Token_Res117 := Row_Pos87;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res117));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_L_Par)
   then
       Token_Pos117 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos87 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos87,
             Expected_Token_Id => Lkt_L_Par,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos117 := Row_Pos87 + 1;
   end if;
end;

--  END <Token(<WithText LPar>, ) (root of 'grammar_null') at parser.lkt:116:40>




if Token_Pos117 /= No_Token_Index then

   Row_Pos87 := Token_Pos117;

else
   Row_Pos87 := No_Token_Index;
   goto Exit_Row87_0;

end if;


--  BEGIN <Defer (for 'type_ref') at parser.lkt:116:44>

Defer_Res113 :=
   Type_Ref_Or_Parse0 (Parser, Row_Pos87);
Defer_Pos113 := Parser.Current_Pos;

--  END <Defer (for 'type_ref') at parser.lkt:116:44>




if Defer_Pos113 /= No_Token_Index then

   Row_Pos87 := Defer_Pos113;

else
   Row_Pos87 := No_Token_Index;
   goto Exit_Row87_0;

end if;


--  BEGIN <Token(<WithText RPar>, ) (root of 'grammar_null') at parser.lkt:116:53>

Token_Res118 := Row_Pos87;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res118));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_R_Par)
   then
       Token_Pos118 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos87 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos87,
             Expected_Token_Id => Lkt_R_Par,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos118 := Row_Pos87 + 1;
   end if;
end;

--  END <Token(<WithText RPar>, ) (root of 'grammar_null') at parser.lkt:116:53>




if Token_Pos118 /= No_Token_Index then

   Row_Pos87 := Token_Pos118;

else
   Row_Pos87 := No_Token_Index;
   goto Exit_Row87_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row87_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'grammar_null') at parser.lkt:116:21>



if Row_Pos87 /= No_Token_Index then

   Transform_Res76 := Allocate_Grammar_Null (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res76,
      Kind => Lkt_Grammar_Null,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos87 = Pos
                            then No_Token_Index
                            else Row_Pos87 - 1));

      
      Initialize_Fields_For_Grammar_Null
        (Self => Transform_Res76,
         Grammar_Null_F_Name => Defer_Res113);

         if Defer_Res113 /= null and then Is_Incomplete (Defer_Res113) then
            Transform_Res76.Last_Attempted_Child := 0;
         elsif Defer_Res113 /= null and then not Is_Ghost (Defer_Res113) then
            Transform_Res76.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos87 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags76);
end if;

--  END <Transform(<ASTNodeType GrammarNull>) (root of 'grammar_null') at parser.lkt:116:21>


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (PP.Grammar_Null_Transform_Parse0_Memo,
      Row_Pos87 /= No_Token_Index,
      Transform_Res76,
      Pos,
      Row_Pos87);


   Parser.Current_Pos := Row_Pos87;

   return Transform_Res76;
end Grammar_Null_Transform_Parse0;

   


function Grammar_Opt_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Grammar_Expr
is
   use Bare_Grammar_Expr_Memos;

      Row_Pos88 :
            Token_Index
               := No_Token_Index;
      Token_Pos119 :
            Token_Index
               := No_Token_Index;
      Token_Res119 :
            Token_Index
               := No_Token_Index;
      Defer_Pos114 :
            Token_Index
               := No_Token_Index;
      Defer_Res114 :
            Bare_Grammar_Expr
               := No_Bare_Lkt_Node;
      Transform_Res77 :
            Bare_Grammar_Opt
               := No_Bare_Lkt_Node;
      Transform_Diags77 :
            Ada.Containers.Count_Type;
      Row_Pos89 :
            Token_Index
               := No_Token_Index;
      Token_Pos120 :
            Token_Index
               := No_Token_Index;
      Token_Res120 :
            Token_Index
               := No_Token_Index;
      Token_Pos121 :
            Token_Index
               := No_Token_Index;
      Token_Res121 :
            Token_Index
               := No_Token_Index;
      Lst_Cpos14 :
            Token_Index
               := No_Token_Index;
      Tmp_List14 :
            Free_Parse_List;
      Defer_Pos115 :
            Token_Index
               := No_Token_Index;
      Defer_Res115 :
            Bare_Grammar_Expr
               := No_Bare_Lkt_Node;
      List_Pos14 :
            Token_Index
               := No_Token_Index;
      List_Res14 :
            Bare_Grammar_Expr_List
               := No_Bare_Lkt_Node;
      Token_Pos122 :
            Token_Index
               := No_Token_Index;
      Token_Res122 :
            Token_Index
               := No_Token_Index;
      Transform_Res78 :
            Bare_Grammar_Opt_Group
               := No_Bare_Lkt_Node;
      Transform_Diags78 :
            Ada.Containers.Count_Type;
      Or_Pos22 :
            Token_Index
               := No_Token_Index;
      Or_Res22 :
            Bare_Grammar_Expr
               := No_Bare_Lkt_Node;


   PP : constant Parser_Private_Part := +Parser.Private_Part;
   M  : Memo_Entry := Get (PP.Grammar_Opt_Or_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Or_Res22 := M.Instance;
      return Or_Res22;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Or_Res22;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  BEGIN <Or (root of 'grammar_opt') at parser.lkt:72:20>

Or_Pos22 := No_Token_Index;
Or_Res22 := No_Bare_Lkt_Node;
    
--  BEGIN <Transform(<ASTNodeType GrammarOpt>) (root of 'grammar_opt') at parser.lkt:73:11>

Transform_Diags77 := Parser.Diagnostics.Length;


--  BEGIN <_Row (root of 'grammar_opt') at parser.lkt:73:11>

Row_Pos88 := Pos;



--  BEGIN <Token(<WithText IntMark>, ) (root of 'grammar_opt') at parser.lkt:73:22>

Token_Res119 := Row_Pos88;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res119));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_Int_Mark)
   then
       Token_Pos119 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos88 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos88,
             Expected_Token_Id => Lkt_Int_Mark,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos119 := Row_Pos88 + 1;
   end if;
end;

--  END <Token(<WithText IntMark>, ) (root of 'grammar_opt') at parser.lkt:73:22>




if Token_Pos119 /= No_Token_Index then

   Row_Pos88 := Token_Pos119;

else
   Row_Pos88 := No_Token_Index;
   goto Exit_Row88_0;

end if;


--  BEGIN <Defer (for 'grammar_expr') at parser.lkt:73:26>

Defer_Res114 :=
   Grammar_Expr_Or_Parse0 (Parser, Row_Pos88);
Defer_Pos114 := Parser.Current_Pos;

--  END <Defer (for 'grammar_expr') at parser.lkt:73:26>




if Defer_Pos114 /= No_Token_Index then

   Row_Pos88 := Defer_Pos114;

else
   Row_Pos88 := No_Token_Index;
   goto Exit_Row88_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row88_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'grammar_opt') at parser.lkt:73:11>



if Row_Pos88 /= No_Token_Index then

   Transform_Res77 := Allocate_Grammar_Opt (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res77,
      Kind => Lkt_Grammar_Opt,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos88 = Pos
                            then No_Token_Index
                            else Row_Pos88 - 1));

      
      Initialize_Fields_For_Grammar_Opt
        (Self => Transform_Res77,
         Grammar_Opt_F_Expr => Defer_Res114);

         if Defer_Res114 /= null and then Is_Incomplete (Defer_Res114) then
            Transform_Res77.Last_Attempted_Child := 0;
         elsif Defer_Res114 /= null and then not Is_Ghost (Defer_Res114) then
            Transform_Res77.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos88 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags77);
end if;

--  END <Transform(<ASTNodeType GrammarOpt>) (root of 'grammar_opt') at parser.lkt:73:11>

    if Row_Pos88 /= No_Token_Index then
        Or_Pos22 := Row_Pos88;
        Or_Res22 := Transform_Res77;
        goto Exit_Or23;
    end if;
    
--  BEGIN <Transform(<ASTNodeType GrammarOptGroup>) (root of 'grammar_opt') at parser.lkt:74:11>

Transform_Diags78 := Parser.Diagnostics.Length;


--  BEGIN <_Row (root of 'grammar_opt') at parser.lkt:74:11>

Row_Pos89 := Pos;



--  BEGIN <Token(<WithText IntMark>, ) (root of 'grammar_opt') at parser.lkt:74:27>

Token_Res120 := Row_Pos89;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res120));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_Int_Mark)
   then
       Token_Pos120 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos89 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos89,
             Expected_Token_Id => Lkt_Int_Mark,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos120 := Row_Pos89 + 1;
   end if;
end;

--  END <Token(<WithText IntMark>, ) (root of 'grammar_opt') at parser.lkt:74:27>




if Token_Pos120 /= No_Token_Index then

   Row_Pos89 := Token_Pos120;

else
   Row_Pos89 := No_Token_Index;
   goto Exit_Row89_0;

end if;


--  BEGIN <Token(<WithText LPar>, ) (root of 'grammar_opt') at parser.lkt:74:31>

Token_Res121 := Row_Pos89;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res121));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_L_Par)
   then
       Token_Pos121 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos89 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos89,
             Expected_Token_Id => Lkt_L_Par,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos121 := Row_Pos89 + 1;
   end if;
end;

--  END <Token(<WithText LPar>, ) (root of 'grammar_opt') at parser.lkt:74:31>




if Token_Pos121 /= No_Token_Index then

   Row_Pos89 := Token_Pos121;

else
   Row_Pos89 := No_Token_Index;
   goto Exit_Row89_0;

end if;


--  BEGIN <List (root of 'grammar_opt') at parser.lkt:74:35>

    List_Pos14 := Row_Pos89;



Lst_Cpos14 := Row_Pos89;
Tmp_List14 := Get_Parse_List (Parser);


loop
   
--  BEGIN <Defer (for 'grammar_expr') at parser.lkt:74:41>

Defer_Res115 :=
   Grammar_Expr_Or_Parse0 (Parser, Lst_Cpos14);
Defer_Pos115 := Parser.Current_Pos;

--  END <Defer (for 'grammar_expr') at parser.lkt:74:41>


   exit when Defer_Pos115 = No_Token_Index;

   List_Pos14 := Defer_Pos115;
   Lst_Cpos14 := List_Pos14;

   Tmp_List14.Nodes.Append (Defer_Res115);

end loop;


declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List14.Nodes.Length;
begin
   List_Res14 := Allocate_Grammar_Expr_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Row_Pos89;
      Token_End := (if Lst_Cpos14 = Row_Pos89
                    then Row_Pos89
                    else List_Pos14 - 1);

   else
      Token_Start := Token_Index'Max (Row_Pos89, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res14,
      Kind              => Lkt_Grammar_Expr_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res14,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_Lkt_Node_Vectors.Vector renames
         Tmp_List14.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res14.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List14);

--  END <List (root of 'grammar_opt') at parser.lkt:74:35>




if List_Pos14 /= No_Token_Index then

   Row_Pos89 := List_Pos14;

else
   Row_Pos89 := No_Token_Index;
   goto Exit_Row89_0;

end if;


--  BEGIN <Token(<WithText RPar>, ) (root of 'grammar_opt') at parser.lkt:74:55>

Token_Res122 := Row_Pos89;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res122));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_R_Par)
   then
       Token_Pos122 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos89 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos89,
             Expected_Token_Id => Lkt_R_Par,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos122 := Row_Pos89 + 1;
   end if;
end;

--  END <Token(<WithText RPar>, ) (root of 'grammar_opt') at parser.lkt:74:55>




if Token_Pos122 /= No_Token_Index then

   Row_Pos89 := Token_Pos122;

else
   Row_Pos89 := No_Token_Index;
   goto Exit_Row89_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row89_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'grammar_opt') at parser.lkt:74:11>



if Row_Pos89 /= No_Token_Index then

   Transform_Res78 := Allocate_Grammar_Opt_Group (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res78,
      Kind => Lkt_Grammar_Opt_Group,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos89 = Pos
                            then No_Token_Index
                            else Row_Pos89 - 1));

      
      Initialize_Fields_For_Grammar_Opt_Group
        (Self => Transform_Res78,
         Grammar_Opt_Group_F_Expr => List_Res14);

         if List_Res14 /= null and then Is_Incomplete (List_Res14) then
            Transform_Res78.Last_Attempted_Child := 0;
         elsif List_Res14 /= null and then not Is_Ghost (List_Res14) then
            Transform_Res78.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos89 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags78);
end if;

--  END <Transform(<ASTNodeType GrammarOptGroup>) (root of 'grammar_opt') at parser.lkt:74:11>

    if Row_Pos89 /= No_Token_Index then
        Or_Pos22 := Row_Pos89;
        Or_Res22 := Transform_Res78;
        goto Exit_Or23;
    end if;
<<Exit_Or23>>

--  END <Or (root of 'grammar_opt') at parser.lkt:72:20>


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (PP.Grammar_Opt_Or_Parse0_Memo,
      Or_Pos22 /= No_Token_Index,
      Or_Res22,
      Pos,
      Or_Pos22);


   Parser.Current_Pos := Or_Pos22;

   return Or_Res22;
end Grammar_Opt_Or_Parse0;

   


function Grammar_Opt_Error_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Grammar_Expr
is
   use Bare_Grammar_Expr_Memos;

      Row_Pos90 :
            Token_Index
               := No_Token_Index;
      Token_Pos123 :
            Token_Index
               := No_Token_Index;
      Token_Res123 :
            Token_Index
               := No_Token_Index;
      Defer_Pos116 :
            Token_Index
               := No_Token_Index;
      Defer_Res116 :
            Bare_Grammar_Expr
               := No_Bare_Lkt_Node;
      Transform_Res79 :
            Bare_Grammar_Opt_Error
               := No_Bare_Lkt_Node;
      Transform_Diags79 :
            Ada.Containers.Count_Type;
      Row_Pos91 :
            Token_Index
               := No_Token_Index;
      Token_Pos124 :
            Token_Index
               := No_Token_Index;
      Token_Res124 :
            Token_Index
               := No_Token_Index;
      Token_Pos125 :
            Token_Index
               := No_Token_Index;
      Token_Res125 :
            Token_Index
               := No_Token_Index;
      Lst_Cpos15 :
            Token_Index
               := No_Token_Index;
      Tmp_List15 :
            Free_Parse_List;
      Defer_Pos117 :
            Token_Index
               := No_Token_Index;
      Defer_Res117 :
            Bare_Grammar_Expr
               := No_Bare_Lkt_Node;
      List_Pos15 :
            Token_Index
               := No_Token_Index;
      List_Res15 :
            Bare_Grammar_Expr_List
               := No_Bare_Lkt_Node;
      Token_Pos126 :
            Token_Index
               := No_Token_Index;
      Token_Res126 :
            Token_Index
               := No_Token_Index;
      Transform_Res80 :
            Bare_Grammar_Opt_Error_Group
               := No_Bare_Lkt_Node;
      Transform_Diags80 :
            Ada.Containers.Count_Type;
      Or_Pos23 :
            Token_Index
               := No_Token_Index;
      Or_Res23 :
            Bare_Grammar_Expr
               := No_Bare_Lkt_Node;


   PP : constant Parser_Private_Part := +Parser.Private_Part;
   M  : Memo_Entry := Get (PP.Grammar_Opt_Error_Or_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Or_Res23 := M.Instance;
      return Or_Res23;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Or_Res23;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  BEGIN <Or (root of 'grammar_opt_error') at parser.lkt:76:26>

Or_Pos23 := No_Token_Index;
Or_Res23 := No_Bare_Lkt_Node;
    
--  BEGIN <Transform(<ASTNodeType GrammarOptError>) (root of 'grammar_opt_error') at parser.lkt:77:11>

Transform_Diags79 := Parser.Diagnostics.Length;


--  BEGIN <_Row (root of 'grammar_opt_error') at parser.lkt:77:11>

Row_Pos90 := Pos;



--  BEGIN <Token(<WithText ExclMark>, ) (root of 'grammar_opt_error') at parser.lkt:77:27>

Token_Res123 := Row_Pos90;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res123));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_Excl_Mark)
   then
       Token_Pos123 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos90 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos90,
             Expected_Token_Id => Lkt_Excl_Mark,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos123 := Row_Pos90 + 1;
   end if;
end;

--  END <Token(<WithText ExclMark>, ) (root of 'grammar_opt_error') at parser.lkt:77:27>




if Token_Pos123 /= No_Token_Index then

   Row_Pos90 := Token_Pos123;

else
   Row_Pos90 := No_Token_Index;
   goto Exit_Row90_0;

end if;


--  BEGIN <Defer (for 'grammar_expr') at parser.lkt:77:31>

Defer_Res116 :=
   Grammar_Expr_Or_Parse0 (Parser, Row_Pos90);
Defer_Pos116 := Parser.Current_Pos;

--  END <Defer (for 'grammar_expr') at parser.lkt:77:31>




if Defer_Pos116 /= No_Token_Index then

   Row_Pos90 := Defer_Pos116;

else
   Row_Pos90 := No_Token_Index;
   goto Exit_Row90_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row90_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'grammar_opt_error') at parser.lkt:77:11>



if Row_Pos90 /= No_Token_Index then

   Transform_Res79 := Allocate_Grammar_Opt_Error (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res79,
      Kind => Lkt_Grammar_Opt_Error,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos90 = Pos
                            then No_Token_Index
                            else Row_Pos90 - 1));

      
      Initialize_Fields_For_Grammar_Opt_Error
        (Self => Transform_Res79,
         Grammar_Opt_Error_F_Expr => Defer_Res116);

         if Defer_Res116 /= null and then Is_Incomplete (Defer_Res116) then
            Transform_Res79.Last_Attempted_Child := 0;
         elsif Defer_Res116 /= null and then not Is_Ghost (Defer_Res116) then
            Transform_Res79.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos90 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags79);
end if;

--  END <Transform(<ASTNodeType GrammarOptError>) (root of 'grammar_opt_error') at parser.lkt:77:11>

    if Row_Pos90 /= No_Token_Index then
        Or_Pos23 := Row_Pos90;
        Or_Res23 := Transform_Res79;
        goto Exit_Or24;
    end if;
    
--  BEGIN <Transform(<ASTNodeType GrammarOptErrorGroup>) (root of 'grammar_opt_error') at parser.lkt:78:11>

Transform_Diags80 := Parser.Diagnostics.Length;


--  BEGIN <_Row (root of 'grammar_opt_error') at parser.lkt:78:11>

Row_Pos91 := Pos;



--  BEGIN <Token(<WithText ExclMark>, ) (root of 'grammar_opt_error') at parser.lkt:78:32>

Token_Res124 := Row_Pos91;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res124));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_Excl_Mark)
   then
       Token_Pos124 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos91 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos91,
             Expected_Token_Id => Lkt_Excl_Mark,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos124 := Row_Pos91 + 1;
   end if;
end;

--  END <Token(<WithText ExclMark>, ) (root of 'grammar_opt_error') at parser.lkt:78:32>




if Token_Pos124 /= No_Token_Index then

   Row_Pos91 := Token_Pos124;

else
   Row_Pos91 := No_Token_Index;
   goto Exit_Row91_0;

end if;


--  BEGIN <Token(<WithText LPar>, ) (root of 'grammar_opt_error') at parser.lkt:78:36>

Token_Res125 := Row_Pos91;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res125));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_L_Par)
   then
       Token_Pos125 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos91 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos91,
             Expected_Token_Id => Lkt_L_Par,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos125 := Row_Pos91 + 1;
   end if;
end;

--  END <Token(<WithText LPar>, ) (root of 'grammar_opt_error') at parser.lkt:78:36>




if Token_Pos125 /= No_Token_Index then

   Row_Pos91 := Token_Pos125;

else
   Row_Pos91 := No_Token_Index;
   goto Exit_Row91_0;

end if;


--  BEGIN <List (root of 'grammar_opt_error') at parser.lkt:78:40>

    List_Pos15 := Row_Pos91;



Lst_Cpos15 := Row_Pos91;
Tmp_List15 := Get_Parse_List (Parser);


loop
   
--  BEGIN <Defer (for 'grammar_expr') at parser.lkt:78:46>

Defer_Res117 :=
   Grammar_Expr_Or_Parse0 (Parser, Lst_Cpos15);
Defer_Pos117 := Parser.Current_Pos;

--  END <Defer (for 'grammar_expr') at parser.lkt:78:46>


   exit when Defer_Pos117 = No_Token_Index;

   List_Pos15 := Defer_Pos117;
   Lst_Cpos15 := List_Pos15;

   Tmp_List15.Nodes.Append (Defer_Res117);

end loop;


declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List15.Nodes.Length;
begin
   List_Res15 := Allocate_Grammar_Expr_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Row_Pos91;
      Token_End := (if Lst_Cpos15 = Row_Pos91
                    then Row_Pos91
                    else List_Pos15 - 1);

   else
      Token_Start := Token_Index'Max (Row_Pos91, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res15,
      Kind              => Lkt_Grammar_Expr_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res15,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_Lkt_Node_Vectors.Vector renames
         Tmp_List15.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res15.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List15);

--  END <List (root of 'grammar_opt_error') at parser.lkt:78:40>




if List_Pos15 /= No_Token_Index then

   Row_Pos91 := List_Pos15;

else
   Row_Pos91 := No_Token_Index;
   goto Exit_Row91_0;

end if;


--  BEGIN <Token(<WithText RPar>, ) (root of 'grammar_opt_error') at parser.lkt:78:60>

Token_Res126 := Row_Pos91;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res126));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_R_Par)
   then
       Token_Pos126 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos91 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos91,
             Expected_Token_Id => Lkt_R_Par,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos126 := Row_Pos91 + 1;
   end if;
end;

--  END <Token(<WithText RPar>, ) (root of 'grammar_opt_error') at parser.lkt:78:60>




if Token_Pos126 /= No_Token_Index then

   Row_Pos91 := Token_Pos126;

else
   Row_Pos91 := No_Token_Index;
   goto Exit_Row91_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row91_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'grammar_opt_error') at parser.lkt:78:11>



if Row_Pos91 /= No_Token_Index then

   Transform_Res80 := Allocate_Grammar_Opt_Error_Group (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res80,
      Kind => Lkt_Grammar_Opt_Error_Group,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos91 = Pos
                            then No_Token_Index
                            else Row_Pos91 - 1));

      
      Initialize_Fields_For_Grammar_Opt_Error_Group
        (Self => Transform_Res80,
         Grammar_Opt_Error_Group_F_Expr => List_Res15);

         if List_Res15 /= null and then Is_Incomplete (List_Res15) then
            Transform_Res80.Last_Attempted_Child := 0;
         elsif List_Res15 /= null and then not Is_Ghost (List_Res15) then
            Transform_Res80.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos91 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags80);
end if;

--  END <Transform(<ASTNodeType GrammarOptErrorGroup>) (root of 'grammar_opt_error') at parser.lkt:78:11>

    if Row_Pos91 /= No_Token_Index then
        Or_Pos23 := Row_Pos91;
        Or_Res23 := Transform_Res80;
        goto Exit_Or24;
    end if;
<<Exit_Or24>>

--  END <Or (root of 'grammar_opt_error') at parser.lkt:76:26>


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (PP.Grammar_Opt_Error_Or_Parse0_Memo,
      Or_Pos23 /= No_Token_Index,
      Or_Res23,
      Pos,
      Or_Pos23);


   Parser.Current_Pos := Or_Pos23;

   return Or_Res23;
end Grammar_Opt_Error_Or_Parse0;

   


function Grammar_Or_Expr_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Grammar_Or_Expr
is
   use Bare_Grammar_Or_Expr_Memos;

      Row_Pos92 :
            Token_Index
               := No_Token_Index;
      Token_Pos127 :
            Token_Index
               := No_Token_Index;
      Token_Res127 :
            Token_Index
               := No_Token_Index;
      Token_Pos128 :
            Token_Index
               := No_Token_Index;
      Token_Res128 :
            Token_Index
               := No_Token_Index;
      Lst_Cpos16 :
            Token_Index
               := No_Token_Index;
      Tmp_List16 :
            Free_Parse_List;
      Has_Leading0 :
            Boolean
               := False;
      Lst_Cpos17 :
            Token_Index
               := No_Token_Index;
      Tmp_List17 :
            Free_Parse_List;
      Defer_Pos118 :
            Token_Index
               := No_Token_Index;
      Defer_Res118 :
            Bare_Grammar_Expr
               := No_Bare_Lkt_Node;
      List_Pos16 :
            Token_Index
               := No_Token_Index;
      List_Res16 :
            Bare_Grammar_Expr_List
               := No_Bare_Lkt_Node;
      Token_Pos129 :
            Token_Index
               := No_Token_Index;
      Token_Res129 :
            Token_Index
               := No_Token_Index;
      List_Pos17 :
            Token_Index
               := No_Token_Index;
      List_Res17 :
            Bare_Grammar_Expr_List_List
               := No_Bare_Lkt_Node;
      Token_Pos130 :
            Token_Index
               := No_Token_Index;
      Token_Res130 :
            Token_Index
               := No_Token_Index;
      Transform_Res81 :
            Bare_Grammar_Or_Expr
               := No_Bare_Lkt_Node;
      Transform_Diags81 :
            Ada.Containers.Count_Type;


   PP : constant Parser_Private_Part := +Parser.Private_Part;
   M  : Memo_Entry := Get (PP.Grammar_Or_Expr_Transform_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res81 := M.Instance;
      return Transform_Res81;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res81;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  BEGIN <Transform(<ASTNodeType GrammarOrExpr>) (root of 'grammar_or_expr') at parser.lkt:84:24>

Transform_Diags81 := Parser.Diagnostics.Length;


--  BEGIN <_Row (root of 'grammar_or_expr') at parser.lkt:84:24>

Row_Pos92 := Pos;



--  BEGIN <Token(<WithText OrKw>, ) (root of 'grammar_or_expr') at parser.lkt:85:9>

Token_Res127 := Row_Pos92;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res127));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_Or_Kw)
   then
       Token_Pos127 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos92 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos92,
             Expected_Token_Id => Lkt_Or_Kw,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos127 := Row_Pos92 + 1;
   end if;
end;

--  END <Token(<WithText OrKw>, ) (root of 'grammar_or_expr') at parser.lkt:85:9>




if Token_Pos127 /= No_Token_Index then

   Row_Pos92 := Token_Pos127;

else
   Row_Pos92 := No_Token_Index;
   goto Exit_Row92_0;

end if;


--  BEGIN <Token(<WithText LPar>, ) (root of 'grammar_or_expr') at parser.lkt:85:14>

Token_Res128 := Row_Pos92;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res128));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_L_Par)
   then
       Token_Pos128 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos92 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos92,
             Expected_Token_Id => Lkt_L_Par,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos128 := Row_Pos92 + 1;
   end if;
end;

--  END <Token(<WithText LPar>, ) (root of 'grammar_or_expr') at parser.lkt:85:14>




if Token_Pos128 /= No_Token_Index then

   Row_Pos92 := Token_Pos128;

else
   Row_Pos92 := No_Token_Index;
   goto Exit_Row92_0;

end if;


--  BEGIN <List (root of 'grammar_or_expr') at parser.lkt:85:18>

    List_Pos17 := No_Token_Index;



Lst_Cpos16 := Row_Pos92;
Tmp_List16 := Get_Parse_List (Parser);

   
--  BEGIN <Token(<WithText Pipe>, ) (root of 'grammar_or_expr') at parser.lkt:85:45>

Token_Res129 := Lst_Cpos16;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res129));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_Pipe)
   then
       Token_Pos129 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Lst_Cpos16 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Lst_Cpos16,
             Expected_Token_Id => Lkt_Pipe,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos129 := Lst_Cpos16 + 1;
   end if;
end;

--  END <Token(<WithText Pipe>, ) (root of 'grammar_or_expr') at parser.lkt:85:45>

   if Token_Pos129 /= No_Token_Index then
       Lst_Cpos16 := Token_Pos129;
       Has_Leading0 := True;
   else
       Has_Leading0 := False;
   end if;

loop
   
--  BEGIN <List (root of 'grammar_or_expr') at parser.lkt:85:24>

    List_Pos16 := No_Token_Index;



Lst_Cpos17 := Lst_Cpos16;
Tmp_List17 := Get_Parse_List (Parser);


loop
   
--  BEGIN <Defer (for 'grammar_expr') at parser.lkt:85:30>

Defer_Res118 :=
   Grammar_Expr_Or_Parse0 (Parser, Lst_Cpos17);
Defer_Pos118 := Parser.Current_Pos;

--  END <Defer (for 'grammar_expr') at parser.lkt:85:30>


   exit when Defer_Pos118 = No_Token_Index;

   List_Pos16 := Defer_Pos118;
   Lst_Cpos17 := List_Pos16;

   Tmp_List17.Nodes.Append (Defer_Res118);

end loop;


declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List17.Nodes.Length;
begin
   List_Res16 := Allocate_Grammar_Expr_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Lst_Cpos16;
      Token_End := (if Lst_Cpos17 = Lst_Cpos16
                    then Lst_Cpos16
                    else List_Pos16 - 1);

   else
      Token_Start := Token_Index'Max (Lst_Cpos16, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res16,
      Kind              => Lkt_Grammar_Expr_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res16,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_Lkt_Node_Vectors.Vector renames
         Tmp_List17.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res16.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List17);

--  END <List (root of 'grammar_or_expr') at parser.lkt:85:24>


   exit when List_Pos16 = No_Token_Index;

   List_Pos17 := List_Pos16;
   Lst_Cpos16 := List_Pos17;

   Tmp_List16.Nodes.Append (List_Res16);

      
--  BEGIN <Token(<WithText Pipe>, ) (root of 'grammar_or_expr') at parser.lkt:85:45>

Token_Res129 := Lst_Cpos16;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res129));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_Pipe)
   then
       Token_Pos129 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Lst_Cpos16 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Lst_Cpos16,
             Expected_Token_Id => Lkt_Pipe,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos129 := Lst_Cpos16 + 1;
   end if;
end;

--  END <Token(<WithText Pipe>, ) (root of 'grammar_or_expr') at parser.lkt:85:45>


      exit when Token_Pos129 = No_Token_Index;

      Lst_Cpos16 := Token_Pos129;

end loop;

   if Has_Leading0 and then Tmp_List16.Nodes.Is_Empty then
      List_Pos17 := No_Token_Index;
   end if;

declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List16.Nodes.Length;
begin
   List_Res17 := Allocate_Grammar_Expr_List_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Row_Pos92;
      Token_End := (if Lst_Cpos16 = Row_Pos92
                    then Row_Pos92
                    else List_Pos17 - 1);

   else
      Token_Start := Token_Index'Max (Row_Pos92, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res17,
      Kind              => Lkt_Grammar_Expr_List_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res17,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_Lkt_Node_Vectors.Vector renames
         Tmp_List16.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res17.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List16);

--  END <List (root of 'grammar_or_expr') at parser.lkt:85:18>




if List_Pos17 /= No_Token_Index then

   Row_Pos92 := List_Pos17;

else
   Row_Pos92 := No_Token_Index;
   goto Exit_Row92_0;

end if;


--  BEGIN <Token(<WithText RPar>, ) (root of 'grammar_or_expr') at parser.lkt:85:65>

Token_Res130 := Row_Pos92;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res130));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_R_Par)
   then
       Token_Pos130 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos92 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos92,
             Expected_Token_Id => Lkt_R_Par,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos130 := Row_Pos92 + 1;
   end if;
end;

--  END <Token(<WithText RPar>, ) (root of 'grammar_or_expr') at parser.lkt:85:65>




if Token_Pos130 /= No_Token_Index then

   Row_Pos92 := Token_Pos130;

else
   Row_Pos92 := No_Token_Index;
   goto Exit_Row92_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row92_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'grammar_or_expr') at parser.lkt:84:24>



if Row_Pos92 /= No_Token_Index then

   Transform_Res81 := Allocate_Grammar_Or_Expr (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res81,
      Kind => Lkt_Grammar_Or_Expr,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos92 = Pos
                            then No_Token_Index
                            else Row_Pos92 - 1));

      
      Initialize_Fields_For_Grammar_Or_Expr
        (Self => Transform_Res81,
         Grammar_Or_Expr_F_Sub_Exprs => List_Res17);

         if List_Res17 /= null and then Is_Incomplete (List_Res17) then
            Transform_Res81.Last_Attempted_Child := 0;
         elsif List_Res17 /= null and then not Is_Ghost (List_Res17) then
            Transform_Res81.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos92 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags81);
end if;

--  END <Transform(<ASTNodeType GrammarOrExpr>) (root of 'grammar_or_expr') at parser.lkt:84:24>


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (PP.Grammar_Or_Expr_Transform_Parse0_Memo,
      Row_Pos92 /= No_Token_Index,
      Transform_Res81,
      Pos,
      Row_Pos92);


   Parser.Current_Pos := Row_Pos92;

   return Transform_Res81;
end Grammar_Or_Expr_Transform_Parse0;

   


function Grammar_Pick_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Grammar_Pick
is
   use Bare_Grammar_Pick_Memos;

      Row_Pos93 :
            Token_Index
               := No_Token_Index;
      Token_Pos131 :
            Token_Index
               := No_Token_Index;
      Token_Res131 :
            Token_Index
               := No_Token_Index;
      Token_Pos132 :
            Token_Index
               := No_Token_Index;
      Token_Res132 :
            Token_Index
               := No_Token_Index;
      Lst_Cpos18 :
            Token_Index
               := No_Token_Index;
      Tmp_List18 :
            Free_Parse_List;
      Defer_Pos119 :
            Token_Index
               := No_Token_Index;
      Defer_Res119 :
            Bare_Grammar_Expr
               := No_Bare_Lkt_Node;
      List_Pos18 :
            Token_Index
               := No_Token_Index;
      List_Res18 :
            Bare_Grammar_Expr_List
               := No_Bare_Lkt_Node;
      Token_Pos133 :
            Token_Index
               := No_Token_Index;
      Token_Res133 :
            Token_Index
               := No_Token_Index;
      Transform_Res82 :
            Bare_Grammar_Pick
               := No_Bare_Lkt_Node;
      Transform_Diags82 :
            Ada.Containers.Count_Type;


   PP : constant Parser_Private_Part := +Parser.Private_Part;
   M  : Memo_Entry := Get (PP.Grammar_Pick_Transform_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res82 := M.Instance;
      return Transform_Res82;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res82;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  BEGIN <Transform(<ASTNodeType GrammarPick>) (root of 'grammar_pick') at parser.lkt:68:21>

Transform_Diags82 := Parser.Diagnostics.Length;


--  BEGIN <_Row (root of 'grammar_pick') at parser.lkt:68:21>

Row_Pos93 := Pos;



--  BEGIN <Token(<WithSymbol Identifier>, pick) (root of 'grammar_pick') at parser.lkt:69:9>

Token_Res131 := Row_Pos93;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res131));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_Identifier)
      or else T.Symbol /= Precomputed_Symbol
        (Precomputed_Symbol_Table (Parser.TDH.Symbols),
         Precomputed_Sym_Pick)
   then
       Token_Pos131 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos93 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos93,
             Expected_Token_Id => Lkt_Identifier,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos131 := Row_Pos93 + 1;
   end if;
end;

--  END <Token(<WithSymbol Identifier>, pick) (root of 'grammar_pick') at parser.lkt:69:9>




if Token_Pos131 /= No_Token_Index then

   Row_Pos93 := Token_Pos131;

else
   Row_Pos93 := No_Token_Index;
   goto Exit_Row93_0;

end if;


--  BEGIN <Token(<WithText LPar>, ) (root of 'grammar_pick') at parser.lkt:69:29>

Token_Res132 := Row_Pos93;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res132));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_L_Par)
   then
       Token_Pos132 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos93 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos93,
             Expected_Token_Id => Lkt_L_Par,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos132 := Row_Pos93 + 1;
   end if;
end;

--  END <Token(<WithText LPar>, ) (root of 'grammar_pick') at parser.lkt:69:29>




if Token_Pos132 /= No_Token_Index then

   Row_Pos93 := Token_Pos132;

else
   Row_Pos93 := No_Token_Index;
   goto Exit_Row93_0;

end if;


--  BEGIN <List (root of 'grammar_pick') at parser.lkt:69:33>

    List_Pos18 := No_Token_Index;



Lst_Cpos18 := Row_Pos93;
Tmp_List18 := Get_Parse_List (Parser);


loop
   
--  BEGIN <Defer (for 'grammar_expr') at parser.lkt:69:39>

Defer_Res119 :=
   Grammar_Expr_Or_Parse0 (Parser, Lst_Cpos18);
Defer_Pos119 := Parser.Current_Pos;

--  END <Defer (for 'grammar_expr') at parser.lkt:69:39>


   exit when Defer_Pos119 = No_Token_Index;

   List_Pos18 := Defer_Pos119;
   Lst_Cpos18 := List_Pos18;

   Tmp_List18.Nodes.Append (Defer_Res119);

end loop;


declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List18.Nodes.Length;
begin
   List_Res18 := Allocate_Grammar_Expr_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Row_Pos93;
      Token_End := (if Lst_Cpos18 = Row_Pos93
                    then Row_Pos93
                    else List_Pos18 - 1);

   else
      Token_Start := Token_Index'Max (Row_Pos93, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res18,
      Kind              => Lkt_Grammar_Expr_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res18,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_Lkt_Node_Vectors.Vector renames
         Tmp_List18.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res18.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List18);

--  END <List (root of 'grammar_pick') at parser.lkt:69:33>




if List_Pos18 /= No_Token_Index then

   Row_Pos93 := List_Pos18;

else
   Row_Pos93 := No_Token_Index;
   goto Exit_Row93_0;

end if;


--  BEGIN <Token(<WithText RPar>, ) (root of 'grammar_pick') at parser.lkt:69:53>

Token_Res133 := Row_Pos93;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res133));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_R_Par)
   then
       Token_Pos133 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos93 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos93,
             Expected_Token_Id => Lkt_R_Par,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos133 := Row_Pos93 + 1;
   end if;
end;

--  END <Token(<WithText RPar>, ) (root of 'grammar_pick') at parser.lkt:69:53>




if Token_Pos133 /= No_Token_Index then

   Row_Pos93 := Token_Pos133;

else
   Row_Pos93 := No_Token_Index;
   goto Exit_Row93_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row93_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'grammar_pick') at parser.lkt:68:21>



if Row_Pos93 /= No_Token_Index then

   Transform_Res82 := Allocate_Grammar_Pick (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res82,
      Kind => Lkt_Grammar_Pick,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos93 = Pos
                            then No_Token_Index
                            else Row_Pos93 - 1));

      
      Initialize_Fields_For_Grammar_Pick
        (Self => Transform_Res82,
         Grammar_Pick_F_Exprs => List_Res18);

         if List_Res18 /= null and then Is_Incomplete (List_Res18) then
            Transform_Res82.Last_Attempted_Child := 0;
         elsif List_Res18 /= null and then not Is_Ghost (List_Res18) then
            Transform_Res82.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos93 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags82);
end if;

--  END <Transform(<ASTNodeType GrammarPick>) (root of 'grammar_pick') at parser.lkt:68:21>


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (PP.Grammar_Pick_Transform_Parse0_Memo,
      Row_Pos93 /= No_Token_Index,
      Transform_Res82,
      Pos,
      Row_Pos93);


   Parser.Current_Pos := Row_Pos93;

   return Transform_Res82;
end Grammar_Pick_Transform_Parse0;

   


function Grammar_Primary_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Grammar_Expr
is
   use Bare_Grammar_Expr_Memos;

      Defer_Pos120 :
            Token_Index
               := No_Token_Index;
      Defer_Res120 :
            Bare_Grammar_Pick
               := No_Bare_Lkt_Node;
      Defer_Pos121 :
            Token_Index
               := No_Token_Index;
      Defer_Res121 :
            Bare_Grammar_List
               := No_Bare_Lkt_Node;
      Defer_Pos122 :
            Token_Index
               := No_Token_Index;
      Defer_Res122 :
            Bare_Token_Lit
               := No_Bare_Lkt_Node;
      Defer_Pos123 :
            Token_Index
               := No_Token_Index;
      Defer_Res123 :
            Bare_Token_No_Case_Lit
               := No_Bare_Lkt_Node;
      Defer_Pos124 :
            Token_Index
               := No_Token_Index;
      Defer_Res124 :
            Bare_Grammar_Expr
               := No_Bare_Lkt_Node;
      Defer_Pos125 :
            Token_Index
               := No_Token_Index;
      Defer_Res125 :
            Bare_Grammar_Cut
               := No_Bare_Lkt_Node;
      Defer_Pos126 :
            Token_Index
               := No_Token_Index;
      Defer_Res126 :
            Bare_Grammar_Skip
               := No_Bare_Lkt_Node;
      Defer_Pos127 :
            Token_Index
               := No_Token_Index;
      Defer_Res127 :
            Bare_Grammar_Null
               := No_Bare_Lkt_Node;
      Defer_Pos128 :
            Token_Index
               := No_Token_Index;
      Defer_Res128 :
            Bare_Token_Ref
               := No_Bare_Lkt_Node;
      Defer_Pos129 :
            Token_Index
               := No_Token_Index;
      Defer_Res129 :
            Bare_Grammar_Stop_Cut
               := No_Bare_Lkt_Node;
      Defer_Pos130 :
            Token_Index
               := No_Token_Index;
      Defer_Res130 :
            Bare_Parse_Node_Expr
               := No_Bare_Lkt_Node;
      Defer_Pos131 :
            Token_Index
               := No_Token_Index;
      Defer_Res131 :
            Bare_Grammar_Expr
               := No_Bare_Lkt_Node;
      Defer_Pos132 :
            Token_Index
               := No_Token_Index;
      Defer_Res132 :
            Bare_Grammar_Expr
               := No_Bare_Lkt_Node;
      Defer_Pos133 :
            Token_Index
               := No_Token_Index;
      Defer_Res133 :
            Bare_Grammar_Or_Expr
               := No_Bare_Lkt_Node;
      Defer_Pos134 :
            Token_Index
               := No_Token_Index;
      Defer_Res134 :
            Bare_Grammar_Rule_Ref
               := No_Bare_Lkt_Node;
      Defer_Pos135 :
            Token_Index
               := No_Token_Index;
      Defer_Res135 :
            Bare_Grammar_Discard
               := No_Bare_Lkt_Node;
      Or_Pos24 :
            Token_Index
               := No_Token_Index;
      Or_Res24 :
            Bare_Grammar_Expr
               := No_Bare_Lkt_Node;


   PP : constant Parser_Private_Part := +Parser.Private_Part;
   M  : Memo_Entry := Get (PP.Grammar_Primary_Or_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Or_Res24 := M.Instance;
      return Or_Res24;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Or_Res24;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  BEGIN <Or (root of 'grammar_primary') at parser.lkt:41:24>

Or_Pos24 := No_Token_Index;
Or_Res24 := No_Bare_Lkt_Node;
    
--  BEGIN <Defer (for 'grammar_pick') at parser.lkt:42:11>

Defer_Res120 :=
   Grammar_Pick_Transform_Parse0 (Parser, Pos);
Defer_Pos120 := Parser.Current_Pos;

--  END <Defer (for 'grammar_pick') at parser.lkt:42:11>

    if Defer_Pos120 /= No_Token_Index then
        Or_Pos24 := Defer_Pos120;
        Or_Res24 := Defer_Res120;
        goto Exit_Or25;
    end if;
    
--  BEGIN <Defer (for 'grammar_list_expr') at parser.lkt:43:11>

Defer_Res121 :=
   Grammar_List_Expr_Transform_Parse3 (Parser, Pos);
Defer_Pos121 := Parser.Current_Pos;

--  END <Defer (for 'grammar_list_expr') at parser.lkt:43:11>

    if Defer_Pos121 /= No_Token_Index then
        Or_Pos24 := Defer_Pos121;
        Or_Res24 := Defer_Res121;
        goto Exit_Or25;
    end if;
    
--  BEGIN <Defer (for 'token_literal') at parser.lkt:44:11>

Defer_Res122 :=
   Token_Literal_Transform_Parse0 (Parser, Pos);
Defer_Pos122 := Parser.Current_Pos;

--  END <Defer (for 'token_literal') at parser.lkt:44:11>

    if Defer_Pos122 /= No_Token_Index then
        Or_Pos24 := Defer_Pos122;
        Or_Res24 := Defer_Res122;
        goto Exit_Or25;
    end if;
    
--  BEGIN <Defer (for 'token_no_case_literal') at parser.lkt:45:11>

Defer_Res123 :=
   Token_No_Case_Literal_Transform_Parse0 (Parser, Pos);
Defer_Pos123 := Parser.Current_Pos;

--  END <Defer (for 'token_no_case_literal') at parser.lkt:45:11>

    if Defer_Pos123 /= No_Token_Index then
        Or_Pos24 := Defer_Pos123;
        Or_Res24 := Defer_Res123;
        goto Exit_Or25;
    end if;
    
--  BEGIN <Defer (for 'token_pattern') at parser.lkt:46:11>

Defer_Res124 :=
   Token_Pattern_Or_Parse0 (Parser, Pos);
Defer_Pos124 := Parser.Current_Pos;

--  END <Defer (for 'token_pattern') at parser.lkt:46:11>

    if Defer_Pos124 /= No_Token_Index then
        Or_Pos24 := Defer_Pos124;
        Or_Res24 := Defer_Res124;
        goto Exit_Or25;
    end if;
    
--  BEGIN <Defer (for 'grammar_cut') at parser.lkt:47:11>

Defer_Res125 :=
   Grammar_Cut_Transform_Parse0 (Parser, Pos);
Defer_Pos125 := Parser.Current_Pos;

--  END <Defer (for 'grammar_cut') at parser.lkt:47:11>

    if Defer_Pos125 /= No_Token_Index then
        Or_Pos24 := Defer_Pos125;
        Or_Res24 := Defer_Res125;
        goto Exit_Or25;
    end if;
    
--  BEGIN <Defer (for 'grammar_skip') at parser.lkt:48:11>

Defer_Res126 :=
   Grammar_Skip_Transform_Parse0 (Parser, Pos);
Defer_Pos126 := Parser.Current_Pos;

--  END <Defer (for 'grammar_skip') at parser.lkt:48:11>

    if Defer_Pos126 /= No_Token_Index then
        Or_Pos24 := Defer_Pos126;
        Or_Res24 := Defer_Res126;
        goto Exit_Or25;
    end if;
    
--  BEGIN <Defer (for 'grammar_null') at parser.lkt:49:11>

Defer_Res127 :=
   Grammar_Null_Transform_Parse0 (Parser, Pos);
Defer_Pos127 := Parser.Current_Pos;

--  END <Defer (for 'grammar_null') at parser.lkt:49:11>

    if Defer_Pos127 /= No_Token_Index then
        Or_Pos24 := Defer_Pos127;
        Or_Res24 := Defer_Res127;
        goto Exit_Or25;
    end if;
    
--  BEGIN <Defer (for 'grammar_token') at parser.lkt:50:11>

Defer_Res128 :=
   Grammar_Token_Transform_Parse0 (Parser, Pos);
Defer_Pos128 := Parser.Current_Pos;

--  END <Defer (for 'grammar_token') at parser.lkt:50:11>

    if Defer_Pos128 /= No_Token_Index then
        Or_Pos24 := Defer_Pos128;
        Or_Res24 := Defer_Res128;
        goto Exit_Or25;
    end if;
    
--  BEGIN <Defer (for 'grammar_stopcut') at parser.lkt:51:11>

Defer_Res129 :=
   Grammar_Stopcut_Transform_Parse0 (Parser, Pos);
Defer_Pos129 := Parser.Current_Pos;

--  END <Defer (for 'grammar_stopcut') at parser.lkt:51:11>

    if Defer_Pos129 /= No_Token_Index then
        Or_Pos24 := Defer_Pos129;
        Or_Res24 := Defer_Res129;
        goto Exit_Or25;
    end if;
    
--  BEGIN <Defer (for 'parse_node_expr') at parser.lkt:52:11>

Defer_Res130 :=
   Parse_Node_Expr_Transform_Parse0 (Parser, Pos);
Defer_Pos130 := Parser.Current_Pos;

--  END <Defer (for 'parse_node_expr') at parser.lkt:52:11>

    if Defer_Pos130 /= No_Token_Index then
        Or_Pos24 := Defer_Pos130;
        Or_Res24 := Defer_Res130;
        goto Exit_Or25;
    end if;
    
--  BEGIN <Defer (for 'grammar_opt') at parser.lkt:53:11>

Defer_Res131 :=
   Grammar_Opt_Or_Parse0 (Parser, Pos);
Defer_Pos131 := Parser.Current_Pos;

--  END <Defer (for 'grammar_opt') at parser.lkt:53:11>

    if Defer_Pos131 /= No_Token_Index then
        Or_Pos24 := Defer_Pos131;
        Or_Res24 := Defer_Res131;
        goto Exit_Or25;
    end if;
    
--  BEGIN <Defer (for 'grammar_opt_error') at parser.lkt:54:11>

Defer_Res132 :=
   Grammar_Opt_Error_Or_Parse0 (Parser, Pos);
Defer_Pos132 := Parser.Current_Pos;

--  END <Defer (for 'grammar_opt_error') at parser.lkt:54:11>

    if Defer_Pos132 /= No_Token_Index then
        Or_Pos24 := Defer_Pos132;
        Or_Res24 := Defer_Res132;
        goto Exit_Or25;
    end if;
    
--  BEGIN <Defer (for 'grammar_or_expr') at parser.lkt:55:11>

Defer_Res133 :=
   Grammar_Or_Expr_Transform_Parse0 (Parser, Pos);
Defer_Pos133 := Parser.Current_Pos;

--  END <Defer (for 'grammar_or_expr') at parser.lkt:55:11>

    if Defer_Pos133 /= No_Token_Index then
        Or_Pos24 := Defer_Pos133;
        Or_Res24 := Defer_Res133;
        goto Exit_Or25;
    end if;
    
--  BEGIN <Defer (for 'grammar_rule_ref') at parser.lkt:56:11>

Defer_Res134 :=
   Grammar_Rule_Ref_Transform_Parse0 (Parser, Pos);
Defer_Pos134 := Parser.Current_Pos;

--  END <Defer (for 'grammar_rule_ref') at parser.lkt:56:11>

    if Defer_Pos134 /= No_Token_Index then
        Or_Pos24 := Defer_Pos134;
        Or_Res24 := Defer_Res134;
        goto Exit_Or25;
    end if;
    
--  BEGIN <Defer (for 'grammar_discard_expr') at parser.lkt:57:11>

Defer_Res135 :=
   Grammar_Discard_Expr_Transform_Parse0 (Parser, Pos);
Defer_Pos135 := Parser.Current_Pos;

--  END <Defer (for 'grammar_discard_expr') at parser.lkt:57:11>

    if Defer_Pos135 /= No_Token_Index then
        Or_Pos24 := Defer_Pos135;
        Or_Res24 := Defer_Res135;
        goto Exit_Or25;
    end if;
<<Exit_Or25>>

--  END <Or (root of 'grammar_primary') at parser.lkt:41:24>


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (PP.Grammar_Primary_Or_Parse0_Memo,
      Or_Pos24 /= No_Token_Index,
      Or_Res24,
      Pos,
      Or_Pos24);


   Parser.Current_Pos := Or_Pos24;

   return Or_Res24;
end Grammar_Primary_Or_Parse0;

   


function Grammar_Rule_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Grammar_Rule_Decl
is
   use Bare_Grammar_Rule_Decl_Memos;

      Row_Pos94 :
            Token_Index
               := No_Token_Index;
      Defer_Pos136 :
            Token_Index
               := No_Token_Index;
      Defer_Res136 :
            Bare_Def_Id
               := No_Bare_Lkt_Node;
      Row_Pos95 :
            Token_Index
               := No_Token_Index;
      Token_Pos134 :
            Token_Index
               := No_Token_Index;
      Token_Res134 :
            Token_Index
               := No_Token_Index;
      Defer_Pos137 :
            Token_Index
               := No_Token_Index;
      Defer_Res137 :
            Bare_Grammar_Expr
               := No_Bare_Lkt_Node;
      Transform_Res83 :
            Bare_Grammar_Rule_Decl
               := No_Bare_Lkt_Node;
      Transform_Diags83 :
            Ada.Containers.Count_Type;


   PP : constant Parser_Private_Part := +Parser.Private_Part;
   M  : Memo_Entry := Get (PP.Grammar_Rule_Transform_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res83 := M.Instance;
      return Transform_Res83;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res83;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  BEGIN <Transform(<ASTNodeType GrammarRuleDecl>) (root of 'grammar_rule') at parser.lkt:17:21>

Transform_Diags83 := Parser.Diagnostics.Length;


--  BEGIN <_Row (root of 'grammar_rule') at parser.lkt:17:21>

Row_Pos94 := Pos;



--  BEGIN <Defer (for 'def_id') at parser.lkt:17:37>

Defer_Res136 :=
   Def_Id_Transform_Parse0 (Parser, Row_Pos94);
Defer_Pos136 := Parser.Current_Pos;

--  END <Defer (for 'def_id') at parser.lkt:17:37>




if Defer_Pos136 /= No_Token_Index then

   Row_Pos94 := Defer_Pos136;

else
   Row_Pos94 := No_Token_Index;
   goto Exit_Row94_0;

end if;


--  BEGIN <Opt (root of 'grammar_rule') at parser.lkt:17:44>












--  BEGIN <_Extract (root of 'grammar_rule') at parser.lkt:17:45>

--  BEGIN <_Row (root of 'grammar_rule') at parser.lkt:17:45>

Row_Pos95 := Row_Pos94;



--  BEGIN <Token(<WithText LeftArrow>, ) (root of 'grammar_rule') at parser.lkt:17:50>

Token_Res134 := Row_Pos95;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res134));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_Left_Arrow)
   then
       Token_Pos134 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos95 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos95,
             Expected_Token_Id => Lkt_Left_Arrow,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos134 := Row_Pos95 + 1;
   end if;
end;

--  END <Token(<WithText LeftArrow>, ) (root of 'grammar_rule') at parser.lkt:17:50>




if Token_Pos134 /= No_Token_Index then

   Row_Pos95 := Token_Pos134;

else
   Row_Pos95 := No_Token_Index;
   goto Exit_Row95_0;

end if;


--  BEGIN <Defer (for 'grammar_expr') at parser.lkt:17:55>

Defer_Res137 :=
   Grammar_Expr_Or_Parse0 (Parser, Row_Pos95);
Defer_Pos137 := Parser.Current_Pos;

--  END <Defer (for 'grammar_expr') at parser.lkt:17:55>




if Defer_Pos137 /= No_Token_Index then

   Row_Pos95 := Defer_Pos137;

else
   Row_Pos95 := No_Token_Index;
   goto Exit_Row95_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row95_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'grammar_rule') at parser.lkt:17:45>

--  END <_Extract (root of 'grammar_rule') at parser.lkt:17:45>


if Row_Pos95 = No_Token_Index then

         
   Defer_Res137 := No_Bare_Lkt_Node;



       
   Row_Pos95 := Row_Pos94;



end if;

--  END <Opt (root of 'grammar_rule') at parser.lkt:17:44>




if Row_Pos95 /= No_Token_Index then

   Row_Pos94 := Row_Pos95;

else
   Row_Pos94 := No_Token_Index;
   goto Exit_Row94_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row94_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'grammar_rule') at parser.lkt:17:21>



if Row_Pos94 /= No_Token_Index then

   Transform_Res83 := Allocate_Grammar_Rule_Decl (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res83,
      Kind => Lkt_Grammar_Rule_Decl,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos94 = Pos
                            then No_Token_Index
                            else Row_Pos94 - 1));

      
      Initialize_Fields_For_Grammar_Rule_Decl
        (Self => Transform_Res83,
         Grammar_Rule_Decl_F_Syn_Name => Defer_Res136,
         Grammar_Rule_Decl_F_Expr => Defer_Res137);

         if Defer_Res136 /= null and then Is_Incomplete (Defer_Res136) then
            Transform_Res83.Last_Attempted_Child := 0;
         elsif Defer_Res136 /= null and then not Is_Ghost (Defer_Res136) then
            Transform_Res83.Last_Attempted_Child := -1;
         end if;
         if Defer_Res137 /= null and then Is_Incomplete (Defer_Res137) then
            Transform_Res83.Last_Attempted_Child := 0;
         elsif Defer_Res137 /= null and then not Is_Ghost (Defer_Res137) then
            Transform_Res83.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos94 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags83);
end if;

--  END <Transform(<ASTNodeType GrammarRuleDecl>) (root of 'grammar_rule') at parser.lkt:17:21>


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (PP.Grammar_Rule_Transform_Parse0_Memo,
      Row_Pos94 /= No_Token_Index,
      Transform_Res83,
      Pos,
      Row_Pos94);


   Parser.Current_Pos := Row_Pos94;

   return Transform_Res83;
end Grammar_Rule_Transform_Parse0;

   


function Grammar_Rule_Ref_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Grammar_Rule_Ref
is
   use Bare_Grammar_Rule_Ref_Memos;

      Row_Pos96 :
            Token_Index
               := No_Token_Index;
      Defer_Pos138 :
            Token_Index
               := No_Token_Index;
      Defer_Res138 :
            Bare_Ref_Id
               := No_Bare_Lkt_Node;
      Transform_Res84 :
            Bare_Grammar_Rule_Ref
               := No_Bare_Lkt_Node;
      Transform_Diags84 :
            Ada.Containers.Count_Type;


   PP : constant Parser_Private_Part := +Parser.Private_Part;
   M  : Memo_Entry := Get (PP.Grammar_Rule_Ref_Transform_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res84 := M.Instance;
      return Transform_Res84;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res84;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  BEGIN <Transform(<ASTNodeType GrammarRuleRef>) (root of 'grammar_rule_ref') at parser.lkt:98:25>

Transform_Diags84 := Parser.Diagnostics.Length;


--  BEGIN <_Row (root of 'grammar_rule_ref') at parser.lkt:98:25>

Row_Pos96 := Pos;



--  BEGIN <Defer (for 'ref_id') at parser.lkt:98:40>

Defer_Res138 :=
   Ref_Id_Transform_Parse0 (Parser, Row_Pos96);
Defer_Pos138 := Parser.Current_Pos;

--  END <Defer (for 'ref_id') at parser.lkt:98:40>




if Defer_Pos138 /= No_Token_Index then

   Row_Pos96 := Defer_Pos138;

else
   Row_Pos96 := No_Token_Index;
   goto Exit_Row96_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row96_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'grammar_rule_ref') at parser.lkt:98:25>



if Row_Pos96 /= No_Token_Index then

   Transform_Res84 := Allocate_Grammar_Rule_Ref (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res84,
      Kind => Lkt_Grammar_Rule_Ref,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos96 = Pos
                            then No_Token_Index
                            else Row_Pos96 - 1));

      
      Initialize_Fields_For_Grammar_Rule_Ref
        (Self => Transform_Res84,
         Grammar_Rule_Ref_F_Node_Name => Defer_Res138);

         if Defer_Res138 /= null and then Is_Incomplete (Defer_Res138) then
            Transform_Res84.Last_Attempted_Child := 0;
         elsif Defer_Res138 /= null and then not Is_Ghost (Defer_Res138) then
            Transform_Res84.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos96 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags84);
end if;

--  END <Transform(<ASTNodeType GrammarRuleRef>) (root of 'grammar_rule_ref') at parser.lkt:98:25>


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (PP.Grammar_Rule_Ref_Transform_Parse0_Memo,
      Row_Pos96 /= No_Token_Index,
      Transform_Res84,
      Pos,
      Row_Pos96);


   Parser.Current_Pos := Row_Pos96;

   return Transform_Res84;
end Grammar_Rule_Ref_Transform_Parse0;

   


function Grammar_Skip_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Grammar_Skip
is
   use Bare_Grammar_Skip_Memos;

      Row_Pos97 :
            Token_Index
               := No_Token_Index;
      Token_Pos135 :
            Token_Index
               := No_Token_Index;
      Token_Res135 :
            Token_Index
               := No_Token_Index;
      Token_Pos136 :
            Token_Index
               := No_Token_Index;
      Token_Res136 :
            Token_Index
               := No_Token_Index;
      Defer_Pos139 :
            Token_Index
               := No_Token_Index;
      Defer_Res139 :
            Bare_Type_Ref
               := No_Bare_Lkt_Node;
      Token_Pos137 :
            Token_Index
               := No_Token_Index;
      Token_Res137 :
            Token_Index
               := No_Token_Index;
      Transform_Res85 :
            Bare_Grammar_Skip
               := No_Bare_Lkt_Node;
      Transform_Diags85 :
            Ada.Containers.Count_Type;


   PP : constant Parser_Private_Part := +Parser.Private_Part;
   M  : Memo_Entry := Get (PP.Grammar_Skip_Transform_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res85 := M.Instance;
      return Transform_Res85;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res85;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  BEGIN <Transform(<ASTNodeType GrammarSkip>) (root of 'grammar_skip') at parser.lkt:115:21>

Transform_Diags85 := Parser.Diagnostics.Length;


--  BEGIN <_Row (root of 'grammar_skip') at parser.lkt:115:21>

Row_Pos97 := Pos;



--  BEGIN <Token(<WithSymbol Identifier>, skip) (root of 'grammar_skip') at parser.lkt:115:33>

Token_Res135 := Row_Pos97;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res135));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_Identifier)
      or else T.Symbol /= Precomputed_Symbol
        (Precomputed_Symbol_Table (Parser.TDH.Symbols),
         Precomputed_Sym_Skip)
   then
       Token_Pos135 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos97 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos97,
             Expected_Token_Id => Lkt_Identifier,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos135 := Row_Pos97 + 1;
   end if;
end;

--  END <Token(<WithSymbol Identifier>, skip) (root of 'grammar_skip') at parser.lkt:115:33>




if Token_Pos135 /= No_Token_Index then

   Row_Pos97 := Token_Pos135;

else
   Row_Pos97 := No_Token_Index;
   goto Exit_Row97_0;

end if;


--  BEGIN <Token(<WithText LPar>, ) (root of 'grammar_skip') at parser.lkt:115:53>

Token_Res136 := Row_Pos97;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res136));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_L_Par)
   then
       Token_Pos136 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos97 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos97,
             Expected_Token_Id => Lkt_L_Par,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos136 := Row_Pos97 + 1;
   end if;
end;

--  END <Token(<WithText LPar>, ) (root of 'grammar_skip') at parser.lkt:115:53>




if Token_Pos136 /= No_Token_Index then

   Row_Pos97 := Token_Pos136;

else
   Row_Pos97 := No_Token_Index;
   goto Exit_Row97_0;

end if;


--  BEGIN <Defer (for 'type_ref') at parser.lkt:115:57>

Defer_Res139 :=
   Type_Ref_Or_Parse0 (Parser, Row_Pos97);
Defer_Pos139 := Parser.Current_Pos;

--  END <Defer (for 'type_ref') at parser.lkt:115:57>




if Defer_Pos139 /= No_Token_Index then

   Row_Pos97 := Defer_Pos139;

else
   Row_Pos97 := No_Token_Index;
   goto Exit_Row97_0;

end if;


--  BEGIN <Token(<WithText RPar>, ) (root of 'grammar_skip') at parser.lkt:115:66>

Token_Res137 := Row_Pos97;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res137));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_R_Par)
   then
       Token_Pos137 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos97 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos97,
             Expected_Token_Id => Lkt_R_Par,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos137 := Row_Pos97 + 1;
   end if;
end;

--  END <Token(<WithText RPar>, ) (root of 'grammar_skip') at parser.lkt:115:66>




if Token_Pos137 /= No_Token_Index then

   Row_Pos97 := Token_Pos137;

else
   Row_Pos97 := No_Token_Index;
   goto Exit_Row97_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row97_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'grammar_skip') at parser.lkt:115:21>



if Row_Pos97 /= No_Token_Index then

   Transform_Res85 := Allocate_Grammar_Skip (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res85,
      Kind => Lkt_Grammar_Skip,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos97 = Pos
                            then No_Token_Index
                            else Row_Pos97 - 1));

      
      Initialize_Fields_For_Grammar_Skip
        (Self => Transform_Res85,
         Grammar_Skip_F_Name => Defer_Res139);

         if Defer_Res139 /= null and then Is_Incomplete (Defer_Res139) then
            Transform_Res85.Last_Attempted_Child := 0;
         elsif Defer_Res139 /= null and then not Is_Ghost (Defer_Res139) then
            Transform_Res85.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos97 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags85);
end if;

--  END <Transform(<ASTNodeType GrammarSkip>) (root of 'grammar_skip') at parser.lkt:115:21>


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (PP.Grammar_Skip_Transform_Parse0_Memo,
      Row_Pos97 /= No_Token_Index,
      Transform_Res85,
      Pos,
      Row_Pos97);


   Parser.Current_Pos := Row_Pos97;

   return Transform_Res85;
end Grammar_Skip_Transform_Parse0;

   


function Grammar_Stopcut_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Grammar_Stop_Cut
is
   use Bare_Grammar_Stop_Cut_Memos;

      Row_Pos98 :
            Token_Index
               := No_Token_Index;
      Token_Pos138 :
            Token_Index
               := No_Token_Index;
      Token_Res138 :
            Token_Index
               := No_Token_Index;
      Token_Pos139 :
            Token_Index
               := No_Token_Index;
      Token_Res139 :
            Token_Index
               := No_Token_Index;
      Defer_Pos140 :
            Token_Index
               := No_Token_Index;
      Defer_Res140 :
            Bare_Grammar_Expr
               := No_Bare_Lkt_Node;
      Token_Pos140 :
            Token_Index
               := No_Token_Index;
      Token_Res140 :
            Token_Index
               := No_Token_Index;
      Transform_Res86 :
            Bare_Grammar_Stop_Cut
               := No_Bare_Lkt_Node;
      Transform_Diags86 :
            Ada.Containers.Count_Type;


   PP : constant Parser_Private_Part := +Parser.Private_Part;
   M  : Memo_Entry := Get (PP.Grammar_Stopcut_Transform_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res86 := M.Instance;
      return Transform_Res86;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res86;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  BEGIN <Transform(<ASTNodeType GrammarStopCut>) (root of 'grammar_stopcut') at parser.lkt:81:24>

Transform_Diags86 := Parser.Diagnostics.Length;


--  BEGIN <_Row (root of 'grammar_stopcut') at parser.lkt:81:24>

Row_Pos98 := Pos;



--  BEGIN <Token(<WithSymbol Identifier>, stop_cut) (root of 'grammar_stopcut') at parser.lkt:82:9>

Token_Res138 := Row_Pos98;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res138));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_Identifier)
      or else T.Symbol /= Precomputed_Symbol
        (Precomputed_Symbol_Table (Parser.TDH.Symbols),
         Precomputed_Sym_Stop_Cut)
   then
       Token_Pos138 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos98 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos98,
             Expected_Token_Id => Lkt_Identifier,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos138 := Row_Pos98 + 1;
   end if;
end;

--  END <Token(<WithSymbol Identifier>, stop_cut) (root of 'grammar_stopcut') at parser.lkt:82:9>




if Token_Pos138 /= No_Token_Index then

   Row_Pos98 := Token_Pos138;

else
   Row_Pos98 := No_Token_Index;
   goto Exit_Row98_0;

end if;


--  BEGIN <Token(<WithText LPar>, ) (root of 'grammar_stopcut') at parser.lkt:82:33>

Token_Res139 := Row_Pos98;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res139));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_L_Par)
   then
       Token_Pos139 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos98 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos98,
             Expected_Token_Id => Lkt_L_Par,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos139 := Row_Pos98 + 1;
   end if;
end;

--  END <Token(<WithText LPar>, ) (root of 'grammar_stopcut') at parser.lkt:82:33>




if Token_Pos139 /= No_Token_Index then

   Row_Pos98 := Token_Pos139;

else
   Row_Pos98 := No_Token_Index;
   goto Exit_Row98_0;

end if;


--  BEGIN <Defer (for 'grammar_expr') at parser.lkt:82:37>

Defer_Res140 :=
   Grammar_Expr_Or_Parse0 (Parser, Row_Pos98);
Defer_Pos140 := Parser.Current_Pos;

--  END <Defer (for 'grammar_expr') at parser.lkt:82:37>




if Defer_Pos140 /= No_Token_Index then

   Row_Pos98 := Defer_Pos140;

else
   Row_Pos98 := No_Token_Index;
   goto Exit_Row98_0;

end if;


--  BEGIN <Token(<WithText RPar>, ) (root of 'grammar_stopcut') at parser.lkt:82:50>

Token_Res140 := Row_Pos98;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res140));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_R_Par)
   then
       Token_Pos140 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos98 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos98,
             Expected_Token_Id => Lkt_R_Par,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos140 := Row_Pos98 + 1;
   end if;
end;

--  END <Token(<WithText RPar>, ) (root of 'grammar_stopcut') at parser.lkt:82:50>




if Token_Pos140 /= No_Token_Index then

   Row_Pos98 := Token_Pos140;

else
   Row_Pos98 := No_Token_Index;
   goto Exit_Row98_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row98_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'grammar_stopcut') at parser.lkt:81:24>



if Row_Pos98 /= No_Token_Index then

   Transform_Res86 := Allocate_Grammar_Stop_Cut (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res86,
      Kind => Lkt_Grammar_Stop_Cut,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos98 = Pos
                            then No_Token_Index
                            else Row_Pos98 - 1));

      
      Initialize_Fields_For_Grammar_Stop_Cut
        (Self => Transform_Res86,
         Grammar_Stop_Cut_F_Expr => Defer_Res140);

         if Defer_Res140 /= null and then Is_Incomplete (Defer_Res140) then
            Transform_Res86.Last_Attempted_Child := 0;
         elsif Defer_Res140 /= null and then not Is_Ghost (Defer_Res140) then
            Transform_Res86.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos98 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags86);
end if;

--  END <Transform(<ASTNodeType GrammarStopCut>) (root of 'grammar_stopcut') at parser.lkt:81:24>


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (PP.Grammar_Stopcut_Transform_Parse0_Memo,
      Row_Pos98 /= No_Token_Index,
      Transform_Res86,
      Pos,
      Row_Pos98);


   Parser.Current_Pos := Row_Pos98;

   return Transform_Res86;
end Grammar_Stopcut_Transform_Parse0;

   


function Grammar_Token_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Token_Ref
is
   use Bare_Token_Ref_Memos;

      Row_Pos99 :
            Token_Index
               := No_Token_Index;
      Token_Pos141 :
            Token_Index
               := No_Token_Index;
      Token_Res141 :
            Token_Index
               := No_Token_Index;
      Defer_Pos141 :
            Token_Index
               := No_Token_Index;
      Defer_Res141 :
            Bare_Ref_Id
               := No_Bare_Lkt_Node;
      Row_Pos100 :
            Token_Index
               := No_Token_Index;
      Token_Pos142 :
            Token_Index
               := No_Token_Index;
      Token_Res142 :
            Token_Index
               := No_Token_Index;
      Defer_Pos142 :
            Token_Index
               := No_Token_Index;
      Defer_Res142 :
            Bare_Token_Lit
               := No_Bare_Lkt_Node;
      Token_Pos143 :
            Token_Index
               := No_Token_Index;
      Token_Res143 :
            Token_Index
               := No_Token_Index;
      Transform_Res87 :
            Bare_Token_Ref
               := No_Bare_Lkt_Node;
      Transform_Diags87 :
            Ada.Containers.Count_Type;


   PP : constant Parser_Private_Part := +Parser.Private_Part;
   M  : Memo_Entry := Get (PP.Grammar_Token_Transform_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res87 := M.Instance;
      return Transform_Res87;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res87;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  BEGIN <Transform(<ASTNodeType TokenRef>) (root of 'grammar_token') at parser.lkt:117:22>

Transform_Diags87 := Parser.Diagnostics.Length;


--  BEGIN <_Row (root of 'grammar_token') at parser.lkt:117:22>

Row_Pos99 := Pos;



--  BEGIN <Token(<WithText At>, ) (root of 'grammar_token') at parser.lkt:117:31>

Token_Res141 := Row_Pos99;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res141));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_At)
   then
       Token_Pos141 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos99 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos99,
             Expected_Token_Id => Lkt_At,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos141 := Row_Pos99 + 1;
   end if;
end;

--  END <Token(<WithText At>, ) (root of 'grammar_token') at parser.lkt:117:31>




if Token_Pos141 /= No_Token_Index then

   Row_Pos99 := Token_Pos141;

else
   Row_Pos99 := No_Token_Index;
   goto Exit_Row99_0;

end if;


--  BEGIN <Defer (for 'ref_id') at parser.lkt:117:35>

Defer_Res141 :=
   Ref_Id_Transform_Parse0 (Parser, Row_Pos99);
Defer_Pos141 := Parser.Current_Pos;

--  END <Defer (for 'ref_id') at parser.lkt:117:35>




if Defer_Pos141 /= No_Token_Index then

   Row_Pos99 := Defer_Pos141;

else
   Row_Pos99 := No_Token_Index;
   goto Exit_Row99_0;

end if;


--  BEGIN <Opt (root of 'grammar_token') at parser.lkt:117:42>












--  BEGIN <_Extract (root of 'grammar_token') at parser.lkt:117:43>

--  BEGIN <_Row (root of 'grammar_token') at parser.lkt:117:43>

Row_Pos100 := Row_Pos99;



--  BEGIN <Token(<WithText LPar>, ) (root of 'grammar_token') at parser.lkt:117:48>

Token_Res142 := Row_Pos100;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res142));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_L_Par)
   then
       Token_Pos142 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos100 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos100,
             Expected_Token_Id => Lkt_L_Par,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos142 := Row_Pos100 + 1;
   end if;
end;

--  END <Token(<WithText LPar>, ) (root of 'grammar_token') at parser.lkt:117:48>




if Token_Pos142 /= No_Token_Index then

   Row_Pos100 := Token_Pos142;

else
   Row_Pos100 := No_Token_Index;
   goto Exit_Row100_0;

end if;


--  BEGIN <Defer (for 'token_literal') at parser.lkt:117:52>

Defer_Res142 :=
   Token_Literal_Transform_Parse0 (Parser, Row_Pos100);
Defer_Pos142 := Parser.Current_Pos;

--  END <Defer (for 'token_literal') at parser.lkt:117:52>




if Defer_Pos142 /= No_Token_Index then

   Row_Pos100 := Defer_Pos142;

else
   Row_Pos100 := No_Token_Index;
   goto Exit_Row100_0;

end if;


--  BEGIN <Token(<WithText RPar>, ) (root of 'grammar_token') at parser.lkt:117:66>

Token_Res143 := Row_Pos100;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res143));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_R_Par)
   then
       Token_Pos143 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos100 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos100,
             Expected_Token_Id => Lkt_R_Par,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos143 := Row_Pos100 + 1;
   end if;
end;

--  END <Token(<WithText RPar>, ) (root of 'grammar_token') at parser.lkt:117:66>




if Token_Pos143 /= No_Token_Index then

   Row_Pos100 := Token_Pos143;

else
   Row_Pos100 := No_Token_Index;
   goto Exit_Row100_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row100_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'grammar_token') at parser.lkt:117:43>

--  END <_Extract (root of 'grammar_token') at parser.lkt:117:43>


if Row_Pos100 = No_Token_Index then

         
   Defer_Res142 := No_Bare_Lkt_Node;



       
   Row_Pos100 := Row_Pos99;



end if;

--  END <Opt (root of 'grammar_token') at parser.lkt:117:42>




if Row_Pos100 /= No_Token_Index then

   Row_Pos99 := Row_Pos100;

else
   Row_Pos99 := No_Token_Index;
   goto Exit_Row99_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row99_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'grammar_token') at parser.lkt:117:22>



if Row_Pos99 /= No_Token_Index then

   Transform_Res87 := Allocate_Token_Ref (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res87,
      Kind => Lkt_Token_Ref,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos99 = Pos
                            then No_Token_Index
                            else Row_Pos99 - 1));

      
      Initialize_Fields_For_Token_Ref
        (Self => Transform_Res87,
         Token_Ref_F_Token_Name => Defer_Res141,
         Token_Ref_F_Expr => Defer_Res142);

         if Defer_Res141 /= null and then Is_Incomplete (Defer_Res141) then
            Transform_Res87.Last_Attempted_Child := 0;
         elsif Defer_Res141 /= null and then not Is_Ghost (Defer_Res141) then
            Transform_Res87.Last_Attempted_Child := -1;
         end if;
         if Defer_Res142 /= null and then Is_Incomplete (Defer_Res142) then
            Transform_Res87.Last_Attempted_Child := 0;
         elsif Defer_Res142 /= null and then not Is_Ghost (Defer_Res142) then
            Transform_Res87.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos99 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags87);
end if;

--  END <Transform(<ASTNodeType TokenRef>) (root of 'grammar_token') at parser.lkt:117:22>


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (PP.Grammar_Token_Transform_Parse0_Memo,
      Row_Pos99 /= No_Token_Index,
      Transform_Res87,
      Pos,
      Row_Pos99);


   Parser.Current_Pos := Row_Pos99;

   return Transform_Res87;
end Grammar_Token_Transform_Parse0;

   


function Id_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Id
is
   use Bare_Id_Memos;

      Row_Pos101 :
            Token_Index
               := No_Token_Index;
      Token_Pos144 :
            Token_Index
               := No_Token_Index;
      Token_Res144 :
            Token_Index
               := No_Token_Index;
      Transform_Res88 :
            Bare_Id
               := No_Bare_Lkt_Node;
      Transform_Diags88 :
            Ada.Containers.Count_Type;


   PP : constant Parser_Private_Part := +Parser.Private_Part;
   M  : Memo_Entry := Get (PP.Id_Transform_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res88 := M.Instance;
      return Transform_Res88;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res88;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  BEGIN <Transform(<ASTNodeType Id>) (root of 'id') at parser.lkt:6:11>

Transform_Diags88 := Parser.Diagnostics.Length;


--  BEGIN <_Row (root of 'id') at parser.lkt:6:11>

Row_Pos101 := Pos;



--  BEGIN <Token(<WithSymbol Identifier>, ) (root of 'id') at parser.lkt:6:14>

Token_Res144 := Row_Pos101;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res144));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_Identifier)
   then
       Token_Pos144 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos101 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos101,
             Expected_Token_Id => Lkt_Identifier,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos144 := Row_Pos101 + 1;
   end if;
end;

--  END <Token(<WithSymbol Identifier>, ) (root of 'id') at parser.lkt:6:14>




if Token_Pos144 /= No_Token_Index then

   Row_Pos101 := Token_Pos144;

else
   Row_Pos101 := No_Token_Index;
   goto Exit_Row101_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row101_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'id') at parser.lkt:6:11>



if Row_Pos101 /= No_Token_Index then

   Transform_Res88 := Allocate_Id (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res88,
      Kind => Lkt_Id,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos101 = Pos
                            then No_Token_Index
                            else Row_Pos101 - 1));

      
      Initialize_Fields_For_Id
        (Self => Transform_Res88);



elsif Row_Pos101 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags88);
end if;

--  END <Transform(<ASTNodeType Id>) (root of 'id') at parser.lkt:6:11>


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (PP.Id_Transform_Parse0_Memo,
      Row_Pos101 /= No_Token_Index,
      Transform_Res88,
      Pos,
      Row_Pos101);


   Parser.Current_Pos := Row_Pos101;

   return Transform_Res88;
end Id_Transform_Parse0;

   


function If_Expr_Transform_Parse1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_If_Expr
is
   use Bare_If_Expr_Memos;

      Row_Pos102 :
            Token_Index
               := No_Token_Index;
      Token_Pos145 :
            Token_Index
               := No_Token_Index;
      Token_Res145 :
            Token_Index
               := No_Token_Index;
      Defer_Pos143 :
            Token_Index
               := No_Token_Index;
      Defer_Res143 :
            Bare_Expr
               := No_Bare_Lkt_Node;
      Token_Pos146 :
            Token_Index
               := No_Token_Index;
      Token_Res146 :
            Token_Index
               := No_Token_Index;
      Defer_Pos144 :
            Token_Index
               := No_Token_Index;
      Defer_Res144 :
            Bare_Expr
               := No_Bare_Lkt_Node;
      Lst_Cpos19 :
            Token_Index
               := No_Token_Index;
      Tmp_List19 :
            Free_Parse_List;
      Row_Pos103 :
            Token_Index
               := No_Token_Index;
      Token_Pos147 :
            Token_Index
               := No_Token_Index;
      Token_Res147 :
            Token_Index
               := No_Token_Index;
      Defer_Pos145 :
            Token_Index
               := No_Token_Index;
      Defer_Res145 :
            Bare_Expr
               := No_Bare_Lkt_Node;
      Token_Pos148 :
            Token_Index
               := No_Token_Index;
      Token_Res148 :
            Token_Index
               := No_Token_Index;
      Defer_Pos146 :
            Token_Index
               := No_Token_Index;
      Defer_Res146 :
            Bare_Expr
               := No_Bare_Lkt_Node;
      Transform_Res89 :
            Bare_Elsif_Branch
               := No_Bare_Lkt_Node;
      Transform_Diags89 :
            Ada.Containers.Count_Type;
      List_Pos19 :
            Token_Index
               := No_Token_Index;
      List_Res19 :
            Bare_Elsif_Branch_List
               := No_Bare_Lkt_Node;
      Token_Pos149 :
            Token_Index
               := No_Token_Index;
      Token_Res149 :
            Token_Index
               := No_Token_Index;
      Defer_Pos147 :
            Token_Index
               := No_Token_Index;
      Defer_Res147 :
            Bare_Expr
               := No_Bare_Lkt_Node;
      Transform_Res90 :
            Bare_If_Expr
               := No_Bare_Lkt_Node;
      Transform_Diags90 :
            Ada.Containers.Count_Type;


   PP : constant Parser_Private_Part := +Parser.Private_Part;
   M  : Memo_Entry := Get (PP.If_Expr_Transform_Parse1_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res90 := M.Instance;
      return Transform_Res90;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res90;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  BEGIN <Transform(<ASTNodeType IfExpr>) (root of 'if_expr') at parser.lkt:368:16>

Transform_Diags90 := Parser.Diagnostics.Length;


--  BEGIN <_Row (root of 'if_expr') at parser.lkt:368:16>

Row_Pos102 := Pos;



--  BEGIN <Token(<WithText IfKw>, ) (root of 'if_expr') at parser.lkt:369:9>

Token_Res145 := Row_Pos102;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res145));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_If_Kw)
   then
       Token_Pos145 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos102 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos102,
             Expected_Token_Id => Lkt_If_Kw,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos145 := Row_Pos102 + 1;
   end if;
end;

--  END <Token(<WithText IfKw>, ) (root of 'if_expr') at parser.lkt:369:9>




if Token_Pos145 /= No_Token_Index then

   Row_Pos102 := Token_Pos145;

else
   Row_Pos102 := No_Token_Index;
   goto Exit_Row102_0;

end if;


--  BEGIN <Defer (for 'expr') at parser.lkt:370:9>

Defer_Res143 :=
   Expr_Or_Parse1 (Parser, Row_Pos102);
Defer_Pos143 := Parser.Current_Pos;

--  END <Defer (for 'expr') at parser.lkt:370:9>




if Defer_Pos143 /= No_Token_Index then

   Row_Pos102 := Defer_Pos143;

else
   Row_Pos102 := No_Token_Index;
   goto Exit_Row102_0;

end if;


--  BEGIN <Token(<WithText ThenKw>, ) (root of 'if_expr') at parser.lkt:371:9>

Token_Res146 := Row_Pos102;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res146));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_Then_Kw)
   then
       Token_Pos146 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos102 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos102,
             Expected_Token_Id => Lkt_Then_Kw,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos146 := Row_Pos102 + 1;
   end if;
end;

--  END <Token(<WithText ThenKw>, ) (root of 'if_expr') at parser.lkt:371:9>




if Token_Pos146 /= No_Token_Index then

   Row_Pos102 := Token_Pos146;

else
   Row_Pos102 := No_Token_Index;
   goto Exit_Row102_0;

end if;


--  BEGIN <Defer (for 'expr') at parser.lkt:372:9>

Defer_Res144 :=
   Expr_Or_Parse1 (Parser, Row_Pos102);
Defer_Pos144 := Parser.Current_Pos;

--  END <Defer (for 'expr') at parser.lkt:372:9>




if Defer_Pos144 /= No_Token_Index then

   Row_Pos102 := Defer_Pos144;

else
   Row_Pos102 := No_Token_Index;
   goto Exit_Row102_0;

end if;


--  BEGIN <List (root of 'if_expr') at parser.lkt:373:9>

    List_Pos19 := Row_Pos102;



Lst_Cpos19 := Row_Pos102;
Tmp_List19 := Get_Parse_List (Parser);


loop
   
--  BEGIN <Transform(<ASTNodeType ElsifBranch>) (root of 'if_expr') at parser.lkt:373:15>

Transform_Diags89 := Parser.Diagnostics.Length;


--  BEGIN <_Row (root of 'if_expr') at parser.lkt:373:15>

Row_Pos103 := Lst_Cpos19;



--  BEGIN <Token(<WithText ElifKw>, ) (root of 'if_expr') at parser.lkt:373:27>

Token_Res147 := Row_Pos103;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res147));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_Elif_Kw)
   then
       Token_Pos147 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos103 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos103,
             Expected_Token_Id => Lkt_Elif_Kw,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos147 := Row_Pos103 + 1;
   end if;
end;

--  END <Token(<WithText ElifKw>, ) (root of 'if_expr') at parser.lkt:373:27>




if Token_Pos147 /= No_Token_Index then

   Row_Pos103 := Token_Pos147;

else
   Row_Pos103 := No_Token_Index;
   goto Exit_Row103_0;

end if;


--  BEGIN <Defer (for 'expr') at parser.lkt:373:34>

Defer_Res145 :=
   Expr_Or_Parse1 (Parser, Row_Pos103);
Defer_Pos145 := Parser.Current_Pos;

--  END <Defer (for 'expr') at parser.lkt:373:34>




if Defer_Pos145 /= No_Token_Index then

   Row_Pos103 := Defer_Pos145;

else
   Row_Pos103 := No_Token_Index;
   goto Exit_Row103_0;

end if;


--  BEGIN <Token(<WithText ThenKw>, ) (root of 'if_expr') at parser.lkt:373:39>

Token_Res148 := Row_Pos103;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res148));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_Then_Kw)
   then
       Token_Pos148 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos103 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos103,
             Expected_Token_Id => Lkt_Then_Kw,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos148 := Row_Pos103 + 1;
   end if;
end;

--  END <Token(<WithText ThenKw>, ) (root of 'if_expr') at parser.lkt:373:39>




if Token_Pos148 /= No_Token_Index then

   Row_Pos103 := Token_Pos148;

else
   Row_Pos103 := No_Token_Index;
   goto Exit_Row103_0;

end if;


--  BEGIN <Defer (for 'expr') at parser.lkt:373:46>

Defer_Res146 :=
   Expr_Or_Parse1 (Parser, Row_Pos103);
Defer_Pos146 := Parser.Current_Pos;

--  END <Defer (for 'expr') at parser.lkt:373:46>




if Defer_Pos146 /= No_Token_Index then

   Row_Pos103 := Defer_Pos146;

else
   Row_Pos103 := No_Token_Index;
   goto Exit_Row103_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row103_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'if_expr') at parser.lkt:373:15>



if Row_Pos103 /= No_Token_Index then

   Transform_Res89 := Allocate_Elsif_Branch (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res89,
      Kind => Lkt_Elsif_Branch,
      Unit => Parser.Unit,

      Token_Start_Index => Lst_Cpos19,
      Token_End_Index   => (if Row_Pos103 = Lst_Cpos19
                            then No_Token_Index
                            else Row_Pos103 - 1));

      
      Initialize_Fields_For_Elsif_Branch
        (Self => Transform_Res89,
         Elsif_Branch_F_Cond_Expr => Defer_Res145,
         Elsif_Branch_F_Then_Expr => Defer_Res146);

         if Defer_Res145 /= null and then Is_Incomplete (Defer_Res145) then
            Transform_Res89.Last_Attempted_Child := 0;
         elsif Defer_Res145 /= null and then not Is_Ghost (Defer_Res145) then
            Transform_Res89.Last_Attempted_Child := -1;
         end if;
         if Defer_Res146 /= null and then Is_Incomplete (Defer_Res146) then
            Transform_Res89.Last_Attempted_Child := 0;
         elsif Defer_Res146 /= null and then not Is_Ghost (Defer_Res146) then
            Transform_Res89.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos103 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags89);
end if;

--  END <Transform(<ASTNodeType ElsifBranch>) (root of 'if_expr') at parser.lkt:373:15>


   exit when Row_Pos103 = No_Token_Index;

   List_Pos19 := Row_Pos103;
   Lst_Cpos19 := List_Pos19;

   Tmp_List19.Nodes.Append (Transform_Res89);

end loop;


declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List19.Nodes.Length;
begin
   List_Res19 := Allocate_Elsif_Branch_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Row_Pos102;
      Token_End := (if Lst_Cpos19 = Row_Pos102
                    then Row_Pos102
                    else List_Pos19 - 1);

   else
      Token_Start := Token_Index'Max (Row_Pos102, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res19,
      Kind              => Lkt_Elsif_Branch_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res19,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_Lkt_Node_Vectors.Vector renames
         Tmp_List19.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res19.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List19);

--  END <List (root of 'if_expr') at parser.lkt:373:9>




if List_Pos19 /= No_Token_Index then

   Row_Pos102 := List_Pos19;

else
   Row_Pos102 := No_Token_Index;
   goto Exit_Row102_0;

end if;


--  BEGIN <Token(<WithText ElseKw>, ) (root of 'if_expr') at parser.lkt:374:9>

Token_Res149 := Row_Pos102;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res149));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_Else_Kw)
   then
       Token_Pos149 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos102 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos102,
             Expected_Token_Id => Lkt_Else_Kw,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos149 := Row_Pos102 + 1;
   end if;
end;

--  END <Token(<WithText ElseKw>, ) (root of 'if_expr') at parser.lkt:374:9>




if Token_Pos149 /= No_Token_Index then

   Row_Pos102 := Token_Pos149;

else
   Row_Pos102 := No_Token_Index;
   goto Exit_Row102_0;

end if;


--  BEGIN <Defer (for 'expr') at parser.lkt:375:9>

Defer_Res147 :=
   Expr_Or_Parse1 (Parser, Row_Pos102);
Defer_Pos147 := Parser.Current_Pos;

--  END <Defer (for 'expr') at parser.lkt:375:9>




if Defer_Pos147 /= No_Token_Index then

   Row_Pos102 := Defer_Pos147;

else
   Row_Pos102 := No_Token_Index;
   goto Exit_Row102_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row102_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'if_expr') at parser.lkt:368:16>



if Row_Pos102 /= No_Token_Index then

   Transform_Res90 := Allocate_If_Expr (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res90,
      Kind => Lkt_If_Expr,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos102 = Pos
                            then No_Token_Index
                            else Row_Pos102 - 1));

      
      Initialize_Fields_For_If_Expr
        (Self => Transform_Res90,
         If_Expr_F_Cond_Expr => Defer_Res143,
         If_Expr_F_Then_Expr => Defer_Res144,
         If_Expr_F_Alternatives => List_Res19,
         If_Expr_F_Else_Expr => Defer_Res147);

         if Defer_Res143 /= null and then Is_Incomplete (Defer_Res143) then
            Transform_Res90.Last_Attempted_Child := 0;
         elsif Defer_Res143 /= null and then not Is_Ghost (Defer_Res143) then
            Transform_Res90.Last_Attempted_Child := -1;
         end if;
         if Defer_Res144 /= null and then Is_Incomplete (Defer_Res144) then
            Transform_Res90.Last_Attempted_Child := 0;
         elsif Defer_Res144 /= null and then not Is_Ghost (Defer_Res144) then
            Transform_Res90.Last_Attempted_Child := -1;
         end if;
         if List_Res19 /= null and then Is_Incomplete (List_Res19) then
            Transform_Res90.Last_Attempted_Child := 0;
         elsif List_Res19 /= null and then not Is_Ghost (List_Res19) then
            Transform_Res90.Last_Attempted_Child := -1;
         end if;
         if Defer_Res147 /= null and then Is_Incomplete (Defer_Res147) then
            Transform_Res90.Last_Attempted_Child := 0;
         elsif Defer_Res147 /= null and then not Is_Ghost (Defer_Res147) then
            Transform_Res90.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos102 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags90);
end if;

--  END <Transform(<ASTNodeType IfExpr>) (root of 'if_expr') at parser.lkt:368:16>


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (PP.If_Expr_Transform_Parse1_Memo,
      Row_Pos102 /= No_Token_Index,
      Transform_Res90,
      Pos,
      Row_Pos102);


   Parser.Current_Pos := Row_Pos102;

   return Transform_Res90;
end If_Expr_Transform_Parse1;

   


function Import_Stmt_Transform_Parse1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Import
is
   use Bare_Import_Memos;

      Row_Pos104 :
            Token_Index
               := No_Token_Index;
      Token_Pos150 :
            Token_Index
               := No_Token_Index;
      Token_Res150 :
            Token_Index
               := No_Token_Index;
      Row_Pos105 :
            Token_Index
               := No_Token_Index;
      Token_Pos151 :
            Token_Index
               := No_Token_Index;
      Token_Res151 :
            Token_Index
               := No_Token_Index;
      Transform_Res91 :
            Bare_Module_Ref_Id
               := No_Bare_Lkt_Node;
      Transform_Diags91 :
            Ada.Containers.Count_Type;
      Transform_Res92 :
            Bare_Import
               := No_Bare_Lkt_Node;
      Transform_Diags92 :
            Ada.Containers.Count_Type;


   PP : constant Parser_Private_Part := +Parser.Private_Part;
   M  : Memo_Entry := Get (PP.Import_Stmt_Transform_Parse1_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res92 := M.Instance;
      return Transform_Res92;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res92;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  BEGIN <Transform(<ASTNodeType Import>) (root of 'import_stmt') at parser.lkt:11:20>

Transform_Diags92 := Parser.Diagnostics.Length;


--  BEGIN <_Row (root of 'import_stmt') at parser.lkt:11:20>

Row_Pos104 := Pos;



--  BEGIN <Token(<WithText ImportKw>, ) (root of 'import_stmt') at parser.lkt:11:27>

Token_Res150 := Row_Pos104;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res150));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_Import_Kw)
   then
       Token_Pos150 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos104 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos104,
             Expected_Token_Id => Lkt_Import_Kw,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos150 := Row_Pos104 + 1;
   end if;
end;

--  END <Token(<WithText ImportKw>, ) (root of 'import_stmt') at parser.lkt:11:27>




if Token_Pos150 /= No_Token_Index then

   Row_Pos104 := Token_Pos150;

else
   Row_Pos104 := No_Token_Index;
   goto Exit_Row104_0;

end if;


--  BEGIN <Transform(<ASTNodeType ModuleRefId>) (root of 'import_stmt') at parser.lkt:11:36>

Transform_Diags91 := Parser.Diagnostics.Length;


--  BEGIN <_Row (root of 'import_stmt') at parser.lkt:11:36>

Row_Pos105 := Row_Pos104;



--  BEGIN <Token(<WithSymbol Identifier>, ) (root of 'import_stmt') at parser.lkt:11:48>

Token_Res151 := Row_Pos105;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res151));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_Identifier)
   then
       Token_Pos151 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos105 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos105,
             Expected_Token_Id => Lkt_Identifier,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos151 := Row_Pos105 + 1;
   end if;
end;

--  END <Token(<WithSymbol Identifier>, ) (root of 'import_stmt') at parser.lkt:11:48>




if Token_Pos151 /= No_Token_Index then

   Row_Pos105 := Token_Pos151;

else
   Row_Pos105 := No_Token_Index;
   goto Exit_Row105_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row105_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'import_stmt') at parser.lkt:11:36>



if Row_Pos105 /= No_Token_Index then

   Transform_Res91 := Allocate_Module_Ref_Id (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res91,
      Kind => Lkt_Module_Ref_Id,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos104,
      Token_End_Index   => (if Row_Pos105 = Row_Pos104
                            then No_Token_Index
                            else Row_Pos105 - 1));

      
      Initialize_Fields_For_Module_Ref_Id
        (Self => Transform_Res91);



elsif Row_Pos105 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags91);
end if;

--  END <Transform(<ASTNodeType ModuleRefId>) (root of 'import_stmt') at parser.lkt:11:36>




if Row_Pos105 /= No_Token_Index then

   Row_Pos104 := Row_Pos105;

else
   Row_Pos104 := No_Token_Index;
   goto Exit_Row104_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row104_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'import_stmt') at parser.lkt:11:20>



if Row_Pos104 /= No_Token_Index then

   Transform_Res92 := Allocate_Import (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res92,
      Kind => Lkt_Import,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos104 = Pos
                            then No_Token_Index
                            else Row_Pos104 - 1));

      
      Initialize_Fields_For_Import
        (Self => Transform_Res92,
         Import_F_Name => Transform_Res91);

         if Transform_Res91 /= null and then Is_Incomplete (Transform_Res91) then
            Transform_Res92.Last_Attempted_Child := 0;
         elsif Transform_Res91 /= null and then not Is_Ghost (Transform_Res91) then
            Transform_Res92.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos104 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags92);
end if;

--  END <Transform(<ASTNodeType Import>) (root of 'import_stmt') at parser.lkt:11:20>


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (PP.Import_Stmt_Transform_Parse1_Memo,
      Row_Pos104 /= No_Token_Index,
      Transform_Res92,
      Pos,
      Row_Pos104);


   Parser.Current_Pos := Row_Pos104;

   return Transform_Res92;
end Import_Stmt_Transform_Parse1;

   


function Imports_List_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Import_List
is
   use Bare_Import_List_Memos;

      Lst_Cpos20 :
            Token_Index
               := No_Token_Index;
      Tmp_List20 :
            Free_Parse_List;
      Defer_Pos148 :
            Token_Index
               := No_Token_Index;
      Defer_Res148 :
            Bare_Import
               := No_Bare_Lkt_Node;
      List_Pos20 :
            Token_Index
               := No_Token_Index;
      List_Res20 :
            Bare_Import_List
               := No_Bare_Lkt_Node;


   PP : constant Parser_Private_Part := +Parser.Private_Part;
   M  : Memo_Entry := Get (PP.Imports_List_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      List_Res20 := M.Instance;
      return List_Res20;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return List_Res20;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  BEGIN <List (root of 'imports') at parser.lkt:12:16>

    List_Pos20 := Pos;



Lst_Cpos20 := Pos;
Tmp_List20 := Get_Parse_List (Parser);


loop
   
--  BEGIN <Defer (for 'import_stmt') at parser.lkt:12:22>

Defer_Res148 :=
   Import_Stmt_Transform_Parse1 (Parser, Lst_Cpos20);
Defer_Pos148 := Parser.Current_Pos;

--  END <Defer (for 'import_stmt') at parser.lkt:12:22>


   exit when Defer_Pos148 = No_Token_Index;

   List_Pos20 := Defer_Pos148;
   Lst_Cpos20 := List_Pos20;

   Tmp_List20.Nodes.Append (Defer_Res148);

end loop;


declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List20.Nodes.Length;
begin
   List_Res20 := Allocate_Import_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Pos;
      Token_End := (if Lst_Cpos20 = Pos
                    then Pos
                    else List_Pos20 - 1);

   else
      Token_Start := Token_Index'Max (Pos, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res20,
      Kind              => Lkt_Import_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res20,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_Lkt_Node_Vectors.Vector renames
         Tmp_List20.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res20.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List20);

--  END <List (root of 'imports') at parser.lkt:12:16>


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (PP.Imports_List_Parse0_Memo,
      List_Pos20 /= No_Token_Index,
      List_Res20,
      Pos,
      List_Pos20);


   Parser.Current_Pos := List_Pos20;

   return List_Res20;
end Imports_List_Parse0;

   


function Integer_Pattern_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Integer_Pattern
is
   use Bare_Integer_Pattern_Memos;

      Row_Pos106 :
            Token_Index
               := No_Token_Index;
      Token_Pos152 :
            Token_Index
               := No_Token_Index;
      Token_Res152 :
            Token_Index
               := No_Token_Index;
      Transform_Res93 :
            Bare_Integer_Pattern
               := No_Bare_Lkt_Node;
      Transform_Diags93 :
            Ada.Containers.Count_Type;


   PP : constant Parser_Private_Part := +Parser.Private_Part;
   M  : Memo_Entry := Get (PP.Integer_Pattern_Transform_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res93 := M.Instance;
      return Transform_Res93;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res93;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  BEGIN <Transform(<ASTNodeType IntegerPattern>) (root of 'integer_pattern') at parser.lkt:280:24>

Transform_Diags93 := Parser.Diagnostics.Length;


--  BEGIN <_Row (root of 'integer_pattern') at parser.lkt:280:24>

Row_Pos106 := Pos;



--  BEGIN <Token(<WithText Number>, ) (root of 'integer_pattern') at parser.lkt:280:39>

Token_Res152 := Row_Pos106;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res152));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_Number)
   then
       Token_Pos152 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos106 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos106,
             Expected_Token_Id => Lkt_Number,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos152 := Row_Pos106 + 1;
   end if;
end;

--  END <Token(<WithText Number>, ) (root of 'integer_pattern') at parser.lkt:280:39>




if Token_Pos152 /= No_Token_Index then

   Row_Pos106 := Token_Pos152;

else
   Row_Pos106 := No_Token_Index;
   goto Exit_Row106_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row106_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'integer_pattern') at parser.lkt:280:24>



if Row_Pos106 /= No_Token_Index then

   Transform_Res93 := Allocate_Integer_Pattern (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res93,
      Kind => Lkt_Integer_Pattern,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos106 = Pos
                            then No_Token_Index
                            else Row_Pos106 - 1));




elsif Row_Pos106 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags93);
end if;

--  END <Transform(<ASTNodeType IntegerPattern>) (root of 'integer_pattern') at parser.lkt:280:24>


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (PP.Integer_Pattern_Transform_Parse0_Memo,
      Row_Pos106 /= No_Token_Index,
      Transform_Res93,
      Pos,
      Row_Pos106);


   Parser.Current_Pos := Row_Pos106;

   return Transform_Res93;
end Integer_Pattern_Transform_Parse0;

   


function Isa_Or_Primary_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr
is
   use Bare_Expr_Memos;

      Row_Pos107 :
            Token_Index
               := No_Token_Index;
      Defer_Pos149 :
            Token_Index
               := No_Token_Index;
      Defer_Res149 :
            Bare_Expr
               := No_Bare_Lkt_Node;
      Token_Pos153 :
            Token_Index
               := No_Token_Index;
      Token_Res153 :
            Token_Index
               := No_Token_Index;
      Defer_Pos150 :
            Token_Index
               := No_Token_Index;
      Defer_Res150 :
            Bare_Pattern
               := No_Bare_Lkt_Node;
      Transform_Res94 :
            Bare_Isa
               := No_Bare_Lkt_Node;
      Transform_Diags94 :
            Ada.Containers.Count_Type;
      Row_Pos108 :
            Token_Index
               := No_Token_Index;
      Defer_Pos151 :
            Token_Index
               := No_Token_Index;
      Defer_Res151 :
            Bare_Expr
               := No_Bare_Lkt_Node;
      Token_Pos154 :
            Token_Index
               := No_Token_Index;
      Token_Res154 :
            Token_Index
               := No_Token_Index;
      Lst_Cpos21 :
            Token_Index
               := No_Token_Index;
      Tmp_List21 :
            Free_Parse_List;
      Defer_Pos152 :
            Token_Index
               := No_Token_Index;
      Defer_Res152 :
            Bare_Expr
               := No_Bare_Lkt_Node;
      Token_Pos155 :
            Token_Index
               := No_Token_Index;
      Token_Res155 :
            Token_Index
               := No_Token_Index;
      List_Pos21 :
            Token_Index
               := No_Token_Index;
      List_Res21 :
            Bare_Any_Of_List
               := No_Bare_Lkt_Node;
      Transform_Res95 :
            Bare_Any_Of
               := No_Bare_Lkt_Node;
      Transform_Diags95 :
            Ada.Containers.Count_Type;
      Row_Pos109 :
            Token_Index
               := No_Token_Index;
      Defer_Pos153 :
            Token_Index
               := No_Token_Index;
      Defer_Res153 :
            Bare_Expr
               := No_Bare_Lkt_Node;
      Token_Pos156 :
            Token_Index
               := No_Token_Index;
      Token_Res156 :
            Token_Index
               := No_Token_Index;
      Defer_Pos154 :
            Token_Index
               := No_Token_Index;
      Defer_Res154 :
            Bare_Expr
               := No_Bare_Lkt_Node;
      Transform_Res96 :
            Bare_Logic_Unify
               := No_Bare_Lkt_Node;
      Transform_Diags96 :
            Ada.Containers.Count_Type;
      Row_Pos110 :
            Token_Index
               := No_Token_Index;
      Defer_Pos155 :
            Token_Index
               := No_Token_Index;
      Defer_Res155 :
            Bare_Expr
               := No_Bare_Lkt_Node;
      Token_Pos157 :
            Token_Index
               := No_Token_Index;
      Token_Res157 :
            Token_Index
               := No_Token_Index;
      Defer_Pos156 :
            Token_Index
               := No_Token_Index;
      Defer_Res156 :
            Bare_Logic_Propagate_Call
               := No_Bare_Lkt_Node;
      Transform_Res97 :
            Bare_Logic_Propagate
               := No_Bare_Lkt_Node;
      Transform_Diags97 :
            Ada.Containers.Count_Type;
      Row_Pos111 :
            Token_Index
               := No_Token_Index;
      Defer_Pos157 :
            Token_Index
               := No_Token_Index;
      Defer_Res157 :
            Bare_Expr
               := No_Bare_Lkt_Node;
      Token_Pos158 :
            Token_Index
               := No_Token_Index;
      Token_Res158 :
            Token_Index
               := No_Token_Index;
      Defer_Pos158 :
            Token_Index
               := No_Token_Index;
      Defer_Res158 :
            Bare_Expr
               := No_Bare_Lkt_Node;
      Transform_Res98 :
            Bare_Logic_Assign
               := No_Bare_Lkt_Node;
      Transform_Diags98 :
            Ada.Containers.Count_Type;
      Defer_Pos159 :
            Token_Index
               := No_Token_Index;
      Defer_Res159 :
            Bare_Expr
               := No_Bare_Lkt_Node;
      Or_Pos25 :
            Token_Index
               := No_Token_Index;
      Or_Res25 :
            Bare_Expr
               := No_Bare_Lkt_Node;

      Mem_Pos : Token_Index := Pos;
      Mem_Res : Bare_Expr := No_Bare_Lkt_Node;

   PP : constant Parser_Private_Part := +Parser.Private_Part;
   M  : Memo_Entry := Get (PP.Isa_Or_Primary_Or_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Or_Res25 := M.Instance;
      return Or_Res25;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Or_Res25;
   end if;

       Set (PP.Isa_Or_Primary_Or_Parse0_Memo, False, Or_Res25, Pos, Mem_Pos);

       <<Try_Again>>



   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  BEGIN <Or (root of 'isa_or_primary') at parser.lkt:335:23>

Or_Pos25 := No_Token_Index;
Or_Res25 := No_Bare_Lkt_Node;
    
--  BEGIN <Transform(<ASTNodeType Isa>) (root of 'isa_or_primary') at parser.lkt:336:11>

Transform_Diags94 := Parser.Diagnostics.Length;


--  BEGIN <_Row (root of 'isa_or_primary') at parser.lkt:336:11>

Row_Pos107 := Pos;



--  BEGIN <Defer (for 'primary') at parser.lkt:336:15>

Defer_Res149 :=
   Primary_Or_Parse0 (Parser, Row_Pos107);
Defer_Pos149 := Parser.Current_Pos;

--  END <Defer (for 'primary') at parser.lkt:336:15>




if Defer_Pos149 /= No_Token_Index then

   Row_Pos107 := Defer_Pos149;

else
   Row_Pos107 := No_Token_Index;
   goto Exit_Row107_0;

end if;


--  BEGIN <Token(<WithText IsKw>, ) (root of 'isa_or_primary') at parser.lkt:336:23>

Token_Res153 := Row_Pos107;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res153));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_Is_Kw)
   then
       Token_Pos153 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos107 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos107,
             Expected_Token_Id => Lkt_Is_Kw,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos153 := Row_Pos107 + 1;
   end if;
end;

--  END <Token(<WithText IsKw>, ) (root of 'isa_or_primary') at parser.lkt:336:23>




if Token_Pos153 /= No_Token_Index then

   Row_Pos107 := Token_Pos153;

else
   Row_Pos107 := No_Token_Index;
   goto Exit_Row107_0;

end if;


--  BEGIN <Defer (for 'pattern') at parser.lkt:336:28>

Defer_Res150 :=
   Pattern_Or_Parse0 (Parser, Row_Pos107);
Defer_Pos150 := Parser.Current_Pos;

--  END <Defer (for 'pattern') at parser.lkt:336:28>




if Defer_Pos150 /= No_Token_Index then

   Row_Pos107 := Defer_Pos150;

else
   Row_Pos107 := No_Token_Index;
   goto Exit_Row107_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row107_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'isa_or_primary') at parser.lkt:336:11>



if Row_Pos107 /= No_Token_Index then

   Transform_Res94 := Allocate_Isa (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res94,
      Kind => Lkt_Isa,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos107 = Pos
                            then No_Token_Index
                            else Row_Pos107 - 1));

      
      Initialize_Fields_For_Isa
        (Self => Transform_Res94,
         Isa_F_Expr => Defer_Res149,
         Isa_F_Pattern => Defer_Res150);

         if Defer_Res149 /= null and then Is_Incomplete (Defer_Res149) then
            Transform_Res94.Last_Attempted_Child := 0;
         elsif Defer_Res149 /= null and then not Is_Ghost (Defer_Res149) then
            Transform_Res94.Last_Attempted_Child := -1;
         end if;
         if Defer_Res150 /= null and then Is_Incomplete (Defer_Res150) then
            Transform_Res94.Last_Attempted_Child := 0;
         elsif Defer_Res150 /= null and then not Is_Ghost (Defer_Res150) then
            Transform_Res94.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos107 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags94);
end if;

--  END <Transform(<ASTNodeType Isa>) (root of 'isa_or_primary') at parser.lkt:336:11>

    if Row_Pos107 /= No_Token_Index then
        Or_Pos25 := Row_Pos107;
        Or_Res25 := Transform_Res94;
        goto Exit_Or26;
    end if;
    
--  BEGIN <Transform(<ASTNodeType AnyOf>) (root of 'isa_or_primary') at parser.lkt:337:11>

Transform_Diags95 := Parser.Diagnostics.Length;


--  BEGIN <_Row (root of 'isa_or_primary') at parser.lkt:337:11>

Row_Pos108 := Pos;



--  BEGIN <Defer (for 'primary') at parser.lkt:337:17>

Defer_Res151 :=
   Primary_Or_Parse0 (Parser, Row_Pos108);
Defer_Pos151 := Parser.Current_Pos;

--  END <Defer (for 'primary') at parser.lkt:337:17>




if Defer_Pos151 /= No_Token_Index then

   Row_Pos108 := Defer_Pos151;

else
   Row_Pos108 := No_Token_Index;
   goto Exit_Row108_0;

end if;


--  BEGIN <Token(<WithText InKw>, ) (root of 'isa_or_primary') at parser.lkt:337:25>

Token_Res154 := Row_Pos108;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res154));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_In_Kw)
   then
       Token_Pos154 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos108 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos108,
             Expected_Token_Id => Lkt_In_Kw,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos154 := Row_Pos108 + 1;
   end if;
end;

--  END <Token(<WithText InKw>, ) (root of 'isa_or_primary') at parser.lkt:337:25>




if Token_Pos154 /= No_Token_Index then

   Row_Pos108 := Token_Pos154;

else
   Row_Pos108 := No_Token_Index;
   goto Exit_Row108_0;

end if;


--  BEGIN <List (root of 'isa_or_primary') at parser.lkt:337:30>

    List_Pos21 := No_Token_Index;



Lst_Cpos21 := Row_Pos108;
Tmp_List21 := Get_Parse_List (Parser);


loop
   
--  BEGIN <Defer (for 'primary') at parser.lkt:337:41>

Defer_Res152 :=
   Primary_Or_Parse0 (Parser, Lst_Cpos21);
Defer_Pos152 := Parser.Current_Pos;

--  END <Defer (for 'primary') at parser.lkt:337:41>


   exit when Defer_Pos152 = No_Token_Index;

   List_Pos21 := Defer_Pos152;
   Lst_Cpos21 := List_Pos21;

   Tmp_List21.Nodes.Append (Defer_Res152);

      
--  BEGIN <Token(<WithText Pipe>, ) (root of 'isa_or_primary') at parser.lkt:337:50>

Token_Res155 := Lst_Cpos21;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res155));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_Pipe)
   then
       Token_Pos155 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Lst_Cpos21 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Lst_Cpos21,
             Expected_Token_Id => Lkt_Pipe,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos155 := Lst_Cpos21 + 1;
   end if;
end;

--  END <Token(<WithText Pipe>, ) (root of 'isa_or_primary') at parser.lkt:337:50>


      exit when Token_Pos155 = No_Token_Index;

      Lst_Cpos21 := Token_Pos155;

end loop;


declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List21.Nodes.Length;
begin
   List_Res21 := Allocate_Any_Of_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Row_Pos108;
      Token_End := (if Lst_Cpos21 = Row_Pos108
                    then Row_Pos108
                    else List_Pos21 - 1);

   else
      Token_Start := Token_Index'Max (Row_Pos108, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res21,
      Kind              => Lkt_Any_Of_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res21,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_Lkt_Node_Vectors.Vector renames
         Tmp_List21.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res21.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List21);

--  END <List (root of 'isa_or_primary') at parser.lkt:337:30>




if List_Pos21 /= No_Token_Index then

   Row_Pos108 := List_Pos21;

else
   Row_Pos108 := No_Token_Index;
   goto Exit_Row108_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row108_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'isa_or_primary') at parser.lkt:337:11>



if Row_Pos108 /= No_Token_Index then

   Transform_Res95 := Allocate_Any_Of (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res95,
      Kind => Lkt_Any_Of,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos108 = Pos
                            then No_Token_Index
                            else Row_Pos108 - 1));

      
      Initialize_Fields_For_Any_Of
        (Self => Transform_Res95,
         Any_Of_F_Expr => Defer_Res151,
         Any_Of_F_Values => List_Res21);

         if Defer_Res151 /= null and then Is_Incomplete (Defer_Res151) then
            Transform_Res95.Last_Attempted_Child := 0;
         elsif Defer_Res151 /= null and then not Is_Ghost (Defer_Res151) then
            Transform_Res95.Last_Attempted_Child := -1;
         end if;
         if List_Res21 /= null and then Is_Incomplete (List_Res21) then
            Transform_Res95.Last_Attempted_Child := 0;
         elsif List_Res21 /= null and then not Is_Ghost (List_Res21) then
            Transform_Res95.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos108 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags95);
end if;

--  END <Transform(<ASTNodeType AnyOf>) (root of 'isa_or_primary') at parser.lkt:337:11>

    if Row_Pos108 /= No_Token_Index then
        Or_Pos25 := Row_Pos108;
        Or_Res25 := Transform_Res95;
        goto Exit_Or26;
    end if;
    
--  BEGIN <Transform(<ASTNodeType LogicUnify>) (root of 'isa_or_primary') at parser.lkt:338:11>

Transform_Diags96 := Parser.Diagnostics.Length;


--  BEGIN <_Row (root of 'isa_or_primary') at parser.lkt:338:11>

Row_Pos109 := Pos;



--  BEGIN <Defer (for 'isa_or_primary') at parser.lkt:338:22>

Defer_Res153 :=
   Isa_Or_Primary_Or_Parse0 (Parser, Row_Pos109);
Defer_Pos153 := Parser.Current_Pos;

--  END <Defer (for 'isa_or_primary') at parser.lkt:338:22>




if Defer_Pos153 /= No_Token_Index then

   Row_Pos109 := Defer_Pos153;

else
   Row_Pos109 := No_Token_Index;
   goto Exit_Row109_0;

end if;


--  BEGIN <Token(<WithText TwoSidedArrow>, ) (root of 'isa_or_primary') at parser.lkt:338:37>

Token_Res156 := Row_Pos109;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res156));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_Two_Sided_Arrow)
   then
       Token_Pos156 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos109 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos109,
             Expected_Token_Id => Lkt_Two_Sided_Arrow,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos156 := Row_Pos109 + 1;
   end if;
end;

--  END <Token(<WithText TwoSidedArrow>, ) (root of 'isa_or_primary') at parser.lkt:338:37>




if Token_Pos156 /= No_Token_Index then

   Row_Pos109 := Token_Pos156;

else
   Row_Pos109 := No_Token_Index;
   goto Exit_Row109_0;

end if;


--  BEGIN <Defer (for 'primary') at parser.lkt:338:43>

Defer_Res154 :=
   Primary_Or_Parse0 (Parser, Row_Pos109);
Defer_Pos154 := Parser.Current_Pos;

--  END <Defer (for 'primary') at parser.lkt:338:43>




if Defer_Pos154 /= No_Token_Index then

   Row_Pos109 := Defer_Pos154;

else
   Row_Pos109 := No_Token_Index;
   goto Exit_Row109_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row109_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'isa_or_primary') at parser.lkt:338:11>



if Row_Pos109 /= No_Token_Index then

   Transform_Res96 := Allocate_Logic_Unify (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res96,
      Kind => Lkt_Logic_Unify,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos109 = Pos
                            then No_Token_Index
                            else Row_Pos109 - 1));

      
      Initialize_Fields_For_Logic_Unify
        (Self => Transform_Res96,
         Logic_Unify_F_Lhs => Defer_Res153,
         Logic_Unify_F_Rhs => Defer_Res154);

         if Defer_Res153 /= null and then Is_Incomplete (Defer_Res153) then
            Transform_Res96.Last_Attempted_Child := 0;
         elsif Defer_Res153 /= null and then not Is_Ghost (Defer_Res153) then
            Transform_Res96.Last_Attempted_Child := -1;
         end if;
         if Defer_Res154 /= null and then Is_Incomplete (Defer_Res154) then
            Transform_Res96.Last_Attempted_Child := 0;
         elsif Defer_Res154 /= null and then not Is_Ghost (Defer_Res154) then
            Transform_Res96.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos109 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags96);
end if;

--  END <Transform(<ASTNodeType LogicUnify>) (root of 'isa_or_primary') at parser.lkt:338:11>

    if Row_Pos109 /= No_Token_Index then
        Or_Pos25 := Row_Pos109;
        Or_Res25 := Transform_Res96;
        goto Exit_Or26;
    end if;
    
--  BEGIN <Transform(<ASTNodeType LogicPropagate>) (root of 'isa_or_primary') at parser.lkt:339:11>

Transform_Diags97 := Parser.Diagnostics.Length;


--  BEGIN <_Row (root of 'isa_or_primary') at parser.lkt:339:11>

Row_Pos110 := Pos;



--  BEGIN <Defer (for 'isa_or_primary') at parser.lkt:339:26>

Defer_Res155 :=
   Isa_Or_Primary_Or_Parse0 (Parser, Row_Pos110);
Defer_Pos155 := Parser.Current_Pos;

--  END <Defer (for 'isa_or_primary') at parser.lkt:339:26>




if Defer_Pos155 /= No_Token_Index then

   Row_Pos110 := Defer_Pos155;

else
   Row_Pos110 := No_Token_Index;
   goto Exit_Row110_0;

end if;


--  BEGIN <Token(<WithText LeftArrow>, ) (root of 'isa_or_primary') at parser.lkt:339:41>

Token_Res157 := Row_Pos110;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res157));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_Left_Arrow)
   then
       Token_Pos157 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos110 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos110,
             Expected_Token_Id => Lkt_Left_Arrow,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos157 := Row_Pos110 + 1;
   end if;
end;

--  END <Token(<WithText LeftArrow>, ) (root of 'isa_or_primary') at parser.lkt:339:41>




if Token_Pos157 /= No_Token_Index then

   Row_Pos110 := Token_Pos157;

else
   Row_Pos110 := No_Token_Index;
   goto Exit_Row110_0;

end if;


--  BEGIN <Defer (for 'logic_propagate_call') at parser.lkt:339:46>

Defer_Res156 :=
   Logic_Propagate_Call_Transform_Parse0 (Parser, Row_Pos110);
Defer_Pos156 := Parser.Current_Pos;

--  END <Defer (for 'logic_propagate_call') at parser.lkt:339:46>




if Defer_Pos156 /= No_Token_Index then

   Row_Pos110 := Defer_Pos156;

else
   Row_Pos110 := No_Token_Index;
   goto Exit_Row110_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row110_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'isa_or_primary') at parser.lkt:339:11>



if Row_Pos110 /= No_Token_Index then

   Transform_Res97 := Allocate_Logic_Propagate (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res97,
      Kind => Lkt_Logic_Propagate,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos110 = Pos
                            then No_Token_Index
                            else Row_Pos110 - 1));

      
      Initialize_Fields_For_Logic_Propagate
        (Self => Transform_Res97,
         Logic_Propagate_F_Dest_Var => Defer_Res155,
         Logic_Propagate_F_Call => Defer_Res156);

         if Defer_Res155 /= null and then Is_Incomplete (Defer_Res155) then
            Transform_Res97.Last_Attempted_Child := 0;
         elsif Defer_Res155 /= null and then not Is_Ghost (Defer_Res155) then
            Transform_Res97.Last_Attempted_Child := -1;
         end if;
         if Defer_Res156 /= null and then Is_Incomplete (Defer_Res156) then
            Transform_Res97.Last_Attempted_Child := 0;
         elsif Defer_Res156 /= null and then not Is_Ghost (Defer_Res156) then
            Transform_Res97.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos110 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags97);
end if;

--  END <Transform(<ASTNodeType LogicPropagate>) (root of 'isa_or_primary') at parser.lkt:339:11>

    if Row_Pos110 /= No_Token_Index then
        Or_Pos25 := Row_Pos110;
        Or_Res25 := Transform_Res97;
        goto Exit_Or26;
    end if;
    
--  BEGIN <Transform(<ASTNodeType LogicAssign>) (root of 'isa_or_primary') at parser.lkt:340:11>

Transform_Diags98 := Parser.Diagnostics.Length;


--  BEGIN <_Row (root of 'isa_or_primary') at parser.lkt:340:11>

Row_Pos111 := Pos;



--  BEGIN <Defer (for 'isa_or_primary') at parser.lkt:340:23>

Defer_Res157 :=
   Isa_Or_Primary_Or_Parse0 (Parser, Row_Pos111);
Defer_Pos157 := Parser.Current_Pos;

--  END <Defer (for 'isa_or_primary') at parser.lkt:340:23>




if Defer_Pos157 /= No_Token_Index then

   Row_Pos111 := Defer_Pos157;

else
   Row_Pos111 := No_Token_Index;
   goto Exit_Row111_0;

end if;


--  BEGIN <Token(<WithText LeftArrow>, ) (root of 'isa_or_primary') at parser.lkt:340:38>

Token_Res158 := Row_Pos111;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res158));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_Left_Arrow)
   then
       Token_Pos158 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos111 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos111,
             Expected_Token_Id => Lkt_Left_Arrow,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos158 := Row_Pos111 + 1;
   end if;
end;

--  END <Token(<WithText LeftArrow>, ) (root of 'isa_or_primary') at parser.lkt:340:38>




if Token_Pos158 /= No_Token_Index then

   Row_Pos111 := Token_Pos158;

else
   Row_Pos111 := No_Token_Index;
   goto Exit_Row111_0;

end if;


--  BEGIN <Defer (for 'primary') at parser.lkt:340:43>

Defer_Res158 :=
   Primary_Or_Parse0 (Parser, Row_Pos111);
Defer_Pos158 := Parser.Current_Pos;

--  END <Defer (for 'primary') at parser.lkt:340:43>




if Defer_Pos158 /= No_Token_Index then

   Row_Pos111 := Defer_Pos158;

else
   Row_Pos111 := No_Token_Index;
   goto Exit_Row111_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row111_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'isa_or_primary') at parser.lkt:340:11>



if Row_Pos111 /= No_Token_Index then

   Transform_Res98 := Allocate_Logic_Assign (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res98,
      Kind => Lkt_Logic_Assign,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos111 = Pos
                            then No_Token_Index
                            else Row_Pos111 - 1));

      
      Initialize_Fields_For_Logic_Assign
        (Self => Transform_Res98,
         Logic_Assign_F_Dest_Var => Defer_Res157,
         Logic_Assign_F_Value => Defer_Res158);

         if Defer_Res157 /= null and then Is_Incomplete (Defer_Res157) then
            Transform_Res98.Last_Attempted_Child := 0;
         elsif Defer_Res157 /= null and then not Is_Ghost (Defer_Res157) then
            Transform_Res98.Last_Attempted_Child := -1;
         end if;
         if Defer_Res158 /= null and then Is_Incomplete (Defer_Res158) then
            Transform_Res98.Last_Attempted_Child := 0;
         elsif Defer_Res158 /= null and then not Is_Ghost (Defer_Res158) then
            Transform_Res98.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos111 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags98);
end if;

--  END <Transform(<ASTNodeType LogicAssign>) (root of 'isa_or_primary') at parser.lkt:340:11>

    if Row_Pos111 /= No_Token_Index then
        Or_Pos25 := Row_Pos111;
        Or_Res25 := Transform_Res98;
        goto Exit_Or26;
    end if;
    
--  BEGIN <Defer (for 'primary') at parser.lkt:341:11>

Defer_Res159 :=
   Primary_Or_Parse0 (Parser, Pos);
Defer_Pos159 := Parser.Current_Pos;

--  END <Defer (for 'primary') at parser.lkt:341:11>

    if Defer_Pos159 /= No_Token_Index then
        Or_Pos25 := Defer_Pos159;
        Or_Res25 := Defer_Res159;
        goto Exit_Or26;
    end if;
<<Exit_Or26>>

--  END <Or (root of 'isa_or_primary') at parser.lkt:335:23>


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------

      if Or_Pos25 > Mem_Pos then
         Mem_Pos := Or_Pos25;
         Mem_Res := Or_Res25;
         Set
           (PP.Isa_Or_Primary_Or_Parse0_Memo,
            Or_Pos25 /= No_Token_Index,
            Or_Res25,
            Pos,
            Or_Pos25);
         goto Try_Again;

      elsif Mem_Pos > Pos then
         Or_Res25 := Mem_Res;
         Or_Pos25 := Mem_Pos;
         goto No_Memo;
      end if;

   Set
     (PP.Isa_Or_Primary_Or_Parse0_Memo,
      Or_Pos25 /= No_Token_Index,
      Or_Res25,
      Pos,
      Or_Pos25);

       <<No_Memo>>

   Parser.Current_Pos := Or_Pos25;

   return Or_Res25;
end Isa_Or_Primary_Or_Parse0;

   


function Lambda_Expr_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Lambda_Expr
is
   use Bare_Lambda_Expr_Memos;

      Nobt3 :
            Boolean
               := False;
      Row_Pos112 :
            Token_Index
               := No_Token_Index;
      Token_Pos159 :
            Token_Index
               := No_Token_Index;
      Token_Res159 :
            Token_Index
               := No_Token_Index;
      Defer_Pos160 :
            Token_Index
               := No_Token_Index;
      Defer_Res160 :
            Bare_Lambda_Param_Decl_List
               := No_Bare_Lkt_Node;
      Token_Pos160 :
            Token_Index
               := No_Token_Index;
      Token_Res160 :
            Token_Index
               := No_Token_Index;
      Row_Pos113 :
            Token_Index
               := No_Token_Index;
      Token_Pos161 :
            Token_Index
               := No_Token_Index;
      Token_Res161 :
            Token_Index
               := No_Token_Index;
      Defer_Pos161 :
            Token_Index
               := No_Token_Index;
      Defer_Res161 :
            Bare_Type_Ref
               := No_Bare_Lkt_Node;
      Token_Pos162 :
            Token_Index
               := No_Token_Index;
      Token_Res162 :
            Token_Index
               := No_Token_Index;
      Defer_Pos162 :
            Token_Index
               := No_Token_Index;
      Defer_Res162 :
            Bare_Expr
               := No_Bare_Lkt_Node;
      Row_Progress3 :
            Integer
               := 0;
      Transform_Res99 :
            Bare_Lambda_Expr
               := No_Bare_Lkt_Node;
      Transform_Has_Failed3 :
            Boolean
               := False;
      Transform_Diags99 :
            Ada.Containers.Count_Type;


   PP : constant Parser_Private_Part := +Parser.Private_Part;
   M  : Memo_Entry := Get (PP.Lambda_Expr_Transform_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res99 := M.Instance;
      return Transform_Res99;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res99;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  BEGIN <Transform(<ASTNodeType LambdaExpr>) (root of 'lambda_expr') at parser.lkt:423:20>

Transform_Diags99 := Parser.Diagnostics.Length;


--  BEGIN <_Row (root of 'lambda_expr') at parser.lkt:423:20>

Row_Pos112 := Pos;



--  BEGIN <Token(<WithText LPar>, ) (root of 'lambda_expr') at parser.lkt:424:9>

Token_Res159 := Row_Pos112;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res159));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_L_Par)
   then
       Token_Pos159 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos112 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos112,
             Expected_Token_Id => Lkt_L_Par,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos159 := Row_Pos112 + 1;
   end if;
end;

--  END <Token(<WithText LPar>, ) (root of 'lambda_expr') at parser.lkt:424:9>



Row_Progress3 := 1;

if Token_Pos159 /= No_Token_Index then

   Row_Pos112 := Token_Pos159;

else
   Row_Pos112 := No_Token_Index;
   goto Exit_Row112_0;

end if;


--  BEGIN <Defer (for 'lambda_param_list') at parser.lkt:424:13>

Defer_Res160 :=
   Lambda_Param_List_List_Parse0 (Parser, Row_Pos112);
Defer_Pos160 := Parser.Current_Pos;

--  END <Defer (for 'lambda_param_list') at parser.lkt:424:13>



Row_Progress3 := 2;

if Defer_Pos160 /= No_Token_Index then

   Row_Pos112 := Defer_Pos160;

else
   Row_Pos112 := No_Token_Index;
   goto Exit_Row112_0;

end if;


--  BEGIN <Token(<WithText RPar>, ) (root of 'lambda_expr') at parser.lkt:424:31>

Token_Res160 := Row_Pos112;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res160));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_R_Par)
   then
       Token_Pos160 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos112 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos112,
             Expected_Token_Id => Lkt_R_Par,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos160 := Row_Pos112 + 1;
   end if;
end;

--  END <Token(<WithText RPar>, ) (root of 'lambda_expr') at parser.lkt:424:31>



Row_Progress3 := 3;

if Token_Pos160 /= No_Token_Index then

   Row_Pos112 := Token_Pos160;

else
   Row_Pos112 := No_Token_Index;
   goto Exit_Row112_0;

end if;


--  BEGIN <Opt (root of 'lambda_expr') at parser.lkt:424:35>












--  BEGIN <_Extract (root of 'lambda_expr') at parser.lkt:424:36>

--  BEGIN <_Row (root of 'lambda_expr') at parser.lkt:424:36>

Row_Pos113 := Row_Pos112;



--  BEGIN <Token(<WithText Colon>, ) (root of 'lambda_expr') at parser.lkt:424:41>

Token_Res161 := Row_Pos113;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res161));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_Colon)
   then
       Token_Pos161 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos113 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos113,
             Expected_Token_Id => Lkt_Colon,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos161 := Row_Pos113 + 1;
   end if;
end;

--  END <Token(<WithText Colon>, ) (root of 'lambda_expr') at parser.lkt:424:41>




if Token_Pos161 /= No_Token_Index then

   Row_Pos113 := Token_Pos161;

else
   Row_Pos113 := No_Token_Index;
   goto Exit_Row113_0;

end if;


--  BEGIN <Defer (for 'type_ref') at parser.lkt:424:45>

Defer_Res161 :=
   Type_Ref_Or_Parse0 (Parser, Row_Pos113);
Defer_Pos161 := Parser.Current_Pos;

--  END <Defer (for 'type_ref') at parser.lkt:424:45>




if Defer_Pos161 /= No_Token_Index then

   Row_Pos113 := Defer_Pos161;

else
   Row_Pos113 := No_Token_Index;
   goto Exit_Row113_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row113_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'lambda_expr') at parser.lkt:424:36>

--  END <_Extract (root of 'lambda_expr') at parser.lkt:424:36>


if Row_Pos113 = No_Token_Index then

         
   Defer_Res161 := No_Bare_Lkt_Node;



       
   Row_Pos113 := Row_Pos112;



end if;

--  END <Opt (root of 'lambda_expr') at parser.lkt:424:35>



Row_Progress3 := 4;

if Row_Pos113 /= No_Token_Index then

   Row_Pos112 := Row_Pos113;

else
   Row_Pos112 := No_Token_Index;
   goto Exit_Row112_0;

end if;


--  BEGIN <Token(<WithText FatRightArrow>, ) (root of 'lambda_expr') at parser.lkt:424:55>

Token_Res162 := Row_Pos112;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res162));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_Fat_Right_Arrow)
   then
       Token_Pos162 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos112 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos112,
             Expected_Token_Id => Lkt_Fat_Right_Arrow,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos162 := Row_Pos112 + 1;
   end if;
end;

--  END <Token(<WithText FatRightArrow>, ) (root of 'lambda_expr') at parser.lkt:424:55>



Row_Progress3 := 5;

if Token_Pos162 /= No_Token_Index then

   Row_Pos112 := Token_Pos162;

else
   Row_Pos112 := No_Token_Index;
   goto Exit_Row112_0;

end if;


--  BEGIN <Cut (root of 'lambda_expr') at parser.lkt:424:60>
Nobt3 := True;
--  END <Cut (root of 'lambda_expr') at parser.lkt:424:60>


   Nobt3 := Nobt3;

Row_Progress3 := 6;

if Row_Pos112 /= No_Token_Index then

   Row_Pos112 := Row_Pos112;

else
   Row_Pos112 := No_Token_Index;
   goto Exit_Row112_0;

end if;


--  BEGIN <Defer (for 'expr') at parser.lkt:424:62>

Defer_Res162 :=
   Expr_Or_Parse1 (Parser, Row_Pos112);
Defer_Pos162 := Parser.Current_Pos;

--  END <Defer (for 'expr') at parser.lkt:424:62>



Row_Progress3 := 7;

if Defer_Pos162 /= No_Token_Index then

   Row_Pos112 := Defer_Pos162;

else
   Row_Pos112 := No_Token_Index;
   goto Exit_Row112_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row112_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'lambda_expr') at parser.lkt:423:20>


if Row_Pos112 = No_Token_Index and then Nobt3 then

   Row_Pos112 := Parser.Last_Fail.Pos;

   Transform_Has_Failed3 := True;
end if;

if Row_Pos112 /= No_Token_Index then

   Transform_Res99 := Allocate_Lambda_Expr (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res99,
      Kind => Lkt_Lambda_Expr,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos112 = Pos
                            then No_Token_Index
                            else Row_Pos112 - 1));

      
      Initialize_Fields_For_Lambda_Expr
        (Self => Transform_Res99,
         Lambda_Expr_F_Params => Defer_Res160,
         Lambda_Expr_F_Return_Type => Defer_Res161,
         Lambda_Expr_F_Body => Defer_Res162);

         if Defer_Res160 /= null and then Is_Incomplete (Defer_Res160) then
            Transform_Res99.Last_Attempted_Child := 0;
         elsif Defer_Res160 /= null and then not Is_Ghost (Defer_Res160) then
            Transform_Res99.Last_Attempted_Child := -1;
         end if;
         if Defer_Res161 /= null and then Is_Incomplete (Defer_Res161) then
            Transform_Res99.Last_Attempted_Child := 0;
         elsif Defer_Res161 /= null and then not Is_Ghost (Defer_Res161) then
            Transform_Res99.Last_Attempted_Child := -1;
         end if;
         if Defer_Res162 /= null and then Is_Incomplete (Defer_Res162) then
            Transform_Res99.Last_Attempted_Child := 0;
         elsif Defer_Res162 /= null and then not Is_Ghost (Defer_Res162) then
            Transform_Res99.Last_Attempted_Child := -1;
         end if;

   if Transform_Has_Failed3 then
      Transform_Res99.Last_Attempted_Child :=
         Row_Progress3;

      Append (Parser.Diagnostics,
              Sloc_Range (Parser.TDH.all,
                          Get_Token (Parser.TDH.all, Pos)),
              To_Text ("Cannot parse <lambda_expr>"));

      Add_Last_Fail_Diagnostic (Parser);
   end if;

elsif Row_Pos112 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags99);
end if;

--  END <Transform(<ASTNodeType LambdaExpr>) (root of 'lambda_expr') at parser.lkt:423:20>


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (PP.Lambda_Expr_Transform_Parse0_Memo,
      Row_Pos112 /= No_Token_Index,
      Transform_Res99,
      Pos,
      Row_Pos112);


   Parser.Current_Pos := Row_Pos112;

   return Transform_Res99;
end Lambda_Expr_Transform_Parse0;

   


function Lambda_Param_Decl_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Lambda_Param_Decl
is
   use Bare_Lambda_Param_Decl_Memos;

      Row_Pos114 :
            Token_Index
               := No_Token_Index;
      Defer_Pos163 :
            Token_Index
               := No_Token_Index;
      Defer_Res163 :
            Bare_Def_Id
               := No_Bare_Lkt_Node;
      Row_Pos115 :
            Token_Index
               := No_Token_Index;
      Token_Pos163 :
            Token_Index
               := No_Token_Index;
      Token_Res163 :
            Token_Index
               := No_Token_Index;
      Defer_Pos164 :
            Token_Index
               := No_Token_Index;
      Defer_Res164 :
            Bare_Type_Ref
               := No_Bare_Lkt_Node;
      Row_Pos116 :
            Token_Index
               := No_Token_Index;
      Token_Pos164 :
            Token_Index
               := No_Token_Index;
      Token_Res164 :
            Token_Index
               := No_Token_Index;
      Defer_Pos165 :
            Token_Index
               := No_Token_Index;
      Defer_Res165 :
            Bare_Expr
               := No_Bare_Lkt_Node;
      Transform_Res100 :
            Bare_Lambda_Param_Decl
               := No_Bare_Lkt_Node;
      Transform_Diags100 :
            Ada.Containers.Count_Type;


   PP : constant Parser_Private_Part := +Parser.Private_Part;
   M  : Memo_Entry := Get (PP.Lambda_Param_Decl_Transform_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res100 := M.Instance;
      return Transform_Res100;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res100;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  BEGIN <Transform(<ASTNodeType LambdaParamDecl>) (root of 'lambda_param_decl') at parser.lkt:185:26>

Transform_Diags100 := Parser.Diagnostics.Length;


--  BEGIN <_Row (root of 'lambda_param_decl') at parser.lkt:185:26>

Row_Pos114 := Pos;



--  BEGIN <Defer (for 'def_id') at parser.lkt:186:9>

Defer_Res163 :=
   Def_Id_Transform_Parse0 (Parser, Row_Pos114);
Defer_Pos163 := Parser.Current_Pos;

--  END <Defer (for 'def_id') at parser.lkt:186:9>




if Defer_Pos163 /= No_Token_Index then

   Row_Pos114 := Defer_Pos163;

else
   Row_Pos114 := No_Token_Index;
   goto Exit_Row114_0;

end if;


--  BEGIN <Opt (root of 'lambda_param_decl') at parser.lkt:186:16>












--  BEGIN <_Extract (root of 'lambda_param_decl') at parser.lkt:186:17>

--  BEGIN <_Row (root of 'lambda_param_decl') at parser.lkt:186:17>

Row_Pos115 := Row_Pos114;



--  BEGIN <Token(<WithText Colon>, ) (root of 'lambda_param_decl') at parser.lkt:186:22>

Token_Res163 := Row_Pos115;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res163));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_Colon)
   then
       Token_Pos163 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos115 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos115,
             Expected_Token_Id => Lkt_Colon,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos163 := Row_Pos115 + 1;
   end if;
end;

--  END <Token(<WithText Colon>, ) (root of 'lambda_param_decl') at parser.lkt:186:22>




if Token_Pos163 /= No_Token_Index then

   Row_Pos115 := Token_Pos163;

else
   Row_Pos115 := No_Token_Index;
   goto Exit_Row115_0;

end if;


--  BEGIN <Defer (for 'type_ref') at parser.lkt:186:26>

Defer_Res164 :=
   Type_Ref_Or_Parse0 (Parser, Row_Pos115);
Defer_Pos164 := Parser.Current_Pos;

--  END <Defer (for 'type_ref') at parser.lkt:186:26>




if Defer_Pos164 /= No_Token_Index then

   Row_Pos115 := Defer_Pos164;

else
   Row_Pos115 := No_Token_Index;
   goto Exit_Row115_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row115_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'lambda_param_decl') at parser.lkt:186:17>

--  END <_Extract (root of 'lambda_param_decl') at parser.lkt:186:17>


if Row_Pos115 = No_Token_Index then

         
   Defer_Res164 := No_Bare_Lkt_Node;



       
   Row_Pos115 := Row_Pos114;



end if;

--  END <Opt (root of 'lambda_param_decl') at parser.lkt:186:16>




if Row_Pos115 /= No_Token_Index then

   Row_Pos114 := Row_Pos115;

else
   Row_Pos114 := No_Token_Index;
   goto Exit_Row114_0;

end if;


--  BEGIN <Opt (root of 'lambda_param_decl') at parser.lkt:186:36>












--  BEGIN <_Extract (root of 'lambda_param_decl') at parser.lkt:186:37>

--  BEGIN <_Row (root of 'lambda_param_decl') at parser.lkt:186:37>

Row_Pos116 := Row_Pos114;



--  BEGIN <Token(<WithText Equal>, ) (root of 'lambda_param_decl') at parser.lkt:186:42>

Token_Res164 := Row_Pos116;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res164));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_Equal)
   then
       Token_Pos164 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos116 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos116,
             Expected_Token_Id => Lkt_Equal,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos164 := Row_Pos116 + 1;
   end if;
end;

--  END <Token(<WithText Equal>, ) (root of 'lambda_param_decl') at parser.lkt:186:42>




if Token_Pos164 /= No_Token_Index then

   Row_Pos116 := Token_Pos164;

else
   Row_Pos116 := No_Token_Index;
   goto Exit_Row116_0;

end if;


--  BEGIN <Defer (for 'expr') at parser.lkt:186:46>

Defer_Res165 :=
   Expr_Or_Parse1 (Parser, Row_Pos116);
Defer_Pos165 := Parser.Current_Pos;

--  END <Defer (for 'expr') at parser.lkt:186:46>




if Defer_Pos165 /= No_Token_Index then

   Row_Pos116 := Defer_Pos165;

else
   Row_Pos116 := No_Token_Index;
   goto Exit_Row116_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row116_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'lambda_param_decl') at parser.lkt:186:37>

--  END <_Extract (root of 'lambda_param_decl') at parser.lkt:186:37>


if Row_Pos116 = No_Token_Index then

         
   Defer_Res165 := No_Bare_Lkt_Node;



       
   Row_Pos116 := Row_Pos114;



end if;

--  END <Opt (root of 'lambda_param_decl') at parser.lkt:186:36>




if Row_Pos116 /= No_Token_Index then

   Row_Pos114 := Row_Pos116;

else
   Row_Pos114 := No_Token_Index;
   goto Exit_Row114_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row114_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'lambda_param_decl') at parser.lkt:185:26>



if Row_Pos114 /= No_Token_Index then

   Transform_Res100 := Allocate_Lambda_Param_Decl (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res100,
      Kind => Lkt_Lambda_Param_Decl,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos114 = Pos
                            then No_Token_Index
                            else Row_Pos114 - 1));

      
      Initialize_Fields_For_Lambda_Param_Decl
        (Self => Transform_Res100,
         Lambda_Param_Decl_F_Syn_Name => Defer_Res163,
         Lambda_Param_Decl_F_Decl_Type => Defer_Res164,
         Lambda_Param_Decl_F_Default_Val => Defer_Res165);

         if Defer_Res163 /= null and then Is_Incomplete (Defer_Res163) then
            Transform_Res100.Last_Attempted_Child := 0;
         elsif Defer_Res163 /= null and then not Is_Ghost (Defer_Res163) then
            Transform_Res100.Last_Attempted_Child := -1;
         end if;
         if Defer_Res164 /= null and then Is_Incomplete (Defer_Res164) then
            Transform_Res100.Last_Attempted_Child := 0;
         elsif Defer_Res164 /= null and then not Is_Ghost (Defer_Res164) then
            Transform_Res100.Last_Attempted_Child := -1;
         end if;
         if Defer_Res165 /= null and then Is_Incomplete (Defer_Res165) then
            Transform_Res100.Last_Attempted_Child := 0;
         elsif Defer_Res165 /= null and then not Is_Ghost (Defer_Res165) then
            Transform_Res100.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos114 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags100);
end if;

--  END <Transform(<ASTNodeType LambdaParamDecl>) (root of 'lambda_param_decl') at parser.lkt:185:26>


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (PP.Lambda_Param_Decl_Transform_Parse0_Memo,
      Row_Pos114 /= No_Token_Index,
      Transform_Res100,
      Pos,
      Row_Pos114);


   Parser.Current_Pos := Row_Pos114;

   return Transform_Res100;
end Lambda_Param_Decl_Transform_Parse0;

   


function Lambda_Param_List_List_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Lambda_Param_Decl_List
is
   use Bare_Lambda_Param_Decl_List_Memos;

      Lst_Cpos22 :
            Token_Index
               := No_Token_Index;
      Tmp_List22 :
            Free_Parse_List;
      Defer_Pos166 :
            Token_Index
               := No_Token_Index;
      Defer_Res166 :
            Bare_Lambda_Param_Decl
               := No_Bare_Lkt_Node;
      Token_Pos165 :
            Token_Index
               := No_Token_Index;
      Token_Res165 :
            Token_Index
               := No_Token_Index;
      List_Pos22 :
            Token_Index
               := No_Token_Index;
      List_Res22 :
            Bare_Lambda_Param_Decl_List
               := No_Bare_Lkt_Node;


   PP : constant Parser_Private_Part := +Parser.Private_Part;
   M  : Memo_Entry := Get (PP.Lambda_Param_List_List_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      List_Res22 := M.Instance;
      return List_Res22;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return List_Res22;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  BEGIN <List (root of 'lambda_param_list') at parser.lkt:192:26>

    List_Pos22 := Pos;



Lst_Cpos22 := Pos;
Tmp_List22 := Get_Parse_List (Parser);


loop
   
--  BEGIN <Defer (for 'lambda_param_decl') at parser.lkt:192:32>

Defer_Res166 :=
   Lambda_Param_Decl_Transform_Parse0 (Parser, Lst_Cpos22);
Defer_Pos166 := Parser.Current_Pos;

--  END <Defer (for 'lambda_param_decl') at parser.lkt:192:32>


   exit when Defer_Pos166 = No_Token_Index;

   List_Pos22 := Defer_Pos166;
   Lst_Cpos22 := List_Pos22;

   Tmp_List22.Nodes.Append (Defer_Res166);

      
--  BEGIN <Token(<WithText Comma>, ) (root of 'lambda_param_list') at parser.lkt:192:51>

Token_Res165 := Lst_Cpos22;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res165));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_Comma)
   then
       Token_Pos165 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Lst_Cpos22 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Lst_Cpos22,
             Expected_Token_Id => Lkt_Comma,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos165 := Lst_Cpos22 + 1;
   end if;
end;

--  END <Token(<WithText Comma>, ) (root of 'lambda_param_list') at parser.lkt:192:51>


      exit when Token_Pos165 = No_Token_Index;

      Lst_Cpos22 := Token_Pos165;

end loop;


declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List22.Nodes.Length;
begin
   List_Res22 := Allocate_Lambda_Param_Decl_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Pos;
      Token_End := (if Lst_Cpos22 = Pos
                    then Pos
                    else List_Pos22 - 1);

   else
      Token_Start := Token_Index'Max (Pos, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res22,
      Kind              => Lkt_Lambda_Param_Decl_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res22,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_Lkt_Node_Vectors.Vector renames
         Tmp_List22.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res22.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List22);

--  END <List (root of 'lambda_param_list') at parser.lkt:192:26>


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (PP.Lambda_Param_List_List_Parse0_Memo,
      List_Pos22 /= No_Token_Index,
      List_Res22,
      Pos,
      List_Pos22);


   Parser.Current_Pos := List_Pos22;

   return List_Res22;
end Lambda_Param_List_List_Parse0;

   


function Lexer_Case_Alt_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Base_Lexer_Case_Rule_Alt
is
   use Bare_Base_Lexer_Case_Rule_Alt_Memos;

      Row_Pos117 :
            Token_Index
               := No_Token_Index;
      Token_Pos166 :
            Token_Index
               := No_Token_Index;
      Token_Res166 :
            Token_Index
               := No_Token_Index;
      Token_Pos167 :
            Token_Index
               := No_Token_Index;
      Token_Res167 :
            Token_Index
               := No_Token_Index;
      Token_Pos168 :
            Token_Index
               := No_Token_Index;
      Token_Res168 :
            Token_Index
               := No_Token_Index;
      Lst_Cpos23 :
            Token_Index
               := No_Token_Index;
      Tmp_List23 :
            Free_Parse_List;
      Defer_Pos167 :
            Token_Index
               := No_Token_Index;
      Defer_Res167 :
            Bare_Ref_Id
               := No_Bare_Lkt_Node;
      Token_Pos169 :
            Token_Index
               := No_Token_Index;
      Token_Res169 :
            Token_Index
               := No_Token_Index;
      List_Pos23 :
            Token_Index
               := No_Token_Index;
      List_Res23 :
            Bare_Ref_Id_List
               := No_Bare_Lkt_Node;
      Token_Pos170 :
            Token_Index
               := No_Token_Index;
      Token_Res170 :
            Token_Index
               := No_Token_Index;
      Defer_Pos168 :
            Token_Index
               := No_Token_Index;
      Defer_Res168 :
            Bare_Lexer_Case_Rule_Send
               := No_Bare_Lkt_Node;
      Transform_Res101 :
            Bare_Lexer_Case_Rule_Cond_Alt
               := No_Bare_Lkt_Node;
      Transform_Diags101 :
            Ada.Containers.Count_Type;
      Row_Pos118 :
            Token_Index
               := No_Token_Index;
      Token_Pos171 :
            Token_Index
               := No_Token_Index;
      Token_Res171 :
            Token_Index
               := No_Token_Index;
      Defer_Pos169 :
            Token_Index
               := No_Token_Index;
      Defer_Res169 :
            Bare_Lexer_Case_Rule_Send
               := No_Bare_Lkt_Node;
      Transform_Res102 :
            Bare_Lexer_Case_Rule_Default_Alt
               := No_Bare_Lkt_Node;
      Transform_Diags102 :
            Ada.Containers.Count_Type;
      Or_Pos26 :
            Token_Index
               := No_Token_Index;
      Or_Res26 :
            Bare_Base_Lexer_Case_Rule_Alt
               := No_Bare_Lkt_Node;


   PP : constant Parser_Private_Part := +Parser.Private_Part;
   M  : Memo_Entry := Get (PP.Lexer_Case_Alt_Or_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Or_Res26 := M.Instance;
      return Or_Res26;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Or_Res26;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  BEGIN <Or (root of 'lexer_case_alt') at parser.lkt:27:23>

Or_Pos26 := No_Token_Index;
Or_Res26 := No_Bare_Lkt_Node;
    
--  BEGIN <Transform(<ASTNodeType LexerCaseRuleCondAlt>) (root of 'lexer_case_alt') at parser.lkt:28:11>

Transform_Diags101 := Parser.Diagnostics.Length;


--  BEGIN <_Row (root of 'lexer_case_alt') at parser.lkt:28:11>

Row_Pos117 := Pos;



--  BEGIN <Token(<WithText IfKw>, ) (root of 'lexer_case_alt') at parser.lkt:29:13>

Token_Res166 := Row_Pos117;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res166));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_If_Kw)
   then
       Token_Pos166 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos117 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos117,
             Expected_Token_Id => Lkt_If_Kw,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos166 := Row_Pos117 + 1;
   end if;
end;

--  END <Token(<WithText IfKw>, ) (root of 'lexer_case_alt') at parser.lkt:29:13>




if Token_Pos166 /= No_Token_Index then

   Row_Pos117 := Token_Pos166;

else
   Row_Pos117 := No_Token_Index;
   goto Exit_Row117_0;

end if;


--  BEGIN <Token(<WithSymbol Identifier>, previous_token) (root of 'lexer_case_alt') at parser.lkt:30:13>

Token_Res167 := Row_Pos117;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res167));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_Identifier)
      or else T.Symbol /= Precomputed_Symbol
        (Precomputed_Symbol_Table (Parser.TDH.Symbols),
         Precomputed_Sym_Previous_Token)
   then
       Token_Pos167 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos117 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos117,
             Expected_Token_Id => Lkt_Identifier,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos167 := Row_Pos117 + 1;
   end if;
end;

--  END <Token(<WithSymbol Identifier>, previous_token) (root of 'lexer_case_alt') at parser.lkt:30:13>




if Token_Pos167 /= No_Token_Index then

   Row_Pos117 := Token_Pos167;

else
   Row_Pos117 := No_Token_Index;
   goto Exit_Row117_0;

end if;


--  BEGIN <Token(<WithText IsKw>, ) (root of 'lexer_case_alt') at parser.lkt:31:13>

Token_Res168 := Row_Pos117;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res168));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_Is_Kw)
   then
       Token_Pos168 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos117 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos117,
             Expected_Token_Id => Lkt_Is_Kw,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos168 := Row_Pos117 + 1;
   end if;
end;

--  END <Token(<WithText IsKw>, ) (root of 'lexer_case_alt') at parser.lkt:31:13>




if Token_Pos168 /= No_Token_Index then

   Row_Pos117 := Token_Pos168;

else
   Row_Pos117 := No_Token_Index;
   goto Exit_Row117_0;

end if;


--  BEGIN <List (root of 'lexer_case_alt') at parser.lkt:32:13>

    List_Pos23 := No_Token_Index;



Lst_Cpos23 := Row_Pos117;
Tmp_List23 := Get_Parse_List (Parser);


loop
   
--  BEGIN <Defer (for 'ref_id') at parser.lkt:32:19>

Defer_Res167 :=
   Ref_Id_Transform_Parse0 (Parser, Lst_Cpos23);
Defer_Pos167 := Parser.Current_Pos;

--  END <Defer (for 'ref_id') at parser.lkt:32:19>


   exit when Defer_Pos167 = No_Token_Index;

   List_Pos23 := Defer_Pos167;
   Lst_Cpos23 := List_Pos23;

   Tmp_List23.Nodes.Append (Defer_Res167);

      
--  BEGIN <Token(<WithText Pipe>, ) (root of 'lexer_case_alt') at parser.lkt:32:27>

Token_Res169 := Lst_Cpos23;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res169));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_Pipe)
   then
       Token_Pos169 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Lst_Cpos23 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Lst_Cpos23,
             Expected_Token_Id => Lkt_Pipe,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos169 := Lst_Cpos23 + 1;
   end if;
end;

--  END <Token(<WithText Pipe>, ) (root of 'lexer_case_alt') at parser.lkt:32:27>


      exit when Token_Pos169 = No_Token_Index;

      Lst_Cpos23 := Token_Pos169;

end loop;


declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List23.Nodes.Length;
begin
   List_Res23 := Allocate_Ref_Id_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Row_Pos117;
      Token_End := (if Lst_Cpos23 = Row_Pos117
                    then Row_Pos117
                    else List_Pos23 - 1);

   else
      Token_Start := Token_Index'Max (Row_Pos117, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res23,
      Kind              => Lkt_Ref_Id_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res23,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_Lkt_Node_Vectors.Vector renames
         Tmp_List23.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res23.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List23);

--  END <List (root of 'lexer_case_alt') at parser.lkt:32:13>




if List_Pos23 /= No_Token_Index then

   Row_Pos117 := List_Pos23;

else
   Row_Pos117 := No_Token_Index;
   goto Exit_Row117_0;

end if;


--  BEGIN <Token(<WithText ThenKw>, ) (root of 'lexer_case_alt') at parser.lkt:33:13>

Token_Res170 := Row_Pos117;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res170));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_Then_Kw)
   then
       Token_Pos170 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos117 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos117,
             Expected_Token_Id => Lkt_Then_Kw,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos170 := Row_Pos117 + 1;
   end if;
end;

--  END <Token(<WithText ThenKw>, ) (root of 'lexer_case_alt') at parser.lkt:33:13>




if Token_Pos170 /= No_Token_Index then

   Row_Pos117 := Token_Pos170;

else
   Row_Pos117 := No_Token_Index;
   goto Exit_Row117_0;

end if;


--  BEGIN <Defer (for 'lexer_case_send') at parser.lkt:34:13>

Defer_Res168 :=
   Lexer_Case_Send_Transform_Parse0 (Parser, Row_Pos117);
Defer_Pos168 := Parser.Current_Pos;

--  END <Defer (for 'lexer_case_send') at parser.lkt:34:13>




if Defer_Pos168 /= No_Token_Index then

   Row_Pos117 := Defer_Pos168;

else
   Row_Pos117 := No_Token_Index;
   goto Exit_Row117_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row117_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'lexer_case_alt') at parser.lkt:28:11>



if Row_Pos117 /= No_Token_Index then

   Transform_Res101 := Allocate_Lexer_Case_Rule_Cond_Alt (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res101,
      Kind => Lkt_Lexer_Case_Rule_Cond_Alt,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos117 = Pos
                            then No_Token_Index
                            else Row_Pos117 - 1));

      
      Initialize_Fields_For_Lexer_Case_Rule_Cond_Alt
        (Self => Transform_Res101,
         Lexer_Case_Rule_Cond_Alt_F_Cond_Exprs => List_Res23,
         Lexer_Case_Rule_Cond_Alt_F_Send => Defer_Res168);

         if List_Res23 /= null and then Is_Incomplete (List_Res23) then
            Transform_Res101.Last_Attempted_Child := 0;
         elsif List_Res23 /= null and then not Is_Ghost (List_Res23) then
            Transform_Res101.Last_Attempted_Child := -1;
         end if;
         if Defer_Res168 /= null and then Is_Incomplete (Defer_Res168) then
            Transform_Res101.Last_Attempted_Child := 0;
         elsif Defer_Res168 /= null and then not Is_Ghost (Defer_Res168) then
            Transform_Res101.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos117 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags101);
end if;

--  END <Transform(<ASTNodeType LexerCaseRuleCondAlt>) (root of 'lexer_case_alt') at parser.lkt:28:11>

    if Row_Pos117 /= No_Token_Index then
        Or_Pos26 := Row_Pos117;
        Or_Res26 := Transform_Res101;
        goto Exit_Or27;
    end if;
    
--  BEGIN <Transform(<ASTNodeType LexerCaseRuleDefaultAlt>) (root of 'lexer_case_alt') at parser.lkt:36:11>

Transform_Diags102 := Parser.Diagnostics.Length;


--  BEGIN <_Row (root of 'lexer_case_alt') at parser.lkt:36:11>

Row_Pos118 := Pos;



--  BEGIN <Token(<WithText ElseKw>, ) (root of 'lexer_case_alt') at parser.lkt:36:35>

Token_Res171 := Row_Pos118;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res171));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_Else_Kw)
   then
       Token_Pos171 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos118 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos118,
             Expected_Token_Id => Lkt_Else_Kw,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos171 := Row_Pos118 + 1;
   end if;
end;

--  END <Token(<WithText ElseKw>, ) (root of 'lexer_case_alt') at parser.lkt:36:35>




if Token_Pos171 /= No_Token_Index then

   Row_Pos118 := Token_Pos171;

else
   Row_Pos118 := No_Token_Index;
   goto Exit_Row118_0;

end if;


--  BEGIN <Defer (for 'lexer_case_send') at parser.lkt:36:42>

Defer_Res169 :=
   Lexer_Case_Send_Transform_Parse0 (Parser, Row_Pos118);
Defer_Pos169 := Parser.Current_Pos;

--  END <Defer (for 'lexer_case_send') at parser.lkt:36:42>




if Defer_Pos169 /= No_Token_Index then

   Row_Pos118 := Defer_Pos169;

else
   Row_Pos118 := No_Token_Index;
   goto Exit_Row118_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row118_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'lexer_case_alt') at parser.lkt:36:11>



if Row_Pos118 /= No_Token_Index then

   Transform_Res102 := Allocate_Lexer_Case_Rule_Default_Alt (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res102,
      Kind => Lkt_Lexer_Case_Rule_Default_Alt,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos118 = Pos
                            then No_Token_Index
                            else Row_Pos118 - 1));

      
      Initialize_Fields_For_Lexer_Case_Rule_Default_Alt
        (Self => Transform_Res102,
         Lexer_Case_Rule_Default_Alt_F_Send => Defer_Res169);

         if Defer_Res169 /= null and then Is_Incomplete (Defer_Res169) then
            Transform_Res102.Last_Attempted_Child := 0;
         elsif Defer_Res169 /= null and then not Is_Ghost (Defer_Res169) then
            Transform_Res102.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos118 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags102);
end if;

--  END <Transform(<ASTNodeType LexerCaseRuleDefaultAlt>) (root of 'lexer_case_alt') at parser.lkt:36:11>

    if Row_Pos118 /= No_Token_Index then
        Or_Pos26 := Row_Pos118;
        Or_Res26 := Transform_Res102;
        goto Exit_Or27;
    end if;
<<Exit_Or27>>

--  END <Or (root of 'lexer_case_alt') at parser.lkt:27:23>


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (PP.Lexer_Case_Alt_Or_Parse0_Memo,
      Or_Pos26 /= No_Token_Index,
      Or_Res26,
      Pos,
      Or_Pos26);


   Parser.Current_Pos := Or_Pos26;

   return Or_Res26;
end Lexer_Case_Alt_Or_Parse0;

   


function Lexer_Case_Rule_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Lexer_Case_Rule
is
   use Bare_Lexer_Case_Rule_Memos;

      Row_Pos119 :
            Token_Index
               := No_Token_Index;
      Token_Pos172 :
            Token_Index
               := No_Token_Index;
      Token_Res172 :
            Token_Index
               := No_Token_Index;
      Defer_Pos170 :
            Token_Index
               := No_Token_Index;
      Defer_Res170 :
            Bare_Grammar_Expr
               := No_Bare_Lkt_Node;
      Token_Pos173 :
            Token_Index
               := No_Token_Index;
      Token_Res173 :
            Token_Index
               := No_Token_Index;
      Lst_Cpos24 :
            Token_Index
               := No_Token_Index;
      Tmp_List24 :
            Free_Parse_List;
      Defer_Pos171 :
            Token_Index
               := No_Token_Index;
      Defer_Res171 :
            Bare_Base_Lexer_Case_Rule_Alt
               := No_Bare_Lkt_Node;
      List_Pos24 :
            Token_Index
               := No_Token_Index;
      List_Res24 :
            Bare_Base_Lexer_Case_Rule_Alt_List
               := No_Bare_Lkt_Node;
      Token_Pos174 :
            Token_Index
               := No_Token_Index;
      Token_Res174 :
            Token_Index
               := No_Token_Index;
      Transform_Res103 :
            Bare_Lexer_Case_Rule
               := No_Bare_Lkt_Node;
      Transform_Diags103 :
            Ada.Containers.Count_Type;


   PP : constant Parser_Private_Part := +Parser.Private_Part;
   M  : Memo_Entry := Get (PP.Lexer_Case_Rule_Transform_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res103 := M.Instance;
      return Transform_Res103;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res103;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  BEGIN <Transform(<ASTNodeType LexerCaseRule>) (root of 'lexer_case_rule') at parser.lkt:24:24>

Transform_Diags103 := Parser.Diagnostics.Length;


--  BEGIN <_Row (root of 'lexer_case_rule') at parser.lkt:24:24>

Row_Pos119 := Pos;



--  BEGIN <Token(<WithText MatchKw>, ) (root of 'lexer_case_rule') at parser.lkt:25:9>

Token_Res172 := Row_Pos119;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res172));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_Match_Kw)
   then
       Token_Pos172 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos119 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos119,
             Expected_Token_Id => Lkt_Match_Kw,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos172 := Row_Pos119 + 1;
   end if;
end;

--  END <Token(<WithText MatchKw>, ) (root of 'lexer_case_rule') at parser.lkt:25:9>




if Token_Pos172 /= No_Token_Index then

   Row_Pos119 := Token_Pos172;

else
   Row_Pos119 := No_Token_Index;
   goto Exit_Row119_0;

end if;


--  BEGIN <Defer (for 'grammar_primary') at parser.lkt:25:17>

Defer_Res170 :=
   Grammar_Primary_Or_Parse0 (Parser, Row_Pos119);
Defer_Pos170 := Parser.Current_Pos;

--  END <Defer (for 'grammar_primary') at parser.lkt:25:17>




if Defer_Pos170 /= No_Token_Index then

   Row_Pos119 := Defer_Pos170;

else
   Row_Pos119 := No_Token_Index;
   goto Exit_Row119_0;

end if;


--  BEGIN <Token(<WithText LBrace>, ) (root of 'lexer_case_rule') at parser.lkt:25:33>

Token_Res173 := Row_Pos119;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res173));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_L_Brace)
   then
       Token_Pos173 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos119 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos119,
             Expected_Token_Id => Lkt_L_Brace,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos173 := Row_Pos119 + 1;
   end if;
end;

--  END <Token(<WithText LBrace>, ) (root of 'lexer_case_rule') at parser.lkt:25:33>




if Token_Pos173 /= No_Token_Index then

   Row_Pos119 := Token_Pos173;

else
   Row_Pos119 := No_Token_Index;
   goto Exit_Row119_0;

end if;


--  BEGIN <List (root of 'lexer_case_rule') at parser.lkt:25:37>

    List_Pos24 := No_Token_Index;



Lst_Cpos24 := Row_Pos119;
Tmp_List24 := Get_Parse_List (Parser);


loop
   
--  BEGIN <Defer (for 'lexer_case_alt') at parser.lkt:25:43>

Defer_Res171 :=
   Lexer_Case_Alt_Or_Parse0 (Parser, Lst_Cpos24);
Defer_Pos171 := Parser.Current_Pos;

--  END <Defer (for 'lexer_case_alt') at parser.lkt:25:43>


   exit when Defer_Pos171 = No_Token_Index;

   List_Pos24 := Defer_Pos171;
   Lst_Cpos24 := List_Pos24;

   Tmp_List24.Nodes.Append (Defer_Res171);

end loop;


declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List24.Nodes.Length;
begin
   List_Res24 := Allocate_Base_Lexer_Case_Rule_Alt_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Row_Pos119;
      Token_End := (if Lst_Cpos24 = Row_Pos119
                    then Row_Pos119
                    else List_Pos24 - 1);

   else
      Token_Start := Token_Index'Max (Row_Pos119, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res24,
      Kind              => Lkt_Base_Lexer_Case_Rule_Alt_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res24,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_Lkt_Node_Vectors.Vector renames
         Tmp_List24.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res24.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List24);

--  END <List (root of 'lexer_case_rule') at parser.lkt:25:37>




if List_Pos24 /= No_Token_Index then

   Row_Pos119 := List_Pos24;

else
   Row_Pos119 := No_Token_Index;
   goto Exit_Row119_0;

end if;


--  BEGIN <Token(<WithText RBrace>, ) (root of 'lexer_case_rule') at parser.lkt:25:59>

Token_Res174 := Row_Pos119;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res174));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_R_Brace)
   then
       Token_Pos174 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos119 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos119,
             Expected_Token_Id => Lkt_R_Brace,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos174 := Row_Pos119 + 1;
   end if;
end;

--  END <Token(<WithText RBrace>, ) (root of 'lexer_case_rule') at parser.lkt:25:59>




if Token_Pos174 /= No_Token_Index then

   Row_Pos119 := Token_Pos174;

else
   Row_Pos119 := No_Token_Index;
   goto Exit_Row119_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row119_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'lexer_case_rule') at parser.lkt:24:24>



if Row_Pos119 /= No_Token_Index then

   Transform_Res103 := Allocate_Lexer_Case_Rule (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res103,
      Kind => Lkt_Lexer_Case_Rule,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos119 = Pos
                            then No_Token_Index
                            else Row_Pos119 - 1));

      
      Initialize_Fields_For_Lexer_Case_Rule
        (Self => Transform_Res103,
         Lexer_Case_Rule_F_Expr => Defer_Res170,
         Lexer_Case_Rule_F_Alts => List_Res24);

         if Defer_Res170 /= null and then Is_Incomplete (Defer_Res170) then
            Transform_Res103.Last_Attempted_Child := 0;
         elsif Defer_Res170 /= null and then not Is_Ghost (Defer_Res170) then
            Transform_Res103.Last_Attempted_Child := -1;
         end if;
         if List_Res24 /= null and then Is_Incomplete (List_Res24) then
            Transform_Res103.Last_Attempted_Child := 0;
         elsif List_Res24 /= null and then not Is_Ghost (List_Res24) then
            Transform_Res103.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos119 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags103);
end if;

--  END <Transform(<ASTNodeType LexerCaseRule>) (root of 'lexer_case_rule') at parser.lkt:24:24>


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (PP.Lexer_Case_Rule_Transform_Parse0_Memo,
      Row_Pos119 /= No_Token_Index,
      Transform_Res103,
      Pos,
      Row_Pos119);


   Parser.Current_Pos := Row_Pos119;

   return Transform_Res103;
end Lexer_Case_Rule_Transform_Parse0;

   


function Lexer_Case_Send_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Lexer_Case_Rule_Send
is
   use Bare_Lexer_Case_Rule_Send_Memos;

      Row_Pos120 :
            Token_Index
               := No_Token_Index;
      Token_Pos175 :
            Token_Index
               := No_Token_Index;
      Token_Res175 :
            Token_Index
               := No_Token_Index;
      Token_Pos176 :
            Token_Index
               := No_Token_Index;
      Token_Res176 :
            Token_Index
               := No_Token_Index;
      Defer_Pos172 :
            Token_Index
               := No_Token_Index;
      Defer_Res172 :
            Bare_Ref_Id
               := No_Bare_Lkt_Node;
      Token_Pos177 :
            Token_Index
               := No_Token_Index;
      Token_Res177 :
            Token_Index
               := No_Token_Index;
      Defer_Pos173 :
            Token_Index
               := No_Token_Index;
      Defer_Res173 :
            Bare_Num_Lit
               := No_Bare_Lkt_Node;
      Token_Pos178 :
            Token_Index
               := No_Token_Index;
      Token_Res178 :
            Token_Index
               := No_Token_Index;
      Transform_Res104 :
            Bare_Lexer_Case_Rule_Send
               := No_Bare_Lkt_Node;
      Transform_Diags104 :
            Ada.Containers.Count_Type;


   PP : constant Parser_Private_Part := +Parser.Private_Part;
   M  : Memo_Entry := Get (PP.Lexer_Case_Send_Transform_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res104 := M.Instance;
      return Transform_Res104;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res104;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  BEGIN <Transform(<ASTNodeType LexerCaseRuleSend>) (root of 'lexer_case_send') at parser.lkt:38:24>

Transform_Diags104 := Parser.Diagnostics.Length;


--  BEGIN <_Row (root of 'lexer_case_send') at parser.lkt:38:24>

Row_Pos120 := Pos;



--  BEGIN <Token(<WithSymbol Identifier>, send) (root of 'lexer_case_send') at parser.lkt:39:9>

Token_Res175 := Row_Pos120;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res175));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_Identifier)
      or else T.Symbol /= Precomputed_Symbol
        (Precomputed_Symbol_Table (Parser.TDH.Symbols),
         Precomputed_Sym_Send)
   then
       Token_Pos175 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos120 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos120,
             Expected_Token_Id => Lkt_Identifier,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos175 := Row_Pos120 + 1;
   end if;
end;

--  END <Token(<WithSymbol Identifier>, send) (root of 'lexer_case_send') at parser.lkt:39:9>




if Token_Pos175 /= No_Token_Index then

   Row_Pos120 := Token_Pos175;

else
   Row_Pos120 := No_Token_Index;
   goto Exit_Row120_0;

end if;


--  BEGIN <Token(<WithText LPar>, ) (root of 'lexer_case_send') at parser.lkt:39:29>

Token_Res176 := Row_Pos120;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res176));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_L_Par)
   then
       Token_Pos176 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos120 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos120,
             Expected_Token_Id => Lkt_L_Par,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos176 := Row_Pos120 + 1;
   end if;
end;

--  END <Token(<WithText LPar>, ) (root of 'lexer_case_send') at parser.lkt:39:29>




if Token_Pos176 /= No_Token_Index then

   Row_Pos120 := Token_Pos176;

else
   Row_Pos120 := No_Token_Index;
   goto Exit_Row120_0;

end if;


--  BEGIN <Defer (for 'ref_id') at parser.lkt:39:33>

Defer_Res172 :=
   Ref_Id_Transform_Parse0 (Parser, Row_Pos120);
Defer_Pos172 := Parser.Current_Pos;

--  END <Defer (for 'ref_id') at parser.lkt:39:33>




if Defer_Pos172 /= No_Token_Index then

   Row_Pos120 := Defer_Pos172;

else
   Row_Pos120 := No_Token_Index;
   goto Exit_Row120_0;

end if;


--  BEGIN <Token(<WithText Comma>, ) (root of 'lexer_case_send') at parser.lkt:39:40>

Token_Res177 := Row_Pos120;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res177));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_Comma)
   then
       Token_Pos177 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos120 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos120,
             Expected_Token_Id => Lkt_Comma,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos177 := Row_Pos120 + 1;
   end if;
end;

--  END <Token(<WithText Comma>, ) (root of 'lexer_case_send') at parser.lkt:39:40>




if Token_Pos177 /= No_Token_Index then

   Row_Pos120 := Token_Pos177;

else
   Row_Pos120 := No_Token_Index;
   goto Exit_Row120_0;

end if;


--  BEGIN <Defer (for 'num_lit') at parser.lkt:39:44>

Defer_Res173 :=
   Num_Lit_Transform_Parse0 (Parser, Row_Pos120);
Defer_Pos173 := Parser.Current_Pos;

--  END <Defer (for 'num_lit') at parser.lkt:39:44>




if Defer_Pos173 /= No_Token_Index then

   Row_Pos120 := Defer_Pos173;

else
   Row_Pos120 := No_Token_Index;
   goto Exit_Row120_0;

end if;


--  BEGIN <Token(<WithText RPar>, ) (root of 'lexer_case_send') at parser.lkt:39:52>

Token_Res178 := Row_Pos120;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res178));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_R_Par)
   then
       Token_Pos178 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos120 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos120,
             Expected_Token_Id => Lkt_R_Par,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos178 := Row_Pos120 + 1;
   end if;
end;

--  END <Token(<WithText RPar>, ) (root of 'lexer_case_send') at parser.lkt:39:52>




if Token_Pos178 /= No_Token_Index then

   Row_Pos120 := Token_Pos178;

else
   Row_Pos120 := No_Token_Index;
   goto Exit_Row120_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row120_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'lexer_case_send') at parser.lkt:38:24>



if Row_Pos120 /= No_Token_Index then

   Transform_Res104 := Allocate_Lexer_Case_Rule_Send (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res104,
      Kind => Lkt_Lexer_Case_Rule_Send,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos120 = Pos
                            then No_Token_Index
                            else Row_Pos120 - 1));

      
      Initialize_Fields_For_Lexer_Case_Rule_Send
        (Self => Transform_Res104,
         Lexer_Case_Rule_Send_F_Sent => Defer_Res172,
         Lexer_Case_Rule_Send_F_Match_Size => Defer_Res173);

         if Defer_Res172 /= null and then Is_Incomplete (Defer_Res172) then
            Transform_Res104.Last_Attempted_Child := 0;
         elsif Defer_Res172 /= null and then not Is_Ghost (Defer_Res172) then
            Transform_Res104.Last_Attempted_Child := -1;
         end if;
         if Defer_Res173 /= null and then Is_Incomplete (Defer_Res173) then
            Transform_Res104.Last_Attempted_Child := 0;
         elsif Defer_Res173 /= null and then not Is_Ghost (Defer_Res173) then
            Transform_Res104.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos120 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags104);
end if;

--  END <Transform(<ASTNodeType LexerCaseRuleSend>) (root of 'lexer_case_send') at parser.lkt:38:24>


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (PP.Lexer_Case_Send_Transform_Parse0_Memo,
      Row_Pos120 /= No_Token_Index,
      Transform_Res104,
      Pos,
      Row_Pos120);


   Parser.Current_Pos := Row_Pos120;

   return Transform_Res104;
end Lexer_Case_Send_Transform_Parse0;

   


function Lexer_Decl_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Lexer_Decl
is
   use Bare_Lexer_Decl_Memos;

      Row_Pos121 :
            Token_Index
               := No_Token_Index;
      Token_Pos179 :
            Token_Index
               := No_Token_Index;
      Token_Res179 :
            Token_Index
               := No_Token_Index;
      Defer_Pos174 :
            Token_Index
               := No_Token_Index;
      Defer_Res174 :
            Bare_Def_Id
               := No_Bare_Lkt_Node;
      Token_Pos180 :
            Token_Index
               := No_Token_Index;
      Token_Res180 :
            Token_Index
               := No_Token_Index;
      Lst_Cpos25 :
            Token_Index
               := No_Token_Index;
      Tmp_List25 :
            Free_Parse_List;
      Defer_Pos175 :
            Token_Index
               := No_Token_Index;
      Defer_Res175 :
            Bare_Full_Decl
               := No_Bare_Lkt_Node;
      Defer_Pos176 :
            Token_Index
               := No_Token_Index;
      Defer_Res176 :
            Bare_Lkt_Node
               := No_Bare_Lkt_Node;
      Or_Pos27 :
            Token_Index
               := No_Token_Index;
      Or_Res27 :
            Bare_Lkt_Node
               := No_Bare_Lkt_Node;
      List_Pos25 :
            Token_Index
               := No_Token_Index;
      List_Res25 :
            Bare_Lkt_Node_List
               := No_Bare_Lkt_Node;
      Token_Pos181 :
            Token_Index
               := No_Token_Index;
      Token_Res181 :
            Token_Index
               := No_Token_Index;
      Transform_Res105 :
            Bare_Lexer_Decl
               := No_Bare_Lkt_Node;
      Transform_Diags105 :
            Ada.Containers.Count_Type;


   PP : constant Parser_Private_Part := +Parser.Private_Part;
   M  : Memo_Entry := Get (PP.Lexer_Decl_Transform_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res105 := M.Instance;
      return Transform_Res105;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res105;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  BEGIN <Transform(<ASTNodeType LexerDecl>) (root of 'lexer_decl') at parser.lkt:13:19>

Transform_Diags105 := Parser.Diagnostics.Length;


--  BEGIN <_Row (root of 'lexer_decl') at parser.lkt:13:19>

Row_Pos121 := Pos;



--  BEGIN <Token(<WithText LexerKw>, ) (root of 'lexer_decl') at parser.lkt:14:9>

Token_Res179 := Row_Pos121;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res179));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_Lexer_Kw)
   then
       Token_Pos179 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos121 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos121,
             Expected_Token_Id => Lkt_Lexer_Kw,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos179 := Row_Pos121 + 1;
   end if;
end;

--  END <Token(<WithText LexerKw>, ) (root of 'lexer_decl') at parser.lkt:14:9>




if Token_Pos179 /= No_Token_Index then

   Row_Pos121 := Token_Pos179;

else
   Row_Pos121 := No_Token_Index;
   goto Exit_Row121_0;

end if;


--  BEGIN <Defer (for 'def_id') at parser.lkt:14:17>

Defer_Res174 :=
   Def_Id_Transform_Parse0 (Parser, Row_Pos121);
Defer_Pos174 := Parser.Current_Pos;

--  END <Defer (for 'def_id') at parser.lkt:14:17>




if Defer_Pos174 /= No_Token_Index then

   Row_Pos121 := Defer_Pos174;

else
   Row_Pos121 := No_Token_Index;
   goto Exit_Row121_0;

end if;


--  BEGIN <Token(<WithText LBrace>, ) (root of 'lexer_decl') at parser.lkt:14:24>

Token_Res180 := Row_Pos121;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res180));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_L_Brace)
   then
       Token_Pos180 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos121 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos121,
             Expected_Token_Id => Lkt_L_Brace,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos180 := Row_Pos121 + 1;
   end if;
end;

--  END <Token(<WithText LBrace>, ) (root of 'lexer_decl') at parser.lkt:14:24>




if Token_Pos180 /= No_Token_Index then

   Row_Pos121 := Token_Pos180;

else
   Row_Pos121 := No_Token_Index;
   goto Exit_Row121_0;

end if;


--  BEGIN <List (root of 'lexer_decl') at parser.lkt:14:28>

    List_Pos25 := Row_Pos121;



Lst_Cpos25 := Row_Pos121;
Tmp_List25 := Get_Parse_List (Parser);


loop
   
--  BEGIN <Or (root of 'lexer_decl') at parser.lkt:14:34>

Or_Pos27 := No_Token_Index;
Or_Res27 := No_Bare_Lkt_Node;
    
--  BEGIN <Defer (for 'lexer_family_decl') at parser.lkt:14:37>

Defer_Res175 :=
   Lexer_Family_Decl_Transform_Parse1 (Parser, Lst_Cpos25);
Defer_Pos175 := Parser.Current_Pos;

--  END <Defer (for 'lexer_family_decl') at parser.lkt:14:37>

    if Defer_Pos175 /= No_Token_Index then
        Or_Pos27 := Defer_Pos175;
        Or_Res27 := Defer_Res175;
        goto Exit_Or28;
    end if;
    
--  BEGIN <Defer (for 'lexer_rule') at parser.lkt:14:57>

Defer_Res176 :=
   Lexer_Rule_Or_Parse0 (Parser, Lst_Cpos25);
Defer_Pos176 := Parser.Current_Pos;

--  END <Defer (for 'lexer_rule') at parser.lkt:14:57>

    if Defer_Pos176 /= No_Token_Index then
        Or_Pos27 := Defer_Pos176;
        Or_Res27 := Defer_Res176;
        goto Exit_Or28;
    end if;
<<Exit_Or28>>

--  END <Or (root of 'lexer_decl') at parser.lkt:14:34>


   exit when Or_Pos27 = No_Token_Index;

   List_Pos25 := Or_Pos27;
   Lst_Cpos25 := List_Pos25;

   Tmp_List25.Nodes.Append (Or_Res27);

end loop;


declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List25.Nodes.Length;
begin
   List_Res25 := Allocate_Lkt_Node_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Row_Pos121;
      Token_End := (if Lst_Cpos25 = Row_Pos121
                    then Row_Pos121
                    else List_Pos25 - 1);

   else
      Token_Start := Token_Index'Max (Row_Pos121, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res25,
      Kind              => Lkt_Lkt_Node_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res25,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_Lkt_Node_Vectors.Vector renames
         Tmp_List25.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res25.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List25);

--  END <List (root of 'lexer_decl') at parser.lkt:14:28>




if List_Pos25 /= No_Token_Index then

   Row_Pos121 := List_Pos25;

else
   Row_Pos121 := No_Token_Index;
   goto Exit_Row121_0;

end if;


--  BEGIN <Token(<WithText RBrace>, ) (root of 'lexer_decl') at parser.lkt:14:70>

Token_Res181 := Row_Pos121;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res181));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_R_Brace)
   then
       Token_Pos181 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos121 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos121,
             Expected_Token_Id => Lkt_R_Brace,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos181 := Row_Pos121 + 1;
   end if;
end;

--  END <Token(<WithText RBrace>, ) (root of 'lexer_decl') at parser.lkt:14:70>




if Token_Pos181 /= No_Token_Index then

   Row_Pos121 := Token_Pos181;

else
   Row_Pos121 := No_Token_Index;
   goto Exit_Row121_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row121_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'lexer_decl') at parser.lkt:13:19>



if Row_Pos121 /= No_Token_Index then

   Transform_Res105 := Allocate_Lexer_Decl (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res105,
      Kind => Lkt_Lexer_Decl,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos121 = Pos
                            then No_Token_Index
                            else Row_Pos121 - 1));

      
      Initialize_Fields_For_Lexer_Decl
        (Self => Transform_Res105,
         Lexer_Decl_F_Syn_Name => Defer_Res174,
         Lexer_Decl_F_Rules => List_Res25);

         if Defer_Res174 /= null and then Is_Incomplete (Defer_Res174) then
            Transform_Res105.Last_Attempted_Child := 0;
         elsif Defer_Res174 /= null and then not Is_Ghost (Defer_Res174) then
            Transform_Res105.Last_Attempted_Child := -1;
         end if;
         if List_Res25 /= null and then Is_Incomplete (List_Res25) then
            Transform_Res105.Last_Attempted_Child := 0;
         elsif List_Res25 /= null and then not Is_Ghost (List_Res25) then
            Transform_Res105.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos121 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags105);
end if;

--  END <Transform(<ASTNodeType LexerDecl>) (root of 'lexer_decl') at parser.lkt:13:19>


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (PP.Lexer_Decl_Transform_Parse0_Memo,
      Row_Pos121 /= No_Token_Index,
      Transform_Res105,
      Pos,
      Row_Pos121);


   Parser.Current_Pos := Row_Pos121;

   return Transform_Res105;
end Lexer_Decl_Transform_Parse0;

   


function Lexer_Family_Decl_Transform_Parse1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Full_Decl
is
   use Bare_Full_Decl_Memos;

      Row_Pos122 :
            Token_Index
               := No_Token_Index;
      Defer_Pos177 :
            Token_Index
               := No_Token_Index;
      Defer_Res177 :
            Bare_String_Lit
               := No_Bare_Lkt_Node;
      Lst_Cpos26 :
            Token_Index
               := No_Token_Index;
      Tmp_List26 :
            Free_Parse_List;
      Defer_Pos178 :
            Token_Index
               := No_Token_Index;
      Defer_Res178 :
            Bare_Decl_Annotation
               := No_Bare_Lkt_Node;
      List_Pos26 :
            Token_Index
               := No_Token_Index;
      List_Res26 :
            Bare_Decl_Annotation_List
               := No_Bare_Lkt_Node;
      Row_Pos123 :
            Token_Index
               := No_Token_Index;
      Token_Pos182 :
            Token_Index
               := No_Token_Index;
      Token_Res182 :
            Token_Index
               := No_Token_Index;
      Defer_Pos179 :
            Token_Index
               := No_Token_Index;
      Defer_Res179 :
            Bare_Def_Id
               := No_Bare_Lkt_Node;
      Token_Pos183 :
            Token_Index
               := No_Token_Index;
      Token_Res183 :
            Token_Index
               := No_Token_Index;
      Lst_Cpos27 :
            Token_Index
               := No_Token_Index;
      Tmp_List27 :
            Free_Parse_List;
      Defer_Pos180 :
            Token_Index
               := No_Token_Index;
      Defer_Res180 :
            Bare_Full_Decl
               := No_Bare_Lkt_Node;
      List_Pos27 :
            Token_Index
               := No_Token_Index;
      List_Res27 :
            Bare_Full_Decl_List
               := No_Bare_Lkt_Node;
      Token_Pos184 :
            Token_Index
               := No_Token_Index;
      Token_Res184 :
            Token_Index
               := No_Token_Index;
      Transform_Res106 :
            Bare_Lexer_Family_Decl
               := No_Bare_Lkt_Node;
      Transform_Diags106 :
            Ada.Containers.Count_Type;
      Transform_Res107 :
            Bare_Full_Decl
               := No_Bare_Lkt_Node;
      Transform_Diags107 :
            Ada.Containers.Count_Type;


   PP : constant Parser_Private_Part := +Parser.Private_Part;
   M  : Memo_Entry := Get (PP.Lexer_Family_Decl_Transform_Parse1_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res107 := M.Instance;
      return Transform_Res107;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res107;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  BEGIN <Transform(<ASTNodeType FullDecl>) (root of 'lexer_family_decl') at parser.lkt:19:26>

Transform_Diags107 := Parser.Diagnostics.Length;


--  BEGIN <_Row (root of 'lexer_family_decl') at parser.lkt:19:26>

Row_Pos122 := Pos;



--  BEGIN <Defer (for 'doc') at parser.lkt:20:9>

Defer_Res177 :=
   Doc_Opt_Parse0 (Parser, Row_Pos122);
Defer_Pos177 := Parser.Current_Pos;

--  END <Defer (for 'doc') at parser.lkt:20:9>




if Defer_Pos177 /= No_Token_Index then

   Row_Pos122 := Defer_Pos177;

else
   Row_Pos122 := No_Token_Index;
   goto Exit_Row122_0;

end if;


--  BEGIN <List (root of 'lexer_family_decl') at parser.lkt:21:9>

    List_Pos26 := Row_Pos122;



Lst_Cpos26 := Row_Pos122;
Tmp_List26 := Get_Parse_List (Parser);


loop
   
--  BEGIN <Defer (for 'decl_annotation') at parser.lkt:21:15>

Defer_Res178 :=
   Decl_Annotation_Transform_Parse0 (Parser, Lst_Cpos26);
Defer_Pos178 := Parser.Current_Pos;

--  END <Defer (for 'decl_annotation') at parser.lkt:21:15>


   exit when Defer_Pos178 = No_Token_Index;

   List_Pos26 := Defer_Pos178;
   Lst_Cpos26 := List_Pos26;

   Tmp_List26.Nodes.Append (Defer_Res178);

end loop;


declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List26.Nodes.Length;
begin
   List_Res26 := Allocate_Decl_Annotation_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Row_Pos122;
      Token_End := (if Lst_Cpos26 = Row_Pos122
                    then Row_Pos122
                    else List_Pos26 - 1);

   else
      Token_Start := Token_Index'Max (Row_Pos122, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res26,
      Kind              => Lkt_Decl_Annotation_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res26,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_Lkt_Node_Vectors.Vector renames
         Tmp_List26.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res26.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List26);

--  END <List (root of 'lexer_family_decl') at parser.lkt:21:9>




if List_Pos26 /= No_Token_Index then

   Row_Pos122 := List_Pos26;

else
   Row_Pos122 := No_Token_Index;
   goto Exit_Row122_0;

end if;


--  BEGIN <Transform(<ASTNodeType LexerFamilyDecl>) (root of 'lexer_family_decl') at parser.lkt:22:9>

Transform_Diags106 := Parser.Diagnostics.Length;


--  BEGIN <_Row (root of 'lexer_family_decl') at parser.lkt:22:9>

Row_Pos123 := Row_Pos122;



--  BEGIN <Token(<WithSymbol Identifier>, family) (root of 'lexer_family_decl') at parser.lkt:22:25>

Token_Res182 := Row_Pos123;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res182));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_Identifier)
      or else T.Symbol /= Precomputed_Symbol
        (Precomputed_Symbol_Table (Parser.TDH.Symbols),
         Precomputed_Sym_Family)
   then
       Token_Pos182 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos123 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos123,
             Expected_Token_Id => Lkt_Identifier,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos182 := Row_Pos123 + 1;
   end if;
end;

--  END <Token(<WithSymbol Identifier>, family) (root of 'lexer_family_decl') at parser.lkt:22:25>




if Token_Pos182 /= No_Token_Index then

   Row_Pos123 := Token_Pos182;

else
   Row_Pos123 := No_Token_Index;
   goto Exit_Row123_0;

end if;


--  BEGIN <Defer (for 'def_id') at parser.lkt:22:47>

Defer_Res179 :=
   Def_Id_Transform_Parse0 (Parser, Row_Pos123);
Defer_Pos179 := Parser.Current_Pos;

--  END <Defer (for 'def_id') at parser.lkt:22:47>




if Defer_Pos179 /= No_Token_Index then

   Row_Pos123 := Defer_Pos179;

else
   Row_Pos123 := No_Token_Index;
   goto Exit_Row123_0;

end if;


--  BEGIN <Token(<WithText LBrace>, ) (root of 'lexer_family_decl') at parser.lkt:22:54>

Token_Res183 := Row_Pos123;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res183));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_L_Brace)
   then
       Token_Pos183 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos123 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos123,
             Expected_Token_Id => Lkt_L_Brace,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos183 := Row_Pos123 + 1;
   end if;
end;

--  END <Token(<WithText LBrace>, ) (root of 'lexer_family_decl') at parser.lkt:22:54>




if Token_Pos183 /= No_Token_Index then

   Row_Pos123 := Token_Pos183;

else
   Row_Pos123 := No_Token_Index;
   goto Exit_Row123_0;

end if;


--  BEGIN <List (root of 'lexer_family_decl') at parser.lkt:22:58>

    List_Pos27 := No_Token_Index;



Lst_Cpos27 := Row_Pos123;
Tmp_List27 := Get_Parse_List (Parser);


loop
   
--  BEGIN <Defer (for 'decl') at parser.lkt:22:64>

Defer_Res180 :=
   Decl_Transform_Parse0 (Parser, Lst_Cpos27);
Defer_Pos180 := Parser.Current_Pos;

--  END <Defer (for 'decl') at parser.lkt:22:64>


   exit when Defer_Pos180 = No_Token_Index;

   List_Pos27 := Defer_Pos180;
   Lst_Cpos27 := List_Pos27;

   Tmp_List27.Nodes.Append (Defer_Res180);

end loop;


declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List27.Nodes.Length;
begin
   List_Res27 := Allocate_Full_Decl_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Row_Pos123;
      Token_End := (if Lst_Cpos27 = Row_Pos123
                    then Row_Pos123
                    else List_Pos27 - 1);

   else
      Token_Start := Token_Index'Max (Row_Pos123, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res27,
      Kind              => Lkt_Full_Decl_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res27,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_Lkt_Node_Vectors.Vector renames
         Tmp_List27.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res27.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List27);

--  END <List (root of 'lexer_family_decl') at parser.lkt:22:58>




if List_Pos27 /= No_Token_Index then

   Row_Pos123 := List_Pos27;

else
   Row_Pos123 := No_Token_Index;
   goto Exit_Row123_0;

end if;


--  BEGIN <Token(<WithText RBrace>, ) (root of 'lexer_family_decl') at parser.lkt:22:70>

Token_Res184 := Row_Pos123;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res184));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_R_Brace)
   then
       Token_Pos184 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos123 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos123,
             Expected_Token_Id => Lkt_R_Brace,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos184 := Row_Pos123 + 1;
   end if;
end;

--  END <Token(<WithText RBrace>, ) (root of 'lexer_family_decl') at parser.lkt:22:70>




if Token_Pos184 /= No_Token_Index then

   Row_Pos123 := Token_Pos184;

else
   Row_Pos123 := No_Token_Index;
   goto Exit_Row123_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row123_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'lexer_family_decl') at parser.lkt:22:9>



if Row_Pos123 /= No_Token_Index then

   Transform_Res106 := Allocate_Lexer_Family_Decl (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res106,
      Kind => Lkt_Lexer_Family_Decl,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos122,
      Token_End_Index   => (if Row_Pos123 = Row_Pos122
                            then No_Token_Index
                            else Row_Pos123 - 1));

      
      Initialize_Fields_For_Lexer_Family_Decl
        (Self => Transform_Res106,
         Lexer_Family_Decl_F_Syn_Name => Defer_Res179,
         Lexer_Family_Decl_F_Rules => List_Res27);

         if Defer_Res179 /= null and then Is_Incomplete (Defer_Res179) then
            Transform_Res106.Last_Attempted_Child := 0;
         elsif Defer_Res179 /= null and then not Is_Ghost (Defer_Res179) then
            Transform_Res106.Last_Attempted_Child := -1;
         end if;
         if List_Res27 /= null and then Is_Incomplete (List_Res27) then
            Transform_Res106.Last_Attempted_Child := 0;
         elsif List_Res27 /= null and then not Is_Ghost (List_Res27) then
            Transform_Res106.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos123 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags106);
end if;

--  END <Transform(<ASTNodeType LexerFamilyDecl>) (root of 'lexer_family_decl') at parser.lkt:22:9>




if Row_Pos123 /= No_Token_Index then

   Row_Pos122 := Row_Pos123;

else
   Row_Pos122 := No_Token_Index;
   goto Exit_Row122_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row122_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'lexer_family_decl') at parser.lkt:19:26>



if Row_Pos122 /= No_Token_Index then

   Transform_Res107 := Allocate_Full_Decl (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res107,
      Kind => Lkt_Full_Decl,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos122 = Pos
                            then No_Token_Index
                            else Row_Pos122 - 1));

      
      Initialize_Fields_For_Full_Decl
        (Self => Transform_Res107,
         Full_Decl_F_Doc => Defer_Res177,
         Full_Decl_F_Decl_Annotations => List_Res26,
         Full_Decl_F_Decl => Transform_Res106);

         if Defer_Res177 /= null and then Is_Incomplete (Defer_Res177) then
            Transform_Res107.Last_Attempted_Child := 0;
         elsif Defer_Res177 /= null and then not Is_Ghost (Defer_Res177) then
            Transform_Res107.Last_Attempted_Child := -1;
         end if;
         if List_Res26 /= null and then Is_Incomplete (List_Res26) then
            Transform_Res107.Last_Attempted_Child := 0;
         elsif List_Res26 /= null and then not Is_Ghost (List_Res26) then
            Transform_Res107.Last_Attempted_Child := -1;
         end if;
         if Transform_Res106 /= null and then Is_Incomplete (Transform_Res106) then
            Transform_Res107.Last_Attempted_Child := 0;
         elsif Transform_Res106 /= null and then not Is_Ghost (Transform_Res106) then
            Transform_Res107.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos122 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags107);
end if;

--  END <Transform(<ASTNodeType FullDecl>) (root of 'lexer_family_decl') at parser.lkt:19:26>


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (PP.Lexer_Family_Decl_Transform_Parse1_Memo,
      Row_Pos122 /= No_Token_Index,
      Transform_Res107,
      Pos,
      Row_Pos122);


   Parser.Current_Pos := Row_Pos122;

   return Transform_Res107;
end Lexer_Family_Decl_Transform_Parse1;

   


function Lexer_Rule_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Lkt_Node
is
   use Bare_Lkt_Node_Memos;

      Defer_Pos181 :
            Token_Index
               := No_Token_Index;
      Defer_Res181 :
            Bare_Full_Decl
               := No_Bare_Lkt_Node;
      Defer_Pos182 :
            Token_Index
               := No_Token_Index;
      Defer_Res182 :
            Bare_Full_Decl
               := No_Bare_Lkt_Node;
      Defer_Pos183 :
            Token_Index
               := No_Token_Index;
      Defer_Res183 :
            Bare_Lexer_Case_Rule
               := No_Bare_Lkt_Node;
      Or_Pos28 :
            Token_Index
               := No_Token_Index;
      Or_Res28 :
            Bare_Lkt_Node
               := No_Bare_Lkt_Node;


   PP : constant Parser_Private_Part := +Parser.Private_Part;
   M  : Memo_Entry := Get (PP.Lexer_Rule_Or_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Or_Res28 := M.Instance;
      return Or_Res28;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Or_Res28;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  BEGIN <Or (root of 'lexer_rule') at parser.lkt:18:19>

Or_Pos28 := No_Token_Index;
Or_Res28 := No_Bare_Lkt_Node;
    
--  BEGIN <Defer (for 'lexer_family_decl') at parser.lkt:18:22>

Defer_Res181 :=
   Lexer_Family_Decl_Transform_Parse1 (Parser, Pos);
Defer_Pos181 := Parser.Current_Pos;

--  END <Defer (for 'lexer_family_decl') at parser.lkt:18:22>

    if Defer_Pos181 /= No_Token_Index then
        Or_Pos28 := Defer_Pos181;
        Or_Res28 := Defer_Res181;
        goto Exit_Or29;
    end if;
    
--  BEGIN <Defer (for 'decl') at parser.lkt:18:42>

Defer_Res182 :=
   Decl_Transform_Parse0 (Parser, Pos);
Defer_Pos182 := Parser.Current_Pos;

--  END <Defer (for 'decl') at parser.lkt:18:42>

    if Defer_Pos182 /= No_Token_Index then
        Or_Pos28 := Defer_Pos182;
        Or_Res28 := Defer_Res182;
        goto Exit_Or29;
    end if;
    
--  BEGIN <Defer (for 'lexer_case_rule') at parser.lkt:18:49>

Defer_Res183 :=
   Lexer_Case_Rule_Transform_Parse0 (Parser, Pos);
Defer_Pos183 := Parser.Current_Pos;

--  END <Defer (for 'lexer_case_rule') at parser.lkt:18:49>

    if Defer_Pos183 /= No_Token_Index then
        Or_Pos28 := Defer_Pos183;
        Or_Res28 := Defer_Res183;
        goto Exit_Or29;
    end if;
<<Exit_Or29>>

--  END <Or (root of 'lexer_rule') at parser.lkt:18:19>


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (PP.Lexer_Rule_Or_Parse0_Memo,
      Or_Pos28 /= No_Token_Index,
      Or_Res28,
      Pos,
      Or_Pos28);


   Parser.Current_Pos := Or_Pos28;

   return Or_Res28;
end Lexer_Rule_Or_Parse0;

   


function List_Pattern_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_List_Pattern
is
   use Bare_List_Pattern_Memos;

      Row_Pos124 :
            Token_Index
               := No_Token_Index;
      Token_Pos185 :
            Token_Index
               := No_Token_Index;
      Token_Res185 :
            Token_Index
               := No_Token_Index;
      Lst_Cpos28 :
            Token_Index
               := No_Token_Index;
      Tmp_List28 :
            Free_Parse_List;
      Defer_Pos184 :
            Token_Index
               := No_Token_Index;
      Defer_Res184 :
            Bare_Ellipsis_Pattern
               := No_Bare_Lkt_Node;
      Defer_Pos185 :
            Token_Index
               := No_Token_Index;
      Defer_Res185 :
            Bare_Pattern
               := No_Bare_Lkt_Node;
      Or_Pos29 :
            Token_Index
               := No_Token_Index;
      Or_Res29 :
            Bare_Pattern
               := No_Bare_Lkt_Node;
      Token_Pos186 :
            Token_Index
               := No_Token_Index;
      Token_Res186 :
            Token_Index
               := No_Token_Index;
      List_Pos28 :
            Token_Index
               := No_Token_Index;
      List_Res28 :
            Bare_Pattern_List
               := No_Bare_Lkt_Node;
      Token_Pos187 :
            Token_Index
               := No_Token_Index;
      Token_Res187 :
            Token_Index
               := No_Token_Index;
      Transform_Res108 :
            Bare_List_Pattern
               := No_Bare_Lkt_Node;
      Transform_Diags108 :
            Ada.Containers.Count_Type;


   PP : constant Parser_Private_Part := +Parser.Private_Part;
   M  : Memo_Entry := Get (PP.List_Pattern_Transform_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res108 := M.Instance;
      return Transform_Res108;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res108;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  BEGIN <Transform(<ASTNodeType ListPattern>) (root of 'list_pattern') at parser.lkt:281:21>

Transform_Diags108 := Parser.Diagnostics.Length;


--  BEGIN <_Row (root of 'list_pattern') at parser.lkt:281:21>

Row_Pos124 := Pos;



--  BEGIN <Token(<WithText LBrack>, ) (root of 'list_pattern') at parser.lkt:282:9>

Token_Res185 := Row_Pos124;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res185));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_L_Brack)
   then
       Token_Pos185 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos124 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos124,
             Expected_Token_Id => Lkt_L_Brack,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos185 := Row_Pos124 + 1;
   end if;
end;

--  END <Token(<WithText LBrack>, ) (root of 'list_pattern') at parser.lkt:282:9>




if Token_Pos185 /= No_Token_Index then

   Row_Pos124 := Token_Pos185;

else
   Row_Pos124 := No_Token_Index;
   goto Exit_Row124_0;

end if;


--  BEGIN <List (root of 'list_pattern') at parser.lkt:282:13>

    List_Pos28 := No_Token_Index;



Lst_Cpos28 := Row_Pos124;
Tmp_List28 := Get_Parse_List (Parser);


loop
   
--  BEGIN <Or (root of 'list_pattern') at parser.lkt:282:19>

Or_Pos29 := No_Token_Index;
Or_Res29 := No_Bare_Lkt_Node;
    
--  BEGIN <Defer (for 'ellipsis_pattern') at parser.lkt:282:22>

Defer_Res184 :=
   Ellipsis_Pattern_Transform_Parse0 (Parser, Lst_Cpos28);
Defer_Pos184 := Parser.Current_Pos;

--  END <Defer (for 'ellipsis_pattern') at parser.lkt:282:22>

    if Defer_Pos184 /= No_Token_Index then
        Or_Pos29 := Defer_Pos184;
        Or_Res29 := Defer_Res184;
        goto Exit_Or30;
    end if;
    
--  BEGIN <Defer (for 'value_pattern') at parser.lkt:282:41>

Defer_Res185 :=
   Value_Pattern_Or_Parse1 (Parser, Lst_Cpos28);
Defer_Pos185 := Parser.Current_Pos;

--  END <Defer (for 'value_pattern') at parser.lkt:282:41>

    if Defer_Pos185 /= No_Token_Index then
        Or_Pos29 := Defer_Pos185;
        Or_Res29 := Defer_Res185;
        goto Exit_Or30;
    end if;
<<Exit_Or30>>

--  END <Or (root of 'list_pattern') at parser.lkt:282:19>


   exit when Or_Pos29 = No_Token_Index;

   List_Pos28 := Or_Pos29;
   Lst_Cpos28 := List_Pos28;

   Tmp_List28.Nodes.Append (Or_Res29);

      
--  BEGIN <Token(<WithText Comma>, ) (root of 'list_pattern') at parser.lkt:282:57>

Token_Res186 := Lst_Cpos28;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res186));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_Comma)
   then
       Token_Pos186 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Lst_Cpos28 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Lst_Cpos28,
             Expected_Token_Id => Lkt_Comma,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos186 := Lst_Cpos28 + 1;
   end if;
end;

--  END <Token(<WithText Comma>, ) (root of 'list_pattern') at parser.lkt:282:57>


      exit when Token_Pos186 = No_Token_Index;

      Lst_Cpos28 := Token_Pos186;

end loop;


declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List28.Nodes.Length;
begin
   List_Res28 := Allocate_Pattern_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Row_Pos124;
      Token_End := (if Lst_Cpos28 = Row_Pos124
                    then Row_Pos124
                    else List_Pos28 - 1);

   else
      Token_Start := Token_Index'Max (Row_Pos124, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res28,
      Kind              => Lkt_Pattern_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res28,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_Lkt_Node_Vectors.Vector renames
         Tmp_List28.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res28.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List28);

--  END <List (root of 'list_pattern') at parser.lkt:282:13>




if List_Pos28 /= No_Token_Index then

   Row_Pos124 := List_Pos28;

else
   Row_Pos124 := No_Token_Index;
   goto Exit_Row124_0;

end if;


--  BEGIN <Token(<WithText RBrack>, ) (root of 'list_pattern') at parser.lkt:282:62>

Token_Res187 := Row_Pos124;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res187));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_R_Brack)
   then
       Token_Pos187 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos124 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos124,
             Expected_Token_Id => Lkt_R_Brack,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos187 := Row_Pos124 + 1;
   end if;
end;

--  END <Token(<WithText RBrack>, ) (root of 'list_pattern') at parser.lkt:282:62>




if Token_Pos187 /= No_Token_Index then

   Row_Pos124 := Token_Pos187;

else
   Row_Pos124 := No_Token_Index;
   goto Exit_Row124_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row124_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'list_pattern') at parser.lkt:281:21>



if Row_Pos124 /= No_Token_Index then

   Transform_Res108 := Allocate_List_Pattern (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res108,
      Kind => Lkt_List_Pattern,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos124 = Pos
                            then No_Token_Index
                            else Row_Pos124 - 1));

      
      Initialize_Fields_For_List_Pattern
        (Self => Transform_Res108,
         List_Pattern_F_Sub_Patterns => List_Res28);

         if List_Res28 /= null and then Is_Incomplete (List_Res28) then
            Transform_Res108.Last_Attempted_Child := 0;
         elsif List_Res28 /= null and then not Is_Ghost (List_Res28) then
            Transform_Res108.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos124 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags108);
end if;

--  END <Transform(<ASTNodeType ListPattern>) (root of 'list_pattern') at parser.lkt:281:21>


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (PP.List_Pattern_Transform_Parse0_Memo,
      Row_Pos124 /= No_Token_Index,
      Transform_Res108,
      Pos,
      Row_Pos124);


   Parser.Current_Pos := Row_Pos124;

   return Transform_Res108;
end List_Pattern_Transform_Parse0;

   


function Logic_Propagate_Call_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Logic_Propagate_Call
is
   use Bare_Logic_Propagate_Call_Memos;

      Row_Pos125 :
            Token_Index
               := No_Token_Index;
      Defer_Pos186 :
            Token_Index
               := No_Token_Index;
      Defer_Res186 :
            Bare_Expr
               := No_Bare_Lkt_Node;
      Token_Pos188 :
            Token_Index
               := No_Token_Index;
      Token_Res188 :
            Token_Index
               := No_Token_Index;
      Token_Pos189 :
            Token_Index
               := No_Token_Index;
      Token_Res189 :
            Token_Index
               := No_Token_Index;
      Defer_Pos187 :
            Token_Index
               := No_Token_Index;
      Defer_Res187 :
            Bare_Argument_List
               := No_Bare_Lkt_Node;
      Token_Pos190 :
            Token_Index
               := No_Token_Index;
      Token_Res190 :
            Token_Index
               := No_Token_Index;
      Transform_Res109 :
            Bare_Logic_Propagate_Call
               := No_Bare_Lkt_Node;
      Transform_Diags109 :
            Ada.Containers.Count_Type;


   PP : constant Parser_Private_Part := +Parser.Private_Part;
   M  : Memo_Entry := Get (PP.Logic_Propagate_Call_Transform_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res109 := M.Instance;
      return Transform_Res109;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res109;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  BEGIN <Transform(<ASTNodeType LogicPropagateCall>) (root of 'logic_propagate_call') at parser.lkt:343:29>

Transform_Diags109 := Parser.Diagnostics.Length;


--  BEGIN <_Row (root of 'logic_propagate_call') at parser.lkt:343:29>

Row_Pos125 := Pos;



--  BEGIN <Defer (for 'callable_ref') at parser.lkt:343:48>

Defer_Res186 :=
   Callable_Ref_Or_Parse0 (Parser, Row_Pos125);
Defer_Pos186 := Parser.Current_Pos;

--  END <Defer (for 'callable_ref') at parser.lkt:343:48>




if Defer_Pos186 /= No_Token_Index then

   Row_Pos125 := Defer_Pos186;

else
   Row_Pos125 := No_Token_Index;
   goto Exit_Row125_0;

end if;


--  BEGIN <Token(<WithText Percent>, ) (root of 'logic_propagate_call') at parser.lkt:343:61>

Token_Res188 := Row_Pos125;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res188));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_Percent)
   then
       Token_Pos188 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos125 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos125,
             Expected_Token_Id => Lkt_Percent,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos188 := Row_Pos125 + 1;
   end if;
end;

--  END <Token(<WithText Percent>, ) (root of 'logic_propagate_call') at parser.lkt:343:61>




if Token_Pos188 /= No_Token_Index then

   Row_Pos125 := Token_Pos188;

else
   Row_Pos125 := No_Token_Index;
   goto Exit_Row125_0;

end if;


--  BEGIN <Token(<WithText LPar>, ) (root of 'logic_propagate_call') at parser.lkt:343:65>

Token_Res189 := Row_Pos125;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res189));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_L_Par)
   then
       Token_Pos189 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos125 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos125,
             Expected_Token_Id => Lkt_L_Par,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos189 := Row_Pos125 + 1;
   end if;
end;

--  END <Token(<WithText LPar>, ) (root of 'logic_propagate_call') at parser.lkt:343:65>




if Token_Pos189 /= No_Token_Index then

   Row_Pos125 := Token_Pos189;

else
   Row_Pos125 := No_Token_Index;
   goto Exit_Row125_0;

end if;


--  BEGIN <Defer (for 'args') at parser.lkt:343:69>

Defer_Res187 :=
   Args_List_Parse0 (Parser, Row_Pos125);
Defer_Pos187 := Parser.Current_Pos;

--  END <Defer (for 'args') at parser.lkt:343:69>




if Defer_Pos187 /= No_Token_Index then

   Row_Pos125 := Defer_Pos187;

else
   Row_Pos125 := No_Token_Index;
   goto Exit_Row125_0;

end if;


--  BEGIN <Token(<WithText RPar>, ) (root of 'logic_propagate_call') at parser.lkt:343:74>

Token_Res190 := Row_Pos125;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res190));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_R_Par)
   then
       Token_Pos190 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos125 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos125,
             Expected_Token_Id => Lkt_R_Par,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos190 := Row_Pos125 + 1;
   end if;
end;

--  END <Token(<WithText RPar>, ) (root of 'logic_propagate_call') at parser.lkt:343:74>




if Token_Pos190 /= No_Token_Index then

   Row_Pos125 := Token_Pos190;

else
   Row_Pos125 := No_Token_Index;
   goto Exit_Row125_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row125_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'logic_propagate_call') at parser.lkt:343:29>



if Row_Pos125 /= No_Token_Index then

   Transform_Res109 := Allocate_Logic_Propagate_Call (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res109,
      Kind => Lkt_Logic_Propagate_Call,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos125 = Pos
                            then No_Token_Index
                            else Row_Pos125 - 1));

      
      Initialize_Fields_For_Logic_Propagate_Call
        (Self => Transform_Res109,
         Base_Call_Expr_F_Name => Defer_Res186,
         Base_Call_Expr_F_Args => Defer_Res187);

         if Defer_Res186 /= null and then Is_Incomplete (Defer_Res186) then
            Transform_Res109.Last_Attempted_Child := 0;
         elsif Defer_Res186 /= null and then not Is_Ghost (Defer_Res186) then
            Transform_Res109.Last_Attempted_Child := -1;
         end if;
         if Defer_Res187 /= null and then Is_Incomplete (Defer_Res187) then
            Transform_Res109.Last_Attempted_Child := 0;
         elsif Defer_Res187 /= null and then not Is_Ghost (Defer_Res187) then
            Transform_Res109.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos125 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags109);
end if;

--  END <Transform(<ASTNodeType LogicPropagateCall>) (root of 'logic_propagate_call') at parser.lkt:343:29>


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (PP.Logic_Propagate_Call_Transform_Parse0_Memo,
      Row_Pos125 /= No_Token_Index,
      Transform_Res109,
      Pos,
      Row_Pos125);


   Parser.Current_Pos := Row_Pos125;

   return Transform_Res109;
end Logic_Propagate_Call_Transform_Parse0;

   


function Main_Rule_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Langkit_Root
is
   use Bare_Langkit_Root_Memos;

      Row_Pos126 :
            Token_Index
               := No_Token_Index;
      Defer_Pos188 :
            Token_Index
               := No_Token_Index;
      Defer_Res188 :
            Bare_Import_List
               := No_Bare_Lkt_Node;
      Defer_Pos189 :
            Token_Index
               := No_Token_Index;
      Defer_Res189 :
            Bare_Full_Decl_List
               := No_Bare_Lkt_Node;
      Token_Pos191 :
            Token_Index
               := No_Token_Index;
      Token_Res191 :
            Token_Index
               := No_Token_Index;
      Transform_Res110 :
            Bare_Langkit_Root
               := No_Bare_Lkt_Node;
      Transform_Diags110 :
            Ada.Containers.Count_Type;


   PP : constant Parser_Private_Part := +Parser.Private_Part;
   M  : Memo_Entry := Get (PP.Main_Rule_Transform_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res110 := M.Instance;
      return Transform_Res110;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res110;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  BEGIN <Transform(<ASTNodeType LangkitRoot>) (root of 'main_rule') at parser.lkt:5:18>

Transform_Diags110 := Parser.Diagnostics.Length;


--  BEGIN <_Row (root of 'main_rule') at parser.lkt:5:18>

Row_Pos126 := Pos;



--  BEGIN <Defer (for 'imports') at parser.lkt:5:30>

Defer_Res188 :=
   Imports_List_Parse0 (Parser, Row_Pos126);
Defer_Pos188 := Parser.Current_Pos;

--  END <Defer (for 'imports') at parser.lkt:5:30>




if Defer_Pos188 /= No_Token_Index then

   Row_Pos126 := Defer_Pos188;

else
   Row_Pos126 := No_Token_Index;
   goto Exit_Row126_0;

end if;


--  BEGIN <Defer (for 'decls') at parser.lkt:5:38>

Defer_Res189 :=
   Decls_List_Parse0 (Parser, Row_Pos126);
Defer_Pos189 := Parser.Current_Pos;

--  END <Defer (for 'decls') at parser.lkt:5:38>




if Defer_Pos189 /= No_Token_Index then

   Row_Pos126 := Defer_Pos189;

else
   Row_Pos126 := No_Token_Index;
   goto Exit_Row126_0;

end if;


--  BEGIN <Token(<WithText Termination>, ) (root of 'main_rule') at parser.lkt:5:44>

Token_Res191 := Row_Pos126;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res191));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_Termination)
   then
       Token_Pos191 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos126 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos126,
             Expected_Token_Id => Lkt_Termination,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos191 := Row_Pos126;
   end if;
end;

--  END <Token(<WithText Termination>, ) (root of 'main_rule') at parser.lkt:5:44>




if Token_Pos191 /= No_Token_Index then

   Row_Pos126 := Token_Pos191;

else
   Row_Pos126 := No_Token_Index;
   goto Exit_Row126_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row126_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'main_rule') at parser.lkt:5:18>



if Row_Pos126 /= No_Token_Index then

   Transform_Res110 := Allocate_Langkit_Root (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res110,
      Kind => Lkt_Langkit_Root,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos126 = Pos
                            then No_Token_Index
                            else Row_Pos126 - 1));

      
      Initialize_Fields_For_Langkit_Root
        (Self => Transform_Res110,
         Langkit_Root_F_Imports => Defer_Res188,
         Langkit_Root_F_Decls => Defer_Res189);

         if Defer_Res188 /= null and then Is_Incomplete (Defer_Res188) then
            Transform_Res110.Last_Attempted_Child := 0;
         elsif Defer_Res188 /= null and then not Is_Ghost (Defer_Res188) then
            Transform_Res110.Last_Attempted_Child := -1;
         end if;
         if Defer_Res189 /= null and then Is_Incomplete (Defer_Res189) then
            Transform_Res110.Last_Attempted_Child := 0;
         elsif Defer_Res189 /= null and then not Is_Ghost (Defer_Res189) then
            Transform_Res110.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos126 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags110);
end if;

--  END <Transform(<ASTNodeType LangkitRoot>) (root of 'main_rule') at parser.lkt:5:18>


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (PP.Main_Rule_Transform_Parse0_Memo,
      Row_Pos126 /= No_Token_Index,
      Transform_Res110,
      Pos,
      Row_Pos126);


   Parser.Current_Pos := Row_Pos126;

   return Transform_Res110;
end Main_Rule_Transform_Parse0;

   


function Match_Expr_Transform_Parse3
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Match_Expr
is
   use Bare_Match_Expr_Memos;

      Row_Pos127 :
            Token_Index
               := No_Token_Index;
      Token_Pos192 :
            Token_Index
               := No_Token_Index;
      Token_Res192 :
            Token_Index
               := No_Token_Index;
      Defer_Pos190 :
            Token_Index
               := No_Token_Index;
      Defer_Res190 :
            Bare_Expr
               := No_Bare_Lkt_Node;
      Token_Pos193 :
            Token_Index
               := No_Token_Index;
      Token_Res193 :
            Token_Index
               := No_Token_Index;
      Lst_Cpos29 :
            Token_Index
               := No_Token_Index;
      Tmp_List29 :
            Free_Parse_List;
      Row_Pos128 :
            Token_Index
               := No_Token_Index;
      Token_Pos194 :
            Token_Index
               := No_Token_Index;
      Token_Res194 :
            Token_Index
               := No_Token_Index;
      Defer_Pos191 :
            Token_Index
               := No_Token_Index;
      Defer_Res191 :
            Bare_Pattern
               := No_Bare_Lkt_Node;
      Token_Pos195 :
            Token_Index
               := No_Token_Index;
      Token_Res195 :
            Token_Index
               := No_Token_Index;
      Defer_Pos192 :
            Token_Index
               := No_Token_Index;
      Defer_Res192 :
            Bare_Expr
               := No_Bare_Lkt_Node;
      Transform_Res111 :
            Bare_Pattern_Match_Branch
               := No_Bare_Lkt_Node;
      Transform_Diags111 :
            Ada.Containers.Count_Type;
      Row_Pos129 :
            Token_Index
               := No_Token_Index;
      Token_Pos196 :
            Token_Index
               := No_Token_Index;
      Token_Res196 :
            Token_Index
               := No_Token_Index;
      Row_Pos130 :
            Token_Index
               := No_Token_Index;
      Defer_Pos193 :
            Token_Index
               := No_Token_Index;
      Defer_Res193 :
            Bare_Def_Id
               := No_Bare_Lkt_Node;
      Row_Pos131 :
            Token_Index
               := No_Token_Index;
      Token_Pos197 :
            Token_Index
               := No_Token_Index;
      Token_Res197 :
            Token_Index
               := No_Token_Index;
      Defer_Pos194 :
            Token_Index
               := No_Token_Index;
      Defer_Res194 :
            Bare_Type_Ref
               := No_Bare_Lkt_Node;
      Transform_Res112 :
            Bare_Match_Val_Decl
               := No_Bare_Lkt_Node;
      Transform_Diags112 :
            Ada.Containers.Count_Type;
      Token_Pos198 :
            Token_Index
               := No_Token_Index;
      Token_Res198 :
            Token_Index
               := No_Token_Index;
      Defer_Pos195 :
            Token_Index
               := No_Token_Index;
      Defer_Res195 :
            Bare_Expr
               := No_Bare_Lkt_Node;
      Transform_Res113 :
            Bare_Match_Branch
               := No_Bare_Lkt_Node;
      Transform_Diags113 :
            Ada.Containers.Count_Type;
      Or_Pos30 :
            Token_Index
               := No_Token_Index;
      Or_Res30 :
            Bare_Base_Match_Branch
               := No_Bare_Lkt_Node;
      List_Pos29 :
            Token_Index
               := No_Token_Index;
      List_Res29 :
            Bare_Base_Match_Branch_List
               := No_Bare_Lkt_Node;
      Token_Pos199 :
            Token_Index
               := No_Token_Index;
      Token_Res199 :
            Token_Index
               := No_Token_Index;
      Transform_Res114 :
            Bare_Match_Expr
               := No_Bare_Lkt_Node;
      Transform_Diags114 :
            Ada.Containers.Count_Type;


   PP : constant Parser_Private_Part := +Parser.Private_Part;
   M  : Memo_Entry := Get (PP.Match_Expr_Transform_Parse3_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res114 := M.Instance;
      return Transform_Res114;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res114;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  BEGIN <Transform(<ASTNodeType MatchExpr>) (root of 'match_expr') at parser.lkt:345:19>

Transform_Diags114 := Parser.Diagnostics.Length;


--  BEGIN <_Row (root of 'match_expr') at parser.lkt:345:19>

Row_Pos127 := Pos;



--  BEGIN <Token(<WithText MatchKw>, ) (root of 'match_expr') at parser.lkt:346:9>

Token_Res192 := Row_Pos127;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res192));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_Match_Kw)
   then
       Token_Pos192 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos127 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos127,
             Expected_Token_Id => Lkt_Match_Kw,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos192 := Row_Pos127 + 1;
   end if;
end;

--  END <Token(<WithText MatchKw>, ) (root of 'match_expr') at parser.lkt:346:9>




if Token_Pos192 /= No_Token_Index then

   Row_Pos127 := Token_Pos192;

else
   Row_Pos127 := No_Token_Index;
   goto Exit_Row127_0;

end if;


--  BEGIN <Defer (for 'expr') at parser.lkt:347:9>

Defer_Res190 :=
   Expr_Or_Parse1 (Parser, Row_Pos127);
Defer_Pos190 := Parser.Current_Pos;

--  END <Defer (for 'expr') at parser.lkt:347:9>




if Defer_Pos190 /= No_Token_Index then

   Row_Pos127 := Defer_Pos190;

else
   Row_Pos127 := No_Token_Index;
   goto Exit_Row127_0;

end if;


--  BEGIN <Token(<WithText LBrace>, ) (root of 'match_expr') at parser.lkt:348:9>

Token_Res193 := Row_Pos127;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res193));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_L_Brace)
   then
       Token_Pos193 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos127 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos127,
             Expected_Token_Id => Lkt_L_Brace,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos193 := Row_Pos127 + 1;
   end if;
end;

--  END <Token(<WithText LBrace>, ) (root of 'match_expr') at parser.lkt:348:9>




if Token_Pos193 /= No_Token_Index then

   Row_Pos127 := Token_Pos193;

else
   Row_Pos127 := No_Token_Index;
   goto Exit_Row127_0;

end if;


--  BEGIN <List (root of 'match_expr') at parser.lkt:349:9>

    List_Pos29 := No_Token_Index;



Lst_Cpos29 := Row_Pos127;
Tmp_List29 := Get_Parse_List (Parser);


loop
   
--  BEGIN <Or (root of 'match_expr') at parser.lkt:349:15>

Or_Pos30 := No_Token_Index;
Or_Res30 := No_Bare_Lkt_Node;
    
--  BEGIN <Transform(<ASTNodeType PatternMatchBranch>) (root of 'match_expr') at parser.lkt:350:15>

Transform_Diags111 := Parser.Diagnostics.Length;


--  BEGIN <_Row (root of 'match_expr') at parser.lkt:350:15>

Row_Pos128 := Lst_Cpos29;



--  BEGIN <Token(<WithText CaseKw>, ) (root of 'match_expr') at parser.lkt:350:34>

Token_Res194 := Row_Pos128;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res194));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_Case_Kw)
   then
       Token_Pos194 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos128 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos128,
             Expected_Token_Id => Lkt_Case_Kw,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos194 := Row_Pos128 + 1;
   end if;
end;

--  END <Token(<WithText CaseKw>, ) (root of 'match_expr') at parser.lkt:350:34>




if Token_Pos194 /= No_Token_Index then

   Row_Pos128 := Token_Pos194;

else
   Row_Pos128 := No_Token_Index;
   goto Exit_Row128_0;

end if;


--  BEGIN <Defer (for 'pattern') at parser.lkt:350:41>

Defer_Res191 :=
   Pattern_Or_Parse0 (Parser, Row_Pos128);
Defer_Pos191 := Parser.Current_Pos;

--  END <Defer (for 'pattern') at parser.lkt:350:41>




if Defer_Pos191 /= No_Token_Index then

   Row_Pos128 := Defer_Pos191;

else
   Row_Pos128 := No_Token_Index;
   goto Exit_Row128_0;

end if;


--  BEGIN <Token(<WithText FatRightArrow>, ) (root of 'match_expr') at parser.lkt:350:49>

Token_Res195 := Row_Pos128;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res195));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_Fat_Right_Arrow)
   then
       Token_Pos195 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos128 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos128,
             Expected_Token_Id => Lkt_Fat_Right_Arrow,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos195 := Row_Pos128 + 1;
   end if;
end;

--  END <Token(<WithText FatRightArrow>, ) (root of 'match_expr') at parser.lkt:350:49>




if Token_Pos195 /= No_Token_Index then

   Row_Pos128 := Token_Pos195;

else
   Row_Pos128 := No_Token_Index;
   goto Exit_Row128_0;

end if;


--  BEGIN <Defer (for 'expr') at parser.lkt:350:54>

Defer_Res192 :=
   Expr_Or_Parse1 (Parser, Row_Pos128);
Defer_Pos192 := Parser.Current_Pos;

--  END <Defer (for 'expr') at parser.lkt:350:54>




if Defer_Pos192 /= No_Token_Index then

   Row_Pos128 := Defer_Pos192;

else
   Row_Pos128 := No_Token_Index;
   goto Exit_Row128_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row128_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'match_expr') at parser.lkt:350:15>



if Row_Pos128 /= No_Token_Index then

   Transform_Res111 := Allocate_Pattern_Match_Branch (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res111,
      Kind => Lkt_Pattern_Match_Branch,
      Unit => Parser.Unit,

      Token_Start_Index => Lst_Cpos29,
      Token_End_Index   => (if Row_Pos128 = Lst_Cpos29
                            then No_Token_Index
                            else Row_Pos128 - 1));

      
      Initialize_Fields_For_Pattern_Match_Branch
        (Self => Transform_Res111,
         Pattern_Match_Branch_F_Pattern => Defer_Res191,
         Pattern_Match_Branch_F_Expr => Defer_Res192);

         if Defer_Res191 /= null and then Is_Incomplete (Defer_Res191) then
            Transform_Res111.Last_Attempted_Child := 0;
         elsif Defer_Res191 /= null and then not Is_Ghost (Defer_Res191) then
            Transform_Res111.Last_Attempted_Child := -1;
         end if;
         if Defer_Res192 /= null and then Is_Incomplete (Defer_Res192) then
            Transform_Res111.Last_Attempted_Child := 0;
         elsif Defer_Res192 /= null and then not Is_Ghost (Defer_Res192) then
            Transform_Res111.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos128 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags111);
end if;

--  END <Transform(<ASTNodeType PatternMatchBranch>) (root of 'match_expr') at parser.lkt:350:15>

    if Row_Pos128 /= No_Token_Index then
        Or_Pos30 := Row_Pos128;
        Or_Res30 := Transform_Res111;
        goto Exit_Or31;
    end if;
    
--  BEGIN <Transform(<ASTNodeType MatchBranch>) (root of 'match_expr') at parser.lkt:351:15>

Transform_Diags113 := Parser.Diagnostics.Length;


--  BEGIN <_Row (root of 'match_expr') at parser.lkt:351:15>

Row_Pos129 := Lst_Cpos29;



--  BEGIN <Token(<WithText CaseKw>, ) (root of 'match_expr') at parser.lkt:352:17>

Token_Res196 := Row_Pos129;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res196));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_Case_Kw)
   then
       Token_Pos196 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos129 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos129,
             Expected_Token_Id => Lkt_Case_Kw,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos196 := Row_Pos129 + 1;
   end if;
end;

--  END <Token(<WithText CaseKw>, ) (root of 'match_expr') at parser.lkt:352:17>




if Token_Pos196 /= No_Token_Index then

   Row_Pos129 := Token_Pos196;

else
   Row_Pos129 := No_Token_Index;
   goto Exit_Row129_0;

end if;


--  BEGIN <Transform(<ASTNodeType MatchValDecl>) (root of 'match_expr') at parser.lkt:352:24>

Transform_Diags112 := Parser.Diagnostics.Length;


--  BEGIN <_Row (root of 'match_expr') at parser.lkt:352:24>

Row_Pos130 := Row_Pos129;



--  BEGIN <Defer (for 'def_id') at parser.lkt:352:37>

Defer_Res193 :=
   Def_Id_Transform_Parse0 (Parser, Row_Pos130);
Defer_Pos193 := Parser.Current_Pos;

--  END <Defer (for 'def_id') at parser.lkt:352:37>




if Defer_Pos193 /= No_Token_Index then

   Row_Pos130 := Defer_Pos193;

else
   Row_Pos130 := No_Token_Index;
   goto Exit_Row130_0;

end if;


--  BEGIN <Opt (root of 'match_expr') at parser.lkt:352:44>












--  BEGIN <_Extract (root of 'match_expr') at parser.lkt:352:45>

--  BEGIN <_Row (root of 'match_expr') at parser.lkt:352:45>

Row_Pos131 := Row_Pos130;



--  BEGIN <Token(<WithText Colon>, ) (root of 'match_expr') at parser.lkt:352:50>

Token_Res197 := Row_Pos131;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res197));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_Colon)
   then
       Token_Pos197 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos131 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos131,
             Expected_Token_Id => Lkt_Colon,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos197 := Row_Pos131 + 1;
   end if;
end;

--  END <Token(<WithText Colon>, ) (root of 'match_expr') at parser.lkt:352:50>




if Token_Pos197 /= No_Token_Index then

   Row_Pos131 := Token_Pos197;

else
   Row_Pos131 := No_Token_Index;
   goto Exit_Row131_0;

end if;


--  BEGIN <Defer (for 'type_ref') at parser.lkt:352:54>

Defer_Res194 :=
   Type_Ref_Or_Parse0 (Parser, Row_Pos131);
Defer_Pos194 := Parser.Current_Pos;

--  END <Defer (for 'type_ref') at parser.lkt:352:54>




if Defer_Pos194 /= No_Token_Index then

   Row_Pos131 := Defer_Pos194;

else
   Row_Pos131 := No_Token_Index;
   goto Exit_Row131_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row131_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'match_expr') at parser.lkt:352:45>

--  END <_Extract (root of 'match_expr') at parser.lkt:352:45>


if Row_Pos131 = No_Token_Index then

         
   Defer_Res194 := No_Bare_Lkt_Node;



       
   Row_Pos131 := Row_Pos130;



end if;

--  END <Opt (root of 'match_expr') at parser.lkt:352:44>




if Row_Pos131 /= No_Token_Index then

   Row_Pos130 := Row_Pos131;

else
   Row_Pos130 := No_Token_Index;
   goto Exit_Row130_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row130_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'match_expr') at parser.lkt:352:24>



if Row_Pos130 /= No_Token_Index then

   Transform_Res112 := Allocate_Match_Val_Decl (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res112,
      Kind => Lkt_Match_Val_Decl,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos129,
      Token_End_Index   => (if Row_Pos130 = Row_Pos129
                            then No_Token_Index
                            else Row_Pos130 - 1));

      
      Initialize_Fields_For_Match_Val_Decl
        (Self => Transform_Res112,
         Match_Val_Decl_F_Syn_Name => Defer_Res193,
         Match_Val_Decl_F_Decl_Type => Defer_Res194);

         if Defer_Res193 /= null and then Is_Incomplete (Defer_Res193) then
            Transform_Res112.Last_Attempted_Child := 0;
         elsif Defer_Res193 /= null and then not Is_Ghost (Defer_Res193) then
            Transform_Res112.Last_Attempted_Child := -1;
         end if;
         if Defer_Res194 /= null and then Is_Incomplete (Defer_Res194) then
            Transform_Res112.Last_Attempted_Child := 0;
         elsif Defer_Res194 /= null and then not Is_Ghost (Defer_Res194) then
            Transform_Res112.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos130 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags112);
end if;

--  END <Transform(<ASTNodeType MatchValDecl>) (root of 'match_expr') at parser.lkt:352:24>




if Row_Pos130 /= No_Token_Index then

   Row_Pos129 := Row_Pos130;

else
   Row_Pos129 := No_Token_Index;
   goto Exit_Row129_0;

end if;


--  BEGIN <Token(<WithText FatRightArrow>, ) (root of 'match_expr') at parser.lkt:352:65>

Token_Res198 := Row_Pos129;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res198));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_Fat_Right_Arrow)
   then
       Token_Pos198 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos129 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos129,
             Expected_Token_Id => Lkt_Fat_Right_Arrow,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos198 := Row_Pos129 + 1;
   end if;
end;

--  END <Token(<WithText FatRightArrow>, ) (root of 'match_expr') at parser.lkt:352:65>




if Token_Pos198 /= No_Token_Index then

   Row_Pos129 := Token_Pos198;

else
   Row_Pos129 := No_Token_Index;
   goto Exit_Row129_0;

end if;


--  BEGIN <Defer (for 'expr') at parser.lkt:352:70>

Defer_Res195 :=
   Expr_Or_Parse1 (Parser, Row_Pos129);
Defer_Pos195 := Parser.Current_Pos;

--  END <Defer (for 'expr') at parser.lkt:352:70>




if Defer_Pos195 /= No_Token_Index then

   Row_Pos129 := Defer_Pos195;

else
   Row_Pos129 := No_Token_Index;
   goto Exit_Row129_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row129_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'match_expr') at parser.lkt:351:15>



if Row_Pos129 /= No_Token_Index then

   Transform_Res113 := Allocate_Match_Branch (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res113,
      Kind => Lkt_Match_Branch,
      Unit => Parser.Unit,

      Token_Start_Index => Lst_Cpos29,
      Token_End_Index   => (if Row_Pos129 = Lst_Cpos29
                            then No_Token_Index
                            else Row_Pos129 - 1));

      
      Initialize_Fields_For_Match_Branch
        (Self => Transform_Res113,
         Match_Branch_F_Decl => Transform_Res112,
         Match_Branch_F_Expr => Defer_Res195);

         if Transform_Res112 /= null and then Is_Incomplete (Transform_Res112) then
            Transform_Res113.Last_Attempted_Child := 0;
         elsif Transform_Res112 /= null and then not Is_Ghost (Transform_Res112) then
            Transform_Res113.Last_Attempted_Child := -1;
         end if;
         if Defer_Res195 /= null and then Is_Incomplete (Defer_Res195) then
            Transform_Res113.Last_Attempted_Child := 0;
         elsif Defer_Res195 /= null and then not Is_Ghost (Defer_Res195) then
            Transform_Res113.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos129 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags113);
end if;

--  END <Transform(<ASTNodeType MatchBranch>) (root of 'match_expr') at parser.lkt:351:15>

    if Row_Pos129 /= No_Token_Index then
        Or_Pos30 := Row_Pos129;
        Or_Res30 := Transform_Res113;
        goto Exit_Or31;
    end if;
<<Exit_Or31>>

--  END <Or (root of 'match_expr') at parser.lkt:349:15>


   exit when Or_Pos30 = No_Token_Index;

   List_Pos29 := Or_Pos30;
   Lst_Cpos29 := List_Pos29;

   Tmp_List29.Nodes.Append (Or_Res30);

end loop;


declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List29.Nodes.Length;
begin
   List_Res29 := Allocate_Base_Match_Branch_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Row_Pos127;
      Token_End := (if Lst_Cpos29 = Row_Pos127
                    then Row_Pos127
                    else List_Pos29 - 1);

   else
      Token_Start := Token_Index'Max (Row_Pos127, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res29,
      Kind              => Lkt_Base_Match_Branch_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res29,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_Lkt_Node_Vectors.Vector renames
         Tmp_List29.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res29.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List29);

--  END <List (root of 'match_expr') at parser.lkt:349:9>




if List_Pos29 /= No_Token_Index then

   Row_Pos127 := List_Pos29;

else
   Row_Pos127 := No_Token_Index;
   goto Exit_Row127_0;

end if;


--  BEGIN <Token(<WithText RBrace>, ) (root of 'match_expr') at parser.lkt:355:9>

Token_Res199 := Row_Pos127;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res199));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_R_Brace)
   then
       Token_Pos199 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos127 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos127,
             Expected_Token_Id => Lkt_R_Brace,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos199 := Row_Pos127 + 1;
   end if;
end;

--  END <Token(<WithText RBrace>, ) (root of 'match_expr') at parser.lkt:355:9>




if Token_Pos199 /= No_Token_Index then

   Row_Pos127 := Token_Pos199;

else
   Row_Pos127 := No_Token_Index;
   goto Exit_Row127_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row127_0>>
pragma Warnings (On, "referenced");

--  END <_Row (root of 'match_expr') at parser.lkt:345:19>



if Row_Pos127 /= No_Token_Index then

   Transform_Res114 := Allocate_Match_Expr (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res114,
      Kind => Lkt_Match_Expr,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos127 = Pos
                            then No_Token_Index
                            else Row_Pos127 - 1));

      
      Initialize_Fields_For_Match_Expr
        (Self => Transform_Res114,
         Match_Expr_F_Match_Expr => Defer_Res190,
         Match_Expr_F_Branches => List_Res29);

         if Defer_Res190 /= null and then Is_Incomplete (Defer_Res190) then
            Transform_Res114.Last_Attempted_Child := 0;
         elsif Defer_Res190 /= null and then not Is_Ghost (Defer_Res190) then
            Transform_Res114.Last_Attempted_Child := -1;
         end if;
         if List_Res29 /= null and then Is_Incomplete (List_Res29) then
            Transform_Res114.Last_Attempted_Child := 0;
         elsif List_Res29 /= null and then not Is_Ghost (List_Res29) then
            Transform_Res114.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos127 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags114);
end if;

--  END <Transform(<ASTNodeType MatchExpr>) (root of 'match_expr') at parser.lkt:345:19>


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (PP.Match_Expr_Transform_Parse3_Memo,
      Row_Pos127 /= No_Token_Index,
      Transform_Res114,
      Pos,
      Row_Pos127);


   Parser.Current_Pos := Row_Pos127;

   return Transform_Res114;
end Match_Expr_Transform_Parse3;

   


function Null_Cond_Qual_Opt_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Null_Cond_Qualifier
is
   use Bare_Null_Cond_Qualifier_Memos;

      Token_Pos200 :
            Token_Index
               := No_Token_Index;
      Token_Res200 :
            Token_Index
               := No_Token_Index;
      Opt_Res2 :
            Bare_Null_Cond_Qualifier
               := No_Bare_Lkt_Node;


   PP : constant Parser_Private_Part := +Parser.Private_Part;
   M  : Memo_Entry := Get (PP.Null_Cond_Qual_Opt_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Opt_Res2 := M.Instance;
      return Opt_Res2;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Opt_Res2;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  BEGIN <Opt (root of 'null_cond_qual') at parser.lkt:383:23>












--  BEGIN <Token(<WithText IntMark>, ) (root of 'null_cond_qual') at parser.lkt:383:41>

Token_Res200 := Pos;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res200));
begin
   if
      T.Kind /= From_Token_Kind (Lkt_Int_Mark)
   then
       Token_Pos200 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Pos then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Pos,
             Expected_Token_Id => Lkt_Int_Mark,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos200 := Pos + 1;
   end if;
end;

--  END <Token(<WithText IntMark>, ) (root of 'null_cond_qual') at parser.lkt:383:41>


if Token_Pos200 = No_Token_Index then

         Opt_Res2 := Allocate_Null_Cond_Qualifier_Absent (Parser.Mem_Pool);
         Initialize
           (Self              => Opt_Res2,
            Kind              => Lkt_Null_Cond_Qualifier_Absent,
            Unit              => Parser.Unit,
            Token_Start_Index => Pos,
            Token_End_Index   => No_Token_Index);


       
   Token_Pos200 := Pos;


else

      Opt_Res2 := Allocate_Null_Cond_Qualifier_Present (Parser.Mem_Pool);
      Initialize
        (Self              => Opt_Res2,
         Kind              => Lkt_Null_Cond_Qualifier_Present,
         Unit              => Parser.Unit,
         Token_Start_Index => Pos,
         Token_End_Index   => Token_Pos200 - 1);

end if;

--  END <Opt (root of 'null_cond_qual') at parser.lkt:383:23>


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (PP.Null_Cond_Qual_Opt_Parse0_Memo,
      Token_Pos200 /= No_Token_Index,
      Opt_Res2,
      Pos,
      Token_Pos200);


   Parser.Current_Pos := Token_Pos200;

   return Opt_Res2;
end Null_Cond_Qual_Opt_Parse0;

   


function Null_Lit_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Null_Lit
is
   use Bare_Null_Lit_Memos;

      Row_Pos132 :
            Token_Index
               := No_Token_Index;
      Token_Pos201 :
            Token_Index
               := No_Token_Index;
  