// This file contains methods that existed in a previous version of Godot in ClassDB but were removed
// or their method signature has changed so they are no longer generated by bindings_generator.
// These methods are provided to avoid breaking binary compatibility.

using System;
using System.ComponentModel;

namespace Godot;

#pragma warning disable CS1734 // XML comment on 'X' has a paramref tag for 'Y', but there is no parameter by that name.
// TODO: This is currently disabled because of https://github.com/dotnet/roslyn/issues/52904
#pragma warning disable IDE0040 // Add accessibility modifiers.

partial class AnimationNode
{
    /// <inheritdoc cref="BlendInput(int, double, bool, bool, float, FilterAction, bool, bool)"/>
    [EditorBrowsable(EditorBrowsableState.Never)]
    public double BlendInput(int inputIndex, double time, bool seek, bool isExternalSeeking, float blend, FilterAction filter, bool sync)
    {
        return BlendInput(inputIndex, time, seek, isExternalSeeking, blend, filter, sync, testOnly: false);
    }

    /// <inheritdoc cref="BlendNode(StringName, AnimationNode, double, bool, bool, float, FilterAction, bool, bool)"/>
    [EditorBrowsable(EditorBrowsableState.Never)]
    public double BlendNode(StringName name, AnimationNode node, double time, bool seek, bool isExternalSeeking, float blend, FilterAction filter, bool sync)
    {
        return BlendNode(name, node, time, seek, isExternalSeeking, blend, filter, sync, testOnly: false);
    }
}

partial class AnimationPlayer
{
    /// <inheritdoc cref="AnimationMixer.CallbackModeMethod"/>
    [EditorBrowsable(EditorBrowsableState.Never)]
    public AnimationMethodCallMode MethodCallMode
    {
        get => (AnimationMethodCallMode)CallbackModeMethod;
        set => CallbackModeMethod = (AnimationCallbackModeMethod)value;
    }

    /// <inheritdoc cref="AnimationMixer.Active"/>
    [EditorBrowsable(EditorBrowsableState.Never)]
    public bool PlaybackActive
    {
        get => Active;
        set => Active = value;
    }

    /// <inheritdoc cref="AnimationMixer.CallbackModeProcess"/>
    [EditorBrowsable(EditorBrowsableState.Never)]
    public AnimationProcessCallback PlaybackProcessMode
    {
        get => (AnimationProcessCallback)CallbackModeProcess;
        set => CallbackModeProcess = (AnimationCallbackModeProcess)value;
    }
}

partial class AnimationTree
{
    /// <inheritdoc cref="AnimationMixer.CallbackModeProcess"/>
    [EditorBrowsable(EditorBrowsableState.Never)]
    public AnimationProcessCallback ProcessCallback
    {
        get => (AnimationProcessCallback)CallbackModeProcess;
        set => CallbackModeProcess = (AnimationCallbackModeProcess)value;
    }
}

partial class CodeEdit
{
    /// <inheritdoc cref="AddCodeCompletionOption(CodeCompletionKind, string, string, Nullable{Color}, Resource, Variant, int)"/>
    [EditorBrowsable(EditorBrowsableState.Never)]
    public void AddCodeCompletionOption(CodeCompletionKind type, string displayText, string insertText, Nullable<Color> textColor, Resource icon, Nullable<Variant> value)
    {
        AddCodeCompletionOption(type, displayText, insertText, textColor, icon, value, location: 1024);
    }
}

partial class Geometry3D
{
    /// <inheritdoc cref="SegmentIntersectsConvex(Vector3, Vector3, Godot.Collections.Array{Plane})"/>
    [EditorBrowsable(EditorBrowsableState.Never)]
    public static Vector3[] SegmentIntersectsConvex(Vector3 from, Vector3 to, Godot.Collections.Array planes)
    {
        return SegmentIntersectsConvex(from, to, new Godot.Collections.Array<Plane>(planes));
    }
}

partial class GraphEdit
{
    /// <inheritdoc cref="ShowArrangeButton"/>
    [EditorBrowsable(EditorBrowsableState.Never)]
    public bool ArrangeNodesButtonHidden
    {
        get => !ShowArrangeButton;
        set => ShowArrangeButton = !value;
    }

    /// <inheritdoc cref="GetMenuHBox()"/>
    [EditorBrowsable(EditorBrowsableState.Never)]
    public HBoxContainer GetZoomHBox()
    {
        return GetMenuHBox();
    }

    /// <inheritdoc cref="SnappingDistance"/>
    [EditorBrowsable(EditorBrowsableState.Never)]
    public int SnapDistance
    {
        get => SnappingDistance;
        set => SnappingDistance = value;
    }

    /// <inheritdoc cref="SnappingEnabled"/>
    [EditorBrowsable(EditorBrowsableState.Never)]
    public bool UseSnap
    {
        get => SnappingEnabled;
        set => SnappingEnabled = value;
    }
}

partial class GraphNode
{
    /// <inheritdoc cref="GraphElement.DeleteRequest"/>
    [EditorBrowsable(EditorBrowsableState.Never)]
    public event Action CloseRequest
    {
        add => DeleteRequest += value;
        remove => DeleteRequest -= value;
    }
}
partial class ImporterMesh
{
    /// <inheritdoc cref="AddSurface(Mesh.PrimitiveType, Godot.Collections.Array, Godot.Collections.Array{Godot.Collections.Array}, Godot.Collections.Dictionary, Material, string, ulong)"/>
    [EditorBrowsable(EditorBrowsableState.Never)]
    public void AddSurface(Mesh.PrimitiveType primitive, Godot.Collections.Array arrays, Godot.Collections.Array<Godot.Collections.Array> blendShapes, Godot.Collections.Dictionary lods, Material material, string name, uint flags)
    {
        AddSurface(primitive, arrays, blendShapes, lods, material, name, (ulong)flags);
    }
}


partial class MeshInstance3D
{
    /// <inheritdoc cref="CreateMultipleConvexCollisions(MeshConvexDecompositionSettings)"/>
    [EditorBrowsable(EditorBrowsableState.Never)]
    public void CreateMultipleConvexCollisions()
    {
        CreateMultipleConvexCollisions(settings: null);
    }
}

partial class Node3D
{
    /// <inheritdoc cref="LookAt(Vector3, Nullable{Vector3}, bool)"/>
    [EditorBrowsable(EditorBrowsableState.Never)]
    public void LookAt(Vector3 target, Nullable<Vector3> up)
    {
        LookAt(target, up, useModelFront: false);
    }

    /// <inheritdoc cref="LookAtFromPosition(Vector3, Vector3, Nullable{Vector3}, bool)"/>
    [EditorBrowsable(EditorBrowsableState.Never)]
    public void LookAtFromPosition(Vector3 position, Vector3 target, Nullable<Vector3> up)
    {
        LookAtFromPosition(position, target, up, useModelFront: false);
    }
}

partial class RenderingDevice
{
    /// <inheritdoc cref="DrawListBegin(Rid, InitialAction, FinalAction, InitialAction, FinalAction, Color[], float, uint, Nullable{Rect2}, Godot.Collections.Array{Rid})"/>
    [EditorBrowsable(EditorBrowsableState.Never)]
    public long DrawListBegin(Rid framebuffer, InitialAction initialColorAction, FinalAction finalColorAction, InitialAction initialDepthAction, FinalAction finalDepthAction, Color[] clearColorValues, float clearDepth, uint clearStencil, Nullable<Rect2> region, Godot.Collections.Array storageTextures)
    {
        return DrawListBegin(framebuffer, initialColorAction, finalColorAction, initialDepthAction, finalDepthAction, clearColorValues, clearDepth, clearStencil, region, new Godot.Collections.Array<Rid>(storageTextures));
    }
}

partial class RichTextLabel
{
    /// <inheritdoc cref="PushList(int, ListType, bool, string)"/>
    [EditorBrowsable(EditorBrowsableState.Never)]
    public void PushList(int level, ListType type, bool capitalize)
    {
        PushList(level, type, capitalize, bullet: "•");
    }

    /// <inheritdoc cref="PushParagraph(HorizontalAlignment, TextDirection, string, TextServer.StructuredTextParser, TextServer.JustificationFlag, float[])"/>
    [EditorBrowsable(EditorBrowsableState.Never)]
    public void PushParagraph(HorizontalAlignment alignment, TextDirection baseDirection, string language, TextServer.StructuredTextParser stParser)
    {
        PushParagraph(alignment, baseDirection, language, stParser, TextServer.JustificationFlag.WordBound | TextServer.JustificationFlag.Kashida | TextServer.JustificationFlag.SkipLastLine | TextServer.JustificationFlag.DoNotSkipSingleLine);
    }
}

partial class SurfaceTool
{
    /// <inheritdoc cref="AddTriangleFan(Vector3[], Vector2[], Color[], Vector2[], Vector3[], Godot.Collections.Array{Plane})"/>
    [EditorBrowsable(EditorBrowsableState.Never)]
    public void AddTriangleFan(Vector3[] vertices, Vector2[] uvs, Color[] colors, Vector2[] uv2S, Vector3[] normals, Godot.Collections.Array tangents)
    {
        AddTriangleFan(vertices, uvs, colors, uv2S, normals, new Godot.Collections.Array<Plane>(tangents));
    }

    /// <inheritdoc cref="Commit(ArrayMesh, ulong)"/>
    [EditorBrowsable(EditorBrowsableState.Never)]
    public ArrayMesh Commit(ArrayMesh existing, uint flags)
    {
        return Commit(existing, (ulong)flags);
    }
}

partial class TileMap
{
    /// <summary>
    /// The TileMap's quadrant size. Optimizes drawing by batching, using chunks of this size.
    /// </summary>
    [EditorBrowsable(EditorBrowsableState.Never)]
    public int CellQuadrantSize
    {
        get => RenderingQuadrantSize;
        set => RenderingQuadrantSize = value;
    }
}

partial class Tree
{
    /// <inheritdoc cref="EditSelected(bool)"/>
    [EditorBrowsable(EditorBrowsableState.Never)]
    public bool EditSelected()
    {
        return EditSelected(forceEdit: false);
    }
}

partial class UndoRedo
{
    /// <inheritdoc cref="CreateAction(string, MergeMode, bool)"/>
    [EditorBrowsable(EditorBrowsableState.Never)]
    public void CreateAction(string name, MergeMode mergeMode)
    {
        CreateAction(name, mergeMode, backwardUndoOps: false);
    }
}

#pragma warning restore CS1734
