// Code generated by 'tmplgen'; DO NOT EDIT.

package ssa

type SIMDLogicalOP uint8

const (
	// boolean simd operations, for reducing expression to VPTERNLOG* instructions
	// sloInterior is set for non-root nodes in logical-op expression trees.
	// the operations are even-numbered.
	sloInterior SIMDLogicalOP = 1
	sloNone     SIMDLogicalOP = 2 * iota
	sloAnd
	sloOr
	sloAndNot
	sloXor
	sloNot
)

func classifyBooleanSIMD(v *Value) SIMDLogicalOP {
	switch v.Op {
	case OpAndInt8x16, OpAndInt16x8, OpAndInt32x4, OpAndInt64x2, OpAndInt8x32, OpAndInt16x16, OpAndInt32x8, OpAndInt64x4, OpAndInt8x64, OpAndInt16x32, OpAndInt32x16, OpAndInt64x8:
		return sloAnd

	case OpOrInt8x16, OpOrInt16x8, OpOrInt32x4, OpOrInt64x2, OpOrInt8x32, OpOrInt16x16, OpOrInt32x8, OpOrInt64x4, OpOrInt8x64, OpOrInt16x32, OpOrInt32x16, OpOrInt64x8:
		return sloOr

	case OpAndNotInt8x16, OpAndNotInt16x8, OpAndNotInt32x4, OpAndNotInt64x2, OpAndNotInt8x32, OpAndNotInt16x16, OpAndNotInt32x8, OpAndNotInt64x4, OpAndNotInt8x64, OpAndNotInt16x32, OpAndNotInt32x16, OpAndNotInt64x8:
		return sloAndNot
	case OpXorInt8x16:
		if y := v.Args[1]; y.Op == OpEqualInt8x16 &&
			y.Args[0] == y.Args[1] {
			return sloNot
		}
		return sloXor
	case OpXorInt16x8:
		if y := v.Args[1]; y.Op == OpEqualInt16x8 &&
			y.Args[0] == y.Args[1] {
			return sloNot
		}
		return sloXor
	case OpXorInt32x4:
		if y := v.Args[1]; y.Op == OpEqualInt32x4 &&
			y.Args[0] == y.Args[1] {
			return sloNot
		}
		return sloXor
	case OpXorInt64x2:
		if y := v.Args[1]; y.Op == OpEqualInt64x2 &&
			y.Args[0] == y.Args[1] {
			return sloNot
		}
		return sloXor
	case OpXorInt8x32:
		if y := v.Args[1]; y.Op == OpEqualInt8x32 &&
			y.Args[0] == y.Args[1] {
			return sloNot
		}
		return sloXor
	case OpXorInt16x16:
		if y := v.Args[1]; y.Op == OpEqualInt16x16 &&
			y.Args[0] == y.Args[1] {
			return sloNot
		}
		return sloXor
	case OpXorInt32x8:
		if y := v.Args[1]; y.Op == OpEqualInt32x8 &&
			y.Args[0] == y.Args[1] {
			return sloNot
		}
		return sloXor
	case OpXorInt64x4:
		if y := v.Args[1]; y.Op == OpEqualInt64x4 &&
			y.Args[0] == y.Args[1] {
			return sloNot
		}
		return sloXor
	case OpXorInt8x64:
		if y := v.Args[1]; y.Op == OpEqualInt8x64 &&
			y.Args[0] == y.Args[1] {
			return sloNot
		}
		return sloXor
	case OpXorInt16x32:
		if y := v.Args[1]; y.Op == OpEqualInt16x32 &&
			y.Args[0] == y.Args[1] {
			return sloNot
		}
		return sloXor
	case OpXorInt32x16:
		if y := v.Args[1]; y.Op == OpEqualInt32x16 &&
			y.Args[0] == y.Args[1] {
			return sloNot
		}
		return sloXor
	case OpXorInt64x8:
		if y := v.Args[1]; y.Op == OpEqualInt64x8 &&
			y.Args[0] == y.Args[1] {
			return sloNot
		}
		return sloXor

	}
	return sloNone
}

func ternOpForLogical(op Op) Op {
	switch op {
	case OpAndInt8x16, OpOrInt8x16, OpXorInt8x16, OpAndNotInt8x16:
		return OpternInt32x4
	case OpAndUint8x16, OpOrUint8x16, OpXorUint8x16, OpAndNotUint8x16:
		return OpternUint32x4
	case OpAndInt16x8, OpOrInt16x8, OpXorInt16x8, OpAndNotInt16x8:
		return OpternInt32x4
	case OpAndUint16x8, OpOrUint16x8, OpXorUint16x8, OpAndNotUint16x8:
		return OpternUint32x4
	case OpAndInt32x4, OpOrInt32x4, OpXorInt32x4, OpAndNotInt32x4:
		return OpternInt32x4
	case OpAndUint32x4, OpOrUint32x4, OpXorUint32x4, OpAndNotUint32x4:
		return OpternUint32x4
	case OpAndInt64x2, OpOrInt64x2, OpXorInt64x2, OpAndNotInt64x2:
		return OpternInt64x2
	case OpAndUint64x2, OpOrUint64x2, OpXorUint64x2, OpAndNotUint64x2:
		return OpternUint64x2
	case OpAndInt8x32, OpOrInt8x32, OpXorInt8x32, OpAndNotInt8x32:
		return OpternInt32x8
	case OpAndUint8x32, OpOrUint8x32, OpXorUint8x32, OpAndNotUint8x32:
		return OpternUint32x8
	case OpAndInt16x16, OpOrInt16x16, OpXorInt16x16, OpAndNotInt16x16:
		return OpternInt32x8
	case OpAndUint16x16, OpOrUint16x16, OpXorUint16x16, OpAndNotUint16x16:
		return OpternUint32x8
	case OpAndInt32x8, OpOrInt32x8, OpXorInt32x8, OpAndNotInt32x8:
		return OpternInt32x8
	case OpAndUint32x8, OpOrUint32x8, OpXorUint32x8, OpAndNotUint32x8:
		return OpternUint32x8
	case OpAndInt64x4, OpOrInt64x4, OpXorInt64x4, OpAndNotInt64x4:
		return OpternInt64x4
	case OpAndUint64x4, OpOrUint64x4, OpXorUint64x4, OpAndNotUint64x4:
		return OpternUint64x4
	case OpAndInt8x64, OpOrInt8x64, OpXorInt8x64, OpAndNotInt8x64:
		return OpternInt32x16
	case OpAndUint8x64, OpOrUint8x64, OpXorUint8x64, OpAndNotUint8x64:
		return OpternUint32x16
	case OpAndInt16x32, OpOrInt16x32, OpXorInt16x32, OpAndNotInt16x32:
		return OpternInt32x16
	case OpAndUint16x32, OpOrUint16x32, OpXorUint16x32, OpAndNotUint16x32:
		return OpternUint32x16
	case OpAndInt32x16, OpOrInt32x16, OpXorInt32x16, OpAndNotInt32x16:
		return OpternInt32x16
	case OpAndUint32x16, OpOrUint32x16, OpXorUint32x16, OpAndNotUint32x16:
		return OpternUint32x16
	case OpAndInt64x8, OpOrInt64x8, OpXorInt64x8, OpAndNotInt64x8:
		return OpternInt64x8
	case OpAndUint64x8, OpOrUint64x8, OpXorUint64x8, OpAndNotUint64x8:
		return OpternUint64x8

	}
	return op
}
