---
title: glab completion
stage: Create
group: Code Review
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
---

<!--
This documentation is auto generated by a script.
Please do not edit this file directly. Run `make gen-docs` instead.
-->

Generate shell completion scripts.

## Synopsis

This command outputs code meant to be saved to a file, or immediately
evaluated by an interactive shell. To load completions:

### Bash

To load completions in your current shell session:

```shell
source <(glab completion -s bash)
```

To load completions for every new session, run this command one time:

#### Linux

```shell
glab completion -s bash > /etc/bash_completion.d/glab
```

#### macOS

```shell
glab completion -s bash > /usr/local/etc/bash_completion.d/glab
```

### Zsh

If shell completion is not already enabled in your environment you must
enable it. Run this command one time:

```shell
echo "autoload -U compinit; compinit" >> ~/.zshrc
```

To load completions in your current shell session:

```shell
source <(glab completion -s zsh); compdef _glab glab
```

To load completions for every new session, run this command one time:

#### Linux

```shell
glab completion -s zsh > "${fpath[1]}/_glab"
```

#### macOS

For older versions of macOS, you might need this command:

```shell
glab completion -s zsh > /usr/local/share/zsh/site-functions/_glab
```

The Homebrew version of glab should install completions automatically.

### fish

To load completions in your current shell session:

```shell
glab completion -s fish | source
```

To load completions for every new session, run this command one time:

```shell
glab completion -s fish > ~/.config/fish/completions/glab.fish
```

### PowerShell

To load completions in your current shell session:

```shell
glab completion -s powershell | Out-String | Invoke-Expression
```

To load completions for every new session, add the output of the above command
to your PowerShell profile.

When installing glab through a package manager, however, you might not need
more shell configuration to support completions.
For Homebrew, see [brew shell completion](https://docs.brew.sh/Shell-Completion)

```plaintext
glab completion [flags]
```

## Options

```plaintext
      --no-desc        Do not include shell completion description.
  -s, --shell string   Shell type: bash, zsh, fish, powershell. (default "bash")
```

## Options inherited from parent commands

```plaintext
  -h, --help   Show help for this command.
```
