#ifndef _CEGOCONDDESC_H_INCLUDED_
#define _CEGOCONDDESC_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoCondDesc.h
// --------------
// Cego condition structure class definition
//     
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2019 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoCondDesc
//
// Description: Condition container class used for queries and inside stores procedures
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// CEGO INCLUDES
#include "CegoPredDesc.h"

class CegoCondDesc {

public:
    
    enum CondType { AND, OR, PRED };
    
    CegoCondDesc(char *buf, CegoDistManager *pGTM, int tabSetId);
    CegoCondDesc(Element *pCondElement, CegoDistManager *pGTM);
    CegoCondDesc(CondType ct);
    ~CegoCondDesc();

    void setTabSetId(int tabSetId);
    
    void getPlanList(ListT<Element*>& planList);

    CegoPredDesc* Left();
    CegoPredDesc* Right();
    
    void setLeft(CegoPredDesc* pP);
    void setRight(CegoPredDesc* pP);

    void setCondType(CondType ct);
    CondType getCondType();

    void setBlock(CegoProcBlock* pBlock);

    void encode(char *buf);
    void decode(char *buf, CegoDistManager *pGTM, int tabSetId);
    int getEncodingLength() const;

    ListT<CegoAttrDesc*> getAttrRefList() const;
    void getFieldList(ListT<CegoField>& fl) const;

    int evalReferences(CegoContentObject *pCO, const ListT<CegoField>& fl);
    ListT<CegoAggregation*> getAggregationList();
    void setFieldListArray(ListT<CegoField> **pFLA);
    
    Element* toElement() const;
    void fromElement(Element* pCondElement, CegoDistManager *pGTM);
    
    void cleanUp();

    CegoCondDesc* clone(bool isAttrRef = false);

private:

    CondType _condType;

    CegoPredDesc *_pLeft;
    CegoPredDesc *_pRight;

};

#endif
