;; NOTE: Assertions have been generated by update_lit_checks.py --output=fuzz-exec and should not be edited.

;; RUN: foreach %s %t wasm-opt -all --fuzz-exec-before -q -o /dev/null 2>&1 | filecheck %s

;; Three exports, one which suspends, the second resumes but ends up throwing,
;; and another suspend. This is a regression test for a bug where the global
;; state of continuations got into a confused state at the last export, and
;; asserted.

(module
 (type $none (func))
 (type $cont (cont $none))

 (import "fuzzing-support" "call-export" (func $call-export (param i32 i32)))

 (tag $tag (type $none))

 ;; CHECK:      [fuzz-exec] calling suspend
 ;; CHECK-NEXT: [exception thrown: unhandled suspend]
 (func $suspend (export "suspend")
  (suspend $tag)
 )

 ;; CHECK:      [fuzz-exec] calling handled
 ;; CHECK-NEXT: [exception thrown: __private externref]
 (func $handled (export "handled")
  (drop
   (block $block (result (ref $cont))
    (resume $cont (on $tag $block)
     (cont.new $cont
      (ref.func $cont)
     )
    )
    (unreachable)
   )
  )
 )

 ;; CHECK:      [fuzz-exec] calling suspend2
 ;; CHECK-NEXT: [exception thrown: unhandled suspend]
 (func $suspend2 (export "suspend2")
  (suspend $tag)
 )

 (func $cont
  ;; This calls $suspend through an export, which traps as we cannot suspend
  ;; through JS.
  (call $call-export
   (i32.const 0)
   (i32.const 0)
  )
 )
)

