from argparse import ArgumentParser, Namespace
from typing import Any

from gunicorn.config import Config
from gunicorn.glogging import Logger as GLogger

from .._types import _ASGIAppType, _WSGIAppType

class BaseApplication:
    usage: str | None
    cfg: Config
    callable: _WSGIAppType | _ASGIAppType | None
    prog: str | None
    logger: GLogger

    def __init__(self, usage: str | None = None, prog: str | None = None) -> None: ...
    def do_load_config(self) -> None: ...
    def load_default_config(self) -> None: ...
    def init(self, parser: ArgumentParser, opts: Namespace, args: list[str]) -> dict[str, Any] | None: ...
    def load(self) -> _WSGIAppType | _ASGIAppType: ...
    def load_config(self) -> None: ...
    def reload(self) -> None: ...
    def wsgi(self) -> _WSGIAppType | _ASGIAppType: ...
    def run(self) -> None: ...

class Application(BaseApplication):
    def chdir(self) -> None: ...
    def get_config_from_filename(self, filename: str) -> dict[str, Any]: ...
    def get_config_from_module_name(self, module_name: str) -> dict[str, Any]: ...
    def load_config_from_module_name_or_filename(self, location: str) -> dict[str, Any]: ...
    def load_config_from_file(self, filename: str) -> dict[str, Any]: ...
    def load_config(self) -> None: ...
    def run(self) -> None: ...
