from typing import Final

from pymeeus.Angle import Angle
from pymeeus.Epoch import Epoch

VSOP87_L: Final[list[list[list[float]]]]
VSOP87_B: Final[list[list[list[float]]]]
VSOP87_R: Final[list[list[list[float]]]]
ORBITAL_ELEM: Final[list[list[float]]]
ORBITAL_ELEM_J2000: Final[list[list[float]]]

class Venus:
    @staticmethod
    def geometric_heliocentric_position(epoch: Epoch, tofk5: bool | None = True) -> tuple[Angle, Angle, float]: ...
    @staticmethod
    def apparent_heliocentric_position(epoch: Epoch) -> tuple[Angle, Angle, float]: ...
    @staticmethod
    def orbital_elements_mean_equinox(epoch: Epoch) -> tuple[Angle, float, float, Angle, Angle, Angle]: ...
    @staticmethod
    def orbital_elements_j2000(epoch: Epoch) -> tuple[Angle, float, float, Angle, Angle, Angle]: ...
    @staticmethod
    def geocentric_position(epoch: Epoch) -> tuple[Angle, Angle, Angle]: ...
    @staticmethod
    def inferior_conjunction(epoch: Epoch) -> Epoch: ...
    @staticmethod
    def superior_conjunction(epoch: Epoch) -> Epoch: ...
    @staticmethod
    def western_elongation(epoch: Epoch) -> tuple[Epoch, Angle]: ...
    @staticmethod
    def eastern_elongation(epoch: Epoch) -> tuple[Epoch, Angle]: ...
    @staticmethod
    def station_longitude_1(epoch: Epoch) -> Epoch: ...
    @staticmethod
    def station_longitude_2(epoch: Epoch) -> Epoch: ...
    @staticmethod
    def perihelion_aphelion(epoch: Epoch, perihelion: bool | None = True) -> Epoch: ...
    @staticmethod
    def passage_nodes(epoch: Epoch, ascending: bool = True) -> tuple[Epoch, float]: ...
    @staticmethod
    def illuminated_fraction(epoch: Epoch) -> float: ...
    @staticmethod
    def magnitude(sun_dist: float, earth_dist: float, phase_angle: float | Angle) -> float: ...

def main() -> None: ...
