# @HEADER
# ************************************************************************
#
#            TriBITS: Tribal Build, Integrate, and Test System
#                    Copyright 2013 Sandia Corporation
#
# Under the terms of Contract DE-AC04-94AL85000 with Sandia Corporation,
# the U.S. Government retains certain rights in this software.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are
# met:
#
# 1. Redistributions of source code must retain the above copyright
# notice, this list of conditions and the following disclaimer.
#
# 2. Redistributions in binary form must reproduce the above copyright
# notice, this list of conditions and the following disclaimer in the
# documentation and/or other materials provided with the distribution.
#
# 3. Neither the name of the Corporation nor the names of the
# contributors may be used to endorse or promote products derived from
# this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY SANDIA CORPORATION "AS IS" AND ANY
# EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
# PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL SANDIA CORPORATION OR THE
# CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
# EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
# PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
# PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
# LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
# NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
# SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# ************************************************************************
# @HEADER

##############################################################################
#
# CMake variable for use by Seacas/Zoltan clients.
#
# Do not edit: This file was generated automatically by CMake.
#
##############################################################################

if(CMAKE_VERSION VERSION_LESS 3.3)
  set(${CMAKE_FIND_PACKAGE_NAME}_NOT_FOUND_MESSAGE
    "Zoltan requires CMake 3.3 or later for 'if (... IN_LIST ...)'"
    )
  set(${CMAKE_FIND_PACKAGE_NAME}_FOUND FALSE)
  return()
endif()
cmake_minimum_required(VERSION 3.3...3.22.0)

## ---------------------------------------------------------------------------
## Compilers used by Seacas/Zoltan build
## ---------------------------------------------------------------------------

set(Zoltan_CXX_COMPILER "${CMAKE_CURRENT_LIST_DIR}/../../../bin/g++.exe")

set(Zoltan_C_COMPILER "${CMAKE_CURRENT_LIST_DIR}/../../../bin/gcc.exe")

set(Zoltan_Fortran_COMPILER "gfortran")
# Deprecated!
set(Zoltan_FORTRAN_COMPILER "gfortran") 


## ---------------------------------------------------------------------------
## Compiler flags used by Seacas/Zoltan build
## ---------------------------------------------------------------------------

## Give the build type
set(Zoltan_CMAKE_BUILD_TYPE "Release")

## Set compiler flags, including those determined by build type
set(Zoltan_CXX_FLAGS [[ ]])

set(Zoltan_C_FLAGS [[  -Wall -Wunused -pedantic -Wshadow -std=c11 ]])

set(Zoltan_Fortran_FLAGS [[ ]])
# Deprecated
set(Zoltan_FORTRAN_FLAGS [[ ]])

## Extra link flags (e.g., specification of fortran libraries)
set(Zoltan_EXTRA_LD_FLAGS [[]])

## This is the command-line entry used for setting rpaths. In a build
## with static libraries it will be empty.
set(Zoltan_SHARED_LIB_RPATH_COMMAND "${CMAKE_CURRENT_LIST_DIR}/../../../lib")
set(Zoltan_BUILD_SHARED_LIBS "ON")

set(Zoltan_LINKER ${CMAKE_CURRENT_LIST_DIR}/../../../bin/ld.exe)
set(Zoltan_AR ${CMAKE_CURRENT_LIST_DIR}/../../../bin/ar.exe)

## ---------------------------------------------------------------------------
## Set library specifications and paths
## ---------------------------------------------------------------------------

## Base install location (if not in the build tree)
set(Zoltan_INSTALL_DIR "${CMAKE_CURRENT_LIST_DIR}/../../..")

## List of package libraries
set(Zoltan_LIBRARIES Zoltan::all_libs)

## ---------------------------------------------------------------------------
## MPI specific variables
##   These variables are provided to make it easier to get the mpi libraries
##   and includes on systems that do not use the mpi wrappers for compiling
## ---------------------------------------------------------------------------

set(Zoltan_MPI_LIBRARIES "")
set(Zoltan_MPI_LIBRARY_DIRS "")
set(Zoltan_MPI_INCLUDE_DIRS "")
set(Zoltan_MPI_EXEC "")
set(Zoltan_MPI_EXEC_MAX_NUMPROCS "")
set(Zoltan_MPI_EXEC_NUMPROCS_FLAG "")

## ---------------------------------------------------------------------------
## Set useful general variables
## ---------------------------------------------------------------------------

# Enables/Disables for upstream package dependencies
set(Zoltan_ENABLE_MPI OFF)
set(Zoltan_ENABLE_METIS ON)
set(Zoltan_ENABLE_ParMETIS OFF)
set(Zoltan_ENABLE_PaToH OFF)
set(Zoltan_ENABLE_Scotch OFF)
set(Zoltan_ENABLE_Zlib OFF)
set(Zoltan_ENABLE_CCOLAMD OFF)
set(Zoltan_ENABLE_OVIS OFF)

# Exported cache variables
set(Zoltan_ENABLE_UINT_IDS "OFF")
set(UNSIGNED_INT_GLOBAL_IDS "OFF")
set(Zoltan_ENABLE_ULONG_IDS "OFF")
set(UNSIGNED_LONG_GLOBAL_IDS "OFF")
set(Zoltan_ENABLE_ULLONG_IDS "OFF")
set(UNSIGNED_LONG_LONG_GLOBAL_IDS "OFF")
set(Zoltan_ENABLE_HUND "OFF")
set(HAVE_ZOLTAN_HUND "OFF")
set(Zoltan_ENABLE_KNUTH_HASH "OFF")
set(HAVE_ZOLTAN_KNUTH_HASH "OFF")
set(Zoltan_ENABLE_F90INTERFACE "OFF")
set(BUILD_ZOLTAN_F90_INTERFACE "OFF")
set(Zoltan_ENABLE_PURIFY "OFF")
set(HAVE_PURIFY "OFF")

# Include configuration of dependent packages
if (NOT TARGET METIS::all_libs)
  include("${CMAKE_CURRENT_LIST_DIR}/../../external_packages/METIS/METISConfig.cmake")
endif()

# Import Zoltan targets
include("${CMAKE_CURRENT_LIST_DIR}/ZoltanTargets.cmake")

# Standard TriBITS-compliant external package variables
set(Zoltan_IS_TRIBITS_COMPLIANT TRUE)
set(Zoltan_TRIBITS_COMPLIANT_PACKAGE_CONFIG_FILE "${CMAKE_CURRENT_LIST_FILE}")
set(Zoltan_TRIBITS_COMPLIANT_PACKAGE_CONFIG_FILE_DIR "${CMAKE_CURRENT_LIST_DIR}")


## ----------------------------------------------------------------------------
## Create deprecated non-namespaced library targets for backwards compatibility
## ----------------------------------------------------------------------------

set(Zoltan_EXPORTED_PACKAGE_LIBS_NAMES "simpi;zoltan")

foreach(libname IN LISTS Zoltan_EXPORTED_PACKAGE_LIBS_NAMES)
  if (NOT TARGET ${libname})
    add_library(${libname} INTERFACE IMPORTED)
    target_link_libraries(${libname}
       INTERFACE Zoltan::${libname})
    set(deprecationMessage
      "WARNING: The non-namespaced target '${libname}' is deprecated!"
      "  If always using newer versions of the project 'Seacas', then use the"
      " new namespaced target 'Zoltan::${libname}', or better yet,"
      " 'Zoltan::all_libs' to be less sensitive to changes in the definition"
      " of targets in the package 'Zoltan'.  Or, to maintain compatibility with"
      " older or newer versions the project 'Seacas', instead link against the"
      " libraries specified by the variable 'Zoltan_LIBRARIES'."
      )
    string(REPLACE ";" "" deprecationMessage "${deprecationMessage}")
    set_target_properties(${libname}
      PROPERTIES DEPRECATION "${deprecationMessage}" )
  endif()
endforeach()
