#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscoptions.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscoptionsinsertstringyaml_ PETSCOPTIONSINSERTSTRINGYAML
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscoptionsinsertstringyaml_ petscoptionsinsertstringyaml
#endif
PETSC_EXTERN void petscoptionsinsertstringyaml_(PetscOptions *a, char b[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = PetscOptionsInsertStringYAML(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscoptions.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscoptionsinsertfileyaml_ PETSCOPTIONSINSERTFILEYAML
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscoptionsinsertfileyaml_ petscoptionsinsertfileyaml
#endif
PETSC_EXTERN void petscoptionsinsertfileyaml_(MPI_Fint *a, PetscOptions *b, char c[], PetscBool *d, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_c)
{
  char* c_c;
  FIXCHAR(c, l_c, c_c);
  *ierr = PetscOptionsInsertFileYAML(MPI_Comm_f2c(*(a)), *b, c_c, *d ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
  FREECHAR(c, c_c);
}
