#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscompctrlcreate_ PETSCOMPCTRLCREATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscompctrlcreate_ petscompctrlcreate
#endif
PETSC_EXTERN void petscompctrlcreate_(MPI_Fint *a, PetscInt *b, PetscOmpCtrl *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  PETSC_FORTRAN_OBJECT_CREATE(c);
  CHKFORTRANNULLOBJECT(c);
  *ierr = PetscOmpCtrlCreate(MPI_Comm_f2c(*(a)), *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscompctrldestroy_ PETSCOMPCTRLDESTROY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscompctrldestroy_ petscompctrldestroy
#endif
PETSC_EXTERN void petscompctrldestroy_(PetscOmpCtrl *a, PetscErrorCode *ierr)
{
  PETSC_FORTRAN_OBJECT_F_DESTROYED_TO_C_NULL(a);
  PetscBool null_a = !*(void**) a ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(a);
  *ierr = PetscOmpCtrlDestroy(a);
  if (*ierr) return;
  if (! null_a && !*(void**) a) *(void **) a = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscompctrlbarrier_ PETSCOMPCTRLBARRIER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscompctrlbarrier_ petscompctrlbarrier
#endif
PETSC_EXTERN void petscompctrlbarrier_(PetscOmpCtrl *a, PetscErrorCode *ierr)
{
  *ierr = PetscOmpCtrlBarrier(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscompctrlompregiononmasterbegin_ PETSCOMPCTRLOMPREGIONONMASTERBEGIN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscompctrlompregiononmasterbegin_ petscompctrlompregiononmasterbegin
#endif
PETSC_EXTERN void petscompctrlompregiononmasterbegin_(PetscOmpCtrl *a, PetscErrorCode *ierr)
{
  *ierr = PetscOmpCtrlOmpRegionOnMasterBegin(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscompctrlompregiononmasterend_ PETSCOMPCTRLOMPREGIONONMASTEREND
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscompctrlompregiononmasterend_ petscompctrlompregiononmasterend
#endif
PETSC_EXTERN void petscompctrlompregiononmasterend_(PetscOmpCtrl *a, PetscErrorCode *ierr)
{
  *ierr = PetscOmpCtrlOmpRegionOnMasterEnd(*a);
  if (*ierr) return;
}
