#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewercgnsopen_ PETSCVIEWERCGNSOPEN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewercgnsopen_ petscviewercgnsopen
#endif
PETSC_EXTERN void petscviewercgnsopen_(MPI_Fint *a, char b[], PetscFileMode *c, PetscViewer *d, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  PetscBool null_d = !*(void**) d ? PETSC_TRUE : PETSC_FALSE;
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  CHKFORTRANNULLOBJECT(d);
  *ierr = PetscViewerCGNSOpen(MPI_Comm_f2c(*(a)), c_b, *c, d);
  if (*ierr) return;
  FREECHAR(b, c_b);
  if (! null_d && !*(void**) d) *(void **) d = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewercgnssetsolutionindex_ PETSCVIEWERCGNSSETSOLUTIONINDEX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewercgnssetsolutionindex_ petscviewercgnssetsolutionindex
#endif
PETSC_EXTERN void petscviewercgnssetsolutionindex_(PetscViewer *a, PetscInt *b, PetscErrorCode *ierr)
{
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  *ierr = PetscViewerCGNSSetSolutionIndex(v_a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewercgnsgetsolutionindex_ PETSCVIEWERCGNSGETSOLUTIONINDEX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewercgnsgetsolutionindex_ petscviewercgnsgetsolutionindex
#endif
PETSC_EXTERN void petscviewercgnsgetsolutionindex_(PetscViewer *a, PetscInt *b, PetscErrorCode *ierr)
{
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  CHKFORTRANNULLINTEGER(b);
  *ierr = PetscViewerCGNSGetSolutionIndex(v_a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewercgnsgetsolutiontime_ PETSCVIEWERCGNSGETSOLUTIONTIME
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewercgnsgetsolutiontime_ petscviewercgnsgetsolutiontime
#endif
PETSC_EXTERN void petscviewercgnsgetsolutiontime_(PetscViewer *a, PetscReal *b, PetscBool *c, PetscErrorCode *ierr)
{
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  CHKFORTRANNULLREAL(b);
  CHKFORTRANNULLBOOL(c);
  *ierr = PetscViewerCGNSGetSolutionTime(v_a, b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewercgnsgetsolutioniteration_ PETSCVIEWERCGNSGETSOLUTIONITERATION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewercgnsgetsolutioniteration_ petscviewercgnsgetsolutioniteration
#endif
PETSC_EXTERN void petscviewercgnsgetsolutioniteration_(PetscViewer *a, PetscInt *b, PetscBool *c, PetscErrorCode *ierr)
{
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  CHKFORTRANNULLINTEGER(b);
  CHKFORTRANNULLBOOL(c);
  *ierr = PetscViewerCGNSGetSolutionIteration(v_a, b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewercgnsgetsolutionname_ PETSCVIEWERCGNSGETSOLUTIONNAME
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewercgnsgetsolutionname_ petscviewercgnsgetsolutionname
#endif
PETSC_EXTERN void petscviewercgnsgetsolutionname_(PetscViewer *a, char b[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b = PETSC_NULLPTR;
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  *ierr = PetscViewerCGNSGetSolutionName(v_a, (const char **)&c_b);
  if (*ierr) return;
  *ierr = PetscStrncpy((char *)b, c_b, l_b);
  if (*ierr) return;
  FIXRETURNCHAR(PETSC_TRUE, b, l_b);
}
