#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmda.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmdasetfieldname_ DMDASETFIELDNAME
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmdasetfieldname_ dmdasetfieldname
#endif
PETSC_EXTERN void dmdasetfieldname_(DM *a, PetscInt *b, char c[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_c)
{
  char* c_c;
  FIXCHAR(c, l_c, c_c);
  *ierr = DMDASetFieldName(*a, *b, c_c);
  if (*ierr) return;
  FREECHAR(c, c_c);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmda.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmdagetfieldname_ DMDAGETFIELDNAME
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmdagetfieldname_ dmdagetfieldname
#endif
PETSC_EXTERN void dmdagetfieldname_(DM *a, PetscInt *b, char c[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_c)
{
  char* c_c = PETSC_NULLPTR;
  *ierr = DMDAGetFieldName(*a, *b, (const char **)&c_c);
  if (*ierr) return;
  *ierr = PetscStrncpy((char *)c, c_c, l_c);
  if (*ierr) return;
  FIXRETURNCHAR(PETSC_TRUE, c, l_c);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmda.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmdasetcoordinatename_ DMDASETCOORDINATENAME
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmdasetcoordinatename_ dmdasetcoordinatename
#endif
PETSC_EXTERN void dmdasetcoordinatename_(DM *a, PetscInt *b, char c[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_c)
{
  char* c_c;
  FIXCHAR(c, l_c, c_c);
  *ierr = DMDASetCoordinateName(*a, *b, c_c);
  if (*ierr) return;
  FREECHAR(c, c_c);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmda.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmdagetcoordinatename_ DMDAGETCOORDINATENAME
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmdagetcoordinatename_ dmdagetcoordinatename
#endif
PETSC_EXTERN void dmdagetcoordinatename_(DM *a, PetscInt *b, char c[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_c)
{
  char* c_c = PETSC_NULLPTR;
  *ierr = DMDAGetCoordinateName(*a, *b, (const char **)&c_c);
  if (*ierr) return;
  *ierr = PetscStrncpy((char *)c, c_c, l_c);
  if (*ierr) return;
  FIXRETURNCHAR(PETSC_TRUE, c, l_c);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmda.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmdagetcorners_ DMDAGETCORNERS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmdagetcorners_ dmdagetcorners
#endif
PETSC_EXTERN void dmdagetcorners_(DM *a, PetscInt *b, PetscInt *c, PetscInt *d, PetscInt *e, PetscInt *f, PetscInt *g, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  CHKFORTRANNULLINTEGER(c);
  CHKFORTRANNULLINTEGER(d);
  CHKFORTRANNULLINTEGER(e);
  CHKFORTRANNULLINTEGER(f);
  CHKFORTRANNULLINTEGER(g);
  *ierr = DMDAGetCorners(*a, b, c, d, e, f, g);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmda.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmdacreatecompatibledmda_ DMDACREATECOMPATIBLEDMDA
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmdacreatecompatibledmda_ dmdacreatecompatibledmda
#endif
PETSC_EXTERN void dmdacreatecompatibledmda_(DM *a, PetscInt *b, DM *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  *ierr = DMDACreateCompatibleDMDA(*a, *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmda.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmdagetcoordinatearray_ DMDAGETCOORDINATEARRAY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmdagetcoordinatearray_ dmdagetcoordinatearray
#endif
PETSC_EXTERN void dmdagetcoordinatearray_(DM *a, void *b, PetscErrorCode *ierr)
{
  *ierr = DMDAGetCoordinateArray(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmda.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmdarestorecoordinatearray_ DMDARESTORECOORDINATEARRAY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmdarestorecoordinatearray_ dmdarestorecoordinatearray
#endif
PETSC_EXTERN void dmdarestorecoordinatearray_(DM *a, void *b, PetscErrorCode *ierr)
{
  *ierr = DMDARestoreCoordinateArray(*a, b);
  if (*ierr) return;
}
