#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmswarm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmswarmsortdestroy_ DMSWARMSORTDESTROY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmswarmsortdestroy_ dmswarmsortdestroy
#endif
PETSC_EXTERN void dmswarmsortdestroy_(DMSwarmSort *a, PetscErrorCode *ierr)
{
  PETSC_FORTRAN_OBJECT_F_DESTROYED_TO_C_NULL(a);
  PetscBool null_a = !*(void**) a ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(a);
  *ierr = DMSwarmSortDestroy(a);
  if (*ierr) return;
  if (! null_a && !*(void**) a) *(void **) a = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmswarm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmswarmsortgetnumberofpointspercell_ DMSWARMSORTGETNUMBEROFPOINTSPERCELL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmswarmsortgetnumberofpointspercell_ dmswarmsortgetnumberofpointspercell
#endif
PETSC_EXTERN void dmswarmsortgetnumberofpointspercell_(DM *a, PetscInt *b, PetscInt *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  *ierr = DMSwarmSortGetNumberOfPointsPerCell(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmswarm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmswarmsortgetaccess_ DMSWARMSORTGETACCESS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmswarmsortgetaccess_ dmswarmsortgetaccess
#endif
PETSC_EXTERN void dmswarmsortgetaccess_(DM *a, PetscErrorCode *ierr)
{
  *ierr = DMSwarmSortGetAccess(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmswarm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmswarmsortrestoreaccess_ DMSWARMSORTRESTOREACCESS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmswarmsortrestoreaccess_ dmswarmsortrestoreaccess
#endif
PETSC_EXTERN void dmswarmsortrestoreaccess_(DM *a, PetscErrorCode *ierr)
{
  *ierr = DMSwarmSortRestoreAccess(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmswarm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmswarmsortgetisvalid_ DMSWARMSORTGETISVALID
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmswarmsortgetisvalid_ dmswarmsortgetisvalid
#endif
PETSC_EXTERN void dmswarmsortgetisvalid_(DM *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = DMSwarmSortGetIsValid(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmswarm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmswarmsortgetsizes_ DMSWARMSORTGETSIZES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmswarmsortgetsizes_ dmswarmsortgetsizes
#endif
PETSC_EXTERN void dmswarmsortgetsizes_(DM *a, PetscInt *b, PetscInt *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  CHKFORTRANNULLINTEGER(c);
  *ierr = DMSwarmSortGetSizes(*a, b, c);
  if (*ierr) return;
}
