#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexissimplex_ DMPLEXISSIMPLEX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexissimplex_ dmplexissimplex
#endif
PETSC_EXTERN void dmplexissimplex_(DM *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = DMPlexIsSimplex(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexgetsimplexorboxcells_ DMPLEXGETSIMPLEXORBOXCELLS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexgetsimplexorboxcells_ dmplexgetsimplexorboxcells
#endif
PETSC_EXTERN void dmplexgetsimplexorboxcells_(DM *a, PetscInt *b, PetscInt *c, PetscInt *d, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  CHKFORTRANNULLINTEGER(d);
  *ierr = DMPlexGetSimplexOrBoxCells(*a, *b, c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexvecview1d_ DMPLEXVECVIEW1D
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexvecview1d_ dmplexvecview1d
#endif
PETSC_EXTERN void dmplexvecview1d_(DM *a, PetscInt *b, Vec c[], PetscViewer *d, PetscErrorCode *ierr)
{
  PetscViewer v_d = PetscPatchDefaultViewers(d);
  *ierr = DMPlexVecView1D(*a, *b, c, v_d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplextopologyview_ DMPLEXTOPOLOGYVIEW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplextopologyview_ dmplextopologyview
#endif
PETSC_EXTERN void dmplextopologyview_(DM *a, PetscViewer *b, PetscErrorCode *ierr)
{
  PetscViewer v_b = PetscPatchDefaultViewers(b);
  *ierr = DMPlexTopologyView(*a, v_b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexcoordinatesview_ DMPLEXCOORDINATESVIEW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexcoordinatesview_ dmplexcoordinatesview
#endif
PETSC_EXTERN void dmplexcoordinatesview_(DM *a, PetscViewer *b, PetscErrorCode *ierr)
{
  PetscViewer v_b = PetscPatchDefaultViewers(b);
  *ierr = DMPlexCoordinatesView(*a, v_b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexlabelsview_ DMPLEXLABELSVIEW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexlabelsview_ dmplexlabelsview
#endif
PETSC_EXTERN void dmplexlabelsview_(DM *a, PetscViewer *b, PetscErrorCode *ierr)
{
  PetscViewer v_b = PetscPatchDefaultViewers(b);
  *ierr = DMPlexLabelsView(*a, v_b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexsectionview_ DMPLEXSECTIONVIEW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexsectionview_ dmplexsectionview
#endif
PETSC_EXTERN void dmplexsectionview_(DM *a, PetscViewer *b, DM *c, PetscErrorCode *ierr)
{
  PetscViewer v_b = PetscPatchDefaultViewers(b);
  *ierr = DMPlexSectionView(*a, v_b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexglobalvectorview_ DMPLEXGLOBALVECTORVIEW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexglobalvectorview_ dmplexglobalvectorview
#endif
PETSC_EXTERN void dmplexglobalvectorview_(DM *a, PetscViewer *b, DM *c, Vec *d, PetscErrorCode *ierr)
{
  PetscViewer v_b = PetscPatchDefaultViewers(b);
  *ierr = DMPlexGlobalVectorView(*a, v_b, *c, *d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexlocalvectorview_ DMPLEXLOCALVECTORVIEW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexlocalvectorview_ dmplexlocalvectorview
#endif
PETSC_EXTERN void dmplexlocalvectorview_(DM *a, PetscViewer *b, DM *c, Vec *d, PetscErrorCode *ierr)
{
  PetscViewer v_b = PetscPatchDefaultViewers(b);
  *ierr = DMPlexLocalVectorView(*a, v_b, *c, *d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplextopologyload_ DMPLEXTOPOLOGYLOAD
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplextopologyload_ dmplextopologyload
#endif
PETSC_EXTERN void dmplextopologyload_(DM *a, PetscViewer *b, PetscSF *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  PetscViewer v_b = PetscPatchDefaultViewers(b);
  CHKFORTRANNULLOBJECT(c);
  *ierr = DMPlexTopologyLoad(*a, v_b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexcoordinatesload_ DMPLEXCOORDINATESLOAD
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexcoordinatesload_ dmplexcoordinatesload
#endif
PETSC_EXTERN void dmplexcoordinatesload_(DM *a, PetscViewer *b, PetscSF *c, PetscErrorCode *ierr)
{
  PetscViewer v_b = PetscPatchDefaultViewers(b);
  *ierr = DMPlexCoordinatesLoad(*a, v_b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexlabelsload_ DMPLEXLABELSLOAD
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexlabelsload_ dmplexlabelsload
#endif
PETSC_EXTERN void dmplexlabelsload_(DM *a, PetscViewer *b, PetscSF *c, PetscErrorCode *ierr)
{
  PetscViewer v_b = PetscPatchDefaultViewers(b);
  *ierr = DMPlexLabelsLoad(*a, v_b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexsectionload_ DMPLEXSECTIONLOAD
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexsectionload_ dmplexsectionload
#endif
PETSC_EXTERN void dmplexsectionload_(DM *a, PetscViewer *b, DM *c, PetscSF *d, PetscSF *e, PetscSF *f, PetscErrorCode *ierr)
{
  PetscBool null_e = !*(void**) e ? PETSC_TRUE : PETSC_FALSE;
  PetscBool null_f = !*(void**) f ? PETSC_TRUE : PETSC_FALSE;
  PetscViewer v_b = PetscPatchDefaultViewers(b);
  CHKFORTRANNULLOBJECT(e);
  CHKFORTRANNULLOBJECT(f);
  *ierr = DMPlexSectionLoad(*a, v_b, *c, *d, e, f);
  if (*ierr) return;
  if (! null_e && !*(void**) e) *(void **) e = (void *)-2;
  if (! null_f && !*(void**) f) *(void **) f = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexglobalvectorload_ DMPLEXGLOBALVECTORLOAD
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexglobalvectorload_ dmplexglobalvectorload
#endif
PETSC_EXTERN void dmplexglobalvectorload_(DM *a, PetscViewer *b, DM *c, PetscSF *d, Vec *e, PetscErrorCode *ierr)
{
  PetscViewer v_b = PetscPatchDefaultViewers(b);
  *ierr = DMPlexGlobalVectorLoad(*a, v_b, *c, *d, *e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexlocalvectorload_ DMPLEXLOCALVECTORLOAD
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexlocalvectorload_ dmplexlocalvectorload
#endif
PETSC_EXTERN void dmplexlocalvectorload_(DM *a, PetscViewer *b, DM *c, PetscSF *d, Vec *e, PetscErrorCode *ierr)
{
  PetscViewer v_b = PetscPatchDefaultViewers(b);
  *ierr = DMPlexLocalVectorLoad(*a, v_b, *c, *d, *e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexgetsubdomainsection_ DMPLEXGETSUBDOMAINSECTION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexgetsubdomainsection_ dmplexgetsubdomainsection
#endif
PETSC_EXTERN void dmplexgetsubdomainsection_(DM *a, PetscSection *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = DMPlexGetSubdomainSection(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexgetchart_ DMPLEXGETCHART
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexgetchart_ dmplexgetchart
#endif
PETSC_EXTERN void dmplexgetchart_(DM *a, PetscInt *b, PetscInt *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  CHKFORTRANNULLINTEGER(c);
  *ierr = DMPlexGetChart(*a, b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexsetchart_ DMPLEXSETCHART
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexsetchart_ dmplexsetchart
#endif
PETSC_EXTERN void dmplexsetchart_(DM *a, PetscInt *b, PetscInt *c, PetscErrorCode *ierr)
{
  *ierr = DMPlexSetChart(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexgetconesize_ DMPLEXGETCONESIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexgetconesize_ dmplexgetconesize
#endif
PETSC_EXTERN void dmplexgetconesize_(DM *a, PetscInt *b, PetscInt *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  *ierr = DMPlexGetConeSize(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexsetconesize_ DMPLEXSETCONESIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexsetconesize_ dmplexsetconesize
#endif
PETSC_EXTERN void dmplexsetconesize_(DM *a, PetscInt *b, PetscInt *c, PetscErrorCode *ierr)
{
  *ierr = DMPlexSetConeSize(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexgetconetuple_ DMPLEXGETCONETUPLE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexgetconetuple_ dmplexgetconetuple
#endif
PETSC_EXTERN void dmplexgetconetuple_(DM *a, IS *b, PetscSection *c, IS *d, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  PetscBool null_d = !*(void**) d ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  CHKFORTRANNULLOBJECT(d);
  *ierr = DMPlexGetConeTuple(*a, *b, c, d);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
  if (! null_d && !*(void**) d) *(void **) d = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexgetconerecursivevertices_ DMPLEXGETCONERECURSIVEVERTICES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexgetconerecursivevertices_ dmplexgetconerecursivevertices
#endif
PETSC_EXTERN void dmplexgetconerecursivevertices_(DM *a, IS *b, IS *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  *ierr = DMPlexGetConeRecursiveVertices(*a, *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexsetcone_ DMPLEXSETCONE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexsetcone_ dmplexsetcone
#endif
PETSC_EXTERN void dmplexsetcone_(DM *a, PetscInt *b, const PetscInt c[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  *ierr = DMPlexSetCone(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexsetconeorientation_ DMPLEXSETCONEORIENTATION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexsetconeorientation_ dmplexsetconeorientation
#endif
PETSC_EXTERN void dmplexsetconeorientation_(DM *a, PetscInt *b, const PetscInt c[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  *ierr = DMPlexSetConeOrientation(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexinsertcone_ DMPLEXINSERTCONE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexinsertcone_ dmplexinsertcone
#endif
PETSC_EXTERN void dmplexinsertcone_(DM *a, PetscInt *b, PetscInt *c, PetscInt *d, PetscErrorCode *ierr)
{
  *ierr = DMPlexInsertCone(*a, *b, *c, *d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexinsertconeorientation_ DMPLEXINSERTCONEORIENTATION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexinsertconeorientation_ dmplexinsertconeorientation
#endif
PETSC_EXTERN void dmplexinsertconeorientation_(DM *a, PetscInt *b, PetscInt *c, PetscInt *d, PetscErrorCode *ierr)
{
  *ierr = DMPlexInsertConeOrientation(*a, *b, *c, *d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexgetsupportsize_ DMPLEXGETSUPPORTSIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexgetsupportsize_ dmplexgetsupportsize
#endif
PETSC_EXTERN void dmplexgetsupportsize_(DM *a, PetscInt *b, PetscInt *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  *ierr = DMPlexGetSupportSize(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexsetsupportsize_ DMPLEXSETSUPPORTSIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexsetsupportsize_ dmplexsetsupportsize
#endif
PETSC_EXTERN void dmplexsetsupportsize_(DM *a, PetscInt *b, PetscInt *c, PetscErrorCode *ierr)
{
  *ierr = DMPlexSetSupportSize(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexsetsupport_ DMPLEXSETSUPPORT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexsetsupport_ dmplexsetsupport
#endif
PETSC_EXTERN void dmplexsetsupport_(DM *a, PetscInt *b, const PetscInt c[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  *ierr = DMPlexSetSupport(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexinsertsupport_ DMPLEXINSERTSUPPORT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexinsertsupport_ dmplexinsertsupport
#endif
PETSC_EXTERN void dmplexinsertsupport_(DM *a, PetscInt *b, PetscInt *c, PetscInt *d, PetscErrorCode *ierr)
{
  *ierr = DMPlexInsertSupport(*a, *b, *c, *d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexgetmaxsizes_ DMPLEXGETMAXSIZES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexgetmaxsizes_ dmplexgetmaxsizes
#endif
PETSC_EXTERN void dmplexgetmaxsizes_(DM *a, PetscInt *b, PetscInt *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  CHKFORTRANNULLINTEGER(c);
  *ierr = DMPlexGetMaxSizes(*a, b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexsymmetrize_ DMPLEXSYMMETRIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexsymmetrize_ dmplexsymmetrize
#endif
PETSC_EXTERN void dmplexsymmetrize_(DM *a, PetscErrorCode *ierr)
{
  *ierr = DMPlexSymmetrize(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexstratify_ DMPLEXSTRATIFY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexstratify_ dmplexstratify
#endif
PETSC_EXTERN void dmplexstratify_(DM *a, PetscErrorCode *ierr)
{
  *ierr = DMPlexStratify(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexcomputecelltypes_ DMPLEXCOMPUTECELLTYPES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexcomputecelltypes_ dmplexcomputecelltypes
#endif
PETSC_EXTERN void dmplexcomputecelltypes_(DM *a, PetscErrorCode *ierr)
{
  *ierr = DMPlexComputeCellTypes(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexequal_ DMPLEXEQUAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexequal_ dmplexequal
#endif
PETSC_EXTERN void dmplexequal_(DM *a, DM *b, PetscBool *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(c);
  *ierr = DMPlexEqual(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexgetnumfacevertices_ DMPLEXGETNUMFACEVERTICES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexgetnumfacevertices_ dmplexgetnumfacevertices
#endif
PETSC_EXTERN void dmplexgetnumfacevertices_(DM *a, PetscInt *b, PetscInt *c, PetscInt *d, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(d);
  *ierr = DMPlexGetNumFaceVertices(*a, *b, *c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexgetdepthlabel_ DMPLEXGETDEPTHLABEL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexgetdepthlabel_ dmplexgetdepthlabel
#endif
PETSC_EXTERN void dmplexgetdepthlabel_(DM *a, DMLabel *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = DMPlexGetDepthLabel(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexgetdepth_ DMPLEXGETDEPTH
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexgetdepth_ dmplexgetdepth
#endif
PETSC_EXTERN void dmplexgetdepth_(DM *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = DMPlexGetDepth(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexgetdepthstratum_ DMPLEXGETDEPTHSTRATUM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexgetdepthstratum_ dmplexgetdepthstratum
#endif
PETSC_EXTERN void dmplexgetdepthstratum_(DM *a, PetscInt *b, PetscInt *c, PetscInt *d, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  CHKFORTRANNULLINTEGER(d);
  *ierr = DMPlexGetDepthStratum(*a, *b, c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexgetheightstratum_ DMPLEXGETHEIGHTSTRATUM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexgetheightstratum_ dmplexgetheightstratum
#endif
PETSC_EXTERN void dmplexgetheightstratum_(DM *a, PetscInt *b, PetscInt *c, PetscInt *d, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  CHKFORTRANNULLINTEGER(d);
  *ierr = DMPlexGetHeightStratum(*a, *b, c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexgetpointdepth_ DMPLEXGETPOINTDEPTH
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexgetpointdepth_ dmplexgetpointdepth
#endif
PETSC_EXTERN void dmplexgetpointdepth_(DM *a, PetscInt *b, PetscInt *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  *ierr = DMPlexGetPointDepth(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexgetpointheight_ DMPLEXGETPOINTHEIGHT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexgetpointheight_ dmplexgetpointheight
#endif
PETSC_EXTERN void dmplexgetpointheight_(DM *a, PetscInt *b, PetscInt *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  *ierr = DMPlexGetPointHeight(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexgetcelltypelabel_ DMPLEXGETCELLTYPELABEL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexgetcelltypelabel_ dmplexgetcelltypelabel
#endif
PETSC_EXTERN void dmplexgetcelltypelabel_(DM *a, DMLabel *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = DMPlexGetCellTypeLabel(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexgetcelltype_ DMPLEXGETCELLTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexgetcelltype_ dmplexgetcelltype
#endif
PETSC_EXTERN void dmplexgetcelltype_(DM *a, PetscInt *b, DMPolytopeType *c, PetscErrorCode *ierr)
{
  *ierr = DMPlexGetCellType(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexsetcelltype_ DMPLEXSETCELLTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexsetcelltype_ dmplexsetcelltype
#endif
PETSC_EXTERN void dmplexsetcelltype_(DM *a, PetscInt *b, DMPolytopeType *c, PetscErrorCode *ierr)
{
  *ierr = DMPlexSetCellType(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexgetconesection_ DMPLEXGETCONESECTION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexgetconesection_ dmplexgetconesection
#endif
PETSC_EXTERN void dmplexgetconesection_(DM *a, PetscSection *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = DMPlexGetConeSection(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexgetsupportsection_ DMPLEXGETSUPPORTSECTION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexgetsupportsection_ dmplexgetsupportsection
#endif
PETSC_EXTERN void dmplexgetsupportsection_(DM *a, PetscSection *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = DMPlexGetSupportSection(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexsetclosurepermutationtensor_ DMPLEXSETCLOSUREPERMUTATIONTENSOR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexsetclosurepermutationtensor_ dmplexsetclosurepermutationtensor
#endif
PETSC_EXTERN void dmplexsetclosurepermutationtensor_(DM *a, PetscInt *b, PetscSection *c, PetscErrorCode *ierr)
{
  *ierr = DMPlexSetClosurePermutationTensor(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexvecsetclosure_ DMPLEXVECSETCLOSURE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexvecsetclosure_ dmplexvecsetclosure
#endif
PETSC_EXTERN void dmplexvecsetclosure_(DM *a, PetscSection *b, Vec *c, PetscInt *d, const PetscScalar e[], InsertMode *f, PetscErrorCode *ierr)
{
  CHKFORTRANNULLSCALAR(e);
  *ierr = DMPlexVecSetClosure(*a, *b, *c, *d, e, *f);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexmatsetclosure_ DMPLEXMATSETCLOSURE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexmatsetclosure_ dmplexmatsetclosure
#endif
PETSC_EXTERN void dmplexmatsetclosure_(DM *a, PetscSection *b, PetscSection *c, Mat *d, PetscInt *e, const PetscScalar f[], InsertMode *g, PetscErrorCode *ierr)
{
  CHKFORTRANNULLSCALAR(f);
  *ierr = DMPlexMatSetClosure(*a, *b, *c, *d, *e, f, *g);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexmatsetclosuregeneral_ DMPLEXMATSETCLOSUREGENERAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexmatsetclosuregeneral_ dmplexmatsetclosuregeneral
#endif
PETSC_EXTERN void dmplexmatsetclosuregeneral_(DM *a, PetscSection *b, PetscSection *c, PetscBool *d, DM *e, PetscSection *f, PetscSection *g, PetscBool *h, Mat *i, PetscInt *j, const PetscScalar k[], InsertMode *l, PetscErrorCode *ierr)
{
  CHKFORTRANNULLSCALAR(k);
  *ierr = DMPlexMatSetClosureGeneral(*a, *b, *c, *d ? PETSC_TRUE : PETSC_FALSE, *e, *f, *g, *h ? PETSC_TRUE : PETSC_FALSE, *i, *j, k, *l);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexmatsetclosurerefined_ DMPLEXMATSETCLOSUREREFINED
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexmatsetclosurerefined_ dmplexmatsetclosurerefined
#endif
PETSC_EXTERN void dmplexmatsetclosurerefined_(DM *a, PetscSection *b, PetscSection *c, DM *d, PetscSection *e, PetscSection *f, Mat *g, PetscInt *h, const PetscScalar i[], InsertMode *j, PetscErrorCode *ierr)
{
  CHKFORTRANNULLSCALAR(i);
  *ierr = DMPlexMatSetClosureRefined(*a, *b, *c, *d, *e, *f, *g, *h, i, *j);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexmatgetclosureindicesrefined_ DMPLEXMATGETCLOSUREINDICESREFINED
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexmatgetclosureindicesrefined_ dmplexmatgetclosureindicesrefined
#endif
PETSC_EXTERN void dmplexmatgetclosureindicesrefined_(DM *a, PetscSection *b, PetscSection *c, DM *d, PetscSection *e, PetscSection *f, PetscInt *g, PetscInt h[], PetscInt i[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(h);
  CHKFORTRANNULLINTEGER(i);
  *ierr = DMPlexMatGetClosureIndicesRefined(*a, *b, *c, *d, *e, *f, *g, h, i);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexgetvtkcellheight_ DMPLEXGETVTKCELLHEIGHT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexgetvtkcellheight_ dmplexgetvtkcellheight
#endif
PETSC_EXTERN void dmplexgetvtkcellheight_(DM *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = DMPlexGetVTKCellHeight(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexsetvtkcellheight_ DMPLEXSETVTKCELLHEIGHT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexsetvtkcellheight_ dmplexsetvtkcellheight
#endif
PETSC_EXTERN void dmplexsetvtkcellheight_(DM *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = DMPlexSetVTKCellHeight(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexgetcelltypestratum_ DMPLEXGETCELLTYPESTRATUM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexgetcelltypestratum_ dmplexgetcelltypestratum
#endif
PETSC_EXTERN void dmplexgetcelltypestratum_(DM *a, DMPolytopeType *b, PetscInt *c, PetscInt *d, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  CHKFORTRANNULLINTEGER(d);
  *ierr = DMPlexGetCellTypeStratum(*a, *b, c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexgetdepthstratumglobalsize_ DMPLEXGETDEPTHSTRATUMGLOBALSIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexgetdepthstratumglobalsize_ dmplexgetdepthstratumglobalsize
#endif
PETSC_EXTERN void dmplexgetdepthstratumglobalsize_(DM *a, PetscInt *b, PetscInt *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  *ierr = DMPlexGetDepthStratumGlobalSize(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexcreatecellnumbering_ DMPLEXCREATECELLNUMBERING
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexcreatecellnumbering_ dmplexcreatecellnumbering
#endif
PETSC_EXTERN void dmplexcreatecellnumbering_(DM *a, PetscBool *b, IS *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  *ierr = DMPlexCreateCellNumbering(*a, *b ? PETSC_TRUE : PETSC_FALSE, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexgetcellnumbering_ DMPLEXGETCELLNUMBERING
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexgetcellnumbering_ dmplexgetcellnumbering
#endif
PETSC_EXTERN void dmplexgetcellnumbering_(DM *a, IS *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = DMPlexGetCellNumbering(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexgetvertexnumbering_ DMPLEXGETVERTEXNUMBERING
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexgetvertexnumbering_ dmplexgetvertexnumbering
#endif
PETSC_EXTERN void dmplexgetvertexnumbering_(DM *a, IS *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = DMPlexGetVertexNumbering(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexcreatepointnumbering_ DMPLEXCREATEPOINTNUMBERING
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexcreatepointnumbering_ dmplexcreatepointnumbering
#endif
PETSC_EXTERN void dmplexcreatepointnumbering_(DM *a, IS *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = DMPlexCreatePointNumbering(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexcreateedgenumbering_ DMPLEXCREATEEDGENUMBERING
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexcreateedgenumbering_ dmplexcreateedgenumbering
#endif
PETSC_EXTERN void dmplexcreateedgenumbering_(DM *a, IS *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = DMPlexCreateEdgeNumbering(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexcreaterankfield_ DMPLEXCREATERANKFIELD
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexcreaterankfield_ dmplexcreaterankfield
#endif
PETSC_EXTERN void dmplexcreaterankfield_(DM *a, Vec *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = DMPlexCreateRankField(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexcreatelabelfield_ DMPLEXCREATELABELFIELD
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexcreatelabelfield_ dmplexcreatelabelfield
#endif
PETSC_EXTERN void dmplexcreatelabelfield_(DM *a, DMLabel *b, Vec *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  *ierr = DMPlexCreateLabelField(*a, *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexchecksymmetry_ DMPLEXCHECKSYMMETRY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexchecksymmetry_ dmplexchecksymmetry
#endif
PETSC_EXTERN void dmplexchecksymmetry_(DM *a, PetscErrorCode *ierr)
{
  *ierr = DMPlexCheckSymmetry(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexcheckskeleton_ DMPLEXCHECKSKELETON
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexcheckskeleton_ dmplexcheckskeleton
#endif
PETSC_EXTERN void dmplexcheckskeleton_(DM *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = DMPlexCheckSkeleton(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexcheckfaces_ DMPLEXCHECKFACES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexcheckfaces_ dmplexcheckfaces
#endif
PETSC_EXTERN void dmplexcheckfaces_(DM *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = DMPlexCheckFaces(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexcheckgeometry_ DMPLEXCHECKGEOMETRY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexcheckgeometry_ dmplexcheckgeometry
#endif
PETSC_EXTERN void dmplexcheckgeometry_(DM *a, PetscErrorCode *ierr)
{
  *ierr = DMPlexCheckGeometry(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexcheckpointsf_ DMPLEXCHECKPOINTSF
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexcheckpointsf_ dmplexcheckpointsf
#endif
PETSC_EXTERN void dmplexcheckpointsf_(DM *a, PetscSF *b, PetscBool *c, PetscErrorCode *ierr)
{
  *ierr = DMPlexCheckPointSF(*a, *b, *c ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexcheckorphanvertices_ DMPLEXCHECKORPHANVERTICES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexcheckorphanvertices_ dmplexcheckorphanvertices
#endif
PETSC_EXTERN void dmplexcheckorphanvertices_(DM *a, PetscErrorCode *ierr)
{
  *ierr = DMPlexCheckOrphanVertices(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexcheck_ DMPLEXCHECK
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexcheck_ dmplexcheck
#endif
PETSC_EXTERN void dmplexcheck_(DM *a, PetscErrorCode *ierr)
{
  *ierr = DMPlexCheck(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexcheckcellshape_ DMPLEXCHECKCELLSHAPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexcheckcellshape_ dmplexcheckcellshape
#endif
PETSC_EXTERN void dmplexcheckcellshape_(DM *a, PetscBool *b, PetscReal *c, PetscErrorCode *ierr)
{
  *ierr = DMPlexCheckCellShape(*a, *b ? PETSC_TRUE : PETSC_FALSE, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexcomputeorthogonalquality_ DMPLEXCOMPUTEORTHOGONALQUALITY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexcomputeorthogonalquality_ dmplexcomputeorthogonalquality
#endif
PETSC_EXTERN void dmplexcomputeorthogonalquality_(DM *a, PetscFV *b, PetscReal *c, Vec *d, DMLabel *e, PetscErrorCode *ierr)
{
  PetscBool null_d = !*(void**) d ? PETSC_TRUE : PETSC_FALSE;
  PetscBool null_e = !*(void**) e ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(d);
  CHKFORTRANNULLOBJECT(e);
  *ierr = DMPlexComputeOrthogonalQuality(*a, *b, *c, d, e);
  if (*ierr) return;
  if (! null_d && !*(void**) d) *(void **) d = (void *)-2;
  if (! null_e && !*(void**) e) *(void **) e = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexgetregularrefinement_ DMPLEXGETREGULARREFINEMENT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexgetregularrefinement_ dmplexgetregularrefinement
#endif
PETSC_EXTERN void dmplexgetregularrefinement_(DM *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = DMPlexGetRegularRefinement(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexsetregularrefinement_ DMPLEXSETREGULARREFINEMENT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexsetregularrefinement_ dmplexsetregularrefinement
#endif
PETSC_EXTERN void dmplexsetregularrefinement_(DM *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = DMPlexSetRegularRefinement(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexgetanchors_ DMPLEXGETANCHORS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexgetanchors_ dmplexgetanchors
#endif
PETSC_EXTERN void dmplexgetanchors_(DM *a, PetscSection *b, IS *c, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  CHKFORTRANNULLOBJECT(c);
  *ierr = DMPlexGetAnchors(*a, b, c);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexsetanchors_ DMPLEXSETANCHORS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexsetanchors_ dmplexsetanchors
#endif
PETSC_EXTERN void dmplexsetanchors_(DM *a, PetscSection *b, IS *c, PetscErrorCode *ierr)
{
  *ierr = DMPlexSetAnchors(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexmonitorthroughput_ DMPLEXMONITORTHROUGHPUT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexmonitorthroughput_ dmplexmonitorthroughput
#endif
PETSC_EXTERN void dmplexmonitorthroughput_(DM *a, void *b, PetscErrorCode *ierr)
{
  *ierr = DMPlexMonitorThroughput(*a, b);
  if (*ierr) return;
}
