#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmda.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmdagetnumcells_ DMDAGETNUMCELLS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmdagetnumcells_ dmdagetnumcells
#endif
PETSC_EXTERN void dmdagetnumcells_(DM *a, PetscInt *b, PetscInt *c, PetscInt *d, PetscInt *e, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  CHKFORTRANNULLINTEGER(c);
  CHKFORTRANNULLINTEGER(d);
  CHKFORTRANNULLINTEGER(e);
  *ierr = DMDAGetNumCells(*a, b, c, d, e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmda.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmdagetcellpoint_ DMDAGETCELLPOINT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmdagetcellpoint_ dmdagetcellpoint
#endif
PETSC_EXTERN void dmdagetcellpoint_(DM *a, PetscInt *b, PetscInt *c, PetscInt *d, PetscInt *e, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(e);
  *ierr = DMDAGetCellPoint(*a, *b, *c, *d, e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmda.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmdagetnumvertices_ DMDAGETNUMVERTICES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmdagetnumvertices_ dmdagetnumvertices
#endif
PETSC_EXTERN void dmdagetnumvertices_(DM *a, PetscInt *b, PetscInt *c, PetscInt *d, PetscInt *e, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  CHKFORTRANNULLINTEGER(c);
  CHKFORTRANNULLINTEGER(d);
  CHKFORTRANNULLINTEGER(e);
  *ierr = DMDAGetNumVertices(*a, b, c, d, e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmda.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmdagetnumfaces_ DMDAGETNUMFACES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmdagetnumfaces_ dmdagetnumfaces
#endif
PETSC_EXTERN void dmdagetnumfaces_(DM *a, PetscInt *b, PetscInt *c, PetscInt *d, PetscInt *e, PetscInt *f, PetscInt *g, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  CHKFORTRANNULLINTEGER(c);
  CHKFORTRANNULLINTEGER(d);
  CHKFORTRANNULLINTEGER(e);
  CHKFORTRANNULLINTEGER(f);
  CHKFORTRANNULLINTEGER(g);
  *ierr = DMDAGetNumFaces(*a, b, c, d, e, f, g);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmda.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmdagetheightstratum_ DMDAGETHEIGHTSTRATUM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmdagetheightstratum_ dmdagetheightstratum
#endif
PETSC_EXTERN void dmdagetheightstratum_(DM *a, PetscInt *b, PetscInt *c, PetscInt *d, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  CHKFORTRANNULLINTEGER(d);
  *ierr = DMDAGetHeightStratum(*a, *b, c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmda.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmdagetdepthstratum_ DMDAGETDEPTHSTRATUM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmdagetdepthstratum_ dmdagetdepthstratum
#endif
PETSC_EXTERN void dmdagetdepthstratum_(DM *a, PetscInt *b, PetscInt *c, PetscInt *d, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  CHKFORTRANNULLINTEGER(d);
  *ierr = DMDAGetDepthStratum(*a, *b, c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmda.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmdasetvertexcoordinates_ DMDASETVERTEXCOORDINATES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmdasetvertexcoordinates_ dmdasetvertexcoordinates
#endif
PETSC_EXTERN void dmdasetvertexcoordinates_(DM *a, PetscReal *b, PetscReal *c, PetscReal *d, PetscReal *e, PetscReal *f, PetscReal *g, PetscErrorCode *ierr)
{
  *ierr = DMDASetVertexCoordinates(*a, *b, *c, *d, *e, *f, *g);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmda.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmdagetarray_ DMDAGETARRAY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmdagetarray_ dmdagetarray
#endif
PETSC_EXTERN void dmdagetarray_(DM *a, PetscBool *b, void *c, PetscErrorCode *ierr)
{
  *ierr = DMDAGetArray(*a, *b ? PETSC_TRUE : PETSC_FALSE, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmda.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmdarestorearray_ DMDARESTOREARRAY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmdarestorearray_ dmdarestorearray
#endif
PETSC_EXTERN void dmdarestorearray_(DM *a, PetscBool *b, void *c, PetscErrorCode *ierr)
{
  *ierr = DMDARestoreArray(*a, *b ? PETSC_TRUE : PETSC_FALSE, c);
  if (*ierr) return;
}
