#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmstag.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmstagcreate3d_ DMSTAGCREATE3D
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmstagcreate3d_ dmstagcreate3d
#endif
PETSC_EXTERN void dmstagcreate3d_(MPI_Fint *a, DMBoundaryType *b, DMBoundaryType *c, DMBoundaryType *d, PetscInt *e, PetscInt *f, PetscInt *g, PetscInt *h, PetscInt *i, PetscInt *j, PetscInt *k, PetscInt *l, PetscInt *m, PetscInt *n, DMStagStencilType *o, PetscInt *p, const PetscInt q[], const PetscInt r[], const PetscInt s[], DM *w, PetscErrorCode *ierr)
{
  PetscBool null_w = !*(void**) w ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLINTEGER(q);
  CHKFORTRANNULLINTEGER(r);
  CHKFORTRANNULLINTEGER(s);
  CHKFORTRANNULLOBJECT(w);
  *ierr = DMStagCreate3d(MPI_Comm_f2c(*(a)), *b, *c, *d, *e, *f, *g, *h, *i, *j, *k, *l, *m, *n, *o, *p, q, r, s, w);
  if (*ierr) return;
  if (! null_w && !*(void**) w) *(void **) w = (void *)-2;
}
