#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdraw.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdrawbarcreate_ PETSCDRAWBARCREATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdrawbarcreate_ petscdrawbarcreate
#endif
PETSC_EXTERN void petscdrawbarcreate_(PetscDraw *a, PetscDrawBar *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  PETSC_FORTRAN_OBJECT_CREATE(b);
  CHKFORTRANNULLOBJECT(b);
  *ierr = PetscDrawBarCreate(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdraw.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdrawbardestroy_ PETSCDRAWBARDESTROY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdrawbardestroy_ petscdrawbardestroy
#endif
PETSC_EXTERN void petscdrawbardestroy_(PetscDrawBar *a, PetscErrorCode *ierr)
{
  PETSC_FORTRAN_OBJECT_F_DESTROYED_TO_C_NULL(a);
  PetscBool null_a = !*(void**) a ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(a);
  *ierr = PetscDrawBarDestroy(a);
  if (*ierr) return;
  if (! null_a && !*(void**) a) *(void **) a = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdraw.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdrawbardraw_ PETSCDRAWBARDRAW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdrawbardraw_ petscdrawbardraw
#endif
PETSC_EXTERN void petscdrawbardraw_(PetscDrawBar *a, PetscErrorCode *ierr)
{
  *ierr = PetscDrawBarDraw(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdraw.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdrawbarsave_ PETSCDRAWBARSAVE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdrawbarsave_ petscdrawbarsave
#endif
PETSC_EXTERN void petscdrawbarsave_(PetscDrawBar *a, PetscErrorCode *ierr)
{
  *ierr = PetscDrawBarSave(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdraw.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdrawbarsetcolor_ PETSCDRAWBARSETCOLOR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdrawbarsetcolor_ petscdrawbarsetcolor
#endif
PETSC_EXTERN void petscdrawbarsetcolor_(PetscDrawBar *a, int *b, PetscErrorCode *ierr)
{
  *ierr = PetscDrawBarSetColor(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdraw.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdrawbarsort_ PETSCDRAWBARSORT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdrawbarsort_ petscdrawbarsort
#endif
PETSC_EXTERN void petscdrawbarsort_(PetscDrawBar *a, PetscBool *b, PetscReal *c, PetscErrorCode *ierr)
{
  *ierr = PetscDrawBarSort(*a, *b ? PETSC_TRUE : PETSC_FALSE, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdraw.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdrawbarsetlimits_ PETSCDRAWBARSETLIMITS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdrawbarsetlimits_ petscdrawbarsetlimits
#endif
PETSC_EXTERN void petscdrawbarsetlimits_(PetscDrawBar *a, PetscReal *b, PetscReal *c, PetscErrorCode *ierr)
{
  *ierr = PetscDrawBarSetLimits(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdraw.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdrawbargetaxis_ PETSCDRAWBARGETAXIS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdrawbargetaxis_ petscdrawbargetaxis
#endif
PETSC_EXTERN void petscdrawbargetaxis_(PetscDrawBar *a, PetscDrawAxis *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = PetscDrawBarGetAxis(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdraw.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdrawbargetdraw_ PETSCDRAWBARGETDRAW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdrawbargetdraw_ petscdrawbargetdraw
#endif
PETSC_EXTERN void petscdrawbargetdraw_(PetscDrawBar *a, PetscDraw *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = PetscDrawBarGetDraw(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdraw.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdrawbarsetfromoptions_ PETSCDRAWBARSETFROMOPTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdrawbarsetfromoptions_ petscdrawbarsetfromoptions
#endif
PETSC_EXTERN void petscdrawbarsetfromoptions_(PetscDrawBar *a, PetscErrorCode *ierr)
{
  *ierr = PetscDrawBarSetFromOptions(*a);
  if (*ierr) return;
}
