#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdraw.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdrawopenimage_ PETSCDRAWOPENIMAGE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdrawopenimage_ petscdrawopenimage
#endif
PETSC_EXTERN void petscdrawopenimage_(MPI_Fint *a, char b[], int *c, int *d, PetscDraw *e, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  PetscBool null_e = !*(void**) e ? PETSC_TRUE : PETSC_FALSE;
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  CHKFORTRANNULLOBJECT(e);
  *ierr = PetscDrawOpenImage(MPI_Comm_f2c(*(a)), c_b, *c, *d, e);
  if (*ierr) return;
  FREECHAR(b, c_b);
  if (! null_e && !*(void**) e) *(void **) e = (void *)-2;
}
