#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscpf.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pfdestroy_ PFDESTROY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pfdestroy_ pfdestroy
#endif
PETSC_EXTERN void pfdestroy_(PF *a, PetscErrorCode *ierr)
{
  PETSC_FORTRAN_OBJECT_F_DESTROYED_TO_C_NULL(a);
  PetscBool null_a = !*(void**) a ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(a);
  *ierr = PFDestroy(a);
  if (*ierr) return;
  if (! null_a && !*(void**) a) *(void **) a = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscpf.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pfcreate_ PFCREATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pfcreate_ pfcreate
#endif
PETSC_EXTERN void pfcreate_(MPI_Fint *a, PetscInt *b, PetscInt *c, PF *d, PetscErrorCode *ierr)
{
  PetscBool null_d = !*(void**) d ? PETSC_TRUE : PETSC_FALSE;
  PETSC_FORTRAN_OBJECT_CREATE(d);
  CHKFORTRANNULLOBJECT(d);
  *ierr = PFCreate(MPI_Comm_f2c(*(a)), *b, *c, d);
  if (*ierr) return;
  if (! null_d && !*(void**) d) *(void **) d = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscpf.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pfapplyvec_ PFAPPLYVEC
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pfapplyvec_ pfapplyvec
#endif
PETSC_EXTERN void pfapplyvec_(PF *a, Vec *b, Vec *c, PetscErrorCode *ierr)
{
  *ierr = PFApplyVec(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscpf.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pfapply_ PFAPPLY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pfapply_ pfapply
#endif
PETSC_EXTERN void pfapply_(PF *a, PetscInt *b, const PetscScalar *c, PetscScalar *d, PetscErrorCode *ierr)
{
  CHKFORTRANNULLSCALAR(c);
  CHKFORTRANNULLSCALAR(d);
  *ierr = PFApply(*a, *b, c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscpf.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pfviewfromoptions_ PFVIEWFROMOPTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pfviewfromoptions_ pfviewfromoptions
#endif
PETSC_EXTERN void pfviewfromoptions_(PF *a, PetscObject *b, char c[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_c)
{
  char* c_c;
  FIXCHAR(c, l_c, c_c);
  *ierr = PFViewFromOptions(*a, *b, c_c);
  if (*ierr) return;
  FREECHAR(c, c_c);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscpf.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pfview_ PFVIEW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pfview_ pfview
#endif
PETSC_EXTERN void pfview_(PF *a, PetscViewer *b, PetscErrorCode *ierr)
{
  PetscViewer v_b = PetscPatchDefaultViewers(b);
  *ierr = PFView(*a, v_b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscpf.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pfgettype_ PFGETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pfgettype_ pfgettype
#endif
PETSC_EXTERN void pfgettype_(PF *a, char * b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b = PETSC_NULLPTR;
  *ierr = PFGetType(*a, (const char **)&c_b);
  if (*ierr) return;
  *ierr = PetscStrncpy((char *)b, c_b, l_b);
  if (*ierr) return;
  FIXRETURNCHAR(PETSC_TRUE, b, l_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscpf.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pfsettype_ PFSETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pfsettype_ pfsettype
#endif
PETSC_EXTERN void pfsettype_(PF *a, char * b, void *c, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = PFSetType(*a, c_b, c);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscpf.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pfsetfromoptions_ PFSETFROMOPTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pfsetfromoptions_ pfsetfromoptions
#endif
PETSC_EXTERN void pfsetfromoptions_(PF *a, PetscErrorCode *ierr)
{
  *ierr = PFSetFromOptions(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscpf.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pffinalizepackage_ PFFINALIZEPACKAGE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pffinalizepackage_ pffinalizepackage
#endif
PETSC_EXTERN void pffinalizepackage_(PetscErrorCode *ierr)
{
  *ierr = PFFinalizePackage();
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscpf.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pfinitializepackage_ PFINITIALIZEPACKAGE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pfinitializepackage_ pfinitializepackage
#endif
PETSC_EXTERN void pfinitializepackage_(PetscErrorCode *ierr)
{
  *ierr = PFInitializePackage();
  if (*ierr) return;
}
