#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmpatch.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmpatchcreate_ DMPATCHCREATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmpatchcreate_ dmpatchcreate
#endif
PETSC_EXTERN void dmpatchcreate_(MPI_Fint *a, DM *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  PETSC_FORTRAN_OBJECT_CREATE(b);
  CHKFORTRANNULLOBJECT(b);
  *ierr = DMPatchCreate(MPI_Comm_f2c(*(a)), b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmpatch.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmpatchcreategrid_ DMPATCHCREATEGRID
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmpatchcreategrid_ dmpatchcreategrid
#endif
PETSC_EXTERN void dmpatchcreategrid_(MPI_Fint *a, PetscInt *b, MatStencil *c, MatStencil *d, MatStencil *e, DM *f, PetscErrorCode *ierr)
{
  PetscBool null_f = !*(void**) f ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(f);
  *ierr = DMPatchCreateGrid(MPI_Comm_f2c(*(a)), *b, *c, *d, *e, f);
  if (*ierr) return;
  if (! null_f && !*(void**) f) *(void **) f = (void *)-2;
}
