#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscconvest.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscconvestdestroy_ PETSCCONVESTDESTROY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscconvestdestroy_ petscconvestdestroy
#endif
PETSC_EXTERN void petscconvestdestroy_(PetscConvEst *a, PetscErrorCode *ierr)
{
  PETSC_FORTRAN_OBJECT_F_DESTROYED_TO_C_NULL(a);
  PetscBool null_a = !*(void**) a ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(a);
  *ierr = PetscConvEstDestroy(a);
  if (*ierr) return;
  if (! null_a && !*(void**) a) *(void **) a = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscconvest.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscconvestsetfromoptions_ PETSCCONVESTSETFROMOPTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscconvestsetfromoptions_ petscconvestsetfromoptions
#endif
PETSC_EXTERN void petscconvestsetfromoptions_(PetscConvEst *a, PetscErrorCode *ierr)
{
  *ierr = PetscConvEstSetFromOptions(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscconvest.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscconvestview_ PETSCCONVESTVIEW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscconvestview_ petscconvestview
#endif
PETSC_EXTERN void petscconvestview_(PetscConvEst *a, PetscViewer *b, PetscErrorCode *ierr)
{
  PetscViewer v_b = PetscPatchDefaultViewers(b);
  *ierr = PetscConvEstView(*a, v_b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscconvest.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscconvestgetsolver_ PETSCCONVESTGETSOLVER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscconvestgetsolver_ petscconvestgetsolver
#endif
PETSC_EXTERN void petscconvestgetsolver_(PetscConvEst *a, PetscObject *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = PetscConvEstGetSolver(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscconvest.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscconvestsetsolver_ PETSCCONVESTSETSOLVER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscconvestsetsolver_ petscconvestsetsolver
#endif
PETSC_EXTERN void petscconvestsetsolver_(PetscConvEst *a, PetscObject *b, PetscErrorCode *ierr)
{
  *ierr = PetscConvEstSetSolver(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscconvest.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscconvestsetup_ PETSCCONVESTSETUP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscconvestsetup_ petscconvestsetup
#endif
PETSC_EXTERN void petscconvestsetup_(PetscConvEst *a, PetscErrorCode *ierr)
{
  *ierr = PetscConvEstSetUp(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscconvest.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscconvestcomputeinitialguess_ PETSCCONVESTCOMPUTEINITIALGUESS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscconvestcomputeinitialguess_ petscconvestcomputeinitialguess
#endif
PETSC_EXTERN void petscconvestcomputeinitialguess_(PetscConvEst *a, PetscInt *b, DM *c, Vec *d, PetscErrorCode *ierr)
{
  *ierr = PetscConvEstComputeInitialGuess(*a, *b, *c, *d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscconvest.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscconvestcomputeerror_ PETSCCONVESTCOMPUTEERROR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscconvestcomputeerror_ petscconvestcomputeerror
#endif
PETSC_EXTERN void petscconvestcomputeerror_(PetscConvEst *a, PetscInt *b, DM *c, Vec *d, PetscReal e[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(e);
  *ierr = PetscConvEstComputeError(*a, *b, *c, *d, e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscconvest.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscconvestmonitordefault_ PETSCCONVESTMONITORDEFAULT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscconvestmonitordefault_ petscconvestmonitordefault
#endif
PETSC_EXTERN void petscconvestmonitordefault_(PetscConvEst *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = PetscConvEstMonitorDefault(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscconvest.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscconvestgetconvrate_ PETSCCONVESTGETCONVRATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscconvestgetconvrate_ petscconvestgetconvrate
#endif
PETSC_EXTERN void petscconvestgetconvrate_(PetscConvEst *a, PetscReal b[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(b);
  *ierr = PetscConvEstGetConvRate(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscconvest.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscconvestrateview_ PETSCCONVESTRATEVIEW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscconvestrateview_ petscconvestrateview
#endif
PETSC_EXTERN void petscconvestrateview_(PetscConvEst *a, const PetscReal b[], PetscViewer *c, PetscErrorCode *ierr)
{
  PetscViewer v_c = PetscPatchDefaultViewers(c);
  CHKFORTRANNULLREAL(b);
  *ierr = PetscConvEstRateView(*a, b, v_c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscconvest.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscconvestcreate_ PETSCCONVESTCREATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscconvestcreate_ petscconvestcreate
#endif
PETSC_EXTERN void petscconvestcreate_(MPI_Fint *a, PetscConvEst *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  PETSC_FORTRAN_OBJECT_CREATE(b);
  CHKFORTRANNULLOBJECT(b);
  *ierr = PetscConvEstCreate(MPI_Comm_f2c(*(a)), b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
