#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcbddcsetdiscretegradient_ PCBDDCSETDISCRETEGRADIENT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcbddcsetdiscretegradient_ pcbddcsetdiscretegradient
#endif
PETSC_EXTERN void pcbddcsetdiscretegradient_(PC *a, Mat *b, PetscInt *c, PetscInt *d, PetscBool *e, PetscBool *f, PetscErrorCode *ierr)
{
  *ierr = PCBDDCSetDiscreteGradient(*a, *b, *c, *d, *e ? PETSC_TRUE : PETSC_FALSE, *f ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcbddcsetdivergencemat_ PCBDDCSETDIVERGENCEMAT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcbddcsetdivergencemat_ pcbddcsetdivergencemat
#endif
PETSC_EXTERN void pcbddcsetdivergencemat_(PC *a, Mat *b, PetscBool *c, IS *d, PetscErrorCode *ierr)
{
  *ierr = PCBDDCSetDivergenceMat(*a, *b, *c ? PETSC_TRUE : PETSC_FALSE, *d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcbddcsetchangeofbasismat_ PCBDDCSETCHANGEOFBASISMAT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcbddcsetchangeofbasismat_ pcbddcsetchangeofbasismat
#endif
PETSC_EXTERN void pcbddcsetchangeofbasismat_(PC *a, Mat *b, PetscBool *c, PetscErrorCode *ierr)
{
  *ierr = PCBDDCSetChangeOfBasisMat(*a, *b, *c ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcbddcsetprimalverticesis_ PCBDDCSETPRIMALVERTICESIS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcbddcsetprimalverticesis_ pcbddcsetprimalverticesis
#endif
PETSC_EXTERN void pcbddcsetprimalverticesis_(PC *a, IS *b, PetscErrorCode *ierr)
{
  *ierr = PCBDDCSetPrimalVerticesIS(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcbddcgetprimalverticesis_ PCBDDCGETPRIMALVERTICESIS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcbddcgetprimalverticesis_ pcbddcgetprimalverticesis
#endif
PETSC_EXTERN void pcbddcgetprimalverticesis_(PC *a, IS *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = PCBDDCGetPrimalVerticesIS(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcbddcsetprimalverticeslocalis_ PCBDDCSETPRIMALVERTICESLOCALIS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcbddcsetprimalverticeslocalis_ pcbddcsetprimalverticeslocalis
#endif
PETSC_EXTERN void pcbddcsetprimalverticeslocalis_(PC *a, IS *b, PetscErrorCode *ierr)
{
  *ierr = PCBDDCSetPrimalVerticesLocalIS(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcbddcgetprimalverticeslocalis_ PCBDDCGETPRIMALVERTICESLOCALIS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcbddcgetprimalverticeslocalis_ pcbddcgetprimalverticeslocalis
#endif
PETSC_EXTERN void pcbddcgetprimalverticeslocalis_(PC *a, IS *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = PCBDDCGetPrimalVerticesLocalIS(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcbddcsetcoarseningratio_ PCBDDCSETCOARSENINGRATIO
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcbddcsetcoarseningratio_ pcbddcsetcoarseningratio
#endif
PETSC_EXTERN void pcbddcsetcoarseningratio_(PC *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = PCBDDCSetCoarseningRatio(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcbddcsetlevels_ PCBDDCSETLEVELS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcbddcsetlevels_ pcbddcsetlevels
#endif
PETSC_EXTERN void pcbddcsetlevels_(PC *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = PCBDDCSetLevels(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcbddcsetdirichletboundaries_ PCBDDCSETDIRICHLETBOUNDARIES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcbddcsetdirichletboundaries_ pcbddcsetdirichletboundaries
#endif
PETSC_EXTERN void pcbddcsetdirichletboundaries_(PC *a, IS *b, PetscErrorCode *ierr)
{
  *ierr = PCBDDCSetDirichletBoundaries(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcbddcsetdirichletboundarieslocal_ PCBDDCSETDIRICHLETBOUNDARIESLOCAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcbddcsetdirichletboundarieslocal_ pcbddcsetdirichletboundarieslocal
#endif
PETSC_EXTERN void pcbddcsetdirichletboundarieslocal_(PC *a, IS *b, PetscErrorCode *ierr)
{
  *ierr = PCBDDCSetDirichletBoundariesLocal(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcbddcsetneumannboundaries_ PCBDDCSETNEUMANNBOUNDARIES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcbddcsetneumannboundaries_ pcbddcsetneumannboundaries
#endif
PETSC_EXTERN void pcbddcsetneumannboundaries_(PC *a, IS *b, PetscErrorCode *ierr)
{
  *ierr = PCBDDCSetNeumannBoundaries(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcbddcsetneumannboundarieslocal_ PCBDDCSETNEUMANNBOUNDARIESLOCAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcbddcsetneumannboundarieslocal_ pcbddcsetneumannboundarieslocal
#endif
PETSC_EXTERN void pcbddcsetneumannboundarieslocal_(PC *a, IS *b, PetscErrorCode *ierr)
{
  *ierr = PCBDDCSetNeumannBoundariesLocal(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcbddcgetdirichletboundaries_ PCBDDCGETDIRICHLETBOUNDARIES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcbddcgetdirichletboundaries_ pcbddcgetdirichletboundaries
#endif
PETSC_EXTERN void pcbddcgetdirichletboundaries_(PC *a, IS *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = PCBDDCGetDirichletBoundaries(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcbddcgetdirichletboundarieslocal_ PCBDDCGETDIRICHLETBOUNDARIESLOCAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcbddcgetdirichletboundarieslocal_ pcbddcgetdirichletboundarieslocal
#endif
PETSC_EXTERN void pcbddcgetdirichletboundarieslocal_(PC *a, IS *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = PCBDDCGetDirichletBoundariesLocal(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcbddcgetneumannboundaries_ PCBDDCGETNEUMANNBOUNDARIES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcbddcgetneumannboundaries_ pcbddcgetneumannboundaries
#endif
PETSC_EXTERN void pcbddcgetneumannboundaries_(PC *a, IS *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = PCBDDCGetNeumannBoundaries(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcbddcgetneumannboundarieslocal_ PCBDDCGETNEUMANNBOUNDARIESLOCAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcbddcgetneumannboundarieslocal_ pcbddcgetneumannboundarieslocal
#endif
PETSC_EXTERN void pcbddcgetneumannboundarieslocal_(PC *a, IS *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = PCBDDCGetNeumannBoundariesLocal(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcbddcsetlocaladjacencygraph_ PCBDDCSETLOCALADJACENCYGRAPH
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcbddcsetlocaladjacencygraph_ pcbddcsetlocaladjacencygraph
#endif
PETSC_EXTERN void pcbddcsetlocaladjacencygraph_(PC *a, PetscInt *b, const PetscInt c[], const PetscInt d[], PetscCopyMode *e, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  CHKFORTRANNULLINTEGER(d);
  *ierr = PCBDDCSetLocalAdjacencyGraph(*a, *b, c, d, *e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcbddcsetdofssplittinglocal_ PCBDDCSETDOFSSPLITTINGLOCAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcbddcsetdofssplittinglocal_ pcbddcsetdofssplittinglocal
#endif
PETSC_EXTERN void pcbddcsetdofssplittinglocal_(PC *a, PetscInt *b, IS c[], PetscErrorCode *ierr)
{
  *ierr = PCBDDCSetDofsSplittingLocal(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcbddcsetdofssplitting_ PCBDDCSETDOFSSPLITTING
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcbddcsetdofssplitting_ pcbddcsetdofssplitting
#endif
PETSC_EXTERN void pcbddcsetdofssplitting_(PC *a, PetscInt *b, IS c[], PetscErrorCode *ierr)
{
  *ierr = PCBDDCSetDofsSplitting(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcbddcmatfetidpgetrhs_ PCBDDCMATFETIDPGETRHS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcbddcmatfetidpgetrhs_ pcbddcmatfetidpgetrhs
#endif
PETSC_EXTERN void pcbddcmatfetidpgetrhs_(Mat *a, Vec *b, Vec *c, PetscErrorCode *ierr)
{
  *ierr = PCBDDCMatFETIDPGetRHS(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcbddcmatfetidpgetsolution_ PCBDDCMATFETIDPGETSOLUTION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcbddcmatfetidpgetsolution_ pcbddcmatfetidpgetsolution
#endif
PETSC_EXTERN void pcbddcmatfetidpgetsolution_(Mat *a, Vec *b, Vec *c, PetscErrorCode *ierr)
{
  *ierr = PCBDDCMatFETIDPGetSolution(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcbddccreatefetidpoperators_ PCBDDCCREATEFETIDPOPERATORS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcbddccreatefetidpoperators_ pcbddccreatefetidpoperators
#endif
PETSC_EXTERN void pcbddccreatefetidpoperators_(PC *a, PetscBool *b, char c[], Mat *d, PC *e, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_c)
{
  PetscBool null_d = !*(void**) d ? PETSC_TRUE : PETSC_FALSE;
  PetscBool null_e = !*(void**) e ? PETSC_TRUE : PETSC_FALSE;
  char* c_c;
  FIXCHAR(c, l_c, c_c);
  CHKFORTRANNULLOBJECT(d);
  CHKFORTRANNULLOBJECT(e);
  *ierr = PCBDDCCreateFETIDPOperators(*a, *b ? PETSC_TRUE : PETSC_FALSE, c_c, d, e);
  if (*ierr) return;
  FREECHAR(c, c_c);
  if (! null_d && !*(void**) d) *(void **) d = (void *)-2;
  if (! null_e && !*(void**) e) *(void **) e = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcbddcinitializepackage_ PCBDDCINITIALIZEPACKAGE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcbddcinitializepackage_ pcbddcinitializepackage
#endif
PETSC_EXTERN void pcbddcinitializepackage_(PetscErrorCode *ierr)
{
  *ierr = PCBDDCInitializePackage();
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcbddcfinalizepackage_ PCBDDCFINALIZEPACKAGE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcbddcfinalizepackage_ pcbddcfinalizepackage
#endif
PETSC_EXTERN void pcbddcfinalizepackage_(PetscErrorCode *ierr)
{
  *ierr = PCBDDCFinalizePackage();
  if (*ierr) return;
}
