#ifndef _DIRECTORY_H_INCLUDED_
#define _DIRECTORY_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// Directory.h
// -----------
// Directory class definition
//                                                         
// Design and Implementation by Bjoern Lemke               
//                                                         
// (C)opyright 2000-2016 Bjoern Lemke
//
// Design and Implementation by Bjoern Lemke               
//                                                         
// INTERFACE MODULE
//
// Class: Direcotry
//
// Description: Utility class for directory operations
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// INCLUDES

#include "Chain.h"
#include "ListT.h"

class Directory {
 
 public:
  
     enum Mode { CLOSED, READ, WRITE, READWRITE, APPEND };  

     Directory();
     Directory(char* s);
     Directory(const Chain& str);
     ~Directory();

     bool exists();
     
     void create();
     ListT<Chain> list() const;

     void setCurrent();
     
     const Chain& getName() const;
     
 private:
       
     Chain _dir;
};
#endif
