/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.colormath.model;

import com.github.ajalt.colormath.Color;
import com.github.ajalt.colormath.ColorComponentInfo;
import com.github.ajalt.colormath.WhitePoint;
import com.github.ajalt.colormath.internal.InternalMathKt;
import com.github.ajalt.colormath.model.Ansi16;
import com.github.ajalt.colormath.model.Ansi256;
import com.github.ajalt.colormath.model.CMYK;
import com.github.ajalt.colormath.model.HPLuv;
import com.github.ajalt.colormath.model.HSL;
import com.github.ajalt.colormath.model.HSLuv;
import com.github.ajalt.colormath.model.HSV;
import com.github.ajalt.colormath.model.HWB;
import com.github.ajalt.colormath.model.ICtCp;
import com.github.ajalt.colormath.model.JzAzBz;
import com.github.ajalt.colormath.model.JzCzHz;
import com.github.ajalt.colormath.model.LABColorSpace;
import com.github.ajalt.colormath.model.LABColorSpaces;
import com.github.ajalt.colormath.model.LCHab;
import com.github.ajalt.colormath.model.LCHabKt;
import com.github.ajalt.colormath.model.LCHuv;
import com.github.ajalt.colormath.model.LUV;
import com.github.ajalt.colormath.model.Oklab;
import com.github.ajalt.colormath.model.Oklch;
import com.github.ajalt.colormath.model.RGB;
import com.github.ajalt.colormath.model.XYZ;
import com.github.ajalt.colormath.model.XYZColorSpace;
import com.github.ajalt.colormath.model.XYZKt;
import com.github.ajalt.colormath.model.xyY;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u0000 (2\u00020\u0001:\u0001(B/\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\bH\u00c6\u0003J;\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u0000H\u0016J\b\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020#H\u0016J\t\u0010$\u001a\u00020%H\u00d6\u0001J\b\u0010&\u001a\u00020'H\u0016R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006)"}, d2={"Lcom/github/ajalt/colormath/model/LAB;", "Lcom/github/ajalt/colormath/Color;", "l", "", "a", "b", "alpha", "space", "Lcom/github/ajalt/colormath/model/LABColorSpace;", "(FFFFLcom/github/ajalt/colormath/model/LABColorSpace;)V", "getA", "()F", "getAlpha", "getB", "getL", "getSpace", "()Lcom/github/ajalt/colormath/model/LABColorSpace;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "", "hashCode", "", "toArray", "", "toLAB", "toLCHab", "Lcom/github/ajalt/colormath/model/LCHab;", "toSRGB", "Lcom/github/ajalt/colormath/model/RGB;", "toString", "", "toXYZ", "Lcom/github/ajalt/colormath/model/XYZ;", "Companion", "colormath"})
public final class LAB
implements Color {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final float l;
    private final float a;
    private final float b;
    private final float alpha;
    @NotNull
    private final LABColorSpace space;

    public LAB(float l, float a, float b, float alpha, @NotNull LABColorSpace space) {
        Intrinsics.checkNotNullParameter(space, "space");
        this.l = l;
        this.a = a;
        this.b = b;
        this.alpha = alpha;
        this.space = space;
    }

    public final float getL() {
        return this.l;
    }

    public final float getA() {
        return this.a;
    }

    public final float getB() {
        return this.b;
    }

    @Override
    public float getAlpha() {
        return this.alpha;
    }

    @NotNull
    public LABColorSpace getSpace() {
        return this.space;
    }

    @Override
    @NotNull
    public RGB toSRGB() {
        float f = this.l;
        return f == 0.0f ? RGB.Companion.invoke(0.0f, 0.0f, 0.0f, this.getAlpha()) : this.toXYZ().toSRGB();
    }

    @Override
    @NotNull
    public XYZ toXYZ() {
        double d;
        boolean bl;
        XYZColorSpace xyzSpace = XYZKt.XYZColorSpace(this.getSpace().getWhitePoint());
        if (this.l == 0.0f) {
            return XYZColorSpace.DefaultImpls.invoke$default(xyzSpace, 0.0, 0.0, 0.0, null, 8, null);
        }
        double fy = (double)(this.l + (float)16) / 116.0;
        double fz = fy - (double)this.b / 200.0;
        double fx = (double)this.a / 500.0 + fy;
        if ((double)this.l > 8.0) {
            double d2 = fy;
            int n = 3;
            bl = false;
            d = Math.pow(d2, n);
        } else {
            d = (double)this.l / 903.2962962962963;
        }
        double yr = d;
        double d3 = fz;
        int n = 3;
        boolean bl2 = false;
        d3 = Math.pow(d3, n);
        bl = false;
        n = 0;
        double it = d3;
        boolean bl3 = false;
        double zr = it > 0.008856451679035631 ? it : ((double)116 * fz - (double)16) / 903.2962962962963;
        double d4 = fx;
        int n2 = 3;
        bl3 = false;
        d4 = Math.pow(d4, n2);
        boolean bl4 = false;
        n2 = 0;
        double it2 = d4;
        boolean bl5 = false;
        double xr = it2 > 0.008856451679035631 ? it2 : ((double)116 * fx - (double)16) / 903.2962962962963;
        xyY wp = this.getSpace().getWhitePoint().getChromaticity();
        return xyzSpace.invoke(xr * (double)wp.getAbsoluteX(), yr * (double)wp.getAbsoluteY(), zr * (double)wp.getAbsoluteZ(), Float.valueOf(this.getAlpha()));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public LCHab toLCHab() {
        void h;
        float f;
        void a$iv;
        float f2 = this.a;
        float b$iv = this.b;
        boolean $i$f$toPolarModel = false;
        void var4_4 = a$iv * a$iv + b$iv * b$iv;
        boolean bl = false;
        float c$iv = (float)Math.sqrt((double)var4_4);
        if ((double)c$iv > -1.0E-7 && (double)c$iv < 1.0E-7) {
            f = Float.NaN;
        } else {
            bl = false;
            f = InternalMathKt.radToDeg((float)Math.atan2(b$iv, (double)a$iv));
        }
        float h$iv = f;
        float f3 = InternalMathKt.normalizeDeg(h$iv);
        float c = c$iv;
        boolean bl2 = false;
        return LCHabKt.LCHabColorSpace(this.getSpace().getWhitePoint()).invoke(this.getL(), c, (float)h, this.getAlpha());
    }

    @Override
    @NotNull
    public LAB toLAB() {
        return this;
    }

    @Override
    @NotNull
    public float[] toArray() {
        float[] fArray = new float[]{this.l, this.a, this.b, this.getAlpha()};
        return fArray;
    }

    @Override
    @NotNull
    public Ansi16 toAnsi16() {
        return Color.DefaultImpls.toAnsi16(this);
    }

    @Override
    @NotNull
    public Ansi256 toAnsi256() {
        return Color.DefaultImpls.toAnsi256(this);
    }

    @Override
    @NotNull
    public CMYK toCMYK() {
        return Color.DefaultImpls.toCMYK(this);
    }

    @Override
    @NotNull
    public HPLuv toHPLuv() {
        return Color.DefaultImpls.toHPLuv(this);
    }

    @Override
    @NotNull
    public HSL toHSL() {
        return Color.DefaultImpls.toHSL(this);
    }

    @Override
    @NotNull
    public HSLuv toHSLuv() {
        return Color.DefaultImpls.toHSLuv(this);
    }

    @Override
    @NotNull
    public HSV toHSV() {
        return Color.DefaultImpls.toHSV(this);
    }

    @Override
    @NotNull
    public HWB toHWB() {
        return Color.DefaultImpls.toHWB(this);
    }

    @Override
    @NotNull
    public ICtCp toICtCp() {
        return Color.DefaultImpls.toICtCp(this);
    }

    @Override
    @NotNull
    public JzAzBz toJzAzBz() {
        return Color.DefaultImpls.toJzAzBz(this);
    }

    @Override
    @NotNull
    public JzCzHz toJzCzHz() {
        return Color.DefaultImpls.toJzCzHz(this);
    }

    @Override
    @NotNull
    public LCHuv toLCHuv() {
        return Color.DefaultImpls.toLCHuv(this);
    }

    @Override
    @NotNull
    public LUV toLUV() {
        return Color.DefaultImpls.toLUV(this);
    }

    @Override
    @NotNull
    public Oklab toOklab() {
        return Color.DefaultImpls.toOklab(this);
    }

    @Override
    @NotNull
    public Oklch toOklch() {
        return Color.DefaultImpls.toOklch(this);
    }

    public final float component1() {
        return this.l;
    }

    public final float component2() {
        return this.a;
    }

    public final float component3() {
        return this.b;
    }

    public final float component4() {
        return this.getAlpha();
    }

    @NotNull
    public final LABColorSpace component5() {
        return this.getSpace();
    }

    @NotNull
    public final LAB copy(float l, float a, float b, float alpha, @NotNull LABColorSpace space) {
        Intrinsics.checkNotNullParameter(space, "space");
        return new LAB(l, a, b, alpha, space);
    }

    public static /* synthetic */ LAB copy$default(LAB lAB, float f, float f2, float f3, float f4, LABColorSpace lABColorSpace, int n, Object object) {
        if ((n & 1) != 0) {
            f = lAB.l;
        }
        if ((n & 2) != 0) {
            f2 = lAB.a;
        }
        if ((n & 4) != 0) {
            f3 = lAB.b;
        }
        if ((n & 8) != 0) {
            f4 = lAB.getAlpha();
        }
        if ((n & 0x10) != 0) {
            lABColorSpace = lAB.getSpace();
        }
        return lAB.copy(f, f2, f3, f4, lABColorSpace);
    }

    @NotNull
    public String toString() {
        return "LAB(l=" + this.l + ", a=" + this.a + ", b=" + this.b + ", alpha=" + this.getAlpha() + ", space=" + this.getSpace() + ')';
    }

    public int hashCode() {
        int result = Float.hashCode(this.l);
        result = result * 31 + Float.hashCode(this.a);
        result = result * 31 + Float.hashCode(this.b);
        result = result * 31 + Float.hashCode(this.getAlpha());
        result = result * 31 + this.getSpace().hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LAB)) {
            return false;
        }
        LAB lAB = (LAB)other;
        if (!Intrinsics.areEqual((Object)Float.valueOf(this.l), (Object)Float.valueOf(lAB.l))) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)Float.valueOf(this.a), (Object)Float.valueOf(lAB.a))) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)Float.valueOf(this.b), (Object)Float.valueOf(lAB.b))) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)Float.valueOf(this.getAlpha()), (Object)Float.valueOf(lAB.getAlpha()))) {
            return false;
        }
        return Intrinsics.areEqual(this.getSpace(), lAB.getSpace());
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0004\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0096\u0001J\u0011\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0003\u001a\u00020\u0015H\u0096\u0001J+\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u00182\b\b\u0002\u0010\u001b\u001a\u00020\u0018H\u0096\u0003J+\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u001c2\u0006\u0010\u0019\u001a\u00020\u001c2\u0006\u0010\u001a\u001a\u00020\u001c2\b\b\u0002\u0010\u001b\u001a\u00020\u001cH\u0096\u0003R\u0018\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00020\tX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0012\u0010\f\u001a\u00020\rX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001d"}, d2={"Lcom/github/ajalt/colormath/model/LAB$Companion;", "Lcom/github/ajalt/colormath/model/LABColorSpace;", "()V", "components", "", "Lcom/github/ajalt/colormath/ColorComponentInfo;", "getComponents", "()Ljava/util/List;", "name", "", "getName", "()Ljava/lang/String;", "whitePoint", "Lcom/github/ajalt/colormath/WhitePoint;", "getWhitePoint", "()Lcom/github/ajalt/colormath/WhitePoint;", "convert", "Lcom/github/ajalt/colormath/model/LAB;", "color", "Lcom/github/ajalt/colormath/Color;", "create", "", "invoke", "l", "", "a", "b", "alpha", "", "colormath"})
    public static final class Companion
    implements LABColorSpace {
        private final /* synthetic */ LABColorSpace $$delegate_0;

        private Companion() {
            this.$$delegate_0 = LABColorSpaces.INSTANCE.getLAB65();
        }

        @Override
        @NotNull
        public LAB convert(@NotNull Color color) {
            Intrinsics.checkNotNullParameter(color, "color");
            return (LAB)this.$$delegate_0.convert(color);
        }

        @Override
        @NotNull
        public LAB create(@NotNull float[] components) {
            Intrinsics.checkNotNullParameter(components, "components");
            return (LAB)this.$$delegate_0.create(components);
        }

        @Override
        @NotNull
        public LAB invoke(float l, float a, float b, float alpha) {
            return this.$$delegate_0.invoke(l, a, b, alpha);
        }

        @Override
        @NotNull
        public LAB invoke(@NotNull Number l, @NotNull Number a, @NotNull Number b, @NotNull Number alpha) {
            Intrinsics.checkNotNullParameter(l, "l");
            Intrinsics.checkNotNullParameter(a, "a");
            Intrinsics.checkNotNullParameter(b, "b");
            Intrinsics.checkNotNullParameter(alpha, "alpha");
            return this.$$delegate_0.invoke(l, a, b, alpha);
        }

        @Override
        @NotNull
        public List<ColorComponentInfo> getComponents() {
            return this.$$delegate_0.getComponents();
        }

        @Override
        @NotNull
        public String getName() {
            return this.$$delegate_0.getName();
        }

        @Override
        @NotNull
        public WhitePoint getWhitePoint() {
            return this.$$delegate_0.getWhitePoint();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

