# SPDX-FileCopyrightText: 2017 Niels Ole Salscheider <niels_ole@salscheider-online.de>
#
# SPDX-License-Identifier: CC0-1.0


####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was QXmppConfig.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

set(_QXmpp_FIND_PARTS_REQUIRED)
if(QXmppQt5_FIND_REQUIRED)
    set(_QXmpp_FIND_PARTS_REQUIRED REQUIRED)
endif()
set(_QXmpp_FIND_PARTS_QUIET)
if(QXmppQt5_FIND_QUIETLY)
    set(_QXmpp_FIND_PARTS_QUIET QUIET)
endif()

include(CMakeFindDependencyMacro)
find_dependency(Qt5Core)
find_dependency(Qt5Network)
find_dependency(Qt5Xml)

include("${CMAKE_CURRENT_LIST_DIR}/QXmpp.cmake")

foreach(module ${QXmppQt5_FIND_COMPONENTS})
    find_package(QXmpp${module}Qt5
        ${QXmppQt5_FIND_VERSION}
        ${_QXmpp_FIND_PARTS_REQUIRED}
        ${_QXmpp_FIND_PARTS_QUIET}
    )
    set(QXmppQt5_${module}_FOUND ${QXmpp${module}Qt5_FOUND})
endforeach()

check_required_components(QXmpp)
