# WARNING: Please don't edit this file. It was generated by Python/WinRT v1.0.0-beta.9

import enum
import datetime
import sys
import types
import typing

import winsdk.system
import winsdk.windows.foundation
import winsdk.windows.foundation.collections
import winsdk.windows.graphics.imaging
import winsdk.windows.storage
import winsdk.windows.storage.streams

class BarcodeScannerStatus(enum.IntEnum):
    ONLINE = 0
    OFF = 1
    OFFLINE = 2
    OFF_OR_OFFLINE = 3
    EXTENDED = 4

class BarcodeSymbologyDecodeLengthKind(enum.IntEnum):
    ANY_LENGTH = 0
    DISCRETE = 1
    RANGE = 2

class CashDrawerStatusKind(enum.IntEnum):
    ONLINE = 0
    OFF = 1
    OFFLINE = 2
    OFF_OR_OFFLINE = 3
    EXTENDED = 4

class LineDisplayCursorType(enum.IntEnum):
    NONE = 0
    BLOCK = 1
    HALF_BLOCK = 2
    UNDERLINE = 3
    REVERSE = 4
    OTHER = 5

class LineDisplayDescriptorState(enum.IntEnum):
    OFF = 0
    ON = 1
    BLINK = 2

class LineDisplayHorizontalAlignment(enum.IntEnum):
    LEFT = 0
    CENTER = 1
    RIGHT = 2

class LineDisplayMarqueeFormat(enum.IntEnum):
    NONE = 0
    WALK = 1
    PLACE = 2

class LineDisplayPowerStatus(enum.IntEnum):
    UNKNOWN = 0
    ONLINE = 1
    OFF = 2
    OFFLINE = 3
    OFF_OR_OFFLINE = 4

class LineDisplayScrollDirection(enum.IntEnum):
    UP = 0
    DOWN = 1
    LEFT = 2
    RIGHT = 3

class LineDisplayTextAttribute(enum.IntEnum):
    NORMAL = 0
    BLINK = 1
    REVERSE = 2
    REVERSE_BLINK = 3

class LineDisplayTextAttributeGranularity(enum.IntEnum):
    NOT_SUPPORTED = 0
    ENTIRE_DISPLAY = 1
    PER_CHARACTER = 2

class LineDisplayVerticalAlignment(enum.IntEnum):
    TOP = 0
    CENTER = 1
    BOTTOM = 2

class MagneticStripeReaderAuthenticationLevel(enum.IntEnum):
    NOT_SUPPORTED = 0
    OPTIONAL = 1
    REQUIRED = 2

class MagneticStripeReaderAuthenticationProtocol(enum.IntEnum):
    NONE = 0
    CHALLENGE_RESPONSE = 1

class MagneticStripeReaderErrorReportingType(enum.IntEnum):
    CARD_LEVEL = 0
    TRACK_LEVEL = 1

class MagneticStripeReaderStatus(enum.IntEnum):
    UNAUTHENTICATED = 0
    AUTHENTICATED = 1
    EXTENDED = 2

class MagneticStripeReaderTrackErrorType(enum.IntEnum):
    NONE = 0
    START_SENTINEL_ERROR = 1
    END_SENTINEL_ERROR = 2
    PARITY_ERROR = 3
    LRC_ERROR = 4
    UNKNOWN = -1

class MagneticStripeReaderTrackIds(enum.IntEnum):
    NONE = 0
    TRACK1 = 1
    TRACK2 = 2
    TRACK3 = 4
    TRACK4 = 8

class PosConnectionTypes(enum.IntFlag):
    LOCAL = 0x1
    I_P = 0x2
    BLUETOOTH = 0x4
    ALL = 0xffffffff

class PosPrinterAlignment(enum.IntEnum):
    LEFT = 0
    CENTER = 1
    RIGHT = 2

class PosPrinterBarcodeTextPosition(enum.IntEnum):
    NONE = 0
    ABOVE = 1
    BELOW = 2

class PosPrinterCartridgeSensors(enum.IntFlag):
    NONE = 0
    REMOVED = 0x1
    EMPTY = 0x2
    HEAD_CLEANING = 0x4
    NEAR_END = 0x8

class PosPrinterColorCapabilities(enum.IntFlag):
    NONE = 0
    PRIMARY = 0x1
    CUSTOM1 = 0x2
    CUSTOM2 = 0x4
    CUSTOM3 = 0x8
    CUSTOM4 = 0x10
    CUSTOM5 = 0x20
    CUSTOM6 = 0x40
    CYAN = 0x80
    MAGENTA = 0x100
    YELLOW = 0x200
    FULL = 0x400

class PosPrinterColorCartridge(enum.IntEnum):
    UNKNOWN = 0
    PRIMARY = 1
    CUSTOM1 = 2
    CUSTOM2 = 3
    CUSTOM3 = 4
    CUSTOM4 = 5
    CUSTOM5 = 6
    CUSTOM6 = 7
    CYAN = 8
    MAGENTA = 9
    YELLOW = 10

class PosPrinterLineDirection(enum.IntEnum):
    HORIZONTAL = 0
    VERTICAL = 1

class PosPrinterLineStyle(enum.IntEnum):
    SINGLE_SOLID = 0
    DOUBLE_SOLID = 1
    BROKEN = 2
    CHAIN = 3

class PosPrinterMapMode(enum.IntEnum):
    DOTS = 0
    TWIPS = 1
    ENGLISH = 2
    METRIC = 3

class PosPrinterMarkFeedCapabilities(enum.IntFlag):
    NONE = 0
    TO_TAKE_UP = 0x1
    TO_CUTTER = 0x2
    TO_CURRENT_TOP_OF_FORM = 0x4
    TO_NEXT_TOP_OF_FORM = 0x8

class PosPrinterMarkFeedKind(enum.IntEnum):
    TO_TAKE_UP = 0
    TO_CUTTER = 1
    TO_CURRENT_TOP_OF_FORM = 2
    TO_NEXT_TOP_OF_FORM = 3

class PosPrinterPrintSide(enum.IntEnum):
    UNKNOWN = 0
    SIDE1 = 1
    SIDE2 = 2

class PosPrinterRotation(enum.IntEnum):
    NORMAL = 0
    RIGHT90 = 1
    LEFT90 = 2
    ROTATE180 = 3

class PosPrinterRuledLineCapabilities(enum.IntFlag):
    NONE = 0
    HORIZONTAL = 0x1
    VERTICAL = 0x2

class PosPrinterStatusKind(enum.IntEnum):
    ONLINE = 0
    OFF = 1
    OFFLINE = 2
    OFF_OR_OFFLINE = 3
    EXTENDED = 4

class UnifiedPosErrorReason(enum.IntEnum):
    UNKNOWN_ERROR_REASON = 0
    NO_SERVICE = 1
    DISABLED = 2
    ILLEGAL = 3
    NO_HARDWARE = 4
    CLOSED = 5
    OFFLINE = 6
    FAILURE = 7
    TIMEOUT = 8
    BUSY = 9
    EXTENDED = 10

class UnifiedPosErrorSeverity(enum.IntEnum):
    UNKNOWN_ERROR_SEVERITY = 0
    WARNING = 1
    RECOVERABLE = 2
    UNRECOVERABLE = 3
    ASSISTANCE_REQUIRED = 4
    FATAL = 5

class UnifiedPosHealthCheckLevel(enum.IntEnum):
    UNKNOWN_HEALTH_CHECK_LEVEL = 0
    P_O_S_INTERNAL = 1
    EXTERNAL = 2
    INTERACTIVE = 3

class UnifiedPosPowerReportingType(enum.IntEnum):
    UNKNOWN_POWER_REPORTING_TYPE = 0
    STANDARD = 1
    ADVANCED = 2

Self = typing.TypeVar('Self')

class SizeUInt32:
    width: winsdk.system.UInt32
    height: winsdk.system.UInt32
    def __new__(cls: typing.Type[SizeUInt32], width: winsdk.system.UInt32, height: winsdk.system.UInt32) -> SizeUInt32: ...

class BarcodeScanner(winsdk.system.Object):
    capabilities: typing.Optional[BarcodeScannerCapabilities]
    device_id: str
    video_device_id: str
    def __enter__(self: Self) -> Self: ...
    def __exit__(self, *args) -> None: ...
    @staticmethod
    def _from(obj: winsdk.system.Object) -> BarcodeScanner: ...
    def check_health_async(self, level: UnifiedPosHealthCheckLevel) -> winsdk.windows.foundation.IAsyncOperation[str]: ...
    def claim_scanner_async(self) -> winsdk.windows.foundation.IAsyncOperation[ClaimedBarcodeScanner]: ...
    def close(self) -> None: ...
    @staticmethod
    def from_id_async(device_id: str) -> winsdk.windows.foundation.IAsyncOperation[BarcodeScanner]: ...
    @staticmethod
    def get_default_async() -> winsdk.windows.foundation.IAsyncOperation[BarcodeScanner]: ...
    @typing.overload
    @staticmethod
    def get_device_selector() -> str: ...
    @typing.overload
    @staticmethod
    def get_device_selector(connection_types: PosConnectionTypes) -> str: ...
    def get_supported_profiles(self) -> typing.Optional[winsdk.windows.foundation.collections.IVectorView[str]]: ...
    def get_supported_symbologies_async(self) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.foundation.collections.IVectorView[winsdk.system.UInt32]]: ...
    def is_profile_supported(self, profile: str) -> winsdk.system.Boolean: ...
    def is_symbology_supported_async(self, barcode_symbology: winsdk.system.UInt32) -> winsdk.windows.foundation.IAsyncOperation[winsdk.system.Boolean]: ...
    def retrieve_statistics_async(self, statistics_categories: typing.Iterable[str]) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.storage.streams.IBuffer]: ...
    def add_status_updated(self, handler: winsdk.windows.foundation.TypedEventHandler[BarcodeScanner, BarcodeScannerStatusUpdatedEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_status_updated(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...

class BarcodeScannerCapabilities(winsdk.system.Object):
    is_image_preview_supported: winsdk.system.Boolean
    is_statistics_reporting_supported: winsdk.system.Boolean
    is_statistics_updating_supported: winsdk.system.Boolean
    power_reporting_type: UnifiedPosPowerReportingType
    is_software_trigger_supported: winsdk.system.Boolean
    is_video_preview_supported: winsdk.system.Boolean
    @staticmethod
    def _from(obj: winsdk.system.Object) -> BarcodeScannerCapabilities: ...

class BarcodeScannerDataReceivedEventArgs(winsdk.system.Object):
    report: typing.Optional[BarcodeScannerReport]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> BarcodeScannerDataReceivedEventArgs: ...

class BarcodeScannerErrorOccurredEventArgs(winsdk.system.Object):
    error_data: typing.Optional[UnifiedPosErrorData]
    is_retriable: winsdk.system.Boolean
    partial_input_data: typing.Optional[BarcodeScannerReport]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> BarcodeScannerErrorOccurredEventArgs: ...

class BarcodeScannerImagePreviewReceivedEventArgs(winsdk.system.Object):
    preview: typing.Optional[winsdk.windows.storage.streams.IRandomAccessStreamWithContentType]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> BarcodeScannerImagePreviewReceivedEventArgs: ...

class BarcodeScannerReport(winsdk.system.Object):
    scan_data: typing.Optional[winsdk.windows.storage.streams.IBuffer]
    scan_data_label: typing.Optional[winsdk.windows.storage.streams.IBuffer]
    scan_data_type: winsdk.system.UInt32
    @staticmethod
    def _from(obj: winsdk.system.Object) -> BarcodeScannerReport: ...
    def __new__(cls: typing.Type[BarcodeScannerReport], scan_data_type: winsdk.system.UInt32, scan_data: typing.Optional[winsdk.windows.storage.streams.IBuffer], scan_data_label: typing.Optional[winsdk.windows.storage.streams.IBuffer]) -> BarcodeScannerReport:...

class BarcodeScannerStatusUpdatedEventArgs(winsdk.system.Object):
    extended_status: winsdk.system.UInt32
    status: BarcodeScannerStatus
    @staticmethod
    def _from(obj: winsdk.system.Object) -> BarcodeScannerStatusUpdatedEventArgs: ...

class BarcodeSymbologies(winsdk.system.Object):
    code11: typing.ClassVar[winsdk.system.UInt32]
    aus_post: typing.ClassVar[winsdk.system.UInt32]
    aztec: typing.ClassVar[winsdk.system.UInt32]
    can_post: typing.ClassVar[winsdk.system.UInt32]
    ccab: typing.ClassVar[winsdk.system.UInt32]
    ccc: typing.ClassVar[winsdk.system.UInt32]
    china_post: typing.ClassVar[winsdk.system.UInt32]
    codabar: typing.ClassVar[winsdk.system.UInt32]
    codablock128: typing.ClassVar[winsdk.system.UInt32]
    codablock_a: typing.ClassVar[winsdk.system.UInt32]
    codablock_f: typing.ClassVar[winsdk.system.UInt32]
    dutch_kix: typing.ClassVar[winsdk.system.UInt32]
    code128: typing.ClassVar[winsdk.system.UInt32]
    code16k: typing.ClassVar[winsdk.system.UInt32]
    code32: typing.ClassVar[winsdk.system.UInt32]
    code39: typing.ClassVar[winsdk.system.UInt32]
    code39_ex: typing.ClassVar[winsdk.system.UInt32]
    code49: typing.ClassVar[winsdk.system.UInt32]
    code93: typing.ClassVar[winsdk.system.UInt32]
    code93_ex: typing.ClassVar[winsdk.system.UInt32]
    data_code: typing.ClassVar[winsdk.system.UInt32]
    data_matrix: typing.ClassVar[winsdk.system.UInt32]
    us_post_net: typing.ClassVar[winsdk.system.UInt32]
    ean13: typing.ClassVar[winsdk.system.UInt32]
    ean13_add2: typing.ClassVar[winsdk.system.UInt32]
    ean13_add5: typing.ClassVar[winsdk.system.UInt32]
    ean8: typing.ClassVar[winsdk.system.UInt32]
    ean8_add2: typing.ClassVar[winsdk.system.UInt32]
    ean8_add5: typing.ClassVar[winsdk.system.UInt32]
    ean99: typing.ClassVar[winsdk.system.UInt32]
    ean99_add2: typing.ClassVar[winsdk.system.UInt32]
    ean99_add5: typing.ClassVar[winsdk.system.UInt32]
    eanv: typing.ClassVar[winsdk.system.UInt32]
    eanv_add2: typing.ClassVar[winsdk.system.UInt32]
    eanv_add5: typing.ClassVar[winsdk.system.UInt32]
    extended_base: typing.ClassVar[winsdk.system.UInt32]
    gs1128: typing.ClassVar[winsdk.system.UInt32]
    gs1128_coupon: typing.ClassVar[winsdk.system.UInt32]
    gs1_databar_type1: typing.ClassVar[winsdk.system.UInt32]
    gs1_databar_type2: typing.ClassVar[winsdk.system.UInt32]
    gs1_databar_type3: typing.ClassVar[winsdk.system.UInt32]
    han_xin: typing.ClassVar[winsdk.system.UInt32]
    info_mail: typing.ClassVar[winsdk.system.UInt32]
    isbn: typing.ClassVar[winsdk.system.UInt32]
    isbn_add5: typing.ClassVar[winsdk.system.UInt32]
    isbt: typing.ClassVar[winsdk.system.UInt32]
    ismn: typing.ClassVar[winsdk.system.UInt32]
    ismn_add2: typing.ClassVar[winsdk.system.UInt32]
    ismn_add5: typing.ClassVar[winsdk.system.UInt32]
    issn: typing.ClassVar[winsdk.system.UInt32]
    issn_add2: typing.ClassVar[winsdk.system.UInt32]
    issn_add5: typing.ClassVar[winsdk.system.UInt32]
    italian_post25: typing.ClassVar[winsdk.system.UInt32]
    italian_post39: typing.ClassVar[winsdk.system.UInt32]
    japan_post: typing.ClassVar[winsdk.system.UInt32]
    korean_post: typing.ClassVar[winsdk.system.UInt32]
    maxicode: typing.ClassVar[winsdk.system.UInt32]
    micr: typing.ClassVar[winsdk.system.UInt32]
    micro_pdf417: typing.ClassVar[winsdk.system.UInt32]
    micro_qr: typing.ClassVar[winsdk.system.UInt32]
    ms_tag: typing.ClassVar[winsdk.system.UInt32]
    msi: typing.ClassVar[winsdk.system.UInt32]
    ocr_a: typing.ClassVar[winsdk.system.UInt32]
    ocr_b: typing.ClassVar[winsdk.system.UInt32]
    pdf417: typing.ClassVar[winsdk.system.UInt32]
    plessey: typing.ClassVar[winsdk.system.UInt32]
    pzn: typing.ClassVar[winsdk.system.UInt32]
    qr: typing.ClassVar[winsdk.system.UInt32]
    sisac: typing.ClassVar[winsdk.system.UInt32]
    sweden_post: typing.ClassVar[winsdk.system.UInt32]
    telepen: typing.ClassVar[winsdk.system.UInt32]
    tf_dis: typing.ClassVar[winsdk.system.UInt32]
    tf_iata: typing.ClassVar[winsdk.system.UInt32]
    tf_ind: typing.ClassVar[winsdk.system.UInt32]
    tf_int: typing.ClassVar[winsdk.system.UInt32]
    tf_mat: typing.ClassVar[winsdk.system.UInt32]
    tf_std: typing.ClassVar[winsdk.system.UInt32]
    tlc39: typing.ClassVar[winsdk.system.UInt32]
    trioptic39: typing.ClassVar[winsdk.system.UInt32]
    ucc_ean128: typing.ClassVar[winsdk.system.UInt32]
    uk_post: typing.ClassVar[winsdk.system.UInt32]
    unknown: typing.ClassVar[winsdk.system.UInt32]
    upc_coupon: typing.ClassVar[winsdk.system.UInt32]
    upca: typing.ClassVar[winsdk.system.UInt32]
    upca_add2: typing.ClassVar[winsdk.system.UInt32]
    upca_add5: typing.ClassVar[winsdk.system.UInt32]
    upce: typing.ClassVar[winsdk.system.UInt32]
    upce_add2: typing.ClassVar[winsdk.system.UInt32]
    upce_add5: typing.ClassVar[winsdk.system.UInt32]
    us4_state_fics: typing.ClassVar[winsdk.system.UInt32]
    us_intelligent: typing.ClassVar[winsdk.system.UInt32]
    us_intelligent_pkg: typing.ClassVar[winsdk.system.UInt32]
    us_planet: typing.ClassVar[winsdk.system.UInt32]
    gs1_d_w_code: typing.ClassVar[winsdk.system.UInt32]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> BarcodeSymbologies: ...
    @staticmethod
    def get_name(scan_data_type: winsdk.system.UInt32) -> str: ...

class BarcodeSymbologyAttributes(winsdk.system.Object):
    is_check_digit_validation_enabled: winsdk.system.Boolean
    is_check_digit_transmission_enabled: winsdk.system.Boolean
    decode_length_kind: BarcodeSymbologyDecodeLengthKind
    decode_length2: winsdk.system.UInt32
    decode_length1: winsdk.system.UInt32
    is_check_digit_transmission_supported: winsdk.system.Boolean
    is_check_digit_validation_supported: winsdk.system.Boolean
    is_decode_length_supported: winsdk.system.Boolean
    @staticmethod
    def _from(obj: winsdk.system.Object) -> BarcodeSymbologyAttributes: ...

class CashDrawer(winsdk.system.Object):
    capabilities: typing.Optional[CashDrawerCapabilities]
    device_id: str
    drawer_event_source: typing.Optional[CashDrawerEventSource]
    is_drawer_open: winsdk.system.Boolean
    status: typing.Optional[CashDrawerStatus]
    def __enter__(self: Self) -> Self: ...
    def __exit__(self, *args) -> None: ...
    @staticmethod
    def _from(obj: winsdk.system.Object) -> CashDrawer: ...
    def check_health_async(self, level: UnifiedPosHealthCheckLevel) -> winsdk.windows.foundation.IAsyncOperation[str]: ...
    def claim_drawer_async(self) -> winsdk.windows.foundation.IAsyncOperation[ClaimedCashDrawer]: ...
    def close(self) -> None: ...
    @staticmethod
    def from_id_async(device_id: str) -> winsdk.windows.foundation.IAsyncOperation[CashDrawer]: ...
    @staticmethod
    def get_default_async() -> winsdk.windows.foundation.IAsyncOperation[CashDrawer]: ...
    @typing.overload
    @staticmethod
    def get_device_selector() -> str: ...
    @typing.overload
    @staticmethod
    def get_device_selector(connection_types: PosConnectionTypes) -> str: ...
    def get_statistics_async(self, statistics_categories: typing.Iterable[str]) -> winsdk.windows.foundation.IAsyncOperation[str]: ...
    def add_status_updated(self, handler: winsdk.windows.foundation.TypedEventHandler[CashDrawer, CashDrawerStatusUpdatedEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_status_updated(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...

class CashDrawerCapabilities(winsdk.system.Object):
    is_drawer_open_sensor_available: winsdk.system.Boolean
    is_statistics_reporting_supported: winsdk.system.Boolean
    is_statistics_updating_supported: winsdk.system.Boolean
    is_status_multi_drawer_detect_supported: winsdk.system.Boolean
    is_status_reporting_supported: winsdk.system.Boolean
    power_reporting_type: UnifiedPosPowerReportingType
    @staticmethod
    def _from(obj: winsdk.system.Object) -> CashDrawerCapabilities: ...

class CashDrawerCloseAlarm(winsdk.system.Object):
    beep_frequency: winsdk.system.UInt32
    beep_duration: datetime.timedelta
    beep_delay: datetime.timedelta
    alarm_timeout: datetime.timedelta
    @staticmethod
    def _from(obj: winsdk.system.Object) -> CashDrawerCloseAlarm: ...
    def start_async(self) -> winsdk.windows.foundation.IAsyncOperation[winsdk.system.Boolean]: ...
    def add_alarm_timeout_expired(self, handler: winsdk.windows.foundation.TypedEventHandler[CashDrawerCloseAlarm, winsdk.system.Object]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_alarm_timeout_expired(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...

class CashDrawerClosedEventArgs(winsdk.system.Object):
    cash_drawer: typing.Optional[CashDrawer]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> CashDrawerClosedEventArgs: ...

class CashDrawerEventSource(winsdk.system.Object):
    @staticmethod
    def _from(obj: winsdk.system.Object) -> CashDrawerEventSource: ...
    def add_drawer_closed(self, handler: winsdk.windows.foundation.TypedEventHandler[CashDrawerEventSource, CashDrawerClosedEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_drawer_closed(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...
    def add_drawer_opened(self, handler: winsdk.windows.foundation.TypedEventHandler[CashDrawerEventSource, CashDrawerOpenedEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_drawer_opened(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...

class CashDrawerOpenedEventArgs(winsdk.system.Object):
    cash_drawer: typing.Optional[CashDrawer]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> CashDrawerOpenedEventArgs: ...

class CashDrawerStatus(winsdk.system.Object):
    extended_status: winsdk.system.UInt32
    status_kind: CashDrawerStatusKind
    @staticmethod
    def _from(obj: winsdk.system.Object) -> CashDrawerStatus: ...

class CashDrawerStatusUpdatedEventArgs(winsdk.system.Object):
    status: typing.Optional[CashDrawerStatus]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> CashDrawerStatusUpdatedEventArgs: ...

class ClaimedBarcodeScanner(winsdk.system.Object):
    is_disabled_on_data_received: winsdk.system.Boolean
    is_decode_data_enabled: winsdk.system.Boolean
    device_id: str
    is_enabled: winsdk.system.Boolean
    is_video_preview_shown_on_enable: winsdk.system.Boolean
    def __enter__(self: Self) -> Self: ...
    def __exit__(self, *args) -> None: ...
    @staticmethod
    def _from(obj: winsdk.system.Object) -> ClaimedBarcodeScanner: ...
    def close(self) -> None: ...
    def disable_async(self) -> winsdk.windows.foundation.IAsyncAction: ...
    def enable_async(self) -> winsdk.windows.foundation.IAsyncAction: ...
    def get_symbology_attributes_async(self, barcode_symbology: winsdk.system.UInt32) -> winsdk.windows.foundation.IAsyncOperation[BarcodeSymbologyAttributes]: ...
    def hide_video_preview(self) -> None: ...
    def reset_statistics_async(self, statistics_categories: typing.Iterable[str]) -> winsdk.windows.foundation.IAsyncAction: ...
    def retain_device(self) -> None: ...
    def set_active_profile_async(self, profile: str) -> winsdk.windows.foundation.IAsyncAction: ...
    def set_active_symbologies_async(self, symbologies: typing.Iterable[winsdk.system.UInt32]) -> winsdk.windows.foundation.IAsyncAction: ...
    def set_symbology_attributes_async(self, barcode_symbology: winsdk.system.UInt32, attributes: typing.Optional[BarcodeSymbologyAttributes]) -> winsdk.windows.foundation.IAsyncOperation[winsdk.system.Boolean]: ...
    def show_video_preview_async(self) -> winsdk.windows.foundation.IAsyncOperation[winsdk.system.Boolean]: ...
    def start_software_trigger_async(self) -> winsdk.windows.foundation.IAsyncAction: ...
    def stop_software_trigger_async(self) -> winsdk.windows.foundation.IAsyncAction: ...
    def update_statistics_async(self, statistics: typing.Iterable[winsdk.windows.foundation.collections.IKeyValuePair[str, str]]) -> winsdk.windows.foundation.IAsyncAction: ...
    def add_data_received(self, handler: winsdk.windows.foundation.TypedEventHandler[ClaimedBarcodeScanner, BarcodeScannerDataReceivedEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_data_received(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...
    def add_error_occurred(self, handler: winsdk.windows.foundation.TypedEventHandler[ClaimedBarcodeScanner, BarcodeScannerErrorOccurredEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_error_occurred(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...
    def add_image_preview_received(self, handler: winsdk.windows.foundation.TypedEventHandler[ClaimedBarcodeScanner, BarcodeScannerImagePreviewReceivedEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_image_preview_received(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...
    def add_release_device_requested(self, handler: winsdk.windows.foundation.EventHandler[ClaimedBarcodeScanner]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_release_device_requested(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...
    def add_trigger_pressed(self, handler: winsdk.windows.foundation.EventHandler[ClaimedBarcodeScanner]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_trigger_pressed(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...
    def add_trigger_released(self, handler: winsdk.windows.foundation.EventHandler[ClaimedBarcodeScanner]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_trigger_released(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...
    def add_closed(self, handler: winsdk.windows.foundation.TypedEventHandler[ClaimedBarcodeScanner, ClaimedBarcodeScannerClosedEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_closed(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...

class ClaimedBarcodeScannerClosedEventArgs(winsdk.system.Object):
    @staticmethod
    def _from(obj: winsdk.system.Object) -> ClaimedBarcodeScannerClosedEventArgs: ...

class ClaimedCashDrawer(winsdk.system.Object):
    close_alarm: typing.Optional[CashDrawerCloseAlarm]
    device_id: str
    is_drawer_open: winsdk.system.Boolean
    is_enabled: winsdk.system.Boolean
    def __enter__(self: Self) -> Self: ...
    def __exit__(self, *args) -> None: ...
    @staticmethod
    def _from(obj: winsdk.system.Object) -> ClaimedCashDrawer: ...
    def close(self) -> None: ...
    def disable_async(self) -> winsdk.windows.foundation.IAsyncOperation[winsdk.system.Boolean]: ...
    def enable_async(self) -> winsdk.windows.foundation.IAsyncOperation[winsdk.system.Boolean]: ...
    def open_drawer_async(self) -> winsdk.windows.foundation.IAsyncOperation[winsdk.system.Boolean]: ...
    def reset_statistics_async(self, statistics_categories: typing.Iterable[str]) -> winsdk.windows.foundation.IAsyncOperation[winsdk.system.Boolean]: ...
    def retain_device_async(self) -> winsdk.windows.foundation.IAsyncOperation[winsdk.system.Boolean]: ...
    def update_statistics_async(self, statistics: typing.Iterable[winsdk.windows.foundation.collections.IKeyValuePair[str, str]]) -> winsdk.windows.foundation.IAsyncOperation[winsdk.system.Boolean]: ...
    def add_release_device_requested(self, handler: winsdk.windows.foundation.TypedEventHandler[ClaimedCashDrawer, winsdk.system.Object]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_release_device_requested(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...
    def add_closed(self, handler: winsdk.windows.foundation.TypedEventHandler[ClaimedCashDrawer, ClaimedCashDrawerClosedEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_closed(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...

class ClaimedCashDrawerClosedEventArgs(winsdk.system.Object):
    @staticmethod
    def _from(obj: winsdk.system.Object) -> ClaimedCashDrawerClosedEventArgs: ...

class ClaimedJournalPrinter(winsdk.system.Object):
    line_spacing: winsdk.system.UInt32
    line_height: winsdk.system.UInt32
    is_letter_quality: winsdk.system.Boolean
    color_cartridge: PosPrinterColorCartridge
    characters_per_line: winsdk.system.UInt32
    is_cartridge_empty: winsdk.system.Boolean
    is_cartridge_removed: winsdk.system.Boolean
    is_cover_open: winsdk.system.Boolean
    is_head_cleaning: winsdk.system.Boolean
    is_paper_empty: winsdk.system.Boolean
    is_paper_near_end: winsdk.system.Boolean
    is_ready_to_print: winsdk.system.Boolean
    line_width: winsdk.system.UInt32
    @staticmethod
    def _from(obj: winsdk.system.Object) -> ClaimedJournalPrinter: ...
    def create_job(self) -> typing.Optional[JournalPrintJob]: ...
    def validate_data(self, data: str) -> winsdk.system.Boolean: ...

class ClaimedLineDisplay(winsdk.system.Object):
    capabilities: typing.Optional[LineDisplayCapabilities]
    default_window: typing.Optional[LineDisplayWindow]
    device_control_description: str
    device_control_version: str
    device_id: str
    device_service_version: str
    physical_device_description: str
    physical_device_name: str
    custom_glyphs: typing.Optional[LineDisplayCustomGlyphs]
    max_bitmap_size_in_pixels: winsdk.windows.foundation.Size
    supported_character_sets: typing.Optional[winsdk.windows.foundation.collections.IVectorView[winsdk.system.Int32]]
    supported_screen_sizes_in_characters: typing.Optional[winsdk.windows.foundation.collections.IVectorView[winsdk.windows.foundation.Size]]
    def __enter__(self: Self) -> Self: ...
    def __exit__(self, *args) -> None: ...
    @staticmethod
    def _from(obj: winsdk.system.Object) -> ClaimedLineDisplay: ...
    def check_health_async(self, level: UnifiedPosHealthCheckLevel) -> winsdk.windows.foundation.IAsyncOperation[str]: ...
    def check_power_status_async(self) -> winsdk.windows.foundation.IAsyncOperation[LineDisplayPowerStatus]: ...
    def close(self) -> None: ...
    @staticmethod
    def from_id_async(device_id: str) -> winsdk.windows.foundation.IAsyncOperation[ClaimedLineDisplay]: ...
    def get_attributes(self) -> typing.Optional[LineDisplayAttributes]: ...
    @typing.overload
    @staticmethod
    def get_device_selector() -> str: ...
    @typing.overload
    @staticmethod
    def get_device_selector(connection_types: PosConnectionTypes) -> str: ...
    def get_statistics_async(self, statistics_categories: typing.Iterable[str]) -> winsdk.windows.foundation.IAsyncOperation[str]: ...
    def retain_device(self) -> None: ...
    def try_clear_descriptors_async(self) -> winsdk.windows.foundation.IAsyncOperation[winsdk.system.Boolean]: ...
    def try_create_window_async(self, viewport: winsdk.windows.foundation.Rect, window_size: winsdk.windows.foundation.Size) -> winsdk.windows.foundation.IAsyncOperation[LineDisplayWindow]: ...
    def try_set_descriptor_async(self, descriptor: winsdk.system.UInt32, descriptor_state: LineDisplayDescriptorState) -> winsdk.windows.foundation.IAsyncOperation[winsdk.system.Boolean]: ...
    @typing.overload
    def try_store_storage_file_bitmap_async(self, bitmap: typing.Optional[winsdk.windows.storage.StorageFile]) -> winsdk.windows.foundation.IAsyncOperation[LineDisplayStoredBitmap]: ...
    @typing.overload
    def try_store_storage_file_bitmap_async(self, bitmap: typing.Optional[winsdk.windows.storage.StorageFile], horizontal_alignment: LineDisplayHorizontalAlignment, vertical_alignment: LineDisplayVerticalAlignment) -> winsdk.windows.foundation.IAsyncOperation[LineDisplayStoredBitmap]: ...
    @typing.overload
    def try_store_storage_file_bitmap_async(self, bitmap: typing.Optional[winsdk.windows.storage.StorageFile], horizontal_alignment: LineDisplayHorizontalAlignment, vertical_alignment: LineDisplayVerticalAlignment, width_in_pixels: winsdk.system.Int32) -> winsdk.windows.foundation.IAsyncOperation[LineDisplayStoredBitmap]: ...
    def try_update_attributes_async(self, attributes: typing.Optional[LineDisplayAttributes]) -> winsdk.windows.foundation.IAsyncOperation[winsdk.system.Boolean]: ...
    def add_release_device_requested(self, handler: winsdk.windows.foundation.TypedEventHandler[ClaimedLineDisplay, winsdk.system.Object]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_release_device_requested(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...
    def add_status_updated(self, handler: winsdk.windows.foundation.TypedEventHandler[ClaimedLineDisplay, LineDisplayStatusUpdatedEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_status_updated(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...
    def add_closed(self, handler: winsdk.windows.foundation.TypedEventHandler[ClaimedLineDisplay, ClaimedLineDisplayClosedEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_closed(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...

class ClaimedLineDisplayClosedEventArgs(winsdk.system.Object):
    @staticmethod
    def _from(obj: winsdk.system.Object) -> ClaimedLineDisplayClosedEventArgs: ...

class ClaimedMagneticStripeReader(winsdk.system.Object):
    tracks_to_read: MagneticStripeReaderTrackIds
    is_transmit_sentinels_enabled: winsdk.system.Boolean
    is_disabled_on_data_received: winsdk.system.Boolean
    is_decode_data_enabled: winsdk.system.Boolean
    data_encryption_algorithm: winsdk.system.UInt32
    device_id: str
    is_device_authenticated: winsdk.system.Boolean
    is_enabled: winsdk.system.Boolean
    def __enter__(self: Self) -> Self: ...
    def __exit__(self, *args) -> None: ...
    @staticmethod
    def _from(obj: winsdk.system.Object) -> ClaimedMagneticStripeReader: ...
    def authenticate_device_async(self, response_token: winsdk.system.Array[winsdk.system.UInt8]) -> winsdk.windows.foundation.IAsyncAction: ...
    def close(self) -> None: ...
    def de_authenticate_device_async(self, response_token: winsdk.system.Array[winsdk.system.UInt8]) -> winsdk.windows.foundation.IAsyncAction: ...
    def disable_async(self) -> winsdk.windows.foundation.IAsyncAction: ...
    def enable_async(self) -> winsdk.windows.foundation.IAsyncAction: ...
    def reset_statistics_async(self, statistics_categories: typing.Iterable[str]) -> winsdk.windows.foundation.IAsyncAction: ...
    def retain_device(self) -> None: ...
    def retrieve_device_authentication_data_async(self) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.storage.streams.IBuffer]: ...
    def set_error_reporting_type(self, value: MagneticStripeReaderErrorReportingType) -> None: ...
    def update_key_async(self, key: str, key_name: str) -> winsdk.windows.foundation.IAsyncAction: ...
    def update_statistics_async(self, statistics: typing.Iterable[winsdk.windows.foundation.collections.IKeyValuePair[str, str]]) -> winsdk.windows.foundation.IAsyncAction: ...
    def add_aamva_card_data_received(self, handler: winsdk.windows.foundation.TypedEventHandler[ClaimedMagneticStripeReader, MagneticStripeReaderAamvaCardDataReceivedEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_aamva_card_data_received(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...
    def add_bank_card_data_received(self, handler: winsdk.windows.foundation.TypedEventHandler[ClaimedMagneticStripeReader, MagneticStripeReaderBankCardDataReceivedEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_bank_card_data_received(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...
    def add_error_occurred(self, handler: winsdk.windows.foundation.TypedEventHandler[ClaimedMagneticStripeReader, MagneticStripeReaderErrorOccurredEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_error_occurred(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...
    def add_release_device_requested(self, handler: winsdk.windows.foundation.EventHandler[ClaimedMagneticStripeReader]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_release_device_requested(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...
    def add_vendor_specific_data_received(self, handler: winsdk.windows.foundation.TypedEventHandler[ClaimedMagneticStripeReader, MagneticStripeReaderVendorSpecificCardDataReceivedEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_vendor_specific_data_received(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...
    def add_closed(self, handler: winsdk.windows.foundation.TypedEventHandler[ClaimedMagneticStripeReader, ClaimedMagneticStripeReaderClosedEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_closed(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...

class ClaimedMagneticStripeReaderClosedEventArgs(winsdk.system.Object):
    @staticmethod
    def _from(obj: winsdk.system.Object) -> ClaimedMagneticStripeReaderClosedEventArgs: ...

class ClaimedPosPrinter(winsdk.system.Object):
    map_mode: PosPrinterMapMode
    is_character_set_mapping_enabled: winsdk.system.Boolean
    character_set: winsdk.system.UInt32
    device_id: str
    is_cover_open: winsdk.system.Boolean
    is_enabled: winsdk.system.Boolean
    journal: typing.Optional[ClaimedJournalPrinter]
    receipt: typing.Optional[ClaimedReceiptPrinter]
    slip: typing.Optional[ClaimedSlipPrinter]
    def __enter__(self: Self) -> Self: ...
    def __exit__(self, *args) -> None: ...
    @staticmethod
    def _from(obj: winsdk.system.Object) -> ClaimedPosPrinter: ...
    def close(self) -> None: ...
    def disable_async(self) -> winsdk.windows.foundation.IAsyncOperation[winsdk.system.Boolean]: ...
    def enable_async(self) -> winsdk.windows.foundation.IAsyncOperation[winsdk.system.Boolean]: ...
    def reset_statistics_async(self, statistics_categories: typing.Iterable[str]) -> winsdk.windows.foundation.IAsyncOperation[winsdk.system.Boolean]: ...
    def retain_device_async(self) -> winsdk.windows.foundation.IAsyncOperation[winsdk.system.Boolean]: ...
    def update_statistics_async(self, statistics: typing.Iterable[winsdk.windows.foundation.collections.IKeyValuePair[str, str]]) -> winsdk.windows.foundation.IAsyncOperation[winsdk.system.Boolean]: ...
    def add_release_device_requested(self, handler: winsdk.windows.foundation.TypedEventHandler[ClaimedPosPrinter, PosPrinterReleaseDeviceRequestedEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_release_device_requested(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...
    def add_closed(self, handler: winsdk.windows.foundation.TypedEventHandler[ClaimedPosPrinter, ClaimedPosPrinterClosedEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_closed(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...

class ClaimedPosPrinterClosedEventArgs(winsdk.system.Object):
    @staticmethod
    def _from(obj: winsdk.system.Object) -> ClaimedPosPrinterClosedEventArgs: ...

class ClaimedReceiptPrinter(winsdk.system.Object):
    lines_to_paper_cut: winsdk.system.UInt32
    page_size: winsdk.windows.foundation.Size
    print_area: winsdk.windows.foundation.Rect
    sideways_max_chars: winsdk.system.UInt32
    sideways_max_lines: winsdk.system.UInt32
    line_spacing: winsdk.system.UInt32
    line_height: winsdk.system.UInt32
    is_letter_quality: winsdk.system.Boolean
    color_cartridge: PosPrinterColorCartridge
    characters_per_line: winsdk.system.UInt32
    is_cartridge_empty: winsdk.system.Boolean
    is_cartridge_removed: winsdk.system.Boolean
    is_cover_open: winsdk.system.Boolean
    is_head_cleaning: winsdk.system.Boolean
    is_paper_empty: winsdk.system.Boolean
    is_paper_near_end: winsdk.system.Boolean
    is_ready_to_print: winsdk.system.Boolean
    line_width: winsdk.system.UInt32
    @staticmethod
    def _from(obj: winsdk.system.Object) -> ClaimedReceiptPrinter: ...
    def create_job(self) -> typing.Optional[ReceiptPrintJob]: ...
    def validate_data(self, data: str) -> winsdk.system.Boolean: ...

class ClaimedSlipPrinter(winsdk.system.Object):
    lines_near_end_to_end: winsdk.system.UInt32
    max_lines: winsdk.system.UInt32
    page_size: winsdk.windows.foundation.Size
    print_area: winsdk.windows.foundation.Rect
    print_side: PosPrinterPrintSide
    sideways_max_chars: winsdk.system.UInt32
    sideways_max_lines: winsdk.system.UInt32
    line_spacing: winsdk.system.UInt32
    line_height: winsdk.system.UInt32
    is_letter_quality: winsdk.system.Boolean
    color_cartridge: PosPrinterColorCartridge
    characters_per_line: winsdk.system.UInt32
    is_cartridge_empty: winsdk.system.Boolean
    is_cartridge_removed: winsdk.system.Boolean
    is_cover_open: winsdk.system.Boolean
    is_head_cleaning: winsdk.system.Boolean
    is_paper_empty: winsdk.system.Boolean
    is_paper_near_end: winsdk.system.Boolean
    is_ready_to_print: winsdk.system.Boolean
    line_width: winsdk.system.UInt32
    @staticmethod
    def _from(obj: winsdk.system.Object) -> ClaimedSlipPrinter: ...
    def change_print_side(self, print_side: PosPrinterPrintSide) -> None: ...
    def close_jaws(self) -> None: ...
    def create_job(self) -> typing.Optional[SlipPrintJob]: ...
    def insert_slip_async(self, timeout: datetime.timedelta) -> winsdk.windows.foundation.IAsyncOperation[winsdk.system.Boolean]: ...
    def open_jaws(self) -> None: ...
    def remove_slip_async(self, timeout: datetime.timedelta) -> winsdk.windows.foundation.IAsyncOperation[winsdk.system.Boolean]: ...
    def validate_data(self, data: str) -> winsdk.system.Boolean: ...

class JournalPrintJob(winsdk.system.Object):
    @staticmethod
    def _from(obj: winsdk.system.Object) -> JournalPrintJob: ...
    def execute_async(self) -> winsdk.windows.foundation.IAsyncOperation[winsdk.system.Boolean]: ...
    def feed_paper_by_line(self, line_count: winsdk.system.Int32) -> None: ...
    def feed_paper_by_map_mode_unit(self, distance: winsdk.system.Int32) -> None: ...
    @typing.overload
    def print(self, data: str) -> None: ...
    @typing.overload
    def print(self, data: str, print_options: typing.Optional[PosPrinterPrintOptions]) -> None: ...
    @typing.overload
    def print_line(self) -> None: ...
    @typing.overload
    def print_line(self, data: str) -> None: ...

class JournalPrinterCapabilities(winsdk.system.Object):
    cartridge_sensors: PosPrinterCartridgeSensors
    color_cartridge_capabilities: PosPrinterColorCapabilities
    is_bold_supported: winsdk.system.Boolean
    is_double_high_double_wide_print_supported: winsdk.system.Boolean
    is_double_high_print_supported: winsdk.system.Boolean
    is_double_wide_print_supported: winsdk.system.Boolean
    is_dual_color_supported: winsdk.system.Boolean
    is_italic_supported: winsdk.system.Boolean
    is_paper_empty_sensor_supported: winsdk.system.Boolean
    is_paper_near_end_sensor_supported: winsdk.system.Boolean
    is_printer_present: winsdk.system.Boolean
    is_underline_supported: winsdk.system.Boolean
    supported_characters_per_line: typing.Optional[winsdk.windows.foundation.collections.IVectorView[winsdk.system.UInt32]]
    is_reverse_paper_feed_by_line_supported: winsdk.system.Boolean
    is_reverse_paper_feed_by_map_mode_unit_supported: winsdk.system.Boolean
    is_reverse_video_supported: winsdk.system.Boolean
    is_strikethrough_supported: winsdk.system.Boolean
    is_subscript_supported: winsdk.system.Boolean
    is_superscript_supported: winsdk.system.Boolean
    @staticmethod
    def _from(obj: winsdk.system.Object) -> JournalPrinterCapabilities: ...

class LineDisplay(winsdk.system.Object):
    capabilities: typing.Optional[LineDisplayCapabilities]
    device_control_description: str
    device_control_version: str
    device_id: str
    device_service_version: str
    physical_device_description: str
    physical_device_name: str
    statistics_category_selector: typing.ClassVar[typing.Optional[LineDisplayStatisticsCategorySelector]]
    def __enter__(self: Self) -> Self: ...
    def __exit__(self, *args) -> None: ...
    @staticmethod
    def _from(obj: winsdk.system.Object) -> LineDisplay: ...
    def check_power_status_async(self) -> winsdk.windows.foundation.IAsyncOperation[LineDisplayPowerStatus]: ...
    def claim_async(self) -> winsdk.windows.foundation.IAsyncOperation[ClaimedLineDisplay]: ...
    def close(self) -> None: ...
    @staticmethod
    def from_id_async(device_id: str) -> winsdk.windows.foundation.IAsyncOperation[LineDisplay]: ...
    @staticmethod
    def get_default_async() -> winsdk.windows.foundation.IAsyncOperation[LineDisplay]: ...
    @typing.overload
    @staticmethod
    def get_device_selector() -> str: ...
    @typing.overload
    @staticmethod
    def get_device_selector(connection_types: PosConnectionTypes) -> str: ...

class LineDisplayAttributes(winsdk.system.Object):
    screen_size_in_characters: winsdk.windows.foundation.Size
    is_power_notify_enabled: winsdk.system.Boolean
    is_character_set_mapping_enabled: winsdk.system.Boolean
    current_window: typing.Optional[LineDisplayWindow]
    character_set: winsdk.system.Int32
    brightness: winsdk.system.Int32
    blink_rate: datetime.timedelta
    @staticmethod
    def _from(obj: winsdk.system.Object) -> LineDisplayAttributes: ...

class LineDisplayCapabilities(winsdk.system.Object):
    can_blink: LineDisplayTextAttributeGranularity
    can_change_blink_rate: winsdk.system.Boolean
    can_change_screen_size: winsdk.system.Boolean
    can_display_bitmaps: winsdk.system.Boolean
    can_display_custom_glyphs: winsdk.system.Boolean
    can_map_character_sets: winsdk.system.Boolean
    can_read_character_at_cursor: winsdk.system.Boolean
    can_reverse: LineDisplayTextAttributeGranularity
    is_brightness_supported: winsdk.system.Boolean
    is_cursor_supported: winsdk.system.Boolean
    is_horizontal_marquee_supported: winsdk.system.Boolean
    is_inter_character_wait_supported: winsdk.system.Boolean
    is_statistics_reporting_supported: winsdk.system.Boolean
    is_statistics_updating_supported: winsdk.system.Boolean
    is_vertical_marquee_supported: winsdk.system.Boolean
    power_reporting_type: UnifiedPosPowerReportingType
    supported_descriptors: winsdk.system.UInt32
    supported_windows: winsdk.system.UInt32
    @staticmethod
    def _from(obj: winsdk.system.Object) -> LineDisplayCapabilities: ...

class LineDisplayCursor(winsdk.system.Object):
    can_customize: winsdk.system.Boolean
    is_blink_supported: winsdk.system.Boolean
    is_block_supported: winsdk.system.Boolean
    is_half_block_supported: winsdk.system.Boolean
    is_other_supported: winsdk.system.Boolean
    is_reverse_supported: winsdk.system.Boolean
    is_underline_supported: winsdk.system.Boolean
    @staticmethod
    def _from(obj: winsdk.system.Object) -> LineDisplayCursor: ...
    def get_attributes(self) -> typing.Optional[LineDisplayCursorAttributes]: ...
    def try_update_attributes_async(self, attributes: typing.Optional[LineDisplayCursorAttributes]) -> winsdk.windows.foundation.IAsyncOperation[winsdk.system.Boolean]: ...

class LineDisplayCursorAttributes(winsdk.system.Object):
    position: winsdk.windows.foundation.Point
    is_blink_enabled: winsdk.system.Boolean
    is_auto_advance_enabled: winsdk.system.Boolean
    cursor_type: LineDisplayCursorType
    @staticmethod
    def _from(obj: winsdk.system.Object) -> LineDisplayCursorAttributes: ...

class LineDisplayCustomGlyphs(winsdk.system.Object):
    size_in_pixels: winsdk.windows.foundation.Size
    supported_glyph_codes: typing.Optional[winsdk.windows.foundation.collections.IVectorView[winsdk.system.UInt32]]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> LineDisplayCustomGlyphs: ...
    def try_redefine_async(self, glyph_code: winsdk.system.UInt32, glyph_data: typing.Optional[winsdk.windows.storage.streams.IBuffer]) -> winsdk.windows.foundation.IAsyncOperation[winsdk.system.Boolean]: ...

class LineDisplayMarquee(winsdk.system.Object):
    scroll_wait_interval: datetime.timedelta
    repeat_wait_interval: datetime.timedelta
    format: LineDisplayMarqueeFormat
    @staticmethod
    def _from(obj: winsdk.system.Object) -> LineDisplayMarquee: ...
    def try_start_scrolling_async(self, direction: LineDisplayScrollDirection) -> winsdk.windows.foundation.IAsyncOperation[winsdk.system.Boolean]: ...
    def try_stop_scrolling_async(self) -> winsdk.windows.foundation.IAsyncOperation[winsdk.system.Boolean]: ...

class LineDisplayStatisticsCategorySelector(winsdk.system.Object):
    all_statistics: str
    manufacturer_statistics: str
    unified_pos_statistics: str
    @staticmethod
    def _from(obj: winsdk.system.Object) -> LineDisplayStatisticsCategorySelector: ...

class LineDisplayStatusUpdatedEventArgs(winsdk.system.Object):
    status: LineDisplayPowerStatus
    @staticmethod
    def _from(obj: winsdk.system.Object) -> LineDisplayStatusUpdatedEventArgs: ...

class LineDisplayStoredBitmap(winsdk.system.Object):
    escape_sequence: str
    @staticmethod
    def _from(obj: winsdk.system.Object) -> LineDisplayStoredBitmap: ...
    def try_delete_async(self) -> winsdk.windows.foundation.IAsyncOperation[winsdk.system.Boolean]: ...

class LineDisplayWindow(winsdk.system.Object):
    inter_character_wait_interval: datetime.timedelta
    size_in_characters: winsdk.windows.foundation.Size
    cursor: typing.Optional[LineDisplayCursor]
    marquee: typing.Optional[LineDisplayMarquee]
    def __enter__(self: Self) -> Self: ...
    def __exit__(self, *args) -> None: ...
    @staticmethod
    def _from(obj: winsdk.system.Object) -> LineDisplayWindow: ...
    def close(self) -> None: ...
    def read_character_at_cursor_async(self) -> winsdk.windows.foundation.IAsyncOperation[winsdk.system.UInt32]: ...
    def try_clear_text_async(self) -> winsdk.windows.foundation.IAsyncOperation[winsdk.system.Boolean]: ...
    @typing.overload
    def try_display_storage_file_bitmap_at_cursor_async(self, bitmap: typing.Optional[winsdk.windows.storage.StorageFile]) -> winsdk.windows.foundation.IAsyncOperation[winsdk.system.Boolean]: ...
    @typing.overload
    def try_display_storage_file_bitmap_at_cursor_async(self, bitmap: typing.Optional[winsdk.windows.storage.StorageFile], horizontal_alignment: LineDisplayHorizontalAlignment, vertical_alignment: LineDisplayVerticalAlignment) -> winsdk.windows.foundation.IAsyncOperation[winsdk.system.Boolean]: ...
    @typing.overload
    def try_display_storage_file_bitmap_at_cursor_async(self, bitmap: typing.Optional[winsdk.windows.storage.StorageFile], horizontal_alignment: LineDisplayHorizontalAlignment, vertical_alignment: LineDisplayVerticalAlignment, width_in_pixels: winsdk.system.Int32) -> winsdk.windows.foundation.IAsyncOperation[winsdk.system.Boolean]: ...
    @typing.overload
    def try_display_storage_file_bitmap_at_point_async(self, bitmap: typing.Optional[winsdk.windows.storage.StorageFile], offset_in_pixels: winsdk.windows.foundation.Point) -> winsdk.windows.foundation.IAsyncOperation[winsdk.system.Boolean]: ...
    @typing.overload
    def try_display_storage_file_bitmap_at_point_async(self, bitmap: typing.Optional[winsdk.windows.storage.StorageFile], offset_in_pixels: winsdk.windows.foundation.Point, width_in_pixels: winsdk.system.Int32) -> winsdk.windows.foundation.IAsyncOperation[winsdk.system.Boolean]: ...
    def try_display_stored_bitmap_at_cursor_async(self, bitmap: typing.Optional[LineDisplayStoredBitmap]) -> winsdk.windows.foundation.IAsyncOperation[winsdk.system.Boolean]: ...
    @typing.overload
    def try_display_text_async(self, text: str) -> winsdk.windows.foundation.IAsyncOperation[winsdk.system.Boolean]: ...
    @typing.overload
    def try_display_text_async(self, text: str, display_attribute: LineDisplayTextAttribute) -> winsdk.windows.foundation.IAsyncOperation[winsdk.system.Boolean]: ...
    @typing.overload
    def try_display_text_async(self, text: str, display_attribute: LineDisplayTextAttribute, start_position: winsdk.windows.foundation.Point) -> winsdk.windows.foundation.IAsyncOperation[winsdk.system.Boolean]: ...
    def try_refresh_async(self) -> winsdk.windows.foundation.IAsyncOperation[winsdk.system.Boolean]: ...
    def try_scroll_text_async(self, direction: LineDisplayScrollDirection, number_of_columns_or_rows: winsdk.system.UInt32) -> winsdk.windows.foundation.IAsyncOperation[winsdk.system.Boolean]: ...

class MagneticStripeReader(winsdk.system.Object):
    capabilities: typing.Optional[MagneticStripeReaderCapabilities]
    device_authentication_protocol: MagneticStripeReaderAuthenticationProtocol
    device_id: str
    supported_card_types: winsdk.system.UInt32
    def __enter__(self: Self) -> Self: ...
    def __exit__(self, *args) -> None: ...
    @staticmethod
    def _from(obj: winsdk.system.Object) -> MagneticStripeReader: ...
    def check_health_async(self, level: UnifiedPosHealthCheckLevel) -> winsdk.windows.foundation.IAsyncOperation[str]: ...
    def claim_reader_async(self) -> winsdk.windows.foundation.IAsyncOperation[ClaimedMagneticStripeReader]: ...
    def close(self) -> None: ...
    @staticmethod
    def from_id_async(device_id: str) -> winsdk.windows.foundation.IAsyncOperation[MagneticStripeReader]: ...
    @staticmethod
    def get_default_async() -> winsdk.windows.foundation.IAsyncOperation[MagneticStripeReader]: ...
    @typing.overload
    @staticmethod
    def get_device_selector() -> str: ...
    @typing.overload
    @staticmethod
    def get_device_selector(connection_types: PosConnectionTypes) -> str: ...
    def get_error_reporting_type(self) -> MagneticStripeReaderErrorReportingType: ...
    def retrieve_statistics_async(self, statistics_categories: typing.Iterable[str]) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.storage.streams.IBuffer]: ...
    def add_status_updated(self, handler: winsdk.windows.foundation.TypedEventHandler[MagneticStripeReader, MagneticStripeReaderStatusUpdatedEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_status_updated(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...

class MagneticStripeReaderAamvaCardDataReceivedEventArgs(winsdk.system.Object):
    address: str
    birth_date: str
    city: str
    class_: str
    endorsements: str
    expiration_date: str
    eye_color: str
    first_name: str
    gender: str
    hair_color: str
    height: str
    license_number: str
    postal_code: str
    report: typing.Optional[MagneticStripeReaderReport]
    restrictions: str
    state: str
    suffix: str
    surname: str
    weight: str
    @staticmethod
    def _from(obj: winsdk.system.Object) -> MagneticStripeReaderAamvaCardDataReceivedEventArgs: ...

class MagneticStripeReaderBankCardDataReceivedEventArgs(winsdk.system.Object):
    account_number: str
    expiration_date: str
    first_name: str
    middle_initial: str
    report: typing.Optional[MagneticStripeReaderReport]
    service_code: str
    suffix: str
    surname: str
    title: str
    @staticmethod
    def _from(obj: winsdk.system.Object) -> MagneticStripeReaderBankCardDataReceivedEventArgs: ...

class MagneticStripeReaderCapabilities(winsdk.system.Object):
    authentication_level: MagneticStripeReaderAuthenticationLevel
    card_authentication: str
    is_iso_supported: winsdk.system.Boolean
    is_jis_one_supported: winsdk.system.Boolean
    is_jis_two_supported: winsdk.system.Boolean
    is_statistics_reporting_supported: winsdk.system.Boolean
    is_statistics_updating_supported: winsdk.system.Boolean
    is_track_data_masking_supported: winsdk.system.Boolean
    is_transmit_sentinels_supported: winsdk.system.Boolean
    power_reporting_type: UnifiedPosPowerReportingType
    supported_encryption_algorithms: winsdk.system.UInt32
    @staticmethod
    def _from(obj: winsdk.system.Object) -> MagneticStripeReaderCapabilities: ...

class MagneticStripeReaderCardTypes(winsdk.system.Object):
    aamva: typing.ClassVar[winsdk.system.UInt32]
    bank: typing.ClassVar[winsdk.system.UInt32]
    extended_base: typing.ClassVar[winsdk.system.UInt32]
    unknown: typing.ClassVar[winsdk.system.UInt32]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> MagneticStripeReaderCardTypes: ...

class MagneticStripeReaderEncryptionAlgorithms(winsdk.system.Object):
    extended_base: typing.ClassVar[winsdk.system.UInt32]
    none: typing.ClassVar[winsdk.system.UInt32]
    triple_des_dukpt: typing.ClassVar[winsdk.system.UInt32]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> MagneticStripeReaderEncryptionAlgorithms: ...

class MagneticStripeReaderErrorOccurredEventArgs(winsdk.system.Object):
    error_data: typing.Optional[UnifiedPosErrorData]
    partial_input_data: typing.Optional[MagneticStripeReaderReport]
    track1_status: MagneticStripeReaderTrackErrorType
    track2_status: MagneticStripeReaderTrackErrorType
    track3_status: MagneticStripeReaderTrackErrorType
    track4_status: MagneticStripeReaderTrackErrorType
    @staticmethod
    def _from(obj: winsdk.system.Object) -> MagneticStripeReaderErrorOccurredEventArgs: ...

class MagneticStripeReaderReport(winsdk.system.Object):
    additional_security_information: typing.Optional[winsdk.windows.storage.streams.IBuffer]
    card_authentication_data: typing.Optional[winsdk.windows.storage.streams.IBuffer]
    card_authentication_data_length: winsdk.system.UInt32
    card_type: winsdk.system.UInt32
    properties: typing.Optional[winsdk.windows.foundation.collections.IMapView[str, str]]
    track1: typing.Optional[MagneticStripeReaderTrackData]
    track2: typing.Optional[MagneticStripeReaderTrackData]
    track3: typing.Optional[MagneticStripeReaderTrackData]
    track4: typing.Optional[MagneticStripeReaderTrackData]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> MagneticStripeReaderReport: ...

class MagneticStripeReaderStatusUpdatedEventArgs(winsdk.system.Object):
    extended_status: winsdk.system.UInt32
    status: MagneticStripeReaderStatus
    @staticmethod
    def _from(obj: winsdk.system.Object) -> MagneticStripeReaderStatusUpdatedEventArgs: ...

class MagneticStripeReaderTrackData(winsdk.system.Object):
    data: typing.Optional[winsdk.windows.storage.streams.IBuffer]
    discretionary_data: typing.Optional[winsdk.windows.storage.streams.IBuffer]
    encrypted_data: typing.Optional[winsdk.windows.storage.streams.IBuffer]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> MagneticStripeReaderTrackData: ...

class MagneticStripeReaderVendorSpecificCardDataReceivedEventArgs(winsdk.system.Object):
    report: typing.Optional[MagneticStripeReaderReport]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> MagneticStripeReaderVendorSpecificCardDataReceivedEventArgs: ...

class PosPrinter(winsdk.system.Object):
    capabilities: typing.Optional[PosPrinterCapabilities]
    device_id: str
    status: typing.Optional[PosPrinterStatus]
    supported_character_sets: typing.Optional[winsdk.windows.foundation.collections.IVectorView[winsdk.system.UInt32]]
    supported_type_faces: typing.Optional[winsdk.windows.foundation.collections.IVectorView[str]]
    supported_barcode_symbologies: typing.Optional[winsdk.windows.foundation.collections.IVectorView[winsdk.system.UInt32]]
    def __enter__(self: Self) -> Self: ...
    def __exit__(self, *args) -> None: ...
    @staticmethod
    def _from(obj: winsdk.system.Object) -> PosPrinter: ...
    def check_health_async(self, level: UnifiedPosHealthCheckLevel) -> winsdk.windows.foundation.IAsyncOperation[str]: ...
    def claim_printer_async(self) -> winsdk.windows.foundation.IAsyncOperation[ClaimedPosPrinter]: ...
    def close(self) -> None: ...
    @staticmethod
    def from_id_async(device_id: str) -> winsdk.windows.foundation.IAsyncOperation[PosPrinter]: ...
    @staticmethod
    def get_default_async() -> winsdk.windows.foundation.IAsyncOperation[PosPrinter]: ...
    @typing.overload
    @staticmethod
    def get_device_selector() -> str: ...
    @typing.overload
    @staticmethod
    def get_device_selector(connection_types: PosConnectionTypes) -> str: ...
    def get_font_property(self, typeface: str) -> typing.Optional[PosPrinterFontProperty]: ...
    def get_statistics_async(self, statistics_categories: typing.Iterable[str]) -> winsdk.windows.foundation.IAsyncOperation[str]: ...
    def add_status_updated(self, handler: winsdk.windows.foundation.TypedEventHandler[PosPrinter, PosPrinterStatusUpdatedEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_status_updated(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...

class PosPrinterCapabilities(winsdk.system.Object):
    can_map_character_set: winsdk.system.Boolean
    default_character_set: winsdk.system.UInt32
    has_cover_sensor: winsdk.system.Boolean
    is_statistics_reporting_supported: winsdk.system.Boolean
    is_statistics_updating_supported: winsdk.system.Boolean
    is_transaction_supported: winsdk.system.Boolean
    journal: typing.Optional[JournalPrinterCapabilities]
    power_reporting_type: UnifiedPosPowerReportingType
    receipt: typing.Optional[ReceiptPrinterCapabilities]
    slip: typing.Optional[SlipPrinterCapabilities]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> PosPrinterCapabilities: ...

class PosPrinterCharacterSetIds(winsdk.system.Object):
    ansi: typing.ClassVar[winsdk.system.UInt32]
    ascii: typing.ClassVar[winsdk.system.UInt32]
    utf16_l_e: typing.ClassVar[winsdk.system.UInt32]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> PosPrinterCharacterSetIds: ...

class PosPrinterFontProperty(winsdk.system.Object):
    character_sizes: typing.Optional[winsdk.windows.foundation.collections.IVectorView[SizeUInt32]]
    is_scalable_to_any_size: winsdk.system.Boolean
    type_face: str
    @staticmethod
    def _from(obj: winsdk.system.Object) -> PosPrinterFontProperty: ...

class PosPrinterPrintOptions(winsdk.system.Object):
    underline: winsdk.system.Boolean
    type_face: str
    superscript: winsdk.system.Boolean
    subscript: winsdk.system.Boolean
    strikethrough: winsdk.system.Boolean
    reverse_video: winsdk.system.Boolean
    italic: winsdk.system.Boolean
    double_wide: winsdk.system.Boolean
    double_high: winsdk.system.Boolean
    character_set: winsdk.system.UInt32
    character_height: winsdk.system.UInt32
    bold: winsdk.system.Boolean
    alignment: PosPrinterAlignment
    @staticmethod
    def _from(obj: winsdk.system.Object) -> PosPrinterPrintOptions: ...
    def __new__(cls: typing.Type[PosPrinterPrintOptions]) -> PosPrinterPrintOptions:...

class PosPrinterReleaseDeviceRequestedEventArgs(winsdk.system.Object):
    @staticmethod
    def _from(obj: winsdk.system.Object) -> PosPrinterReleaseDeviceRequestedEventArgs: ...

class PosPrinterStatus(winsdk.system.Object):
    extended_status: winsdk.system.UInt32
    status_kind: PosPrinterStatusKind
    @staticmethod
    def _from(obj: winsdk.system.Object) -> PosPrinterStatus: ...

class PosPrinterStatusUpdatedEventArgs(winsdk.system.Object):
    status: typing.Optional[PosPrinterStatus]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> PosPrinterStatusUpdatedEventArgs: ...

class ReceiptPrintJob(winsdk.system.Object):
    @staticmethod
    def _from(obj: winsdk.system.Object) -> ReceiptPrintJob: ...
    @typing.overload
    def cut_paper(self) -> None: ...
    @typing.overload
    def cut_paper(self, percentage: winsdk.system.Double) -> None: ...
    def draw_ruled_line(self, position_list: str, line_direction: PosPrinterLineDirection, line_width: winsdk.system.UInt32, line_style: PosPrinterLineStyle, line_color: winsdk.system.UInt32) -> None: ...
    def execute_async(self) -> winsdk.windows.foundation.IAsyncOperation[winsdk.system.Boolean]: ...
    def feed_paper_by_line(self, line_count: winsdk.system.Int32) -> None: ...
    def feed_paper_by_map_mode_unit(self, distance: winsdk.system.Int32) -> None: ...
    def mark_feed(self, kind: PosPrinterMarkFeedKind) -> None: ...
    @typing.overload
    def print(self, data: str) -> None: ...
    @typing.overload
    def print(self, data: str, print_options: typing.Optional[PosPrinterPrintOptions]) -> None: ...
    def print_barcode(self, data: str, symbology: winsdk.system.UInt32, height: winsdk.system.UInt32, width: winsdk.system.UInt32, text_position: PosPrinterBarcodeTextPosition, alignment: PosPrinterAlignment) -> None: ...
    def print_barcode_custom_align(self, data: str, symbology: winsdk.system.UInt32, height: winsdk.system.UInt32, width: winsdk.system.UInt32, text_position: PosPrinterBarcodeTextPosition, alignment_distance: winsdk.system.UInt32) -> None: ...
    @typing.overload
    def print_bitmap(self, bitmap: typing.Optional[winsdk.windows.graphics.imaging.BitmapFrame], alignment: PosPrinterAlignment) -> None: ...
    @typing.overload
    def print_bitmap(self, bitmap: typing.Optional[winsdk.windows.graphics.imaging.BitmapFrame], alignment: PosPrinterAlignment, width: winsdk.system.UInt32) -> None: ...
    @typing.overload
    def print_custom_aligned_bitmap(self, bitmap: typing.Optional[winsdk.windows.graphics.imaging.BitmapFrame], alignment_distance: winsdk.system.UInt32) -> None: ...
    @typing.overload
    def print_custom_aligned_bitmap(self, bitmap: typing.Optional[winsdk.windows.graphics.imaging.BitmapFrame], alignment_distance: winsdk.system.UInt32, width: winsdk.system.UInt32) -> None: ...
    @typing.overload
    def print_line(self) -> None: ...
    @typing.overload
    def print_line(self, data: str) -> None: ...
    def print_saved_bitmap(self, bitmap_number: winsdk.system.UInt32) -> None: ...
    def set_barcode_rotation(self, value: PosPrinterRotation) -> None: ...
    @typing.overload
    def set_bitmap(self, bitmap_number: winsdk.system.UInt32, bitmap: typing.Optional[winsdk.windows.graphics.imaging.BitmapFrame], alignment: PosPrinterAlignment) -> None: ...
    @typing.overload
    def set_bitmap(self, bitmap_number: winsdk.system.UInt32, bitmap: typing.Optional[winsdk.windows.graphics.imaging.BitmapFrame], alignment: PosPrinterAlignment, width: winsdk.system.UInt32) -> None: ...
    @typing.overload
    def set_custom_aligned_bitmap(self, bitmap_number: winsdk.system.UInt32, bitmap: typing.Optional[winsdk.windows.graphics.imaging.BitmapFrame], alignment_distance: winsdk.system.UInt32) -> None: ...
    @typing.overload
    def set_custom_aligned_bitmap(self, bitmap_number: winsdk.system.UInt32, bitmap: typing.Optional[winsdk.windows.graphics.imaging.BitmapFrame], alignment_distance: winsdk.system.UInt32, width: winsdk.system.UInt32) -> None: ...
    def set_print_area(self, value: winsdk.windows.foundation.Rect) -> None: ...
    def set_print_rotation(self, value: PosPrinterRotation, include_bitmaps: winsdk.system.Boolean) -> None: ...
    def stamp_paper(self) -> None: ...

class ReceiptPrinterCapabilities(winsdk.system.Object):
    cartridge_sensors: PosPrinterCartridgeSensors
    color_cartridge_capabilities: PosPrinterColorCapabilities
    is_bold_supported: winsdk.system.Boolean
    is_double_high_double_wide_print_supported: winsdk.system.Boolean
    is_double_high_print_supported: winsdk.system.Boolean
    is_double_wide_print_supported: winsdk.system.Boolean
    is_dual_color_supported: winsdk.system.Boolean
    is_italic_supported: winsdk.system.Boolean
    is_paper_empty_sensor_supported: winsdk.system.Boolean
    is_paper_near_end_sensor_supported: winsdk.system.Boolean
    is_printer_present: winsdk.system.Boolean
    is_underline_supported: winsdk.system.Boolean
    supported_characters_per_line: typing.Optional[winsdk.windows.foundation.collections.IVectorView[winsdk.system.UInt32]]
    is180_rotation_supported: winsdk.system.Boolean
    is_barcode_supported: winsdk.system.Boolean
    is_bitmap_supported: winsdk.system.Boolean
    is_left90_rotation_supported: winsdk.system.Boolean
    is_print_area_supported: winsdk.system.Boolean
    is_right90_rotation_supported: winsdk.system.Boolean
    ruled_line_capabilities: PosPrinterRuledLineCapabilities
    supported_barcode_rotations: typing.Optional[winsdk.windows.foundation.collections.IVectorView[PosPrinterRotation]]
    supported_bitmap_rotations: typing.Optional[winsdk.windows.foundation.collections.IVectorView[PosPrinterRotation]]
    can_cut_paper: winsdk.system.Boolean
    is_stamp_supported: winsdk.system.Boolean
    mark_feed_capabilities: PosPrinterMarkFeedCapabilities
    is_reverse_paper_feed_by_line_supported: winsdk.system.Boolean
    is_reverse_paper_feed_by_map_mode_unit_supported: winsdk.system.Boolean
    is_reverse_video_supported: winsdk.system.Boolean
    is_strikethrough_supported: winsdk.system.Boolean
    is_subscript_supported: winsdk.system.Boolean
    is_superscript_supported: winsdk.system.Boolean
    @staticmethod
    def _from(obj: winsdk.system.Object) -> ReceiptPrinterCapabilities: ...

class SlipPrintJob(winsdk.system.Object):
    @staticmethod
    def _from(obj: winsdk.system.Object) -> SlipPrintJob: ...
    def draw_ruled_line(self, position_list: str, line_direction: PosPrinterLineDirection, line_width: winsdk.system.UInt32, line_style: PosPrinterLineStyle, line_color: winsdk.system.UInt32) -> None: ...
    def execute_async(self) -> winsdk.windows.foundation.IAsyncOperation[winsdk.system.Boolean]: ...
    def feed_paper_by_line(self, line_count: winsdk.system.Int32) -> None: ...
    def feed_paper_by_map_mode_unit(self, distance: winsdk.system.Int32) -> None: ...
    @typing.overload
    def print(self, data: str) -> None: ...
    @typing.overload
    def print(self, data: str, print_options: typing.Optional[PosPrinterPrintOptions]) -> None: ...
    def print_barcode(self, data: str, symbology: winsdk.system.UInt32, height: winsdk.system.UInt32, width: winsdk.system.UInt32, text_position: PosPrinterBarcodeTextPosition, alignment: PosPrinterAlignment) -> None: ...
    def print_barcode_custom_align(self, data: str, symbology: winsdk.system.UInt32, height: winsdk.system.UInt32, width: winsdk.system.UInt32, text_position: PosPrinterBarcodeTextPosition, alignment_distance: winsdk.system.UInt32) -> None: ...
    @typing.overload
    def print_bitmap(self, bitmap: typing.Optional[winsdk.windows.graphics.imaging.BitmapFrame], alignment: PosPrinterAlignment) -> None: ...
    @typing.overload
    def print_bitmap(self, bitmap: typing.Optional[winsdk.windows.graphics.imaging.BitmapFrame], alignment: PosPrinterAlignment, width: winsdk.system.UInt32) -> None: ...
    @typing.overload
    def print_custom_aligned_bitmap(self, bitmap: typing.Optional[winsdk.windows.graphics.imaging.BitmapFrame], alignment_distance: winsdk.system.UInt32) -> None: ...
    @typing.overload
    def print_custom_aligned_bitmap(self, bitmap: typing.Optional[winsdk.windows.graphics.imaging.BitmapFrame], alignment_distance: winsdk.system.UInt32, width: winsdk.system.UInt32) -> None: ...
    @typing.overload
    def print_line(self) -> None: ...
    @typing.overload
    def print_line(self, data: str) -> None: ...
    def print_saved_bitmap(self, bitmap_number: winsdk.system.UInt32) -> None: ...
    def set_barcode_rotation(self, value: PosPrinterRotation) -> None: ...
    @typing.overload
    def set_bitmap(self, bitmap_number: winsdk.system.UInt32, bitmap: typing.Optional[winsdk.windows.graphics.imaging.BitmapFrame], alignment: PosPrinterAlignment) -> None: ...
    @typing.overload
    def set_bitmap(self, bitmap_number: winsdk.system.UInt32, bitmap: typing.Optional[winsdk.windows.graphics.imaging.BitmapFrame], alignment: PosPrinterAlignment, width: winsdk.system.UInt32) -> None: ...
    @typing.overload
    def set_custom_aligned_bitmap(self, bitmap_number: winsdk.system.UInt32, bitmap: typing.Optional[winsdk.windows.graphics.imaging.BitmapFrame], alignment_distance: winsdk.system.UInt32) -> None: ...
    @typing.overload
    def set_custom_aligned_bitmap(self, bitmap_number: winsdk.system.UInt32, bitmap: typing.Optional[winsdk.windows.graphics.imaging.BitmapFrame], alignment_distance: winsdk.system.UInt32, width: winsdk.system.UInt32) -> None: ...
    def set_print_area(self, value: winsdk.windows.foundation.Rect) -> None: ...
    def set_print_rotation(self, value: PosPrinterRotation, include_bitmaps: winsdk.system.Boolean) -> None: ...

class SlipPrinterCapabilities(winsdk.system.Object):
    cartridge_sensors: PosPrinterCartridgeSensors
    color_cartridge_capabilities: PosPrinterColorCapabilities
    is_bold_supported: winsdk.system.Boolean
    is_double_high_double_wide_print_supported: winsdk.system.Boolean
    is_double_high_print_supported: winsdk.system.Boolean
    is_double_wide_print_supported: winsdk.system.Boolean
    is_dual_color_supported: winsdk.system.Boolean
    is_italic_supported: winsdk.system.Boolean
    is_paper_empty_sensor_supported: winsdk.system.Boolean
    is_paper_near_end_sensor_supported: winsdk.system.Boolean
    is_printer_present: winsdk.system.Boolean
    is_underline_supported: winsdk.system.Boolean
    supported_characters_per_line: typing.Optional[winsdk.windows.foundation.collections.IVectorView[winsdk.system.UInt32]]
    is180_rotation_supported: winsdk.system.Boolean
    is_barcode_supported: winsdk.system.Boolean
    is_bitmap_supported: winsdk.system.Boolean
    is_left90_rotation_supported: winsdk.system.Boolean
    is_print_area_supported: winsdk.system.Boolean
    is_right90_rotation_supported: winsdk.system.Boolean
    ruled_line_capabilities: PosPrinterRuledLineCapabilities
    supported_barcode_rotations: typing.Optional[winsdk.windows.foundation.collections.IVectorView[PosPrinterRotation]]
    supported_bitmap_rotations: typing.Optional[winsdk.windows.foundation.collections.IVectorView[PosPrinterRotation]]
    is_both_sides_printing_supported: winsdk.system.Boolean
    is_full_length_supported: winsdk.system.Boolean
    is_reverse_paper_feed_by_line_supported: winsdk.system.Boolean
    is_reverse_paper_feed_by_map_mode_unit_supported: winsdk.system.Boolean
    is_reverse_video_supported: winsdk.system.Boolean
    is_strikethrough_supported: winsdk.system.Boolean
    is_subscript_supported: winsdk.system.Boolean
    is_superscript_supported: winsdk.system.Boolean
    @staticmethod
    def _from(obj: winsdk.system.Object) -> SlipPrinterCapabilities: ...

class UnifiedPosErrorData(winsdk.system.Object):
    extended_reason: winsdk.system.UInt32
    message: str
    reason: UnifiedPosErrorReason
    severity: UnifiedPosErrorSeverity
    @staticmethod
    def _from(obj: winsdk.system.Object) -> UnifiedPosErrorData: ...
    def __new__(cls: typing.Type[UnifiedPosErrorData], message: str, severity: UnifiedPosErrorSeverity, reason: UnifiedPosErrorReason, extended_reason: winsdk.system.UInt32) -> UnifiedPosErrorData:...

class ICashDrawerEventSourceEventArgs(winsdk.system.Object):
    cash_drawer: typing.Optional[CashDrawer]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> ICashDrawerEventSourceEventArgs: ...

class ICommonClaimedPosPrinterStation(winsdk.system.Object):
    characters_per_line: winsdk.system.UInt32
    color_cartridge: PosPrinterColorCartridge
    is_cartridge_empty: winsdk.system.Boolean
    is_cartridge_removed: winsdk.system.Boolean
    is_cover_open: winsdk.system.Boolean
    is_head_cleaning: winsdk.system.Boolean
    is_letter_quality: winsdk.system.Boolean
    is_paper_empty: winsdk.system.Boolean
    is_paper_near_end: winsdk.system.Boolean
    is_ready_to_print: winsdk.system.Boolean
    line_height: winsdk.system.UInt32
    line_spacing: winsdk.system.UInt32
    line_width: winsdk.system.UInt32
    @staticmethod
    def _from(obj: winsdk.system.Object) -> ICommonClaimedPosPrinterStation: ...
    def validate_data(self, data: str) -> winsdk.system.Boolean: ...

class ICommonPosPrintStationCapabilities(winsdk.system.Object):
    cartridge_sensors: PosPrinterCartridgeSensors
    color_cartridge_capabilities: PosPrinterColorCapabilities
    is_bold_supported: winsdk.system.Boolean
    is_double_high_double_wide_print_supported: winsdk.system.Boolean
    is_double_high_print_supported: winsdk.system.Boolean
    is_double_wide_print_supported: winsdk.system.Boolean
    is_dual_color_supported: winsdk.system.Boolean
    is_italic_supported: winsdk.system.Boolean
    is_paper_empty_sensor_supported: winsdk.system.Boolean
    is_paper_near_end_sensor_supported: winsdk.system.Boolean
    is_printer_present: winsdk.system.Boolean
    is_underline_supported: winsdk.system.Boolean
    supported_characters_per_line: typing.Optional[winsdk.windows.foundation.collections.IVectorView[winsdk.system.UInt32]]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> ICommonPosPrintStationCapabilities: ...

class ICommonReceiptSlipCapabilities(winsdk.system.Object):
    is180_rotation_supported: winsdk.system.Boolean
    is_barcode_supported: winsdk.system.Boolean
    is_bitmap_supported: winsdk.system.Boolean
    is_left90_rotation_supported: winsdk.system.Boolean
    is_print_area_supported: winsdk.system.Boolean
    is_right90_rotation_supported: winsdk.system.Boolean
    ruled_line_capabilities: PosPrinterRuledLineCapabilities
    supported_barcode_rotations: typing.Optional[winsdk.windows.foundation.collections.IVectorView[PosPrinterRotation]]
    supported_bitmap_rotations: typing.Optional[winsdk.windows.foundation.collections.IVectorView[PosPrinterRotation]]
    cartridge_sensors: PosPrinterCartridgeSensors
    color_cartridge_capabilities: PosPrinterColorCapabilities
    is_bold_supported: winsdk.system.Boolean
    is_double_high_double_wide_print_supported: winsdk.system.Boolean
    is_double_high_print_supported: winsdk.system.Boolean
    is_double_wide_print_supported: winsdk.system.Boolean
    is_dual_color_supported: winsdk.system.Boolean
    is_italic_supported: winsdk.system.Boolean
    is_paper_empty_sensor_supported: winsdk.system.Boolean
    is_paper_near_end_sensor_supported: winsdk.system.Boolean
    is_printer_present: winsdk.system.Boolean
    is_underline_supported: winsdk.system.Boolean
    supported_characters_per_line: typing.Optional[winsdk.windows.foundation.collections.IVectorView[winsdk.system.UInt32]]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> ICommonReceiptSlipCapabilities: ...

class IPosPrinterJob(winsdk.system.Object):
    @staticmethod
    def _from(obj: winsdk.system.Object) -> IPosPrinterJob: ...
    def execute_async(self) -> winsdk.windows.foundation.IAsyncOperation[winsdk.system.Boolean]: ...
    def print(self, data: str) -> None: ...
    @typing.overload
    def print_line(self) -> None: ...
    @typing.overload
    def print_line(self, data: str) -> None: ...

class IReceiptOrSlipJob(winsdk.system.Object):
    @staticmethod
    def _from(obj: winsdk.system.Object) -> IReceiptOrSlipJob: ...
    def draw_ruled_line(self, position_list: str, line_direction: PosPrinterLineDirection, line_width: winsdk.system.UInt32, line_style: PosPrinterLineStyle, line_color: winsdk.system.UInt32) -> None: ...
    def execute_async(self) -> winsdk.windows.foundation.IAsyncOperation[winsdk.system.Boolean]: ...
    def print(self, data: str) -> None: ...
    def print_barcode(self, data: str, symbology: winsdk.system.UInt32, height: winsdk.system.UInt32, width: winsdk.system.UInt32, text_position: PosPrinterBarcodeTextPosition, alignment: PosPrinterAlignment) -> None: ...
    def print_barcode_custom_align(self, data: str, symbology: winsdk.system.UInt32, height: winsdk.system.UInt32, width: winsdk.system.UInt32, text_position: PosPrinterBarcodeTextPosition, alignment_distance: winsdk.system.UInt32) -> None: ...
    @typing.overload
    def print_bitmap(self, bitmap: typing.Optional[winsdk.windows.graphics.imaging.BitmapFrame], alignment: PosPrinterAlignment) -> None: ...
    @typing.overload
    def print_bitmap(self, bitmap: typing.Optional[winsdk.windows.graphics.imaging.BitmapFrame], alignment: PosPrinterAlignment, width: winsdk.system.UInt32) -> None: ...
    @typing.overload
    def print_custom_aligned_bitmap(self, bitmap: typing.Optional[winsdk.windows.graphics.imaging.BitmapFrame], alignment_distance: winsdk.system.UInt32) -> None: ...
    @typing.overload
    def print_custom_aligned_bitmap(self, bitmap: typing.Optional[winsdk.windows.graphics.imaging.BitmapFrame], alignment_distance: winsdk.system.UInt32, width: winsdk.system.UInt32) -> None: ...
    @typing.overload
    def print_line(self) -> None: ...
    @typing.overload
    def print_line(self, data: str) -> None: ...
    def print_saved_bitmap(self, bitmap_number: winsdk.system.UInt32) -> None: ...
    def set_barcode_rotation(self, value: PosPrinterRotation) -> None: ...
    @typing.overload
    def set_bitmap(self, bitmap_number: winsdk.system.UInt32, bitmap: typing.Optional[winsdk.windows.graphics.imaging.BitmapFrame], alignment: PosPrinterAlignment) -> None: ...
    @typing.overload
    def set_bitmap(self, bitmap_number: winsdk.system.UInt32, bitmap: typing.Optional[winsdk.windows.graphics.imaging.BitmapFrame], alignment: PosPrinterAlignment, width: winsdk.system.UInt32) -> None: ...
    @typing.overload
    def set_custom_aligned_bitmap(self, bitmap_number: winsdk.system.UInt32, bitmap: typing.Optional[winsdk.windows.graphics.imaging.BitmapFrame], alignment_distance: winsdk.system.UInt32) -> None: ...
    @typing.overload
    def set_custom_aligned_bitmap(self, bitmap_number: winsdk.system.UInt32, bitmap: typing.Optional[winsdk.windows.graphics.imaging.BitmapFrame], alignment_distance: winsdk.system.UInt32, width: winsdk.system.UInt32) -> None: ...
    def set_print_area(self, value: winsdk.windows.foundation.Rect) -> None: ...
    def set_print_rotation(self, value: PosPrinterRotation, include_bitmaps: winsdk.system.Boolean) -> None: ...

