# WARNING: Please don't edit this file. It was generated by Python/WinRT v1.0.0-beta.9

import enum
import datetime
import sys
import types
import typing

import winsdk.system
import winsdk.windows.foundation
import winsdk.windows.foundation.collections

class AltitudeReferenceSystem(enum.IntEnum):
    UNSPECIFIED = 0
    TERRAIN = 1
    ELLIPSOID = 2
    GEOID = 3
    SURFACE = 4

class GeolocationAccessStatus(enum.IntEnum):
    UNSPECIFIED = 0
    ALLOWED = 1
    DENIED = 2

class GeoshapeType(enum.IntEnum):
    GEOPOINT = 0
    GEOCIRCLE = 1
    GEOPATH = 2
    GEOBOUNDING_BOX = 3

class PositionAccuracy(enum.IntEnum):
    DEFAULT = 0
    HIGH = 1

class PositionSource(enum.IntEnum):
    CELLULAR = 0
    SATELLITE = 1
    WI_FI = 2
    IP_ADDRESS = 3
    UNKNOWN = 4
    DEFAULT = 5
    OBFUSCATED = 6

class PositionStatus(enum.IntEnum):
    READY = 0
    INITIALIZING = 1
    NO_DATA = 2
    DISABLED = 3
    NOT_INITIALIZED = 4
    NOT_AVAILABLE = 5

class VisitMonitoringScope(enum.IntEnum):
    VENUE = 0
    CITY = 1

class VisitStateChange(enum.IntEnum):
    TRACKING_LOST = 0
    ARRIVED = 1
    DEPARTED = 2
    OTHER_MOVEMENT = 3

Self = typing.TypeVar('Self')

class BasicGeoposition:
    latitude: winsdk.system.Double
    longitude: winsdk.system.Double
    altitude: winsdk.system.Double
    def __new__(cls: typing.Type[BasicGeoposition], latitude: winsdk.system.Double, longitude: winsdk.system.Double, altitude: winsdk.system.Double) -> BasicGeoposition: ...

class CivicAddress(winsdk.system.Object):
    city: str
    country: str
    postal_code: str
    state: str
    timestamp: datetime.datetime
    @staticmethod
    def _from(obj: winsdk.system.Object) -> CivicAddress: ...

class GeoboundingBox(winsdk.system.Object):
    center: BasicGeoposition
    max_altitude: winsdk.system.Double
    min_altitude: winsdk.system.Double
    northwest_corner: BasicGeoposition
    southeast_corner: BasicGeoposition
    altitude_reference_system: AltitudeReferenceSystem
    geoshape_type: GeoshapeType
    spatial_reference_id: winsdk.system.UInt32
    @staticmethod
    def _from(obj: winsdk.system.Object) -> GeoboundingBox: ...
    @typing.overload
    def __new__(cls: typing.Type[GeoboundingBox], northwest_corner: BasicGeoposition, southeast_corner: BasicGeoposition) -> GeoboundingBox:...
    @typing.overload
    def __new__(cls: typing.Type[GeoboundingBox], northwest_corner: BasicGeoposition, southeast_corner: BasicGeoposition, altitude_reference_system: AltitudeReferenceSystem) -> GeoboundingBox:...
    @typing.overload
    def __new__(cls: typing.Type[GeoboundingBox], northwest_corner: BasicGeoposition, southeast_corner: BasicGeoposition, altitude_reference_system: AltitudeReferenceSystem, spatial_reference_id: winsdk.system.UInt32) -> GeoboundingBox:...
    @typing.overload
    @staticmethod
    def try_compute(positions: typing.Iterable[BasicGeoposition]) -> typing.Optional[GeoboundingBox]: ...
    @typing.overload
    @staticmethod
    def try_compute(positions: typing.Iterable[BasicGeoposition], altitude_ref_system: AltitudeReferenceSystem) -> typing.Optional[GeoboundingBox]: ...
    @typing.overload
    @staticmethod
    def try_compute(positions: typing.Iterable[BasicGeoposition], altitude_ref_system: AltitudeReferenceSystem, spatial_reference_id: winsdk.system.UInt32) -> typing.Optional[GeoboundingBox]: ...

class Geocircle(winsdk.system.Object):
    center: BasicGeoposition
    radius: winsdk.system.Double
    altitude_reference_system: AltitudeReferenceSystem
    geoshape_type: GeoshapeType
    spatial_reference_id: winsdk.system.UInt32
    @staticmethod
    def _from(obj: winsdk.system.Object) -> Geocircle: ...
    @typing.overload
    def __new__(cls: typing.Type[Geocircle], position: BasicGeoposition, radius: winsdk.system.Double) -> Geocircle:...
    @typing.overload
    def __new__(cls: typing.Type[Geocircle], position: BasicGeoposition, radius: winsdk.system.Double, altitude_reference_system: AltitudeReferenceSystem) -> Geocircle:...
    @typing.overload
    def __new__(cls: typing.Type[Geocircle], position: BasicGeoposition, radius: winsdk.system.Double, altitude_reference_system: AltitudeReferenceSystem, spatial_reference_id: winsdk.system.UInt32) -> Geocircle:...

class Geocoordinate(winsdk.system.Object):
    accuracy: winsdk.system.Double
    altitude: typing.Optional[typing.Optional[winsdk.system.Double]]
    altitude_accuracy: typing.Optional[typing.Optional[winsdk.system.Double]]
    heading: typing.Optional[typing.Optional[winsdk.system.Double]]
    latitude: winsdk.system.Double
    longitude: winsdk.system.Double
    speed: typing.Optional[typing.Optional[winsdk.system.Double]]
    timestamp: datetime.datetime
    point: typing.Optional[Geopoint]
    position_source: PositionSource
    satellite_data: typing.Optional[GeocoordinateSatelliteData]
    position_source_timestamp: typing.Optional[typing.Optional[datetime.datetime]]
    is_remote_source: winsdk.system.Boolean
    @staticmethod
    def _from(obj: winsdk.system.Object) -> Geocoordinate: ...

class GeocoordinateSatelliteData(winsdk.system.Object):
    horizontal_dilution_of_precision: typing.Optional[typing.Optional[winsdk.system.Double]]
    position_dilution_of_precision: typing.Optional[typing.Optional[winsdk.system.Double]]
    vertical_dilution_of_precision: typing.Optional[typing.Optional[winsdk.system.Double]]
    geometric_dilution_of_precision: typing.Optional[typing.Optional[winsdk.system.Double]]
    time_dilution_of_precision: typing.Optional[typing.Optional[winsdk.system.Double]]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> GeocoordinateSatelliteData: ...

class Geolocator(winsdk.system.Object):
    report_interval: winsdk.system.UInt32
    movement_threshold: winsdk.system.Double
    desired_accuracy: PositionAccuracy
    location_status: PositionStatus
    desired_accuracy_in_meters: typing.Optional[typing.Optional[winsdk.system.UInt32]]
    default_geoposition: typing.ClassVar[typing.Optional[typing.Optional[BasicGeoposition]]]
    is_default_geoposition_recommended: typing.ClassVar[winsdk.system.Boolean]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> Geolocator: ...
    def __new__(cls: typing.Type[Geolocator]) -> Geolocator:...
    def allow_fallback_to_consentless_positions(self) -> None: ...
    @typing.overload
    def get_geoposition_async(self) -> winsdk.windows.foundation.IAsyncOperation[Geoposition]: ...
    @typing.overload
    def get_geoposition_async(self, maximum_age: datetime.timedelta, timeout: datetime.timedelta) -> winsdk.windows.foundation.IAsyncOperation[Geoposition]: ...
    @typing.overload
    @staticmethod
    def get_geoposition_history_async(start_time: datetime.datetime) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.foundation.collections.IVectorView[Geoposition]]: ...
    @typing.overload
    @staticmethod
    def get_geoposition_history_async(start_time: datetime.datetime, duration: datetime.timedelta) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.foundation.collections.IVectorView[Geoposition]]: ...
    @staticmethod
    def request_access_async() -> winsdk.windows.foundation.IAsyncOperation[GeolocationAccessStatus]: ...
    def add_position_changed(self, handler: winsdk.windows.foundation.TypedEventHandler[Geolocator, PositionChangedEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_position_changed(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...
    def add_status_changed(self, handler: winsdk.windows.foundation.TypedEventHandler[Geolocator, StatusChangedEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_status_changed(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...

class Geopath(winsdk.system.Object):
    positions: typing.Optional[winsdk.windows.foundation.collections.IVectorView[BasicGeoposition]]
    altitude_reference_system: AltitudeReferenceSystem
    geoshape_type: GeoshapeType
    spatial_reference_id: winsdk.system.UInt32
    @staticmethod
    def _from(obj: winsdk.system.Object) -> Geopath: ...
    @typing.overload
    def __new__(cls: typing.Type[Geopath], positions: typing.Iterable[BasicGeoposition]) -> Geopath:...
    @typing.overload
    def __new__(cls: typing.Type[Geopath], positions: typing.Iterable[BasicGeoposition], altitude_reference_system: AltitudeReferenceSystem) -> Geopath:...
    @typing.overload
    def __new__(cls: typing.Type[Geopath], positions: typing.Iterable[BasicGeoposition], altitude_reference_system: AltitudeReferenceSystem, spatial_reference_id: winsdk.system.UInt32) -> Geopath:...

class Geopoint(winsdk.system.Object):
    position: BasicGeoposition
    altitude_reference_system: AltitudeReferenceSystem
    geoshape_type: GeoshapeType
    spatial_reference_id: winsdk.system.UInt32
    @staticmethod
    def _from(obj: winsdk.system.Object) -> Geopoint: ...
    @typing.overload
    def __new__(cls: typing.Type[Geopoint], position: BasicGeoposition) -> Geopoint:...
    @typing.overload
    def __new__(cls: typing.Type[Geopoint], position: BasicGeoposition, altitude_reference_system: AltitudeReferenceSystem) -> Geopoint:...
    @typing.overload
    def __new__(cls: typing.Type[Geopoint], position: BasicGeoposition, altitude_reference_system: AltitudeReferenceSystem, spatial_reference_id: winsdk.system.UInt32) -> Geopoint:...

class Geoposition(winsdk.system.Object):
    civic_address: typing.Optional[CivicAddress]
    coordinate: typing.Optional[Geocoordinate]
    venue_data: typing.Optional[VenueData]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> Geoposition: ...

class Geovisit(winsdk.system.Object):
    position: typing.Optional[Geoposition]
    state_change: VisitStateChange
    timestamp: datetime.datetime
    @staticmethod
    def _from(obj: winsdk.system.Object) -> Geovisit: ...

class GeovisitMonitor(winsdk.system.Object):
    monitoring_scope: VisitMonitoringScope
    @staticmethod
    def _from(obj: winsdk.system.Object) -> GeovisitMonitor: ...
    def __new__(cls: typing.Type[GeovisitMonitor]) -> GeovisitMonitor:...
    @staticmethod
    def get_last_report_async() -> winsdk.windows.foundation.IAsyncOperation[Geovisit]: ...
    def start(self, value: VisitMonitoringScope) -> None: ...
    def stop(self) -> None: ...
    def add_visit_state_changed(self, handler: winsdk.windows.foundation.TypedEventHandler[GeovisitMonitor, GeovisitStateChangedEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_visit_state_changed(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...

class GeovisitStateChangedEventArgs(winsdk.system.Object):
    visit: typing.Optional[Geovisit]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> GeovisitStateChangedEventArgs: ...

class GeovisitTriggerDetails(winsdk.system.Object):
    @staticmethod
    def _from(obj: winsdk.system.Object) -> GeovisitTriggerDetails: ...
    def read_reports(self) -> typing.Optional[winsdk.windows.foundation.collections.IVectorView[Geovisit]]: ...

class PositionChangedEventArgs(winsdk.system.Object):
    position: typing.Optional[Geoposition]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> PositionChangedEventArgs: ...

class StatusChangedEventArgs(winsdk.system.Object):
    status: PositionStatus
    @staticmethod
    def _from(obj: winsdk.system.Object) -> StatusChangedEventArgs: ...

class VenueData(winsdk.system.Object):
    id: str
    level: str
    @staticmethod
    def _from(obj: winsdk.system.Object) -> VenueData: ...

class IGeoshape(winsdk.system.Object):
    altitude_reference_system: AltitudeReferenceSystem
    geoshape_type: GeoshapeType
    spatial_reference_id: winsdk.system.UInt32
    @staticmethod
    def _from(obj: winsdk.system.Object) -> IGeoshape: ...

