# This file was automatically generated by SWIG (https://www.swig.org).
# Version 4.1.1
#
# Do not make changes to this file unless you know what you are doing - modify
# the SWIG interface file instead.

"""Distribution special function."""

from sys import version_info as _swig_python_version_info
# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _DistFunc
else:
    import _DistFunc

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "this":
            set(self, name, value)
        elif name == "thisown":
            self.this.own(value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


class SwigPyIterator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _DistFunc.delete_SwigPyIterator

    def value(self):
        return _DistFunc.SwigPyIterator_value(self)

    def incr(self, n=1):
        return _DistFunc.SwigPyIterator_incr(self, n)

    def decr(self, n=1):
        return _DistFunc.SwigPyIterator_decr(self, n)

    def distance(self, x):
        return _DistFunc.SwigPyIterator_distance(self, x)

    def equal(self, x):
        return _DistFunc.SwigPyIterator_equal(self, x)

    def copy(self):
        return _DistFunc.SwigPyIterator_copy(self)

    def next(self):
        return _DistFunc.SwigPyIterator_next(self)

    def __next__(self):
        return _DistFunc.SwigPyIterator___next__(self)

    def previous(self):
        return _DistFunc.SwigPyIterator_previous(self)

    def advance(self, n):
        return _DistFunc.SwigPyIterator_advance(self, n)

    def __eq__(self, x):
        return _DistFunc.SwigPyIterator___eq__(self, x)

    def __ne__(self, x):
        return _DistFunc.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n):
        return _DistFunc.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n):
        return _DistFunc.SwigPyIterator___isub__(self, n)

    def __add__(self, n):
        return _DistFunc.SwigPyIterator___add__(self, n)

    def __sub__(self, *args):
        return _DistFunc.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self

# Register SwigPyIterator in _DistFunc:
_DistFunc.SwigPyIterator_swigregister(SwigPyIterator)
import openturns.base
import openturns.common
import openturns.typ
import openturns.statistics
import openturns.graph
import openturns.func
import openturns.geom
import openturns.iterative_statistics
import openturns.diff
import openturns.optim
import openturns.experiment
import openturns.solver
import openturns.algo

def pBeta(p1, p2, x, tail=False):
    return _DistFunc.pBeta(p1, p2, x, tail)

def qBeta(p1, p2, p, tail=False):
    return _DistFunc.qBeta(p1, p2, p, tail)

def rBeta(*args):
    return _DistFunc.rBeta(*args)

def logdBinomial(n, p, k):
    r"""
    Logarithm of the probability function of a binomial distribution.

    Parameters
    ----------
    n : int, :math:`n>0`
        The number of trials
    p : float, :math:`0\leq p\leq 1`
        The success probability of each trial
    k : int
        The number of success.

    Returns
    -------
    logp : float
        The natural logarithm of the probability to get :math:`k` successes.

    Notes
    -----
    This method implements Loader's algorithm, the *fast* and *accurate* method
    described in [loader2000]_, with the further improvements mentioned
    in [dimitriadis2016]_.

    Examples
    --------
    >>> import openturns as ot
    >>> p = ot.DistFunc.logdBinomial(5, 0.2, 2)
    """
    return _DistFunc.logdBinomial(n, p, k)

def dBinomial(n, p, k):
    r"""
    Probability function of a binomial distribution.

    Parameters
    ----------
    n : int, :math:`n>0`
        The number of trials
    p : float, :math:`0\leq p\leq 1`
        The success probability of each trial
    k : int
        The number of success.

    Returns
    -------
    probability : float
        The probability to get :math:`k` successes.

    Notes
    -----
    This method implements Loader's algorithm, the *fast* and *accurate* method
    described in [loader2000]_, with the further improvements mentioned
    in [dimitriadis2016]_.

    Examples
    --------
    >>> import openturns as ot
    >>> p = ot.DistFunc.dBinomial(5, 0.2, 2)
    """
    return _DistFunc.dBinomial(n, p, k)

def rBinomial(*args):
    r"""
    Realization of a binomial distribution.

    Parameters
    ----------
    n : int, :math:`n>0`
        The number of trials
    p : float, :math:`0\leq p\leq 1`
        The success probability of each trial
    size : int
        The number of realizations to generate.

    Returns
    -------
    realizations : int or :class:`~openturns.Indices`
        The realizations of the discrete disctribution.

    Notes
    -----
    This method implements the rejection algorithm described in [hormann1993]_.

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> r = ot.DistFunc.rBinomial(5, 0.3)
    >>> r = ot.DistFunc.rBinomial(5, 0.3, 10)
    """
    return _DistFunc.rBinomial(*args)

def rDiscrete(*args):
    r"""
    Realization of a bounded integral discrete distribution.

    Parameters
    ----------
    probabilities : sequence of float
        The probabilities of the discrete distribution :math:`p_k=\Prob{X=k}`,
        where :math:`p_k\in[0,1]` and :math:`\sum_{k=1}^n p_k=1`.
    size : int
        The number of realizations to generate.

    Returns
    -------
    realizations : int or :class:`~openturns.Indices`
        The realizations of the discrete disctribution.

    Notes
    -----
    This method implements the *alias* method as described in [devroye1986]_,
    Chapter 3. It has an optimal space complexity of :math:`\cO(n)` and runtime CPU
    complexity of :math:`\cO(1)`.

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> r = ot.DistFunc.rDiscrete([0.2, 0.3, 0.5])
    >>> r = ot.DistFunc.rDiscrete([0.2, 0.3, 0.5], 10)
    """
    return _DistFunc.rDiscrete(*args)

def pGamma(k, x, tail=False):
    return _DistFunc.pGamma(k, x, tail)

def qGamma(k, p, tail=False):
    return _DistFunc.qGamma(k, p, tail)

def rGamma(*args):
    return _DistFunc.rGamma(*args)

def dHypergeometric(n, k, m, x):
    r"""
    The probability function of an hypergeometric distribution.

    Parameters
    ----------
    n : int, :math:`n\geq 0`
        The population size
    k : int, :math:`0\leq k\leq n`
        The number of candidates in the population
    m : int, :math:`0\leq m\leq n`
        The number of individuals in a draw
    x : int, :math:`x\geq 0`
        The number of candidates in a draw

    Returns
    -------
    p : float
        The probability to get :math:`x` candidates in a draw.

    Notes
    -----
    This method is based on an algorithm similar to Loader's algorithm, the *fast*
    and *accurate* method described in [loader2000]_, with the further improvements
    mentioned in [dimitriadis2016]_.

    Examples
    --------
    >>> import openturns as ot
    >>> p = ot.DistFunc.dHypergeometric(10, 4, 7, 2)
    """
    return _DistFunc.dHypergeometric(n, k, m, x)

def logdHypergeometric(n, k, m, x):
    r"""
    Logarithm of the probability function of an hypergeometric distribution.

    Parameters
    ----------
    n : int, :math:`n\geq 0`
        The population size
    k : int, :math:`0\leq k\leq n`
        The number of candidates in the population
    m : int, :math:`0\leq m\leq n`
        The number of individuals in a draw
    x : int, :math:`x\geq 0`
        The number of candidates in a draw

    Returns
    -------
    logp : float
        The natural logarithm of the probability to get :math:`x` candidates in a draw.

    Notes
    -----
    This method is based on an algorithm similar to Loader's algorithm, the *fast*
    and *accurate* method described in [loader2000]_, with the further improvements
    mentioned in [dimitriadis2016]_.

    Examples
    --------
    >>> import openturns as ot
    >>> p = ot.DistFunc.logdHypergeometric(10, 4, 7, 2)
    """
    return _DistFunc.logdHypergeometric(n, k, m, x)

def pHypergeometric(n, k, m, x, tail=False):
    r"""
    The cumulative probability function of an hypergeometric distribution.

    Parameters
    ----------
    n : int, :math:`n\geq 0`
        The population size
    k : int, :math:`0\leq k\leq n`
        The number of candidates in the population
    m : int, :math:`0\leq m\leq n`
        The number of individuals in a draw
    x : int, :math:`x\geq 0`
        The number of candidates in a draw
    tail : bool
        Flag to tell if it is the CDF or its complement which is evaluated

    Returns
    -------
    p : float
        The probability to get at most :math:`x` candidates in a draw.

    Notes
    -----
    This method is based on a summation of the probability function toward the upper
    bound or the lower bound of the range depending on the position of :math:`x` wrt
    the mode :math:`\left\lfloor\dfrac{(k+1)(m+1)}{n+2}\right\rfloor` of the
    distribution, then take the complement if needed.

    Examples
    --------
    >>> import openturns as ot
    >>> p = ot.DistFunc.pHypergeometric(10, 4, 7, 2)
    >>> p = ot.DistFunc.pHypergeometric(10, 4, 7, 2, True)
    """
    return _DistFunc.pHypergeometric(n, k, m, x, tail)

def rHypergeometric(*args):
    r"""
    Realization of an hypergeometric distribution.

    Parameters
    ----------
    n : int, :math:`n\geq 0`
        The population size
    k : int, :math:`0\leq k\leq n`
        The number of candidates in the population
    m : int, :math:`0\leq m\leq n`
        The number of individuals in a draw
    size : int
        The number of realizations to generate.

    Returns
    -------
    realizations : int or :class:`~openturns.Indices`
        The realizations of the discrete disctribution.

    Notes
    -----
    This method is based on the alias method.

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> r = ot.DistFunc.rHypergeometric(10, 4, 7)
    >>> r = ot.DistFunc.rHypergeometric(10, 4, 7, 10)
    """
    return _DistFunc.rHypergeometric(*args)

def pKolmogorov(n, x, tail=False):
    return _DistFunc.pKolmogorov(n, x, tail)

def dNonCentralChiSquare(*args):
    r"""
    Probability function of a NonCentralChiSquare distribution.

    Parameters
    ----------
    nu : float
    lambda : float
    x : float
    precision : float, optional
    maximum_iteration : int, optional

    Returns
    -------
    p : float
    """
    return _DistFunc.dNonCentralChiSquare(*args)

def pNonCentralChiSquare(*args):
    return _DistFunc.pNonCentralChiSquare(*args)

def rNonCentralChiSquare(*args):
    return _DistFunc.rNonCentralChiSquare(*args)

def dNonCentralStudent(nu, delta, x):
    r"""
    Probability function of a NonCentralStudent distribution.

    Parameters
    ----------
    nu : float
    delta : float
    x : float

    Returns
    -------
    p : float
    """
    return _DistFunc.dNonCentralStudent(nu, delta, x)

def dNonCentralStudentAlt0(*args):
    return _DistFunc.dNonCentralStudentAlt0(*args)

def pNonCentralStudent(nu, delta, x, tail=False):
    return _DistFunc.pNonCentralStudent(nu, delta, x, tail)

def rNonCentralStudent(*args):
    return _DistFunc.rNonCentralStudent(*args)

def pNormal(*args):
    r"""
    CDF of an unit-variance centered Normal distribution.

    Parameters
    ----------
    x : float
        Location
    tail : bool, default=False
        Tail flag

    Returns
    -------
    cdf : float

    Examples
    --------
    >>> import openturns as ot
    >>> cdf = ot.DistFunc.pNormal(0.9)
    """
    return _DistFunc.pNormal(*args)

def pNormal2D(x1, x2, rho, tail=False):
    return _DistFunc.pNormal2D(x1, x2, rho, tail)

def pNormal3D(x1, x2, x3, rho12, rho13, rho23, tail=False):
    return _DistFunc.pNormal3D(x1, x2, x3, rho12, rho13, rho23, tail)

def logpNormal(x, tail=False):
    r"""
    log-CDF of an unit-variance centered Normal distribution.

    Parameters
    ----------
    x : float
        Location
    tail : bool, default=False
        Tail flag

    Returns
    -------
    logCdf : float

    Examples
    --------
    >>> import openturns as ot
    >>> logCdf = ot.DistFunc.logpNormal(0.9)
    """
    return _DistFunc.logpNormal(x, tail)

def qNormal(*args):
    r"""
    Quantile of an unit-variance centered Normal distribution.

    Parameters
    ----------
    prob : float

    Returns
    -------
    q : float

    Examples
    --------
    >>> import openturns as ot
    >>> q = ot.DistFunc.qNormal(0.95)
    """
    return _DistFunc.qNormal(*args)

def rNormal(*args):
    r"""
    Realization of an unit-variance centered Normal distribution.

    Returns
    -------
    realization : float

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> r = ot.DistFunc.rNormal()
    """
    return _DistFunc.rNormal(*args)

def dNormal(*args):
    r"""
    PDF of an unit-variance centered Normal distribution.

    Parameters
    ----------
    x : float or sequence of floats
        Location

    Returns
    -------
    pdf : float or sequence of floats

    Examples
    --------
    >>> import openturns as ot
    >>> pdf = ot.DistFunc.dNormal(3.0)
    >>> pdf = ot.DistFunc.dNormal([-3, -2, 2, 3])
    """
    return _DistFunc.dNormal(*args)

def logdNormal(x):
    r"""
    log-PDF of an unit-variance centered Normal distribution.

    Parameters
    ----------
    x : float
        Location

    Returns
    -------
    logPdf : float

    Examples
    --------
    >>> import openturns as ot
    >>> pdf = ot.DistFunc.logdNormal(3.0)
    """
    return _DistFunc.logdNormal(x)

def logdPoisson(_lambda, k):
    r"""
    Logarithm of the probability function of a Poisson distribution.

    Parameters
    ----------
    lambda: float, :math:`\lambda\geq 0`
        The intensity of the Poisson distribution
    k : int
        The number of success.

    Returns
    -------
    logp : float
        The natural logarithm of the probability to get :math:`k` successes.

    Notes
    -----
    This method implements Loader's algorithm, the *fast* and *accurate* method
    described in [loader2000]_, with the further improvements mentioned
    in [dimitriadis2016]_.

    Examples
    --------
    >>> import openturns as ot
    >>> p = ot.DistFunc.logdPoisson(5.0, 2)
    """
    return _DistFunc.logdPoisson(_lambda, k)

def dPoisson(_lambda, k):
    r"""
    Probability function of a Poisson distribution.

    Parameters
    ----------
    lambda: float, :math:`\lambda\geq 0`
        The intensity of the Poisson distribution
    k : int
        The number of success.

    Returns
    -------
    p : float
        The probability to get :math:`k` successes.

    Notes
    -----
    This method implements Loader's algorithm, the *fast* and *accurate* method
    described in [loader2000]_, with the further improvements mentioned
    in [dimitriadis2016]_.

    Examples
    --------
    >>> import openturns as ot
    >>> p = ot.DistFunc.dPoisson(5.0, 2)
    """
    return _DistFunc.dPoisson(_lambda, k)

def qPoisson(_lambda, p, tail=False):
    return _DistFunc.qPoisson(_lambda, p, tail)

def rPoisson(*args):
    r"""
    Realization of a Poisson distribution.

    Parameters
    ----------
    lambda: float, :math:`\lambda\geq 0`
        The intensity of the Poisson distribution
    size : int
        The number of realizations to generate.

    Returns
    -------
    realizations : int or :class:`~openturns.Indices`
        The realizations of the discrete disctribution.

    Notes
    -----
    For the small values of :math:`\lambda`, we use the method of inversion by
    sequential search described in [devroye1986]_ and with the important errata in
    [devroye1986b]_. For the large values of :math:`\lambda`, we use the ratio of
    uniform method described in [stadlober1990]_.

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> r = ot.DistFunc.rPoisson(5.0)
    >>> r = ot.DistFunc.rPoisson(5.0, 10)
    """
    return _DistFunc.rPoisson(*args)

def pPearsonCorrelation(size, rho, tail=False):
    r"""
    Asymptotic probability function for the Pearson :math:`\rho` correlation.

    Parameters
    ----------
    n : int
        The size of the population

    rho : float :math:`-1<rho<1`
        The Pearson correlation coefficient

    tail : bool
        Tells if we consider to be in the critical region (tTrue)
        Default value is False

    Returns
    -------
    pvalue : float
        The probability to be in the region of interest

    Notes
    -----
    This method allows one to compute the *asymptotic* distribution of the
    `Pearson` correlation coefficient issued from two univariate samples
    of size `n`. Basically, we want to measure how coefficient is significatly
    different from `0`. If `tail` is True, the issued value measures probability
    to be in the critical region.

    Examples
    --------
    >>> import openturns as ot
    >>> pval = ot.DistFunc.pPearsonCorrelation(100, 0.3, True)
    """
    return _DistFunc.pPearsonCorrelation(size, rho, tail)

def pSpearmanCorrelation(size, rho, tail=False, ties=False):
    return _DistFunc.pSpearmanCorrelation(size, rho, tail, ties)

def pStudent(*args):
    return _DistFunc.pStudent(*args)

def qStudent(*args):
    return _DistFunc.qStudent(*args)

def rStudent(*args):
    return _DistFunc.rStudent(*args)

def rUniformSegment(*args):
    r"""
    Realization of a uniform distribution over a segment.

    Parameters
    ----------
    a : sequence of float, in :math:`\Rset^n`
        The first vertex of the segment.
    b : sequence of float, in :math:`\Rset^n`
        The second vertex of the segment.
    size : int
        The number of realizations to generate.

    Notes
    -----
    This method samples the barycentric coordinates, allowing to work in any dimension.

    Returns
    -------
    realizations : :class:`~openturns.Point` or :class:`~openturns.Sample`
        The realizations of the uniform disctribution.

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> a = [1, 5]
    >>> b = [2, 3]
    >>> r = ot.DistFunc.rUniformSegment(a, b)
    >>> r = ot.DistFunc.rUniformSegment(a, b, 10)
    """
    return _DistFunc.rUniformSegment(*args)

def rUniformTriangle(*args):
    r"""
    Realization of a uniform distribution over a triangle.

    Parameters
    ----------
    a : sequence of float, in :math:`\Rset^n`
        The first vertex of the triangle.
    b : sequence of float, in :math:`\Rset^n`
        The second vertex of the triangle.
    c : sequence of float, in :math:`\Rset^n`
        The third vertex of the triangle.
    size : int
        The number of realizations to generate.

    Notes
    -----
    This method samples the barycentric coordinates, allowing to work in any dimension.

    Returns
    -------
    realizations : :class:`~openturns.Point` or :class:`~openturns.Sample`
        The realizations of the uniform disctribution.

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> a = [1, 5]
    >>> b = [2, 3]
    >>> c = [-1, 2]
    >>> r = ot.DistFunc.rUniformTriangle(a, b, c)
    >>> r = ot.DistFunc.rUniformTriangle(a, b, c, 10)
    """
    return _DistFunc.rUniformTriangle(*args)

def rUniformTetrahedron(*args):
    r"""
    Realization of a uniform distribution over a tetrahedron.

    Parameters
    ----------
    a : sequence of float, in :math:`\Rset^n`
        The first vertex of the triangle.
    b : sequence of float, in :math:`\Rset^n`
        The second vertex of the triangle.
    c : sequence of float, in :math:`\Rset^n`
        The third vertex of the triangle.
    d : sequence of float, in :math:`\Rset^n`
        The fourth vertex of the triangle.
    size : int
        The number of realizations to generate.

    Notes
    -----
    This method samples the barycentric coordinates, allowing to work in any dimension.

    Returns
    -------
    realizations : :class:`~openturns.Point` or :class:`~openturns.Sample`
        The realizations of the uniform disctribution.

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> a = [1, 5, 0]
    >>> b = [2, 3, -1]
    >>> c = [-1, 2, 2]
    >>> d = [1, 2, 1]
    >>> r = ot.DistFunc.rUniformTetrahedron(a, b, c, d)
    >>> r = ot.DistFunc.rUniformTetrahedron(a, b, c, d, 10)
    """
    return _DistFunc.rUniformTetrahedron(*args)

def rUniformSimplex(*args):
    r"""
    Realization of a uniform distribution over a simplex.

    Parameters
    ----------
    vertices : 2-d sequence of float, a list of points in :math:`\Rset^n`
        The vertices of the simplex.
    size : int
        The number of realizations to generate.

    Notes
    -----
    This method samples the barycentric coordinates, allowing to work in any dimension.

    Returns
    -------
    realizations : :class:`~openturns.Point` or :class:`~openturns.Sample`
        The realizations of the uniform disctribution.

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> vertices = [[0, 1, 0, 2, 0, 0],
    ...             [1, 0, 2, 3, 1, 0],
    ...             [3, 4, 0, 0, 1, 2],
    ...             [2, 0, 2, 0, 1, 1],
    ...             [1, 3, 1, 4, 1, 5]]
    >>> r = ot.DistFunc.rUniformSimplex(vertices)
    >>> r = ot.DistFunc.rUniformSimplex(vertices, 10)
    """
    return _DistFunc.rUniformSimplex(*args)

def eZ1(n):
    r"""
    Expectation of the min of n independent standard normal random variables.

    Parameters
    ----------
    n : int

    Returns
    -------
    mu : float
    """
    return _DistFunc.eZ1(n)

def kFactorPooled(n, m, p, alpha):
    r"""
    Exact margin factor for bilateral covering interval of pooled Normal populations.

    Parameters
    ----------
    n : int
        The size of the population

    m : int
        The size of the pool

    p : float :math:`0<p<1`
        The probability level of the covering interval

    alpha : float :math:`0<\alpha<1`
        The confidence level of the covering interval

    Returns
    -------
    k : float
        The margin factor

    Notes
    -----
    This method allows one to compute the *exact* margin factor :math:`k` of a
    pool of :math:`m` Normal populations of size :math:`n` with unknown
    means :math:`\mu_i` and unknown common variance :math:`\sigma^2`.
    This implements the standard NF ISO 16269-6. 
    Let :math:`m_i=\dfrac{1}{n}\sum_{j=1}^nX_{ij}` be the empirical mean
    of the ith population :math:`(X_{i1},\dots,X_{in})` and
    :math:`\sigma^2_{mn}=\dfrac{}{}\sum_{i=1}^m\sum_{j=1}^n(X_{ij}-m_i)^2`
    the empirical *pooled* variance. The covering factor :math:`k` is such
    that the intervals :math:`[m_i-k\sigma_{mn},m_i+k\sigma_{mn}]` satisfy:

    .. math::
        \Prob{\Prob{X_i\in[m_i-k\sigma_{mn},m_i+k\sigma_{mn}]}\geq p}=\alpha

    for :math:`i\in\{1,\dots,m\}`. It reduces to find :math:`k` such that:

    .. math::
        \int_{\Rset}F(x,k;\nu_{m,n},p)\phi_{0,1/\sqrt{n}}(x)\,\di x = \alpha

    where :math:`phi_{0,1/\sqrt{n}}` is the density function of the normal
    distribution with a mean equals to 0 and a variance equals to
    :math:`1/n`, :math:`\nu_{m,n}=m(n-1)` and :math:`F(x,k;\nu_{m,n},p)`
    the function defined by:

    .. math::
        F(x,k;\nu_{m,n},p)=\bar{F}_{\chi^2_{\nu_{m,n}}}(\nu_{m,n} R^2(x;p)/k^2)

    where :math:`\bar{F}_{\chi^2_{\nu_{m,n}}}` is the complementary distribution
    function of a chi-square distribution with :math:`\nu_{m,n}` degrees
    of freedom and :math:`R(x;p)` the solution of:

    .. math::
        \Phi(x + R) - \Phi(x - R) = p

    Examples
    --------
    >>> import openturns as ot
    >>> k = ot.DistFunc.kFactorPooled(5, 3, 0.95, 0.9)
    """
    return _DistFunc.kFactorPooled(n, m, p, alpha)

def kFactor(n, p, alpha):
    r"""
    Exact margin factor for bilateral covering interval of a Normal population.

    Parameters
    ----------
    n : int
        The size of the population

    p : float :math:`0<p<1`
        The probability level of the covering interval

    alpha : float :math:`0<\alpha<1`
        The confidence level of the covering interval

    Returns
    -------
    k : float
        The margin factor

    Notes
    -----
    This method allows one to compute the *exact* margin factor :math:`k` of a
    Normal population of size :math:`n` with unknown
    means :math:`\mu_i` and unknown common variance :math:`\sigma^2`. It
    is equivalent to the pooled version with :math:`m=1`.
    This implements the standard NF ISO 16269-6. 

    Examples
    --------
    >>> import openturns as ot
    >>> k = ot.DistFunc.kFactor(5, 0.95, 0.9)
    """
    return _DistFunc.kFactor(n, p, alpha)

def pDickeyFullerTrend(x, tail=False):
    return _DistFunc.pDickeyFullerTrend(x, tail)

def pDickeyFullerConstant(x, tail=False):
    return _DistFunc.pDickeyFullerConstant(x, tail)

def pDickeyFullerNoConstant(x, tail=False):
    return _DistFunc.pDickeyFullerNoConstant(x, tail)

def qDickeyFullerTrend(p, tail=False):
    return _DistFunc.qDickeyFullerTrend(p, tail)

def qDickeyFullerConstant(p, tail=False):
    return _DistFunc.qDickeyFullerConstant(p, tail)

def qDickeyFullerNoConstant(p, tail=False):
    return _DistFunc.qDickeyFullerNoConstant(p, tail)

cvar = _DistFunc.cvar
NumberOfBandNormalZigurrat = cvar.NumberOfBandNormalZigurrat
NormalZigguratTail = cvar.NormalZigguratTail
NormalZigguratAbscissa = cvar.NormalZigguratAbscissa
NormalZigguratRatio = cvar.NormalZigguratRatio

