%feature("docstring") OT::SubsetSampling
"Subset simulation.

Parameters
----------
event : :class:`~openturns.RandomVector`
    Event we are computing the probability.
proposalRange : float, optional
    Proposal range length
targetProbability : float, optional
    Value of :math:`P(F_i|F_{i-1})` between successive steps

Notes
-----
The goal is to estimate the following probability

.. math::

    P_f = \\int_{\\mathcal D_f} f_{\\uX}(\\ux)\\di{\\ux}\\\\
        = \\int_{\\mathbb R^{n_X}} \\mathbf{1}_{\\{g(\\ux,\\underline{d}) \\:\\leq 0\\: \\}}f_{\\uX}(\\ux)\\di{\\ux}\\\\
        = \\Prob {\\{g(\\uX,\\underline{d}) \\leq 0\\}}


The idea of the subset simulation method [au2001]_ is to replace simulating a
rare failure event in the original probability space by a sequence of
simulations of more frequent conditional events :math:`F_i`

.. math::

    F_1 \\supset F_2 \\supset \\dots \\supset F_m = F


The original probability estimate rewrites

.. math::

    P_f = P(F_m) = P(\\bigcap \\limits_{i=1}^m F_i) = P(F_1) \\prod_{i=2}^m P(F_i|F_{i-1})


And each conditional subset failure region is chosen by setting the threshold
:math:`g_i` so that :math:`P(F_i|F_{i-1})` leads to a conditional failure
probability of order :math:`0.1`

.. math::

    F_i =\\Prob {\\{g(\\uX,\\underline{d}) \\leq g_i\\}}


The conditional samples are generated by the means of Markov Chains,
using the Metropolis Hastings algorithm.

:math:`N` being the number of simulations per subset, and :math:`p_{0i}` the
conditional probability of each subset event, and :math:`\\gamma_i` the
autocorrelation between Markov chain samples.

.. math::

    \\delta^2 = \\sum_{i=1}^m \\delta^2_i = \\sum_{i=1}^m (1+\\gamma_i) \\frac{1-p_{0i}}{p_{0i}N}


The first event :math:`F_1` not being conditional, :math:`\\delta^2_1`
expresses as the classic Monte Carlo c.o.v.

See also
--------
EventSimulation"

// ---------------------------------------------------------------------------

%feature("docstring") OT::SubsetSampling::getCoefficientOfVariationPerStep
"Coefficient of variation per step accessor.

Returns
-------
coef : :class:`~openturns.Point`
    Coefficient of variation at each subset step."

// ---------------------------------------------------------------------------

%feature("docstring") OT::SubsetSampling::setConditionalProbability
"Conditional probability accessor.

Value of :math:`P(F_i|F_{i-1})` between successive steps.

Parameters
----------
prob : float
    Conditional probability value."

// ---------------------------------------------------------------------------

%feature("docstring") OT::SubsetSampling::getConditionalProbability
"Conditional probability accessor.

Value of :math:`P(F_i|F_{i-1})` between successive steps.

Returns
-------
prob : float
    Conditional probability value."

// ---------------------------------------------------------------------------

%feature("docstring") OT::SubsetSampling::setKeepEventSample
"Sample storage accessor.

Parameters
----------
keepEventsample : bool
    Whether to keep the samples that realized the event."

// ---------------------------------------------------------------------------

%feature("docstring") OT::SubsetSampling::getEventInputSample
"Input sample accessor.

Returns
-------
inputSample : :class:`~openturns.Sample`
    Input sample that realized the event."

// ---------------------------------------------------------------------------

%feature("docstring") OT::SubsetSampling::getEventOutputSample
"Output sample accessor.

Returns
-------
outputSample : :class:`~openturns.Sample`
    Output sample that realized the event."

// ---------------------------------------------------------------------------

%feature("docstring") OT::SubsetSampling::getThresholdPerStep
"Threshold accessor.

Returns
-------
threshold : :class:`~openturns.Point`
    Threshold values at each step."

// ---------------------------------------------------------------------------

%feature("docstring") OT::SubsetSampling::getGammaPerStep
"Autocorrelation accessor.

Returns
-------
prob : :class:`~openturns.Point`
    Autocorrelation values at each step."

// ---------------------------------------------------------------------------

%feature("docstring") OT::SubsetSampling::getProbabilityEstimatePerStep
"Probability estimate accessor.

Returns
-------
prob : :class:`~openturns.Point`
    Probability estimate at each step."

// ---------------------------------------------------------------------------

%feature("docstring") OT::SubsetSampling::setMinimumProbability
"Minimum probability accessor.

Allows one to stop the algorithm if the probability becomes too small.

Parameters
----------
prob_min : float, defaults to the square root of SpecFunc.MinScalar
    Minimum probability."

// ---------------------------------------------------------------------------

%feature("docstring") OT::SubsetSampling::getMinimumProbability
"Minimum probability accessor.

Returns
-------
prob_min : float
    Minimum probability."

// ---------------------------------------------------------------------------

%feature("docstring") OT::SubsetSampling::getStepsNumber
"Subset steps number accessor.

Returns
-------
n : int
    Number of subset steps, including the initial Monte Carlo sampling."

// ---------------------------------------------------------------------------

%feature("docstring") OT::SubsetSampling::setProposalRange
"Proposal range length accessor.

Parameters
----------
range : float
    Range length."

// ---------------------------------------------------------------------------

%feature("docstring") OT::SubsetSampling::getProposalRange
"Proposal range length accessor.

Returns
-------
range : float
    Range length."

// ---------------------------------------------------------------------------

%feature("docstring") OT::SubsetSampling::setBetaMin
"Hypersphere radius accessor.

Parameters
----------
beta : float
    Radius value of the exclusion hypershere when the conditional simulation
    is enabled."

// ---------------------------------------------------------------------------

%feature("docstring") OT::SubsetSampling::setISubset
"Conditonal simulation flag accessor.

Parameters
----------
isubset : bool
    Whether to enable conditional simulation for the first step of the
    simulation."

