%feature("docstring") OT::StudentFactory
"Student factory.

Available constructor:
    StudentFactory()

The parameters are estimated by a mixed method of moments and reduces MLE:

.. math::
    :nowrap:

    \\begin{align*}
      \\Hat{\\mu} = &\\Hat{\\mu}_x \\\\
      \\Hat{\\sigma} = &\\Hat{\\sigma}_x\\sqrt{\\dfrac{\\Hat{\\nu}-2}{\\Hat{\\nu}}} \\\\
      \\Hat{R}_{ij} = &\\dfrac{2}{\\pi}\\arcsin(\\tau_{ij})
    \\end{align*}

where :math:`\\mat{\\tau}` is the sample Kendall tau matrix and :math:`\\Hat{\\nu}`
maximizes the reduced likelihood associated to :class:`~openturns.Student` with
parameters :math:`(\\Hat{\\nu}, \\Hat{\\mu}, \\hat{\\sigma}(\\Hat{\\nu}), \\Hat{\\mat{R}})`.
    
See also
--------
DistributionFactory, Student"

// ---------------------------------------------------------------------

%define OT_DistributionFactory_buildAsStudent_doc
"Build the Student distribution.

**Available usages**:

    buildAsStudent(*sample*)

    buildAsStudent(*param*)

Parameters
----------
sample : 2-d sequence of float
    Sample from which the distribution parameters are estimated.
param : Collection of :class:`~openturns.PointWithDescription`
    A vector of parameters of the distribution.

Returns
-------
dist : :class:`~openturns.Student`
    The built distribution."
%enddef
%feature("docstring") OT::StudentFactory::buildAsStudent
OT_DistributionFactory_buildAsStudent_doc

