%feature("docstring") OT::Exponential
"Exponential distribution.

Parameters
----------
lambda : float, :math:`\\lambda > 0`
    Rate parameter.
gamma : float, optional
    Location parameter :math:`\\gamma`.

Notes
-----
Its probability density function is defined as:

.. math::

    f_X(x) = \\lambda \\exp\\left(- \\lambda\\,(x - \\gamma)\\right),
             \\quad x \\in [\\gamma; +\\infty[

with :math:`\\lambda > 0` and :math:`\\gamma \\in \\Rset`.

Its first moments are:

.. math::
    :nowrap:

    \\begin{eqnarray*}
        \\Expect{X} & = & \\gamma + \\frac{1}{\\lambda} \\\\
        \\Var{X} & = & \\frac{1}{\\lambda^2}
    \\end{eqnarray*}

Examples
--------
Create a distribution:

>>> import openturns as ot
>>> distribution = ot.Exponential(1.0)

Draw a sample:

>>> sample = distribution.getSample(5)"

// ---------------------------------------------------------------------

%feature("docstring") OT::Exponential::getLambda
"Accessor to the rate parameter.

Returns
-------
lambda : float
    Rate parameter."

// ---------------------------------------------------------------------

%feature("docstring") OT::Exponential::getGamma
"Accessor to the location parameter.

Returns
-------
gamma : float
    Shift parameter."

// ---------------------------------------------------------------------

%feature("docstring") OT::Exponential::setLambda
"Accessor to the rate parameter.

Parameters
----------
lambda : float, :math:`\\lambda > 0`
    Failure rate parameter."

// ---------------------------------------------------------------------

%feature("docstring") OT::Exponential::setGamma
"Accessor to the location parameter.

Parameters
----------
gamma : float, :math:`\\gamma \\in \\Rset`
    Shift parameter."
