
with Ada.Containers.Vectors;
with Ada.Unchecked_Deallocation;

with Langkit_Support.Diagnostics; use Langkit_Support.Diagnostics;
with Langkit_Support.Packrat;
with Langkit_Support.Symbols; use Langkit_Support.Symbols;
with Langkit_Support.Text;        use Langkit_Support.Text;

with Libadalang.Common;             use Libadalang.Common;
use Libadalang.Common.Precomputed_Symbols;

with Libadalang.Implementation;     use Libadalang.Implementation;
with Libadalang.Private_Converters; use Libadalang.Private_Converters;



package body Libadalang.Parsers is
   use all type Langkit_Support.Symbols.Symbol_Type;

   --  Prepare packrat instantiations: one per enum type and onefor each kind
   --  of node (including lists). Likewise for bump ptr. allocators, except
   --  we need them only for non-abstract AST nodes.
   --
   --  In the Alloc instanciations, there are unchecked conversions to wrap
   --  System.Address values from a low-level allocator. All read/writes for
   --  the pointed values are made through values of the same access types
   --  (i.e. AST node access). Thus, strict aliasing issues should not arise
   --  for these.
   --
   --  See <https://gcc.gnu.org/onlinedocs/gnat_ugn/
   --       Optimization-and-Strict-Aliasing.html>.

   pragma Warnings (Off, "is not referenced");
   pragma Warnings (Off, "possible aliasing problem for type");
      package Bare_Ada_Node_Memos is new Langkit_Support.Packrat
        (Bare_Ada_Node, Token_Index);

      package Bare_Abort_Node_Memos is new Langkit_Support.Packrat
        (Bare_Abort_Node, Token_Index);

      package Bare_Abort_Absent_Memos is new Langkit_Support.Packrat
        (Bare_Abort_Absent, Token_Index);

         
         subtype Subtype_For_Abort_Absent is
            Root_Node_Record (Ada_Abort_Absent);
         type Access_To_Subtype_For_Abort_Absent is access all Subtype_For_Abort_Absent;
         package Bare_Abort_Absent_Alloc is new Alloc
           (Subtype_For_Abort_Absent, Access_To_Subtype_For_Abort_Absent);

         function Allocate_Abort_Absent
           (Pool : Bump_Ptr_Pool) return Bare_Abort_Absent;

         function Allocate_Abort_Absent
           (Pool : Bump_Ptr_Pool) return Bare_Abort_Absent
         is
            Result      : constant Access_To_Subtype_For_Abort_Absent := Bare_Abort_Absent_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Abort_Absent;
            return Bare_Abort_Absent (Result);
         end Allocate_Abort_Absent;

      package Bare_Abort_Present_Memos is new Langkit_Support.Packrat
        (Bare_Abort_Present, Token_Index);

         
         subtype Subtype_For_Abort_Present is
            Root_Node_Record (Ada_Abort_Present);
         type Access_To_Subtype_For_Abort_Present is access all Subtype_For_Abort_Present;
         package Bare_Abort_Present_Alloc is new Alloc
           (Subtype_For_Abort_Present, Access_To_Subtype_For_Abort_Present);

         function Allocate_Abort_Present
           (Pool : Bump_Ptr_Pool) return Bare_Abort_Present;

         function Allocate_Abort_Present
           (Pool : Bump_Ptr_Pool) return Bare_Abort_Present
         is
            Result      : constant Access_To_Subtype_For_Abort_Present := Bare_Abort_Present_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Abort_Present;
            return Bare_Abort_Present (Result);
         end Allocate_Abort_Present;

      package Bare_Abstract_Node_Memos is new Langkit_Support.Packrat
        (Bare_Abstract_Node, Token_Index);

      package Bare_Abstract_Absent_Memos is new Langkit_Support.Packrat
        (Bare_Abstract_Absent, Token_Index);

         
         subtype Subtype_For_Abstract_Absent is
            Root_Node_Record (Ada_Abstract_Absent);
         type Access_To_Subtype_For_Abstract_Absent is access all Subtype_For_Abstract_Absent;
         package Bare_Abstract_Absent_Alloc is new Alloc
           (Subtype_For_Abstract_Absent, Access_To_Subtype_For_Abstract_Absent);

         function Allocate_Abstract_Absent
           (Pool : Bump_Ptr_Pool) return Bare_Abstract_Absent;

         function Allocate_Abstract_Absent
           (Pool : Bump_Ptr_Pool) return Bare_Abstract_Absent
         is
            Result      : constant Access_To_Subtype_For_Abstract_Absent := Bare_Abstract_Absent_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Abstract_Absent;
            return Bare_Abstract_Absent (Result);
         end Allocate_Abstract_Absent;

      package Bare_Abstract_Present_Memos is new Langkit_Support.Packrat
        (Bare_Abstract_Present, Token_Index);

         
         subtype Subtype_For_Abstract_Present is
            Root_Node_Record (Ada_Abstract_Present);
         type Access_To_Subtype_For_Abstract_Present is access all Subtype_For_Abstract_Present;
         package Bare_Abstract_Present_Alloc is new Alloc
           (Subtype_For_Abstract_Present, Access_To_Subtype_For_Abstract_Present);

         function Allocate_Abstract_Present
           (Pool : Bump_Ptr_Pool) return Bare_Abstract_Present;

         function Allocate_Abstract_Present
           (Pool : Bump_Ptr_Pool) return Bare_Abstract_Present
         is
            Result      : constant Access_To_Subtype_For_Abstract_Present := Bare_Abstract_Present_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Abstract_Present;
            return Bare_Abstract_Present (Result);
         end Allocate_Abstract_Present;

      package Bare_Ada_List_Memos is new Langkit_Support.Packrat
        (Bare_Ada_List, Token_Index);

      package Bare_Ada_Node_List_Memos is new Langkit_Support.Packrat
        (Bare_Ada_Node_List, Token_Index);

         
         subtype Subtype_For_Ada_Node_List is
            Root_Node_Record (Ada_Ada_Node_List);
         type Access_To_Subtype_For_Ada_Node_List is access all Subtype_For_Ada_Node_List;
         package Bare_Ada_Node_List_Alloc is new Alloc
           (Subtype_For_Ada_Node_List, Access_To_Subtype_For_Ada_Node_List);

         function Allocate_Ada_Node_List
           (Pool : Bump_Ptr_Pool) return Bare_Ada_Node_List;

         function Allocate_Ada_Node_List
           (Pool : Bump_Ptr_Pool) return Bare_Ada_Node_List
         is
            Result      : constant Access_To_Subtype_For_Ada_Node_List := Bare_Ada_Node_List_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Ada_Node_List;
            return Bare_Ada_Node_List (Result);
         end Allocate_Ada_Node_List;

      package Bare_Alternatives_List_Memos is new Langkit_Support.Packrat
        (Bare_Alternatives_List, Token_Index);

         
         subtype Subtype_For_Alternatives_List is
            Root_Node_Record (Ada_Alternatives_List);
         type Access_To_Subtype_For_Alternatives_List is access all Subtype_For_Alternatives_List;
         package Bare_Alternatives_List_Alloc is new Alloc
           (Subtype_For_Alternatives_List, Access_To_Subtype_For_Alternatives_List);

         function Allocate_Alternatives_List
           (Pool : Bump_Ptr_Pool) return Bare_Alternatives_List;

         function Allocate_Alternatives_List
           (Pool : Bump_Ptr_Pool) return Bare_Alternatives_List
         is
            Result      : constant Access_To_Subtype_For_Alternatives_List := Bare_Alternatives_List_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Alternatives_List;
            return Bare_Alternatives_List (Result);
         end Allocate_Alternatives_List;

      package Bare_Constraint_List_Memos is new Langkit_Support.Packrat
        (Bare_Constraint_List, Token_Index);

         
         subtype Subtype_For_Constraint_List is
            Root_Node_Record (Ada_Constraint_List);
         type Access_To_Subtype_For_Constraint_List is access all Subtype_For_Constraint_List;
         package Bare_Constraint_List_Alloc is new Alloc
           (Subtype_For_Constraint_List, Access_To_Subtype_For_Constraint_List);

         function Allocate_Constraint_List
           (Pool : Bump_Ptr_Pool) return Bare_Constraint_List;

         function Allocate_Constraint_List
           (Pool : Bump_Ptr_Pool) return Bare_Constraint_List
         is
            Result      : constant Access_To_Subtype_For_Constraint_List := Bare_Constraint_List_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Constraint_List;
            return Bare_Constraint_List (Result);
         end Allocate_Constraint_List;

      package Bare_Decl_List_Memos is new Langkit_Support.Packrat
        (Bare_Decl_List, Token_Index);

         
         subtype Subtype_For_Decl_List is
            Root_Node_Record (Ada_Decl_List);
         type Access_To_Subtype_For_Decl_List is access all Subtype_For_Decl_List;
         package Bare_Decl_List_Alloc is new Alloc
           (Subtype_For_Decl_List, Access_To_Subtype_For_Decl_List);

         function Allocate_Decl_List
           (Pool : Bump_Ptr_Pool) return Bare_Decl_List;

         function Allocate_Decl_List
           (Pool : Bump_Ptr_Pool) return Bare_Decl_List
         is
            Result      : constant Access_To_Subtype_For_Decl_List := Bare_Decl_List_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Decl_List;
            return Bare_Decl_List (Result);
         end Allocate_Decl_List;

      package Bare_Stmt_List_Memos is new Langkit_Support.Packrat
        (Bare_Stmt_List, Token_Index);

         
         subtype Subtype_For_Stmt_List is
            Root_Node_Record (Ada_Stmt_List);
         type Access_To_Subtype_For_Stmt_List is access all Subtype_For_Stmt_List;
         package Bare_Stmt_List_Alloc is new Alloc
           (Subtype_For_Stmt_List, Access_To_Subtype_For_Stmt_List);

         function Allocate_Stmt_List
           (Pool : Bump_Ptr_Pool) return Bare_Stmt_List;

         function Allocate_Stmt_List
           (Pool : Bump_Ptr_Pool) return Bare_Stmt_List
         is
            Result      : constant Access_To_Subtype_For_Stmt_List := Bare_Stmt_List_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Stmt_List;
            return Bare_Stmt_List (Result);
         end Allocate_Stmt_List;

      package Bare_Aspect_Assoc_List_Memos is new Langkit_Support.Packrat
        (Bare_Aspect_Assoc_List, Token_Index);

         
         subtype Subtype_For_Aspect_Assoc_List is
            Root_Node_Record (Ada_Aspect_Assoc_List);
         type Access_To_Subtype_For_Aspect_Assoc_List is access all Subtype_For_Aspect_Assoc_List;
         package Bare_Aspect_Assoc_List_Alloc is new Alloc
           (Subtype_For_Aspect_Assoc_List, Access_To_Subtype_For_Aspect_Assoc_List);

         function Allocate_Aspect_Assoc_List
           (Pool : Bump_Ptr_Pool) return Bare_Aspect_Assoc_List;

         function Allocate_Aspect_Assoc_List
           (Pool : Bump_Ptr_Pool) return Bare_Aspect_Assoc_List
         is
            Result      : constant Access_To_Subtype_For_Aspect_Assoc_List := Bare_Aspect_Assoc_List_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Aspect_Assoc_List;
            return Bare_Aspect_Assoc_List (Result);
         end Allocate_Aspect_Assoc_List;

      package Bare_Base_Assoc_List_Memos is new Langkit_Support.Packrat
        (Bare_Base_Assoc_List, Token_Index);

         
         subtype Subtype_For_Base_Assoc_List is
            Root_Node_Record (Ada_Base_Assoc_List);
         type Access_To_Subtype_For_Base_Assoc_List is access all Subtype_For_Base_Assoc_List;
         package Bare_Base_Assoc_List_Alloc is new Alloc
           (Subtype_For_Base_Assoc_List, Access_To_Subtype_For_Base_Assoc_List);

         function Allocate_Base_Assoc_List
           (Pool : Bump_Ptr_Pool) return Bare_Base_Assoc_List;

         function Allocate_Base_Assoc_List
           (Pool : Bump_Ptr_Pool) return Bare_Base_Assoc_List
         is
            Result      : constant Access_To_Subtype_For_Base_Assoc_List := Bare_Base_Assoc_List_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Base_Assoc_List;
            return Bare_Base_Assoc_List (Result);
         end Allocate_Base_Assoc_List;

      package Bare_Basic_Assoc_List_Memos is new Langkit_Support.Packrat
        (Bare_Basic_Assoc_List, Token_Index);

      package Bare_Assoc_List_Memos is new Langkit_Support.Packrat
        (Bare_Assoc_List, Token_Index);

         
         subtype Subtype_For_Assoc_List is
            Root_Node_Record (Ada_Assoc_List);
         type Access_To_Subtype_For_Assoc_List is access all Subtype_For_Assoc_List;
         package Bare_Assoc_List_Alloc is new Alloc
           (Subtype_For_Assoc_List, Access_To_Subtype_For_Assoc_List);

         function Allocate_Assoc_List
           (Pool : Bump_Ptr_Pool) return Bare_Assoc_List;

         function Allocate_Assoc_List
           (Pool : Bump_Ptr_Pool) return Bare_Assoc_List
         is
            Result      : constant Access_To_Subtype_For_Assoc_List := Bare_Assoc_List_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Assoc_List;
            return Bare_Assoc_List (Result);
         end Allocate_Assoc_List;

      package Bare_Basic_Decl_List_Memos is new Langkit_Support.Packrat
        (Bare_Basic_Decl_List, Token_Index);

         
         subtype Subtype_For_Basic_Decl_List is
            Root_Node_Record (Ada_Basic_Decl_List);
         type Access_To_Subtype_For_Basic_Decl_List is access all Subtype_For_Basic_Decl_List;
         package Bare_Basic_Decl_List_Alloc is new Alloc
           (Subtype_For_Basic_Decl_List, Access_To_Subtype_For_Basic_Decl_List);

         function Allocate_Basic_Decl_List
           (Pool : Bump_Ptr_Pool) return Bare_Basic_Decl_List;

         function Allocate_Basic_Decl_List
           (Pool : Bump_Ptr_Pool) return Bare_Basic_Decl_List
         is
            Result      : constant Access_To_Subtype_For_Basic_Decl_List := Bare_Basic_Decl_List_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Basic_Decl_List;
            return Bare_Basic_Decl_List (Result);
         end Allocate_Basic_Decl_List;

      package Bare_Case_Expr_Alternative_List_Memos is new Langkit_Support.Packrat
        (Bare_Case_Expr_Alternative_List, Token_Index);

         
         subtype Subtype_For_Case_Expr_Alternative_List is
            Root_Node_Record (Ada_Case_Expr_Alternative_List);
         type Access_To_Subtype_For_Case_Expr_Alternative_List is access all Subtype_For_Case_Expr_Alternative_List;
         package Bare_Case_Expr_Alternative_List_Alloc is new Alloc
           (Subtype_For_Case_Expr_Alternative_List, Access_To_Subtype_For_Case_Expr_Alternative_List);

         function Allocate_Case_Expr_Alternative_List
           (Pool : Bump_Ptr_Pool) return Bare_Case_Expr_Alternative_List;

         function Allocate_Case_Expr_Alternative_List
           (Pool : Bump_Ptr_Pool) return Bare_Case_Expr_Alternative_List
         is
            Result      : constant Access_To_Subtype_For_Case_Expr_Alternative_List := Bare_Case_Expr_Alternative_List_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Case_Expr_Alternative_List;
            return Bare_Case_Expr_Alternative_List (Result);
         end Allocate_Case_Expr_Alternative_List;

      package Bare_Case_Stmt_Alternative_List_Memos is new Langkit_Support.Packrat
        (Bare_Case_Stmt_Alternative_List, Token_Index);

         
         subtype Subtype_For_Case_Stmt_Alternative_List is
            Root_Node_Record (Ada_Case_Stmt_Alternative_List);
         type Access_To_Subtype_For_Case_Stmt_Alternative_List is access all Subtype_For_Case_Stmt_Alternative_List;
         package Bare_Case_Stmt_Alternative_List_Alloc is new Alloc
           (Subtype_For_Case_Stmt_Alternative_List, Access_To_Subtype_For_Case_Stmt_Alternative_List);

         function Allocate_Case_Stmt_Alternative_List
           (Pool : Bump_Ptr_Pool) return Bare_Case_Stmt_Alternative_List;

         function Allocate_Case_Stmt_Alternative_List
           (Pool : Bump_Ptr_Pool) return Bare_Case_Stmt_Alternative_List
         is
            Result      : constant Access_To_Subtype_For_Case_Stmt_Alternative_List := Bare_Case_Stmt_Alternative_List_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Case_Stmt_Alternative_List;
            return Bare_Case_Stmt_Alternative_List (Result);
         end Allocate_Case_Stmt_Alternative_List;

      package Bare_Compilation_Unit_List_Memos is new Langkit_Support.Packrat
        (Bare_Compilation_Unit_List, Token_Index);

         
         subtype Subtype_For_Compilation_Unit_List is
            Root_Node_Record (Ada_Compilation_Unit_List);
         type Access_To_Subtype_For_Compilation_Unit_List is access all Subtype_For_Compilation_Unit_List;
         package Bare_Compilation_Unit_List_Alloc is new Alloc
           (Subtype_For_Compilation_Unit_List, Access_To_Subtype_For_Compilation_Unit_List);

         function Allocate_Compilation_Unit_List
           (Pool : Bump_Ptr_Pool) return Bare_Compilation_Unit_List;

         function Allocate_Compilation_Unit_List
           (Pool : Bump_Ptr_Pool) return Bare_Compilation_Unit_List
         is
            Result      : constant Access_To_Subtype_For_Compilation_Unit_List := Bare_Compilation_Unit_List_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Compilation_Unit_List;
            return Bare_Compilation_Unit_List (Result);
         end Allocate_Compilation_Unit_List;

      package Bare_Contract_Case_Assoc_List_Memos is new Langkit_Support.Packrat
        (Bare_Contract_Case_Assoc_List, Token_Index);

         
         subtype Subtype_For_Contract_Case_Assoc_List is
            Root_Node_Record (Ada_Contract_Case_Assoc_List);
         type Access_To_Subtype_For_Contract_Case_Assoc_List is access all Subtype_For_Contract_Case_Assoc_List;
         package Bare_Contract_Case_Assoc_List_Alloc is new Alloc
           (Subtype_For_Contract_Case_Assoc_List, Access_To_Subtype_For_Contract_Case_Assoc_List);

         function Allocate_Contract_Case_Assoc_List
           (Pool : Bump_Ptr_Pool) return Bare_Contract_Case_Assoc_List;

         function Allocate_Contract_Case_Assoc_List
           (Pool : Bump_Ptr_Pool) return Bare_Contract_Case_Assoc_List
         is
            Result      : constant Access_To_Subtype_For_Contract_Case_Assoc_List := Bare_Contract_Case_Assoc_List_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Contract_Case_Assoc_List;
            return Bare_Contract_Case_Assoc_List (Result);
         end Allocate_Contract_Case_Assoc_List;

      package Bare_Defining_Name_List_Memos is new Langkit_Support.Packrat
        (Bare_Defining_Name_List, Token_Index);

         
         subtype Subtype_For_Defining_Name_List is
            Root_Node_Record (Ada_Defining_Name_List);
         type Access_To_Subtype_For_Defining_Name_List is access all Subtype_For_Defining_Name_List;
         package Bare_Defining_Name_List_Alloc is new Alloc
           (Subtype_For_Defining_Name_List, Access_To_Subtype_For_Defining_Name_List);

         function Allocate_Defining_Name_List
           (Pool : Bump_Ptr_Pool) return Bare_Defining_Name_List;

         function Allocate_Defining_Name_List
           (Pool : Bump_Ptr_Pool) return Bare_Defining_Name_List
         is
            Result      : constant Access_To_Subtype_For_Defining_Name_List := Bare_Defining_Name_List_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Defining_Name_List;
            return Bare_Defining_Name_List (Result);
         end Allocate_Defining_Name_List;

      package Bare_Discriminant_Spec_List_Memos is new Langkit_Support.Packrat
        (Bare_Discriminant_Spec_List, Token_Index);

         
         subtype Subtype_For_Discriminant_Spec_List is
            Root_Node_Record (Ada_Discriminant_Spec_List);
         type Access_To_Subtype_For_Discriminant_Spec_List is access all Subtype_For_Discriminant_Spec_List;
         package Bare_Discriminant_Spec_List_Alloc is new Alloc
           (Subtype_For_Discriminant_Spec_List, Access_To_Subtype_For_Discriminant_Spec_List);

         function Allocate_Discriminant_Spec_List
           (Pool : Bump_Ptr_Pool) return Bare_Discriminant_Spec_List;

         function Allocate_Discriminant_Spec_List
           (Pool : Bump_Ptr_Pool) return Bare_Discriminant_Spec_List
         is
            Result      : constant Access_To_Subtype_For_Discriminant_Spec_List := Bare_Discriminant_Spec_List_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Discriminant_Spec_List;
            return Bare_Discriminant_Spec_List (Result);
         end Allocate_Discriminant_Spec_List;

      package Bare_Elsif_Expr_Part_List_Memos is new Langkit_Support.Packrat
        (Bare_Elsif_Expr_Part_List, Token_Index);

         
         subtype Subtype_For_Elsif_Expr_Part_List is
            Root_Node_Record (Ada_Elsif_Expr_Part_List);
         type Access_To_Subtype_For_Elsif_Expr_Part_List is access all Subtype_For_Elsif_Expr_Part_List;
         package Bare_Elsif_Expr_Part_List_Alloc is new Alloc
           (Subtype_For_Elsif_Expr_Part_List, Access_To_Subtype_For_Elsif_Expr_Part_List);

         function Allocate_Elsif_Expr_Part_List
           (Pool : Bump_Ptr_Pool) return Bare_Elsif_Expr_Part_List;

         function Allocate_Elsif_Expr_Part_List
           (Pool : Bump_Ptr_Pool) return Bare_Elsif_Expr_Part_List
         is
            Result      : constant Access_To_Subtype_For_Elsif_Expr_Part_List := Bare_Elsif_Expr_Part_List_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Elsif_Expr_Part_List;
            return Bare_Elsif_Expr_Part_List (Result);
         end Allocate_Elsif_Expr_Part_List;

      package Bare_Elsif_Stmt_Part_List_Memos is new Langkit_Support.Packrat
        (Bare_Elsif_Stmt_Part_List, Token_Index);

         
         subtype Subtype_For_Elsif_Stmt_Part_List is
            Root_Node_Record (Ada_Elsif_Stmt_Part_List);
         type Access_To_Subtype_For_Elsif_Stmt_Part_List is access all Subtype_For_Elsif_Stmt_Part_List;
         package Bare_Elsif_Stmt_Part_List_Alloc is new Alloc
           (Subtype_For_Elsif_Stmt_Part_List, Access_To_Subtype_For_Elsif_Stmt_Part_List);

         function Allocate_Elsif_Stmt_Part_List
           (Pool : Bump_Ptr_Pool) return Bare_Elsif_Stmt_Part_List;

         function Allocate_Elsif_Stmt_Part_List
           (Pool : Bump_Ptr_Pool) return Bare_Elsif_Stmt_Part_List
         is
            Result      : constant Access_To_Subtype_For_Elsif_Stmt_Part_List := Bare_Elsif_Stmt_Part_List_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Elsif_Stmt_Part_List;
            return Bare_Elsif_Stmt_Part_List (Result);
         end Allocate_Elsif_Stmt_Part_List;

      package Bare_Enum_Literal_Decl_List_Memos is new Langkit_Support.Packrat
        (Bare_Enum_Literal_Decl_List, Token_Index);

         
         subtype Subtype_For_Enum_Literal_Decl_List is
            Root_Node_Record (Ada_Enum_Literal_Decl_List);
         type Access_To_Subtype_For_Enum_Literal_Decl_List is access all Subtype_For_Enum_Literal_Decl_List;
         package Bare_Enum_Literal_Decl_List_Alloc is new Alloc
           (Subtype_For_Enum_Literal_Decl_List, Access_To_Subtype_For_Enum_Literal_Decl_List);

         function Allocate_Enum_Literal_Decl_List
           (Pool : Bump_Ptr_Pool) return Bare_Enum_Literal_Decl_List;

         function Allocate_Enum_Literal_Decl_List
           (Pool : Bump_Ptr_Pool) return Bare_Enum_Literal_Decl_List
         is
            Result      : constant Access_To_Subtype_For_Enum_Literal_Decl_List := Bare_Enum_Literal_Decl_List_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Enum_Literal_Decl_List;
            return Bare_Enum_Literal_Decl_List (Result);
         end Allocate_Enum_Literal_Decl_List;

      package Bare_Expr_List_Memos is new Langkit_Support.Packrat
        (Bare_Expr_List, Token_Index);

      package Bare_Expr_Alternatives_List_Memos is new Langkit_Support.Packrat
        (Bare_Expr_Alternatives_List, Token_Index);

         
         subtype Subtype_For_Expr_Alternatives_List is
            Root_Node_Record (Ada_Expr_Alternatives_List);
         type Access_To_Subtype_For_Expr_Alternatives_List is access all Subtype_For_Expr_Alternatives_List;
         package Bare_Expr_Alternatives_List_Alloc is new Alloc
           (Subtype_For_Expr_Alternatives_List, Access_To_Subtype_For_Expr_Alternatives_List);

         function Allocate_Expr_Alternatives_List
           (Pool : Bump_Ptr_Pool) return Bare_Expr_Alternatives_List;

         function Allocate_Expr_Alternatives_List
           (Pool : Bump_Ptr_Pool) return Bare_Expr_Alternatives_List
         is
            Result      : constant Access_To_Subtype_For_Expr_Alternatives_List := Bare_Expr_Alternatives_List_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Expr_Alternatives_List;
            return Bare_Expr_Alternatives_List (Result);
         end Allocate_Expr_Alternatives_List;

      package Bare_Identifier_List_Memos is new Langkit_Support.Packrat
        (Bare_Identifier_List, Token_Index);

      package Bare_Discriminant_Choice_List_Memos is new Langkit_Support.Packrat
        (Bare_Discriminant_Choice_List, Token_Index);

         
         subtype Subtype_For_Discriminant_Choice_List is
            Root_Node_Record (Ada_Discriminant_Choice_List);
         type Access_To_Subtype_For_Discriminant_Choice_List is access all Subtype_For_Discriminant_Choice_List;
         package Bare_Discriminant_Choice_List_Alloc is new Alloc
           (Subtype_For_Discriminant_Choice_List, Access_To_Subtype_For_Discriminant_Choice_List);

         function Allocate_Discriminant_Choice_List
           (Pool : Bump_Ptr_Pool) return Bare_Discriminant_Choice_List;

         function Allocate_Discriminant_Choice_List
           (Pool : Bump_Ptr_Pool) return Bare_Discriminant_Choice_List
         is
            Result      : constant Access_To_Subtype_For_Discriminant_Choice_List := Bare_Discriminant_Choice_List_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Discriminant_Choice_List;
            return Bare_Discriminant_Choice_List (Result);
         end Allocate_Discriminant_Choice_List;

      package Bare_Name_List_Memos is new Langkit_Support.Packrat
        (Bare_Name_List, Token_Index);

         
         subtype Subtype_For_Name_List is
            Root_Node_Record (Ada_Name_List);
         type Access_To_Subtype_For_Name_List is access all Subtype_For_Name_List;
         package Bare_Name_List_Alloc is new Alloc
           (Subtype_For_Name_List, Access_To_Subtype_For_Name_List);

         function Allocate_Name_List
           (Pool : Bump_Ptr_Pool) return Bare_Name_List;

         function Allocate_Name_List
           (Pool : Bump_Ptr_Pool) return Bare_Name_List
         is
            Result      : constant Access_To_Subtype_For_Name_List := Bare_Name_List_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Name_List;
            return Bare_Name_List (Result);
         end Allocate_Name_List;

      package Bare_Parent_List_Memos is new Langkit_Support.Packrat
        (Bare_Parent_List, Token_Index);

         
         subtype Subtype_For_Parent_List is
            Root_Node_Record (Ada_Parent_List);
         type Access_To_Subtype_For_Parent_List is access all Subtype_For_Parent_List;
         package Bare_Parent_List_Alloc is new Alloc
           (Subtype_For_Parent_List, Access_To_Subtype_For_Parent_List);

         function Allocate_Parent_List
           (Pool : Bump_Ptr_Pool) return Bare_Parent_List;

         function Allocate_Parent_List
           (Pool : Bump_Ptr_Pool) return Bare_Parent_List
         is
            Result      : constant Access_To_Subtype_For_Parent_List := Bare_Parent_List_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Parent_List;
            return Bare_Parent_List (Result);
         end Allocate_Parent_List;

      package Bare_Param_Spec_List_Memos is new Langkit_Support.Packrat
        (Bare_Param_Spec_List, Token_Index);

         
         subtype Subtype_For_Param_Spec_List is
            Root_Node_Record (Ada_Param_Spec_List);
         type Access_To_Subtype_For_Param_Spec_List is access all Subtype_For_Param_Spec_List;
         package Bare_Param_Spec_List_Alloc is new Alloc
           (Subtype_For_Param_Spec_List, Access_To_Subtype_For_Param_Spec_List);

         function Allocate_Param_Spec_List
           (Pool : Bump_Ptr_Pool) return Bare_Param_Spec_List;

         function Allocate_Param_Spec_List
           (Pool : Bump_Ptr_Pool) return Bare_Param_Spec_List
         is
            Result      : constant Access_To_Subtype_For_Param_Spec_List := Bare_Param_Spec_List_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Param_Spec_List;
            return Bare_Param_Spec_List (Result);
         end Allocate_Param_Spec_List;

      package Bare_Pragma_Node_List_Memos is new Langkit_Support.Packrat
        (Bare_Pragma_Node_List, Token_Index);

         
         subtype Subtype_For_Pragma_Node_List is
            Root_Node_Record (Ada_Pragma_Node_List);
         type Access_To_Subtype_For_Pragma_Node_List is access all Subtype_For_Pragma_Node_List;
         package Bare_Pragma_Node_List_Alloc is new Alloc
           (Subtype_For_Pragma_Node_List, Access_To_Subtype_For_Pragma_Node_List);

         function Allocate_Pragma_Node_List
           (Pool : Bump_Ptr_Pool) return Bare_Pragma_Node_List;

         function Allocate_Pragma_Node_List
           (Pool : Bump_Ptr_Pool) return Bare_Pragma_Node_List
         is
            Result      : constant Access_To_Subtype_For_Pragma_Node_List := Bare_Pragma_Node_List_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Pragma_Node_List;
            return Bare_Pragma_Node_List (Result);
         end Allocate_Pragma_Node_List;

      package Bare_Select_When_Part_List_Memos is new Langkit_Support.Packrat
        (Bare_Select_When_Part_List, Token_Index);

         
         subtype Subtype_For_Select_When_Part_List is
            Root_Node_Record (Ada_Select_When_Part_List);
         type Access_To_Subtype_For_Select_When_Part_List is access all Subtype_For_Select_When_Part_List;
         package Bare_Select_When_Part_List_Alloc is new Alloc
           (Subtype_For_Select_When_Part_List, Access_To_Subtype_For_Select_When_Part_List);

         function Allocate_Select_When_Part_List
           (Pool : Bump_Ptr_Pool) return Bare_Select_When_Part_List;

         function Allocate_Select_When_Part_List
           (Pool : Bump_Ptr_Pool) return Bare_Select_When_Part_List
         is
            Result      : constant Access_To_Subtype_For_Select_When_Part_List := Bare_Select_When_Part_List_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Select_When_Part_List;
            return Bare_Select_When_Part_List (Result);
         end Allocate_Select_When_Part_List;

      package Bare_Unconstrained_Array_Index_List_Memos is new Langkit_Support.Packrat
        (Bare_Unconstrained_Array_Index_List, Token_Index);

         
         subtype Subtype_For_Unconstrained_Array_Index_List is
            Root_Node_Record (Ada_Unconstrained_Array_Index_List);
         type Access_To_Subtype_For_Unconstrained_Array_Index_List is access all Subtype_For_Unconstrained_Array_Index_List;
         package Bare_Unconstrained_Array_Index_List_Alloc is new Alloc
           (Subtype_For_Unconstrained_Array_Index_List, Access_To_Subtype_For_Unconstrained_Array_Index_List);

         function Allocate_Unconstrained_Array_Index_List
           (Pool : Bump_Ptr_Pool) return Bare_Unconstrained_Array_Index_List;

         function Allocate_Unconstrained_Array_Index_List
           (Pool : Bump_Ptr_Pool) return Bare_Unconstrained_Array_Index_List
         is
            Result      : constant Access_To_Subtype_For_Unconstrained_Array_Index_List := Bare_Unconstrained_Array_Index_List_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Unconstrained_Array_Index_List;
            return Bare_Unconstrained_Array_Index_List (Result);
         end Allocate_Unconstrained_Array_Index_List;

      package Bare_Variant_List_Memos is new Langkit_Support.Packrat
        (Bare_Variant_List, Token_Index);

         
         subtype Subtype_For_Variant_List is
            Root_Node_Record (Ada_Variant_List);
         type Access_To_Subtype_For_Variant_List is access all Subtype_For_Variant_List;
         package Bare_Variant_List_Alloc is new Alloc
           (Subtype_For_Variant_List, Access_To_Subtype_For_Variant_List);

         function Allocate_Variant_List
           (Pool : Bump_Ptr_Pool) return Bare_Variant_List;

         function Allocate_Variant_List
           (Pool : Bump_Ptr_Pool) return Bare_Variant_List
         is
            Result      : constant Access_To_Subtype_For_Variant_List := Bare_Variant_List_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Variant_List;
            return Bare_Variant_List (Result);
         end Allocate_Variant_List;

      package Bare_Aliased_Node_Memos is new Langkit_Support.Packrat
        (Bare_Aliased_Node, Token_Index);

      package Bare_Aliased_Absent_Memos is new Langkit_Support.Packrat
        (Bare_Aliased_Absent, Token_Index);

         
         subtype Subtype_For_Aliased_Absent is
            Root_Node_Record (Ada_Aliased_Absent);
         type Access_To_Subtype_For_Aliased_Absent is access all Subtype_For_Aliased_Absent;
         package Bare_Aliased_Absent_Alloc is new Alloc
           (Subtype_For_Aliased_Absent, Access_To_Subtype_For_Aliased_Absent);

         function Allocate_Aliased_Absent
           (Pool : Bump_Ptr_Pool) return Bare_Aliased_Absent;

         function Allocate_Aliased_Absent
           (Pool : Bump_Ptr_Pool) return Bare_Aliased_Absent
         is
            Result      : constant Access_To_Subtype_For_Aliased_Absent := Bare_Aliased_Absent_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Aliased_Absent;
            return Bare_Aliased_Absent (Result);
         end Allocate_Aliased_Absent;

      package Bare_Aliased_Present_Memos is new Langkit_Support.Packrat
        (Bare_Aliased_Present, Token_Index);

         
         subtype Subtype_For_Aliased_Present is
            Root_Node_Record (Ada_Aliased_Present);
         type Access_To_Subtype_For_Aliased_Present is access all Subtype_For_Aliased_Present;
         package Bare_Aliased_Present_Alloc is new Alloc
           (Subtype_For_Aliased_Present, Access_To_Subtype_For_Aliased_Present);

         function Allocate_Aliased_Present
           (Pool : Bump_Ptr_Pool) return Bare_Aliased_Present;

         function Allocate_Aliased_Present
           (Pool : Bump_Ptr_Pool) return Bare_Aliased_Present
         is
            Result      : constant Access_To_Subtype_For_Aliased_Present := Bare_Aliased_Present_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Aliased_Present;
            return Bare_Aliased_Present (Result);
         end Allocate_Aliased_Present;

      package Bare_All_Node_Memos is new Langkit_Support.Packrat
        (Bare_All_Node, Token_Index);

      package Bare_All_Absent_Memos is new Langkit_Support.Packrat
        (Bare_All_Absent, Token_Index);

         
         subtype Subtype_For_All_Absent is
            Root_Node_Record (Ada_All_Absent);
         type Access_To_Subtype_For_All_Absent is access all Subtype_For_All_Absent;
         package Bare_All_Absent_Alloc is new Alloc
           (Subtype_For_All_Absent, Access_To_Subtype_For_All_Absent);

         function Allocate_All_Absent
           (Pool : Bump_Ptr_Pool) return Bare_All_Absent;

         function Allocate_All_Absent
           (Pool : Bump_Ptr_Pool) return Bare_All_Absent
         is
            Result      : constant Access_To_Subtype_For_All_Absent := Bare_All_Absent_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_All_Absent;
            return Bare_All_Absent (Result);
         end Allocate_All_Absent;

      package Bare_All_Present_Memos is new Langkit_Support.Packrat
        (Bare_All_Present, Token_Index);

         
         subtype Subtype_For_All_Present is
            Root_Node_Record (Ada_All_Present);
         type Access_To_Subtype_For_All_Present is access all Subtype_For_All_Present;
         package Bare_All_Present_Alloc is new Alloc
           (Subtype_For_All_Present, Access_To_Subtype_For_All_Present);

         function Allocate_All_Present
           (Pool : Bump_Ptr_Pool) return Bare_All_Present;

         function Allocate_All_Present
           (Pool : Bump_Ptr_Pool) return Bare_All_Present
         is
            Result      : constant Access_To_Subtype_For_All_Present := Bare_All_Present_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_All_Present;
            return Bare_All_Present (Result);
         end Allocate_All_Present;

      package Bare_Array_Indices_Memos is new Langkit_Support.Packrat
        (Bare_Array_Indices, Token_Index);

      package Bare_Constrained_Array_Indices_Memos is new Langkit_Support.Packrat
        (Bare_Constrained_Array_Indices, Token_Index);

         
         subtype Subtype_For_Constrained_Array_Indices is
            Root_Node_Record (Ada_Constrained_Array_Indices);
         type Access_To_Subtype_For_Constrained_Array_Indices is access all Subtype_For_Constrained_Array_Indices;
         package Bare_Constrained_Array_Indices_Alloc is new Alloc
           (Subtype_For_Constrained_Array_Indices, Access_To_Subtype_For_Constrained_Array_Indices);

         function Allocate_Constrained_Array_Indices
           (Pool : Bump_Ptr_Pool) return Bare_Constrained_Array_Indices;

         function Allocate_Constrained_Array_Indices
           (Pool : Bump_Ptr_Pool) return Bare_Constrained_Array_Indices
         is
            Result      : constant Access_To_Subtype_For_Constrained_Array_Indices := Bare_Constrained_Array_Indices_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Constrained_Array_Indices;
            return Bare_Constrained_Array_Indices (Result);
         end Allocate_Constrained_Array_Indices;

      package Bare_Unconstrained_Array_Indices_Memos is new Langkit_Support.Packrat
        (Bare_Unconstrained_Array_Indices, Token_Index);

         
         subtype Subtype_For_Unconstrained_Array_Indices is
            Root_Node_Record (Ada_Unconstrained_Array_Indices);
         type Access_To_Subtype_For_Unconstrained_Array_Indices is access all Subtype_For_Unconstrained_Array_Indices;
         package Bare_Unconstrained_Array_Indices_Alloc is new Alloc
           (Subtype_For_Unconstrained_Array_Indices, Access_To_Subtype_For_Unconstrained_Array_Indices);

         function Allocate_Unconstrained_Array_Indices
           (Pool : Bump_Ptr_Pool) return Bare_Unconstrained_Array_Indices;

         function Allocate_Unconstrained_Array_Indices
           (Pool : Bump_Ptr_Pool) return Bare_Unconstrained_Array_Indices
         is
            Result      : constant Access_To_Subtype_For_Unconstrained_Array_Indices := Bare_Unconstrained_Array_Indices_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Unconstrained_Array_Indices;
            return Bare_Unconstrained_Array_Indices (Result);
         end Allocate_Unconstrained_Array_Indices;

      package Bare_Aspect_Assoc_Memos is new Langkit_Support.Packrat
        (Bare_Aspect_Assoc, Token_Index);

         
         subtype Subtype_For_Aspect_Assoc is
            Root_Node_Record (Ada_Aspect_Assoc);
         type Access_To_Subtype_For_Aspect_Assoc is access all Subtype_For_Aspect_Assoc;
         package Bare_Aspect_Assoc_Alloc is new Alloc
           (Subtype_For_Aspect_Assoc, Access_To_Subtype_For_Aspect_Assoc);

         function Allocate_Aspect_Assoc
           (Pool : Bump_Ptr_Pool) return Bare_Aspect_Assoc;

         function Allocate_Aspect_Assoc
           (Pool : Bump_Ptr_Pool) return Bare_Aspect_Assoc
         is
            Result      : constant Access_To_Subtype_For_Aspect_Assoc := Bare_Aspect_Assoc_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Aspect_Assoc;
            return Bare_Aspect_Assoc (Result);
         end Allocate_Aspect_Assoc;

      package Bare_Aspect_Clause_Memos is new Langkit_Support.Packrat
        (Bare_Aspect_Clause, Token_Index);

      package Bare_At_Clause_Memos is new Langkit_Support.Packrat
        (Bare_At_Clause, Token_Index);

         
         subtype Subtype_For_At_Clause is
            Root_Node_Record (Ada_At_Clause);
         type Access_To_Subtype_For_At_Clause is access all Subtype_For_At_Clause;
         package Bare_At_Clause_Alloc is new Alloc
           (Subtype_For_At_Clause, Access_To_Subtype_For_At_Clause);

         function Allocate_At_Clause
           (Pool : Bump_Ptr_Pool) return Bare_At_Clause;

         function Allocate_At_Clause
           (Pool : Bump_Ptr_Pool) return Bare_At_Clause
         is
            Result      : constant Access_To_Subtype_For_At_Clause := Bare_At_Clause_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_At_Clause;
            return Bare_At_Clause (Result);
         end Allocate_At_Clause;

      package Bare_Attribute_Def_Clause_Memos is new Langkit_Support.Packrat
        (Bare_Attribute_Def_Clause, Token_Index);

         
         subtype Subtype_For_Attribute_Def_Clause is
            Root_Node_Record (Ada_Attribute_Def_Clause);
         type Access_To_Subtype_For_Attribute_Def_Clause is access all Subtype_For_Attribute_Def_Clause;
         package Bare_Attribute_Def_Clause_Alloc is new Alloc
           (Subtype_For_Attribute_Def_Clause, Access_To_Subtype_For_Attribute_Def_Clause);

         function Allocate_Attribute_Def_Clause
           (Pool : Bump_Ptr_Pool) return Bare_Attribute_Def_Clause;

         function Allocate_Attribute_Def_Clause
           (Pool : Bump_Ptr_Pool) return Bare_Attribute_Def_Clause
         is
            Result      : constant Access_To_Subtype_For_Attribute_Def_Clause := Bare_Attribute_Def_Clause_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Attribute_Def_Clause;
            return Bare_Attribute_Def_Clause (Result);
         end Allocate_Attribute_Def_Clause;

      package Bare_Enum_Rep_Clause_Memos is new Langkit_Support.Packrat
        (Bare_Enum_Rep_Clause, Token_Index);

         
         subtype Subtype_For_Enum_Rep_Clause is
            Root_Node_Record (Ada_Enum_Rep_Clause);
         type Access_To_Subtype_For_Enum_Rep_Clause is access all Subtype_For_Enum_Rep_Clause;
         package Bare_Enum_Rep_Clause_Alloc is new Alloc
           (Subtype_For_Enum_Rep_Clause, Access_To_Subtype_For_Enum_Rep_Clause);

         function Allocate_Enum_Rep_Clause
           (Pool : Bump_Ptr_Pool) return Bare_Enum_Rep_Clause;

         function Allocate_Enum_Rep_Clause
           (Pool : Bump_Ptr_Pool) return Bare_Enum_Rep_Clause
         is
            Result      : constant Access_To_Subtype_For_Enum_Rep_Clause := Bare_Enum_Rep_Clause_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Enum_Rep_Clause;
            return Bare_Enum_Rep_Clause (Result);
         end Allocate_Enum_Rep_Clause;

      package Bare_Record_Rep_Clause_Memos is new Langkit_Support.Packrat
        (Bare_Record_Rep_Clause, Token_Index);

         
         subtype Subtype_For_Record_Rep_Clause is
            Root_Node_Record (Ada_Record_Rep_Clause);
         type Access_To_Subtype_For_Record_Rep_Clause is access all Subtype_For_Record_Rep_Clause;
         package Bare_Record_Rep_Clause_Alloc is new Alloc
           (Subtype_For_Record_Rep_Clause, Access_To_Subtype_For_Record_Rep_Clause);

         function Allocate_Record_Rep_Clause
           (Pool : Bump_Ptr_Pool) return Bare_Record_Rep_Clause;

         function Allocate_Record_Rep_Clause
           (Pool : Bump_Ptr_Pool) return Bare_Record_Rep_Clause
         is
            Result      : constant Access_To_Subtype_For_Record_Rep_Clause := Bare_Record_Rep_Clause_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Record_Rep_Clause;
            return Bare_Record_Rep_Clause (Result);
         end Allocate_Record_Rep_Clause;

      package Bare_Aspect_Spec_Memos is new Langkit_Support.Packrat
        (Bare_Aspect_Spec, Token_Index);

         
         subtype Subtype_For_Aspect_Spec is
            Root_Node_Record (Ada_Aspect_Spec);
         type Access_To_Subtype_For_Aspect_Spec is access all Subtype_For_Aspect_Spec;
         package Bare_Aspect_Spec_Alloc is new Alloc
           (Subtype_For_Aspect_Spec, Access_To_Subtype_For_Aspect_Spec);

         function Allocate_Aspect_Spec
           (Pool : Bump_Ptr_Pool) return Bare_Aspect_Spec;

         function Allocate_Aspect_Spec
           (Pool : Bump_Ptr_Pool) return Bare_Aspect_Spec
         is
            Result      : constant Access_To_Subtype_For_Aspect_Spec := Bare_Aspect_Spec_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Aspect_Spec;
            return Bare_Aspect_Spec (Result);
         end Allocate_Aspect_Spec;

      package Bare_Base_Assoc_Memos is new Langkit_Support.Packrat
        (Bare_Base_Assoc, Token_Index);

      package Bare_Contract_Case_Assoc_Memos is new Langkit_Support.Packrat
        (Bare_Contract_Case_Assoc, Token_Index);

         
         subtype Subtype_For_Contract_Case_Assoc is
            Root_Node_Record (Ada_Contract_Case_Assoc);
         type Access_To_Subtype_For_Contract_Case_Assoc is access all Subtype_For_Contract_Case_Assoc;
         package Bare_Contract_Case_Assoc_Alloc is new Alloc
           (Subtype_For_Contract_Case_Assoc, Access_To_Subtype_For_Contract_Case_Assoc);

         function Allocate_Contract_Case_Assoc
           (Pool : Bump_Ptr_Pool) return Bare_Contract_Case_Assoc;

         function Allocate_Contract_Case_Assoc
           (Pool : Bump_Ptr_Pool) return Bare_Contract_Case_Assoc
         is
            Result      : constant Access_To_Subtype_For_Contract_Case_Assoc := Bare_Contract_Case_Assoc_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Contract_Case_Assoc;
            return Bare_Contract_Case_Assoc (Result);
         end Allocate_Contract_Case_Assoc;

      package Bare_Pragma_Argument_Assoc_Memos is new Langkit_Support.Packrat
        (Bare_Pragma_Argument_Assoc, Token_Index);

         
         subtype Subtype_For_Pragma_Argument_Assoc is
            Root_Node_Record (Ada_Pragma_Argument_Assoc);
         type Access_To_Subtype_For_Pragma_Argument_Assoc is access all Subtype_For_Pragma_Argument_Assoc;
         package Bare_Pragma_Argument_Assoc_Alloc is new Alloc
           (Subtype_For_Pragma_Argument_Assoc, Access_To_Subtype_For_Pragma_Argument_Assoc);

         function Allocate_Pragma_Argument_Assoc
           (Pool : Bump_Ptr_Pool) return Bare_Pragma_Argument_Assoc;

         function Allocate_Pragma_Argument_Assoc
           (Pool : Bump_Ptr_Pool) return Bare_Pragma_Argument_Assoc
         is
            Result      : constant Access_To_Subtype_For_Pragma_Argument_Assoc := Bare_Pragma_Argument_Assoc_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Pragma_Argument_Assoc;
            return Bare_Pragma_Argument_Assoc (Result);
         end Allocate_Pragma_Argument_Assoc;

      package Bare_Base_Formal_Param_Holder_Memos is new Langkit_Support.Packrat
        (Bare_Base_Formal_Param_Holder, Token_Index);

      package Bare_Base_Subp_Spec_Memos is new Langkit_Support.Packrat
        (Bare_Base_Subp_Spec, Token_Index);

      package Bare_Entry_Spec_Memos is new Langkit_Support.Packrat
        (Bare_Entry_Spec, Token_Index);

         
         subtype Subtype_For_Entry_Spec is
            Root_Node_Record (Ada_Entry_Spec);
         type Access_To_Subtype_For_Entry_Spec is access all Subtype_For_Entry_Spec;
         package Bare_Entry_Spec_Alloc is new Alloc
           (Subtype_For_Entry_Spec, Access_To_Subtype_For_Entry_Spec);

         function Allocate_Entry_Spec
           (Pool : Bump_Ptr_Pool) return Bare_Entry_Spec;

         function Allocate_Entry_Spec
           (Pool : Bump_Ptr_Pool) return Bare_Entry_Spec
         is
            Result      : constant Access_To_Subtype_For_Entry_Spec := Bare_Entry_Spec_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Entry_Spec;
            return Bare_Entry_Spec (Result);
         end Allocate_Entry_Spec;

      package Bare_Enum_Subp_Spec_Memos is new Langkit_Support.Packrat
        (Bare_Enum_Subp_Spec, Token_Index);

         
         subtype Subtype_For_Enum_Subp_Spec is
            Root_Node_Record (Ada_Enum_Subp_Spec);
         type Access_To_Subtype_For_Enum_Subp_Spec is access all Subtype_For_Enum_Subp_Spec;
         package Bare_Enum_Subp_Spec_Alloc is new Alloc
           (Subtype_For_Enum_Subp_Spec, Access_To_Subtype_For_Enum_Subp_Spec);

         function Allocate_Enum_Subp_Spec
           (Pool : Bump_Ptr_Pool) return Bare_Enum_Subp_Spec;

         function Allocate_Enum_Subp_Spec
           (Pool : Bump_Ptr_Pool) return Bare_Enum_Subp_Spec
         is
            Result      : constant Access_To_Subtype_For_Enum_Subp_Spec := Bare_Enum_Subp_Spec_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Enum_Subp_Spec;
            return Bare_Enum_Subp_Spec (Result);
         end Allocate_Enum_Subp_Spec;

      package Bare_Subp_Spec_Memos is new Langkit_Support.Packrat
        (Bare_Subp_Spec, Token_Index);

         
         subtype Subtype_For_Subp_Spec is
            Root_Node_Record (Ada_Subp_Spec);
         type Access_To_Subtype_For_Subp_Spec is access all Subtype_For_Subp_Spec;
         package Bare_Subp_Spec_Alloc is new Alloc
           (Subtype_For_Subp_Spec, Access_To_Subtype_For_Subp_Spec);

         function Allocate_Subp_Spec
           (Pool : Bump_Ptr_Pool) return Bare_Subp_Spec;

         function Allocate_Subp_Spec
           (Pool : Bump_Ptr_Pool) return Bare_Subp_Spec
         is
            Result      : constant Access_To_Subtype_For_Subp_Spec := Bare_Subp_Spec_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Subp_Spec;
            return Bare_Subp_Spec (Result);
         end Allocate_Subp_Spec;

      package Bare_Component_List_Memos is new Langkit_Support.Packrat
        (Bare_Component_List, Token_Index);

         
         subtype Subtype_For_Component_List is
            Root_Node_Record (Ada_Component_List);
         type Access_To_Subtype_For_Component_List is access all Subtype_For_Component_List;
         package Bare_Component_List_Alloc is new Alloc
           (Subtype_For_Component_List, Access_To_Subtype_For_Component_List);

         function Allocate_Component_List
           (Pool : Bump_Ptr_Pool) return Bare_Component_List;

         function Allocate_Component_List
           (Pool : Bump_Ptr_Pool) return Bare_Component_List
         is
            Result      : constant Access_To_Subtype_For_Component_List := Bare_Component_List_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Component_List;
            return Bare_Component_List (Result);
         end Allocate_Component_List;

      package Bare_Discriminant_Part_Memos is new Langkit_Support.Packrat
        (Bare_Discriminant_Part, Token_Index);

      package Bare_Known_Discriminant_Part_Memos is new Langkit_Support.Packrat
        (Bare_Known_Discriminant_Part, Token_Index);

         
         subtype Subtype_For_Known_Discriminant_Part is
            Root_Node_Record (Ada_Known_Discriminant_Part);
         type Access_To_Subtype_For_Known_Discriminant_Part is access all Subtype_For_Known_Discriminant_Part;
         package Bare_Known_Discriminant_Part_Alloc is new Alloc
           (Subtype_For_Known_Discriminant_Part, Access_To_Subtype_For_Known_Discriminant_Part);

         function Allocate_Known_Discriminant_Part
           (Pool : Bump_Ptr_Pool) return Bare_Known_Discriminant_Part;

         function Allocate_Known_Discriminant_Part
           (Pool : Bump_Ptr_Pool) return Bare_Known_Discriminant_Part
         is
            Result      : constant Access_To_Subtype_For_Known_Discriminant_Part := Bare_Known_Discriminant_Part_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Known_Discriminant_Part;
            return Bare_Known_Discriminant_Part (Result);
         end Allocate_Known_Discriminant_Part;

      package Bare_Unknown_Discriminant_Part_Memos is new Langkit_Support.Packrat
        (Bare_Unknown_Discriminant_Part, Token_Index);

         
         subtype Subtype_For_Unknown_Discriminant_Part is
            Root_Node_Record (Ada_Unknown_Discriminant_Part);
         type Access_To_Subtype_For_Unknown_Discriminant_Part is access all Subtype_For_Unknown_Discriminant_Part;
         package Bare_Unknown_Discriminant_Part_Alloc is new Alloc
           (Subtype_For_Unknown_Discriminant_Part, Access_To_Subtype_For_Unknown_Discriminant_Part);

         function Allocate_Unknown_Discriminant_Part
           (Pool : Bump_Ptr_Pool) return Bare_Unknown_Discriminant_Part;

         function Allocate_Unknown_Discriminant_Part
           (Pool : Bump_Ptr_Pool) return Bare_Unknown_Discriminant_Part
         is
            Result      : constant Access_To_Subtype_For_Unknown_Discriminant_Part := Bare_Unknown_Discriminant_Part_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Unknown_Discriminant_Part;
            return Bare_Unknown_Discriminant_Part (Result);
         end Allocate_Unknown_Discriminant_Part;

      package Bare_Entry_Completion_Formal_Params_Memos is new Langkit_Support.Packrat
        (Bare_Entry_Completion_Formal_Params, Token_Index);

         
         subtype Subtype_For_Entry_Completion_Formal_Params is
            Root_Node_Record (Ada_Entry_Completion_Formal_Params);
         type Access_To_Subtype_For_Entry_Completion_Formal_Params is access all Subtype_For_Entry_Completion_Formal_Params;
         package Bare_Entry_Completion_Formal_Params_Alloc is new Alloc
           (Subtype_For_Entry_Completion_Formal_Params, Access_To_Subtype_For_Entry_Completion_Formal_Params);

         function Allocate_Entry_Completion_Formal_Params
           (Pool : Bump_Ptr_Pool) return Bare_Entry_Completion_Formal_Params;

         function Allocate_Entry_Completion_Formal_Params
           (Pool : Bump_Ptr_Pool) return Bare_Entry_Completion_Formal_Params
         is
            Result      : constant Access_To_Subtype_For_Entry_Completion_Formal_Params := Bare_Entry_Completion_Formal_Params_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Entry_Completion_Formal_Params;
            return Bare_Entry_Completion_Formal_Params (Result);
         end Allocate_Entry_Completion_Formal_Params;

      package Bare_Generic_Formal_Part_Memos is new Langkit_Support.Packrat
        (Bare_Generic_Formal_Part, Token_Index);

         
         subtype Subtype_For_Generic_Formal_Part is
            Root_Node_Record (Ada_Generic_Formal_Part);
         type Access_To_Subtype_For_Generic_Formal_Part is access all Subtype_For_Generic_Formal_Part;
         package Bare_Generic_Formal_Part_Alloc is new Alloc
           (Subtype_For_Generic_Formal_Part, Access_To_Subtype_For_Generic_Formal_Part);

         function Allocate_Generic_Formal_Part
           (Pool : Bump_Ptr_Pool) return Bare_Generic_Formal_Part;

         function Allocate_Generic_Formal_Part
           (Pool : Bump_Ptr_Pool) return Bare_Generic_Formal_Part
         is
            Result      : constant Access_To_Subtype_For_Generic_Formal_Part := Bare_Generic_Formal_Part_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Generic_Formal_Part;
            return Bare_Generic_Formal_Part (Result);
         end Allocate_Generic_Formal_Part;

      package Bare_Base_Record_Def_Memos is new Langkit_Support.Packrat
        (Bare_Base_Record_Def, Token_Index);

      package Bare_Null_Record_Def_Memos is new Langkit_Support.Packrat
        (Bare_Null_Record_Def, Token_Index);

         
         subtype Subtype_For_Null_Record_Def is
            Root_Node_Record (Ada_Null_Record_Def);
         type Access_To_Subtype_For_Null_Record_Def is access all Subtype_For_Null_Record_Def;
         package Bare_Null_Record_Def_Alloc is new Alloc
           (Subtype_For_Null_Record_Def, Access_To_Subtype_For_Null_Record_Def);

         function Allocate_Null_Record_Def
           (Pool : Bump_Ptr_Pool) return Bare_Null_Record_Def;

         function Allocate_Null_Record_Def
           (Pool : Bump_Ptr_Pool) return Bare_Null_Record_Def
         is
            Result      : constant Access_To_Subtype_For_Null_Record_Def := Bare_Null_Record_Def_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Null_Record_Def;
            return Bare_Null_Record_Def (Result);
         end Allocate_Null_Record_Def;

      package Bare_Record_Def_Memos is new Langkit_Support.Packrat
        (Bare_Record_Def, Token_Index);

         
         subtype Subtype_For_Record_Def is
            Root_Node_Record (Ada_Record_Def);
         type Access_To_Subtype_For_Record_Def is access all Subtype_For_Record_Def;
         package Bare_Record_Def_Alloc is new Alloc
           (Subtype_For_Record_Def, Access_To_Subtype_For_Record_Def);

         function Allocate_Record_Def
           (Pool : Bump_Ptr_Pool) return Bare_Record_Def;

         function Allocate_Record_Def
           (Pool : Bump_Ptr_Pool) return Bare_Record_Def
         is
            Result      : constant Access_To_Subtype_For_Record_Def := Bare_Record_Def_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Record_Def;
            return Bare_Record_Def (Result);
         end Allocate_Record_Def;

      package Bare_Basic_Assoc_Memos is new Langkit_Support.Packrat
        (Bare_Basic_Assoc, Token_Index);

      package Bare_Aggregate_Assoc_Memos is new Langkit_Support.Packrat
        (Bare_Aggregate_Assoc, Token_Index);

         
         subtype Subtype_For_Aggregate_Assoc is
            Root_Node_Record (Ada_Aggregate_Assoc);
         type Access_To_Subtype_For_Aggregate_Assoc is access all Subtype_For_Aggregate_Assoc;
         package Bare_Aggregate_Assoc_Alloc is new Alloc
           (Subtype_For_Aggregate_Assoc, Access_To_Subtype_For_Aggregate_Assoc);

         function Allocate_Aggregate_Assoc
           (Pool : Bump_Ptr_Pool) return Bare_Aggregate_Assoc;

         function Allocate_Aggregate_Assoc
           (Pool : Bump_Ptr_Pool) return Bare_Aggregate_Assoc
         is
            Result      : constant Access_To_Subtype_For_Aggregate_Assoc := Bare_Aggregate_Assoc_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Aggregate_Assoc;
            return Bare_Aggregate_Assoc (Result);
         end Allocate_Aggregate_Assoc;

      package Bare_Multi_Dim_Array_Assoc_Memos is new Langkit_Support.Packrat
        (Bare_Multi_Dim_Array_Assoc, Token_Index);

         
         subtype Subtype_For_Multi_Dim_Array_Assoc is
            Root_Node_Record (Ada_Multi_Dim_Array_Assoc);
         type Access_To_Subtype_For_Multi_Dim_Array_Assoc is access all Subtype_For_Multi_Dim_Array_Assoc;
         package Bare_Multi_Dim_Array_Assoc_Alloc is new Alloc
           (Subtype_For_Multi_Dim_Array_Assoc, Access_To_Subtype_For_Multi_Dim_Array_Assoc);

         function Allocate_Multi_Dim_Array_Assoc
           (Pool : Bump_Ptr_Pool) return Bare_Multi_Dim_Array_Assoc;

         function Allocate_Multi_Dim_Array_Assoc
           (Pool : Bump_Ptr_Pool) return Bare_Multi_Dim_Array_Assoc
         is
            Result      : constant Access_To_Subtype_For_Multi_Dim_Array_Assoc := Bare_Multi_Dim_Array_Assoc_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Multi_Dim_Array_Assoc;
            return Bare_Multi_Dim_Array_Assoc (Result);
         end Allocate_Multi_Dim_Array_Assoc;

      package Bare_Discriminant_Assoc_Memos is new Langkit_Support.Packrat
        (Bare_Discriminant_Assoc, Token_Index);

         
         subtype Subtype_For_Discriminant_Assoc is
            Root_Node_Record (Ada_Discriminant_Assoc);
         type Access_To_Subtype_For_Discriminant_Assoc is access all Subtype_For_Discriminant_Assoc;
         package Bare_Discriminant_Assoc_Alloc is new Alloc
           (Subtype_For_Discriminant_Assoc, Access_To_Subtype_For_Discriminant_Assoc);

         function Allocate_Discriminant_Assoc
           (Pool : Bump_Ptr_Pool) return Bare_Discriminant_Assoc;

         function Allocate_Discriminant_Assoc
           (Pool : Bump_Ptr_Pool) return Bare_Discriminant_Assoc
         is
            Result      : constant Access_To_Subtype_For_Discriminant_Assoc := Bare_Discriminant_Assoc_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Discriminant_Assoc;
            return Bare_Discriminant_Assoc (Result);
         end Allocate_Discriminant_Assoc;

      package Bare_Iterated_Assoc_Memos is new Langkit_Support.Packrat
        (Bare_Iterated_Assoc, Token_Index);

         
         subtype Subtype_For_Iterated_Assoc is
            Root_Node_Record (Ada_Iterated_Assoc);
         type Access_To_Subtype_For_Iterated_Assoc is access all Subtype_For_Iterated_Assoc;
         package Bare_Iterated_Assoc_Alloc is new Alloc
           (Subtype_For_Iterated_Assoc, Access_To_Subtype_For_Iterated_Assoc);

         function Allocate_Iterated_Assoc
           (Pool : Bump_Ptr_Pool) return Bare_Iterated_Assoc;

         function Allocate_Iterated_Assoc
           (Pool : Bump_Ptr_Pool) return Bare_Iterated_Assoc
         is
            Result      : constant Access_To_Subtype_For_Iterated_Assoc := Bare_Iterated_Assoc_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Iterated_Assoc;
            return Bare_Iterated_Assoc (Result);
         end Allocate_Iterated_Assoc;

      package Bare_Param_Assoc_Memos is new Langkit_Support.Packrat
        (Bare_Param_Assoc, Token_Index);

         
         subtype Subtype_For_Param_Assoc is
            Root_Node_Record (Ada_Param_Assoc);
         type Access_To_Subtype_For_Param_Assoc is access all Subtype_For_Param_Assoc;
         package Bare_Param_Assoc_Alloc is new Alloc
           (Subtype_For_Param_Assoc, Access_To_Subtype_For_Param_Assoc);

         function Allocate_Param_Assoc
           (Pool : Bump_Ptr_Pool) return Bare_Param_Assoc;

         function Allocate_Param_Assoc
           (Pool : Bump_Ptr_Pool) return Bare_Param_Assoc
         is
            Result      : constant Access_To_Subtype_For_Param_Assoc := Bare_Param_Assoc_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Param_Assoc;
            return Bare_Param_Assoc (Result);
         end Allocate_Param_Assoc;

      package Bare_Basic_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Basic_Decl, Token_Index);

      package Bare_Base_Formal_Param_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Base_Formal_Param_Decl, Token_Index);

      package Bare_Component_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Component_Decl, Token_Index);

         
         subtype Subtype_For_Component_Decl is
            Root_Node_Record (Ada_Component_Decl);
         type Access_To_Subtype_For_Component_Decl is access all Subtype_For_Component_Decl;
         package Bare_Component_Decl_Alloc is new Alloc
           (Subtype_For_Component_Decl, Access_To_Subtype_For_Component_Decl);

         function Allocate_Component_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Component_Decl;

         function Allocate_Component_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Component_Decl
         is
            Result      : constant Access_To_Subtype_For_Component_Decl := Bare_Component_Decl_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Component_Decl;
            return Bare_Component_Decl (Result);
         end Allocate_Component_Decl;

      package Bare_Discriminant_Spec_Memos is new Langkit_Support.Packrat
        (Bare_Discriminant_Spec, Token_Index);

         
         subtype Subtype_For_Discriminant_Spec is
            Root_Node_Record (Ada_Discriminant_Spec);
         type Access_To_Subtype_For_Discriminant_Spec is access all Subtype_For_Discriminant_Spec;
         package Bare_Discriminant_Spec_Alloc is new Alloc
           (Subtype_For_Discriminant_Spec, Access_To_Subtype_For_Discriminant_Spec);

         function Allocate_Discriminant_Spec
           (Pool : Bump_Ptr_Pool) return Bare_Discriminant_Spec;

         function Allocate_Discriminant_Spec
           (Pool : Bump_Ptr_Pool) return Bare_Discriminant_Spec
         is
            Result      : constant Access_To_Subtype_For_Discriminant_Spec := Bare_Discriminant_Spec_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Discriminant_Spec;
            return Bare_Discriminant_Spec (Result);
         end Allocate_Discriminant_Spec;

      package Bare_Generic_Formal_Memos is new Langkit_Support.Packrat
        (Bare_Generic_Formal, Token_Index);

      package Bare_Generic_Formal_Obj_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Generic_Formal_Obj_Decl, Token_Index);

         
         subtype Subtype_For_Generic_Formal_Obj_Decl is
            Root_Node_Record (Ada_Generic_Formal_Obj_Decl);
         type Access_To_Subtype_For_Generic_Formal_Obj_Decl is access all Subtype_For_Generic_Formal_Obj_Decl;
         package Bare_Generic_Formal_Obj_Decl_Alloc is new Alloc
           (Subtype_For_Generic_Formal_Obj_Decl, Access_To_Subtype_For_Generic_Formal_Obj_Decl);

         function Allocate_Generic_Formal_Obj_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Generic_Formal_Obj_Decl;

         function Allocate_Generic_Formal_Obj_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Generic_Formal_Obj_Decl
         is
            Result      : constant Access_To_Subtype_For_Generic_Formal_Obj_Decl := Bare_Generic_Formal_Obj_Decl_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Generic_Formal_Obj_Decl;
            return Bare_Generic_Formal_Obj_Decl (Result);
         end Allocate_Generic_Formal_Obj_Decl;

      package Bare_Generic_Formal_Package_Memos is new Langkit_Support.Packrat
        (Bare_Generic_Formal_Package, Token_Index);

         
         subtype Subtype_For_Generic_Formal_Package is
            Root_Node_Record (Ada_Generic_Formal_Package);
         type Access_To_Subtype_For_Generic_Formal_Package is access all Subtype_For_Generic_Formal_Package;
         package Bare_Generic_Formal_Package_Alloc is new Alloc
           (Subtype_For_Generic_Formal_Package, Access_To_Subtype_For_Generic_Formal_Package);

         function Allocate_Generic_Formal_Package
           (Pool : Bump_Ptr_Pool) return Bare_Generic_Formal_Package;

         function Allocate_Generic_Formal_Package
           (Pool : Bump_Ptr_Pool) return Bare_Generic_Formal_Package
         is
            Result      : constant Access_To_Subtype_For_Generic_Formal_Package := Bare_Generic_Formal_Package_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Generic_Formal_Package;
            return Bare_Generic_Formal_Package (Result);
         end Allocate_Generic_Formal_Package;

      package Bare_Generic_Formal_Subp_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Generic_Formal_Subp_Decl, Token_Index);

         
         subtype Subtype_For_Generic_Formal_Subp_Decl is
            Root_Node_Record (Ada_Generic_Formal_Subp_Decl);
         type Access_To_Subtype_For_Generic_Formal_Subp_Decl is access all Subtype_For_Generic_Formal_Subp_Decl;
         package Bare_Generic_Formal_Subp_Decl_Alloc is new Alloc
           (Subtype_For_Generic_Formal_Subp_Decl, Access_To_Subtype_For_Generic_Formal_Subp_Decl);

         function Allocate_Generic_Formal_Subp_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Generic_Formal_Subp_Decl;

         function Allocate_Generic_Formal_Subp_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Generic_Formal_Subp_Decl
         is
            Result      : constant Access_To_Subtype_For_Generic_Formal_Subp_Decl := Bare_Generic_Formal_Subp_Decl_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Generic_Formal_Subp_Decl;
            return Bare_Generic_Formal_Subp_Decl (Result);
         end Allocate_Generic_Formal_Subp_Decl;

      package Bare_Generic_Formal_Type_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Generic_Formal_Type_Decl, Token_Index);

         
         subtype Subtype_For_Generic_Formal_Type_Decl is
            Root_Node_Record (Ada_Generic_Formal_Type_Decl);
         type Access_To_Subtype_For_Generic_Formal_Type_Decl is access all Subtype_For_Generic_Formal_Type_Decl;
         package Bare_Generic_Formal_Type_Decl_Alloc is new Alloc
           (Subtype_For_Generic_Formal_Type_Decl, Access_To_Subtype_For_Generic_Formal_Type_Decl);

         function Allocate_Generic_Formal_Type_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Generic_Formal_Type_Decl;

         function Allocate_Generic_Formal_Type_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Generic_Formal_Type_Decl
         is
            Result      : constant Access_To_Subtype_For_Generic_Formal_Type_Decl := Bare_Generic_Formal_Type_Decl_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Generic_Formal_Type_Decl;
            return Bare_Generic_Formal_Type_Decl (Result);
         end Allocate_Generic_Formal_Type_Decl;

      package Bare_Param_Spec_Memos is new Langkit_Support.Packrat
        (Bare_Param_Spec, Token_Index);

         
         subtype Subtype_For_Param_Spec is
            Root_Node_Record (Ada_Param_Spec);
         type Access_To_Subtype_For_Param_Spec is access all Subtype_For_Param_Spec;
         package Bare_Param_Spec_Alloc is new Alloc
           (Subtype_For_Param_Spec, Access_To_Subtype_For_Param_Spec);

         function Allocate_Param_Spec
           (Pool : Bump_Ptr_Pool) return Bare_Param_Spec;

         function Allocate_Param_Spec
           (Pool : Bump_Ptr_Pool) return Bare_Param_Spec
         is
            Result      : constant Access_To_Subtype_For_Param_Spec := Bare_Param_Spec_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Param_Spec;
            return Bare_Param_Spec (Result);
         end Allocate_Param_Spec;

      package Bare_Base_Package_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Base_Package_Decl, Token_Index);

      package Bare_Generic_Package_Internal_Memos is new Langkit_Support.Packrat
        (Bare_Generic_Package_Internal, Token_Index);

         
         subtype Subtype_For_Generic_Package_Internal is
            Root_Node_Record (Ada_Generic_Package_Internal);
         type Access_To_Subtype_For_Generic_Package_Internal is access all Subtype_For_Generic_Package_Internal;
         package Bare_Generic_Package_Internal_Alloc is new Alloc
           (Subtype_For_Generic_Package_Internal, Access_To_Subtype_For_Generic_Package_Internal);

         function Allocate_Generic_Package_Internal
           (Pool : Bump_Ptr_Pool) return Bare_Generic_Package_Internal;

         function Allocate_Generic_Package_Internal
           (Pool : Bump_Ptr_Pool) return Bare_Generic_Package_Internal
         is
            Result      : constant Access_To_Subtype_For_Generic_Package_Internal := Bare_Generic_Package_Internal_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Generic_Package_Internal;
            return Bare_Generic_Package_Internal (Result);
         end Allocate_Generic_Package_Internal;

      package Bare_Package_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Package_Decl, Token_Index);

         
         subtype Subtype_For_Package_Decl is
            Root_Node_Record (Ada_Package_Decl);
         type Access_To_Subtype_For_Package_Decl is access all Subtype_For_Package_Decl;
         package Bare_Package_Decl_Alloc is new Alloc
           (Subtype_For_Package_Decl, Access_To_Subtype_For_Package_Decl);

         function Allocate_Package_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Package_Decl;

         function Allocate_Package_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Package_Decl
         is
            Result      : constant Access_To_Subtype_For_Package_Decl := Bare_Package_Decl_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Package_Decl;
            return Bare_Package_Decl (Result);
         end Allocate_Package_Decl;

      package Bare_Base_Type_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Base_Type_Decl, Token_Index);

      package Bare_Base_Subtype_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Base_Subtype_Decl, Token_Index);

      package Bare_Discrete_Base_Subtype_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Discrete_Base_Subtype_Decl, Token_Index);

         
         subtype Subtype_For_Discrete_Base_Subtype_Decl is
            Root_Node_Record (Ada_Discrete_Base_Subtype_Decl);
         type Access_To_Subtype_For_Discrete_Base_Subtype_Decl is access all Subtype_For_Discrete_Base_Subtype_Decl;
         package Bare_Discrete_Base_Subtype_Decl_Alloc is new Alloc
           (Subtype_For_Discrete_Base_Subtype_Decl, Access_To_Subtype_For_Discrete_Base_Subtype_Decl);

         function Allocate_Discrete_Base_Subtype_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Discrete_Base_Subtype_Decl;

         function Allocate_Discrete_Base_Subtype_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Discrete_Base_Subtype_Decl
         is
            Result      : constant Access_To_Subtype_For_Discrete_Base_Subtype_Decl := Bare_Discrete_Base_Subtype_Decl_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Discrete_Base_Subtype_Decl;
            return Bare_Discrete_Base_Subtype_Decl (Result);
         end Allocate_Discrete_Base_Subtype_Decl;

      package Bare_Subtype_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Subtype_Decl, Token_Index);

         
         subtype Subtype_For_Subtype_Decl is
            Root_Node_Record (Ada_Subtype_Decl);
         type Access_To_Subtype_For_Subtype_Decl is access all Subtype_For_Subtype_Decl;
         package Bare_Subtype_Decl_Alloc is new Alloc
           (Subtype_For_Subtype_Decl, Access_To_Subtype_For_Subtype_Decl);

         function Allocate_Subtype_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Subtype_Decl;

         function Allocate_Subtype_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Subtype_Decl
         is
            Result      : constant Access_To_Subtype_For_Subtype_Decl := Bare_Subtype_Decl_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Subtype_Decl;
            return Bare_Subtype_Decl (Result);
         end Allocate_Subtype_Decl;

      package Bare_Classwide_Type_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Classwide_Type_Decl, Token_Index);

         
         subtype Subtype_For_Classwide_Type_Decl is
            Root_Node_Record (Ada_Classwide_Type_Decl);
         type Access_To_Subtype_For_Classwide_Type_Decl is access all Subtype_For_Classwide_Type_Decl;
         package Bare_Classwide_Type_Decl_Alloc is new Alloc
           (Subtype_For_Classwide_Type_Decl, Access_To_Subtype_For_Classwide_Type_Decl);

         function Allocate_Classwide_Type_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Classwide_Type_Decl;

         function Allocate_Classwide_Type_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Classwide_Type_Decl
         is
            Result      : constant Access_To_Subtype_For_Classwide_Type_Decl := Bare_Classwide_Type_Decl_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Classwide_Type_Decl;
            return Bare_Classwide_Type_Decl (Result);
         end Allocate_Classwide_Type_Decl;

      package Bare_Incomplete_Type_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Incomplete_Type_Decl, Token_Index);

         
         subtype Subtype_For_Incomplete_Type_Decl is
            Root_Node_Record (Ada_Incomplete_Type_Decl);
         type Access_To_Subtype_For_Incomplete_Type_Decl is access all Subtype_For_Incomplete_Type_Decl;
         package Bare_Incomplete_Type_Decl_Alloc is new Alloc
           (Subtype_For_Incomplete_Type_Decl, Access_To_Subtype_For_Incomplete_Type_Decl);

         function Allocate_Incomplete_Type_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Incomplete_Type_Decl;

         function Allocate_Incomplete_Type_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Incomplete_Type_Decl
         is
            Result      : constant Access_To_Subtype_For_Incomplete_Type_Decl := Bare_Incomplete_Type_Decl_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Incomplete_Type_Decl;
            return Bare_Incomplete_Type_Decl (Result);
         end Allocate_Incomplete_Type_Decl;

      package Bare_Incomplete_Tagged_Type_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Incomplete_Tagged_Type_Decl, Token_Index);

         
         subtype Subtype_For_Incomplete_Tagged_Type_Decl is
            Root_Node_Record (Ada_Incomplete_Tagged_Type_Decl);
         type Access_To_Subtype_For_Incomplete_Tagged_Type_Decl is access all Subtype_For_Incomplete_Tagged_Type_Decl;
         package Bare_Incomplete_Tagged_Type_Decl_Alloc is new Alloc
           (Subtype_For_Incomplete_Tagged_Type_Decl, Access_To_Subtype_For_Incomplete_Tagged_Type_Decl);

         function Allocate_Incomplete_Tagged_Type_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Incomplete_Tagged_Type_Decl;

         function Allocate_Incomplete_Tagged_Type_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Incomplete_Tagged_Type_Decl
         is
            Result      : constant Access_To_Subtype_For_Incomplete_Tagged_Type_Decl := Bare_Incomplete_Tagged_Type_Decl_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Incomplete_Tagged_Type_Decl;
            return Bare_Incomplete_Tagged_Type_Decl (Result);
         end Allocate_Incomplete_Tagged_Type_Decl;

      package Bare_Protected_Type_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Protected_Type_Decl, Token_Index);

         
         subtype Subtype_For_Protected_Type_Decl is
            Root_Node_Record (Ada_Protected_Type_Decl);
         type Access_To_Subtype_For_Protected_Type_Decl is access all Subtype_For_Protected_Type_Decl;
         package Bare_Protected_Type_Decl_Alloc is new Alloc
           (Subtype_For_Protected_Type_Decl, Access_To_Subtype_For_Protected_Type_Decl);

         function Allocate_Protected_Type_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Protected_Type_Decl;

         function Allocate_Protected_Type_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Protected_Type_Decl
         is
            Result      : constant Access_To_Subtype_For_Protected_Type_Decl := Bare_Protected_Type_Decl_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Protected_Type_Decl;
            return Bare_Protected_Type_Decl (Result);
         end Allocate_Protected_Type_Decl;

      package Bare_Task_Type_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Task_Type_Decl, Token_Index);

         
         subtype Subtype_For_Task_Type_Decl is
            Root_Node_Record (Ada_Task_Type_Decl);
         type Access_To_Subtype_For_Task_Type_Decl is access all Subtype_For_Task_Type_Decl;
         package Bare_Task_Type_Decl_Alloc is new Alloc
           (Subtype_For_Task_Type_Decl, Access_To_Subtype_For_Task_Type_Decl);

         function Allocate_Task_Type_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Task_Type_Decl;

         function Allocate_Task_Type_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Task_Type_Decl
         is
            Result      : constant Access_To_Subtype_For_Task_Type_Decl := Bare_Task_Type_Decl_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Task_Type_Decl;
            return Bare_Task_Type_Decl (Result);
         end Allocate_Task_Type_Decl;

      package Bare_Single_Task_Type_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Single_Task_Type_Decl, Token_Index);

         
         subtype Subtype_For_Single_Task_Type_Decl is
            Root_Node_Record (Ada_Single_Task_Type_Decl);
         type Access_To_Subtype_For_Single_Task_Type_Decl is access all Subtype_For_Single_Task_Type_Decl;
         package Bare_Single_Task_Type_Decl_Alloc is new Alloc
           (Subtype_For_Single_Task_Type_Decl, Access_To_Subtype_For_Single_Task_Type_Decl);

         function Allocate_Single_Task_Type_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Single_Task_Type_Decl;

         function Allocate_Single_Task_Type_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Single_Task_Type_Decl
         is
            Result      : constant Access_To_Subtype_For_Single_Task_Type_Decl := Bare_Single_Task_Type_Decl_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Single_Task_Type_Decl;
            return Bare_Single_Task_Type_Decl (Result);
         end Allocate_Single_Task_Type_Decl;

      package Bare_Type_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Type_Decl, Token_Index);

         
         subtype Subtype_For_Type_Decl is
            Root_Node_Record (Ada_Type_Decl);
         type Access_To_Subtype_For_Type_Decl is access all Subtype_For_Type_Decl;
         package Bare_Type_Decl_Alloc is new Alloc
           (Subtype_For_Type_Decl, Access_To_Subtype_For_Type_Decl);

         function Allocate_Type_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Type_Decl;

         function Allocate_Type_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Type_Decl
         is
            Result      : constant Access_To_Subtype_For_Type_Decl := Bare_Type_Decl_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Type_Decl;
            return Bare_Type_Decl (Result);
         end Allocate_Type_Decl;

      package Bare_Anonymous_Type_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Anonymous_Type_Decl, Token_Index);

         
         subtype Subtype_For_Anonymous_Type_Decl is
            Root_Node_Record (Ada_Anonymous_Type_Decl);
         type Access_To_Subtype_For_Anonymous_Type_Decl is access all Subtype_For_Anonymous_Type_Decl;
         package Bare_Anonymous_Type_Decl_Alloc is new Alloc
           (Subtype_For_Anonymous_Type_Decl, Access_To_Subtype_For_Anonymous_Type_Decl);

         function Allocate_Anonymous_Type_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Anonymous_Type_Decl;

         function Allocate_Anonymous_Type_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Anonymous_Type_Decl
         is
            Result      : constant Access_To_Subtype_For_Anonymous_Type_Decl := Bare_Anonymous_Type_Decl_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Anonymous_Type_Decl;
            return Bare_Anonymous_Type_Decl (Result);
         end Allocate_Anonymous_Type_Decl;

      package Bare_Synth_Anonymous_Type_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Synth_Anonymous_Type_Decl, Token_Index);

         
         subtype Subtype_For_Synth_Anonymous_Type_Decl is
            Root_Node_Record (Ada_Synth_Anonymous_Type_Decl);
         type Access_To_Subtype_For_Synth_Anonymous_Type_Decl is access all Subtype_For_Synth_Anonymous_Type_Decl;
         package Bare_Synth_Anonymous_Type_Decl_Alloc is new Alloc
           (Subtype_For_Synth_Anonymous_Type_Decl, Access_To_Subtype_For_Synth_Anonymous_Type_Decl);

         function Allocate_Synth_Anonymous_Type_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Synth_Anonymous_Type_Decl;

         function Allocate_Synth_Anonymous_Type_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Synth_Anonymous_Type_Decl
         is
            Result      : constant Access_To_Subtype_For_Synth_Anonymous_Type_Decl := Bare_Synth_Anonymous_Type_Decl_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Synth_Anonymous_Type_Decl;
            return Bare_Synth_Anonymous_Type_Decl (Result);
         end Allocate_Synth_Anonymous_Type_Decl;

      package Bare_Basic_Subp_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Basic_Subp_Decl, Token_Index);

      package Bare_Classic_Subp_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Classic_Subp_Decl, Token_Index);

      package Bare_Abstract_Subp_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Abstract_Subp_Decl, Token_Index);

         
         subtype Subtype_For_Abstract_Subp_Decl is
            Root_Node_Record (Ada_Abstract_Subp_Decl);
         type Access_To_Subtype_For_Abstract_Subp_Decl is access all Subtype_For_Abstract_Subp_Decl;
         package Bare_Abstract_Subp_Decl_Alloc is new Alloc
           (Subtype_For_Abstract_Subp_Decl, Access_To_Subtype_For_Abstract_Subp_Decl);

         function Allocate_Abstract_Subp_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Abstract_Subp_Decl;

         function Allocate_Abstract_Subp_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Abstract_Subp_Decl
         is
            Result      : constant Access_To_Subtype_For_Abstract_Subp_Decl := Bare_Abstract_Subp_Decl_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Abstract_Subp_Decl;
            return Bare_Abstract_Subp_Decl (Result);
         end Allocate_Abstract_Subp_Decl;

      package Bare_Formal_Subp_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Formal_Subp_Decl, Token_Index);

      package Bare_Abstract_Formal_Subp_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Abstract_Formal_Subp_Decl, Token_Index);

         
         subtype Subtype_For_Abstract_Formal_Subp_Decl is
            Root_Node_Record (Ada_Abstract_Formal_Subp_Decl);
         type Access_To_Subtype_For_Abstract_Formal_Subp_Decl is access all Subtype_For_Abstract_Formal_Subp_Decl;
         package Bare_Abstract_Formal_Subp_Decl_Alloc is new Alloc
           (Subtype_For_Abstract_Formal_Subp_Decl, Access_To_Subtype_For_Abstract_Formal_Subp_Decl);

         function Allocate_Abstract_Formal_Subp_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Abstract_Formal_Subp_Decl;

         function Allocate_Abstract_Formal_Subp_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Abstract_Formal_Subp_Decl
         is
            Result      : constant Access_To_Subtype_For_Abstract_Formal_Subp_Decl := Bare_Abstract_Formal_Subp_Decl_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Abstract_Formal_Subp_Decl;
            return Bare_Abstract_Formal_Subp_Decl (Result);
         end Allocate_Abstract_Formal_Subp_Decl;

      package Bare_Concrete_Formal_Subp_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Concrete_Formal_Subp_Decl, Token_Index);

         
         subtype Subtype_For_Concrete_Formal_Subp_Decl is
            Root_Node_Record (Ada_Concrete_Formal_Subp_Decl);
         type Access_To_Subtype_For_Concrete_Formal_Subp_Decl is access all Subtype_For_Concrete_Formal_Subp_Decl;
         package Bare_Concrete_Formal_Subp_Decl_Alloc is new Alloc
           (Subtype_For_Concrete_Formal_Subp_Decl, Access_To_Subtype_For_Concrete_Formal_Subp_Decl);

         function Allocate_Concrete_Formal_Subp_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Concrete_Formal_Subp_Decl;

         function Allocate_Concrete_Formal_Subp_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Concrete_Formal_Subp_Decl
         is
            Result      : constant Access_To_Subtype_For_Concrete_Formal_Subp_Decl := Bare_Concrete_Formal_Subp_Decl_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Concrete_Formal_Subp_Decl;
            return Bare_Concrete_Formal_Subp_Decl (Result);
         end Allocate_Concrete_Formal_Subp_Decl;

      package Bare_Subp_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Subp_Decl, Token_Index);

         
         subtype Subtype_For_Subp_Decl is
            Root_Node_Record (Ada_Subp_Decl);
         type Access_To_Subtype_For_Subp_Decl is access all Subtype_For_Subp_Decl;
         package Bare_Subp_Decl_Alloc is new Alloc
           (Subtype_For_Subp_Decl, Access_To_Subtype_For_Subp_Decl);

         function Allocate_Subp_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Subp_Decl;

         function Allocate_Subp_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Subp_Decl
         is
            Result      : constant Access_To_Subtype_For_Subp_Decl := Bare_Subp_Decl_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Subp_Decl;
            return Bare_Subp_Decl (Result);
         end Allocate_Subp_Decl;

      package Bare_Entry_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Entry_Decl, Token_Index);

         
         subtype Subtype_For_Entry_Decl is
            Root_Node_Record (Ada_Entry_Decl);
         type Access_To_Subtype_For_Entry_Decl is access all Subtype_For_Entry_Decl;
         package Bare_Entry_Decl_Alloc is new Alloc
           (Subtype_For_Entry_Decl, Access_To_Subtype_For_Entry_Decl);

         function Allocate_Entry_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Entry_Decl;

         function Allocate_Entry_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Entry_Decl
         is
            Result      : constant Access_To_Subtype_For_Entry_Decl := Bare_Entry_Decl_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Entry_Decl;
            return Bare_Entry_Decl (Result);
         end Allocate_Entry_Decl;

      package Bare_Enum_Literal_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Enum_Literal_Decl, Token_Index);

         
         subtype Subtype_For_Enum_Literal_Decl is
            Root_Node_Record (Ada_Enum_Literal_Decl);
         type Access_To_Subtype_For_Enum_Literal_Decl is access all Subtype_For_Enum_Literal_Decl;
         package Bare_Enum_Literal_Decl_Alloc is new Alloc
           (Subtype_For_Enum_Literal_Decl, Access_To_Subtype_For_Enum_Literal_Decl);

         function Allocate_Enum_Literal_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Enum_Literal_Decl;

         function Allocate_Enum_Literal_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Enum_Literal_Decl
         is
            Result      : constant Access_To_Subtype_For_Enum_Literal_Decl := Bare_Enum_Literal_Decl_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Enum_Literal_Decl;
            return Bare_Enum_Literal_Decl (Result);
         end Allocate_Enum_Literal_Decl;

      package Bare_Generic_Subp_Internal_Memos is new Langkit_Support.Packrat
        (Bare_Generic_Subp_Internal, Token_Index);

         
         subtype Subtype_For_Generic_Subp_Internal is
            Root_Node_Record (Ada_Generic_Subp_Internal);
         type Access_To_Subtype_For_Generic_Subp_Internal is access all Subtype_For_Generic_Subp_Internal;
         package Bare_Generic_Subp_Internal_Alloc is new Alloc
           (Subtype_For_Generic_Subp_Internal, Access_To_Subtype_For_Generic_Subp_Internal);

         function Allocate_Generic_Subp_Internal
           (Pool : Bump_Ptr_Pool) return Bare_Generic_Subp_Internal;

         function Allocate_Generic_Subp_Internal
           (Pool : Bump_Ptr_Pool) return Bare_Generic_Subp_Internal
         is
            Result      : constant Access_To_Subtype_For_Generic_Subp_Internal := Bare_Generic_Subp_Internal_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Generic_Subp_Internal;
            return Bare_Generic_Subp_Internal (Result);
         end Allocate_Generic_Subp_Internal;

      package Bare_Body_Node_Memos is new Langkit_Support.Packrat
        (Bare_Body_Node, Token_Index);

      package Bare_Base_Subp_Body_Memos is new Langkit_Support.Packrat
        (Bare_Base_Subp_Body, Token_Index);

      package Bare_Expr_Function_Memos is new Langkit_Support.Packrat
        (Bare_Expr_Function, Token_Index);

         
         subtype Subtype_For_Expr_Function is
            Root_Node_Record (Ada_Expr_Function);
         type Access_To_Subtype_For_Expr_Function is access all Subtype_For_Expr_Function;
         package Bare_Expr_Function_Alloc is new Alloc
           (Subtype_For_Expr_Function, Access_To_Subtype_For_Expr_Function);

         function Allocate_Expr_Function
           (Pool : Bump_Ptr_Pool) return Bare_Expr_Function;

         function Allocate_Expr_Function
           (Pool : Bump_Ptr_Pool) return Bare_Expr_Function
         is
            Result      : constant Access_To_Subtype_For_Expr_Function := Bare_Expr_Function_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Expr_Function;
            return Bare_Expr_Function (Result);
         end Allocate_Expr_Function;

      package Bare_Null_Subp_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Null_Subp_Decl, Token_Index);

         
         subtype Subtype_For_Null_Subp_Decl is
            Root_Node_Record (Ada_Null_Subp_Decl);
         type Access_To_Subtype_For_Null_Subp_Decl is access all Subtype_For_Null_Subp_Decl;
         package Bare_Null_Subp_Decl_Alloc is new Alloc
           (Subtype_For_Null_Subp_Decl, Access_To_Subtype_For_Null_Subp_Decl);

         function Allocate_Null_Subp_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Null_Subp_Decl;

         function Allocate_Null_Subp_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Null_Subp_Decl
         is
            Result      : constant Access_To_Subtype_For_Null_Subp_Decl := Bare_Null_Subp_Decl_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Null_Subp_Decl;
            return Bare_Null_Subp_Decl (Result);
         end Allocate_Null_Subp_Decl;

      package Bare_Subp_Body_Memos is new Langkit_Support.Packrat
        (Bare_Subp_Body, Token_Index);

         
         subtype Subtype_For_Subp_Body is
            Root_Node_Record (Ada_Subp_Body);
         type Access_To_Subtype_For_Subp_Body is access all Subtype_For_Subp_Body;
         package Bare_Subp_Body_Alloc is new Alloc
           (Subtype_For_Subp_Body, Access_To_Subtype_For_Subp_Body);

         function Allocate_Subp_Body
           (Pool : Bump_Ptr_Pool) return Bare_Subp_Body;

         function Allocate_Subp_Body
           (Pool : Bump_Ptr_Pool) return Bare_Subp_Body
         is
            Result      : constant Access_To_Subtype_For_Subp_Body := Bare_Subp_Body_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Subp_Body;
            return Bare_Subp_Body (Result);
         end Allocate_Subp_Body;

      package Bare_Subp_Renaming_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Subp_Renaming_Decl, Token_Index);

         
         subtype Subtype_For_Subp_Renaming_Decl is
            Root_Node_Record (Ada_Subp_Renaming_Decl);
         type Access_To_Subtype_For_Subp_Renaming_Decl is access all Subtype_For_Subp_Renaming_Decl;
         package Bare_Subp_Renaming_Decl_Alloc is new Alloc
           (Subtype_For_Subp_Renaming_Decl, Access_To_Subtype_For_Subp_Renaming_Decl);

         function Allocate_Subp_Renaming_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Subp_Renaming_Decl;

         function Allocate_Subp_Renaming_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Subp_Renaming_Decl
         is
            Result      : constant Access_To_Subtype_For_Subp_Renaming_Decl := Bare_Subp_Renaming_Decl_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Subp_Renaming_Decl;
            return Bare_Subp_Renaming_Decl (Result);
         end Allocate_Subp_Renaming_Decl;

      package Bare_Body_Stub_Memos is new Langkit_Support.Packrat
        (Bare_Body_Stub, Token_Index);

      package Bare_Package_Body_Stub_Memos is new Langkit_Support.Packrat
        (Bare_Package_Body_Stub, Token_Index);

         
         subtype Subtype_For_Package_Body_Stub is
            Root_Node_Record (Ada_Package_Body_Stub);
         type Access_To_Subtype_For_Package_Body_Stub is access all Subtype_For_Package_Body_Stub;
         package Bare_Package_Body_Stub_Alloc is new Alloc
           (Subtype_For_Package_Body_Stub, Access_To_Subtype_For_Package_Body_Stub);

         function Allocate_Package_Body_Stub
           (Pool : Bump_Ptr_Pool) return Bare_Package_Body_Stub;

         function Allocate_Package_Body_Stub
           (Pool : Bump_Ptr_Pool) return Bare_Package_Body_Stub
         is
            Result      : constant Access_To_Subtype_For_Package_Body_Stub := Bare_Package_Body_Stub_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Package_Body_Stub;
            return Bare_Package_Body_Stub (Result);
         end Allocate_Package_Body_Stub;

      package Bare_Protected_Body_Stub_Memos is new Langkit_Support.Packrat
        (Bare_Protected_Body_Stub, Token_Index);

         
         subtype Subtype_For_Protected_Body_Stub is
            Root_Node_Record (Ada_Protected_Body_Stub);
         type Access_To_Subtype_For_Protected_Body_Stub is access all Subtype_For_Protected_Body_Stub;
         package Bare_Protected_Body_Stub_Alloc is new Alloc
           (Subtype_For_Protected_Body_Stub, Access_To_Subtype_For_Protected_Body_Stub);

         function Allocate_Protected_Body_Stub
           (Pool : Bump_Ptr_Pool) return Bare_Protected_Body_Stub;

         function Allocate_Protected_Body_Stub
           (Pool : Bump_Ptr_Pool) return Bare_Protected_Body_Stub
         is
            Result      : constant Access_To_Subtype_For_Protected_Body_Stub := Bare_Protected_Body_Stub_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Protected_Body_Stub;
            return Bare_Protected_Body_Stub (Result);
         end Allocate_Protected_Body_Stub;

      package Bare_Subp_Body_Stub_Memos is new Langkit_Support.Packrat
        (Bare_Subp_Body_Stub, Token_Index);

         
         subtype Subtype_For_Subp_Body_Stub is
            Root_Node_Record (Ada_Subp_Body_Stub);
         type Access_To_Subtype_For_Subp_Body_Stub is access all Subtype_For_Subp_Body_Stub;
         package Bare_Subp_Body_Stub_Alloc is new Alloc
           (Subtype_For_Subp_Body_Stub, Access_To_Subtype_For_Subp_Body_Stub);

         function Allocate_Subp_Body_Stub
           (Pool : Bump_Ptr_Pool) return Bare_Subp_Body_Stub;

         function Allocate_Subp_Body_Stub
           (Pool : Bump_Ptr_Pool) return Bare_Subp_Body_Stub
         is
            Result      : constant Access_To_Subtype_For_Subp_Body_Stub := Bare_Subp_Body_Stub_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Subp_Body_Stub;
            return Bare_Subp_Body_Stub (Result);
         end Allocate_Subp_Body_Stub;

      package Bare_Task_Body_Stub_Memos is new Langkit_Support.Packrat
        (Bare_Task_Body_Stub, Token_Index);

         
         subtype Subtype_For_Task_Body_Stub is
            Root_Node_Record (Ada_Task_Body_Stub);
         type Access_To_Subtype_For_Task_Body_Stub is access all Subtype_For_Task_Body_Stub;
         package Bare_Task_Body_Stub_Alloc is new Alloc
           (Subtype_For_Task_Body_Stub, Access_To_Subtype_For_Task_Body_Stub);

         function Allocate_Task_Body_Stub
           (Pool : Bump_Ptr_Pool) return Bare_Task_Body_Stub;

         function Allocate_Task_Body_Stub
           (Pool : Bump_Ptr_Pool) return Bare_Task_Body_Stub
         is
            Result      : constant Access_To_Subtype_For_Task_Body_Stub := Bare_Task_Body_Stub_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Task_Body_Stub;
            return Bare_Task_Body_Stub (Result);
         end Allocate_Task_Body_Stub;

      package Bare_Entry_Body_Memos is new Langkit_Support.Packrat
        (Bare_Entry_Body, Token_Index);

         
         subtype Subtype_For_Entry_Body is
            Root_Node_Record (Ada_Entry_Body);
         type Access_To_Subtype_For_Entry_Body is access all Subtype_For_Entry_Body;
         package Bare_Entry_Body_Alloc is new Alloc
           (Subtype_For_Entry_Body, Access_To_Subtype_For_Entry_Body);

         function Allocate_Entry_Body
           (Pool : Bump_Ptr_Pool) return Bare_Entry_Body;

         function Allocate_Entry_Body
           (Pool : Bump_Ptr_Pool) return Bare_Entry_Body
         is
            Result      : constant Access_To_Subtype_For_Entry_Body := Bare_Entry_Body_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Entry_Body;
            return Bare_Entry_Body (Result);
         end Allocate_Entry_Body;

      package Bare_Package_Body_Memos is new Langkit_Support.Packrat
        (Bare_Package_Body, Token_Index);

         
         subtype Subtype_For_Package_Body is
            Root_Node_Record (Ada_Package_Body);
         type Access_To_Subtype_For_Package_Body is access all Subtype_For_Package_Body;
         package Bare_Package_Body_Alloc is new Alloc
           (Subtype_For_Package_Body, Access_To_Subtype_For_Package_Body);

         function Allocate_Package_Body
           (Pool : Bump_Ptr_Pool) return Bare_Package_Body;

         function Allocate_Package_Body
           (Pool : Bump_Ptr_Pool) return Bare_Package_Body
         is
            Result      : constant Access_To_Subtype_For_Package_Body := Bare_Package_Body_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Package_Body;
            return Bare_Package_Body (Result);
         end Allocate_Package_Body;

      package Bare_Protected_Body_Memos is new Langkit_Support.Packrat
        (Bare_Protected_Body, Token_Index);

         
         subtype Subtype_For_Protected_Body is
            Root_Node_Record (Ada_Protected_Body);
         type Access_To_Subtype_For_Protected_Body is access all Subtype_For_Protected_Body;
         package Bare_Protected_Body_Alloc is new Alloc
           (Subtype_For_Protected_Body, Access_To_Subtype_For_Protected_Body);

         function Allocate_Protected_Body
           (Pool : Bump_Ptr_Pool) return Bare_Protected_Body;

         function Allocate_Protected_Body
           (Pool : Bump_Ptr_Pool) return Bare_Protected_Body
         is
            Result      : constant Access_To_Subtype_For_Protected_Body := Bare_Protected_Body_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Protected_Body;
            return Bare_Protected_Body (Result);
         end Allocate_Protected_Body;

      package Bare_Task_Body_Memos is new Langkit_Support.Packrat
        (Bare_Task_Body, Token_Index);

         
         subtype Subtype_For_Task_Body is
            Root_Node_Record (Ada_Task_Body);
         type Access_To_Subtype_For_Task_Body is access all Subtype_For_Task_Body;
         package Bare_Task_Body_Alloc is new Alloc
           (Subtype_For_Task_Body, Access_To_Subtype_For_Task_Body);

         function Allocate_Task_Body
           (Pool : Bump_Ptr_Pool) return Bare_Task_Body;

         function Allocate_Task_Body
           (Pool : Bump_Ptr_Pool) return Bare_Task_Body
         is
            Result      : constant Access_To_Subtype_For_Task_Body := Bare_Task_Body_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Task_Body;
            return Bare_Task_Body (Result);
         end Allocate_Task_Body;

      package Bare_Entry_Index_Spec_Memos is new Langkit_Support.Packrat
        (Bare_Entry_Index_Spec, Token_Index);

         
         subtype Subtype_For_Entry_Index_Spec is
            Root_Node_Record (Ada_Entry_Index_Spec);
         type Access_To_Subtype_For_Entry_Index_Spec is access all Subtype_For_Entry_Index_Spec;
         package Bare_Entry_Index_Spec_Alloc is new Alloc
           (Subtype_For_Entry_Index_Spec, Access_To_Subtype_For_Entry_Index_Spec);

         function Allocate_Entry_Index_Spec
           (Pool : Bump_Ptr_Pool) return Bare_Entry_Index_Spec;

         function Allocate_Entry_Index_Spec
           (Pool : Bump_Ptr_Pool) return Bare_Entry_Index_Spec
         is
            Result      : constant Access_To_Subtype_For_Entry_Index_Spec := Bare_Entry_Index_Spec_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Entry_Index_Spec;
            return Bare_Entry_Index_Spec (Result);
         end Allocate_Entry_Index_Spec;

      package Bare_Error_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Error_Decl, Token_Index);

         
         subtype Subtype_For_Error_Decl is
            Root_Node_Record (Ada_Error_Decl);
         type Access_To_Subtype_For_Error_Decl is access all Subtype_For_Error_Decl;
         package Bare_Error_Decl_Alloc is new Alloc
           (Subtype_For_Error_Decl, Access_To_Subtype_For_Error_Decl);

         function Allocate_Error_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Error_Decl;

         function Allocate_Error_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Error_Decl
         is
            Result      : constant Access_To_Subtype_For_Error_Decl := Bare_Error_Decl_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Error_Decl;
            return Bare_Error_Decl (Result);
         end Allocate_Error_Decl;

      package Bare_Exception_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Exception_Decl, Token_Index);

         
         subtype Subtype_For_Exception_Decl is
            Root_Node_Record (Ada_Exception_Decl);
         type Access_To_Subtype_For_Exception_Decl is access all Subtype_For_Exception_Decl;
         package Bare_Exception_Decl_Alloc is new Alloc
           (Subtype_For_Exception_Decl, Access_To_Subtype_For_Exception_Decl);

         function Allocate_Exception_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Exception_Decl;

         function Allocate_Exception_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Exception_Decl
         is
            Result      : constant Access_To_Subtype_For_Exception_Decl := Bare_Exception_Decl_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Exception_Decl;
            return Bare_Exception_Decl (Result);
         end Allocate_Exception_Decl;

      package Bare_Exception_Handler_Memos is new Langkit_Support.Packrat
        (Bare_Exception_Handler, Token_Index);

         
         subtype Subtype_For_Exception_Handler is
            Root_Node_Record (Ada_Exception_Handler);
         type Access_To_Subtype_For_Exception_Handler is access all Subtype_For_Exception_Handler;
         package Bare_Exception_Handler_Alloc is new Alloc
           (Subtype_For_Exception_Handler, Access_To_Subtype_For_Exception_Handler);

         function Allocate_Exception_Handler
           (Pool : Bump_Ptr_Pool) return Bare_Exception_Handler;

         function Allocate_Exception_Handler
           (Pool : Bump_Ptr_Pool) return Bare_Exception_Handler
         is
            Result      : constant Access_To_Subtype_For_Exception_Handler := Bare_Exception_Handler_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Exception_Handler;
            return Bare_Exception_Handler (Result);
         end Allocate_Exception_Handler;

      package Bare_For_Loop_Var_Decl_Memos is new Langkit_Support.Packrat
        (Bare_For_Loop_Var_Decl, Token_Index);

         
         subtype Subtype_For_For_Loop_Var_Decl is
            Root_Node_Record (Ada_For_Loop_Var_Decl);
         type Access_To_Subtype_For_For_Loop_Var_Decl is access all Subtype_For_For_Loop_Var_Decl;
         package Bare_For_Loop_Var_Decl_Alloc is new Alloc
           (Subtype_For_For_Loop_Var_Decl, Access_To_Subtype_For_For_Loop_Var_Decl);

         function Allocate_For_Loop_Var_Decl
           (Pool : Bump_Ptr_Pool) return Bare_For_Loop_Var_Decl;

         function Allocate_For_Loop_Var_Decl
           (Pool : Bump_Ptr_Pool) return Bare_For_Loop_Var_Decl
         is
            Result      : constant Access_To_Subtype_For_For_Loop_Var_Decl := Bare_For_Loop_Var_Decl_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_For_Loop_Var_Decl;
            return Bare_For_Loop_Var_Decl (Result);
         end Allocate_For_Loop_Var_Decl;

      package Bare_Generic_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Generic_Decl, Token_Index);

      package Bare_Generic_Package_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Generic_Package_Decl, Token_Index);

         
         subtype Subtype_For_Generic_Package_Decl is
            Root_Node_Record (Ada_Generic_Package_Decl);
         type Access_To_Subtype_For_Generic_Package_Decl is access all Subtype_For_Generic_Package_Decl;
         package Bare_Generic_Package_Decl_Alloc is new Alloc
           (Subtype_For_Generic_Package_Decl, Access_To_Subtype_For_Generic_Package_Decl);

         function Allocate_Generic_Package_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Generic_Package_Decl;

         function Allocate_Generic_Package_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Generic_Package_Decl
         is
            Result      : constant Access_To_Subtype_For_Generic_Package_Decl := Bare_Generic_Package_Decl_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Generic_Package_Decl;
            return Bare_Generic_Package_Decl (Result);
         end Allocate_Generic_Package_Decl;

      package Bare_Generic_Subp_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Generic_Subp_Decl, Token_Index);

         
         subtype Subtype_For_Generic_Subp_Decl is
            Root_Node_Record (Ada_Generic_Subp_Decl);
         type Access_To_Subtype_For_Generic_Subp_Decl is access all Subtype_For_Generic_Subp_Decl;
         package Bare_Generic_Subp_Decl_Alloc is new Alloc
           (Subtype_For_Generic_Subp_Decl, Access_To_Subtype_For_Generic_Subp_Decl);

         function Allocate_Generic_Subp_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Generic_Subp_Decl;

         function Allocate_Generic_Subp_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Generic_Subp_Decl
         is
            Result      : constant Access_To_Subtype_For_Generic_Subp_Decl := Bare_Generic_Subp_Decl_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Generic_Subp_Decl;
            return Bare_Generic_Subp_Decl (Result);
         end Allocate_Generic_Subp_Decl;

      package Bare_Generic_Instantiation_Memos is new Langkit_Support.Packrat
        (Bare_Generic_Instantiation, Token_Index);

      package Bare_Generic_Package_Instantiation_Memos is new Langkit_Support.Packrat
        (Bare_Generic_Package_Instantiation, Token_Index);

         
         subtype Subtype_For_Generic_Package_Instantiation is
            Root_Node_Record (Ada_Generic_Package_Instantiation);
         type Access_To_Subtype_For_Generic_Package_Instantiation is access all Subtype_For_Generic_Package_Instantiation;
         package Bare_Generic_Package_Instantiation_Alloc is new Alloc
           (Subtype_For_Generic_Package_Instantiation, Access_To_Subtype_For_Generic_Package_Instantiation);

         function Allocate_Generic_Package_Instantiation
           (Pool : Bump_Ptr_Pool) return Bare_Generic_Package_Instantiation;

         function Allocate_Generic_Package_Instantiation
           (Pool : Bump_Ptr_Pool) return Bare_Generic_Package_Instantiation
         is
            Result      : constant Access_To_Subtype_For_Generic_Package_Instantiation := Bare_Generic_Package_Instantiation_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Generic_Package_Instantiation;
            return Bare_Generic_Package_Instantiation (Result);
         end Allocate_Generic_Package_Instantiation;

      package Bare_Generic_Subp_Instantiation_Memos is new Langkit_Support.Packrat
        (Bare_Generic_Subp_Instantiation, Token_Index);

         
         subtype Subtype_For_Generic_Subp_Instantiation is
            Root_Node_Record (Ada_Generic_Subp_Instantiation);
         type Access_To_Subtype_For_Generic_Subp_Instantiation is access all Subtype_For_Generic_Subp_Instantiation;
         package Bare_Generic_Subp_Instantiation_Alloc is new Alloc
           (Subtype_For_Generic_Subp_Instantiation, Access_To_Subtype_For_Generic_Subp_Instantiation);

         function Allocate_Generic_Subp_Instantiation
           (Pool : Bump_Ptr_Pool) return Bare_Generic_Subp_Instantiation;

         function Allocate_Generic_Subp_Instantiation
           (Pool : Bump_Ptr_Pool) return Bare_Generic_Subp_Instantiation
         is
            Result      : constant Access_To_Subtype_For_Generic_Subp_Instantiation := Bare_Generic_Subp_Instantiation_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Generic_Subp_Instantiation;
            return Bare_Generic_Subp_Instantiation (Result);
         end Allocate_Generic_Subp_Instantiation;

      package Bare_Generic_Renaming_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Generic_Renaming_Decl, Token_Index);

      package Bare_Generic_Package_Renaming_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Generic_Package_Renaming_Decl, Token_Index);

         
         subtype Subtype_For_Generic_Package_Renaming_Decl is
            Root_Node_Record (Ada_Generic_Package_Renaming_Decl);
         type Access_To_Subtype_For_Generic_Package_Renaming_Decl is access all Subtype_For_Generic_Package_Renaming_Decl;
         package Bare_Generic_Package_Renaming_Decl_Alloc is new Alloc
           (Subtype_For_Generic_Package_Renaming_Decl, Access_To_Subtype_For_Generic_Package_Renaming_Decl);

         function Allocate_Generic_Package_Renaming_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Generic_Package_Renaming_Decl;

         function Allocate_Generic_Package_Renaming_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Generic_Package_Renaming_Decl
         is
            Result      : constant Access_To_Subtype_For_Generic_Package_Renaming_Decl := Bare_Generic_Package_Renaming_Decl_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Generic_Package_Renaming_Decl;
            return Bare_Generic_Package_Renaming_Decl (Result);
         end Allocate_Generic_Package_Renaming_Decl;

      package Bare_Generic_Subp_Renaming_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Generic_Subp_Renaming_Decl, Token_Index);

         
         subtype Subtype_For_Generic_Subp_Renaming_Decl is
            Root_Node_Record (Ada_Generic_Subp_Renaming_Decl);
         type Access_To_Subtype_For_Generic_Subp_Renaming_Decl is access all Subtype_For_Generic_Subp_Renaming_Decl;
         package Bare_Generic_Subp_Renaming_Decl_Alloc is new Alloc
           (Subtype_For_Generic_Subp_Renaming_Decl, Access_To_Subtype_For_Generic_Subp_Renaming_Decl);

         function Allocate_Generic_Subp_Renaming_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Generic_Subp_Renaming_Decl;

         function Allocate_Generic_Subp_Renaming_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Generic_Subp_Renaming_Decl
         is
            Result      : constant Access_To_Subtype_For_Generic_Subp_Renaming_Decl := Bare_Generic_Subp_Renaming_Decl_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Generic_Subp_Renaming_Decl;
            return Bare_Generic_Subp_Renaming_Decl (Result);
         end Allocate_Generic_Subp_Renaming_Decl;

      package Bare_Label_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Label_Decl, Token_Index);

         
         subtype Subtype_For_Label_Decl is
            Root_Node_Record (Ada_Label_Decl);
         type Access_To_Subtype_For_Label_Decl is access all Subtype_For_Label_Decl;
         package Bare_Label_Decl_Alloc is new Alloc
           (Subtype_For_Label_Decl, Access_To_Subtype_For_Label_Decl);

         function Allocate_Label_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Label_Decl;

         function Allocate_Label_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Label_Decl
         is
            Result      : constant Access_To_Subtype_For_Label_Decl := Bare_Label_Decl_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Label_Decl;
            return Bare_Label_Decl (Result);
         end Allocate_Label_Decl;

      package Bare_Named_Stmt_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Named_Stmt_Decl, Token_Index);

         
         subtype Subtype_For_Named_Stmt_Decl is
            Root_Node_Record (Ada_Named_Stmt_Decl);
         type Access_To_Subtype_For_Named_Stmt_Decl is access all Subtype_For_Named_Stmt_Decl;
         package Bare_Named_Stmt_Decl_Alloc is new Alloc
           (Subtype_For_Named_Stmt_Decl, Access_To_Subtype_For_Named_Stmt_Decl);

         function Allocate_Named_Stmt_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Named_Stmt_Decl;

         function Allocate_Named_Stmt_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Named_Stmt_Decl
         is
            Result      : constant Access_To_Subtype_For_Named_Stmt_Decl := Bare_Named_Stmt_Decl_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Named_Stmt_Decl;
            return Bare_Named_Stmt_Decl (Result);
         end Allocate_Named_Stmt_Decl;

      package Bare_Number_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Number_Decl, Token_Index);

         
         subtype Subtype_For_Number_Decl is
            Root_Node_Record (Ada_Number_Decl);
         type Access_To_Subtype_For_Number_Decl is access all Subtype_For_Number_Decl;
         package Bare_Number_Decl_Alloc is new Alloc
           (Subtype_For_Number_Decl, Access_To_Subtype_For_Number_Decl);

         function Allocate_Number_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Number_Decl;

         function Allocate_Number_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Number_Decl
         is
            Result      : constant Access_To_Subtype_For_Number_Decl := Bare_Number_Decl_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Number_Decl;
            return Bare_Number_Decl (Result);
         end Allocate_Number_Decl;

      package Bare_Object_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Object_Decl, Token_Index);

         
         subtype Subtype_For_Object_Decl is
            Root_Node_Record (Ada_Object_Decl);
         type Access_To_Subtype_For_Object_Decl is access all Subtype_For_Object_Decl;
         package Bare_Object_Decl_Alloc is new Alloc
           (Subtype_For_Object_Decl, Access_To_Subtype_For_Object_Decl);

         function Allocate_Object_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Object_Decl;

         function Allocate_Object_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Object_Decl
         is
            Result      : constant Access_To_Subtype_For_Object_Decl := Bare_Object_Decl_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Object_Decl;
            return Bare_Object_Decl (Result);
         end Allocate_Object_Decl;

      package Bare_Anonymous_Object_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Anonymous_Object_Decl, Token_Index);

         
         subtype Subtype_For_Anonymous_Object_Decl is
            Root_Node_Record (Ada_Anonymous_Object_Decl);
         type Access_To_Subtype_For_Anonymous_Object_Decl is access all Subtype_For_Anonymous_Object_Decl;
         package Bare_Anonymous_Object_Decl_Alloc is new Alloc
           (Subtype_For_Anonymous_Object_Decl, Access_To_Subtype_For_Anonymous_Object_Decl);

         function Allocate_Anonymous_Object_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Anonymous_Object_Decl;

         function Allocate_Anonymous_Object_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Anonymous_Object_Decl
         is
            Result      : constant Access_To_Subtype_For_Anonymous_Object_Decl := Bare_Anonymous_Object_Decl_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Anonymous_Object_Decl;
            return Bare_Anonymous_Object_Decl (Result);
         end Allocate_Anonymous_Object_Decl;

      package Bare_Extended_Return_Stmt_Object_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Extended_Return_Stmt_Object_Decl, Token_Index);

         
         subtype Subtype_For_Extended_Return_Stmt_Object_Decl is
            Root_Node_Record (Ada_Extended_Return_Stmt_Object_Decl);
         type Access_To_Subtype_For_Extended_Return_Stmt_Object_Decl is access all Subtype_For_Extended_Return_Stmt_Object_Decl;
         package Bare_Extended_Return_Stmt_Object_Decl_Alloc is new Alloc
           (Subtype_For_Extended_Return_Stmt_Object_Decl, Access_To_Subtype_For_Extended_Return_Stmt_Object_Decl);

         function Allocate_Extended_Return_Stmt_Object_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Extended_Return_Stmt_Object_Decl;

         function Allocate_Extended_Return_Stmt_Object_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Extended_Return_Stmt_Object_Decl
         is
            Result      : constant Access_To_Subtype_For_Extended_Return_Stmt_Object_Decl := Bare_Extended_Return_Stmt_Object_Decl_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Extended_Return_Stmt_Object_Decl;
            return Bare_Extended_Return_Stmt_Object_Decl (Result);
         end Allocate_Extended_Return_Stmt_Object_Decl;

      package Bare_Package_Renaming_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Package_Renaming_Decl, Token_Index);

         
         subtype Subtype_For_Package_Renaming_Decl is
            Root_Node_Record (Ada_Package_Renaming_Decl);
         type Access_To_Subtype_For_Package_Renaming_Decl is access all Subtype_For_Package_Renaming_Decl;
         package Bare_Package_Renaming_Decl_Alloc is new Alloc
           (Subtype_For_Package_Renaming_Decl, Access_To_Subtype_For_Package_Renaming_Decl);

         function Allocate_Package_Renaming_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Package_Renaming_Decl;

         function Allocate_Package_Renaming_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Package_Renaming_Decl
         is
            Result      : constant Access_To_Subtype_For_Package_Renaming_Decl := Bare_Package_Renaming_Decl_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Package_Renaming_Decl;
            return Bare_Package_Renaming_Decl (Result);
         end Allocate_Package_Renaming_Decl;

      package Bare_Single_Protected_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Single_Protected_Decl, Token_Index);

         
         subtype Subtype_For_Single_Protected_Decl is
            Root_Node_Record (Ada_Single_Protected_Decl);
         type Access_To_Subtype_For_Single_Protected_Decl is access all Subtype_For_Single_Protected_Decl;
         package Bare_Single_Protected_Decl_Alloc is new Alloc
           (Subtype_For_Single_Protected_Decl, Access_To_Subtype_For_Single_Protected_Decl);

         function Allocate_Single_Protected_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Single_Protected_Decl;

         function Allocate_Single_Protected_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Single_Protected_Decl
         is
            Result      : constant Access_To_Subtype_For_Single_Protected_Decl := Bare_Single_Protected_Decl_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Single_Protected_Decl;
            return Bare_Single_Protected_Decl (Result);
         end Allocate_Single_Protected_Decl;

      package Bare_Single_Task_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Single_Task_Decl, Token_Index);

         
         subtype Subtype_For_Single_Task_Decl is
            Root_Node_Record (Ada_Single_Task_Decl);
         type Access_To_Subtype_For_Single_Task_Decl is access all Subtype_For_Single_Task_Decl;
         package Bare_Single_Task_Decl_Alloc is new Alloc
           (Subtype_For_Single_Task_Decl, Access_To_Subtype_For_Single_Task_Decl);

         function Allocate_Single_Task_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Single_Task_Decl;

         function Allocate_Single_Task_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Single_Task_Decl
         is
            Result      : constant Access_To_Subtype_For_Single_Task_Decl := Bare_Single_Task_Decl_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Single_Task_Decl;
            return Bare_Single_Task_Decl (Result);
         end Allocate_Single_Task_Decl;

      package Bare_Case_Stmt_Alternative_Memos is new Langkit_Support.Packrat
        (Bare_Case_Stmt_Alternative, Token_Index);

         
         subtype Subtype_For_Case_Stmt_Alternative is
            Root_Node_Record (Ada_Case_Stmt_Alternative);
         type Access_To_Subtype_For_Case_Stmt_Alternative is access all Subtype_For_Case_Stmt_Alternative;
         package Bare_Case_Stmt_Alternative_Alloc is new Alloc
           (Subtype_For_Case_Stmt_Alternative, Access_To_Subtype_For_Case_Stmt_Alternative);

         function Allocate_Case_Stmt_Alternative
           (Pool : Bump_Ptr_Pool) return Bare_Case_Stmt_Alternative;

         function Allocate_Case_Stmt_Alternative
           (Pool : Bump_Ptr_Pool) return Bare_Case_Stmt_Alternative
         is
            Result      : constant Access_To_Subtype_For_Case_Stmt_Alternative := Bare_Case_Stmt_Alternative_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Case_Stmt_Alternative;
            return Bare_Case_Stmt_Alternative (Result);
         end Allocate_Case_Stmt_Alternative;

      package Bare_Compilation_Unit_Memos is new Langkit_Support.Packrat
        (Bare_Compilation_Unit, Token_Index);

         
         subtype Subtype_For_Compilation_Unit is
            Root_Node_Record (Ada_Compilation_Unit);
         type Access_To_Subtype_For_Compilation_Unit is access all Subtype_For_Compilation_Unit;
         package Bare_Compilation_Unit_Alloc is new Alloc
           (Subtype_For_Compilation_Unit, Access_To_Subtype_For_Compilation_Unit);

         function Allocate_Compilation_Unit
           (Pool : Bump_Ptr_Pool) return Bare_Compilation_Unit;

         function Allocate_Compilation_Unit
           (Pool : Bump_Ptr_Pool) return Bare_Compilation_Unit
         is
            Result      : constant Access_To_Subtype_For_Compilation_Unit := Bare_Compilation_Unit_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Compilation_Unit;
            return Bare_Compilation_Unit (Result);
         end Allocate_Compilation_Unit;

      package Bare_Component_Clause_Memos is new Langkit_Support.Packrat
        (Bare_Component_Clause, Token_Index);

         
         subtype Subtype_For_Component_Clause is
            Root_Node_Record (Ada_Component_Clause);
         type Access_To_Subtype_For_Component_Clause is access all Subtype_For_Component_Clause;
         package Bare_Component_Clause_Alloc is new Alloc
           (Subtype_For_Component_Clause, Access_To_Subtype_For_Component_Clause);

         function Allocate_Component_Clause
           (Pool : Bump_Ptr_Pool) return Bare_Component_Clause;

         function Allocate_Component_Clause
           (Pool : Bump_Ptr_Pool) return Bare_Component_Clause
         is
            Result      : constant Access_To_Subtype_For_Component_Clause := Bare_Component_Clause_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Component_Clause;
            return Bare_Component_Clause (Result);
         end Allocate_Component_Clause;

      package Bare_Component_Def_Memos is new Langkit_Support.Packrat
        (Bare_Component_Def, Token_Index);

         
         subtype Subtype_For_Component_Def is
            Root_Node_Record (Ada_Component_Def);
         type Access_To_Subtype_For_Component_Def is access all Subtype_For_Component_Def;
         package Bare_Component_Def_Alloc is new Alloc
           (Subtype_For_Component_Def, Access_To_Subtype_For_Component_Def);

         function Allocate_Component_Def
           (Pool : Bump_Ptr_Pool) return Bare_Component_Def;

         function Allocate_Component_Def
           (Pool : Bump_Ptr_Pool) return Bare_Component_Def
         is
            Result      : constant Access_To_Subtype_For_Component_Def := Bare_Component_Def_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Component_Def;
            return Bare_Component_Def (Result);
         end Allocate_Component_Def;

      package Bare_Constant_Node_Memos is new Langkit_Support.Packrat
        (Bare_Constant_Node, Token_Index);

      package Bare_Constant_Absent_Memos is new Langkit_Support.Packrat
        (Bare_Constant_Absent, Token_Index);

         
         subtype Subtype_For_Constant_Absent is
            Root_Node_Record (Ada_Constant_Absent);
         type Access_To_Subtype_For_Constant_Absent is access all Subtype_For_Constant_Absent;
         package Bare_Constant_Absent_Alloc is new Alloc
           (Subtype_For_Constant_Absent, Access_To_Subtype_For_Constant_Absent);

         function Allocate_Constant_Absent
           (Pool : Bump_Ptr_Pool) return Bare_Constant_Absent;

         function Allocate_Constant_Absent
           (Pool : Bump_Ptr_Pool) return Bare_Constant_Absent
         is
            Result      : constant Access_To_Subtype_For_Constant_Absent := Bare_Constant_Absent_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Constant_Absent;
            return Bare_Constant_Absent (Result);
         end Allocate_Constant_Absent;

      package Bare_Constant_Present_Memos is new Langkit_Support.Packrat
        (Bare_Constant_Present, Token_Index);

         
         subtype Subtype_For_Constant_Present is
            Root_Node_Record (Ada_Constant_Present);
         type Access_To_Subtype_For_Constant_Present is access all Subtype_For_Constant_Present;
         package Bare_Constant_Present_Alloc is new Alloc
           (Subtype_For_Constant_Present, Access_To_Subtype_For_Constant_Present);

         function Allocate_Constant_Present
           (Pool : Bump_Ptr_Pool) return Bare_Constant_Present;

         function Allocate_Constant_Present
           (Pool : Bump_Ptr_Pool) return Bare_Constant_Present
         is
            Result      : constant Access_To_Subtype_For_Constant_Present := Bare_Constant_Present_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Constant_Present;
            return Bare_Constant_Present (Result);
         end Allocate_Constant_Present;

      package Bare_Constraint_Memos is new Langkit_Support.Packrat
        (Bare_Constraint, Token_Index);

      package Bare_Delta_Constraint_Memos is new Langkit_Support.Packrat
        (Bare_Delta_Constraint, Token_Index);

         
         subtype Subtype_For_Delta_Constraint is
            Root_Node_Record (Ada_Delta_Constraint);
         type Access_To_Subtype_For_Delta_Constraint is access all Subtype_For_Delta_Constraint;
         package Bare_Delta_Constraint_Alloc is new Alloc
           (Subtype_For_Delta_Constraint, Access_To_Subtype_For_Delta_Constraint);

         function Allocate_Delta_Constraint
           (Pool : Bump_Ptr_Pool) return Bare_Delta_Constraint;

         function Allocate_Delta_Constraint
           (Pool : Bump_Ptr_Pool) return Bare_Delta_Constraint
         is
            Result      : constant Access_To_Subtype_For_Delta_Constraint := Bare_Delta_Constraint_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Delta_Constraint;
            return Bare_Delta_Constraint (Result);
         end Allocate_Delta_Constraint;

      package Bare_Digits_Constraint_Memos is new Langkit_Support.Packrat
        (Bare_Digits_Constraint, Token_Index);

         
         subtype Subtype_For_Digits_Constraint is
            Root_Node_Record (Ada_Digits_Constraint);
         type Access_To_Subtype_For_Digits_Constraint is access all Subtype_For_Digits_Constraint;
         package Bare_Digits_Constraint_Alloc is new Alloc
           (Subtype_For_Digits_Constraint, Access_To_Subtype_For_Digits_Constraint);

         function Allocate_Digits_Constraint
           (Pool : Bump_Ptr_Pool) return Bare_Digits_Constraint;

         function Allocate_Digits_Constraint
           (Pool : Bump_Ptr_Pool) return Bare_Digits_Constraint
         is
            Result      : constant Access_To_Subtype_For_Digits_Constraint := Bare_Digits_Constraint_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Digits_Constraint;
            return Bare_Digits_Constraint (Result);
         end Allocate_Digits_Constraint;

      package Bare_Discriminant_Constraint_Memos is new Langkit_Support.Packrat
        (Bare_Discriminant_Constraint, Token_Index);

         
         subtype Subtype_For_Discriminant_Constraint is
            Root_Node_Record (Ada_Discriminant_Constraint);
         type Access_To_Subtype_For_Discriminant_Constraint is access all Subtype_For_Discriminant_Constraint;
         package Bare_Discriminant_Constraint_Alloc is new Alloc
           (Subtype_For_Discriminant_Constraint, Access_To_Subtype_For_Discriminant_Constraint);

         function Allocate_Discriminant_Constraint
           (Pool : Bump_Ptr_Pool) return Bare_Discriminant_Constraint;

         function Allocate_Discriminant_Constraint
           (Pool : Bump_Ptr_Pool) return Bare_Discriminant_Constraint
         is
            Result      : constant Access_To_Subtype_For_Discriminant_Constraint := Bare_Discriminant_Constraint_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Discriminant_Constraint;
            return Bare_Discriminant_Constraint (Result);
         end Allocate_Discriminant_Constraint;

      package Bare_Index_Constraint_Memos is new Langkit_Support.Packrat
        (Bare_Index_Constraint, Token_Index);

         
         subtype Subtype_For_Index_Constraint is
            Root_Node_Record (Ada_Index_Constraint);
         type Access_To_Subtype_For_Index_Constraint is access all Subtype_For_Index_Constraint;
         package Bare_Index_Constraint_Alloc is new Alloc
           (Subtype_For_Index_Constraint, Access_To_Subtype_For_Index_Constraint);

         function Allocate_Index_Constraint
           (Pool : Bump_Ptr_Pool) return Bare_Index_Constraint;

         function Allocate_Index_Constraint
           (Pool : Bump_Ptr_Pool) return Bare_Index_Constraint
         is
            Result      : constant Access_To_Subtype_For_Index_Constraint := Bare_Index_Constraint_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Index_Constraint;
            return Bare_Index_Constraint (Result);
         end Allocate_Index_Constraint;

      package Bare_Range_Constraint_Memos is new Langkit_Support.Packrat
        (Bare_Range_Constraint, Token_Index);

         
         subtype Subtype_For_Range_Constraint is
            Root_Node_Record (Ada_Range_Constraint);
         type Access_To_Subtype_For_Range_Constraint is access all Subtype_For_Range_Constraint;
         package Bare_Range_Constraint_Alloc is new Alloc
           (Subtype_For_Range_Constraint, Access_To_Subtype_For_Range_Constraint);

         function Allocate_Range_Constraint
           (Pool : Bump_Ptr_Pool) return Bare_Range_Constraint;

         function Allocate_Range_Constraint
           (Pool : Bump_Ptr_Pool) return Bare_Range_Constraint
         is
            Result      : constant Access_To_Subtype_For_Range_Constraint := Bare_Range_Constraint_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Range_Constraint;
            return Bare_Range_Constraint (Result);
         end Allocate_Range_Constraint;

      package Bare_Declarative_Part_Memos is new Langkit_Support.Packrat
        (Bare_Declarative_Part, Token_Index);

         
         subtype Subtype_For_Declarative_Part is
            Root_Node_Record (Ada_Declarative_Part);
         type Access_To_Subtype_For_Declarative_Part is access all Subtype_For_Declarative_Part;
         package Bare_Declarative_Part_Alloc is new Alloc
           (Subtype_For_Declarative_Part, Access_To_Subtype_For_Declarative_Part);

         function Allocate_Declarative_Part
           (Pool : Bump_Ptr_Pool) return Bare_Declarative_Part;

         function Allocate_Declarative_Part
           (Pool : Bump_Ptr_Pool) return Bare_Declarative_Part
         is
            Result      : constant Access_To_Subtype_For_Declarative_Part := Bare_Declarative_Part_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Declarative_Part;
            return Bare_Declarative_Part (Result);
         end Allocate_Declarative_Part;

      package Bare_Private_Part_Memos is new Langkit_Support.Packrat
        (Bare_Private_Part, Token_Index);

         
         subtype Subtype_For_Private_Part is
            Root_Node_Record (Ada_Private_Part);
         type Access_To_Subtype_For_Private_Part is access all Subtype_For_Private_Part;
         package Bare_Private_Part_Alloc is new Alloc
           (Subtype_For_Private_Part, Access_To_Subtype_For_Private_Part);

         function Allocate_Private_Part
           (Pool : Bump_Ptr_Pool) return Bare_Private_Part;

         function Allocate_Private_Part
           (Pool : Bump_Ptr_Pool) return Bare_Private_Part
         is
            Result      : constant Access_To_Subtype_For_Private_Part := Bare_Private_Part_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Private_Part;
            return Bare_Private_Part (Result);
         end Allocate_Private_Part;

      package Bare_Public_Part_Memos is new Langkit_Support.Packrat
        (Bare_Public_Part, Token_Index);

         
         subtype Subtype_For_Public_Part is
            Root_Node_Record (Ada_Public_Part);
         type Access_To_Subtype_For_Public_Part is access all Subtype_For_Public_Part;
         package Bare_Public_Part_Alloc is new Alloc
           (Subtype_For_Public_Part, Access_To_Subtype_For_Public_Part);

         function Allocate_Public_Part
           (Pool : Bump_Ptr_Pool) return Bare_Public_Part;

         function Allocate_Public_Part
           (Pool : Bump_Ptr_Pool) return Bare_Public_Part
         is
            Result      : constant Access_To_Subtype_For_Public_Part := Bare_Public_Part_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Public_Part;
            return Bare_Public_Part (Result);
         end Allocate_Public_Part;

      package Bare_Elsif_Expr_Part_Memos is new Langkit_Support.Packrat
        (Bare_Elsif_Expr_Part, Token_Index);

         
         subtype Subtype_For_Elsif_Expr_Part is
            Root_Node_Record (Ada_Elsif_Expr_Part);
         type Access_To_Subtype_For_Elsif_Expr_Part is access all Subtype_For_Elsif_Expr_Part;
         package Bare_Elsif_Expr_Part_Alloc is new Alloc
           (Subtype_For_Elsif_Expr_Part, Access_To_Subtype_For_Elsif_Expr_Part);

         function Allocate_Elsif_Expr_Part
           (Pool : Bump_Ptr_Pool) return Bare_Elsif_Expr_Part;

         function Allocate_Elsif_Expr_Part
           (Pool : Bump_Ptr_Pool) return Bare_Elsif_Expr_Part
         is
            Result      : constant Access_To_Subtype_For_Elsif_Expr_Part := Bare_Elsif_Expr_Part_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Elsif_Expr_Part;
            return Bare_Elsif_Expr_Part (Result);
         end Allocate_Elsif_Expr_Part;

      package Bare_Elsif_Stmt_Part_Memos is new Langkit_Support.Packrat
        (Bare_Elsif_Stmt_Part, Token_Index);

         
         subtype Subtype_For_Elsif_Stmt_Part is
            Root_Node_Record (Ada_Elsif_Stmt_Part);
         type Access_To_Subtype_For_Elsif_Stmt_Part is access all Subtype_For_Elsif_Stmt_Part;
         package Bare_Elsif_Stmt_Part_Alloc is new Alloc
           (Subtype_For_Elsif_Stmt_Part, Access_To_Subtype_For_Elsif_Stmt_Part);

         function Allocate_Elsif_Stmt_Part
           (Pool : Bump_Ptr_Pool) return Bare_Elsif_Stmt_Part;

         function Allocate_Elsif_Stmt_Part
           (Pool : Bump_Ptr_Pool) return Bare_Elsif_Stmt_Part
         is
            Result      : constant Access_To_Subtype_For_Elsif_Stmt_Part := Bare_Elsif_Stmt_Part_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Elsif_Stmt_Part;
            return Bare_Elsif_Stmt_Part (Result);
         end Allocate_Elsif_Stmt_Part;

      package Bare_Expr_Memos is new Langkit_Support.Packrat
        (Bare_Expr, Token_Index);

      package Bare_Allocator_Memos is new Langkit_Support.Packrat
        (Bare_Allocator, Token_Index);

         
         subtype Subtype_For_Allocator is
            Root_Node_Record (Ada_Allocator);
         type Access_To_Subtype_For_Allocator is access all Subtype_For_Allocator;
         package Bare_Allocator_Alloc is new Alloc
           (Subtype_For_Allocator, Access_To_Subtype_For_Allocator);

         function Allocate_Allocator
           (Pool : Bump_Ptr_Pool) return Bare_Allocator;

         function Allocate_Allocator
           (Pool : Bump_Ptr_Pool) return Bare_Allocator
         is
            Result      : constant Access_To_Subtype_For_Allocator := Bare_Allocator_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Allocator;
            return Bare_Allocator (Result);
         end Allocate_Allocator;

      package Bare_Base_Aggregate_Memos is new Langkit_Support.Packrat
        (Bare_Base_Aggregate, Token_Index);

      package Bare_Aggregate_Memos is new Langkit_Support.Packrat
        (Bare_Aggregate, Token_Index);

         
         subtype Subtype_For_Aggregate is
            Root_Node_Record (Ada_Aggregate);
         type Access_To_Subtype_For_Aggregate is access all Subtype_For_Aggregate;
         package Bare_Aggregate_Alloc is new Alloc
           (Subtype_For_Aggregate, Access_To_Subtype_For_Aggregate);

         function Allocate_Aggregate
           (Pool : Bump_Ptr_Pool) return Bare_Aggregate;

         function Allocate_Aggregate
           (Pool : Bump_Ptr_Pool) return Bare_Aggregate
         is
            Result      : constant Access_To_Subtype_For_Aggregate := Bare_Aggregate_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Aggregate;
            return Bare_Aggregate (Result);
         end Allocate_Aggregate;

      package Bare_Bracket_Aggregate_Memos is new Langkit_Support.Packrat
        (Bare_Bracket_Aggregate, Token_Index);

         
         subtype Subtype_For_Bracket_Aggregate is
            Root_Node_Record (Ada_Bracket_Aggregate);
         type Access_To_Subtype_For_Bracket_Aggregate is access all Subtype_For_Bracket_Aggregate;
         package Bare_Bracket_Aggregate_Alloc is new Alloc
           (Subtype_For_Bracket_Aggregate, Access_To_Subtype_For_Bracket_Aggregate);

         function Allocate_Bracket_Aggregate
           (Pool : Bump_Ptr_Pool) return Bare_Bracket_Aggregate;

         function Allocate_Bracket_Aggregate
           (Pool : Bump_Ptr_Pool) return Bare_Bracket_Aggregate
         is
            Result      : constant Access_To_Subtype_For_Bracket_Aggregate := Bare_Bracket_Aggregate_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Bracket_Aggregate;
            return Bare_Bracket_Aggregate (Result);
         end Allocate_Bracket_Aggregate;

      package Bare_Delta_Aggregate_Memos is new Langkit_Support.Packrat
        (Bare_Delta_Aggregate, Token_Index);

         
         subtype Subtype_For_Delta_Aggregate is
            Root_Node_Record (Ada_Delta_Aggregate);
         type Access_To_Subtype_For_Delta_Aggregate is access all Subtype_For_Delta_Aggregate;
         package Bare_Delta_Aggregate_Alloc is new Alloc
           (Subtype_For_Delta_Aggregate, Access_To_Subtype_For_Delta_Aggregate);

         function Allocate_Delta_Aggregate
           (Pool : Bump_Ptr_Pool) return Bare_Delta_Aggregate;

         function Allocate_Delta_Aggregate
           (Pool : Bump_Ptr_Pool) return Bare_Delta_Aggregate
         is
            Result      : constant Access_To_Subtype_For_Delta_Aggregate := Bare_Delta_Aggregate_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Delta_Aggregate;
            return Bare_Delta_Aggregate (Result);
         end Allocate_Delta_Aggregate;

      package Bare_Bracket_Delta_Aggregate_Memos is new Langkit_Support.Packrat
        (Bare_Bracket_Delta_Aggregate, Token_Index);

         
         subtype Subtype_For_Bracket_Delta_Aggregate is
            Root_Node_Record (Ada_Bracket_Delta_Aggregate);
         type Access_To_Subtype_For_Bracket_Delta_Aggregate is access all Subtype_For_Bracket_Delta_Aggregate;
         package Bare_Bracket_Delta_Aggregate_Alloc is new Alloc
           (Subtype_For_Bracket_Delta_Aggregate, Access_To_Subtype_For_Bracket_Delta_Aggregate);

         function Allocate_Bracket_Delta_Aggregate
           (Pool : Bump_Ptr_Pool) return Bare_Bracket_Delta_Aggregate;

         function Allocate_Bracket_Delta_Aggregate
           (Pool : Bump_Ptr_Pool) return Bare_Bracket_Delta_Aggregate
         is
            Result      : constant Access_To_Subtype_For_Bracket_Delta_Aggregate := Bare_Bracket_Delta_Aggregate_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Bracket_Delta_Aggregate;
            return Bare_Bracket_Delta_Aggregate (Result);
         end Allocate_Bracket_Delta_Aggregate;

      package Bare_Null_Record_Aggregate_Memos is new Langkit_Support.Packrat
        (Bare_Null_Record_Aggregate, Token_Index);

         
         subtype Subtype_For_Null_Record_Aggregate is
            Root_Node_Record (Ada_Null_Record_Aggregate);
         type Access_To_Subtype_For_Null_Record_Aggregate is access all Subtype_For_Null_Record_Aggregate;
         package Bare_Null_Record_Aggregate_Alloc is new Alloc
           (Subtype_For_Null_Record_Aggregate, Access_To_Subtype_For_Null_Record_Aggregate);

         function Allocate_Null_Record_Aggregate
           (Pool : Bump_Ptr_Pool) return Bare_Null_Record_Aggregate;

         function Allocate_Null_Record_Aggregate
           (Pool : Bump_Ptr_Pool) return Bare_Null_Record_Aggregate
         is
            Result      : constant Access_To_Subtype_For_Null_Record_Aggregate := Bare_Null_Record_Aggregate_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Null_Record_Aggregate;
            return Bare_Null_Record_Aggregate (Result);
         end Allocate_Null_Record_Aggregate;

      package Bare_Bin_Op_Memos is new Langkit_Support.Packrat
        (Bare_Bin_Op, Token_Index);

         
         subtype Subtype_For_Bin_Op is
            Root_Node_Record (Ada_Bin_Op);
         type Access_To_Subtype_For_Bin_Op is access all Subtype_For_Bin_Op;
         package Bare_Bin_Op_Alloc is new Alloc
           (Subtype_For_Bin_Op, Access_To_Subtype_For_Bin_Op);

         function Allocate_Bin_Op
           (Pool : Bump_Ptr_Pool) return Bare_Bin_Op;

         function Allocate_Bin_Op
           (Pool : Bump_Ptr_Pool) return Bare_Bin_Op
         is
            Result      : constant Access_To_Subtype_For_Bin_Op := Bare_Bin_Op_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Bin_Op;
            return Bare_Bin_Op (Result);
         end Allocate_Bin_Op;

      package Bare_Relation_Op_Memos is new Langkit_Support.Packrat
        (Bare_Relation_Op, Token_Index);

         
         subtype Subtype_For_Relation_Op is
            Root_Node_Record (Ada_Relation_Op);
         type Access_To_Subtype_For_Relation_Op is access all Subtype_For_Relation_Op;
         package Bare_Relation_Op_Alloc is new Alloc
           (Subtype_For_Relation_Op, Access_To_Subtype_For_Relation_Op);

         function Allocate_Relation_Op
           (Pool : Bump_Ptr_Pool) return Bare_Relation_Op;

         function Allocate_Relation_Op
           (Pool : Bump_Ptr_Pool) return Bare_Relation_Op
         is
            Result      : constant Access_To_Subtype_For_Relation_Op := Bare_Relation_Op_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Relation_Op;
            return Bare_Relation_Op (Result);
         end Allocate_Relation_Op;

      package Bare_Box_Expr_Memos is new Langkit_Support.Packrat
        (Bare_Box_Expr, Token_Index);

         
         subtype Subtype_For_Box_Expr is
            Root_Node_Record (Ada_Box_Expr);
         type Access_To_Subtype_For_Box_Expr is access all Subtype_For_Box_Expr;
         package Bare_Box_Expr_Alloc is new Alloc
           (Subtype_For_Box_Expr, Access_To_Subtype_For_Box_Expr);

         function Allocate_Box_Expr
           (Pool : Bump_Ptr_Pool) return Bare_Box_Expr;

         function Allocate_Box_Expr
           (Pool : Bump_Ptr_Pool) return Bare_Box_Expr
         is
            Result      : constant Access_To_Subtype_For_Box_Expr := Bare_Box_Expr_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Box_Expr;
            return Bare_Box_Expr (Result);
         end Allocate_Box_Expr;

      package Bare_Case_Expr_Alternative_Memos is new Langkit_Support.Packrat
        (Bare_Case_Expr_Alternative, Token_Index);

         
         subtype Subtype_For_Case_Expr_Alternative is
            Root_Node_Record (Ada_Case_Expr_Alternative);
         type Access_To_Subtype_For_Case_Expr_Alternative is access all Subtype_For_Case_Expr_Alternative;
         package Bare_Case_Expr_Alternative_Alloc is new Alloc
           (Subtype_For_Case_Expr_Alternative, Access_To_Subtype_For_Case_Expr_Alternative);

         function Allocate_Case_Expr_Alternative
           (Pool : Bump_Ptr_Pool) return Bare_Case_Expr_Alternative;

         function Allocate_Case_Expr_Alternative
           (Pool : Bump_Ptr_Pool) return Bare_Case_Expr_Alternative
         is
            Result      : constant Access_To_Subtype_For_Case_Expr_Alternative := Bare_Case_Expr_Alternative_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Case_Expr_Alternative;
            return Bare_Case_Expr_Alternative (Result);
         end Allocate_Case_Expr_Alternative;

      package Bare_Cond_Expr_Memos is new Langkit_Support.Packrat
        (Bare_Cond_Expr, Token_Index);

      package Bare_Case_Expr_Memos is new Langkit_Support.Packrat
        (Bare_Case_Expr, Token_Index);

         
         subtype Subtype_For_Case_Expr is
            Root_Node_Record (Ada_Case_Expr);
         type Access_To_Subtype_For_Case_Expr is access all Subtype_For_Case_Expr;
         package Bare_Case_Expr_Alloc is new Alloc
           (Subtype_For_Case_Expr, Access_To_Subtype_For_Case_Expr);

         function Allocate_Case_Expr
           (Pool : Bump_Ptr_Pool) return Bare_Case_Expr;

         function Allocate_Case_Expr
           (Pool : Bump_Ptr_Pool) return Bare_Case_Expr
         is
            Result      : constant Access_To_Subtype_For_Case_Expr := Bare_Case_Expr_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Case_Expr;
            return Bare_Case_Expr (Result);
         end Allocate_Case_Expr;

      package Bare_If_Expr_Memos is new Langkit_Support.Packrat
        (Bare_If_Expr, Token_Index);

         
         subtype Subtype_For_If_Expr is
            Root_Node_Record (Ada_If_Expr);
         type Access_To_Subtype_For_If_Expr is access all Subtype_For_If_Expr;
         package Bare_If_Expr_Alloc is new Alloc
           (Subtype_For_If_Expr, Access_To_Subtype_For_If_Expr);

         function Allocate_If_Expr
           (Pool : Bump_Ptr_Pool) return Bare_If_Expr;

         function Allocate_If_Expr
           (Pool : Bump_Ptr_Pool) return Bare_If_Expr
         is
            Result      : constant Access_To_Subtype_For_If_Expr := Bare_If_Expr_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_If_Expr;
            return Bare_If_Expr (Result);
         end Allocate_If_Expr;

      package Bare_Contract_Cases_Memos is new Langkit_Support.Packrat
        (Bare_Contract_Cases, Token_Index);

         
         subtype Subtype_For_Contract_Cases is
            Root_Node_Record (Ada_Contract_Cases);
         type Access_To_Subtype_For_Contract_Cases is access all Subtype_For_Contract_Cases;
         package Bare_Contract_Cases_Alloc is new Alloc
           (Subtype_For_Contract_Cases, Access_To_Subtype_For_Contract_Cases);

         function Allocate_Contract_Cases
           (Pool : Bump_Ptr_Pool) return Bare_Contract_Cases;

         function Allocate_Contract_Cases
           (Pool : Bump_Ptr_Pool) return Bare_Contract_Cases
         is
            Result      : constant Access_To_Subtype_For_Contract_Cases := Bare_Contract_Cases_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Contract_Cases;
            return Bare_Contract_Cases (Result);
         end Allocate_Contract_Cases;

      package Bare_Decl_Expr_Memos is new Langkit_Support.Packrat
        (Bare_Decl_Expr, Token_Index);

         
         subtype Subtype_For_Decl_Expr is
            Root_Node_Record (Ada_Decl_Expr);
         type Access_To_Subtype_For_Decl_Expr is access all Subtype_For_Decl_Expr;
         package Bare_Decl_Expr_Alloc is new Alloc
           (Subtype_For_Decl_Expr, Access_To_Subtype_For_Decl_Expr);

         function Allocate_Decl_Expr
           (Pool : Bump_Ptr_Pool) return Bare_Decl_Expr;

         function Allocate_Decl_Expr
           (Pool : Bump_Ptr_Pool) return Bare_Decl_Expr
         is
            Result      : constant Access_To_Subtype_For_Decl_Expr := Bare_Decl_Expr_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Decl_Expr;
            return Bare_Decl_Expr (Result);
         end Allocate_Decl_Expr;

      package Bare_Membership_Expr_Memos is new Langkit_Support.Packrat
        (Bare_Membership_Expr, Token_Index);

         
         subtype Subtype_For_Membership_Expr is
            Root_Node_Record (Ada_Membership_Expr);
         type Access_To_Subtype_For_Membership_Expr is access all Subtype_For_Membership_Expr;
         package Bare_Membership_Expr_Alloc is new Alloc
           (Subtype_For_Membership_Expr, Access_To_Subtype_For_Membership_Expr);

         function Allocate_Membership_Expr
           (Pool : Bump_Ptr_Pool) return Bare_Membership_Expr;

         function Allocate_Membership_Expr
           (Pool : Bump_Ptr_Pool) return Bare_Membership_Expr
         is
            Result      : constant Access_To_Subtype_For_Membership_Expr := Bare_Membership_Expr_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Membership_Expr;
            return Bare_Membership_Expr (Result);
         end Allocate_Membership_Expr;

      package Bare_Name_Memos is new Langkit_Support.Packrat
        (Bare_Name, Token_Index);

      package Bare_Attribute_Ref_Memos is new Langkit_Support.Packrat
        (Bare_Attribute_Ref, Token_Index);

         
         subtype Subtype_For_Attribute_Ref is
            Root_Node_Record (Ada_Attribute_Ref);
         type Access_To_Subtype_For_Attribute_Ref is access all Subtype_For_Attribute_Ref;
         package Bare_Attribute_Ref_Alloc is new Alloc
           (Subtype_For_Attribute_Ref, Access_To_Subtype_For_Attribute_Ref);

         function Allocate_Attribute_Ref
           (Pool : Bump_Ptr_Pool) return Bare_Attribute_Ref;

         function Allocate_Attribute_Ref
           (Pool : Bump_Ptr_Pool) return Bare_Attribute_Ref
         is
            Result      : constant Access_To_Subtype_For_Attribute_Ref := Bare_Attribute_Ref_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Attribute_Ref;
            return Bare_Attribute_Ref (Result);
         end Allocate_Attribute_Ref;

      package Bare_Update_Attribute_Ref_Memos is new Langkit_Support.Packrat
        (Bare_Update_Attribute_Ref, Token_Index);

         
         subtype Subtype_For_Update_Attribute_Ref is
            Root_Node_Record (Ada_Update_Attribute_Ref);
         type Access_To_Subtype_For_Update_Attribute_Ref is access all Subtype_For_Update_Attribute_Ref;
         package Bare_Update_Attribute_Ref_Alloc is new Alloc
           (Subtype_For_Update_Attribute_Ref, Access_To_Subtype_For_Update_Attribute_Ref);

         function Allocate_Update_Attribute_Ref
           (Pool : Bump_Ptr_Pool) return Bare_Update_Attribute_Ref;

         function Allocate_Update_Attribute_Ref
           (Pool : Bump_Ptr_Pool) return Bare_Update_Attribute_Ref
         is
            Result      : constant Access_To_Subtype_For_Update_Attribute_Ref := Bare_Update_Attribute_Ref_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Update_Attribute_Ref;
            return Bare_Update_Attribute_Ref (Result);
         end Allocate_Update_Attribute_Ref;

      package Bare_Call_Expr_Memos is new Langkit_Support.Packrat
        (Bare_Call_Expr, Token_Index);

         
         subtype Subtype_For_Call_Expr is
            Root_Node_Record (Ada_Call_Expr);
         type Access_To_Subtype_For_Call_Expr is access all Subtype_For_Call_Expr;
         package Bare_Call_Expr_Alloc is new Alloc
           (Subtype_For_Call_Expr, Access_To_Subtype_For_Call_Expr);

         function Allocate_Call_Expr
           (Pool : Bump_Ptr_Pool) return Bare_Call_Expr;

         function Allocate_Call_Expr
           (Pool : Bump_Ptr_Pool) return Bare_Call_Expr
         is
            Result      : constant Access_To_Subtype_For_Call_Expr := Bare_Call_Expr_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Call_Expr;
            return Bare_Call_Expr (Result);
         end Allocate_Call_Expr;

      package Bare_Defining_Name_Memos is new Langkit_Support.Packrat
        (Bare_Defining_Name, Token_Index);

         
         subtype Subtype_For_Defining_Name is
            Root_Node_Record (Ada_Defining_Name);
         type Access_To_Subtype_For_Defining_Name is access all Subtype_For_Defining_Name;
         package Bare_Defining_Name_Alloc is new Alloc
           (Subtype_For_Defining_Name, Access_To_Subtype_For_Defining_Name);

         function Allocate_Defining_Name
           (Pool : Bump_Ptr_Pool) return Bare_Defining_Name;

         function Allocate_Defining_Name
           (Pool : Bump_Ptr_Pool) return Bare_Defining_Name
         is
            Result      : constant Access_To_Subtype_For_Defining_Name := Bare_Defining_Name_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Defining_Name;
            return Bare_Defining_Name (Result);
         end Allocate_Defining_Name;

      package Bare_Discrete_Subtype_Name_Memos is new Langkit_Support.Packrat
        (Bare_Discrete_Subtype_Name, Token_Index);

         
         subtype Subtype_For_Discrete_Subtype_Name is
            Root_Node_Record (Ada_Discrete_Subtype_Name);
         type Access_To_Subtype_For_Discrete_Subtype_Name is access all Subtype_For_Discrete_Subtype_Name;
         package Bare_Discrete_Subtype_Name_Alloc is new Alloc
           (Subtype_For_Discrete_Subtype_Name, Access_To_Subtype_For_Discrete_Subtype_Name);

         function Allocate_Discrete_Subtype_Name
           (Pool : Bump_Ptr_Pool) return Bare_Discrete_Subtype_Name;

         function Allocate_Discrete_Subtype_Name
           (Pool : Bump_Ptr_Pool) return Bare_Discrete_Subtype_Name
         is
            Result      : constant Access_To_Subtype_For_Discrete_Subtype_Name := Bare_Discrete_Subtype_Name_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Discrete_Subtype_Name;
            return Bare_Discrete_Subtype_Name (Result);
         end Allocate_Discrete_Subtype_Name;

      package Bare_Dotted_Name_Memos is new Langkit_Support.Packrat
        (Bare_Dotted_Name, Token_Index);

         
         subtype Subtype_For_Dotted_Name is
            Root_Node_Record (Ada_Dotted_Name);
         type Access_To_Subtype_For_Dotted_Name is access all Subtype_For_Dotted_Name;
         package Bare_Dotted_Name_Alloc is new Alloc
           (Subtype_For_Dotted_Name, Access_To_Subtype_For_Dotted_Name);

         function Allocate_Dotted_Name
           (Pool : Bump_Ptr_Pool) return Bare_Dotted_Name;

         function Allocate_Dotted_Name
           (Pool : Bump_Ptr_Pool) return Bare_Dotted_Name
         is
            Result      : constant Access_To_Subtype_For_Dotted_Name := Bare_Dotted_Name_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Dotted_Name;
            return Bare_Dotted_Name (Result);
         end Allocate_Dotted_Name;

      package Bare_End_Name_Memos is new Langkit_Support.Packrat
        (Bare_End_Name, Token_Index);

         
         subtype Subtype_For_End_Name is
            Root_Node_Record (Ada_End_Name);
         type Access_To_Subtype_For_End_Name is access all Subtype_For_End_Name;
         package Bare_End_Name_Alloc is new Alloc
           (Subtype_For_End_Name, Access_To_Subtype_For_End_Name);

         function Allocate_End_Name
           (Pool : Bump_Ptr_Pool) return Bare_End_Name;

         function Allocate_End_Name
           (Pool : Bump_Ptr_Pool) return Bare_End_Name
         is
            Result      : constant Access_To_Subtype_For_End_Name := Bare_End_Name_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_End_Name;
            return Bare_End_Name (Result);
         end Allocate_End_Name;

      package Bare_Explicit_Deref_Memos is new Langkit_Support.Packrat
        (Bare_Explicit_Deref, Token_Index);

         
         subtype Subtype_For_Explicit_Deref is
            Root_Node_Record (Ada_Explicit_Deref);
         type Access_To_Subtype_For_Explicit_Deref is access all Subtype_For_Explicit_Deref;
         package Bare_Explicit_Deref_Alloc is new Alloc
           (Subtype_For_Explicit_Deref, Access_To_Subtype_For_Explicit_Deref);

         function Allocate_Explicit_Deref
           (Pool : Bump_Ptr_Pool) return Bare_Explicit_Deref;

         function Allocate_Explicit_Deref
           (Pool : Bump_Ptr_Pool) return Bare_Explicit_Deref
         is
            Result      : constant Access_To_Subtype_For_Explicit_Deref := Bare_Explicit_Deref_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Explicit_Deref;
            return Bare_Explicit_Deref (Result);
         end Allocate_Explicit_Deref;

      package Bare_Qual_Expr_Memos is new Langkit_Support.Packrat
        (Bare_Qual_Expr, Token_Index);

         
         subtype Subtype_For_Qual_Expr is
            Root_Node_Record (Ada_Qual_Expr);
         type Access_To_Subtype_For_Qual_Expr is access all Subtype_For_Qual_Expr;
         package Bare_Qual_Expr_Alloc is new Alloc
           (Subtype_For_Qual_Expr, Access_To_Subtype_For_Qual_Expr);

         function Allocate_Qual_Expr
           (Pool : Bump_Ptr_Pool) return Bare_Qual_Expr;

         function Allocate_Qual_Expr
           (Pool : Bump_Ptr_Pool) return Bare_Qual_Expr
         is
            Result      : constant Access_To_Subtype_For_Qual_Expr := Bare_Qual_Expr_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Qual_Expr;
            return Bare_Qual_Expr (Result);
         end Allocate_Qual_Expr;

      package Bare_Single_Tok_Node_Memos is new Langkit_Support.Packrat
        (Bare_Single_Tok_Node, Token_Index);

      package Bare_Base_Id_Memos is new Langkit_Support.Packrat
        (Bare_Base_Id, Token_Index);

      package Bare_Char_Literal_Memos is new Langkit_Support.Packrat
        (Bare_Char_Literal, Token_Index);

         
         subtype Subtype_For_Char_Literal is
            Root_Node_Record (Ada_Char_Literal);
         type Access_To_Subtype_For_Char_Literal is access all Subtype_For_Char_Literal;
         package Bare_Char_Literal_Alloc is new Alloc
           (Subtype_For_Char_Literal, Access_To_Subtype_For_Char_Literal);

         function Allocate_Char_Literal
           (Pool : Bump_Ptr_Pool) return Bare_Char_Literal;

         function Allocate_Char_Literal
           (Pool : Bump_Ptr_Pool) return Bare_Char_Literal
         is
            Result      : constant Access_To_Subtype_For_Char_Literal := Bare_Char_Literal_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Char_Literal;
            return Bare_Char_Literal (Result);
         end Allocate_Char_Literal;

      package Bare_Identifier_Memos is new Langkit_Support.Packrat
        (Bare_Identifier, Token_Index);

         
         subtype Subtype_For_Identifier is
            Root_Node_Record (Ada_Identifier);
         type Access_To_Subtype_For_Identifier is access all Subtype_For_Identifier;
         package Bare_Identifier_Alloc is new Alloc
           (Subtype_For_Identifier, Access_To_Subtype_For_Identifier);

         function Allocate_Identifier
           (Pool : Bump_Ptr_Pool) return Bare_Identifier;

         function Allocate_Identifier
           (Pool : Bump_Ptr_Pool) return Bare_Identifier
         is
            Result      : constant Access_To_Subtype_For_Identifier := Bare_Identifier_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Identifier;
            return Bare_Identifier (Result);
         end Allocate_Identifier;

      package Bare_Op_Memos is new Langkit_Support.Packrat
        (Bare_Op, Token_Index);

      package Bare_Op_Abs_Memos is new Langkit_Support.Packrat
        (Bare_Op_Abs, Token_Index);

         
         subtype Subtype_For_Op_Abs is
            Root_Node_Record (Ada_Op_Abs);
         type Access_To_Subtype_For_Op_Abs is access all Subtype_For_Op_Abs;
         package Bare_Op_Abs_Alloc is new Alloc
           (Subtype_For_Op_Abs, Access_To_Subtype_For_Op_Abs);

         function Allocate_Op_Abs
           (Pool : Bump_Ptr_Pool) return Bare_Op_Abs;

         function Allocate_Op_Abs
           (Pool : Bump_Ptr_Pool) return Bare_Op_Abs
         is
            Result      : constant Access_To_Subtype_For_Op_Abs := Bare_Op_Abs_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Op_Abs;
            return Bare_Op_Abs (Result);
         end Allocate_Op_Abs;

      package Bare_Op_And_Memos is new Langkit_Support.Packrat
        (Bare_Op_And, Token_Index);

         
         subtype Subtype_For_Op_And is
            Root_Node_Record (Ada_Op_And);
         type Access_To_Subtype_For_Op_And is access all Subtype_For_Op_And;
         package Bare_Op_And_Alloc is new Alloc
           (Subtype_For_Op_And, Access_To_Subtype_For_Op_And);

         function Allocate_Op_And
           (Pool : Bump_Ptr_Pool) return Bare_Op_And;

         function Allocate_Op_And
           (Pool : Bump_Ptr_Pool) return Bare_Op_And
         is
            Result      : constant Access_To_Subtype_For_Op_And := Bare_Op_And_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Op_And;
            return Bare_Op_And (Result);
         end Allocate_Op_And;

      package Bare_Op_And_Then_Memos is new Langkit_Support.Packrat
        (Bare_Op_And_Then, Token_Index);

         
         subtype Subtype_For_Op_And_Then is
            Root_Node_Record (Ada_Op_And_Then);
         type Access_To_Subtype_For_Op_And_Then is access all Subtype_For_Op_And_Then;
         package Bare_Op_And_Then_Alloc is new Alloc
           (Subtype_For_Op_And_Then, Access_To_Subtype_For_Op_And_Then);

         function Allocate_Op_And_Then
           (Pool : Bump_Ptr_Pool) return Bare_Op_And_Then;

         function Allocate_Op_And_Then
           (Pool : Bump_Ptr_Pool) return Bare_Op_And_Then
         is
            Result      : constant Access_To_Subtype_For_Op_And_Then := Bare_Op_And_Then_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Op_And_Then;
            return Bare_Op_And_Then (Result);
         end Allocate_Op_And_Then;

      package Bare_Op_Concat_Memos is new Langkit_Support.Packrat
        (Bare_Op_Concat, Token_Index);

         
         subtype Subtype_For_Op_Concat is
            Root_Node_Record (Ada_Op_Concat);
         type Access_To_Subtype_For_Op_Concat is access all Subtype_For_Op_Concat;
         package Bare_Op_Concat_Alloc is new Alloc
           (Subtype_For_Op_Concat, Access_To_Subtype_For_Op_Concat);

         function Allocate_Op_Concat
           (Pool : Bump_Ptr_Pool) return Bare_Op_Concat;

         function Allocate_Op_Concat
           (Pool : Bump_Ptr_Pool) return Bare_Op_Concat
         is
            Result      : constant Access_To_Subtype_For_Op_Concat := Bare_Op_Concat_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Op_Concat;
            return Bare_Op_Concat (Result);
         end Allocate_Op_Concat;

      package Bare_Op_Div_Memos is new Langkit_Support.Packrat
        (Bare_Op_Div, Token_Index);

         
         subtype Subtype_For_Op_Div is
            Root_Node_Record (Ada_Op_Div);
         type Access_To_Subtype_For_Op_Div is access all Subtype_For_Op_Div;
         package Bare_Op_Div_Alloc is new Alloc
           (Subtype_For_Op_Div, Access_To_Subtype_For_Op_Div);

         function Allocate_Op_Div
           (Pool : Bump_Ptr_Pool) return Bare_Op_Div;

         function Allocate_Op_Div
           (Pool : Bump_Ptr_Pool) return Bare_Op_Div
         is
            Result      : constant Access_To_Subtype_For_Op_Div := Bare_Op_Div_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Op_Div;
            return Bare_Op_Div (Result);
         end Allocate_Op_Div;

      package Bare_Op_Double_Dot_Memos is new Langkit_Support.Packrat
        (Bare_Op_Double_Dot, Token_Index);

         
         subtype Subtype_For_Op_Double_Dot is
            Root_Node_Record (Ada_Op_Double_Dot);
         type Access_To_Subtype_For_Op_Double_Dot is access all Subtype_For_Op_Double_Dot;
         package Bare_Op_Double_Dot_Alloc is new Alloc
           (Subtype_For_Op_Double_Dot, Access_To_Subtype_For_Op_Double_Dot);

         function Allocate_Op_Double_Dot
           (Pool : Bump_Ptr_Pool) return Bare_Op_Double_Dot;

         function Allocate_Op_Double_Dot
           (Pool : Bump_Ptr_Pool) return Bare_Op_Double_Dot
         is
            Result      : constant Access_To_Subtype_For_Op_Double_Dot := Bare_Op_Double_Dot_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Op_Double_Dot;
            return Bare_Op_Double_Dot (Result);
         end Allocate_Op_Double_Dot;

      package Bare_Op_Eq_Memos is new Langkit_Support.Packrat
        (Bare_Op_Eq, Token_Index);

         
         subtype Subtype_For_Op_Eq is
            Root_Node_Record (Ada_Op_Eq);
         type Access_To_Subtype_For_Op_Eq is access all Subtype_For_Op_Eq;
         package Bare_Op_Eq_Alloc is new Alloc
           (Subtype_For_Op_Eq, Access_To_Subtype_For_Op_Eq);

         function Allocate_Op_Eq
           (Pool : Bump_Ptr_Pool) return Bare_Op_Eq;

         function Allocate_Op_Eq
           (Pool : Bump_Ptr_Pool) return Bare_Op_Eq
         is
            Result      : constant Access_To_Subtype_For_Op_Eq := Bare_Op_Eq_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Op_Eq;
            return Bare_Op_Eq (Result);
         end Allocate_Op_Eq;

      package Bare_Op_Gt_Memos is new Langkit_Support.Packrat
        (Bare_Op_Gt, Token_Index);

         
         subtype Subtype_For_Op_Gt is
            Root_Node_Record (Ada_Op_Gt);
         type Access_To_Subtype_For_Op_Gt is access all Subtype_For_Op_Gt;
         package Bare_Op_Gt_Alloc is new Alloc
           (Subtype_For_Op_Gt, Access_To_Subtype_For_Op_Gt);

         function Allocate_Op_Gt
           (Pool : Bump_Ptr_Pool) return Bare_Op_Gt;

         function Allocate_Op_Gt
           (Pool : Bump_Ptr_Pool) return Bare_Op_Gt
         is
            Result      : constant Access_To_Subtype_For_Op_Gt := Bare_Op_Gt_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Op_Gt;
            return Bare_Op_Gt (Result);
         end Allocate_Op_Gt;

      package Bare_Op_Gte_Memos is new Langkit_Support.Packrat
        (Bare_Op_Gte, Token_Index);

         
         subtype Subtype_For_Op_Gte is
            Root_Node_Record (Ada_Op_Gte);
         type Access_To_Subtype_For_Op_Gte is access all Subtype_For_Op_Gte;
         package Bare_Op_Gte_Alloc is new Alloc
           (Subtype_For_Op_Gte, Access_To_Subtype_For_Op_Gte);

         function Allocate_Op_Gte
           (Pool : Bump_Ptr_Pool) return Bare_Op_Gte;

         function Allocate_Op_Gte
           (Pool : Bump_Ptr_Pool) return Bare_Op_Gte
         is
            Result      : constant Access_To_Subtype_For_Op_Gte := Bare_Op_Gte_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Op_Gte;
            return Bare_Op_Gte (Result);
         end Allocate_Op_Gte;

      package Bare_Op_In_Memos is new Langkit_Support.Packrat
        (Bare_Op_In, Token_Index);

         
         subtype Subtype_For_Op_In is
            Root_Node_Record (Ada_Op_In);
         type Access_To_Subtype_For_Op_In is access all Subtype_For_Op_In;
         package Bare_Op_In_Alloc is new Alloc
           (Subtype_For_Op_In, Access_To_Subtype_For_Op_In);

         function Allocate_Op_In
           (Pool : Bump_Ptr_Pool) return Bare_Op_In;

         function Allocate_Op_In
           (Pool : Bump_Ptr_Pool) return Bare_Op_In
         is
            Result      : constant Access_To_Subtype_For_Op_In := Bare_Op_In_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Op_In;
            return Bare_Op_In (Result);
         end Allocate_Op_In;

      package Bare_Op_Lt_Memos is new Langkit_Support.Packrat
        (Bare_Op_Lt, Token_Index);

         
         subtype Subtype_For_Op_Lt is
            Root_Node_Record (Ada_Op_Lt);
         type Access_To_Subtype_For_Op_Lt is access all Subtype_For_Op_Lt;
         package Bare_Op_Lt_Alloc is new Alloc
           (Subtype_For_Op_Lt, Access_To_Subtype_For_Op_Lt);

         function Allocate_Op_Lt
           (Pool : Bump_Ptr_Pool) return Bare_Op_Lt;

         function Allocate_Op_Lt
           (Pool : Bump_Ptr_Pool) return Bare_Op_Lt
         is
            Result      : constant Access_To_Subtype_For_Op_Lt := Bare_Op_Lt_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Op_Lt;
            return Bare_Op_Lt (Result);
         end Allocate_Op_Lt;

      package Bare_Op_Lte_Memos is new Langkit_Support.Packrat
        (Bare_Op_Lte, Token_Index);

         
         subtype Subtype_For_Op_Lte is
            Root_Node_Record (Ada_Op_Lte);
         type Access_To_Subtype_For_Op_Lte is access all Subtype_For_Op_Lte;
         package Bare_Op_Lte_Alloc is new Alloc
           (Subtype_For_Op_Lte, Access_To_Subtype_For_Op_Lte);

         function Allocate_Op_Lte
           (Pool : Bump_Ptr_Pool) return Bare_Op_Lte;

         function Allocate_Op_Lte
           (Pool : Bump_Ptr_Pool) return Bare_Op_Lte
         is
            Result      : constant Access_To_Subtype_For_Op_Lte := Bare_Op_Lte_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Op_Lte;
            return Bare_Op_Lte (Result);
         end Allocate_Op_Lte;

      package Bare_Op_Minus_Memos is new Langkit_Support.Packrat
        (Bare_Op_Minus, Token_Index);

         
         subtype Subtype_For_Op_Minus is
            Root_Node_Record (Ada_Op_Minus);
         type Access_To_Subtype_For_Op_Minus is access all Subtype_For_Op_Minus;
         package Bare_Op_Minus_Alloc is new Alloc
           (Subtype_For_Op_Minus, Access_To_Subtype_For_Op_Minus);

         function Allocate_Op_Minus
           (Pool : Bump_Ptr_Pool) return Bare_Op_Minus;

         function Allocate_Op_Minus
           (Pool : Bump_Ptr_Pool) return Bare_Op_Minus
         is
            Result      : constant Access_To_Subtype_For_Op_Minus := Bare_Op_Minus_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Op_Minus;
            return Bare_Op_Minus (Result);
         end Allocate_Op_Minus;

      package Bare_Op_Mod_Memos is new Langkit_Support.Packrat
        (Bare_Op_Mod, Token_Index);

         
         subtype Subtype_For_Op_Mod is
            Root_Node_Record (Ada_Op_Mod);
         type Access_To_Subtype_For_Op_Mod is access all Subtype_For_Op_Mod;
         package Bare_Op_Mod_Alloc is new Alloc
           (Subtype_For_Op_Mod, Access_To_Subtype_For_Op_Mod);

         function Allocate_Op_Mod
           (Pool : Bump_Ptr_Pool) return Bare_Op_Mod;

         function Allocate_Op_Mod
           (Pool : Bump_Ptr_Pool) return Bare_Op_Mod
         is
            Result      : constant Access_To_Subtype_For_Op_Mod := Bare_Op_Mod_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Op_Mod;
            return Bare_Op_Mod (Result);
         end Allocate_Op_Mod;

      package Bare_Op_Mult_Memos is new Langkit_Support.Packrat
        (Bare_Op_Mult, Token_Index);

         
         subtype Subtype_For_Op_Mult is
            Root_Node_Record (Ada_Op_Mult);
         type Access_To_Subtype_For_Op_Mult is access all Subtype_For_Op_Mult;
         package Bare_Op_Mult_Alloc is new Alloc
           (Subtype_For_Op_Mult, Access_To_Subtype_For_Op_Mult);

         function Allocate_Op_Mult
           (Pool : Bump_Ptr_Pool) return Bare_Op_Mult;

         function Allocate_Op_Mult
           (Pool : Bump_Ptr_Pool) return Bare_Op_Mult
         is
            Result      : constant Access_To_Subtype_For_Op_Mult := Bare_Op_Mult_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Op_Mult;
            return Bare_Op_Mult (Result);
         end Allocate_Op_Mult;

      package Bare_Op_Neq_Memos is new Langkit_Support.Packrat
        (Bare_Op_Neq, Token_Index);

         
         subtype Subtype_For_Op_Neq is
            Root_Node_Record (Ada_Op_Neq);
         type Access_To_Subtype_For_Op_Neq is access all Subtype_For_Op_Neq;
         package Bare_Op_Neq_Alloc is new Alloc
           (Subtype_For_Op_Neq, Access_To_Subtype_For_Op_Neq);

         function Allocate_Op_Neq
           (Pool : Bump_Ptr_Pool) return Bare_Op_Neq;

         function Allocate_Op_Neq
           (Pool : Bump_Ptr_Pool) return Bare_Op_Neq
         is
            Result      : constant Access_To_Subtype_For_Op_Neq := Bare_Op_Neq_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Op_Neq;
            return Bare_Op_Neq (Result);
         end Allocate_Op_Neq;

      package Bare_Op_Not_Memos is new Langkit_Support.Packrat
        (Bare_Op_Not, Token_Index);

         
         subtype Subtype_For_Op_Not is
            Root_Node_Record (Ada_Op_Not);
         type Access_To_Subtype_For_Op_Not is access all Subtype_For_Op_Not;
         package Bare_Op_Not_Alloc is new Alloc
           (Subtype_For_Op_Not, Access_To_Subtype_For_Op_Not);

         function Allocate_Op_Not
           (Pool : Bump_Ptr_Pool) return Bare_Op_Not;

         function Allocate_Op_Not
           (Pool : Bump_Ptr_Pool) return Bare_Op_Not
         is
            Result      : constant Access_To_Subtype_For_Op_Not := Bare_Op_Not_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Op_Not;
            return Bare_Op_Not (Result);
         end Allocate_Op_Not;

      package Bare_Op_Not_In_Memos is new Langkit_Support.Packrat
        (Bare_Op_Not_In, Token_Index);

         
         subtype Subtype_For_Op_Not_In is
            Root_Node_Record (Ada_Op_Not_In);
         type Access_To_Subtype_For_Op_Not_In is access all Subtype_For_Op_Not_In;
         package Bare_Op_Not_In_Alloc is new Alloc
           (Subtype_For_Op_Not_In, Access_To_Subtype_For_Op_Not_In);

         function Allocate_Op_Not_In
           (Pool : Bump_Ptr_Pool) return Bare_Op_Not_In;

         function Allocate_Op_Not_In
           (Pool : Bump_Ptr_Pool) return Bare_Op_Not_In
         is
            Result      : constant Access_To_Subtype_For_Op_Not_In := Bare_Op_Not_In_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Op_Not_In;
            return Bare_Op_Not_In (Result);
         end Allocate_Op_Not_In;

      package Bare_Op_Or_Memos is new Langkit_Support.Packrat
        (Bare_Op_Or, Token_Index);

         
         subtype Subtype_For_Op_Or is
            Root_Node_Record (Ada_Op_Or);
         type Access_To_Subtype_For_Op_Or is access all Subtype_For_Op_Or;
         package Bare_Op_Or_Alloc is new Alloc
           (Subtype_For_Op_Or, Access_To_Subtype_For_Op_Or);

         function Allocate_Op_Or
           (Pool : Bump_Ptr_Pool) return Bare_Op_Or;

         function Allocate_Op_Or
           (Pool : Bump_Ptr_Pool) return Bare_Op_Or
         is
            Result      : constant Access_To_Subtype_For_Op_Or := Bare_Op_Or_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Op_Or;
            return Bare_Op_Or (Result);
         end Allocate_Op_Or;

      package Bare_Op_Or_Else_Memos is new Langkit_Support.Packrat
        (Bare_Op_Or_Else, Token_Index);

         
         subtype Subtype_For_Op_Or_Else is
            Root_Node_Record (Ada_Op_Or_Else);
         type Access_To_Subtype_For_Op_Or_Else is access all Subtype_For_Op_Or_Else;
         package Bare_Op_Or_Else_Alloc is new Alloc
           (Subtype_For_Op_Or_Else, Access_To_Subtype_For_Op_Or_Else);

         function Allocate_Op_Or_Else
           (Pool : Bump_Ptr_Pool) return Bare_Op_Or_Else;

         function Allocate_Op_Or_Else
           (Pool : Bump_Ptr_Pool) return Bare_Op_Or_Else
         is
            Result      : constant Access_To_Subtype_For_Op_Or_Else := Bare_Op_Or_Else_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Op_Or_Else;
            return Bare_Op_Or_Else (Result);
         end Allocate_Op_Or_Else;

      package Bare_Op_Plus_Memos is new Langkit_Support.Packrat
        (Bare_Op_Plus, Token_Index);

         
         subtype Subtype_For_Op_Plus is
            Root_Node_Record (Ada_Op_Plus);
         type Access_To_Subtype_For_Op_Plus is access all Subtype_For_Op_Plus;
         package Bare_Op_Plus_Alloc is new Alloc
           (Subtype_For_Op_Plus, Access_To_Subtype_For_Op_Plus);

         function Allocate_Op_Plus
           (Pool : Bump_Ptr_Pool) return Bare_Op_Plus;

         function Allocate_Op_Plus
           (Pool : Bump_Ptr_Pool) return Bare_Op_Plus
         is
            Result      : constant Access_To_Subtype_For_Op_Plus := Bare_Op_Plus_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Op_Plus;
            return Bare_Op_Plus (Result);
         end Allocate_Op_Plus;

      package Bare_Op_Pow_Memos is new Langkit_Support.Packrat
        (Bare_Op_Pow, Token_Index);

         
         subtype Subtype_For_Op_Pow is
            Root_Node_Record (Ada_Op_Pow);
         type Access_To_Subtype_For_Op_Pow is access all Subtype_For_Op_Pow;
         package Bare_Op_Pow_Alloc is new Alloc
           (Subtype_For_Op_Pow, Access_To_Subtype_For_Op_Pow);

         function Allocate_Op_Pow
           (Pool : Bump_Ptr_Pool) return Bare_Op_Pow;

         function Allocate_Op_Pow
           (Pool : Bump_Ptr_Pool) return Bare_Op_Pow
         is
            Result      : constant Access_To_Subtype_For_Op_Pow := Bare_Op_Pow_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Op_Pow;
            return Bare_Op_Pow (Result);
         end Allocate_Op_Pow;

      package Bare_Op_Rem_Memos is new Langkit_Support.Packrat
        (Bare_Op_Rem, Token_Index);

         
         subtype Subtype_For_Op_Rem is
            Root_Node_Record (Ada_Op_Rem);
         type Access_To_Subtype_For_Op_Rem is access all Subtype_For_Op_Rem;
         package Bare_Op_Rem_Alloc is new Alloc
           (Subtype_For_Op_Rem, Access_To_Subtype_For_Op_Rem);

         function Allocate_Op_Rem
           (Pool : Bump_Ptr_Pool) return Bare_Op_Rem;

         function Allocate_Op_Rem
           (Pool : Bump_Ptr_Pool) return Bare_Op_Rem
         is
            Result      : constant Access_To_Subtype_For_Op_Rem := Bare_Op_Rem_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Op_Rem;
            return Bare_Op_Rem (Result);
         end Allocate_Op_Rem;

      package Bare_Op_Xor_Memos is new Langkit_Support.Packrat
        (Bare_Op_Xor, Token_Index);

         
         subtype Subtype_For_Op_Xor is
            Root_Node_Record (Ada_Op_Xor);
         type Access_To_Subtype_For_Op_Xor is access all Subtype_For_Op_Xor;
         package Bare_Op_Xor_Alloc is new Alloc
           (Subtype_For_Op_Xor, Access_To_Subtype_For_Op_Xor);

         function Allocate_Op_Xor
           (Pool : Bump_Ptr_Pool) return Bare_Op_Xor;

         function Allocate_Op_Xor
           (Pool : Bump_Ptr_Pool) return Bare_Op_Xor
         is
            Result      : constant Access_To_Subtype_For_Op_Xor := Bare_Op_Xor_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Op_Xor;
            return Bare_Op_Xor (Result);
         end Allocate_Op_Xor;

      package Bare_String_Literal_Memos is new Langkit_Support.Packrat
        (Bare_String_Literal, Token_Index);

         
         subtype Subtype_For_String_Literal is
            Root_Node_Record (Ada_String_Literal);
         type Access_To_Subtype_For_String_Literal is access all Subtype_For_String_Literal;
         package Bare_String_Literal_Alloc is new Alloc
           (Subtype_For_String_Literal, Access_To_Subtype_For_String_Literal);

         function Allocate_String_Literal
           (Pool : Bump_Ptr_Pool) return Bare_String_Literal;

         function Allocate_String_Literal
           (Pool : Bump_Ptr_Pool) return Bare_String_Literal
         is
            Result      : constant Access_To_Subtype_For_String_Literal := Bare_String_Literal_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_String_Literal;
            return Bare_String_Literal (Result);
         end Allocate_String_Literal;

      package Bare_Null_Literal_Memos is new Langkit_Support.Packrat
        (Bare_Null_Literal, Token_Index);

         
         subtype Subtype_For_Null_Literal is
            Root_Node_Record (Ada_Null_Literal);
         type Access_To_Subtype_For_Null_Literal is access all Subtype_For_Null_Literal;
         package Bare_Null_Literal_Alloc is new Alloc
           (Subtype_For_Null_Literal, Access_To_Subtype_For_Null_Literal);

         function Allocate_Null_Literal
           (Pool : Bump_Ptr_Pool) return Bare_Null_Literal;

         function Allocate_Null_Literal
           (Pool : Bump_Ptr_Pool) return Bare_Null_Literal
         is
            Result      : constant Access_To_Subtype_For_Null_Literal := Bare_Null_Literal_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Null_Literal;
            return Bare_Null_Literal (Result);
         end Allocate_Null_Literal;

      package Bare_Num_Literal_Memos is new Langkit_Support.Packrat
        (Bare_Num_Literal, Token_Index);

      package Bare_Int_Literal_Memos is new Langkit_Support.Packrat
        (Bare_Int_Literal, Token_Index);

         
         subtype Subtype_For_Int_Literal is
            Root_Node_Record (Ada_Int_Literal);
         type Access_To_Subtype_For_Int_Literal is access all Subtype_For_Int_Literal;
         package Bare_Int_Literal_Alloc is new Alloc
           (Subtype_For_Int_Literal, Access_To_Subtype_For_Int_Literal);

         function Allocate_Int_Literal
           (Pool : Bump_Ptr_Pool) return Bare_Int_Literal;

         function Allocate_Int_Literal
           (Pool : Bump_Ptr_Pool) return Bare_Int_Literal
         is
            Result      : constant Access_To_Subtype_For_Int_Literal := Bare_Int_Literal_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Int_Literal;
            return Bare_Int_Literal (Result);
         end Allocate_Int_Literal;

      package Bare_Real_Literal_Memos is new Langkit_Support.Packrat
        (Bare_Real_Literal, Token_Index);

         
         subtype Subtype_For_Real_Literal is
            Root_Node_Record (Ada_Real_Literal);
         type Access_To_Subtype_For_Real_Literal is access all Subtype_For_Real_Literal;
         package Bare_Real_Literal_Alloc is new Alloc
           (Subtype_For_Real_Literal, Access_To_Subtype_For_Real_Literal);

         function Allocate_Real_Literal
           (Pool : Bump_Ptr_Pool) return Bare_Real_Literal;

         function Allocate_Real_Literal
           (Pool : Bump_Ptr_Pool) return Bare_Real_Literal
         is
            Result      : constant Access_To_Subtype_For_Real_Literal := Bare_Real_Literal_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Real_Literal;
            return Bare_Real_Literal (Result);
         end Allocate_Real_Literal;

      package Bare_Target_Name_Memos is new Langkit_Support.Packrat
        (Bare_Target_Name, Token_Index);

         
         subtype Subtype_For_Target_Name is
            Root_Node_Record (Ada_Target_Name);
         type Access_To_Subtype_For_Target_Name is access all Subtype_For_Target_Name;
         package Bare_Target_Name_Alloc is new Alloc
           (Subtype_For_Target_Name, Access_To_Subtype_For_Target_Name);

         function Allocate_Target_Name
           (Pool : Bump_Ptr_Pool) return Bare_Target_Name;

         function Allocate_Target_Name
           (Pool : Bump_Ptr_Pool) return Bare_Target_Name
         is
            Result      : constant Access_To_Subtype_For_Target_Name := Bare_Target_Name_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Target_Name;
            return Bare_Target_Name (Result);
         end Allocate_Target_Name;

      package Bare_Paren_Expr_Memos is new Langkit_Support.Packrat
        (Bare_Paren_Expr, Token_Index);

         
         subtype Subtype_For_Paren_Expr is
            Root_Node_Record (Ada_Paren_Expr);
         type Access_To_Subtype_For_Paren_Expr is access all Subtype_For_Paren_Expr;
         package Bare_Paren_Expr_Alloc is new Alloc
           (Subtype_For_Paren_Expr, Access_To_Subtype_For_Paren_Expr);

         function Allocate_Paren_Expr
           (Pool : Bump_Ptr_Pool) return Bare_Paren_Expr;

         function Allocate_Paren_Expr
           (Pool : Bump_Ptr_Pool) return Bare_Paren_Expr
         is
            Result      : constant Access_To_Subtype_For_Paren_Expr := Bare_Paren_Expr_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Paren_Expr;
            return Bare_Paren_Expr (Result);
         end Allocate_Paren_Expr;

      package Bare_Quantified_Expr_Memos is new Langkit_Support.Packrat
        (Bare_Quantified_Expr, Token_Index);

         
         subtype Subtype_For_Quantified_Expr is
            Root_Node_Record (Ada_Quantified_Expr);
         type Access_To_Subtype_For_Quantified_Expr is access all Subtype_For_Quantified_Expr;
         package Bare_Quantified_Expr_Alloc is new Alloc
           (Subtype_For_Quantified_Expr, Access_To_Subtype_For_Quantified_Expr);

         function Allocate_Quantified_Expr
           (Pool : Bump_Ptr_Pool) return Bare_Quantified_Expr;

         function Allocate_Quantified_Expr
           (Pool : Bump_Ptr_Pool) return Bare_Quantified_Expr
         is
            Result      : constant Access_To_Subtype_For_Quantified_Expr := Bare_Quantified_Expr_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Quantified_Expr;
            return Bare_Quantified_Expr (Result);
         end Allocate_Quantified_Expr;

      package Bare_Raise_Expr_Memos is new Langkit_Support.Packrat
        (Bare_Raise_Expr, Token_Index);

         
         subtype Subtype_For_Raise_Expr is
            Root_Node_Record (Ada_Raise_Expr);
         type Access_To_Subtype_For_Raise_Expr is access all Subtype_For_Raise_Expr;
         package Bare_Raise_Expr_Alloc is new Alloc
           (Subtype_For_Raise_Expr, Access_To_Subtype_For_Raise_Expr);

         function Allocate_Raise_Expr
           (Pool : Bump_Ptr_Pool) return Bare_Raise_Expr;

         function Allocate_Raise_Expr
           (Pool : Bump_Ptr_Pool) return Bare_Raise_Expr
         is
            Result      : constant Access_To_Subtype_For_Raise_Expr := Bare_Raise_Expr_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Raise_Expr;
            return Bare_Raise_Expr (Result);
         end Allocate_Raise_Expr;

      package Bare_Un_Op_Memos is new Langkit_Support.Packrat
        (Bare_Un_Op, Token_Index);

         
         subtype Subtype_For_Un_Op is
            Root_Node_Record (Ada_Un_Op);
         type Access_To_Subtype_For_Un_Op is access all Subtype_For_Un_Op;
         package Bare_Un_Op_Alloc is new Alloc
           (Subtype_For_Un_Op, Access_To_Subtype_For_Un_Op);

         function Allocate_Un_Op
           (Pool : Bump_Ptr_Pool) return Bare_Un_Op;

         function Allocate_Un_Op
           (Pool : Bump_Ptr_Pool) return Bare_Un_Op
         is
            Result      : constant Access_To_Subtype_For_Un_Op := Bare_Un_Op_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Un_Op;
            return Bare_Un_Op (Result);
         end Allocate_Un_Op;

      package Bare_Handled_Stmts_Memos is new Langkit_Support.Packrat
        (Bare_Handled_Stmts, Token_Index);

         
         subtype Subtype_For_Handled_Stmts is
            Root_Node_Record (Ada_Handled_Stmts);
         type Access_To_Subtype_For_Handled_Stmts is access all Subtype_For_Handled_Stmts;
         package Bare_Handled_Stmts_Alloc is new Alloc
           (Subtype_For_Handled_Stmts, Access_To_Subtype_For_Handled_Stmts);

         function Allocate_Handled_Stmts
           (Pool : Bump_Ptr_Pool) return Bare_Handled_Stmts;

         function Allocate_Handled_Stmts
           (Pool : Bump_Ptr_Pool) return Bare_Handled_Stmts
         is
            Result      : constant Access_To_Subtype_For_Handled_Stmts := Bare_Handled_Stmts_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Handled_Stmts;
            return Bare_Handled_Stmts (Result);
         end Allocate_Handled_Stmts;

      package Bare_Interface_Kind_Memos is new Langkit_Support.Packrat
        (Bare_Interface_Kind, Token_Index);

      package Bare_Interface_Kind_Limited_Memos is new Langkit_Support.Packrat
        (Bare_Interface_Kind_Limited, Token_Index);

         
         subtype Subtype_For_Interface_Kind_Limited is
            Root_Node_Record (Ada_Interface_Kind_Limited);
         type Access_To_Subtype_For_Interface_Kind_Limited is access all Subtype_For_Interface_Kind_Limited;
         package Bare_Interface_Kind_Limited_Alloc is new Alloc
           (Subtype_For_Interface_Kind_Limited, Access_To_Subtype_For_Interface_Kind_Limited);

         function Allocate_Interface_Kind_Limited
           (Pool : Bump_Ptr_Pool) return Bare_Interface_Kind_Limited;

         function Allocate_Interface_Kind_Limited
           (Pool : Bump_Ptr_Pool) return Bare_Interface_Kind_Limited
         is
            Result      : constant Access_To_Subtype_For_Interface_Kind_Limited := Bare_Interface_Kind_Limited_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Interface_Kind_Limited;
            return Bare_Interface_Kind_Limited (Result);
         end Allocate_Interface_Kind_Limited;

      package Bare_Interface_Kind_Protected_Memos is new Langkit_Support.Packrat
        (Bare_Interface_Kind_Protected, Token_Index);

         
         subtype Subtype_For_Interface_Kind_Protected is
            Root_Node_Record (Ada_Interface_Kind_Protected);
         type Access_To_Subtype_For_Interface_Kind_Protected is access all Subtype_For_Interface_Kind_Protected;
         package Bare_Interface_Kind_Protected_Alloc is new Alloc
           (Subtype_For_Interface_Kind_Protected, Access_To_Subtype_For_Interface_Kind_Protected);

         function Allocate_Interface_Kind_Protected
           (Pool : Bump_Ptr_Pool) return Bare_Interface_Kind_Protected;

         function Allocate_Interface_Kind_Protected
           (Pool : Bump_Ptr_Pool) return Bare_Interface_Kind_Protected
         is
            Result      : constant Access_To_Subtype_For_Interface_Kind_Protected := Bare_Interface_Kind_Protected_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Interface_Kind_Protected;
            return Bare_Interface_Kind_Protected (Result);
         end Allocate_Interface_Kind_Protected;

      package Bare_Interface_Kind_Synchronized_Memos is new Langkit_Support.Packrat
        (Bare_Interface_Kind_Synchronized, Token_Index);

         
         subtype Subtype_For_Interface_Kind_Synchronized is
            Root_Node_Record (Ada_Interface_Kind_Synchronized);
         type Access_To_Subtype_For_Interface_Kind_Synchronized is access all Subtype_For_Interface_Kind_Synchronized;
         package Bare_Interface_Kind_Synchronized_Alloc is new Alloc
           (Subtype_For_Interface_Kind_Synchronized, Access_To_Subtype_For_Interface_Kind_Synchronized);

         function Allocate_Interface_Kind_Synchronized
           (Pool : Bump_Ptr_Pool) return Bare_Interface_Kind_Synchronized;

         function Allocate_Interface_Kind_Synchronized
           (Pool : Bump_Ptr_Pool) return Bare_Interface_Kind_Synchronized
         is
            Result      : constant Access_To_Subtype_For_Interface_Kind_Synchronized := Bare_Interface_Kind_Synchronized_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Interface_Kind_Synchronized;
            return Bare_Interface_Kind_Synchronized (Result);
         end Allocate_Interface_Kind_Synchronized;

      package Bare_Interface_Kind_Task_Memos is new Langkit_Support.Packrat
        (Bare_Interface_Kind_Task, Token_Index);

         
         subtype Subtype_For_Interface_Kind_Task is
            Root_Node_Record (Ada_Interface_Kind_Task);
         type Access_To_Subtype_For_Interface_Kind_Task is access all Subtype_For_Interface_Kind_Task;
         package Bare_Interface_Kind_Task_Alloc is new Alloc
           (Subtype_For_Interface_Kind_Task, Access_To_Subtype_For_Interface_Kind_Task);

         function Allocate_Interface_Kind_Task
           (Pool : Bump_Ptr_Pool) return Bare_Interface_Kind_Task;

         function Allocate_Interface_Kind_Task
           (Pool : Bump_Ptr_Pool) return Bare_Interface_Kind_Task
         is
            Result      : constant Access_To_Subtype_For_Interface_Kind_Task := Bare_Interface_Kind_Task_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Interface_Kind_Task;
            return Bare_Interface_Kind_Task (Result);
         end Allocate_Interface_Kind_Task;

      package Bare_Iter_Type_Memos is new Langkit_Support.Packrat
        (Bare_Iter_Type, Token_Index);

      package Bare_Iter_Type_In_Memos is new Langkit_Support.Packrat
        (Bare_Iter_Type_In, Token_Index);

         
         subtype Subtype_For_Iter_Type_In is
            Root_Node_Record (Ada_Iter_Type_In);
         type Access_To_Subtype_For_Iter_Type_In is access all Subtype_For_Iter_Type_In;
         package Bare_Iter_Type_In_Alloc is new Alloc
           (Subtype_For_Iter_Type_In, Access_To_Subtype_For_Iter_Type_In);

         function Allocate_Iter_Type_In
           (Pool : Bump_Ptr_Pool) return Bare_Iter_Type_In;

         function Allocate_Iter_Type_In
           (Pool : Bump_Ptr_Pool) return Bare_Iter_Type_In
         is
            Result      : constant Access_To_Subtype_For_Iter_Type_In := Bare_Iter_Type_In_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Iter_Type_In;
            return Bare_Iter_Type_In (Result);
         end Allocate_Iter_Type_In;

      package Bare_Iter_Type_Of_Memos is new Langkit_Support.Packrat
        (Bare_Iter_Type_Of, Token_Index);

         
         subtype Subtype_For_Iter_Type_Of is
            Root_Node_Record (Ada_Iter_Type_Of);
         type Access_To_Subtype_For_Iter_Type_Of is access all Subtype_For_Iter_Type_Of;
         package Bare_Iter_Type_Of_Alloc is new Alloc
           (Subtype_For_Iter_Type_Of, Access_To_Subtype_For_Iter_Type_Of);

         function Allocate_Iter_Type_Of
           (Pool : Bump_Ptr_Pool) return Bare_Iter_Type_Of;

         function Allocate_Iter_Type_Of
           (Pool : Bump_Ptr_Pool) return Bare_Iter_Type_Of
         is
            Result      : constant Access_To_Subtype_For_Iter_Type_Of := Bare_Iter_Type_Of_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Iter_Type_Of;
            return Bare_Iter_Type_Of (Result);
         end Allocate_Iter_Type_Of;

      package Bare_Library_Item_Memos is new Langkit_Support.Packrat
        (Bare_Library_Item, Token_Index);

         
         subtype Subtype_For_Library_Item is
            Root_Node_Record (Ada_Library_Item);
         type Access_To_Subtype_For_Library_Item is access all Subtype_For_Library_Item;
         package Bare_Library_Item_Alloc is new Alloc
           (Subtype_For_Library_Item, Access_To_Subtype_For_Library_Item);

         function Allocate_Library_Item
           (Pool : Bump_Ptr_Pool) return Bare_Library_Item;

         function Allocate_Library_Item
           (Pool : Bump_Ptr_Pool) return Bare_Library_Item
         is
            Result      : constant Access_To_Subtype_For_Library_Item := Bare_Library_Item_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Library_Item;
            return Bare_Library_Item (Result);
         end Allocate_Library_Item;

      package Bare_Limited_Node_Memos is new Langkit_Support.Packrat
        (Bare_Limited_Node, Token_Index);

      package Bare_Limited_Absent_Memos is new Langkit_Support.Packrat
        (Bare_Limited_Absent, Token_Index);

         
         subtype Subtype_For_Limited_Absent is
            Root_Node_Record (Ada_Limited_Absent);
         type Access_To_Subtype_For_Limited_Absent is access all Subtype_For_Limited_Absent;
         package Bare_Limited_Absent_Alloc is new Alloc
           (Subtype_For_Limited_Absent, Access_To_Subtype_For_Limited_Absent);

         function Allocate_Limited_Absent
           (Pool : Bump_Ptr_Pool) return Bare_Limited_Absent;

         function Allocate_Limited_Absent
           (Pool : Bump_Ptr_Pool) return Bare_Limited_Absent
         is
            Result      : constant Access_To_Subtype_For_Limited_Absent := Bare_Limited_Absent_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Limited_Absent;
            return Bare_Limited_Absent (Result);
         end Allocate_Limited_Absent;

      package Bare_Limited_Present_Memos is new Langkit_Support.Packrat
        (Bare_Limited_Present, Token_Index);

         
         subtype Subtype_For_Limited_Present is
            Root_Node_Record (Ada_Limited_Present);
         type Access_To_Subtype_For_Limited_Present is access all Subtype_For_Limited_Present;
         package Bare_Limited_Present_Alloc is new Alloc
           (Subtype_For_Limited_Present, Access_To_Subtype_For_Limited_Present);

         function Allocate_Limited_Present
           (Pool : Bump_Ptr_Pool) return Bare_Limited_Present;

         function Allocate_Limited_Present
           (Pool : Bump_Ptr_Pool) return Bare_Limited_Present
         is
            Result      : constant Access_To_Subtype_For_Limited_Present := Bare_Limited_Present_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Limited_Present;
            return Bare_Limited_Present (Result);
         end Allocate_Limited_Present;

      package Bare_Loop_Spec_Memos is new Langkit_Support.Packrat
        (Bare_Loop_Spec, Token_Index);

      package Bare_For_Loop_Spec_Memos is new Langkit_Support.Packrat
        (Bare_For_Loop_Spec, Token_Index);

         
         subtype Subtype_For_For_Loop_Spec is
            Root_Node_Record (Ada_For_Loop_Spec);
         type Access_To_Subtype_For_For_Loop_Spec is access all Subtype_For_For_Loop_Spec;
         package Bare_For_Loop_Spec_Alloc is new Alloc
           (Subtype_For_For_Loop_Spec, Access_To_Subtype_For_For_Loop_Spec);

         function Allocate_For_Loop_Spec
           (Pool : Bump_Ptr_Pool) return Bare_For_Loop_Spec;

         function Allocate_For_Loop_Spec
           (Pool : Bump_Ptr_Pool) return Bare_For_Loop_Spec
         is
            Result      : constant Access_To_Subtype_For_For_Loop_Spec := Bare_For_Loop_Spec_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_For_Loop_Spec;
            return Bare_For_Loop_Spec (Result);
         end Allocate_For_Loop_Spec;

      package Bare_While_Loop_Spec_Memos is new Langkit_Support.Packrat
        (Bare_While_Loop_Spec, Token_Index);

         
         subtype Subtype_For_While_Loop_Spec is
            Root_Node_Record (Ada_While_Loop_Spec);
         type Access_To_Subtype_For_While_Loop_Spec is access all Subtype_For_While_Loop_Spec;
         package Bare_While_Loop_Spec_Alloc is new Alloc
           (Subtype_For_While_Loop_Spec, Access_To_Subtype_For_While_Loop_Spec);

         function Allocate_While_Loop_Spec
           (Pool : Bump_Ptr_Pool) return Bare_While_Loop_Spec;

         function Allocate_While_Loop_Spec
           (Pool : Bump_Ptr_Pool) return Bare_While_Loop_Spec
         is
            Result      : constant Access_To_Subtype_For_While_Loop_Spec := Bare_While_Loop_Spec_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_While_Loop_Spec;
            return Bare_While_Loop_Spec (Result);
         end Allocate_While_Loop_Spec;

      package Bare_Mode_Memos is new Langkit_Support.Packrat
        (Bare_Mode, Token_Index);

      package Bare_Mode_Default_Memos is new Langkit_Support.Packrat
        (Bare_Mode_Default, Token_Index);

         
         subtype Subtype_For_Mode_Default is
            Root_Node_Record (Ada_Mode_Default);
         type Access_To_Subtype_For_Mode_Default is access all Subtype_For_Mode_Default;
         package Bare_Mode_Default_Alloc is new Alloc
           (Subtype_For_Mode_Default, Access_To_Subtype_For_Mode_Default);

         function Allocate_Mode_Default
           (Pool : Bump_Ptr_Pool) return Bare_Mode_Default;

         function Allocate_Mode_Default
           (Pool : Bump_Ptr_Pool) return Bare_Mode_Default
         is
            Result      : constant Access_To_Subtype_For_Mode_Default := Bare_Mode_Default_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Mode_Default;
            return Bare_Mode_Default (Result);
         end Allocate_Mode_Default;

      package Bare_Mode_In_Memos is new Langkit_Support.Packrat
        (Bare_Mode_In, Token_Index);

         
         subtype Subtype_For_Mode_In is
            Root_Node_Record (Ada_Mode_In);
         type Access_To_Subtype_For_Mode_In is access all Subtype_For_Mode_In;
         package Bare_Mode_In_Alloc is new Alloc
           (Subtype_For_Mode_In, Access_To_Subtype_For_Mode_In);

         function Allocate_Mode_In
           (Pool : Bump_Ptr_Pool) return Bare_Mode_In;

         function Allocate_Mode_In
           (Pool : Bump_Ptr_Pool) return Bare_Mode_In
         is
            Result      : constant Access_To_Subtype_For_Mode_In := Bare_Mode_In_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Mode_In;
            return Bare_Mode_In (Result);
         end Allocate_Mode_In;

      package Bare_Mode_In_Out_Memos is new Langkit_Support.Packrat
        (Bare_Mode_In_Out, Token_Index);

         
         subtype Subtype_For_Mode_In_Out is
            Root_Node_Record (Ada_Mode_In_Out);
         type Access_To_Subtype_For_Mode_In_Out is access all Subtype_For_Mode_In_Out;
         package Bare_Mode_In_Out_Alloc is new Alloc
           (Subtype_For_Mode_In_Out, Access_To_Subtype_For_Mode_In_Out);

         function Allocate_Mode_In_Out
           (Pool : Bump_Ptr_Pool) return Bare_Mode_In_Out;

         function Allocate_Mode_In_Out
           (Pool : Bump_Ptr_Pool) return Bare_Mode_In_Out
         is
            Result      : constant Access_To_Subtype_For_Mode_In_Out := Bare_Mode_In_Out_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Mode_In_Out;
            return Bare_Mode_In_Out (Result);
         end Allocate_Mode_In_Out;

      package Bare_Mode_Out_Memos is new Langkit_Support.Packrat
        (Bare_Mode_Out, Token_Index);

         
         subtype Subtype_For_Mode_Out is
            Root_Node_Record (Ada_Mode_Out);
         type Access_To_Subtype_For_Mode_Out is access all Subtype_For_Mode_Out;
         package Bare_Mode_Out_Alloc is new Alloc
           (Subtype_For_Mode_Out, Access_To_Subtype_For_Mode_Out);

         function Allocate_Mode_Out
           (Pool : Bump_Ptr_Pool) return Bare_Mode_Out;

         function Allocate_Mode_Out
           (Pool : Bump_Ptr_Pool) return Bare_Mode_Out
         is
            Result      : constant Access_To_Subtype_For_Mode_Out := Bare_Mode_Out_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Mode_Out;
            return Bare_Mode_Out (Result);
         end Allocate_Mode_Out;

      package Bare_Not_Null_Memos is new Langkit_Support.Packrat
        (Bare_Not_Null, Token_Index);

      package Bare_Not_Null_Absent_Memos is new Langkit_Support.Packrat
        (Bare_Not_Null_Absent, Token_Index);

         
         subtype Subtype_For_Not_Null_Absent is
            Root_Node_Record (Ada_Not_Null_Absent);
         type Access_To_Subtype_For_Not_Null_Absent is access all Subtype_For_Not_Null_Absent;
         package Bare_Not_Null_Absent_Alloc is new Alloc
           (Subtype_For_Not_Null_Absent, Access_To_Subtype_For_Not_Null_Absent);

         function Allocate_Not_Null_Absent
           (Pool : Bump_Ptr_Pool) return Bare_Not_Null_Absent;

         function Allocate_Not_Null_Absent
           (Pool : Bump_Ptr_Pool) return Bare_Not_Null_Absent
         is
            Result      : constant Access_To_Subtype_For_Not_Null_Absent := Bare_Not_Null_Absent_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Not_Null_Absent;
            return Bare_Not_Null_Absent (Result);
         end Allocate_Not_Null_Absent;

      package Bare_Not_Null_Present_Memos is new Langkit_Support.Packrat
        (Bare_Not_Null_Present, Token_Index);

         
         subtype Subtype_For_Not_Null_Present is
            Root_Node_Record (Ada_Not_Null_Present);
         type Access_To_Subtype_For_Not_Null_Present is access all Subtype_For_Not_Null_Present;
         package Bare_Not_Null_Present_Alloc is new Alloc
           (Subtype_For_Not_Null_Present, Access_To_Subtype_For_Not_Null_Present);

         function Allocate_Not_Null_Present
           (Pool : Bump_Ptr_Pool) return Bare_Not_Null_Present;

         function Allocate_Not_Null_Present
           (Pool : Bump_Ptr_Pool) return Bare_Not_Null_Present
         is
            Result      : constant Access_To_Subtype_For_Not_Null_Present := Bare_Not_Null_Present_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Not_Null_Present;
            return Bare_Not_Null_Present (Result);
         end Allocate_Not_Null_Present;

      package Bare_Null_Component_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Null_Component_Decl, Token_Index);

         
         subtype Subtype_For_Null_Component_Decl is
            Root_Node_Record (Ada_Null_Component_Decl);
         type Access_To_Subtype_For_Null_Component_Decl is access all Subtype_For_Null_Component_Decl;
         package Bare_Null_Component_Decl_Alloc is new Alloc
           (Subtype_For_Null_Component_Decl, Access_To_Subtype_For_Null_Component_Decl);

         function Allocate_Null_Component_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Null_Component_Decl;

         function Allocate_Null_Component_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Null_Component_Decl
         is
            Result      : constant Access_To_Subtype_For_Null_Component_Decl := Bare_Null_Component_Decl_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Null_Component_Decl;
            return Bare_Null_Component_Decl (Result);
         end Allocate_Null_Component_Decl;

      package Bare_Others_Designator_Memos is new Langkit_Support.Packrat
        (Bare_Others_Designator, Token_Index);

         
         subtype Subtype_For_Others_Designator is
            Root_Node_Record (Ada_Others_Designator);
         type Access_To_Subtype_For_Others_Designator is access all Subtype_For_Others_Designator;
         package Bare_Others_Designator_Alloc is new Alloc
           (Subtype_For_Others_Designator, Access_To_Subtype_For_Others_Designator);

         function Allocate_Others_Designator
           (Pool : Bump_Ptr_Pool) return Bare_Others_Designator;

         function Allocate_Others_Designator
           (Pool : Bump_Ptr_Pool) return Bare_Others_Designator
         is
            Result      : constant Access_To_Subtype_For_Others_Designator := Bare_Others_Designator_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Others_Designator;
            return Bare_Others_Designator (Result);
         end Allocate_Others_Designator;

      package Bare_Overriding_Node_Memos is new Langkit_Support.Packrat
        (Bare_Overriding_Node, Token_Index);

      package Bare_Overriding_Not_Overriding_Memos is new Langkit_Support.Packrat
        (Bare_Overriding_Not_Overriding, Token_Index);

         
         subtype Subtype_For_Overriding_Not_Overriding is
            Root_Node_Record (Ada_Overriding_Not_Overriding);
         type Access_To_Subtype_For_Overriding_Not_Overriding is access all Subtype_For_Overriding_Not_Overriding;
         package Bare_Overriding_Not_Overriding_Alloc is new Alloc
           (Subtype_For_Overriding_Not_Overriding, Access_To_Subtype_For_Overriding_Not_Overriding);

         function Allocate_Overriding_Not_Overriding
           (Pool : Bump_Ptr_Pool) return Bare_Overriding_Not_Overriding;

         function Allocate_Overriding_Not_Overriding
           (Pool : Bump_Ptr_Pool) return Bare_Overriding_Not_Overriding
         is
            Result      : constant Access_To_Subtype_For_Overriding_Not_Overriding := Bare_Overriding_Not_Overriding_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Overriding_Not_Overriding;
            return Bare_Overriding_Not_Overriding (Result);
         end Allocate_Overriding_Not_Overriding;

      package Bare_Overriding_Overriding_Memos is new Langkit_Support.Packrat
        (Bare_Overriding_Overriding, Token_Index);

         
         subtype Subtype_For_Overriding_Overriding is
            Root_Node_Record (Ada_Overriding_Overriding);
         type Access_To_Subtype_For_Overriding_Overriding is access all Subtype_For_Overriding_Overriding;
         package Bare_Overriding_Overriding_Alloc is new Alloc
           (Subtype_For_Overriding_Overriding, Access_To_Subtype_For_Overriding_Overriding);

         function Allocate_Overriding_Overriding
           (Pool : Bump_Ptr_Pool) return Bare_Overriding_Overriding;

         function Allocate_Overriding_Overriding
           (Pool : Bump_Ptr_Pool) return Bare_Overriding_Overriding
         is
            Result      : constant Access_To_Subtype_For_Overriding_Overriding := Bare_Overriding_Overriding_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Overriding_Overriding;
            return Bare_Overriding_Overriding (Result);
         end Allocate_Overriding_Overriding;

      package Bare_Overriding_Unspecified_Memos is new Langkit_Support.Packrat
        (Bare_Overriding_Unspecified, Token_Index);

         
         subtype Subtype_For_Overriding_Unspecified is
            Root_Node_Record (Ada_Overriding_Unspecified);
         type Access_To_Subtype_For_Overriding_Unspecified is access all Subtype_For_Overriding_Unspecified;
         package Bare_Overriding_Unspecified_Alloc is new Alloc
           (Subtype_For_Overriding_Unspecified, Access_To_Subtype_For_Overriding_Unspecified);

         function Allocate_Overriding_Unspecified
           (Pool : Bump_Ptr_Pool) return Bare_Overriding_Unspecified;

         function Allocate_Overriding_Unspecified
           (Pool : Bump_Ptr_Pool) return Bare_Overriding_Unspecified
         is
            Result      : constant Access_To_Subtype_For_Overriding_Unspecified := Bare_Overriding_Unspecified_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Overriding_Unspecified;
            return Bare_Overriding_Unspecified (Result);
         end Allocate_Overriding_Unspecified;

      package Bare_Params_Memos is new Langkit_Support.Packrat
        (Bare_Params, Token_Index);

         
         subtype Subtype_For_Params is
            Root_Node_Record (Ada_Params);
         type Access_To_Subtype_For_Params is access all Subtype_For_Params;
         package Bare_Params_Alloc is new Alloc
           (Subtype_For_Params, Access_To_Subtype_For_Params);

         function Allocate_Params
           (Pool : Bump_Ptr_Pool) return Bare_Params;

         function Allocate_Params
           (Pool : Bump_Ptr_Pool) return Bare_Params
         is
            Result      : constant Access_To_Subtype_For_Params := Bare_Params_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Params;
            return Bare_Params (Result);
         end Allocate_Params;

      package Bare_Pragma_Node_Memos is new Langkit_Support.Packrat
        (Bare_Pragma_Node, Token_Index);

         
         subtype Subtype_For_Pragma_Node is
            Root_Node_Record (Ada_Pragma_Node);
         type Access_To_Subtype_For_Pragma_Node is access all Subtype_For_Pragma_Node;
         package Bare_Pragma_Node_Alloc is new Alloc
           (Subtype_For_Pragma_Node, Access_To_Subtype_For_Pragma_Node);

         function Allocate_Pragma_Node
           (Pool : Bump_Ptr_Pool) return Bare_Pragma_Node;

         function Allocate_Pragma_Node
           (Pool : Bump_Ptr_Pool) return Bare_Pragma_Node
         is
            Result      : constant Access_To_Subtype_For_Pragma_Node := Bare_Pragma_Node_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Pragma_Node;
            return Bare_Pragma_Node (Result);
         end Allocate_Pragma_Node;

      package Bare_Prim_Type_Accessor_Memos is new Langkit_Support.Packrat
        (Bare_Prim_Type_Accessor, Token_Index);

         
         subtype Subtype_For_Prim_Type_Accessor is
            Root_Node_Record (Ada_Prim_Type_Accessor);
         type Access_To_Subtype_For_Prim_Type_Accessor is access all Subtype_For_Prim_Type_Accessor;
         package Bare_Prim_Type_Accessor_Alloc is new Alloc
           (Subtype_For_Prim_Type_Accessor, Access_To_Subtype_For_Prim_Type_Accessor);

         function Allocate_Prim_Type_Accessor
           (Pool : Bump_Ptr_Pool) return Bare_Prim_Type_Accessor;

         function Allocate_Prim_Type_Accessor
           (Pool : Bump_Ptr_Pool) return Bare_Prim_Type_Accessor
         is
            Result      : constant Access_To_Subtype_For_Prim_Type_Accessor := Bare_Prim_Type_Accessor_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Prim_Type_Accessor;
            return Bare_Prim_Type_Accessor (Result);
         end Allocate_Prim_Type_Accessor;

      package Bare_Private_Node_Memos is new Langkit_Support.Packrat
        (Bare_Private_Node, Token_Index);

      package Bare_Private_Absent_Memos is new Langkit_Support.Packrat
        (Bare_Private_Absent, Token_Index);

         
         subtype Subtype_For_Private_Absent is
            Root_Node_Record (Ada_Private_Absent);
         type Access_To_Subtype_For_Private_Absent is access all Subtype_For_Private_Absent;
         package Bare_Private_Absent_Alloc is new Alloc
           (Subtype_For_Private_Absent, Access_To_Subtype_For_Private_Absent);

         function Allocate_Private_Absent
           (Pool : Bump_Ptr_Pool) return Bare_Private_Absent;

         function Allocate_Private_Absent
           (Pool : Bump_Ptr_Pool) return Bare_Private_Absent
         is
            Result      : constant Access_To_Subtype_For_Private_Absent := Bare_Private_Absent_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Private_Absent;
            return Bare_Private_Absent (Result);
         end Allocate_Private_Absent;

      package Bare_Private_Present_Memos is new Langkit_Support.Packrat
        (Bare_Private_Present, Token_Index);

         
         subtype Subtype_For_Private_Present is
            Root_Node_Record (Ada_Private_Present);
         type Access_To_Subtype_For_Private_Present is access all Subtype_For_Private_Present;
         package Bare_Private_Present_Alloc is new Alloc
           (Subtype_For_Private_Present, Access_To_Subtype_For_Private_Present);

         function Allocate_Private_Present
           (Pool : Bump_Ptr_Pool) return Bare_Private_Present;

         function Allocate_Private_Present
           (Pool : Bump_Ptr_Pool) return Bare_Private_Present
         is
            Result      : constant Access_To_Subtype_For_Private_Present := Bare_Private_Present_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Private_Present;
            return Bare_Private_Present (Result);
         end Allocate_Private_Present;

      package Bare_Protected_Def_Memos is new Langkit_Support.Packrat
        (Bare_Protected_Def, Token_Index);

         
         subtype Subtype_For_Protected_Def is
            Root_Node_Record (Ada_Protected_Def);
         type Access_To_Subtype_For_Protected_Def is access all Subtype_For_Protected_Def;
         package Bare_Protected_Def_Alloc is new Alloc
           (Subtype_For_Protected_Def, Access_To_Subtype_For_Protected_Def);

         function Allocate_Protected_Def
           (Pool : Bump_Ptr_Pool) return Bare_Protected_Def;

         function Allocate_Protected_Def
           (Pool : Bump_Ptr_Pool) return Bare_Protected_Def
         is
            Result      : constant Access_To_Subtype_For_Protected_Def := Bare_Protected_Def_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Protected_Def;
            return Bare_Protected_Def (Result);
         end Allocate_Protected_Def;

      package Bare_Protected_Node_Memos is new Langkit_Support.Packrat
        (Bare_Protected_Node, Token_Index);

      package Bare_Protected_Absent_Memos is new Langkit_Support.Packrat
        (Bare_Protected_Absent, Token_Index);

         
         subtype Subtype_For_Protected_Absent is
            Root_Node_Record (Ada_Protected_Absent);
         type Access_To_Subtype_For_Protected_Absent is access all Subtype_For_Protected_Absent;
         package Bare_Protected_Absent_Alloc is new Alloc
           (Subtype_For_Protected_Absent, Access_To_Subtype_For_Protected_Absent);

         function Allocate_Protected_Absent
           (Pool : Bump_Ptr_Pool) return Bare_Protected_Absent;

         function Allocate_Protected_Absent
           (Pool : Bump_Ptr_Pool) return Bare_Protected_Absent
         is
            Result      : constant Access_To_Subtype_For_Protected_Absent := Bare_Protected_Absent_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Protected_Absent;
            return Bare_Protected_Absent (Result);
         end Allocate_Protected_Absent;

      package Bare_Protected_Present_Memos is new Langkit_Support.Packrat
        (Bare_Protected_Present, Token_Index);

         
         subtype Subtype_For_Protected_Present is
            Root_Node_Record (Ada_Protected_Present);
         type Access_To_Subtype_For_Protected_Present is access all Subtype_For_Protected_Present;
         package Bare_Protected_Present_Alloc is new Alloc
           (Subtype_For_Protected_Present, Access_To_Subtype_For_Protected_Present);

         function Allocate_Protected_Present
           (Pool : Bump_Ptr_Pool) return Bare_Protected_Present;

         function Allocate_Protected_Present
           (Pool : Bump_Ptr_Pool) return Bare_Protected_Present
         is
            Result      : constant Access_To_Subtype_For_Protected_Present := Bare_Protected_Present_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Protected_Present;
            return Bare_Protected_Present (Result);
         end Allocate_Protected_Present;

      package Bare_Quantifier_Memos is new Langkit_Support.Packrat
        (Bare_Quantifier, Token_Index);

      package Bare_Quantifier_All_Memos is new Langkit_Support.Packrat
        (Bare_Quantifier_All, Token_Index);

         
         subtype Subtype_For_Quantifier_All is
            Root_Node_Record (Ada_Quantifier_All);
         type Access_To_Subtype_For_Quantifier_All is access all Subtype_For_Quantifier_All;
         package Bare_Quantifier_All_Alloc is new Alloc
           (Subtype_For_Quantifier_All, Access_To_Subtype_For_Quantifier_All);

         function Allocate_Quantifier_All
           (Pool : Bump_Ptr_Pool) return Bare_Quantifier_All;

         function Allocate_Quantifier_All
           (Pool : Bump_Ptr_Pool) return Bare_Quantifier_All
         is
            Result      : constant Access_To_Subtype_For_Quantifier_All := Bare_Quantifier_All_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Quantifier_All;
            return Bare_Quantifier_All (Result);
         end Allocate_Quantifier_All;

      package Bare_Quantifier_Some_Memos is new Langkit_Support.Packrat
        (Bare_Quantifier_Some, Token_Index);

         
         subtype Subtype_For_Quantifier_Some is
            Root_Node_Record (Ada_Quantifier_Some);
         type Access_To_Subtype_For_Quantifier_Some is access all Subtype_For_Quantifier_Some;
         package Bare_Quantifier_Some_Alloc is new Alloc
           (Subtype_For_Quantifier_Some, Access_To_Subtype_For_Quantifier_Some);

         function Allocate_Quantifier_Some
           (Pool : Bump_Ptr_Pool) return Bare_Quantifier_Some;

         function Allocate_Quantifier_Some
           (Pool : Bump_Ptr_Pool) return Bare_Quantifier_Some
         is
            Result      : constant Access_To_Subtype_For_Quantifier_Some := Bare_Quantifier_Some_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Quantifier_Some;
            return Bare_Quantifier_Some (Result);
         end Allocate_Quantifier_Some;

      package Bare_Range_Spec_Memos is new Langkit_Support.Packrat
        (Bare_Range_Spec, Token_Index);

         
         subtype Subtype_For_Range_Spec is
            Root_Node_Record (Ada_Range_Spec);
         type Access_To_Subtype_For_Range_Spec is access all Subtype_For_Range_Spec;
         package Bare_Range_Spec_Alloc is new Alloc
           (Subtype_For_Range_Spec, Access_To_Subtype_For_Range_Spec);

         function Allocate_Range_Spec
           (Pool : Bump_Ptr_Pool) return Bare_Range_Spec;

         function Allocate_Range_Spec
           (Pool : Bump_Ptr_Pool) return Bare_Range_Spec
         is
            Result      : constant Access_To_Subtype_For_Range_Spec := Bare_Range_Spec_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Range_Spec;
            return Bare_Range_Spec (Result);
         end Allocate_Range_Spec;

      package Bare_Renaming_Clause_Memos is new Langkit_Support.Packrat
        (Bare_Renaming_Clause, Token_Index);

         
         subtype Subtype_For_Renaming_Clause is
            Root_Node_Record (Ada_Renaming_Clause);
         type Access_To_Subtype_For_Renaming_Clause is access all Subtype_For_Renaming_Clause;
         package Bare_Renaming_Clause_Alloc is new Alloc
           (Subtype_For_Renaming_Clause, Access_To_Subtype_For_Renaming_Clause);

         function Allocate_Renaming_Clause
           (Pool : Bump_Ptr_Pool) return Bare_Renaming_Clause;

         function Allocate_Renaming_Clause
           (Pool : Bump_Ptr_Pool) return Bare_Renaming_Clause
         is
            Result      : constant Access_To_Subtype_For_Renaming_Clause := Bare_Renaming_Clause_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Renaming_Clause;
            return Bare_Renaming_Clause (Result);
         end Allocate_Renaming_Clause;

      package Bare_Synthetic_Renaming_Clause_Memos is new Langkit_Support.Packrat
        (Bare_Synthetic_Renaming_Clause, Token_Index);

         
         subtype Subtype_For_Synthetic_Renaming_Clause is
            Root_Node_Record (Ada_Synthetic_Renaming_Clause);
         type Access_To_Subtype_For_Synthetic_Renaming_Clause is access all Subtype_For_Synthetic_Renaming_Clause;
         package Bare_Synthetic_Renaming_Clause_Alloc is new Alloc
           (Subtype_For_Synthetic_Renaming_Clause, Access_To_Subtype_For_Synthetic_Renaming_Clause);

         function Allocate_Synthetic_Renaming_Clause
           (Pool : Bump_Ptr_Pool) return Bare_Synthetic_Renaming_Clause;

         function Allocate_Synthetic_Renaming_Clause
           (Pool : Bump_Ptr_Pool) return Bare_Synthetic_Renaming_Clause
         is
            Result      : constant Access_To_Subtype_For_Synthetic_Renaming_Clause := Bare_Synthetic_Renaming_Clause_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Synthetic_Renaming_Clause;
            return Bare_Synthetic_Renaming_Clause (Result);
         end Allocate_Synthetic_Renaming_Clause;

      package Bare_Reverse_Node_Memos is new Langkit_Support.Packrat
        (Bare_Reverse_Node, Token_Index);

      package Bare_Reverse_Absent_Memos is new Langkit_Support.Packrat
        (Bare_Reverse_Absent, Token_Index);

         
         subtype Subtype_For_Reverse_Absent is
            Root_Node_Record (Ada_Reverse_Absent);
         type Access_To_Subtype_For_Reverse_Absent is access all Subtype_For_Reverse_Absent;
         package Bare_Reverse_Absent_Alloc is new Alloc
           (Subtype_For_Reverse_Absent, Access_To_Subtype_For_Reverse_Absent);

         function Allocate_Reverse_Absent
           (Pool : Bump_Ptr_Pool) return Bare_Reverse_Absent;

         function Allocate_Reverse_Absent
           (Pool : Bump_Ptr_Pool) return Bare_Reverse_Absent
         is
            Result      : constant Access_To_Subtype_For_Reverse_Absent := Bare_Reverse_Absent_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Reverse_Absent;
            return Bare_Reverse_Absent (Result);
         end Allocate_Reverse_Absent;

      package Bare_Reverse_Present_Memos is new Langkit_Support.Packrat
        (Bare_Reverse_Present, Token_Index);

         
         subtype Subtype_For_Reverse_Present is
            Root_Node_Record (Ada_Reverse_Present);
         type Access_To_Subtype_For_Reverse_Present is access all Subtype_For_Reverse_Present;
         package Bare_Reverse_Present_Alloc is new Alloc
           (Subtype_For_Reverse_Present, Access_To_Subtype_For_Reverse_Present);

         function Allocate_Reverse_Present
           (Pool : Bump_Ptr_Pool) return Bare_Reverse_Present;

         function Allocate_Reverse_Present
           (Pool : Bump_Ptr_Pool) return Bare_Reverse_Present
         is
            Result      : constant Access_To_Subtype_For_Reverse_Present := Bare_Reverse_Present_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Reverse_Present;
            return Bare_Reverse_Present (Result);
         end Allocate_Reverse_Present;

      package Bare_Select_When_Part_Memos is new Langkit_Support.Packrat
        (Bare_Select_When_Part, Token_Index);

         
         subtype Subtype_For_Select_When_Part is
            Root_Node_Record (Ada_Select_When_Part);
         type Access_To_Subtype_For_Select_When_Part is access all Subtype_For_Select_When_Part;
         package Bare_Select_When_Part_Alloc is new Alloc
           (Subtype_For_Select_When_Part, Access_To_Subtype_For_Select_When_Part);

         function Allocate_Select_When_Part
           (Pool : Bump_Ptr_Pool) return Bare_Select_When_Part;

         function Allocate_Select_When_Part
           (Pool : Bump_Ptr_Pool) return Bare_Select_When_Part
         is
            Result      : constant Access_To_Subtype_For_Select_When_Part := Bare_Select_When_Part_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Select_When_Part;
            return Bare_Select_When_Part (Result);
         end Allocate_Select_When_Part;

      package Bare_Stmt_Memos is new Langkit_Support.Packrat
        (Bare_Stmt, Token_Index);

      package Bare_Composite_Stmt_Memos is new Langkit_Support.Packrat
        (Bare_Composite_Stmt, Token_Index);

      package Bare_Accept_Stmt_Memos is new Langkit_Support.Packrat
        (Bare_Accept_Stmt, Token_Index);

         
         subtype Subtype_For_Accept_Stmt is
            Root_Node_Record (Ada_Accept_Stmt);
         type Access_To_Subtype_For_Accept_Stmt is access all Subtype_For_Accept_Stmt;
         package Bare_Accept_Stmt_Alloc is new Alloc
           (Subtype_For_Accept_Stmt, Access_To_Subtype_For_Accept_Stmt);

         function Allocate_Accept_Stmt
           (Pool : Bump_Ptr_Pool) return Bare_Accept_Stmt;

         function Allocate_Accept_Stmt
           (Pool : Bump_Ptr_Pool) return Bare_Accept_Stmt
         is
            Result      : constant Access_To_Subtype_For_Accept_Stmt := Bare_Accept_Stmt_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Accept_Stmt;
            return Bare_Accept_Stmt (Result);
         end Allocate_Accept_Stmt;

      package Bare_Accept_Stmt_With_Stmts_Memos is new Langkit_Support.Packrat
        (Bare_Accept_Stmt_With_Stmts, Token_Index);

         
         subtype Subtype_For_Accept_Stmt_With_Stmts is
            Root_Node_Record (Ada_Accept_Stmt_With_Stmts);
         type Access_To_Subtype_For_Accept_Stmt_With_Stmts is access all Subtype_For_Accept_Stmt_With_Stmts;
         package Bare_Accept_Stmt_With_Stmts_Alloc is new Alloc
           (Subtype_For_Accept_Stmt_With_Stmts, Access_To_Subtype_For_Accept_Stmt_With_Stmts);

         function Allocate_Accept_Stmt_With_Stmts
           (Pool : Bump_Ptr_Pool) return Bare_Accept_Stmt_With_Stmts;

         function Allocate_Accept_Stmt_With_Stmts
           (Pool : Bump_Ptr_Pool) return Bare_Accept_Stmt_With_Stmts
         is
            Result      : constant Access_To_Subtype_For_Accept_Stmt_With_Stmts := Bare_Accept_Stmt_With_Stmts_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Accept_Stmt_With_Stmts;
            return Bare_Accept_Stmt_With_Stmts (Result);
         end Allocate_Accept_Stmt_With_Stmts;

      package Bare_Base_Loop_Stmt_Memos is new Langkit_Support.Packrat
        (Bare_Base_Loop_Stmt, Token_Index);

      package Bare_For_Loop_Stmt_Memos is new Langkit_Support.Packrat
        (Bare_For_Loop_Stmt, Token_Index);

         
         subtype Subtype_For_For_Loop_Stmt is
            Root_Node_Record (Ada_For_Loop_Stmt);
         type Access_To_Subtype_For_For_Loop_Stmt is access all Subtype_For_For_Loop_Stmt;
         package Bare_For_Loop_Stmt_Alloc is new Alloc
           (Subtype_For_For_Loop_Stmt, Access_To_Subtype_For_For_Loop_Stmt);

         function Allocate_For_Loop_Stmt
           (Pool : Bump_Ptr_Pool) return Bare_For_Loop_Stmt;

         function Allocate_For_Loop_Stmt
           (Pool : Bump_Ptr_Pool) return Bare_For_Loop_Stmt
         is
            Result      : constant Access_To_Subtype_For_For_Loop_Stmt := Bare_For_Loop_Stmt_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_For_Loop_Stmt;
            return Bare_For_Loop_Stmt (Result);
         end Allocate_For_Loop_Stmt;

      package Bare_Loop_Stmt_Memos is new Langkit_Support.Packrat
        (Bare_Loop_Stmt, Token_Index);

         
         subtype Subtype_For_Loop_Stmt is
            Root_Node_Record (Ada_Loop_Stmt);
         type Access_To_Subtype_For_Loop_Stmt is access all Subtype_For_Loop_Stmt;
         package Bare_Loop_Stmt_Alloc is new Alloc
           (Subtype_For_Loop_Stmt, Access_To_Subtype_For_Loop_Stmt);

         function Allocate_Loop_Stmt
           (Pool : Bump_Ptr_Pool) return Bare_Loop_Stmt;

         function Allocate_Loop_Stmt
           (Pool : Bump_Ptr_Pool) return Bare_Loop_Stmt
         is
            Result      : constant Access_To_Subtype_For_Loop_Stmt := Bare_Loop_Stmt_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Loop_Stmt;
            return Bare_Loop_Stmt (Result);
         end Allocate_Loop_Stmt;

      package Bare_While_Loop_Stmt_Memos is new Langkit_Support.Packrat
        (Bare_While_Loop_Stmt, Token_Index);

         
         subtype Subtype_For_While_Loop_Stmt is
            Root_Node_Record (Ada_While_Loop_Stmt);
         type Access_To_Subtype_For_While_Loop_Stmt is access all Subtype_For_While_Loop_Stmt;
         package Bare_While_Loop_Stmt_Alloc is new Alloc
           (Subtype_For_While_Loop_Stmt, Access_To_Subtype_For_While_Loop_Stmt);

         function Allocate_While_Loop_Stmt
           (Pool : Bump_Ptr_Pool) return Bare_While_Loop_Stmt;

         function Allocate_While_Loop_Stmt
           (Pool : Bump_Ptr_Pool) return Bare_While_Loop_Stmt
         is
            Result      : constant Access_To_Subtype_For_While_Loop_Stmt := Bare_While_Loop_Stmt_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_While_Loop_Stmt;
            return Bare_While_Loop_Stmt (Result);
         end Allocate_While_Loop_Stmt;

      package Bare_Block_Stmt_Memos is new Langkit_Support.Packrat
        (Bare_Block_Stmt, Token_Index);

      package Bare_Begin_Block_Memos is new Langkit_Support.Packrat
        (Bare_Begin_Block, Token_Index);

         
         subtype Subtype_For_Begin_Block is
            Root_Node_Record (Ada_Begin_Block);
         type Access_To_Subtype_For_Begin_Block is access all Subtype_For_Begin_Block;
         package Bare_Begin_Block_Alloc is new Alloc
           (Subtype_For_Begin_Block, Access_To_Subtype_For_Begin_Block);

         function Allocate_Begin_Block
           (Pool : Bump_Ptr_Pool) return Bare_Begin_Block;

         function Allocate_Begin_Block
           (Pool : Bump_Ptr_Pool) return Bare_Begin_Block
         is
            Result      : constant Access_To_Subtype_For_Begin_Block := Bare_Begin_Block_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Begin_Block;
            return Bare_Begin_Block (Result);
         end Allocate_Begin_Block;

      package Bare_Decl_Block_Memos is new Langkit_Support.Packrat
        (Bare_Decl_Block, Token_Index);

         
         subtype Subtype_For_Decl_Block is
            Root_Node_Record (Ada_Decl_Block);
         type Access_To_Subtype_For_Decl_Block is access all Subtype_For_Decl_Block;
         package Bare_Decl_Block_Alloc is new Alloc
           (Subtype_For_Decl_Block, Access_To_Subtype_For_Decl_Block);

         function Allocate_Decl_Block
           (Pool : Bump_Ptr_Pool) return Bare_Decl_Block;

         function Allocate_Decl_Block
           (Pool : Bump_Ptr_Pool) return Bare_Decl_Block
         is
            Result      : constant Access_To_Subtype_For_Decl_Block := Bare_Decl_Block_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Decl_Block;
            return Bare_Decl_Block (Result);
         end Allocate_Decl_Block;

      package Bare_Case_Stmt_Memos is new Langkit_Support.Packrat
        (Bare_Case_Stmt, Token_Index);

         
         subtype Subtype_For_Case_Stmt is
            Root_Node_Record (Ada_Case_Stmt);
         type Access_To_Subtype_For_Case_Stmt is access all Subtype_For_Case_Stmt;
         package Bare_Case_Stmt_Alloc is new Alloc
           (Subtype_For_Case_Stmt, Access_To_Subtype_For_Case_Stmt);

         function Allocate_Case_Stmt
           (Pool : Bump_Ptr_Pool) return Bare_Case_Stmt;

         function Allocate_Case_Stmt
           (Pool : Bump_Ptr_Pool) return Bare_Case_Stmt
         is
            Result      : constant Access_To_Subtype_For_Case_Stmt := Bare_Case_Stmt_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Case_Stmt;
            return Bare_Case_Stmt (Result);
         end Allocate_Case_Stmt;

      package Bare_Extended_Return_Stmt_Memos is new Langkit_Support.Packrat
        (Bare_Extended_Return_Stmt, Token_Index);

         
         subtype Subtype_For_Extended_Return_Stmt is
            Root_Node_Record (Ada_Extended_Return_Stmt);
         type Access_To_Subtype_For_Extended_Return_Stmt is access all Subtype_For_Extended_Return_Stmt;
         package Bare_Extended_Return_Stmt_Alloc is new Alloc
           (Subtype_For_Extended_Return_Stmt, Access_To_Subtype_For_Extended_Return_Stmt);

         function Allocate_Extended_Return_Stmt
           (Pool : Bump_Ptr_Pool) return Bare_Extended_Return_Stmt;

         function Allocate_Extended_Return_Stmt
           (Pool : Bump_Ptr_Pool) return Bare_Extended_Return_Stmt
         is
            Result      : constant Access_To_Subtype_For_Extended_Return_Stmt := Bare_Extended_Return_Stmt_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Extended_Return_Stmt;
            return Bare_Extended_Return_Stmt (Result);
         end Allocate_Extended_Return_Stmt;

      package Bare_If_Stmt_Memos is new Langkit_Support.Packrat
        (Bare_If_Stmt, Token_Index);

         
         subtype Subtype_For_If_Stmt is
            Root_Node_Record (Ada_If_Stmt);
         type Access_To_Subtype_For_If_Stmt is access all Subtype_For_If_Stmt;
         package Bare_If_Stmt_Alloc is new Alloc
           (Subtype_For_If_Stmt, Access_To_Subtype_For_If_Stmt);

         function Allocate_If_Stmt
           (Pool : Bump_Ptr_Pool) return Bare_If_Stmt;

         function Allocate_If_Stmt
           (Pool : Bump_Ptr_Pool) return Bare_If_Stmt
         is
            Result      : constant Access_To_Subtype_For_If_Stmt := Bare_If_Stmt_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_If_Stmt;
            return Bare_If_Stmt (Result);
         end Allocate_If_Stmt;

      package Bare_Named_Stmt_Memos is new Langkit_Support.Packrat
        (Bare_Named_Stmt, Token_Index);

         
         subtype Subtype_For_Named_Stmt is
            Root_Node_Record (Ada_Named_Stmt);
         type Access_To_Subtype_For_Named_Stmt is access all Subtype_For_Named_Stmt;
         package Bare_Named_Stmt_Alloc is new Alloc
           (Subtype_For_Named_Stmt, Access_To_Subtype_For_Named_Stmt);

         function Allocate_Named_Stmt
           (Pool : Bump_Ptr_Pool) return Bare_Named_Stmt;

         function Allocate_Named_Stmt
           (Pool : Bump_Ptr_Pool) return Bare_Named_Stmt
         is
            Result      : constant Access_To_Subtype_For_Named_Stmt := Bare_Named_Stmt_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Named_Stmt;
            return Bare_Named_Stmt (Result);
         end Allocate_Named_Stmt;

      package Bare_Select_Stmt_Memos is new Langkit_Support.Packrat
        (Bare_Select_Stmt, Token_Index);

         
         subtype Subtype_For_Select_Stmt is
            Root_Node_Record (Ada_Select_Stmt);
         type Access_To_Subtype_For_Select_Stmt is access all Subtype_For_Select_Stmt;
         package Bare_Select_Stmt_Alloc is new Alloc
           (Subtype_For_Select_Stmt, Access_To_Subtype_For_Select_Stmt);

         function Allocate_Select_Stmt
           (Pool : Bump_Ptr_Pool) return Bare_Select_Stmt;

         function Allocate_Select_Stmt
           (Pool : Bump_Ptr_Pool) return Bare_Select_Stmt
         is
            Result      : constant Access_To_Subtype_For_Select_Stmt := Bare_Select_Stmt_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Select_Stmt;
            return Bare_Select_Stmt (Result);
         end Allocate_Select_Stmt;

      package Bare_Error_Stmt_Memos is new Langkit_Support.Packrat
        (Bare_Error_Stmt, Token_Index);

         
         subtype Subtype_For_Error_Stmt is
            Root_Node_Record (Ada_Error_Stmt);
         type Access_To_Subtype_For_Error_Stmt is access all Subtype_For_Error_Stmt;
         package Bare_Error_Stmt_Alloc is new Alloc
           (Subtype_For_Error_Stmt, Access_To_Subtype_For_Error_Stmt);

         function Allocate_Error_Stmt
           (Pool : Bump_Ptr_Pool) return Bare_Error_Stmt;

         function Allocate_Error_Stmt
           (Pool : Bump_Ptr_Pool) return Bare_Error_Stmt
         is
            Result      : constant Access_To_Subtype_For_Error_Stmt := Bare_Error_Stmt_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Error_Stmt;
            return Bare_Error_Stmt (Result);
         end Allocate_Error_Stmt;

      package Bare_Simple_Stmt_Memos is new Langkit_Support.Packrat
        (Bare_Simple_Stmt, Token_Index);

      package Bare_Abort_Stmt_Memos is new Langkit_Support.Packrat
        (Bare_Abort_Stmt, Token_Index);

         
         subtype Subtype_For_Abort_Stmt is
            Root_Node_Record (Ada_Abort_Stmt);
         type Access_To_Subtype_For_Abort_Stmt is access all Subtype_For_Abort_Stmt;
         package Bare_Abort_Stmt_Alloc is new Alloc
           (Subtype_For_Abort_Stmt, Access_To_Subtype_For_Abort_Stmt);

         function Allocate_Abort_Stmt
           (Pool : Bump_Ptr_Pool) return Bare_Abort_Stmt;

         function Allocate_Abort_Stmt
           (Pool : Bump_Ptr_Pool) return Bare_Abort_Stmt
         is
            Result      : constant Access_To_Subtype_For_Abort_Stmt := Bare_Abort_Stmt_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Abort_Stmt;
            return Bare_Abort_Stmt (Result);
         end Allocate_Abort_Stmt;

      package Bare_Assign_Stmt_Memos is new Langkit_Support.Packrat
        (Bare_Assign_Stmt, Token_Index);

         
         subtype Subtype_For_Assign_Stmt is
            Root_Node_Record (Ada_Assign_Stmt);
         type Access_To_Subtype_For_Assign_Stmt is access all Subtype_For_Assign_Stmt;
         package Bare_Assign_Stmt_Alloc is new Alloc
           (Subtype_For_Assign_Stmt, Access_To_Subtype_For_Assign_Stmt);

         function Allocate_Assign_Stmt
           (Pool : Bump_Ptr_Pool) return Bare_Assign_Stmt;

         function Allocate_Assign_Stmt
           (Pool : Bump_Ptr_Pool) return Bare_Assign_Stmt
         is
            Result      : constant Access_To_Subtype_For_Assign_Stmt := Bare_Assign_Stmt_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Assign_Stmt;
            return Bare_Assign_Stmt (Result);
         end Allocate_Assign_Stmt;

      package Bare_Call_Stmt_Memos is new Langkit_Support.Packrat
        (Bare_Call_Stmt, Token_Index);

         
         subtype Subtype_For_Call_Stmt is
            Root_Node_Record (Ada_Call_Stmt);
         type Access_To_Subtype_For_Call_Stmt is access all Subtype_For_Call_Stmt;
         package Bare_Call_Stmt_Alloc is new Alloc
           (Subtype_For_Call_Stmt, Access_To_Subtype_For_Call_Stmt);

         function Allocate_Call_Stmt
           (Pool : Bump_Ptr_Pool) return Bare_Call_Stmt;

         function Allocate_Call_Stmt
           (Pool : Bump_Ptr_Pool) return Bare_Call_Stmt
         is
            Result      : constant Access_To_Subtype_For_Call_Stmt := Bare_Call_Stmt_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Call_Stmt;
            return Bare_Call_Stmt (Result);
         end Allocate_Call_Stmt;

      package Bare_Delay_Stmt_Memos is new Langkit_Support.Packrat
        (Bare_Delay_Stmt, Token_Index);

         
         subtype Subtype_For_Delay_Stmt is
            Root_Node_Record (Ada_Delay_Stmt);
         type Access_To_Subtype_For_Delay_Stmt is access all Subtype_For_Delay_Stmt;
         package Bare_Delay_Stmt_Alloc is new Alloc
           (Subtype_For_Delay_Stmt, Access_To_Subtype_For_Delay_Stmt);

         function Allocate_Delay_Stmt
           (Pool : Bump_Ptr_Pool) return Bare_Delay_Stmt;

         function Allocate_Delay_Stmt
           (Pool : Bump_Ptr_Pool) return Bare_Delay_Stmt
         is
            Result      : constant Access_To_Subtype_For_Delay_Stmt := Bare_Delay_Stmt_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Delay_Stmt;
            return Bare_Delay_Stmt (Result);
         end Allocate_Delay_Stmt;

      package Bare_Exit_Stmt_Memos is new Langkit_Support.Packrat
        (Bare_Exit_Stmt, Token_Index);

         
         subtype Subtype_For_Exit_Stmt is
            Root_Node_Record (Ada_Exit_Stmt);
         type Access_To_Subtype_For_Exit_Stmt is access all Subtype_For_Exit_Stmt;
         package Bare_Exit_Stmt_Alloc is new Alloc
           (Subtype_For_Exit_Stmt, Access_To_Subtype_For_Exit_Stmt);

         function Allocate_Exit_Stmt
           (Pool : Bump_Ptr_Pool) return Bare_Exit_Stmt;

         function Allocate_Exit_Stmt
           (Pool : Bump_Ptr_Pool) return Bare_Exit_Stmt
         is
            Result      : constant Access_To_Subtype_For_Exit_Stmt := Bare_Exit_Stmt_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Exit_Stmt;
            return Bare_Exit_Stmt (Result);
         end Allocate_Exit_Stmt;

      package Bare_Goto_Stmt_Memos is new Langkit_Support.Packrat
        (Bare_Goto_Stmt, Token_Index);

         
         subtype Subtype_For_Goto_Stmt is
            Root_Node_Record (Ada_Goto_Stmt);
         type Access_To_Subtype_For_Goto_Stmt is access all Subtype_For_Goto_Stmt;
         package Bare_Goto_Stmt_Alloc is new Alloc
           (Subtype_For_Goto_Stmt, Access_To_Subtype_For_Goto_Stmt);

         function Allocate_Goto_Stmt
           (Pool : Bump_Ptr_Pool) return Bare_Goto_Stmt;

         function Allocate_Goto_Stmt
           (Pool : Bump_Ptr_Pool) return Bare_Goto_Stmt
         is
            Result      : constant Access_To_Subtype_For_Goto_Stmt := Bare_Goto_Stmt_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Goto_Stmt;
            return Bare_Goto_Stmt (Result);
         end Allocate_Goto_Stmt;

      package Bare_Label_Memos is new Langkit_Support.Packrat
        (Bare_Label, Token_Index);

         
         subtype Subtype_For_Label is
            Root_Node_Record (Ada_Label);
         type Access_To_Subtype_For_Label is access all Subtype_For_Label;
         package Bare_Label_Alloc is new Alloc
           (Subtype_For_Label, Access_To_Subtype_For_Label);

         function Allocate_Label
           (Pool : Bump_Ptr_Pool) return Bare_Label;

         function Allocate_Label
           (Pool : Bump_Ptr_Pool) return Bare_Label
         is
            Result      : constant Access_To_Subtype_For_Label := Bare_Label_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Label;
            return Bare_Label (Result);
         end Allocate_Label;

      package Bare_Null_Stmt_Memos is new Langkit_Support.Packrat
        (Bare_Null_Stmt, Token_Index);

         
         subtype Subtype_For_Null_Stmt is
            Root_Node_Record (Ada_Null_Stmt);
         type Access_To_Subtype_For_Null_Stmt is access all Subtype_For_Null_Stmt;
         package Bare_Null_Stmt_Alloc is new Alloc
           (Subtype_For_Null_Stmt, Access_To_Subtype_For_Null_Stmt);

         function Allocate_Null_Stmt
           (Pool : Bump_Ptr_Pool) return Bare_Null_Stmt;

         function Allocate_Null_Stmt
           (Pool : Bump_Ptr_Pool) return Bare_Null_Stmt
         is
            Result      : constant Access_To_Subtype_For_Null_Stmt := Bare_Null_Stmt_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Null_Stmt;
            return Bare_Null_Stmt (Result);
         end Allocate_Null_Stmt;

      package Bare_Raise_Stmt_Memos is new Langkit_Support.Packrat
        (Bare_Raise_Stmt, Token_Index);

         
         subtype Subtype_For_Raise_Stmt is
            Root_Node_Record (Ada_Raise_Stmt);
         type Access_To_Subtype_For_Raise_Stmt is access all Subtype_For_Raise_Stmt;
         package Bare_Raise_Stmt_Alloc is new Alloc
           (Subtype_For_Raise_Stmt, Access_To_Subtype_For_Raise_Stmt);

         function Allocate_Raise_Stmt
           (Pool : Bump_Ptr_Pool) return Bare_Raise_Stmt;

         function Allocate_Raise_Stmt
           (Pool : Bump_Ptr_Pool) return Bare_Raise_Stmt
         is
            Result      : constant Access_To_Subtype_For_Raise_Stmt := Bare_Raise_Stmt_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Raise_Stmt;
            return Bare_Raise_Stmt (Result);
         end Allocate_Raise_Stmt;

      package Bare_Requeue_Stmt_Memos is new Langkit_Support.Packrat
        (Bare_Requeue_Stmt, Token_Index);

         
         subtype Subtype_For_Requeue_Stmt is
            Root_Node_Record (Ada_Requeue_Stmt);
         type Access_To_Subtype_For_Requeue_Stmt is access all Subtype_For_Requeue_Stmt;
         package Bare_Requeue_Stmt_Alloc is new Alloc
           (Subtype_For_Requeue_Stmt, Access_To_Subtype_For_Requeue_Stmt);

         function Allocate_Requeue_Stmt
           (Pool : Bump_Ptr_Pool) return Bare_Requeue_Stmt;

         function Allocate_Requeue_Stmt
           (Pool : Bump_Ptr_Pool) return Bare_Requeue_Stmt
         is
            Result      : constant Access_To_Subtype_For_Requeue_Stmt := Bare_Requeue_Stmt_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Requeue_Stmt;
            return Bare_Requeue_Stmt (Result);
         end Allocate_Requeue_Stmt;

      package Bare_Return_Stmt_Memos is new Langkit_Support.Packrat
        (Bare_Return_Stmt, Token_Index);

         
         subtype Subtype_For_Return_Stmt is
            Root_Node_Record (Ada_Return_Stmt);
         type Access_To_Subtype_For_Return_Stmt is access all Subtype_For_Return_Stmt;
         package Bare_Return_Stmt_Alloc is new Alloc
           (Subtype_For_Return_Stmt, Access_To_Subtype_For_Return_Stmt);

         function Allocate_Return_Stmt
           (Pool : Bump_Ptr_Pool) return Bare_Return_Stmt;

         function Allocate_Return_Stmt
           (Pool : Bump_Ptr_Pool) return Bare_Return_Stmt
         is
            Result      : constant Access_To_Subtype_For_Return_Stmt := Bare_Return_Stmt_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Return_Stmt;
            return Bare_Return_Stmt (Result);
         end Allocate_Return_Stmt;

      package Bare_Terminate_Alternative_Memos is new Langkit_Support.Packrat
        (Bare_Terminate_Alternative, Token_Index);

         
         subtype Subtype_For_Terminate_Alternative is
            Root_Node_Record (Ada_Terminate_Alternative);
         type Access_To_Subtype_For_Terminate_Alternative is access all Subtype_For_Terminate_Alternative;
         package Bare_Terminate_Alternative_Alloc is new Alloc
           (Subtype_For_Terminate_Alternative, Access_To_Subtype_For_Terminate_Alternative);

         function Allocate_Terminate_Alternative
           (Pool : Bump_Ptr_Pool) return Bare_Terminate_Alternative;

         function Allocate_Terminate_Alternative
           (Pool : Bump_Ptr_Pool) return Bare_Terminate_Alternative
         is
            Result      : constant Access_To_Subtype_For_Terminate_Alternative := Bare_Terminate_Alternative_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Terminate_Alternative;
            return Bare_Terminate_Alternative (Result);
         end Allocate_Terminate_Alternative;

      package Bare_Subp_Kind_Memos is new Langkit_Support.Packrat
        (Bare_Subp_Kind, Token_Index);

      package Bare_Subp_Kind_Function_Memos is new Langkit_Support.Packrat
        (Bare_Subp_Kind_Function, Token_Index);

         
         subtype Subtype_For_Subp_Kind_Function is
            Root_Node_Record (Ada_Subp_Kind_Function);
         type Access_To_Subtype_For_Subp_Kind_Function is access all Subtype_For_Subp_Kind_Function;
         package Bare_Subp_Kind_Function_Alloc is new Alloc
           (Subtype_For_Subp_Kind_Function, Access_To_Subtype_For_Subp_Kind_Function);

         function Allocate_Subp_Kind_Function
           (Pool : Bump_Ptr_Pool) return Bare_Subp_Kind_Function;

         function Allocate_Subp_Kind_Function
           (Pool : Bump_Ptr_Pool) return Bare_Subp_Kind_Function
         is
            Result      : constant Access_To_Subtype_For_Subp_Kind_Function := Bare_Subp_Kind_Function_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Subp_Kind_Function;
            return Bare_Subp_Kind_Function (Result);
         end Allocate_Subp_Kind_Function;

      package Bare_Subp_Kind_Procedure_Memos is new Langkit_Support.Packrat
        (Bare_Subp_Kind_Procedure, Token_Index);

         
         subtype Subtype_For_Subp_Kind_Procedure is
            Root_Node_Record (Ada_Subp_Kind_Procedure);
         type Access_To_Subtype_For_Subp_Kind_Procedure is access all Subtype_For_Subp_Kind_Procedure;
         package Bare_Subp_Kind_Procedure_Alloc is new Alloc
           (Subtype_For_Subp_Kind_Procedure, Access_To_Subtype_For_Subp_Kind_Procedure);

         function Allocate_Subp_Kind_Procedure
           (Pool : Bump_Ptr_Pool) return Bare_Subp_Kind_Procedure;

         function Allocate_Subp_Kind_Procedure
           (Pool : Bump_Ptr_Pool) return Bare_Subp_Kind_Procedure
         is
            Result      : constant Access_To_Subtype_For_Subp_Kind_Procedure := Bare_Subp_Kind_Procedure_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Subp_Kind_Procedure;
            return Bare_Subp_Kind_Procedure (Result);
         end Allocate_Subp_Kind_Procedure;

      package Bare_Subunit_Memos is new Langkit_Support.Packrat
        (Bare_Subunit, Token_Index);

         
         subtype Subtype_For_Subunit is
            Root_Node_Record (Ada_Subunit);
         type Access_To_Subtype_For_Subunit is access all Subtype_For_Subunit;
         package Bare_Subunit_Alloc is new Alloc
           (Subtype_For_Subunit, Access_To_Subtype_For_Subunit);

         function Allocate_Subunit
           (Pool : Bump_Ptr_Pool) return Bare_Subunit;

         function Allocate_Subunit
           (Pool : Bump_Ptr_Pool) return Bare_Subunit
         is
            Result      : constant Access_To_Subtype_For_Subunit := Bare_Subunit_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Subunit;
            return Bare_Subunit (Result);
         end Allocate_Subunit;

      package Bare_Synchronized_Node_Memos is new Langkit_Support.Packrat
        (Bare_Synchronized_Node, Token_Index);

      package Bare_Synchronized_Absent_Memos is new Langkit_Support.Packrat
        (Bare_Synchronized_Absent, Token_Index);

         
         subtype Subtype_For_Synchronized_Absent is
            Root_Node_Record (Ada_Synchronized_Absent);
         type Access_To_Subtype_For_Synchronized_Absent is access all Subtype_For_Synchronized_Absent;
         package Bare_Synchronized_Absent_Alloc is new Alloc
           (Subtype_For_Synchronized_Absent, Access_To_Subtype_For_Synchronized_Absent);

         function Allocate_Synchronized_Absent
           (Pool : Bump_Ptr_Pool) return Bare_Synchronized_Absent;

         function Allocate_Synchronized_Absent
           (Pool : Bump_Ptr_Pool) return Bare_Synchronized_Absent
         is
            Result      : constant Access_To_Subtype_For_Synchronized_Absent := Bare_Synchronized_Absent_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Synchronized_Absent;
            return Bare_Synchronized_Absent (Result);
         end Allocate_Synchronized_Absent;

      package Bare_Synchronized_Present_Memos is new Langkit_Support.Packrat
        (Bare_Synchronized_Present, Token_Index);

         
         subtype Subtype_For_Synchronized_Present is
            Root_Node_Record (Ada_Synchronized_Present);
         type Access_To_Subtype_For_Synchronized_Present is access all Subtype_For_Synchronized_Present;
         package Bare_Synchronized_Present_Alloc is new Alloc
           (Subtype_For_Synchronized_Present, Access_To_Subtype_For_Synchronized_Present);

         function Allocate_Synchronized_Present
           (Pool : Bump_Ptr_Pool) return Bare_Synchronized_Present;

         function Allocate_Synchronized_Present
           (Pool : Bump_Ptr_Pool) return Bare_Synchronized_Present
         is
            Result      : constant Access_To_Subtype_For_Synchronized_Present := Bare_Synchronized_Present_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Synchronized_Present;
            return Bare_Synchronized_Present (Result);
         end Allocate_Synchronized_Present;

      package Bare_Tagged_Node_Memos is new Langkit_Support.Packrat
        (Bare_Tagged_Node, Token_Index);

      package Bare_Tagged_Absent_Memos is new Langkit_Support.Packrat
        (Bare_Tagged_Absent, Token_Index);

         
         subtype Subtype_For_Tagged_Absent is
            Root_Node_Record (Ada_Tagged_Absent);
         type Access_To_Subtype_For_Tagged_Absent is access all Subtype_For_Tagged_Absent;
         package Bare_Tagged_Absent_Alloc is new Alloc
           (Subtype_For_Tagged_Absent, Access_To_Subtype_For_Tagged_Absent);

         function Allocate_Tagged_Absent
           (Pool : Bump_Ptr_Pool) return Bare_Tagged_Absent;

         function Allocate_Tagged_Absent
           (Pool : Bump_Ptr_Pool) return Bare_Tagged_Absent
         is
            Result      : constant Access_To_Subtype_For_Tagged_Absent := Bare_Tagged_Absent_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Tagged_Absent;
            return Bare_Tagged_Absent (Result);
         end Allocate_Tagged_Absent;

      package Bare_Tagged_Present_Memos is new Langkit_Support.Packrat
        (Bare_Tagged_Present, Token_Index);

         
         subtype Subtype_For_Tagged_Present is
            Root_Node_Record (Ada_Tagged_Present);
         type Access_To_Subtype_For_Tagged_Present is access all Subtype_For_Tagged_Present;
         package Bare_Tagged_Present_Alloc is new Alloc
           (Subtype_For_Tagged_Present, Access_To_Subtype_For_Tagged_Present);

         function Allocate_Tagged_Present
           (Pool : Bump_Ptr_Pool) return Bare_Tagged_Present;

         function Allocate_Tagged_Present
           (Pool : Bump_Ptr_Pool) return Bare_Tagged_Present
         is
            Result      : constant Access_To_Subtype_For_Tagged_Present := Bare_Tagged_Present_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Tagged_Present;
            return Bare_Tagged_Present (Result);
         end Allocate_Tagged_Present;

      package Bare_Task_Def_Memos is new Langkit_Support.Packrat
        (Bare_Task_Def, Token_Index);

         
         subtype Subtype_For_Task_Def is
            Root_Node_Record (Ada_Task_Def);
         type Access_To_Subtype_For_Task_Def is access all Subtype_For_Task_Def;
         package Bare_Task_Def_Alloc is new Alloc
           (Subtype_For_Task_Def, Access_To_Subtype_For_Task_Def);

         function Allocate_Task_Def
           (Pool : Bump_Ptr_Pool) return Bare_Task_Def;

         function Allocate_Task_Def
           (Pool : Bump_Ptr_Pool) return Bare_Task_Def
         is
            Result      : constant Access_To_Subtype_For_Task_Def := Bare_Task_Def_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Task_Def;
            return Bare_Task_Def (Result);
         end Allocate_Task_Def;

      package Bare_Type_Def_Memos is new Langkit_Support.Packrat
        (Bare_Type_Def, Token_Index);

      package Bare_Access_Def_Memos is new Langkit_Support.Packrat
        (Bare_Access_Def, Token_Index);

      package Bare_Access_To_Subp_Def_Memos is new Langkit_Support.Packrat
        (Bare_Access_To_Subp_Def, Token_Index);

         
         subtype Subtype_For_Access_To_Subp_Def is
            Root_Node_Record (Ada_Access_To_Subp_Def);
         type Access_To_Subtype_For_Access_To_Subp_Def is access all Subtype_For_Access_To_Subp_Def;
         package Bare_Access_To_Subp_Def_Alloc is new Alloc
           (Subtype_For_Access_To_Subp_Def, Access_To_Subtype_For_Access_To_Subp_Def);

         function Allocate_Access_To_Subp_Def
           (Pool : Bump_Ptr_Pool) return Bare_Access_To_Subp_Def;

         function Allocate_Access_To_Subp_Def
           (Pool : Bump_Ptr_Pool) return Bare_Access_To_Subp_Def
         is
            Result      : constant Access_To_Subtype_For_Access_To_Subp_Def := Bare_Access_To_Subp_Def_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Access_To_Subp_Def;
            return Bare_Access_To_Subp_Def (Result);
         end Allocate_Access_To_Subp_Def;

      package Bare_Base_Type_Access_Def_Memos is new Langkit_Support.Packrat
        (Bare_Base_Type_Access_Def, Token_Index);

      package Bare_Anonymous_Type_Access_Def_Memos is new Langkit_Support.Packrat
        (Bare_Anonymous_Type_Access_Def, Token_Index);

         
         subtype Subtype_For_Anonymous_Type_Access_Def is
            Root_Node_Record (Ada_Anonymous_Type_Access_Def);
         type Access_To_Subtype_For_Anonymous_Type_Access_Def is access all Subtype_For_Anonymous_Type_Access_Def;
         package Bare_Anonymous_Type_Access_Def_Alloc is new Alloc
           (Subtype_For_Anonymous_Type_Access_Def, Access_To_Subtype_For_Anonymous_Type_Access_Def);

         function Allocate_Anonymous_Type_Access_Def
           (Pool : Bump_Ptr_Pool) return Bare_Anonymous_Type_Access_Def;

         function Allocate_Anonymous_Type_Access_Def
           (Pool : Bump_Ptr_Pool) return Bare_Anonymous_Type_Access_Def
         is
            Result      : constant Access_To_Subtype_For_Anonymous_Type_Access_Def := Bare_Anonymous_Type_Access_Def_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Anonymous_Type_Access_Def;
            return Bare_Anonymous_Type_Access_Def (Result);
         end Allocate_Anonymous_Type_Access_Def;

      package Bare_Type_Access_Def_Memos is new Langkit_Support.Packrat
        (Bare_Type_Access_Def, Token_Index);

         
         subtype Subtype_For_Type_Access_Def is
            Root_Node_Record (Ada_Type_Access_Def);
         type Access_To_Subtype_For_Type_Access_Def is access all Subtype_For_Type_Access_Def;
         package Bare_Type_Access_Def_Alloc is new Alloc
           (Subtype_For_Type_Access_Def, Access_To_Subtype_For_Type_Access_Def);

         function Allocate_Type_Access_Def
           (Pool : Bump_Ptr_Pool) return Bare_Type_Access_Def;

         function Allocate_Type_Access_Def
           (Pool : Bump_Ptr_Pool) return Bare_Type_Access_Def
         is
            Result      : constant Access_To_Subtype_For_Type_Access_Def := Bare_Type_Access_Def_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Type_Access_Def;
            return Bare_Type_Access_Def (Result);
         end Allocate_Type_Access_Def;

      package Bare_Array_Type_Def_Memos is new Langkit_Support.Packrat
        (Bare_Array_Type_Def, Token_Index);

         
         subtype Subtype_For_Array_Type_Def is
            Root_Node_Record (Ada_Array_Type_Def);
         type Access_To_Subtype_For_Array_Type_Def is access all Subtype_For_Array_Type_Def;
         package Bare_Array_Type_Def_Alloc is new Alloc
           (Subtype_For_Array_Type_Def, Access_To_Subtype_For_Array_Type_Def);

         function Allocate_Array_Type_Def
           (Pool : Bump_Ptr_Pool) return Bare_Array_Type_Def;

         function Allocate_Array_Type_Def
           (Pool : Bump_Ptr_Pool) return Bare_Array_Type_Def
         is
            Result      : constant Access_To_Subtype_For_Array_Type_Def := Bare_Array_Type_Def_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Array_Type_Def;
            return Bare_Array_Type_Def (Result);
         end Allocate_Array_Type_Def;

      package Bare_Derived_Type_Def_Memos is new Langkit_Support.Packrat
        (Bare_Derived_Type_Def, Token_Index);

         
         subtype Subtype_For_Derived_Type_Def is
            Root_Node_Record (Ada_Derived_Type_Def);
         type Access_To_Subtype_For_Derived_Type_Def is access all Subtype_For_Derived_Type_Def;
         package Bare_Derived_Type_Def_Alloc is new Alloc
           (Subtype_For_Derived_Type_Def, Access_To_Subtype_For_Derived_Type_Def);

         function Allocate_Derived_Type_Def
           (Pool : Bump_Ptr_Pool) return Bare_Derived_Type_Def;

         function Allocate_Derived_Type_Def
           (Pool : Bump_Ptr_Pool) return Bare_Derived_Type_Def
         is
            Result      : constant Access_To_Subtype_For_Derived_Type_Def := Bare_Derived_Type_Def_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Derived_Type_Def;
            return Bare_Derived_Type_Def (Result);
         end Allocate_Derived_Type_Def;

      package Bare_Enum_Type_Def_Memos is new Langkit_Support.Packrat
        (Bare_Enum_Type_Def, Token_Index);

         
         subtype Subtype_For_Enum_Type_Def is
            Root_Node_Record (Ada_Enum_Type_Def);
         type Access_To_Subtype_For_Enum_Type_Def is access all Subtype_For_Enum_Type_Def;
         package Bare_Enum_Type_Def_Alloc is new Alloc
           (Subtype_For_Enum_Type_Def, Access_To_Subtype_For_Enum_Type_Def);

         function Allocate_Enum_Type_Def
           (Pool : Bump_Ptr_Pool) return Bare_Enum_Type_Def;

         function Allocate_Enum_Type_Def
           (Pool : Bump_Ptr_Pool) return Bare_Enum_Type_Def
         is
            Result      : constant Access_To_Subtype_For_Enum_Type_Def := Bare_Enum_Type_Def_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Enum_Type_Def;
            return Bare_Enum_Type_Def (Result);
         end Allocate_Enum_Type_Def;

      package Bare_Formal_Discrete_Type_Def_Memos is new Langkit_Support.Packrat
        (Bare_Formal_Discrete_Type_Def, Token_Index);

         
         subtype Subtype_For_Formal_Discrete_Type_Def is
            Root_Node_Record (Ada_Formal_Discrete_Type_Def);
         type Access_To_Subtype_For_Formal_Discrete_Type_Def is access all Subtype_For_Formal_Discrete_Type_Def;
         package Bare_Formal_Discrete_Type_Def_Alloc is new Alloc
           (Subtype_For_Formal_Discrete_Type_Def, Access_To_Subtype_For_Formal_Discrete_Type_Def);

         function Allocate_Formal_Discrete_Type_Def
           (Pool : Bump_Ptr_Pool) return Bare_Formal_Discrete_Type_Def;

         function Allocate_Formal_Discrete_Type_Def
           (Pool : Bump_Ptr_Pool) return Bare_Formal_Discrete_Type_Def
         is
            Result      : constant Access_To_Subtype_For_Formal_Discrete_Type_Def := Bare_Formal_Discrete_Type_Def_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Formal_Discrete_Type_Def;
            return Bare_Formal_Discrete_Type_Def (Result);
         end Allocate_Formal_Discrete_Type_Def;

      package Bare_Interface_Type_Def_Memos is new Langkit_Support.Packrat
        (Bare_Interface_Type_Def, Token_Index);

         
         subtype Subtype_For_Interface_Type_Def is
            Root_Node_Record (Ada_Interface_Type_Def);
         type Access_To_Subtype_For_Interface_Type_Def is access all Subtype_For_Interface_Type_Def;
         package Bare_Interface_Type_Def_Alloc is new Alloc
           (Subtype_For_Interface_Type_Def, Access_To_Subtype_For_Interface_Type_Def);

         function Allocate_Interface_Type_Def
           (Pool : Bump_Ptr_Pool) return Bare_Interface_Type_Def;

         function Allocate_Interface_Type_Def
           (Pool : Bump_Ptr_Pool) return Bare_Interface_Type_Def
         is
            Result      : constant Access_To_Subtype_For_Interface_Type_Def := Bare_Interface_Type_Def_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Interface_Type_Def;
            return Bare_Interface_Type_Def (Result);
         end Allocate_Interface_Type_Def;

      package Bare_Mod_Int_Type_Def_Memos is new Langkit_Support.Packrat
        (Bare_Mod_Int_Type_Def, Token_Index);

         
         subtype Subtype_For_Mod_Int_Type_Def is
            Root_Node_Record (Ada_Mod_Int_Type_Def);
         type Access_To_Subtype_For_Mod_Int_Type_Def is access all Subtype_For_Mod_Int_Type_Def;
         package Bare_Mod_Int_Type_Def_Alloc is new Alloc
           (Subtype_For_Mod_Int_Type_Def, Access_To_Subtype_For_Mod_Int_Type_Def);

         function Allocate_Mod_Int_Type_Def
           (Pool : Bump_Ptr_Pool) return Bare_Mod_Int_Type_Def;

         function Allocate_Mod_Int_Type_Def
           (Pool : Bump_Ptr_Pool) return Bare_Mod_Int_Type_Def
         is
            Result      : constant Access_To_Subtype_For_Mod_Int_Type_Def := Bare_Mod_Int_Type_Def_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Mod_Int_Type_Def;
            return Bare_Mod_Int_Type_Def (Result);
         end Allocate_Mod_Int_Type_Def;

      package Bare_Private_Type_Def_Memos is new Langkit_Support.Packrat
        (Bare_Private_Type_Def, Token_Index);

         
         subtype Subtype_For_Private_Type_Def is
            Root_Node_Record (Ada_Private_Type_Def);
         type Access_To_Subtype_For_Private_Type_Def is access all Subtype_For_Private_Type_Def;
         package Bare_Private_Type_Def_Alloc is new Alloc
           (Subtype_For_Private_Type_Def, Access_To_Subtype_For_Private_Type_Def);

         function Allocate_Private_Type_Def
           (Pool : Bump_Ptr_Pool) return Bare_Private_Type_Def;

         function Allocate_Private_Type_Def
           (Pool : Bump_Ptr_Pool) return Bare_Private_Type_Def
         is
            Result      : constant Access_To_Subtype_For_Private_Type_Def := Bare_Private_Type_Def_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Private_Type_Def;
            return Bare_Private_Type_Def (Result);
         end Allocate_Private_Type_Def;

      package Bare_Real_Type_Def_Memos is new Langkit_Support.Packrat
        (Bare_Real_Type_Def, Token_Index);

      package Bare_Decimal_Fixed_Point_Def_Memos is new Langkit_Support.Packrat
        (Bare_Decimal_Fixed_Point_Def, Token_Index);

         
         subtype Subtype_For_Decimal_Fixed_Point_Def is
            Root_Node_Record (Ada_Decimal_Fixed_Point_Def);
         type Access_To_Subtype_For_Decimal_Fixed_Point_Def is access all Subtype_For_Decimal_Fixed_Point_Def;
         package Bare_Decimal_Fixed_Point_Def_Alloc is new Alloc
           (Subtype_For_Decimal_Fixed_Point_Def, Access_To_Subtype_For_Decimal_Fixed_Point_Def);

         function Allocate_Decimal_Fixed_Point_Def
           (Pool : Bump_Ptr_Pool) return Bare_Decimal_Fixed_Point_Def;

         function Allocate_Decimal_Fixed_Point_Def
           (Pool : Bump_Ptr_Pool) return Bare_Decimal_Fixed_Point_Def
         is
            Result      : constant Access_To_Subtype_For_Decimal_Fixed_Point_Def := Bare_Decimal_Fixed_Point_Def_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Decimal_Fixed_Point_Def;
            return Bare_Decimal_Fixed_Point_Def (Result);
         end Allocate_Decimal_Fixed_Point_Def;

      package Bare_Floating_Point_Def_Memos is new Langkit_Support.Packrat
        (Bare_Floating_Point_Def, Token_Index);

         
         subtype Subtype_For_Floating_Point_Def is
            Root_Node_Record (Ada_Floating_Point_Def);
         type Access_To_Subtype_For_Floating_Point_Def is access all Subtype_For_Floating_Point_Def;
         package Bare_Floating_Point_Def_Alloc is new Alloc
           (Subtype_For_Floating_Point_Def, Access_To_Subtype_For_Floating_Point_Def);

         function Allocate_Floating_Point_Def
           (Pool : Bump_Ptr_Pool) return Bare_Floating_Point_Def;

         function Allocate_Floating_Point_Def
           (Pool : Bump_Ptr_Pool) return Bare_Floating_Point_Def
         is
            Result      : constant Access_To_Subtype_For_Floating_Point_Def := Bare_Floating_Point_Def_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Floating_Point_Def;
            return Bare_Floating_Point_Def (Result);
         end Allocate_Floating_Point_Def;

      package Bare_Ordinary_Fixed_Point_Def_Memos is new Langkit_Support.Packrat
        (Bare_Ordinary_Fixed_Point_Def, Token_Index);

         
         subtype Subtype_For_Ordinary_Fixed_Point_Def is
            Root_Node_Record (Ada_Ordinary_Fixed_Point_Def);
         type Access_To_Subtype_For_Ordinary_Fixed_Point_Def is access all Subtype_For_Ordinary_Fixed_Point_Def;
         package Bare_Ordinary_Fixed_Point_Def_Alloc is new Alloc
           (Subtype_For_Ordinary_Fixed_Point_Def, Access_To_Subtype_For_Ordinary_Fixed_Point_Def);

         function Allocate_Ordinary_Fixed_Point_Def
           (Pool : Bump_Ptr_Pool) return Bare_Ordinary_Fixed_Point_Def;

         function Allocate_Ordinary_Fixed_Point_Def
           (Pool : Bump_Ptr_Pool) return Bare_Ordinary_Fixed_Point_Def
         is
            Result      : constant Access_To_Subtype_For_Ordinary_Fixed_Point_Def := Bare_Ordinary_Fixed_Point_Def_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Ordinary_Fixed_Point_Def;
            return Bare_Ordinary_Fixed_Point_Def (Result);
         end Allocate_Ordinary_Fixed_Point_Def;

      package Bare_Record_Type_Def_Memos is new Langkit_Support.Packrat
        (Bare_Record_Type_Def, Token_Index);

         
         subtype Subtype_For_Record_Type_Def is
            Root_Node_Record (Ada_Record_Type_Def);
         type Access_To_Subtype_For_Record_Type_Def is access all Subtype_For_Record_Type_Def;
         package Bare_Record_Type_Def_Alloc is new Alloc
           (Subtype_For_Record_Type_Def, Access_To_Subtype_For_Record_Type_Def);

         function Allocate_Record_Type_Def
           (Pool : Bump_Ptr_Pool) return Bare_Record_Type_Def;

         function Allocate_Record_Type_Def
           (Pool : Bump_Ptr_Pool) return Bare_Record_Type_Def
         is
            Result      : constant Access_To_Subtype_For_Record_Type_Def := Bare_Record_Type_Def_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Record_Type_Def;
            return Bare_Record_Type_Def (Result);
         end Allocate_Record_Type_Def;

      package Bare_Signed_Int_Type_Def_Memos is new Langkit_Support.Packrat
        (Bare_Signed_Int_Type_Def, Token_Index);

         
         subtype Subtype_For_Signed_Int_Type_Def is
            Root_Node_Record (Ada_Signed_Int_Type_Def);
         type Access_To_Subtype_For_Signed_Int_Type_Def is access all Subtype_For_Signed_Int_Type_Def;
         package Bare_Signed_Int_Type_Def_Alloc is new Alloc
           (Subtype_For_Signed_Int_Type_Def, Access_To_Subtype_For_Signed_Int_Type_Def);

         function Allocate_Signed_Int_Type_Def
           (Pool : Bump_Ptr_Pool) return Bare_Signed_Int_Type_Def;

         function Allocate_Signed_Int_Type_Def
           (Pool : Bump_Ptr_Pool) return Bare_Signed_Int_Type_Def
         is
            Result      : constant Access_To_Subtype_For_Signed_Int_Type_Def := Bare_Signed_Int_Type_Def_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Signed_Int_Type_Def;
            return Bare_Signed_Int_Type_Def (Result);
         end Allocate_Signed_Int_Type_Def;

      package Bare_Type_Expr_Memos is new Langkit_Support.Packrat
        (Bare_Type_Expr, Token_Index);

      package Bare_Anonymous_Type_Memos is new Langkit_Support.Packrat
        (Bare_Anonymous_Type, Token_Index);

         
         subtype Subtype_For_Anonymous_Type is
            Root_Node_Record (Ada_Anonymous_Type);
         type Access_To_Subtype_For_Anonymous_Type is access all Subtype_For_Anonymous_Type;
         package Bare_Anonymous_Type_Alloc is new Alloc
           (Subtype_For_Anonymous_Type, Access_To_Subtype_For_Anonymous_Type);

         function Allocate_Anonymous_Type
           (Pool : Bump_Ptr_Pool) return Bare_Anonymous_Type;

         function Allocate_Anonymous_Type
           (Pool : Bump_Ptr_Pool) return Bare_Anonymous_Type
         is
            Result      : constant Access_To_Subtype_For_Anonymous_Type := Bare_Anonymous_Type_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Anonymous_Type;
            return Bare_Anonymous_Type (Result);
         end Allocate_Anonymous_Type;

      package Bare_Enum_Lit_Synth_Type_Expr_Memos is new Langkit_Support.Packrat
        (Bare_Enum_Lit_Synth_Type_Expr, Token_Index);

         
         subtype Subtype_For_Enum_Lit_Synth_Type_Expr is
            Root_Node_Record (Ada_Enum_Lit_Synth_Type_Expr);
         type Access_To_Subtype_For_Enum_Lit_Synth_Type_Expr is access all Subtype_For_Enum_Lit_Synth_Type_Expr;
         package Bare_Enum_Lit_Synth_Type_Expr_Alloc is new Alloc
           (Subtype_For_Enum_Lit_Synth_Type_Expr, Access_To_Subtype_For_Enum_Lit_Synth_Type_Expr);

         function Allocate_Enum_Lit_Synth_Type_Expr
           (Pool : Bump_Ptr_Pool) return Bare_Enum_Lit_Synth_Type_Expr;

         function Allocate_Enum_Lit_Synth_Type_Expr
           (Pool : Bump_Ptr_Pool) return Bare_Enum_Lit_Synth_Type_Expr
         is
            Result      : constant Access_To_Subtype_For_Enum_Lit_Synth_Type_Expr := Bare_Enum_Lit_Synth_Type_Expr_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Enum_Lit_Synth_Type_Expr;
            return Bare_Enum_Lit_Synth_Type_Expr (Result);
         end Allocate_Enum_Lit_Synth_Type_Expr;

      package Bare_Subtype_Indication_Memos is new Langkit_Support.Packrat
        (Bare_Subtype_Indication, Token_Index);

         
         subtype Subtype_For_Subtype_Indication is
            Root_Node_Record (Ada_Subtype_Indication);
         type Access_To_Subtype_For_Subtype_Indication is access all Subtype_For_Subtype_Indication;
         package Bare_Subtype_Indication_Alloc is new Alloc
           (Subtype_For_Subtype_Indication, Access_To_Subtype_For_Subtype_Indication);

         function Allocate_Subtype_Indication
           (Pool : Bump_Ptr_Pool) return Bare_Subtype_Indication;

         function Allocate_Subtype_Indication
           (Pool : Bump_Ptr_Pool) return Bare_Subtype_Indication
         is
            Result      : constant Access_To_Subtype_For_Subtype_Indication := Bare_Subtype_Indication_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Subtype_Indication;
            return Bare_Subtype_Indication (Result);
         end Allocate_Subtype_Indication;

      package Bare_Constrained_Subtype_Indication_Memos is new Langkit_Support.Packrat
        (Bare_Constrained_Subtype_Indication, Token_Index);

         
         subtype Subtype_For_Constrained_Subtype_Indication is
            Root_Node_Record (Ada_Constrained_Subtype_Indication);
         type Access_To_Subtype_For_Constrained_Subtype_Indication is access all Subtype_For_Constrained_Subtype_Indication;
         package Bare_Constrained_Subtype_Indication_Alloc is new Alloc
           (Subtype_For_Constrained_Subtype_Indication, Access_To_Subtype_For_Constrained_Subtype_Indication);

         function Allocate_Constrained_Subtype_Indication
           (Pool : Bump_Ptr_Pool) return Bare_Constrained_Subtype_Indication;

         function Allocate_Constrained_Subtype_Indication
           (Pool : Bump_Ptr_Pool) return Bare_Constrained_Subtype_Indication
         is
            Result      : constant Access_To_Subtype_For_Constrained_Subtype_Indication := Bare_Constrained_Subtype_Indication_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Constrained_Subtype_Indication;
            return Bare_Constrained_Subtype_Indication (Result);
         end Allocate_Constrained_Subtype_Indication;

      package Bare_Discrete_Subtype_Indication_Memos is new Langkit_Support.Packrat
        (Bare_Discrete_Subtype_Indication, Token_Index);

         
         subtype Subtype_For_Discrete_Subtype_Indication is
            Root_Node_Record (Ada_Discrete_Subtype_Indication);
         type Access_To_Subtype_For_Discrete_Subtype_Indication is access all Subtype_For_Discrete_Subtype_Indication;
         package Bare_Discrete_Subtype_Indication_Alloc is new Alloc
           (Subtype_For_Discrete_Subtype_Indication, Access_To_Subtype_For_Discrete_Subtype_Indication);

         function Allocate_Discrete_Subtype_Indication
           (Pool : Bump_Ptr_Pool) return Bare_Discrete_Subtype_Indication;

         function Allocate_Discrete_Subtype_Indication
           (Pool : Bump_Ptr_Pool) return Bare_Discrete_Subtype_Indication
         is
            Result      : constant Access_To_Subtype_For_Discrete_Subtype_Indication := Bare_Discrete_Subtype_Indication_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Discrete_Subtype_Indication;
            return Bare_Discrete_Subtype_Indication (Result);
         end Allocate_Discrete_Subtype_Indication;

      package Bare_Unconstrained_Array_Index_Memos is new Langkit_Support.Packrat
        (Bare_Unconstrained_Array_Index, Token_Index);

         
         subtype Subtype_For_Unconstrained_Array_Index is
            Root_Node_Record (Ada_Unconstrained_Array_Index);
         type Access_To_Subtype_For_Unconstrained_Array_Index is access all Subtype_For_Unconstrained_Array_Index;
         package Bare_Unconstrained_Array_Index_Alloc is new Alloc
           (Subtype_For_Unconstrained_Array_Index, Access_To_Subtype_For_Unconstrained_Array_Index);

         function Allocate_Unconstrained_Array_Index
           (Pool : Bump_Ptr_Pool) return Bare_Unconstrained_Array_Index;

         function Allocate_Unconstrained_Array_Index
           (Pool : Bump_Ptr_Pool) return Bare_Unconstrained_Array_Index
         is
            Result      : constant Access_To_Subtype_For_Unconstrained_Array_Index := Bare_Unconstrained_Array_Index_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Unconstrained_Array_Index;
            return Bare_Unconstrained_Array_Index (Result);
         end Allocate_Unconstrained_Array_Index;

      package Bare_Until_Node_Memos is new Langkit_Support.Packrat
        (Bare_Until_Node, Token_Index);

      package Bare_Until_Absent_Memos is new Langkit_Support.Packrat
        (Bare_Until_Absent, Token_Index);

         
         subtype Subtype_For_Until_Absent is
            Root_Node_Record (Ada_Until_Absent);
         type Access_To_Subtype_For_Until_Absent is access all Subtype_For_Until_Absent;
         package Bare_Until_Absent_Alloc is new Alloc
           (Subtype_For_Until_Absent, Access_To_Subtype_For_Until_Absent);

         function Allocate_Until_Absent
           (Pool : Bump_Ptr_Pool) return Bare_Until_Absent;

         function Allocate_Until_Absent
           (Pool : Bump_Ptr_Pool) return Bare_Until_Absent
         is
            Result      : constant Access_To_Subtype_For_Until_Absent := Bare_Until_Absent_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Until_Absent;
            return Bare_Until_Absent (Result);
         end Allocate_Until_Absent;

      package Bare_Until_Present_Memos is new Langkit_Support.Packrat
        (Bare_Until_Present, Token_Index);

         
         subtype Subtype_For_Until_Present is
            Root_Node_Record (Ada_Until_Present);
         type Access_To_Subtype_For_Until_Present is access all Subtype_For_Until_Present;
         package Bare_Until_Present_Alloc is new Alloc
           (Subtype_For_Until_Present, Access_To_Subtype_For_Until_Present);

         function Allocate_Until_Present
           (Pool : Bump_Ptr_Pool) return Bare_Until_Present;

         function Allocate_Until_Present
           (Pool : Bump_Ptr_Pool) return Bare_Until_Present
         is
            Result      : constant Access_To_Subtype_For_Until_Present := Bare_Until_Present_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Until_Present;
            return Bare_Until_Present (Result);
         end Allocate_Until_Present;

      package Bare_Use_Clause_Memos is new Langkit_Support.Packrat
        (Bare_Use_Clause, Token_Index);

      package Bare_Use_Package_Clause_Memos is new Langkit_Support.Packrat
        (Bare_Use_Package_Clause, Token_Index);

         
         subtype Subtype_For_Use_Package_Clause is
            Root_Node_Record (Ada_Use_Package_Clause);
         type Access_To_Subtype_For_Use_Package_Clause is access all Subtype_For_Use_Package_Clause;
         package Bare_Use_Package_Clause_Alloc is new Alloc
           (Subtype_For_Use_Package_Clause, Access_To_Subtype_For_Use_Package_Clause);

         function Allocate_Use_Package_Clause
           (Pool : Bump_Ptr_Pool) return Bare_Use_Package_Clause;

         function Allocate_Use_Package_Clause
           (Pool : Bump_Ptr_Pool) return Bare_Use_Package_Clause
         is
            Result      : constant Access_To_Subtype_For_Use_Package_Clause := Bare_Use_Package_Clause_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Use_Package_Clause;
            return Bare_Use_Package_Clause (Result);
         end Allocate_Use_Package_Clause;

      package Bare_Use_Type_Clause_Memos is new Langkit_Support.Packrat
        (Bare_Use_Type_Clause, Token_Index);

         
         subtype Subtype_For_Use_Type_Clause is
            Root_Node_Record (Ada_Use_Type_Clause);
         type Access_To_Subtype_For_Use_Type_Clause is access all Subtype_For_Use_Type_Clause;
         package Bare_Use_Type_Clause_Alloc is new Alloc
           (Subtype_For_Use_Type_Clause, Access_To_Subtype_For_Use_Type_Clause);

         function Allocate_Use_Type_Clause
           (Pool : Bump_Ptr_Pool) return Bare_Use_Type_Clause;

         function Allocate_Use_Type_Clause
           (Pool : Bump_Ptr_Pool) return Bare_Use_Type_Clause
         is
            Result      : constant Access_To_Subtype_For_Use_Type_Clause := Bare_Use_Type_Clause_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Use_Type_Clause;
            return Bare_Use_Type_Clause (Result);
         end Allocate_Use_Type_Clause;

      package Bare_Variant_Memos is new Langkit_Support.Packrat
        (Bare_Variant, Token_Index);

         
         subtype Subtype_For_Variant is
            Root_Node_Record (Ada_Variant);
         type Access_To_Subtype_For_Variant is access all Subtype_For_Variant;
         package Bare_Variant_Alloc is new Alloc
           (Subtype_For_Variant, Access_To_Subtype_For_Variant);

         function Allocate_Variant
           (Pool : Bump_Ptr_Pool) return Bare_Variant;

         function Allocate_Variant
           (Pool : Bump_Ptr_Pool) return Bare_Variant
         is
            Result      : constant Access_To_Subtype_For_Variant := Bare_Variant_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Variant;
            return Bare_Variant (Result);
         end Allocate_Variant;

      package Bare_Variant_Part_Memos is new Langkit_Support.Packrat
        (Bare_Variant_Part, Token_Index);

         
         subtype Subtype_For_Variant_Part is
            Root_Node_Record (Ada_Variant_Part);
         type Access_To_Subtype_For_Variant_Part is access all Subtype_For_Variant_Part;
         package Bare_Variant_Part_Alloc is new Alloc
           (Subtype_For_Variant_Part, Access_To_Subtype_For_Variant_Part);

         function Allocate_Variant_Part
           (Pool : Bump_Ptr_Pool) return Bare_Variant_Part;

         function Allocate_Variant_Part
           (Pool : Bump_Ptr_Pool) return Bare_Variant_Part
         is
            Result      : constant Access_To_Subtype_For_Variant_Part := Bare_Variant_Part_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Variant_Part;
            return Bare_Variant_Part (Result);
         end Allocate_Variant_Part;

      package Bare_With_Clause_Memos is new Langkit_Support.Packrat
        (Bare_With_Clause, Token_Index);

         
         subtype Subtype_For_With_Clause is
            Root_Node_Record (Ada_With_Clause);
         type Access_To_Subtype_For_With_Clause is access all Subtype_For_With_Clause;
         package Bare_With_Clause_Alloc is new Alloc
           (Subtype_For_With_Clause, Access_To_Subtype_For_With_Clause);

         function Allocate_With_Clause
           (Pool : Bump_Ptr_Pool) return Bare_With_Clause;

         function Allocate_With_Clause
           (Pool : Bump_Ptr_Pool) return Bare_With_Clause
         is
            Result      : constant Access_To_Subtype_For_With_Clause := Bare_With_Clause_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_With_Clause;
            return Bare_With_Clause (Result);
         end Allocate_With_Clause;

      package Bare_With_Private_Memos is new Langkit_Support.Packrat
        (Bare_With_Private, Token_Index);

      package Bare_With_Private_Absent_Memos is new Langkit_Support.Packrat
        (Bare_With_Private_Absent, Token_Index);

         
         subtype Subtype_For_With_Private_Absent is
            Root_Node_Record (Ada_With_Private_Absent);
         type Access_To_Subtype_For_With_Private_Absent is access all Subtype_For_With_Private_Absent;
         package Bare_With_Private_Absent_Alloc is new Alloc
           (Subtype_For_With_Private_Absent, Access_To_Subtype_For_With_Private_Absent);

         function Allocate_With_Private_Absent
           (Pool : Bump_Ptr_Pool) return Bare_With_Private_Absent;

         function Allocate_With_Private_Absent
           (Pool : Bump_Ptr_Pool) return Bare_With_Private_Absent
         is
            Result      : constant Access_To_Subtype_For_With_Private_Absent := Bare_With_Private_Absent_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_With_Private_Absent;
            return Bare_With_Private_Absent (Result);
         end Allocate_With_Private_Absent;

      package Bare_With_Private_Present_Memos is new Langkit_Support.Packrat
        (Bare_With_Private_Present, Token_Index);

         
         subtype Subtype_For_With_Private_Present is
            Root_Node_Record (Ada_With_Private_Present);
         type Access_To_Subtype_For_With_Private_Present is access all Subtype_For_With_Private_Present;
         package Bare_With_Private_Present_Alloc is new Alloc
           (Subtype_For_With_Private_Present, Access_To_Subtype_For_With_Private_Present);

         function Allocate_With_Private_Present
           (Pool : Bump_Ptr_Pool) return Bare_With_Private_Present;

         function Allocate_With_Private_Present
           (Pool : Bump_Ptr_Pool) return Bare_With_Private_Present
         is
            Result      : constant Access_To_Subtype_For_With_Private_Present := Bare_With_Private_Present_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_With_Private_Present;
            return Bare_With_Private_Present (Result);
         end Allocate_With_Private_Present;

   pragma Warnings (On, "is not referenced");
   pragma Warnings (On, "possible aliasing problem for type");

   procedure Initialize_List
     (Self   : Bare_Ada_List;
      Parser : Parser_Type;
      Count  : Natural);
   --  Helper for parsers, to initialize the list of children in a freshly
   --  allocated list node.

   type Dontskip_Parser_Function is access function
     (Parser : in out Parser_Type;
      Pos    : Token_Index)
      return Bare_Ada_Node;

   package Dont_Skip_Fn_Vectors
   is new Ada.Containers.Vectors (Natural, Dontskip_Parser_Function);

   type Free_Parse_List_Record;
   type Free_Parse_List is access all Free_Parse_List_Record;
   --  Cache of temporary lists of AST nodes used in List parsers

   type Free_Parse_List_Record is record
      Nodes : Bare_Ada_Node_Vectors.Vector;
      Next  : Free_Parse_List;
   end record;

   type Parser_Private_Part_Type is record
      Parse_Lists : Free_Parse_List;

      
      Abort_Stmt_Transform_Parse_0_Memo : Bare_Abort_Stmt_Memos.Memo_Type;
      
      Abstract_Subp_Decl_Transform_Parse_0_Memo : Bare_Abstract_Subp_Decl_Memos.Memo_Type;
      
      Accept_Stmt_Or_Parse_0_Memo : Bare_Accept_Stmt_Memos.Memo_Type;
      
      Access_Def_Or_Parse_0_Memo : Bare_Access_Def_Memos.Memo_Type;
      
      Aggregate_Assoc_Or_Parse_2_Memo : Bare_Basic_Assoc_Memos.Memo_Type;
      
      Aggregate_Or_Parse_0_Memo : Bare_Base_Aggregate_Memos.Memo_Type;
      
      Allocator_Transform_Parse_0_Memo : Bare_Allocator_Memos.Memo_Type;
      
      Anonymous_Type_Decl_Transform_Parse_0_Memo : Bare_Anonymous_Type_Decl_Memos.Memo_Type;
      
      Anonymous_Type_Transform_Parse_0_Memo : Bare_Anonymous_Type_Memos.Memo_Type;
      
      Array_Type_Def_Transform_Parse_2_Memo : Bare_Array_Type_Def_Memos.Memo_Type;
      
      Aspect_Assoc_Transform_Parse_0_Memo : Bare_Aspect_Assoc_Memos.Memo_Type;
      
      Aspect_Clause_Or_Parse_1_Memo : Bare_Aspect_Clause_Memos.Memo_Type;
      
      Aspect_Spec_Opt_Parse_0_Memo : Bare_Aspect_Spec_Memos.Memo_Type;
      
      Assignment_Stmt_Transform_Parse_0_Memo : Bare_Assign_Stmt_Memos.Memo_Type;
      
      Basic_Decl_Or_Parse_0_Memo : Bare_Ada_Node_Memos.Memo_Type;
      
      Basic_Decls_List_Parse_0_Memo : Bare_Ada_Node_List_Memos.Memo_Type;
      
      Block_Stmt_Or_Parse_0_Memo : Bare_Composite_Stmt_Memos.Memo_Type;
      
      Body_Or_Parse_0_Memo : Bare_Body_Node_Memos.Memo_Type;
      
      Body_Stub_Or_Parse_0_Memo : Bare_Body_Stub_Memos.Memo_Type;
      
      Boolean_Op_Or_Parse_0_Memo : Bare_Op_Memos.Memo_Type;
      
      Box_Expr_Transform_Parse_0_Memo : Bare_Box_Expr_Memos.Memo_Type;
      
      Bracket_Aggregate_Or_Parse_0_Memo : Bare_Base_Aggregate_Memos.Memo_Type;
      
      Call_Stmt_Transform_Parse_0_Memo : Bare_Call_Stmt_Memos.Memo_Type;
      
      Call_Suffix_Or_Parse_0_Memo : Bare_Ada_Node_Memos.Memo_Type;
      
      Case_Alt_Transform_Parse_0_Memo : Bare_Case_Stmt_Alternative_Memos.Memo_Type;
      
      Case_Expr_Alt_Transform_Parse_0_Memo : Bare_Case_Expr_Alternative_Memos.Memo_Type;
      
      Case_Expr_Transform_Parse_0_Memo : Bare_Case_Expr_Memos.Memo_Type;
      
      Case_Stmt_Transform_Parse_0_Memo : Bare_Case_Stmt_Memos.Memo_Type;
      
      Char_Literal_Transform_Parse_0_Memo : Bare_Char_Literal_Memos.Memo_Type;
      
      Choice_List_List_Parse_0_Memo : Bare_Alternatives_List_Memos.Memo_Type;
      
      Choice_Or_Parse_0_Memo : Bare_Ada_Node_Memos.Memo_Type;
      
      Compilation_Or_Parse_0_Memo : Bare_Ada_Node_Memos.Memo_Type;
      
      Compilation_Unit_Transform_Parse_0_Memo : Bare_Compilation_Unit_Memos.Memo_Type;
      
      Component_Clause_Transform_Parse_0_Memo : Bare_Component_Clause_Memos.Memo_Type;
      
      Component_Decl_Transform_Parse_0_Memo : Bare_Component_Decl_Memos.Memo_Type;
      
      Component_Def_Transform_Parse_0_Memo : Bare_Component_Def_Memos.Memo_Type;
      
      Component_Item_Or_Parse_0_Memo : Bare_Ada_Node_Memos.Memo_Type;
      
      Component_List_Transform_Parse_0_Memo : Bare_Component_List_Memos.Memo_Type;
      
      Compound_Stmt_Or_Parse_0_Memo : Bare_Composite_Stmt_Memos.Memo_Type;
      
      Conditional_Expr_Or_Parse_0_Memo : Bare_Expr_Memos.Memo_Type;
      
      Constrained_Subtype_Indication_Transform_Parse_0_Memo : Bare_Constrained_Subtype_Indication_Memos.Memo_Type;
      
      Constraint_List_List_Parse_0_Memo : Bare_Constraint_List_Memos.Memo_Type;
      
      Constraint_Or_Parse_0_Memo : Bare_Constraint_Memos.Memo_Type;
      
      Context_Item_Or_Parse_0_Memo : Bare_Ada_Node_Memos.Memo_Type;
      
      Contract_Case_Assoc_Transform_Parse_0_Memo : Bare_Contract_Case_Assoc_Memos.Memo_Type;
      
      Contract_Cases_Expr_Transform_Parse_0_Memo : Bare_Contract_Cases_Memos.Memo_Type;
      
      Dec_Literal_Transform_Parse_0_Memo : Bare_Real_Literal_Memos.Memo_Type;
      
      Decimal_Fixed_Point_Def_Transform_Parse_0_Memo : Bare_Decimal_Fixed_Point_Def_Memos.Memo_Type;
      
      Decl_Part_Transform_Parse_0_Memo : Bare_Declarative_Part_Memos.Memo_Type;
      
      Declare_Expr_Transform_Parse_0_Memo : Bare_Decl_Expr_Memos.Memo_Type;
      
      Defining_Id_List_List_Parse_0_Memo : Bare_Defining_Name_List_Memos.Memo_Type;
      
      Defining_Id_Transform_Parse_0_Memo : Bare_Defining_Name_Memos.Memo_Type;
      
      Defining_Name_Transform_Parse_0_Memo : Bare_Defining_Name_Memos.Memo_Type;
      
      Delay_Stmt_Transform_Parse_0_Memo : Bare_Delay_Stmt_Memos.Memo_Type;
      
      Delta_Constraint_Transform_Parse_0_Memo : Bare_Delta_Constraint_Memos.Memo_Type;
      
      Derived_Type_Def_Transform_Parse_0_Memo : Bare_Derived_Type_Def_Memos.Memo_Type;
      
      Digits_Constraint_Transform_Parse_0_Memo : Bare_Digits_Constraint_Memos.Memo_Type;
      
      Direct_Name_Or_Parse_0_Memo : Bare_Base_Id_Memos.Memo_Type;
      
      Direct_Name_Or_Target_Name_Or_Parse_0_Memo : Bare_Name_Memos.Memo_Type;
      
      Discr_Spec_List_List_Parse_0_Memo : Bare_Discriminant_Spec_List_Memos.Memo_Type;
      
      Discrete_Range_Or_Parse_0_Memo : Bare_Expr_Memos.Memo_Type;
      
      Discrete_Subtype_Definition_Or_Parse_0_Memo : Bare_Ada_Node_Memos.Memo_Type;
      
      Discrete_Subtype_Indication_Transform_Parse_0_Memo : Bare_Discrete_Subtype_Indication_Memos.Memo_Type;
      
      Discriminant_Assoc_Transform_Parse_0_Memo : Bare_Discriminant_Assoc_Memos.Memo_Type;
      
      Discriminant_Constraint_Transform_Parse_0_Memo : Bare_Discriminant_Constraint_Memos.Memo_Type;
      
      Discriminant_Part_Or_Parse_0_Memo : Bare_Discriminant_Part_Memos.Memo_Type;
      
      Discriminant_Spec_Transform_Parse_0_Memo : Bare_Discriminant_Spec_Memos.Memo_Type;
      
      Dontskip_Case_Alt_0_Extract_Parse_0_Memo : Bare_Ada_Node_Memos.Memo_Type;
      
      Dontskip_Exception_Handler_0_Extract_Parse_0_Memo : Bare_Ada_Node_Memos.Memo_Type;
      
      Dontskip_Generic_Decl_0_Extract_Parse_0_Memo : Bare_Ada_Node_Memos.Memo_Type;
      
      Dontskip_Generic_Decl_1_Extract_Parse_0_Memo : Bare_Ada_Node_Memos.Memo_Type;
      
      Dontskip_Handled_Stmts_0_Extract_Parse_0_Memo : Bare_Ada_Node_Memos.Memo_Type;
      
      Dontskip_If_Stmt_0_Extract_Parse_0_Memo : Bare_Ada_Node_Memos.Memo_Type;
      
      Dontskip_If_Stmt_1_Extract_Parse_0_Memo : Bare_Ada_Node_Memos.Memo_Type;
      
      Dontskip_If_Stmt_2_Extract_Parse_0_Memo : Bare_Ada_Node_Memos.Memo_Type;
      
      Dontskip_Iloop_Stmt_0_Extract_Parse_0_Memo : Bare_Ada_Node_Memos.Memo_Type;
      
      Dontskip_Iloop_Stmt_1_Extract_Parse_0_Memo : Bare_Ada_Node_Memos.Memo_Type;
      
      Dontskip_Iloop_Stmt_2_Extract_Parse_0_Memo : Bare_Ada_Node_Memos.Memo_Type;
      
      Dontskip_Package_Body_0_Extract_Parse_0_Memo : Bare_Ada_Node_Memos.Memo_Type;
      
      Dontskip_Package_Decl_0_Extract_Parse_0_Memo : Bare_Ada_Node_Memos.Memo_Type;
      
      Dontskip_Package_Decl_1_Extract_Parse_0_Memo : Bare_Ada_Node_Memos.Memo_Type;
      
      Dontskip_Protected_Body_0_Extract_Parse_0_Memo : Bare_Ada_Node_Memos.Memo_Type;
      
      Dontskip_Recov_Decl_Part_0_Extract_Parse_0_Memo : Bare_Ada_Node_Memos.Memo_Type;
      
      Dontskip_Select_Stmt_0_Extract_Parse_0_Memo : Bare_Ada_Node_Memos.Memo_Type;
      
      Dontskip_Select_Stmt_1_Extract_Parse_0_Memo : Bare_Ada_Node_Memos.Memo_Type;
      
      Dontskip_Select_Stmt_2_Extract_Parse_0_Memo : Bare_Ada_Node_Memos.Memo_Type;
      
      Entry_Body_Transform_Parse_3_Memo : Bare_Entry_Body_Memos.Memo_Type;
      
      Entry_Decl_Transform_Parse_1_Memo : Bare_Entry_Decl_Memos.Memo_Type;
      
      Enum_Literal_Decl_Transform_Parse_1_Memo : Bare_Enum_Literal_Decl_Memos.Memo_Type;
      
      Enum_Type_Def_Transform_Parse_0_Memo : Bare_Enum_Type_Def_Memos.Memo_Type;
      
      Exception_Decl_Transform_Parse_0_Memo : Bare_Exception_Decl_Memos.Memo_Type;
      
      Exception_Handler_Transform_Parse_0_Memo : Bare_Exception_Handler_Memos.Memo_Type;
      
      Exit_Stmt_Transform_Parse_0_Memo : Bare_Exit_Stmt_Memos.Memo_Type;
      
      Expr_Fn_Transform_Parse_0_Memo : Bare_Expr_Function_Memos.Memo_Type;
      
      Expr_Or_Parse_0_Memo : Bare_Expr_Memos.Memo_Type;
      
      Ext_Ret_Stmt_Object_Decl_Transform_Parse_0_Memo : Bare_Extended_Return_Stmt_Object_Decl_Memos.Memo_Type;
      
      Ext_Return_Stmt_Transform_Parse_0_Memo : Bare_Extended_Return_Stmt_Memos.Memo_Type;
      
      Factor_Or_Parse_1_Memo : Bare_Expr_Memos.Memo_Type;
      
      Floating_Point_Def_Transform_Parse_0_Memo : Bare_Floating_Point_Def_Memos.Memo_Type;
      
      For_Loop_Param_Spec_Transform_Parse_3_Memo : Bare_For_Loop_Spec_Memos.Memo_Type;
      
      Formal_Discrete_Type_Def_Transform_Parse_0_Memo : Bare_Formal_Discrete_Type_Def_Memos.Memo_Type;
      
      Formal_Subp_Decl_Or_Parse_2_Memo : Bare_Formal_Subp_Decl_Memos.Memo_Type;
      
      Generic_Decl_Or_Parse_0_Memo : Bare_Generic_Decl_Memos.Memo_Type;
      
      Generic_Formal_Decl_Or_Parse_0_Memo : Bare_Ada_Node_Memos.Memo_Type;
      
      Generic_Formal_Part_Transform_Parse_0_Memo : Bare_Generic_Formal_Part_Memos.Memo_Type;
      
      Generic_Instantiation_Or_Parse_1_Memo : Bare_Generic_Instantiation_Memos.Memo_Type;
      
      Generic_Renaming_Decl_Or_Parse_1_Memo : Bare_Generic_Renaming_Decl_Memos.Memo_Type;
      
      Goto_Stmt_Transform_Parse_0_Memo : Bare_Goto_Stmt_Memos.Memo_Type;
      
      Handled_Stmts_Transform_Parse_0_Memo : Bare_Handled_Stmts_Memos.Memo_Type;
      
      Iblock_Stmt_Or_Parse_0_Memo : Bare_Block_Stmt_Memos.Memo_Type;
      
      Identifier_Transform_Parse_0_Memo : Bare_Identifier_Memos.Memo_Type;
      
      If_Expr_Transform_Parse_1_Memo : Bare_If_Expr_Memos.Memo_Type;
      
      If_Stmt_Transform_Parse_1_Memo : Bare_If_Stmt_Memos.Memo_Type;
      
      Iloop_Stmt_Or_Parse_0_Memo : Bare_Base_Loop_Stmt_Memos.Memo_Type;
      
      Index_Constraint_Transform_Parse_0_Memo : Bare_Index_Constraint_Memos.Memo_Type;
      
      Int_Literal_Transform_Parse_0_Memo : Bare_Int_Literal_Memos.Memo_Type;
      
      Interface_Type_Def_Transform_Parse_4_Memo : Bare_Interface_Type_Def_Memos.Memo_Type;
      
      Label_Transform_Parse_1_Memo : Bare_Label_Memos.Memo_Type;
      
      Library_Item_Transform_Parse_1_Memo : Bare_Library_Item_Memos.Memo_Type;
      
      Library_Unit_Body_Or_Parse_0_Memo : Bare_Body_Node_Memos.Memo_Type;
      
      Library_Unit_Renaming_Decl_Or_Parse_0_Memo : Bare_Basic_Decl_Memos.Memo_Type;
      
      Loop_Stmt_Or_Parse_0_Memo : Bare_Composite_Stmt_Memos.Memo_Type;
      
      Membership_Choice_List_List_Parse_0_Memo : Bare_Expr_Alternatives_List_Memos.Memo_Type;
      
      Membership_Choice_Or_Parse_0_Memo : Bare_Expr_Memos.Memo_Type;
      
      Mod_Int_Type_Def_Transform_Parse_0_Memo : Bare_Mod_Int_Type_Def_Memos.Memo_Type;
      
      Mode_Or_Parse_0_Memo : Bare_Mode_Memos.Memo_Type;
      
      Multidim_Array_Assoc_Transform_Parse_0_Memo : Bare_Multi_Dim_Array_Assoc_Memos.Memo_Type;
      
      Name_Or_Parse_1_Memo : Bare_Name_Memos.Memo_Type;
      
      Null_Literal_Transform_Parse_0_Memo : Bare_Null_Literal_Memos.Memo_Type;
      
      Null_Stmt_Transform_Parse_0_Memo : Bare_Null_Stmt_Memos.Memo_Type;
      
      Null_Subp_Decl_Transform_Parse_0_Memo : Bare_Null_Subp_Decl_Memos.Memo_Type;
      
      Num_Literal_Or_Parse_0_Memo : Bare_Num_Literal_Memos.Memo_Type;
      
      Number_Decl_Transform_Parse_0_Memo : Bare_Number_Decl_Memos.Memo_Type;
      
      Object_Decl_Or_Parse_0_Memo : Bare_Basic_Decl_Memos.Memo_Type;
      
      Ordinary_Fixed_Point_Def_Transform_Parse_0_Memo : Bare_Ordinary_Fixed_Point_Def_Memos.Memo_Type;
      
      Others_Designator_Transform_Parse_0_Memo : Bare_Others_Designator_Memos.Memo_Type;
      
      Overriding_Indicator_Or_Parse_0_Memo : Bare_Overriding_Node_Memos.Memo_Type;
      
      Package_Body_Stub_Transform_Parse_0_Memo : Bare_Package_Body_Stub_Memos.Memo_Type;
      
      Package_Body_Transform_Parse_1_Memo : Bare_Package_Body_Memos.Memo_Type;
      
      Package_Decl_Transform_Parse_3_Memo : Bare_Package_Decl_Memos.Memo_Type;
      
      Package_Renaming_Decl_Transform_Parse_0_Memo : Bare_Package_Renaming_Decl_Memos.Memo_Type;
      
      Param_Assoc_Transform_Parse_0_Memo : Bare_Param_Assoc_Memos.Memo_Type;
      
      Param_Spec_Transform_Parse_0_Memo : Bare_Param_Spec_Memos.Memo_Type;
      
      Param_Specs_Transform_Parse_0_Memo : Bare_Params_Memos.Memo_Type;
      
      Paren_Expr_Transform_Parse_0_Memo : Bare_Paren_Expr_Memos.Memo_Type;
      
      Parent_List_List_Parse_0_Memo : Bare_Parent_List_Memos.Memo_Type;
      
      Pragma_Argument_Transform_Parse_0_Memo : Bare_Pragma_Argument_Assoc_Memos.Memo_Type;
      
      Pragma_Transform_Parse_0_Memo : Bare_Pragma_Node_Memos.Memo_Type;
      
      Primary_Or_Parse_0_Memo : Bare_Expr_Memos.Memo_Type;
      
      Protected_Body_Stub_Transform_Parse_0_Memo : Bare_Protected_Body_Stub_Memos.Memo_Type;
      
      Protected_Body_Transform_Parse_1_Memo : Bare_Protected_Body_Memos.Memo_Type;
      
      Protected_Decl_Transform_Parse_0_Memo : Bare_Single_Protected_Decl_Memos.Memo_Type;
      
      Protected_Def_Transform_Parse_3_Memo : Bare_Protected_Def_Memos.Memo_Type;
      
      Protected_El_Or_Parse_0_Memo : Bare_Ada_Node_Memos.Memo_Type;
      
      Protected_Op_Or_Parse_0_Memo : Bare_Ada_Node_Memos.Memo_Type;
      
      Protected_Type_Decl_Transform_Parse_0_Memo : Bare_Protected_Type_Decl_Memos.Memo_Type;
      
      Qual_Name_Internal_Or_Parse_0_Memo : Bare_Name_Memos.Memo_Type;
      
      Qualified_Name_Transform_Parse_0_Memo : Bare_Qual_Expr_Memos.Memo_Type;
      
      Quantified_Expr_Transform_Parse_2_Memo : Bare_Quantified_Expr_Memos.Memo_Type;
      
      Raise_Expr_Or_Parse_0_Memo : Bare_Raise_Expr_Memos.Memo_Type;
      
      Raise_Stmt_Or_Parse_0_Memo : Bare_Raise_Stmt_Memos.Memo_Type;
      
      Range_Constraint_Transform_Parse_1_Memo : Bare_Range_Constraint_Memos.Memo_Type;
      
      Range_Spec_Transform_Parse_0_Memo : Bare_Range_Spec_Memos.Memo_Type;
      
      Real_Type_Def_Or_Parse_0_Memo : Bare_Real_Type_Def_Memos.Memo_Type;
      
      Record_Def_Or_Parse_0_Memo : Bare_Base_Record_Def_Memos.Memo_Type;
      
      Record_Type_Def_Transform_Parse_0_Memo : Bare_Record_Type_Def_Memos.Memo_Type;
      
      Recov_Decl_Part_Dont_Skip_Parse_0_Memo : Bare_Declarative_Part_Memos.Memo_Type;
      
      Regular_Aggregate_Or_Parse_0_Memo : Bare_Base_Aggregate_Memos.Memo_Type;
      
      Rel_Op_Or_Parse_0_Memo : Bare_Op_Memos.Memo_Type;
      
      Relation_Or_Parse_1_Memo : Bare_Expr_Memos.Memo_Type;
      
      Renaming_Clause_Transform_Parse_0_Memo : Bare_Renaming_Clause_Memos.Memo_Type;
      
      Requeue_Stmt_Transform_Parse_0_Memo : Bare_Requeue_Stmt_Memos.Memo_Type;
      
      Return_Stmt_Transform_Parse_0_Memo : Bare_Return_Stmt_Memos.Memo_Type;
      
      Select_Stmt_Transform_Parse_1_Memo : Bare_Select_Stmt_Memos.Memo_Type;
      
      Sexpr_Or_Box_Or_Parse_0_Memo : Bare_Expr_Memos.Memo_Type;
      
      Signed_Int_Type_Def_Transform_Parse_0_Memo : Bare_Signed_Int_Type_Def_Memos.Memo_Type;
      
      Simple_Expr_Or_Parse_1_Memo : Bare_Expr_Memos.Memo_Type;
      
      Simple_Stmt_Or_Parse_0_Memo : Bare_Ada_Node_Memos.Memo_Type;
      
      Simple_Subp_Decl_Transform_Parse_0_Memo : Bare_Subp_Decl_Memos.Memo_Type;
      
      Single_Task_Decl_Transform_Parse_1_Memo : Bare_Single_Task_Decl_Memos.Memo_Type;
      
      Static_Name_Or_Parse_0_Memo : Bare_Name_Memos.Memo_Type;
      
      Stmt_Or_Parse_0_Memo : Bare_Ada_Node_Memos.Memo_Type;
      
      Stmts_List_Parse_0_Memo : Bare_Stmt_List_Memos.Memo_Type;
      
      String_Literal_Transform_Parse_0_Memo : Bare_String_Literal_Memos.Memo_Type;
      
      Sub_Object_Decl_Transform_Parse_0_Memo : Bare_Object_Decl_Memos.Memo_Type;
      
      Subp_Body_Stub_Transform_Parse_0_Memo : Bare_Subp_Body_Stub_Memos.Memo_Type;
      
      Subp_Body_Transform_Parse_1_Memo : Bare_Subp_Body_Memos.Memo_Type;
      
      Subp_Decl_Or_Parse_0_Memo : Bare_Basic_Decl_Memos.Memo_Type;
      
      Subp_Renaming_Decl_Transform_Parse_0_Memo : Bare_Subp_Renaming_Decl_Memos.Memo_Type;
      
      Subp_Spec_Transform_Parse_2_Memo : Bare_Subp_Spec_Memos.Memo_Type;
      
      Subtype_Decl_Transform_Parse_0_Memo : Bare_Subtype_Decl_Memos.Memo_Type;
      
      Subtype_Indication_Transform_Parse_0_Memo : Bare_Subtype_Indication_Memos.Memo_Type;
      
      Subtype_Name_Or_Parse_0_Memo : Bare_Name_Memos.Memo_Type;
      
      Subunit_Transform_Parse_0_Memo : Bare_Subunit_Memos.Memo_Type;
      
      Target_Name_Transform_Parse_0_Memo : Bare_Target_Name_Memos.Memo_Type;
      
      Task_Body_Stub_Transform_Parse_0_Memo : Bare_Task_Body_Stub_Memos.Memo_Type;
      
      Task_Body_Transform_Parse_1_Memo : Bare_Task_Body_Memos.Memo_Type;
      
      Task_Def_Transform_Parse_3_Memo : Bare_Task_Def_Memos.Memo_Type;
      
      Task_Item_Or_Parse_0_Memo : Bare_Ada_Node_Memos.Memo_Type;
      
      Task_Type_Decl_Transform_Parse_0_Memo : Bare_Task_Type_Decl_Memos.Memo_Type;
      
      Term_Or_Parse_1_Memo : Bare_Expr_Memos.Memo_Type;
      
      Terminate_Alternative_Transform_Parse_0_Memo : Bare_Terminate_Alternative_Memos.Memo_Type;
      
      Type_Decl_Or_Parse_1_Memo : Bare_Base_Type_Decl_Memos.Memo_Type;
      
      Type_Def_Or_Parse_0_Memo : Bare_Type_Def_Memos.Memo_Type;
      
      Type_Expr_Or_Parse_0_Memo : Bare_Type_Expr_Memos.Memo_Type;
      
      Unconstrained_Index_Transform_Parse_0_Memo : Bare_Unconstrained_Array_Index_Memos.Memo_Type;
      
      Unop_Term_Or_Parse_1_Memo : Bare_Expr_Memos.Memo_Type;
      
      Update_Attr_Aggregate_Or_Parse_0_Memo : Bare_Base_Aggregate_Memos.Memo_Type;
      
      Update_Attr_Content_List_Parse_0_Memo : Bare_Assoc_List_Memos.Memo_Type;
      
      Use_Clause_Or_Parse_0_Memo : Bare_Use_Clause_Memos.Memo_Type;
      
      Use_Package_Clause_Transform_Parse_0_Memo : Bare_Use_Package_Clause_Memos.Memo_Type;
      
      Use_Type_Clause_Transform_Parse_0_Memo : Bare_Use_Type_Clause_Memos.Memo_Type;
      
      Variant_Part_Transform_Parse_0_Memo : Bare_Variant_Part_Memos.Memo_Type;
      
      Variant_Transform_Parse_0_Memo : Bare_Variant_Memos.Memo_Type;
      
      With_Clause_Transform_Parse_0_Memo : Bare_With_Clause_Memos.Memo_Type;

      Dont_Skip : Dont_Skip_Fn_Vectors.Vector;
   end record;

   
function Identifier_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Identifier;

   
function String_Literal_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_String_Literal;

   
function Char_Literal_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Char_Literal;

   
function Direct_Name_Or_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Base_Id;

   
function Subtype_Name_Or_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Name;

   
function Dec_Literal_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Real_Literal;

   
function Int_Literal_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Int_Literal;

   
function Num_Literal_Or_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Num_Literal;

   
function Null_Literal_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Null_Literal;

   
function Qual_Name_Internal_Or_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Name;

   
function Boolean_Op_Or_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Op;

   
function Rel_Op_Or_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Op;

   
function Membership_Choice_Or_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr;

   
function Membership_Choice_List_List_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr_Alternatives_List;

   
function Relation_Or_Parse_1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr;

   
function Expr_Or_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr;

   
function Paren_Expr_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Paren_Expr;

   
function Defining_Id_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Defining_Name;

   
function Box_Expr_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Box_Expr;

   
function Range_Spec_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Range_Spec;

   
function Digits_Constraint_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Digits_Constraint;

   
function Delta_Constraint_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Delta_Constraint;

   
function Discriminant_Assoc_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Discriminant_Assoc;

   
function Discriminant_Constraint_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Discriminant_Constraint;

   
function Discrete_Subtype_Definition_Or_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Ada_Node;

   
function Constraint_List_List_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Constraint_List;

   
function Index_Constraint_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Index_Constraint;

   
function Constraint_Or_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Constraint;

   
function Subtype_Indication_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Subtype_Indication;

   
function For_Loop_Param_Spec_Transform_Parse_3
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_For_Loop_Spec;

   
function Others_Designator_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Others_Designator;

   
function Choice_Or_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Ada_Node;

   
function Choice_List_List_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Alternatives_List;

   
function Aggregate_Assoc_Or_Parse_2
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Basic_Assoc;

   
function Regular_Aggregate_Or_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Base_Aggregate;

   
function Qualified_Name_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Qual_Expr;

   
function Allocator_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Allocator;

   
function If_Expr_Transform_Parse_1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_If_Expr;

   
function Case_Expr_Alt_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Case_Expr_Alternative;

   
function Case_Expr_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Case_Expr;

   
function Quantified_Expr_Transform_Parse_2
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Quantified_Expr;

   
function Conditional_Expr_Or_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr;

   
function Raise_Expr_Or_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Raise_Expr;

   
function Defining_Id_List_List_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Defining_Name_List;

   
function Mode_Or_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Mode;

   
function Unconstrained_Index_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Unconstrained_Array_Index;

   
function Component_Def_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Component_Def;

   
function Array_Type_Def_Transform_Parse_2
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Array_Type_Def;

   
function Static_Name_Or_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Name;

   
function Defining_Name_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Defining_Name;

   
function Param_Spec_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Param_Spec;

   
function Param_Specs_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Params;

   
function Subp_Spec_Transform_Parse_2
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Subp_Spec;

   
function Access_Def_Or_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Access_Def;

   
function Contract_Case_Assoc_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Contract_Case_Assoc;

   
function Contract_Cases_Expr_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Contract_Cases;

   
function Aspect_Assoc_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Aspect_Assoc;

   
function Aspect_Spec_Opt_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Aspect_Spec;

   
function Anonymous_Type_Decl_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Anonymous_Type_Decl;

   
function Anonymous_Type_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Anonymous_Type;

   
function Type_Expr_Or_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Type_Expr;

   
function Renaming_Clause_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Renaming_Clause;

   
function Sub_Object_Decl_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Object_Decl;

   
function Parent_List_List_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Parent_List;

   
function Overriding_Indicator_Or_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Overriding_Node;

   
function Constrained_Subtype_Indication_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Constrained_Subtype_Indication;

   
function Entry_Decl_Transform_Parse_1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Entry_Decl;

   
function Component_Clause_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Component_Clause;

   
function Pragma_Argument_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Pragma_Argument_Assoc;

   
function Pragma_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Pragma_Node;

   
function Aspect_Clause_Or_Parse_1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Aspect_Clause;

   
function Task_Item_Or_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Ada_Node;

   
function Task_Def_Transform_Parse_3
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Task_Def;

   
function Single_Task_Decl_Transform_Parse_1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Single_Task_Decl;

   
function Null_Subp_Decl_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Null_Subp_Decl;

   
function Abstract_Subp_Decl_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Abstract_Subp_Decl;

   
function Bracket_Aggregate_Or_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Base_Aggregate;

   
function Aggregate_Or_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Base_Aggregate;

   
function Expr_Fn_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr_Function;

   
function Subp_Renaming_Decl_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Subp_Renaming_Decl;

   
function Simple_Subp_Decl_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Subp_Decl;

   
function Subp_Decl_Or_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Basic_Decl;

   
function Protected_Op_Or_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Ada_Node;

   
function Component_Decl_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Component_Decl;

   
function Protected_El_Or_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Ada_Node;

   
function Protected_Def_Transform_Parse_3
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Protected_Def;

   
function Protected_Decl_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Single_Protected_Decl;

   
function Number_Decl_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Number_Decl;

   
function Object_Decl_Or_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Basic_Decl;

   
function Declare_Expr_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Decl_Expr;

   
function Primary_Or_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr;

   
function Factor_Or_Parse_1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr;

   
function Term_Or_Parse_1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr;

   
function Unop_Term_Or_Parse_1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr;

   
function Simple_Expr_Or_Parse_1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr;

   
function Discrete_Range_Or_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr;

   
function Range_Constraint_Transform_Parse_1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Range_Constraint;

   
function Discrete_Subtype_Indication_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Discrete_Subtype_Indication;

   
function Param_Assoc_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Param_Assoc;

   
function Call_Suffix_Or_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Ada_Node;

   
function Multidim_Array_Assoc_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Multi_Dim_Array_Assoc;

   
function Update_Attr_Content_List_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Assoc_List;

   
function Update_Attr_Aggregate_Or_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Base_Aggregate;

   
function Target_Name_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Target_Name;

   
function Direct_Name_Or_Target_Name_Or_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Name;

   
function Name_Or_Parse_1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Name;

   
function Abort_Stmt_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Abort_Stmt;

   
function If_Stmt_Transform_Parse_1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_If_Stmt;

   
function Subp_Body_Stub_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Subp_Body_Stub;

   
function Package_Body_Stub_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Package_Body_Stub;

   
function Task_Body_Stub_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Task_Body_Stub;

   
function Protected_Body_Stub_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Protected_Body_Stub;

   
function Body_Stub_Or_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Body_Stub;

   
function Generic_Instantiation_Or_Parse_1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Generic_Instantiation;

   
function Subp_Body_Transform_Parse_1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Subp_Body;

   
function Package_Body_Transform_Parse_1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Package_Body;

   
function Task_Body_Transform_Parse_1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Task_Body;

   
function Protected_Body_Transform_Parse_1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Protected_Body;

   
function Entry_Body_Transform_Parse_3
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Entry_Body;

   
function Body_Or_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Body_Node;

   
function Discriminant_Spec_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Discriminant_Spec;

   
function Discr_Spec_List_List_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Discriminant_Spec_List;

   
function Discriminant_Part_Or_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Discriminant_Part;

   
function Component_Item_Or_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Ada_Node;

   
function Variant_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Variant;

   
function Variant_Part_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Variant_Part;

   
function Component_List_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Component_List;

   
function Record_Def_Or_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Base_Record_Def;

   
function Record_Type_Def_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Record_Type_Def;

   
function Sexpr_Or_Box_Or_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr;

   
function Floating_Point_Def_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Floating_Point_Def;

   
function Decimal_Fixed_Point_Def_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Decimal_Fixed_Point_Def;

   
function Ordinary_Fixed_Point_Def_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Ordinary_Fixed_Point_Def;

   
function Real_Type_Def_Or_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Real_Type_Def;

   
function Derived_Type_Def_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Derived_Type_Def;

   
function Signed_Int_Type_Def_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Signed_Int_Type_Def;

   
function Mod_Int_Type_Def_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Mod_Int_Type_Def;

   
function Interface_Type_Def_Transform_Parse_4
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Interface_Type_Def;

   
function Formal_Discrete_Type_Def_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Formal_Discrete_Type_Def;

   
function Enum_Literal_Decl_Transform_Parse_1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Enum_Literal_Decl;

   
function Enum_Type_Def_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Enum_Type_Def;

   
function Type_Def_Or_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Type_Def;

   
function Type_Decl_Or_Parse_1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Base_Type_Decl;

   
function Task_Type_Decl_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Task_Type_Decl;

   
function Protected_Type_Decl_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Protected_Type_Decl;

   
function Subtype_Decl_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Subtype_Decl;

   
function Package_Decl_Transform_Parse_3
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Package_Decl;

   
function Use_Package_Clause_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Use_Package_Clause;

   
function Use_Type_Clause_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Use_Type_Clause;

   
function Use_Clause_Or_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Use_Clause;

   
function Exception_Decl_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Exception_Decl;

   
function Package_Renaming_Decl_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Package_Renaming_Decl;

   
function Generic_Renaming_Decl_Or_Parse_1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Generic_Renaming_Decl;

   
function Formal_Subp_Decl_Or_Parse_2
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Formal_Subp_Decl;

   
function Generic_Formal_Decl_Or_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Ada_Node;

   
function Generic_Formal_Part_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Generic_Formal_Part;

   
function Generic_Decl_Or_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Generic_Decl;

   
function Basic_Decl_Or_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Ada_Node;

   
function Basic_Decls_List_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Ada_Node_List;

   
function Decl_Part_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Declarative_Part;

   
function Recov_Decl_Part_Dont_Skip_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Declarative_Part;

   
function Iblock_Stmt_Or_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Block_Stmt;

   
function Block_Stmt_Or_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Composite_Stmt;

   
function Iloop_Stmt_Or_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Base_Loop_Stmt;

   
function Loop_Stmt_Or_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Composite_Stmt;

   
function Ext_Ret_Stmt_Object_Decl_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Extended_Return_Stmt_Object_Decl;

   
function Ext_Return_Stmt_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Extended_Return_Stmt;

   
function Case_Alt_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Case_Stmt_Alternative;

   
function Case_Stmt_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Case_Stmt;

   
function Select_Stmt_Transform_Parse_1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Select_Stmt;

   
function Compound_Stmt_Or_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Composite_Stmt;

   
function Null_Stmt_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Null_Stmt;

   
function Assignment_Stmt_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Assign_Stmt;

   
function Goto_Stmt_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Goto_Stmt;

   
function Exit_Stmt_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Exit_Stmt;

   
function Return_Stmt_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Return_Stmt;

   
function Requeue_Stmt_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Requeue_Stmt;

   
function Call_Stmt_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Call_Stmt;

   
function Delay_Stmt_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Delay_Stmt;

   
function Raise_Stmt_Or_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Raise_Stmt;

   
function Terminate_Alternative_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Terminate_Alternative;

   
function Simple_Stmt_Or_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Ada_Node;

   
function Stmt_Or_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Ada_Node;

   
function Label_Transform_Parse_1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Label;

   
function Stmts_List_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Stmt_List;

   
function Exception_Handler_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Exception_Handler;

   
function Handled_Stmts_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Handled_Stmts;

   
function Accept_Stmt_Or_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Accept_Stmt;

   
function With_Clause_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_With_Clause;

   
function Context_Item_Or_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Ada_Node;

   
function Subunit_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Subunit;

   
function Library_Unit_Body_Or_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Body_Node;

   
function Library_Unit_Renaming_Decl_Or_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Basic_Decl;

   
function Library_Item_Transform_Parse_1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Library_Item;

   
function Compilation_Unit_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Compilation_Unit;

   
function Compilation_Or_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Ada_Node;

   
function Dontskip_Case_Alt_0_Extract_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Ada_Node;

   
function Dontskip_Exception_Handler_0_Extract_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Ada_Node;

   
function Dontskip_Generic_Decl_0_Extract_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Ada_Node;

   
function Dontskip_Generic_Decl_1_Extract_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Ada_Node;

   
function Dontskip_Handled_Stmts_0_Extract_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Ada_Node;

   
function Dontskip_If_Stmt_0_Extract_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Ada_Node;

   
function Dontskip_If_Stmt_1_Extract_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Ada_Node;

   
function Dontskip_If_Stmt_2_Extract_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Ada_Node;

   
function Dontskip_Iloop_Stmt_0_Extract_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Ada_Node;

   
function Dontskip_Iloop_Stmt_1_Extract_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Ada_Node;

   
function Dontskip_Iloop_Stmt_2_Extract_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Ada_Node;

   
function Dontskip_Package_Body_0_Extract_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Ada_Node;

   
function Dontskip_Package_Decl_0_Extract_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Ada_Node;

   
function Dontskip_Package_Decl_1_Extract_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Ada_Node;

   
function Dontskip_Protected_Body_0_Extract_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Ada_Node;

   
function Dontskip_Recov_Decl_Part_0_Extract_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Ada_Node;

   
function Dontskip_Select_Stmt_0_Extract_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Ada_Node;

   
function Dontskip_Select_Stmt_1_Extract_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Ada_Node;

   
function Dontskip_Select_Stmt_2_Extract_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Ada_Node;


   procedure Process_Parsing_Error
     (Parser         : in out Parser_Type;
      Check_Complete : Boolean := True);
   --  Helper for the user parsing function, to be called after a low-level
   --  parsing function. Check_Complete has the same semantics as in Parse. If
   --  the parsing failed (Parser.Current_Pos = No_Token_Index), append
   --  corresponding diagnostics to Parser.Diagnostics, do nothing instead.

   procedure Add_Last_Fail_Diagnostic (Parser : in out Parser_Type);
   --  Add a diagnostic for the last fail position of the parser

   function Get_Parse_List (Parser : Parser_Type) return Free_Parse_List;
   --  Get a free parse list, or allocate one if there is no free parse list in
   --  Parser. When done with the result, the caller must invoke
   --  Release_Parse_List.

   procedure Release_Parse_List
     (Parser : Parser_Type; List : in out Free_Parse_List);
   --  Release a parse list, putting it in Parsers' free list. Set List to
   --  null.

   ---------------------
   -- Initialize_List --
   ---------------------

   procedure Initialize_List
     (Self   : Bare_Ada_List;
      Parser : Parser_Type;
      Count  : Natural) is
   begin
      Self.Count := Count;
      Self.Nodes := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, 0);
   end Initialize_List;

   -----------------
   -- Init_Parser --
   -----------------

   procedure Init_Parser
     (Input       : Internal_Lexer_Input;
      With_Trivia : Boolean;
      Unit        : access Implementation.Analysis_Unit_Type;
      TDH         : Token_Data_Handler_Access;
      Parser      : in out Parser_Type) is
   begin
      Reset (Parser);
      Extract_Tokens
        (Input, With_Trivia, TDH.all, Parser.Diagnostics);
      Parser.Unit := Unit;
      Parser.TDH := TDH;
   end Init_Parser;

   ------------------------------
   -- Add_Last_Fail_Diagnostic --
   ------------------------------

   procedure Add_Last_Fail_Diagnostic (Parser : in out Parser_Type)
   is
      Last_Token : Stored_Token_Data renames
         Get_Token (Parser.TDH.all, Parser.Last_Fail.Pos);
      D : constant Diagnostic :=
        (if Parser.Last_Fail.Kind = Token_Fail then
          Create (Sloc_Range (Parser.TDH.all, Last_Token), To_Text
            ("Expected "
             & Token_Error_Image (Parser.Last_Fail.Expected_Token_Id)
             & ", got "
             & Token_Error_Image (Parser.Last_Fail.Found_Token_Id)))
         else
           Create (Sloc_Range (Parser.TDH.all, Last_Token),
                   To_Text (Parser.Last_Fail.Custom_Message.all)));
   begin
      Parser.Diagnostics.Append (D);
   end Add_Last_Fail_Diagnostic;

   ---------------------------
   -- Process_Parsing_Error --
   ---------------------------

   procedure Process_Parsing_Error
     (Parser         : in out Parser_Type;
      Check_Complete : Boolean := True) is
   begin

      if Parser.Current_Pos = No_Token_Index then
         Add_Last_Fail_Diagnostic (Parser);
      elsif Check_Complete
        and then Parser.Current_Pos /= Last_Token (Parser.TDH.all)
      then
         --  If the fail pos is the current position of the parser or after,
         --  it means that the longest parse is the correct result, and that we
         --  have some garbage afterwards.
         if Parser.Current_Pos >= Parser.Last_Fail.Pos then
            declare
               First_Garbage_Token : Stored_Token_Data renames
                  Get_Token (Parser.TDH.all, Parser.Current_Pos);
            begin
               Append
                 (Parser.Diagnostics,
                  Sloc_Range (Parser.TDH.all, First_Garbage_Token),
                  To_Text
                    ("End of input expected, got """
                     & Token_Kind_Name
                         (To_Token_Kind (First_Garbage_Token.Kind))
                     & """"));
            end;

         --  Else, the last fail pos is further down the line, and we want to
         --  have the diagnostic of what exactly failed.
         else
            Add_Last_Fail_Diagnostic (Parser);
         end if;
      end if;

   end Process_Parsing_Error;

   -----------
   -- Parse --
   -----------

   function Parse
     (Parser         : in out Parser_Type;
      Check_Complete : Boolean := True;
      Rule           : Grammar_Rule) return Parsed_Node
   is
      Result : Bare_Ada_Node;
   begin
      case Rule is
         when Parent_List_Rule =>
            Result := Parent_List_List_Parse_0
              (Parser, First_Token_Index);
         when Protected_Type_Decl_Rule =>
            Result := Protected_Type_Decl_Transform_Parse_0
              (Parser, First_Token_Index);
         when Protected_Op_Rule =>
            Result := Protected_Op_Or_Parse_0
              (Parser, First_Token_Index);
         when Protected_El_Rule =>
            Result := Protected_El_Or_Parse_0
              (Parser, First_Token_Index);
         when Protected_Def_Rule =>
            Result := Protected_Def_Transform_Parse_3
              (Parser, First_Token_Index);
         when Protected_Decl_Rule =>
            Result := Protected_Decl_Transform_Parse_0
              (Parser, First_Token_Index);
         when Task_Item_Rule =>
            Result := Task_Item_Or_Parse_0
              (Parser, First_Token_Index);
         when Task_Def_Rule =>
            Result := Task_Def_Transform_Parse_3
              (Parser, First_Token_Index);
         when Task_Type_Decl_Rule =>
            Result := Task_Type_Decl_Transform_Parse_0
              (Parser, First_Token_Index);
         when Subtype_Decl_Rule =>
            Result := Subtype_Decl_Transform_Parse_0
              (Parser, First_Token_Index);
         when Interface_Type_Def_Rule =>
            Result := Interface_Type_Def_Transform_Parse_4
              (Parser, First_Token_Index);
         when Unconstrained_Index_Rule =>
            Result := Unconstrained_Index_Transform_Parse_0
              (Parser, First_Token_Index);
         when Array_Type_Def_Rule =>
            Result := Array_Type_Def_Transform_Parse_2
              (Parser, First_Token_Index);
         when Discrete_Subtype_Definition_Rule =>
            Result := Discrete_Subtype_Definition_Or_Parse_0
              (Parser, First_Token_Index);
         when Constraint_List_Rule =>
            Result := Constraint_List_List_Parse_0
              (Parser, First_Token_Index);
         when Signed_Int_Type_Def_Rule =>
            Result := Signed_Int_Type_Def_Transform_Parse_0
              (Parser, First_Token_Index);
         when Mod_Int_Type_Def_Rule =>
            Result := Mod_Int_Type_Def_Transform_Parse_0
              (Parser, First_Token_Index);
         when Derived_Type_Def_Rule =>
            Result := Derived_Type_Def_Transform_Parse_0
              (Parser, First_Token_Index);
         when Discriminant_Assoc_Rule =>
            Result := Discriminant_Assoc_Transform_Parse_0
              (Parser, First_Token_Index);
         when Discriminant_Constraint_Rule =>
            Result := Discriminant_Constraint_Transform_Parse_0
              (Parser, First_Token_Index);
         when Index_Constraint_Rule =>
            Result := Index_Constraint_Transform_Parse_0
              (Parser, First_Token_Index);
         when Digits_Constraint_Rule =>
            Result := Digits_Constraint_Transform_Parse_0
              (Parser, First_Token_Index);
         when Delta_Constraint_Rule =>
            Result := Delta_Constraint_Transform_Parse_0
              (Parser, First_Token_Index);
         when Range_Constraint_Rule =>
            Result := Range_Constraint_Transform_Parse_1
              (Parser, First_Token_Index);
         when Constraint_Rule =>
            Result := Constraint_Or_Parse_0
              (Parser, First_Token_Index);
         when Discriminant_Spec_Rule =>
            Result := Discriminant_Spec_Transform_Parse_0
              (Parser, First_Token_Index);
         when Discr_Spec_List_Rule =>
            Result := Discr_Spec_List_List_Parse_0
              (Parser, First_Token_Index);
         when Discriminant_Part_Rule =>
            Result := Discriminant_Part_Or_Parse_0
              (Parser, First_Token_Index);
         when Enum_Literal_Decl_Rule =>
            Result := Enum_Literal_Decl_Transform_Parse_1
              (Parser, First_Token_Index);
         when Formal_Discrete_Type_Def_Rule =>
            Result := Formal_Discrete_Type_Def_Transform_Parse_0
              (Parser, First_Token_Index);
         when Record_Def_Rule =>
            Result := Record_Def_Or_Parse_0
              (Parser, First_Token_Index);
         when Range_Spec_Rule =>
            Result := Range_Spec_Transform_Parse_0
              (Parser, First_Token_Index);
         when Real_Type_Def_Rule =>
            Result := Real_Type_Def_Or_Parse_0
              (Parser, First_Token_Index);
         when Sexpr_Or_Box_Rule =>
            Result := Sexpr_Or_Box_Or_Parse_0
              (Parser, First_Token_Index);
         when Ordinary_Fixed_Point_Def_Rule =>
            Result := Ordinary_Fixed_Point_Def_Transform_Parse_0
              (Parser, First_Token_Index);
         when Decimal_Fixed_Point_Def_Rule =>
            Result := Decimal_Fixed_Point_Def_Transform_Parse_0
              (Parser, First_Token_Index);
         when Floating_Point_Def_Rule =>
            Result := Floating_Point_Def_Transform_Parse_0
              (Parser, First_Token_Index);
         when Record_Type_Def_Rule =>
            Result := Record_Type_Def_Transform_Parse_0
              (Parser, First_Token_Index);
         when Access_Def_Rule =>
            Result := Access_Def_Or_Parse_0
              (Parser, First_Token_Index);
         when Enum_Type_Def_Rule =>
            Result := Enum_Type_Def_Transform_Parse_0
              (Parser, First_Token_Index);
         when Type_Def_Rule =>
            Result := Type_Def_Or_Parse_0
              (Parser, First_Token_Index);
         when Variant_Rule =>
            Result := Variant_Transform_Parse_0
              (Parser, First_Token_Index);
         when Anonymous_Type_Decl_Rule =>
            Result := Anonymous_Type_Decl_Transform_Parse_0
              (Parser, First_Token_Index);
         when Type_Decl_Rule =>
            Result := Type_Decl_Or_Parse_1
              (Parser, First_Token_Index);
         when Variant_Part_Rule =>
            Result := Variant_Part_Transform_Parse_0
              (Parser, First_Token_Index);
         when Component_Def_Rule =>
            Result := Component_Def_Transform_Parse_0
              (Parser, First_Token_Index);
         when Component_Item_Rule =>
            Result := Component_Item_Or_Parse_0
              (Parser, First_Token_Index);
         when Component_Decl_Rule =>
            Result := Component_Decl_Transform_Parse_0
              (Parser, First_Token_Index);
         when Component_List_Rule =>
            Result := Component_List_Transform_Parse_0
              (Parser, First_Token_Index);
         when Generic_Decl_Rule =>
            Result := Generic_Decl_Or_Parse_0
              (Parser, First_Token_Index);
         when Generic_Formal_Part_Rule =>
            Result := Generic_Formal_Part_Transform_Parse_0
              (Parser, First_Token_Index);
         when Generic_Formal_Decl_Rule =>
            Result := Generic_Formal_Decl_Or_Parse_0
              (Parser, First_Token_Index);
         when Formal_Subp_Decl_Rule =>
            Result := Formal_Subp_Decl_Or_Parse_2
              (Parser, First_Token_Index);
         when Renaming_Clause_Rule =>
            Result := Renaming_Clause_Transform_Parse_0
              (Parser, First_Token_Index);
         when Generic_Renaming_Decl_Rule =>
            Result := Generic_Renaming_Decl_Or_Parse_1
              (Parser, First_Token_Index);
         when Generic_Instantiation_Rule =>
            Result := Generic_Instantiation_Or_Parse_1
              (Parser, First_Token_Index);
         when Exception_Decl_Rule =>
            Result := Exception_Decl_Transform_Parse_0
              (Parser, First_Token_Index);
         when Basic_Decls_Rule =>
            Result := Basic_Decls_List_Parse_0
              (Parser, First_Token_Index);
         when Package_Renaming_Decl_Rule =>
            Result := Package_Renaming_Decl_Transform_Parse_0
              (Parser, First_Token_Index);
         when Package_Decl_Rule =>
            Result := Package_Decl_Transform_Parse_3
              (Parser, First_Token_Index);
         when Basic_Decl_Rule =>
            Result := Basic_Decl_Or_Parse_0
              (Parser, First_Token_Index);
         when Object_Decl_Rule =>
            Result := Object_Decl_Or_Parse_0
              (Parser, First_Token_Index);
         when Sub_Object_Decl_Rule =>
            Result := Sub_Object_Decl_Transform_Parse_0
              (Parser, First_Token_Index);
         when Ext_Ret_Stmt_Object_Decl_Rule =>
            Result := Ext_Ret_Stmt_Object_Decl_Transform_Parse_0
              (Parser, First_Token_Index);
         when Defining_Id_List_Rule =>
            Result := Defining_Id_List_List_Parse_0
              (Parser, First_Token_Index);
         when Number_Decl_Rule =>
            Result := Number_Decl_Transform_Parse_0
              (Parser, First_Token_Index);
         when Contract_Case_Assoc_Rule =>
            Result := Contract_Case_Assoc_Transform_Parse_0
              (Parser, First_Token_Index);
         when Contract_Cases_Expr_Rule =>
            Result := Contract_Cases_Expr_Transform_Parse_0
              (Parser, First_Token_Index);
         when Aspect_Assoc_Rule =>
            Result := Aspect_Assoc_Transform_Parse_0
              (Parser, First_Token_Index);
         when Aspect_Spec_Rule =>
            Result := Aspect_Spec_Opt_Parse_0
              (Parser, First_Token_Index);
         when Single_Task_Decl_Rule =>
            Result := Single_Task_Decl_Transform_Parse_1
              (Parser, First_Token_Index);
         when Overriding_Indicator_Rule =>
            Result := Overriding_Indicator_Or_Parse_0
              (Parser, First_Token_Index);
         when Entry_Decl_Rule =>
            Result := Entry_Decl_Transform_Parse_1
              (Parser, First_Token_Index);
         when Component_Clause_Rule =>
            Result := Component_Clause_Transform_Parse_0
              (Parser, First_Token_Index);
         when Aspect_Clause_Rule =>
            Result := Aspect_Clause_Or_Parse_1
              (Parser, First_Token_Index);
         when Param_Spec_Rule =>
            Result := Param_Spec_Transform_Parse_0
              (Parser, First_Token_Index);
         when Param_Specs_Rule =>
            Result := Param_Specs_Transform_Parse_0
              (Parser, First_Token_Index);
         when Subp_Spec_Rule =>
            Result := Subp_Spec_Transform_Parse_2
              (Parser, First_Token_Index);
         when Expr_Fn_Rule =>
            Result := Expr_Fn_Transform_Parse_0
              (Parser, First_Token_Index);
         when Null_Subp_Decl_Rule =>
            Result := Null_Subp_Decl_Transform_Parse_0
              (Parser, First_Token_Index);
         when Abstract_Subp_Decl_Rule =>
            Result := Abstract_Subp_Decl_Transform_Parse_0
              (Parser, First_Token_Index);
         when Subp_Renaming_Decl_Rule =>
            Result := Subp_Renaming_Decl_Transform_Parse_0
              (Parser, First_Token_Index);
         when Simple_Subp_Decl_Rule =>
            Result := Simple_Subp_Decl_Transform_Parse_0
              (Parser, First_Token_Index);
         when Subp_Decl_Rule =>
            Result := Subp_Decl_Or_Parse_0
              (Parser, First_Token_Index);
         when With_Clause_Rule =>
            Result := With_Clause_Transform_Parse_0
              (Parser, First_Token_Index);
         when Context_Item_Rule =>
            Result := Context_Item_Or_Parse_0
              (Parser, First_Token_Index);
         when Use_Clause_Rule =>
            Result := Use_Clause_Or_Parse_0
              (Parser, First_Token_Index);
         when Use_Package_Clause_Rule =>
            Result := Use_Package_Clause_Transform_Parse_0
              (Parser, First_Token_Index);
         when Use_Type_Clause_Rule =>
            Result := Use_Type_Clause_Transform_Parse_0
              (Parser, First_Token_Index);
         when Subtype_Indication_Rule =>
            Result := Subtype_Indication_Transform_Parse_0
              (Parser, First_Token_Index);
         when Discrete_Subtype_Indication_Rule =>
            Result := Discrete_Subtype_Indication_Transform_Parse_0
              (Parser, First_Token_Index);
         when Constrained_Subtype_Indication_Rule =>
            Result := Constrained_Subtype_Indication_Transform_Parse_0
              (Parser, First_Token_Index);
         when Type_Expr_Rule =>
            Result := Type_Expr_Or_Parse_0
              (Parser, First_Token_Index);
         when Anonymous_Type_Rule =>
            Result := Anonymous_Type_Transform_Parse_0
              (Parser, First_Token_Index);
         when Mode_Rule =>
            Result := Mode_Or_Parse_0
              (Parser, First_Token_Index);
         when Pragma_Argument_Rule =>
            Result := Pragma_Argument_Transform_Parse_0
              (Parser, First_Token_Index);
         when Pragma_Rule =>
            Result := Pragma_Transform_Parse_0
              (Parser, First_Token_Index);
         when Subunit_Rule =>
            Result := Subunit_Transform_Parse_0
              (Parser, First_Token_Index);
         when Library_Unit_Body_Rule =>
            Result := Library_Unit_Body_Or_Parse_0
              (Parser, First_Token_Index);
         when Library_Unit_Renaming_Decl_Rule =>
            Result := Library_Unit_Renaming_Decl_Or_Parse_0
              (Parser, First_Token_Index);
         when Library_Item_Rule =>
            Result := Library_Item_Transform_Parse_1
              (Parser, First_Token_Index);
         when Compilation_Unit_Rule =>
            Result := Compilation_Unit_Transform_Parse_0
              (Parser, First_Token_Index);
         when Compilation_Rule =>
            Result := Compilation_Or_Parse_0
              (Parser, First_Token_Index);
         when Decl_Part_Rule =>
            Result := Decl_Part_Transform_Parse_0
              (Parser, First_Token_Index);
         when Entry_Body_Rule =>
            Result := Entry_Body_Transform_Parse_3
              (Parser, First_Token_Index);
         when Protected_Body_Rule =>
            Result := Protected_Body_Transform_Parse_1
              (Parser, First_Token_Index);
         when Protected_Body_Stub_Rule =>
            Result := Protected_Body_Stub_Transform_Parse_0
              (Parser, First_Token_Index);
         when Task_Body_Rule =>
            Result := Task_Body_Transform_Parse_1
              (Parser, First_Token_Index);
         when Task_Body_Stub_Rule =>
            Result := Task_Body_Stub_Transform_Parse_0
              (Parser, First_Token_Index);
         when Package_Body_Stub_Rule =>
            Result := Package_Body_Stub_Transform_Parse_0
              (Parser, First_Token_Index);
         when Package_Body_Rule =>
            Result := Package_Body_Transform_Parse_1
              (Parser, First_Token_Index);
         when Terminate_Alternative_Rule =>
            Result := Terminate_Alternative_Transform_Parse_0
              (Parser, First_Token_Index);
         when Select_Stmt_Rule =>
            Result := Select_Stmt_Transform_Parse_1
              (Parser, First_Token_Index);
         when Accept_Stmt_Rule =>
            Result := Accept_Stmt_Or_Parse_0
              (Parser, First_Token_Index);
         when Case_Alt_Rule =>
            Result := Case_Alt_Transform_Parse_0
              (Parser, First_Token_Index);
         when Case_Stmt_Rule =>
            Result := Case_Stmt_Transform_Parse_0
              (Parser, First_Token_Index);
         when Ext_Return_Stmt_Rule =>
            Result := Ext_Return_Stmt_Transform_Parse_0
              (Parser, First_Token_Index);
         when Iblock_Stmt_Rule =>
            Result := Iblock_Stmt_Or_Parse_0
              (Parser, First_Token_Index);
         when Block_Stmt_Rule =>
            Result := Block_Stmt_Or_Parse_0
              (Parser, First_Token_Index);
         when Iloop_Stmt_Rule =>
            Result := Iloop_Stmt_Or_Parse_0
              (Parser, First_Token_Index);
         when Loop_Stmt_Rule =>
            Result := Loop_Stmt_Or_Parse_0
              (Parser, First_Token_Index);
         when Compound_Stmt_Rule =>
            Result := Compound_Stmt_Or_Parse_0
              (Parser, First_Token_Index);
         when If_Stmt_Rule =>
            Result := If_Stmt_Transform_Parse_1
              (Parser, First_Token_Index);
         when Raise_Stmt_Rule =>
            Result := Raise_Stmt_Or_Parse_0
              (Parser, First_Token_Index);
         when Delay_Stmt_Rule =>
            Result := Delay_Stmt_Transform_Parse_0
              (Parser, First_Token_Index);
         when Abort_Stmt_Rule =>
            Result := Abort_Stmt_Transform_Parse_0
              (Parser, First_Token_Index);
         when Body_Rule =>
            Result := Body_Or_Parse_0
              (Parser, First_Token_Index);
         when Body_Stub_Rule =>
            Result := Body_Stub_Or_Parse_0
              (Parser, First_Token_Index);
         when Subp_Body_Stub_Rule =>
            Result := Subp_Body_Stub_Transform_Parse_0
              (Parser, First_Token_Index);
         when Recov_Decl_Part_Rule =>
            Result := Recov_Decl_Part_Dont_Skip_Parse_0
              (Parser, First_Token_Index);
         when Subp_Body_Rule =>
            Result := Subp_Body_Transform_Parse_1
              (Parser, First_Token_Index);
         when Handled_Stmts_Rule =>
            Result := Handled_Stmts_Transform_Parse_0
              (Parser, First_Token_Index);
         when Exception_Handler_Rule =>
            Result := Exception_Handler_Transform_Parse_0
              (Parser, First_Token_Index);
         when Stmts_Rule =>
            Result := Stmts_List_Parse_0
              (Parser, First_Token_Index);
         when Label_Rule =>
            Result := Label_Transform_Parse_1
              (Parser, First_Token_Index);
         when Stmt_Rule =>
            Result := Stmt_Or_Parse_0
              (Parser, First_Token_Index);
         when Call_Stmt_Rule =>
            Result := Call_Stmt_Transform_Parse_0
              (Parser, First_Token_Index);
         when Simple_Stmt_Rule =>
            Result := Simple_Stmt_Or_Parse_0
              (Parser, First_Token_Index);
         when Null_Stmt_Rule =>
            Result := Null_Stmt_Transform_Parse_0
              (Parser, First_Token_Index);
         when Assignment_Stmt_Rule =>
            Result := Assignment_Stmt_Transform_Parse_0
              (Parser, First_Token_Index);
         when Goto_Stmt_Rule =>
            Result := Goto_Stmt_Transform_Parse_0
              (Parser, First_Token_Index);
         when Exit_Stmt_Rule =>
            Result := Exit_Stmt_Transform_Parse_0
              (Parser, First_Token_Index);
         when Return_Stmt_Rule =>
            Result := Return_Stmt_Transform_Parse_0
              (Parser, First_Token_Index);
         when Requeue_Stmt_Rule =>
            Result := Requeue_Stmt_Transform_Parse_0
              (Parser, First_Token_Index);
         when Identifier_Rule =>
            Result := Identifier_Transform_Parse_0
              (Parser, First_Token_Index);
         when Char_Literal_Rule =>
            Result := Char_Literal_Transform_Parse_0
              (Parser, First_Token_Index);
         when String_Literal_Rule =>
            Result := String_Literal_Transform_Parse_0
              (Parser, First_Token_Index);
         when Defining_Id_Rule =>
            Result := Defining_Id_Transform_Parse_0
              (Parser, First_Token_Index);
         when Dec_Literal_Rule =>
            Result := Dec_Literal_Transform_Parse_0
              (Parser, First_Token_Index);
         when Int_Literal_Rule =>
            Result := Int_Literal_Transform_Parse_0
              (Parser, First_Token_Index);
         when Num_Literal_Rule =>
            Result := Num_Literal_Or_Parse_0
              (Parser, First_Token_Index);
         when Null_Literal_Rule =>
            Result := Null_Literal_Transform_Parse_0
              (Parser, First_Token_Index);
         when Allocator_Rule =>
            Result := Allocator_Transform_Parse_0
              (Parser, First_Token_Index);
         when For_Loop_Param_Spec_Rule =>
            Result := For_Loop_Param_Spec_Transform_Parse_3
              (Parser, First_Token_Index);
         when Quantified_Expr_Rule =>
            Result := Quantified_Expr_Transform_Parse_2
              (Parser, First_Token_Index);
         when Case_Expr_Rule =>
            Result := Case_Expr_Transform_Parse_0
              (Parser, First_Token_Index);
         when Case_Expr_Alt_Rule =>
            Result := Case_Expr_Alt_Transform_Parse_0
              (Parser, First_Token_Index);
         when Raise_Expr_Rule =>
            Result := Raise_Expr_Or_Parse_0
              (Parser, First_Token_Index);
         when If_Expr_Rule =>
            Result := If_Expr_Transform_Parse_1
              (Parser, First_Token_Index);
         when Conditional_Expr_Rule =>
            Result := Conditional_Expr_Or_Parse_0
              (Parser, First_Token_Index);
         when Box_Expr_Rule =>
            Result := Box_Expr_Transform_Parse_0
              (Parser, First_Token_Index);
         when Others_Designator_Rule =>
            Result := Others_Designator_Transform_Parse_0
              (Parser, First_Token_Index);
         when Aggregate_Assoc_Rule =>
            Result := Aggregate_Assoc_Or_Parse_2
              (Parser, First_Token_Index);
         when Regular_Aggregate_Rule =>
            Result := Regular_Aggregate_Or_Parse_0
              (Parser, First_Token_Index);
         when Bracket_Aggregate_Rule =>
            Result := Bracket_Aggregate_Or_Parse_0
              (Parser, First_Token_Index);
         when Aggregate_Rule =>
            Result := Aggregate_Or_Parse_0
              (Parser, First_Token_Index);
         when Direct_Name_Rule =>
            Result := Direct_Name_Or_Parse_0
              (Parser, First_Token_Index);
         when Param_Assoc_Rule =>
            Result := Param_Assoc_Transform_Parse_0
              (Parser, First_Token_Index);
         when Call_Suffix_Rule =>
            Result := Call_Suffix_Or_Parse_0
              (Parser, First_Token_Index);
         when Qualified_Name_Rule =>
            Result := Qualified_Name_Transform_Parse_0
              (Parser, First_Token_Index);
         when Qual_Name_Internal_Rule =>
            Result := Qual_Name_Internal_Or_Parse_0
              (Parser, First_Token_Index);
         when Name_Rule =>
            Result := Name_Or_Parse_1
              (Parser, First_Token_Index);
         when Defining_Name_Rule =>
            Result := Defining_Name_Transform_Parse_0
              (Parser, First_Token_Index);
         when Direct_Name_Or_Target_Name_Rule =>
            Result := Direct_Name_Or_Target_Name_Or_Parse_0
              (Parser, First_Token_Index);
         when Target_Name_Rule =>
            Result := Target_Name_Transform_Parse_0
              (Parser, First_Token_Index);
         when Update_Attr_Aggregate_Rule =>
            Result := Update_Attr_Aggregate_Or_Parse_0
              (Parser, First_Token_Index);
         when Update_Attr_Content_Rule =>
            Result := Update_Attr_Content_List_Parse_0
              (Parser, First_Token_Index);
         when Multidim_Array_Assoc_Rule =>
            Result := Multidim_Array_Assoc_Transform_Parse_0
              (Parser, First_Token_Index);
         when Subtype_Name_Rule =>
            Result := Subtype_Name_Or_Parse_0
              (Parser, First_Token_Index);
         when Static_Name_Rule =>
            Result := Static_Name_Or_Parse_0
              (Parser, First_Token_Index);
         when Primary_Rule =>
            Result := Primary_Or_Parse_0
              (Parser, First_Token_Index);
         when Paren_Expr_Rule =>
            Result := Paren_Expr_Transform_Parse_0
              (Parser, First_Token_Index);
         when Declare_Expr_Rule =>
            Result := Declare_Expr_Transform_Parse_0
              (Parser, First_Token_Index);
         when Factor_Rule =>
            Result := Factor_Or_Parse_1
              (Parser, First_Token_Index);
         when Term_Rule =>
            Result := Term_Or_Parse_1
              (Parser, First_Token_Index);
         when Unop_Term_Rule =>
            Result := Unop_Term_Or_Parse_1
              (Parser, First_Token_Index);
         when Simple_Expr_Rule =>
            Result := Simple_Expr_Or_Parse_1
              (Parser, First_Token_Index);
         when Boolean_Op_Rule =>
            Result := Boolean_Op_Or_Parse_0
              (Parser, First_Token_Index);
         when Discrete_Range_Rule =>
            Result := Discrete_Range_Or_Parse_0
              (Parser, First_Token_Index);
         when Choice_Rule =>
            Result := Choice_Or_Parse_0
              (Parser, First_Token_Index);
         when Choice_List_Rule =>
            Result := Choice_List_List_Parse_0
              (Parser, First_Token_Index);
         when Rel_Op_Rule =>
            Result := Rel_Op_Or_Parse_0
              (Parser, First_Token_Index);
         when Membership_Choice_Rule =>
            Result := Membership_Choice_Or_Parse_0
              (Parser, First_Token_Index);
         when Membership_Choice_List_Rule =>
            Result := Membership_Choice_List_List_Parse_0
              (Parser, First_Token_Index);
         when Relation_Rule =>
            Result := Relation_Or_Parse_1
              (Parser, First_Token_Index);
         when Expr_Rule =>
            Result := Expr_Or_Parse_0
              (Parser, First_Token_Index);
      end case;
      Process_Parsing_Error (Parser, Check_Complete);
      Set_Parents (Result, null);
      return Parsed_Node (Result);
   end Parse;

   


function Identifier_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Identifier
is
   use Bare_Identifier_Memos;

      Row_Pos_15 :
            Token_Index
               := No_Token_Index;
      Token_Pos_22 :
            Token_Index
               := No_Token_Index;
      Token_Res_22 :
            Token_Index
               := No_Token_Index;
      Transform_Res_12 :
            Bare_Identifier
               := No_Bare_Ada_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Identifier_Transform_Parse_0_Memo, Pos);

begin

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res_12 := M.Instance;
      return Transform_Res_12;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res_12;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code


--  Start row_code

Row_Pos_15 := Pos;



--  Start tok_code

Token_Res_22 := Row_Pos_15;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_22));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Identifier)
   then
       Token_Pos_22 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_15 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_15,
             Expected_Token_Id => Ada_Identifier,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_22 := Row_Pos_15 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_22 /= No_Token_Index then

   Row_Pos_15 := Token_Pos_22;

else
   Row_Pos_15 := No_Token_Index;
   goto Exit_Row_5_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_5_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_15 /= No_Token_Index then

   Transform_Res_12 := Allocate_Identifier (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_12,
      Kind => Ada_Identifier,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_15 = Pos
                            then No_Token_Index
                            else Row_Pos_15 - 1));

      Initialize_Fields_For_Identifier
        (Self => Transform_Res_12);



end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Identifier_Transform_Parse_0_Memo,
      Row_Pos_15 /= No_Token_Index,
      Transform_Res_12,
      Pos,
      Row_Pos_15);


   Parser.Current_Pos := Row_Pos_15;

   return Transform_Res_12;
end Identifier_Transform_Parse_0;

   


function String_Literal_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_String_Literal
is
   use Bare_String_Literal_Memos;

      Row_Pos_16 :
            Token_Index
               := No_Token_Index;
      Token_Pos_23 :
            Token_Index
               := No_Token_Index;
      Token_Res_23 :
            Token_Index
               := No_Token_Index;
      Transform_Res_13 :
            Bare_String_Literal
               := No_Bare_Ada_Node;


   M : Memo_Entry := Get (Parser.Private_Part.String_Literal_Transform_Parse_0_Memo, Pos);

begin

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res_13 := M.Instance;
      return Transform_Res_13;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res_13;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code


--  Start row_code

Row_Pos_16 := Pos;



--  Start tok_code

Token_Res_23 := Row_Pos_16;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_23));
begin
   if
      T.Kind /= From_Token_Kind (Ada_String)
   then
       Token_Pos_23 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_16 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_16,
             Expected_Token_Id => Ada_String,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_23 := Row_Pos_16 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_23 /= No_Token_Index then

   Row_Pos_16 := Token_Pos_23;

else
   Row_Pos_16 := No_Token_Index;
   goto Exit_Row_6_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_6_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_16 /= No_Token_Index then

   Transform_Res_13 := Allocate_String_Literal (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_13,
      Kind => Ada_String_Literal,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_16 = Pos
                            then No_Token_Index
                            else Row_Pos_16 - 1));

      Initialize_Fields_For_String_Literal
        (Self => Transform_Res_13);



end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.String_Literal_Transform_Parse_0_Memo,
      Row_Pos_16 /= No_Token_Index,
      Transform_Res_13,
      Pos,
      Row_Pos_16);


   Parser.Current_Pos := Row_Pos_16;

   return Transform_Res_13;
end String_Literal_Transform_Parse_0;

   


function Char_Literal_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Char_Literal
is
   use Bare_Char_Literal_Memos;

      Row_Pos_17 :
            Token_Index
               := No_Token_Index;
      Token_Pos_24 :
            Token_Index
               := No_Token_Index;
      Token_Res_24 :
            Token_Index
               := No_Token_Index;
      Transform_Res_14 :
            Bare_Char_Literal
               := No_Bare_Ada_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Char_Literal_Transform_Parse_0_Memo, Pos);

begin

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res_14 := M.Instance;
      return Transform_Res_14;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res_14;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code


--  Start row_code

Row_Pos_17 := Pos;



--  Start tok_code

Token_Res_24 := Row_Pos_17;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_24));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Char)
   then
       Token_Pos_24 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_17 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_17,
             Expected_Token_Id => Ada_Char,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_24 := Row_Pos_17 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_24 /= No_Token_Index then

   Row_Pos_17 := Token_Pos_24;

else
   Row_Pos_17 := No_Token_Index;
   goto Exit_Row_7_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_7_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_17 /= No_Token_Index then

   Transform_Res_14 := Allocate_Char_Literal (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_14,
      Kind => Ada_Char_Literal,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_17 = Pos
                            then No_Token_Index
                            else Row_Pos_17 - 1));

      Initialize_Fields_For_Char_Literal
        (Self => Transform_Res_14);



end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Char_Literal_Transform_Parse_0_Memo,
      Row_Pos_17 /= No_Token_Index,
      Transform_Res_14,
      Pos,
      Row_Pos_17);


   Parser.Current_Pos := Row_Pos_17;

   return Transform_Res_14;
end Char_Literal_Transform_Parse_0;

   


function Direct_Name_Or_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Base_Id
is
   use Bare_Base_Id_Memos;

      Defer_Pos_28 :
            Token_Index
               := No_Token_Index;
      Defer_Res_28 :
            Bare_Identifier
               := No_Bare_Ada_Node;
      Defer_Pos_29 :
            Token_Index
               := No_Token_Index;
      Defer_Res_29 :
            Bare_String_Literal
               := No_Bare_Ada_Node;
      Defer_Pos_30 :
            Token_Index
               := No_Token_Index;
      Defer_Res_30 :
            Bare_Char_Literal
               := No_Bare_Ada_Node;
      Or_Pos_4 :
            Token_Index
               := No_Token_Index;
      Or_Res_4 :
            Bare_Base_Id
               := No_Bare_Ada_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Direct_Name_Or_Parse_0_Memo, Pos);

begin

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Or_Res_4 := M.Instance;
      return Or_Res_4;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Or_Res_4;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start or_code

Or_Pos_4 := No_Token_Index;
Or_Res_4 := No_Bare_Ada_Node;
    
Defer_Res_28 :=
   Identifier_Transform_Parse_0 (Parser, Pos);
Defer_Pos_28 := Parser.Current_Pos;

    if Defer_Pos_28 /= No_Token_Index then
        Or_Pos_4 := Defer_Pos_28;
        Or_Res_4 := Defer_Res_28;
        goto Exit_Or_3;
    end if;
    
Defer_Res_29 :=
   String_Literal_Transform_Parse_0 (Parser, Pos);
Defer_Pos_29 := Parser.Current_Pos;

    if Defer_Pos_29 /= No_Token_Index then
        Or_Pos_4 := Defer_Pos_29;
        Or_Res_4 := Defer_Res_29;
        goto Exit_Or_3;
    end if;
    
Defer_Res_30 :=
   Char_Literal_Transform_Parse_0 (Parser, Pos);
Defer_Pos_30 := Parser.Current_Pos;

    if Defer_Pos_30 /= No_Token_Index then
        Or_Pos_4 := Defer_Pos_30;
        Or_Res_4 := Defer_Res_30;
        goto Exit_Or_3;
    end if;
<<Exit_Or_3>>

--  End or_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Direct_Name_Or_Parse_0_Memo,
      Or_Pos_4 /= No_Token_Index,
      Or_Res_4,
      Pos,
      Or_Pos_4);


   Parser.Current_Pos := Or_Pos_4;

   return Or_Res_4;
end Direct_Name_Or_Parse_0;

   


function Subtype_Name_Or_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Name
is
   use Bare_Name_Memos;

      Row_Pos_12 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_22 :
            Token_Index
               := No_Token_Index;
      Defer_Res_22 :
            Bare_Name
               := No_Bare_Ada_Node;
      Token_Pos_18 :
            Token_Index
               := No_Token_Index;
      Token_Res_18 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_23 :
            Token_Index
               := No_Token_Index;
      Defer_Res_23 :
            Bare_Base_Id
               := No_Bare_Ada_Node;
      Transform_Res_10 :
            Bare_Dotted_Name
               := No_Bare_Ada_Node;
      Row_Pos_13 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_24 :
            Token_Index
               := No_Token_Index;
      Defer_Res_24 :
            Bare_Name
               := No_Bare_Ada_Node;
      Token_Pos_19 :
            Token_Index
               := No_Token_Index;
      Token_Res_19 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_25 :
            Token_Index
               := No_Token_Index;
      Defer_Res_25 :
            Bare_Identifier
               := No_Bare_Ada_Node;
      Row_Pos_14 :
            Token_Index
               := No_Token_Index;
      Token_Pos_20 :
            Token_Index
               := No_Token_Index;
      Token_Res_20 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_26 :
            Token_Index
               := No_Token_Index;
      Defer_Res_26 :
            Bare_Ada_Node
               := No_Bare_Ada_Node;
      Token_Pos_21 :
            Token_Index
               := No_Token_Index;
      Token_Res_21 :
            Token_Index
               := No_Token_Index;
      Transform_Res_11 :
            Bare_Attribute_Ref
               := No_Bare_Ada_Node;
      Defer_Pos_27 :
            Token_Index
               := No_Token_Index;
      Defer_Res_27 :
            Bare_Base_Id
               := No_Bare_Ada_Node;
      Or_Pos_3 :
            Token_Index
               := No_Token_Index;
      Or_Res_3 :
            Bare_Name
               := No_Bare_Ada_Node;

      Mem_Pos : Token_Index := Pos;
      Mem_Res : Bare_Name := No_Bare_Ada_Node;

   M : Memo_Entry := Get (Parser.Private_Part.Subtype_Name_Or_Parse_0_Memo, Pos);

begin

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Or_Res_3 := M.Instance;
      return Or_Res_3;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Or_Res_3;
   end if;

       Set (Parser.Private_Part.Subtype_Name_Or_Parse_0_Memo, False, Or_Res_3, Pos, Mem_Pos);

       <<Try_Again>>



   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start or_code

Or_Pos_3 := No_Token_Index;
Or_Res_3 := No_Bare_Ada_Node;
    
--  Start transform_code


--  Start row_code

Row_Pos_12 := Pos;



Defer_Res_22 :=
   Subtype_Name_Or_Parse_0 (Parser, Row_Pos_12);
Defer_Pos_22 := Parser.Current_Pos;



if Defer_Pos_22 /= No_Token_Index then

   Row_Pos_12 := Defer_Pos_22;

else
   Row_Pos_12 := No_Token_Index;
   goto Exit_Row_4_0;

end if;


--  Start tok_code

Token_Res_18 := Row_Pos_12;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_18));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Dot)
   then
       Token_Pos_18 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_12 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_12,
             Expected_Token_Id => Ada_Dot,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_18 := Row_Pos_12 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_18 /= No_Token_Index then

   Row_Pos_12 := Token_Pos_18;

else
   Row_Pos_12 := No_Token_Index;
   goto Exit_Row_4_0;

end if;


Defer_Res_23 :=
   Direct_Name_Or_Parse_0 (Parser, Row_Pos_12);
Defer_Pos_23 := Parser.Current_Pos;



if Defer_Pos_23 /= No_Token_Index then

   Row_Pos_12 := Defer_Pos_23;

else
   Row_Pos_12 := No_Token_Index;
   goto Exit_Row_4_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_4_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_12 /= No_Token_Index then

   Transform_Res_10 := Allocate_Dotted_Name (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_10,
      Kind => Ada_Dotted_Name,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_12 = Pos
                            then No_Token_Index
                            else Row_Pos_12 - 1));

      Initialize_Fields_For_Dotted_Name
        (Self => Transform_Res_10, Dotted_Name_F_Prefix => Defer_Res_22, Dotted_Name_F_Suffix => Defer_Res_23);

         if Defer_Res_22 /= null and then Is_Incomplete (Defer_Res_22) then
            Transform_Res_10.Last_Attempted_Child := 0;
         elsif Defer_Res_22 /= null and then not Is_Ghost (Defer_Res_22) then
            Transform_Res_10.Last_Attempted_Child := -1;
         end if;
         if Defer_Res_23 /= null and then Is_Incomplete (Defer_Res_23) then
            Transform_Res_10.Last_Attempted_Child := 0;
         elsif Defer_Res_23 /= null and then not Is_Ghost (Defer_Res_23) then
            Transform_Res_10.Last_Attempted_Child := -1;
         end if;


end if;

--  End transform_code

    if Row_Pos_12 /= No_Token_Index then
        Or_Pos_3 := Row_Pos_12;
        Or_Res_3 := Transform_Res_10;
        goto Exit_Or_2;
    end if;
    
--  Start transform_code


--  Start row_code

Row_Pos_13 := Pos;



Defer_Res_24 :=
   Subtype_Name_Or_Parse_0 (Parser, Row_Pos_13);
Defer_Pos_24 := Parser.Current_Pos;



if Defer_Pos_24 /= No_Token_Index then

   Row_Pos_13 := Defer_Pos_24;

else
   Row_Pos_13 := No_Token_Index;
   goto Exit_Row_8_0;

end if;


--  Start tok_code

Token_Res_19 := Row_Pos_13;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_19));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Tick)
   then
       Token_Pos_19 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_13 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_13,
             Expected_Token_Id => Ada_Tick,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_19 := Row_Pos_13 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_19 /= No_Token_Index then

   Row_Pos_13 := Token_Pos_19;

else
   Row_Pos_13 := No_Token_Index;
   goto Exit_Row_8_0;

end if;


Defer_Res_25 :=
   Identifier_Transform_Parse_0 (Parser, Row_Pos_13);
Defer_Pos_25 := Parser.Current_Pos;



if Defer_Pos_25 /= No_Token_Index then

   Row_Pos_13 := Defer_Pos_25;

else
   Row_Pos_13 := No_Token_Index;
   goto Exit_Row_8_0;

end if;


--  Start opt_code




--  Start row_code

Row_Pos_14 := Row_Pos_13;



--  Start tok_code

Token_Res_20 := Row_Pos_14;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_20));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Par_Open)
   then
       Token_Pos_20 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_14 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_14,
             Expected_Token_Id => Ada_Par_Open,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_20 := Row_Pos_14 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_20 /= No_Token_Index then

   Row_Pos_14 := Token_Pos_20;

else
   Row_Pos_14 := No_Token_Index;
   goto Exit_Row_9_0;

end if;


Defer_Res_26 :=
   Call_Suffix_Or_Parse_0 (Parser, Row_Pos_14);
Defer_Pos_26 := Parser.Current_Pos;



if Defer_Pos_26 /= No_Token_Index then

   Row_Pos_14 := Defer_Pos_26;

else
   Row_Pos_14 := No_Token_Index;
   goto Exit_Row_9_0;

end if;


--  Start tok_code

Token_Res_21 := Row_Pos_14;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_21));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Par_Close)
   then
       Token_Pos_21 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_14 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_14,
             Expected_Token_Id => Ada_Par_Close,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_21 := Row_Pos_14 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_21 /= No_Token_Index then

   Row_Pos_14 := Token_Pos_21;

else
   Row_Pos_14 := No_Token_Index;
   goto Exit_Row_9_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_9_0>>
pragma Warnings (On, "referenced");

--  End row_code


if Row_Pos_14 = No_Token_Index then

        Defer_Res_26 := No_Bare_Ada_Node;


    Row_Pos_14 := Row_Pos_13;


end if;

--  End opt_code



if Row_Pos_14 /= No_Token_Index then

   Row_Pos_13 := Row_Pos_14;

else
   Row_Pos_13 := No_Token_Index;
   goto Exit_Row_8_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_8_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_13 /= No_Token_Index then

   Transform_Res_11 := Allocate_Attribute_Ref (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_11,
      Kind => Ada_Attribute_Ref,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_13 = Pos
                            then No_Token_Index
                            else Row_Pos_13 - 1));

      Initialize_Fields_For_Attribute_Ref
        (Self => Transform_Res_11, Attribute_Ref_F_Prefix => Defer_Res_24, Attribute_Ref_F_Attribute => Defer_Res_25, Attribute_Ref_F_Args => Defer_Res_26);

         if Defer_Res_24 /= null and then Is_Incomplete (Defer_Res_24) then
            Transform_Res_11.Last_Attempted_Child := 0;
         elsif Defer_Res_24 /= null and then not Is_Ghost (Defer_Res_24) then
            Transform_Res_11.Last_Attempted_Child := -1;
         end if;
         if Defer_Res_25 /= null and then Is_Incomplete (Defer_Res_25) then
            Transform_Res_11.Last_Attempted_Child := 0;
         elsif Defer_Res_25 /= null and then not Is_Ghost (Defer_Res_25) then
            Transform_Res_11.Last_Attempted_Child := -1;
         end if;
         if Defer_Res_26 /= null and then Is_Incomplete (Defer_Res_26) then
            Transform_Res_11.Last_Attempted_Child := 0;
         elsif Defer_Res_26 /= null and then not Is_Ghost (Defer_Res_26) then
            Transform_Res_11.Last_Attempted_Child := -1;
         end if;


end if;

--  End transform_code

    if Row_Pos_13 /= No_Token_Index then
        Or_Pos_3 := Row_Pos_13;
        Or_Res_3 := Transform_Res_11;
        goto Exit_Or_2;
    end if;
    
Defer_Res_27 :=
   Direct_Name_Or_Parse_0 (Parser, Pos);
Defer_Pos_27 := Parser.Current_Pos;

    if Defer_Pos_27 /= No_Token_Index then
        Or_Pos_3 := Defer_Pos_27;
        Or_Res_3 := Defer_Res_27;
        goto Exit_Or_2;
    end if;
<<Exit_Or_2>>

--  End or_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------

      if Or_Pos_3 > Mem_Pos then
         Mem_Pos := Or_Pos_3;
         Mem_Res := Or_Res_3;
         Set
           (Parser.Private_Part.Subtype_Name_Or_Parse_0_Memo,
            Or_Pos_3 /= No_Token_Index,
            Or_Res_3,
            Pos,
            Or_Pos_3);
         goto Try_Again;

      elsif Mem_Pos > Pos then
         Or_Res_3 := Mem_Res;
         Or_Pos_3 := Mem_Pos;
         goto No_Memo;
      end if;

   Set
     (Parser.Private_Part.Subtype_Name_Or_Parse_0_Memo,
      Or_Pos_3 /= No_Token_Index,
      Or_Res_3,
      Pos,
      Or_Pos_3);

       <<No_Memo>>

   Parser.Current_Pos := Or_Pos_3;

   return Or_Res_3;
end Subtype_Name_Or_Parse_0;

   


function Dec_Literal_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Real_Literal
is
   use Bare_Real_Literal_Memos;

      Row_Pos_36 :
            Token_Index
               := No_Token_Index;
      Token_Pos_37 :
            Token_Index
               := No_Token_Index;
      Token_Res_37 :
            Token_Index
               := No_Token_Index;
      Transform_Res_33 :
            Bare_Real_Literal
               := No_Bare_Ada_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Dec_Literal_Transform_Parse_0_Memo, Pos);

begin

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res_33 := M.Instance;
      return Transform_Res_33;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res_33;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code


--  Start row_code

Row_Pos_36 := Pos;



--  Start tok_code

Token_Res_37 := Row_Pos_36;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_37));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Decimal)
   then
       Token_Pos_37 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_36 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_36,
             Expected_Token_Id => Ada_Decimal,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_37 := Row_Pos_36 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_37 /= No_Token_Index then

   Row_Pos_36 := Token_Pos_37;

else
   Row_Pos_36 := No_Token_Index;
   goto Exit_Row_25_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_25_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_36 /= No_Token_Index then

   Transform_Res_33 := Allocate_Real_Literal (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_33,
      Kind => Ada_Real_Literal,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_36 = Pos
                            then No_Token_Index
                            else Row_Pos_36 - 1));

      Initialize_Fields_For_Real_Literal
        (Self => Transform_Res_33);



end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Dec_Literal_Transform_Parse_0_Memo,
      Row_Pos_36 /= No_Token_Index,
      Transform_Res_33,
      Pos,
      Row_Pos_36);


   Parser.Current_Pos := Row_Pos_36;

   return Transform_Res_33;
end Dec_Literal_Transform_Parse_0;

   


function Int_Literal_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Int_Literal
is
   use Bare_Int_Literal_Memos;

      Row_Pos_37 :
            Token_Index
               := No_Token_Index;
      Token_Pos_38 :
            Token_Index
               := No_Token_Index;
      Token_Res_38 :
            Token_Index
               := No_Token_Index;
      Transform_Res_34 :
            Bare_Int_Literal
               := No_Bare_Ada_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Int_Literal_Transform_Parse_0_Memo, Pos);

begin

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res_34 := M.Instance;
      return Transform_Res_34;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res_34;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code


--  Start row_code

Row_Pos_37 := Pos;



--  Start tok_code

Token_Res_38 := Row_Pos_37;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_38));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Integer)
   then
       Token_Pos_38 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_37 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_37,
             Expected_Token_Id => Ada_Integer,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_38 := Row_Pos_37 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_38 /= No_Token_Index then

   Row_Pos_37 := Token_Pos_38;

else
   Row_Pos_37 := No_Token_Index;
   goto Exit_Row_26_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_26_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_37 /= No_Token_Index then

   Transform_Res_34 := Allocate_Int_Literal (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_34,
      Kind => Ada_Int_Literal,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_37 = Pos
                            then No_Token_Index
                            else Row_Pos_37 - 1));

      Initialize_Fields_For_Int_Literal
        (Self => Transform_Res_34);



end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Int_Literal_Transform_Parse_0_Memo,
      Row_Pos_37 /= No_Token_Index,
      Transform_Res_34,
      Pos,
      Row_Pos_37);


   Parser.Current_Pos := Row_Pos_37;

   return Transform_Res_34;
end Int_Literal_Transform_Parse_0;

   


function Num_Literal_Or_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Num_Literal
is
   use Bare_Num_Literal_Memos;

      Defer_Pos_55 :
            Token_Index
               := No_Token_Index;
      Defer_Res_55 :
            Bare_Real_Literal
               := No_Bare_Ada_Node;
      Defer_Pos_56 :
            Token_Index
               := No_Token_Index;
      Defer_Res_56 :
            Bare_Int_Literal
               := No_Bare_Ada_Node;
      Or_Pos_14 :
            Token_Index
               := No_Token_Index;
      Or_Res_14 :
            Bare_Num_Literal
               := No_Bare_Ada_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Num_Literal_Or_Parse_0_Memo, Pos);

begin

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Or_Res_14 := M.Instance;
      return Or_Res_14;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Or_Res_14;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start or_code

Or_Pos_14 := No_Token_Index;
Or_Res_14 := No_Bare_Ada_Node;
    
Defer_Res_55 :=
   Dec_Literal_Transform_Parse_0 (Parser, Pos);
Defer_Pos_55 := Parser.Current_Pos;

    if Defer_Pos_55 /= No_Token_Index then
        Or_Pos_14 := Defer_Pos_55;
        Or_Res_14 := Defer_Res_55;
        goto Exit_Or_13;
    end if;
    
Defer_Res_56 :=
   Int_Literal_Transform_Parse_0 (Parser, Pos);
Defer_Pos_56 := Parser.Current_Pos;

    if Defer_Pos_56 /= No_Token_Index then
        Or_Pos_14 := Defer_Pos_56;
        Or_Res_14 := Defer_Res_56;
        goto Exit_Or_13;
    end if;
<<Exit_Or_13>>

--  End or_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Num_Literal_Or_Parse_0_Memo,
      Or_Pos_14 /= No_Token_Index,
      Or_Res_14,
      Pos,
      Or_Pos_14);


   Parser.Current_Pos := Or_Pos_14;

   return Or_Res_14;
end Num_Literal_Or_Parse_0;

   


function Null_Literal_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Null_Literal
is
   use Bare_Null_Literal_Memos;

      Row_Pos_38 :
            Token_Index
               := No_Token_Index;
      Token_Pos_39 :
            Token_Index
               := No_Token_Index;
      Token_Res_39 :
            Token_Index
               := No_Token_Index;
      Transform_Res_35 :
            Bare_Null_Literal
               := No_Bare_Ada_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Null_Literal_Transform_Parse_0_Memo, Pos);

begin

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res_35 := M.Instance;
      return Transform_Res_35;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res_35;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code


--  Start row_code

Row_Pos_38 := Pos;



--  Start tok_code

Token_Res_39 := Row_Pos_38;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_39));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Null)
   then
       Token_Pos_39 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_38 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_38,
             Expected_Token_Id => Ada_Null,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_39 := Row_Pos_38 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_39 /= No_Token_Index then

   Row_Pos_38 := Token_Pos_39;

else
   Row_Pos_38 := No_Token_Index;
   goto Exit_Row_27_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_27_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_38 /= No_Token_Index then

   Transform_Res_35 := Allocate_Null_Literal (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_35,
      Kind => Ada_Null_Literal,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_38 = Pos
                            then No_Token_Index
                            else Row_Pos_38 - 1));

      Initialize_Fields_For_Null_Literal
        (Self => Transform_Res_35);



end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Null_Literal_Transform_Parse_0_Memo,
      Row_Pos_38 /= No_Token_Index,
      Transform_Res_35,
      Pos,
      Row_Pos_38);


   Parser.Current_Pos := Row_Pos_38;

   return Transform_Res_35;
end Null_Literal_Transform_Parse_0;

   


function Qual_Name_Internal_Or_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Name
is
   use Bare_Name_Memos;

      Row_Pos_42 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_63 :
            Token_Index
               := No_Token_Index;
      Defer_Res_63 :
            Bare_Name
               := No_Bare_Ada_Node;
      Token_Pos_44 :
            Token_Index
               := No_Token_Index;
      Token_Res_44 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_64 :
            Token_Index
               := No_Token_Index;
      Defer_Res_64 :
            Bare_Base_Id
               := No_Bare_Ada_Node;
      Transform_Res_38 :
            Bare_Dotted_Name
               := No_Bare_Ada_Node;
      Row_Pos_43 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_65 :
            Token_Index
               := No_Token_Index;
      Defer_Res_65 :
            Bare_Name
               := No_Bare_Ada_Node;
      Token_Pos_45 :
            Token_Index
               := No_Token_Index;
      Token_Res_45 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_66 :
            Token_Index
               := No_Token_Index;
      Defer_Res_66 :
            Bare_Identifier
               := No_Bare_Ada_Node;
      Null_Res_1 :
            Bare_Ada_Node
               := No_Bare_Ada_Node;
      Transform_Res_39 :
            Bare_Attribute_Ref
               := No_Bare_Ada_Node;
      Defer_Pos_67 :
            Token_Index
               := No_Token_Index;
      Defer_Res_67 :
            Bare_Base_Id
               := No_Bare_Ada_Node;
      Or_Pos_17 :
            Token_Index
               := No_Token_Index;
      Or_Res_17 :
            Bare_Name
               := No_Bare_Ada_Node;

      Mem_Pos : Token_Index := Pos;
      Mem_Res : Bare_Name := No_Bare_Ada_Node;

   M : Memo_Entry := Get (Parser.Private_Part.Qual_Name_Internal_Or_Parse_0_Memo, Pos);

begin

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Or_Res_17 := M.Instance;
      return Or_Res_17;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Or_Res_17;
   end if;

       Set (Parser.Private_Part.Qual_Name_Internal_Or_Parse_0_Memo, False, Or_Res_17, Pos, Mem_Pos);

       <<Try_Again>>



   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start or_code

Or_Pos_17 := No_Token_Index;
Or_Res_17 := No_Bare_Ada_Node;
    
--  Start transform_code


--  Start row_code

Row_Pos_42 := Pos;



Defer_Res_63 :=
   Qual_Name_Internal_Or_Parse_0 (Parser, Row_Pos_42);
Defer_Pos_63 := Parser.Current_Pos;



if Defer_Pos_63 /= No_Token_Index then

   Row_Pos_42 := Defer_Pos_63;

else
   Row_Pos_42 := No_Token_Index;
   goto Exit_Row_31_0;

end if;


--  Start tok_code

Token_Res_44 := Row_Pos_42;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_44));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Dot)
   then
       Token_Pos_44 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_42 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_42,
             Expected_Token_Id => Ada_Dot,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_44 := Row_Pos_42 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_44 /= No_Token_Index then

   Row_Pos_42 := Token_Pos_44;

else
   Row_Pos_42 := No_Token_Index;
   goto Exit_Row_31_0;

end if;


Defer_Res_64 :=
   Direct_Name_Or_Parse_0 (Parser, Row_Pos_42);
Defer_Pos_64 := Parser.Current_Pos;



if Defer_Pos_64 /= No_Token_Index then

   Row_Pos_42 := Defer_Pos_64;

else
   Row_Pos_42 := No_Token_Index;
   goto Exit_Row_31_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_31_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_42 /= No_Token_Index then

   Transform_Res_38 := Allocate_Dotted_Name (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_38,
      Kind => Ada_Dotted_Name,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_42 = Pos
                            then No_Token_Index
                            else Row_Pos_42 - 1));

      Initialize_Fields_For_Dotted_Name
        (Self => Transform_Res_38, Dotted_Name_F_Prefix => Defer_Res_63, Dotted_Name_F_Suffix => Defer_Res_64);

         if Defer_Res_63 /= null and then Is_Incomplete (Defer_Res_63) then
            Transform_Res_38.Last_Attempted_Child := 0;
         elsif Defer_Res_63 /= null and then not Is_Ghost (Defer_Res_63) then
            Transform_Res_38.Last_Attempted_Child := -1;
         end if;
         if Defer_Res_64 /= null and then Is_Incomplete (Defer_Res_64) then
            Transform_Res_38.Last_Attempted_Child := 0;
         elsif Defer_Res_64 /= null and then not Is_Ghost (Defer_Res_64) then
            Transform_Res_38.Last_Attempted_Child := -1;
         end if;


end if;

--  End transform_code

    if Row_Pos_42 /= No_Token_Index then
        Or_Pos_17 := Row_Pos_42;
        Or_Res_17 := Transform_Res_38;
        goto Exit_Or_15;
    end if;
    
--  Start transform_code


--  Start row_code

Row_Pos_43 := Pos;



Defer_Res_65 :=
   Qual_Name_Internal_Or_Parse_0 (Parser, Row_Pos_43);
Defer_Pos_65 := Parser.Current_Pos;



if Defer_Pos_65 /= No_Token_Index then

   Row_Pos_43 := Defer_Pos_65;

else
   Row_Pos_43 := No_Token_Index;
   goto Exit_Row_32_0;

end if;


--  Start tok_code

Token_Res_45 := Row_Pos_43;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_45));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Tick)
   then
       Token_Pos_45 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_43 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_43,
             Expected_Token_Id => Ada_Tick,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_45 := Row_Pos_43 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_45 /= No_Token_Index then

   Row_Pos_43 := Token_Pos_45;

else
   Row_Pos_43 := No_Token_Index;
   goto Exit_Row_32_0;

end if;


Defer_Res_66 :=
   Identifier_Transform_Parse_0 (Parser, Row_Pos_43);
Defer_Pos_66 := Parser.Current_Pos;



if Defer_Pos_66 /= No_Token_Index then

   Row_Pos_43 := Defer_Pos_66;

else
   Row_Pos_43 := No_Token_Index;
   goto Exit_Row_32_0;

end if;


   Null_Res_1 := No_Bare_Ada_Node;



if Row_Pos_43 /= No_Token_Index then

   Row_Pos_43 := Row_Pos_43;

else
   Row_Pos_43 := No_Token_Index;
   goto Exit_Row_32_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_32_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_43 /= No_Token_Index then

   Transform_Res_39 := Allocate_Attribute_Ref (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_39,
      Kind => Ada_Attribute_Ref,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_43 = Pos
                            then No_Token_Index
                            else Row_Pos_43 - 1));

      Initialize_Fields_For_Attribute_Ref
        (Self => Transform_Res_39, Attribute_Ref_F_Prefix => Defer_Res_65, Attribute_Ref_F_Attribute => Defer_Res_66, Attribute_Ref_F_Args => Null_Res_1);

         if Defer_Res_65 /= null and then Is_Incomplete (Defer_Res_65) then
            Transform_Res_39.Last_Attempted_Child := 0;
         elsif Defer_Res_65 /= null and then not Is_Ghost (Defer_Res_65) then
            Transform_Res_39.Last_Attempted_Child := -1;
         end if;
         if Defer_Res_66 /= null and then Is_Incomplete (Defer_Res_66) then
            Transform_Res_39.Last_Attempted_Child := 0;
         elsif Defer_Res_66 /= null and then not Is_Ghost (Defer_Res_66) then
            Transform_Res_39.Last_Attempted_Child := -1;
         end if;
         if Null_Res_1 /= null and then Is_Incomplete (Null_Res_1) then
            Transform_Res_39.Last_Attempted_Child := 0;
         elsif Null_Res_1 /= null and then not Is_Ghost (Null_Res_1) then
            Transform_Res_39.Last_Attempted_Child := -1;
         end if;


end if;

--  End transform_code

    if Row_Pos_43 /= No_Token_Index then
        Or_Pos_17 := Row_Pos_43;
        Or_Res_17 := Transform_Res_39;
        goto Exit_Or_15;
    end if;
    
Defer_Res_67 :=
   Direct_Name_Or_Parse_0 (Parser, Pos);
Defer_Pos_67 := Parser.Current_Pos;

    if Defer_Pos_67 /= No_Token_Index then
        Or_Pos_17 := Defer_Pos_67;
        Or_Res_17 := Defer_Res_67;
        goto Exit_Or_15;
    end if;
<<Exit_Or_15>>

--  End or_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------

      if Or_Pos_17 > Mem_Pos then
         Mem_Pos := Or_Pos_17;
         Mem_Res := Or_Res_17;
         Set
           (Parser.Private_Part.Qual_Name_Internal_Or_Parse_0_Memo,
            Or_Pos_17 /= No_Token_Index,
            Or_Res_17,
            Pos,
            Or_Pos_17);
         goto Try_Again;

      elsif Mem_Pos > Pos then
         Or_Res_17 := Mem_Res;
         Or_Pos_17 := Mem_Pos;
         goto No_Memo;
      end if;

   Set
     (Parser.Private_Part.Qual_Name_Internal_Or_Parse_0_Memo,
      Or_Pos_17 /= No_Token_Index,
      Or_Res_17,
      Pos,
      Or_Pos_17);

       <<No_Memo>>

   Parser.Current_Pos := Or_Pos_17;

   return Or_Res_17;
end Qual_Name_Internal_Or_Parse_0;

   


function Boolean_Op_Or_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Op
is
   use Bare_Op_Memos;

      Row_Pos_46 :
            Token_Index
               := No_Token_Index;
      Token_Pos_48 :
            Token_Index
               := No_Token_Index;
      Token_Res_48 :
            Token_Index
               := No_Token_Index;
      Transform_Res_42 :
            Bare_Op_Xor
               := No_Bare_Ada_Node;
      Row_Pos_47 :
            Token_Index
               := No_Token_Index;
      Token_Pos_49 :
            Token_Index
               := No_Token_Index;
      Token_Res_49 :
            Token_Index
               := No_Token_Index;
      Token_Pos_50 :
            Token_Index
               := No_Token_Index;
      Token_Res_50 :
            Token_Index
               := No_Token_Index;
      Transform_Res_43 :
            Bare_Op_And_Then
               := No_Bare_Ada_Node;
      Row_Pos_48 :
            Token_Index
               := No_Token_Index;
      Token_Pos_51 :
            Token_Index
               := No_Token_Index;
      Token_Res_51 :
            Token_Index
               := No_Token_Index;
      Transform_Res_44 :
            Bare_Op_And
               := No_Bare_Ada_Node;
      Row_Pos_49 :
            Token_Index
               := No_Token_Index;
      Token_Pos_52 :
            Token_Index
               := No_Token_Index;
      Token_Res_52 :
            Token_Index
               := No_Token_Index;
      Token_Pos_53 :
            Token_Index
               := No_Token_Index;
      Token_Res_53 :
            Token_Index
               := No_Token_Index;
      Transform_Res_45 :
            Bare_Op_Or_Else
               := No_Bare_Ada_Node;
      Row_Pos_50 :
            Token_Index
               := No_Token_Index;
      Token_Pos_54 :
            Token_Index
               := No_Token_Index;
      Token_Res_54 :
            Token_Index
               := No_Token_Index;
      Transform_Res_46 :
            Bare_Op_Or
               := No_Bare_Ada_Node;
      Or_Pos_19 :
            Token_Index
               := No_Token_Index;
      Or_Res_19 :
            Bare_Op
               := No_Bare_Ada_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Boolean_Op_Or_Parse_0_Memo, Pos);

begin

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Or_Res_19 := M.Instance;
      return Or_Res_19;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Or_Res_19;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start or_code

Or_Pos_19 := No_Token_Index;
Or_Res_19 := No_Bare_Ada_Node;
    
--  Start transform_code


--  Start row_code

Row_Pos_46 := Pos;



--  Start tok_code

Token_Res_48 := Row_Pos_46;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_48));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Xor)
   then
       Token_Pos_48 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_46 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_46,
             Expected_Token_Id => Ada_Xor,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_48 := Row_Pos_46 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_48 /= No_Token_Index then

   Row_Pos_46 := Token_Pos_48;

else
   Row_Pos_46 := No_Token_Index;
   goto Exit_Row_35_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_35_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_46 /= No_Token_Index then

   Transform_Res_42 := Allocate_Op_Xor (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_42,
      Kind => Ada_Op_Xor,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_46 = Pos
                            then No_Token_Index
                            else Row_Pos_46 - 1));

      Initialize_Fields_For_Op_Xor
        (Self => Transform_Res_42);



end if;

--  End transform_code

    if Row_Pos_46 /= No_Token_Index then
        Or_Pos_19 := Row_Pos_46;
        Or_Res_19 := Transform_Res_42;
        goto Exit_Or_18;
    end if;
    
--  Start transform_code


--  Start row_code

Row_Pos_47 := Pos;



--  Start tok_code

Token_Res_49 := Row_Pos_47;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_49));
begin
   if
      T.Kind /= From_Token_Kind (Ada_And)
   then
       Token_Pos_49 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_47 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_47,
             Expected_Token_Id => Ada_And,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_49 := Row_Pos_47 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_49 /= No_Token_Index then

   Row_Pos_47 := Token_Pos_49;

else
   Row_Pos_47 := No_Token_Index;
   goto Exit_Row_36_0;

end if;


--  Start tok_code

Token_Res_50 := Row_Pos_47;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_50));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Then)
   then
       Token_Pos_50 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_47 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_47,
             Expected_Token_Id => Ada_Then,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_50 := Row_Pos_47 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_50 /= No_Token_Index then

   Row_Pos_47 := Token_Pos_50;

else
   Row_Pos_47 := No_Token_Index;
   goto Exit_Row_36_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_36_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_47 /= No_Token_Index then

   Transform_Res_43 := Allocate_Op_And_Then (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_43,
      Kind => Ada_Op_And_Then,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_47 = Pos
                            then No_Token_Index
                            else Row_Pos_47 - 1));

      Initialize_Fields_For_Op_And_Then
        (Self => Transform_Res_43);



end if;

--  End transform_code

    if Row_Pos_47 /= No_Token_Index then
        Or_Pos_19 := Row_Pos_47;
        Or_Res_19 := Transform_Res_43;
        goto Exit_Or_18;
    end if;
    
--  Start transform_code


--  Start row_code

Row_Pos_48 := Pos;



--  Start tok_code

Token_Res_51 := Row_Pos_48;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_51));
begin
   if
      T.Kind /= From_Token_Kind (Ada_And)
   then
       Token_Pos_51 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_48 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_48,
             Expected_Token_Id => Ada_And,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_51 := Row_Pos_48 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_51 /= No_Token_Index then

   Row_Pos_48 := Token_Pos_51;

else
   Row_Pos_48 := No_Token_Index;
   goto Exit_Row_37_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_37_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_48 /= No_Token_Index then

   Transform_Res_44 := Allocate_Op_And (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_44,
      Kind => Ada_Op_And,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_48 = Pos
                            then No_Token_Index
                            else Row_Pos_48 - 1));

      Initialize_Fields_For_Op_And
        (Self => Transform_Res_44);



end if;

--  End transform_code

    if Row_Pos_48 /= No_Token_Index then
        Or_Pos_19 := Row_Pos_48;
        Or_Res_19 := Transform_Res_44;
        goto Exit_Or_18;
    end if;
    
--  Start transform_code


--  Start row_code

Row_Pos_49 := Pos;



--  Start tok_code

Token_Res_52 := Row_Pos_49;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_52));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Or)
   then
       Token_Pos_52 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_49 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_49,
             Expected_Token_Id => Ada_Or,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_52 := Row_Pos_49 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_52 /= No_Token_Index then

   Row_Pos_49 := Token_Pos_52;

else
   Row_Pos_49 := No_Token_Index;
   goto Exit_Row_38_0;

end if;


--  Start tok_code

Token_Res_53 := Row_Pos_49;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_53));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Else)
   then
       Token_Pos_53 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_49 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_49,
             Expected_Token_Id => Ada_Else,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_53 := Row_Pos_49 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_53 /= No_Token_Index then

   Row_Pos_49 := Token_Pos_53;

else
   Row_Pos_49 := No_Token_Index;
   goto Exit_Row_38_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_38_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_49 /= No_Token_Index then

   Transform_Res_45 := Allocate_Op_Or_Else (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_45,
      Kind => Ada_Op_Or_Else,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_49 = Pos
                            then No_Token_Index
                            else Row_Pos_49 - 1));

      Initialize_Fields_For_Op_Or_Else
        (Self => Transform_Res_45);



end if;

--  End transform_code

    if Row_Pos_49 /= No_Token_Index then
        Or_Pos_19 := Row_Pos_49;
        Or_Res_19 := Transform_Res_45;
        goto Exit_Or_18;
    end if;
    
--  Start transform_code


--  Start row_code

Row_Pos_50 := Pos;



--  Start tok_code

Token_Res_54 := Row_Pos_50;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_54));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Or)
   then
       Token_Pos_54 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_50 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_50,
             Expected_Token_Id => Ada_Or,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_54 := Row_Pos_50 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_54 /= No_Token_Index then

   Row_Pos_50 := Token_Pos_54;

else
   Row_Pos_50 := No_Token_Index;
   goto Exit_Row_39_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_39_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_50 /= No_Token_Index then

   Transform_Res_46 := Allocate_Op_Or (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_46,
      Kind => Ada_Op_Or,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_50 = Pos
                            then No_Token_Index
                            else Row_Pos_50 - 1));

      Initialize_Fields_For_Op_Or
        (Self => Transform_Res_46);



end if;

--  End transform_code

    if Row_Pos_50 /= No_Token_Index then
        Or_Pos_19 := Row_Pos_50;
        Or_Res_19 := Transform_Res_46;
        goto Exit_Or_18;
    end if;
<<Exit_Or_18>>

--  End or_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Boolean_Op_Or_Parse_0_Memo,
      Or_Pos_19 /= No_Token_Index,
      Or_Res_19,
      Pos,
      Or_Pos_19);


   Parser.Current_Pos := Or_Pos_19;

   return Or_Res_19;
end Boolean_Op_Or_Parse_0;

   


function Rel_Op_Or_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Op
is
   use Bare_Op_Memos;

      Row_Pos_59 :
            Token_Index
               := No_Token_Index;
      Token_Pos_61 :
            Token_Index
               := No_Token_Index;
      Token_Res_61 :
            Token_Index
               := No_Token_Index;
      Token_Pos_62 :
            Token_Index
               := No_Token_Index;
      Token_Res_62 :
            Token_Index
               := No_Token_Index;
      Transform_Res_55 :
            Bare_Op_Not_In
               := No_Bare_Ada_Node;
      Row_Pos_60 :
            Token_Index
               := No_Token_Index;
      Token_Pos_63 :
            Token_Index
               := No_Token_Index;
      Token_Res_63 :
            Token_Index
               := No_Token_Index;
      Transform_Res_56 :
            Bare_Op_In
               := No_Bare_Ada_Node;
      Or_Pos_22 :
            Token_Index
               := No_Token_Index;
      Or_Res_22 :
            Bare_Op
               := No_Bare_Ada_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Rel_Op_Or_Parse_0_Memo, Pos);

begin

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Or_Res_22 := M.Instance;
      return Or_Res_22;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Or_Res_22;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start or_code

Or_Pos_22 := No_Token_Index;
Or_Res_22 := No_Bare_Ada_Node;
    
--  Start transform_code


--  Start row_code

Row_Pos_59 := Pos;



--  Start tok_code

Token_Res_61 := Row_Pos_59;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_61));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Not)
   then
       Token_Pos_61 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_59 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_59,
             Expected_Token_Id => Ada_Not,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_61 := Row_Pos_59 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_61 /= No_Token_Index then

   Row_Pos_59 := Token_Pos_61;

else
   Row_Pos_59 := No_Token_Index;
   goto Exit_Row_48_0;

end if;


--  Start tok_code

Token_Res_62 := Row_Pos_59;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_62));
begin
   if
      T.Kind /= From_Token_Kind (Ada_In)
   then
       Token_Pos_62 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_59 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_59,
             Expected_Token_Id => Ada_In,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_62 := Row_Pos_59 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_62 /= No_Token_Index then

   Row_Pos_59 := Token_Pos_62;

else
   Row_Pos_59 := No_Token_Index;
   goto Exit_Row_48_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_48_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_59 /= No_Token_Index then

   Transform_Res_55 := Allocate_Op_Not_In (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_55,
      Kind => Ada_Op_Not_In,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_59 = Pos
                            then No_Token_Index
                            else Row_Pos_59 - 1));

      Initialize_Fields_For_Op_Not_In
        (Self => Transform_Res_55);



end if;

--  End transform_code

    if Row_Pos_59 /= No_Token_Index then
        Or_Pos_22 := Row_Pos_59;
        Or_Res_22 := Transform_Res_55;
        goto Exit_Or_21;
    end if;
    
--  Start transform_code


--  Start row_code

Row_Pos_60 := Pos;



--  Start tok_code

Token_Res_63 := Row_Pos_60;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_63));
begin
   if
      T.Kind /= From_Token_Kind (Ada_In)
   then
       Token_Pos_63 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_60 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_60,
             Expected_Token_Id => Ada_In,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_63 := Row_Pos_60 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_63 /= No_Token_Index then

   Row_Pos_60 := Token_Pos_63;

else
   Row_Pos_60 := No_Token_Index;
   goto Exit_Row_49_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_49_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_60 /= No_Token_Index then

   Transform_Res_56 := Allocate_Op_In (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_56,
      Kind => Ada_Op_In,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_60 = Pos
                            then No_Token_Index
                            else Row_Pos_60 - 1));

      Initialize_Fields_For_Op_In
        (Self => Transform_Res_56);



end if;

--  End transform_code

    if Row_Pos_60 /= No_Token_Index then
        Or_Pos_22 := Row_Pos_60;
        Or_Res_22 := Transform_Res_56;
        goto Exit_Or_21;
    end if;
<<Exit_Or_21>>

--  End or_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Rel_Op_Or_Parse_0_Memo,
      Or_Pos_22 /= No_Token_Index,
      Or_Res_22,
      Pos,
      Or_Pos_22);


   Parser.Current_Pos := Or_Pos_22;

   return Or_Res_22;
end Rel_Op_Or_Parse_0;

   


function Membership_Choice_Or_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr
is
   use Bare_Expr_Memos;

      Defer_Pos_80 :
            Token_Index
               := No_Token_Index;
      Defer_Res_80 :
            Bare_Expr
               := No_Bare_Ada_Node;
      Row_Pos_61 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_81 :
            Token_Index
               := No_Token_Index;
      Defer_Res_81 :
            Bare_Discrete_Subtype_Indication
               := No_Bare_Ada_Node;
      Transform_Res_57 :
            Bare_Discrete_Subtype_Name
               := No_Bare_Ada_Node;
      Defer_Pos_82 :
            Token_Index
               := No_Token_Index;
      Defer_Res_82 :
            Bare_Expr
               := No_Bare_Ada_Node;
      Or_Pos_23 :
            Token_Index
               := No_Token_Index;
      Or_Res_23 :
            Bare_Expr
               := No_Bare_Ada_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Membership_Choice_Or_Parse_0_Memo, Pos);

begin

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Or_Res_23 := M.Instance;
      return Or_Res_23;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Or_Res_23;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start or_code

Or_Pos_23 := No_Token_Index;
Or_Res_23 := No_Bare_Ada_Node;
    
Defer_Res_80 :=
   Discrete_Range_Or_Parse_0 (Parser, Pos);
Defer_Pos_80 := Parser.Current_Pos;

    if Defer_Pos_80 /= No_Token_Index then
        Or_Pos_23 := Defer_Pos_80;
        Or_Res_23 := Defer_Res_80;
        goto Exit_Or_22;
    end if;
    
--  Start transform_code


--  Start row_code

Row_Pos_61 := Pos;



Defer_Res_81 :=
   Discrete_Subtype_Indication_Transform_Parse_0 (Parser, Row_Pos_61);
Defer_Pos_81 := Parser.Current_Pos;



if Defer_Pos_81 /= No_Token_Index then

   Row_Pos_61 := Defer_Pos_81;

else
   Row_Pos_61 := No_Token_Index;
   goto Exit_Row_50_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_50_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_61 /= No_Token_Index then

   Transform_Res_57 := Allocate_Discrete_Subtype_Name (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_57,
      Kind => Ada_Discrete_Subtype_Name,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_61 = Pos
                            then No_Token_Index
                            else Row_Pos_61 - 1));

      Initialize_Fields_For_Discrete_Subtype_Name
        (Self => Transform_Res_57, Discrete_Subtype_Name_F_Subtype => Defer_Res_81);

         if Defer_Res_81 /= null and then Is_Incomplete (Defer_Res_81) then
            Transform_Res_57.Last_Attempted_Child := 0;
         elsif Defer_Res_81 /= null and then not Is_Ghost (Defer_Res_81) then
            Transform_Res_57.Last_Attempted_Child := -1;
         end if;


end if;

--  End transform_code

    if Row_Pos_61 /= No_Token_Index then
        Or_Pos_23 := Row_Pos_61;
        Or_Res_23 := Transform_Res_57;
        goto Exit_Or_22;
    end if;
    
Defer_Res_82 :=
   Simple_Expr_Or_Parse_1 (Parser, Pos);
Defer_Pos_82 := Parser.Current_Pos;

    if Defer_Pos_82 /= No_Token_Index then
        Or_Pos_23 := Defer_Pos_82;
        Or_Res_23 := Defer_Res_82;
        goto Exit_Or_22;
    end if;
<<Exit_Or_22>>

--  End or_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Membership_Choice_Or_Parse_0_Memo,
      Or_Pos_23 /= No_Token_Index,
      Or_Res_23,
      Pos,
      Or_Pos_23);


   Parser.Current_Pos := Or_Pos_23;

   return Or_Res_23;
end Membership_Choice_Or_Parse_0;

   


function Membership_Choice_List_List_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr_Alternatives_List
is
   use Bare_Expr_Alternatives_List_Memos;

      Lst_Cpos_2 :
            Token_Index
               := No_Token_Index;
      Tmp_List_2 :
            Free_Parse_List;
      Defer_Pos_79 :
            Token_Index
               := No_Token_Index;
      Defer_Res_79 :
            Bare_Expr
               := No_Bare_Ada_Node;
      Token_Pos_64 :
            Token_Index
               := No_Token_Index;
      Token_Res_64 :
            Token_Index
               := No_Token_Index;
      List_Pos_2 :
            Token_Index
               := No_Token_Index;
      List_Res_2 :
            Bare_Expr_Alternatives_List
               := No_Bare_Ada_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Membership_Choice_List_List_Parse_0_Memo, Pos);

begin

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      List_Res_2 := M.Instance;
      return List_Res_2;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return List_Res_2;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start list_code

    List_Pos_2 := No_Token_Index;



Lst_Cpos_2 := Pos;
Tmp_List_2 := Get_Parse_List (Parser);

loop
   
Defer_Res_79 :=
   Membership_Choice_Or_Parse_0 (Parser, Lst_Cpos_2);
Defer_Pos_79 := Parser.Current_Pos;


   exit when Defer_Pos_79 = No_Token_Index;

   List_Pos_2 := Defer_Pos_79;
   Lst_Cpos_2 := List_Pos_2;

   Tmp_List_2.Nodes.Append (Defer_Res_79);

      
--  Start tok_code

Token_Res_64 := Lst_Cpos_2;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_64));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Pipe)
   then
       Token_Pos_64 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Lst_Cpos_2 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Lst_Cpos_2,
             Expected_Token_Id => Ada_Pipe,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_64 := Lst_Cpos_2 + 1;
   end if;
end;

--  End tok_code

      if Token_Pos_64 /= No_Token_Index then
          Lst_Cpos_2 := Token_Pos_64;
      else
         exit;
      end if;

end loop;

declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List_2.Nodes.Length;
begin
   List_Res_2 :=
      Allocate_Expr_Alternatives_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Pos;
      Token_End := (if Lst_Cpos_2 = Pos
                    then Pos
                    else Lst_Cpos_2 - 1);

   else
      Token_Start := Token_Index'Max (Pos, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res_2,
      Kind              => Ada_Expr_Alternatives_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res_2,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_Ada_Node_Vectors.Vector renames
         Tmp_List_2.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res_2.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List_2);

--  End list_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Membership_Choice_List_List_Parse_0_Memo,
      List_Pos_2 /= No_Token_Index,
      List_Res_2,
      Pos,
      List_Pos_2);


   Parser.Current_Pos := List_Pos_2;

   return List_Res_2;
end Membership_Choice_List_List_Parse_0;

   


function Relation_Or_Parse_1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr
is
   use Bare_Expr_Memos;

      Nobt_8 :
            Boolean
               := False;
      Row_Pos_51 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_73 :
            Token_Index
               := No_Token_Index;
      Defer_Res_73 :
            Bare_Expr
               := No_Bare_Ada_Node;
      Row_Pos_52 :
            Token_Index
               := No_Token_Index;
      Token_Pos_55 :
            Token_Index
               := No_Token_Index;
      Token_Res_55 :
            Token_Index
               := No_Token_Index;
      Transform_Res_47 :
            Bare_Op_Eq
               := No_Bare_Ada_Node;
      Row_Pos_53 :
            Token_Index
               := No_Token_Index;
      Token_Pos_56 :
            Token_Index
               := No_Token_Index;
      Token_Res_56 :
            Token_Index
               := No_Token_Index;
      Transform_Res_48 :
            Bare_Op_Neq
               := No_Bare_Ada_Node;
      Row_Pos_54 :
            Token_Index
               := No_Token_Index;
      Token_Pos_57 :
            Token_Index
               := No_Token_Index;
      Token_Res_57 :
            Token_Index
               := No_Token_Index;
      Transform_Res_49 :
            Bare_Op_Lt
               := No_Bare_Ada_Node;
      Row_Pos_55 :
            Token_Index
               := No_Token_Index;
      Token_Pos_58 :
            Token_Index
               := No_Token_Index;
      Token_Res_58 :
            Token_Index
               := No_Token_Index;
      Transform_Res_50 :
            Bare_Op_Lte
               := No_Bare_Ada_Node;
      Row_Pos_56 :
            Token_Index
               := No_Token_Index;
      Token_Pos_59 :
            Token_Index
               := No_Token_Index;
      Token_Res_59 :
            Token_Index
               := No_Token_Index;
      Transform_Res_51 :
            Bare_Op_Gt
               := No_Bare_Ada_Node;
      Row_Pos_57 :
            Token_Index
               := No_Token_Index;
      Token_Pos_60 :
            Token_Index
               := No_Token_Index;
      Token_Res_60 :
            Token_Index
               := No_Token_Index;
      Transform_Res_52 :
            Bare_Op_Gte
               := No_Bare_Ada_Node;
      Or_Pos_20 :
            Token_Index
               := No_Token_Index;
      Or_Res_20 :
            Bare_Op
               := No_Bare_Ada_Node;
      Defer_Pos_74 :
            Token_Index
               := No_Token_Index;
      Defer_Res_74 :
            Bare_Expr
               := No_Bare_Ada_Node;
      Row_Progress_8 :
            Integer
               := 0;
      Transform_Res_53 :
            Bare_Relation_Op
               := No_Bare_Ada_Node;
      Transform_Has_Failed_8 :
            Boolean
               := False;
      Row_Pos_58 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_75 :
            Token_Index
               := No_Token_Index;
      Defer_Res_75 :
            Bare_Expr
               := No_Bare_Ada_Node;
      Defer_Pos_76 :
            Token_Index
               := No_Token_Index;
      Defer_Res_76 :
            Bare_Op
               := No_Bare_Ada_Node;
      Defer_Pos_77 :
            Token_Index
               := No_Token_Index;
      Defer_Res_77 :
            Bare_Expr_Alternatives_List
               := No_Bare_Ada_Node;
      Transform_Res_54 :
            Bare_Membership_Expr
               := No_Bare_Ada_Node;
      Defer_Pos_78 :
            Token_Index
               := No_Token_Index;
      Defer_Res_78 :
            Bare_Expr
               := No_Bare_Ada_Node;
      Or_Pos_21 :
            Token_Index
               := No_Token_Index;
      Or_Res_21 :
            Bare_Expr
               := No_Bare_Ada_Node;

      Mem_Pos : Token_Index := Pos;
      Mem_Res : Bare_Expr := No_Bare_Ada_Node;

   M : Memo_Entry := Get (Parser.Private_Part.Relation_Or_Parse_1_Memo, Pos);

begin

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Or_Res_21 := M.Instance;
      return Or_Res_21;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Or_Res_21;
   end if;

       Set (Parser.Private_Part.Relation_Or_Parse_1_Memo, False, Or_Res_21, Pos, Mem_Pos);

       <<Try_Again>>

      Nobt_8 := False;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start or_code

Or_Pos_21 := No_Token_Index;
Or_Res_21 := No_Bare_Ada_Node;
    
--  Start transform_code


--  Start row_code

Row_Pos_51 := Pos;



Defer_Res_73 :=
   Relation_Or_Parse_1 (Parser, Row_Pos_51);
Defer_Pos_73 := Parser.Current_Pos;


Row_Progress_8 := 1;

if Defer_Pos_73 /= No_Token_Index then

   Row_Pos_51 := Defer_Pos_73;

else
   Row_Pos_51 := No_Token_Index;
   goto Exit_Row_40_0;

end if;


--  Start or_code

Or_Pos_20 := No_Token_Index;
Or_Res_20 := No_Bare_Ada_Node;
    
--  Start transform_code


--  Start row_code

Row_Pos_52 := Row_Pos_51;



--  Start tok_code

Token_Res_55 := Row_Pos_52;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_55));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Equal)
   then
       Token_Pos_55 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_52 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_52,
             Expected_Token_Id => Ada_Equal,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_55 := Row_Pos_52 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_55 /= No_Token_Index then

   Row_Pos_52 := Token_Pos_55;

else
   Row_Pos_52 := No_Token_Index;
   goto Exit_Row_41_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_41_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_52 /= No_Token_Index then

   Transform_Res_47 := Allocate_Op_Eq (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_47,
      Kind => Ada_Op_Eq,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos_51,
      Token_End_Index   => (if Row_Pos_52 = Row_Pos_51
                            then No_Token_Index
                            else Row_Pos_52 - 1));

      Initialize_Fields_For_Op_Eq
        (Self => Transform_Res_47);



end if;

--  End transform_code

    if Row_Pos_52 /= No_Token_Index then
        Or_Pos_20 := Row_Pos_52;
        Or_Res_20 := Transform_Res_47;
        goto Exit_Or_20;
    end if;
    
--  Start transform_code


--  Start row_code

Row_Pos_53 := Row_Pos_51;



--  Start tok_code

Token_Res_56 := Row_Pos_53;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_56));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Notequal)
   then
       Token_Pos_56 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_53 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_53,
             Expected_Token_Id => Ada_Notequal,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_56 := Row_Pos_53 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_56 /= No_Token_Index then

   Row_Pos_53 := Token_Pos_56;

else
   Row_Pos_53 := No_Token_Index;
   goto Exit_Row_42_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_42_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_53 /= No_Token_Index then

   Transform_Res_48 := Allocate_Op_Neq (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_48,
      Kind => Ada_Op_Neq,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos_51,
      Token_End_Index   => (if Row_Pos_53 = Row_Pos_51
                            then No_Token_Index
                            else Row_Pos_53 - 1));

      Initialize_Fields_For_Op_Neq
        (Self => Transform_Res_48);



end if;

--  End transform_code

    if Row_Pos_53 /= No_Token_Index then
        Or_Pos_20 := Row_Pos_53;
        Or_Res_20 := Transform_Res_48;
        goto Exit_Or_20;
    end if;
    
--  Start transform_code


--  Start row_code

Row_Pos_54 := Row_Pos_51;



--  Start tok_code

Token_Res_57 := Row_Pos_54;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_57));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Lt)
   then
       Token_Pos_57 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_54 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_54,
             Expected_Token_Id => Ada_Lt,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_57 := Row_Pos_54 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_57 /= No_Token_Index then

   Row_Pos_54 := Token_Pos_57;

else
   Row_Pos_54 := No_Token_Index;
   goto Exit_Row_43_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_43_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_54 /= No_Token_Index then

   Transform_Res_49 := Allocate_Op_Lt (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_49,
      Kind => Ada_Op_Lt,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos_51,
      Token_End_Index   => (if Row_Pos_54 = Row_Pos_51
                            then No_Token_Index
                            else Row_Pos_54 - 1));

      Initialize_Fields_For_Op_Lt
        (Self => Transform_Res_49);



end if;

--  End transform_code

    if Row_Pos_54 /= No_Token_Index then
        Or_Pos_20 := Row_Pos_54;
        Or_Res_20 := Transform_Res_49;
        goto Exit_Or_20;
    end if;
    
--  Start transform_code


--  Start row_code

Row_Pos_55 := Row_Pos_51;



--  Start tok_code

Token_Res_58 := Row_Pos_55;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_58));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Lte)
   then
       Token_Pos_58 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_55 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_55,
             Expected_Token_Id => Ada_Lte,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_58 := Row_Pos_55 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_58 /= No_Token_Index then

   Row_Pos_55 := Token_Pos_58;

else
   Row_Pos_55 := No_Token_Index;
   goto Exit_Row_44_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_44_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_55 /= No_Token_Index then

   Transform_Res_50 := Allocate_Op_Lte (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_50,
      Kind => Ada_Op_Lte,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos_51,
      Token_End_Index   => (if Row_Pos_55 = Row_Pos_51
                            then No_Token_Index
                            else Row_Pos_55 - 1));

      Initialize_Fields_For_Op_Lte
        (Self => Transform_Res_50);



end if;

--  End transform_code

    if Row_Pos_55 /= No_Token_Index then
        Or_Pos_20 := Row_Pos_55;
        Or_Res_20 := Transform_Res_50;
        goto Exit_Or_20;
    end if;
    
--  Start transform_code


--  Start row_code

Row_Pos_56 := Row_Pos_51;



--  Start tok_code

Token_Res_59 := Row_Pos_56;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_59));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Gt)
   then
       Token_Pos_59 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_56 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_56,
             Expected_Token_Id => Ada_Gt,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_59 := Row_Pos_56 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_59 /= No_Token_Index then

   Row_Pos_56 := Token_Pos_59;

else
   Row_Pos_56 := No_Token_Index;
   goto Exit_Row_45_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_45_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_56 /= No_Token_Index then

   Transform_Res_51 := Allocate_Op_Gt (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_51,
      Kind => Ada_Op_Gt,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos_51,
      Token_End_Index   => (if Row_Pos_56 = Row_Pos_51
                            then No_Token_Index
                            else Row_Pos_56 - 1));

      Initialize_Fields_For_Op_Gt
        (Self => Transform_Res_51);



end if;

--  End transform_code

    if Row_Pos_56 /= No_Token_Index then
        Or_Pos_20 := Row_Pos_56;
        Or_Res_20 := Transform_Res_51;
        goto Exit_Or_20;
    end if;
    
--  Start transform_code


--  Start row_code

Row_Pos_57 := Row_Pos_51;



--  Start tok_code

Token_Res_60 := Row_Pos_57;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_60));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Gte)
   then
       Token_Pos_60 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_57 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_57,
             Expected_Token_Id => Ada_Gte,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_60 := Row_Pos_57 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_60 /= No_Token_Index then

   Row_Pos_57 := Token_Pos_60;

else
   Row_Pos_57 := No_Token_Index;
   goto Exit_Row_46_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_46_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_57 /= No_Token_Index then

   Transform_Res_52 := Allocate_Op_Gte (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_52,
      Kind => Ada_Op_Gte,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos_51,
      Token_End_Index   => (if Row_Pos_57 = Row_Pos_51
                            then No_Token_Index
                            else Row_Pos_57 - 1));

      Initialize_Fields_For_Op_Gte
        (Self => Transform_Res_52);



end if;

--  End transform_code

    if Row_Pos_57 /= No_Token_Index then
        Or_Pos_20 := Row_Pos_57;
        Or_Res_20 := Transform_Res_52;
        goto Exit_Or_20;
    end if;
<<Exit_Or_20>>

--  End or_code


Row_Progress_8 := 2;

if Or_Pos_20 /= No_Token_Index then

   Row_Pos_51 := Or_Pos_20;

else
   Row_Pos_51 := No_Token_Index;
   goto Exit_Row_40_0;

end if;

Nobt_8 := True;

Row_Progress_8 := 3;

if Row_Pos_51 /= No_Token_Index then

   Row_Pos_51 := Row_Pos_51;

else
   Row_Pos_51 := No_Token_Index;
   goto Exit_Row_40_0;

end if;


Defer_Res_74 :=
   Simple_Expr_Or_Parse_1 (Parser, Row_Pos_51);
Defer_Pos_74 := Parser.Current_Pos;


Row_Progress_8 := 4;

if Defer_Pos_74 /= No_Token_Index then

   Row_Pos_51 := Defer_Pos_74;

else
   Row_Pos_51 := No_Token_Index;
   goto Exit_Row_40_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_40_0>>
pragma Warnings (On, "referenced");

--  End row_code


if Row_Pos_51 = No_Token_Index and then Nobt_8 then
   Row_Pos_51 := Parser.Last_Fail.Pos;
   Transform_Has_Failed_8 := True;
end if;

if Row_Pos_51 /= No_Token_Index then

   Transform_Res_53 := Allocate_Relation_Op (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_53,
      Kind => Ada_Relation_Op,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_51 = Pos
                            then No_Token_Index
                            else Row_Pos_51 - 1));

      Initialize_Fields_For_Relation_Op
        (Self => Transform_Res_53, Bin_Op_F_Left => Defer_Res_73, Bin_Op_F_Op => Or_Res_20, Bin_Op_F_Right => Defer_Res_74);

         if Defer_Res_73 /= null and then Is_Incomplete (Defer_Res_73) then
            Transform_Res_53.Last_Attempted_Child := 0;
         elsif Defer_Res_73 /= null and then not Is_Ghost (Defer_Res_73) then
            Transform_Res_53.Last_Attempted_Child := -1;
         end if;
         if Or_Res_20 /= null and then Is_Incomplete (Or_Res_20) then
            Transform_Res_53.Last_Attempted_Child := 0;
         elsif Or_Res_20 /= null and then not Is_Ghost (Or_Res_20) then
            Transform_Res_53.Last_Attempted_Child := -1;
         end if;
         if Defer_Res_74 /= null and then Is_Incomplete (Defer_Res_74) then
            Transform_Res_53.Last_Attempted_Child := 0;
         elsif Defer_Res_74 /= null and then not Is_Ghost (Defer_Res_74) then
            Transform_Res_53.Last_Attempted_Child := -1;
         end if;

   if Transform_Has_Failed_8 then
      Transform_Res_53.Last_Attempted_Child :=
         Row_Progress_8;

      Append (Parser.Diagnostics,
              Sloc_Range (Parser.TDH.all,
                          Get_Token (Parser.TDH.all, Pos)),
              To_Text ("Cannot parse <relation>"));

      Add_Last_Fail_Diagnostic (Parser);
   end if;

end if;

--  End transform_code

    if Row_Pos_51 /= No_Token_Index then
        Or_Pos_21 := Row_Pos_51;
        Or_Res_21 := Transform_Res_53;
        goto Exit_Or_19;
    end if;
    
--  Start transform_code


--  Start row_code

Row_Pos_58 := Pos;



Defer_Res_75 :=
   Relation_Or_Parse_1 (Parser, Row_Pos_58);
Defer_Pos_75 := Parser.Current_Pos;



if Defer_Pos_75 /= No_Token_Index then

   Row_Pos_58 := Defer_Pos_75;

else
   Row_Pos_58 := No_Token_Index;
   goto Exit_Row_47_0;

end if;


Defer_Res_76 :=
   Rel_Op_Or_Parse_0 (Parser, Row_Pos_58);
Defer_Pos_76 := Parser.Current_Pos;



if Defer_Pos_76 /= No_Token_Index then

   Row_Pos_58 := Defer_Pos_76;

else
   Row_Pos_58 := No_Token_Index;
   goto Exit_Row_47_0;

end if;


Defer_Res_77 :=
   Membership_Choice_List_List_Parse_0 (Parser, Row_Pos_58);
Defer_Pos_77 := Parser.Current_Pos;



if Defer_Pos_77 /= No_Token_Index then

   Row_Pos_58 := Defer_Pos_77;

else
   Row_Pos_58 := No_Token_Index;
   goto Exit_Row_47_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_47_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_58 /= No_Token_Index then

   Transform_Res_54 := Allocate_Membership_Expr (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_54,
      Kind => Ada_Membership_Expr,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_58 = Pos
                            then No_Token_Index
                            else Row_Pos_58 - 1));

      Initialize_Fields_For_Membership_Expr
        (Self => Transform_Res_54, Membership_Expr_F_Expr => Defer_Res_75, Membership_Expr_F_Op => Defer_Res_76, Membership_Expr_F_Membership_Exprs => Defer_Res_77);

         if Defer_Res_75 /= null and then Is_Incomplete (Defer_Res_75) then
            Transform_Res_54.Last_Attempted_Child := 0;
         elsif Defer_Res_75 /= null and then not Is_Ghost (Defer_Res_75) then
            Transform_Res_54.Last_Attempted_Child := -1;
         end if;
         if Defer_Res_76 /= null and then Is_Incomplete (Defer_Res_76) then
            Transform_Res_54.Last_Attempted_Child := 0;
         elsif Defer_Res_76 /= null and then not Is_Ghost (Defer_Res_76) then
            Transform_Res_54.Last_Attempted_Child := -1;
         end if;
         if Defer_Res_77 /= null and then Is_Incomplete (Defer_Res_77) then
            Transform_Res_54.Last_Attempted_Child := 0;
         elsif Defer_Res_77 /= null and then not Is_Ghost (Defer_Res_77) then
            Transform_Res_54.Last_Attempted_Child := -1;
         end if;


end if;

--  End transform_code

    if Row_Pos_58 /= No_Token_Index then
        Or_Pos_21 := Row_Pos_58;
        Or_Res_21 := Transform_Res_54;
        goto Exit_Or_19;
    end if;
    
Defer_Res_78 :=
   Simple_Expr_Or_Parse_1 (Parser, Pos);
Defer_Pos_78 := Parser.Current_Pos;

    if Defer_Pos_78 /= No_Token_Index then
        Or_Pos_21 := Defer_Pos_78;
        Or_Res_21 := Defer_Res_78;
        goto Exit_Or_19;
    end if;
<<Exit_Or_19>>

--  End or_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------

      if Or_Pos_21 > Mem_Pos then
         Mem_Pos := Or_Pos_21;
         Mem_Res := Or_Res_21;
         Set
           (Parser.Private_Part.Relation_Or_Parse_1_Memo,
            Or_Pos_21 /= No_Token_Index,
            Or_Res_21,
            Pos,
            Or_Pos_21);
         goto Try_Again;

      elsif Mem_Pos > Pos then
         Or_Res_21 := Mem_Res;
         Or_Pos_21 := Mem_Pos;
         goto No_Memo;
      end if;

   Set
     (Parser.Private_Part.Relation_Or_Parse_1_Memo,
      Or_Pos_21 /= No_Token_Index,
      Or_Res_21,
      Pos,
      Or_Pos_21);

       <<No_Memo>>

   Parser.Current_Pos := Or_Pos_21;

   return Or_Res_21;
end Relation_Or_Parse_1;

   


function Expr_Or_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr
is
   use Bare_Expr_Memos;

      Nobt_7 :
            Boolean
               := False;
      Row_Pos_45 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_69 :
            Token_Index
               := No_Token_Index;
      Defer_Res_69 :
            Bare_Expr
               := No_Bare_Ada_Node;
      Defer_Pos_70 :
            Token_Index
               := No_Token_Index;
      Defer_Res_70 :
            Bare_Op
               := No_Bare_Ada_Node;
      Defer_Pos_71 :
            Token_Index
               := No_Token_Index;
      Defer_Res_71 :
            Bare_Expr
               := No_Bare_Ada_Node;
      Row_Progress_7 :
            Integer
               := 0;
      Transform_Res_41 :
            Bare_Bin_Op
               := No_Bare_Ada_Node;
      Transform_Has_Failed_7 :
            Boolean
               := False;
      Defer_Pos_72 :
            Token_Index
               := No_Token_Index;
      Defer_Res_72 :
            Bare_Expr
               := No_Bare_Ada_Node;
      Or_Pos_18 :
            Token_Index
               := No_Token_Index;
      Or_Res_18 :
            Bare_Expr
               := No_Bare_Ada_Node;

      Mem_Pos : Token_Index := Pos;
      Mem_Res : Bare_Expr := No_Bare_Ada_Node;

   M : Memo_Entry := Get (Parser.Private_Part.Expr_Or_Parse_0_Memo, Pos);

begin

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Or_Res_18 := M.Instance;
      return Or_Res_18;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Or_Res_18;
   end if;

       Set (Parser.Private_Part.Expr_Or_Parse_0_Memo, False, Or_Res_18, Pos, Mem_Pos);

       <<Try_Again>>

      Nobt_7 := False;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start or_code

Or_Pos_18 := No_Token_Index;
Or_Res_18 := No_Bare_Ada_Node;
    
--  Start transform_code


--  Start row_code

Row_Pos_45 := Pos;



Defer_Res_69 :=
   Expr_Or_Parse_0 (Parser, Row_Pos_45);
Defer_Pos_69 := Parser.Current_Pos;


Row_Progress_7 := 1;

if Defer_Pos_69 /= No_Token_Index then

   Row_Pos_45 := Defer_Pos_69;

else
   Row_Pos_45 := No_Token_Index;
   goto Exit_Row_34_0;

end if;


Defer_Res_70 :=
   Boolean_Op_Or_Parse_0 (Parser, Row_Pos_45);
Defer_Pos_70 := Parser.Current_Pos;


Row_Progress_7 := 2;

if Defer_Pos_70 /= No_Token_Index then

   Row_Pos_45 := Defer_Pos_70;

else
   Row_Pos_45 := No_Token_Index;
   goto Exit_Row_34_0;

end if;

Nobt_7 := True;

Row_Progress_7 := 3;

if Row_Pos_45 /= No_Token_Index then

   Row_Pos_45 := Row_Pos_45;

else
   Row_Pos_45 := No_Token_Index;
   goto Exit_Row_34_0;

end if;


Defer_Res_71 :=
   Relation_Or_Parse_1 (Parser, Row_Pos_45);
Defer_Pos_71 := Parser.Current_Pos;


Row_Progress_7 := 4;

if Defer_Pos_71 /= No_Token_Index then

   Row_Pos_45 := Defer_Pos_71;

else
   Row_Pos_45 := No_Token_Index;
   goto Exit_Row_34_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_34_0>>
pragma Warnings (On, "referenced");

--  End row_code


if Row_Pos_45 = No_Token_Index and then Nobt_7 then
   Row_Pos_45 := Parser.Last_Fail.Pos;
   Transform_Has_Failed_7 := True;
end if;

if Row_Pos_45 /= No_Token_Index then

   Transform_Res_41 := Allocate_Bin_Op (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_41,
      Kind => Ada_Bin_Op,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_45 = Pos
                            then No_Token_Index
                            else Row_Pos_45 - 1));

      Initialize_Fields_For_Bin_Op
        (Self => Transform_Res_41, Bin_Op_F_Left => Defer_Res_69, Bin_Op_F_Op => Defer_Res_70, Bin_Op_F_Right => Defer_Res_71);

         if Defer_Res_69 /= null and then Is_Incomplete (Defer_Res_69) then
            Transform_Res_41.Last_Attempted_Child := 0;
         elsif Defer_Res_69 /= null and then not Is_Ghost (Defer_Res_69) then
            Transform_Res_41.Last_Attempted_Child := -1;
         end if;
         if Defer_Res_70 /= null and then Is_Incomplete (Defer_Res_70) then
            Transform_Res_41.Last_Attempted_Child := 0;
         elsif Defer_Res_70 /= null and then not Is_Ghost (Defer_Res_70) then
            Transform_Res_41.Last_Attempted_Child := -1;
         end if;
         if Defer_Res_71 /= null and then Is_Incomplete (Defer_Res_71) then
            Transform_Res_41.Last_Attempted_Child := 0;
         elsif Defer_Res_71 /= null and then not Is_Ghost (Defer_Res_71) then
            Transform_Res_41.Last_Attempted_Child := -1;
         end if;

   if Transform_Has_Failed_7 then
      Transform_Res_41.Last_Attempted_Child :=
         Row_Progress_7;

      Append (Parser.Diagnostics,
              Sloc_Range (Parser.TDH.all,
                          Get_Token (Parser.TDH.all, Pos)),
              To_Text ("Cannot parse <expr>"));

      Add_Last_Fail_Diagnostic (Parser);
   end if;

end if;

--  End transform_code

    if Row_Pos_45 /= No_Token_Index then
        Or_Pos_18 := Row_Pos_45;
        Or_Res_18 := Transform_Res_41;
        goto Exit_Or_17;
    end if;
    
Defer_Res_72 :=
   Relation_Or_Parse_1 (Parser, Pos);
Defer_Pos_72 := Parser.Current_Pos;

    if Defer_Pos_72 /= No_Token_Index then
        Or_Pos_18 := Defer_Pos_72;
        Or_Res_18 := Defer_Res_72;
        goto Exit_Or_17;
    end if;
<<Exit_Or_17>>

--  End or_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------

      if Or_Pos_18 > Mem_Pos then
         Mem_Pos := Or_Pos_18;
         Mem_Res := Or_Res_18;
         Set
           (Parser.Private_Part.Expr_Or_Parse_0_Memo,
            Or_Pos_18 /= No_Token_Index,
            Or_Res_18,
            Pos,
            Or_Pos_18);
         goto Try_Again;

      elsif Mem_Pos > Pos then
         Or_Res_18 := Mem_Res;
         Or_Pos_18 := Mem_Pos;
         goto No_Memo;
      end if;

   Set
     (Parser.Private_Part.Expr_Or_Parse_0_Memo,
      Or_Pos_18 /= No_Token_Index,
      Or_Res_18,
      Pos,
      Or_Pos_18);

       <<No_Memo>>

   Parser.Current_Pos := Or_Pos_18;

   return Or_Res_18;
end Expr_Or_Parse_0;

   


function Paren_Expr_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Paren_Expr
is
   use Bare_Paren_Expr_Memos;

      Row_Pos_44 :
            Token_Index
               := No_Token_Index;
      Token_Pos_46 :
            Token_Index
               := No_Token_Index;
      Token_Res_46 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_68 :
            Token_Index
               := No_Token_Index;
      Defer_Res_68 :
            Bare_Expr
               := No_Bare_Ada_Node;
      Token_Pos_47 :
            Token_Index
               := No_Token_Index;
      Token_Res_47 :
            Token_Index
               := No_Token_Index;
      Transform_Res_40 :
            Bare_Paren_Expr
               := No_Bare_Ada_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Paren_Expr_Transform_Parse_0_Memo, Pos);

begin

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res_40 := M.Instance;
      return Transform_Res_40;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res_40;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code


--  Start row_code

Row_Pos_44 := Pos;



--  Start tok_code

Token_Res_46 := Row_Pos_44;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_46));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Par_Open)
   then
       Token_Pos_46 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_44 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_44,
             Expected_Token_Id => Ada_Par_Open,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_46 := Row_Pos_44 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_46 /= No_Token_Index then

   Row_Pos_44 := Token_Pos_46;

else
   Row_Pos_44 := No_Token_Index;
   goto Exit_Row_33_0;

end if;


Defer_Res_68 :=
   Expr_Or_Parse_0 (Parser, Row_Pos_44);
Defer_Pos_68 := Parser.Current_Pos;



if Defer_Pos_68 /= No_Token_Index then

   Row_Pos_44 := Defer_Pos_68;

else
   Row_Pos_44 := No_Token_Index;
   goto Exit_Row_33_0;

end if;


--  Start tok_code

Token_Res_47 := Row_Pos_44;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_47));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Par_Close)
   then
       Token_Pos_47 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_44 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_44,
             Expected_Token_Id => Ada_Par_Close,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_47 := Row_Pos_44 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_47 /= No_Token_Index then

   Row_Pos_44 := Token_Pos_47;

else
   Row_Pos_44 := No_Token_Index;
   goto Exit_Row_33_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_33_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_44 /= No_Token_Index then

   Transform_Res_40 := Allocate_Paren_Expr (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_40,
      Kind => Ada_Paren_Expr,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_44 = Pos
                            then No_Token_Index
                            else Row_Pos_44 - 1));

      Initialize_Fields_For_Paren_Expr
        (Self => Transform_Res_40, Paren_Expr_F_Expr => Defer_Res_68);

         if Defer_Res_68 /= null and then Is_Incomplete (Defer_Res_68) then
            Transform_Res_40.Last_Attempted_Child := 0;
         elsif Defer_Res_68 /= null and then not Is_Ghost (Defer_Res_68) then
            Transform_Res_40.Last_Attempted_Child := -1;
         end if;


end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Paren_Expr_Transform_Parse_0_Memo,
      Row_Pos_44 /= No_Token_Index,
      Transform_Res_40,
      Pos,
      Row_Pos_44);


   Parser.Current_Pos := Row_Pos_44;

   return Transform_Res_40;
end Paren_Expr_Transform_Parse_0;

   


function Defining_Id_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Defining_Name
is
   use Bare_Defining_Name_Memos;

      Row_Pos_75 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_99 :
            Token_Index
               := No_Token_Index;
      Defer_Res_99 :
            Bare_Identifier
               := No_Bare_Ada_Node;
      Transform_Res_67 :
            Bare_Defining_Name
               := No_Bare_Ada_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Defining_Id_Transform_Parse_0_Memo, Pos);

begin

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res_67 := M.Instance;
      return Transform_Res_67;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res_67;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code


--  Start row_code

Row_Pos_75 := Pos;



Defer_Res_99 :=
   Identifier_Transform_Parse_0 (Parser, Row_Pos_75);
Defer_Pos_99 := Parser.Current_Pos;



if Defer_Pos_99 /= No_Token_Index then

   Row_Pos_75 := Defer_Pos_99;

else
   Row_Pos_75 := No_Token_Index;
   goto Exit_Row_57_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_57_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_75 /= No_Token_Index then

   Transform_Res_67 := Allocate_Defining_Name (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_67,
      Kind => Ada_Defining_Name,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_75 = Pos
                            then No_Token_Index
                            else Row_Pos_75 - 1));

      Initialize_Fields_For_Defining_Name
        (Self => Transform_Res_67, Defining_Name_F_Name => Defer_Res_99);

         if Defer_Res_99 /= null and then Is_Incomplete (Defer_Res_99) then
            Transform_Res_67.Last_Attempted_Child := 0;
         elsif Defer_Res_99 /= null and then not Is_Ghost (Defer_Res_99) then
            Transform_Res_67.Last_Attempted_Child := -1;
         end if;


end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Defining_Id_Transform_Parse_0_Memo,
      Row_Pos_75 /= No_Token_Index,
      Transform_Res_67,
      Pos,
      Row_Pos_75);


   Parser.Current_Pos := Row_Pos_75;

   return Transform_Res_67;
end Defining_Id_Transform_Parse_0;

   


function Box_Expr_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Box_Expr
is
   use Bare_Box_Expr_Memos;

      Row_Pos_80 :
            Token_Index
               := No_Token_Index;
      Token_Pos_90 :
            Token_Index
               := No_Token_Index;
      Token_Res_90 :
            Token_Index
               := No_Token_Index;
      Transform_Res_71 :
            Bare_Box_Expr
               := No_Bare_Ada_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Box_Expr_Transform_Parse_0_Memo, Pos);

begin

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res_71 := M.Instance;
      return Transform_Res_71;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res_71;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code


--  Start row_code

Row_Pos_80 := Pos;



--  Start tok_code

Token_Res_90 := Row_Pos_80;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_90));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Diamond)
   then
       Token_Pos_90 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_80 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_80,
             Expected_Token_Id => Ada_Diamond,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_90 := Row_Pos_80 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_90 /= No_Token_Index then

   Row_Pos_80 := Token_Pos_90;

else
   Row_Pos_80 := No_Token_Index;
   goto Exit_Row_63_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_63_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_80 /= No_Token_Index then

   Transform_Res_71 := Allocate_Box_Expr (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_71,
      Kind => Ada_Box_Expr,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_80 = Pos
                            then No_Token_Index
                            else Row_Pos_80 - 1));

      Initialize_Fields_For_Box_Expr
        (Self => Transform_Res_71);



end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Box_Expr_Transform_Parse_0_Memo,
      Row_Pos_80 /= No_Token_Index,
      Transform_Res_71,
      Pos,
      Row_Pos_80);


   Parser.Current_Pos := Row_Pos_80;

   return Transform_Res_71;
end Box_Expr_Transform_Parse_0;

   


function Range_Spec_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Range_Spec
is
   use Bare_Range_Spec_Memos;

      Row_Pos_79 :
            Token_Index
               := No_Token_Index;
      Token_Pos_89 :
            Token_Index
               := No_Token_Index;
      Token_Res_89 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_109 :
            Token_Index
               := No_Token_Index;
      Defer_Res_109 :
            Bare_Expr
               := No_Bare_Ada_Node;
      Defer_Pos_110 :
            Token_Index
               := No_Token_Index;
      Defer_Res_110 :
            Bare_Name
               := No_Bare_Ada_Node;
      Defer_Pos_111 :
            Token_Index
               := No_Token_Index;
      Defer_Res_111 :
            Bare_Box_Expr
               := No_Bare_Ada_Node;
      Or_Pos_31 :
            Token_Index
               := No_Token_Index;
      Or_Res_31 :
            Bare_Expr
               := No_Bare_Ada_Node;
      Transform_Res_70 :
            Bare_Range_Spec
               := No_Bare_Ada_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Range_Spec_Transform_Parse_0_Memo, Pos);

begin

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res_70 := M.Instance;
      return Transform_Res_70;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res_70;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code


--  Start row_code

Row_Pos_79 := Pos;



--  Start tok_code

Token_Res_89 := Row_Pos_79;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_89));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Range)
   then
       Token_Pos_89 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_79 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_79,
             Expected_Token_Id => Ada_Range,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_89 := Row_Pos_79 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_89 /= No_Token_Index then

   Row_Pos_79 := Token_Pos_89;

else
   Row_Pos_79 := No_Token_Index;
   goto Exit_Row_62_0;

end if;


--  Start or_code

Or_Pos_31 := No_Token_Index;
Or_Res_31 := No_Bare_Ada_Node;
    
Defer_Res_109 :=
   Discrete_Range_Or_Parse_0 (Parser, Row_Pos_79);
Defer_Pos_109 := Parser.Current_Pos;

    if Defer_Pos_109 /= No_Token_Index then
        Or_Pos_31 := Defer_Pos_109;
        Or_Res_31 := Defer_Res_109;
        goto Exit_Or_26;
    end if;
    
Defer_Res_110 :=
   Name_Or_Parse_1 (Parser, Row_Pos_79);
Defer_Pos_110 := Parser.Current_Pos;

    if Defer_Pos_110 /= No_Token_Index then
        Or_Pos_31 := Defer_Pos_110;
        Or_Res_31 := Defer_Res_110;
        goto Exit_Or_26;
    end if;
    
Defer_Res_111 :=
   Box_Expr_Transform_Parse_0 (Parser, Row_Pos_79);
Defer_Pos_111 := Parser.Current_Pos;

    if Defer_Pos_111 /= No_Token_Index then
        Or_Pos_31 := Defer_Pos_111;
        Or_Res_31 := Defer_Res_111;
        goto Exit_Or_26;
    end if;
<<Exit_Or_26>>

--  End or_code



if Or_Pos_31 /= No_Token_Index then

   Row_Pos_79 := Or_Pos_31;

else
   Row_Pos_79 := No_Token_Index;
   goto Exit_Row_62_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_62_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_79 /= No_Token_Index then

   Transform_Res_70 := Allocate_Range_Spec (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_70,
      Kind => Ada_Range_Spec,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_79 = Pos
                            then No_Token_Index
                            else Row_Pos_79 - 1));

      Initialize_Fields_For_Range_Spec
        (Self => Transform_Res_70, Range_Spec_F_Range => Or_Res_31);

         if Or_Res_31 /= null and then Is_Incomplete (Or_Res_31) then
            Transform_Res_70.Last_Attempted_Child := 0;
         elsif Or_Res_31 /= null and then not Is_Ghost (Or_Res_31) then
            Transform_Res_70.Last_Attempted_Child := -1;
         end if;


end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Range_Spec_Transform_Parse_0_Memo,
      Row_Pos_79 /= No_Token_Index,
      Transform_Res_70,
      Pos,
      Row_Pos_79);


   Parser.Current_Pos := Row_Pos_79;

   return Transform_Res_70;
end Range_Spec_Transform_Parse_0;

   


function Digits_Constraint_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Digits_Constraint
is
   use Bare_Digits_Constraint_Memos;

      Row_Pos_78 :
            Token_Index
               := No_Token_Index;
      Token_Pos_88 :
            Token_Index
               := No_Token_Index;
      Token_Res_88 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_107 :
            Token_Index
               := No_Token_Index;
      Defer_Res_107 :
            Bare_Expr
               := No_Bare_Ada_Node;
      Defer_Pos_108 :
            Token_Index
               := No_Token_Index;
      Defer_Res_108 :
            Bare_Range_Spec
               := No_Bare_Ada_Node;
      Transform_Res_69 :
            Bare_Digits_Constraint
               := No_Bare_Ada_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Digits_Constraint_Transform_Parse_0_Memo, Pos);

begin

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res_69 := M.Instance;
      return Transform_Res_69;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res_69;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code


--  Start row_code

Row_Pos_78 := Pos;



--  Start tok_code

Token_Res_88 := Row_Pos_78;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_88));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Digits)
   then
       Token_Pos_88 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_78 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_78,
             Expected_Token_Id => Ada_Digits,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_88 := Row_Pos_78 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_88 /= No_Token_Index then

   Row_Pos_78 := Token_Pos_88;

else
   Row_Pos_78 := No_Token_Index;
   goto Exit_Row_61_0;

end if;


Defer_Res_107 :=
   Simple_Expr_Or_Parse_1 (Parser, Row_Pos_78);
Defer_Pos_107 := Parser.Current_Pos;



if Defer_Pos_107 /= No_Token_Index then

   Row_Pos_78 := Defer_Pos_107;

else
   Row_Pos_78 := No_Token_Index;
   goto Exit_Row_61_0;

end if;


--  Start opt_code




Defer_Res_108 :=
   Range_Spec_Transform_Parse_0 (Parser, Row_Pos_78);
Defer_Pos_108 := Parser.Current_Pos;


if Defer_Pos_108 = No_Token_Index then

        Defer_Res_108 := No_Bare_Ada_Node;


    Defer_Pos_108 := Row_Pos_78;


end if;

--  End opt_code



if Defer_Pos_108 /= No_Token_Index then

   Row_Pos_78 := Defer_Pos_108;

else
   Row_Pos_78 := No_Token_Index;
   goto Exit_Row_61_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_61_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_78 /= No_Token_Index then

   Transform_Res_69 := Allocate_Digits_Constraint (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_69,
      Kind => Ada_Digits_Constraint,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_78 = Pos
                            then No_Token_Index
                            else Row_Pos_78 - 1));

      Initialize_Fields_For_Digits_Constraint
        (Self => Transform_Res_69, Digits_Constraint_F_Digits => Defer_Res_107, Digits_Constraint_F_Range => Defer_Res_108);

         if Defer_Res_107 /= null and then Is_Incomplete (Defer_Res_107) then
            Transform_Res_69.Last_Attempted_Child := 0;
         elsif Defer_Res_107 /= null and then not Is_Ghost (Defer_Res_107) then
            Transform_Res_69.Last_Attempted_Child := -1;
         end if;
         if Defer_Res_108 /= null and then Is_Incomplete (Defer_Res_108) then
            Transform_Res_69.Last_Attempted_Child := 0;
         elsif Defer_Res_108 /= null and then not Is_Ghost (Defer_Res_108) then
            Transform_Res_69.Last_Attempted_Child := -1;
         end if;


end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Digits_Constraint_Transform_Parse_0_Memo,
      Row_Pos_78 /= No_Token_Index,
      Transform_Res_69,
      Pos,
      Row_Pos_78);


   Parser.Current_Pos := Row_Pos_78;

   return Transform_Res_69;
end Digits_Constraint_Transform_Parse_0;

   


function Delta_Constraint_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Delta_Constraint
is
   use Bare_Delta_Constraint_Memos;

      Row_Pos_81 :
            Token_Index
               := No_Token_Index;
      Token_Pos_91 :
            Token_Index
               := No_Token_Index;
      Token_Res_91 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_112 :
            Token_Index
               := No_Token_Index;
      Defer_Res_112 :
            Bare_Expr
               := No_Bare_Ada_Node;
      Defer_Pos_113 :
            Token_Index
               := No_Token_Index;
      Defer_Res_113 :
            Bare_Range_Spec
               := No_Bare_Ada_Node;
      Transform_Res_72 :
            Bare_Delta_Constraint
               := No_Bare_Ada_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Delta_Constraint_Transform_Parse_0_Memo, Pos);

begin

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res_72 := M.Instance;
      return Transform_Res_72;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res_72;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code


--  Start row_code

Row_Pos_81 := Pos;



--  Start tok_code

Token_Res_91 := Row_Pos_81;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_91));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Delta)
   then
       Token_Pos_91 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_81 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_81,
             Expected_Token_Id => Ada_Delta,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_91 := Row_Pos_81 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_91 /= No_Token_Index then

   Row_Pos_81 := Token_Pos_91;

else
   Row_Pos_81 := No_Token_Index;
   goto Exit_Row_64_0;

end if;


Defer_Res_112 :=
   Simple_Expr_Or_Parse_1 (Parser, Row_Pos_81);
Defer_Pos_112 := Parser.Current_Pos;



if Defer_Pos_112 /= No_Token_Index then

   Row_Pos_81 := Defer_Pos_112;

else
   Row_Pos_81 := No_Token_Index;
   goto Exit_Row_64_0;

end if;


--  Start opt_code




Defer_Res_113 :=
   Range_Spec_Transform_Parse_0 (Parser, Row_Pos_81);
Defer_Pos_113 := Parser.Current_Pos;


if Defer_Pos_113 = No_Token_Index then

        Defer_Res_113 := No_Bare_Ada_Node;


    Defer_Pos_113 := Row_Pos_81;


end if;

--  End opt_code



if Defer_Pos_113 /= No_Token_Index then

   Row_Pos_81 := Defer_Pos_113;

else
   Row_Pos_81 := No_Token_Index;
   goto Exit_Row_64_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_64_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_81 /= No_Token_Index then

   Transform_Res_72 := Allocate_Delta_Constraint (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_72,
      Kind => Ada_Delta_Constraint,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_81 = Pos
                            then No_Token_Index
                            else Row_Pos_81 - 1));

      Initialize_Fields_For_Delta_Constraint
        (Self => Transform_Res_72, Delta_Constraint_F_Digits => Defer_Res_112, Delta_Constraint_F_Range => Defer_Res_113);

         if Defer_Res_112 /= null and then Is_Incomplete (Defer_Res_112) then
            Transform_Res_72.Last_Attempted_Child := 0;
         elsif Defer_Res_112 /= null and then not Is_Ghost (Defer_Res_112) then
            Transform_Res_72.Last_Attempted_Child := -1;
         end if;
         if Defer_Res_113 /= null and then Is_Incomplete (Defer_Res_113) then
            Transform_Res_72.Last_Attempted_Child := 0;
         elsif Defer_Res_113 /= null and then not Is_Ghost (Defer_Res_113) then
            Transform_Res_72.Last_Attempted_Child := -1;
         end if;


end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Delta_Constraint_Transform_Parse_0_Memo,
      Row_Pos_81 /= No_Token_Index,
      Transform_Res_72,
      Pos,
      Row_Pos_81);


   Parser.Current_Pos := Row_Pos_81;

   return Transform_Res_72;
end Delta_Constraint_Transform_Parse_0;

   


function Discriminant_Assoc_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Discriminant_Assoc
is
   use Bare_Discriminant_Assoc_Memos;

      Row_Pos_83 :
            Token_Index
               := No_Token_Index;
      Row_Pos_84 :
            Token_Index
               := No_Token_Index;
      Lst_Cpos_6 :
            Token_Index
               := No_Token_Index;
      Tmp_List_6 :
            Free_Parse_List;
      Defer_Pos_115 :
            Token_Index
               := No_Token_Index;
      Defer_Res_115 :
            Bare_Identifier
               := No_Bare_Ada_Node;
      Token_Pos_95 :
            Token_Index
               := No_Token_Index;
      Token_Res_95 :
            Token_Index
               := No_Token_Index;
      List_Pos_6 :
            Token_Index
               := No_Token_Index;
      List_Res_6 :
            Bare_Discriminant_Choice_List
               := No_Bare_Ada_Node;
      Token_Pos_96 :
            Token_Index
               := No_Token_Index;
      Token_Res_96 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_116 :
            Token_Index
               := No_Token_Index;
      Defer_Res_116 :
            Bare_Expr
               := No_Bare_Ada_Node;
      Transform_Res_74 :
            Bare_Discriminant_Assoc
               := No_Bare_Ada_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Discriminant_Assoc_Transform_Parse_0_Memo, Pos);

begin

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res_74 := M.Instance;
      return Transform_Res_74;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res_74;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code


--  Start row_code

Row_Pos_83 := Pos;



--  Start opt_code




--  Start row_code

Row_Pos_84 := Row_Pos_83;



--  Start list_code

    List_Pos_6 := No_Token_Index;



Lst_Cpos_6 := Row_Pos_84;
Tmp_List_6 := Get_Parse_List (Parser);

loop
   
Defer_Res_115 :=
   Identifier_Transform_Parse_0 (Parser, Lst_Cpos_6);
Defer_Pos_115 := Parser.Current_Pos;


   exit when Defer_Pos_115 = No_Token_Index;

   List_Pos_6 := Defer_Pos_115;
   Lst_Cpos_6 := List_Pos_6;

   Tmp_List_6.Nodes.Append (Defer_Res_115);

      
--  Start tok_code

Token_Res_95 := Lst_Cpos_6;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_95));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Pipe)
   then
       Token_Pos_95 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Lst_Cpos_6 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Lst_Cpos_6,
             Expected_Token_Id => Ada_Pipe,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_95 := Lst_Cpos_6 + 1;
   end if;
end;

--  End tok_code

      if Token_Pos_95 /= No_Token_Index then
          Lst_Cpos_6 := Token_Pos_95;
      else
         exit;
      end if;

end loop;

declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List_6.Nodes.Length;
begin
   List_Res_6 :=
      Allocate_Discriminant_Choice_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Row_Pos_84;
      Token_End := (if Lst_Cpos_6 = Row_Pos_84
                    then Row_Pos_84
                    else Lst_Cpos_6 - 1);

   else
      Token_Start := Token_Index'Max (Row_Pos_84, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res_6,
      Kind              => Ada_Discriminant_Choice_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res_6,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_Ada_Node_Vectors.Vector renames
         Tmp_List_6.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res_6.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List_6);

--  End list_code



if List_Pos_6 /= No_Token_Index then

   Row_Pos_84 := List_Pos_6;

else
   Row_Pos_84 := No_Token_Index;
   goto Exit_Row_67_0;

end if;


--  Start tok_code

Token_Res_96 := Row_Pos_84;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_96));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Arrow)
   then
       Token_Pos_96 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_84 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_84,
             Expected_Token_Id => Ada_Arrow,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_96 := Row_Pos_84 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_96 /= No_Token_Index then

   Row_Pos_84 := Token_Pos_96;

else
   Row_Pos_84 := No_Token_Index;
   goto Exit_Row_67_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_67_0>>
pragma Warnings (On, "referenced");

--  End row_code


if Row_Pos_84 = No_Token_Index then

        List_Res_6 :=
           Allocate_Discriminant_Choice_List (Parser.Mem_Pool);
         Initialize
           (Self              => List_Res_6,
            Kind              => Ada_Discriminant_Choice_List,
            Unit              => Parser.Unit,
            Token_Start_Index => Row_Pos_83 - 1,
            Token_End_Index   => No_Token_Index);
         Initialize_List
           (Self   => List_Res_6,
            Parser => Parser,
            Count  => 0);


    Row_Pos_84 := Row_Pos_83;


end if;

--  End opt_code



if Row_Pos_84 /= No_Token_Index then

   Row_Pos_83 := Row_Pos_84;

else
   Row_Pos_83 := No_Token_Index;
   goto Exit_Row_66_0;

end if;


Defer_Res_116 :=
   Expr_Or_Parse_0 (Parser, Row_Pos_83);
Defer_Pos_116 := Parser.Current_Pos;



if Defer_Pos_116 /= No_Token_Index then

   Row_Pos_83 := Defer_Pos_116;

else
   Row_Pos_83 := No_Token_Index;
   goto Exit_Row_66_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_66_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_83 /= No_Token_Index then

   Transform_Res_74 := Allocate_Discriminant_Assoc (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_74,
      Kind => Ada_Discriminant_Assoc,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_83 = Pos
                            then No_Token_Index
                            else Row_Pos_83 - 1));

      Initialize_Fields_For_Discriminant_Assoc
        (Self => Transform_Res_74, Discriminant_Assoc_F_Ids => List_Res_6, Discriminant_Assoc_F_Discr_Expr => Defer_Res_116);

         if List_Res_6 /= null and then Is_Incomplete (List_Res_6) then
            Transform_Res_74.Last_Attempted_Child := 0;
         elsif List_Res_6 /= null and then not Is_Ghost (List_Res_6) then
            Transform_Res_74.Last_Attempted_Child := -1;
         end if;
         if Defer_Res_116 /= null and then Is_Incomplete (Defer_Res_116) then
            Transform_Res_74.Last_Attempted_Child := 0;
         elsif Defer_Res_116 /= null and then not Is_Ghost (Defer_Res_116) then
            Transform_Res_74.Last_Attempted_Child := -1;
         end if;


end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Discriminant_Assoc_Transform_Parse_0_Memo,
      Row_Pos_83 /= No_Token_Index,
      Transform_Res_74,
      Pos,
      Row_Pos_83);


   Parser.Current_Pos := Row_Pos_83;

   return Transform_Res_74;
end Discriminant_Assoc_Transform_Parse_0;

   


function Discriminant_Constraint_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Discriminant_Constraint
is
   use Bare_Discriminant_Constraint_Memos;

      Row_Pos_82 :
            Token_Index
               := No_Token_Index;
      Token_Pos_92 :
            Token_Index
               := No_Token_Index;
      Token_Res_92 :
            Token_Index
               := No_Token_Index;
      Lst_Cpos_5 :
            Token_Index
               := No_Token_Index;
      Tmp_List_5 :
            Free_Parse_List;
      Defer_Pos_114 :
            Token_Index
               := No_Token_Index;
      Defer_Res_114 :
            Bare_Discriminant_Assoc
               := No_Bare_Ada_Node;
      Token_Pos_93 :
            Token_Index
               := No_Token_Index;
      Token_Res_93 :
            Token_Index
               := No_Token_Index;
      List_Pos_5 :
            Token_Index
               := No_Token_Index;
      List_Res_5 :
            Bare_Assoc_List
               := No_Bare_Ada_Node;
      Token_Pos_94 :
            Token_Index
               := No_Token_Index;
      Token_Res_94 :
            Token_Index
               := No_Token_Index;
      Transform_Res_73 :
            Bare_Discriminant_Constraint
               := No_Bare_Ada_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Discriminant_Constraint_Transform_Parse_0_Memo, Pos);

begin

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res_73 := M.Instance;
      return Transform_Res_73;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res_73;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code


--  Start row_code

Row_Pos_82 := Pos;



--  Start tok_code

Token_Res_92 := Row_Pos_82;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_92));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Par_Open)
   then
       Token_Pos_92 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_82 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_82,
             Expected_Token_Id => Ada_Par_Open,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_92 := Row_Pos_82 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_92 /= No_Token_Index then

   Row_Pos_82 := Token_Pos_92;

else
   Row_Pos_82 := No_Token_Index;
   goto Exit_Row_65_0;

end if;


--  Start list_code

    List_Pos_5 := No_Token_Index;



Lst_Cpos_5 := Row_Pos_82;
Tmp_List_5 := Get_Parse_List (Parser);

loop
   
Defer_Res_114 :=
   Discriminant_Assoc_Transform_Parse_0 (Parser, Lst_Cpos_5);
Defer_Pos_114 := Parser.Current_Pos;


   exit when Defer_Pos_114 = No_Token_Index;

   List_Pos_5 := Defer_Pos_114;
   Lst_Cpos_5 := List_Pos_5;

   Tmp_List_5.Nodes.Append (Defer_Res_114);

      
--  Start tok_code

Token_Res_93 := Lst_Cpos_5;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_93));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Comma)
   then
       Token_Pos_93 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Lst_Cpos_5 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Lst_Cpos_5,
             Expected_Token_Id => Ada_Comma,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_93 := Lst_Cpos_5 + 1;
   end if;
end;

--  End tok_code

      if Token_Pos_93 /= No_Token_Index then
          Lst_Cpos_5 := Token_Pos_93;
      else
         exit;
      end if;

end loop;

declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List_5.Nodes.Length;
begin
   List_Res_5 :=
      Allocate_Assoc_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Row_Pos_82;
      Token_End := (if Lst_Cpos_5 = Row_Pos_82
                    then Row_Pos_82
                    else Lst_Cpos_5 - 1);

   else
      Token_Start := Token_Index'Max (Row_Pos_82, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res_5,
      Kind              => Ada_Assoc_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res_5,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_Ada_Node_Vectors.Vector renames
         Tmp_List_5.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res_5.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List_5);

--  End list_code



if List_Pos_5 /= No_Token_Index then

   Row_Pos_82 := List_Pos_5;

else
   Row_Pos_82 := No_Token_Index;
   goto Exit_Row_65_0;

end if;


--  Start tok_code

Token_Res_94 := Row_Pos_82;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_94));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Par_Close)
   then
       Token_Pos_94 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_82 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_82,
             Expected_Token_Id => Ada_Par_Close,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_94 := Row_Pos_82 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_94 /= No_Token_Index then

   Row_Pos_82 := Token_Pos_94;

else
   Row_Pos_82 := No_Token_Index;
   goto Exit_Row_65_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_65_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_82 /= No_Token_Index then

   Transform_Res_73 := Allocate_Discriminant_Constraint (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_73,
      Kind => Ada_Discriminant_Constraint,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_82 = Pos
                            then No_Token_Index
                            else Row_Pos_82 - 1));

      Initialize_Fields_For_Discriminant_Constraint
        (Self => Transform_Res_73, Discriminant_Constraint_F_Constraints => List_Res_5);

         if List_Res_5 /= null and then Is_Incomplete (List_Res_5) then
            Transform_Res_73.Last_Attempted_Child := 0;
         elsif List_Res_5 /= null and then not Is_Ghost (List_Res_5) then
            Transform_Res_73.Last_Attempted_Child := -1;
         end if;


end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Discriminant_Constraint_Transform_Parse_0_Memo,
      Row_Pos_82 /= No_Token_Index,
      Transform_Res_73,
      Pos,
      Row_Pos_82);


   Parser.Current_Pos := Row_Pos_82;

   return Transform_Res_73;
end Discriminant_Constraint_Transform_Parse_0;

   


function Discrete_Subtype_Definition_Or_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Ada_Node
is
   use Bare_Ada_Node_Memos;

      Defer_Pos_119 :
            Token_Index
               := No_Token_Index;
      Defer_Res_119 :
            Bare_Expr
               := No_Bare_Ada_Node;
      Defer_Pos_120 :
            Token_Index
               := No_Token_Index;
      Defer_Res_120 :
            Bare_Subtype_Indication
               := No_Bare_Ada_Node;
      Or_Pos_32 :
            Token_Index
               := No_Token_Index;
      Or_Res_32 :
            Bare_Ada_Node
               := No_Bare_Ada_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Discrete_Subtype_Definition_Or_Parse_0_Memo, Pos);

begin

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Or_Res_32 := M.Instance;
      return Or_Res_32;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Or_Res_32;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start or_code

Or_Pos_32 := No_Token_Index;
Or_Res_32 := No_Bare_Ada_Node;
    
Defer_Res_119 :=
   Discrete_Range_Or_Parse_0 (Parser, Pos);
Defer_Pos_119 := Parser.Current_Pos;

    if Defer_Pos_119 /= No_Token_Index then
        Or_Pos_32 := Defer_Pos_119;
        Or_Res_32 := Defer_Res_119;
        goto Exit_Or_27;
    end if;
    
Defer_Res_120 :=
   Subtype_Indication_Transform_Parse_0 (Parser, Pos);
Defer_Pos_120 := Parser.Current_Pos;

    if Defer_Pos_120 /= No_Token_Index then
        Or_Pos_32 := Defer_Pos_120;
        Or_Res_32 := Defer_Res_120;
        goto Exit_Or_27;
    end if;
<<Exit_Or_27>>

--  End or_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Discrete_Subtype_Definition_Or_Parse_0_Memo,
      Or_Pos_32 /= No_Token_Index,
      Or_Res_32,
      Pos,
      Or_Pos_32);


   Parser.Current_Pos := Or_Pos_32;

   return Or_Res_32;
end Discrete_Subtype_Definition_Or_Parse_0;

   


function Constraint_List_List_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Constraint_List
is
   use Bare_Constraint_List_Memos;

      Lst_Cpos_7 :
            Token_Index
               := No_Token_Index;
      Tmp_List_7 :
            Free_Parse_List;
      Defer_Pos_118 :
            Token_Index
               := No_Token_Index;
      Defer_Res_118 :
            Bare_Ada_Node
               := No_Bare_Ada_Node;
      Token_Pos_99 :
            Token_Index
               := No_Token_Index;
      Token_Res_99 :
            Token_Index
               := No_Token_Index;
      List_Pos_7 :
            Token_Index
               := No_Token_Index;
      List_Res_7 :
            Bare_Constraint_List
               := No_Bare_Ada_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Constraint_List_List_Parse_0_Memo, Pos);

begin

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      List_Res_7 := M.Instance;
      return List_Res_7;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return List_Res_7;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start list_code

    List_Pos_7 := No_Token_Index;



Lst_Cpos_7 := Pos;
Tmp_List_7 := Get_Parse_List (Parser);

loop
   
Defer_Res_118 :=
   Discrete_Subtype_Definition_Or_Parse_0 (Parser, Lst_Cpos_7);
Defer_Pos_118 := Parser.Current_Pos;


   exit when Defer_Pos_118 = No_Token_Index;

   List_Pos_7 := Defer_Pos_118;
   Lst_Cpos_7 := List_Pos_7;

   Tmp_List_7.Nodes.Append (Defer_Res_118);

      
--  Start tok_code

Token_Res_99 := Lst_Cpos_7;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_99));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Comma)
   then
       Token_Pos_99 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Lst_Cpos_7 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Lst_Cpos_7,
             Expected_Token_Id => Ada_Comma,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_99 := Lst_Cpos_7 + 1;
   end if;
end;

--  End tok_code

      if Token_Pos_99 /= No_Token_Index then
          Lst_Cpos_7 := Token_Pos_99;
      else
         exit;
      end if;

end loop;

declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List_7.Nodes.Length;
begin
   List_Res_7 :=
      Allocate_Constraint_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Pos;
      Token_End := (if Lst_Cpos_7 = Pos
                    then Pos
                    else Lst_Cpos_7 - 1);

   else
      Token_Start := Token_Index'Max (Pos, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res_7,
      Kind              => Ada_Constraint_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res_7,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_Ada_Node_Vectors.Vector renames
         Tmp_List_7.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res_7.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List_7);

--  End list_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Constraint_List_List_Parse_0_Memo,
      List_Pos_7 /= No_Token_Index,
      List_Res_7,
      Pos,
      List_Pos_7);


   Parser.Current_Pos := List_Pos_7;

   return List_Res_7;
end Constraint_List_List_Parse_0;

   


function Index_Constraint_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Index_Constraint
is
   use Bare_Index_Constraint_Memos;

      Row_Pos_85 :
            Token_Index
               := No_Token_Index;
      Token_Pos_97 :
            Token_Index
               := No_Token_Index;
      Token_Res_97 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_117 :
            Token_Index
               := No_Token_Index;
      Defer_Res_117 :
            Bare_Constraint_List
               := No_Bare_Ada_Node;
      Token_Pos_98 :
            Token_Index
               := No_Token_Index;
      Token_Res_98 :
            Token_Index
               := No_Token_Index;
      Transform_Res_75 :
            Bare_Index_Constraint
               := No_Bare_Ada_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Index_Constraint_Transform_Parse_0_Memo, Pos);

begin

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res_75 := M.Instance;
      return Transform_Res_75;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res_75;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code


--  Start row_code

Row_Pos_85 := Pos;



--  Start tok_code

Token_Res_97 := Row_Pos_85;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_97));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Par_Open)
   then
       Token_Pos_97 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_85 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_85,
             Expected_Token_Id => Ada_Par_Open,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_97 := Row_Pos_85 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_97 /= No_Token_Index then

   Row_Pos_85 := Token_Pos_97;

else
   Row_Pos_85 := No_Token_Index;
   goto Exit_Row_68_0;

end if;


Defer_Res_117 :=
   Constraint_List_List_Parse_0 (Parser, Row_Pos_85);
Defer_Pos_117 := Parser.Current_Pos;



if Defer_Pos_117 /= No_Token_Index then

   Row_Pos_85 := Defer_Pos_117;

else
   Row_Pos_85 := No_Token_Index;
   goto Exit_Row_68_0;

end if;


--  Start tok_code

Token_Res_98 := Row_Pos_85;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_98));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Par_Close)
   then
       Token_Pos_98 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_85 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_85,
             Expected_Token_Id => Ada_Par_Close,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_98 := Row_Pos_85 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_98 /= No_Token_Index then

   Row_Pos_85 := Token_Pos_98;

else
   Row_Pos_85 := No_Token_Index;
   goto Exit_Row_68_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_68_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_85 /= No_Token_Index then

   Transform_Res_75 := Allocate_Index_Constraint (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_75,
      Kind => Ada_Index_Constraint,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_85 = Pos
                            then No_Token_Index
                            else Row_Pos_85 - 1));

      Initialize_Fields_For_Index_Constraint
        (Self => Transform_Res_75, Index_Constraint_F_Constraints => Defer_Res_117);

         if Defer_Res_117 /= null and then Is_Incomplete (Defer_Res_117) then
            Transform_Res_75.Last_Attempted_Child := 0;
         elsif Defer_Res_117 /= null and then not Is_Ghost (Defer_Res_117) then
            Transform_Res_75.Last_Attempted_Child := -1;
         end if;


end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Index_Constraint_Transform_Parse_0_Memo,
      Row_Pos_85 /= No_Token_Index,
      Transform_Res_75,
      Pos,
      Row_Pos_85);


   Parser.Current_Pos := Row_Pos_85;

   return Transform_Res_75;
end Index_Constraint_Transform_Parse_0;

   


function Constraint_Or_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Constraint
is
   use Bare_Constraint_Memos;

      Defer_Pos_102 :
            Token_Index
               := No_Token_Index;
      Defer_Res_102 :
            Bare_Digits_Constraint
               := No_Bare_Ada_Node;
      Defer_Pos_103 :
            Token_Index
               := No_Token_Index;
      Defer_Res_103 :
            Bare_Delta_Constraint
               := No_Bare_Ada_Node;
      Defer_Pos_104 :
            Token_Index
               := No_Token_Index;
      Defer_Res_104 :
            Bare_Range_Constraint
               := No_Bare_Ada_Node;
      Defer_Pos_105 :
            Token_Index
               := No_Token_Index;
      Defer_Res_105 :
            Bare_Discriminant_Constraint
               := No_Bare_Ada_Node;
      Defer_Pos_106 :
            Token_Index
               := No_Token_Index;
      Defer_Res_106 :
            Bare_Index_Constraint
               := No_Bare_Ada_Node;
      Or_Pos_30 :
            Token_Index
               := No_Token_Index;
      Or_Res_30 :
            Bare_Constraint
               := No_Bare_Ada_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Constraint_Or_Parse_0_Memo, Pos);

begin

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Or_Res_30 := M.Instance;
      return Or_Res_30;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Or_Res_30;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start or_code

Or_Pos_30 := No_Token_Index;
Or_Res_30 := No_Bare_Ada_Node;
    
Defer_Res_102 :=
   Digits_Constraint_Transform_Parse_0 (Parser, Pos);
Defer_Pos_102 := Parser.Current_Pos;

    if Defer_Pos_102 /= No_Token_Index then
        Or_Pos_30 := Defer_Pos_102;
        Or_Res_30 := Defer_Res_102;
        goto Exit_Or_25;
    end if;
    
Defer_Res_103 :=
   Delta_Constraint_Transform_Parse_0 (Parser, Pos);
Defer_Pos_103 := Parser.Current_Pos;

    if Defer_Pos_103 /= No_Token_Index then
        Or_Pos_30 := Defer_Pos_103;
        Or_Res_30 := Defer_Res_103;
        goto Exit_Or_25;
    end if;
    
Defer_Res_104 :=
   Range_Constraint_Transform_Parse_1 (Parser, Pos);
Defer_Pos_104 := Parser.Current_Pos;

    if Defer_Pos_104 /= No_Token_Index then
        Or_Pos_30 := Defer_Pos_104;
        Or_Res_30 := Defer_Res_104;
        goto Exit_Or_25;
    end if;
    
Defer_Res_105 :=
   Discriminant_Constraint_Transform_Parse_0 (Parser, Pos);
Defer_Pos_105 := Parser.Current_Pos;

    if Defer_Pos_105 /= No_Token_Index then
        Or_Pos_30 := Defer_Pos_105;
        Or_Res_30 := Defer_Res_105;
        goto Exit_Or_25;
    end if;
    
Defer_Res_106 :=
   Index_Constraint_Transform_Parse_0 (Parser, Pos);
Defer_Pos_106 := Parser.Current_Pos;

    if Defer_Pos_106 /= No_Token_Index then
        Or_Pos_30 := Defer_Pos_106;
        Or_Res_30 := Defer_Res_106;
        goto Exit_Or_25;
    end if;
<<Exit_Or_25>>

--  End or_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Constraint_Or_Parse_0_Memo,
      Or_Pos_30 /= No_Token_Index,
      Or_Res_30,
      Pos,
      Or_Pos_30);


   Parser.Current_Pos := Or_Pos_30;

   return Or_Res_30;
end Constraint_Or_Parse_0;

   


function Subtype_Indication_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Subtype_Indication
is
   use Bare_Subtype_Indication_Memos;

      Row_Pos_76 :
            Token_Index
               := No_Token_Index;
      Row_Pos_77 :
            Token_Index
               := No_Token_Index;
      Token_Pos_86 :
            Token_Index
               := No_Token_Index;
      Token_Res_86 :
            Token_Index
               := No_Token_Index;
      Token_Pos_87 :
            Token_Index
               := No_Token_Index;
      Token_Res_87 :
            Token_Index
               := No_Token_Index;
      Opt_Res_2 :
            Bare_Not_Null
               := No_Bare_Ada_Node;
      Defer_Pos_100 :
            Token_Index
               := No_Token_Index;
      Defer_Res_100 :
            Bare_Name
               := No_Bare_Ada_Node;
      Defer_Pos_101 :
            Token_Index
               := No_Token_Index;
      Defer_Res_101 :
            Bare_Constraint
               := No_Bare_Ada_Node;
      Transform_Res_68 :
            Bare_Subtype_Indication
               := No_Bare_Ada_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Subtype_Indication_Transform_Parse_0_Memo, Pos);

begin

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res_68 := M.Instance;
      return Transform_Res_68;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res_68;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code


--  Start row_code

Row_Pos_76 := Pos;



--  Start opt_code




--  Start row_code

Row_Pos_77 := Row_Pos_76;



--  Start tok_code

Token_Res_86 := Row_Pos_77;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_86));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Not)
   then
       Token_Pos_86 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_77 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_77,
             Expected_Token_Id => Ada_Not,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_86 := Row_Pos_77 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_86 /= No_Token_Index then

   Row_Pos_77 := Token_Pos_86;

else
   Row_Pos_77 := No_Token_Index;
   goto Exit_Row_60_0;

end if;


--  Start tok_code

Token_Res_87 := Row_Pos_77;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_87));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Null)
   then
       Token_Pos_87 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_77 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_77,
             Expected_Token_Id => Ada_Null,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_87 := Row_Pos_77 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_87 /= No_Token_Index then

   Row_Pos_77 := Token_Pos_87;

else
   Row_Pos_77 := No_Token_Index;
   goto Exit_Row_60_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_60_0>>
pragma Warnings (On, "referenced");

--  End row_code


if Row_Pos_77 = No_Token_Index then

         Opt_Res_2 := Allocate_Not_Null_Absent (Parser.Mem_Pool);
         Initialize
           (Self              => Opt_Res_2,
            Kind              => Ada_Not_Null_Absent,
            Unit              => Parser.Unit,
            Token_Start_Index => Row_Pos_76,
            Token_End_Index   => No_Token_Index);


    Row_Pos_77 := Row_Pos_76;

else

      Opt_Res_2 := Allocate_Not_Null_Present (Parser.Mem_Pool);
      Initialize
        (Self              => Opt_Res_2,
         Kind              => Ada_Not_Null_Present,
         Unit              => Parser.Unit,
         Token_Start_Index => Row_Pos_76,
         Token_End_Index   => Row_Pos_77 - 1);

end if;

--  End opt_code



if Row_Pos_77 /= No_Token_Index then

   Row_Pos_76 := Row_Pos_77;

else
   Row_Pos_76 := No_Token_Index;
   goto Exit_Row_59_0;

end if;


Defer_Res_100 :=
   Subtype_Name_Or_Parse_0 (Parser, Row_Pos_76);
Defer_Pos_100 := Parser.Current_Pos;



if Defer_Pos_100 /= No_Token_Index then

   Row_Pos_76 := Defer_Pos_100;

else
   Row_Pos_76 := No_Token_Index;
   goto Exit_Row_59_0;

end if;


--  Start opt_code




Defer_Res_101 :=
   Constraint_Or_Parse_0 (Parser, Row_Pos_76);
Defer_Pos_101 := Parser.Current_Pos;


if Defer_Pos_101 = No_Token_Index then

        Defer_Res_101 := No_Bare_Ada_Node;


    Defer_Pos_101 := Row_Pos_76;


end if;

--  End opt_code



if Defer_Pos_101 /= No_Token_Index then

   Row_Pos_76 := Defer_Pos_101;

else
   Row_Pos_76 := No_Token_Index;
   goto Exit_Row_59_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_59_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_76 /= No_Token_Index then

   Transform_Res_68 := Allocate_Subtype_Indication (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_68,
      Kind => Ada_Subtype_Indication,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_76 = Pos
                            then No_Token_Index
                            else Row_Pos_76 - 1));

      Initialize_Fields_For_Subtype_Indication
        (Self => Transform_Res_68, Subtype_Indication_F_Has_Not_Null => Opt_Res_2, Subtype_Indication_F_Name => Defer_Res_100, Subtype_Indication_F_Constraint => Defer_Res_101);

         if Opt_Res_2 /= null and then Is_Incomplete (Opt_Res_2) then
            Transform_Res_68.Last_Attempted_Child := 0;
         elsif Opt_Res_2 /= null and then not Is_Ghost (Opt_Res_2) then
            Transform_Res_68.Last_Attempted_Child := -1;
         end if;
         if Defer_Res_100 /= null and then Is_Incomplete (Defer_Res_100) then
            Transform_Res_68.Last_Attempted_Child := 0;
         elsif Defer_Res_100 /= null and then not Is_Ghost (Defer_Res_100) then
            Transform_Res_68.Last_Attempted_Child := -1;
         end if;
         if Defer_Res_101 /= null and then Is_Incomplete (Defer_Res_101) then
            Transform_Res_68.Last_Attempted_Child := 0;
         elsif Defer_Res_101 /= null and then not Is_Ghost (Defer_Res_101) then
            Transform_Res_68.Last_Attempted_Child := -1;
         end if;


end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Subtype_Indication_Transform_Parse_0_Memo,
      Row_Pos_76 /= No_Token_Index,
      Transform_Res_68,
      Pos,
      Row_Pos_76);


   Parser.Current_Pos := Row_Pos_76;

   return Transform_Res_68;
end Subtype_Indication_Transform_Parse_0;

   


function For_Loop_Param_Spec_Transform_Parse_3
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_For_Loop_Spec
is
   use Bare_For_Loop_Spec_Memos;

      Row_Pos_70 :
            Token_Index
               := No_Token_Index;
      Row_Pos_71 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_94 :
            Token_Index
               := No_Token_Index;
      Defer_Res_94 :
            Bare_Defining_Name
               := No_Bare_Ada_Node;
      Row_Pos_72 :
            Token_Index
               := No_Token_Index;
      Token_Pos_82 :
            Token_Index
               := No_Token_Index;
      Token_Res_82 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_95 :
            Token_Index
               := No_Token_Index;
      Defer_Res_95 :
            Bare_Subtype_Indication
               := No_Bare_Ada_Node;
      Transform_Res_63 :
            Bare_For_Loop_Var_Decl
               := No_Bare_Ada_Node;
      Row_Pos_73 :
            Token_Index
               := No_Token_Index;
      Token_Pos_83 :
            Token_Index
               := No_Token_Index;
      Token_Res_83 :
            Token_Index
               := No_Token_Index;
      Transform_Res_64 :
            Bare_Iter_Type_In
               := No_Bare_Ada_Node;
      Row_Pos_74 :
            Token_Index
               := No_Token_Index;
      Token_Pos_84 :
            Token_Index
               := No_Token_Index;
      Token_Res_84 :
            Token_Index
               := No_Token_Index;
      Transform_Res_65 :
            Bare_Iter_Type_Of
               := No_Bare_Ada_Node;
      Or_Pos_28 :
            Token_Index
               := No_Token_Index;
      Or_Res_28 :
            Bare_Iter_Type
               := No_Bare_Ada_Node;
      Token_Pos_85 :
            Token_Index
               := No_Token_Index;
      Token_Res_85 :
            Token_Index
               := No_Token_Index;
      Opt_Res_1 :
            Bare_Reverse_Node
               := No_Bare_Ada_Node;
      Defer_Pos_96 :
            Token_Index
               := No_Token_Index;
      Defer_Res_96 :
            Bare_Expr
               := No_Bare_Ada_Node;
      Defer_Pos_97 :
            Token_Index
               := No_Token_Index;
      Defer_Res_97 :
            Bare_Discrete_Subtype_Indication
               := No_Bare_Ada_Node;
      Defer_Pos_98 :
            Token_Index
               := No_Token_Index;
      Defer_Res_98 :
            Bare_Name
               := No_Bare_Ada_Node;
      Or_Pos_29 :
            Token_Index
               := No_Token_Index;
      Or_Res_29 :
            Bare_Ada_Node
               := No_Bare_Ada_Node;
      Transform_Res_66 :
            Bare_For_Loop_Spec
               := No_Bare_Ada_Node;


   M : Memo_Entry := Get (Parser.Private_Part.For_Loop_Param_Spec_Transform_Parse_3_Memo, Pos);

begin

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res_66 := M.Instance;
      return Transform_Res_66;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res_66;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code


--  Start row_code

Row_Pos_70 := Pos;



--  Start transform_code


--  Start row_code

Row_Pos_71 := Row_Pos_70;



Defer_Res_94 :=
   Defining_Id_Transform_Parse_0 (Parser, Row_Pos_71);
Defer_Pos_94 := Parser.Current_Pos;



if Defer_Pos_94 /= No_Token_Index then

   Row_Pos_71 := Defer_Pos_94;

else
   Row_Pos_71 := No_Token_Index;
   goto Exit_Row_56_0;

end if;


--  Start opt_code




--  Start row_code

Row_Pos_72 := Row_Pos_71;



--  Start tok_code

Token_Res_82 := Row_Pos_72;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_82));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Colon)
   then
       Token_Pos_82 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_72 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_72,
             Expected_Token_Id => Ada_Colon,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_82 := Row_Pos_72 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_82 /= No_Token_Index then

   Row_Pos_72 := Token_Pos_82;

else
   Row_Pos_72 := No_Token_Index;
   goto Exit_Row_58_0;

end if;


Defer_Res_95 :=
   Subtype_Indication_Transform_Parse_0 (Parser, Row_Pos_72);
Defer_Pos_95 := Parser.Current_Pos;



if Defer_Pos_95 /= No_Token_Index then

   Row_Pos_72 := Defer_Pos_95;

else
   Row_Pos_72 := No_Token_Index;
   goto Exit_Row_58_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_58_0>>
pragma Warnings (On, "referenced");

--  End row_code


if Row_Pos_72 = No_Token_Index then

        Defer_Res_95 := No_Bare_Ada_Node;


    Row_Pos_72 := Row_Pos_71;


end if;

--  End opt_code



if Row_Pos_72 /= No_Token_Index then

   Row_Pos_71 := Row_Pos_72;

else
   Row_Pos_71 := No_Token_Index;
   goto Exit_Row_56_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_56_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_71 /= No_Token_Index then

   Transform_Res_63 := Allocate_For_Loop_Var_Decl (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_63,
      Kind => Ada_For_Loop_Var_Decl,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos_70,
      Token_End_Index   => (if Row_Pos_71 = Row_Pos_70
                            then No_Token_Index
                            else Row_Pos_71 - 1));

      Initialize_Fields_For_For_Loop_Var_Decl
        (Self => Transform_Res_63, For_Loop_Var_Decl_F_Id => Defer_Res_94, For_Loop_Var_Decl_F_Id_Type => Defer_Res_95);

         if Defer_Res_94 /= null and then Is_Incomplete (Defer_Res_94) then
            Transform_Res_63.Last_Attempted_Child := 0;
         elsif Defer_Res_94 /= null and then not Is_Ghost (Defer_Res_94) then
            Transform_Res_63.Last_Attempted_Child := -1;
         end if;
         if Defer_Res_95 /= null and then Is_Incomplete (Defer_Res_95) then
            Transform_Res_63.Last_Attempted_Child := 0;
         elsif Defer_Res_95 /= null and then not Is_Ghost (Defer_Res_95) then
            Transform_Res_63.Last_Attempted_Child := -1;
         end if;


end if;

--  End transform_code



if Row_Pos_71 /= No_Token_Index then

   Row_Pos_70 := Row_Pos_71;

else
   Row_Pos_70 := No_Token_Index;
   goto Exit_Row_55_0;

end if;


--  Start or_code

Or_Pos_28 := No_Token_Index;
Or_Res_28 := No_Bare_Ada_Node;
    
--  Start transform_code


--  Start row_code

Row_Pos_73 := Row_Pos_70;



--  Start tok_code

Token_Res_83 := Row_Pos_73;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_83));
begin
   if
      T.Kind /= From_Token_Kind (Ada_In)
   then
       Token_Pos_83 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_73 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_73,
             Expected_Token_Id => Ada_In,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_83 := Row_Pos_73 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_83 /= No_Token_Index then

   Row_Pos_73 := Token_Pos_83;

else
   Row_Pos_73 := No_Token_Index;
   goto Exit_Row_69_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_69_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_73 /= No_Token_Index then

   Transform_Res_64 := Allocate_Iter_Type_In (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_64,
      Kind => Ada_Iter_Type_In,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos_70,
      Token_End_Index   => (if Row_Pos_73 = Row_Pos_70
                            then No_Token_Index
                            else Row_Pos_73 - 1));




end if;

--  End transform_code

    if Row_Pos_73 /= No_Token_Index then
        Or_Pos_28 := Row_Pos_73;
        Or_Res_28 := Transform_Res_64;
        goto Exit_Or_28;
    end if;
    
--  Start transform_code


--  Start row_code

Row_Pos_74 := Row_Pos_70;



--  Start tok_code

Token_Res_84 := Row_Pos_74;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_84));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Of)
   then
       Token_Pos_84 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_74 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_74,
             Expected_Token_Id => Ada_Of,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_84 := Row_Pos_74 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_84 /= No_Token_Index then

   Row_Pos_74 := Token_Pos_84;

else
   Row_Pos_74 := No_Token_Index;
   goto Exit_Row_70_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_70_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_74 /= No_Token_Index then

   Transform_Res_65 := Allocate_Iter_Type_Of (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_65,
      Kind => Ada_Iter_Type_Of,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos_70,
      Token_End_Index   => (if Row_Pos_74 = Row_Pos_70
                            then No_Token_Index
                            else Row_Pos_74 - 1));




end if;

--  End transform_code

    if Row_Pos_74 /= No_Token_Index then
        Or_Pos_28 := Row_Pos_74;
        Or_Res_28 := Transform_Res_65;
        goto Exit_Or_28;
    end if;
<<Exit_Or_28>>

--  End or_code



if Or_Pos_28 /= No_Token_Index then

   Row_Pos_70 := Or_Pos_28;

else
   Row_Pos_70 := No_Token_Index;
   goto Exit_Row_55_0;

end if;


--  Start opt_code




--  Start tok_code

Token_Res_85 := Row_Pos_70;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_85));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Reverse)
   then
       Token_Pos_85 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_70 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_70,
             Expected_Token_Id => Ada_Reverse,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_85 := Row_Pos_70 + 1;
   end if;
end;

--  End tok_code


if Token_Pos_85 = No_Token_Index then

         Opt_Res_1 := Allocate_Reverse_Absent (Parser.Mem_Pool);
         Initialize
           (Self              => Opt_Res_1,
            Kind              => Ada_Reverse_Absent,
            Unit              => Parser.Unit,
            Token_Start_Index => Row_Pos_70,
            Token_End_Index   => No_Token_Index);


    Token_Pos_85 := Row_Pos_70;

else

      Opt_Res_1 := Allocate_Reverse_Present (Parser.Mem_Pool);
      Initialize
        (Self              => Opt_Res_1,
         Kind              => Ada_Reverse_Present,
         Unit              => Parser.Unit,
         Token_Start_Index => Row_Pos_70,
         Token_End_Index   => Token_Pos_85 - 1);

end if;

--  End opt_code



if Token_Pos_85 /= No_Token_Index then

   Row_Pos_70 := Token_Pos_85;

else
   Row_Pos_70 := No_Token_Index;
   goto Exit_Row_55_0;

end if;


--  Start or_code

Or_Pos_29 := No_Token_Index;
Or_Res_29 := No_Bare_Ada_Node;
    
Defer_Res_96 :=
   Discrete_Range_Or_Parse_0 (Parser, Row_Pos_70);
Defer_Pos_96 := Parser.Current_Pos;

    if Defer_Pos_96 /= No_Token_Index then
        Or_Pos_29 := Defer_Pos_96;
        Or_Res_29 := Defer_Res_96;
        goto Exit_Or_29;
    end if;
    
Defer_Res_97 :=
   Discrete_Subtype_Indication_Transform_Parse_0 (Parser, Row_Pos_70);
Defer_Pos_97 := Parser.Current_Pos;

    if Defer_Pos_97 /= No_Token_Index then
        Or_Pos_29 := Defer_Pos_97;
        Or_Res_29 := Defer_Res_97;
        goto Exit_Or_29;
    end if;
    
Defer_Res_98 :=
   Name_Or_Parse_1 (Parser, Row_Pos_70);
Defer_Pos_98 := Parser.Current_Pos;

    if Defer_Pos_98 /= No_Token_Index then
        Or_Pos_29 := Defer_Pos_98;
        Or_Res_29 := Defer_Res_98;
        goto Exit_Or_29;
    end if;
<<Exit_Or_29>>

--  End or_code



if Or_Pos_29 /= No_Token_Index then

   Row_Pos_70 := Or_Pos_29;

else
   Row_Pos_70 := No_Token_Index;
   goto Exit_Row_55_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_55_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_70 /= No_Token_Index then

   Transform_Res_66 := Allocate_For_Loop_Spec (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_66,
      Kind => Ada_For_Loop_Spec,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_70 = Pos
                            then No_Token_Index
                            else Row_Pos_70 - 1));

      Initialize_Fields_For_For_Loop_Spec
        (Self => Transform_Res_66, For_Loop_Spec_F_Var_Decl => Transform_Res_63, For_Loop_Spec_F_Loop_Type => Or_Res_28, For_Loop_Spec_F_Has_Reverse => Opt_Res_1, For_Loop_Spec_F_Iter_Expr => Or_Res_29);

         if Transform_Res_63 /= null and then Is_Incomplete (Transform_Res_63) then
            Transform_Res_66.Last_Attempted_Child := 0;
         elsif Transform_Res_63 /= null and then not Is_Ghost (Transform_Res_63) then
            Transform_Res_66.Last_Attempted_Child := -1;
         end if;
         if Or_Res_28 /= null and then Is_Incomplete (Or_Res_28) then
            Transform_Res_66.Last_Attempted_Child := 0;
         elsif Or_Res_28 /= null and then not Is_Ghost (Or_Res_28) then
            Transform_Res_66.Last_Attempted_Child := -1;
         end if;
         if Opt_Res_1 /= null and then Is_Incomplete (Opt_Res_1) then
            Transform_Res_66.Last_Attempted_Child := 0;
         elsif Opt_Res_1 /= null and then not Is_Ghost (Opt_Res_1) then
            Transform_Res_66.Last_Attempted_Child := -1;
         end if;
         if Or_Res_29 /= null and then Is_Incomplete (Or_Res_29) then
            Transform_Res_66.Last_Attempted_Child := 0;
         elsif Or_Res_29 /= null and then not Is_Ghost (Or_Res_29) then
            Transform_Res_66.Last_Attempted_Child := -1;
         end if;


end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.For_Loop_Param_Spec_Transform_Parse_3_Memo,
      Row_Pos_70 /= No_Token_Index,
      Transform_Res_66,
      Pos,
      Row_Pos_70);


   Parser.Current_Pos := Row_Pos_70;

   return Transform_Res_66;
end For_Loop_Param_Spec_Transform_Parse_3;

   


function Others_Designator_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Others_Designator
is
   use Bare_Others_Designator_Memos;

      Row_Pos_86 :
            Token_Index
               := No_Token_Index;
      Token_Pos_101 :
            Token_Index
               := No_Token_Index;
      Token_Res_101 :
            Token_Index
               := No_Token_Index;
      Transform_Res_76 :
            Bare_Others_Designator
               := No_Bare_Ada_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Others_Designator_Transform_Parse_0_Memo, Pos);

begin

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res_76 := M.Instance;
      return Transform_Res_76;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res_76;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code


--  Start row_code

Row_Pos_86 := Pos;



--  Start tok_code

Token_Res_101 := Row_Pos_86;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_101));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Others)
   then
       Token_Pos_101 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_86 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_86,
             Expected_Token_Id => Ada_Others,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_101 := Row_Pos_86 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_101 /= No_Token_Index then

   Row_Pos_86 := Token_Pos_101;

else
   Row_Pos_86 := No_Token_Index;
   goto Exit_Row_73_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_73_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_86 /= No_Token_Index then

   Transform_Res_76 := Allocate_Others_Designator (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_76,
      Kind => Ada_Others_Designator,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_86 = Pos
                            then No_Token_Index
                            else Row_Pos_86 - 1));




end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Others_Designator_Transform_Parse_0_Memo,
      Row_Pos_86 /= No_Token_Index,
      Transform_Res_76,
      Pos,
      Row_Pos_86);


   Parser.Current_Pos := Row_Pos_86;

   return Transform_Res_76;
end Others_Designator_Transform_Parse_0;

   


function Choice_Or_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Ada_Node
is
   use Bare_Ada_Node_Memos;

      Defer_Pos_122 :
            Token_Index
               := No_Token_Index;
      Defer_Res_122 :
            Bare_Expr
               := No_Bare_Ada_Node;
      Defer_Pos_123 :
            Token_Index
               := No_Token_Index;
      Defer_Res_123 :
            Bare_Discrete_Subtype_Indication
               := No_Bare_Ada_Node;
      Defer_Pos_124 :
            Token_Index
               := No_Token_Index;
      Defer_Res_124 :
            Bare_Expr
               := No_Bare_Ada_Node;
      Defer_Pos_125 :
            Token_Index
               := No_Token_Index;
      Defer_Res_125 :
            Bare_Others_Designator
               := No_Bare_Ada_Node;
      Or_Pos_33 :
            Token_Index
               := No_Token_Index;
      Or_Res_33 :
            Bare_Ada_Node
               := No_Bare_Ada_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Choice_Or_Parse_0_Memo, Pos);

begin

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Or_Res_33 := M.Instance;
      return Or_Res_33;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Or_Res_33;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start or_code

Or_Pos_33 := No_Token_Index;
Or_Res_33 := No_Bare_Ada_Node;
    
Defer_Res_122 :=
   Discrete_Range_Or_Parse_0 (Parser, Pos);
Defer_Pos_122 := Parser.Current_Pos;

    if Defer_Pos_122 /= No_Token_Index then
        Or_Pos_33 := Defer_Pos_122;
        Or_Res_33 := Defer_Res_122;
        goto Exit_Or_31;
    end if;
    
Defer_Res_123 :=
   Discrete_Subtype_Indication_Transform_Parse_0 (Parser, Pos);
Defer_Pos_123 := Parser.Current_Pos;

    if Defer_Pos_123 /= No_Token_Index then
        Or_Pos_33 := Defer_Pos_123;
        Or_Res_33 := Defer_Res_123;
        goto Exit_Or_31;
    end if;
    
Defer_Res_124 :=
   Expr_Or_Parse_0 (Parser, Pos);
Defer_Pos_124 := Parser.Current_Pos;

    if Defer_Pos_124 /= No_Token_Index then
        Or_Pos_33 := Defer_Pos_124;
        Or_Res_33 := Defer_Res_124;
        goto Exit_Or_31;
    end if;
    
Defer_Res_125 :=
   Others_Designator_Transform_Parse_0 (Parser, Pos);
Defer_Pos_125 := Parser.Current_Pos;

    if Defer_Pos_125 /= No_Token_Index then
        Or_Pos_33 := Defer_Pos_125;
        Or_Res_33 := Defer_Res_125;
        goto Exit_Or_31;
    end if;
<<Exit_Or_31>>

--  End or_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Choice_Or_Parse_0_Memo,
      Or_Pos_33 /= No_Token_Index,
      Or_Res_33,
      Pos,
      Or_Pos_33);


   Parser.Current_Pos := Or_Pos_33;

   return Or_Res_33;
end Choice_Or_Parse_0;

   


function Choice_List_List_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Alternatives_List
is
   use Bare_Alternatives_List_Memos;

      Lst_Cpos_8 :
            Token_Index
               := No_Token_Index;
      Tmp_List_8 :
            Free_Parse_List;
      Defer_Pos_121 :
            Token_Index
               := No_Token_Index;
      Defer_Res_121 :
            Bare_Ada_Node
               := No_Bare_Ada_Node;
      Token_Pos_100 :
            Token_Index
               := No_Token_Index;
      Token_Res_100 :
            Token_Index
               := No_Token_Index;
      List_Pos_8 :
            Token_Index
               := No_Token_Index;
      List_Res_8 :
            Bare_Alternatives_List
               := No_Bare_Ada_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Choice_List_List_Parse_0_Memo, Pos);

begin

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      List_Res_8 := M.Instance;
      return List_Res_8;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return List_Res_8;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start list_code

    List_Pos_8 := No_Token_Index;



Lst_Cpos_8 := Pos;
Tmp_List_8 := Get_Parse_List (Parser);

loop
   
Defer_Res_121 :=
   Choice_Or_Parse_0 (Parser, Lst_Cpos_8);
Defer_Pos_121 := Parser.Current_Pos;


   exit when Defer_Pos_121 = No_Token_Index;

   List_Pos_8 := Defer_Pos_121;
   Lst_Cpos_8 := List_Pos_8;

   Tmp_List_8.Nodes.Append (Defer_Res_121);

      
--  Start tok_code

Token_Res_100 := Lst_Cpos_8;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_100));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Pipe)
   then
       Token_Pos_100 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Lst_Cpos_8 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Lst_Cpos_8,
             Expected_Token_Id => Ada_Pipe,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_100 := Lst_Cpos_8 + 1;
   end if;
end;

--  End tok_code

      if Token_Pos_100 /= No_Token_Index then
          Lst_Cpos_8 := Token_Pos_100;
      else
         exit;
      end if;

end loop;

declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List_8.Nodes.Length;
begin
   List_Res_8 :=
      Allocate_Alternatives_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Pos;
      Token_End := (if Lst_Cpos_8 = Pos
                    then Pos
                    else Lst_Cpos_8 - 1);

   else
      Token_Start := Token_Index'Max (Pos, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res_8,
      Kind              => Ada_Alternatives_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res_8,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_Ada_Node_Vectors.Vector renames
         Tmp_List_8.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res_8.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List_8);

--  End list_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Choice_List_List_Parse_0_Memo,
      List_Pos_8 /= No_Token_Index,
      List_Res_8,
      Pos,
      List_Pos_8);


   Parser.Current_Pos := List_Pos_8;

   return List_Res_8;
end Choice_List_List_Parse_0;

   


function Aggregate_Assoc_Or_Parse_2
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Basic_Assoc
is
   use Bare_Basic_Assoc_Memos;

      Nobt_11 :
            Boolean
               := False;
      Row_Pos_67 :
            Token_Index
               := No_Token_Index;
      Token_Pos_79 :
            Token_Index
               := No_Token_Index;
      Token_Res_79 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_88 :
            Token_Index
               := No_Token_Index;
      Defer_Res_88 :
            Bare_For_Loop_Spec
               := No_Bare_Ada_Node;
      Token_Pos_80 :
            Token_Index
               := No_Token_Index;
      Token_Res_80 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_89 :
            Token_Index
               := No_Token_Index;
      Defer_Res_89 :
            Bare_Expr
               := No_Bare_Ada_Node;
      Defer_Pos_90 :
            Token_Index
               := No_Token_Index;
      Defer_Res_90 :
            Bare_Expr
               := No_Bare_Ada_Node;
      Or_Pos_25 :
            Token_Index
               := No_Token_Index;
      Or_Res_25 :
            Bare_Expr
               := No_Bare_Ada_Node;
      Row_Progress_11 :
            Integer
               := 0;
      Transform_Res_61 :
            Bare_Iterated_Assoc
               := No_Bare_Ada_Node;
      Transform_Has_Failed_11 :
            Boolean
               := False;
      Row_Pos_68 :
            Token_Index
               := No_Token_Index;
      Row_Pos_69 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_91 :
            Token_Index
               := No_Token_Index;
      Defer_Res_91 :
            Bare_Alternatives_List
               := No_Bare_Ada_Node;
      Token_Pos_81 :
            Token_Index
               := No_Token_Index;
      Token_Res_81 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_92 :
            Token_Index
               := No_Token_Index;
      Defer_Res_92 :
            Bare_Box_Expr
               := No_Bare_Ada_Node;
      Defer_Pos_93 :
            Token_Index
               := No_Token_Index;
      Defer_Res_93 :
            Bare_Expr
               := No_Bare_Ada_Node;
      Or_Pos_26 :
            Token_Index
               := No_Token_Index;
      Or_Res_26 :
            Bare_Expr
               := No_Bare_Ada_Node;
      Transform_Res_62 :
            Bare_Aggregate_Assoc
               := No_Bare_Ada_Node;
      Or_Pos_27 :
            Token_Index
               := No_Token_Index;
      Or_Res_27 :
            Bare_Basic_Assoc
               := No_Bare_Ada_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Aggregate_Assoc_Or_Parse_2_Memo, Pos);

begin

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Or_Res_27 := M.Instance;
      return Or_Res_27;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Or_Res_27;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start or_code

Or_Pos_27 := No_Token_Index;
Or_Res_27 := No_Bare_Ada_Node;
    
--  Start transform_code


--  Start row_code

Row_Pos_67 := Pos;



--  Start tok_code

Token_Res_79 := Row_Pos_67;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_79));
begin
   if
      T.Kind /= From_Token_Kind (Ada_For)
   then
       Token_Pos_79 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_67 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_67,
             Expected_Token_Id => Ada_For,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_79 := Row_Pos_67 + 1;
   end if;
end;

--  End tok_code


Row_Progress_11 := 1;

if Token_Pos_79 /= No_Token_Index then

   Row_Pos_67 := Token_Pos_79;

else
   Row_Pos_67 := No_Token_Index;
   goto Exit_Row_54_0;

end if;

Nobt_11 := True;

Row_Progress_11 := 2;

if Row_Pos_67 /= No_Token_Index then

   Row_Pos_67 := Row_Pos_67;

else
   Row_Pos_67 := No_Token_Index;
   goto Exit_Row_54_0;

end if;


Defer_Res_88 :=
   For_Loop_Param_Spec_Transform_Parse_3 (Parser, Row_Pos_67);
Defer_Pos_88 := Parser.Current_Pos;


Row_Progress_11 := 3;

if Defer_Pos_88 /= No_Token_Index then

   Row_Pos_67 := Defer_Pos_88;

else
   Row_Pos_67 := No_Token_Index;
   goto Exit_Row_54_0;

end if;


--  Start tok_code

Token_Res_80 := Row_Pos_67;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_80));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Arrow)
   then
       Token_Pos_80 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_67 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_67,
             Expected_Token_Id => Ada_Arrow,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_80 := Row_Pos_67 + 1;
   end if;
end;

--  End tok_code


Row_Progress_11 := 4;

if Token_Pos_80 /= No_Token_Index then

   Row_Pos_67 := Token_Pos_80;

else
   Row_Pos_67 := No_Token_Index;
   goto Exit_Row_54_0;

end if;


--  Start or_code

Or_Pos_25 := No_Token_Index;
Or_Res_25 := No_Bare_Ada_Node;
    
Defer_Res_89 :=
   Expr_Or_Parse_0 (Parser, Row_Pos_67);
Defer_Pos_89 := Parser.Current_Pos;

    if Defer_Pos_89 /= No_Token_Index then
        Or_Pos_25 := Defer_Pos_89;
        Or_Res_25 := Defer_Res_89;
        goto Exit_Or_30;
    end if;
    
Defer_Res_90 :=
   Discrete_Range_Or_Parse_0 (Parser, Row_Pos_67);
Defer_Pos_90 := Parser.Current_Pos;

    if Defer_Pos_90 /= No_Token_Index then
        Or_Pos_25 := Defer_Pos_90;
        Or_Res_25 := Defer_Res_90;
        goto Exit_Or_30;
    end if;
<<Exit_Or_30>>

--  End or_code


Row_Progress_11 := 5;

if Or_Pos_25 /= No_Token_Index then

   Row_Pos_67 := Or_Pos_25;

else
   Row_Pos_67 := No_Token_Index;
   goto Exit_Row_54_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_54_0>>
pragma Warnings (On, "referenced");

--  End row_code


if Row_Pos_67 = No_Token_Index and then Nobt_11 then
   Row_Pos_67 := Parser.Last_Fail.Pos;
   Transform_Has_Failed_11 := True;
end if;

if Row_Pos_67 /= No_Token_Index then

   Transform_Res_61 := Allocate_Iterated_Assoc (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_61,
      Kind => Ada_Iterated_Assoc,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_67 = Pos
                            then No_Token_Index
                            else Row_Pos_67 - 1));

      Initialize_Fields_For_Iterated_Assoc
        (Self => Transform_Res_61, Iterated_Assoc_F_Spec => Defer_Res_88, Iterated_Assoc_F_R_Expr => Or_Res_25);

         if Defer_Res_88 /= null and then Is_Incomplete (Defer_Res_88) then
            Transform_Res_61.Last_Attempted_Child := 0;
         elsif Defer_Res_88 /= null and then not Is_Ghost (Defer_Res_88) then
            Transform_Res_61.Last_Attempted_Child := -1;
         end if;
         if Or_Res_25 /= null and then Is_Incomplete (Or_Res_25) then
            Transform_Res_61.Last_Attempted_Child := 0;
         elsif Or_Res_25 /= null and then not Is_Ghost (Or_Res_25) then
            Transform_Res_61.Last_Attempted_Child := -1;
         end if;

   if Transform_Has_Failed_11 then
      Transform_Res_61.Last_Attempted_Child :=
         Row_Progress_11;

      Append (Parser.Diagnostics,
              Sloc_Range (Parser.TDH.all,
                          Get_Token (Parser.TDH.all, Pos)),
              To_Text ("Cannot parse <aggregate_assoc>"));

      Add_Last_Fail_Diagnostic (Parser);
   end if;

end if;

--  End transform_code

    if Row_Pos_67 /= No_Token_Index then
        Or_Pos_27 := Row_Pos_67;
        Or_Res_27 := Transform_Res_61;
        goto Exit_Or_24;
    end if;
    
--  Start transform_code


--  Start row_code

Row_Pos_68 := Pos;



--  Start opt_code




--  Start row_code

Row_Pos_69 := Row_Pos_68;



Defer_Res_91 :=
   Choice_List_List_Parse_0 (Parser, Row_Pos_69);
Defer_Pos_91 := Parser.Current_Pos;



if Defer_Pos_91 /= No_Token_Index then

   Row_Pos_69 := Defer_Pos_91;

else
   Row_Pos_69 := No_Token_Index;
   goto Exit_Row_72_0;

end if;


--  Start tok_code

Token_Res_81 := Row_Pos_69;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_81));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Arrow)
   then
       Token_Pos_81 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_69 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_69,
             Expected_Token_Id => Ada_Arrow,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_81 := Row_Pos_69 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_81 /= No_Token_Index then

   Row_Pos_69 := Token_Pos_81;

else
   Row_Pos_69 := No_Token_Index;
   goto Exit_Row_72_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_72_0>>
pragma Warnings (On, "referenced");

--  End row_code


if Row_Pos_69 = No_Token_Index then

        Defer_Res_91 :=
           Allocate_Alternatives_List (Parser.Mem_Pool);
         Initialize
           (Self              => Defer_Res_91,
            Kind              => Ada_Alternatives_List,
            Unit              => Parser.Unit,
            Token_Start_Index => Row_Pos_68 - 1,
            Token_End_Index   => No_Token_Index);
         Initialize_List
           (Self   => Defer_Res_91,
            Parser => Parser,
            Count  => 0);


    Row_Pos_69 := Row_Pos_68;


end if;

--  End opt_code



if Row_Pos_69 /= No_Token_Index then

   Row_Pos_68 := Row_Pos_69;

else
   Row_Pos_68 := No_Token_Index;
   goto Exit_Row_71_0;

end if;


--  Start or_code

Or_Pos_26 := No_Token_Index;
Or_Res_26 := No_Bare_Ada_Node;
    
Defer_Res_92 :=
   Box_Expr_Transform_Parse_0 (Parser, Row_Pos_68);
Defer_Pos_92 := Parser.Current_Pos;

    if Defer_Pos_92 /= No_Token_Index then
        Or_Pos_26 := Defer_Pos_92;
        Or_Res_26 := Defer_Res_92;
        goto Exit_Or_32;
    end if;
    
Defer_Res_93 :=
   Expr_Or_Parse_0 (Parser, Row_Pos_68);
Defer_Pos_93 := Parser.Current_Pos;

    if Defer_Pos_93 /= No_Token_Index then
        Or_Pos_26 := Defer_Pos_93;
        Or_Res_26 := Defer_Res_93;
        goto Exit_Or_32;
    end if;
<<Exit_Or_32>>

--  End or_code



if Or_Pos_26 /= No_Token_Index then

   Row_Pos_68 := Or_Pos_26;

else
   Row_Pos_68 := No_Token_Index;
   goto Exit_Row_71_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_71_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_68 /= No_Token_Index then

   Transform_Res_62 := Allocate_Aggregate_Assoc (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_62,
      Kind => Ada_Aggregate_Assoc,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_68 = Pos
                            then No_Token_Index
                            else Row_Pos_68 - 1));

      Initialize_Fields_For_Aggregate_Assoc
        (Self => Transform_Res_62, Aggregate_Assoc_F_Designators => Defer_Res_91, Aggregate_Assoc_F_R_Expr => Or_Res_26);

         if Defer_Res_91 /= null and then Is_Incomplete (Defer_Res_91) then
            Transform_Res_62.Last_Attempted_Child := 0;
         elsif Defer_Res_91 /= null and then not Is_Ghost (Defer_Res_91) then
            Transform_Res_62.Last_Attempted_Child := -1;
         end if;
         if Or_Res_26 /= null and then Is_Incomplete (Or_Res_26) then
            Transform_Res_62.Last_Attempted_Child := 0;
         elsif Or_Res_26 /= null and then not Is_Ghost (Or_Res_26) then
            Transform_Res_62.Last_Attempted_Child := -1;
         end if;


end if;

--  End transform_code

    if Row_Pos_68 /= No_Token_Index then
        Or_Pos_27 := Row_Pos_68;
        Or_Res_27 := Transform_Res_62;
        goto Exit_Or_24;
    end if;
<<Exit_Or_24>>

--  End or_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Aggregate_Assoc_Or_Parse_2_Memo,
      Or_Pos_27 /= No_Token_Index,
      Or_Res_27,
      Pos,
      Or_Pos_27);


   Parser.Current_Pos := Or_Pos_27;

   return Or_Res_27;
end Aggregate_Assoc_Or_Parse_2;

   


function Regular_Aggregate_Or_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Base_Aggregate
is
   use Bare_Base_Aggregate_Memos;

      Nobt_9 :
            Boolean
               := False;
      Nobt_10 :
            Boolean
               := False;
      Row_Pos_62 :
            Token_Index
               := No_Token_Index;
      Token_Pos_65 :
            Token_Index
               := No_Token_Index;
      Token_Res_65 :
            Token_Index
               := No_Token_Index;
      Row_Pos_63 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_83 :
            Token_Index
               := No_Token_Index;
      Defer_Res_83 :
            Bare_Expr
               := No_Bare_Ada_Node;
      Token_Pos_66 :
            Token_Index
               := No_Token_Index;
      Token_Res_66 :
            Token_Index
               := No_Token_Index;
      Token_Pos_67 :
            Token_Index
               := No_Token_Index;
      Token_Res_67 :
            Token_Index
               := No_Token_Index;
      Token_Pos_68 :
            Token_Index
               := No_Token_Index;
      Token_Res_68 :
            Token_Index
               := No_Token_Index;
      Null_Res_2 :
            Bare_Assoc_List
               := No_Bare_Ada_Node;
      Token_Pos_69 :
            Token_Index
               := No_Token_Index;
      Token_Res_69 :
            Token_Index
               := No_Token_Index;
      Transform_Res_58 :
            Bare_Null_Record_Aggregate
               := No_Bare_Ada_Node;
      Row_Pos_64 :
            Token_Index
               := No_Token_Index;
      Token_Pos_70 :
            Token_Index
               := No_Token_Index;
      Token_Res_70 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_84 :
            Token_Index
               := No_Token_Index;
      Defer_Res_84 :
            Bare_Expr
               := No_Bare_Ada_Node;
      Token_Pos_71 :
            Token_Index
               := No_Token_Index;
      Token_Res_71 :
            Token_Index
               := No_Token_Index;
      Token_Pos_72 :
            Token_Index
               := No_Token_Index;
      Token_Res_72 :
            Token_Index
               := No_Token_Index;
      Lst_Cpos_3 :
            Token_Index
               := No_Token_Index;
      Tmp_List_3 :
            Free_Parse_List;
      Defer_Pos_85 :
            Token_Index
               := No_Token_Index;
      Defer_Res_85 :
            Bare_Basic_Assoc
               := No_Bare_Ada_Node;
      Token_Pos_73 :
            Token_Index
               := No_Token_Index;
      Token_Res_73 :
            Token_Index
               := No_Token_Index;
      List_Pos_3 :
            Token_Index
               := No_Token_Index;
      List_Res_3 :
            Bare_Assoc_List
               := No_Bare_Ada_Node;
      Token_Pos_74 :
            Token_Index
               := No_Token_Index;
      Token_Res_74 :
            Token_Index
               := No_Token_Index;
      Row_Progress_9 :
            Integer
               := 0;
      Transform_Res_59 :
            Bare_Delta_Aggregate
               := No_Bare_Ada_Node;
      Transform_Has_Failed_9 :
            Boolean
               := False;
      Row_Pos_65 :
            Token_Index
               := No_Token_Index;
      Token_Pos_75 :
            Token_Index
               := No_Token_Index;
      Token_Res_75 :
            Token_Index
               := No_Token_Index;
      Row_Pos_66 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_86 :
            Token_Index
               := No_Token_Index;
      Defer_Res_86 :
            Bare_Expr
               := No_Bare_Ada_Node;
      Token_Pos_76 :
            Token_Index
               := No_Token_Index;
      Token_Res_76 :
            Token_Index
               := No_Token_Index;
      Lst_Cpos_4 :
            Token_Index
               := No_Token_Index;
      Tmp_List_4 :
            Free_Parse_List;
      Defer_Pos_87 :
            Token_Index
               := No_Token_Index;
      Defer_Res_87 :
            Bare_Basic_Assoc
               := No_Bare_Ada_Node;
      Token_Pos_77 :
            Token_Index
               := No_Token_Index;
      Token_Res_77 :
            Token_Index
               := No_Token_Index;
      List_Pos_4 :
            Token_Index
               := No_Token_Index;
      List_Res_4 :
            Bare_Assoc_List
               := No_Bare_Ada_Node;
      Token_Pos_78 :
            Token_Index
               := No_Token_Index;
      Token_Res_78 :
            Token_Index
               := No_Token_Index;
      Row_Progress_10 :
            Integer
               := 0;
      Transform_Res_60 :
            Bare_Aggregate
               := No_Bare_Ada_Node;
      Transform_Has_Failed_10 :
            Boolean
               := False;
      Or_Pos_24 :
            Token_Index
               := No_Token_Index;
      Or_Res_24 :
            Bare_Base_Aggregate
               := No_Bare_Ada_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Regular_Aggregate_Or_Parse_0_Memo, Pos);

begin

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Or_Res_24 := M.Instance;
      return Or_Res_24;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Or_Res_24;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start or_code

Or_Pos_24 := No_Token_Index;
Or_Res_24 := No_Bare_Ada_Node;
    
--  Start transform_code


--  Start row_code

Row_Pos_62 := Pos;



--  Start tok_code

Token_Res_65 := Row_Pos_62;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_65));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Par_Open)
   then
       Token_Pos_65 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_62 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_62,
             Expected_Token_Id => Ada_Par_Open,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_65 := Row_Pos_62 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_65 /= No_Token_Index then

   Row_Pos_62 := Token_Pos_65;

else
   Row_Pos_62 := No_Token_Index;
   goto Exit_Row_51_0;

end if;


--  Start opt_code




--  Start row_code

Row_Pos_63 := Row_Pos_62;



Defer_Res_83 :=
   Expr_Or_Parse_0 (Parser, Row_Pos_63);
Defer_Pos_83 := Parser.Current_Pos;



if Defer_Pos_83 /= No_Token_Index then

   Row_Pos_63 := Defer_Pos_83;

else
   Row_Pos_63 := No_Token_Index;
   goto Exit_Row_52_0;

end if;


--  Start tok_code

Token_Res_66 := Row_Pos_63;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_66));
begin
   if
      T.Kind /= From_Token_Kind (Ada_With)
   then
       Token_Pos_66 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_63 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_63,
             Expected_Token_Id => Ada_With,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_66 := Row_Pos_63 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_66 /= No_Token_Index then

   Row_Pos_63 := Token_Pos_66;

else
   Row_Pos_63 := No_Token_Index;
   goto Exit_Row_52_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_52_0>>
pragma Warnings (On, "referenced");

--  End row_code


if Row_Pos_63 = No_Token_Index then

        Defer_Res_83 := No_Bare_Ada_Node;


    Row_Pos_63 := Row_Pos_62;


end if;

--  End opt_code



if Row_Pos_63 /= No_Token_Index then

   Row_Pos_62 := Row_Pos_63;

else
   Row_Pos_62 := No_Token_Index;
   goto Exit_Row_51_0;

end if;


--  Start tok_code

Token_Res_67 := Row_Pos_62;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_67));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Null)
   then
       Token_Pos_67 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_62 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_62,
             Expected_Token_Id => Ada_Null,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_67 := Row_Pos_62 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_67 /= No_Token_Index then

   Row_Pos_62 := Token_Pos_67;

else
   Row_Pos_62 := No_Token_Index;
   goto Exit_Row_51_0;

end if;


--  Start tok_code

Token_Res_68 := Row_Pos_62;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_68));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Record)
   then
       Token_Pos_68 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_62 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_62,
             Expected_Token_Id => Ada_Record,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_68 := Row_Pos_62 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_68 /= No_Token_Index then

   Row_Pos_62 := Token_Pos_68;

else
   Row_Pos_62 := No_Token_Index;
   goto Exit_Row_51_0;

end if;


   Null_Res_2 := Allocate_Assoc_List (Parser.Mem_Pool);
   Initialize
     (Self              => Null_Res_2,
      Kind              => Ada_Assoc_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Index'Max (Row_Pos_62, 1),
      Token_End_Index   => No_Token_Index);
   Initialize_List
     (Self   => Null_Res_2,
      Parser => Parser,
      Count  => 0);




if Row_Pos_62 /= No_Token_Index then

   Row_Pos_62 := Row_Pos_62;

else
   Row_Pos_62 := No_Token_Index;
   goto Exit_Row_51_0;

end if;


--  Start tok_code

Token_Res_69 := Row_Pos_62;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_69));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Par_Close)
   then
       Token_Pos_69 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_62 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_62,
             Expected_Token_Id => Ada_Par_Close,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_69 := Row_Pos_62 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_69 /= No_Token_Index then

   Row_Pos_62 := Token_Pos_69;

else
   Row_Pos_62 := No_Token_Index;
   goto Exit_Row_51_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_51_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_62 /= No_Token_Index then

   Transform_Res_58 := Allocate_Null_Record_Aggregate (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_58,
      Kind => Ada_Null_Record_Aggregate,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_62 = Pos
                            then No_Token_Index
                            else Row_Pos_62 - 1));

      Initialize_Fields_For_Null_Record_Aggregate
        (Self => Transform_Res_58, Base_Aggregate_F_Ancestor_Expr => Defer_Res_83, Base_Aggregate_F_Assocs => Null_Res_2);

         if Defer_Res_83 /= null and then Is_Incomplete (Defer_Res_83) then
            Transform_Res_58.Last_Attempted_Child := 0;
         elsif Defer_Res_83 /= null and then not Is_Ghost (Defer_Res_83) then
            Transform_Res_58.Last_Attempted_Child := -1;
         end if;
         if Null_Res_2 /= null and then Is_Incomplete (Null_Res_2) then
            Transform_Res_58.Last_Attempted_Child := 0;
         elsif Null_Res_2 /= null and then not Is_Ghost (Null_Res_2) then
            Transform_Res_58.Last_Attempted_Child := -1;
         end if;


end if;

--  End transform_code

    if Row_Pos_62 /= No_Token_Index then
        Or_Pos_24 := Row_Pos_62;
        Or_Res_24 := Transform_Res_58;
        goto Exit_Or_23;
    end if;
    
--  Start transform_code


--  Start row_code

Row_Pos_64 := Pos;



--  Start tok_code

Token_Res_70 := Row_Pos_64;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_70));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Par_Open)
   then
       Token_Pos_70 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_64 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_64,
             Expected_Token_Id => Ada_Par_Open,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_70 := Row_Pos_64 + 1;
   end if;
end;

--  End tok_code


Row_Progress_9 := 1;

if Token_Pos_70 /= No_Token_Index then

   Row_Pos_64 := Token_Pos_70;

else
   Row_Pos_64 := No_Token_Index;
   goto Exit_Row_53_0;

end if;


Defer_Res_84 :=
   Expr_Or_Parse_0 (Parser, Row_Pos_64);
Defer_Pos_84 := Parser.Current_Pos;


Row_Progress_9 := 2;

if Defer_Pos_84 /= No_Token_Index then

   Row_Pos_64 := Defer_Pos_84;

else
   Row_Pos_64 := No_Token_Index;
   goto Exit_Row_53_0;

end if;


--  Start tok_code

Token_Res_71 := Row_Pos_64;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_71));
begin
   if
      T.Kind /= From_Token_Kind (Ada_With)
   then
       Token_Pos_71 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_64 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_64,
             Expected_Token_Id => Ada_With,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_71 := Row_Pos_64 + 1;
   end if;
end;

--  End tok_code


Row_Progress_9 := 3;

if Token_Pos_71 /= No_Token_Index then

   Row_Pos_64 := Token_Pos_71;

else
   Row_Pos_64 := No_Token_Index;
   goto Exit_Row_53_0;

end if;


--  Start tok_code

Token_Res_72 := Row_Pos_64;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_72));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Delta)
   then
       Token_Pos_72 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_64 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_64,
             Expected_Token_Id => Ada_Delta,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_72 := Row_Pos_64 + 1;
   end if;
end;

--  End tok_code


Row_Progress_9 := 4;

if Token_Pos_72 /= No_Token_Index then

   Row_Pos_64 := Token_Pos_72;

else
   Row_Pos_64 := No_Token_Index;
   goto Exit_Row_53_0;

end if;

Nobt_9 := True;

Row_Progress_9 := 5;

if Row_Pos_64 /= No_Token_Index then

   Row_Pos_64 := Row_Pos_64;

else
   Row_Pos_64 := No_Token_Index;
   goto Exit_Row_53_0;

end if;


--  Start list_code

    List_Pos_3 := No_Token_Index;



Lst_Cpos_3 := Row_Pos_64;
Tmp_List_3 := Get_Parse_List (Parser);

loop
   
Defer_Res_85 :=
   Aggregate_Assoc_Or_Parse_2 (Parser, Lst_Cpos_3);
Defer_Pos_85 := Parser.Current_Pos;


   exit when Defer_Pos_85 = No_Token_Index;

   List_Pos_3 := Defer_Pos_85;
   Lst_Cpos_3 := List_Pos_3;

   Tmp_List_3.Nodes.Append (Defer_Res_85);

      
--  Start tok_code

Token_Res_73 := Lst_Cpos_3;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_73));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Comma)
   then
       Token_Pos_73 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Lst_Cpos_3 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Lst_Cpos_3,
             Expected_Token_Id => Ada_Comma,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_73 := Lst_Cpos_3 + 1;
   end if;
end;

--  End tok_code

      if Token_Pos_73 /= No_Token_Index then
          Lst_Cpos_3 := Token_Pos_73;
      else
         exit;
      end if;

end loop;

declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List_3.Nodes.Length;
begin
   List_Res_3 :=
      Allocate_Assoc_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Row_Pos_64;
      Token_End := (if Lst_Cpos_3 = Row_Pos_64
                    then Row_Pos_64
                    else Lst_Cpos_3 - 1);

   else
      Token_Start := Token_Index'Max (Row_Pos_64, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res_3,
      Kind              => Ada_Assoc_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res_3,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_Ada_Node_Vectors.Vector renames
         Tmp_List_3.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res_3.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List_3);

--  End list_code


Row_Progress_9 := 6;

if List_Pos_3 /= No_Token_Index then

   Row_Pos_64 := List_Pos_3;

else
   Row_Pos_64 := No_Token_Index;
   goto Exit_Row_53_0;

end if;


--  Start tok_code

Token_Res_74 := Row_Pos_64;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_74));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Par_Close)
   then
       Token_Pos_74 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_64 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_64,
             Expected_Token_Id => Ada_Par_Close,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_74 := Row_Pos_64 + 1;
   end if;
end;

--  End tok_code


Row_Progress_9 := 7;

if Token_Pos_74 /= No_Token_Index then

   Row_Pos_64 := Token_Pos_74;

else
   Row_Pos_64 := No_Token_Index;
   goto Exit_Row_53_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_53_0>>
pragma Warnings (On, "referenced");

--  End row_code


if Row_Pos_64 = No_Token_Index and then Nobt_9 then
   Row_Pos_64 := Parser.Last_Fail.Pos;
   Transform_Has_Failed_9 := True;
end if;

if Row_Pos_64 /= No_Token_Index then

   Transform_Res_59 := Allocate_Delta_Aggregate (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_59,
      Kind => Ada_Delta_Aggregate,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_64 = Pos
                            then No_Token_Index
                            else Row_Pos_64 - 1));

      Initialize_Fields_For_Delta_Aggregate
        (Self => Transform_Res_59, Base_Aggregate_F_Ancestor_Expr => Defer_Res_84, Base_Aggregate_F_Assocs => List_Res_3);

         if Defer_Res_84 /= null and then Is_Incomplete (Defer_Res_84) then
            Transform_Res_59.Last_Attempted_Child := 0;
         elsif Defer_Res_84 /= null and then not Is_Ghost (Defer_Res_84) then
            Transform_Res_59.Last_Attempted_Child := -1;
         end if;
         if List_Res_3 /= null and then Is_Incomplete (List_Res_3) then
            Transform_Res_59.Last_Attempted_Child := 0;
         elsif List_Res_3 /= null and then not Is_Ghost (List_Res_3) then
            Transform_Res_59.Last_Attempted_Child := -1;
         end if;

   if Transform_Has_Failed_9 then
      Transform_Res_59.Last_Attempted_Child :=
         Row_Progress_9;

      Append (Parser.Diagnostics,
              Sloc_Range (Parser.TDH.all,
                          Get_Token (Parser.TDH.all, Pos)),
              To_Text ("Cannot parse <regular_aggregate>"));

      Add_Last_Fail_Diagnostic (Parser);
   end if;

end if;

--  End transform_code

    if Row_Pos_64 /= No_Token_Index then
        Or_Pos_24 := Row_Pos_64;
        Or_Res_24 := Transform_Res_59;
        goto Exit_Or_23;
    end if;
    
--  Start transform_code


--  Start row_code

Row_Pos_65 := Pos;



--  Start tok_code

Token_Res_75 := Row_Pos_65;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_75));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Par_Open)
   then
       Token_Pos_75 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_65 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_65,
             Expected_Token_Id => Ada_Par_Open,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_75 := Row_Pos_65 + 1;
   end if;
end;

--  End tok_code


Row_Progress_10 := 1;

if Token_Pos_75 /= No_Token_Index then

   Row_Pos_65 := Token_Pos_75;

else
   Row_Pos_65 := No_Token_Index;
   goto Exit_Row_74_0;

end if;

Nobt_10 := True;

Row_Progress_10 := 2;

if Row_Pos_65 /= No_Token_Index then

   Row_Pos_65 := Row_Pos_65;

else
   Row_Pos_65 := No_Token_Index;
   goto Exit_Row_74_0;

end if;


--  Start opt_code




--  Start row_code

Row_Pos_66 := Row_Pos_65;



Defer_Res_86 :=
   Expr_Or_Parse_0 (Parser, Row_Pos_66);
Defer_Pos_86 := Parser.Current_Pos;



if Defer_Pos_86 /= No_Token_Index then

   Row_Pos_66 := Defer_Pos_86;

else
   Row_Pos_66 := No_Token_Index;
   goto Exit_Row_75_0;

end if;


--  Start tok_code

Token_Res_76 := Row_Pos_66;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_76));
begin
   if
      T.Kind /= From_Token_Kind (Ada_With)
   then
       Token_Pos_76 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_66 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_66,
             Expected_Token_Id => Ada_With,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_76 := Row_Pos_66 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_76 /= No_Token_Index then

   Row_Pos_66 := Token_Pos_76;

else
   Row_Pos_66 := No_Token_Index;
   goto Exit_Row_75_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_75_0>>
pragma Warnings (On, "referenced");

--  End row_code


if Row_Pos_66 = No_Token_Index then

        Defer_Res_86 := No_Bare_Ada_Node;


    Row_Pos_66 := Row_Pos_65;


end if;

--  End opt_code


Row_Progress_10 := 3;

if Row_Pos_66 /= No_Token_Index then

   Row_Pos_65 := Row_Pos_66;

else
   Row_Pos_65 := No_Token_Index;
   goto Exit_Row_74_0;

end if;


--  Start list_code

    List_Pos_4 := No_Token_Index;



Lst_Cpos_4 := Row_Pos_65;
Tmp_List_4 := Get_Parse_List (Parser);

loop
   
Defer_Res_87 :=
   Aggregate_Assoc_Or_Parse_2 (Parser, Lst_Cpos_4);
Defer_Pos_87 := Parser.Current_Pos;


   exit when Defer_Pos_87 = No_Token_Index;

   List_Pos_4 := Defer_Pos_87;
   Lst_Cpos_4 := List_Pos_4;

   Tmp_List_4.Nodes.Append (Defer_Res_87);

      
--  Start tok_code

Token_Res_77 := Lst_Cpos_4;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_77));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Comma)
   then
       Token_Pos_77 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Lst_Cpos_4 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Lst_Cpos_4,
             Expected_Token_Id => Ada_Comma,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_77 := Lst_Cpos_4 + 1;
   end if;
end;

--  End tok_code

      if Token_Pos_77 /= No_Token_Index then
          Lst_Cpos_4 := Token_Pos_77;
      else
         exit;
      end if;

end loop;

declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List_4.Nodes.Length;
begin
   List_Res_4 :=
      Allocate_Assoc_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Row_Pos_65;
      Token_End := (if Lst_Cpos_4 = Row_Pos_65
                    then Row_Pos_65
                    else Lst_Cpos_4 - 1);

   else
      Token_Start := Token_Index'Max (Row_Pos_65, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res_4,
      Kind              => Ada_Assoc_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res_4,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_Ada_Node_Vectors.Vector renames
         Tmp_List_4.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res_4.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List_4);

--  End list_code


Row_Progress_10 := 4;

if List_Pos_4 /= No_Token_Index then

   Row_Pos_65 := List_Pos_4;

else
   Row_Pos_65 := No_Token_Index;
   goto Exit_Row_74_0;

end if;


--  Start tok_code

Token_Res_78 := Row_Pos_65;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_78));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Par_Close)
   then
       Token_Pos_78 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_65 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_65,
             Expected_Token_Id => Ada_Par_Close,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_78 := Row_Pos_65 + 1;
   end if;
end;

--  End tok_code


Row_Progress_10 := 5;

if Token_Pos_78 /= No_Token_Index then

   Row_Pos_65 := Token_Pos_78;

else
   Row_Pos_65 := No_Token_Index;
   goto Exit_Row_74_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_74_0>>
pragma Warnings (On, "referenced");

--  End row_code


if Row_Pos_65 = No_Token_Index and then Nobt_10 then
   Row_Pos_65 := Parser.Last_Fail.Pos;
   Transform_Has_Failed_10 := True;
end if;

if Row_Pos_65 /= No_Token_Index then

   Transform_Res_60 := Allocate_Aggregate (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_60,
      Kind => Ada_Aggregate,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_65 = Pos
                            then No_Token_Index
                            else Row_Pos_65 - 1));

      Initialize_Fields_For_Aggregate
        (Self => Transform_Res_60, Base_Aggregate_F_Ancestor_Expr => Defer_Res_86, Base_Aggregate_F_Assocs => List_Res_4);

         if Defer_Res_86 /= null and then Is_Incomplete (Defer_Res_86) then
            Transform_Res_60.Last_Attempted_Child := 0;
         elsif Defer_Res_86 /= null and then not Is_Ghost (Defer_Res_86) then
            Transform_Res_60.Last_Attempted_Child := -1;
         end if;
         if List_Res_4 /= null and then Is_Incomplete (List_Res_4) then
            Transform_Res_60.Last_Attempted_Child := 0;
         elsif List_Res_4 /= null and then not Is_Ghost (List_Res_4) then
            Transform_Res_60.Last_Attempted_Child := -1;
         end if;

   if Transform_Has_Failed_10 then
      Transform_Res_60.Last_Attempted_Child :=
         Row_Progress_10;

      Append (Parser.Diagnostics,
              Sloc_Range (Parser.TDH.all,
                          Get_Token (Parser.TDH.all, Pos)),
              To_Text ("Cannot parse <regular_aggregate>"));

      Add_Last_Fail_Diagnostic (Parser);
   end if;

end if;

--  End transform_code

    if Row_Pos_65 /= No_Token_Index then
        Or_Pos_24 := Row_Pos_65;
        Or_Res_24 := Transform_Res_60;
        goto Exit_Or_23;
    end if;
<<Exit_Or_23>>

--  End or_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Regular_Aggregate_Or_Parse_0_Memo,
      Or_Pos_24 /= No_Token_Index,
      Or_Res_24,
      Pos,
      Or_Pos_24);


   Parser.Current_Pos := Or_Pos_24;

   return Or_Res_24;
end Regular_Aggregate_Or_Parse_0;

   


function Qualified_Name_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Qual_Expr
is
   use Bare_Qual_Expr_Memos;

      Row_Pos_41 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_60 :
            Token_Index
               := No_Token_Index;
      Defer_Res_60 :
            Bare_Name
               := No_Bare_Ada_Node;
      Token_Pos_43 :
            Token_Index
               := No_Token_Index;
      Token_Res_43 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_61 :
            Token_Index
               := No_Token_Index;
      Defer_Res_61 :
            Bare_Paren_Expr
               := No_Bare_Ada_Node;
      Defer_Pos_62 :
            Token_Index
               := No_Token_Index;
      Defer_Res_62 :
            Bare_Base_Aggregate
               := No_Bare_Ada_Node;
      Or_Pos_16 :
            Token_Index
               := No_Token_Index;
      Or_Res_16 :
            Bare_Expr
               := No_Bare_Ada_Node;
      Transform_Res_37 :
            Bare_Qual_Expr
               := No_Bare_Ada_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Qualified_Name_Transform_Parse_0_Memo, Pos);

begin

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res_37 := M.Instance;
      return Transform_Res_37;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res_37;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code


--  Start row_code

Row_Pos_41 := Pos;



Defer_Res_60 :=
   Qual_Name_Internal_Or_Parse_0 (Parser, Row_Pos_41);
Defer_Pos_60 := Parser.Current_Pos;



if Defer_Pos_60 /= No_Token_Index then

   Row_Pos_41 := Defer_Pos_60;

else
   Row_Pos_41 := No_Token_Index;
   goto Exit_Row_30_0;

end if;


--  Start tok_code

Token_Res_43 := Row_Pos_41;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_43));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Tick)
   then
       Token_Pos_43 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_41 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_41,
             Expected_Token_Id => Ada_Tick,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_43 := Row_Pos_41 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_43 /= No_Token_Index then

   Row_Pos_41 := Token_Pos_43;

else
   Row_Pos_41 := No_Token_Index;
   goto Exit_Row_30_0;

end if;


--  Start or_code

Or_Pos_16 := No_Token_Index;
Or_Res_16 := No_Bare_Ada_Node;
    
Defer_Res_61 :=
   Paren_Expr_Transform_Parse_0 (Parser, Row_Pos_41);
Defer_Pos_61 := Parser.Current_Pos;

    if Defer_Pos_61 /= No_Token_Index then
        Or_Pos_16 := Defer_Pos_61;
        Or_Res_16 := Defer_Res_61;
        goto Exit_Or_16;
    end if;
    
Defer_Res_62 :=
   Regular_Aggregate_Or_Parse_0 (Parser, Row_Pos_41);
Defer_Pos_62 := Parser.Current_Pos;

    if Defer_Pos_62 /= No_Token_Index then
        Or_Pos_16 := Defer_Pos_62;
        Or_Res_16 := Defer_Res_62;
        goto Exit_Or_16;
    end if;
<<Exit_Or_16>>

--  End or_code



if Or_Pos_16 /= No_Token_Index then

   Row_Pos_41 := Or_Pos_16;

else
   Row_Pos_41 := No_Token_Index;
   goto Exit_Row_30_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_30_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_41 /= No_Token_Index then

   Transform_Res_37 := Allocate_Qual_Expr (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_37,
      Kind => Ada_Qual_Expr,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_41 = Pos
                            then No_Token_Index
                            else Row_Pos_41 - 1));

      Initialize_Fields_For_Qual_Expr
        (Self => Transform_Res_37, Qual_Expr_F_Prefix => Defer_Res_60, Qual_Expr_F_Suffix => Or_Res_16);

         if Defer_Res_60 /= null and then Is_Incomplete (Defer_Res_60) then
            Transform_Res_37.Last_Attempted_Child := 0;
         elsif Defer_Res_60 /= null and then not Is_Ghost (Defer_Res_60) then
            Transform_Res_37.Last_Attempted_Child := -1;
         end if;
         if Or_Res_16 /= null and then Is_Incomplete (Or_Res_16) then
            Transform_Res_37.Last_Attempted_Child := 0;
         elsif Or_Res_16 /= null and then not Is_Ghost (Or_Res_16) then
            Transform_Res_37.Last_Attempted_Child := -1;
         end if;


end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Qualified_Name_Transform_Parse_0_Memo,
      Row_Pos_41 /= No_Token_Index,
      Transform_Res_37,
      Pos,
      Row_Pos_41);


   Parser.Current_Pos := Row_Pos_41;

   return Transform_Res_37;
end Qualified_Name_Transform_Parse_0;

   


function Allocator_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Allocator
is
   use Bare_Allocator_Memos;

      Nobt_6 :
            Boolean
               := False;
      Row_Pos_39 :
            Token_Index
               := No_Token_Index;
      Token_Pos_40 :
            Token_Index
               := No_Token_Index;
      Token_Res_40 :
            Token_Index
               := No_Token_Index;
      Row_Pos_40 :
            Token_Index
               := No_Token_Index;
      Token_Pos_41 :
            Token_Index
               := No_Token_Index;
      Token_Res_41 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_57 :
            Token_Index
               := No_Token_Index;
      Defer_Res_57 :
            Bare_Name
               := No_Bare_Ada_Node;
      Token_Pos_42 :
            Token_Index
               := No_Token_Index;
      Token_Res_42 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_58 :
            Token_Index
               := No_Token_Index;
      Defer_Res_58 :
            Bare_Qual_Expr
               := No_Bare_Ada_Node;
      Defer_Pos_59 :
            Token_Index
               := No_Token_Index;
      Defer_Res_59 :
            Bare_Subtype_Indication
               := No_Bare_Ada_Node;
      Or_Pos_15 :
            Token_Index
               := No_Token_Index;
      Or_Res_15 :
            Bare_Ada_Node
               := No_Bare_Ada_Node;
      Row_Progress_6 :
            Integer
               := 0;
      Transform_Res_36 :
            Bare_Allocator
               := No_Bare_Ada_Node;
      Transform_Has_Failed_6 :
            Boolean
               := False;


   M : Memo_Entry := Get (Parser.Private_Part.Allocator_Transform_Parse_0_Memo, Pos);

begin

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res_36 := M.Instance;
      return Transform_Res_36;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res_36;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code


--  Start row_code

Row_Pos_39 := Pos;



--  Start tok_code

Token_Res_40 := Row_Pos_39;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_40));
begin
   if
      T.Kind /= From_Token_Kind (Ada_New)
   then
       Token_Pos_40 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_39 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_39,
             Expected_Token_Id => Ada_New,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_40 := Row_Pos_39 + 1;
   end if;
end;

--  End tok_code


Row_Progress_6 := 1;

if Token_Pos_40 /= No_Token_Index then

   Row_Pos_39 := Token_Pos_40;

else
   Row_Pos_39 := No_Token_Index;
   goto Exit_Row_28_0;

end if;

Nobt_6 := True;

Row_Progress_6 := 2;

if Row_Pos_39 /= No_Token_Index then

   Row_Pos_39 := Row_Pos_39;

else
   Row_Pos_39 := No_Token_Index;
   goto Exit_Row_28_0;

end if;


--  Start opt_code




--  Start row_code

Row_Pos_40 := Row_Pos_39;



--  Start tok_code

Token_Res_41 := Row_Pos_40;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_41));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Par_Open)
   then
       Token_Pos_41 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_40 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_40,
             Expected_Token_Id => Ada_Par_Open,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_41 := Row_Pos_40 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_41 /= No_Token_Index then

   Row_Pos_40 := Token_Pos_41;

else
   Row_Pos_40 := No_Token_Index;
   goto Exit_Row_29_0;

end if;


Defer_Res_57 :=
   Name_Or_Parse_1 (Parser, Row_Pos_40);
Defer_Pos_57 := Parser.Current_Pos;



if Defer_Pos_57 /= No_Token_Index then

   Row_Pos_40 := Defer_Pos_57;

else
   Row_Pos_40 := No_Token_Index;
   goto Exit_Row_29_0;

end if;


--  Start tok_code

Token_Res_42 := Row_Pos_40;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_42));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Par_Close)
   then
       Token_Pos_42 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_40 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_40,
             Expected_Token_Id => Ada_Par_Close,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_42 := Row_Pos_40 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_42 /= No_Token_Index then

   Row_Pos_40 := Token_Pos_42;

else
   Row_Pos_40 := No_Token_Index;
   goto Exit_Row_29_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_29_0>>
pragma Warnings (On, "referenced");

--  End row_code


if Row_Pos_40 = No_Token_Index then

        Defer_Res_57 := No_Bare_Ada_Node;


    Row_Pos_40 := Row_Pos_39;


end if;

--  End opt_code


Row_Progress_6 := 3;

if Row_Pos_40 /= No_Token_Index then

   Row_Pos_39 := Row_Pos_40;

else
   Row_Pos_39 := No_Token_Index;
   goto Exit_Row_28_0;

end if;


--  Start or_code

Or_Pos_15 := No_Token_Index;
Or_Res_15 := No_Bare_Ada_Node;
    
Defer_Res_58 :=
   Qualified_Name_Transform_Parse_0 (Parser, Row_Pos_39);
Defer_Pos_58 := Parser.Current_Pos;

    if Defer_Pos_58 /= No_Token_Index then
        Or_Pos_15 := Defer_Pos_58;
        Or_Res_15 := Defer_Res_58;
        goto Exit_Or_14;
    end if;
    
Defer_Res_59 :=
   Subtype_Indication_Transform_Parse_0 (Parser, Row_Pos_39);
Defer_Pos_59 := Parser.Current_Pos;

    if Defer_Pos_59 /= No_Token_Index then
        Or_Pos_15 := Defer_Pos_59;
        Or_Res_15 := Defer_Res_59;
        goto Exit_Or_14;
    end if;
<<Exit_Or_14>>

--  End or_code


Row_Progress_6 := 4;

if Or_Pos_15 /= No_Token_Index then

   Row_Pos_39 := Or_Pos_15;

else
   Row_Pos_39 := No_Token_Index;
   goto Exit_Row_28_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_28_0>>
pragma Warnings (On, "referenced");

--  End row_code


if Row_Pos_39 = No_Token_Index and then Nobt_6 then
   Row_Pos_39 := Parser.Last_Fail.Pos;
   Transform_Has_Failed_6 := True;
end if;

if Row_Pos_39 /= No_Token_Index then

   Transform_Res_36 := Allocate_Allocator (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_36,
      Kind => Ada_Allocator,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_39 = Pos
                            then No_Token_Index
                            else Row_Pos_39 - 1));

      Initialize_Fields_For_Allocator
        (Self => Transform_Res_36, Allocator_F_Subpool => Defer_Res_57, Allocator_F_Type_Or_Expr => Or_Res_15);

         if Defer_Res_57 /= null and then Is_Incomplete (Defer_Res_57) then
            Transform_Res_36.Last_Attempted_Child := 0;
         elsif Defer_Res_57 /= null and then not Is_Ghost (Defer_Res_57) then
            Transform_Res_36.Last_Attempted_Child := -1;
         end if;
         if Or_Res_15 /= null and then Is_Incomplete (Or_Res_15) then
            Transform_Res_36.Last_Attempted_Child := 0;
         elsif Or_Res_15 /= null and then not Is_Ghost (Or_Res_15) then
            Transform_Res_36.Last_Attempted_Child := -1;
         end if;

   if Transform_Has_Failed_6 then
      Transform_Res_36.Last_Attempted_Child :=
         Row_Progress_6;

      Append (Parser.Diagnostics,
              Sloc_Range (Parser.TDH.all,
                          Get_Token (Parser.TDH.all, Pos)),
              To_Text ("Cannot parse <allocator>"));

      Add_Last_Fail_Diagnostic (Parser);
   end if;

end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Allocator_Transform_Parse_0_Memo,
      Row_Pos_39 /= No_Token_Index,
      Transform_Res_36,
      Pos,
      Row_Pos_39);


   Parser.Current_Pos := Row_Pos_39;

   return Transform_Res_36;
end Allocator_Transform_Parse_0;

   


function If_Expr_Transform_Parse_1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_If_Expr
is
   use Bare_If_Expr_Memos;

      Row_Pos_87 :
            Token_Index
               := No_Token_Index;
      Token_Pos_102 :
            Token_Index
               := No_Token_Index;
      Token_Res_102 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_129 :
            Token_Index
               := No_Token_Index;
      Defer_Res_129 :
            Bare_Expr
               := No_Bare_Ada_Node;
      Token_Pos_103 :
            Token_Index
               := No_Token_Index;
      Token_Res_103 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_130 :
            Token_Index
               := No_Token_Index;
      Defer_Res_130 :
            Bare_Expr
               := No_Bare_Ada_Node;
      Lst_Cpos_9 :
            Token_Index
               := No_Token_Index;
      Tmp_List_9 :
            Free_Parse_List;
      Row_Pos_88 :
            Token_Index
               := No_Token_Index;
      Token_Pos_104 :
            Token_Index
               := No_Token_Index;
      Token_Res_104 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_131 :
            Token_Index
               := No_Token_Index;
      Defer_Res_131 :
            Bare_Expr
               := No_Bare_Ada_Node;
      Token_Pos_105 :
            Token_Index
               := No_Token_Index;
      Token_Res_105 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_132 :
            Token_Index
               := No_Token_Index;
      Defer_Res_132 :
            Bare_Expr
               := No_Bare_Ada_Node;
      Transform_Res_77 :
            Bare_Elsif_Expr_Part
               := No_Bare_Ada_Node;
      List_Pos_9 :
            Token_Index
               := No_Token_Index;
      List_Res_9 :
            Bare_Elsif_Expr_Part_List
               := No_Bare_Ada_Node;
      Row_Pos_89 :
            Token_Index
               := No_Token_Index;
      Token_Pos_106 :
            Token_Index
               := No_Token_Index;
      Token_Res_106 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_133 :
            Token_Index
               := No_Token_Index;
      Defer_Res_133 :
            Bare_Expr
               := No_Bare_Ada_Node;
      Transform_Res_78 :
            Bare_If_Expr
               := No_Bare_Ada_Node;


   M : Memo_Entry := Get (Parser.Private_Part.If_Expr_Transform_Parse_1_Memo, Pos);

begin

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res_78 := M.Instance;
      return Transform_Res_78;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res_78;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code


--  Start row_code

Row_Pos_87 := Pos;



--  Start tok_code

Token_Res_102 := Row_Pos_87;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_102));
begin
   if
      T.Kind /= From_Token_Kind (Ada_If)
   then
       Token_Pos_102 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_87 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_87,
             Expected_Token_Id => Ada_If,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_102 := Row_Pos_87 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_102 /= No_Token_Index then

   Row_Pos_87 := Token_Pos_102;

else
   Row_Pos_87 := No_Token_Index;
   goto Exit_Row_76_0;

end if;


Defer_Res_129 :=
   Expr_Or_Parse_0 (Parser, Row_Pos_87);
Defer_Pos_129 := Parser.Current_Pos;



if Defer_Pos_129 /= No_Token_Index then

   Row_Pos_87 := Defer_Pos_129;

else
   Row_Pos_87 := No_Token_Index;
   goto Exit_Row_76_0;

end if;


--  Start tok_code

Token_Res_103 := Row_Pos_87;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_103));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Then)
   then
       Token_Pos_103 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_87 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_87,
             Expected_Token_Id => Ada_Then,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_103 := Row_Pos_87 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_103 /= No_Token_Index then

   Row_Pos_87 := Token_Pos_103;

else
   Row_Pos_87 := No_Token_Index;
   goto Exit_Row_76_0;

end if;


Defer_Res_130 :=
   Expr_Or_Parse_0 (Parser, Row_Pos_87);
Defer_Pos_130 := Parser.Current_Pos;



if Defer_Pos_130 /= No_Token_Index then

   Row_Pos_87 := Defer_Pos_130;

else
   Row_Pos_87 := No_Token_Index;
   goto Exit_Row_76_0;

end if;


--  Start list_code

    List_Pos_9 := Row_Pos_87;



Lst_Cpos_9 := Row_Pos_87;
Tmp_List_9 := Get_Parse_List (Parser);

loop
   
--  Start transform_code


--  Start row_code

Row_Pos_88 := Lst_Cpos_9;



--  Start tok_code

Token_Res_104 := Row_Pos_88;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_104));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Elsif)
   then
       Token_Pos_104 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_88 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_88,
             Expected_Token_Id => Ada_Elsif,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_104 := Row_Pos_88 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_104 /= No_Token_Index then

   Row_Pos_88 := Token_Pos_104;

else
   Row_Pos_88 := No_Token_Index;
   goto Exit_Row_77_0;

end if;


Defer_Res_131 :=
   Expr_Or_Parse_0 (Parser, Row_Pos_88);
Defer_Pos_131 := Parser.Current_Pos;



if Defer_Pos_131 /= No_Token_Index then

   Row_Pos_88 := Defer_Pos_131;

else
   Row_Pos_88 := No_Token_Index;
   goto Exit_Row_77_0;

end if;


--  Start tok_code

Token_Res_105 := Row_Pos_88;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_105));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Then)
   then
       Token_Pos_105 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_88 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_88,
             Expected_Token_Id => Ada_Then,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_105 := Row_Pos_88 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_105 /= No_Token_Index then

   Row_Pos_88 := Token_Pos_105;

else
   Row_Pos_88 := No_Token_Index;
   goto Exit_Row_77_0;

end if;


Defer_Res_132 :=
   Expr_Or_Parse_0 (Parser, Row_Pos_88);
Defer_Pos_132 := Parser.Current_Pos;



if Defer_Pos_132 /= No_Token_Index then

   Row_Pos_88 := Defer_Pos_132;

else
   Row_Pos_88 := No_Token_Index;
   goto Exit_Row_77_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_77_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_88 /= No_Token_Index then

   Transform_Res_77 := Allocate_Elsif_Expr_Part (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_77,
      Kind => Ada_Elsif_Expr_Part,
      Unit => Parser.Unit,

      Token_Start_Index => Lst_Cpos_9,
      Token_End_Index   => (if Row_Pos_88 = Lst_Cpos_9
                            then No_Token_Index
                            else Row_Pos_88 - 1));

      Initialize_Fields_For_Elsif_Expr_Part
        (Self => Transform_Res_77, Elsif_Expr_Part_F_Cond_Expr => Defer_Res_131, Elsif_Expr_Part_F_Then_Expr => Defer_Res_132);

         if Defer_Res_131 /= null and then Is_Incomplete (Defer_Res_131) then
            Transform_Res_77.Last_Attempted_Child := 0;
         elsif Defer_Res_131 /= null and then not Is_Ghost (Defer_Res_131) then
            Transform_Res_77.Last_Attempted_Child := -1;
         end if;
         if Defer_Res_132 /= null and then Is_Incomplete (Defer_Res_132) then
            Transform_Res_77.Last_Attempted_Child := 0;
         elsif Defer_Res_132 /= null and then not Is_Ghost (Defer_Res_132) then
            Transform_Res_77.Last_Attempted_Child := -1;
         end if;


end if;

--  End transform_code


   exit when Row_Pos_88 = No_Token_Index;

   List_Pos_9 := Row_Pos_88;
   Lst_Cpos_9 := List_Pos_9;

   Tmp_List_9.Nodes.Append (Transform_Res_77);


end loop;

declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List_9.Nodes.Length;
begin
   List_Res_9 :=
      Allocate_Elsif_Expr_Part_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Row_Pos_87;
      Token_End := (if Lst_Cpos_9 = Row_Pos_87
                    then Row_Pos_87
                    else Lst_Cpos_9 - 1);

   else
      Token_Start := Token_Index'Max (Row_Pos_87, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res_9,
      Kind              => Ada_Elsif_Expr_Part_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res_9,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_Ada_Node_Vectors.Vector renames
         Tmp_List_9.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res_9.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List_9);

--  End list_code



if List_Pos_9 /= No_Token_Index then

   Row_Pos_87 := List_Pos_9;

else
   Row_Pos_87 := No_Token_Index;
   goto Exit_Row_76_0;

end if;


--  Start opt_code




--  Start row_code

Row_Pos_89 := Row_Pos_87;



--  Start tok_code

Token_Res_106 := Row_Pos_89;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_106));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Else)
   then
       Token_Pos_106 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_89 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_89,
             Expected_Token_Id => Ada_Else,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_106 := Row_Pos_89 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_106 /= No_Token_Index then

   Row_Pos_89 := Token_Pos_106;

else
   Row_Pos_89 := No_Token_Index;
   goto Exit_Row_78_0;

end if;


Defer_Res_133 :=
   Expr_Or_Parse_0 (Parser, Row_Pos_89);
Defer_Pos_133 := Parser.Current_Pos;



if Defer_Pos_133 /= No_Token_Index then

   Row_Pos_89 := Defer_Pos_133;

else
   Row_Pos_89 := No_Token_Index;
   goto Exit_Row_78_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_78_0>>
pragma Warnings (On, "referenced");

--  End row_code


if Row_Pos_89 = No_Token_Index then

        Defer_Res_133 := No_Bare_Ada_Node;


    Row_Pos_89 := Row_Pos_87;


end if;

--  End opt_code



if Row_Pos_89 /= No_Token_Index then

   Row_Pos_87 := Row_Pos_89;

else
   Row_Pos_87 := No_Token_Index;
   goto Exit_Row_76_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_76_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_87 /= No_Token_Index then

   Transform_Res_78 := Allocate_If_Expr (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_78,
      Kind => Ada_If_Expr,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_87 = Pos
                            then No_Token_Index
                            else Row_Pos_87 - 1));

      Initialize_Fields_For_If_Expr
        (Self => Transform_Res_78, If_Expr_F_Cond_Expr => Defer_Res_129, If_Expr_F_Then_Expr => Defer_Res_130, If_Expr_F_Alternatives => List_Res_9, If_Expr_F_Else_Expr => Defer_Res_133);

         if Defer_Res_129 /= null and then Is_Incomplete (Defer_Res_129) then
            Transform_Res_78.Last_Attempted_Child := 0;
         elsif Defer_Res_129 /= null and then not Is_Ghost (Defer_Res_129) then
            Transform_Res_78.Last_Attempted_Child := -1;
         end if;
         if Defer_Res_130 /= null and then Is_Incomplete (Defer_Res_130) then
            Transform_Res_78.Last_Attempted_Child := 0;
         elsif Defer_Res_130 /= null and then not Is_Ghost (Defer_Res_130) then
            Transform_Res_78.Last_Attempted_Child := -1;
         end if;
         if List_Res_9 /= null and then Is_Incomplete (List_Res_9) then
            Transform_Res_78.Last_Attempted_Child := 0;
         elsif List_Res_9 /= null and then not Is_Ghost (List_Res_9) then
            Transform_Res_78.Last_Attempted_Child := -1;
         end if;
         if Defer_Res_133 /= null and then Is_Incomplete (Defer_Res_133) then
            Transform_Res_78.Last_Attempted_Child := 0;
         elsif Defer_Res_133 /= null and then not Is_Ghost (Defer_Res_133) then
            Transform_Res_78.Last_Attempted_Child := -1;
         end if;


end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.If_Expr_Transform_Parse_1_Memo,
      Row_Pos_87 /= No_Token_Index,
      Transform_Res_78,
      Pos,
      Row_Pos_87);


   Parser.Current_Pos := Row_Pos_87;

   return Transform_Res_78;
end If_Expr_Transform_Parse_1;

   


function Case_Expr_Alt_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Case_Expr_Alternative
is
   use Bare_Case_Expr_Alternative_Memos;

      Row_Pos_91 :
            Token_Index
               := No_Token_Index;
      Token_Pos_110 :
            Token_Index
               := No_Token_Index;
      Token_Res_110 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_136 :
            Token_Index
               := No_Token_Index;
      Defer_Res_136 :
            Bare_Alternatives_List
               := No_Bare_Ada_Node;
      Token_Pos_111 :
            Token_Index
               := No_Token_Index;
      Token_Res_111 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_137 :
            Token_Index
               := No_Token_Index;
      Defer_Res_137 :
            Bare_Expr
               := No_Bare_Ada_Node;
      Transform_Res_80 :
            Bare_Case_Expr_Alternative
               := No_Bare_Ada_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Case_Expr_Alt_Transform_Parse_0_Memo, Pos);

begin

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res_80 := M.Instance;
      return Transform_Res_80;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res_80;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code


--  Start row_code

Row_Pos_91 := Pos;



--  Start tok_code

Token_Res_110 := Row_Pos_91;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_110));
begin
   if
      T.Kind /= From_Token_Kind (Ada_When)
   then
       Token_Pos_110 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_91 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_91,
             Expected_Token_Id => Ada_When,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_110 := Row_Pos_91 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_110 /= No_Token_Index then

   Row_Pos_91 := Token_Pos_110;

else
   Row_Pos_91 := No_Token_Index;
   goto Exit_Row_80_0;

end if;


Defer_Res_136 :=
   Choice_List_List_Parse_0 (Parser, Row_Pos_91);
Defer_Pos_136 := Parser.Current_Pos;



if Defer_Pos_136 /= No_Token_Index then

   Row_Pos_91 := Defer_Pos_136;

else
   Row_Pos_91 := No_Token_Index;
   goto Exit_Row_80_0;

end if;


--  Start tok_code

Token_Res_111 := Row_Pos_91;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_111));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Arrow)
   then
       Token_Pos_111 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_91 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_91,
             Expected_Token_Id => Ada_Arrow,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_111 := Row_Pos_91 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_111 /= No_Token_Index then

   Row_Pos_91 := Token_Pos_111;

else
   Row_Pos_91 := No_Token_Index;
   goto Exit_Row_80_0;

end if;


Defer_Res_137 :=
   Expr_Or_Parse_0 (Parser, Row_Pos_91);
Defer_Pos_137 := Parser.Current_Pos;



if Defer_Pos_137 /= No_Token_Index then

   Row_Pos_91 := Defer_Pos_137;

else
   Row_Pos_91 := No_Token_Index;
   goto Exit_Row_80_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_80_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_91 /= No_Token_Index then

   Transform_Res_80 := Allocate_Case_Expr_Alternative (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_80,
      Kind => Ada_Case_Expr_Alternative,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_91 = Pos
                            then No_Token_Index
                            else Row_Pos_91 - 1));

      Initialize_Fields_For_Case_Expr_Alternative
        (Self => Transform_Res_80, Case_Expr_Alternative_F_Choices => Defer_Res_136, Case_Expr_Alternative_F_Expr => Defer_Res_137);

         if Defer_Res_136 /= null and then Is_Incomplete (Defer_Res_136) then
            Transform_Res_80.Last_Attempted_Child := 0;
         elsif Defer_Res_136 /= null and then not Is_Ghost (Defer_Res_136) then
            Transform_Res_80.Last_Attempted_Child := -1;
         end if;
         if Defer_Res_137 /= null and then Is_Incomplete (Defer_Res_137) then
            Transform_Res_80.Last_Attempted_Child := 0;
         elsif Defer_Res_137 /= null and then not Is_Ghost (Defer_Res_137) then
            Transform_Res_80.Last_Attempted_Child := -1;
         end if;


end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Case_Expr_Alt_Transform_Parse_0_Memo,
      Row_Pos_91 /= No_Token_Index,
      Transform_Res_80,
      Pos,
      Row_Pos_91);


   Parser.Current_Pos := Row_Pos_91;

   return Transform_Res_80;
end Case_Expr_Alt_Transform_Parse_0;

   


function Case_Expr_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Case_Expr
is
   use Bare_Case_Expr_Memos;

      Row_Pos_90 :
            Token_Index
               := No_Token_Index;
      Token_Pos_107 :
            Token_Index
               := No_Token_Index;
      Token_Res_107 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_134 :
            Token_Index
               := No_Token_Index;
      Defer_Res_134 :
            Bare_Expr
               := No_Bare_Ada_Node;
      Token_Pos_108 :
            Token_Index
               := No_Token_Index;
      Token_Res_108 :
            Token_Index
               := No_Token_Index;
      Lst_Cpos_10 :
            Token_Index
               := No_Token_Index;
      Tmp_List_10 :
            Free_Parse_List;
      Defer_Pos_135 :
            Token_Index
               := No_Token_Index;
      Defer_Res_135 :
            Bare_Case_Expr_Alternative
               := No_Bare_Ada_Node;
      Token_Pos_109 :
            Token_Index
               := No_Token_Index;
      Token_Res_109 :
            Token_Index
               := No_Token_Index;
      List_Pos_10 :
            Token_Index
               := No_Token_Index;
      List_Res_10 :
            Bare_Case_Expr_Alternative_List
               := No_Bare_Ada_Node;
      Transform_Res_79 :
            Bare_Case_Expr
               := No_Bare_Ada_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Case_Expr_Transform_Parse_0_Memo, Pos);

begin

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res_79 := M.Instance;
      return Transform_Res_79;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res_79;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code


--  Start row_code

Row_Pos_90 := Pos;



--  Start tok_code

Token_Res_107 := Row_Pos_90;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_107));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Case)
   then
       Token_Pos_107 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_90 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_90,
             Expected_Token_Id => Ada_Case,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_107 := Row_Pos_90 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_107 /= No_Token_Index then

   Row_Pos_90 := Token_Pos_107;

else
   Row_Pos_90 := No_Token_Index;
   goto Exit_Row_79_0;

end if;


Defer_Res_134 :=
   Expr_Or_Parse_0 (Parser, Row_Pos_90);
Defer_Pos_134 := Parser.Current_Pos;



if Defer_Pos_134 /= No_Token_Index then

   Row_Pos_90 := Defer_Pos_134;

else
   Row_Pos_90 := No_Token_Index;
   goto Exit_Row_79_0;

end if;


--  Start tok_code

Token_Res_108 := Row_Pos_90;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_108));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Is)
   then
       Token_Pos_108 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_90 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_90,
             Expected_Token_Id => Ada_Is,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_108 := Row_Pos_90 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_108 /= No_Token_Index then

   Row_Pos_90 := Token_Pos_108;

else
   Row_Pos_90 := No_Token_Index;
   goto Exit_Row_79_0;

end if;


--  Start list_code

    List_Pos_10 := No_Token_Index;



Lst_Cpos_10 := Row_Pos_90;
Tmp_List_10 := Get_Parse_List (Parser);

loop
   
Defer_Res_135 :=
   Case_Expr_Alt_Transform_Parse_0 (Parser, Lst_Cpos_10);
Defer_Pos_135 := Parser.Current_Pos;


   exit when Defer_Pos_135 = No_Token_Index;

   List_Pos_10 := Defer_Pos_135;
   Lst_Cpos_10 := List_Pos_10;

   Tmp_List_10.Nodes.Append (Defer_Res_135);

      
--  Start tok_code

Token_Res_109 := Lst_Cpos_10;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_109));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Comma)
   then
       Token_Pos_109 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Lst_Cpos_10 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Lst_Cpos_10,
             Expected_Token_Id => Ada_Comma,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_109 := Lst_Cpos_10 + 1;
   end if;
end;

--  End tok_code

      if Token_Pos_109 /= No_Token_Index then
          Lst_Cpos_10 := Token_Pos_109;
      else
         exit;
      end if;

end loop;

declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List_10.Nodes.Length;
begin
   List_Res_10 :=
      Allocate_Case_Expr_Alternative_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Row_Pos_90;
      Token_End := (if Lst_Cpos_10 = Row_Pos_90
                    then Row_Pos_90
                    else Lst_Cpos_10 - 1);

   else
      Token_Start := Token_Index'Max (Row_Pos_90, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res_10,
      Kind              => Ada_Case_Expr_Alternative_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res_10,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_Ada_Node_Vectors.Vector renames
         Tmp_List_10.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res_10.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List_10);

--  End list_code



if List_Pos_10 /= No_Token_Index then

   Row_Pos_90 := List_Pos_10;

else
   Row_Pos_90 := No_Token_Index;
   goto Exit_Row_79_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_79_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_90 /= No_Token_Index then

   Transform_Res_79 := Allocate_Case_Expr (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_79,
      Kind => Ada_Case_Expr,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_90 = Pos
                            then No_Token_Index
                            else Row_Pos_90 - 1));

      Initialize_Fields_For_Case_Expr
        (Self => Transform_Res_79, Case_Expr_F_Expr => Defer_Res_134, Case_Expr_F_Cases => List_Res_10);

         if Defer_Res_134 /= null and then Is_Incomplete (Defer_Res_134) then
            Transform_Res_79.Last_Attempted_Child := 0;
         elsif Defer_Res_134 /= null and then not Is_Ghost (Defer_Res_134) then
            Transform_Res_79.Last_Attempted_Child := -1;
         end if;
         if List_Res_10 /= null and then Is_Incomplete (List_Res_10) then
            Transform_Res_79.Last_Attempted_Child := 0;
         elsif List_Res_10 /= null and then not Is_Ghost (List_Res_10) then
            Transform_Res_79.Last_Attempted_Child := -1;
         end if;


end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Case_Expr_Transform_Parse_0_Memo,
      Row_Pos_90 /= No_Token_Index,
      Transform_Res_79,
      Pos,
      Row_Pos_90);


   Parser.Current_Pos := Row_Pos_90;

   return Transform_Res_79;
end Case_Expr_Transform_Parse_0;

   


function Quantified_Expr_Transform_Parse_2
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Quantified_Expr
is
   use Bare_Quantified_Expr_Memos;

      Row_Pos_92 :
            Token_Index
               := No_Token_Index;
      Token_Pos_112 :
            Token_Index
               := No_Token_Index;
      Token_Res_112 :
            Token_Index
               := No_Token_Index;
      Row_Pos_93 :
            Token_Index
               := No_Token_Index;
      Token_Pos_113 :
            Token_Index
               := No_Token_Index;
      Token_Res_113 :
            Token_Index
               := No_Token_Index;
      Transform_Res_81 :
            Bare_Quantifier_All
               := No_Bare_Ada_Node;
      Row_Pos_94 :
            Token_Index
               := No_Token_Index;
      Token_Pos_114 :
            Token_Index
               := No_Token_Index;
      Token_Res_114 :
            Token_Index
               := No_Token_Index;
      Transform_Res_82 :
            Bare_Quantifier_Some
               := No_Bare_Ada_Node;
      Or_Pos_35 :
            Token_Index
               := No_Token_Index;
      Or_Res_35 :
            Bare_Quantifier
               := No_Bare_Ada_Node;
      Defer_Pos_138 :
            Token_Index
               := No_Token_Index;
      Defer_Res_138 :
            Bare_For_Loop_Spec
               := No_Bare_Ada_Node;
      Token_Pos_115 :
            Token_Index
               := No_Token_Index;
      Token_Res_115 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_139 :
            Token_Index
               := No_Token_Index;
      Defer_Res_139 :
            Bare_Expr
               := No_Bare_Ada_Node;
      Defer_Pos_140 :
            Token_Index
               := No_Token_Index;
      Defer_Res_140 :
            Bare_Expr
               := No_Bare_Ada_Node;
      Or_Pos_36 :
            Token_Index
               := No_Token_Index;
      Or_Res_36 :
            Bare_Expr
               := No_Bare_Ada_Node;
      Transform_Res_83 :
            Bare_Quantified_Expr
               := No_Bare_Ada_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Quantified_Expr_Transform_Parse_2_Memo, Pos);

begin

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res_83 := M.Instance;
      return Transform_Res_83;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res_83;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code


--  Start row_code

Row_Pos_92 := Pos;



--  Start tok_code

Token_Res_112 := Row_Pos_92;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_112));
begin
   if
      T.Kind /= From_Token_Kind (Ada_For)
   then
       Token_Pos_112 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_92 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_92,
             Expected_Token_Id => Ada_For,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_112 := Row_Pos_92 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_112 /= No_Token_Index then

   Row_Pos_92 := Token_Pos_112;

else
   Row_Pos_92 := No_Token_Index;
   goto Exit_Row_81_0;

end if;


--  Start or_code

Or_Pos_35 := No_Token_Index;
Or_Res_35 := No_Bare_Ada_Node;
    
--  Start transform_code


--  Start row_code

Row_Pos_93 := Row_Pos_92;



--  Start tok_code

Token_Res_113 := Row_Pos_93;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_113));
begin
   if
      T.Kind /= From_Token_Kind (Ada_All)
   then
       Token_Pos_113 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_93 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_93,
             Expected_Token_Id => Ada_All,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_113 := Row_Pos_93 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_113 /= No_Token_Index then

   Row_Pos_93 := Token_Pos_113;

else
   Row_Pos_93 := No_Token_Index;
   goto Exit_Row_82_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_82_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_93 /= No_Token_Index then

   Transform_Res_81 := Allocate_Quantifier_All (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_81,
      Kind => Ada_Quantifier_All,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos_92,
      Token_End_Index   => (if Row_Pos_93 = Row_Pos_92
                            then No_Token_Index
                            else Row_Pos_93 - 1));




end if;

--  End transform_code

    if Row_Pos_93 /= No_Token_Index then
        Or_Pos_35 := Row_Pos_93;
        Or_Res_35 := Transform_Res_81;
        goto Exit_Or_34;
    end if;
    
--  Start transform_code


--  Start row_code

Row_Pos_94 := Row_Pos_92;



--  Start tok_code

Token_Res_114 := Row_Pos_94;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_114));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Identifier)
      or else T.Symbol /= Precomputed_Symbol
        (Precomputed_Symbol_Table (Parser.TDH.Symbols),
         Precomputed_Symbol_Some)
   then
       Token_Pos_114 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_94 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_94,
             Expected_Token_Id => Ada_Identifier,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_114 := Row_Pos_94 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_114 /= No_Token_Index then

   Row_Pos_94 := Token_Pos_114;

else
   Row_Pos_94 := No_Token_Index;
   goto Exit_Row_83_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_83_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_94 /= No_Token_Index then

   Transform_Res_82 := Allocate_Quantifier_Some (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_82,
      Kind => Ada_Quantifier_Some,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos_92,
      Token_End_Index   => (if Row_Pos_94 = Row_Pos_92
                            then No_Token_Index
                            else Row_Pos_94 - 1));




end if;

--  End transform_code

    if Row_Pos_94 /= No_Token_Index then
        Or_Pos_35 := Row_Pos_94;
        Or_Res_35 := Transform_Res_82;
        goto Exit_Or_34;
    end if;
<<Exit_Or_34>>

--  End or_code



if Or_Pos_35 /= No_Token_Index then

   Row_Pos_92 := Or_Pos_35;

else
   Row_Pos_92 := No_Token_Index;
   goto Exit_Row_81_0;

end if;


Defer_Res_138 :=
   For_Loop_Param_Spec_Transform_Parse_3 (Parser, Row_Pos_92);
Defer_Pos_138 := Parser.Current_Pos;



if Defer_Pos_138 /= No_Token_Index then

   Row_Pos_92 := Defer_Pos_138;

else
   Row_Pos_92 := No_Token_Index;
   goto Exit_Row_81_0;

end if;


--  Start tok_code

Token_Res_115 := Row_Pos_92;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_115));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Arrow)
   then
       Token_Pos_115 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_92 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_92,
             Expected_Token_Id => Ada_Arrow,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_115 := Row_Pos_92 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_115 /= No_Token_Index then

   Row_Pos_92 := Token_Pos_115;

else
   Row_Pos_92 := No_Token_Index;
   goto Exit_Row_81_0;

end if;


--  Start or_code

Or_Pos_36 := No_Token_Index;
Or_Res_36 := No_Bare_Ada_Node;
    
Defer_Res_139 :=
   Expr_Or_Parse_0 (Parser, Row_Pos_92);
Defer_Pos_139 := Parser.Current_Pos;

    if Defer_Pos_139 /= No_Token_Index then
        Or_Pos_36 := Defer_Pos_139;
        Or_Res_36 := Defer_Res_139;
        goto Exit_Or_35;
    end if;
    
Defer_Res_140 :=
   Discrete_Range_Or_Parse_0 (Parser, Row_Pos_92);
Defer_Pos_140 := Parser.Current_Pos;

    if Defer_Pos_140 /= No_Token_Index then
        Or_Pos_36 := Defer_Pos_140;
        Or_Res_36 := Defer_Res_140;
        goto Exit_Or_35;
    end if;
<<Exit_Or_35>>

--  End or_code



if Or_Pos_36 /= No_Token_Index then

   Row_Pos_92 := Or_Pos_36;

else
   Row_Pos_92 := No_Token_Index;
   goto Exit_Row_81_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_81_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_92 /= No_Token_Index then

   Transform_Res_83 := Allocate_Quantified_Expr (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_83,
      Kind => Ada_Quantified_Expr,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_92 = Pos
                            then No_Token_Index
                            else Row_Pos_92 - 1));

      Initialize_Fields_For_Quantified_Expr
        (Self => Transform_Res_83, Quantified_Expr_F_Quantifier => Or_Res_35, Quantified_Expr_F_Loop_Spec => Defer_Res_138, Quantified_Expr_F_Expr => Or_Res_36);

         if Or_Res_35 /= null and then Is_Incomplete (Or_Res_35) then
            Transform_Res_83.Last_Attempted_Child := 0;
         elsif Or_Res_35 /= null and then not Is_Ghost (Or_Res_35) then
            Transform_Res_83.Last_Attempted_Child := -1;
         end if;
         if Defer_Res_138 /= null and then Is_Incomplete (Defer_Res_138) then
            Transform_Res_83.Last_Attempted_Child := 0;
         elsif Defer_Res_138 /= null and then not Is_Ghost (Defer_Res_138) then
            Transform_Res_83.Last_Attempted_Child := -1;
         end if;
         if Or_Res_36 /= null and then Is_Incomplete (Or_Res_36) then
            Transform_Res_83.Last_Attempted_Child := 0;
         elsif Or_Res_36 /= null and then not Is_Ghost (Or_Res_36) then
            Transform_Res_83.Last_Attempted_Child := -1;
         end if;


end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Quantified_Expr_Transform_Parse_2_Memo,
      Row_Pos_92 /= No_Token_Index,
      Transform_Res_83,
      Pos,
      Row_Pos_92);


   Parser.Current_Pos := Row_Pos_92;

   return Transform_Res_83;
end Quantified_Expr_Transform_Parse_2;

   


function Conditional_Expr_Or_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr
is
   use Bare_Expr_Memos;

      Defer_Pos_126 :
            Token_Index
               := No_Token_Index;
      Defer_Res_126 :
            Bare_If_Expr
               := No_Bare_Ada_Node;
      Defer_Pos_127 :
            Token_Index
               := No_Token_Index;
      Defer_Res_127 :
            Bare_Case_Expr
               := No_Bare_Ada_Node;
      Defer_Pos_128 :
            Token_Index
               := No_Token_Index;
      Defer_Res_128 :
            Bare_Quantified_Expr
               := No_Bare_Ada_Node;
      Or_Pos_34 :
            Token_Index
               := No_Token_Index;
      Or_Res_34 :
            Bare_Expr
               := No_Bare_Ada_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Conditional_Expr_Or_Parse_0_Memo, Pos);

begin

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Or_Res_34 := M.Instance;
      return Or_Res_34;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Or_Res_34;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start or_code

Or_Pos_34 := No_Token_Index;
Or_Res_34 := No_Bare_Ada_Node;
    
Defer_Res_126 :=
   If_Expr_Transform_Parse_1 (Parser, Pos);
Defer_Pos_126 := Parser.Current_Pos;

    if Defer_Pos_126 /= No_Token_Index then
        Or_Pos_34 := Defer_Pos_126;
        Or_Res_34 := Defer_Res_126;
        goto Exit_Or_33;
    end if;
    
Defer_Res_127 :=
   Case_Expr_Transform_Parse_0 (Parser, Pos);
Defer_Pos_127 := Parser.Current_Pos;

    if Defer_Pos_127 /= No_Token_Index then
        Or_Pos_34 := Defer_Pos_127;
        Or_Res_34 := Defer_Res_127;
        goto Exit_Or_33;
    end if;
    
Defer_Res_128 :=
   Quantified_Expr_Transform_Parse_2 (Parser, Pos);
Defer_Pos_128 := Parser.Current_Pos;

    if Defer_Pos_128 /= No_Token_Index then
        Or_Pos_34 := Defer_Pos_128;
        Or_Res_34 := Defer_Res_128;
        goto Exit_Or_33;
    end if;
<<Exit_Or_33>>

--  End or_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Conditional_Expr_Or_Parse_0_Memo,
      Or_Pos_34 /= No_Token_Index,
      Or_Res_34,
      Pos,
      Or_Pos_34);


   Parser.Current_Pos := Or_Pos_34;

   return Or_Res_34;
end Conditional_Expr_Or_Parse_0;

   


function Raise_Expr_Or_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Raise_Expr
is
   use Bare_Raise_Expr_Memos;

      Row_Pos_95 :
            Token_Index
               := No_Token_Index;
      Token_Pos_116 :
            Token_Index
               := No_Token_Index;
      Token_Res_116 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_141 :
            Token_Index
               := No_Token_Index;
      Defer_Res_141 :
            Bare_Name
               := No_Bare_Ada_Node;
      Row_Pos_96 :
            Token_Index
               := No_Token_Index;
      Token_Pos_117 :
            Token_Index
               := No_Token_Index;
      Token_Res_117 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_142 :
            Token_Index
               := No_Token_Index;
      Defer_Res_142 :
            Bare_Expr
               := No_Bare_Ada_Node;
      Transform_Res_84 :
            Bare_Raise_Expr
               := No_Bare_Ada_Node;
      Row_Pos_97 :
            Token_Index
               := No_Token_Index;
      Token_Pos_118 :
            Token_Index
               := No_Token_Index;
      Token_Res_118 :
            Token_Index
               := No_Token_Index;
      Null_Res_3 :
            Bare_Name
               := No_Bare_Ada_Node;
      Null_Res_4 :
            Bare_Expr
               := No_Bare_Ada_Node;
      Transform_Res_85 :
            Bare_Raise_Expr
               := No_Bare_Ada_Node;
      Or_Pos_37 :
            Token_Index
               := No_Token_Index;
      Or_Res_37 :
            Bare_Raise_Expr
               := No_Bare_Ada_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Raise_Expr_Or_Parse_0_Memo, Pos);

begin

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Or_Res_37 := M.Instance;
      return Or_Res_37;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Or_Res_37;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start or_code

Or_Pos_37 := No_Token_Index;
Or_Res_37 := No_Bare_Ada_Node;
    
--  Start transform_code


--  Start row_code

Row_Pos_95 := Pos;



--  Start tok_code

Token_Res_116 := Row_Pos_95;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_116));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Raise)
   then
       Token_Pos_116 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_95 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_95,
             Expected_Token_Id => Ada_Raise,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_116 := Row_Pos_95 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_116 /= No_Token_Index then

   Row_Pos_95 := Token_Pos_116;

else
   Row_Pos_95 := No_Token_Index;
   goto Exit_Row_84_0;

end if;


Defer_Res_141 :=
   Name_Or_Parse_1 (Parser, Row_Pos_95);
Defer_Pos_141 := Parser.Current_Pos;



if Defer_Pos_141 /= No_Token_Index then

   Row_Pos_95 := Defer_Pos_141;

else
   Row_Pos_95 := No_Token_Index;
   goto Exit_Row_84_0;

end if;


--  Start opt_code




--  Start row_code

Row_Pos_96 := Row_Pos_95;



--  Start tok_code

Token_Res_117 := Row_Pos_96;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_117));
begin
   if
      T.Kind /= From_Token_Kind (Ada_With)
   then
       Token_Pos_117 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_96 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_96,
             Expected_Token_Id => Ada_With,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_117 := Row_Pos_96 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_117 /= No_Token_Index then

   Row_Pos_96 := Token_Pos_117;

else
   Row_Pos_96 := No_Token_Index;
   goto Exit_Row_85_0;

end if;


Defer_Res_142 :=
   Expr_Or_Parse_0 (Parser, Row_Pos_96);
Defer_Pos_142 := Parser.Current_Pos;



if Defer_Pos_142 /= No_Token_Index then

   Row_Pos_96 := Defer_Pos_142;

else
   Row_Pos_96 := No_Token_Index;
   goto Exit_Row_85_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_85_0>>
pragma Warnings (On, "referenced");

--  End row_code


if Row_Pos_96 = No_Token_Index then

        Defer_Res_142 := No_Bare_Ada_Node;


    Row_Pos_96 := Row_Pos_95;


end if;

--  End opt_code



if Row_Pos_96 /= No_Token_Index then

   Row_Pos_95 := Row_Pos_96;

else
   Row_Pos_95 := No_Token_Index;
   goto Exit_Row_84_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_84_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_95 /= No_Token_Index then

   Transform_Res_84 := Allocate_Raise_Expr (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_84,
      Kind => Ada_Raise_Expr,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_95 = Pos
                            then No_Token_Index
                            else Row_Pos_95 - 1));

      Initialize_Fields_For_Raise_Expr
        (Self => Transform_Res_84, Raise_Expr_F_Exception_Name => Defer_Res_141, Raise_Expr_F_Error_Message => Defer_Res_142);

         if Defer_Res_141 /= null and then Is_Incomplete (Defer_Res_141) then
            Transform_Res_84.Last_Attempted_Child := 0;
         elsif Defer_Res_141 /= null and then not Is_Ghost (Defer_Res_141) then
            Transform_Res_84.Last_Attempted_Child := -1;
         end if;
         if Defer_Res_142 /= null and then Is_Incomplete (Defer_Res_142) then
            Transform_Res_84.Last_Attempted_Child := 0;
         elsif Defer_Res_142 /= null and then not Is_Ghost (Defer_Res_142) then
            Transform_Res_84.Last_Attempted_Child := -1;
         end if;


end if;

--  End transform_code

    if Row_Pos_95 /= No_Token_Index then
        Or_Pos_37 := Row_Pos_95;
        Or_Res_37 := Transform_Res_84;
        goto Exit_Or_36;
    end if;
    
--  Start transform_code


--  Start row_code

Row_Pos_97 := Pos;



--  Start tok_code

Token_Res_118 := Row_Pos_97;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_118));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Raise)
   then
       Token_Pos_118 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_97 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_97,
             Expected_Token_Id => Ada_Raise,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_118 := Row_Pos_97 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_118 /= No_Token_Index then

   Row_Pos_97 := Token_Pos_118;

else
   Row_Pos_97 := No_Token_Index;
   goto Exit_Row_86_0;

end if;


   Null_Res_3 := No_Bare_Ada_Node;



if Row_Pos_97 /= No_Token_Index then

   Row_Pos_97 := Row_Pos_97;

else
   Row_Pos_97 := No_Token_Index;
   goto Exit_Row_86_0;

end if;


   Null_Res_4 := No_Bare_Ada_Node;



if Row_Pos_97 /= No_Token_Index then

   Row_Pos_97 := Row_Pos_97;

else
   Row_Pos_97 := No_Token_Index;
   goto Exit_Row_86_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_86_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_97 /= No_Token_Index then

   Transform_Res_85 := Allocate_Raise_Expr (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_85,
      Kind => Ada_Raise_Expr,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_97 = Pos
                            then No_Token_Index
                            else Row_Pos_97 - 1));

      Initialize_Fields_For_Raise_Expr
        (Self => Transform_Res_85, Raise_Expr_F_Exception_Name => Null_Res_3, Raise_Expr_F_Error_Message => Null_Res_4);

         if Null_Res_3 /= null and then Is_Incomplete (Null_Res_3) then
            Transform_Res_85.Last_Attempted_Child := 0;
         elsif Null_Res_3 /= null and then not Is_Ghost (Null_Res_3) then
            Transform_Res_85.Last_Attempted_Child := -1;
         end if;
         if Null_Res_4 /= null and then Is_Incomplete (Null_Res_4) then
            Transform_Res_85.Last_Attempted_Child := 0;
         elsif Null_Res_4 /= null and then not Is_Ghost (Null_Res_4) then
            Transform_Res_85.Last_Attempted_Child := -1;
         end if;


end if;

--  End transform_code

    if Row_Pos_97 /= No_Token_Index then
        Or_Pos_37 := Row_Pos_97;
        Or_Res_37 := Transform_Res_85;
        goto Exit_Or_36;
    end if;
<<Exit_Or_36>>

--  End or_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Raise_Expr_Or_Parse_0_Memo,
      Or_Pos_37 /= No_Token_Index,
      Or_Res_37,
      Pos,
      Or_Pos_37);


   Parser.Current_Pos := Or_Pos_37;

   return Or_Res_37;
end Raise_Expr_Or_Parse_0;

   


function Defining_Id_List_List_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Defining_Name_List
is
   use Bare_Defining_Name_List_Memos;

      Lst_Cpos_12 :
            Token_Index
               := No_Token_Index;
      Tmp_List_12 :
            Free_Parse_List;
      Defer_Pos_155 :
            Token_Index
               := No_Token_Index;
      Defer_Res_155 :
            Bare_Defining_Name
               := No_Bare_Ada_Node;
      Token_Pos_126 :
            Token_Index
               := No_Token_Index;
      Token_Res_126 :
            Token_Index
               := No_Token_Index;
      List_Pos_12 :
            Token_Index
               := No_Token_Index;
      List_Res_12 :
            Bare_Defining_Name_List
               := No_Bare_Ada_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Defining_Id_List_List_Parse_0_Memo, Pos);

begin

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      List_Res_12 := M.Instance;
      return List_Res_12;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return List_Res_12;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start list_code

    List_Pos_12 := No_Token_Index;



Lst_Cpos_12 := Pos;
Tmp_List_12 := Get_Parse_List (Parser);

loop
   
Defer_Res_155 :=
   Defining_Id_Transform_Parse_0 (Parser, Lst_Cpos_12);
Defer_Pos_155 := Parser.Current_Pos;


   exit when Defer_Pos_155 = No_Token_Index;

   List_Pos_12 := Defer_Pos_155;
   Lst_Cpos_12 := List_Pos_12;

   Tmp_List_12.Nodes.Append (Defer_Res_155);

      
--  Start tok_code

Token_Res_126 := Lst_Cpos_12;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_126));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Comma)
   then
       Token_Pos_126 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Lst_Cpos_12 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Lst_Cpos_12,
             Expected_Token_Id => Ada_Comma,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_126 := Lst_Cpos_12 + 1;
   end if;
end;

--  End tok_code

      if Token_Pos_126 /= No_Token_Index then
          Lst_Cpos_12 := Token_Pos_126;
      else
         exit;
      end if;

end loop;

declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List_12.Nodes.Length;
begin
   List_Res_12 :=
      Allocate_Defining_Name_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Pos;
      Token_End := (if Lst_Cpos_12 = Pos
                    then Pos
                    else Lst_Cpos_12 - 1);

   else
      Token_Start := Token_Index'Max (Pos, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res_12,
      Kind              => Ada_Defining_Name_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res_12,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_Ada_Node_Vectors.Vector renames
         Tmp_List_12.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res_12.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List_12);

--  End list_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Defining_Id_List_List_Parse_0_Memo,
      List_Pos_12 /= No_Token_Index,
      List_Res_12,
      Pos,
      List_Pos_12);


   Parser.Current_Pos := List_Pos_12;

   return List_Res_12;
end Defining_Id_List_List_Parse_0;

   


function Mode_Or_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Mode
is
   use Bare_Mode_Memos;

      Row_Pos_101 :
            Token_Index
               := No_Token_Index;
      Token_Pos_127 :
            Token_Index
               := No_Token_Index;
      Token_Res_127 :
            Token_Index
               := No_Token_Index;
      Token_Pos_128 :
            Token_Index
               := No_Token_Index;
      Token_Res_128 :
            Token_Index
               := No_Token_Index;
      Transform_Res_88 :
            Bare_Mode_In_Out
               := No_Bare_Ada_Node;
      Row_Pos_102 :
            Token_Index
               := No_Token_Index;
      Token_Pos_129 :
            Token_Index
               := No_Token_Index;
      Token_Res_129 :
            Token_Index
               := No_Token_Index;
      Transform_Res_89 :
            Bare_Mode_In
               := No_Bare_Ada_Node;
      Row_Pos_103 :
            Token_Index
               := No_Token_Index;
      Token_Pos_130 :
            Token_Index
               := No_Token_Index;
      Token_Res_130 :
            Token_Index
               := No_Token_Index;
      Transform_Res_90 :
            Bare_Mode_Out
               := No_Bare_Ada_Node;
      Row_Pos_104 :
            Token_Index
               := No_Token_Index;
      Transform_Res_91 :
            Bare_Mode_Default
               := No_Bare_Ada_Node;
      Or_Pos_39 :
            Token_Index
               := No_Token_Index;
      Or_Res_39 :
            Bare_Mode
               := No_Bare_Ada_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Mode_Or_Parse_0_Memo, Pos);

begin

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Or_Res_39 := M.Instance;
      return Or_Res_39;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Or_Res_39;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start or_code

Or_Pos_39 := No_Token_Index;
Or_Res_39 := No_Bare_Ada_Node;
    
--  Start transform_code


--  Start row_code

Row_Pos_101 := Pos;



--  Start tok_code

Token_Res_127 := Row_Pos_101;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_127));
begin
   if
      T.Kind /= From_Token_Kind (Ada_In)
   then
       Token_Pos_127 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_101 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_101,
             Expected_Token_Id => Ada_In,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_127 := Row_Pos_101 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_127 /= No_Token_Index then

   Row_Pos_101 := Token_Pos_127;

else
   Row_Pos_101 := No_Token_Index;
   goto Exit_Row_89_0;

end if;


--  Start tok_code

Token_Res_128 := Row_Pos_101;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_128));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Out)
   then
       Token_Pos_128 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_101 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_101,
             Expected_Token_Id => Ada_Out,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_128 := Row_Pos_101 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_128 /= No_Token_Index then

   Row_Pos_101 := Token_Pos_128;

else
   Row_Pos_101 := No_Token_Index;
   goto Exit_Row_89_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_89_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_101 /= No_Token_Index then

   Transform_Res_88 := Allocate_Mode_In_Out (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_88,
      Kind => Ada_Mode_In_Out,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_101 = Pos
                            then No_Token_Index
                            else Row_Pos_101 - 1));




end if;

--  End transform_code

    if Row_Pos_101 /= No_Token_Index then
        Or_Pos_39 := Row_Pos_101;
        Or_Res_39 := Transform_Res_88;
        goto Exit_Or_38;
    end if;
    
--  Start transform_code


--  Start row_code

Row_Pos_102 := Pos;



--  Start tok_code

Token_Res_129 := Row_Pos_102;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_129));
begin
   if
      T.Kind /= From_Token_Kind (Ada_In)
   then
       Token_Pos_129 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_102 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_102,
             Expected_Token_Id => Ada_In,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_129 := Row_Pos_102 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_129 /= No_Token_Index then

   Row_Pos_102 := Token_Pos_129;

else
   Row_Pos_102 := No_Token_Index;
   goto Exit_Row_90_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_90_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_102 /= No_Token_Index then

   Transform_Res_89 := Allocate_Mode_In (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_89,
      Kind => Ada_Mode_In,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_102 = Pos
                            then No_Token_Index
                            else Row_Pos_102 - 1));




end if;

--  End transform_code

    if Row_Pos_102 /= No_Token_Index then
        Or_Pos_39 := Row_Pos_102;
        Or_Res_39 := Transform_Res_89;
        goto Exit_Or_38;
    end if;
    
--  Start transform_code


--  Start row_code

Row_Pos_103 := Pos;



--  Start tok_code

Token_Res_130 := Row_Pos_103;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_130));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Out)
   then
       Token_Pos_130 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_103 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_103,
             Expected_Token_Id => Ada_Out,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_130 := Row_Pos_103 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_130 /= No_Token_Index then

   Row_Pos_103 := Token_Pos_130;

else
   Row_Pos_103 := No_Token_Index;
   goto Exit_Row_91_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_91_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_103 /= No_Token_Index then

   Transform_Res_90 := Allocate_Mode_Out (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_90,
      Kind => Ada_Mode_Out,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_103 = Pos
                            then No_Token_Index
                            else Row_Pos_103 - 1));




end if;

--  End transform_code

    if Row_Pos_103 /= No_Token_Index then
        Or_Pos_39 := Row_Pos_103;
        Or_Res_39 := Transform_Res_90;
        goto Exit_Or_38;
    end if;
    
--  Start transform_code


--  Start row_code

Row_Pos_104 := Pos;


pragma Warnings (Off, "referenced");
<<Exit_Row_92_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_104 /= No_Token_Index then

   Transform_Res_91 := Allocate_Mode_Default (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_91,
      Kind => Ada_Mode_Default,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_104 = Pos
                            then No_Token_Index
                            else Row_Pos_104 - 1));




end if;

--  End transform_code

    if Row_Pos_104 /= No_Token_Index then
        Or_Pos_39 := Row_Pos_104;
        Or_Res_39 := Transform_Res_91;
        goto Exit_Or_38;
    end if;
<<Exit_Or_38>>

--  End or_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Mode_Or_Parse_0_Memo,
      Or_Pos_39 /= No_Token_Index,
      Or_Res_39,
      Pos,
      Or_Pos_39);


   Parser.Current_Pos := Or_Pos_39;

   return Or_Res_39;
end Mode_Or_Parse_0;

   


function Unconstrained_Index_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Unconstrained_Array_Index
is
   use Bare_Unconstrained_Array_Index_Memos;

      Row_Pos_110 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_165 :
            Token_Index
               := No_Token_Index;
      Defer_Res_165 :
            Bare_Subtype_Indication
               := No_Bare_Ada_Node;
      Token_Pos_136 :
            Token_Index
               := No_Token_Index;
      Token_Res_136 :
            Token_Index
               := No_Token_Index;
      Token_Pos_137 :
            Token_Index
               := No_Token_Index;
      Token_Res_137 :
            Token_Index
               := No_Token_Index;
      Transform_Res_97 :
            Bare_Unconstrained_Array_Index
               := No_Bare_Ada_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Unconstrained_Index_Transform_Parse_0_Memo, Pos);

begin

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res_97 := M.Instance;
      return Transform_Res_97;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res_97;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code


--  Start row_code

Row_Pos_110 := Pos;



Defer_Res_165 :=
   Subtype_Indication_Transform_Parse_0 (Parser, Row_Pos_110);
Defer_Pos_165 := Parser.Current_Pos;



if Defer_Pos_165 /= No_Token_Index then

   Row_Pos_110 := Defer_Pos_165;

else
   Row_Pos_110 := No_Token_Index;
   goto Exit_Row_97_0;

end if;


--  Start tok_code

Token_Res_136 := Row_Pos_110;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_136));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Range)
   then
       Token_Pos_136 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_110 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_110,
             Expected_Token_Id => Ada_Range,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_136 := Row_Pos_110 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_136 /= No_Token_Index then

   Row_Pos_110 := Token_Pos_136;

else
   Row_Pos_110 := No_Token_Index;
   goto Exit_Row_97_0;

end if;


--  Start tok_code

Token_Res_137 := Row_Pos_110;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_137));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Diamond)
   then
       Token_Pos_137 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_110 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_110,
             Expected_Token_Id => Ada_Diamond,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_137 := Row_Pos_110 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_137 /= No_Token_Index then

   Row_Pos_110 := Token_Pos_137;

else
   Row_Pos_110 := No_Token_Index;
   goto Exit_Row_97_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_97_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_110 /= No_Token_Index then

   Transform_Res_97 := Allocate_Unconstrained_Array_Index (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_97,
      Kind => Ada_Unconstrained_Array_Index,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_110 = Pos
                            then No_Token_Index
                            else Row_Pos_110 - 1));

      Initialize_Fields_For_Unconstrained_Array_Index
        (Self => Transform_Res_97, Unconstrained_Array_Index_F_Subtype_Indication => Defer_Res_165);

         if Defer_Res_165 /= null and then Is_Incomplete (Defer_Res_165) then
            Transform_Res_97.Last_Attempted_Child := 0;
         elsif Defer_Res_165 /= null and then not Is_Ghost (Defer_Res_165) then
            Transform_Res_97.Last_Attempted_Child := -1;
         end if;


end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Unconstrained_Index_Transform_Parse_0_Memo,
      Row_Pos_110 /= No_Token_Index,
      Transform_Res_97,
      Pos,
      Row_Pos_110);


   Parser.Current_Pos := Row_Pos_110;

   return Transform_Res_97;
end Unconstrained_Index_Transform_Parse_0;

   


function Component_Def_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Component_Def
is
   use Bare_Component_Def_Memos;

      Row_Pos_111 :
            Token_Index
               := No_Token_Index;
      Token_Pos_138 :
            Token_Index
               := No_Token_Index;
      Token_Res_138 :
            Token_Index
               := No_Token_Index;
      Opt_Res_5 :
            Bare_Aliased_Node
               := No_Bare_Ada_Node;
      Token_Pos_139 :
            Token_Index
               := No_Token_Index;
      Token_Res_139 :
            Token_Index
               := No_Token_Index;
      Opt_Res_6 :
            Bare_Constant_Node
               := No_Bare_Ada_Node;
      Defer_Pos_166 :
            Token_Index
               := No_Token_Index;
      Defer_Res_166 :
            Bare_Type_Expr
               := No_Bare_Ada_Node;
      Transform_Res_98 :
            Bare_Component_Def
               := No_Bare_Ada_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Component_Def_Transform_Parse_0_Memo, Pos);

begin

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res_98 := M.Instance;
      return Transform_Res_98;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res_98;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code


--  Start row_code

Row_Pos_111 := Pos;



--  Start opt_code




--  Start tok_code

Token_Res_138 := Row_Pos_111;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_138));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Identifier)
      or else T.Symbol /= Precomputed_Symbol
        (Precomputed_Symbol_Table (Parser.TDH.Symbols),
         Precomputed_Symbol_Aliased)
   then
       Token_Pos_138 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_111 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_111,
             Expected_Token_Id => Ada_Identifier,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_138 := Row_Pos_111 + 1;
   end if;
end;

--  End tok_code


if Token_Pos_138 = No_Token_Index then

         Opt_Res_5 := Allocate_Aliased_Absent (Parser.Mem_Pool);
         Initialize
           (Self              => Opt_Res_5,
            Kind              => Ada_Aliased_Absent,
            Unit              => Parser.Unit,
            Token_Start_Index => Row_Pos_111,
            Token_End_Index   => No_Token_Index);


    Token_Pos_138 := Row_Pos_111;

else

      Opt_Res_5 := Allocate_Aliased_Present (Parser.Mem_Pool);
      Initialize
        (Self              => Opt_Res_5,
         Kind              => Ada_Aliased_Present,
         Unit              => Parser.Unit,
         Token_Start_Index => Row_Pos_111,
         Token_End_Index   => Token_Pos_138 - 1);

end if;

--  End opt_code



if Token_Pos_138 /= No_Token_Index then

   Row_Pos_111 := Token_Pos_138;

else
   Row_Pos_111 := No_Token_Index;
   goto Exit_Row_99_0;

end if;


--  Start opt_code




--  Start tok_code

Token_Res_139 := Row_Pos_111;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_139));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Constant)
   then
       Token_Pos_139 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_111 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_111,
             Expected_Token_Id => Ada_Constant,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_139 := Row_Pos_111 + 1;
   end if;
end;

--  End tok_code


if Token_Pos_139 = No_Token_Index then

         Opt_Res_6 := Allocate_Constant_Absent (Parser.Mem_Pool);
         Initialize
           (Self              => Opt_Res_6,
            Kind              => Ada_Constant_Absent,
            Unit              => Parser.Unit,
            Token_Start_Index => Row_Pos_111,
            Token_End_Index   => No_Token_Index);


    Token_Pos_139 := Row_Pos_111;

else

      Opt_Res_6 := Allocate_Constant_Present (Parser.Mem_Pool);
      Initialize
        (Self              => Opt_Res_6,
         Kind              => Ada_Constant_Present,
         Unit              => Parser.Unit,
         Token_Start_Index => Row_Pos_111,
         Token_End_Index   => Token_Pos_139 - 1);

end if;

--  End opt_code



if Token_Pos_139 /= No_Token_Index then

   Row_Pos_111 := Token_Pos_139;

else
   Row_Pos_111 := No_Token_Index;
   goto Exit_Row_99_0;

end if;


Defer_Res_166 :=
   Type_Expr_Or_Parse_0 (Parser, Row_Pos_111);
Defer_Pos_166 := Parser.Current_Pos;



if Defer_Pos_166 /= No_Token_Index then

   Row_Pos_111 := Defer_Pos_166;

else
   Row_Pos_111 := No_Token_Index;
   goto Exit_Row_99_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_99_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_111 /= No_Token_Index then

   Transform_Res_98 := Allocate_Component_Def (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_98,
      Kind => Ada_Component_Def,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_111 = Pos
                            then No_Token_Index
                            else Row_Pos_111 - 1));

      Initialize_Fields_For_Component_Def
        (Self => Transform_Res_98, Component_Def_F_Has_Aliased => Opt_Res_5, Component_Def_F_Has_Constant => Opt_Res_6, Component_Def_F_Type_Expr => Defer_Res_166);

         if Opt_Res_5 /= null and then Is_Incomplete (Opt_Res_5) then
            Transform_Res_98.Last_Attempted_Child := 0;
         elsif Opt_Res_5 /= null and then not Is_Ghost (Opt_Res_5) then
            Transform_Res_98.Last_Attempted_Child := -1;
         end if;
         if Opt_Res_6 /= null and then Is_Incomplete (Opt_Res_6) then
            Transform_Res_98.Last_Attempted_Child := 0;
         elsif Opt_Res_6 /= null and then not Is_Ghost (Opt_Res_6) then
            Transform_Res_98.Last_Attempted_Child := -1;
         end if;
         if Defer_Res_166 /= null and then Is_Incomplete (Defer_Res_166) then
            Transform_Res_98.Last_Attempted_Child := 0;
         elsif Defer_Res_166 /= null and then not Is_Ghost (Defer_Res_166) then
            Transform_Res_98.Last_Attempted_Child := -1;
         end if;


end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Component_Def_Transform_Parse_0_Memo,
      Row_Pos_111 /= No_Token_Index,
      Transform_Res_98,
      Pos,
      Row_Pos_111);


   Parser.Current_Pos := Row_Pos_111;

   return Transform_Res_98;
end Component_Def_Transform_Parse_0;

   


function Array_Type_Def_Transform_Parse_2
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Array_Type_Def
is
   use Bare_Array_Type_Def_Memos;

      Row_Pos_107 :
            Token_Index
               := No_Token_Index;
      Token_Pos_131 :
            Token_Index
               := No_Token_Index;
      Token_Res_131 :
            Token_Index
               := No_Token_Index;
      Token_Pos_132 :
            Token_Index
               := No_Token_Index;
      Token_Res_132 :
            Token_Index
               := No_Token_Index;
      Row_Pos_108 :
            Token_Index
               := No_Token_Index;
      Lst_Cpos_13 :
            Token_Index
               := No_Token_Index;
      Tmp_List_13 :
            Free_Parse_List;
      Defer_Pos_162 :
            Token_Index
               := No_Token_Index;
      Defer_Res_162 :
            Bare_Unconstrained_Array_Index
               := No_Bare_Ada_Node;
      Token_Pos_133 :
            Token_Index
               := No_Token_Index;
      Token_Res_133 :
            Token_Index
               := No_Token_Index;
      List_Pos_13 :
            Token_Index
               := No_Token_Index;
      List_Res_13 :
            Bare_Unconstrained_Array_Index_List
               := No_Bare_Ada_Node;
      Transform_Res_94 :
            Bare_Unconstrained_Array_Indices
               := No_Bare_Ada_Node;
      Row_Pos_109 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_163 :
            Token_Index
               := No_Token_Index;
      Defer_Res_163 :
            Bare_Constraint_List
               := No_Bare_Ada_Node;
      Transform_Res_95 :
            Bare_Constrained_Array_Indices
               := No_Bare_Ada_Node;
      Or_Pos_42 :
            Token_Index
               := No_Token_Index;
      Or_Res_42 :
            Bare_Array_Indices
               := No_Bare_Ada_Node;
      Token_Pos_134 :
            Token_Index
               := No_Token_Index;
      Token_Res_134 :
            Token_Index
               := No_Token_Index;
      Token_Pos_135 :
            Token_Index
               := No_Token_Index;
      Token_Res_135 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_164 :
            Token_Index
               := No_Token_Index;
      Defer_Res_164 :
            Bare_Component_Def
               := No_Bare_Ada_Node;
      Transform_Res_96 :
            Bare_Array_Type_Def
               := No_Bare_Ada_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Array_Type_Def_Transform_Parse_2_Memo, Pos);

begin

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res_96 := M.Instance;
      return Transform_Res_96;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res_96;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code


--  Start row_code

Row_Pos_107 := Pos;



--  Start tok_code

Token_Res_131 := Row_Pos_107;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_131));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Array)
   then
       Token_Pos_131 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_107 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_107,
             Expected_Token_Id => Ada_Array,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_131 := Row_Pos_107 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_131 /= No_Token_Index then

   Row_Pos_107 := Token_Pos_131;

else
   Row_Pos_107 := No_Token_Index;
   goto Exit_Row_95_0;

end if;


--  Start tok_code

Token_Res_132 := Row_Pos_107;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_132));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Par_Open)
   then
       Token_Pos_132 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_107 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_107,
             Expected_Token_Id => Ada_Par_Open,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_132 := Row_Pos_107 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_132 /= No_Token_Index then

   Row_Pos_107 := Token_Pos_132;

else
   Row_Pos_107 := No_Token_Index;
   goto Exit_Row_95_0;

end if;


--  Start or_code

Or_Pos_42 := No_Token_Index;
Or_Res_42 := No_Bare_Ada_Node;
    
--  Start transform_code


--  Start row_code

Row_Pos_108 := Row_Pos_107;



--  Start list_code

    List_Pos_13 := No_Token_Index;



Lst_Cpos_13 := Row_Pos_108;
Tmp_List_13 := Get_Parse_List (Parser);

loop
   
Defer_Res_162 :=
   Unconstrained_Index_Transform_Parse_0 (Parser, Lst_Cpos_13);
Defer_Pos_162 := Parser.Current_Pos;


   exit when Defer_Pos_162 = No_Token_Index;

   List_Pos_13 := Defer_Pos_162;
   Lst_Cpos_13 := List_Pos_13;

   Tmp_List_13.Nodes.Append (Defer_Res_162);

      
--  Start tok_code

Token_Res_133 := Lst_Cpos_13;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_133));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Comma)
   then
       Token_Pos_133 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Lst_Cpos_13 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Lst_Cpos_13,
             Expected_Token_Id => Ada_Comma,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_133 := Lst_Cpos_13 + 1;
   end if;
end;

--  End tok_code

      if Token_Pos_133 /= No_Token_Index then
          Lst_Cpos_13 := Token_Pos_133;
      else
         exit;
      end if;

end loop;

declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List_13.Nodes.Length;
begin
   List_Res_13 :=
      Allocate_Unconstrained_Array_Index_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Row_Pos_108;
      Token_End := (if Lst_Cpos_13 = Row_Pos_108
                    then Row_Pos_108
                    else Lst_Cpos_13 - 1);

   else
      Token_Start := Token_Index'Max (Row_Pos_108, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res_13,
      Kind              => Ada_Unconstrained_Array_Index_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res_13,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_Ada_Node_Vectors.Vector renames
         Tmp_List_13.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res_13.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List_13);

--  End list_code



if List_Pos_13 /= No_Token_Index then

   Row_Pos_108 := List_Pos_13;

else
   Row_Pos_108 := No_Token_Index;
   goto Exit_Row_96_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_96_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_108 /= No_Token_Index then

   Transform_Res_94 := Allocate_Unconstrained_Array_Indices (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_94,
      Kind => Ada_Unconstrained_Array_Indices,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos_107,
      Token_End_Index   => (if Row_Pos_108 = Row_Pos_107
                            then No_Token_Index
                            else Row_Pos_108 - 1));

      Initialize_Fields_For_Unconstrained_Array_Indices
        (Self => Transform_Res_94, Unconstrained_Array_Indices_F_Types => List_Res_13);

         if List_Res_13 /= null and then Is_Incomplete (List_Res_13) then
            Transform_Res_94.Last_Attempted_Child := 0;
         elsif List_Res_13 /= null and then not Is_Ghost (List_Res_13) then
            Transform_Res_94.Last_Attempted_Child := -1;
         end if;


end if;

--  End transform_code

    if Row_Pos_108 /= No_Token_Index then
        Or_Pos_42 := Row_Pos_108;
        Or_Res_42 := Transform_Res_94;
        goto Exit_Or_41;
    end if;
    
--  Start transform_code


--  Start row_code

Row_Pos_109 := Row_Pos_107;



Defer_Res_163 :=
   Constraint_List_List_Parse_0 (Parser, Row_Pos_109);
Defer_Pos_163 := Parser.Current_Pos;



if Defer_Pos_163 /= No_Token_Index then

   Row_Pos_109 := Defer_Pos_163;

else
   Row_Pos_109 := No_Token_Index;
   goto Exit_Row_98_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_98_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_109 /= No_Token_Index then

   Transform_Res_95 := Allocate_Constrained_Array_Indices (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_95,
      Kind => Ada_Constrained_Array_Indices,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos_107,
      Token_End_Index   => (if Row_Pos_109 = Row_Pos_107
                            then No_Token_Index
                            else Row_Pos_109 - 1));

      Initialize_Fields_For_Constrained_Array_Indices
        (Self => Transform_Res_95, Constrained_Array_Indices_F_List => Defer_Res_163);

         if Defer_Res_163 /= null and then Is_Incomplete (Defer_Res_163) then
            Transform_Res_95.Last_Attempted_Child := 0;
         elsif Defer_Res_163 /= null and then not Is_Ghost (Defer_Res_163) then
            Transform_Res_95.Last_Attempted_Child := -1;
         end if;


end if;

--  End transform_code

    if Row_Pos_109 /= No_Token_Index then
        Or_Pos_42 := Row_Pos_109;
        Or_Res_42 := Transform_Res_95;
        goto Exit_Or_41;
    end if;
<<Exit_Or_41>>

--  End or_code



if Or_Pos_42 /= No_Token_Index then

   Row_Pos_107 := Or_Pos_42;

else
   Row_Pos_107 := No_Token_Index;
   goto Exit_Row_95_0;

end if;


--  Start tok_code

Token_Res_134 := Row_Pos_107;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_134));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Par_Close)
   then
       Token_Pos_134 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_107 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_107,
             Expected_Token_Id => Ada_Par_Close,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_134 := Row_Pos_107 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_134 /= No_Token_Index then

   Row_Pos_107 := Token_Pos_134;

else
   Row_Pos_107 := No_Token_Index;
   goto Exit_Row_95_0;

end if;


--  Start tok_code

Token_Res_135 := Row_Pos_107;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_135));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Of)
   then
       Token_Pos_135 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_107 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_107,
             Expected_Token_Id => Ada_Of,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_135 := Row_Pos_107 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_135 /= No_Token_Index then

   Row_Pos_107 := Token_Pos_135;

else
   Row_Pos_107 := No_Token_Index;
   goto Exit_Row_95_0;

end if;


Defer_Res_164 :=
   Component_Def_Transform_Parse_0 (Parser, Row_Pos_107);
Defer_Pos_164 := Parser.Current_Pos;



if Defer_Pos_164 /= No_Token_Index then

   Row_Pos_107 := Defer_Pos_164;

else
   Row_Pos_107 := No_Token_Index;
   goto Exit_Row_95_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_95_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_107 /= No_Token_Index then

   Transform_Res_96 := Allocate_Array_Type_Def (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_96,
      Kind => Ada_Array_Type_Def,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_107 = Pos
                            then No_Token_Index
                            else Row_Pos_107 - 1));

      Initialize_Fields_For_Array_Type_Def
        (Self => Transform_Res_96, Array_Type_Def_F_Indices => Or_Res_42, Array_Type_Def_F_Component_Type => Defer_Res_164);

         if Or_Res_42 /= null and then Is_Incomplete (Or_Res_42) then
            Transform_Res_96.Last_Attempted_Child := 0;
         elsif Or_Res_42 /= null and then not Is_Ghost (Or_Res_42) then
            Transform_Res_96.Last_Attempted_Child := -1;
         end if;
         if Defer_Res_164 /= null and then Is_Incomplete (Defer_Res_164) then
            Transform_Res_96.Last_Attempted_Child := 0;
         elsif Defer_Res_164 /= null and then not Is_Ghost (Defer_Res_164) then
            Transform_Res_96.Last_Attempted_Child := -1;
         end if;


end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Array_Type_Def_Transform_Parse_2_Memo,
      Row_Pos_107 /= No_Token_Index,
      Transform_Res_96,
      Pos,
      Row_Pos_107);


   Parser.Current_Pos := Row_Pos_107;

   return Transform_Res_96;
end Array_Type_Def_Transform_Parse_2;

   


function Static_Name_Or_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Name
is
   use Bare_Name_Memos;

      Nobt_13 :
            Boolean
               := False;
      Row_Pos_121 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_173 :
            Token_Index
               := No_Token_Index;
      Defer_Res_173 :
            Bare_Name
               := No_Bare_Ada_Node;
      Token_Pos_152 :
            Token_Index
               := No_Token_Index;
      Token_Res_152 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_174 :
            Token_Index
               := No_Token_Index;
      Defer_Res_174 :
            Bare_Base_Id
               := No_Bare_Ada_Node;
      Row_Progress_13 :
            Integer
               := 0;
      Transform_Res_105 :
            Bare_Dotted_Name
               := No_Bare_Ada_Node;
      Transform_Has_Failed_13 :
            Boolean
               := False;
      Defer_Pos_175 :
            Token_Index
               := No_Token_Index;
      Defer_Res_175 :
            Bare_Base_Id
               := No_Bare_Ada_Node;
      Or_Pos_45 :
            Token_Index
               := No_Token_Index;
      Or_Res_45 :
            Bare_Name
               := No_Bare_Ada_Node;

      Mem_Pos : Token_Index := Pos;
      Mem_Res : Bare_Name := No_Bare_Ada_Node;

   M : Memo_Entry := Get (Parser.Private_Part.Static_Name_Or_Parse_0_Memo, Pos);

begin

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Or_Res_45 := M.Instance;
      return Or_Res_45;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Or_Res_45;
   end if;

       Set (Parser.Private_Part.Static_Name_Or_Parse_0_Memo, False, Or_Res_45, Pos, Mem_Pos);

       <<Try_Again>>

      Nobt_13 := False;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start or_code

Or_Pos_45 := No_Token_Index;
Or_Res_45 := No_Bare_Ada_Node;
    
--  Start transform_code


--  Start row_code

Row_Pos_121 := Pos;



Defer_Res_173 :=
   Static_Name_Or_Parse_0 (Parser, Row_Pos_121);
Defer_Pos_173 := Parser.Current_Pos;


Row_Progress_13 := 1;

if Defer_Pos_173 /= No_Token_Index then

   Row_Pos_121 := Defer_Pos_173;

else
   Row_Pos_121 := No_Token_Index;
   goto Exit_Row_106_0;

end if;


--  Start tok_code

Token_Res_152 := Row_Pos_121;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_152));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Dot)
   then
       Token_Pos_152 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_121 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_121,
             Expected_Token_Id => Ada_Dot,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_152 := Row_Pos_121 + 1;
   end if;
end;

--  End tok_code


Row_Progress_13 := 2;

if Token_Pos_152 /= No_Token_Index then

   Row_Pos_121 := Token_Pos_152;

else
   Row_Pos_121 := No_Token_Index;
   goto Exit_Row_106_0;

end if;

Nobt_13 := True;

Row_Progress_13 := 3;

if Row_Pos_121 /= No_Token_Index then

   Row_Pos_121 := Row_Pos_121;

else
   Row_Pos_121 := No_Token_Index;
   goto Exit_Row_106_0;

end if;


Defer_Res_174 :=
   Direct_Name_Or_Parse_0 (Parser, Row_Pos_121);
Defer_Pos_174 := Parser.Current_Pos;


Row_Progress_13 := 4;

if Defer_Pos_174 /= No_Token_Index then

   Row_Pos_121 := Defer_Pos_174;

else
   Row_Pos_121 := No_Token_Index;
   goto Exit_Row_106_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_106_0>>
pragma Warnings (On, "referenced");

--  End row_code


if Row_Pos_121 = No_Token_Index and then Nobt_13 then
   Row_Pos_121 := Parser.Last_Fail.Pos;
   Transform_Has_Failed_13 := True;
end if;

if Row_Pos_121 /= No_Token_Index then

   Transform_Res_105 := Allocate_Dotted_Name (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_105,
      Kind => Ada_Dotted_Name,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_121 = Pos
                            then No_Token_Index
                            else Row_Pos_121 - 1));

      Initialize_Fields_For_Dotted_Name
        (Self => Transform_Res_105, Dotted_Name_F_Prefix => Defer_Res_173, Dotted_Name_F_Suffix => Defer_Res_174);

         if Defer_Res_173 /= null and then Is_Incomplete (Defer_Res_173) then
            Transform_Res_105.Last_Attempted_Child := 0;
         elsif Defer_Res_173 /= null and then not Is_Ghost (Defer_Res_173) then
            Transform_Res_105.Last_Attempted_Child := -1;
         end if;
         if Defer_Res_174 /= null and then Is_Incomplete (Defer_Res_174) then
            Transform_Res_105.Last_Attempted_Child := 0;
         elsif Defer_Res_174 /= null and then not Is_Ghost (Defer_Res_174) then
            Transform_Res_105.Last_Attempted_Child := -1;
         end if;

   if Transform_Has_Failed_13 then
      Transform_Res_105.Last_Attempted_Child :=
         Row_Progress_13;

      Append (Parser.Diagnostics,
              Sloc_Range (Parser.TDH.all,
                          Get_Token (Parser.TDH.all, Pos)),
              To_Text ("Cannot parse <static_name>"));

      Add_Last_Fail_Diagnostic (Parser);
   end if;

end if;

--  End transform_code

    if Row_Pos_121 /= No_Token_Index then
        Or_Pos_45 := Row_Pos_121;
        Or_Res_45 := Transform_Res_105;
        goto Exit_Or_44;
    end if;
    
Defer_Res_175 :=
   Direct_Name_Or_Parse_0 (Parser, Pos);
Defer_Pos_175 := Parser.Current_Pos;

    if Defer_Pos_175 /= No_Token_Index then
        Or_Pos_45 := Defer_Pos_175;
        Or_Res_45 := Defer_Res_175;
        goto Exit_Or_44;
    end if;
<<Exit_Or_44>>

--  End or_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------

      if Or_Pos_45 > Mem_Pos then
         Mem_Pos := Or_Pos_45;
         Mem_Res := Or_Res_45;
         Set
           (Parser.Private_Part.Static_Name_Or_Parse_0_Memo,
            Or_Pos_45 /= No_Token_Index,
            Or_Res_45,
            Pos,
            Or_Pos_45);
         goto Try_Again;

      elsif Mem_Pos > Pos then
         Or_Res_45 := Mem_Res;
         Or_Pos_45 := Mem_Pos;
         goto No_Memo;
      end if;

   Set
     (Parser.Private_Part.Static_Name_Or_Parse_0_Memo,
      Or_Pos_45 /= No_Token_Index,
      Or_Res_45,
      Pos,
      Or_Pos_45);

       <<No_Memo>>

   Parser.Current_Pos := Or_Pos_45;

   return Or_Res_45;
end Static_Name_Or_Parse_0;

   


function Defining_Name_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Defining_Name
is
   use Bare_Defining_Name_Memos;

      Row_Pos_120 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_172 :
            Token_Index
               := No_Token_Index;
      Defer_Res_172 :
            Bare_Name
               := No_Bare_Ada_Node;
      Transform_Res_104 :
            Bare_Defining_Name
               := No_Bare_Ada_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Defining_Name_Transform_Parse_0_Memo, Pos);

begin

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res_104 := M.Instance;
      return Transform_Res_104;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res_104;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code


--  Start row_code

Row_Pos_120 := Pos;



Defer_Res_172 :=
   Static_Name_Or_Parse_0 (Parser, Row_Pos_120);
Defer_Pos_172 := Parser.Current_Pos;



if Defer_Pos_172 /= No_Token_Index then

   Row_Pos_120 := Defer_Pos_172;

else
   Row_Pos_120 := No_Token_Index;
   goto Exit_Row_105_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_105_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_120 /= No_Token_Index then

   Transform_Res_104 := Allocate_Defining_Name (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_104,
      Kind => Ada_Defining_Name,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_120 = Pos
                            then No_Token_Index
                            else Row_Pos_120 - 1));

      Initialize_Fields_For_Defining_Name
        (Self => Transform_Res_104, Defining_Name_F_Name => Defer_Res_172);

         if Defer_Res_172 /= null and then Is_Incomplete (Defer_Res_172) then
            Transform_Res_104.Last_Attempted_Child := 0;
         elsif Defer_Res_172 /= null and then not Is_Ghost (Defer_Res_172) then
            Transform_Res_104.Last_Attempted_Child := -1;
         end if;


end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Defining_Name_Transform_Parse_0_Memo,
      Row_Pos_120 /= No_Token_Index,
      Transform_Res_104,
      Pos,
      Row_Pos_120);


   Parser.Current_Pos := Row_Pos_120;

   return Transform_Res_104;
end Defining_Name_Transform_Parse_0;

   


function Param_Spec_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Param_Spec
is
   use Bare_Param_Spec_Memos;

      Row_Pos_123 :
            Token_Index
               := No_Token_Index;
      Lst_Cpos_15 :
            Token_Index
               := No_Token_Index;
      Tmp_List_15 :
            Free_Parse_List;
      Defer_Pos_177 :
            Token_Index
               := No_Token_Index;
      Defer_Res_177 :
            Bare_Defining_Name
               := No_Bare_Ada_Node;
      Token_Pos_156 :
            Token_Index
               := No_Token_Index;
      Token_Res_156 :
            Token_Index
               := No_Token_Index;
      List_Pos_15 :
            Token_Index
               := No_Token_Index;
      List_Res_15 :
            Bare_Defining_Name_List
               := No_Bare_Ada_Node;
      Token_Pos_157 :
            Token_Index
               := No_Token_Index;
      Token_Res_157 :
            Token_Index
               := No_Token_Index;
      Token_Pos_158 :
            Token_Index
               := No_Token_Index;
      Token_Res_158 :
            Token_Index
               := No_Token_Index;
      Opt_Res_12 :
            Bare_Aliased_Node
               := No_Bare_Ada_Node;
      Defer_Pos_178 :
            Token_Index
               := No_Token_Index;
      Defer_Res_178 :
            Bare_Mode
               := No_Bare_Ada_Node;
      Defer_Pos_179 :
            Token_Index
               := No_Token_Index;
      Defer_Res_179 :
            Bare_Type_Expr
               := No_Bare_Ada_Node;
      Row_Pos_124 :
            Token_Index
               := No_Token_Index;
      Token_Pos_159 :
            Token_Index
               := No_Token_Index;
      Token_Res_159 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_180 :
            Token_Index
               := No_Token_Index;
      Defer_Res_180 :
            Bare_Expr
               := No_Bare_Ada_Node;
      Transform_Res_107 :
            Bare_Param_Spec
               := No_Bare_Ada_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Param_Spec_Transform_Parse_0_Memo, Pos);

begin

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res_107 := M.Instance;
      return Transform_Res_107;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res_107;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code


--  Start row_code

Row_Pos_123 := Pos;



--  Start list_code

    List_Pos_15 := No_Token_Index;



Lst_Cpos_15 := Row_Pos_123;
Tmp_List_15 := Get_Parse_List (Parser);

loop
   
Defer_Res_177 :=
   Defining_Id_Transform_Parse_0 (Parser, Lst_Cpos_15);
Defer_Pos_177 := Parser.Current_Pos;


   exit when Defer_Pos_177 = No_Token_Index;

   List_Pos_15 := Defer_Pos_177;
   Lst_Cpos_15 := List_Pos_15;

   Tmp_List_15.Nodes.Append (Defer_Res_177);

      
--  Start tok_code

Token_Res_156 := Lst_Cpos_15;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_156));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Comma)
   then
       Token_Pos_156 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Lst_Cpos_15 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Lst_Cpos_15,
             Expected_Token_Id => Ada_Comma,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_156 := Lst_Cpos_15 + 1;
   end if;
end;

--  End tok_code

      if Token_Pos_156 /= No_Token_Index then
          Lst_Cpos_15 := Token_Pos_156;
      else
         exit;
      end if;

end loop;

declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List_15.Nodes.Length;
begin
   List_Res_15 :=
      Allocate_Defining_Name_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Row_Pos_123;
      Token_End := (if Lst_Cpos_15 = Row_Pos_123
                    then Row_Pos_123
                    else Lst_Cpos_15 - 1);

   else
      Token_Start := Token_Index'Max (Row_Pos_123, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res_15,
      Kind              => Ada_Defining_Name_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res_15,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_Ada_Node_Vectors.Vector renames
         Tmp_List_15.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res_15.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List_15);

--  End list_code



if List_Pos_15 /= No_Token_Index then

   Row_Pos_123 := List_Pos_15;

else
   Row_Pos_123 := No_Token_Index;
   goto Exit_Row_108_0;

end if;


--  Start tok_code

Token_Res_157 := Row_Pos_123;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_157));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Colon)
   then
       Token_Pos_157 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_123 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_123,
             Expected_Token_Id => Ada_Colon,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_157 := Row_Pos_123 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_157 /= No_Token_Index then

   Row_Pos_123 := Token_Pos_157;

else
   Row_Pos_123 := No_Token_Index;
   goto Exit_Row_108_0;

end if;


--  Start opt_code




--  Start tok_code

Token_Res_158 := Row_Pos_123;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_158));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Identifier)
      or else T.Symbol /= Precomputed_Symbol
        (Precomputed_Symbol_Table (Parser.TDH.Symbols),
         Precomputed_Symbol_Aliased)
   then
       Token_Pos_158 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_123 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_123,
             Expected_Token_Id => Ada_Identifier,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_158 := Row_Pos_123 + 1;
   end if;
end;

--  End tok_code


if Token_Pos_158 = No_Token_Index then

         Opt_Res_12 := Allocate_Aliased_Absent (Parser.Mem_Pool);
         Initialize
           (Self              => Opt_Res_12,
            Kind              => Ada_Aliased_Absent,
            Unit              => Parser.Unit,
            Token_Start_Index => Row_Pos_123,
            Token_End_Index   => No_Token_Index);


    Token_Pos_158 := Row_Pos_123;

else

      Opt_Res_12 := Allocate_Aliased_Present (Parser.Mem_Pool);
      Initialize
        (Self              => Opt_Res_12,
         Kind              => Ada_Aliased_Present,
         Unit              => Parser.Unit,
         Token_Start_Index => Row_Pos_123,
         Token_End_Index   => Token_Pos_158 - 1);

end if;

--  End opt_code



if Token_Pos_158 /= No_Token_Index then

   Row_Pos_123 := Token_Pos_158;

else
   Row_Pos_123 := No_Token_Index;
   goto Exit_Row_108_0;

end if;


--  Start opt_code




Defer_Res_178 :=
   Mode_Or_Parse_0 (Parser, Row_Pos_123);
Defer_Pos_178 := Parser.Current_Pos;


if Defer_Pos_178 = No_Token_Index then

        Defer_Res_178 := No_Bare_Ada_Node;


    Defer_Pos_178 := Row_Pos_123;


end if;

--  End opt_code



if Defer_Pos_178 /= No_Token_Index then

   Row_Pos_123 := Defer_Pos_178;

else
   Row_Pos_123 := No_Token_Index;
   goto Exit_Row_108_0;

end if;


Defer_Res_179 :=
   Type_Expr_Or_Parse_0 (Parser, Row_Pos_123);
Defer_Pos_179 := Parser.Current_Pos;



if Defer_Pos_179 /= No_Token_Index then

   Row_Pos_123 := Defer_Pos_179;

else
   Row_Pos_123 := No_Token_Index;
   goto Exit_Row_108_0;

end if;


--  Start opt_code




--  Start row_code

Row_Pos_124 := Row_Pos_123;



--  Start tok_code

Token_Res_159 := Row_Pos_124;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_159));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Assign)
   then
       Token_Pos_159 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_124 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_124,
             Expected_Token_Id => Ada_Assign,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_159 := Row_Pos_124 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_159 /= No_Token_Index then

   Row_Pos_124 := Token_Pos_159;

else
   Row_Pos_124 := No_Token_Index;
   goto Exit_Row_109_0;

end if;


Defer_Res_180 :=
   Expr_Or_Parse_0 (Parser, Row_Pos_124);
Defer_Pos_180 := Parser.Current_Pos;



if Defer_Pos_180 /= No_Token_Index then

   Row_Pos_124 := Defer_Pos_180;

else
   Row_Pos_124 := No_Token_Index;
   goto Exit_Row_109_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_109_0>>
pragma Warnings (On, "referenced");

--  End row_code


if Row_Pos_124 = No_Token_Index then

        Defer_Res_180 := No_Bare_Ada_Node;


    Row_Pos_124 := Row_Pos_123;


end if;

--  End opt_code



if Row_Pos_124 /= No_Token_Index then

   Row_Pos_123 := Row_Pos_124;

else
   Row_Pos_123 := No_Token_Index;
   goto Exit_Row_108_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_108_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_123 /= No_Token_Index then

   Transform_Res_107 := Allocate_Param_Spec (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_107,
      Kind => Ada_Param_Spec,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_123 = Pos
                            then No_Token_Index
                            else Row_Pos_123 - 1));

      Initialize_Fields_For_Param_Spec
        (Self => Transform_Res_107, Param_Spec_F_Ids => List_Res_15, Param_Spec_F_Has_Aliased => Opt_Res_12, Param_Spec_F_Mode => Defer_Res_178, Param_Spec_F_Type_Expr => Defer_Res_179, Param_Spec_F_Default_Expr => Defer_Res_180);

         if List_Res_15 /= null and then Is_Incomplete (List_Res_15) then
            Transform_Res_107.Last_Attempted_Child := 0;
         elsif List_Res_15 /= null and then not Is_Ghost (List_Res_15) then
            Transform_Res_107.Last_Attempted_Child := -1;
         end if;
         if Opt_Res_12 /= null and then Is_Incomplete (Opt_Res_12) then
            Transform_Res_107.Last_Attempted_Child := 0;
         elsif Opt_Res_12 /= null and then not Is_Ghost (Opt_Res_12) then
            Transform_Res_107.Last_Attempted_Child := -1;
         end if;
         if Defer_Res_178 /= null and then Is_Incomplete (Defer_Res_178) then
            Transform_Res_107.Last_Attempted_Child := 0;
         elsif Defer_Res_178 /= null and then not Is_Ghost (Defer_Res_178) then
            Transform_Res_107.Last_Attempted_Child := -1;
         end if;
         if Defer_Res_179 /= null and then Is_Incomplete (Defer_Res_179) then
            Transform_Res_107.Last_Attempted_Child := 0;
         elsif Defer_Res_179 /= null and then not Is_Ghost (Defer_Res_179) then
            Transform_Res_107.Last_Attempted_Child := -1;
         end if;
         if Defer_Res_180 /= null and then Is_Incomplete (Defer_Res_180) then
            Transform_Res_107.Last_Attempted_Child := 0;
         elsif Defer_Res_180 /= null and then not Is_Ghost (Defer_Res_180) then
            Transform_Res_107.Last_Attempted_Child := -1;
         end if;


end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Param_Spec_Transform_Parse_0_Memo,
      Row_Pos_123 /= No_Token_Index,
      Transform_Res_107,
      Pos,
      Row_Pos_123);


   Parser.Current_Pos := Row_Pos_123;

   return Transform_Res_107;
end Param_Spec_Transform_Parse_0;

   


function Param_Specs_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Params
is
   use Bare_Params_Memos;

      Nobt_14 :
            Boolean
               := False;
      Row_Pos_122 :
            Token_Index
               := No_Token_Index;
      Token_Pos_153 :
            Token_Index
               := No_Token_Index;
      Token_Res_153 :
            Token_Index
               := No_Token_Index;
      Lst_Cpos_14 :
            Token_Index
               := No_Token_Index;
      Tmp_List_14 :
            Free_Parse_List;
      Defer_Pos_176 :
            Token_Index
               := No_Token_Index;
      Defer_Res_176 :
            Bare_Param_Spec
               := No_Bare_Ada_Node;
      Token_Pos_154 :
            Token_Index
               := No_Token_Index;
      Token_Res_154 :
            Token_Index
               := No_Token_Index;
      List_Pos_14 :
            Token_Index
               := No_Token_Index;
      List_Res_14 :
            Bare_Param_Spec_List
               := No_Bare_Ada_Node;
      Token_Pos_155 :
            Token_Index
               := No_Token_Index;
      Token_Res_155 :
            Token_Index
               := No_Token_Index;
      Row_Progress_14 :
            Integer
               := 0;
      Transform_Res_106 :
            Bare_Params
               := No_Bare_Ada_Node;
      Transform_Has_Failed_14 :
            Boolean
               := False;


   M : Memo_Entry := Get (Parser.Private_Part.Param_Specs_Transform_Parse_0_Memo, Pos);

begin

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res_106 := M.Instance;
      return Transform_Res_106;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res_106;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code


--  Start row_code

Row_Pos_122 := Pos;



--  Start tok_code

Token_Res_153 := Row_Pos_122;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_153));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Par_Open)
   then
       Token_Pos_153 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_122 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_122,
             Expected_Token_Id => Ada_Par_Open,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_153 := Row_Pos_122 + 1;
   end if;
end;

--  End tok_code


Row_Progress_14 := 1;

if Token_Pos_153 /= No_Token_Index then

   Row_Pos_122 := Token_Pos_153;

else
   Row_Pos_122 := No_Token_Index;
   goto Exit_Row_107_0;

end if;

Nobt_14 := True;

Row_Progress_14 := 2;

if Row_Pos_122 /= No_Token_Index then

   Row_Pos_122 := Row_Pos_122;

else
   Row_Pos_122 := No_Token_Index;
   goto Exit_Row_107_0;

end if;


--  Start list_code

    List_Pos_14 := No_Token_Index;



Lst_Cpos_14 := Row_Pos_122;
Tmp_List_14 := Get_Parse_List (Parser);

loop
   
Defer_Res_176 :=
   Param_Spec_Transform_Parse_0 (Parser, Lst_Cpos_14);
Defer_Pos_176 := Parser.Current_Pos;


   exit when Defer_Pos_176 = No_Token_Index;

   List_Pos_14 := Defer_Pos_176;
   Lst_Cpos_14 := List_Pos_14;

   Tmp_List_14.Nodes.Append (Defer_Res_176);

      
--  Start tok_code

Token_Res_154 := Lst_Cpos_14;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_154));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Semicolon)
   then
       Token_Pos_154 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Lst_Cpos_14 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Lst_Cpos_14,
             Expected_Token_Id => Ada_Semicolon,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_154 := Lst_Cpos_14 + 1;
   end if;
end;

--  End tok_code

      if Token_Pos_154 /= No_Token_Index then
          Lst_Cpos_14 := Token_Pos_154;
      else
         exit;
      end if;

end loop;

declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List_14.Nodes.Length;
begin
   List_Res_14 :=
      Allocate_Param_Spec_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Row_Pos_122;
      Token_End := (if Lst_Cpos_14 = Row_Pos_122
                    then Row_Pos_122
                    else Lst_Cpos_14 - 1);

   else
      Token_Start := Token_Index'Max (Row_Pos_122, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res_14,
      Kind              => Ada_Param_Spec_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res_14,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_Ada_Node_Vectors.Vector renames
         Tmp_List_14.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res_14.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List_14);

--  End list_code


Row_Progress_14 := 3;

if List_Pos_14 /= No_Token_Index then

   Row_Pos_122 := List_Pos_14;

else
   Row_Pos_122 := No_Token_Index;
   goto Exit_Row_107_0;

end if;


--  Start tok_code

Token_Res_155 := Row_Pos_122;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_155));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Par_Close)
   then
       Token_Pos_155 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_122 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_122,
             Expected_Token_Id => Ada_Par_Close,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_155 := Row_Pos_122 + 1;
   end if;
end;

--  End tok_code


Row_Progress_14 := 4;

if Token_Pos_155 /= No_Token_Index then

   Row_Pos_122 := Token_Pos_155;

else
   Row_Pos_122 := No_Token_Index;
   goto Exit_Row_107_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_107_0>>
pragma Warnings (On, "referenced");

--  End row_code


if Row_Pos_122 = No_Token_Index and then Nobt_14 then
   Row_Pos_122 := Parser.Last_Fail.Pos;
   Transform_Has_Failed_14 := True;
end if;

if Row_Pos_122 /= No_Token_Index then

   Transform_Res_106 := Allocate_Params (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_106,
      Kind => Ada_Params,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_122 = Pos
                            then No_Token_Index
                            else Row_Pos_122 - 1));

      Initialize_Fields_For_Params
        (Self => Transform_Res_106, Params_F_Params => List_Res_14);

         if List_Res_14 /= null and then Is_Incomplete (List_Res_14) then
            Transform_Res_106.Last_Attempted_Child := 0;
         elsif List_Res_14 /= null and then not Is_Ghost (List_Res_14) then
            Transform_Res_106.Last_Attempted_Child := -1;
         end if;

   if Transform_Has_Failed_14 then
      Transform_Res_106.Last_Attempted_Child :=
         Row_Progress_14;

      Append (Parser.Diagnostics,
              Sloc_Range (Parser.TDH.all,
                          Get_Token (Parser.TDH.all, Pos)),
              To_Text ("Cannot parse <param_specs>"));

      Add_Last_Fail_Diagnostic (Parser);
   end if;

end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Param_Specs_Transform_Parse_0_Memo,
      Row_Pos_122 /= No_Token_Index,
      Transform_Res_106,
      Pos,
      Row_Pos_122);


   Parser.Current_Pos := Row_Pos_122;

   return Transform_Res_106;
end Param_Specs_Transform_Parse_0;

   


function Subp_Spec_Transform_Parse_2
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Subp_Spec
is
   use Bare_Subp_Spec_Memos;

      Row_Pos_116 :
            Token_Index
               := No_Token_Index;
      Row_Pos_117 :
            Token_Index
               := No_Token_Index;
      Token_Pos_149 :
            Token_Index
               := No_Token_Index;
      Token_Res_149 :
            Token_Index
               := No_Token_Index;
      Transform_Res_101 :
            Bare_Subp_Kind_Procedure
               := No_Bare_Ada_Node;
      Row_Pos_118 :
            Token_Index
               := No_Token_Index;
      Token_Pos_150 :
            Token_Index
               := No_Token_Index;
      Token_Res_150 :
            Token_Index
               := No_Token_Index;
      Transform_Res_102 :
            Bare_Subp_Kind_Function
               := No_Bare_Ada_Node;
      Or_Pos_44 :
            Token_Index
               := No_Token_Index;
      Or_Res_44 :
            Bare_Subp_Kind
               := No_Bare_Ada_Node;
      Defer_Pos_169 :
            Token_Index
               := No_Token_Index;
      Defer_Res_169 :
            Bare_Defining_Name
               := No_Bare_Ada_Node;
      Defer_Pos_170 :
            Token_Index
               := No_Token_Index;
      Defer_Res_170 :
            Bare_Params
               := No_Bare_Ada_Node;
      Row_Pos_119 :
            Token_Index
               := No_Token_Index;
      Token_Pos_151 :
            Token_Index
               := No_Token_Index;
      Token_Res_151 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_171 :
            Token_Index
               := No_Token_Index;
      Defer_Res_171 :
            Bare_Type_Expr
               := No_Bare_Ada_Node;
      Transform_Res_103 :
            Bare_Subp_Spec
               := No_Bare_Ada_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Subp_Spec_Transform_Parse_2_Memo, Pos);

begin

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res_103 := M.Instance;
      return Transform_Res_103;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res_103;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code


--  Start row_code

Row_Pos_116 := Pos;



--  Start or_code

Or_Pos_44 := No_Token_Index;
Or_Res_44 := No_Bare_Ada_Node;
    
--  Start transform_code


--  Start row_code

Row_Pos_117 := Row_Pos_116;



--  Start tok_code

Token_Res_149 := Row_Pos_117;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_149));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Procedure)
   then
       Token_Pos_149 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_117 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_117,
             Expected_Token_Id => Ada_Procedure,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_149 := Row_Pos_117 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_149 /= No_Token_Index then

   Row_Pos_117 := Token_Pos_149;

else
   Row_Pos_117 := No_Token_Index;
   goto Exit_Row_103_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_103_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_117 /= No_Token_Index then

   Transform_Res_101 := Allocate_Subp_Kind_Procedure (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_101,
      Kind => Ada_Subp_Kind_Procedure,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos_116,
      Token_End_Index   => (if Row_Pos_117 = Row_Pos_116
                            then No_Token_Index
                            else Row_Pos_117 - 1));




end if;

--  End transform_code

    if Row_Pos_117 /= No_Token_Index then
        Or_Pos_44 := Row_Pos_117;
        Or_Res_44 := Transform_Res_101;
        goto Exit_Or_43;
    end if;
    
--  Start transform_code


--  Start row_code

Row_Pos_118 := Row_Pos_116;



--  Start tok_code

Token_Res_150 := Row_Pos_118;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_150));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Function)
   then
       Token_Pos_150 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_118 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_118,
             Expected_Token_Id => Ada_Function,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_150 := Row_Pos_118 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_150 /= No_Token_Index then

   Row_Pos_118 := Token_Pos_150;

else
   Row_Pos_118 := No_Token_Index;
   goto Exit_Row_104_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_104_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_118 /= No_Token_Index then

   Transform_Res_102 := Allocate_Subp_Kind_Function (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_102,
      Kind => Ada_Subp_Kind_Function,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos_116,
      Token_End_Index   => (if Row_Pos_118 = Row_Pos_116
                            then No_Token_Index
                            else Row_Pos_118 - 1));




end if;

--  End transform_code

    if Row_Pos_118 /= No_Token_Index then
        Or_Pos_44 := Row_Pos_118;
        Or_Res_44 := Transform_Res_102;
        goto Exit_Or_43;
    end if;
<<Exit_Or_43>>

--  End or_code



if Or_Pos_44 /= No_Token_Index then

   Row_Pos_116 := Or_Pos_44;

else
   Row_Pos_116 := No_Token_Index;
   goto Exit_Row_102_0;

end if;


--  Start opt_code




Defer_Res_169 :=
   Defining_Name_Transform_Parse_0 (Parser, Row_Pos_116);
Defer_Pos_169 := Parser.Current_Pos;


if Defer_Pos_169 = No_Token_Index then

        Defer_Res_169 := No_Bare_Ada_Node;


    Defer_Pos_169 := Row_Pos_116;


end if;

--  End opt_code



if Defer_Pos_169 /= No_Token_Index then

   Row_Pos_116 := Defer_Pos_169;

else
   Row_Pos_116 := No_Token_Index;
   goto Exit_Row_102_0;

end if;


--  Start opt_code




Defer_Res_170 :=
   Param_Specs_Transform_Parse_0 (Parser, Row_Pos_116);
Defer_Pos_170 := Parser.Current_Pos;


if Defer_Pos_170 = No_Token_Index then

        Defer_Res_170 := No_Bare_Ada_Node;


    Defer_Pos_170 := Row_Pos_116;


end if;

--  End opt_code



if Defer_Pos_170 /= No_Token_Index then

   Row_Pos_116 := Defer_Pos_170;

else
   Row_Pos_116 := No_Token_Index;
   goto Exit_Row_102_0;

end if;


--  Start opt_code




--  Start row_code

Row_Pos_119 := Row_Pos_116;



--  Start tok_code

Token_Res_151 := Row_Pos_119;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_151));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Return)
   then
       Token_Pos_151 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_119 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_119,
             Expected_Token_Id => Ada_Return,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_151 := Row_Pos_119 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_151 /= No_Token_Index then

   Row_Pos_119 := Token_Pos_151;

else
   Row_Pos_119 := No_Token_Index;
   goto Exit_Row_110_0;

end if;


Defer_Res_171 :=
   Type_Expr_Or_Parse_0 (Parser, Row_Pos_119);
Defer_Pos_171 := Parser.Current_Pos;



if Defer_Pos_171 /= No_Token_Index then

   Row_Pos_119 := Defer_Pos_171;

else
   Row_Pos_119 := No_Token_Index;
   goto Exit_Row_110_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_110_0>>
pragma Warnings (On, "referenced");

--  End row_code


if Row_Pos_119 = No_Token_Index then

        Defer_Res_171 := No_Bare_Ada_Node;


    Row_Pos_119 := Row_Pos_116;


end if;

--  End opt_code



if Row_Pos_119 /= No_Token_Index then

   Row_Pos_116 := Row_Pos_119;

else
   Row_Pos_116 := No_Token_Index;
   goto Exit_Row_102_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_102_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_116 /= No_Token_Index then

   Transform_Res_103 := Allocate_Subp_Spec (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_103,
      Kind => Ada_Subp_Spec,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_116 = Pos
                            then No_Token_Index
                            else Row_Pos_116 - 1));

      Initialize_Fields_For_Subp_Spec
        (Self => Transform_Res_103, Subp_Spec_F_Subp_Kind => Or_Res_44, Subp_Spec_F_Subp_Name => Defer_Res_169, Subp_Spec_F_Subp_Params => Defer_Res_170, Subp_Spec_F_Subp_Returns => Defer_Res_171);

         if Or_Res_44 /= null and then Is_Incomplete (Or_Res_44) then
            Transform_Res_103.Last_Attempted_Child := 0;
         elsif Or_Res_44 /= null and then not Is_Ghost (Or_Res_44) then
            Transform_Res_103.Last_Attempted_Child := -1;
         end if;
         if Defer_Res_169 /= null and then Is_Incomplete (Defer_Res_169) then
            Transform_Res_103.Last_Attempted_Child := 0;
         elsif Defer_Res_169 /= null and then not Is_Ghost (Defer_Res_169) then
            Transform_Res_103.Last_Attempted_Child := -1;
         end if;
         if Defer_Res_170 /= null and then Is_Incomplete (Defer_Res_170) then
            Transform_Res_103.Last_Attempted_Child := 0;
         elsif Defer_Res_170 /= null and then not Is_Ghost (Defer_Res_170) then
            Transform_Res_103.Last_Attempted_Child := -1;
         end if;
         if Defer_Res_171 /= null and then Is_Incomplete (Defer_Res_171) then
            Transform_Res_103.Last_Attempted_Child := 0;
         elsif Defer_Res_171 /= null and then not Is_Ghost (Defer_Res_171) then
            Transform_Res_103.Last_Attempted_Child := -1;
         end if;


end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Subp_Spec_Transform_Parse_2_Memo,
      Row_Pos_116 /= No_Token_Index,
      Transform_Res_103,
      Pos,
      Row_Pos_116);


   Parser.Current_Pos := Row_Pos_116;

   return Transform_Res_103;
end Subp_Spec_Transform_Parse_2;

   


function Access_Def_Or_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Access_Def
is
   use Bare_Access_Def_Memos;

      Row_Pos_112 :
            Token_Index
               := No_Token_Index;
      Row_Pos_113 :
            Token_Index
               := No_Token_Index;
      Token_Pos_140 :
            Token_Index
               := No_Token_Index;
      Token_Res_140 :
            Token_Index
               := No_Token_Index;
      Token_Pos_141 :
            Token_Index
               := No_Token_Index;
      Token_Res_141 :
            Token_Index
               := No_Token_Index;
      Opt_Res_7 :
            Bare_Not_Null
               := No_Bare_Ada_Node;
      Token_Pos_142 :
            Token_Index
               := No_Token_Index;
      Token_Res_142 :
            Token_Index
               := No_Token_Index;
      Token_Pos_143 :
            Token_Index
               := No_Token_Index;
      Token_Res_143 :
            Token_Index
               := No_Token_Index;
      Opt_Res_8 :
            Bare_Protected_Node
               := No_Bare_Ada_Node;
      Defer_Pos_167 :
            Token_Index
               := No_Token_Index;
      Defer_Res_167 :
            Bare_Subp_Spec
               := No_Bare_Ada_Node;
      Transform_Res_99 :
            Bare_Access_To_Subp_Def
               := No_Bare_Ada_Node;
      Row_Pos_114 :
            Token_Index
               := No_Token_Index;
      Row_Pos_115 :
            Token_Index
               := No_Token_Index;
      Token_Pos_144 :
            Token_Index
               := No_Token_Index;
      Token_Res_144 :
            Token_Index
               := No_Token_Index;
      Token_Pos_145 :
            Token_Index
               := No_Token_Index;
      Token_Res_145 :
            Token_Index
               := No_Token_Index;
      Opt_Res_9 :
            Bare_Not_Null
               := No_Bare_Ada_Node;
      Token_Pos_146 :
            Token_Index
               := No_Token_Index;
      Token_Res_146 :
            Token_Index
               := No_Token_Index;
      Token_Pos_147 :
            Token_Index
               := No_Token_Index;
      Token_Res_147 :
            Token_Index
               := No_Token_Index;
      Opt_Res_10 :
            Bare_All_Node
               := No_Bare_Ada_Node;
      Token_Pos_148 :
            Token_Index
               := No_Token_Index;
      Token_Res_148 :
            Token_Index
               := No_Token_Index;
      Opt_Res_11 :
            Bare_Constant_Node
               := No_Bare_Ada_Node;
      Defer_Pos_168 :
            Token_Index
               := No_Token_Index;
      Defer_Res_168 :
            Bare_Subtype_Indication
               := No_Bare_Ada_Node;
      Transform_Res_100 :
            Bare_Type_Access_Def
               := No_Bare_Ada_Node;
      Or_Pos_43 :
            Token_Index
               := No_Token_Index;
      Or_Res_43 :
            Bare_Access_Def
               := No_Bare_Ada_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Access_Def_Or_Parse_0_Memo, Pos);

begin

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Or_Res_43 := M.Instance;
      return Or_Res_43;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Or_Res_43;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start or_code

Or_Pos_43 := No_Token_Index;
Or_Res_43 := No_Bare_Ada_Node;
    
--  Start transform_code


--  Start row_code

Row_Pos_112 := Pos;



--  Start opt_code




--  Start row_code

Row_Pos_113 := Row_Pos_112;



--  Start tok_code

Token_Res_140 := Row_Pos_113;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_140));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Not)
   then
       Token_Pos_140 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_113 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_113,
             Expected_Token_Id => Ada_Not,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_140 := Row_Pos_113 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_140 /= No_Token_Index then

   Row_Pos_113 := Token_Pos_140;

else
   Row_Pos_113 := No_Token_Index;
   goto Exit_Row_101_0;

end if;


--  Start tok_code

Token_Res_141 := Row_Pos_113;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_141));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Null)
   then
       Token_Pos_141 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_113 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_113,
             Expected_Token_Id => Ada_Null,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_141 := Row_Pos_113 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_141 /= No_Token_Index then

   Row_Pos_113 := Token_Pos_141;

else
   Row_Pos_113 := No_Token_Index;
   goto Exit_Row_101_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_101_0>>
pragma Warnings (On, "referenced");

--  End row_code


if Row_Pos_113 = No_Token_Index then

         Opt_Res_7 := Allocate_Not_Null_Absent (Parser.Mem_Pool);
         Initialize
           (Self              => Opt_Res_7,
            Kind              => Ada_Not_Null_Absent,
            Unit              => Parser.Unit,
            Token_Start_Index => Row_Pos_112,
            Token_End_Index   => No_Token_Index);


    Row_Pos_113 := Row_Pos_112;

else

      Opt_Res_7 := Allocate_Not_Null_Present (Parser.Mem_Pool);
      Initialize
        (Self              => Opt_Res_7,
         Kind              => Ada_Not_Null_Present,
         Unit              => Parser.Unit,
         Token_Start_Index => Row_Pos_112,
         Token_End_Index   => Row_Pos_113 - 1);

end if;

--  End opt_code



if Row_Pos_113 /= No_Token_Index then

   Row_Pos_112 := Row_Pos_113;

else
   Row_Pos_112 := No_Token_Index;
   goto Exit_Row_100_0;

end if;


--  Start tok_code

Token_Res_142 := Row_Pos_112;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_142));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Access)
   then
       Token_Pos_142 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_112 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_112,
             Expected_Token_Id => Ada_Access,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_142 := Row_Pos_112 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_142 /= No_Token_Index then

   Row_Pos_112 := Token_Pos_142;

else
   Row_Pos_112 := No_Token_Index;
   goto Exit_Row_100_0;

end if;


--  Start opt_code




--  Start tok_code

Token_Res_143 := Row_Pos_112;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_143));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Identifier)
      or else T.Symbol /= Precomputed_Symbol
        (Precomputed_Symbol_Table (Parser.TDH.Symbols),
         Precomputed_Symbol_Protected)
   then
       Token_Pos_143 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_112 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_112,
             Expected_Token_Id => Ada_Identifier,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_143 := Row_Pos_112 + 1;
   end if;
end;

--  End tok_code


if Token_Pos_143 = No_Token_Index then

         Opt_Res_8 := Allocate_Protected_Absent (Parser.Mem_Pool);
         Initialize
           (Self              => Opt_Res_8,
            Kind              => Ada_Protected_Absent,
            Unit              => Parser.Unit,
            Token_Start_Index => Row_Pos_112,
            Token_End_Index   => No_Token_Index);


    Token_Pos_143 := Row_Pos_112;

else

      Opt_Res_8 := Allocate_Protected_Present (Parser.Mem_Pool);
      Initialize
        (Self              => Opt_Res_8,
         Kind              => Ada_Protected_Present,
         Unit              => Parser.Unit,
         Token_Start_Index => Row_Pos_112,
         Token_End_Index   => Token_Pos_143 - 1);

end if;

--  End opt_code



if Token_Pos_143 /= No_Token_Index then

   Row_Pos_112 := Token_Pos_143;

else
   Row_Pos_112 := No_Token_Index;
   goto Exit_Row_100_0;

end if;


Defer_Res_167 :=
   Subp_Spec_Transform_Parse_2 (Parser, Row_Pos_112);
Defer_Pos_167 := Parser.Current_Pos;



if Defer_Pos_167 /= No_Token_Index then

   Row_Pos_112 := Defer_Pos_167;

else
   Row_Pos_112 := No_Token_Index;
   goto Exit_Row_100_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_100_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_112 /= No_Token_Index then

   Transform_Res_99 := Allocate_Access_To_Subp_Def (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_99,
      Kind => Ada_Access_To_Subp_Def,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_112 = Pos
                            then No_Token_Index
                            else Row_Pos_112 - 1));

      Initialize_Fields_For_Access_To_Subp_Def
        (Self => Transform_Res_99, Access_Def_F_Has_Not_Null => Opt_Res_7, Access_To_Subp_Def_F_Has_Protected => Opt_Res_8, Access_To_Subp_Def_F_Subp_Spec => Defer_Res_167);

         if Opt_Res_7 /= null and then Is_Incomplete (Opt_Res_7) then
            Transform_Res_99.Last_Attempted_Child := 0;
         elsif Opt_Res_7 /= null and then not Is_Ghost (Opt_Res_7) then
            Transform_Res_99.Last_Attempted_Child := -1;
         end if;
         if Opt_Res_8 /= null and then Is_Incomplete (Opt_Res_8) then
            Transform_Res_99.Last_Attempted_Child := 0;
         elsif Opt_Res_8 /= null and then not Is_Ghost (Opt_Res_8) then
            Transform_Res_99.Last_Attempted_Child := -1;
         end if;
         if Defer_Res_167 /= null and then Is_Incomplete (Defer_Res_167) then
            Transform_Res_99.Last_Attempted_Child := 0;
         elsif Defer_Res_167 /= null and then not Is_Ghost (Defer_Res_167) then
            Transform_Res_99.Last_Attempted_Child := -1;
         end if;


end if;

--  End transform_code

    if Row_Pos_112 /= No_Token_Index then
        Or_Pos_43 := Row_Pos_112;
        Or_Res_43 := Transform_Res_99;
        goto Exit_Or_42;
    end if;
    
--  Start transform_code


--  Start row_code

Row_Pos_114 := Pos;



--  Start opt_code




--  Start row_code

Row_Pos_115 := Row_Pos_114;



--  Start tok_code

Token_Res_144 := Row_Pos_115;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_144));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Not)
   then
       Token_Pos_144 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_115 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_115,
             Expected_Token_Id => Ada_Not,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_144 := Row_Pos_115 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_144 /= No_Token_Index then

   Row_Pos_115 := Token_Pos_144;

else
   Row_Pos_115 := No_Token_Index;
   goto Exit_Row_112_0;

end if;


--  Start tok_code

Token_Res_145 := Row_Pos_115;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_145));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Null)
   then
       Token_Pos_145 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_115 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_115,
             Expected_Token_Id => Ada_Null,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_145 := Row_Pos_115 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_145 /= No_Token_Index then

   Row_Pos_115 := Token_Pos_145;

else
   Row_Pos_115 := No_Token_Index;
   goto Exit_Row_112_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_112_0>>
pragma Warnings (On, "referenced");

--  End row_code


if Row_Pos_115 = No_Token_Index then

         Opt_Res_9 := Allocate_Not_Null_Absent (Parser.Mem_Pool);
         Initialize
           (Self              => Opt_Res_9,
            Kind              => Ada_Not_Null_Absent,
            Unit              => Parser.Unit,
            Token_Start_Index => Row_Pos_114,
            Token_End_Index   => No_Token_Index);


    Row_Pos_115 := Row_Pos_114;

else

      Opt_Res_9 := Allocate_Not_Null_Present (Parser.Mem_Pool);
      Initialize
        (Self              => Opt_Res_9,
         Kind              => Ada_Not_Null_Present,
         Unit              => Parser.Unit,
         Token_Start_Index => Row_Pos_114,
         Token_End_Index   => Row_Pos_115 - 1);

end if;

--  End opt_code



if Row_Pos_115 /= No_Token_Index then

   Row_Pos_114 := Row_Pos_115;

else
   Row_Pos_114 := No_Token_Index;
   goto Exit_Row_111_0;

end if;


--  Start tok_code

Token_Res_146 := Row_Pos_114;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_146));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Access)
   then
       Token_Pos_146 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_114 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_114,
             Expected_Token_Id => Ada_Access,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_146 := Row_Pos_114 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_146 /= No_Token_Index then

   Row_Pos_114 := Token_Pos_146;

else
   Row_Pos_114 := No_Token_Index;
   goto Exit_Row_111_0;

end if;


--  Start opt_code




--  Start tok_code

Token_Res_147 := Row_Pos_114;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_147));
begin
   if
      T.Kind /= From_Token_Kind (Ada_All)
   then
       Token_Pos_147 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_114 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_114,
             Expected_Token_Id => Ada_All,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_147 := Row_Pos_114 + 1;
   end if;
end;

--  End tok_code


if Token_Pos_147 = No_Token_Index then

         Opt_Res_10 := Allocate_All_Absent (Parser.Mem_Pool);
         Initialize
           (Self              => Opt_Res_10,
            Kind              => Ada_All_Absent,
            Unit              => Parser.Unit,
            Token_Start_Index => Row_Pos_114,
            Token_End_Index   => No_Token_Index);


    Token_Pos_147 := Row_Pos_114;

else

      Opt_Res_10 := Allocate_All_Present (Parser.Mem_Pool);
      Initialize
        (Self              => Opt_Res_10,
         Kind              => Ada_All_Present,
         Unit              => Parser.Unit,
         Token_Start_Index => Row_Pos_114,
         Token_End_Index   => Token_Pos_147 - 1);

end if;

--  End opt_code



if Token_Pos_147 /= No_Token_Index then

   Row_Pos_114 := Token_Pos_147;

else
   Row_Pos_114 := No_Token_Index;
   goto Exit_Row_111_0;

end if;


--  Start opt_code




--  Start tok_code

Token_Res_148 := Row_Pos_114;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_148));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Constant)
   then
       Token_Pos_148 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_114 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_114,
             Expected_Token_Id => Ada_Constant,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_148 := Row_Pos_114 + 1;
   end if;
end;

--  End tok_code


if Token_Pos_148 = No_Token_Index then

         Opt_Res_11 := Allocate_Constant_Absent (Parser.Mem_Pool);
         Initialize
           (Self              => Opt_Res_11,
            Kind              => Ada_Constant_Absent,
            Unit              => Parser.Unit,
            Token_Start_Index => Row_Pos_114,
            Token_End_Index   => No_Token_Index);


    Token_Pos_148 := Row_Pos_114;

else

      Opt_Res_11 := Allocate_Constant_Present (Parser.Mem_Pool);
      Initialize
        (Self              => Opt_Res_11,
         Kind              => Ada_Constant_Present,
         Unit              => Parser.Unit,
         Token_Start_Index => Row_Pos_114,
         Token_End_Index   => Token_Pos_148 - 1);

end if;

--  End opt_code



if Token_Pos_148 /= No_Token_Index then

   Row_Pos_114 := Token_Pos_148;

else
   Row_Pos_114 := No_Token_Index;
   goto Exit_Row_111_0;

end if;


Defer_Res_168 :=
   Subtype_Indication_Transform_Parse_0 (Parser, Row_Pos_114);
Defer_Pos_168 := Parser.Current_Pos;



if Defer_Pos_168 /= No_Token_Index then

   Row_Pos_114 := Defer_Pos_168;

else
   Row_Pos_114 := No_Token_Index;
   goto Exit_Row_111_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_111_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_114 /= No_Token_Index then

   Transform_Res_100 := Allocate_Type_Access_Def (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_100,
      Kind => Ada_Type_Access_Def,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_114 = Pos
                            then No_Token_Index
                            else Row_Pos_114 - 1));

      Initialize_Fields_For_Type_Access_Def
        (Self => Transform_Res_100, Access_Def_F_Has_Not_Null => Opt_Res_9, Type_Access_Def_F_Has_All => Opt_Res_10, Type_Access_Def_F_Has_Constant => Opt_Res_11, Type_Access_Def_F_Subtype_Indication => Defer_Res_168);

         if Opt_Res_9 /= null and then Is_Incomplete (Opt_Res_9) then
            Transform_Res_100.Last_Attempted_Child := 0;
         elsif Opt_Res_9 /= null and then not Is_Ghost (Opt_Res_9) then
            Transform_Res_100.Last_Attempted_Child := -1;
         end if;
         if Opt_Res_10 /= null and then Is_Incomplete (Opt_Res_10) then
            Transform_Res_100.Last_Attempted_Child := 0;
         elsif Opt_Res_10 /= null and then not Is_Ghost (Opt_Res_10) then
            Transform_Res_100.Last_Attempted_Child := -1;
         end if;
         if Opt_Res_11 /= null and then Is_Incomplete (Opt_Res_11) then
            Transform_Res_100.Last_Attempted_Child := 0;
         elsif Opt_Res_11 /= null and then not Is_Ghost (Opt_Res_11) then
            Transform_Res_100.Last_Attempted_Child := -1;
         end if;
         if Defer_Res_168 /= null and then Is_Incomplete (Defer_Res_168) then
            Transform_Res_100.Last_Attempted_Child := 0;
         elsif Defer_Res_168 /= null and then not Is_Ghost (Defer_Res_168) then
            Transform_Res_100.Last_Attempted_Child := -1;
         end if;


end if;

--  End transform_code

    if Row_Pos_114 /= No_Token_Index then
        Or_Pos_43 := Row_Pos_114;
        Or_Res_43 := Transform_Res_100;
        goto Exit_Or_42;
    end if;
<<Exit_Or_42>>

--  End or_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Access_Def_Or_Parse_0_Memo,
      Or_Pos_43 /= No_Token_Index,
      Or_Res_43,
      Pos,
      Or_Pos_43);


   Parser.Current_Pos := Or_Pos_43;

   return Or_Res_43;
end Access_Def_Or_Parse_0;

   


function Contract_Case_Assoc_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Contract_Case_Assoc
is
   use Bare_Contract_Case_Assoc_Memos;

      Row_Pos_129 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_186 :
            Token_Index
               := No_Token_Index;
      Defer_Res_186 :
            Bare_Expr
               := No_Bare_Ada_Node;
      Defer_Pos_187 :
            Token_Index
               := No_Token_Index;
      Defer_Res_187 :
            Bare_Others_Designator
               := No_Bare_Ada_Node;
      Or_Pos_47 :
            Token_Index
               := No_Token_Index;
      Or_Res_47 :
            Bare_Ada_Node
               := No_Bare_Ada_Node;
      Token_Pos_166 :
            Token_Index
               := No_Token_Index;
      Token_Res_166 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_188 :
            Token_Index
               := No_Token_Index;
      Defer_Res_188 :
            Bare_Expr
               := No_Bare_Ada_Node;
      Transform_Res_111 :
            Bare_Contract_Case_Assoc
               := No_Bare_Ada_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Contract_Case_Assoc_Transform_Parse_0_Memo, Pos);

begin

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res_111 := M.Instance;
      return Transform_Res_111;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res_111;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code


--  Start row_code

Row_Pos_129 := Pos;



--  Start or_code

Or_Pos_47 := No_Token_Index;
Or_Res_47 := No_Bare_Ada_Node;
    
Defer_Res_186 :=
   Expr_Or_Parse_0 (Parser, Row_Pos_129);
Defer_Pos_186 := Parser.Current_Pos;

    if Defer_Pos_186 /= No_Token_Index then
        Or_Pos_47 := Defer_Pos_186;
        Or_Res_47 := Defer_Res_186;
        goto Exit_Or_46;
    end if;
    
Defer_Res_187 :=
   Others_Designator_Transform_Parse_0 (Parser, Row_Pos_129);
Defer_Pos_187 := Parser.Current_Pos;

    if Defer_Pos_187 /= No_Token_Index then
        Or_Pos_47 := Defer_Pos_187;
        Or_Res_47 := Defer_Res_187;
        goto Exit_Or_46;
    end if;
<<Exit_Or_46>>

--  End or_code



if Or_Pos_47 /= No_Token_Index then

   Row_Pos_129 := Or_Pos_47;

else
   Row_Pos_129 := No_Token_Index;
   goto Exit_Row_117_0;

end if;


--  Start tok_code

Token_Res_166 := Row_Pos_129;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_166));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Arrow)
   then
       Token_Pos_166 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_129 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_129,
             Expected_Token_Id => Ada_Arrow,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_166 := Row_Pos_129 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_166 /= No_Token_Index then

   Row_Pos_129 := Token_Pos_166;

else
   Row_Pos_129 := No_Token_Index;
   goto Exit_Row_117_0;

end if;


Defer_Res_188 :=
   Expr_Or_Parse_0 (Parser, Row_Pos_129);
Defer_Pos_188 := Parser.Current_Pos;



if Defer_Pos_188 /= No_Token_Index then

   Row_Pos_129 := Defer_Pos_188;

else
   Row_Pos_129 := No_Token_Index;
   goto Exit_Row_117_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_117_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_129 /= No_Token_Index then

   Transform_Res_111 := Allocate_Contract_Case_Assoc (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_111,
      Kind => Ada_Contract_Case_Assoc,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_129 = Pos
                            then No_Token_Index
                            else Row_Pos_129 - 1));

      Initialize_Fields_For_Contract_Case_Assoc
        (Self => Transform_Res_111, Contract_Case_Assoc_F_Guard => Or_Res_47, Contract_Case_Assoc_F_Consequence => Defer_Res_188);

         if Or_Res_47 /= null and then Is_Incomplete (Or_Res_47) then
            Transform_Res_111.Last_Attempted_Child := 0;
         elsif Or_Res_47 /= null and then not Is_Ghost (Or_Res_47) then
            Transform_Res_111.Last_Attempted_Child := -1;
         end if;
         if Defer_Res_188 /= null and then Is_Incomplete (Defer_Res_188) then
            Transform_Res_111.Last_Attempted_Child := 0;
         elsif Defer_Res_188 /= null and then not Is_Ghost (Defer_Res_188) then
            Transform_Res_111.Last_Attempted_Child := -1;
         end if;


end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Contract_Case_Assoc_Transform_Parse_0_Memo,
      Row_Pos_129 /= No_Token_Index,
      Transform_Res_111,
      Pos,
      Row_Pos_129);


   Parser.Current_Pos := Row_Pos_129;

   return Transform_Res_111;
end Contract_Case_Assoc_Transform_Parse_0;

   


function Contract_Cases_Expr_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Contract_Cases
is
   use Bare_Contract_Cases_Memos;

      Row_Pos_128 :
            Token_Index
               := No_Token_Index;
      Token_Pos_163 :
            Token_Index
               := No_Token_Index;
      Token_Res_163 :
            Token_Index
               := No_Token_Index;
      Lst_Cpos_17 :
            Token_Index
               := No_Token_Index;
      Tmp_List_17 :
            Free_Parse_List;
      Defer_Pos_185 :
            Token_Index
               := No_Token_Index;
      Defer_Res_185 :
            Bare_Contract_Case_Assoc
               := No_Bare_Ada_Node;
      Token_Pos_164 :
            Token_Index
               := No_Token_Index;
      Token_Res_164 :
            Token_Index
               := No_Token_Index;
      List_Pos_17 :
            Token_Index
               := No_Token_Index;
      List_Res_17 :
            Bare_Contract_Case_Assoc_List
               := No_Bare_Ada_Node;
      Token_Pos_165 :
            Token_Index
               := No_Token_Index;
      Token_Res_165 :
            Token_Index
               := No_Token_Index;
      Transform_Res_110 :
            Bare_Contract_Cases
               := No_Bare_Ada_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Contract_Cases_Expr_Transform_Parse_0_Memo, Pos);

begin

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res_110 := M.Instance;
      return Transform_Res_110;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res_110;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code


--  Start row_code

Row_Pos_128 := Pos;



--  Start tok_code

Token_Res_163 := Row_Pos_128;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_163));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Par_Open)
   then
       Token_Pos_163 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_128 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_128,
             Expected_Token_Id => Ada_Par_Open,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_163 := Row_Pos_128 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_163 /= No_Token_Index then

   Row_Pos_128 := Token_Pos_163;

else
   Row_Pos_128 := No_Token_Index;
   goto Exit_Row_116_0;

end if;


--  Start list_code

    List_Pos_17 := No_Token_Index;



Lst_Cpos_17 := Row_Pos_128;
Tmp_List_17 := Get_Parse_List (Parser);

loop
   
Defer_Res_185 :=
   Contract_Case_Assoc_Transform_Parse_0 (Parser, Lst_Cpos_17);
Defer_Pos_185 := Parser.Current_Pos;


   exit when Defer_Pos_185 = No_Token_Index;

   List_Pos_17 := Defer_Pos_185;
   Lst_Cpos_17 := List_Pos_17;

   Tmp_List_17.Nodes.Append (Defer_Res_185);

      
--  Start tok_code

Token_Res_164 := Lst_Cpos_17;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_164));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Comma)
   then
       Token_Pos_164 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Lst_Cpos_17 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Lst_Cpos_17,
             Expected_Token_Id => Ada_Comma,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_164 := Lst_Cpos_17 + 1;
   end if;
end;

--  End tok_code

      if Token_Pos_164 /= No_Token_Index then
          Lst_Cpos_17 := Token_Pos_164;
      else
         exit;
      end if;

end loop;

declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List_17.Nodes.Length;
begin
   List_Res_17 :=
      Allocate_Contract_Case_Assoc_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Row_Pos_128;
      Token_End := (if Lst_Cpos_17 = Row_Pos_128
                    then Row_Pos_128
                    else Lst_Cpos_17 - 1);

   else
      Token_Start := Token_Index'Max (Row_Pos_128, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res_17,
      Kind              => Ada_Contract_Case_Assoc_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res_17,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_Ada_Node_Vectors.Vector renames
         Tmp_List_17.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res_17.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List_17);

--  End list_code



if List_Pos_17 /= No_Token_Index then

   Row_Pos_128 := List_Pos_17;

else
   Row_Pos_128 := No_Token_Index;
   goto Exit_Row_116_0;

end if;


--  Start tok_code

Token_Res_165 := Row_Pos_128;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_165));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Par_Close)
   then
       Token_Pos_165 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_128 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_128,
             Expected_Token_Id => Ada_Par_Close,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_165 := Row_Pos_128 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_165 /= No_Token_Index then

   Row_Pos_128 := Token_Pos_165;

else
   Row_Pos_128 := No_Token_Index;
   goto Exit_Row_116_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_116_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_128 /= No_Token_Index then

   Transform_Res_110 := Allocate_Contract_Cases (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_110,
      Kind => Ada_Contract_Cases,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_128 = Pos
                            then No_Token_Index
                            else Row_Pos_128 - 1));

      Initialize_Fields_For_Contract_Cases
        (Self => Transform_Res_110, Contract_Cases_F_Contract_Cases => List_Res_17);

         if List_Res_17 /= null and then Is_Incomplete (List_Res_17) then
            Transform_Res_110.Last_Attempted_Child := 0;
         elsif List_Res_17 /= null and then not Is_Ghost (List_Res_17) then
            Transform_Res_110.Last_Attempted_Child := -1;
         end if;


end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Contract_Cases_Expr_Transform_Parse_0_Memo,
      Row_Pos_128 /= No_Token_Index,
      Transform_Res_110,
      Pos,
      Row_Pos_128);


   Parser.Current_Pos := Row_Pos_128;

   return Transform_Res_110;
end Contract_Cases_Expr_Transform_Parse_0;

   


function Aspect_Assoc_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Aspect_Assoc
is
   use Bare_Aspect_Assoc_Memos;

      Row_Pos_126 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_182 :
            Token_Index
               := No_Token_Index;
      Defer_Res_182 :
            Bare_Name
               := No_Bare_Ada_Node;
      Row_Pos_127 :
            Token_Index
               := No_Token_Index;
      Token_Pos_162 :
            Token_Index
               := No_Token_Index;
      Token_Res_162 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_183 :
            Token_Index
               := No_Token_Index;
      Defer_Res_183 :
            Bare_Expr
               := No_Bare_Ada_Node;
      Defer_Pos_184 :
            Token_Index
               := No_Token_Index;
      Defer_Res_184 :
            Bare_Contract_Cases
               := No_Bare_Ada_Node;
      Or_Pos_46 :
            Token_Index
               := No_Token_Index;
      Or_Res_46 :
            Bare_Expr
               := No_Bare_Ada_Node;
      Transform_Res_109 :
            Bare_Aspect_Assoc
               := No_Bare_Ada_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Aspect_Assoc_Transform_Parse_0_Memo, Pos);

begin

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res_109 := M.Instance;
      return Transform_Res_109;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res_109;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code


--  Start row_code

Row_Pos_126 := Pos;



Defer_Res_182 :=
   Name_Or_Parse_1 (Parser, Row_Pos_126);
Defer_Pos_182 := Parser.Current_Pos;



if Defer_Pos_182 /= No_Token_Index then

   Row_Pos_126 := Defer_Pos_182;

else
   Row_Pos_126 := No_Token_Index;
   goto Exit_Row_114_0;

end if;


--  Start opt_code




--  Start row_code

Row_Pos_127 := Row_Pos_126;



--  Start tok_code

Token_Res_162 := Row_Pos_127;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_162));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Arrow)
   then
       Token_Pos_162 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_127 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_127,
             Expected_Token_Id => Ada_Arrow,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_162 := Row_Pos_127 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_162 /= No_Token_Index then

   Row_Pos_127 := Token_Pos_162;

else
   Row_Pos_127 := No_Token_Index;
   goto Exit_Row_115_0;

end if;


--  Start or_code

Or_Pos_46 := No_Token_Index;
Or_Res_46 := No_Bare_Ada_Node;
    
Defer_Res_183 :=
   Expr_Or_Parse_0 (Parser, Row_Pos_127);
Defer_Pos_183 := Parser.Current_Pos;

    if Defer_Pos_183 /= No_Token_Index then
        Or_Pos_46 := Defer_Pos_183;
        Or_Res_46 := Defer_Res_183;
        goto Exit_Or_45;
    end if;
    
Defer_Res_184 :=
   Contract_Cases_Expr_Transform_Parse_0 (Parser, Row_Pos_127);
Defer_Pos_184 := Parser.Current_Pos;

    if Defer_Pos_184 /= No_Token_Index then
        Or_Pos_46 := Defer_Pos_184;
        Or_Res_46 := Defer_Res_184;
        goto Exit_Or_45;
    end if;
<<Exit_Or_45>>

--  End or_code



if Or_Pos_46 /= No_Token_Index then

   Row_Pos_127 := Or_Pos_46;

else
   Row_Pos_127 := No_Token_Index;
   goto Exit_Row_115_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_115_0>>
pragma Warnings (On, "referenced");

--  End row_code


if Row_Pos_127 = No_Token_Index then

        Or_Res_46 := No_Bare_Ada_Node;


    Row_Pos_127 := Row_Pos_126;


end if;

--  End opt_code



if Row_Pos_127 /= No_Token_Index then

   Row_Pos_126 := Row_Pos_127;

else
   Row_Pos_126 := No_Token_Index;
   goto Exit_Row_114_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_114_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_126 /= No_Token_Index then

   Transform_Res_109 := Allocate_Aspect_Assoc (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_109,
      Kind => Ada_Aspect_Assoc,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_126 = Pos
                            then No_Token_Index
                            else Row_Pos_126 - 1));

      Initialize_Fields_For_Aspect_Assoc
        (Self => Transform_Res_109, Aspect_Assoc_F_Id => Defer_Res_182, Aspect_Assoc_F_Expr => Or_Res_46);

         if Defer_Res_182 /= null and then Is_Incomplete (Defer_Res_182) then
            Transform_Res_109.Last_Attempted_Child := 0;
         elsif Defer_Res_182 /= null and then not Is_Ghost (Defer_Res_182) then
            Transform_Res_109.Last_Attempted_Child := -1;
         end if;
         if Or_Res_46 /= null and then Is_Incomplete (Or_Res_46) then
            Transform_Res_109.Last_Attempted_Child := 0;
         elsif Or_Res_46 /= null and then not Is_Ghost (Or_Res_46) then
            Transform_Res_109.Last_Attempted_Child := -1;
         end if;


end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Aspect_Assoc_Transform_Parse_0_Memo,
      Row_Pos_126 /= No_Token_Index,
      Transform_Res_109,
      Pos,
      Row_Pos_126);


   Parser.Current_Pos := Row_Pos_126;

   return Transform_Res_109;
end Aspect_Assoc_Transform_Parse_0;

   


function Aspect_Spec_Opt_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Aspect_Spec
is
   use Bare_Aspect_Spec_Memos;

      Nobt_15 :
            Boolean
               := False;
      Row_Pos_125 :
            Token_Index
               := No_Token_Index;
      Token_Pos_160 :
            Token_Index
               := No_Token_Index;
      Token_Res_160 :
            Token_Index
               := No_Token_Index;
      Lst_Cpos_16 :
            Token_Index
               := No_Token_Index;
      Tmp_List_16 :
            Free_Parse_List;
      Defer_Pos_181 :
            Token_Index
               := No_Token_Index;
      Defer_Res_181 :
            Bare_Aspect_Assoc
               := No_Bare_Ada_Node;
      Token_Pos_161 :
            Token_Index
               := No_Token_Index;
      Token_Res_161 :
            Token_Index
               := No_Token_Index;
      List_Pos_16 :
            Token_Index
               := No_Token_Index;
      List_Res_16 :
            Bare_Aspect_Assoc_List
               := No_Bare_Ada_Node;
      Row_Progress_15 :
            Integer
               := 0;
      Transform_Res_108 :
            Bare_Aspect_Spec
               := No_Bare_Ada_Node;
      Transform_Has_Failed_15 :
            Boolean
               := False;


   M : Memo_Entry := Get (Parser.Private_Part.Aspect_Spec_Opt_Parse_0_Memo, Pos);

begin

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res_108 := M.Instance;
      return Transform_Res_108;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res_108;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start opt_code




--  Start transform_code


--  Start row_code

Row_Pos_125 := Pos;



--  Start tok_code

Token_Res_160 := Row_Pos_125;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_160));
begin
   if
      T.Kind /= From_Token_Kind (Ada_With)
   then
       Token_Pos_160 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_125 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_125,
             Expected_Token_Id => Ada_With,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_160 := Row_Pos_125 + 1;
   end if;
end;

--  End tok_code


Row_Progress_15 := 1;

if Token_Pos_160 /= No_Token_Index then

   Row_Pos_125 := Token_Pos_160;

else
   Row_Pos_125 := No_Token_Index;
   goto Exit_Row_113_0;

end if;

Nobt_15 := True;

Row_Progress_15 := 2;

if Row_Pos_125 /= No_Token_Index then

   Row_Pos_125 := Row_Pos_125;

else
   Row_Pos_125 := No_Token_Index;
   goto Exit_Row_113_0;

end if;


--  Start list_code

    List_Pos_16 := No_Token_Index;



Lst_Cpos_16 := Row_Pos_125;
Tmp_List_16 := Get_Parse_List (Parser);

loop
   
Defer_Res_181 :=
   Aspect_Assoc_Transform_Parse_0 (Parser, Lst_Cpos_16);
Defer_Pos_181 := Parser.Current_Pos;


   exit when Defer_Pos_181 = No_Token_Index;

   List_Pos_16 := Defer_Pos_181;
   Lst_Cpos_16 := List_Pos_16;

   Tmp_List_16.Nodes.Append (Defer_Res_181);

      
--  Start tok_code

Token_Res_161 := Lst_Cpos_16;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_161));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Comma)
   then
       Token_Pos_161 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Lst_Cpos_16 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Lst_Cpos_16,
             Expected_Token_Id => Ada_Comma,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_161 := Lst_Cpos_16 + 1;
   end if;
end;

--  End tok_code

      if Token_Pos_161 /= No_Token_Index then
          Lst_Cpos_16 := Token_Pos_161;
      else
         exit;
      end if;

end loop;

declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List_16.Nodes.Length;
begin
   List_Res_16 :=
      Allocate_Aspect_Assoc_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Row_Pos_125;
      Token_End := (if Lst_Cpos_16 = Row_Pos_125
                    then Row_Pos_125
                    else Lst_Cpos_16 - 1);

   else
      Token_Start := Token_Index'Max (Row_Pos_125, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res_16,
      Kind              => Ada_Aspect_Assoc_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res_16,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_Ada_Node_Vectors.Vector renames
         Tmp_List_16.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res_16.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List_16);

--  End list_code


Row_Progress_15 := 3;

if List_Pos_16 /= No_Token_Index then

   Row_Pos_125 := List_Pos_16;

else
   Row_Pos_125 := No_Token_Index;
   goto Exit_Row_113_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_113_0>>
pragma Warnings (On, "referenced");

--  End row_code


if Row_Pos_125 = No_Token_Index and then Nobt_15 then
   Row_Pos_125 := Parser.Last_Fail.Pos;
   Transform_Has_Failed_15 := True;
end if;

if Row_Pos_125 /= No_Token_Index then

   Transform_Res_108 := Allocate_Aspect_Spec (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_108,
      Kind => Ada_Aspect_Spec,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_125 = Pos
                            then No_Token_Index
                            else Row_Pos_125 - 1));

      Initialize_Fields_For_Aspect_Spec
        (Self => Transform_Res_108, Aspect_Spec_F_Aspect_Assocs => List_Res_16);

         if List_Res_16 /= null and then Is_Incomplete (List_Res_16) then
            Transform_Res_108.Last_Attempted_Child := 0;
         elsif List_Res_16 /= null and then not Is_Ghost (List_Res_16) then
            Transform_Res_108.Last_Attempted_Child := -1;
         end if;

   if Transform_Has_Failed_15 then
      Transform_Res_108.Last_Attempted_Child :=
         Row_Progress_15;

      Append (Parser.Diagnostics,
              Sloc_Range (Parser.TDH.all,
                          Get_Token (Parser.TDH.all, Pos)),
              To_Text ("Cannot parse <aspect_spec>"));

      Add_Last_Fail_Diagnostic (Parser);
   end if;

end if;

--  End transform_code


if Row_Pos_125 = No_Token_Index then

        Transform_Res_108 := No_Bare_Ada_Node;


    Row_Pos_125 := Pos;


end if;

--  End opt_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Aspect_Spec_Opt_Parse_0_Memo,
      Row_Pos_125 /= No_Token_Index,
      Transform_Res_108,
      Pos,
      Row_Pos_125);


   Parser.Current_Pos := Row_Pos_125;

   return Transform_Res_108;
end Aspect_Spec_Opt_Parse_0;

   


function Anonymous_Type_Decl_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Anonymous_Type_Decl
is
   use Bare_Anonymous_Type_Decl_Memos;

      Row_Pos_106 :
            Token_Index
               := No_Token_Index;
      Null_Res_5 :
            Bare_Defining_Name
               := No_Bare_Ada_Node;
      Null_Res_6 :
            Bare_Discriminant_Part
               := No_Bare_Ada_Node;
      Defer_Pos_159 :
            Token_Index
               := No_Token_Index;
      Defer_Res_159 :
            Bare_Array_Type_Def
               := No_Bare_Ada_Node;
      Defer_Pos_160 :
            Token_Index
               := No_Token_Index;
      Defer_Res_160 :
            Bare_Access_Def
               := No_Bare_Ada_Node;
      Or_Pos_41 :
            Token_Index
               := No_Token_Index;
      Or_Res_41 :
            Bare_Type_Def
               := No_Bare_Ada_Node;
      Defer_Pos_161 :
            Token_Index
               := No_Token_Index;
      Defer_Res_161 :
            Bare_Aspect_Spec
               := No_Bare_Ada_Node;
      Transform_Res_93 :
            Bare_Anonymous_Type_Decl
               := No_Bare_Ada_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Anonymous_Type_Decl_Transform_Parse_0_Memo, Pos);

begin

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res_93 := M.Instance;
      return Transform_Res_93;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res_93;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code


--  Start row_code

Row_Pos_106 := Pos;



   Null_Res_5 := No_Bare_Ada_Node;



if Row_Pos_106 /= No_Token_Index then

   Row_Pos_106 := Row_Pos_106;

else
   Row_Pos_106 := No_Token_Index;
   goto Exit_Row_94_0;

end if;


   Null_Res_6 := No_Bare_Ada_Node;



if Row_Pos_106 /= No_Token_Index then

   Row_Pos_106 := Row_Pos_106;

else
   Row_Pos_106 := No_Token_Index;
   goto Exit_Row_94_0;

end if;


--  Start or_code

Or_Pos_41 := No_Token_Index;
Or_Res_41 := No_Bare_Ada_Node;
    
Defer_Res_159 :=
   Array_Type_Def_Transform_Parse_2 (Parser, Row_Pos_106);
Defer_Pos_159 := Parser.Current_Pos;

    if Defer_Pos_159 /= No_Token_Index then
        Or_Pos_41 := Defer_Pos_159;
        Or_Res_41 := Defer_Res_159;
        goto Exit_Or_40;
    end if;
    
Defer_Res_160 :=
   Access_Def_Or_Parse_0 (Parser, Row_Pos_106);
Defer_Pos_160 := Parser.Current_Pos;

    if Defer_Pos_160 /= No_Token_Index then
        Or_Pos_41 := Defer_Pos_160;
        Or_Res_41 := Defer_Res_160;
        goto Exit_Or_40;
    end if;
<<Exit_Or_40>>

--  End or_code



if Or_Pos_41 /= No_Token_Index then

   Row_Pos_106 := Or_Pos_41;

else
   Row_Pos_106 := No_Token_Index;
   goto Exit_Row_94_0;

end if;


Defer_Res_161 :=
   Aspect_Spec_Opt_Parse_0 (Parser, Row_Pos_106);
Defer_Pos_161 := Parser.Current_Pos;



if Defer_Pos_161 /= No_Token_Index then

   Row_Pos_106 := Defer_Pos_161;

else
   Row_Pos_106 := No_Token_Index;
   goto Exit_Row_94_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_94_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_106 /= No_Token_Index then

   Transform_Res_93 := Allocate_Anonymous_Type_Decl (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_93,
      Kind => Ada_Anonymous_Type_Decl,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_106 = Pos
                            then No_Token_Index
                            else Row_Pos_106 - 1));

      Initialize_Fields_For_Anonymous_Type_Decl
        (Self => Transform_Res_93, Base_Type_Decl_F_Name => Null_Res_5, Type_Decl_F_Discriminants => Null_Res_6, Type_Decl_F_Type_Def => Or_Res_41, Type_Decl_F_Aspects => Defer_Res_161);

         if Null_Res_5 /= null and then Is_Incomplete (Null_Res_5) then
            Transform_Res_93.Last_Attempted_Child := 0;
         elsif Null_Res_5 /= null and then not Is_Ghost (Null_Res_5) then
            Transform_Res_93.Last_Attempted_Child := -1;
         end if;
         if Null_Res_6 /= null and then Is_Incomplete (Null_Res_6) then
            Transform_Res_93.Last_Attempted_Child := 0;
         elsif Null_Res_6 /= null and then not Is_Ghost (Null_Res_6) then
            Transform_Res_93.Last_Attempted_Child := -1;
         end if;
         if Or_Res_41 /= null and then Is_Incomplete (Or_Res_41) then
            Transform_Res_93.Last_Attempted_Child := 0;
         elsif Or_Res_41 /= null and then not Is_Ghost (Or_Res_41) then
            Transform_Res_93.Last_Attempted_Child := -1;
         end if;
         if Defer_Res_161 /= null and then Is_Incomplete (Defer_Res_161) then
            Transform_Res_93.Last_Attempted_Child := 0;
         elsif Defer_Res_161 /= null and then not Is_Ghost (Defer_Res_161) then
            Transform_Res_93.Last_Attempted_Child := -1;
         end if;


end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Anonymous_Type_Decl_Transform_Parse_0_Memo,
      Row_Pos_106 /= No_Token_Index,
      Transform_Res_93,
      Pos,
      Row_Pos_106);


   Parser.Current_Pos := Row_Pos_106;

   return Transform_Res_93;
end Anonymous_Type_Decl_Transform_Parse_0;

   


function Anonymous_Type_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Anonymous_Type
is
   use Bare_Anonymous_Type_Memos;

      Row_Pos_105 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_158 :
            Token_Index
               := No_Token_Index;
      Defer_Res_158 :
            Bare_Anonymous_Type_Decl
               := No_Bare_Ada_Node;
      Transform_Res_92 :
            Bare_Anonymous_Type
               := No_Bare_Ada_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Anonymous_Type_Transform_Parse_0_Memo, Pos);

begin

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res_92 := M.Instance;
      return Transform_Res_92;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res_92;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code


--  Start row_code

Row_Pos_105 := Pos;



Defer_Res_158 :=
   Anonymous_Type_Decl_Transform_Parse_0 (Parser, Row_Pos_105);
Defer_Pos_158 := Parser.Current_Pos;



if Defer_Pos_158 /= No_Token_Index then

   Row_Pos_105 := Defer_Pos_158;

else
   Row_Pos_105 := No_Token_Index;
   goto Exit_Row_93_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_93_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_105 /= No_Token_Index then

   Transform_Res_92 := Allocate_Anonymous_Type (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_92,
      Kind => Ada_Anonymous_Type,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_105 = Pos
                            then No_Token_Index
                            else Row_Pos_105 - 1));

      Initialize_Fields_For_Anonymous_Type
        (Self => Transform_Res_92, Anonymous_Type_F_Type_Decl => Defer_Res_158);

         if Defer_Res_158 /= null and then Is_Incomplete (Defer_Res_158) then
            Transform_Res_92.Last_Attempted_Child := 0;
         elsif Defer_Res_158 /= null and then not Is_Ghost (Defer_Res_158) then
            Transform_Res_92.Last_Attempted_Child := -1;
         end if;


end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Anonymous_Type_Transform_Parse_0_Memo,
      Row_Pos_105 /= No_Token_Index,
      Transform_Res_92,
      Pos,
      Row_Pos_105);


   Parser.Current_Pos := Row_Pos_105;

   return Transform_Res_92;
end Anonymous_Type_Transform_Parse_0;

   


function Type_Expr_Or_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Type_Expr
is
   use Bare_Type_Expr_Memos;

      Defer_Pos_156 :
            Token_Index
               := No_Token_Index;
      Defer_Res_156 :
            Bare_Anonymous_Type
               := No_Bare_Ada_Node;
      Defer_Pos_157 :
            Token_Index
               := No_Token_Index;
      Defer_Res_157 :
            Bare_Subtype_Indication
               := No_Bare_Ada_Node;
      Or_Pos_40 :
            Token_Index
               := No_Token_Index;
      Or_Res_40 :
            Bare_Type_Expr
               := No_Bare_Ada_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Type_Expr_Or_Parse_0_Memo, Pos);

begin

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Or_Res_40 := M.Instance;
      return Or_Res_40;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Or_Res_40;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start or_code

Or_Pos_40 := No_Token_Index;
Or_Res_40 := No_Bare_Ada_Node;
    
Defer_Res_156 :=
   Anonymous_Type_Transform_Parse_0 (Parser, Pos);
Defer_Pos_156 := Parser.Current_Pos;

    if Defer_Pos_156 /= No_Token_Index then
        Or_Pos_40 := Defer_Pos_156;
        Or_Res_40 := Defer_Res_156;
        goto Exit_Or_39;
    end if;
    
Defer_Res_157 :=
   Subtype_Indication_Transform_Parse_0 (Parser, Pos);
Defer_Pos_157 := Parser.Current_Pos;

    if Defer_Pos_157 /= No_Token_Index then
        Or_Pos_40 := Defer_Pos_157;
        Or_Res_40 := Defer_Res_157;
        goto Exit_Or_39;
    end if;
<<Exit_Or_39>>

--  End or_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Type_Expr_Or_Parse_0_Memo,
      Or_Pos_40 /= No_Token_Index,
      Or_Res_40,
      Pos,
      Or_Pos_40);


   Parser.Current_Pos := Or_Pos_40;

   return Or_Res_40;
end Type_Expr_Or_Parse_0;

   


function Renaming_Clause_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Renaming_Clause
is
   use Bare_Renaming_Clause_Memos;

      Row_Pos_130 :
            Token_Index
               := No_Token_Index;
      Token_Pos_167 :
            Token_Index
               := No_Token_Index;
      Token_Res_167 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_189 :
            Token_Index
               := No_Token_Index;
      Defer_Res_189 :
            Bare_Name
               := No_Bare_Ada_Node;
      Transform_Res_112 :
            Bare_Renaming_Clause
               := No_Bare_Ada_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Renaming_Clause_Transform_Parse_0_Memo, Pos);

begin

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res_112 := M.Instance;
      return Transform_Res_112;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res_112;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code


--  Start row_code

Row_Pos_130 := Pos;



--  Start tok_code

Token_Res_167 := Row_Pos_130;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_167));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Renames)
   then
       Token_Pos_167 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_130 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_130,
             Expected_Token_Id => Ada_Renames,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_167 := Row_Pos_130 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_167 /= No_Token_Index then

   Row_Pos_130 := Token_Pos_167;

else
   Row_Pos_130 := No_Token_Index;
   goto Exit_Row_119_0;

end if;


Defer_Res_189 :=
   Name_Or_Parse_1 (Parser, Row_Pos_130);
Defer_Pos_189 := Parser.Current_Pos;



if Defer_Pos_189 /= No_Token_Index then

   Row_Pos_130 := Defer_Pos_189;

else
   Row_Pos_130 := No_Token_Index;
   goto Exit_Row_119_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_119_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_130 /= No_Token_Index then

   Transform_Res_112 := Allocate_Renaming_Clause (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_112,
      Kind => Ada_Renaming_Clause,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_130 = Pos
                            then No_Token_Index
                            else Row_Pos_130 - 1));

      Initialize_Fields_For_Renaming_Clause
        (Self => Transform_Res_112, Renaming_Clause_F_Renamed_Object => Defer_Res_189);

         if Defer_Res_189 /= null and then Is_Incomplete (Defer_Res_189) then
            Transform_Res_112.Last_Attempted_Child := 0;
         elsif Defer_Res_189 /= null and then not Is_Ghost (Defer_Res_189) then
            Transform_Res_112.Last_Attempted_Child := -1;
         end if;


end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Renaming_Clause_Transform_Parse_0_Memo,
      Row_Pos_130 /= No_Token_Index,
      Transform_Res_112,
      Pos,
      Row_Pos_130);


   Parser.Current_Pos := Row_Pos_130;

   return Transform_Res_112;
end Renaming_Clause_Transform_Parse_0;

   


function Sub_Object_Decl_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Object_Decl
is
   use Bare_Object_Decl_Memos;

      Nobt_12 :
            Boolean
               := False;
      Row_Pos_99 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_149 :
            Token_Index
               := No_Token_Index;
      Defer_Res_149 :
            Bare_Defining_Name_List
               := No_Bare_Ada_Node;
      Token_Pos_121 :
            Token_Index
               := No_Token_Index;
      Token_Res_121 :
            Token_Index
               := No_Token_Index;
      Token_Pos_122 :
            Token_Index
               := No_Token_Index;
      Token_Res_122 :
            Token_Index
               := No_Token_Index;
      Opt_Res_3 :
            Bare_Aliased_Node
               := No_Bare_Ada_Node;
      Token_Pos_123 :
            Token_Index
               := No_Token_Index;
      Token_Res_123 :
            Token_Index
               := No_Token_Index;
      Opt_Res_4 :
            Bare_Constant_Node
               := No_Bare_Ada_Node;
      Defer_Pos_150 :
            Token_Index
               := No_Token_Index;
      Defer_Res_150 :
            Bare_Mode
               := No_Bare_Ada_Node;
      Defer_Pos_151 :
            Token_Index
               := No_Token_Index;
      Defer_Res_151 :
            Bare_Type_Expr
               := No_Bare_Ada_Node;
      Row_Pos_100 :
            Token_Index
               := No_Token_Index;
      Token_Pos_124 :
            Token_Index
               := No_Token_Index;
      Token_Res_124 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_152 :
            Token_Index
               := No_Token_Index;
      Defer_Res_152 :
            Bare_Expr
               := No_Bare_Ada_Node;
      Defer_Pos_153 :
            Token_Index
               := No_Token_Index;
      Defer_Res_153 :
            Bare_Renaming_Clause
               := No_Bare_Ada_Node;
      Defer_Pos_154 :
            Token_Index
               := No_Token_Index;
      Defer_Res_154 :
            Bare_Aspect_Spec
               := No_Bare_Ada_Node;
      Token_Pos_125 :
            Token_Index
               := No_Token_Index;
      Token_Res_125 :
            Token_Index
               := No_Token_Index;
      Row_Progress_12 :
            Integer
               := 0;
      Transform_Res_87 :
            Bare_Object_Decl
               := No_Bare_Ada_Node;
      Transform_Has_Failed_12 :
            Boolean
               := False;


   M : Memo_Entry := Get (Parser.Private_Part.Sub_Object_Decl_Transform_Parse_0_Memo, Pos);

begin

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res_87 := M.Instance;
      return Transform_Res_87;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res_87;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code


--  Start row_code

Row_Pos_99 := Pos;



Defer_Res_149 :=
   Defining_Id_List_List_Parse_0 (Parser, Row_Pos_99);
Defer_Pos_149 := Parser.Current_Pos;


Row_Progress_12 := 1;

if Defer_Pos_149 /= No_Token_Index then

   Row_Pos_99 := Defer_Pos_149;

else
   Row_Pos_99 := No_Token_Index;
   goto Exit_Row_88_0;

end if;


--  Start tok_code

Token_Res_121 := Row_Pos_99;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_121));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Colon)
   then
       Token_Pos_121 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_99 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_99,
             Expected_Token_Id => Ada_Colon,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_121 := Row_Pos_99 + 1;
   end if;
end;

--  End tok_code


Row_Progress_12 := 2;

if Token_Pos_121 /= No_Token_Index then

   Row_Pos_99 := Token_Pos_121;

else
   Row_Pos_99 := No_Token_Index;
   goto Exit_Row_88_0;

end if;


--  Start opt_code




--  Start tok_code

Token_Res_122 := Row_Pos_99;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_122));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Identifier)
      or else T.Symbol /= Precomputed_Symbol
        (Precomputed_Symbol_Table (Parser.TDH.Symbols),
         Precomputed_Symbol_Aliased)
   then
       Token_Pos_122 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_99 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_99,
             Expected_Token_Id => Ada_Identifier,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_122 := Row_Pos_99 + 1;
   end if;
end;

--  End tok_code


if Token_Pos_122 = No_Token_Index then

         Opt_Res_3 := Allocate_Aliased_Absent (Parser.Mem_Pool);
         Initialize
           (Self              => Opt_Res_3,
            Kind              => Ada_Aliased_Absent,
            Unit              => Parser.Unit,
            Token_Start_Index => Row_Pos_99,
            Token_End_Index   => No_Token_Index);


    Token_Pos_122 := Row_Pos_99;

else

      Opt_Res_3 := Allocate_Aliased_Present (Parser.Mem_Pool);
      Initialize
        (Self              => Opt_Res_3,
         Kind              => Ada_Aliased_Present,
         Unit              => Parser.Unit,
         Token_Start_Index => Row_Pos_99,
         Token_End_Index   => Token_Pos_122 - 1);

end if;

--  End opt_code


Row_Progress_12 := 3;

if Token_Pos_122 /= No_Token_Index then

   Row_Pos_99 := Token_Pos_122;

else
   Row_Pos_99 := No_Token_Index;
   goto Exit_Row_88_0;

end if;


--  Start opt_code




--  Start tok_code

Token_Res_123 := Row_Pos_99;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_123));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Constant)
   then
       Token_Pos_123 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_99 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_99,
             Expected_Token_Id => Ada_Constant,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_123 := Row_Pos_99 + 1;
   end if;
end;

--  End tok_code


if Token_Pos_123 = No_Token_Index then

         Opt_Res_4 := Allocate_Constant_Absent (Parser.Mem_Pool);
         Initialize
           (Self              => Opt_Res_4,
            Kind              => Ada_Constant_Absent,
            Unit              => Parser.Unit,
            Token_Start_Index => Row_Pos_99,
            Token_End_Index   => No_Token_Index);


    Token_Pos_123 := Row_Pos_99;

else

      Opt_Res_4 := Allocate_Constant_Present (Parser.Mem_Pool);
      Initialize
        (Self              => Opt_Res_4,
         Kind              => Ada_Constant_Present,
         Unit              => Parser.Unit,
         Token_Start_Index => Row_Pos_99,
         Token_End_Index   => Token_Pos_123 - 1);

end if;

--  End opt_code


Row_Progress_12 := 4;

if Token_Pos_123 /= No_Token_Index then

   Row_Pos_99 := Token_Pos_123;

else
   Row_Pos_99 := No_Token_Index;
   goto Exit_Row_88_0;

end if;


--  Start opt_code




Defer_Res_150 :=
   Mode_Or_Parse_0 (Parser, Row_Pos_99);
Defer_Pos_150 := Parser.Current_Pos;


if Defer_Pos_150 = No_Token_Index then

        Defer_Res_150 := No_Bare_Ada_Node;


    Defer_Pos_150 := Row_Pos_99;


end if;

--  End opt_code


Row_Progress_12 := 5;

if Defer_Pos_150 /= No_Token_Index then

   Row_Pos_99 := Defer_Pos_150;

else
   Row_Pos_99 := No_Token_Index;
   goto Exit_Row_88_0;

end if;


Defer_Res_151 :=
   Type_Expr_Or_Parse_0 (Parser, Row_Pos_99);
Defer_Pos_151 := Parser.Current_Pos;


Row_Progress_12 := 6;

if Defer_Pos_151 /= No_Token_Index then

   Row_Pos_99 := Defer_Pos_151;

else
   Row_Pos_99 := No_Token_Index;
   goto Exit_Row_88_0;

end if;

Nobt_12 := True;

Row_Progress_12 := 7;

if Row_Pos_99 /= No_Token_Index then

   Row_Pos_99 := Row_Pos_99;

else
   Row_Pos_99 := No_Token_Index;
   goto Exit_Row_88_0;

end if;


--  Start opt_code




--  Start row_code

Row_Pos_100 := Row_Pos_99;



--  Start tok_code

Token_Res_124 := Row_Pos_100;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_124));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Assign)
   then
       Token_Pos_124 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_100 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_100,
             Expected_Token_Id => Ada_Assign,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_124 := Row_Pos_100 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_124 /= No_Token_Index then

   Row_Pos_100 := Token_Pos_124;

else
   Row_Pos_100 := No_Token_Index;
   goto Exit_Row_118_0;

end if;


Defer_Res_152 :=
   Expr_Or_Parse_0 (Parser, Row_Pos_100);
Defer_Pos_152 := Parser.Current_Pos;



if Defer_Pos_152 /= No_Token_Index then

   Row_Pos_100 := Defer_Pos_152;

else
   Row_Pos_100 := No_Token_Index;
   goto Exit_Row_118_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_118_0>>
pragma Warnings (On, "referenced");

--  End row_code


if Row_Pos_100 = No_Token_Index then

        Defer_Res_152 := No_Bare_Ada_Node;


    Row_Pos_100 := Row_Pos_99;


end if;

--  End opt_code


Row_Progress_12 := 8;

if Row_Pos_100 /= No_Token_Index then

   Row_Pos_99 := Row_Pos_100;

else
   Row_Pos_99 := No_Token_Index;
   goto Exit_Row_88_0;

end if;


--  Start opt_code




Defer_Res_153 :=
   Renaming_Clause_Transform_Parse_0 (Parser, Row_Pos_99);
Defer_Pos_153 := Parser.Current_Pos;


if Defer_Pos_153 = No_Token_Index then

        Defer_Res_153 := No_Bare_Ada_Node;


    Defer_Pos_153 := Row_Pos_99;


end if;

--  End opt_code


Row_Progress_12 := 9;

if Defer_Pos_153 /= No_Token_Index then

   Row_Pos_99 := Defer_Pos_153;

else
   Row_Pos_99 := No_Token_Index;
   goto Exit_Row_88_0;

end if;


Defer_Res_154 :=
   Aspect_Spec_Opt_Parse_0 (Parser, Row_Pos_99);
Defer_Pos_154 := Parser.Current_Pos;


Row_Progress_12 := 10;

if Defer_Pos_154 /= No_Token_Index then

   Row_Pos_99 := Defer_Pos_154;

else
   Row_Pos_99 := No_Token_Index;
   goto Exit_Row_88_0;

end if;


--  Start tok_code

Token_Res_125 := Row_Pos_99;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_125));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Semicolon)
   then
       Token_Pos_125 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_99 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_99,
             Expected_Token_Id => Ada_Semicolon,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_125 := Row_Pos_99 + 1;
   end if;
end;

--  End tok_code


Row_Progress_12 := 11;

if Token_Pos_125 /= No_Token_Index then

   Row_Pos_99 := Token_Pos_125;

else
   Row_Pos_99 := No_Token_Index;
   goto Exit_Row_88_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_88_0>>
pragma Warnings (On, "referenced");

--  End row_code


if Row_Pos_99 = No_Token_Index and then Nobt_12 then
   Row_Pos_99 := Parser.Last_Fail.Pos;
   Transform_Has_Failed_12 := True;
end if;

if Row_Pos_99 /= No_Token_Index then

   Transform_Res_87 := Allocate_Object_Decl (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_87,
      Kind => Ada_Object_Decl,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_99 = Pos
                            then No_Token_Index
                            else Row_Pos_99 - 1));

      Initialize_Fields_For_Object_Decl
        (Self => Transform_Res_87, Object_Decl_F_Ids => Defer_Res_149, Object_Decl_F_Has_Aliased => Opt_Res_3, Object_Decl_F_Has_Constant => Opt_Res_4, Object_Decl_F_Mode => Defer_Res_150, Object_Decl_F_Type_Expr => Defer_Res_151, Object_Decl_F_Default_Expr => Defer_Res_152, Object_Decl_F_Renaming_Clause => Defer_Res_153, Object_Decl_F_Aspects => Defer_Res_154);

         if Defer_Res_149 /= null and then Is_Incomplete (Defer_Res_149) then
            Transform_Res_87.Last_Attempted_Child := 0;
         elsif Defer_Res_149 /= null and then not Is_Ghost (Defer_Res_149) then
            Transform_Res_87.Last_Attempted_Child := -1;
         end if;
         if Opt_Res_3 /= null and then Is_Incomplete (Opt_Res_3) then
            Transform_Res_87.Last_Attempted_Child := 0;
         elsif Opt_Res_3 /= null and then not Is_Ghost (Opt_Res_3) then
            Transform_Res_87.Last_Attempted_Child := -1;
         end if;
         if Opt_Res_4 /= null and then Is_Incomplete (Opt_Res_4) then
            Transform_Res_87.Last_Attempted_Child := 0;
         elsif Opt_Res_4 /= null and then not Is_Ghost (Opt_Res_4) then
            Transform_Res_87.Last_Attempted_Child := -1;
         end if;
         if Defer_Res_150 /= null and then Is_Incomplete (Defer_Res_150) then
            Transform_Res_87.Last_Attempted_Child := 0;
         elsif Defer_Res_150 /= null and then not Is_Ghost (Defer_Res_150) then
            Transform_Res_87.Last_Attempted_Child := -1;
         end if;
         if Defer_Res_151 /= null and then Is_Incomplete (Defer_Res_151) then
            Transform_Res_87.Last_Attempted_Child := 0;
         elsif Defer_Res_151 /= null and then not Is_Ghost (Defer_Res_151) then
            Transform_Res_87.Last_Attempted_Child := -1;
         end if;
         if Defer_Res_152 /= null and then Is_Incomplete (Defer_Res_152) then
            Transform_Res_87.Last_Attempted_Child := 0;
         elsif Defer_Res_152 /= null and then not Is_Ghost (Defer_Res_152) then
            Transform_Res_87.Last_Attempted_Child := -1;
         end if;
         if Defer_Res_153 /= null and then Is_Incomplete (Defer_Res_153) then
            Transform_Res_87.Last_Attempted_Child := 0;
         elsif Defer_Res_153 /= null and then not Is_Ghost (Defer_Res_153) then
            Transform_Res_87.Last_Attempted_Child := -1;
         end if;
         if Defer_Res_154 /= null and then Is_Incomplete (Defer_Res_154) then
            Transform_Res_87.Last_Attempted_Child := 0;
         elsif Defer_Res_154 /= null and then not Is_Ghost (Defer_Res_154) then
            Transform_Res_87.Last_Attempted_Child := -1;
         end if;

   if Transform_Has_Failed_12 then
      Transform_Res_87.Last_Attempted_Child :=
         Row_Progress_12;

      Append (Parser.Diagnostics,
              Sloc_Range (Parser.TDH.all,
                          Get_Token (Parser.TDH.all, Pos)),
              To_Text ("Cannot parse <sub_object_decl>"));

      Add_Last_Fail_Diagnostic (Parser);
   end if;

end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Sub_Object_Decl_Transform_Parse_0_Memo,
      Row_Pos_99 /= No_Token_Index,
      Transform_Res_87,
      Pos,
      Row_Pos_99);


   Parser.Current_Pos := Row_Pos_99;

   return Transform_Res_87;
end Sub_Object_Decl_Transform_Parse_0;

   


function Parent_List_List_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Parent_List
is
   use Bare_Parent_List_Memos;

      Lst_Cpos_20 :
            Token_Index
               := No_Token_Index;
      Tmp_List_20 :
            Free_Parse_List;
      Defer_Pos_197 :
            Token_Index
               := No_Token_Index;
      Defer_Res_197 :
            Bare_Name
               := No_Bare_Ada_Node;
      Token_Pos_175 :
            Token_Index
               := No_Token_Index;
      Token_Res_175 :
            Token_Index
               := No_Token_Index;
      List_Pos_20 :
            Token_Index
               := No_Token_Index;
      List_Res_20 :
            Bare_Parent_List
               := No_Bare_Ada_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Parent_List_List_Parse_0_Memo, Pos);

begin

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      List_Res_20 := M.Instance;
      return List_Res_20;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return List_Res_20;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start list_code

    List_Pos_20 := No_Token_Index;



Lst_Cpos_20 := Pos;
Tmp_List_20 := Get_Parse_List (Parser);

loop
   
Defer_Res_197 :=
   Static_Name_Or_Parse_0 (Parser, Lst_Cpos_20);
Defer_Pos_197 := Parser.Current_Pos;


   exit when Defer_Pos_197 = No_Token_Index;

   List_Pos_20 := Defer_Pos_197;
   Lst_Cpos_20 := List_Pos_20;

   Tmp_List_20.Nodes.Append (Defer_Res_197);

      
--  Start tok_code

Token_Res_175 := Lst_Cpos_20;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_175));
begin
   if
      T.Kind /= From_Token_Kind (Ada_And)
   then
       Token_Pos_175 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Lst_Cpos_20 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Lst_Cpos_20,
             Expected_Token_Id => Ada_And,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_175 := Lst_Cpos_20 + 1;
   end if;
end;

--  End tok_code

      if Token_Pos_175 /= No_Token_Index then
          Lst_Cpos_20 := Token_Pos_175;
      else
         exit;
      end if;

end loop;

declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List_20.Nodes.Length;
begin
   List_Res_20 :=
      Allocate_Parent_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Pos;
      Token_End := (if Lst_Cpos_20 = Pos
                    then Pos
                    else Lst_Cpos_20 - 1);

   else
      Token_Start := Token_Index'Max (Pos, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res_20,
      Kind              => Ada_Parent_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res_20,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_Ada_Node_Vectors.Vector renames
         Tmp_List_20.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res_20.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List_20);

--  End list_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Parent_List_List_Parse_0_Memo,
      List_Pos_20 /= No_Token_Index,
      List_Res_20,
      Pos,
      List_Pos_20);


   Parser.Current_Pos := List_Pos_20;

   return List_Res_20;
end Parent_List_List_Parse_0;

   


function Overriding_Indicator_Or_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Overriding_Node
is
   use Bare_Overriding_Node_Memos;

      Row_Pos_143 :
            Token_Index
               := No_Token_Index;
      Token_Pos_180 :
            Token_Index
               := No_Token_Index;
      Token_Res_180 :
            Token_Index
               := No_Token_Index;
      Transform_Res_121 :
            Bare_Overriding_Overriding
               := No_Bare_Ada_Node;
      Row_Pos_144 :
            Token_Index
               := No_Token_Index;
      Token_Pos_181 :
            Token_Index
               := No_Token_Index;
      Token_Res_181 :
            Token_Index
               := No_Token_Index;
      Token_Pos_182 :
            Token_Index
               := No_Token_Index;
      Token_Res_182 :
            Token_Index
               := No_Token_Index;
      Transform_Res_122 :
            Bare_Overriding_Not_Overriding
               := No_Bare_Ada_Node;
      Row_Pos_145 :
            Token_Index
               := No_Token_Index;
      Transform_Res_123 :
            Bare_Overriding_Unspecified
               := No_Bare_Ada_Node;
      Or_Pos_50 :
            Token_Index
               := No_Token_Index;
      Or_Res_50 :
            Bare_Overriding_Node
               := No_Bare_Ada_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Overriding_Indicator_Or_Parse_0_Memo, Pos);

begin

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Or_Res_50 := M.Instance;
      return Or_Res_50;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Or_Res_50;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start or_code

Or_Pos_50 := No_Token_Index;
Or_Res_50 := No_Bare_Ada_Node;
    
--  Start transform_code


--  Start row_code

Row_Pos_143 := Pos;



--  Start tok_code

Token_Res_180 := Row_Pos_143;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_180));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Identifier)
      or else T.Symbol /= Precomputed_Symbol
        (Precomputed_Symbol_Table (Parser.TDH.Symbols),
         Precomputed_Symbol_Overriding)
   then
       Token_Pos_180 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_143 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_143,
             Expected_Token_Id => Ada_Identifier,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_180 := Row_Pos_143 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_180 /= No_Token_Index then

   Row_Pos_143 := Token_Pos_180;

else
   Row_Pos_143 := No_Token_Index;
   goto Exit_Row_126_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_126_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_143 /= No_Token_Index then

   Transform_Res_121 := Allocate_Overriding_Overriding (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_121,
      Kind => Ada_Overriding_Overriding,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_143 = Pos
                            then No_Token_Index
                            else Row_Pos_143 - 1));




end if;

--  End transform_code

    if Row_Pos_143 /= No_Token_Index then
        Or_Pos_50 := Row_Pos_143;
        Or_Res_50 := Transform_Res_121;
        goto Exit_Or_48;
    end if;
    
--  Start transform_code


--  Start row_code

Row_Pos_144 := Pos;



--  Start tok_code

Token_Res_181 := Row_Pos_144;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_181));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Not)
   then
       Token_Pos_181 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_144 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_144,
             Expected_Token_Id => Ada_Not,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_181 := Row_Pos_144 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_181 /= No_Token_Index then

   Row_Pos_144 := Token_Pos_181;

else
   Row_Pos_144 := No_Token_Index;
   goto Exit_Row_127_0;

end if;


--  Start tok_code

Token_Res_182 := Row_Pos_144;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_182));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Identifier)
      or else T.Symbol /= Precomputed_Symbol
        (Precomputed_Symbol_Table (Parser.TDH.Symbols),
         Precomputed_Symbol_Overriding)
   then
       Token_Pos_182 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_144 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_144,
             Expected_Token_Id => Ada_Identifier,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_182 := Row_Pos_144 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_182 /= No_Token_Index then

   Row_Pos_144 := Token_Pos_182;

else
   Row_Pos_144 := No_Token_Index;
   goto Exit_Row_127_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_127_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_144 /= No_Token_Index then

   Transform_Res_122 := Allocate_Overriding_Not_Overriding (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_122,
      Kind => Ada_Overriding_Not_Overriding,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_144 = Pos
                            then No_Token_Index
                            else Row_Pos_144 - 1));




end if;

--  End transform_code

    if Row_Pos_144 /= No_Token_Index then
        Or_Pos_50 := Row_Pos_144;
        Or_Res_50 := Transform_Res_122;
        goto Exit_Or_48;
    end if;
    
--  Start transform_code


--  Start row_code

Row_Pos_145 := Pos;


pragma Warnings (Off, "referenced");
<<Exit_Row_128_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_145 /= No_Token_Index then

   Transform_Res_123 := Allocate_Overriding_Unspecified (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_123,
      Kind => Ada_Overriding_Unspecified,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_145 = Pos
                            then No_Token_Index
                            else Row_Pos_145 - 1));




end if;

--  End transform_code

    if Row_Pos_145 /= No_Token_Index then
        Or_Pos_50 := Row_Pos_145;
        Or_Res_50 := Transform_Res_123;
        goto Exit_Or_48;
    end if;
<<Exit_Or_48>>

--  End or_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Overriding_Indicator_Or_Parse_0_Memo,
      Or_Pos_50 /= No_Token_Index,
      Or_Res_50,
      Pos,
      Or_Pos_50);


   Parser.Current_Pos := Or_Pos_50;

   return Or_Res_50;
end Overriding_Indicator_Or_Parse_0;

   


function Constrained_Subtype_Indication_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Constrained_Subtype_Indication
is
   use Bare_Constrained_Subtype_Indication_Memos;

      Row_Pos_146 :
            Token_Index
               := No_Token_Index;
      Row_Pos_147 :
            Token_Index
               := No_Token_Index;
      Token_Pos_183 :
            Token_Index
               := No_Token_Index;
      Token_Res_183 :
            Token_Index
               := No_Token_Index;
      Token_Pos_184 :
            Token_Index
               := No_Token_Index;
      Token_Res_184 :
            Token_Index
               := No_Token_Index;
      Opt_Res_13 :
            Bare_Not_Null
               := No_Bare_Ada_Node;
      Defer_Pos_208 :
            Token_Index
               := No_Token_Index;
      Defer_Res_208 :
            Bare_Name
               := No_Bare_Ada_Node;
      Defer_Pos_209 :
            Token_Index
               := No_Token_Index;
      Defer_Res_209 :
            Bare_Constraint
               := No_Bare_Ada_Node;
      Transform_Res_124 :
            Bare_Constrained_Subtype_Indication
               := No_Bare_Ada_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Constrained_Subtype_Indication_Transform_Parse_0_Memo, Pos);

begin

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res_124 := M.Instance;
      return Transform_Res_124;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res_124;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code


--  Start row_code

Row_Pos_146 := Pos;



--  Start opt_code




--  Start row_code

Row_Pos_147 := Row_Pos_146;



--  Start tok_code

Token_Res_183 := Row_Pos_147;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_183));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Not)
   then
       Token_Pos_183 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_147 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_147,
             Expected_Token_Id => Ada_Not,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_183 := Row_Pos_147 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_183 /= No_Token_Index then

   Row_Pos_147 := Token_Pos_183;

else
   Row_Pos_147 := No_Token_Index;
   goto Exit_Row_132_0;

end if;


--  Start tok_code

Token_Res_184 := Row_Pos_147;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_184));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Null)
   then
       Token_Pos_184 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_147 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_147,
             Expected_Token_Id => Ada_Null,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_184 := Row_Pos_147 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_184 /= No_Token_Index then

   Row_Pos_147 := Token_Pos_184;

else
   Row_Pos_147 := No_Token_Index;
   goto Exit_Row_132_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_132_0>>
pragma Warnings (On, "referenced");

--  End row_code


if Row_Pos_147 = No_Token_Index then

         Opt_Res_13 := Allocate_Not_Null_Absent (Parser.Mem_Pool);
         Initialize
           (Self              => Opt_Res_13,
            Kind              => Ada_Not_Null_Absent,
            Unit              => Parser.Unit,
            Token_Start_Index => Row_Pos_146,
            Token_End_Index   => No_Token_Index);


    Row_Pos_147 := Row_Pos_146;

else

      Opt_Res_13 := Allocate_Not_Null_Present (Parser.Mem_Pool);
      Initialize
        (Self              => Opt_Res_13,
         Kind              => Ada_Not_Null_Present,
         Unit              => Parser.Unit,
         Token_Start_Index => Row_Pos_146,
         Token_End_Index   => Row_Pos_147 - 1);

end if;

--  End opt_code



if Row_Pos_147 /= No_Token_Index then

   Row_Pos_146 := Row_Pos_147;

else
   Row_Pos_146 := No_Token_Index;
   goto Exit_Row_131_0;

end if;


Defer_Res_208 :=
   Subtype_Name_Or_Parse_0 (Parser, Row_Pos_146);
Defer_Pos_208 := Parser.Current_Pos;



if Defer_Pos_208 /= No_Token_Index then

   Row_Pos_146 := Defer_Pos_208;

else
   Row_Pos_146 := No_Token_Index;
   goto Exit_Row_131_0;

end if;


Defer_Res_209 :=
   Constraint_Or_Parse_0 (Parser, Row_Pos_146);
Defer_Pos_209 := Parser.Current_Pos;



if Defer_Pos_209 /= No_Token_Index then

   Row_Pos_146 := Defer_Pos_209;

else
   Row_Pos_146 := No_Token_Index;
   goto Exit_Row_131_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_131_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_146 /= No_Token_Index then

   Transform_Res_124 := Allocate_Constrained_Subtype_Indication (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_124,
      Kind => Ada_Constrained_Subtype_Indication,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_146 = Pos
                            then No_Token_Index
                            else Row_Pos_146 - 1));

      Initialize_Fields_For_Constrained_Subtype_Indication
        (Self => Transform_Res_124, Subtype_Indication_F_Has_Not_Null => Opt_Res_13, Subtype_Indication_F_Name => Defer_Res_208, Subtype_Indication_F_Constraint => Defer_Res_209);

         if Opt_Res_13 /= null and then Is_Incomplete (Opt_Res_13) then
            Transform_Res_124.Last_Attempted_Child := 0;
         elsif Opt_Res_13 /= null and then not Is_Ghost (Opt_Res_13) then
            Transform_Res_124.Last_Attempted_Child := -1;
         end if;
         if Defer_Res_208 /= null and then Is_Incomplete (Defer_Res_208) then
            Transform_Res_124.Last_Attempted_Child := 0;
         elsif Defer_Res_208 /= null and then not Is_Ghost (Defer_Res_208) then
            Transform_Res_124.Last_Attempted_Child := -1;
         end if;
         if Defer_Res_209 /= null and then Is_Incomplete (Defer_Res_209) then
            Transform_Res_124.Last_Attempted_Child := 0;
         elsif Defer_Res_209 /= null and then not Is_Ghost (Defer_Res_209) then
            Transform_Res_124.Last_Attempted_Child := -1;
         end if;


end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Constrained_Subtype_Indication_Transform_Parse_0_Memo,
      Row_Pos_146 /= No_Token_Index,
      Transform_Res_124,
      Pos,
      Row_Pos_146);


   Parser.Current_Pos := Row_Pos_146;

   return Transform_Res_124;
end Constrained_Subtype_Indication_Transform_Parse_0;

   


function Entry_Decl_Transform_Parse_1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Entry_Decl
is
   use Bare_Entry_Decl_Memos;

      Row_Pos_140 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_201 :
            Token_Index
               := No_Token_Index;
      Defer_Res_201 :
            Bare_Overriding_Node
               := No_Bare_Ada_Node;
      Row_Pos_141 :
            Token_Index
               := No_Token_Index;
      Token_Pos_176 :
            Token_Index
               := No_Token_Index;
      Token_Res_176 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_202 :
            Token_Index
               := No_Token_Index;
      Defer_Res_202 :
            Bare_Defining_Name
               := No_Bare_Ada_Node;
      Row_Pos_142 :
            Token_Index
               := No_Token_Index;
      Token_Pos_177 :
            Token_Index
               := No_Token_Index;
      Token_Res_177 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_203 :
            Token_Index
               := No_Token_Index;
      Defer_Res_203 :
            Bare_Constrained_Subtype_Indication
               := No_Bare_Ada_Node;
      Defer_Pos_204 :
            Token_Index
               := No_Token_Index;
      Defer_Res_204 :
            Bare_Expr
               := No_Bare_Ada_Node;
      Defer_Pos_205 :
            Token_Index
               := No_Token_Index;
      Defer_Res_205 :
            Bare_Subtype_Indication
               := No_Bare_Ada_Node;
      Or_Pos_49 :
            Token_Index
               := No_Token_Index;
      Or_Res_49 :
            Bare_Ada_Node
               := No_Bare_Ada_Node;
      Token_Pos_178 :
            Token_Index
               := No_Token_Index;
      Token_Res_178 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_206 :
            Token_Index
               := No_Token_Index;
      Defer_Res_206 :
            Bare_Params
               := No_Bare_Ada_Node;
      Transform_Res_119 :
            Bare_Entry_Spec
               := No_Bare_Ada_Node;
      Defer_Pos_207 :
            Token_Index
               := No_Token_Index;
      Defer_Res_207 :
            Bare_Aspect_Spec
               := No_Bare_Ada_Node;
      Token_Pos_179 :
            Token_Index
               := No_Token_Index;
      Token_Res_179 :
            Token_Index
               := No_Token_Index;
      Transform_Res_120 :
            Bare_Entry_Decl
               := No_Bare_Ada_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Entry_Decl_Transform_Parse_1_Memo, Pos);

begin

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res_120 := M.Instance;
      return Transform_Res_120;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res_120;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code


--  Start row_code

Row_Pos_140 := Pos;



Defer_Res_201 :=
   Overriding_Indicator_Or_Parse_0 (Parser, Row_Pos_140);
Defer_Pos_201 := Parser.Current_Pos;



if Defer_Pos_201 /= No_Token_Index then

   Row_Pos_140 := Defer_Pos_201;

else
   Row_Pos_140 := No_Token_Index;
   goto Exit_Row_125_0;

end if;


--  Start transform_code


--  Start row_code

Row_Pos_141 := Row_Pos_140;



--  Start tok_code

Token_Res_176 := Row_Pos_141;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_176));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Entry)
   then
       Token_Pos_176 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_141 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_141,
             Expected_Token_Id => Ada_Entry,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_176 := Row_Pos_141 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_176 /= No_Token_Index then

   Row_Pos_141 := Token_Pos_176;

else
   Row_Pos_141 := No_Token_Index;
   goto Exit_Row_129_0;

end if;


Defer_Res_202 :=
   Defining_Id_Transform_Parse_0 (Parser, Row_Pos_141);
Defer_Pos_202 := Parser.Current_Pos;



if Defer_Pos_202 /= No_Token_Index then

   Row_Pos_141 := Defer_Pos_202;

else
   Row_Pos_141 := No_Token_Index;
   goto Exit_Row_129_0;

end if;


--  Start opt_code




--  Start row_code

Row_Pos_142 := Row_Pos_141;



--  Start tok_code

Token_Res_177 := Row_Pos_142;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_177));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Par_Open)
   then
       Token_Pos_177 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_142 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_142,
             Expected_Token_Id => Ada_Par_Open,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_177 := Row_Pos_142 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_177 /= No_Token_Index then

   Row_Pos_142 := Token_Pos_177;

else
   Row_Pos_142 := No_Token_Index;
   goto Exit_Row_130_0;

end if;


--  Start or_code

Or_Pos_49 := No_Token_Index;
Or_Res_49 := No_Bare_Ada_Node;
    
Defer_Res_203 :=
   Constrained_Subtype_Indication_Transform_Parse_0 (Parser, Row_Pos_142);
Defer_Pos_203 := Parser.Current_Pos;

    if Defer_Pos_203 /= No_Token_Index then
        Or_Pos_49 := Defer_Pos_203;
        Or_Res_49 := Defer_Res_203;
        goto Exit_Or_49;
    end if;
    
Defer_Res_204 :=
   Discrete_Range_Or_Parse_0 (Parser, Row_Pos_142);
Defer_Pos_204 := Parser.Current_Pos;

    if Defer_Pos_204 /= No_Token_Index then
        Or_Pos_49 := Defer_Pos_204;
        Or_Res_49 := Defer_Res_204;
        goto Exit_Or_49;
    end if;
    
Defer_Res_205 :=
   Subtype_Indication_Transform_Parse_0 (Parser, Row_Pos_142);
Defer_Pos_205 := Parser.Current_Pos;

    if Defer_Pos_205 /= No_Token_Index then
        Or_Pos_49 := Defer_Pos_205;
        Or_Res_49 := Defer_Res_205;
        goto Exit_Or_49;
    end if;
<<Exit_Or_49>>

--  End or_code



if Or_Pos_49 /= No_Token_Index then

   Row_Pos_142 := Or_Pos_49;

else
   Row_Pos_142 := No_Token_Index;
   goto Exit_Row_130_0;

end if;


--  Start tok_code

Token_Res_178 := Row_Pos_142;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_178));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Par_Close)
   then
       Token_Pos_178 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_142 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_142,
             Expected_Token_Id => Ada_Par_Close,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_178 := Row_Pos_142 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_178 /= No_Token_Index then

   Row_Pos_142 := Token_Pos_178;

else
   Row_Pos_142 := No_Token_Index;
   goto Exit_Row_130_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_130_0>>
pragma Warnings (On, "referenced");

--  End row_code


if Row_Pos_142 = No_Token_Index then

        Or_Res_49 := No_Bare_Ada_Node;


    Row_Pos_142 := Row_Pos_141;


end if;

--  End opt_code



if Row_Pos_142 /= No_Token_Index then

   Row_Pos_141 := Row_Pos_142;

else
   Row_Pos_141 := No_Token_Index;
   goto Exit_Row_129_0;

end if;


--  Start opt_code




Defer_Res_206 :=
   Param_Specs_Transform_Parse_0 (Parser, Row_Pos_141);
Defer_Pos_206 := Parser.Current_Pos;


if Defer_Pos_206 = No_Token_Index then

        Defer_Res_206 := No_Bare_Ada_Node;


    Defer_Pos_206 := Row_Pos_141;


end if;

--  End opt_code



if Defer_Pos_206 /= No_Token_Index then

   Row_Pos_141 := Defer_Pos_206;

else
   Row_Pos_141 := No_Token_Index;
   goto Exit_Row_129_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_129_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_141 /= No_Token_Index then

   Transform_Res_119 := Allocate_Entry_Spec (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_119,
      Kind => Ada_Entry_Spec,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos_140,
      Token_End_Index   => (if Row_Pos_141 = Row_Pos_140
                            then No_Token_Index
                            else Row_Pos_141 - 1));

      Initialize_Fields_For_Entry_Spec
        (Self => Transform_Res_119, Entry_Spec_F_Entry_Name => Defer_Res_202, Entry_Spec_F_Family_Type => Or_Res_49, Entry_Spec_F_Entry_Params => Defer_Res_206);

         if Defer_Res_202 /= null and then Is_Incomplete (Defer_Res_202) then
            Transform_Res_119.Last_Attempted_Child := 0;
         elsif Defer_Res_202 /= null and then not Is_Ghost (Defer_Res_202) then
            Transform_Res_119.Last_Attempted_Child := -1;
         end if;
         if Or_Res_49 /= null and then Is_Incomplete (Or_Res_49) then
            Transform_Res_119.Last_Attempted_Child := 0;
         elsif Or_Res_49 /= null and then not Is_Ghost (Or_Res_49) then
            Transform_Res_119.Last_Attempted_Child := -1;
         end if;
         if Defer_Res_206 /= null and then Is_Incomplete (Defer_Res_206) then
            Transform_Res_119.Last_Attempted_Child := 0;
         elsif Defer_Res_206 /= null and then not Is_Ghost (Defer_Res_206) then
            Transform_Res_119.Last_Attempted_Child := -1;
         end if;


end if;

--  End transform_code



if Row_Pos_141 /= No_Token_Index then

   Row_Pos_140 := Row_Pos_141;

else
   Row_Pos_140 := No_Token_Index;
   goto Exit_Row_125_0;

end if;


Defer_Res_207 :=
   Aspect_Spec_Opt_Parse_0 (Parser, Row_Pos_140);
Defer_Pos_207 := Parser.Current_Pos;



if Defer_Pos_207 /= No_Token_Index then

   Row_Pos_140 := Defer_Pos_207;

else
   Row_Pos_140 := No_Token_Index;
   goto Exit_Row_125_0;

end if;


--  Start opt_code




--  Start tok_code

Token_Res_179 := Row_Pos_140;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_179));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Semicolon)
   then
       Token_Pos_179 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_140 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_140,
             Expected_Token_Id => Ada_Semicolon,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_179 := Row_Pos_140 + 1;
   end if;
end;

--  End tok_code


if Token_Pos_179 = No_Token_Index then

        Token_Res_179 := No_Token_Index;

        Append (Parser.Diagnostics,
                Sloc_Range (Parser.TDH.all,
                            Get_Token (Parser.TDH.all, Row_Pos_140)),
                To_Text ("Missing ';'"));

    Token_Pos_179 := Row_Pos_140;


end if;

--  End opt_code



if Token_Pos_179 /= No_Token_Index then

   Row_Pos_140 := Token_Pos_179;

else
   Row_Pos_140 := No_Token_Index;
   goto Exit_Row_125_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_125_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_140 /= No_Token_Index then

   Transform_Res_120 := Allocate_Entry_Decl (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_120,
      Kind => Ada_Entry_Decl,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_140 = Pos
                            then No_Token_Index
                            else Row_Pos_140 - 1));

      Initialize_Fields_For_Entry_Decl
        (Self => Transform_Res_120, Entry_Decl_F_Overriding => Defer_Res_201, Entry_Decl_F_Spec => Transform_Res_119, Entry_Decl_F_Aspects => Defer_Res_207);

         if Defer_Res_201 /= null and then Is_Incomplete (Defer_Res_201) then
            Transform_Res_120.Last_Attempted_Child := 0;
         elsif Defer_Res_201 /= null and then not Is_Ghost (Defer_Res_201) then
            Transform_Res_120.Last_Attempted_Child := -1;
         end if;
         if Transform_Res_119 /= null and then Is_Incomplete (Transform_Res_119) then
            Transform_Res_120.Last_Attempted_Child := 0;
         elsif Transform_Res_119 /= null and then not Is_Ghost (Transform_Res_119) then
            Transform_Res_120.Last_Attempted_Child := -1;
         end if;
         if Defer_Res_207 /= null and then Is_Incomplete (Defer_Res_207) then
            Transform_Res_120.Last_Attempted_Child := 0;
         elsif Defer_Res_207 /= null and then not Is_Ghost (Defer_Res_207) then
            Transform_Res_120.Last_Attempted_Child := -1;
         end if;


end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Entry_Decl_Transform_Parse_1_Memo,
      Row_Pos_140 /= No_Token_Index,
      Transform_Res_120,
      Pos,
      Row_Pos_140);


   Parser.Current_Pos := Row_Pos_140;

   return Transform_Res_120;
end Entry_Decl_Transform_Parse_1;

   


function Component_Clause_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Component_Clause
is
   use Bare_Component_Clause_Memos;

      Row_Pos_153 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_220 :
            Token_Index
               := No_Token_Index;
      Defer_Res_220 :
            Bare_Identifier
               := No_Bare_Ada_Node;
      Token_Pos_204 :
            Token_Index
               := No_Token_Index;
      Token_Res_204 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_221 :
            Token_Index
               := No_Token_Index;
      Defer_Res_221 :
            Bare_Expr
               := No_Bare_Ada_Node;
      Defer_Pos_222 :
            Token_Index
               := No_Token_Index;
      Defer_Res_222 :
            Bare_Range_Spec
               := No_Bare_Ada_Node;
      Token_Pos_205 :
            Token_Index
               := No_Token_Index;
      Token_Res_205 :
            Token_Index
               := No_Token_Index;
      Transform_Res_129 :
            Bare_Component_Clause
               := No_Bare_Ada_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Component_Clause_Transform_Parse_0_Memo, Pos);

begin

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res_129 := M.Instance;
      return Transform_Res_129;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res_129;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code


--  Start row_code

Row_Pos_153 := Pos;



Defer_Res_220 :=
   Identifier_Transform_Parse_0 (Parser, Row_Pos_153);
Defer_Pos_220 := Parser.Current_Pos;



if Defer_Pos_220 /= No_Token_Index then

   Row_Pos_153 := Defer_Pos_220;

else
   Row_Pos_153 := No_Token_Index;
   goto Exit_Row_136_0;

end if;


--  Start tok_code

Token_Res_204 := Row_Pos_153;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_204));
begin
   if
      T.Kind /= From_Token_Kind (Ada_At)
   then
       Token_Pos_204 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_153 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_153,
             Expected_Token_Id => Ada_At,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_204 := Row_Pos_153 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_204 /= No_Token_Index then

   Row_Pos_153 := Token_Pos_204;

else
   Row_Pos_153 := No_Token_Index;
   goto Exit_Row_136_0;

end if;


Defer_Res_221 :=
   Simple_Expr_Or_Parse_1 (Parser, Row_Pos_153);
Defer_Pos_221 := Parser.Current_Pos;



if Defer_Pos_221 /= No_Token_Index then

   Row_Pos_153 := Defer_Pos_221;

else
   Row_Pos_153 := No_Token_Index;
   goto Exit_Row_136_0;

end if;


Defer_Res_222 :=
   Range_Spec_Transform_Parse_0 (Parser, Row_Pos_153);
Defer_Pos_222 := Parser.Current_Pos;



if Defer_Pos_222 /= No_Token_Index then

   Row_Pos_153 := Defer_Pos_222;

else
   Row_Pos_153 := No_Token_Index;
   goto Exit_Row_136_0;

end if;


--  Start opt_code




--  Start tok_code

Token_Res_205 := Row_Pos_153;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_205));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Semicolon)
   then
       Token_Pos_205 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_153 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_153,
             Expected_Token_Id => Ada_Semicolon,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_205 := Row_Pos_153 + 1;
   end if;
end;

--  End tok_code


if Token_Pos_205 = No_Token_Index then

        Token_Res_205 := No_Token_Index;

        Append (Parser.Diagnostics,
                Sloc_Range (Parser.TDH.all,
                            Get_Token (Parser.TDH.all, Row_Pos_153)),
                To_Text ("Missing ';'"));

    Token_Pos_205 := Row_Pos_153;


end if;

--  End opt_code



if Token_Pos_205 /= No_Token_Index then

   Row_Pos_153 := Token_Pos_205;

else
   Row_Pos_153 := No_Token_Index;
   goto Exit_Row_136_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_136_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_153 /= No_Token_Index then

   Transform_Res_129 := Allocate_Component_Clause (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_129,
      Kind => Ada_Component_Clause,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_153 = Pos
                            then No_Token_Index
                            else Row_Pos_153 - 1));

      Initialize_Fields_For_Component_Clause
        (Self => Transform_Res_129, Component_Clause_F_Id => Defer_Res_220, Component_Clause_F_Position => Defer_Res_221, Component_Clause_F_Range => Defer_Res_222);

         if Defer_Res_220 /= null and then Is_Incomplete (Defer_Res_220) then
            Transform_Res_129.Last_Attempted_Child := 0;
         elsif Defer_Res_220 /= null and then not Is_Ghost (Defer_Res_220) then
            Transform_Res_129.Last_Attempted_Child := -1;
         end if;
         if Defer_Res_221 /= null and then Is_Incomplete (Defer_Res_221) then
            Transform_Res_129.Last_Attempted_Child := 0;
         elsif Defer_Res_221 /= null and then not Is_Ghost (Defer_Res_221) then
            Transform_Res_129.Last_Attempted_Child := -1;
         end if;
         if Defer_Res_222 /= null and then Is_Incomplete (Defer_Res_222) then
            Transform_Res_129.Last_Attempted_Child := 0;
         elsif Defer_Res_222 /= null and then not Is_Ghost (Defer_Res_222) then
            Transform_Res_129.Last_Attempted_Child := -1;
         end if;


end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Component_Clause_Transform_Parse_0_Memo,
      Row_Pos_153 /= No_Token_Index,
      Transform_Res_129,
      Pos,
      Row_Pos_153);


   Parser.Current_Pos := Row_Pos_153;

   return Transform_Res_129;
end Component_Clause_Transform_Parse_0;

   


function Pragma_Argument_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Pragma_Argument_Assoc
is
   use Bare_Pragma_Argument_Assoc_Memos;

      Row_Pos_156 :
            Token_Index
               := No_Token_Index;
      Row_Pos_157 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_226 :
            Token_Index
               := No_Token_Index;
      Defer_Res_226 :
            Bare_Identifier
               := No_Bare_Ada_Node;
      Token_Pos_211 :
            Token_Index
               := No_Token_Index;
      Token_Res_211 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_227 :
            Token_Index
               := No_Token_Index;
      Defer_Res_227 :
            Bare_Expr
               := No_Bare_Ada_Node;
      Transform_Res_131 :
            Bare_Pragma_Argument_Assoc
               := No_Bare_Ada_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Pragma_Argument_Transform_Parse_0_Memo, Pos);

begin

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res_131 := M.Instance;
      return Transform_Res_131;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res_131;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code


--  Start row_code

Row_Pos_156 := Pos;



--  Start opt_code




--  Start row_code

Row_Pos_157 := Row_Pos_156;



Defer_Res_226 :=
   Identifier_Transform_Parse_0 (Parser, Row_Pos_157);
Defer_Pos_226 := Parser.Current_Pos;



if Defer_Pos_226 /= No_Token_Index then

   Row_Pos_157 := Defer_Pos_226;

else
   Row_Pos_157 := No_Token_Index;
   goto Exit_Row_140_0;

end if;


--  Start tok_code

Token_Res_211 := Row_Pos_157;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_211));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Arrow)
   then
       Token_Pos_211 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_157 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_157,
             Expected_Token_Id => Ada_Arrow,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_211 := Row_Pos_157 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_211 /= No_Token_Index then

   Row_Pos_157 := Token_Pos_211;

else
   Row_Pos_157 := No_Token_Index;
   goto Exit_Row_140_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_140_0>>
pragma Warnings (On, "referenced");

--  End row_code


if Row_Pos_157 = No_Token_Index then

        Defer_Res_226 := No_Bare_Ada_Node;


    Row_Pos_157 := Row_Pos_156;


end if;

--  End opt_code



if Row_Pos_157 /= No_Token_Index then

   Row_Pos_156 := Row_Pos_157;

else
   Row_Pos_156 := No_Token_Index;
   goto Exit_Row_139_0;

end if;


Defer_Res_227 :=
   Expr_Or_Parse_0 (Parser, Row_Pos_156);
Defer_Pos_227 := Parser.Current_Pos;



if Defer_Pos_227 /= No_Token_Index then

   Row_Pos_156 := Defer_Pos_227;

else
   Row_Pos_156 := No_Token_Index;
   goto Exit_Row_139_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_139_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_156 /= No_Token_Index then

   Transform_Res_131 := Allocate_Pragma_Argument_Assoc (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_131,
      Kind => Ada_Pragma_Argument_Assoc,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_156 = Pos
                            then No_Token_Index
                            else Row_Pos_156 - 1));

      Initialize_Fields_For_Pragma_Argument_Assoc
        (Self => Transform_Res_131, Pragma_Argument_Assoc_F_Id => Defer_Res_226, Pragma_Argument_Assoc_F_Expr => Defer_Res_227);

         if Defer_Res_226 /= null and then Is_Incomplete (Defer_Res_226) then
            Transform_Res_131.Last_Attempted_Child := 0;
         elsif Defer_Res_226 /= null and then not Is_Ghost (Defer_Res_226) then
            Transform_Res_131.Last_Attempted_Child := -1;
         end if;
         if Defer_Res_227 /= null and then Is_Incomplete (Defer_Res_227) then
            Transform_Res_131.Last_Attempted_Child := 0;
         elsif Defer_Res_227 /= null and then not Is_Ghost (Defer_Res_227) then
            Transform_Res_131.Last_Attempted_Child := -1;
         end if;


end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Pragma_Argument_Transform_Parse_0_Memo,
      Row_Pos_156 /= No_Token_Index,
      Transform_Res_131,
      Pos,
      Row_Pos_156);


   Parser.Current_Pos := Row_Pos_156;

   return Transform_Res_131;
end Pragma_Argument_Transform_Parse_0;

   


function Pragma_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Pragma_Node
is
   use Bare_Pragma_Node_Memos;

      Nobt_19 :
            Boolean
               := False;
      Row_Pos_154 :
            Token_Index
               := No_Token_Index;
      Token_Pos_206 :
            Token_Index
               := No_Token_Index;
      Token_Res_206 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_223 :
            Token_Index
               := No_Token_Index;
      Defer_Res_223 :
            Bare_Identifier
               := No_Bare_Ada_Node;
      Row_Pos_155 :
            Token_Index
               := No_Token_Index;
      Token_Pos_207 :
            Token_Index
               := No_Token_Index;
      Token_Res_207 :
            Token_Index
               := No_Token_Index;
      Lst_Cpos_22 :
            Token_Index
               := No_Token_Index;
      Tmp_List_22 :
            Free_Parse_List;
      Defer_Pos_224 :
            Token_Index
               := No_Token_Index;
      Defer_Res_224 :
            Bare_Pragma_Argument_Assoc
               := No_Bare_Ada_Node;
      Defer_Pos_225 :
            Token_Index
               := No_Token_Index;
      Defer_Res_225 :
            Bare_Contract_Case_Assoc
               := No_Bare_Ada_Node;
      Or_Pos_53 :
            Token_Index
               := No_Token_Index;
      Or_Res_53 :
            Bare_Base_Assoc
               := No_Bare_Ada_Node;
      Token_Pos_208 :
            Token_Index
               := No_Token_Index;
      Token_Res_208 :
            Token_Index
               := No_Token_Index;
      List_Pos_22 :
            Token_Index
               := No_Token_Index;
      List_Res_22 :
            Bare_Base_Assoc_List
               := No_Bare_Ada_Node;
      Token_Pos_209 :
            Token_Index
               := No_Token_Index;
      Token_Res_209 :
            Token_Index
               := No_Token_Index;
      Token_Pos_210 :
            Token_Index
               := No_Token_Index;
      Token_Res_210 :
            Token_Index
               := No_Token_Index;
      Row_Progress_19 :
            Integer
               := 0;
      Transform_Res_130 :
            Bare_Pragma_Node
               := No_Bare_Ada_Node;
      Transform_Has_Failed_19 :
            Boolean
               := False;


   M : Memo_Entry := Get (Parser.Private_Part.Pragma_Transform_Parse_0_Memo, Pos);

begin

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res_130 := M.Instance;
      return Transform_Res_130;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res_130;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code


--  Start row_code

Row_Pos_154 := Pos;



--  Start tok_code

Token_Res_206 := Row_Pos_154;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_206));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Pragma)
   then
       Token_Pos_206 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_154 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_154,
             Expected_Token_Id => Ada_Pragma,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_206 := Row_Pos_154 + 1;
   end if;
end;

--  End tok_code


Row_Progress_19 := 1;

if Token_Pos_206 /= No_Token_Index then

   Row_Pos_154 := Token_Pos_206;

else
   Row_Pos_154 := No_Token_Index;
   goto Exit_Row_137_0;

end if;

Nobt_19 := True;

Row_Progress_19 := 2;

if Row_Pos_154 /= No_Token_Index then

   Row_Pos_154 := Row_Pos_154;

else
   Row_Pos_154 := No_Token_Index;
   goto Exit_Row_137_0;

end if;


Defer_Res_223 :=
   Identifier_Transform_Parse_0 (Parser, Row_Pos_154);
Defer_Pos_223 := Parser.Current_Pos;


Row_Progress_19 := 3;

if Defer_Pos_223 /= No_Token_Index then

   Row_Pos_154 := Defer_Pos_223;

else
   Row_Pos_154 := No_Token_Index;
   goto Exit_Row_137_0;

end if;


--  Start opt_code




--  Start row_code

Row_Pos_155 := Row_Pos_154;



--  Start tok_code

Token_Res_207 := Row_Pos_155;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_207));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Par_Open)
   then
       Token_Pos_207 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_155 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_155,
             Expected_Token_Id => Ada_Par_Open,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_207 := Row_Pos_155 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_207 /= No_Token_Index then

   Row_Pos_155 := Token_Pos_207;

else
   Row_Pos_155 := No_Token_Index;
   goto Exit_Row_138_0;

end if;


--  Start list_code

    List_Pos_22 := No_Token_Index;



Lst_Cpos_22 := Row_Pos_155;
Tmp_List_22 := Get_Parse_List (Parser);

loop
   
--  Start or_code

Or_Pos_53 := No_Token_Index;
Or_Res_53 := No_Bare_Ada_Node;
    
Defer_Res_224 :=
   Pragma_Argument_Transform_Parse_0 (Parser, Lst_Cpos_22);
Defer_Pos_224 := Parser.Current_Pos;

    if Defer_Pos_224 /= No_Token_Index then
        Or_Pos_53 := Defer_Pos_224;
        Or_Res_53 := Defer_Res_224;
        goto Exit_Or_52;
    end if;
    
Defer_Res_225 :=
   Contract_Case_Assoc_Transform_Parse_0 (Parser, Lst_Cpos_22);
Defer_Pos_225 := Parser.Current_Pos;

    if Defer_Pos_225 /= No_Token_Index then
        Or_Pos_53 := Defer_Pos_225;
        Or_Res_53 := Defer_Res_225;
        goto Exit_Or_52;
    end if;
<<Exit_Or_52>>

--  End or_code


   exit when Or_Pos_53 = No_Token_Index;

   List_Pos_22 := Or_Pos_53;
   Lst_Cpos_22 := List_Pos_22;

   Tmp_List_22.Nodes.Append (Or_Res_53);

      
--  Start tok_code

Token_Res_208 := Lst_Cpos_22;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_208));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Comma)
   then
       Token_Pos_208 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Lst_Cpos_22 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Lst_Cpos_22,
             Expected_Token_Id => Ada_Comma,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_208 := Lst_Cpos_22 + 1;
   end if;
end;

--  End tok_code

      if Token_Pos_208 /= No_Token_Index then
          Lst_Cpos_22 := Token_Pos_208;
      else
         exit;
      end if;

end loop;

declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List_22.Nodes.Length;
begin
   List_Res_22 :=
      Allocate_Base_Assoc_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Row_Pos_155;
      Token_End := (if Lst_Cpos_22 = Row_Pos_155
                    then Row_Pos_155
                    else Lst_Cpos_22 - 1);

   else
      Token_Start := Token_Index'Max (Row_Pos_155, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res_22,
      Kind              => Ada_Base_Assoc_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res_22,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_Ada_Node_Vectors.Vector renames
         Tmp_List_22.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res_22.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List_22);

--  End list_code



if List_Pos_22 /= No_Token_Index then

   Row_Pos_155 := List_Pos_22;

else
   Row_Pos_155 := No_Token_Index;
   goto Exit_Row_138_0;

end if;


--  Start tok_code

Token_Res_209 := Row_Pos_155;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_209));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Par_Close)
   then
       Token_Pos_209 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_155 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_155,
             Expected_Token_Id => Ada_Par_Close,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_209 := Row_Pos_155 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_209 /= No_Token_Index then

   Row_Pos_155 := Token_Pos_209;

else
   Row_Pos_155 := No_Token_Index;
   goto Exit_Row_138_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_138_0>>
pragma Warnings (On, "referenced");

--  End row_code


if Row_Pos_155 = No_Token_Index then

        List_Res_22 :=
           Allocate_Base_Assoc_List (Parser.Mem_Pool);
         Initialize
           (Self              => List_Res_22,
            Kind              => Ada_Base_Assoc_List,
            Unit              => Parser.Unit,
            Token_Start_Index => Row_Pos_154 - 1,
            Token_End_Index   => No_Token_Index);
         Initialize_List
           (Self   => List_Res_22,
            Parser => Parser,
            Count  => 0);


    Row_Pos_155 := Row_Pos_154;


end if;

--  End opt_code


Row_Progress_19 := 4;

if Row_Pos_155 /= No_Token_Index then

   Row_Pos_154 := Row_Pos_155;

else
   Row_Pos_154 := No_Token_Index;
   goto Exit_Row_137_0;

end if;


--  Start opt_code




--  Start tok_code

Token_Res_210 := Row_Pos_154;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_210));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Semicolon)
   then
       Token_Pos_210 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_154 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_154,
             Expected_Token_Id => Ada_Semicolon,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_210 := Row_Pos_154 + 1;
   end if;
end;

--  End tok_code


if Token_Pos_210 = No_Token_Index then

        Token_Res_210 := No_Token_Index;

        Append (Parser.Diagnostics,
                Sloc_Range (Parser.TDH.all,
                            Get_Token (Parser.TDH.all, Row_Pos_154)),
                To_Text ("Missing ';'"));

    Token_Pos_210 := Row_Pos_154;


end if;

--  End opt_code


Row_Progress_19 := 5;

if Token_Pos_210 /= No_Token_Index then

   Row_Pos_154 := Token_Pos_210;

else
   Row_Pos_154 := No_Token_Index;
   goto Exit_Row_137_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_137_0>>
pragma Warnings (On, "referenced");

--  End row_code


if Row_Pos_154 = No_Token_Index and then Nobt_19 then
   Row_Pos_154 := Parser.Last_Fail.Pos;
   Transform_Has_Failed_19 := True;
end if;

if Row_Pos_154 /= No_Token_Index then

   Transform_Res_130 := Allocate_Pragma_Node (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_130,
      Kind => Ada_Pragma_Node,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_154 = Pos
                            then No_Token_Index
                            else Row_Pos_154 - 1));

      Initialize_Fields_For_Pragma_Node
        (Self => Transform_Res_130, Pragma_Node_F_Id => Defer_Res_223, Pragma_Node_F_Args => List_Res_22);

         if Defer_Res_223 /= null and then Is_Incomplete (Defer_Res_223) then
            Transform_Res_130.Last_Attempted_Child := 0;
         elsif Defer_Res_223 /= null and then not Is_Ghost (Defer_Res_223) then
            Transform_Res_130.Last_Attempted_Child := -1;
         end if;
         if List_Res_22 /= null and then Is_Incomplete (List_Res_22) then
            Transform_Res_130.Last_Attempted_Child := 0;
         elsif List_Res_22 /= null and then not Is_Ghost (List_Res_22) then
            Transform_Res_130.Last_Attempted_Child := -1;
         end if;

   if Transform_Has_Failed_19 then
      Transform_Res_130.Last_Attempted_Child :=
         Row_Progress_19;

      Append (Parser.Diagnostics,
              Sloc_Range (Parser.TDH.all,
                          Get_Token (Parser.TDH.all, Pos)),
              To_Text ("Cannot parse <pragma>"));

      Add_Last_Fail_Diagnostic (Parser);
   end if;

end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Pragma_Transform_Parse_0_Memo,
      Row_Pos_154 /= No_Token_Index,
      Transform_Res_130,
      Pos,
      Row_Pos_154);


   Parser.Current_Pos := Row_Pos_154;

   return Transform_Res_130;
end Pragma_Transform_Parse_0;

   


function Aspect_Clause_Or_Parse_1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Aspect_Clause
is
   use Bare_Aspect_Clause_Memos;

      Nobt_17 :
            Boolean
               := False;
      Nobt_18 :
            Boolean
               := False;
      Row_Pos_148 :
            Token_Index
               := No_Token_Index;
      Token_Pos_185 :
            Token_Index
               := No_Token_Index;
      Token_Res_185 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_210 :
            Token_Index
               := No_Token_Index;
      Defer_Res_210 :
            Bare_Name
               := No_Bare_Ada_Node;
      Token_Pos_186 :
            Token_Index
               := No_Token_Index;
      Token_Res_186 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_211 :
            Token_Index
               := No_Token_Index;
      Defer_Res_211 :
            Bare_Base_Aggregate
               := No_Bare_Ada_Node;
      Token_Pos_187 :
            Token_Index
               := No_Token_Index;
      Token_Res_187 :
            Token_Index
               := No_Token_Index;
      Row_Progress_17 :
            Integer
               := 0;
      Transform_Res_125 :
            Bare_Enum_Rep_Clause
               := No_Bare_Ada_Node;
      Transform_Has_Failed_17 :
            Boolean
               := False;
      Row_Pos_149 :
            Token_Index
               := No_Token_Index;
      Token_Pos_188 :
            Token_Index
               := No_Token_Index;
      Token_Res_188 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_212 :
            Token_Index
               := No_Token_Index;
      Defer_Res_212 :
            Bare_Name
               := No_Bare_Ada_Node;
      Token_Pos_189 :
            Token_Index
               := No_Token_Index;
      Token_Res_189 :
            Token_Index
               := No_Token_Index;
      Token_Pos_190 :
            Token_Index
               := No_Token_Index;
      Token_Res_190 :
            Token_Index
               := No_Token_Index;
      Row_Pos_150 :
            Token_Index
               := No_Token_Index;
      Token_Pos_191 :
            Token_Index
               := No_Token_Index;
      Token_Res_191 :
            Token_Index
               := No_Token_Index;
      Token_Pos_192 :
            Token_Index
               := No_Token_Index;
      Token_Res_192 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_213 :
            Token_Index
               := No_Token_Index;
      Defer_Res_213 :
            Bare_Expr
               := No_Bare_Ada_Node;
      Token_Pos_193 :
            Token_Index
               := No_Token_Index;
      Token_Res_193 :
            Token_Index
               := No_Token_Index;
      Lst_Cpos_21 :
            Token_Index
               := No_Token_Index;
      Tmp_List_21 :
            Free_Parse_List;
      Defer_Pos_214 :
            Token_Index
               := No_Token_Index;
      Defer_Res_214 :
            Bare_Component_Clause
               := No_Bare_Ada_Node;
      Defer_Pos_215 :
            Token_Index
               := No_Token_Index;
      Defer_Res_215 :
            Bare_Pragma_Node
               := No_Bare_Ada_Node;
      Or_Pos_51 :
            Token_Index
               := No_Token_Index;
      Or_Res_51 :
            Bare_Ada_Node
               := No_Bare_Ada_Node;
      List_Pos_21 :
            Token_Index
               := No_Token_Index;
      List_Res_21 :
            Bare_Ada_Node_List
               := No_Bare_Ada_Node;
      Token_Pos_194 :
            Token_Index
               := No_Token_Index;
      Token_Res_194 :
            Token_Index
               := No_Token_Index;
      Token_Pos_195 :
            Token_Index
               := No_Token_Index;
      Token_Res_195 :
            Token_Index
               := No_Token_Index;
      Token_Pos_196 :
            Token_Index
               := No_Token_Index;
      Token_Res_196 :
            Token_Index
               := No_Token_Index;
      Transform_Res_126 :
            Bare_Record_Rep_Clause
               := No_Bare_Ada_Node;
      Row_Pos_151 :
            Token_Index
               := No_Token_Index;
      Token_Pos_197 :
            Token_Index
               := No_Token_Index;
      Token_Res_197 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_216 :
            Token_Index
               := No_Token_Index;
      Defer_Res_216 :
            Bare_Base_Id
               := No_Bare_Ada_Node;
      Token_Pos_198 :
            Token_Index
               := No_Token_Index;
      Token_Res_198 :
            Token_Index
               := No_Token_Index;
      Token_Pos_199 :
            Token_Index
               := No_Token_Index;
      Token_Res_199 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_217 :
            Token_Index
               := No_Token_Index;
      Defer_Res_217 :
            Bare_Expr
               := No_Bare_Ada_Node;
      Token_Pos_200 :
            Token_Index
               := No_Token_Index;
      Token_Res_200 :
            Token_Index
               := No_Token_Index;
      Transform_Res_127 :
            Bare_At_Clause
               := No_Bare_Ada_Node;
      Row_Pos_152 :
            Token_Index
               := No_Token_Index;
      Token_Pos_201 :
            Token_Index
               := No_Token_Index;
      Token_Res_201 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_218 :
            Token_Index
               := No_Token_Index;
      Defer_Res_218 :
            Bare_Name
               := No_Bare_Ada_Node;
      Token_Pos_202 :
            Token_Index
               := No_Token_Index;
      Token_Res_202 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_219 :
            Token_Index
               := No_Token_Index;
      Defer_Res_219 :
            Bare_Expr
               := No_Bare_Ada_Node;
      Token_Pos_203 :
            Token_Index
               := No_Token_Index;
      Token_Res_203 :
            Token_Index
               := No_Token_Index;
      Row_Progress_18 :
            Integer
               := 0;
      Transform_Res_128 :
            Bare_Attribute_Def_Clause
               := No_Bare_Ada_Node;
      Transform_Has_Failed_18 :
            Boolean
               := False;
      Or_Pos_52 :
            Token_Index
               := No_Token_Index;
      Or_Res_52 :
            Bare_Aspect_Clause
               := No_Bare_Ada_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Aspect_Clause_Or_Parse_1_Memo, Pos);

begin

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Or_Res_52 := M.Instance;
      return Or_Res_52;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Or_Res_52;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start or_code

Or_Pos_52 := No_Token_Index;
Or_Res_52 := No_Bare_Ada_Node;
    
--  Start transform_code


--  Start row_code

Row_Pos_148 := Pos;



--  Start tok_code

Token_Res_185 := Row_Pos_148;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_185));
begin
   if
      T.Kind /= From_Token_Kind (Ada_For)
   then
       Token_Pos_185 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_148 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_148,
             Expected_Token_Id => Ada_For,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_185 := Row_Pos_148 + 1;
   end if;
end;

--  End tok_code


Row_Progress_17 := 1;

if Token_Pos_185 /= No_Token_Index then

   Row_Pos_148 := Token_Pos_185;

else
   Row_Pos_148 := No_Token_Index;
   goto Exit_Row_133_0;

end if;


Defer_Res_210 :=
   Static_Name_Or_Parse_0 (Parser, Row_Pos_148);
Defer_Pos_210 := Parser.Current_Pos;


Row_Progress_17 := 2;

if Defer_Pos_210 /= No_Token_Index then

   Row_Pos_148 := Defer_Pos_210;

else
   Row_Pos_148 := No_Token_Index;
   goto Exit_Row_133_0;

end if;


--  Start tok_code

Token_Res_186 := Row_Pos_148;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_186));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Use)
   then
       Token_Pos_186 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_148 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_148,
             Expected_Token_Id => Ada_Use,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_186 := Row_Pos_148 + 1;
   end if;
end;

--  End tok_code


Row_Progress_17 := 3;

if Token_Pos_186 /= No_Token_Index then

   Row_Pos_148 := Token_Pos_186;

else
   Row_Pos_148 := No_Token_Index;
   goto Exit_Row_133_0;

end if;


Defer_Res_211 :=
   Regular_Aggregate_Or_Parse_0 (Parser, Row_Pos_148);
Defer_Pos_211 := Parser.Current_Pos;


Row_Progress_17 := 4;

if Defer_Pos_211 /= No_Token_Index then

   Row_Pos_148 := Defer_Pos_211;

else
   Row_Pos_148 := No_Token_Index;
   goto Exit_Row_133_0;

end if;

Nobt_17 := True;

Row_Progress_17 := 5;

if Row_Pos_148 /= No_Token_Index then

   Row_Pos_148 := Row_Pos_148;

else
   Row_Pos_148 := No_Token_Index;
   goto Exit_Row_133_0;

end if;


--  Start tok_code

Token_Res_187 := Row_Pos_148;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_187));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Semicolon)
   then
       Token_Pos_187 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_148 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_148,
             Expected_Token_Id => Ada_Semicolon,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_187 := Row_Pos_148 + 1;
   end if;
end;

--  End tok_code


Row_Progress_17 := 6;

if Token_Pos_187 /= No_Token_Index then

   Row_Pos_148 := Token_Pos_187;

else
   Row_Pos_148 := No_Token_Index;
   goto Exit_Row_133_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_133_0>>
pragma Warnings (On, "referenced");

--  End row_code


if Row_Pos_148 = No_Token_Index and then Nobt_17 then
   Row_Pos_148 := Parser.Last_Fail.Pos;
   Transform_Has_Failed_17 := True;
end if;

if Row_Pos_148 /= No_Token_Index then

   Transform_Res_125 := Allocate_Enum_Rep_Clause (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_125,
      Kind => Ada_Enum_Rep_Clause,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_148 = Pos
                            then No_Token_Index
                            else Row_Pos_148 - 1));

      Initialize_Fields_For_Enum_Rep_Clause
        (Self => Transform_Res_125, Enum_Rep_Clause_F_Type_Name => Defer_Res_210, Enum_Rep_Clause_F_Aggregate => Defer_Res_211);

         if Defer_Res_210 /= null and then Is_Incomplete (Defer_Res_210) then
            Transform_Res_125.Last_Attempted_Child := 0;
         elsif Defer_Res_210 /= null and then not Is_Ghost (Defer_Res_210) then
            Transform_Res_125.Last_Attempted_Child := -1;
         end if;
         if Defer_Res_211 /= null and then Is_Incomplete (Defer_Res_211) then
            Transform_Res_125.Last_Attempted_Child := 0;
         elsif Defer_Res_211 /= null and then not Is_Ghost (Defer_Res_211) then
            Transform_Res_125.Last_Attempted_Child := -1;
         end if;

   if Transform_Has_Failed_17 then
      Transform_Res_125.Last_Attempted_Child :=
         Row_Progress_17;

      Append (Parser.Diagnostics,
              Sloc_Range (Parser.TDH.all,
                          Get_Token (Parser.TDH.all, Pos)),
              To_Text ("Cannot parse <aspect_clause>"));

      Add_Last_Fail_Diagnostic (Parser);
   end if;

end if;

--  End transform_code

    if Row_Pos_148 /= No_Token_Index then
        Or_Pos_52 := Row_Pos_148;
        Or_Res_52 := Transform_Res_125;
        goto Exit_Or_50;
    end if;
    
--  Start transform_code


--  Start row_code

Row_Pos_149 := Pos;



--  Start tok_code

Token_Res_188 := Row_Pos_149;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_188));
begin
   if
      T.Kind /= From_Token_Kind (Ada_For)
   then
       Token_Pos_188 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_149 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_149,
             Expected_Token_Id => Ada_For,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_188 := Row_Pos_149 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_188 /= No_Token_Index then

   Row_Pos_149 := Token_Pos_188;

else
   Row_Pos_149 := No_Token_Index;
   goto Exit_Row_134_0;

end if;


Defer_Res_212 :=
   Static_Name_Or_Parse_0 (Parser, Row_Pos_149);
Defer_Pos_212 := Parser.Current_Pos;



if Defer_Pos_212 /= No_Token_Index then

   Row_Pos_149 := Defer_Pos_212;

else
   Row_Pos_149 := No_Token_Index;
   goto Exit_Row_134_0;

end if;


--  Start tok_code

Token_Res_189 := Row_Pos_149;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_189));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Use)
   then
       Token_Pos_189 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_149 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_149,
             Expected_Token_Id => Ada_Use,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_189 := Row_Pos_149 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_189 /= No_Token_Index then

   Row_Pos_149 := Token_Pos_189;

else
   Row_Pos_149 := No_Token_Index;
   goto Exit_Row_134_0;

end if;


--  Start tok_code

Token_Res_190 := Row_Pos_149;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_190));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Record)
   then
       Token_Pos_190 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_149 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_149,
             Expected_Token_Id => Ada_Record,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_190 := Row_Pos_149 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_190 /= No_Token_Index then

   Row_Pos_149 := Token_Pos_190;

else
   Row_Pos_149 := No_Token_Index;
   goto Exit_Row_134_0;

end if;


--  Start opt_code




--  Start row_code

Row_Pos_150 := Row_Pos_149;



--  Start tok_code

Token_Res_191 := Row_Pos_150;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_191));
begin
   if
      T.Kind /= From_Token_Kind (Ada_At)
   then
       Token_Pos_191 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_150 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_150,
             Expected_Token_Id => Ada_At,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_191 := Row_Pos_150 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_191 /= No_Token_Index then

   Row_Pos_150 := Token_Pos_191;

else
   Row_Pos_150 := No_Token_Index;
   goto Exit_Row_135_0;

end if;


--  Start tok_code

Token_Res_192 := Row_Pos_150;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_192));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Mod)
   then
       Token_Pos_192 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_150 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_150,
             Expected_Token_Id => Ada_Mod,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_192 := Row_Pos_150 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_192 /= No_Token_Index then

   Row_Pos_150 := Token_Pos_192;

else
   Row_Pos_150 := No_Token_Index;
   goto Exit_Row_135_0;

end if;


Defer_Res_213 :=
   Simple_Expr_Or_Parse_1 (Parser, Row_Pos_150);
Defer_Pos_213 := Parser.Current_Pos;



if Defer_Pos_213 /= No_Token_Index then

   Row_Pos_150 := Defer_Pos_213;

else
   Row_Pos_150 := No_Token_Index;
   goto Exit_Row_135_0;

end if;


--  Start opt_code




--  Start tok_code

Token_Res_193 := Row_Pos_150;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_193));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Semicolon)
   then
       Token_Pos_193 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_150 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_150,
             Expected_Token_Id => Ada_Semicolon,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_193 := Row_Pos_150 + 1;
   end if;
end;

--  End tok_code


if Token_Pos_193 = No_Token_Index then

        Token_Res_193 := No_Token_Index;

        Append (Parser.Diagnostics,
                Sloc_Range (Parser.TDH.all,
                            Get_Token (Parser.TDH.all, Row_Pos_150)),
                To_Text ("Missing ';'"));

    Token_Pos_193 := Row_Pos_150;


end if;

--  End opt_code



if Token_Pos_193 /= No_Token_Index then

   Row_Pos_150 := Token_Pos_193;

else
   Row_Pos_150 := No_Token_Index;
   goto Exit_Row_135_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_135_0>>
pragma Warnings (On, "referenced");

--  End row_code


if Row_Pos_150 = No_Token_Index then

        Defer_Res_213 := No_Bare_Ada_Node;


    Row_Pos_150 := Row_Pos_149;


end if;

--  End opt_code



if Row_Pos_150 /= No_Token_Index then

   Row_Pos_149 := Row_Pos_150;

else
   Row_Pos_149 := No_Token_Index;
   goto Exit_Row_134_0;

end if;


--  Start list_code

    List_Pos_21 := Row_Pos_149;



Lst_Cpos_21 := Row_Pos_149;
Tmp_List_21 := Get_Parse_List (Parser);

loop
   
--  Start or_code

Or_Pos_51 := No_Token_Index;
Or_Res_51 := No_Bare_Ada_Node;
    
Defer_Res_214 :=
   Component_Clause_Transform_Parse_0 (Parser, Lst_Cpos_21);
Defer_Pos_214 := Parser.Current_Pos;

    if Defer_Pos_214 /= No_Token_Index then
        Or_Pos_51 := Defer_Pos_214;
        Or_Res_51 := Defer_Res_214;
        goto Exit_Or_51;
    end if;
    
Defer_Res_215 :=
   Pragma_Transform_Parse_0 (Parser, Lst_Cpos_21);
Defer_Pos_215 := Parser.Current_Pos;

    if Defer_Pos_215 /= No_Token_Index then
        Or_Pos_51 := Defer_Pos_215;
        Or_Res_51 := Defer_Res_215;
        goto Exit_Or_51;
    end if;
<<Exit_Or_51>>

--  End or_code


   exit when Or_Pos_51 = No_Token_Index;

   List_Pos_21 := Or_Pos_51;
   Lst_Cpos_21 := List_Pos_21;

   Tmp_List_21.Nodes.Append (Or_Res_51);


end loop;

declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List_21.Nodes.Length;
begin
   List_Res_21 :=
      Allocate_Ada_Node_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Row_Pos_149;
      Token_End := (if Lst_Cpos_21 = Row_Pos_149
                    then Row_Pos_149
                    else Lst_Cpos_21 - 1);

   else
      Token_Start := Token_Index'Max (Row_Pos_149, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res_21,
      Kind              => Ada_Ada_Node_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res_21,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_Ada_Node_Vectors.Vector renames
         Tmp_List_21.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res_21.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List_21);

--  End list_code



if List_Pos_21 /= No_Token_Index then

   Row_Pos_149 := List_Pos_21;

else
   Row_Pos_149 := No_Token_Index;
   goto Exit_Row_134_0;

end if;


--  Start tok_code

Token_Res_194 := Row_Pos_149;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_194));
begin
   if
      T.Kind /= From_Token_Kind (Ada_End)
   then
       Token_Pos_194 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_149 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_149,
             Expected_Token_Id => Ada_End,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_194 := Row_Pos_149 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_194 /= No_Token_Index then

   Row_Pos_149 := Token_Pos_194;

else
   Row_Pos_149 := No_Token_Index;
   goto Exit_Row_134_0;

end if;


--  Start tok_code

Token_Res_195 := Row_Pos_149;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_195));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Record)
   then
       Token_Pos_195 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_149 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_149,
             Expected_Token_Id => Ada_Record,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_195 := Row_Pos_149 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_195 /= No_Token_Index then

   Row_Pos_149 := Token_Pos_195;

else
   Row_Pos_149 := No_Token_Index;
   goto Exit_Row_134_0;

end if;


--  Start opt_code




--  Start tok_code

Token_Res_196 := Row_Pos_149;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_196));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Semicolon)
   then
       Token_Pos_196 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_149