
#ifndef KCODECS_EXPORT_H
#define KCODECS_EXPORT_H

#ifdef KCODECS_STATIC_DEFINE
#  define KCODECS_EXPORT
#  define KCODECS_NO_EXPORT
#else
#  ifndef KCODECS_EXPORT
#    ifdef KF5Codecs_EXPORTS
        /* We are building this library */
#      define KCODECS_EXPORT __declspec(dllexport)
#    else
        /* We are using this library */
#      define KCODECS_EXPORT __declspec(dllimport)
#    endif
#  endif

#  ifndef KCODECS_NO_EXPORT
#    define KCODECS_NO_EXPORT 
#  endif
#endif

#ifndef KCODECS_DECL_DEPRECATED
#  define KCODECS_DECL_DEPRECATED __declspec(deprecated)
#endif

#ifndef KCODECS_DECL_DEPRECATED_EXPORT
#  define KCODECS_DECL_DEPRECATED_EXPORT KCODECS_EXPORT KCODECS_DECL_DEPRECATED
#endif

#ifndef KCODECS_DECL_DEPRECATED_NO_EXPORT
#  define KCODECS_DECL_DEPRECATED_NO_EXPORT KCODECS_NO_EXPORT KCODECS_DECL_DEPRECATED
#endif

#if 0 /* DEFINE_NO_DEPRECATED */
#  ifndef KCODECS_NO_DEPRECATED
#    define KCODECS_NO_DEPRECATED
#  endif
#endif

#define KCODECS_DECL_DEPRECATED_TEXT(text) __attribute__ ((__deprecated__(text)))

/* Take any defaults from group settings */
#if !defined(KCODECS_NO_DEPRECATED) && !defined(KCODECS_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  ifdef KF_NO_DEPRECATED
#    define KCODECS_NO_DEPRECATED
#  elif defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#    define KCODECS_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#  endif
#endif
#if !defined(KCODECS_DISABLE_DEPRECATED_BEFORE_AND_AT) && defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  define KCODECS_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#endif

#if !defined(KCODECS_NO_DEPRECATED_WARNINGS) && !defined(KCODECS_DEPRECATED_WARNINGS_SINCE)
#  ifdef KF_NO_DEPRECATED_WARNINGS
#    define KCODECS_NO_DEPRECATED_WARNINGS
#  elif defined(KF_DEPRECATED_WARNINGS_SINCE)
#    define KCODECS_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#  endif
#endif
#if !defined(KCODECS_DEPRECATED_WARNINGS_SINCE) && defined(KF_DEPRECATED_WARNINGS_SINCE)
#  define KCODECS_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#endif

#if defined(KCODECS_NO_DEPRECATED)
#  undef KCODECS_DEPRECATED
#  define KCODECS_DEPRECATED_EXPORT KCODECS_EXPORT
#  define KCODECS_DEPRECATED_NO_EXPORT KCODECS_NO_EXPORT
#elif defined(KCODECS_NO_DEPRECATED_WARNINGS)
#  define KCODECS_DEPRECATED
#  define KCODECS_DEPRECATED_EXPORT KCODECS_EXPORT
#  define KCODECS_DEPRECATED_NO_EXPORT KCODECS_NO_EXPORT
#else
#  define KCODECS_DEPRECATED KCODECS_DECL_DEPRECATED
#  define KCODECS_DEPRECATED_EXPORT KCODECS_DECL_DEPRECATED_EXPORT
#  define KCODECS_DEPRECATED_NO_EXPORT KCODECS_DECL_DEPRECATED_NO_EXPORT
#endif

/* No deprecated API had been removed from build */
#define KCODECS_EXCLUDE_DEPRECATED_BEFORE_AND_AT 0

#define KCODECS_BUILD_DEPRECATED_SINCE(major, minor) 1

#ifdef KCODECS_NO_DEPRECATED
#  define KCODECS_DISABLE_DEPRECATED_BEFORE_AND_AT 0x57200
#endif
#ifdef KCODECS_NO_DEPRECATED_WARNINGS
#  define KCODECS_DEPRECATED_WARNINGS_SINCE 0
#endif

#ifndef KCODECS_DEPRECATED_WARNINGS_SINCE
#  ifdef KCODECS_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define KCODECS_DEPRECATED_WARNINGS_SINCE KCODECS_DISABLE_DEPRECATED_BEFORE_AND_AT
#  else
#    define KCODECS_DEPRECATED_WARNINGS_SINCE 0x57200
#  endif
#endif

#ifndef KCODECS_DISABLE_DEPRECATED_BEFORE_AND_AT
#  define KCODECS_DISABLE_DEPRECATED_BEFORE_AND_AT 0
#endif

#ifdef KCODECS_DEPRECATED
#  define KCODECS_ENABLE_DEPRECATED_SINCE(major, minor) (((major<<16)|(minor<<8)) > KCODECS_DISABLE_DEPRECATED_BEFORE_AND_AT)
#else
#  define KCODECS_ENABLE_DEPRECATED_SINCE(major, minor) 0
#endif

#if KCODECS_DEPRECATED_WARNINGS_SINCE >= 0x50500
#  define KCODECS_DEPRECATED_VERSION_5_5(text) KCODECS_DECL_DEPRECATED_TEXT(text)
#else
#  define KCODECS_DEPRECATED_VERSION_5_5(text)
#endif

#if KCODECS_DEPRECATED_WARNINGS_SINCE >= 0x53800
#  define KCODECS_DEPRECATED_VERSION_5_56(text) KCODECS_DECL_DEPRECATED_TEXT(text)
#else
#  define KCODECS_DEPRECATED_VERSION_5_56(text)
#endif

#if KCODECS_DEPRECATED_WARNINGS_SINCE >= 0x56500
#  define KCODECS_DEPRECATED_VERSION_5_101(text) KCODECS_DECL_DEPRECATED_TEXT(text)
#else
#  define KCODECS_DEPRECATED_VERSION_5_101(text)
#endif
#define KCODECS_DEPRECATED_VERSION_5(minor, text)      KCODECS_DEPRECATED_VERSION_5_##minor(text)
#define KCODECS_DEPRECATED_VERSION(major, minor, text) KCODECS_DEPRECATED_VERSION_##major(minor, "Since "#major"."#minor". " text)
#define KCODECS_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text) KCODECS_DEPRECATED_VERSION_##major(minor, "Since "#textmajor"."#textminor". " text)
#if defined(__cpp_enumerator_attributes) && __cpp_enumerator_attributes >= 201411
#  define KCODECS_ENUMERATOR_DEPRECATED_VERSION(major, minor, text) KCODECS_DEPRECATED_VERSION(major, minor, text)
#  define KCODECS_ENUMERATOR_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text) KCODECS_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text)
#else
#  define KCODECS_ENUMERATOR_DEPRECATED_VERSION(major, minor, text)
#  define KCODECS_ENUMERATOR_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text)
#endif

#endif /* KCODECS_EXPORT_H */
