'''OpenGL extension NV.query_resource

This module customises the behaviour of the 
OpenGL.raw.GL.NV.query_resource to provide a more 
Python-friendly API

Overview (from the spec)
	
	OpenGL implementations manage the residence of textures, shaders, and
	other graphical objects in GPU accessible memory (whether in on-board
	video memory or addressable system memory is implementation dependent).
	With more insight into OpenGL's memory usage 1) applications could make
	educated decisions on better utilizing the limited GPU resources,
	2) users could better optimize their workflow when working with multiple
	tools, and 3) administrators can make better decisions regarding resource
	allocation and system configurations.
	
	The purpose of this extension is to return a more detailed breakdown
	of memory usage in terms of the OpenGL objects residing in memory
	(textures, render buffers, buffer objects, system reserved objects, ...).
	This extension differs from GL_NVX_gpu_memory_info in that this extension
	returns detailed memory usage at the object level for video memory while
	the other extension only reports total vidmem usage.
	
	For the purposes of this specification the term vidmem refers to video
	memory resident on the graphics card that is directly accessible to the
	GPU at the highest performance level.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/NV/query_resource.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GL import _types, _glgets
from OpenGL.raw.GL.NV.query_resource import *
from OpenGL.raw.GL.NV.query_resource import _EXTENSION_NAME

def glInitQueryResourceNV():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )

# INPUT glQueryResourceNV.buffer size not checked against count
glQueryResourceNV=wrapper.wrapper(glQueryResourceNV).setInputArraySize(
    'buffer', None
)
### END AUTOGENERATED SECTION