%feature("docstring") OT::MaximumEntropyOrderStatisticsDistribution
"MaximumEntropyOrderStatistics distribution.

Parameters
----------
coll : sequence of :class:`~openturns.Distribution`
    The marginals, with range verifying :math:`a_i \\leq a_{i+1}` and :math:`b_i \\leq b_{i+1}`.
useApproximation : bool
    Indicates whether the expression :math:`\\Phi_k(t)` is approximated with a polynomials (Hermitte with degree 4 on a discretization determined by a Gauss-Kronrod algorithm applied to :math:`\\Phi_k(t)`).
    By default, the approximation is used.
checkMarginals : bool
    Indicates whether the compatibility tests on the marginals is done.
    By default, the tests are done.

Notes
-----
Its realizations are ordered :math:`X_1 \\leq \\dots \\leq X_n`.

Its probability density function is defined as:

.. math::

    f_X(x) = f_1(x_1) \\prod\\limits_{k=2}^d \\phi_k(x_k) \\exp\\left(-\\int_{x_{k-1}}^{x_k} \\phi_k(s)\\di{s}\\right) \\mathbf{1}_{x_1 \\leq \\dots \\leq x_d}

             \\text{with } \\phi_k(x_k) = \\frac{f_k(x_k)}{F_{k-1}(x_k)-F_k(x_k)}

We note:

.. math::

    \\Phi_k(t) = \\exp\\left(-\\int_{a_{k}}^{t} \\phi_k(s)\\di{s}\\right)

The exponential factor :math:`\\Phi_k(t)` may be expensive to compute for every value
of :math:`t`. It can be replaced by a piecewise Hermite approximation using the
following keys in :class:`~openturns.ResourceMap`:

* 'MaximumEntropyOrderStatisticsDistribution-UseApproximation': if set to *True*, the approximation is built. The default value is *False*;
* 'MaximumEntropyOrderStatisticsDistribution-SupportShift': a shift to avoid the discontinuities in :math:`\\Phi_k(t)`. Its default value is *1e-15*;
* 'MaximumEntropyOrderStatisticsDistribution-ExponentialFactorDiscretization': the maximum size of the adaptive discretization used to detect discontinuities using a 7/15 points Gauss-Kronrod integration method. Default value is *100*, which should give an absolute error of order *1e-8* for the approximation with no subdivision.
* 'MaximumEntropyOrderStatisticsDistribution-MaximumApproximationSubdivision': each interval of the adapted grid is subdivided into a regular grid of this size to improve the accuracy. Default value is *2*, giving an absolute error of order *1e-9*.

The approximation should be used *with caution*. There is no easy quantitative criterion to guide the choice, but either it works with a high degree of precision, or it fails producing negative values for the exponential factor. It occurs when two marginal distributions have almost the same range, eg two uniform distributions with range [0,1] and [0.038, 1.038].

Examples
--------
Create a distribution:

>>> import openturns as ot
>>> coll = [ot.Uniform(-1.0, 1.0), ot.LogUniform(1.0, 1.2), ot.Triangular(3.0, 4.0, 5.0)]
>>> distribution = ot.MaximumEntropyOrderStatisticsDistribution(coll)

Draw a sample:

>>> sample = distribution.getSample(5)"

// ---------------------------------------------------------------------

%feature("docstring") OT::MaximumEntropyOrderStatisticsDistribution::getDistributionCollection
"Accessor to the distribution's collection.

Returns
-------
coll : sequence
    The marginals."

// ---------------------------------------------------------------------

%feature("docstring") OT::MaximumEntropyOrderStatisticsDistribution::setDistributionCollection
"Accessor to the distribution's collection.

Parameters
----------
coll : sequence
    The marginals."

// ---------------------------------------------------------------------

