/*
 * Decompiled with CFR 0.152.
 */
package esecurity.trustloader;

import esecurity.trustloader.SqlLiteClassLoader;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class DBBuilder {
    static String url = "jdbc:sqlite:file:";
    private Connection objConn;
    private boolean debug = false;

    public DBBuilder(String dbname, String dbKey, String dbPassword, boolean debug) throws Exception {
        String driver = "org.sqlite.JDBC";
        Class.forName(driver);
        this.objConn = DriverManager.getConnection(url + dbname + "?cipher=aes128cbc&kdf_iter=1&key=" + dbKey, "sa", dbPassword);
        this.createNewTable(this.objConn);
        String mainifest = "Manifest-Version: 1.0\nCreated-By: SqlLiteClassLoader Utils\n\n";
        this.debug = debug;
        this.insert("META-INF/MANIFEST.MF", mainifest.getBytes());
    }

    private void createNewTable(Connection conn) {
        String sql = "CREATE TABLE IF NOT EXISTS class (\n\tname TEXT PRIMARY KEY, blob BLOB\n);";
        try {
            Statement stmt = conn.createStatement();
            stmt.execute(sql);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insert(String name, byte[] blob) throws Exception {
        String sql = "insert into class values(?,?)";
        try (PreparedStatement stmt = null;){
            stmt = this.objConn.prepareStatement(sql);
            stmt.setString(1, name);
            stmt.setBytes(2, SqlLiteClassLoader.compress(blob));
            stmt.executeUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendToEntry(String name, byte[] blob) throws Exception {
        String sql = "select * from class where name = ?";
        String sql2 = "update class set blob = ? where name = ?";
        PreparedStatement stmt = null;
        Statement stmtInsert = null;
        ResultSet res = null;
        try {
            stmt = this.objConn.prepareStatement(sql);
            stmt.setString(1, name);
            res = stmt.executeQuery();
            if (res.next()) {
                byte[] byteArr = SqlLiteClassLoader.unCompress(res.getBytes("blob"));
                String message = new String(byteArr).trim();
                String append = new String(blob);
                message = message + "\r\n" + append;
                stmtInsert = this.objConn.prepareStatement(sql2);
                stmtInsert.setBytes(1, SqlLiteClassLoader.compress(message.getBytes()));
                stmtInsert.setString(2, name);
                stmtInsert.executeUpdate();
                stmtInsert.close();
                stmtInsert = null;
                res.close();
                res = null;
            }
        }
        catch (SQLException e) {
            if (this.debug) {
                System.out.println("Fails insert -->" + name + " cause by --> " + e.getMessage());
            }
            if (!(name.equals("META-INF/MANIFEST.MF") || name.equals("META-INF/MANIFEST.MF") || name.equals("META-INF/NOTICE"))) {
                this.appendToEntry(name, blob);
            }
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
            if (stmtInsert != null) {
                stmtInsert.close();
            }
            if (res != null) {
                res.close();
            }
        }
    }

    public void addJar(String jar) throws SQLException {
        this.objConn.createStatement().execute("VACUUM");
        try {
            ZipEntry ze;
            ZipInputStream is = new ZipInputStream(new FileInputStream(jar));
            while ((ze = is.getNextEntry()) != null) {
                String name = ze.getName();
                if (ze.isDirectory()) continue;
                this.insertEntry(name, is);
            }
            is.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void insertEntry(String name, InputStream is) throws Exception {
        int len;
        byte[] buffer = new byte[1024];
        byte[] buf = new byte[4096];
        ByteArrayOutputStream fos = new ByteArrayOutputStream();
        while ((len = is.read(buffer)) > 0) {
            fos.write(buffer, 0, len);
        }
        fos.close();
        boolean opzionale = name.startsWith("META-INF") && (name.endsWith(".SF") || name.endsWith(".DSA") || name.endsWith("LICENSE") || name.endsWith("DEPENDENCIES") || name.endsWith("LICENSE.txt") || name.endsWith("NOTICE.txt") || name.endsWith("NOTICE") || name.endsWith("MANIFEST.MF"));
        opzionale = opzionale || name.equals("about.html");
        boolean bl = opzionale = opzionale || name.equals("version.properties");
        if (!opzionale) {
            this.insert(name, fos.toByteArray());
        }
    }

    public void vacuum() throws SQLException {
        this.objConn.createStatement().execute("VACUUM");
    }

    public void close() throws SQLException {
        this.objConn.close();
    }
}

