/*
 * This file is part of the Vamsas Client version 0.2. 
 * Copyright 2010 by Jim Procter, Iain Milne, Pierre Marguerite, 
 *  Andrew Waterhouse and Dominik Lindner.
 * 
 * Earlier versions have also been incorporated into Jalview version 2.4 
 * since 2008, and TOPALi version 2 since 2007.
 * 
 * The Vamsas Client is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *  
 * The Vamsas Client is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with the Vamsas Client.  If not, see <http://www.gnu.org/licenses/>.
 */
package uk.ac.vamsas.test.objects;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import uk.ac.vamsas.objects.core.*;
import uk.ac.vamsas.objects.utils.*;
import uk.ac.vamsas.objects.utils.document.*;
import uk.ac.vamsas.test.simpleclient.ArchiveReports;

/**
 * @author jim test XSD-Java binding classes in uk.ac.vamsas.objects.core
 */
public class Core {
  static Log log = LogFactory.getLog(Core.class);

  /**
   * 
   * complete any automatically completable entries in the dataset
   * 
   * @param ds
   */
  public static String user = "uk.ac.vamsas.test.objects.Core";

  public static void complete(DataSet ds) {
    Sequence[] q = ds.getSequence();
    for (int i = 0, j = q.length; i < j; i++) {
      q[i].setStart(i + 1);
      q[i].setEnd(q[i].getSequence().length() + i + 1);
    }
  }

  public static VAMSAS getDemoVamsas() {
    VAMSAS v = new VAMSAS();
    DataSet ds = new DataSet();
    ds.addSequence(Seq.newSequence("Dummy1", "ASDFLEQ",
        SymbolDictionary.STANDARD_AA, 5, 11));
    ds.addSequence(Seq.newSequence("Dummy2", "ASFLEQ",
        SymbolDictionary.STANDARD_AA, 5, 10));
    ds.addSequence(Seq.newSequence("Dummy3", "ADFEQ",
        SymbolDictionary.STANDARD_AA, 3, 7));
    ds.setProvenance(ProvenanceStuff.newProvenance(user,
        "constructed some dummy sequences"));
    complete(ds);
    v.addDataSet(ds);
    Alignment al = new Alignment();
    al.setProvenance(ProvenanceStuff.newProvenance(user,
        "Created dummy alignment"));
    // rely on newAlignmentSequence to set start/end correctly
    al.addAlignmentSequence(Seq.newAlignmentSequence("Aligned1", "ASDFLEQ", ds
        .getSequence(0), -1, -1));
    al.addAlignmentSequence(Seq.newAlignmentSequence("Aligned2", "AS-FLEQ", ds
        .getSequence(1), -1, -1));
    al.addAlignmentSequence(Seq.newAlignmentSequence("Aligned3", "A-DF-EQ", ds
        .getSequence(2), -1, -1));
    al.setGapChar("-");
    ds.addAlignment(al);
    // TODO: create annotations
    // TODO: create tree
    return v;
  }

  /**
   * @param args
   */
  public static void main(String[] args) {

    /**
     * test constants and controlled vocab utils
     */
    System.out.println("VersionEntries.compare(invalid, ALPHA) returned "
        + VersionEntries.compare("invalid", VersionEntries.ALPHA_VERSION));
    System.out.println("VersionEntries.compare(ALPHA, invalid) returned "
        + VersionEntries.compare(VersionEntries.ALPHA_VERSION, "invalid"));
    System.out.println("VersionEntries.compare(BETA, ALPHA) returned "
        + VersionEntries.compare(VersionEntries.BETA_VERSION,
            VersionEntries.ALPHA_VERSION));
    System.out.println("VersionEntries.compare(ALPHA, BETA) returned "
        + VersionEntries.compare(VersionEntries.ALPHA_VERSION,
            VersionEntries.BETA_VERSION));
    System.out.println("VersionEntries.compare(ALPHA, ALPHA) returned "
        + VersionEntries.compare(VersionEntries.ALPHA_VERSION,
            VersionEntries.ALPHA_VERSION));
    System.out.println("VersionEntries.compare(invalid, invalid) returned "
        + VersionEntries.compare("invalid", "invalid"));
    System.out.println("VersionEntries.latestVersion()="
        + VersionEntries.latestVersion() + ", dict_aa="
        + SymbolDictionary.STANDARD_AA + ", dict_na="
        + SymbolDictionary.STANDARD_NA);
    /**
     * Test utils and autogenerated Vobject interfaces
     */

    VamsasDocument doc = DocumentStuff.newVamsasDocument(
        new VAMSAS[] { getDemoVamsas() }, ProvenanceStuff.newProvenance(
            "org.vamsas.objects.test.Core", "Created demo vamsasDocument"),
        VersionEntries.latestVersion());
    ArchiveReports.reportDocument(doc, null, true, System.out);
  }
}
