/*
 * Decompiled with CFR 0.152.
 */
package sun.net.httpserver;

import com.sun.net.httpserver.Filter;
import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpContext;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import com.sun.net.httpserver.HttpsConfigurator;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import sun.net.httpserver.Code;
import sun.net.httpserver.ContextList;
import sun.net.httpserver.Event;
import sun.net.httpserver.ExchangeImpl;
import sun.net.httpserver.HttpConnection;
import sun.net.httpserver.HttpContextImpl;
import sun.net.httpserver.HttpError;
import sun.net.httpserver.HttpExchangeImpl;
import sun.net.httpserver.HttpsExchangeImpl;
import sun.net.httpserver.LeftOverInputStream;
import sun.net.httpserver.Request;
import sun.net.httpserver.SSLStreams;
import sun.net.httpserver.ServerConfig;
import sun.net.httpserver.TimeSource;
import sun.net.httpserver.WriteFinishedEvent;

class ServerImpl
implements TimeSource {
    private String protocol;
    private boolean https;
    private Executor executor;
    private HttpsConfigurator httpsConfig;
    private SSLContext sslContext;
    private ContextList contexts;
    private InetSocketAddress address;
    private ServerSocketChannel schan;
    private Selector selector;
    private SelectionKey listenerKey;
    private Set<HttpConnection> idleConnections;
    private Set<HttpConnection> allConnections;
    private List<Event> events;
    private Object lolock = new Object();
    private volatile boolean finished = false;
    private volatile boolean terminating = false;
    private boolean bound = false;
    private boolean started = false;
    private volatile long time;
    private volatile long ticks;
    private HttpServer wrapper;
    static final int CLOCK_TICK = ServerConfig.getClockTick();
    static final long IDLE_INTERVAL = ServerConfig.getIdleInterval();
    static final int MAX_IDLE_CONNECTIONS = ServerConfig.getMaxIdleConnections();
    private Timer timer;
    private Logger logger;
    Dispatcher dispatcher;
    static boolean debug = ServerConfig.debugEnabled();
    private int exchangeCount = 0;

    ServerImpl(HttpServer httpServer, String string, InetSocketAddress inetSocketAddress, int n) throws IOException {
        this.protocol = string;
        this.wrapper = httpServer;
        this.logger = Logger.getLogger("com.sun.net.httpserver");
        this.https = string.equalsIgnoreCase("https");
        this.address = inetSocketAddress;
        this.contexts = new ContextList();
        this.schan = ServerSocketChannel.open();
        if (inetSocketAddress != null) {
            ServerSocket serverSocket = this.schan.socket();
            serverSocket.bind(inetSocketAddress, n);
            this.bound = true;
        }
        this.selector = Selector.open();
        this.schan.configureBlocking(false);
        this.listenerKey = this.schan.register(this.selector, 16);
        this.dispatcher = new Dispatcher();
        this.idleConnections = Collections.synchronizedSet(new HashSet());
        this.allConnections = Collections.synchronizedSet(new HashSet());
        this.time = System.currentTimeMillis();
        this.timer = new Timer("server-timer", true);
        this.timer.schedule((TimerTask)new ServerTimerTask(), CLOCK_TICK, (long)CLOCK_TICK);
        this.events = new LinkedList<Event>();
        this.logger.config("HttpServer created " + string + " " + inetSocketAddress);
    }

    public void bind(InetSocketAddress inetSocketAddress, int n) throws IOException {
        if (this.bound) {
            throw new BindException("HttpServer already bound");
        }
        if (inetSocketAddress == null) {
            throw new NullPointerException("null address");
        }
        ServerSocket serverSocket = this.schan.socket();
        serverSocket.bind(inetSocketAddress, n);
        this.bound = true;
    }

    public void start() {
        if (!this.bound || this.started || this.finished) {
            throw new IllegalStateException("server in wrong state");
        }
        if (this.executor == null) {
            this.executor = new DefaultExecutor();
        }
        Thread thread = new Thread(this.dispatcher);
        this.started = true;
        thread.start();
    }

    public void setExecutor(Executor executor) {
        if (this.started) {
            throw new IllegalStateException("server already started");
        }
        this.executor = executor;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public void setHttpsConfigurator(HttpsConfigurator httpsConfigurator) {
        if (httpsConfigurator == null) {
            throw new NullPointerException("null HttpsConfigurator");
        }
        if (this.started) {
            throw new IllegalStateException("server already started");
        }
        this.httpsConfig = httpsConfigurator;
        this.sslContext = httpsConfigurator.getSSLContext();
    }

    public HttpsConfigurator getHttpsConfigurator() {
        return this.httpsConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("negative delay parameter");
        }
        this.terminating = true;
        try {
            this.schan.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.selector.wakeup();
        long l = System.currentTimeMillis() + (long)(n * 1000);
        while (System.currentTimeMillis() < l) {
            this.delay();
            if (!this.finished) continue;
        }
        this.finished = true;
        this.selector.wakeup();
        Set<HttpConnection> set = this.allConnections;
        synchronized (set) {
            for (HttpConnection httpConnection : this.allConnections) {
                httpConnection.close();
            }
        }
        this.allConnections.clear();
        this.idleConnections.clear();
        this.timer.cancel();
    }

    public synchronized HttpContextImpl createContext(String string, HttpHandler httpHandler) {
        if (httpHandler == null || string == null) {
            throw new NullPointerException("null handler, or path parameter");
        }
        HttpContextImpl httpContextImpl = new HttpContextImpl(this.protocol, string, httpHandler, this);
        this.contexts.add(httpContextImpl);
        this.logger.config("context created: " + string);
        return httpContextImpl;
    }

    public synchronized HttpContextImpl createContext(String string) {
        if (string == null) {
            throw new NullPointerException("null path parameter");
        }
        HttpContextImpl httpContextImpl = new HttpContextImpl(this.protocol, string, null, this);
        this.contexts.add(httpContextImpl);
        this.logger.config("context created: " + string);
        return httpContextImpl;
    }

    public synchronized void removeContext(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new NullPointerException("null path parameter");
        }
        this.contexts.remove(this.protocol, string);
        this.logger.config("context removed: " + string);
    }

    public synchronized void removeContext(HttpContext httpContext) throws IllegalArgumentException {
        if (!(httpContext instanceof HttpContextImpl)) {
            throw new IllegalArgumentException("wrong HttpContext type");
        }
        this.contexts.remove((HttpContextImpl)httpContext);
        this.logger.config("context removed: " + httpContext.getPath());
    }

    public InetSocketAddress getAddress() {
        return (InetSocketAddress)this.schan.socket().getLocalSocketAddress();
    }

    Selector getSelector() {
        return this.selector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addEvent(Event event) {
        Object object = this.lolock;
        synchronized (object) {
            this.events.add(event);
            this.selector.wakeup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int resultSize() {
        Object object = this.lolock;
        synchronized (object) {
            return this.events.size();
        }
    }

    static synchronized void dprint(String string) {
        if (debug) {
            System.out.println(string);
        }
    }

    static synchronized void dprint(Exception exception) {
        if (debug) {
            System.out.println(exception);
            exception.printStackTrace();
        }
    }

    Logger getLogger() {
        return this.logger;
    }

    void logReply(int n, String string, String string2) {
        if (string2 == null) {
            string2 = "";
        }
        String string3 = string + " [" + n + " " + Code.msg(n) + "] (" + string2 + ")";
        this.logger.fine(string3);
    }

    long getTicks() {
        return this.ticks;
    }

    public long getTime() {
        return this.time;
    }

    void delay() {
        Thread.yield();
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    synchronized void startExchange() {
        ++this.exchangeCount;
    }

    synchronized int endExchange() {
        --this.exchangeCount;
        assert (this.exchangeCount >= 0);
        return this.exchangeCount;
    }

    HttpServer getWrapper() {
        return this.wrapper;
    }

    class ServerTimerTask
    extends TimerTask {
        ServerTimerTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            LinkedList<HttpConnection> linkedList = new LinkedList<HttpConnection>();
            ServerImpl.this.time = System.currentTimeMillis();
            ServerImpl.this.ticks++;
            Set set = ServerImpl.this.idleConnections;
            synchronized (set) {
                for (HttpConnection httpConnection : ServerImpl.this.idleConnections) {
                    if (httpConnection.time > ServerImpl.this.time) continue;
                    linkedList.add(httpConnection);
                }
                for (HttpConnection httpConnection : linkedList) {
                    ServerImpl.this.idleConnections.remove(httpConnection);
                    ServerImpl.this.allConnections.remove(httpConnection);
                    httpConnection.close();
                }
            }
        }
    }

    class Exchange
    implements Runnable {
        SocketChannel chan;
        HttpConnection connection;
        HttpContextImpl context;
        InputStream rawin;
        OutputStream rawout;
        String protocol;
        ExchangeImpl tx;
        HttpContextImpl ctx;
        boolean rejected = false;

        Exchange(SocketChannel socketChannel, String string, HttpConnection httpConnection) throws IOException {
            this.chan = socketChannel;
            this.connection = httpConnection;
            this.protocol = string;
        }

        public void run() {
            this.context = this.connection.getHttpContext();
            SSLEngine sSLEngine = null;
            String string = null;
            SSLStreams sSLStreams = null;
            try {
                String string2;
                Object object;
                boolean bl;
                if (this.context != null) {
                    this.rawin = this.connection.getInputStream();
                    this.rawout = this.connection.getRawOutputStream();
                    bl = false;
                } else {
                    bl = true;
                    if (ServerImpl.this.https) {
                        if (ServerImpl.this.sslContext == null) {
                            ServerImpl.this.logger.warning("SSL connection received. No https contxt created");
                            throw new HttpError("No SSL context established");
                        }
                        sSLStreams = new SSLStreams(ServerImpl.this, ServerImpl.this.sslContext, this.chan);
                        this.rawin = sSLStreams.getInputStream();
                        this.rawout = sSLStreams.getOutputStream();
                        sSLEngine = sSLStreams.getSSLEngine();
                    } else {
                        this.rawin = new BufferedInputStream(new Request.ReadStream(ServerImpl.this, this.chan));
                        this.rawout = new Request.WriteStream(ServerImpl.this, this.chan);
                    }
                }
                Request request = new Request(this.rawin, this.rawout);
                string = request.requestLine();
                if (string == null) {
                    this.connection.close();
                    return;
                }
                int n = string.indexOf(32);
                if (n == -1) {
                    this.reject(400, string, "Bad request line");
                    return;
                }
                String string3 = string.substring(0, n);
                int n2 = n + 1;
                if ((n = string.indexOf(32, n2)) == -1) {
                    this.reject(400, string, "Bad request line");
                    return;
                }
                String string4 = string.substring(n2, n);
                URI uRI = new URI(string4);
                n2 = n + 1;
                String string5 = string.substring(n2);
                Headers headers = request.headers();
                String string6 = headers.getFirst("Transfer-encoding");
                int n3 = 0;
                if (string6 != null && string6.equalsIgnoreCase("chunked")) {
                    n3 = -1;
                } else {
                    string6 = headers.getFirst("Content-Length");
                    if (string6 != null) {
                        n3 = Integer.parseInt(string6);
                    }
                }
                this.ctx = ServerImpl.this.contexts.findContext(this.protocol, uRI.getPath());
                if (this.ctx == null) {
                    this.reject(404, string, "No context found for request");
                    return;
                }
                this.connection.setContext(this.ctx);
                if (this.ctx.getHandler() == null) {
                    this.reject(500, string, "No handler for context");
                    return;
                }
                this.tx = new ExchangeImpl(string3, uRI, request, n3, this.connection);
                String string7 = headers.getFirst("Connection");
                Headers headers2 = this.tx.getResponseHeaders();
                if (string7 != null && string7.equalsIgnoreCase("close")) {
                    this.tx.close = true;
                }
                if (string5.equalsIgnoreCase("http/1.0")) {
                    this.tx.http10 = true;
                    if (string7 == null) {
                        this.tx.close = true;
                        headers2.set("Connection", "close");
                    } else if (string7.equalsIgnoreCase("keep-alive")) {
                        headers2.set("Connection", "keep-alive");
                        int n4 = (int)ServerConfig.getIdleInterval() / 1000;
                        int n5 = ServerConfig.getMaxIdleConnections();
                        object = "timeout=" + n4 + ", max=" + n5;
                        headers2.set("Keep-Alive", (String)object);
                    }
                }
                if (bl) {
                    this.connection.setParameters(this.rawin, this.rawout, this.chan, sSLEngine, sSLStreams, ServerImpl.this.sslContext, this.protocol, this.ctx, this.rawin);
                }
                if ((string2 = headers.getFirst("Expect")) != null && string2.equalsIgnoreCase("100-continue")) {
                    ServerImpl.this.logReply(100, string, null);
                    this.sendReply(100, false, null);
                }
                List<Filter> list = this.ctx.getSystemFilters();
                object = this.ctx.getFilters();
                Filter.Chain chain = new Filter.Chain(list, this.ctx.getHandler());
                Filter.Chain chain2 = new Filter.Chain((List<Filter>)object, new LinkHandler(chain));
                this.tx.getRequestBody();
                this.tx.getResponseBody();
                if (ServerImpl.this.https) {
                    chain2.doFilter(new HttpsExchangeImpl(this.tx));
                } else {
                    chain2.doFilter(new HttpExchangeImpl(this.tx));
                }
            }
            catch (IOException iOException) {
                ServerImpl.this.logger.log(Level.FINER, "ServerImpl.Exchange (1)", iOException);
                this.connection.close();
            }
            catch (NumberFormatException numberFormatException) {
                this.reject(400, string, "NumberFormatException thrown");
            }
            catch (URISyntaxException uRISyntaxException) {
                this.reject(400, string, "URISyntaxException thrown");
            }
            catch (Exception exception) {
                ServerImpl.this.logger.log(Level.FINER, "ServerImpl.Exchange (2)", exception);
                this.connection.close();
            }
        }

        void reject(int n, String string, String string2) {
            this.rejected = true;
            ServerImpl.this.logReply(n, string, string2);
            this.sendReply(n, true, "<h1>" + n + Code.msg(n) + "</h1>" + string2);
        }

        void sendReply(int n, boolean bl, String string) {
            try {
                String string2 = "HTTP/1.1 " + n + Code.msg(n) + "\r\n";
                if (string != null && string.length() != 0) {
                    string2 = string2 + "Content-Length: " + string.length() + "\r\n";
                    string2 = string2 + "Content-Type: text/html\r\n";
                } else {
                    string2 = string2 + "Content-Length: 0\r\n";
                    string = "";
                }
                if (bl) {
                    string2 = string2 + "Connection: close\r\n";
                }
                string2 = string2 + "\r\n" + string;
                byte[] byArray = string2.getBytes("ISO8859_1");
                this.rawout.write(byArray);
                this.rawout.flush();
                if (bl) {
                    this.connection.close();
                }
            }
            catch (IOException iOException) {
                ServerImpl.this.logger.log(Level.FINER, "ServerImpl.sendReply", iOException);
                this.connection.close();
            }
        }

        class LinkHandler
        implements HttpHandler {
            Filter.Chain nextChain;

            LinkHandler(Filter.Chain chain) {
                this.nextChain = chain;
            }

            public void handle(HttpExchange httpExchange) throws IOException {
                this.nextChain.doFilter(httpExchange);
            }
        }
    }

    class Dispatcher
    implements Runnable {
        Dispatcher() {
        }

        private void handleEvent(Event event) {
            ExchangeImpl exchangeImpl = event.exchange;
            HttpConnection httpConnection = exchangeImpl.getConnection();
            try {
                if (event instanceof WriteFinishedEvent) {
                    int n = ServerImpl.this.endExchange();
                    if (ServerImpl.this.terminating && n == 0) {
                        ServerImpl.this.finished = true;
                    }
                    SocketChannel socketChannel = httpConnection.getChannel();
                    LeftOverInputStream leftOverInputStream = exchangeImpl.getOriginalInputStream();
                    if (!leftOverInputStream.isEOF()) {
                        exchangeImpl.close = true;
                    }
                    if (exchangeImpl.close || ServerImpl.this.idleConnections.size() >= MAX_IDLE_CONNECTIONS) {
                        httpConnection.close();
                        ServerImpl.this.allConnections.remove(httpConnection);
                    } else if (leftOverInputStream.isDataBuffered()) {
                        this.handle(httpConnection.getChannel(), httpConnection);
                    } else {
                        SelectionKey selectionKey = httpConnection.getSelectionKey();
                        if (selectionKey.isValid()) {
                            selectionKey.interestOps(selectionKey.interestOps() | 1);
                        }
                        httpConnection.time = ServerImpl.this.getTime() + IDLE_INTERVAL;
                        ServerImpl.this.idleConnections.add(httpConnection);
                    }
                }
            }
            catch (IOException iOException) {
                ServerImpl.this.logger.log(Level.FINER, "Dispatcher (1)", iOException);
                httpConnection.close();
            }
        }

        public void run() {
            try {
                this.run1();
            }
            catch (Exception exception) {
                ServerImpl.this.logger.log(Level.FINE, "Dispatcher (7)", exception);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run1() {
            while (!ServerImpl.this.finished) {
                try {
                    Object object;
                    Iterator<SelectionKey> iterator;
                    while (ServerImpl.this.resultSize() > 0) {
                        iterator = ServerImpl.this.lolock;
                        synchronized (iterator) {
                            object = (Event)ServerImpl.this.events.remove(0);
                            this.handleEvent((Event)object);
                        }
                    }
                    ServerImpl.this.selector.select(1000L);
                    object = ServerImpl.this.selector.selectedKeys();
                    iterator = object.iterator();
                    while (iterator.hasNext()) {
                        HttpConnection httpConnection;
                        Object object2;
                        SelectionKey selectionKey = iterator.next();
                        iterator.remove();
                        if (selectionKey.equals(ServerImpl.this.listenerKey)) {
                            SocketChannel socketChannel;
                            if (ServerImpl.this.terminating || (socketChannel = ServerImpl.this.schan.accept()) == null) continue;
                            socketChannel.configureBlocking(false);
                            object2 = socketChannel.register(ServerImpl.this.selector, 1);
                            httpConnection = new HttpConnection();
                            httpConnection.selectionKey = object2;
                            httpConnection.setChannel(socketChannel);
                            ((SelectionKey)object2).attach(httpConnection);
                            ServerImpl.this.allConnections.add(httpConnection);
                            continue;
                        }
                        try {
                            if (selectionKey.isReadable()) {
                                object2 = (SocketChannel)selectionKey.channel();
                                httpConnection = (HttpConnection)selectionKey.attachment();
                                selectionKey.interestOps(0);
                                this.handle((SocketChannel)object2, httpConnection);
                                continue;
                            }
                            assert (false);
                        }
                        catch (IOException iOException) {
                            object2 = (HttpConnection)selectionKey.attachment();
                            ServerImpl.this.logger.log(Level.FINER, "Dispatcher (2)", iOException);
                            ((HttpConnection)object2).close();
                        }
                    }
                }
                catch (CancelledKeyException cancelledKeyException) {
                    ServerImpl.this.logger.log(Level.FINER, "Dispatcher (3)", cancelledKeyException);
                }
                catch (IOException iOException) {
                    ServerImpl.this.logger.log(Level.FINER, "Dispatcher (4)", iOException);
                }
            }
        }

        public void handle(SocketChannel socketChannel, HttpConnection httpConnection) throws IOException {
            try {
                Exchange exchange = new Exchange(socketChannel, ServerImpl.this.protocol, httpConnection);
                ServerImpl.this.executor.execute(exchange);
            }
            catch (HttpError httpError) {
                ServerImpl.this.logger.log(Level.FINER, "Dispatcher (5)", httpError);
                httpConnection.close();
            }
            catch (IOException iOException) {
                ServerImpl.this.logger.log(Level.FINER, "Dispatcher (6)", iOException);
                httpConnection.close();
            }
        }
    }

    private static class DefaultExecutor
    implements Executor {
        private DefaultExecutor() {
        }

        public void execute(Runnable runnable) {
            runnable.run();
        }
    }
}

