/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.rdbms.schema;

import java.sql.SQLException;
import org.openrdf.sail.rdbms.schema.IdSequence;
import org.openrdf.sail.rdbms.schema.ValueTable;

public class LiteralTable {
    public static final boolean ONLY_INSERT_LABEL = false;
    private ValueTable labels;
    private ValueTable longLabels;
    private ValueTable languages;
    private ValueTable datatypes;
    private ValueTable numeric;
    private ValueTable dateTime;
    private int version;
    private IdSequence ids;

    public void setIdSequence(IdSequence ids) {
        this.ids = ids;
    }

    public ValueTable getLabelTable() {
        return this.labels;
    }

    public void setLabelTable(ValueTable labels) {
        this.labels = labels;
    }

    public ValueTable getLongLabelTable() {
        return this.longLabels;
    }

    public void setLongLabelTable(ValueTable longLabels) {
        this.longLabels = longLabels;
    }

    public ValueTable getLanguageTable() {
        return this.languages;
    }

    public void setLanguageTable(ValueTable languages) {
        this.languages = languages;
    }

    public ValueTable getDatatypeTable() {
        return this.datatypes;
    }

    public void setDatatypeTable(ValueTable datatypes) {
        this.datatypes = datatypes;
    }

    public ValueTable getNumericTable() {
        return this.numeric;
    }

    public void setNumericTable(ValueTable numeric) {
        this.numeric = numeric;
    }

    public ValueTable getDateTimeTable() {
        return this.dateTime;
    }

    public void setDateTimeTable(ValueTable dateTime) {
        this.dateTime = dateTime;
    }

    public void close() throws SQLException {
        this.labels.close();
        this.longLabels.close();
        this.languages.close();
        this.datatypes.close();
        this.numeric.close();
        this.dateTime.close();
    }

    public int getBatchSize() {
        return this.labels.getBatchSize();
    }

    public int getIdVersion() {
        return this.version;
    }

    public void insertSimple(Number id, String label) throws SQLException, InterruptedException {
        if (this.ids.isLong(id)) {
            this.longLabels.insert(id, label);
        } else {
            this.labels.insert(id, label);
        }
    }

    public void insertLanguage(Number id, String label, String language) throws SQLException, InterruptedException {
        this.insertSimple(id, label);
        this.languages.insert(id, language);
    }

    public void insertDatatype(Number id, String label, String datatype) throws SQLException, InterruptedException {
        this.insertSimple(id, label);
        this.datatypes.insert(id, datatype);
    }

    public void insertNumeric(Number id, String label, String datatype, double value) throws SQLException, InterruptedException {
        this.labels.insert(id, label);
        this.datatypes.insert(id, datatype);
        this.numeric.insert(id, value);
    }

    public void insertDateTime(Number id, String label, String datatype, long value) throws SQLException, InterruptedException {
        this.labels.insert(id, label);
        this.datatypes.insert(id, datatype);
        this.dateTime.insert(id, value);
    }

    public void optimize() throws SQLException {
        this.labels.optimize();
        this.longLabels.optimize();
        this.languages.optimize();
        this.datatypes.optimize();
        this.numeric.optimize();
        this.dateTime.optimize();
    }

    public boolean expunge(String condition) throws SQLException {
        boolean bool = false;
        bool |= this.labels.expunge(condition);
        bool |= this.longLabels.expunge(condition);
        bool |= this.languages.expunge(condition);
        bool |= this.datatypes.expunge(condition);
        bool |= this.numeric.expunge(condition);
        return bool |= this.dateTime.expunge(condition);
    }
}

