/* plugin.c generated by valac 0.16.1, the Vala compiler
 * generated from plugin.vala, do not modify */

/*
 * Copyright (C) 2009-2012 Michael 'Mickey' Lauer <mlauer@vanille-media.de>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <fsobasics.h>
#include <freesmartphone.h>
#include <fsoframework.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>
#include <sys/types.h>
#include <errno.h>
#include <unistd.h>
#include <time.h>
#include <sys/ioctl.h>
#include <linux/rtc.h>
#include <gio/gio.h>


#define KERNEL26_TYPE_RTC (kernel26_rtc_get_type ())
#define KERNEL26_RTC(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KERNEL26_TYPE_RTC, Kernel26Rtc))
#define KERNEL26_RTC_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KERNEL26_TYPE_RTC, Kernel26RtcClass))
#define KERNEL26_IS_RTC(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KERNEL26_TYPE_RTC))
#define KERNEL26_IS_RTC_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KERNEL26_TYPE_RTC))
#define KERNEL26_RTC_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KERNEL26_TYPE_RTC, Kernel26RtcClass))

typedef struct _Kernel26Rtc Kernel26Rtc;
typedef struct _Kernel26RtcClass Kernel26RtcClass;
typedef struct _Kernel26RtcPrivate Kernel26RtcPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_io_channel_unref0(var) ((var == NULL) ? NULL : (var = (g_io_channel_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Kernel26RtcGetNameData Kernel26RtcGetNameData;
typedef struct _Kernel26RtcGetCurrentTimeData Kernel26RtcGetCurrentTimeData;
typedef struct _Kernel26RtcSetCurrentTimeData Kernel26RtcSetCurrentTimeData;
typedef struct _Kernel26RtcGetWakeupTimeData Kernel26RtcGetWakeupTimeData;
typedef struct _Kernel26RtcSetWakeupTimeData Kernel26RtcSetWakeupTimeData;
#define _g_dir_close0(var) ((var == NULL) ? NULL : (var = (g_dir_close (var), NULL)))

struct _Kernel26Rtc {
	FsoFrameworkAbstractObject parent_instance;
	Kernel26RtcPrivate * priv;
};

struct _Kernel26RtcClass {
	FsoFrameworkAbstractObjectClass parent_class;
};

struct _Kernel26RtcPrivate {
	FsoFrameworkSubsystem* subsystem;
	gchar* sysfsnode;
	gchar* devnode;
	gint rtc_fd;
	GIOChannel* channel;
	guint watch;
};

struct _Kernel26RtcGetNameData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	Kernel26Rtc* self;
	gchar* result;
	const gchar* _tmp0_;
	gchar* _tmp1_;
};

struct _Kernel26RtcGetCurrentTimeData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	Kernel26Rtc* self;
	gint result;
	gint _tmp0_;
	gint _tmp1_;
	GError * _inner_error_;
};

struct _Kernel26RtcSetCurrentTimeData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	Kernel26Rtc* self;
	gint seconds_since_epoch;
	gint _tmp0_;
	struct tm _tmp1_;
	struct tm t;
	FsoFrameworkLogger* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	struct tm _tmp5_;
	gint _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	gint res;
	gint _tmp11_;
	GError * _inner_error_;
};

struct _Kernel26RtcGetWakeupTimeData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	Kernel26Rtc* self;
	gint result;
	struct rtc_wkalrm _tmp0_;
	struct rtc_wkalrm alarm;
	gint _tmp1_;
	gint _tmp2_;
	gint res;
	gint _tmp3_;
	struct tm _tmp4_;
	struct tm t;
	FsoFrameworkLogger* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	struct rtc_wkalrm _tmp8_;
	gchar _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	struct rtc_wkalrm _tmp12_;
	gchar _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gint _tmp18_;
	struct rtc_wkalrm _tmp19_;
	gchar _tmp20_;
	struct tm _tmp21_;
	time_t _tmp22_;
	GError * _inner_error_;
};

struct _Kernel26RtcSetWakeupTimeData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	Kernel26Rtc* self;
	gint seconds_since_epoch;
	gint _tmp0_;
	gint rtctime;
	gboolean _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gboolean _tmp5_;
	GError* _tmp6_;
	struct rtc_wkalrm _tmp7_;
	struct rtc_wkalrm alarm;
	gint _tmp8_;
	struct tm _tmp9_;
	struct tm t;
	FsoFrameworkLogger* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	struct tm _tmp13_;
	gint _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	struct tm _tmp17_;
	gint _tmp18_;
	struct tm _tmp19_;
	gint _tmp20_;
	struct tm _tmp21_;
	gint _tmp22_;
	struct tm _tmp23_;
	gint _tmp24_;
	struct tm _tmp25_;
	gint _tmp26_;
	struct tm _tmp27_;
	gint _tmp28_;
	gint _tmp29_;
	gint _tmp30_;
	gint _tmp31_;
	gint _tmp32_;
	gint _tmp33_;
	gint res;
	gint _tmp34_;
	struct rtc_wkalrm _tmp35_;
	gchar _tmp36_;
	GIOChannel* _tmp37_;
	gint _tmp38_;
	GIOChannel* _tmp39_;
	GIOChannel* _tmp40_;
	guint _tmp41_;
	gint _tmp42_;
	guint _tmp43_;
	guint _tmp44_;
	GError * _inner_error_;
};


static gpointer kernel26_rtc_parent_class = NULL;
static FreeSmartphoneDeviceRealtimeClockIface* kernel26_rtc_free_smartphone_device_realtime_clock_parent_iface = NULL;
static GType kernel26_rtc_type_id = 0;
extern gchar* sysfs_root;
gchar* sysfs_root = NULL;
extern gchar* sys_class_rtcs;
gchar* sys_class_rtcs = NULL;
extern GList* instances;
GList* instances = NULL;

#define KERNEL26_IOCTL_RTC_RD_TIME ((guint) 0x80247009LL)
#define KERNEL26_IOCTL_RTC_SET_TIME ((guint) 0x4024700a)
#define KERNEL26_IOCTL_RTC_WKALM_RD ((guint) 0x80287010LL)
#define KERNEL26_IOCTL_RTC_WKALM_SET ((guint) 0x4028700f)
GType kernel26_rtc_get_type (void) G_GNUC_CONST;
GType kernel26_rtc_register_type (GTypeModule * module);
#define KERNEL26_RTC_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), KERNEL26_TYPE_RTC, Kernel26RtcPrivate))
enum  {
	KERNEL26_RTC_DUMMY_PROPERTY
};
Kernel26Rtc* kernel26_rtc_new (FsoFrameworkSubsystem* subsystem, const gchar* sysfsnode);
Kernel26Rtc* kernel26_rtc_construct (GType object_type, FsoFrameworkSubsystem* subsystem, const gchar* sysfsnode);
static gchar* kernel26_rtc_real_repr (FsoFrameworkAbstractObject* base);
static void kernel26_rtc_openRtc (Kernel26Rtc* self, GError** error);
static void kernel26_rtc_closeRtc (Kernel26Rtc* self, gboolean raise, GError** error);
static gboolean kernel26_rtc_onInputEvent (Kernel26Rtc* self, GIOChannel* source, GIOCondition condition);
static gint _kernel26_rtc_getCurrentTime (Kernel26Rtc* self, GError** error);
static void kernel26_rtc_get_name_data_free (gpointer _data);
void kernel26_rtc_get_name (Kernel26Rtc* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
gchar* kernel26_rtc_get_name_finish (Kernel26Rtc* self, GAsyncResult* _res_, GError** error);
static gboolean kernel26_rtc_get_name_co (Kernel26RtcGetNameData* _data_);
static void kernel26_rtc_real_get_current_time_data_free (gpointer _data);
static void kernel26_rtc_real_get_current_time (FreeSmartphoneDeviceRealtimeClock* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean kernel26_rtc_real_get_current_time_co (Kernel26RtcGetCurrentTimeData* _data_);
static void kernel26_rtc_real_set_current_time_data_free (gpointer _data);
static void kernel26_rtc_real_set_current_time (FreeSmartphoneDeviceRealtimeClock* base, gint seconds_since_epoch, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean kernel26_rtc_real_set_current_time_co (Kernel26RtcSetCurrentTimeData* _data_);
static void kernel26_rtc_real_get_wakeup_time_data_free (gpointer _data);
static void kernel26_rtc_real_get_wakeup_time (FreeSmartphoneDeviceRealtimeClock* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean kernel26_rtc_real_get_wakeup_time_co (Kernel26RtcGetWakeupTimeData* _data_);
static void kernel26_rtc_real_set_wakeup_time_data_free (gpointer _data);
static void kernel26_rtc_real_set_wakeup_time (FreeSmartphoneDeviceRealtimeClock* base, gint seconds_since_epoch, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean kernel26_rtc_real_set_wakeup_time_co (Kernel26RtcSetWakeupTimeData* _data_);
static gboolean _kernel26_rtc_onInputEvent_gio_func (GIOChannel* source, GIOCondition condition, gpointer self);
static void kernel26_rtc_finalize (GObject* obj);
gchar* fso_factory_function (FsoFrameworkSubsystem* subsystem, GError** error);
void fso_register_function (GTypeModule* module);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		const gchar* _tmp0_;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		GRegex* _tmp3_;
		GRegex* _tmp4_;
		GRegex* regex;
		GRegex* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		_tmp0_ = old;
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		regex = _tmp4_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp5_ = regex;
		_tmp6_ = replacement;
		_tmp7_ = g_regex_replace_literal (_tmp5_, self, (gssize) (-1), 0, _tmp6_, 0, &_inner_error_);
		_tmp8_ = _tmp7_;
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp8_;
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


Kernel26Rtc* kernel26_rtc_construct (GType object_type, FsoFrameworkSubsystem* subsystem, const gchar* sysfsnode) {
	Kernel26Rtc * self = NULL;
	FsoFrameworkSubsystem* _tmp0_;
	FsoFrameworkSubsystem* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_ = NULL;
	FsoFrameworkSubsystem* _tmp6_;
	FsoFrameworkLogger* _tmp7_;
	g_return_val_if_fail (subsystem != NULL, NULL);
	g_return_val_if_fail (sysfsnode != NULL, NULL);
	self = (Kernel26Rtc*) fso_framework_abstract_object_construct (object_type);
	_tmp0_ = subsystem;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->subsystem);
	self->priv->subsystem = _tmp1_;
	_tmp2_ = sysfsnode;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 (self->priv->sysfsnode);
	self->priv->sysfsnode = _tmp3_;
	_tmp4_ = sysfsnode;
	_tmp5_ = string_replace (_tmp4_, "/sys/class/rtc/", "/dev/");
	_g_free0 (self->priv->devnode);
	self->priv->devnode = _tmp5_;
	_tmp6_ = subsystem;
	fso_framework_subsystem_registerObjectForServiceWithPrefix (_tmp6_, FREE_SMARTPHONE_DEVICE_TYPE_REALTIME_CLOCK, (GBoxedCopyFunc) g_object_ref, g_object_unref, FSO_FRAMEWORK_DEVICE_ServiceDBusName, FSO_FRAMEWORK_DEVICE_RtcServicePath, (FreeSmartphoneDeviceRealtimeClock*) self);
	_tmp7_ = ((FsoFrameworkAbstractObject*) self)->logger;
	fso_framework_logger_info (_tmp7_, "Created new Rtc object.");
	return self;
}


Kernel26Rtc* kernel26_rtc_new (FsoFrameworkSubsystem* subsystem, const gchar* sysfsnode) {
	return kernel26_rtc_construct (KERNEL26_TYPE_RTC, subsystem, sysfsnode);
}


static gchar* kernel26_rtc_real_repr (FsoFrameworkAbstractObject* base) {
	Kernel26Rtc * self;
	gchar* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	self = (Kernel26Rtc*) base;
	_tmp0_ = self->priv->sysfsnode;
	_tmp1_ = self->priv->devnode;
	_tmp2_ = g_strdup_printf ("<%s : %s>", _tmp0_, _tmp1_);
	result = _tmp2_;
	return result;
}


static void kernel26_rtc_openRtc (Kernel26Rtc* self, GError** error) {
	GIOChannel* _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->channel;
	if (_tmp0_ == NULL) {
		const gchar* _tmp1_;
		gint _tmp2_ = 0;
		gint _tmp3_;
		_tmp1_ = self->priv->devnode;
		_tmp2_ = open (_tmp1_, O_RDONLY, (mode_t) 0);
		self->priv->rtc_fd = _tmp2_;
		_tmp3_ = self->priv->rtc_fd;
		if (_tmp3_ == (-1)) {
			gint _tmp4_;
			const gchar* _tmp5_ = NULL;
			GError* _tmp6_;
			_tmp4_ = errno;
			_tmp5_ = strerror (_tmp4_);
			_tmp6_ = g_error_new_literal (FREE_SMARTPHONE_ERROR, FREE_SMARTPHONE_ERROR_SYSTEM_ERROR, _tmp5_);
			_inner_error_ = _tmp6_;
			if (_inner_error_->domain == FREE_SMARTPHONE_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	}
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static void kernel26_rtc_closeRtc (Kernel26Rtc* self, gboolean raise, GError** error) {
	gint _tmp0_;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* e;
	gboolean _tmp4_ = FALSE;
	GIOChannel* _tmp5_;
	gboolean _tmp7_;
	gboolean _tmp9_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = errno;
	_tmp1_ = strerror (_tmp0_);
	_tmp2_ = string_to_string (_tmp1_);
	_tmp3_ = g_strdup (_tmp2_);
	e = _tmp3_;
	_tmp5_ = self->priv->channel;
	if (_tmp5_ == NULL) {
		gint _tmp6_;
		_tmp6_ = self->priv->rtc_fd;
		_tmp4_ = _tmp6_ != (-1);
	} else {
		_tmp4_ = FALSE;
	}
	_tmp7_ = _tmp4_;
	if (_tmp7_) {
		gint _tmp8_;
		_tmp8_ = self->priv->rtc_fd;
		close (_tmp8_);
	}
	_tmp9_ = raise;
	if (_tmp9_) {
		const gchar* _tmp10_;
		GError* _tmp11_;
		_tmp10_ = e;
		_tmp11_ = g_error_new_literal (FREE_SMARTPHONE_ERROR, FREE_SMARTPHONE_ERROR_SYSTEM_ERROR, _tmp10_);
		_inner_error_ = _tmp11_;
		if (_inner_error_->domain == FREE_SMARTPHONE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (e);
			return;
		} else {
			_g_free0 (e);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_g_free0 (e);
}


static gboolean kernel26_rtc_onInputEvent (Kernel26Rtc* self, GIOChannel* source, GIOCondition condition) {
	gboolean result = FALSE;
	GIOChannel* _tmp0_;
	GIOChannel* _tmp1_;
	GTimeVal now = {0};
	GTimeVal _tmp18_;
	glong _tmp19_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (source != NULL, FALSE);
	_tmp0_ = source;
	_tmp1_ = self->priv->channel;
	if (_tmp0_ != _tmp1_) {
		FsoFrameworkLogger* _tmp2_;
		_tmp2_ = ((FsoFrameworkAbstractObject*) self)->logger;
		fso_framework_logger_error (_tmp2_, "Bogus onInputEvent for RTC channel");
	} else {
		gchar* _tmp3_ = NULL;
		gchar* buf;
		gint buf_length1;
		gint _buf_size_;
		GIOChannel* _tmp4_;
		gint _tmp5_ = 0;
		gchar* _tmp6_;
		gint _tmp6__length1;
		gssize _tmp7_ = 0L;
		gssize bytesread;
		gssize _tmp8_;
		_tmp3_ = g_new0 (gchar, 1024);
		buf = _tmp3_;
		buf_length1 = 1024;
		_buf_size_ = buf_length1;
		_tmp4_ = source;
		_tmp5_ = g_io_channel_unix_get_fd (_tmp4_);
		_tmp6_ = buf;
		_tmp6__length1 = buf_length1;
		_tmp7_ = read (_tmp5_, _tmp6_, (gsize) 1024);
		bytesread = _tmp7_;
		_tmp8_ = bytesread;
		if (_tmp8_ == ((gssize) 0)) {
			FsoFrameworkLogger* _tmp9_;
			GIOChannel* _tmp10_;
			gint _tmp11_ = 0;
			gchar* _tmp12_ = NULL;
			gchar* _tmp13_;
			_tmp9_ = ((FsoFrameworkAbstractObject*) self)->logger;
			_tmp10_ = source;
			_tmp11_ = g_io_channel_unix_get_fd (_tmp10_);
			_tmp12_ = g_strdup_printf ("Could not read from input device fd %d.", _tmp11_);
			_tmp13_ = _tmp12_;
			fso_framework_logger_warning (_tmp9_, _tmp13_);
			_g_free0 (_tmp13_);
		} else {
			FsoFrameworkLogger* _tmp14_;
			gssize _tmp15_;
			gchar* _tmp16_ = NULL;
			gchar* _tmp17_;
			_tmp14_ = ((FsoFrameworkAbstractObject*) self)->logger;
			_tmp15_ = bytesread;
			_tmp16_ = g_strdup_printf ("Read %d bytes from RTC", (gint) _tmp15_);
			_tmp17_ = _tmp16_;
			fso_framework_logger_debug (_tmp14_, _tmp17_);
			_g_free0 (_tmp17_);
		}
		buf = (g_free (buf), NULL);
	}
	free_smartphone_device_realtime_clock_set_wakeup_time ((FreeSmartphoneDeviceRealtimeClock*) self, 0, NULL, NULL);
	g_get_current_time (&now);
	_tmp18_ = now;
	_tmp19_ = _tmp18_.tv_sec;
	g_signal_emit_by_name ((FreeSmartphoneDeviceRealtimeClock*) self, "alarm", (gint) _tmp19_);
	result = FALSE;
	return result;
}


static gchar* g_time_to_string (struct tm *self) {
	gchar* result = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gchar* _tmp6_ = NULL;
	_tmp0_ = (*self).tm_year;
	_tmp1_ = (*self).tm_mon;
	_tmp2_ = (*self).tm_mday;
	_tmp3_ = (*self).tm_hour;
	_tmp4_ = (*self).tm_min;
	_tmp5_ = (*self).tm_sec;
	_tmp6_ = g_strdup_printf ("%04d-%02d-%02d %02d:%02d:%02d", _tmp0_ + 1900, _tmp1_ + 1, _tmp2_, _tmp3_, _tmp4_, _tmp5_);
	result = _tmp6_;
	return result;
}


static gint _kernel26_rtc_getCurrentTime (Kernel26Rtc* self, GError** error) {
	gint result = 0;
	struct tm _tmp0_ = {0};
	struct tm t;
	gint _tmp1_;
	gint _tmp2_ = 0;
	gint res;
	gint _tmp3_;
	FsoFrameworkLogger* _tmp4_;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	struct tm _tmp9_;
	time_t _tmp10_ = 0;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	kernel26_rtc_openRtc (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == FREE_SMARTPHONE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	t = _tmp0_;
	_tmp1_ = self->priv->rtc_fd;
	_tmp2_ = ioctl (_tmp1_, RTC_RD_TIME, &t);
	res = _tmp2_;
	_tmp3_ = res;
	kernel26_rtc_closeRtc (self, _tmp3_ == (-1), &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == FREE_SMARTPHONE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	_tmp4_ = ((FsoFrameworkAbstractObject*) self)->logger;
	_tmp5_ = g_time_to_string (&t);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strdup_printf ("RTC time equals %s", _tmp6_);
	_tmp8_ = _tmp7_;
	fso_framework_logger_info (_tmp4_, _tmp8_);
	_g_free0 (_tmp8_);
	_g_free0 (_tmp6_);
	_tmp9_ = t;
	_tmp10_ = timegm (&_tmp9_);
	result = (gint) _tmp10_;
	return result;
}


static void kernel26_rtc_get_name_data_free (gpointer _data) {
	Kernel26RtcGetNameData* _data_;
	_data_ = _data;
	_g_free0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (Kernel26RtcGetNameData, _data_);
}


void kernel26_rtc_get_name (Kernel26Rtc* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	Kernel26RtcGetNameData* _data_;
	Kernel26Rtc* _tmp0_;
	_data_ = g_slice_new0 (Kernel26RtcGetNameData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, kernel26_rtc_get_name);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, kernel26_rtc_get_name_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	kernel26_rtc_get_name_co (_data_);
}


gchar* kernel26_rtc_get_name_finish (Kernel26Rtc* self, GAsyncResult* _res_, GError** error) {
	gchar* result;
	Kernel26RtcGetNameData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static gboolean kernel26_rtc_get_name_co (Kernel26RtcGetNameData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->sysfsnode;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = g_path_get_basename (_data_->_tmp0_);
	_data_->result = _data_->_tmp1_;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void kernel26_rtc_real_get_current_time_data_free (gpointer _data) {
	Kernel26RtcGetCurrentTimeData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (Kernel26RtcGetCurrentTimeData, _data_);
}


static void kernel26_rtc_real_get_current_time (FreeSmartphoneDeviceRealtimeClock* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	Kernel26Rtc * self;
	Kernel26RtcGetCurrentTimeData* _data_;
	Kernel26Rtc* _tmp0_;
	self = (Kernel26Rtc*) base;
	_data_ = g_slice_new0 (Kernel26RtcGetCurrentTimeData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, kernel26_rtc_real_get_current_time);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, kernel26_rtc_real_get_current_time_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	kernel26_rtc_real_get_current_time_co (_data_);
}


static gint kernel26_rtc_real_get_current_time_finish (FreeSmartphoneDeviceRealtimeClock* base, GAsyncResult* _res_, GError** error) {
	gint result;
	Kernel26RtcGetCurrentTimeData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return 0;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	return result;
}


static gboolean kernel26_rtc_real_get_current_time_co (Kernel26RtcGetCurrentTimeData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = 0;
	_data_->_tmp0_ = _kernel26_rtc_getCurrentTime (_data_->self, &_data_->_inner_error_);
	_data_->_tmp1_ = _data_->_tmp0_;
	if (_data_->_inner_error_ != NULL) {
		if (((_data_->_inner_error_->domain == FREE_SMARTPHONE_ERROR) || (_data_->_inner_error_->domain == G_DBUS_ERROR)) || (_data_->_inner_error_->domain == G_IO_ERROR)) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	_data_->result = _data_->_tmp1_;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void kernel26_rtc_real_set_current_time_data_free (gpointer _data) {
	Kernel26RtcSetCurrentTimeData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (Kernel26RtcSetCurrentTimeData, _data_);
}


static void kernel26_rtc_real_set_current_time (FreeSmartphoneDeviceRealtimeClock* base, gint seconds_since_epoch, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	Kernel26Rtc * self;
	Kernel26RtcSetCurrentTimeData* _data_;
	Kernel26Rtc* _tmp0_;
	gint _tmp1_;
	self = (Kernel26Rtc*) base;
	_data_ = g_slice_new0 (Kernel26RtcSetCurrentTimeData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, kernel26_rtc_real_set_current_time);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, kernel26_rtc_real_set_current_time_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = seconds_since_epoch;
	_data_->seconds_since_epoch = _tmp1_;
	kernel26_rtc_real_set_current_time_co (_data_);
}


static void kernel26_rtc_real_set_current_time_finish (FreeSmartphoneDeviceRealtimeClock* base, GAsyncResult* _res_, GError** error) {
	Kernel26RtcSetCurrentTimeData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void g_time_gm (time_t time, struct tm* result) {
	struct tm _result_ = {0};
	struct tm _tmp0_ = {0};
	gmtime_r (&time, &_tmp0_);
	_result_ = _tmp0_;
	*result = _result_;
	return;
}


static gboolean kernel26_rtc_real_set_current_time_co (Kernel26RtcSetCurrentTimeData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	kernel26_rtc_openRtc (_data_->self, &_data_->_inner_error_);
	if (_data_->_inner_error_ != NULL) {
		if (((_data_->_inner_error_->domain == FREE_SMARTPHONE_ERROR) || (_data_->_inner_error_->domain == G_DBUS_ERROR)) || (_data_->_inner_error_->domain == G_IO_ERROR)) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	_data_->_tmp0_ = _data_->seconds_since_epoch;
	memset (&_data_->_tmp1_, 0, sizeof (struct tm));
	g_time_gm ((time_t) _data_->_tmp0_, &_data_->_tmp1_);
	_data_->t = _data_->_tmp1_;
	_data_->_tmp2_ = ((FsoFrameworkAbstractObject*) _data_->self)->logger;
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = g_time_to_string (&_data_->t);
	_data_->_tmp4_ = _data_->_tmp3_;
	_data_->_tmp5_ = _data_->t;
	_data_->_tmp6_ = _data_->_tmp5_.tm_isdst;
	_data_->_tmp7_ = NULL;
	_data_->_tmp7_ = g_strdup_printf ("Setting RTC time to %s (dst=%d)", _data_->_tmp4_, _data_->_tmp6_);
	_data_->_tmp8_ = _data_->_tmp7_;
	fso_framework_logger_info (_data_->_tmp2_, _data_->_tmp8_);
	_g_free0 (_data_->_tmp8_);
	_g_free0 (_data_->_tmp4_);
	_data_->_tmp9_ = _data_->self->priv->rtc_fd;
	_data_->_tmp10_ = 0;
	_data_->_tmp10_ = ioctl (_data_->_tmp9_, RTC_SET_TIME, &_data_->t);
	_data_->res = _data_->_tmp10_;
	_data_->_tmp11_ = _data_->res;
	kernel26_rtc_closeRtc (_data_->self, _data_->_tmp11_ == (-1), &_data_->_inner_error_);
	if (_data_->_inner_error_ != NULL) {
		if (((_data_->_inner_error_->domain == FREE_SMARTPHONE_ERROR) || (_data_->_inner_error_->domain == G_DBUS_ERROR)) || (_data_->_inner_error_->domain == G_IO_ERROR)) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void kernel26_rtc_real_get_wakeup_time_data_free (gpointer _data) {
	Kernel26RtcGetWakeupTimeData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (Kernel26RtcGetWakeupTimeData, _data_);
}


static void kernel26_rtc_real_get_wakeup_time (FreeSmartphoneDeviceRealtimeClock* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	Kernel26Rtc * self;
	Kernel26RtcGetWakeupTimeData* _data_;
	Kernel26Rtc* _tmp0_;
	self = (Kernel26Rtc*) base;
	_data_ = g_slice_new0 (Kernel26RtcGetWakeupTimeData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, kernel26_rtc_real_get_wakeup_time);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, kernel26_rtc_real_get_wakeup_time_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	kernel26_rtc_real_get_wakeup_time_co (_data_);
}


static gint kernel26_rtc_real_get_wakeup_time_finish (FreeSmartphoneDeviceRealtimeClock* base, GAsyncResult* _res_, GError** error) {
	gint result;
	Kernel26RtcGetWakeupTimeData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return 0;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	return result;
}


static gchar* bool_to_string (gboolean self) {
	gchar* result = NULL;
	if (self) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("true");
		result = _tmp0_;
		return result;
	} else {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("false");
		result = _tmp1_;
		return result;
	}
}


static gboolean kernel26_rtc_real_get_wakeup_time_co (Kernel26RtcGetWakeupTimeData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	kernel26_rtc_openRtc (_data_->self, &_data_->_inner_error_);
	if (_data_->_inner_error_ != NULL) {
		if (((_data_->_inner_error_->domain == FREE_SMARTPHONE_ERROR) || (_data_->_inner_error_->domain == G_DBUS_ERROR)) || (_data_->_inner_error_->domain == G_IO_ERROR)) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	memset (&_data_->_tmp0_, 0, sizeof (struct rtc_wkalrm));
	_data_->alarm = _data_->_tmp0_;
	_data_->_tmp1_ = _data_->self->priv->rtc_fd;
	_data_->_tmp2_ = 0;
	_data_->_tmp2_ = ioctl (_data_->_tmp1_, RTC_WKALM_RD, &_data_->alarm);
	_data_->res = _data_->_tmp2_;
	_data_->_tmp3_ = _data_->res;
	kernel26_rtc_closeRtc (_data_->self, _data_->_tmp3_ == (-1), &_data_->_inner_error_);
	if (_data_->_inner_error_ != NULL) {
		if (((_data_->_inner_error_->domain == FREE_SMARTPHONE_ERROR) || (_data_->_inner_error_->domain == G_DBUS_ERROR)) || (_data_->_inner_error_->domain == G_IO_ERROR)) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	memset (&_data_->_tmp4_, 0, sizeof (struct tm));
	_data_->t = _data_->_tmp4_;
	memcpy (&_data_->alarm.time, &_data_->t, (gsize) sizeof (struct tm));
	_data_->_tmp5_ = ((FsoFrameworkAbstractObject*) _data_->self)->logger;
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = g_time_to_string (&_data_->t);
	_data_->_tmp7_ = _data_->_tmp6_;
	_data_->_tmp8_ = _data_->alarm;
	_data_->_tmp9_ = _data_->_tmp8_.enabled;
	_data_->_tmp10_ = NULL;
	_data_->_tmp10_ = bool_to_string ((gboolean) _data_->_tmp9_);
	_data_->_tmp11_ = _data_->_tmp10_;
	_data_->_tmp12_ = _data_->alarm;
	_data_->_tmp13_ = _data_->_tmp12_.pending;
	_data_->_tmp14_ = NULL;
	_data_->_tmp14_ = bool_to_string ((gboolean) _data_->_tmp13_);
	_data_->_tmp15_ = _data_->_tmp14_;
	_data_->_tmp16_ = NULL;
	_data_->_tmp16_ = g_strdup_printf ("RTC alarm equals %s. Enabled=%s, Pending=%s", _data_->_tmp7_, _data_->_tmp11_, _data_->_tmp15_);
	_data_->_tmp17_ = _data_->_tmp16_;
	fso_framework_logger_info (_data_->_tmp5_, _data_->_tmp17_);
	_g_free0 (_data_->_tmp17_);
	_g_free0 (_data_->_tmp15_);
	_g_free0 (_data_->_tmp11_);
	_g_free0 (_data_->_tmp7_);
	_data_->_tmp19_ = _data_->alarm;
	_data_->_tmp20_ = _data_->_tmp19_.enabled;
	if (((gint) _data_->_tmp20_) == 1) {
		_data_->_tmp21_ = _data_->t;
		_data_->_tmp22_ = 0;
		_data_->_tmp22_ = timegm (&_data_->_tmp21_);
		_data_->_tmp18_ = (gint) _data_->_tmp22_;
	} else {
		_data_->_tmp18_ = 0;
	}
	_data_->result = _data_->_tmp18_;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void kernel26_rtc_real_set_wakeup_time_data_free (gpointer _data) {
	Kernel26RtcSetWakeupTimeData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (Kernel26RtcSetWakeupTimeData, _data_);
}


static void kernel26_rtc_real_set_wakeup_time (FreeSmartphoneDeviceRealtimeClock* base, gint seconds_since_epoch, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	Kernel26Rtc * self;
	Kernel26RtcSetWakeupTimeData* _data_;
	Kernel26Rtc* _tmp0_;
	gint _tmp1_;
	self = (Kernel26Rtc*) base;
	_data_ = g_slice_new0 (Kernel26RtcSetWakeupTimeData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, kernel26_rtc_real_set_wakeup_time);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, kernel26_rtc_real_set_wakeup_time_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = seconds_since_epoch;
	_data_->seconds_since_epoch = _tmp1_;
	kernel26_rtc_real_set_wakeup_time_co (_data_);
}


static void kernel26_rtc_real_set_wakeup_time_finish (FreeSmartphoneDeviceRealtimeClock* base, GAsyncResult* _res_, GError** error) {
	Kernel26RtcSetWakeupTimeData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean _kernel26_rtc_onInputEvent_gio_func (GIOChannel* source, GIOCondition condition, gpointer self) {
	gboolean result;
	result = kernel26_rtc_onInputEvent (self, source, condition);
	return result;
}


static gboolean kernel26_rtc_real_set_wakeup_time_co (Kernel26RtcSetWakeupTimeData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = 0;
	_data_->_tmp0_ = _kernel26_rtc_getCurrentTime (_data_->self, &_data_->_inner_error_);
	_data_->rtctime = _data_->_tmp0_;
	if (_data_->_inner_error_ != NULL) {
		if (((_data_->_inner_error_->domain == FREE_SMARTPHONE_ERROR) || (_data_->_inner_error_->domain == G_DBUS_ERROR)) || (_data_->_inner_error_->domain == G_IO_ERROR)) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	_data_->_tmp2_ = _data_->seconds_since_epoch;
	if (_data_->_tmp2_ > 0) {
		_data_->_tmp3_ = _data_->rtctime;
		_data_->_tmp4_ = _data_->seconds_since_epoch;
		_data_->_tmp1_ = _data_->_tmp3_ >= _data_->_tmp4_;
	} else {
		_data_->_tmp1_ = FALSE;
	}
	_data_->_tmp5_ = _data_->_tmp1_;
	if (_data_->_tmp5_) {
		_data_->_tmp6_ = g_error_new_literal (FREE_SMARTPHONE_ERROR, FREE_SMARTPHONE_ERROR_INVALID_PARAMETER, "RTC Wakeup time not in the future");
		_data_->_inner_error_ = _data_->_tmp6_;
		if (((_data_->_inner_error_->domain == FREE_SMARTPHONE_ERROR) || (_data_->_inner_error_->domain == G_DBUS_ERROR)) || (_data_->_inner_error_->domain == G_IO_ERROR)) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	memset (&_data_->_tmp7_, 0, sizeof (struct rtc_wkalrm));
	_data_->alarm = _data_->_tmp7_;
	_data_->_tmp8_ = _data_->seconds_since_epoch;
	memset (&_data_->_tmp9_, 0, sizeof (struct tm));
	g_time_gm ((time_t) _data_->_tmp8_, &_data_->_tmp9_);
	_data_->t = _data_->_tmp9_;
	_data_->_tmp10_ = ((FsoFrameworkAbstractObject*) _data_->self)->logger;
	_data_->_tmp11_ = NULL;
	_data_->_tmp11_ = g_time_to_string (&_data_->t);
	_data_->_tmp12_ = _data_->_tmp11_;
	_data_->_tmp13_ = _data_->t;
	_data_->_tmp14_ = _data_->_tmp13_.tm_isdst;
	_data_->_tmp15_ = NULL;
	_data_->_tmp15_ = g_strdup_printf ("Setting RTC alarm to %s (dst=%d)", _data_->_tmp12_, _data_->_tmp14_);
	_data_->_tmp16_ = _data_->_tmp15_;
	fso_framework_logger_info (_data_->_tmp10_, _data_->_tmp16_);
	_g_free0 (_data_->_tmp16_);
	_g_free0 (_data_->_tmp12_);
	_data_->_tmp17_ = _data_->t;
	_data_->_tmp18_ = _data_->_tmp17_.tm_sec;
	_data_->alarm.time.tm_sec = _data_->_tmp18_;
	_data_->_tmp19_ = _data_->t;
	_data_->_tmp20_ = _data_->_tmp19_.tm_min;
	_data_->alarm.time.tm_min = _data_->_tmp20_;
	_data_->_tmp21_ = _data_->t;
	_data_->_tmp22_ = _data_->_tmp21_.tm_hour;
	_data_->alarm.time.tm_hour = _data_->_tmp22_;
	_data_->_tmp23_ = _data_->t;
	_data_->_tmp24_ = _data_->_tmp23_.tm_mday;
	_data_->alarm.time.tm_mday = _data_->_tmp24_;
	_data_->_tmp25_ = _data_->t;
	_data_->_tmp26_ = _data_->_tmp25_.tm_mon;
	_data_->alarm.time.tm_mon = _data_->_tmp26_;
	_data_->_tmp27_ = _data_->t;
	_data_->_tmp28_ = _data_->_tmp27_.tm_year;
	_data_->alarm.time.tm_year = _data_->_tmp28_;
	_data_->_tmp30_ = _data_->seconds_since_epoch;
	if (_data_->_tmp30_ > 0) {
		_data_->_tmp29_ = 1;
	} else {
		_data_->_tmp29_ = 0;
	}
	_data_->_tmp31_ = _data_->_tmp29_;
	_data_->alarm.enabled = (gchar) _data_->_tmp31_;
	_data_->alarm.pending = (gchar) 0;
	kernel26_rtc_openRtc (_data_->self, &_data_->_inner_error_);
	if (_data_->_inner_error_ != NULL) {
		if (((_data_->_inner_error_->domain == FREE_SMARTPHONE_ERROR) || (_data_->_inner_error_->domain == G_DBUS_ERROR)) || (_data_->_inner_error_->domain == G_IO_ERROR)) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	_data_->_tmp32_ = _data_->self->priv->rtc_fd;
	_data_->_tmp33_ = 0;
	_data_->_tmp33_ = ioctl (_data_->_tmp32_, RTC_WKALM_SET, &_data_->alarm);
	_data_->res = _data_->_tmp33_;
	_data_->_tmp34_ = _data_->res;
	if (_data_->_tmp34_ == (-1)) {
		kernel26_rtc_closeRtc (_data_->self, TRUE, &_data_->_inner_error_);
		if (_data_->_inner_error_ != NULL) {
			if (((_data_->_inner_error_->domain == FREE_SMARTPHONE_ERROR) || (_data_->_inner_error_->domain == G_DBUS_ERROR)) || (_data_->_inner_error_->domain == G_IO_ERROR)) {
				g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
				g_error_free (_data_->_inner_error_);
				if (_data_->_state_ == 0) {
					g_simple_async_result_complete_in_idle (_data_->_async_result);
				} else {
					g_simple_async_result_complete (_data_->_async_result);
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
				g_clear_error (&_data_->_inner_error_);
				return FALSE;
			}
		}
	}
	_data_->_tmp35_ = _data_->alarm;
	_data_->_tmp36_ = _data_->_tmp35_.enabled;
	if (((gint) _data_->_tmp36_) == 1) {
		_data_->_tmp37_ = _data_->self->priv->channel;
		if (_data_->_tmp37_ == NULL) {
			_data_->_tmp38_ = _data_->self->priv->rtc_fd;
			_data_->_tmp39_ = g_io_channel_unix_new (_data_->_tmp38_);
			_g_io_channel_unref0 (_data_->self->priv->channel);
			_data_->self->priv->channel = _data_->_tmp39_;
			_data_->_tmp40_ = _data_->self->priv->channel;
			_data_->_tmp41_ = 0U;
			_data_->_tmp41_ = g_io_add_watch (_data_->_tmp40_, G_IO_IN, _kernel26_rtc_onInputEvent_gio_func, _data_->self);
			_data_->self->priv->watch = _data_->_tmp41_;
		}
		_data_->_tmp42_ = _data_->seconds_since_epoch;
		g_signal_emit_by_name ((FreeSmartphoneDeviceRealtimeClock*) _data_->self, "wakeup-time-changed", _data_->_tmp42_);
	} else {
		_data_->_tmp43_ = _data_->self->priv->watch;
		if (_data_->_tmp43_ > ((guint) 0)) {
			_data_->_tmp44_ = _data_->self->priv->watch;
			g_source_remove (_data_->_tmp44_);
		}
		_g_io_channel_unref0 (_data_->self->priv->channel);
		_data_->self->priv->channel = NULL;
		kernel26_rtc_closeRtc (_data_->self, FALSE, &_data_->_inner_error_);
		if (_data_->_inner_error_ != NULL) {
			if (((_data_->_inner_error_->domain == FREE_SMARTPHONE_ERROR) || (_data_->_inner_error_->domain == G_DBUS_ERROR)) || (_data_->_inner_error_->domain == G_IO_ERROR)) {
				g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
				g_error_free (_data_->_inner_error_);
				if (_data_->_state_ == 0) {
					g_simple_async_result_complete_in_idle (_data_->_async_result);
				} else {
					g_simple_async_result_complete (_data_->_async_result);
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
				g_clear_error (&_data_->_inner_error_);
				return FALSE;
			}
		}
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void kernel26_rtc_class_init (Kernel26RtcClass * klass) {
	kernel26_rtc_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (Kernel26RtcPrivate));
	FSO_FRAMEWORK_ABSTRACT_OBJECT_CLASS (klass)->repr = kernel26_rtc_real_repr;
	G_OBJECT_CLASS (klass)->finalize = kernel26_rtc_finalize;
}


static void kernel26_rtc_free_smartphone_device_realtime_clock_interface_init (FreeSmartphoneDeviceRealtimeClockIface * iface) {
	kernel26_rtc_free_smartphone_device_realtime_clock_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_current_time = (gint (*)(FreeSmartphoneDeviceRealtimeClock*, GError**)) kernel26_rtc_real_get_current_time;
	iface->get_current_time_finish = kernel26_rtc_real_get_current_time_finish;
	iface->set_current_time = (void (*)(FreeSmartphoneDeviceRealtimeClock*, gint, GError**)) kernel26_rtc_real_set_current_time;
	iface->set_current_time_finish = kernel26_rtc_real_set_current_time_finish;
	iface->get_wakeup_time = (gint (*)(FreeSmartphoneDeviceRealtimeClock*, GError**)) kernel26_rtc_real_get_wakeup_time;
	iface->get_wakeup_time_finish = kernel26_rtc_real_get_wakeup_time_finish;
	iface->set_wakeup_time = (void (*)(FreeSmartphoneDeviceRealtimeClock*, gint, GError**)) kernel26_rtc_real_set_wakeup_time;
	iface->set_wakeup_time_finish = kernel26_rtc_real_set_wakeup_time_finish;
}


static void kernel26_rtc_instance_init (Kernel26Rtc * self) {
	self->priv = KERNEL26_RTC_GET_PRIVATE (self);
	self->priv->rtc_fd = -1;
}


static void kernel26_rtc_finalize (GObject* obj) {
	Kernel26Rtc * self;
	self = KERNEL26_RTC (obj);
	_g_object_unref0 (self->priv->subsystem);
	_g_free0 (self->priv->sysfsnode);
	_g_free0 (self->priv->devnode);
	_g_io_channel_unref0 (self->priv->channel);
	G_OBJECT_CLASS (kernel26_rtc_parent_class)->finalize (obj);
}


/**
 * Implementation of org.freesmartphone.Device.RTC for the Kernel26 Real-Time-Clock interface
 **/
GType kernel26_rtc_get_type (void) {
	return kernel26_rtc_type_id;
}


GType kernel26_rtc_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (Kernel26RtcClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) kernel26_rtc_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Kernel26Rtc), 0, (GInstanceInitFunc) kernel26_rtc_instance_init, NULL };
	static const GInterfaceInfo free_smartphone_device_realtime_clock_info = { (GInterfaceInitFunc) kernel26_rtc_free_smartphone_device_realtime_clock_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	kernel26_rtc_type_id = g_type_module_register_type (module, FSO_FRAMEWORK_TYPE_ABSTRACT_OBJECT, "Kernel26Rtc", &g_define_type_info, 0);
	g_type_module_add_interface (module, kernel26_rtc_type_id, FREE_SMARTPHONE_DEVICE_TYPE_REALTIME_CLOCK, &free_smartphone_device_realtime_clock_info);
	return kernel26_rtc_type_id;
}


/**
 * This function gets called on plugin initialization time.
 * @return the name of your plugin here
 * @note that it needs to be a name in the format <subsystem>.<plugin>
 * else your module will be unloaded immediately.
 **/
gchar* fso_factory_function (FsoFrameworkSubsystem* subsystem, GError** error) {
	gchar* result = NULL;
	FsoFrameworkSmartKeyFile* _tmp0_;
	FsoFrameworkSmartKeyFile* _tmp1_;
	FsoFrameworkSmartKeyFile* config;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_;
	gchar* _tmp4_ = NULL;
	const gchar* _tmp5_;
	GDir* _tmp6_ = NULL;
	GDir* dir;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	gchar* entry;
	gchar* _tmp18_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (subsystem != NULL, NULL);
	_tmp0_ = fso_framework_theConfig;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	config = _tmp1_;
	_tmp2_ = fso_framework_smart_key_file_stringValue (config, "cornucopia", "sysfs_root", "/sys");
	_g_free0 (sysfs_root);
	sysfs_root = _tmp2_;
	_tmp3_ = sysfs_root;
	_tmp4_ = g_strdup_printf ("%s/class/rtc", _tmp3_);
	_g_free0 (sys_class_rtcs);
	sys_class_rtcs = _tmp4_;
	_tmp5_ = sys_class_rtcs;
	_tmp6_ = g_dir_open (_tmp5_, (guint) 0, &_inner_error_);
	dir = _tmp6_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (config);
		return NULL;
	}
	_tmp7_ = g_dir_read_name (dir);
	_tmp8_ = g_strdup (_tmp7_);
	entry = _tmp8_;
	while (TRUE) {
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		gchar* _tmp12_ = NULL;
		gchar* filename;
		FsoFrameworkSubsystem* _tmp13_;
		const gchar* _tmp14_;
		Kernel26Rtc* _tmp15_;
		const gchar* _tmp16_ = NULL;
		gchar* _tmp17_;
		_tmp9_ = entry;
		if (!(_tmp9_ != NULL)) {
			break;
		}
		_tmp10_ = sys_class_rtcs;
		_tmp11_ = entry;
		_tmp12_ = g_build_filename (_tmp10_, _tmp11_, NULL);
		filename = _tmp12_;
		_tmp13_ = subsystem;
		_tmp14_ = filename;
		_tmp15_ = kernel26_rtc_new (_tmp13_, _tmp14_);
		instances = g_list_append (instances, _tmp15_);
		_tmp16_ = g_dir_read_name (dir);
		_tmp17_ = g_strdup (_tmp16_);
		_g_free0 (entry);
		entry = _tmp17_;
		_g_free0 (filename);
	}
	_tmp18_ = g_strdup ("fsodevice.kernel26_rtc");
	result = _tmp18_;
	_g_free0 (entry);
	_g_dir_close0 (dir);
	_g_object_unref0 (config);
	return result;
}


void fso_register_function (GTypeModule* module) {
	FsoFrameworkLogger* _tmp0_;
	g_return_if_fail (module != NULL);
	kernel26_rtc_register_type (module);
	_tmp0_ = fso_framework_theLogger;
	fso_framework_logger_debug (_tmp0_, "fsodevice.kernel26_rtc fso_register_function()");
}



