static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Lens plug-in - adjust for lens distortion                                  \n"
" *                                                                            \n"
" * Copyright (C) 1995 Spencer Kimball and Peter Mattis                        \n"
" * Copyright (C) 2001-2005 David Hodson <hodsond@acm.org>                     \n"
" * Copyright (C) 2008 Aurimas Juška <aurisj@svn.gnome.org>                   \n"
" * Copyright (C) 2011 Robert Sasu <sasu.robert@gmail.com>                     \n"
" * Copyright (C) 2013 Téo Mazars <teo.mazars@ensimag.fr>                     \n"
" *                                                                            \n"
" * Many thanks for Lars Clausen for the original inspiration,                 \n"
" *   useful discussion, optimisation and improvements.                        \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_double (main, _(\"Main\"), 0.0)                                      \n"
"    description (_(\"Amount of second-order distortion\"))                    \n"
"    value_range (-100.0, 100.0)                                               \n"
"                                                                              \n"
"property_double (edge, _(\"Edge\"), 0.0)                                      \n"
"    description (_(\"Amount of fourth-order distortion\"))                    \n"
"    value_range (-100.0, 100.0)                                               \n"
"                                                                              \n"
"property_double (zoom, _(\"Zoom\"), 0.0)                                      \n"
"    description (_(\"Rescale overall image size\"))                           \n"
"    value_range (-100, 100.0)                                                 \n"
"                                                                              \n"
"property_double (x_shift, _(\"Shift X\"), 0.0)                                \n"
"    description (_(\"Effect centre offset in X\"))                            \n"
"    value_range (-100.0, 100.0)                                               \n"
"                                                                              \n"
"property_double (y_shift, _(\"Shift Y\"), 0.0)                                \n"
"    description (_(\"Effect centre offset in Y\"))                            \n"
"    value_range (-100.0, 100.0)                                               \n"
"                                                                              \n"
"property_double (brighten, _(\"Brighten\"), 0.0)                              \n"
"    description (_(\"Adjust brightness in corners\"))                         \n"
"    value_range (-100.0, 100.0)                                               \n"
"                                                                              \n"
"property_color  (background, _(\"Background color\"), \"none\")               \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_FILTER                                                        \n"
"#define GEGL_OP_NAME     lens_distortion                                      \n"
"#define GEGL_OP_C_SOURCE lens-distortion.c                                    \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"#include <math.h>                                                             \n"
"#include <stdio.h>                                                            \n"
"                                                                              \n"
"#define SQR(x) ((x)*(x))                                                      \n"
"                                                                              \n"
"#define MIN3(x,y,z) (MIN (MIN ((x),(y)),(z)))                                 \n"
"                                                                              \n"
"#define MAX3(x,y,z) (MAX (MAX ((x),(y)),(z)))                                 \n"
"                                                                              \n"
"#define MAX_WH     1024                                                       \n"
"#define CHUNK_SIZE 512                                                        \n"
"                                                                              \n"
"                                                                              \n"
"typedef struct                                                                \n"
"{                                                                             \n"
"  gdouble centre_x;                                                           \n"
"  gdouble centre_y;                                                           \n"
"  gdouble mult_sq;                                                            \n"
"  gdouble mult_qd;                                                            \n"
"  gdouble rescale;                                                            \n"
"  gdouble brighten;                                                           \n"
"  gdouble norm;                                                               \n"
"} LensValues;                                                                 \n"
"                                                                              \n"
"                                                                              \n"
"static void                                                                   \n"
"reorder (gdouble *low,                                                        \n"
"         gdouble *high)                                                       \n"
"{                                                                             \n"
"  gdouble temp;                                                               \n"
"                                                                              \n"
"  if (*low < *high) return;                                                   \n"
"                                                                              \n"
"  temp = *low;                                                                \n"
"  *low = *high;                                                               \n"
"  *high = temp;                                                               \n"
"}                                                                             \n"
"                                                                              \n"
"static LensValues                                                             \n"
"lens_setup_calc (GeglProperties *o,                                           \n"
"                 GeglRectangle   boundary)                                    \n"
"{                                                                             \n"
"  LensValues lens;                                                            \n"
"                                                                              \n"
"  lens.norm     = 4.0 / (SQR (boundary.width) + SQR (boundary.height));       \n"
"  lens.centre_x = boundary.width  * (100.0 + o->x_shift) / 200.0;             \n"
"  lens.centre_y = boundary.height * (100.0 + o->y_shift) / 200.0;             \n"
"  lens.mult_sq  = o->main / 200.0;                                            \n"
"  lens.mult_qd  = o->edge / 200.0;                                            \n"
"  lens.rescale  = pow (2.0, - o->zoom / 100.0);                               \n"
"  lens.brighten = - o->brighten / 10.0;                                       \n"
"                                                                              \n"
"  return lens;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"lens_get_source_coord (gdouble     i,                                         \n"
"                       gdouble     j,                                         \n"
"                       gdouble    *x,                                         \n"
"                       gdouble    *y,                                         \n"
"                       gdouble    *mag,                                       \n"
"                       LensValues *lens)                                      \n"
"{                                                                             \n"
"  gdouble radius_sq, off_x, off_y, radius_mult;                               \n"
"                                                                              \n"
"  off_x = i - lens->centre_x;                                                 \n"
"  off_y = j - lens->centre_y;                                                 \n"
"                                                                              \n"
"  radius_sq = SQR (off_x) + SQR (off_y);                                      \n"
"                                                                              \n"
"  radius_sq *= lens->norm;                                                    \n"
"                                                                              \n"
"  radius_mult = radius_sq * lens->mult_sq + SQR (radius_sq) * lens->mult_qd;  \n"
"                                                                              \n"
"  *mag = radius_mult;                                                         \n"
"                                                                              \n"
"  radius_mult = lens->rescale * (1.0 + radius_mult);                          \n"
"                                                                              \n"
"  *x = lens->centre_x + radius_mult * off_x;                                  \n"
"  *y = lens->centre_y + radius_mult * off_y;                                  \n"
"}                                                                             \n"
"                                                                              \n"
"/* FIXME: not 100% bullet proof */                                            \n"
"static GeglRectangle                                                          \n"
"get_required (GeglRectangle       *boundary,                                  \n"
"              const GeglRectangle *roi,                                       \n"
"              GeglOperation       *operation)                                 \n"
"{                                                                             \n"
"                                                                              \n"
"  GeglProperties *o;                                                          \n"
"  GeglRectangle   area;                                                       \n"
"  LensValues      lens;                                                       \n"
"  gdouble         x1, y1, x2, y2, x3, y3, x4, y4, mag;                        \n"
"  gint            x, y, width, height;                                        \n"
"                                                                              \n"
"  o = GEGL_PROPERTIES (operation);                                            \n"
"                                                                              \n"
"  lens = lens_setup_calc (o, *boundary);                                      \n"
"                                                                              \n"
"  x = roi->x;                                                                 \n"
"  y = roi->y;                                                                 \n"
"  width = roi->width;                                                         \n"
"  height = roi->height;                                                       \n"
"                                                                              \n"
"  lens_get_source_coord (x,         y,          &x1, &y1, &mag, &lens);       \n"
"  lens_get_source_coord (x + width, y,          &x2, &y2, &mag, &lens);       \n"
"  lens_get_source_coord (x,         y + height, &x3, &y3, &mag, &lens);       \n"
"  lens_get_source_coord (x + width, y + height, &x4, &y4, &mag, &lens);       \n"
"                                                                              \n"
"  /* This is ugly, and happens                                                \n"
"   * with a crazy set of parameters */                                        \n"
"  reorder (&x1, &x2);                                                         \n"
"  reorder (&x3, &x4);                                                         \n"
"                                                                              \n"
"  reorder (&y1, &y3);                                                         \n"
"  reorder (&y2, &y4);                                                         \n"
"                                                                              \n"
"  if (lens.centre_y > y && lens.centre_y < y + height)                        \n"
"    {                                                                         \n"
"      gdouble x5, y5, x6, y6;                                                 \n"
"                                                                              \n"
"      lens_get_source_coord (x,         lens.centre_y, &x5, &y5, &mag, &lens);\n"
"      lens_get_source_coord (x + width, lens.centre_y, &x6, &y6, &mag, &lens);\n"
"                                                                              \n"
"      reorder (&x5, &x6);                                                     \n"
"                                                                              \n"
"      area.x = floor (MIN3 (x1, x3, x5)) - 1;                                 \n"
"      area.width = ceil (MAX3 (x2, x4, x6)) + 3 - area.x;                     \n"
"    }                                                                         \n"
"  else                                                                        \n"
"    {                                                                         \n"
"      area.x = floor (MIN (x1, x3)) - 1;                                      \n"
"      area.width = ceil (MAX (x2, x4)) + 3 - area.x;                          \n"
"    }                                                                         \n"
"                                                                              \n"
"  if (lens.centre_x > x && lens.centre_x < x + width)                         \n"
"    {                                                                         \n"
"      gdouble x5, y5, x6, y6;                                                 \n"
"                                                                              \n"
"      lens_get_source_coord (lens.centre_x, y,          &x5, &y5, &mag, &lens);\n"
"      lens_get_source_coord (lens.centre_x, y + height, &x6, &y6, &mag, &lens);\n"
"                                                                              \n"
"      reorder (&y5, &y6);                                                     \n"
"                                                                              \n"
"      area.y = floor (MIN3 (y1, y2, y5)) - 1;                                 \n"
"      area.height = ceil (MAX3 (y3, y4, y6)) + 3 - area.y;                    \n"
"    }                                                                         \n"
"  else                                                                        \n"
"    {                                                                         \n"
"      area.y = floor (MIN (y1, y2)) - 1;                                      \n"
"      area.height = ceil (MAX (y3, y4)) + 3 - area.y;                         \n"
"    }                                                                         \n"
"                                                                              \n"
"  return area;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"clamp_area (GeglRectangle *area,                                              \n"
"            gdouble        center_x,                                          \n"
"            gdouble        center_y)                                          \n"
"{                                                                             \n"
"  if (center_x <= area->x || area->width < 1)                                 \n"
"    {                                                                         \n"
"      area->width = CLAMP (area->width, 1, MAX_WH);                           \n"
"    }                                                                         \n"
"  else                                                                        \n"
"    {                                                                         \n"
"      area->x += area->width - CLAMP (area->width, 1, MAX_WH);                \n"
"      area->width = CLAMP (area->width, 1, MAX_WH);                           \n"
"    }                                                                         \n"
"                                                                              \n"
"  if (center_y <= area->y || area->height < 1)                                \n"
"    {                                                                         \n"
"      area->height = CLAMP (area->height, 1, MAX_WH);                         \n"
"    }                                                                         \n"
"  else                                                                        \n"
"    {                                                                         \n"
"      area->y += area->height - CLAMP (area->height, 1, MAX_WH);              \n"
"      area->height = CLAMP (area->height, 1, MAX_WH);                         \n"
"    }                                                                         \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_required_for_output (GeglOperation       *operation,                      \n"
"                         const gchar         *input_pad,                      \n"
"                         const GeglRectangle *roi)                            \n"
"{                                                                             \n"
"  GeglRectangle *boundary;                                                    \n"
"                                                                              \n"
"  boundary = gegl_operation_source_get_bounding_box (operation, \"input\");   \n"
"                                                                              \n"
"  if (strcmp (input_pad, \"input\") || !boundary)                             \n"
"    return *GEGL_RECTANGLE (0, 0, 0, 0);                                      \n"
"                                                                              \n"
"  return get_required (boundary, roi, operation);                             \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"prepare (GeglOperation *operation)                                            \n"
"{                                                                             \n"
"  gegl_operation_set_format (operation, \"input\", babl_format (\"RGBA float\"));\n"
"  gegl_operation_set_format (operation, \"output\", babl_format (\"RGBA float\"));\n"
"}                                                                             \n"
"                                                                              \n"
"/*                                                                            \n"
" * Catmull-Rom cubic interpolation XXX: FIXME: use gegl resampler instead of  \n"
" *                                             reimplementing cubic sampler here\n"
" * equally spaced points p0, p1, p2, p3                                       \n"
" * interpolate 0 <= u < 1 between p1 and p2                                   \n"
" *                                                                            \n"
" * (1 u u^2 u^3) (  0.0  1.0  0.0  0.0 ) (p0)                                 \n"
" *               ( -0.5  0.0  0.5  0.0 ) (p1)                                 \n"
" *               (  1.0 -2.5  2.0 -0.5 ) (p2)                                 \n"
" *               ( -0.5  1.5 -1.5  0.5 ) (p3)                                 \n"
" *                                                                            \n"
" */                                                                           \n"
"                                                                              \n"
"static void                                                                   \n"
"lens_cubic_interpolate (gfloat  *src,                                         \n"
"                        gfloat  *dst,                                         \n"
"                        gdouble  dx,                                          \n"
"                        gdouble  dy,                                          \n"
"                        gdouble  brighten)                                    \n"
"{                                                                             \n"
"  gfloat um1, u, up1, up2;                                                    \n"
"  gfloat vm1, v, vp1, vp2;                                                    \n"
"  gint   c, row_stride = 16;                                                  \n"
"  gfloat verts[16];                                                           \n"
"                                                                              \n"
"  um1 = ((-0.5 * dx + 1.0) * dx - 0.5) * dx;                                  \n"
"  u = (1.5 * dx - 2.5) * dx * dx + 1.0;                                       \n"
"  up1 = ((-1.5 * dx + 2.0) * dx + 0.5) * dx;                                  \n"
"  up2 = (0.5 * dx - 0.5) * dx * dx;                                           \n"
"                                                                              \n"
"  vm1 = ((-0.5 * dy + 1.0) * dy - 0.5) * dy;                                  \n"
"  v = (1.5 * dy - 2.5) * dy * dy + 1.0;                                       \n"
"  vp1 = ((-1.5 * dy + 2.0) * dy + 0.5) * dy;                                  \n"
"  vp2 = (0.5 * dy - 0.5) * dy * dy;                                           \n"
"                                                                              \n"
"  for (c = 0; c < 4 * 4; ++c)                                                 \n"
"    {                                                                         \n"
"      verts[c] = vm1 * src[c] + v * src[c + row_stride] +                     \n"
"        vp1 * src[c + row_stride * 2] + vp2 * src[ c + row_stride * 3];       \n"
"    }                                                                         \n"
"                                                                              \n"
"  for (c = 0; c < 4; ++c)                                                     \n"
"    {                                                                         \n"
"      gfloat result;                                                          \n"
"                                                                              \n"
"      result = um1 * verts[c] + u * verts[c + 4] +                            \n"
"        up1 * verts[c + 4 * 2] + up2 * verts[c + 4 * 3];                      \n"
"                                                                              \n"
"      if (c != 3)                                                             \n"
"        result *= brighten;                                                   \n"
"                                                                              \n"
"      dst[c] = CLAMP (result, 0.0, 1.0);                                      \n"
"    }                                                                         \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"lens_distort_func (gfloat              *src_buf,                              \n"
"                   gfloat              *dst_buf,                              \n"
"                   const GeglRectangle *extended,                             \n"
"                   const GeglRectangle *result,                               \n"
"                   const GeglRectangle *boundary,                             \n"
"                   LensValues          *lens,                                 \n"
"                   gint                 xx,                                   \n"
"                   gint                 yy,                                   \n"
"                   GeglBuffer          *input,                                \n"
"                   gfloat              *background,                           \n"
"                   gint                 level)                                \n"
"{                                                                             \n"
"  gdouble sx, sy, mag;                                                        \n"
"  gdouble brighten;                                                           \n"
"  gfloat  pixel_buffer [16 * 4], temp[4];                                     \n"
"  gdouble dx, dy;                                                             \n"
"  gint    x_int, y_int, x = 0, y = 0, offset = 0;                             \n"
"                                                                              \n"
"  temp[0] = temp[1] = temp[2] = temp[3] = 0.0;                                \n"
"                                                                              \n"
"  lens_get_source_coord ((gdouble) xx, (gdouble) yy, &sx, &sy, &mag, lens);   \n"
"                                                                              \n"
"  /* pseudo gamma transformation, since the input is scRGB */                 \n"
"  brighten = pow (MAX (1.0 + mag * lens->brighten, 0.0), 2.4);                \n"
"                                                                              \n"
"  x_int = floor (sx);                                                         \n"
"  dx = sx - x_int;                                                            \n"
"                                                                              \n"
"  y_int = floor (sy);                                                         \n"
"  dy = sy - y_int;                                                            \n"
"                                                                              \n"
"  for (y = y_int - 1; y <= y_int + 2; y++)                                    \n"
"    {                                                                         \n"
"      for (x = x_int - 1; x <= x_int + 2; x++)                                \n"
"        {                                                                     \n"
"          gint b;                                                             \n"
"                                                                              \n"
"          if (x < boundary->x || x >= (boundary->x + boundary->width) ||      \n"
"              y < boundary->y || y >= (boundary->y + boundary->height))       \n"
"            {                                                                 \n"
"              for (b = 0; b < 4; b++)                                         \n"
"                pixel_buffer[offset++] = background[b];                       \n"
"            }                                                                 \n"
"          else                                                                \n"
"            {                                                                 \n"
"                                                                              \n"
"              if (x >= extended->x && x < (extended->x + extended->width) &&  \n"
"                  y >= extended->y && y < (extended->y + extended->height))   \n"
"                {                                                             \n"
"                  gint src_off;                                               \n"
"                  src_off = (y - extended->y) * extended->width * 4 +         \n"
"                    (x - extended->x) * 4;                                    \n"
"                                                                              \n"
"                  for (b = 0; b < 4; b++)                                     \n"
"                    temp[b] = src_buf[src_off++];                             \n"
"                }                                                             \n"
"              else                                                            \n"
"                {                                                             \n"
"                  gegl_buffer_sample_at_level (input, x, y, NULL, temp,       \n"
"                                      babl_format (\"RGBA float\"),           \n"
"                                      level,                                  \n"
"                                      GEGL_SAMPLER_LINEAR,                    \n"
"                                      GEGL_ABYSS_CLAMP);                      \n"
"                }                                                             \n"
"                                                                              \n"
"              for (b = 0; b < 4; b++)                                         \n"
"                pixel_buffer[offset++] = temp[b];                             \n"
"            }                                                                 \n"
"        }                                                                     \n"
"    }                                                                         \n"
"                                                                              \n"
"  lens_cubic_interpolate (pixel_buffer, temp, dx, dy, brighten);              \n"
"                                                                              \n"
"  offset = (yy - result->y) * result->width * 4 + (xx - result->x) * 4;       \n"
"                                                                              \n"
"  for (x = 0; x < 4; x++)                                                     \n"
"    dst_buf[offset++] = temp[x];                                              \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         GeglBuffer          *input,                                          \n"
"         GeglBuffer          *output,                                         \n"
"         const GeglRectangle *result,                                         \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"  LensValues      lens;                                                       \n"
"  GeglRectangle   boundary;                                                   \n"
"  gint            i, j;                                                       \n"
"  gfloat         *src_buf, *dst_buf;                                          \n"
"  gfloat          background[4];                                              \n"
"                                                                              \n"
"  boundary = *gegl_operation_source_get_bounding_box (operation, \"input\");  \n"
"  lens     =  lens_setup_calc (o, boundary);                                  \n"
"                                                                              \n"
"  src_buf = g_new0 (gfloat, SQR (MAX_WH) * 4);                                \n"
"  dst_buf = g_new0 (gfloat, SQR (CHUNK_SIZE) * 4);                            \n"
"                                                                              \n"
"  gegl_color_get_pixel (o->background, babl_format (\"RaGaBaA float\"), background);\n"
"                                                                              \n"
"  for (j = 0; (j-1) * CHUNK_SIZE < result->height; j++)                       \n"
"    for (i = 0; (i-1) * CHUNK_SIZE < result->width; i++)                      \n"
"      {                                                                       \n"
"        GeglRectangle chunked_result;                                         \n"
"        GeglRectangle area;                                                   \n"
"        gint          x, y;                                                   \n"
"                                                                              \n"
"        chunked_result = *GEGL_RECTANGLE (result->x + i * CHUNK_SIZE,         \n"
"                                          result->y + j * CHUNK_SIZE,         \n"
"                                          CHUNK_SIZE, CHUNK_SIZE);            \n"
"                                                                              \n"
"        gegl_rectangle_intersect (&chunked_result, &chunked_result, result);  \n"
"                                                                              \n"
"        if (chunked_result.width < 1  || chunked_result.height < 1)           \n"
"          continue;                                                           \n"
"                                                                              \n"
"        area = get_required (&boundary, &chunked_result, operation);          \n"
"                                                                              \n"
"        clamp_area (&area, lens.centre_x, lens.centre_y);                     \n"
"                                                                              \n"
"        gegl_buffer_get (input, &area, 1.0, babl_format (\"RaGaBaA float\"), src_buf,\n"
"                         GEGL_AUTO_ROWSTRIDE, GEGL_ABYSS_CLAMP);              \n"
"                                                                              \n"
"        for (y = chunked_result.y; y < chunked_result.y + chunked_result.height; y++)\n"
"          for (x = chunked_result.x; x < chunked_result.x + chunked_result.width; x++)\n"
"            {                                                                 \n"
"              lens_distort_func (src_buf, dst_buf, &area, &chunked_result, &boundary,\n"
"                                 &lens, x, y, input, background, level);      \n"
"            }                                                                 \n"
"                                                                              \n"
"        gegl_buffer_set (output, &chunked_result, 0, babl_format (\"RaGaBaA float\"),\n"
"                         dst_buf, GEGL_AUTO_ROWSTRIDE);                       \n"
"      }                                                                       \n"
"                                                                              \n"
"  g_free (dst_buf);                                                           \n"
"  g_free (src_buf);                                                           \n"
"                                                                              \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass       *operation_class;                                  \n"
"  GeglOperationFilterClass *filter_class;                                     \n"
"  gchar                    *composition =                                     \n"
"    \"<?xml version='1.0' encoding='UTF-8'?>\"                                \n"
"    \"<gegl>\"                                                                \n"
"    \"<node operation='gegl:lens-distortion'>\"                               \n"
"    \"  <params>\"                                                            \n"
"    \"    <param name='main'>100</param>\"                                    \n"
"    \"    <param name='zoom'>20</param>\"                                     \n"
"    \"    <param name='edge'>100</param>\"                                    \n"
"    \"    <param name='x-shift'>20</param>\"                                  \n"
"    \"    <param name='y-shift'>20</param>\"                                  \n"
"    \"  </params>\"                                                           \n"
"    \"</node>\"                                                               \n"
"    \"<node operation='gegl:load'>\"                                          \n"
"    \"  <params>\"                                                            \n"
"    \"    <param name='path'>standard-input.png</param>\"                     \n"
"    \"  </params>\"                                                           \n"
"    \"</node>\"                                                               \n"
"    \"</gegl>\";                                                              \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  filter_class    = GEGL_OPERATION_FILTER_CLASS (klass);                      \n"
"                                                                              \n"
"  operation_class->prepare                 = prepare;                         \n"
"  operation_class->get_required_for_output = get_required_for_output;         \n"
"                                                                              \n"
"  filter_class->process                    = process;                         \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\",                  \"gegl:lens-distortion\",                      \n"
"    \"title\",                 _(\"Lens Distortion\"),                        \n"
"    \"categories\",            \"distort\",                                   \n"
"    \"position-dependent\",    \"true\",                                      \n"
"    \"license\",               \"GPL3+\",                                     \n"
"    \"reference-hash\",        \"991dbbc6def3811821265049f69c23b3\",          \n"
"    \"reference-composition\", composition,                                   \n"
"    \"description\", _(\"Corrects barrel or pincushion lens distortion.\"),   \n"
"    NULL);                                                                    \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
