// Copyright (C) 2017 The Qt Company Ltd.
// SPDX-License-Identifier: LicenseRef-Qt-Commercial OR GPL-3.0-only
import QtQuick

pragma Singleton

QtObject {

    // Font Awesome by Dave Gandy - http://fontawesome.io
    // Font Awesome is licensed under SIL OFL 1.1 (http://scripts.sil.org/OFL)
    property FontLoader fontLoader: FontLoader {
        source: "FontAwesome.otf"
    }

    // Generated from copying the contents of https://fortawesome.github.io/Font-Awesome/cheatsheet/ and running it through
    // sed -E 's/([0-9].[0-9])?..fa-([a-zA-Z0-9-]+) (\(alias\) )?\[\&\#x([a-f0-9]+);\]/\2: \"\\\u\4\";/g'
    // | tr \; "\n"
    // | awk '{ r="-[a-z0-9]"; while (match($0, r)) sub(r, toupper(substr($0, RSTART + 1, 1))); print "readonly property string" $0 }'

    // Some icon names have been manually edited either because the symbol is reserved or invalid.

    // Manually edited. Was "500px"
    readonly property string i500px: "\uf26e"
    readonly property string adjust: "\uf042"
    readonly property string adn: "\uf170"
    readonly property string alignCenter: "\uf037"
    readonly property string alignJustify: "\uf039"
    readonly property string alignLeft: "\uf036"
    readonly property string alignRight: "\uf038"
    readonly property string amazon: "\uf270"
    readonly property string ambulance: "\uf0f9"
    readonly property string anchor: "\uf13d"
    readonly property string android: "\uf17b"
    readonly property string angellist: "\uf209"
    readonly property string angleDoubleDown: "\uf103"
    readonly property string angleDoubleLeft: "\uf100"
    readonly property string angleDoubleRight: "\uf101"
    readonly property string angleDoubleUp: "\uf102"
    readonly property string angleDown: "\uf107"
    readonly property string angleLeft: "\uf104"
    readonly property string angleRight: "\uf105"
    readonly property string angleUp: "\uf106"
    readonly property string apple: "\uf179"
    readonly property string archive: "\uf187"
    readonly property string areaChart: "\uf1fe"
    readonly property string arrowCircleDown: "\uf0ab"
    readonly property string arrowCircleLeft: "\uf0a8"
    readonly property string arrowCircleODown: "\uf01a"
    readonly property string arrowCircleOLeft: "\uf190"
    readonly property string arrowCircleORight: "\uf18e"
    readonly property string arrowCircleOUp: "\uf01b"
    readonly property string arrowCircleRight: "\uf0a9"
    readonly property string arrowCircleUp: "\uf0aa"
    readonly property string arrowDown: "\uf063"
    readonly property string arrowLeft: "\uf060"
    readonly property string arrowRight: "\uf061"
    readonly property string arrowUp: "\uf062"
    readonly property string arrows: "\uf047"
    readonly property string arrowsAlt: "\uf0b2"
    readonly property string arrowsH: "\uf07e"
    readonly property string arrowsV: "\uf07d"
    readonly property string asterisk: "\uf069"
    readonly property string at: "\uf1fa"
    readonly property string automobile: "\uf1b9"
    readonly property string backward: "\uf04a"
    readonly property string balanceScale: "\uf24e"
    readonly property string ban: "\uf05e"
    readonly property string bank: "\uf19c"
    readonly property string barChart: "\uf080"
    readonly property string barChartO: "\uf080"
    readonly property string barcode: "\uf02a"
    readonly property string bars: "\uf0c9"
    readonly property string battery0: "\uf244"
    readonly property string battery1: "\uf243"
    readonly property string battery2: "\uf242"
    readonly property string battery3: "\uf241"
    readonly property string battery4: "\uf240"
    readonly property string batteryEmpty: "\uf244"
    readonly property string batteryFull: "\uf240"
    readonly property string batteryHalf: "\uf242"
    readonly property string batteryQuarter: "\uf243"
    readonly property string batteryThreeQuarters: "\uf241"
    readonly property string bed: "\uf236"
    readonly property string beer: "\uf0fc"
    readonly property string behance: "\uf1b4"
    readonly property string behanceSquare: "\uf1b5"
    readonly property string bell: "\uf0f3"
    readonly property string bellO: "\uf0a2"
    readonly property string bellSlash: "\uf1f6"
    readonly property string bellSlashO: "\uf1f7"
    readonly property string bicycle: "\uf206"
    readonly property string binoculars: "\uf1e5"
    readonly property string birthdayCake: "\uf1fd"
    readonly property string bitbucket: "\uf171"
    readonly property string bitbucketSquare: "\uf172"
    readonly property string bitcoin: "\uf15a"
    readonly property string blackTie: "\uf27e"
    readonly property string bold: "\uf032"
    readonly property string bolt: "\uf0e7"
    readonly property string bomb: "\uf1e2"
    readonly property string book: "\uf02d"
    readonly property string bookmark: "\uf02e"
    readonly property string bookmarkO: "\uf097"
    readonly property string briefcase: "\uf0b1"
    readonly property string btc: "\uf15a"
    readonly property string bug: "\uf188"
    readonly property string building: "\uf1ad"
    readonly property string buildingO: "\uf0f7"
    readonly property string bullhorn: "\uf0a1"
    readonly property string bullseye: "\uf140"
    readonly property string bus: "\uf207"
    readonly property string buysellads: "\uf20d"
    readonly property string cab: "\uf1ba"
    readonly property string calculator: "\uf1ec"
    readonly property string calendar: "\uf073"
    readonly property string calendarCheckO: "\uf274"
    readonly property string calendarMinusO: "\uf272"
    readonly property string calendarO: "\uf133"
    readonly property string calendarPlusO: "\uf271"
    readonly property string calendarTimesO: "\uf273"
    readonly property string camera: "\uf030"
    readonly property string cameraRetro: "\uf083"
    readonly property string car: "\uf1b9"
    readonly property string caretDown: "\uf0d7"
    readonly property string caretLeft: "\uf0d9"
    readonly property string caretRight: "\uf0da"
    readonly property string caretSquareODown: "\uf150"
    readonly property string caretSquareOLeft: "\uf191"
    readonly property string caretSquareORight: "\uf152"
    readonly property string caretSquareOUp: "\uf151"
    readonly property string caretUp: "\uf0d8"
    readonly property string cartArrowDown: "\uf218"
    readonly property string cartPlus: "\uf217"
    readonly property string cc: "\uf20a"
    readonly property string ccAmex: "\uf1f3"
    readonly property string ccDinersClub: "\uf24c"
    readonly property string ccDiscover: "\uf1f2"
    readonly property string ccJcb: "\uf24b"
    readonly property string ccMastercard: "\uf1f1"
    readonly property string ccPaypal: "\uf1f4"
    readonly property string ccStripe: "\uf1f5"
    readonly property string ccVisa: "\uf1f0"
    readonly property string certificate: "\uf0a3"
    readonly property string chain: "\uf0c1"
    readonly property string chainBroken: "\uf127"
    readonly property string check: "\uf00c"
    readonly property string checkCircle: "\uf058"
    readonly property string checkCircleO: "\uf05d"
    readonly property string checkSquare: "\uf14a"
    readonly property string checkSquareO: "\uf046"
    readonly property string chevronCircleDown: "\uf13a"
    readonly property string chevronCircleLeft: "\uf137"
    readonly property string chevronCircleRight: "\uf138"
    readonly property string chevronCircleUp: "\uf139"
    readonly property string chevronDown: "\uf078"
    readonly property string chevronLeft: "\uf053"
    readonly property string chevronRight: "\uf054"
    readonly property string chevronUp: "\uf077"
    readonly property string child: "\uf1ae"
    readonly property string chrome: "\uf268"
    readonly property string circle: "\uf111"
    readonly property string circleO: "\uf10c"
    readonly property string circleONotch: "\uf1ce"
    readonly property string circleThin: "\uf1db"
    readonly property string clipboard: "\uf0ea"
    readonly property string clockO: "\uf017"
    readonly property string clone: "\uf24d"
    readonly property string close: "\uf00d"
    readonly property string cloud: "\uf0c2"
    readonly property string cloudDownload: "\uf0ed"
    readonly property string cloudUpload: "\uf0ee"
    readonly property string cny: "\uf157"
    readonly property string code: "\uf121"
    readonly property string codeFork: "\uf126"
    readonly property string codepen: "\uf1cb"
    readonly property string coffee: "\uf0f4"
    readonly property string cog: "\uf013"
    readonly property string cogs: "\uf085"
    readonly property string columns: "\uf0db"
    readonly property string comment: "\uf075"
    readonly property string commentO: "\uf0e5"
    readonly property string commenting: "\uf27a"
    readonly property string commentingO: "\uf27b"
    readonly property string comments: "\uf086"
    readonly property string commentsO: "\uf0e6"
    readonly property string compass: "\uf14e"
    readonly property string compress: "\uf066"
    readonly property string connectdevelop: "\uf20e"
    readonly property string contao: "\uf26d"
    readonly property string copy: "\uf0c5"
    readonly property string copyright: "\uf1f9"
    readonly property string creativeCommons: "\uf25e"
    readonly property string creditCard: "\uf09d"
    readonly property string crop: "\uf125"
    readonly property string crosshairs: "\uf05b"
    readonly property string css3: "\uf13c"
    readonly property string cube: "\uf1b2"
    readonly property string cubes: "\uf1b3"
    readonly property string cut: "\uf0c4"
    readonly property string cutlery: "\uf0f5"
    readonly property string dashboard: "\uf0e4"
    readonly property string dashcube: "\uf210"
    readonly property string database: "\uf1c0"
    readonly property string dedent: "\uf03b"
    readonly property string delicious: "\uf1a5"
    readonly property string desktop: "\uf108"
    readonly property string deviantart: "\uf1bd"
    readonly property string diamond: "\uf219"
    readonly property string digg: "\uf1a6"
    readonly property string dollar: "\uf155"
    readonly property string dotCircleO: "\uf192"
    readonly property string download: "\uf019"
    readonly property string dribbble: "\uf17d"
    readonly property string dropbox: "\uf16b"
    readonly property string drupal: "\uf1a9"
    readonly property string edit: "\uf044"
    readonly property string eject: "\uf052"
    readonly property string ellipsisH: "\uf141"
    readonly property string ellipsisV: "\uf142"
    readonly property string empire: "\uf1d1"
    readonly property string envelope: "\uf0e0"
    readonly property string envelopeO: "\uf003"
    readonly property string envelopeSquare: "\uf199"
    readonly property string eraser: "\uf12d"
    readonly property string eur: "\uf153"
    readonly property string euro: "\uf153"
    readonly property string exchange: "\uf0ec"
    readonly property string exclamation: "\uf12a"
    readonly property string exclamationCircle: "\uf06a"
    readonly property string exclamationTriangle: "\uf071"
    readonly property string expand: "\uf065"
    readonly property string expeditedssl: "\uf23e"
    readonly property string externalLink: "\uf08e"
    readonly property string externalLinkSquare: "\uf14c"
    readonly property string eye: "\uf06e"
    readonly property string eyeSlash: "\uf070"
    readonly property string eyedropper: "\uf1fb"
    readonly property string facebook: "\uf09a"
    readonly property string facebookF: "\uf09a"
    readonly property string facebookOfficial: "\uf230"
    readonly property string facebookSquare: "\uf082"
    readonly property string fastBackward: "\uf049"
    readonly property string fastForward: "\uf050"
    readonly property string fax: "\uf1ac"
    readonly property string feed: "\uf09e"
    readonly property string female: "\uf182"
    readonly property string fighterJet: "\uf0fb"
    readonly property string file: "\uf15b"
    readonly property string fileArchiveO: "\uf1c6"
    readonly property string fileAudioO: "\uf1c7"
    readonly property string fileCodeO: "\uf1c9"
    readonly property string fileExcelO: "\uf1c3"
    readonly property string fileImageO: "\uf1c5"
    readonly property string fileMovieO: "\uf1c8"
    readonly property string fileO: "\uf016"
    readonly property string filePdfO: "\uf1c1"
    readonly property string filePhotoO: "\uf1c5"
    readonly property string filePictureO: "\uf1c5"
    readonly property string filePowerpointO: "\uf1c4"
    readonly property string fileSoundO: "\uf1c7"
    readonly property string fileText: "\uf15c"
    readonly property string fileTextO: "\uf0f6"
    readonly property string fileVideoO: "\uf1c8"
    readonly property string fileWordO: "\uf1c2"
    readonly property string fileZipO: "\uf1c6"
    readonly property string filesO: "\uf0c5"
    readonly property string film: "\uf008"
    readonly property string filter: "\uf0b0"
    readonly property string fire: "\uf06d"
    readonly property string fireExtinguisher: "\uf134"
    readonly property string firefox: "\uf269"
    readonly property string flag: "\uf024"
    readonly property string flagCheckered: "\uf11e"
    readonly property string flagO: "\uf11d"
    readonly property string flash: "\uf0e7"
    readonly property string flask: "\uf0c3"
    readonly property string flickr: "\uf16e"
    readonly property string floppyO: "\uf0c7"
    readonly property string folder: "\uf07b"
    readonly property string folderO: "\uf114"
    readonly property string folderOpen: "\uf07c"
    readonly property string folderOpenO: "\uf115"
    readonly property string font: "\uf031"
    readonly property string fonticons: "\uf280"
    readonly property string forumbee: "\uf211"
    readonly property string forward: "\uf04e"
    readonly property string foursquare: "\uf180"
    readonly property string frownO: "\uf119"
    readonly property string futbolO: "\uf1e3"
    readonly property string gamepad: "\uf11b"
    readonly property string gavel: "\uf0e3"
    readonly property string gbp: "\uf154"
    readonly property string ge: "\uf1d1"
    readonly property string gear: "\uf013"
    readonly property string gears: "\uf085"
    readonly property string genderless: "\uf22d"
    readonly property string getPocket: "\uf265"
    readonly property string gg: "\uf260"
    readonly property string ggCircle: "\uf261"
    readonly property string gift: "\uf06b"
    readonly property string git: "\uf1d3"
    readonly property string gitSquare: "\uf1d2"
    readonly property string github: "\uf09b"
    readonly property string githubAlt: "\uf113"
    readonly property string githubSquare: "\uf092"
    readonly property string gittip: "\uf184"
    readonly property string glass: "\uf000"
    readonly property string globe: "\uf0ac"
    readonly property string google: "\uf1a0"
    readonly property string googlePlus: "\uf0d5"
    readonly property string googlePlusSquare: "\uf0d4"
    readonly property string googleWallet: "\uf1ee"
    readonly property string graduationCap: "\uf19d"
    readonly property string gratipay: "\uf184"
    readonly property string group: "\uf0c0"
    readonly property string hSquare: "\uf0fd"
    readonly property string hackerNews: "\uf1d4"
    readonly property string handGrabO: "\uf255"
    readonly property string handLizardO: "\uf258"
    readonly property string handODown: "\uf0a7"
    readonly property string handOLeft: "\uf0a5"
    readonly property string handORight: "\uf0a4"
    readonly property string handOUp: "\uf0a6"
    readonly property string handPaperO: "\uf256"
    readonly property string handPeaceO: "\uf25b"
    readonly property string handPointerO: "\uf25a"
    readonly property string handRockO: "\uf255"
    readonly property string handScissorsO: "\uf257"
    readonly property string handSpockO: "\uf259"
    readonly property string handStopO: "\uf256"
    readonly property string hddO: "\uf0a0"
    readonly property string header: "\uf1dc"
    readonly property string headphones: "\uf025"
    readonly property string heart: "\uf004"
    readonly property string heartO: "\uf08a"
    readonly property string heartbeat: "\uf21e"
    readonly property string history: "\uf1da"
    readonly property string home: "\uf015"
    readonly property string hospitalO: "\uf0f8"
    readonly property string hotel: "\uf236"
    readonly property string hourglass: "\uf254"
    readonly property string hourglass1: "\uf251"
    readonly property string hourglass2: "\uf252"
    readonly property string hourglass3: "\uf253"
    readonly property string hourglassEnd: "\uf253"
    readonly property string hourglassHalf: "\uf252"
    readonly property string hourglassO: "\uf250"
    readonly property string hourglassStart: "\uf251"
    readonly property string houzz: "\uf27c"
    readonly property string html5: "\uf13b"
    readonly property string iCursor: "\uf246"
    readonly property string ils: "\uf20b"
    readonly property string image: "\uf03e"
    readonly property string inbox: "\uf01c"
    readonly property string indent: "\uf03c"
    readonly property string industry: "\uf275"
    readonly property string info: "\uf129"
    readonly property string infoCircle: "\uf05a"
    readonly property string inr: "\uf156"
    readonly property string instagram: "\uf16d"
    readonly property string institution: "\uf19c"
    readonly property string internetExplorer: "\uf26b"
    readonly property string intersex: "\uf224"
    readonly property string ioxhost: "\uf208"
    readonly property string italic: "\uf033"
    readonly property string joomla: "\uf1aa"
    readonly property string jpy: "\uf157"
    readonly property string jsfiddle: "\uf1cc"
    readonly property string key: "\uf084"
    readonly property string keyboardO: "\uf11c"
    readonly property string krw: "\uf159"
    readonly property string language: "\uf1ab"
    readonly property string laptop: "\uf109"
    readonly property string lastfm: "\uf202"
    readonly property string lastfmSquare: "\uf203"
    readonly property string leaf: "\uf06c"
    readonly property string leanpub: "\uf212"
    readonly property string legal: "\uf0e3"
    readonly property string lemonO: "\uf094"
    readonly property string levelDown: "\uf149"
    readonly property string levelUp: "\uf148"
    readonly property string lifeBouy: "\uf1cd"
    readonly property string lifeBuoy: "\uf1cd"
    readonly property string lifeRing: "\uf1cd"
    readonly property string lifeSaver: "\uf1cd"
    readonly property string lightbulbO: "\uf0eb"
    readonly property string lineChart: "\uf201"
    readonly property string link: "\uf0c1"
    readonly property string linkedin: "\uf0e1"
    readonly property string linkedinSquare: "\uf08c"
    readonly property string linux: "\uf17c"
    readonly property string list: "\uf03a"
    readonly property string listAlt: "\uf022"
    readonly property string listOl: "\uf0cb"
    readonly property string listUl: "\uf0ca"
    readonly property string locationArrow: "\uf124"
    readonly property string lock: "\uf023"
    readonly property string longArrowDown: "\uf175"
    readonly property string longArrowLeft: "\uf177"
    readonly property string longArrowRight: "\uf178"
    readonly property string longArrowUp: "\uf176"
    readonly property string magic: "\uf0d0"
    readonly property string magnet: "\uf076"
    readonly property string mailForward: "\uf064"
    readonly property string mailReply: "\uf112"
    readonly property string mailReplyAll: "\uf122"
    readonly property string male: "\uf183"
    readonly property string map: "\uf279"
    readonly property string mapMarker: "\uf041"
    readonly property string mapO: "\uf278"
    readonly property string mapPin: "\uf276"
    readonly property string mapSigns: "\uf277"
    readonly property string mars: "\uf222"
    readonly property string marsDouble: "\uf227"
    readonly property string marsStroke: "\uf229"
    readonly property string marsStrokeH: "\uf22b"
    readonly property string marsStrokeV: "\uf22a"
    readonly property string maxcdn: "\uf136"
    readonly property string meanpath: "\uf20c"
    readonly property string medium: "\uf23a"
    readonly property string medkit: "\uf0fa"
    readonly property string mehO: "\uf11a"
    readonly property string mercury: "\uf223"
    readonly property string microphone: "\uf130"
    readonly property string microphoneSlash: "\uf131"
    readonly property string minus: "\uf068"
    readonly property string minusCircle: "\uf056"
    readonly property string minusSquare: "\uf146"
    readonly property string minusSquareO: "\uf147"
    readonly property string mobile: "\uf10b"
    readonly property string mobilePhone: "\uf10b"
    readonly property string money: "\uf0d6"
    readonly property string moonO: "\uf186"
    readonly property string mortarBoard: "\uf19d"
    readonly property string motorcycle: "\uf21c"
    readonly property string mousePointer: "\uf245"
    readonly property string music: "\uf001"
    readonly property string navicon: "\uf0c9"
    readonly property string neuter: "\uf22c"
    readonly property string newspaperO: "\uf1ea"
    readonly property string objectGroup: "\uf247"
    readonly property string objectUngroup: "\uf248"
    readonly property string odnoklassniki: "\uf263"
    readonly property string odnoklassnikiSquare: "\uf264"
    readonly property string opencart: "\uf23d"
    readonly property string openid: "\uf19b"
    readonly property string opera: "\uf26a"
    readonly property string optinMonster: "\uf23c"
    readonly property string outdent: "\uf03b"
    readonly property string pagelines: "\uf18c"
    readonly property string paintBrush: "\uf1fc"
    readonly property string paperPlane: "\uf1d8"
    readonly property string paperPlaneO: "\uf1d9"
    readonly property string paperclip: "\uf0c6"
    readonly property string paragraph: "\uf1dd"
    readonly property string paste: "\uf0ea"
    readonly property string pause: "\uf04c"
    readonly property string paw: "\uf1b0"
    readonly property string paypal: "\uf1ed"
    readonly property string pencil: "\uf040"
    readonly property string pencilSquare: "\uf14b"
    readonly property string pencilSquareO: "\uf044"
    readonly property string phone: "\uf095"
    readonly property string phoneSquare: "\uf098"
    readonly property string photo: "\uf03e"
    readonly property string pictureO: "\uf03e"
    readonly property string pieChart: "\uf200"
    readonly property string piedPiper: "\uf1a7"
    readonly property string piedPiperAlt: "\uf1a8"
    readonly property string pinterest: "\uf0d2"
    readonly property string pinterestP: "\uf231"
    readonly property string pinterestSquare: "\uf0d3"
    readonly property string plane: "\uf072"
    readonly property string play: "\uf04b"
    readonly property string playCircle: "\uf144"
    readonly property string playCircleO: "\uf01d"
    readonly property string plug: "\uf1e6"
    readonly property string plus: "\uf067"
    readonly property string plusCircle: "\uf055"
    readonly property string plusSquare: "\uf0fe"
    readonly property string plusSquareO: "\uf196"
    readonly property string powerOff: "\uf011"
    // Manually edited. Was "print"
    readonly property string printer: "\uf02f"
    readonly property string puzzlePiece: "\uf12e"
    readonly property string qq: "\uf1d6"
    readonly property string qrcode: "\uf029"
    readonly property string question: "\uf128"
    readonly property string questionCircle: "\uf059"
    readonly property string quoteLeft: "\uf10d"
    readonly property string quoteRight: "\uf10e"
    readonly property string ra: "\uf1d0"
    readonly property string random: "\uf074"
    readonly property string rebel: "\uf1d0"
    readonly property string recycle: "\uf1b8"
    readonly property string reddit: "\uf1a1"
    readonly property string redditSquare: "\uf1a2"
    readonly property string refresh: "\uf021"
    readonly property string registered: "\uf25d"
    readonly property string remove: "\uf00d"
    readonly property string renren: "\uf18b"
    readonly property string reorder: "\uf0c9"
    readonly property string repeat: "\uf01e"
    readonly property string reply: "\uf112"
    readonly property string replyAll: "\uf122"
    readonly property string retweet: "\uf079"
    readonly property string rmb: "\uf157"
    readonly property string road: "\uf018"
    readonly property string rocket: "\uf135"
    readonly property string rotateLeft: "\uf0e2"
    readonly property string rotateRight: "\uf01e"
    readonly property string rouble: "\uf158"
    readonly property string rss: "\uf09e"
    readonly property string rssSquare: "\uf143"
    readonly property string rub: "\uf158"
    readonly property string ruble: "\uf158"
    readonly property string rupee: "\uf156"
    readonly property string safari: "\uf267"
    readonly property string save: "\uf0c7"
    readonly property string scissors: "\uf0c4"
    readonly property string search: "\uf002"
    readonly property string searchMinus: "\uf010"
    readonly property string searchPlus: "\uf00e"
    readonly property string sellsy: "\uf213"
    readonly property string send: "\uf1d8"
    readonly property string sendO: "\uf1d9"
    readonly property string server: "\uf233"
    readonly property string share: "\uf064"
    readonly property string shareAlt: "\uf1e0"
    readonly property string shareAltSquare: "\uf1e1"
    readonly property string shareSquare: "\uf14d"
    readonly property string shareSquareO: "\uf045"
    readonly property string shekel: "\uf20b"
    readonly property string sheqel: "\uf20b"
    readonly property string shield: "\uf132"
    readonly property string ship: "\uf21a"
    readonly property string shirtsinbulk: "\uf214"
    readonly property string shoppingCart: "\uf07a"
    readonly property string signIn: "\uf090"
    readonly property string signOut: "\uf08b"
    readonly property string signal: "\uf012"
    readonly property string simplybuilt: "\uf215"
    readonly property string sitemap: "\uf0e8"
    readonly property string skyatlas: "\uf216"
    readonly property string skype: "\uf17e"
    readonly property string slack: "\uf198"
    readonly property string sliders: "\uf1de"
    readonly property string slideshare: "\uf1e7"
    readonly property string smileO: "\uf118"
    readonly property string soccerBallO: "\uf1e3"
    readonly property string sort: "\uf0dc"
    readonly property string sortAlphaAsc: "\uf15d"
    readonly property string sortAlphaDesc: "\uf15e"
    readonly property string sortAmountAsc: "\uf160"
    readonly property string sortAmountDesc: "\uf161"
    readonly property string sortAsc: "\uf0de"
    readonly property string sortDesc: "\uf0dd"
    readonly property string sortDown: "\uf0dd"
    readonly property string sortNumericAsc: "\uf162"
    readonly property string sortNumericDesc: "\uf163"
    readonly property string sortUp: "\uf0de"
    readonly property string soundcloud: "\uf1be"
    readonly property string spaceShuttle: "\uf197"
    readonly property string spinner: "\uf110"
    readonly property string spoon: "\uf1b1"
    readonly property string spotify: "\uf1bc"
    readonly property string square: "\uf0c8"
    readonly property string squareO: "\uf096"
    readonly property string stackExchange: "\uf18d"
    readonly property string stackOverflow: "\uf16c"
    readonly property string star: "\uf005"
    readonly property string starHalf: "\uf089"
    readonly property string starHalfEmpty: "\uf123"
    readonly property string starHalfFull: "\uf123"
    readonly property string starHalfO: "\uf123"
    readonly property string starO: "\uf006"
    readonly property string steam: "\uf1b6"
    readonly property string steamSquare: "\uf1b7"
    readonly property string stepBackward: "\uf048"
    readonly property string stepForward: "\uf051"
    readonly property string stethoscope: "\uf0f1"
    readonly property string stickyNote: "\uf249"
    readonly property string stickyNoteO: "\uf24a"
    readonly property string stop: "\uf04d"
    readonly property string streetView: "\uf21d"
    readonly property string strikethrough: "\uf0cc"
    readonly property string stumbleupon: "\uf1a4"
    readonly property string stumbleuponCircle: "\uf1a3"
    readonly property string subscript: "\uf12c"
    readonly property string subway: "\uf239"
    readonly property string suitcase: "\uf0f2"
    readonly property string sunO: "\uf185"
    readonly property string superscript: "\uf12b"
    readonly property string support: "\uf1cd"
    readonly property string table: "\uf0ce"
    readonly property string tablet: "\uf10a"
    readonly property string tachometer: "\uf0e4"
    readonly property string tag: "\uf02b"
    readonly property string tags: "\uf02c"
    readonly property string tasks: "\uf0ae"
    readonly property string taxi: "\uf1ba"
    readonly property string television: "\uf26c"
    readonly property string tencentWeibo: "\uf1d5"
    readonly property string terminal: "\uf120"
    readonly property string textHeight: "\uf034"
    readonly property string textWidth: "\uf035"
    readonly property string th: "\uf00a"
    readonly property string thLarge: "\uf009"
    readonly property string thList: "\uf00b"
    readonly property string thumbTack: "\uf08d"
    readonly property string thumbsDown: "\uf165"
    readonly property string thumbsODown: "\uf088"
    readonly property string thumbsOUp: "\uf087"
    readonly property string thumbsUp: "\uf164"
    readonly property string ticket: "\uf145"
    readonly property string times: "\uf00d"
    readonly property string timesCircle: "\uf057"
    readonly property string timesCircleO: "\uf05c"
    readonly property string tint: "\uf043"
    readonly property string toggleDown: "\uf150"
    readonly property string toggleLeft: "\uf191"
    readonly property string toggleOff: "\uf204"
    readonly property string toggleOn: "\uf205"
    readonly property string toggleRight: "\uf152"
    readonly property string toggleUp: "\uf151"
    readonly property string trademark: "\uf25c"
    readonly property string train: "\uf238"
    readonly property string transgender: "\uf224"
    readonly property string transgenderAlt: "\uf225"
    readonly property string trash: "\uf1f8"
    readonly property string trashO: "\uf014"
    readonly property string tree: "\uf1bb"
    readonly property string trello: "\uf181"
    readonly property string tripadvisor: "\uf262"
    readonly property string trophy: "\uf091"
    readonly property string truck: "\uf0d1"
    // Reserved word. Use turkishLira
    // readonly property string try: "\uf195"
    readonly property string tty: "\uf1e4"
    readonly property string tumblr: "\uf173"
    readonly property string tumblrSquare: "\uf174"
    readonly property string turkishLira: "\uf195"
    readonly property string tv: "\uf26c"
    readonly property string twitch: "\uf1e8"
    readonly property string twitter: "\uf099"
    readonly property string twitterSquare: "\uf081"
    readonly property string umbrella: "\uf0e9"
    readonly property string underline: "\uf0cd"
    readonly property string undo: "\uf0e2"
    readonly property string university: "\uf19c"
    readonly property string unlink: "\uf127"
    readonly property string unlock: "\uf09c"
    readonly property string unlockAlt: "\uf13e"
    readonly property string unsorted: "\uf0dc"
    readonly property string upload: "\uf093"
    readonly property string usd: "\uf155"
    readonly property string user: "\uf007"
    readonly property string userMd: "\uf0f0"
    readonly property string userPlus: "\uf234"
    readonly property string userSecret: "\uf21b"
    readonly property string userTimes: "\uf235"
    readonly property string users: "\uf0c0"
    readonly property string venus: "\uf221"
    readonly property string venusDouble: "\uf226"
    readonly property string venusMars: "\uf228"
    readonly property string viacoin: "\uf237"
    readonly property string videoCamera: "\uf03d"
    readonly property string vimeo: "\uf27d"
    readonly property string vimeoSquare: "\uf194"
    readonly property string vine: "\uf1ca"
    readonly property string vk: "\uf189"
    readonly property string volumeDown: "\uf027"
    readonly property string volumeOff: "\uf026"
    readonly property string volumeUp: "\uf028"
    readonly property string warning: "\uf071"
    readonly property string wechat: "\uf1d7"
    readonly property string weibo: "\uf18a"
    readonly property string weixin: "\uf1d7"
    readonly property string whatsapp: "\uf232"
    readonly property string wheelchair: "\uf193"
    readonly property string wifi: "\uf1eb"
    readonly property string wikipediaW: "\uf266"
    readonly property string windows: "\uf17a"
    readonly property string won: "\uf159"
    readonly property string wordpress: "\uf19a"
    readonly property string wrench: "\uf0ad"
    readonly property string xing: "\uf168"
    readonly property string xingSquare: "\uf169"
    readonly property string yCombinator: "\uf23b"
    readonly property string yCombinatorSquare: "\uf1d4"
    readonly property string yahoo: "\uf19e"
    readonly property string yc: "\uf23b"
    readonly property string ycSquare: "\uf1d4"
    readonly property string yelp: "\uf1e9"
    readonly property string yen: "\uf157"
    readonly property string youtube: "\uf167"
    readonly property string youtubePlay: "\uf16a"
    readonly property string youtubeSquare: "\uf166"
}
